/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.io;

import dotty.tools.io.Directory;
import dotty.tools.io.File;
import dotty.tools.io.File$;
import dotty.tools.io.Jar$;
import dotty.tools.io.Jar$WManifest$;
import dotty.tools.io.JarWriter;
import dotty.tools.io.Path;
import java.io.InputStream;
import java.io.Serializable;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import scala.Console$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Map;
import scala.io.Codec$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.util.Properties$;

public class Jar {
    public static final long OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(Jar.class.getDeclaredField("manifest$lzy1"));
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(Jar.class.getDeclaredField("jarFile$lzy1"));
    private final File file;
    private volatile Object jarFile$lzy1;
    private volatile Object manifest$lzy1;

    public static WManifest WManifest(Manifest manifest) {
        return Jar$.MODULE$.WManifest(manifest);
    }

    public static void create(File file, Directory directory, String string) {
        Jar$.MODULE$.create(file, directory, string);
    }

    public static boolean isJarOrZip(Path path) {
        return Jar$.MODULE$.isJarOrZip(path);
    }

    public static boolean isJarOrZip(Path path, boolean bl) {
        return Jar$.MODULE$.isJarOrZip(path, bl);
    }

    public Jar(File file) {
        this.file = file;
    }

    public Jar(java.io.File jfile) {
        this(File$.MODULE$.apply(jfile.toPath(), Codec$.MODULE$.fallbackSystemCodec()));
    }

    public Jar(String path) {
        this(File$.MODULE$.apply(path, Codec$.MODULE$.fallbackSystemCodec()));
    }

    public void errorFn(String msg) {
        Console$.MODULE$.println((Object)msg);
    }

    public JarFile jarFile() {
        Object object = this.jarFile$lzy1;
        if (object instanceof JarFile) {
            return (JarFile)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (JarFile)this.jarFile$lzyINIT1();
    }

    private Object jarFile$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.jarFile$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    JarFile jarFile = null;
                    try {
                        jarFile = new JarFile(this.file.jpath().toFile());
                        object2 = jarFile == null ? LazyVals.NullValue$.MODULE$ : jarFile;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.jarFile$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return jarFile;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Option<Manifest> manifest() {
        Object object = this.manifest$lzy1;
        if (object instanceof Option) {
            return (Option)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Option)this.manifest$lzyINIT1();
    }

    private Object manifest$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.manifest$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Option option = null;
                    try {
                        option = (Option)this.withJarInput((Function1 & Serializable)s -> Option$.MODULE$.apply((Object)s.getManifest()));
                        object2 = option == null ? LazyVals.NullValue$.MODULE$ : option;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.manifest$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return option;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Option<String> mainClass() {
        return this.manifest().map((Function1 & Serializable)_$1 -> Jar$.MODULE$.WManifest((Manifest)_$1).apply(Attributes.Name.MAIN_CLASS));
    }

    public Option<String> classPathString() {
        return this.manifest().flatMap((Function1 & Serializable)m -> Jar$.MODULE$.WManifest((Manifest)m).attrs().get((Object)Attributes.Name.CLASS_PATH).withFilter((Function1 & Serializable)cp -> !cp.trim().isEmpty()).map((Function1 & Serializable)cp -> cp));
    }

    public List<String> classPathElements() {
        Option<String> option = this.classPathString();
        if (option instanceof Some) {
            Some some = (Some)option;
            String s = (String)some.value();
            return Predef$.MODULE$.wrapRefArray((Object[])s.split("\\s+")).toList();
        }
        return package$.MODULE$.Nil();
    }

    public <T> T withJarInput(Function1<JarInputStream, T> f) {
        Object object;
        try (JarInputStream in = new JarInputStream(this.file.inputStream());){
            object = f.apply((Object)in);
        }
        return (T)object;
    }

    public JarWriter jarWriter(Seq<Tuple2<Attributes.Name, String>> mainAttrs) {
        return new JarWriter(this.file, Jar$WManifest$.MODULE$.apply(mainAttrs).underlying());
    }

    public List<JarEntry> toList() {
        return (List)this.withJarInput((Function1 & Serializable)in -> package$.MODULE$.Iterator().continually(() -> Jar.toList$$anonfun$1$$anonfun$1(in)).takeWhile((Function1 & Serializable)_$2 -> _$2 != null).toList());
    }

    public InputStream getEntryStream(JarEntry entry) {
        InputStream inputStream = this.jarFile().getInputStream(entry);
        if (inputStream == null) {
            this.errorFn(new StringBuilder(15).append("No such entry: ").append(entry).toString());
            return null;
        }
        InputStream x = inputStream;
        return x;
    }

    public String toString() {
        return String.valueOf(this.file);
    }

    private static final JarEntry toList$$anonfun$1$$anonfun$1(JarInputStream in$1) {
        return in$1.getNextJarEntry();
    }

    public static class WManifest {
        private final Manifest manifest;

        public WManifest(Manifest manifest) {
            this.manifest = manifest;
            this.initialMainAttrs().withFilter((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    Attributes.Name k = (Attributes.Name)tuple2._1();
                    String v = (String)tuple2._2();
                    return true;
                }
                return false;
            }).foreach((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    Attributes.Name k = (Attributes.Name)tuple2._1();
                    String v = (String)tuple2._2();
                    return this.update(k, v);
                }
                throw new MatchError((Object)tuple2);
            });
        }

        public Manifest manifest() {
            return this.manifest;
        }

        public Manifest underlying() {
            return this.manifest();
        }

        public Map<Attributes.Name, String> attrs() {
            return CollectionConverters$.MODULE$.MapHasAsScala((java.util.Map)this.manifest().getMainAttributes()).asScala().withDefaultValue(null);
        }

        public scala.collection.immutable.Map<Attributes.Name, String> initialMainAttrs() {
            Object[] objectArray = new Tuple2[2];
            Attributes.Name name = (Attributes.Name)Predef$.MODULE$.ArrowAssoc((Object)Attributes.Name.MANIFEST_VERSION);
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)name, (Object)"1.0");
            Attributes.Name name2 = (Attributes.Name)Predef$.MODULE$.ArrowAssoc((Object)Properties$.MODULE$.ScalaCompilerVersion());
            objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)name2, (Object)Properties$.MODULE$.versionNumberString());
            return (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        }

        public String apply(Attributes.Name name) {
            return (String)this.attrs().apply((Object)name);
        }

        public String apply(String name) {
            return this.apply(new Attributes.Name(name));
        }

        public Option<String> update(Attributes.Name key, String value) {
            return this.attrs().put((Object)key, (Object)value);
        }

        public Option<String> update(String key, String value) {
            return this.attrs().put((Object)new Attributes.Name(key), (Object)value);
        }

        public String mainClass() {
            return this.apply(Attributes.Name.MAIN_CLASS);
        }

        public Option<String> mainClass_$eq(String value) {
            return this.update(Attributes.Name.MAIN_CLASS, value);
        }
    }
}

