/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.provider.runner;

import javax.annotation.Nullable;
import org.gradle.internal.buildtree.BuildActionRunner;
import org.gradle.internal.buildtree.BuildTreeLifecycleController;
import org.gradle.internal.invocation.BuildAction;
import org.gradle.tooling.internal.protocol.PhasedActionResult;
import org.gradle.tooling.internal.provider.action.ClientProvidedBuildAction;
import org.gradle.tooling.internal.provider.runner.AbstractClientProvidedBuildActionRunner;
import org.gradle.tooling.internal.provider.runner.BuildControllerFactory;
import org.gradle.tooling.internal.provider.serialization.PayloadSerializer;
import org.gradle.tooling.internal.provider.serialization.SerializedPayload;

public class ClientProvidedBuildActionRunner
extends AbstractClientProvidedBuildActionRunner
implements BuildActionRunner {
    private final PayloadSerializer payloadSerializer;

    public ClientProvidedBuildActionRunner(BuildControllerFactory buildControllerFactory, PayloadSerializer payloadSerializer) {
        super(buildControllerFactory, payloadSerializer);
        this.payloadSerializer = payloadSerializer;
    }

    public BuildActionRunner.Result run(BuildAction action, BuildTreeLifecycleController buildController) {
        if (!(action instanceof ClientProvidedBuildAction)) {
            return BuildActionRunner.Result.nothing();
        }
        ClientProvidedBuildAction clientProvidedBuildAction = (ClientProvidedBuildAction)action;
        Object clientAction = this.payloadSerializer.deserialize(clientProvidedBuildAction.getAction());
        return this.runClientAction(new ClientActionImpl(clientAction, action), buildController);
    }

    private static class ClientActionImpl
    implements AbstractClientProvidedBuildActionRunner.ClientAction {
        private final Object clientAction;
        private final BuildAction action;
        private SerializedPayload result;

        public ClientActionImpl(Object clientAction, BuildAction action) {
            this.clientAction = clientAction;
            this.action = action;
        }

        @Override
        public Object getProjectsEvaluatedAction() {
            return null;
        }

        @Override
        public Object getBuildFinishedAction() {
            return this.clientAction;
        }

        @Override
        public void collectActionResult(SerializedPayload serializedResult, PhasedActionResult.Phase phase) {
            this.result = serializedResult;
        }

        @Override
        @Nullable
        public SerializedPayload getResult() {
            return this.result;
        }

        @Override
        public boolean isRunTasks() {
            return this.action.isRunTasks();
        }
    }
}

