/*
 * Decompiled with CFR 0.152.
 */
package kawa.lang;

import gnu.expr.Compilation;
import gnu.expr.Language;
import gnu.mapping.InPort;
import gnu.mapping.WrappedException;
import gnu.text.SourceMessages;
import gnu.text.SyntaxException;
import java.io.FileNotFoundException;
import java.io.IOException;

public class CompileFile {
    public static final Compilation read(String string, SourceMessages sourceMessages) throws IOException, SyntaxException {
        try {
            InPort inPort = InPort.openFile(string);
            Compilation compilation = CompileFile.read(inPort, sourceMessages);
            inPort.close();
            return compilation;
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new WrappedException("compile-file: file not found: " + string, fileNotFoundException);
        }
        catch (IOException iOException) {
            throw new WrappedException("compile-file: read-error: " + string, iOException);
        }
    }

    public static final Compilation read(InPort inPort, SourceMessages sourceMessages) throws IOException, SyntaxException {
        return Language.getDefaultLanguage().parse(inPort, sourceMessages, 0);
    }
}

