/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml;

import gnu.mapping.Symbol;
import gnu.xml.NamespaceBinding;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class XName
extends Symbol
implements Externalizable {
    NamespaceBinding namespaceNodes;

    public XName() {
    }

    public XName(Symbol symbol, NamespaceBinding namespaceBinding) {
        super(symbol.getNamespace(), symbol.getName());
        this.namespaceNodes = namespaceBinding;
    }

    public final NamespaceBinding getNamespaceNodes() {
        return this.namespaceNodes;
    }

    public final void setNamespaceNodes(NamespaceBinding namespaceBinding) {
        this.namespaceNodes = namespaceBinding;
    }

    String lookupNamespaceURI(String string) {
        NamespaceBinding namespaceBinding = this.namespaceNodes;
        while (namespaceBinding != null) {
            if (string == namespaceBinding.prefix) {
                return namespaceBinding.uri;
            }
            namespaceBinding = namespaceBinding.next;
        }
        return null;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        objectOutput.writeObject(this.namespaceNodes);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        this.namespaceNodes = (NamespaceBinding)objectInput.readObject();
    }

    public static boolean isNameStart(int n) {
        return Character.isUnicodeIdentifierStart(n) || n == 95;
    }

    public static boolean isNamePart(int n) {
        return Character.isUnicodeIdentifierPart(n) || n == 45 || n == 46;
    }

    public static boolean isNmToken(String string) {
        return XName.checkName(string) >= 0;
    }

    public static boolean isName(String string) {
        return XName.checkName(string) > 0;
    }

    public static boolean isNCName(String string) {
        return XName.checkName(string) > 1;
    }

    public static int checkName(String string) {
        int n = string.length();
        if (n == 0) {
            return -1;
        }
        int n2 = 2;
        int n3 = 0;
        while (n3 < n) {
            int n4;
            boolean bl = n3 == 0;
            if ((n4 = string.charAt(n3++)) >= 55296 && n4 < 56320 && n3 < n) {
                n4 = (n4 - 55296) * 1024 + (string.charAt(n3++) - 56320) + 65536;
            }
            if (n4 == 58) {
                if (n2 != 2) continue;
                n2 = 1;
                continue;
            }
            if (!XName.isNamePart(n4)) {
                return -1;
            }
            if (!bl || XName.isNameStart(n4)) continue;
            n2 = 0;
        }
        return n2;
    }
}

