/*
 * Decompiled with CFR 0.152.
 */
package gnu.lists;

import gnu.lists.Consumer;
import gnu.lists.GapVector;
import gnu.lists.SimpleVector;

public class StableVector
extends GapVector {
    protected int[] positions;
    protected int free;
    protected static final int FREE_POSITION = -2;
    static final int START_POSITION = 0;
    static final int END_POSITION = 1;

    protected void chainFreelist() {
        this.free = -1;
        int n = this.positions.length;
        while (--n > 1) {
            int n2 = this.positions[n];
            if (n2 != -2) continue;
            this.positions[n] = this.free;
            this.free = n;
        }
    }

    protected void unchainFreelist() {
        int n = this.free;
        while (n >= 0) {
            int n2 = this.positions[n];
            this.positions[n] = -2;
            n = n2;
        }
        this.free = -2;
    }

    public int startPos() {
        return 0;
    }

    public int endPos() {
        return 1;
    }

    public StableVector(SimpleVector simpleVector) {
        super(simpleVector);
        this.positions = new int[16];
        this.positions[0] = 0;
        this.positions[1] = simpleVector.getBufferLength() << 1 | 1;
        this.free = -1;
        int n = this.positions.length;
        while (--n >= 2) {
            this.positions[n] = this.free;
            this.free = n;
        }
    }

    protected StableVector() {
    }

    protected int allocPositionIndex() {
        int n;
        if (this.free == -2) {
            this.chainFreelist();
        }
        if (this.free < 0) {
            n = this.positions.length;
            int[] nArray = new int[2 * n];
            System.arraycopy(this.positions, 0, nArray, 0, n);
            int n2 = 2 * n;
            while (--n2 >= n) {
                nArray[n2] = this.free;
                this.free = n2;
            }
            this.positions = nArray;
        }
        n = this.free;
        this.free = this.positions[this.free];
        return n;
    }

    public int createPos(int n, boolean bl) {
        if (n == 0 && !bl) {
            return 0;
        }
        if (bl && n == this.size()) {
            return 1;
        }
        if (n > this.gapStart || n == this.gapStart && bl) {
            n += this.gapEnd - this.gapStart;
        }
        int n2 = this.allocPositionIndex();
        this.positions[n2] = n << 1 | (bl ? 1 : 0);
        return n2;
    }

    protected boolean isAfterPos(int n) {
        return (this.positions[n] & 1) != 0;
    }

    public boolean hasNext(int n) {
        int n2 = this.positions[n];
        int n3 = n2 >>> 1;
        if (n3 >= this.gapStart) {
            n3 += this.gapEnd - this.gapStart;
        }
        return n3 < this.base.getBufferLength();
    }

    public int nextPos(int n) {
        int n2 = this.positions[n];
        int n3 = n2 >>> 1;
        if (n3 >= this.gapStart) {
            n3 += this.gapEnd - this.gapStart;
        }
        if (n3 >= this.base.getBufferLength()) {
            this.releasePos(n);
            return 0;
        }
        if (n == 0) {
            n = this.createPos(0, true);
        }
        this.positions[n] = n2 | 1;
        return n;
    }

    public int nextIndex(int n) {
        int n2 = this.positions[n] >>> 1;
        if (n2 > this.gapStart) {
            n2 -= this.gapEnd - this.gapStart;
        }
        return n2;
    }

    public void releasePos(int n) {
        if (n >= 2) {
            if (this.free == -2) {
                this.chainFreelist();
            }
            this.positions[n] = this.free;
            this.free = n;
        }
    }

    public int copyPos(int n) {
        if (n > 1) {
            int n2 = this.allocPositionIndex();
            this.positions[n2] = this.positions[n];
            n = n2;
        }
        return n;
    }

    public void fillPosRange(int n, int n2, Object object2) {
        this.fillPosRange(this.positions[n], this.positions[n2], object2);
    }

    protected void shiftGap(int n) {
        int n2;
        int n3;
        int n4;
        int n5 = this.gapStart;
        int n6 = n - n5;
        if (n6 > 0) {
            n4 = this.gapEnd;
            n3 = n4 + n6;
            n2 = n5 - n4 << 1;
            n4 <<= 1;
            n3 = (n3 << 1) - 1;
        } else {
            if (n == n5) {
                return;
            }
            n4 = (n << 1) + 1;
            n3 = n5 << 1;
            n2 = this.gapEnd - n5 << 1;
        }
        super.shiftGap(n);
        this.adjustPositions(n4, n3, n2);
    }

    protected void gapReserve(int n, int n2) {
        int n3 = this.gapEnd;
        int n4 = this.gapStart;
        if (n2 > n3 - n4) {
            int n5 = this.base.size;
            super.gapReserve(n, n2);
            int n6 = this.base.size;
            if (n == n4) {
                this.adjustPositions(n3 << 1, n6 << 1 | 1, n6 - n5 << 1);
            } else {
                this.adjustPositions(n3 << 1, n5 << 1 | 1, n4 - n3 << 1);
                this.adjustPositions(this.gapStart << 1, n6 << 1 | 1, this.gapEnd - this.gapStart << 1);
            }
        } else if (n != this.gapStart) {
            this.shiftGap(n);
        }
    }

    protected void adjustPositions(int n, int n2, int n3) {
        if (this.free >= 0) {
            this.unchainFreelist();
        }
        n ^= Integer.MIN_VALUE;
        n2 ^= Integer.MIN_VALUE;
        int n4 = this.positions.length;
        while (--n4 > 0) {
            int n5;
            int n6 = this.positions[n4];
            if (n6 == -2 || (n5 = n6 ^ Integer.MIN_VALUE) < n || n5 > n2) continue;
            this.positions[n4] = n6 + n3;
        }
    }

    protected int addPos(int n, Object object2) {
        int n2 = this.positions[n];
        int n3 = n2 >>> 1;
        if (n3 >= this.gapStart) {
            n3 += this.gapEnd - this.gapStart;
        }
        if ((n2 & 1) == 0) {
            if (n == 0) {
                n = this.createPos(0, true);
            } else {
                this.positions[n] = n2 | 1;
            }
        }
        this.add(n3, object2);
        return n;
    }

    protected void removePosRange(int n, int n2) {
        super.removePosRange(this.positions[n], this.positions[n2]);
        int n3 = this.gapStart;
        int n4 = this.gapEnd;
        if (this.free >= 0) {
            this.unchainFreelist();
        }
        int n5 = this.positions.length;
        while (--n5 > 0) {
            boolean bl;
            int n6 = this.positions[n5];
            if (n6 == -2) continue;
            int n7 = n6 >> 1;
            boolean bl2 = bl = (n6 & 1) != 0;
            if (bl) {
                if (n7 < n3 || n7 >= n4) continue;
                this.positions[n5] = this.gapEnd << 1 | 1;
                continue;
            }
            if (n7 <= n3 || n7 > n4) continue;
            this.positions[n5] = this.gapStart << 1;
        }
    }

    public void consumePosRange(int n, int n2, Consumer consumer) {
        super.consumePosRange(this.positions[n], this.positions[n2], consumer);
    }
}

