/*
 * Decompiled with CFR 0.152.
 */
package gnu.bytecode;

import gnu.bytecode.CodeAttr;
import gnu.bytecode.Type;

public class Label {
    int first_fixup;
    int position;
    Type[] stackTypes;
    Type[] localTypes;

    public final boolean defined() {
        return this.position >= 0;
    }

    public Label() {
        this(-1);
    }

    public Label(CodeAttr codeAttr) {
        this(-1);
    }

    public Label(int n) {
        this.position = n;
    }

    void setTypes(Type[] typeArray, int n, Type[] typeArray2, int n2) {
        Type type;
        while (n > 0 && (type = typeArray[n - 1]) == null) {
            --n;
        }
        if (this.stackTypes == null) {
            if (n2 == 0) {
                this.stackTypes = Type.typeArray0;
            } else {
                this.stackTypes = new Type[n2];
                System.arraycopy(typeArray2, 0, this.stackTypes, 0, n2);
            }
            if (n == 0) {
                this.localTypes = Type.typeArray0;
            } else {
                this.localTypes = new Type[n];
                System.arraycopy(typeArray, 0, this.localTypes, 0, n);
            }
        } else {
            int n3;
            int n4;
            int n5 = n2;
            int n6 = this.stackTypes.length;
            if (n5 != n6) {
                throw new Error("inconsistent stack len was:" + n6 + " now:" + n5 + " for " + this);
            }
            for (n4 = 0; n4 < n5; ++n4) {
                this.stackTypes[n4] = Type.lowestCommonSuperType(this.stackTypes[n4], typeArray2[n4]);
            }
            n4 = n < this.localTypes.length ? n : this.localTypes.length;
            for (n3 = 0; n3 < n4; ++n3) {
                this.localTypes[n3] = Type.lowestCommonSuperType(this.localTypes[n3], typeArray[n3]);
            }
            for (n3 = n; n3 < this.localTypes.length; ++n3) {
                this.localTypes[n3] = null;
            }
        }
    }

    public void setTypes(CodeAttr codeAttr) {
        if (this.stackTypes != null && codeAttr.SP != this.stackTypes.length) {
            throw new Error();
        }
        this.setTypes(codeAttr.local_types, codeAttr.local_types == null ? 0 : codeAttr.local_types.length, codeAttr.stack_types, codeAttr.SP);
    }

    public void setTypes(Label label) {
        this.setTypes(label.localTypes, label.localTypes.length, label.stackTypes, label.stackTypes.length);
    }

    void setTypesSame(Label label) {
        this.stackTypes = label.stackTypes;
        this.localTypes = label.localTypes;
    }

    public void defineRaw(CodeAttr codeAttr) {
        if (this.position >= 0) {
            throw new Error("label definition more than once");
        }
        this.position = codeAttr.PC;
        this.first_fixup = codeAttr.fixup_count;
        if (this.first_fixup >= 0) {
            codeAttr.fixupAdd(1, this);
        }
    }

    public void define(CodeAttr codeAttr) {
        if (codeAttr.reachableHere()) {
            this.setTypes(codeAttr);
        }
        if (this.localTypes != null) {
            codeAttr.setTypes(this);
        }
        codeAttr.setReachable(true);
        this.defineRaw(codeAttr);
    }
}

