/*
 * Decompiled with CFR 0.152.
 */
package gnu.mapping;

import gnu.mapping.Environment;
import gnu.mapping.IndirectableLocation;
import gnu.mapping.Location;
import gnu.mapping.LocationEnumeration;
import gnu.mapping.NamedLocation;
import gnu.mapping.Namespace;
import gnu.mapping.SharedLocation;
import gnu.mapping.SimpleEnvironment;
import gnu.mapping.Symbol;

public class InheritingEnvironment
extends SimpleEnvironment {
    int numInherited;
    Environment[] inherited;
    Namespace[] namespaceMap;
    Object[] propertyMap;
    int baseTimestamp;

    public InheritingEnvironment(String string, Environment environment) {
        super(string);
        this.addParent(environment);
        if (environment instanceof SimpleEnvironment) {
            int n;
            this.baseTimestamp = n = ++((SimpleEnvironment)environment).currentTimestamp;
            this.currentTimestamp = n;
        }
    }

    public final int getNumParents() {
        return this.numInherited;
    }

    public final Environment getParent(int n) {
        return this.inherited[n];
    }

    public void addParent(Environment environment) {
        if (this.numInherited == 0) {
            this.inherited = new Environment[4];
        } else if (this.numInherited <= this.inherited.length) {
            Environment[] environmentArray = new Environment[2 * this.numInherited];
            System.arraycopy(this.inherited, 0, environmentArray, 0, this.numInherited);
            this.inherited = environmentArray;
        }
        this.inherited[this.numInherited] = environment;
        ++this.numInherited;
    }

    public NamedLocation lookupInherited(Symbol symbol, Object object2, int n) {
        for (int i = 0; i < this.numInherited; ++i) {
            Object object3;
            Object object4;
            Symbol symbol2 = symbol;
            Object object5 = object2;
            if (this.namespaceMap != null && this.namespaceMap.length > 2 * i) {
                object4 = this.namespaceMap[2 * i];
                object3 = this.namespaceMap[2 * i + 1];
                if (object4 != null || object3 != null) {
                    if (symbol.getNamespace() != object3) continue;
                    symbol2 = Symbol.make(object4, symbol.getName());
                }
            }
            if (this.propertyMap != null && this.propertyMap.length > 2 * i) {
                object4 = this.propertyMap[2 * i];
                object3 = this.propertyMap[2 * i + 1];
                if (object4 != null || object3 != null) {
                    if (object2 != object3) continue;
                    object5 = object4;
                }
            }
            if ((object4 = this.inherited[i].lookup(symbol2, object5, n)) == null || !((Location)object4).isBound() || object4 instanceof SharedLocation && ((SharedLocation)object4).timestamp >= this.baseTimestamp) continue;
            return object4;
        }
        return null;
    }

    public NamedLocation lookup(Symbol symbol, Object object2, int n) {
        NamedLocation namedLocation = super.lookup(symbol, object2, n);
        if (namedLocation != null) {
            return namedLocation;
        }
        return this.lookupInherited(symbol, object2, n);
    }

    public synchronized NamedLocation getLocation(Symbol symbol, Object object2, int n, boolean bl) {
        NamedLocation namedLocation = this.lookupDirect(symbol, object2, n);
        if (namedLocation != null) {
            return namedLocation;
        }
        namedLocation = (this.flags & 0x20) != 0 && bl ? this.inherited[0].getLocation(symbol, object2, n, true) : this.lookupInherited(symbol, object2, n);
        if (namedLocation != null) {
            if (bl) {
                NamedLocation namedLocation2 = this.addUnboundLocation(symbol, object2, n);
                if ((this.flags & 1) == 0 && namedLocation.isBound()) {
                    this.redefineError(symbol, object2, namedLocation2);
                }
                namedLocation2.base = namedLocation;
                namedLocation2.value = namedLocation.value == IndirectableLocation.INDIRECT_FLUIDS ? namedLocation.value : ((this.flags & 0x10) != 0 ? IndirectableLocation.DIRECT_ON_SET : null);
                if (namedLocation2 instanceof SharedLocation) {
                    ((SharedLocation)namedLocation2).timestamp = this.baseTimestamp;
                }
                return namedLocation2;
            }
            return namedLocation;
        }
        return bl ? this.addUnboundLocation(symbol, object2, n) : null;
    }

    public LocationEnumeration enumerateAllLocations() {
        LocationEnumeration locationEnumeration = new LocationEnumeration(this.table, 1 << this.log2Size);
        locationEnumeration.env = this;
        if (this.inherited != null && this.inherited.length > 0) {
            locationEnumeration.inherited = this.inherited[0].enumerateAllLocations();
            locationEnumeration.index = 0;
        }
        return locationEnumeration;
    }

    protected boolean hasMoreElements(LocationEnumeration locationEnumeration) {
        if (locationEnumeration.inherited != null) {
            while (true) {
                NamedLocation namedLocation = locationEnumeration.curLoc;
                while (true) {
                    locationEnumeration.inherited.curLoc = namedLocation;
                    if (!locationEnumeration.inherited.hasMoreElements()) break;
                    namedLocation = locationEnumeration.inherited.curLoc;
                    if (this.lookup(namedLocation.name, namedLocation.property) == namedLocation) {
                        locationEnumeration.curLoc = namedLocation;
                        return true;
                    }
                    namedLocation = namedLocation.next;
                }
                locationEnumeration.curLoc = locationEnumeration.inherited.curLoc;
                if (++locationEnumeration.index == this.numInherited) break;
                locationEnumeration.inherited = this.inherited[locationEnumeration.index].enumerateAllLocations();
            }
            locationEnumeration.inherited = null;
            locationEnumeration.bindings = this.table;
            locationEnumeration.index = 1 << this.log2Size;
        }
        return super.hasMoreElements(locationEnumeration);
    }

    protected void toStringBase(StringBuffer stringBuffer) {
        stringBuffer.append(" baseTs:");
        stringBuffer.append(this.baseTimestamp);
        for (int i = 0; i < this.numInherited; ++i) {
            stringBuffer.append(" base:");
            stringBuffer.append(this.inherited[i].toStringVerbose());
        }
    }
}

