/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.reflect;

import gnu.bytecode.ClassType;
import gnu.bytecode.Field;
import gnu.bytecode.Type;
import gnu.expr.Compilation;
import gnu.expr.Declaration;
import gnu.expr.ModuleExp;
import gnu.expr.ModuleInfo;
import gnu.kawa.reflect.ClassMemberLocation;
import gnu.mapping.Location;
import gnu.mapping.Procedure;
import gnu.mapping.WrappedException;
import kawa.lang.Syntax;

public class FieldLocation
extends ClassMemberLocation {
    Declaration decl;
    Object value;
    static final int SETUP_DONE = 1;
    static final int INDIRECT_LOCATION = 2;
    static final int CONSTANT = 4;
    static final int VALUE_SET = 8;
    public static final int PROCEDURE = 16;
    public static final int SYNTAX = 32;
    public static final int KIND_FLAGS_SET = 64;
    private int flags;

    public boolean isIndirectLocation() {
        return (this.flags & 2) != 0;
    }

    public void setProcedure() {
        this.flags |= 0x54;
    }

    public void setSyntax() {
        this.flags |= 0x64;
    }

    void setKindFlags() {
        String string = this.getMemberName();
        Field field = this.getDeclaringClass().getDeclaredField(string);
        int n = field.getModifiers();
        Type type = field.getType();
        if (type.isSubtype(Compilation.typeLocation)) {
            this.flags |= 2;
        }
        if ((n & 0x10) != 0) {
            if ((this.flags & 2) == 0) {
                this.flags |= 4;
                if (type.isSubtype(Compilation.typeProcedure)) {
                    this.flags |= 0x10;
                }
                if (type.isSubtype(ClassType.make("kawa.lang.Syntax"))) {
                    this.flags |= 0x20;
                }
            } else {
                Location location2 = (Location)this.getFieldValue();
                if (location2 instanceof FieldLocation) {
                    FieldLocation fieldLocation = (FieldLocation)location2;
                    if ((fieldLocation.flags & 0x40) == 0) {
                        fieldLocation.setKindFlags();
                    }
                    this.flags |= fieldLocation.flags & 0x34;
                    if ((fieldLocation.flags & 4) != 0) {
                        if ((fieldLocation.flags & 8) != 0) {
                            this.value = fieldLocation.value;
                            this.flags |= 8;
                        }
                    } else {
                        this.value = fieldLocation;
                        this.flags |= 8;
                    }
                } else if (location2.isConstant()) {
                    Object object2 = location2.get(null);
                    if (object2 instanceof Procedure) {
                        this.flags |= 0x10;
                    }
                    if (object2 instanceof Syntax) {
                        this.flags |= 0x20;
                    }
                    this.flags |= 0xC;
                    this.value = object2;
                }
            }
        }
        this.flags |= 0x40;
    }

    public boolean isProcedureOrSyntax() {
        if ((this.flags & 0x40) == 0) {
            this.setKindFlags();
        }
        return (this.flags & 0x30) != 0;
    }

    public FieldLocation(Object object2, String string, String string2) {
        super(object2, ClassType.make(string), string2);
    }

    public FieldLocation(Object object2, ClassType classType, String string) {
        super(object2, classType, string);
    }

    public void setDeclaration(Declaration declaration) {
        this.decl = declaration;
    }

    public Field getField() {
        return this.type.getDeclaredField(this.mname);
    }

    public Type getFType() {
        return this.type.getDeclaredField(this.mname).getType();
    }

    public synchronized Declaration getDeclaration() {
        Declaration declaration;
        if ((this.flags & 0x40) == 0) {
            this.setKindFlags();
        }
        if ((declaration = this.decl) == null) {
            String string = this.getMemberName();
            ClassType classType = this.getDeclaringClass();
            Field field = classType.getDeclaredField(string);
            if (field == null) {
                return null;
            }
            ModuleInfo moduleInfo = ModuleInfo.find(classType.getName());
            ModuleExp moduleExp = moduleInfo.getModuleExp();
            for (declaration = moduleExp.firstDecl(); !(declaration == null || declaration.field != null && declaration.field.getName().equals(string)); declaration = declaration.nextDecl()) {
            }
            if (declaration == null) {
                throw new RuntimeException("no field found for " + this);
            }
            this.decl = declaration;
        }
        return declaration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setup() {
        FieldLocation fieldLocation = this;
        synchronized (fieldLocation) {
            if ((this.flags & 1) != 0) {
                return;
            }
            super.setup();
            if ((this.flags & 0x40) == 0) {
                this.setKindFlags();
            }
            this.flags |= 1;
        }
    }

    public Object get(Object object2) {
        Object object3;
        try {
            this.setup();
        }
        catch (Throwable throwable) {
            return object2;
        }
        if ((this.flags & 8) != 0) {
            object3 = this.value;
            if ((this.flags & 4) != 0) {
                return object3;
            }
        } else {
            object3 = this.getFieldValue();
            if ((this.type.getDeclaredField(this.mname).getModifiers() & 0x10) != 0) {
                this.flags |= 8;
                if ((this.flags & 2) == 0) {
                    this.flags |= 4;
                }
                this.value = object3;
            }
        }
        if ((this.flags & 2) != 0) {
            Location location2 = (Location)object3;
            String string = Location.UNBOUND;
            if ((object3 = location2.get(string)) == string) {
                return object2;
            }
            if (location2.isConstant()) {
                this.flags |= 4;
                this.value = object3;
            }
        }
        return object3;
    }

    private Object getFieldValue() {
        super.setup();
        try {
            return this.rfield.get(this.instance);
        }
        catch (Throwable throwable) {
            throw WrappedException.wrapIfNeeded(throwable);
        }
    }

    public void set(Object object2) {
        this.setup();
        if ((this.flags & 2) == 0) {
            try {
                this.rfield.set(this.instance, object2);
            }
            catch (Throwable throwable) {
                throw WrappedException.wrapIfNeeded(throwable);
            }
        } else {
            Object object3;
            if ((this.flags & 8) != 0) {
                object3 = this.value;
            } else {
                this.flags |= 8;
                this.value = object3 = this.getFieldValue();
            }
            ((Location)object3).set(object2);
        }
    }

    public boolean isConstant() {
        if ((this.flags & 0x40) == 0) {
            this.setKindFlags();
        }
        if ((this.flags & 4) != 0) {
            return true;
        }
        if (this.isIndirectLocation()) {
            Object object2;
            if ((this.flags & 8) != 0) {
                object2 = this.value;
            } else {
                try {
                    this.setup();
                }
                catch (Throwable throwable) {
                    return false;
                }
                object2 = this.getFieldValue();
                this.flags |= 8;
                this.value = object2;
            }
            return ((Location)object2).isConstant();
        }
        return false;
    }

    public boolean isBound() {
        Object object2;
        if ((this.flags & 0x40) == 0) {
            this.setKindFlags();
        }
        if ((this.flags & 4) != 0 || (this.flags & 2) == 0) {
            return true;
        }
        if ((this.flags & 8) != 0) {
            object2 = this.value;
        } else {
            try {
                this.setup();
            }
            catch (Throwable throwable) {
                return false;
            }
            object2 = this.getFieldValue();
            this.flags |= 8;
            this.value = object2;
        }
        return ((Location)object2).isBound();
    }

    public static FieldLocation make(Object object2, String string, String string2) {
        return new FieldLocation(object2, ClassType.make(string), string2);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("FieldLocation[");
        if (this.instance != null) {
            stringBuffer.append(this.instance);
            stringBuffer.append(' ');
        }
        stringBuffer.append(this.type.getName());
        stringBuffer.append('.');
        stringBuffer.append(this.mname);
        stringBuffer.append(']');
        return stringBuffer.toString();
    }
}

