/*
 * Decompiled with CFR 0.152.
 */
package gnu.bytecode;

import gnu.bytecode.ClassType;
import gnu.bytecode.CodeAttr;
import gnu.bytecode.Method;
import gnu.bytecode.Type;

public class PrimType
extends Type {
    public PrimType(String string, String string2, int n, Class clazz) {
        super(string, string2);
        this.size = n;
        this.reflectClass = clazz;
        Type.registerTypeForClass(clazz, this);
    }

    protected PrimType(PrimType primType) {
        super(primType.this_name, primType.signature);
        this.size = primType.size;
        this.reflectClass = primType.reflectClass;
    }

    public Object coerceFromObject(Object object2) {
        if (object2.getClass() == this.reflectClass) {
            return object2;
        }
        int n = this.signature == null || this.signature.length() != 1 ? 32 : (int)this.signature.charAt(0);
        switch (n) {
            case 66: {
                return new Byte(((Number)object2).byteValue());
            }
            case 83: {
                return new Short(((Number)object2).shortValue());
            }
            case 73: {
                return new Integer(((Number)object2).intValue());
            }
            case 74: {
                return new Long(((Number)object2).longValue());
            }
            case 70: {
                return new Float(((Number)object2).floatValue());
            }
            case 68: {
                return new Double(((Number)object2).doubleValue());
            }
        }
        throw new ClassCastException("don't know how to coerce " + object2.getClass().getName() + " to " + this.getName());
    }

    public char charValue(Object object2) {
        return ((Character)object2).charValue();
    }

    public static boolean booleanValue(Object object2) {
        return !(object2 instanceof Boolean) || (Boolean)object2 != false;
    }

    public void emitCoerceToObject(CodeAttr codeAttr) {
        ClassType classType;
        char c = this.getSignature().charAt(0);
        String string = null;
        switch (c) {
            case 'Z': {
                classType = ClassType.make("java.lang.Boolean");
                codeAttr.emitIfIntNotZero();
                codeAttr.emitGetStatic(classType.getDeclaredField("TRUE"));
                codeAttr.emitElse();
                codeAttr.emitGetStatic(classType.getDeclaredField("FALSE"));
                codeAttr.emitFi();
                break;
            }
            case 'C': {
                string = "java.lang.Character";
                break;
            }
            case 'B': {
                string = "java.lang.Byte";
                break;
            }
            case 'S': {
                string = "java.lang.Short";
                break;
            }
            case 'I': {
                string = "java.lang.Integer";
                break;
            }
            case 'J': {
                string = "java.lang.Long";
                break;
            }
            case 'F': {
                string = "java.lang.Float";
                break;
            }
            case 'D': {
                string = "java.lang.Double";
                break;
            }
            default: {
                string = null;
            }
        }
        classType = ClassType.make(string);
        Type[] typeArray = new Type[]{this};
        Method method = classType.getDeclaredMethod("<init>", typeArray);
        codeAttr.emitNew(classType);
        codeAttr.emitDupX();
        codeAttr.emitSwap();
        codeAttr.emitInvokeSpecial(method);
    }

    public void emitCoerceFromObject(CodeAttr codeAttr) {
        int n;
        int n2 = n = this.signature == null || this.signature.length() != 1 ? 32 : (int)this.signature.charAt(0);
        if (n == 90) {
            codeAttr.emitCheckcast(Type.boolean_ctype);
            codeAttr.emitInvokeVirtual(Type.booleanValue_method);
        } else if (n == 86) {
            codeAttr.emitPop(1);
        } else {
            codeAttr.emitCheckcast(Type.number_type);
            if (n == 73 || n == 83 || n == 66) {
                codeAttr.emitInvokeVirtual(Type.intValue_method);
            } else if (n == 74) {
                codeAttr.emitInvokeVirtual(Type.longValue_method);
            } else if (n == 68) {
                codeAttr.emitInvokeVirtual(Type.doubleValue_method);
            } else if (n == 70) {
                codeAttr.emitInvokeVirtual(Type.floatValue_method);
            } else {
                super.emitCoerceFromObject(codeAttr);
            }
        }
    }

    public static int compare(PrimType primType, PrimType primType2) {
        char c;
        char c2 = primType.signature.charAt(0);
        if (c2 == (c = primType2.signature.charAt(0))) {
            return 0;
        }
        if (c2 == 'V') {
            return 1;
        }
        if (c == 'V') {
            return -1;
        }
        if (c2 == 'Z' || c == 'Z') {
            return -3;
        }
        if (c2 == 'C') {
            return primType2.size > 2 ? -1 : -3;
        }
        if (c == 'C') {
            return primType.size > 2 ? 1 : -3;
        }
        if (c2 == 'D') {
            return 1;
        }
        if (c == 'D') {
            return -1;
        }
        if (c2 == 'F') {
            return 1;
        }
        if (c == 'F') {
            return -1;
        }
        if (c2 == 'J') {
            return 1;
        }
        if (c == 'J') {
            return -1;
        }
        if (c2 == 'I') {
            return 1;
        }
        if (c == 'I') {
            return -1;
        }
        if (c2 == 'S') {
            return 1;
        }
        if (c == 'S') {
            return -1;
        }
        return -3;
    }

    public int compare(Type type) {
        if (type instanceof PrimType) {
            return PrimType.compare(this, (PrimType)type);
        }
        if (!(type instanceof ClassType)) {
            return -3;
        }
        char c = this.signature.charAt(0);
        String string = type.getName();
        switch (c) {
            case 'V': {
                return 1;
            }
            case 'D': {
                if (!string.equals("java.lang.Double") && !string.equals("gnu.math.DFloat")) break;
                return 0;
            }
            case 'I': {
                if (string.equals("java.lang.Integer")) {
                    return 0;
                }
                if (!string.equals("gnu.math.IntNum")) break;
                return -1;
            }
        }
        if (string.equals("java.lang.Object") || type == Type.tostring_type) {
            return -1;
        }
        return -2;
    }
}

