/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.bytecode.ClassType;
import gnu.bytecode.CodeAttr;
import gnu.bytecode.ExceptionsAttr;
import gnu.bytecode.Field;
import gnu.bytecode.Filter;
import gnu.bytecode.Method;
import gnu.bytecode.ObjectType;
import gnu.bytecode.PrimType;
import gnu.bytecode.Type;
import gnu.bytecode.Variable;
import gnu.expr.ApplyExp;
import gnu.expr.CheckedTarget;
import gnu.expr.ClassExp;
import gnu.expr.Closure;
import gnu.expr.Compilation;
import gnu.expr.ConsumerTarget;
import gnu.expr.Declaration;
import gnu.expr.ExpWalker;
import gnu.expr.Expression;
import gnu.expr.IgnoreTarget;
import gnu.expr.Initializer;
import gnu.expr.InlineCalls;
import gnu.expr.Keyword;
import gnu.expr.Language;
import gnu.expr.ModuleExp;
import gnu.expr.PrimProcedure;
import gnu.expr.ProcInitializer;
import gnu.expr.QuoteExp;
import gnu.expr.ReferenceExp;
import gnu.expr.ScopeExp;
import gnu.expr.Special;
import gnu.expr.StackTarget;
import gnu.expr.Target;
import gnu.expr.ThisExp;
import gnu.lists.LList;
import gnu.mapping.CallContext;
import gnu.mapping.OutPort;
import gnu.mapping.Procedure;
import gnu.mapping.PropertySet;
import gnu.mapping.Values;
import gnu.mapping.WrappedException;
import gnu.mapping.WrongArguments;
import java.util.Set;
import java.util.Vector;

public class LambdaExp
extends ScopeExp {
    public Expression body;
    public int min_args;
    public int max_args;
    Vector applyMethods;
    Variable argsArray;
    private Declaration firstArgsArrayArg;
    public Keyword[] keywords;
    public Expression[] defaultArgs;
    Declaration capturedVars;
    Variable heapFrame;
    public LambdaExp firstChild;
    public LambdaExp nextSibling;
    static final ApplyExp unknownContinuation = new ApplyExp((Expression)null, null);
    public Expression returnContinuation;
    Set<LambdaExp> tailCallers;
    public LambdaExp inlineHome;
    ReferenceExp[] throwsSpecification;
    public Declaration nameDecl;
    public Field closureEnvField;
    public Field staticLinkField;
    Variable closureEnv;
    static final int INLINE_ONLY = 1;
    static final int CAN_READ = 2;
    static final int CAN_CALL = 4;
    static final int IMPORTS_LEX_VARS = 8;
    static final int NEEDS_STATIC_LINK = 16;
    static final int CANNOT_INLINE = 32;
    static final int CLASS_METHOD = 64;
    static final int METHODS_COMPILED = 128;
    public static final int NO_FIELD = 256;
    static final int DEFAULT_CAPTURES_ARG = 512;
    public static final int SEQUENCE_RESULT = 1024;
    public static final int OVERLOADABLE_FIELD = 2048;
    public static final int ATTEMPT_INLINE = 4096;
    protected static final int NEXT_AVAIL_FLAG = 8192;
    ClassType type = Compilation.typeProcedure;
    int selectorValue;
    Method[] primMethods;
    Method[] primBodyMethods;
    Variable thisVariable;
    static Method searchForKeywordMethod3;
    static Method searchForKeywordMethod4;
    Initializer initChain;
    Procedure thisValue;
    Object[] properties;
    public Type returnType;

    public void capture(Declaration decl) {
        if (decl.isSimple()) {
            if (!(this.capturedVars != null || decl.isStatic() || this instanceof ModuleExp || this instanceof ClassExp)) {
                this.heapFrame = new Variable("heapFrame");
            }
            decl.setSimple(false);
            if (!decl.isPublic()) {
                decl.nextCapturedVar = this.capturedVars;
                this.capturedVars = decl;
            }
        }
    }

    public void setExceptions(ReferenceExp[] exceptions) {
        this.throwsSpecification = exceptions;
    }

    public final boolean getInlineOnly() {
        return (this.flags & 1) != 0;
    }

    public final void setInlineOnly(boolean inlineOnly) {
        this.setFlag(inlineOnly, 1);
    }

    public final boolean getNeedsClosureEnv() {
        return (this.flags & 0x18) != 0;
    }

    public final boolean getNeedsStaticLink() {
        return (this.flags & 0x10) != 0;
    }

    public final void setNeedsStaticLink(boolean needsStaticLink) {
        this.flags = needsStaticLink ? (this.flags |= 0x10) : (this.flags &= 0xFFFFFFEF);
    }

    public final boolean getImportsLexVars() {
        return (this.flags & 8) != 0;
    }

    public final void setImportsLexVars(boolean importsLexVars) {
        this.flags = importsLexVars ? (this.flags |= 8) : (this.flags &= 0xFFFFFFF7);
    }

    public final void setImportsLexVars() {
        int old = this.flags;
        this.flags |= 8;
        if ((old & 8) == 0 && this.nameDecl != null) {
            this.setCallersNeedStaticLink();
        }
    }

    public final void setNeedsStaticLink() {
        int old = this.flags;
        this.flags |= 0x10;
        if ((old & 0x10) == 0 && this.nameDecl != null) {
            this.setCallersNeedStaticLink();
        }
    }

    void setCallersNeedStaticLink() {
        LambdaExp outer = this.outerLambda();
        ApplyExp app = this.nameDecl.firstCall;
        while (app != null) {
            for (LambdaExp caller = app.context; caller != outer && !(caller instanceof ModuleExp); caller = caller.outerLambda()) {
                caller.setNeedsStaticLink();
            }
            app = app.nextCall;
        }
    }

    public final boolean getCanRead() {
        return (this.flags & 2) != 0;
    }

    public final void setCanRead(boolean read) {
        this.flags = read ? (this.flags |= 2) : (this.flags &= 0xFFFFFFFD);
    }

    public final boolean getCanCall() {
        return (this.flags & 4) != 0;
    }

    public final void setCanCall(boolean called) {
        this.flags = called ? (this.flags |= 4) : (this.flags &= 0xFFFFFFFB);
    }

    public final boolean isClassMethod() {
        return (this.flags & 0x40) != 0;
    }

    public final void setClassMethod(boolean isMethod) {
        this.flags = isMethod ? (this.flags |= 0x40) : (this.flags &= 0xFFFFFFBF);
    }

    public final boolean isModuleBody() {
        return this instanceof ModuleExp;
    }

    public final boolean isClassGenerated() {
        return this.isModuleBody() || this instanceof ClassExp;
    }

    public boolean isAbstract() {
        return this.body == QuoteExp.abstractExp;
    }

    public int getCallConvention() {
        if (this.isModuleBody()) {
            return Compilation.defaultCallConvention >= 2 ? Compilation.defaultCallConvention : 2;
        }
        if (this.isClassMethod()) {
            return 1;
        }
        return Compilation.defaultCallConvention != 0 ? Compilation.defaultCallConvention : 1;
    }

    public final boolean isHandlingTailCalls() {
        return this.isModuleBody() || Compilation.defaultCallConvention >= 3 && !this.isClassMethod();
    }

    public final boolean variable_args() {
        return this.max_args < 0;
    }

    protected ClassType getCompiledClassType(Compilation comp) {
        if (this.type == Compilation.typeProcedure) {
            throw new Error("internal error: getCompiledClassType");
        }
        return this.type;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(ClassType type) {
        this.type = type;
    }

    public int incomingArgs() {
        return this.min_args == this.max_args && this.max_args <= 4 && this.max_args > 0 ? this.max_args : 1;
    }

    int getSelectorValue(Compilation comp) {
        int s = this.selectorValue;
        if (s == 0) {
            s = comp.maxSelectorValue;
            comp.maxSelectorValue = s + this.primMethods.length;
            this.selectorValue = ++s;
        }
        return s;
    }

    public final Method getMethod(int argCount) {
        if (this.primMethods == null || this.max_args >= 0 && argCount > this.max_args) {
            return null;
        }
        int index = argCount - this.min_args;
        if (index < 0) {
            return null;
        }
        int length = this.primMethods.length;
        return this.primMethods[index < length ? index : length - 1];
    }

    public final Method getMainMethod() {
        Method[] methods = this.primBodyMethods;
        return methods == null ? null : methods[methods.length - 1];
    }

    public final Type restArgType() {
        if (this.min_args == this.max_args) {
            return null;
        }
        if (this.primMethods == null) {
            throw new Error("internal error - restArgType");
        }
        Method[] methods = this.primMethods;
        if (this.max_args >= 0 && methods.length > this.max_args - this.min_args) {
            return null;
        }
        Method method = methods[methods.length - 1];
        Type[] types = method.getParameterTypes();
        int ilast = types.length - 1;
        if (method.getName().endsWith("$X")) {
            --ilast;
        }
        return types[ilast];
    }

    public LambdaExp outerLambda() {
        return this.outer == null ? null : this.outer.currentLambda();
    }

    public LambdaExp outerLambdaNotInline() {
        ScopeExp exp = this;
        while ((exp = exp.outer) != null) {
            ScopeExp result;
            if (!(exp instanceof LambdaExp) || ((LambdaExp)(result = exp)).getInlineOnly()) continue;
            return result;
        }
        return null;
    }

    boolean inlinedIn(LambdaExp outer) {
        LambdaExp exp = this;
        while (exp.getInlineOnly()) {
            if (exp == outer) {
                return true;
            }
            exp = exp.getCaller();
        }
        return false;
    }

    public LambdaExp getCaller() {
        return this.inlineHome;
    }

    public Variable declareThis(ClassType clas) {
        if (this.thisVariable == null) {
            this.thisVariable = new Variable("this");
            this.getVarScope().addVariableAfter(null, this.thisVariable);
            this.thisVariable.setParameter(true);
        }
        if (this.thisVariable.getType() == null) {
            this.thisVariable.setType(clas);
        }
        if (this.decls != null && this.decls.isThisParameter()) {
            this.decls.var = this.thisVariable;
        }
        return this.thisVariable;
    }

    public Variable declareClosureEnv() {
        if (this.closureEnv == null && this.getNeedsClosureEnv()) {
            Variable parentFrame;
            LambdaExp parent = this.outerLambda();
            if (parent instanceof ClassExp) {
                parent = parent.outerLambda();
            }
            Variable variable = parentFrame = parent.heapFrame != null ? parent.heapFrame : parent.closureEnv;
            if (this.isClassMethod() && !"*init*".equals(this.getName())) {
                this.closureEnv = this.declareThis(this.type);
            } else if (parent.heapFrame == null && !parent.getNeedsStaticLink() && !(parent instanceof ModuleExp)) {
                this.closureEnv = null;
            } else if (!this.isClassGenerated() && !this.getInlineOnly()) {
                Method primMethod = this.getMainMethod();
                boolean isInit = "*init*".equals(this.getName());
                if (!primMethod.getStaticFlag() && !isInit) {
                    this.closureEnv = this.declareThis(primMethod.getDeclaringClass());
                } else {
                    Type envType = primMethod.getParameterTypes()[0];
                    this.closureEnv = new Variable("closureEnv", envType);
                    Variable prev = isInit ? this.declareThis(primMethod.getDeclaringClass()) : null;
                    this.getVarScope().addVariableAfter(prev, this.closureEnv);
                    this.closureEnv.setParameter(true);
                }
            } else if (this.inlinedIn(parent)) {
                this.closureEnv = parentFrame;
            } else {
                this.closureEnv = new Variable("closureEnv", parentFrame.getType());
                this.getVarScope().addVariable(this.closureEnv);
            }
        }
        return this.closureEnv;
    }

    public LambdaExp() {
    }

    public LambdaExp(int args) {
        this.min_args = args;
        this.max_args = args;
    }

    public LambdaExp(Expression body) {
        this.body = body;
    }

    public void loadHeapFrame(Compilation comp) {
        ClassType curType;
        LambdaExp curLambda;
        for (curLambda = comp.curLambda; curLambda != this && curLambda.getInlineOnly(); curLambda = curLambda.getCaller()) {
        }
        CodeAttr code = comp.getCode();
        if (curLambda.heapFrame != null && this == curLambda) {
            code.emitLoad(curLambda.heapFrame);
            return;
        }
        if (curLambda.closureEnv != null) {
            code.emitLoad(curLambda.closureEnv);
            curType = (ClassType)curLambda.closureEnv.getType();
        } else {
            code.emitPushThis();
            curType = comp.curClass;
        }
        while (curLambda != this) {
            Field link = curLambda.staticLinkField;
            if (link != null && link.getDeclaringClass() == curType) {
                code.emitGetField(link);
                curType = (ClassType)link.getType();
            }
            curLambda = curLambda.outerLambda();
        }
    }

    Declaration getArg(int i) {
        Declaration var = this.firstDecl();
        while (true) {
            if (var == null) {
                throw new Error("internal error - getArg");
            }
            if (i == 0) {
                return var;
            }
            --i;
            var = var.nextDecl();
        }
    }

    public void compileEnd(Compilation comp) {
        CodeAttr code = comp.getCode();
        if (!this.getInlineOnly()) {
            if (comp.method.reachableHere() && (Compilation.defaultCallConvention < 3 || this.isModuleBody() || this.isClassMethod() || this.isHandlingTailCalls())) {
                code.emitReturn();
            }
            this.popScope(code);
            if (!Compilation.fewerClasses) {
                code.popScope();
            }
        }
        LambdaExp child = this.firstChild;
        while (child != null) {
            if (!child.getCanRead() && !child.getInlineOnly()) {
                child.compileAsMethod(comp);
            }
            child = child.nextSibling;
        }
        if (this.heapFrame != null) {
            comp.generateConstructor(this);
        }
    }

    public void generateApplyMethods(Compilation comp) {
        comp.generateMatchMethods(this);
        if (Compilation.defaultCallConvention >= 2) {
            comp.generateApplyMethodsWithContext(this);
        } else {
            comp.generateApplyMethodsWithoutContext(this);
        }
    }

    Field allocFieldFor(Compilation comp) {
        if (this.nameDecl != null && this.nameDecl.field != null) {
            return this.nameDecl.field;
        }
        boolean needsClosure = this.getNeedsClosureEnv();
        ClassType frameType = needsClosure ? this.getOwningLambda().getHeapFrameType() : comp.mainClass;
        String name = this.getName();
        String fname = name == null ? "lambda" : Compilation.mangleNameIfNeeded(name);
        int fflags = 16;
        if (this.nameDecl != null && this.nameDecl.context instanceof ModuleExp) {
            boolean external_access = this.nameDecl.needsExternalAccess();
            if (external_access) {
                fname = "$Prvt$" + fname;
            }
            if (this.nameDecl.getFlag(2048L)) {
                fflags |= 8;
                if (!((ModuleExp)this.nameDecl.context).isStatic()) {
                    fflags &= 0xFFFFFFEF;
                }
            }
            if (!this.nameDecl.isPrivate() || external_access || comp.immediate) {
                fflags |= 1;
            }
            if ((this.flags & 0x800) != 0) {
                int suffix;
                String fname0 = fname;
                int n = suffix = this.min_args == this.max_args ? this.min_args : 1;
                while (frameType.getDeclaredField(fname = fname0 + '$' + suffix++) != null) {
                }
            }
        } else {
            fname = fname + "$Fn" + ++comp.localFieldIndex;
            if (!needsClosure) {
                fflags |= 8;
            }
        }
        ClassType rtype = Compilation.typeModuleMethod;
        Field field = frameType.addField(fname, rtype, fflags);
        if (this.nameDecl != null) {
            this.nameDecl.field = field;
        }
        return field;
    }

    final void addApplyMethod(Compilation comp, Field field) {
        LambdaExp owner = this;
        if (field != null && field.getStaticFlag()) {
            owner = comp.getModule();
        } else {
            while (!((owner = owner.outerLambda()) instanceof ModuleExp) && owner.heapFrame == null) {
            }
            ClassType frameType = owner.getHeapFrameType();
            if (!frameType.getSuperclass().isSubtype(Compilation.typeModuleBody)) {
                owner = comp.getModule();
            }
        }
        if (owner.applyMethods == null) {
            owner.applyMethods = new Vector();
        }
        owner.applyMethods.addElement(this);
    }

    public Field compileSetField(Compilation comp) {
        if (this.primMethods == null) {
            this.allocMethod(this.outerLambda(), comp);
        }
        Field field = this.allocFieldFor(comp);
        if (comp.usingCPStyle()) {
            this.compile(comp, Type.objectType);
        } else {
            this.compileAsMethod(comp);
            this.addApplyMethod(comp, field);
        }
        return new ProcInitializer((LambdaExp)this, (Compilation)comp, (Field)field).field;
    }

    public void compile(Compilation comp, Target target) {
        if (target instanceof IgnoreTarget) {
            return;
        }
        CodeAttr code = comp.getCode();
        LambdaExp outer = this.outerLambda();
        ClassType rtype = Compilation.typeModuleMethod;
        if ((this.flags & 0x100) != 0 || comp.immediate && outer instanceof ModuleExp) {
            if (this.primMethods == null) {
                this.allocMethod(this.outerLambda(), comp);
            }
            this.compileAsMethod(comp);
            this.addApplyMethod(comp, null);
            ProcInitializer.emitLoadModuleMethod(this, comp);
        } else {
            Field field = this.compileSetField(comp);
            if (field.getStaticFlag()) {
                code.emitGetStatic(field);
            } else {
                LambdaExp parent = comp.curLambda;
                Variable frame97 = parent.heapFrame != null ? parent.heapFrame : parent.closureEnv;
                code.emitLoad(frame97);
                code.emitGetField(field);
            }
        }
        target.compileFromStack(comp, rtype);
    }

    public ClassType getHeapFrameType() {
        if (this instanceof ModuleExp || this instanceof ClassExp) {
            return (ClassType)this.getType();
        }
        return (ClassType)this.heapFrame.getType();
    }

    public LambdaExp getOwningLambda() {
        ScopeExp exp = this.outer;
        while (exp != null) {
            if (exp instanceof ModuleExp || exp instanceof ClassExp && this.getNeedsClosureEnv() || exp instanceof LambdaExp && ((LambdaExp)exp).heapFrame != null) {
                return (LambdaExp)exp;
            }
            exp = exp.outer;
        }
        return null;
    }

    void addMethodFor(Compilation comp, ObjectType closureEnvType) {
        ScopeExp sc = this;
        while (sc != null && !(sc instanceof ClassExp)) {
            sc = sc.outer;
        }
        ClassType ctype = sc != null ? ((ClassExp)sc).instanceType : this.getOwningLambda().getHeapFrameType();
        this.addMethodFor(ctype, comp, closureEnvType);
    }

    void addMethodFor(ClassType ctype, Compilation comp, ObjectType closureEnvType) {
        int i;
        boolean withContext;
        int mflags;
        StringBuffer nameBuf;
        int isInitMethod;
        boolean varArgs;
        int numStubs;
        int opt_args;
        int key_args;
        LambdaExp outer;
        String name;
        block57: {
            boolean isStatic;
            name = this.getName();
            outer = this.outerLambda();
            key_args = this.keywords == null ? 0 : this.keywords.length;
            opt_args = this.defaultArgs == null ? 0 : this.defaultArgs.length - key_args;
            numStubs = (this.flags & 0x200) != 0 ? 0 : opt_args;
            varArgs = this.max_args < 0 || this.min_args + numStubs < this.max_args;
            Method[] methods = new Method[numStubs + 1];
            this.primBodyMethods = methods;
            if (this.primMethods == null) {
                this.primMethods = methods;
            }
            isInitMethod = 0;
            if (this.nameDecl != null && this.nameDecl.getFlag(4096L)) {
                isStatic = false;
            } else if (this.nameDecl != null && this.nameDecl.getFlag(2048L)) {
                isStatic = true;
            } else if (this.isClassMethod()) {
                if (outer instanceof ClassExp) {
                    ClassExp cl = (ClassExp)outer;
                    boolean bl = isStatic = cl.isMakingClassPair() && closureEnvType != null;
                    if (this == cl.initMethod) {
                        isInitMethod = 73;
                    } else if (this == cl.clinitMethod) {
                        isInitMethod = 67;
                        isStatic = true;
                    }
                } else {
                    isStatic = false;
                }
            } else {
                ModuleExp mexp;
                isStatic = this.thisVariable != null || closureEnvType == ctype ? false : (this.nameDecl != null && this.nameDecl.context instanceof ModuleExp ? (mexp = (ModuleExp)this.nameDecl.context).getSuperType() == null && mexp.getInterfaces() == null : true);
            }
            nameBuf = new StringBuffer(60);
            int n = mflags = isStatic ? 8 : 0;
            if (this.nameDecl != null) {
                if (this.nameDecl.needsExternalAccess()) {
                    mflags |= 1;
                } else {
                    short defaultFlag;
                    short s = defaultFlag = this.nameDecl.isPrivate() ? (short)0 : 1;
                    if (this.isClassMethod()) {
                        defaultFlag = this.nameDecl.getAccessFlags(defaultFlag);
                    }
                    mflags |= defaultFlag;
                }
            }
            if (!outer.isModuleBody() && !(outer instanceof ClassExp) || name == null) {
                nameBuf.append("lambda");
                nameBuf.append(++comp.method_counter);
            }
            if (isInitMethod == 67) {
                nameBuf.append("<clinit>");
            } else if (this.getSymbol() != null) {
                nameBuf.append(Compilation.mangleName(name));
            }
            if (this.getFlag(1024)) {
                nameBuf.append("$C");
            }
            boolean bl = withContext = this.getCallConvention() >= 2 && isInitMethod == 0;
            if (isInitMethod != 0) {
                mflags = isStatic ? (mflags & 0xFFFFFFFD) + 1 : (mflags & 2) + 2;
            }
            if (ctype.isInterface() || this.isAbstract()) {
                mflags |= 0x400;
            }
            if (!this.isClassMethod() || !(outer instanceof ClassExp) || this.min_args != this.max_args) break block57;
            Method[] inherited = null;
            int iarg = 0;
            Declaration param = this.firstDecl();
            block0: while (true) {
                block56: {
                    block59: {
                        block60: {
                            block58: {
                                if (param != null) break block58;
                                if (this.returnType != null) {
                                    break;
                                }
                                break block59;
                            }
                            if (!param.isThisParameter()) break block60;
                            --iarg;
                            break block56;
                        }
                        if (param.getFlag(8192L)) break block56;
                    }
                    if (inherited == null) {
                        final String mangled = nameBuf.toString();
                        Filter filter = new Filter(){

                            public boolean select(Object value) {
                                Method method = (Method)value;
                                if (!method.getName().equals(mangled)) {
                                    return false;
                                }
                                Type[] ptypes = method.getParameterTypes();
                                return ptypes.length == LambdaExp.this.min_args;
                            }
                        };
                        inherited = ctype.getMethods(filter, 2);
                    }
                    Type type = null;
                    i = inherited.length;
                    while (--i >= 0) {
                        Type ptype;
                        void method = inherited[i];
                        Type type2 = ptype = param == null ? method.getReturnType() : method.getParameterTypes()[iarg];
                        if (type == null) {
                            type = ptype;
                            continue;
                        }
                        if (ptype == type) continue;
                        if (param == null) {
                            break block0;
                        }
                        break block56;
                    }
                    if (type != null) {
                        if (param != null) {
                            param.setType(type);
                        } else {
                            this.setCoercedReturnType(type);
                        }
                    }
                    if (param == null) break;
                }
                param = param.nextDecl();
                ++iarg;
            }
        }
        PrimType rtype = this.getFlag(1024) || this.getCallConvention() >= 2 ? Type.voidType : this.getReturnType().getImplementationType();
        int extraArg = closureEnvType != null && closureEnvType != ctype ? 1 : 0;
        int ctxArg = 0;
        if (this.getCallConvention() >= 2 && isInitMethod == 0) {
            ctxArg = 1;
        }
        int nameBaseLength = nameBuf.length();
        for (i = 0; i <= numStubs; ++i) {
            Method method;
            Declaration var;
            int plainArgs;
            nameBuf.setLength(nameBaseLength);
            int numArgs = plainArgs = this.min_args + i;
            if (i == numStubs && varArgs) {
                ++numArgs;
            }
            Type[] atypes = new Type[extraArg + numArgs + ctxArg];
            if (extraArg > 0) {
                atypes[0] = closureEnvType;
            }
            if ((var = this.firstDecl()) != null && var.isThisParameter()) {
                var = var.nextDecl();
            }
            int itype = 0;
            while (itype < plainArgs) {
                atypes[extraArg + itype++] = var.getType().getImplementationType();
                var = var.nextDecl();
            }
            if (ctxArg != 0) {
                atypes[atypes.length - 1] = Compilation.typeCallContext;
            }
            if (plainArgs < numArgs) {
                Type lastType = var.getType();
                String lastTypeName = lastType.getName();
                if (ctype.getClassfileVersion() >= 0x310000 && "java.lang.Object[]".equals(lastTypeName)) {
                    mflags |= 0x80;
                } else {
                    nameBuf.append("$V");
                }
                if (key_args > 0 || numStubs < opt_args || !"gnu.lists.LList".equals(lastTypeName) && !"java.lang.Object[]".equals(lastTypeName)) {
                    lastType = Compilation.objArrayType;
                    this.argsArray = new Variable("argsArray", Compilation.objArrayType);
                    this.argsArray.setParameter(true);
                }
                this.firstArgsArrayArg = var;
                atypes[atypes.length - (withContext ? 2 : 1)] = lastType;
            }
            if (withContext) {
                nameBuf.append("$X");
            }
            boolean classSpecified = outer instanceof ClassExp || outer instanceof ModuleExp && ((ModuleExp)outer).getFlag(65536);
            name = nameBuf.toString();
            int renameCount = 0;
            int len = nameBuf.length();
            block4: while (true) {
                for (ClassType t = ctype; t != null; t = t.getSuperclass()) {
                    if (t.getDeclaredMethod(name, atypes) != null) {
                        nameBuf.setLength(len);
                        nameBuf.append('$');
                        nameBuf.append(++renameCount);
                        name = nameBuf.toString();
                        continue;
                    }
                    if (classSpecified) break block4;
                }
                break;
            }
            methods[i] = method = ctype.addMethod(name, atypes, rtype, mflags);
            if (this.throwsSpecification == null || this.throwsSpecification.length <= 0) continue;
            int n = this.throwsSpecification.length;
            ClassType[] exceptions = new ClassType[n];
            for (int j = 0; j < n; ++j) {
                ClassType exception = null;
                Declaration decl = this.throwsSpecification[j].getBinding();
                if (decl != null) {
                    Expression declValue = decl.getValue();
                    if (declValue instanceof ClassExp) {
                        exception = ((ClassExp)declValue).getCompiledClassType(comp);
                    } else {
                        comp.error('e', "throws specification " + decl.getName() + " has non-class lexical binding");
                    }
                }
                if (exception == null) {
                    String exName = this.throwsSpecification[j].getName();
                    int nlen = exName.length();
                    if (nlen > 2 && exName.charAt(0) == '<' && exName.charAt(nlen - 1) == '>') {
                        exName = exName.substring(1, nlen - 1);
                    }
                    exception = ClassType.make(exName);
                }
                exceptions[j] = exception;
            }
            ExceptionsAttr attr = new ExceptionsAttr(method);
            attr.setExceptions(exceptions);
        }
    }

    public void allocChildClasses(Compilation comp) {
        Method main = this.getMainMethod();
        if (main != null && !main.getStaticFlag()) {
            this.declareThis(main.getDeclaringClass());
        }
        Declaration decl = this.firstDecl();
        while (true) {
            Variable var;
            if (decl == this.firstArgsArrayArg && this.argsArray != null) {
                this.getVarScope().addVariable(this.argsArray);
            }
            if (!this.getInlineOnly() && this.getCallConvention() >= 2 && (this.firstArgsArrayArg == null ? decl == null : (this.argsArray != null ? decl == this.firstArgsArrayArg : decl == this.firstArgsArrayArg.nextDecl()))) {
                var = this.getVarScope().addVariable(null, Compilation.typeCallContext, "$ctx");
                var.setParameter(true);
            }
            if (decl == null) break;
            var = decl.var;
            if (!(var != null || this.getInlineOnly() && decl.ignorable())) {
                if (decl.isSimple() && !decl.isIndirectBinding()) {
                    var = decl.allocateVariable(null);
                } else {
                    String vname = Compilation.mangleName(decl.getName()).intern();
                    Type vtype = decl.getType().getImplementationType();
                    var = decl.var = this.getVarScope().addVariable(null, vtype, vname);
                    var.setParameter(true);
                }
            }
            decl = decl.nextDecl();
        }
        this.declareClosureEnv();
        this.allocFrame(comp);
        this.allocChildMethods(comp);
    }

    void allocMethod(LambdaExp outer, Compilation comp) {
        ClassType closureEnvType;
        if (!this.getNeedsClosureEnv()) {
            closureEnvType = null;
        } else if (outer instanceof ClassExp || outer instanceof ModuleExp) {
            closureEnvType = outer.getCompiledClassType(comp);
        } else {
            LambdaExp owner = outer;
            while (owner.heapFrame == null) {
                owner = owner.outerLambda();
            }
            closureEnvType = (ClassType)owner.heapFrame.getType();
        }
        this.addMethodFor(comp, closureEnvType);
    }

    void allocChildMethods(Compilation comp) {
        LambdaExp child = this.firstChild;
        while (child != null) {
            ClassExp cl;
            if (!child.isClassGenerated() && !child.getInlineOnly() && child.nameDecl != null) {
                child.allocMethod(this, comp);
            }
            if (child instanceof ClassExp && (cl = (ClassExp)child).getNeedsClosureEnv()) {
                ClassType parentFrameType;
                if (this instanceof ModuleExp || this instanceof ClassExp) {
                    parentFrameType = (ClassType)this.getType();
                } else {
                    Variable parentFrame = this.heapFrame != null ? this.heapFrame : this.closureEnv;
                    parentFrameType = (ClassType)parentFrame.getType();
                }
                cl.closureEnvField = cl.staticLinkField = cl.instanceType.setOuterLink(parentFrameType);
            }
            child = child.nextSibling;
        }
    }

    public void allocFrame(Compilation comp) {
        if (this.heapFrame != null) {
            ClassType frameType;
            if (this instanceof ModuleExp || this instanceof ClassExp) {
                frameType = this.getCompiledClassType(comp);
            } else {
                frameType = new ClassType(comp.generateClassName("frame"));
                frameType.setSuper(comp.getModuleType());
                comp.addClass(frameType);
            }
            this.heapFrame.setType(frameType);
        }
    }

    void allocParameters(Compilation comp) {
        CodeAttr code = comp.getCode();
        int i = 0;
        int j = 0;
        code.locals.enterScope(this.getVarScope());
        int line = this.getLineNumber();
        if (line > 0) {
            code.putLineNumber(this.getFileName(), line);
        }
        for (Declaration decl = this.firstDecl(); decl != null; decl = decl.nextDecl()) {
            if (this.argsArray != null && this.min_args == this.max_args && this.primMethods == null && this.getCallConvention() < 2) {
                code.emitLoad(this.argsArray);
                code.emitPushInt(j);
                code.emitArrayLoad(Type.objectType);
                decl.getType().emitCoerceFromObject(code);
                code.emitStore(decl.getVariable());
            }
            ++j;
            ++i;
        }
        if (this.heapFrame != null) {
            this.heapFrame.allocateLocal(code);
        }
    }

    void enterFunction(Compilation comp) {
        int opt_args;
        ClassType frameType;
        CodeAttr code = comp.getCode();
        this.getVarScope().noteStartFunction(code);
        if (this.closureEnv != null && !this.closureEnv.isParameter() && !comp.usingCPStyle()) {
            if (!this.getInlineOnly()) {
                code.emitPushThis();
                Field field = this.closureEnvField;
                if (field == null) {
                    field = this.outerLambda().closureEnvField;
                }
                code.emitGetField(field);
                code.emitStore(this.closureEnv);
            } else if (!this.inlinedIn(this.outerLambda())) {
                this.outerLambda().loadHeapFrame(comp);
                code.emitStore(this.closureEnv);
            }
        }
        if (!comp.usingCPStyle()) {
            frameType = this.heapFrame == null ? this.currentModule().getCompiledClassType(comp) : (ClassType)this.heapFrame.getType();
            Declaration decl = this.capturedVars;
            while (decl != null) {
                if (decl.field == null) {
                    decl.makeField(frameType, comp, null);
                }
                decl = decl.nextCapturedVar;
            }
        }
        if (this.heapFrame != null && !comp.usingCPStyle()) {
            frameType = (ClassType)this.heapFrame.getType();
            if (this.closureEnv != null && !(this instanceof ModuleExp)) {
                this.staticLinkField = frameType.addField("staticLink", this.closureEnv.getType());
            }
            if (!(this instanceof ModuleExp) && !(this instanceof ClassExp)) {
                frameType.setEnclosingMember(comp.method);
                code.emitNew(frameType);
                code.emitDup(frameType);
                Method constructor = Compilation.getConstructor(frameType, this);
                code.emitInvokeSpecial(constructor);
                if (this.staticLinkField != null) {
                    code.emitDup(frameType);
                    code.emitLoad(this.closureEnv);
                    code.emitPutField(this.staticLinkField);
                }
                code.emitStore(this.heapFrame);
            }
        }
        Variable argsArray = this.argsArray;
        if (this.min_args == this.max_args && !Compilation.fewerClasses && this.primMethods == null && this.getCallConvention() < 2) {
            argsArray = null;
        }
        int i = 0;
        int opt_i = 0;
        int key_i = 0;
        int key_args = this.keywords == null ? 0 : this.keywords.length;
        int n = opt_args = this.defaultArgs == null ? 0 : this.defaultArgs.length - key_args;
        if (this instanceof ModuleExp) {
            return;
        }
        int plainArgs = -1;
        int defaultStart = 0;
        Method mainMethod = this.getMainMethod();
        Variable callContextSave = comp.callContextVar;
        for (Declaration param = this.firstDecl(); param != null; param = param.nextDecl()) {
            Variable variable = comp.callContextVar = this.getCallConvention() < 2 ? null : this.getVarScope().lookup("$ctx");
            if (param == this.firstArgsArrayArg && argsArray != null) {
                if (this.primMethods != null) {
                    plainArgs = i;
                    defaultStart = plainArgs - this.min_args;
                } else {
                    plainArgs = 0;
                    defaultStart = 0;
                }
            }
            if (plainArgs >= 0 || !param.isSimple() || param.isIndirectBinding()) {
                Type stackType;
                Type paramType = param.getType();
                Type type = stackType = mainMethod == null || plainArgs >= 0 ? Type.objectType : paramType;
                if (!param.isSimple()) {
                    param.loadOwningObject(null, comp);
                }
                if (plainArgs < 0) {
                    code.emitLoad(param.getVariable());
                } else if (i < this.min_args) {
                    code.emitLoad(argsArray);
                    code.emitPushInt(i);
                    code.emitArrayLoad(Type.objectType);
                } else if (i < this.min_args + opt_args) {
                    code.emitPushInt(i - plainArgs);
                    code.emitLoad(argsArray);
                    code.emitArrayLength();
                    code.emitIfIntLt();
                    code.emitLoad(argsArray);
                    code.emitPushInt(i - plainArgs);
                    code.emitArrayLoad();
                    code.emitElse();
                    this.defaultArgs[defaultStart + opt_i++].compile(comp, paramType);
                    code.emitFi();
                } else if (this.max_args < 0 && i == this.min_args + opt_args) {
                    code.emitLoad(argsArray);
                    code.emitPushInt(i - plainArgs);
                    code.emitInvokeStatic(Compilation.makeListMethod);
                    stackType = Compilation.scmListType;
                } else {
                    Type[] argts;
                    code.emitLoad(argsArray);
                    code.emitPushInt(this.min_args + opt_args - plainArgs);
                    comp.compileConstant(this.keywords[key_i++]);
                    Expression defaultArg = this.defaultArgs[defaultStart + opt_i++];
                    if (defaultArg instanceof QuoteExp) {
                        if (searchForKeywordMethod4 == null) {
                            argts = new Type[]{Compilation.objArrayType, Type.intType, Type.objectType, Type.objectType};
                            searchForKeywordMethod4 = Compilation.scmKeywordType.addMethod("searchForKeyword", argts, Type.objectType, 9);
                        }
                        defaultArg.compile(comp, paramType);
                        code.emitInvokeStatic(searchForKeywordMethod4);
                    } else {
                        if (searchForKeywordMethod3 == null) {
                            argts = new Type[]{Compilation.objArrayType, Type.intType, Type.objectType};
                            searchForKeywordMethod3 = Compilation.scmKeywordType.addMethod("searchForKeyword", argts, Type.objectType, 9);
                        }
                        code.emitInvokeStatic(searchForKeywordMethod3);
                        code.emitDup(1);
                        comp.compileConstant(Special.dfault);
                        code.emitIfEq();
                        code.emitPop(1);
                        defaultArg.compile(comp, paramType);
                        code.emitFi();
                    }
                }
                if (paramType != stackType) {
                    CheckedTarget.emitCheckedCoerce(comp, this, i + 1, paramType);
                }
                if (param.isIndirectBinding()) {
                    param.pushIndirectBinding(comp);
                }
                if (param.isSimple()) {
                    code.emitStore(param.getVariable());
                } else {
                    code.emitPutField(param.field);
                }
            }
            ++i;
        }
        comp.callContextVar = callContextSave;
    }

    void compileAsMethod(Compilation comp) {
        if ((this.flags & 0x80) != 0 || this.isAbstract()) {
            return;
        }
        this.flags |= 0x80;
        if (this.primMethods == null) {
            return;
        }
        Method save_method = comp.method;
        LambdaExp save_lambda = comp.curLambda;
        comp.curLambda = this;
        Method method = this.primMethods[0];
        boolean isStatic = method.getStaticFlag();
        int numStubs = this.primMethods.length - 1;
        Type restArgType = this.restArgType();
        long[] saveDeclFlags = null;
        if (numStubs > 0) {
            saveDeclFlags = new long[this.min_args + numStubs];
            int k = 0;
            Declaration decl = this.firstDecl();
            while (k < this.min_args + numStubs) {
                saveDeclFlags[k++] = decl.flags;
                decl = decl.nextDecl();
            }
        }
        boolean ctxArg = this.getCallConvention() >= 2;
        for (int i = 0; i <= numStubs; ++i) {
            comp.method = this.primMethods[i];
            if (i < numStubs) {
                int toCall;
                CodeAttr code = comp.method.startCode();
                for (toCall = i + 1; toCall < numStubs && this.defaultArgs[toCall] instanceof QuoteExp; ++toCall) {
                }
                boolean varArgs = toCall == numStubs && restArgType != null;
                Variable callContextSave = comp.callContextVar;
                Variable var = code.getArg(0);
                if (!isStatic) {
                    code.emitPushThis();
                    if (this.getNeedsClosureEnv()) {
                        this.closureEnv = var;
                    }
                    var = code.getArg(1);
                }
                Declaration decl = this.firstDecl();
                int j = 0;
                while (j < this.min_args + i) {
                    decl.flags |= 0x40L;
                    decl.var = var;
                    code.emitLoad(var);
                    var = var.nextVar();
                    ++j;
                    decl = decl.nextDecl();
                }
                comp.callContextVar = ctxArg ? var : null;
                j = i;
                while (j < toCall) {
                    Target paramTarget = StackTarget.getInstance(decl.getType());
                    this.defaultArgs[j].compile(comp, paramTarget);
                    ++j;
                    decl = decl.nextDecl();
                }
                if (varArgs) {
                    QuoteExp arg;
                    String lastTypeName = restArgType.getName();
                    if ("gnu.lists.LList".equals(lastTypeName)) {
                        arg = new QuoteExp(LList.Empty);
                    } else if ("java.lang.Object[]".equals(lastTypeName)) {
                        arg = new QuoteExp(Values.noArgs);
                    } else {
                        throw new Error("unimplemented #!rest type " + lastTypeName);
                    }
                    arg.compile(comp, restArgType);
                }
                if (ctxArg) {
                    code.emitLoad(var);
                }
                if (isStatic) {
                    code.emitInvokeStatic(this.primMethods[toCall]);
                } else {
                    code.emitInvokeVirtual(this.primMethods[toCall]);
                }
                code.emitReturn();
                this.closureEnv = null;
                comp.callContextVar = callContextSave;
                continue;
            }
            if (saveDeclFlags != null) {
                int k = 0;
                Declaration decl = this.firstDecl();
                while (k < this.min_args + numStubs) {
                    decl.flags = saveDeclFlags[k++];
                    decl.var = null;
                    decl = decl.nextDecl();
                }
            }
            comp.method.initCode();
            this.allocChildClasses(comp);
            this.allocParameters(comp);
            this.enterFunction(comp);
            this.compileBody(comp);
            this.compileEnd(comp);
            this.generateApplyMethods(comp);
        }
        comp.method = save_method;
        comp.curLambda = save_lambda;
    }

    public void compileBody(Compilation comp) {
        Target target;
        Variable callContextSave = comp.callContextVar;
        comp.callContextVar = null;
        if (this.getCallConvention() >= 2) {
            Variable var = this.getVarScope().lookup("$ctx");
            if (var != null && var.getType() == Compilation.typeCallContext) {
                comp.callContextVar = var;
            }
            target = ConsumerTarget.makeContextTarget(comp);
        } else {
            target = Target.pushValue(this.getReturnType());
        }
        this.body.compileWithPosition(comp, target, this.body.getLineNumber() > 0 ? this.body : this);
        comp.callContextVar = callContextSave;
    }

    protected Expression walk(ExpWalker walker) {
        return walker.walkLambdaExp(this);
    }

    protected void walkChildren(ExpWalker walker) {
        this.walkChildrenOnly(walker);
        this.walkProperties(walker);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void walkChildrenOnly(ExpWalker walker) {
        LambdaExp save = walker.currentLambda;
        walker.currentLambda = this;
        try {
            walker.walkDefaultArgs(this);
            if (walker.exitValue == null && this.body != null) {
                this.body = walker.walk(this.body);
            }
        }
        finally {
            walker.currentLambda = save;
        }
    }

    protected final void walkProperties(ExpWalker walker) {
        if (this.properties != null) {
            int len = this.properties.length;
            for (int i = 1; i < len; i += 2) {
                Object val = this.properties[i];
                if (!(val instanceof Expression)) continue;
                this.properties[i] = walker.walk((Expression)this.properties[i]);
            }
        }
    }

    protected boolean mustCompile() {
        if (this.keywords != null && this.keywords.length > 0) {
            return true;
        }
        if (this.defaultArgs != null) {
            int i = this.defaultArgs.length;
            while (--i >= 0) {
                Expression def = this.defaultArgs[i];
                if (def == null || def instanceof QuoteExp) continue;
                return true;
            }
        }
        return false;
    }

    public void apply(CallContext ctx) throws Throwable {
        this.setIndexes();
        ctx.writeValue(new Closure(this, ctx));
    }

    Object evalDefaultArg(int index, CallContext ctx) {
        try {
            return this.defaultArgs[index].eval(ctx);
        }
        catch (Throwable ex) {
            throw new WrappedException("error evaluating default argument", ex);
        }
    }

    public Expression inline(ApplyExp exp, InlineCalls walker, Declaration decl, boolean argsInlined) {
        Method method;
        Expression[] args = exp.getArgs();
        if (!argsInlined) {
            Expression inlined;
            if ((this.flags & 0x1000) != 0 && (inlined = InlineCalls.inlineCall(this, args, true)) != null) {
                return walker.walk(inlined);
            }
            exp.args = walker.walkExps(exp.args, exp.args.length);
        }
        int args_length = exp.args.length;
        String msg = WrongArguments.checkArgCount(this.getName(), this.min_args, this.max_args, args_length);
        if (msg != null) {
            return walker.noteError(msg);
        }
        int conv = this.getCallConvention();
        Compilation comp = walker.getCompilation();
        if (comp.inlineOk(this) && this.isClassMethod() && (conv <= 2 || conv == 3) && (method = this.getMethod(args_length)) != null) {
            Expression[] margs;
            ClassExp cl;
            boolean isStatic = this.nameDecl.isStatic();
            if (isStatic || !(this.outer instanceof ClassExp) || (cl = (ClassExp)this.outer).isMakingClassPair()) {
                // empty if block
            }
            PrimProcedure mproc = new PrimProcedure(method, this);
            if (isStatic) {
                margs = exp.args;
            } else {
                LambdaExp curLambda = walker.getCurrentLambda();
                while (true) {
                    if (curLambda == null) {
                        return walker.noteError("internal error: missing " + this);
                    }
                    if (curLambda.outer == this.outer) break;
                    curLambda = curLambda.outerLambda();
                }
                Declaration d = curLambda.firstDecl();
                if (d == null || !d.isThisParameter()) {
                    return walker.noteError("calling non-static method " + this.getName() + " from static method " + curLambda.getName());
                }
                int nargs = exp.getArgCount();
                margs = new Expression[1 + nargs];
                System.arraycopy(exp.getArgs(), 0, margs, 1, nargs);
                margs[0] = new ThisExp(d);
            }
            ApplyExp nexp = new ApplyExp(mproc, margs);
            return nexp.setLine(exp);
        }
        return exp;
    }

    public void print(OutPort out) {
        out.startLogicalBlock("(Lambda/", ")", 2);
        Object sym = this.getSymbol();
        if (sym != null) {
            out.print(sym);
            out.print('/');
        }
        out.print(this.id);
        out.print('/');
        out.print("fl:");
        out.print(Integer.toHexString(this.flags));
        out.writeSpaceFill();
        this.printLineColumn(out);
        out.startLogicalBlock("(", false, ")");
        Special prevMode = null;
        int i = 0;
        int opt_i = 0;
        int key_args = this.keywords == null ? 0 : this.keywords.length;
        int opt_args = this.defaultArgs == null ? 0 : this.defaultArgs.length - key_args;
        Declaration decl = this.firstDecl();
        if (decl != null && decl.isThisParameter()) {
            i = -1;
        }
        while (decl != null) {
            Special mode = i < this.min_args ? null : (i < this.min_args + opt_args ? Special.optional : (this.max_args < 0 && i == this.min_args + opt_args ? Special.rest : Special.key));
            if (decl != this.firstDecl()) {
                out.writeSpaceFill();
            }
            if (mode != prevMode) {
                out.print(mode);
                out.writeSpaceFill();
            }
            Expression defaultArg = null;
            if (mode == Special.optional || mode == Special.key) {
                defaultArg = this.defaultArgs[opt_i++];
            }
            if (defaultArg != null) {
                out.print('(');
            }
            decl.printInfo(out);
            if (defaultArg != null && defaultArg != QuoteExp.falseExp) {
                out.print(' ');
                defaultArg.print(out);
                out.print(')');
            }
            ++i;
            prevMode = mode;
            decl = decl.nextDecl();
        }
        out.endLogicalBlock(")");
        out.writeSpaceLinear();
        if (this.body == null) {
            out.print("<null body>");
        } else {
            this.body.print(out);
        }
        out.endLogicalBlock(")");
    }

    protected final String getExpClassName() {
        String cname = this.getClass().getName();
        int index = cname.lastIndexOf(46);
        if (index >= 0) {
            cname = cname.substring(index + 1);
        }
        return cname;
    }

    public boolean side_effects() {
        return false;
    }

    public String toString() {
        String str = this.getExpClassName() + ':' + this.getSymbol() + '/' + this.id + '/';
        int l = this.getLineNumber();
        if (l <= 0 && this.body != null) {
            l = this.body.getLineNumber();
        }
        if (l > 0) {
            str = str + "l:" + l;
        }
        return str;
    }

    public Object getProperty(Object key, Object defaultValue) {
        if (this.properties != null) {
            int i = this.properties.length;
            while ((i -= 2) >= 0) {
                if (this.properties[i] != key) continue;
                return this.properties[i + 1];
            }
        }
        return defaultValue;
    }

    public synchronized void setProperty(Object key, Object value) {
        this.properties = PropertySet.setProperty(this.properties, key, value);
    }

    public final Type getReturnType() {
        if (this.returnType == null) {
            this.returnType = Type.objectType;
            if (this.body != null && !this.isAbstract()) {
                this.returnType = this.body.getType();
            }
        }
        return this.returnType;
    }

    public final void setReturnType(Type returnType) {
        this.returnType = returnType;
    }

    public final void setCoercedReturnType(Type returnType) {
        this.returnType = returnType;
        if (returnType != null && returnType != Type.objectType && returnType != Type.voidType && this.body != QuoteExp.abstractExp) {
            Expression value = this.body;
            this.body = Compilation.makeCoercion(value, returnType);
            this.body.setLine(value);
        }
    }

    public final void setCoercedReturnValue(Expression type, Language language) {
        Type rtype;
        if (!this.isAbstract()) {
            Expression value = this.body;
            this.body = Compilation.makeCoercion(value, type);
            this.body.setLine(value);
        }
        if ((rtype = language.getTypeFor(type)) != null) {
            this.setReturnType(rtype);
        }
    }
}

