/* 
 *    Programmed By: Mohammed Isam Mohammed [mohammed_isam1984@yahoo.com]
 *    Copyright 2018, 2024 (c)
 * 
 *    file: module_c.c
 *    This file is part of mino.
 *
 *    mino is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    (at your option) any later version.
 *
 *    mino is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with mino.  If not, see <http://www.gnu.org/licenses/>.
 */    
#include "modules.h"

char *ext_c[] = { "c", "h" };
wchar_t *keyword_c[] = {
      //basic C language keywords
      L"auto",
      L"break",
      L"case",
      L"char",
      L"const",
      L"continue",
      L"default",
      L"do",
      L"double",
      L"else",
      L"enum",
      L"extern",
      L"float",
      L"for",
      L"goto",
      L"if",
      L"int",
      L"long",
      L"register",
      L"return",
      L"short",
      L"signed",
      L"sizeof",
      L"static",
      L"struct",
      L"switch",
      L"typedef",
      L"union",
      L"unsigned",
      L"void",
      L"volatile",
      L"while",
      //math function names
      L"acos",
      L"asin",
      L"atan",
      L"atan2",
      L"cos",
      L"cosh",
      L"sin",
      L"sinh",
      L"tan",
      L"tanh",
      L"exp",
      L"frexp",
      L"ldexp",
      L"log",
      L"log10",
      L"modf",
      L"pow",
      L"sqrt",
      L"ceil",
      L"fabs",
      L"floor",
      L"fmod",
      //file function names
      L"clearerr",
      L"fclose",
      L"feof",
      L"ferror",
      L"fflush",
      L"fgetpos",
      L"fopen",
      L"fread",
      L"freopen",
      L"fseek",
      L"fsetpos",
      L"ftell",
      L"fwrite",
      L"remove",
      L"rename",
      L"rewind",
      L"setbuf",
      L"setvbuf",
      L"tmpfile",
      L"tmpnam",
      //printf function names
      L"fprintf",
      L"printf",
      L"sprintf",
      L"vfprintf",
      L"vprintf",
      L"vsprintf",
      L"fscanf",
      L"scanf",
      L"sscanf",
      L"fgetc",
      L"fgets",
      L"fputc",
      L"fputs",
      L"getc",
      L"getchar",
      L"gets",
      L"putc",
      L"putchar",
      L"puts",
      L"ungetc",
      L"perror",
      //stdlib function names
      L"atof",
      L"atoi",
      L"atol",
      L"strtod",
      L"strtol",
      L"strtoul",
      L"calloc",
      L"free",
      L"malloc",
      L"realloc",
      L"abort",
      L"atexit",
      L"exit",
      L"getenv",
      L"system",
      L"bsearch",
      L"qsort",
      L"abs",
      L"div",
      L"labs",
      L"ldiv",
      L"rand",
      L"srand",
      L"mblen",
      L"mbstowcs",
      L"mbtowc",
      L"wcstombs",
      L"wctomb",
      //string function names
      L"memchr",
      L"memcmp",
      L"memcpy",
      L"memmove",
      L"memset",
      L"strcat",
      L"strncat",
      L"strchr",
      L"strcmp",
      L"strcoll",
      L"strcpy",
      L"strncpy",
      L"strcspn",
      L"strerror",
      L"strlen",
      L"strpbrk",
      L"strrchr",
      L"strspn",
      L"strstr",
      L"strtok",
      L"strxfrm",
      //time function names
      L"asctime",
      L"clock",
      L"ctime",
      L"difftime",
      L"gmtime",
      L"localtime",
      L"mktime",
      L"strftime",
      L"time",
      ////////
      L"stdin",
      L"stdout",
      L"stderr",
};

struct modulestruct module_c =
{
    .extsCount      = 2,
    .exts           = ext_c,
    .keywordCount   = 156,
    .keywords       = keyword_c,
    .mlCommentStart = L"/*",
    .mlCommentEnd   = L"*/",
    .slCommentStart = L"//",
    .caseSensitive  = 1,
};

