/* 
 *    Programmed By: Mohammed Isam Mohammed [mohammed_isam1984@yahoo.com]
 *    Copyright 2018, 2024 (c)
 * 
 *    file: module_f77.c
 *    This file is part of mino.
 *
 *    mino is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    (at your option) any later version.
 *
 *    mino is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with mino.  If not, see <http://www.gnu.org/licenses/>.
 */    
#include "modules.h"

char *ext_f77[] = { "f", "for", "F", "FOR" };
wchar_t *keyword_f77[] = {
      //FORTRAN 77 4.0 language keywords
      L"accept",
      L"assignment",
      L"assign",
      L"automatic",
      L"backspace",
      L"block",
      L"data",
      L"byte",
      L"call",
      L"character",
      L"close",
      L"common",
      L"complex",
      L"continue",
      L"decode",
      L"dimension",
      L"double",
      L"do",
      L"else",
      L"encode",
      L"endfile",
      L"end",
      L"entry",
      L"if",
      L"map",
      L"structure",
      L"union",
      L"equivalence",
      L"external",
      L"format",
      L"function",
      L"go",
      L"to",
      L"then",
      L"implicit",
      L"include",
      L"inquire",
      L"integer",
      L"intrinsic",
      L"logical",
      L"namelist",
      L"open",
      L"options",
      L"parameter",
      L"pause",
      L"pointer",
      L"pragma",
      L"program",
      L"print",
      L"read",
      L"real",
      L"record",
      L"return",
      L"rewind",
      L"save",
      L"static",
      L"stop",
      L"structure",
      L"subroutine",
      L"type",
      L"union",
      L"virtual",
      L"volatile",
      L"write",
      L"precision",
      L"file",
      L"abort",
      L"access",
      L"alarm",
      L"bit",
      L"and",
      L"or",
      L"setbit",
      L"xor",
      L"not",
      L"rshift",
      L"lshift",
      L"bic",
      L"bis",
      L"chdir",
      L"chmod",
      L"date",
      L"dtime",
      L"etime",
      L"exit",
      L"f77_floatingpoint",
      L"f77_ieee_environment",
      L"fdate",
      L"flush",
      L"fork",
      L"free",
      L"fseek",
      L"ftell",
      L"getarg",
      L"iargc",
      L"getcwd",
      L"fgetc",
      L"getc",
      L"getenv",
      L"getfd",
      L"getfile",
      L"getlog",
      L"getpid",
      L"getuid",
      L"getgid",
      L"hostnm",
      L"idate",
      L"itime",
      L"index",
      L"rindex",
      L"lnblnk",
      L"len",
      L"inmax",
      L"ioinit",
      L"kill",
      L"libm_double",
      L"libm_quadruple",
      L"libm_single",
      L"link",
      L"symlnk",
      L"loc",
      L"long",
      L"short",
      L"longjmp",
      L"isetjmp",
      L"malloc",
      L"mvbits",
      L"perror",
      L"gerror",
      L"ierrno",
      L"putc",
      L"fputc",
      L"qsort",
      L"drand",
      L"irand",
      L"rand",
      L"rename",
      L"secnds",
      L"sh",
      L"signal",
      L"sleep",
      L"fstat",
      L"lstat",
      L"stat",
      L"system",
      L"ctime",
      L"ltime",
      L"gmtime",
      L"time",
      L"topen",
      L"tclose",
      L"twrite",
      L"tread",
      L"trewin",
      L"tskipf",
      L"tstate",
      L"ttynam",
      L"isatty",
      L"unlink",
      L"wait",
};

struct modulestruct module_f77 =
{
    .extsCount      = 4,
    .exts           = ext_f77,
    .keywordCount   = 160,
    .keywords       = keyword_f77,
    .mlCommentStart = NULL,
    .mlCommentEnd   = NULL,
    .slCommentStart = L"C",     /* TODO: we should support all F77 comments, i.e. lines 
                                 *       starting with a, c, C, *, d, D, and ! are all
                                 *       comments.
                                 */
    .caseSensitive  = 1,
};

