/*

    A little library to do matrix arithmetic 
    Copyright (C) 1998  John Darrington

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
*/
static const char RCSID[]="$Id: txfm.c,v 1.1 2003/07/10 10:30:06 jmd Exp $";

#include <stdio.h>
#include "txfm.h"
#include <assert.h>

/* print out the location of a point.  For debug only */
void
plot( point p)
{
	int i;

	for( i=0; i < MATRIX_DIM; i++) {
		printf("%f\t", p[i] );
	}
	putchar('\n');
}





/* Pre-multiply a point or vector x, by matrix M */
void 
transform( const Matrix M, pv  x)
{
	int i,j;

	/* Temporary point variable for result */
	pv q={0,0,0,0};
	

	/* for each row */
	for(i=0;i < MATRIX_DIM; i++) {
		/* for each column */
		for ( j=0; j < MATRIX_DIM; j++)
			 q[i] += M[i+MATRIX_DIM*j] * x[j] ;
	}

	/* Now copy  q into x */
	for(i=0;i < MATRIX_DIM; i++)
		x[i]=q[i];
	
}



/* print a matrix on the stdout.  For debugging */
void 
showMatrix(const Matrix M)
{
	int i,j;

	/* for each row */
	for( i=0; i < MATRIX_DIM; i++) {
		/* for each column */
		for ( j=0; j<MATRIX_DIM; j++) {
			printf("%f\t",(float) M[i+(MATRIX_DIM*j)] );
		}
		putchar('\n');
	}
}




/* Pre-multiply a matrix N, by matrix M */
void 
pre_mult( const Matrix M, Matrix N)
{
	int i,j;
	int k;

	/* Temporary Matrix variable for result */
	Matrix T = {
		0,0,0,0,
		0,0,0,0,
		0,0,0,0,
		0,0,0,0
	};

	

	for(k=0;k < MATRIX_DIM ; k++) {
		for(i=0;i < MATRIX_DIM ; i++) {
			for ( j=0; j < MATRIX_DIM; j++) {
				 T[i+k*MATRIX_DIM] += 
					M[i+MATRIX_DIM*j] * N[j+MATRIX_DIM*k];
			}
		}
	}

	/* Now copy  T into N */
	for(i=0;i < MATRIX_DIM * MATRIX_DIM; i++)
		N[i]=T[i];
	
}



/* Set matrix element x,y to value */
void
set(Matrix M, int x, int y, float value)
{
  assert(x <= MATRIX_DIM);
  assert(y <= MATRIX_DIM);

  M[x + MATRIX_DIM * y ] = value;

}

/* Create a vector by taking the difference of 2 points */
void
vector_from_points(point p1, point p2, vector v)
{
  int i;

  for(i = 0 ; i < MATRIX_DIM ; ++i ) 
    v[i] = p2[i] - p1[i];

  assert(v[MATRIX_DIM-1] == 0.0);
}
