/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database;

import com.sun.electric.database.ImmutableCell;
import com.sun.electric.database.ImmutableNodeInst;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.text.Name;
import java.util.ConcurrentModificationException;
import java.util.HashSet;

public class Snapshot {
    private final ImmutableCell[] cells;
    private static final ImmutableCell[] NULL_CELLS;
    public static final Snapshot EMPTY;
    static final /* synthetic */ boolean $assertionsDisabled;

    Snapshot(ImmutableCell[] cells) {
        this.cells = cells;
        this.check();
    }

    public int maxCellId() {
        return this.cells.length - 1;
    }

    public ImmutableCell getCellById(int cellId) {
        return cellId < this.cells.length ? this.cells[cellId] : null;
    }

    private ImmutableCell getCellByIdSurely(int cellId) {
        ImmutableCell cell = this.cells[cellId];
        if (cell == null) {
            throw new ArrayIndexOutOfBoundsException(cellId);
        }
        return cell;
    }

    public int findCellId(String name) {
        if (name != null) {
            for (int i = 0; i < this.cells.length; ++i) {
                ImmutableCell cell = this.cells[i];
                if (cell == null || !cell.name.equals(name)) continue;
                return i;
            }
        }
        return -1;
    }

    public static Snapshot newInstance(ImmutableCell[] cells) {
        ImmutableCell[] newCells = Snapshot.clone(cells, NULL_CELLS);
        Snapshot.checkNames(newCells);
        Snapshot.checkProto(newCells);
        return new Snapshot(newCells);
    }

    public Snapshot withCells(ImmutableCell[] cells) {
        ImmutableCell[] newCells = Snapshot.clone(cells, this.cells);
        if (newCells == this.cells) {
            return this;
        }
        boolean checkNames = false;
        boolean checkProtos = false;
        for (int i = 0; i < newCells.length; ++i) {
            ImmutableCell newCell;
            ImmutableCell oldCell = this.getCellById(i);
            if (oldCell == (newCell = newCells[i])) continue;
            boolean checkProto = false;
            if (oldCell == null) {
                checkNames = true;
                checkProto = true;
            } else if (newCell == null) {
                checkProtos = true;
            } else {
                if (!newCell.name.equals(oldCell.name)) {
                    checkNames = true;
                }
                if (newCell.nodes != oldCell.nodes) {
                    checkProto = true;
                }
            }
            if (!checkProto || checkProtos) continue;
            newCell.checkProto(newCells);
        }
        if (checkNames) {
            Snapshot.checkNames(newCells);
        }
        if (checkProtos) {
            Snapshot.checkProto(newCells);
        }
        return new Snapshot(newCells);
    }

    public Snapshot withCell(int cellId, ImmutableCell cell) {
        ImmutableCell oldCell = this.getCellById(cellId);
        if (cell == oldCell) {
            return this;
        }
        int length = this.cells.length;
        boolean checkName = false;
        boolean checkProtos = false;
        boolean checkProto = false;
        if (oldCell == null) {
            checkName = true;
            checkProto = true;
            if (cellId >= length) {
                length = cellId + 1;
            }
        } else if (cell == null) {
            checkProtos = true;
            if (cellId == length - 1) {
                while (--length > 0 && this.cells[length - 1] == null) {
                }
            }
        } else {
            if (!cell.name.equals(oldCell.name)) {
                checkName = true;
            }
            if (cell.nodes != oldCell.nodes) {
                checkProto = true;
            }
        }
        if (checkName && this.findCellId(cell.name) >= 0) {
            throw new IllegalArgumentException("cell " + cell.name + " exists");
        }
        ImmutableCell[] newCells = new ImmutableCell[length];
        System.arraycopy(this.cells, 0, newCells, 0, Math.min(this.cells.length, length));
        if (cellId < length) {
            newCells[cellId] = cell;
        }
        if (checkProtos) {
            Snapshot.checkProto(newCells);
        } else if (checkProto) {
            cell.checkProto(newCells);
        }
        return new Snapshot(newCells);
    }

    public Snapshot withCellName(int cellId, String name) {
        return this.withCell(cellId, this.getCellByIdSurely(cellId).withName(name));
    }

    public Snapshot withNode(int cellId, int nodeId, ImmutableNodeInst node) {
        return this.withCell(cellId, this.getCellByIdSurely(cellId).withNode(nodeId, node));
    }

    public Snapshot withNodeProto(int cellId, int nodeId, int protoId) {
        return this.withCell(cellId, this.getCellByIdSurely(cellId).withNodeProto(nodeId, protoId));
    }

    public Snapshot withNodeName(int cellId, int nodeId, Name name) {
        return this.withCell(cellId, this.getCellByIdSurely(cellId).withNodeName(nodeId, name));
    }

    public Snapshot withNodeAnchor(int cellId, int nodeId, EPoint anchor) {
        return this.withCell(cellId, this.getCellByIdSurely(cellId).withNodeAnchor(nodeId, anchor));
    }

    private static ImmutableCell[] clone(ImmutableCell[] cells, ImmutableCell[] oldCells) {
        ImmutableCell[] newCells = NULL_CELLS;
        if (cells != null) {
            int length;
            for (length = cells.length; length > 0 && cells[length - 1] == null; --length) {
            }
            if (length == oldCells.length) {
                int i;
                for (i = length - 1; i >= 0 && cells[i] == oldCells[i]; --i) {
                }
                if (i < 0) {
                    return oldCells;
                }
            }
            if (length > 0) {
                newCells = new ImmutableCell[length];
                System.arraycopy(cells, 0, newCells, 0, length);
                if (newCells[length - 1] == null) {
                    throw new ConcurrentModificationException();
                }
            }
        }
        return newCells;
    }

    public void check() {
        if (!$assertionsDisabled && this.cells == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.cells.length != 0 && this.cells[this.cells.length - 1] == null) {
            throw new AssertionError();
        }
        for (int i = 0; i < this.cells.length; ++i) {
            ImmutableCell cell = this.cells[i];
            if (cell == null) continue;
            cell.check();
        }
        Snapshot.checkNames(this.cells);
        Snapshot.checkProto(this.cells);
    }

    private static void checkNames(ImmutableCell[] cells) {
        HashSet<String> names = new HashSet<String>();
        for (int i = 0; i < cells.length; ++i) {
            ImmutableCell cell = cells[i];
            if (cell == null) continue;
            if (names.contains(cell.name)) {
                throw new IllegalArgumentException("Duplicate cell " + cell.name);
            }
            names.add(cell.name);
        }
    }

    private static void checkProto(ImmutableCell[] cells) {
        for (int i = 0; i < cells.length; ++i) {
            ImmutableCell cell = cells[i];
            if (cell == null) continue;
            cell.checkProto(cells);
        }
    }

    static {
        $assertionsDisabled = !Snapshot.class.desiredAssertionStatus();
        NULL_CELLS = new ImmutableCell[0];
        EMPTY = new Snapshot(NULL_CELLS);
    }
}

