/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree.tiny;

import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.om.AtomicSequence;
import net.sf.saxon.om.CopyOptions;
import net.sf.saxon.om.NameOfNode;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.tiny.TinyNodeImpl;
import net.sf.saxon.tree.tiny.TinyTree;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;

public final class TinyAttributeImpl
extends TinyNodeImpl {
    public TinyAttributeImpl(TinyTree tree, int nodeNr) {
        this.tree = tree;
        this.nodeNr = nodeNr;
    }

    public void setSystemId(String uri) {
    }

    public NodeInfo getParent() {
        return this.tree.getNode(this.tree.attParent[this.nodeNr]);
    }

    public NodeInfo getRoot() {
        NodeInfo parent = this.getParent();
        if (parent == null) {
            return this;
        }
        return parent.getRoot();
    }

    protected long getSequenceNumber() {
        return ((TinyNodeImpl)this.getParent()).getSequenceNumber() + 32768L + (long)(this.nodeNr - this.tree.alpha[this.tree.attParent[this.nodeNr]]);
    }

    public final int getNodeKind() {
        return 2;
    }

    public CharSequence getStringValueCS() {
        return this.tree.attValue[this.nodeNr];
    }

    public String getStringValue() {
        return this.tree.attValue[this.nodeNr].toString();
    }

    public int getFingerprint() {
        return this.tree.attCode[this.nodeNr] & 0xFFFFF;
    }

    public int getNameCode() {
        return this.tree.attCode[this.nodeNr];
    }

    public String getPrefix() {
        int code = this.tree.attCode[this.nodeNr];
        if (!NamePool.isPrefixed(code)) {
            return "";
        }
        return this.tree.prefixPool.getPrefix(code >> 20);
    }

    public String getDisplayName() {
        int code = this.tree.attCode[this.nodeNr];
        if (code < 0) {
            return "";
        }
        if (NamePool.isPrefixed(code)) {
            return this.getPrefix() + ":" + this.getLocalPart();
        }
        return this.getLocalPart();
    }

    public String getLocalPart() {
        return this.tree.getNamePool().getLocalName(this.tree.attCode[this.nodeNr]);
    }

    public final String getURI() {
        return this.tree.getNamePool().getURI(this.tree.attCode[this.nodeNr]);
    }

    public SchemaType getSchemaType() {
        if (this.tree.attType == null) {
            return BuiltInAtomicType.UNTYPED_ATOMIC;
        }
        return this.tree.getAttributeType(this.nodeNr);
    }

    public AtomicSequence atomize() throws XPathException {
        return this.tree.getTypedValueOfAttribute(this, this.nodeNr);
    }

    public void generateId(FastStringBuffer buffer) {
        this.getParent().generateId(buffer);
        buffer.append("a");
        buffer.append(Integer.toString(this.tree.attCode[this.nodeNr]));
    }

    public void copy(Receiver out, int copyOptions, Location locationId) throws XPathException {
        BuiltInAtomicType typeCode = CopyOptions.includes(copyOptions, 4) ? (SimpleType)this.getSchemaType() : BuiltInAtomicType.UNTYPED_ATOMIC;
        out.attribute(NameOfNode.makeName(this), typeCode, this.getStringValue(), locationId, 0);
    }

    public int getLineNumber() {
        return this.getParent().getLineNumber();
    }

    public int getColumnNumber() {
        return this.getParent().getColumnNumber();
    }

    public boolean isNilled() {
        return false;
    }

    public boolean isId() {
        return this.tree.isIdAttribute(this.nodeNr);
    }

    public boolean isIdref() {
        return this.tree.isIdrefAttribute(this.nodeNr);
    }

    public boolean isDefaultedAttribute() {
        return this.tree.isDefaultedAttribute(this.nodeNr);
    }

    public int hashCode() {
        return (int)(this.tree.getDocumentNumber() & 0x3FFL) << 20 ^ this.nodeNr ^ 0xE0000;
    }
}

