/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.instruct.NextMatch;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.style.Compilation;
import net.sf.saxon.style.ComponentDeclaration;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.XSLFallback;
import net.sf.saxon.style.XSLWithParam;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.value.Whitespace;

public class XSLNextMatch
extends StyleElement {
    private boolean useTailRecursion = false;

    public boolean isInstruction() {
        return true;
    }

    public boolean mayContainFallback() {
        return true;
    }

    public void prepareAttributes() throws XPathException {
        AttributeCollection atts = this.getAttributeList();
        for (int a = 0; a < atts.getLength(); ++a) {
            this.checkUnknownAttribute(atts.getNodeName(a));
        }
    }

    public void validate(ComponentDeclaration decl) throws XPathException {
        NodeInfo child;
        AxisIterator kids = this.iterateAxis((byte)3);
        while ((child = kids.next()) != null) {
            if (child instanceof XSLWithParam || child instanceof XSLFallback) continue;
            if (child.getNodeKind() == 3) {
                if (Whitespace.isWhite(child.getStringValueCS())) continue;
                this.compileError("No character data is allowed within xsl:next-match", "XTSE0010");
                continue;
            }
            this.compileError("Child element " + child.getDisplayName() + " is not allowed as a child of xsl:next-match", "XTSE0010");
        }
    }

    protected boolean markTailCalls() {
        this.useTailRecursion = true;
        return true;
    }

    public Expression compile(Compilation exec, ComponentDeclaration decl) throws XPathException {
        NextMatch inst = new NextMatch(this.useTailRecursion);
        inst.setLocation(this.allocateLocation());
        inst.setActualParams(this.getWithParamInstructions(inst, exec, decl, false));
        inst.setTunnelParams(this.getWithParamInstructions(inst, exec, decl, true));
        return inst;
    }
}

