/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.instruct.CopyOf;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.style.Compilation;
import net.sf.saxon.style.ComponentDeclaration;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.value.Whitespace;

public final class XSLCopyOf
extends StyleElement {
    private Expression select;
    private boolean copyNamespaces;
    private boolean copyAccumulators;
    private int validation = 3;
    private SchemaType schemaType;

    public boolean isInstruction() {
        return true;
    }

    public void prepareAttributes() throws XPathException {
        AttributeCollection atts = this.getAttributeList();
        String selectAtt = null;
        String copyNamespacesAtt = null;
        String copyAccumulatorsAtt = null;
        String validationAtt = null;
        String typeAtt = null;
        for (int a = 0; a < atts.getLength(); ++a) {
            String f = atts.getQName(a);
            if (f.equals("select")) {
                selectAtt = atts.getValue(a);
                this.select = this.makeExpression(selectAtt, a);
                continue;
            }
            if (f.equals("copy-namespaces")) {
                copyNamespacesAtt = Whitespace.trim(atts.getValue(a));
                continue;
            }
            if (f.equals("copy-accumulators")) {
                copyAccumulatorsAtt = Whitespace.trim(atts.getValue(a));
                continue;
            }
            if (f.equals("validation")) {
                validationAtt = Whitespace.trim(atts.getValue(a));
                continue;
            }
            if (f.equals("type")) {
                typeAtt = Whitespace.trim(atts.getValue(a));
                continue;
            }
            if (atts.getLocalName(a).equals("read-once") && atts.getURI(a).equals("http://saxon.sf.net/")) {
                this.compileError("The saxon:read-once attribute is no longer available - use xsl:stream");
                continue;
            }
            this.checkUnknownAttribute(atts.getNodeName(a));
        }
        if (selectAtt == null) {
            this.reportAbsence("select");
        }
        if (copyAccumulatorsAtt == null) {
            this.copyAccumulators = false;
        } else {
            this.copyAccumulators = this.processBooleanAttribute("copy-accumulators", copyAccumulatorsAtt);
            if (this.copyAccumulators && this.isConstructingComplexContent()) {
                this.compileWarning("Copying accumulators is pointless when the copied element is immediately attached to a new parent, since that action will lose the accumulator values", "SXWN9017");
                this.copyAccumulators = false;
            }
        }
        this.copyNamespaces = copyNamespacesAtt == null ? true : this.processBooleanAttribute("copy-namespaces", copyNamespacesAtt);
        this.validation = validationAtt != null ? this.validateValidationAttribute(validationAtt) : this.getDefaultValidation();
        if (typeAtt != null) {
            this.schemaType = this.getSchemaType(typeAtt);
            if (!this.isSchemaAware()) {
                this.compileError("The @type attribute is available only with a schema-aware XSLT processor", "XTSE1660");
            }
            this.validation = 8;
        }
        if (typeAtt != null && validationAtt != null) {
            this.compileError("The @validation and @type attributes are mutually exclusive", "XTSE1505");
        }
    }

    public void validate(ComponentDeclaration decl) throws XPathException {
        this.checkEmpty();
        this.select = this.typeCheck("select", this.select);
    }

    public Expression compile(Compilation exec, ComponentDeclaration decl) {
        CopyOf inst = new CopyOf(this.select, this.copyNamespaces, this.validation, this.schemaType, false);
        inst.setCopyAccumulators(this.copyAccumulators);
        inst.setCopyLineNumbers(exec.getConfiguration().isLineNumbering());
        inst.setSchemaAware(exec.isSchemaAware());
        return inst;
    }
}

