/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.pattern;

import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.UType;

public class DocumentNodeTest
extends NodeTest {
    private NodeTest elementTest;

    public DocumentNodeTest(NodeTest elementTest) {
        this.elementTest = elementTest;
    }

    public UType getUType() {
        return UType.DOCUMENT;
    }

    public boolean matches(int nodeKind, NodeName name, SchemaType annotation) {
        throw new UnsupportedOperationException("DocumentNodeTest doesn't support this method");
    }

    public boolean matchesNode(NodeInfo node) {
        NodeInfo n;
        if (node.getNodeKind() != 9) {
            return false;
        }
        AxisIterator iter = node.iterateAxis((byte)3);
        boolean found = false;
        while ((n = iter.next()) != null) {
            int kind = n.getNodeKind();
            if (kind == 3) {
                return false;
            }
            if (kind != 1) continue;
            if (found) {
                return false;
            }
            if (this.elementTest.matchesNode(n)) {
                found = true;
                continue;
            }
            return false;
        }
        return found;
    }

    public final double getDefaultPriority() {
        return this.elementTest.getDefaultPriority();
    }

    public int getPrimitiveType() {
        return 9;
    }

    public int getNodeKindMask() {
        return 512;
    }

    public NodeTest getElementTest() {
        return this.elementTest;
    }

    public String toString() {
        return "document-node(" + this.elementTest.toString() + ')';
    }

    public int hashCode() {
        return this.elementTest.hashCode() ^ 0x3039;
    }

    public boolean equals(Object other) {
        return other instanceof DocumentNodeTest && ((DocumentNodeTest)other).elementTest.equals(this.elementTest);
    }

    public String generateJavaScriptItemTypeTest(ItemType knownToBe, int targetVersion) throws XPathException {
        String elTest = "function e(item) {" + this.elementTest.generateJavaScriptItemTypeTest(NodeKindTest.ELEMENT, targetVersion) + "};";
        if (targetVersion == 1) {
            return elTest + "return SaxonJS.U.isNode(item) && (item.nodeType===9 || item.nodeType===11) && " + "SaxonJS.U.Axis.child(item).filter(e).next();";
        }
        return elTest + "return SaxonJS.U.isConstrainedDocumentNode(item, e);";
    }
}

