########################################################################
# Verifies the %OEIS list
#   doesn't contribute to 100% coverage, because those rows are executed on
#   module load... just contributes to my peace of mind
########################################################################
use 5.006;
use strict;
use warnings;
use Test::More;

use Math::PRBS;

my @tests = (
    { taps => [ 2, 1 ]              , oeis => 'A011655' },
    { taps => [ 3, 2 ]              , oeis => 'A011656' },
    { taps => [ 3, 1 ]              , oeis => 'A011657' },
    { taps => [ 4, 3, 2, 1 ]        , oeis => 'A011658' },
    { taps => [ 4, 1 ]              , oeis => 'A011659' },
    { taps => [ 5, 4, 2, 1 ]        , oeis => 'A011660' },
    { taps => [ 5, 3, 2, 1 ]        , oeis => 'A011661' },
    { taps => [ 5, 2 ]              , oeis => 'A011662' },
    { taps => [ 5, 4, 3, 1 ]        , oeis => 'A011663' },
    { taps => [ 5, 3 ]              , oeis => 'A011664' },
    { taps => [ 5, 4, 3, 2 ]        , oeis => 'A011665' },
    { taps => [ 6, 5, 4, 1 ]        , oeis => 'A011666' },
    { taps => [ 6, 5, 3, 2 ]        , oeis => 'A011667' },
    { taps => [ 6, 5, 2, 1 ]        , oeis => 'A011668' },
    { taps => [ 6, 1 ]              , oeis => 'A011669' },
    { taps => [ 6, 4, 3, 1 ]        , oeis => 'A011670' },
    { taps => [ 6, 5, 4, 2 ]        , oeis => 'A011671' },
    { taps => [ 6, 3 ]              , oeis => 'A011672' },
    { taps => [ 6, 5 ]              , oeis => 'A011673' },
    { taps => [ 7, 6, 5, 4, 3, 2 ]  , oeis => 'A011674' },
    { taps => [ 7, 4 ]              , oeis => 'A011675' },
    { taps => [ 7, 6, 4, 2 ]        , oeis => 'A011676' },
    { taps => [ 7, 5, 2, 1 ]        , oeis => 'A011677' },
    { taps => [ 7, 5, 3, 1 ]        , oeis => 'A011678' },
    { taps => [ 7, 6, 4, 1 ]        , oeis => 'A011679' },
    { taps => [ 7, 6, 5, 4, 2, 1 ]  , oeis => 'A011680' },
    { taps => [ 7, 6, 5, 3, 2, 1 ]  , oeis => 'A011681' },
    { taps => [ 7, 1 ]              , oeis => 'A011682' },
    { taps => [ 7, 5, 4, 3, 2, 1 ]  , oeis => 'A011683' },
    { taps => [ 7, 4, 3, 2 ]        , oeis => 'A011684' },
    { taps => [ 7, 6, 3, 1 ]        , oeis => 'A011685' },
    { taps => [ 7, 6 ]              , oeis => 'A011686' },
    { taps => [ 7, 6, 5, 4 ]        , oeis => 'A011687' },
    { taps => [ 7, 5, 4, 3 ]        , oeis => 'A011688' },
    { taps => [ 7, 3, 2, 1 ]        , oeis => 'A011689' },
    { taps => [ 7, 3 ]              , oeis => 'A011690' },
    { taps => [ 7, 6, 5, 2 ]        , oeis => 'A011691' },
    { taps => [ 8, 6, 4, 3, 2, 1 ]  , oeis => 'A011692' },
    { taps => [ 8, 5, 4, 3 ]        , oeis => 'A011693' },
    { taps => [ 8, 7, 5, 3 ]        , oeis => 'A011694' },
    { taps => [ 8, 7, 6, 5, 4, 2 ]  , oeis => 'A011695' },
    { taps => [ 8, 7, 6, 5, 4, 3 ]  , oeis => 'A011696' },
    { taps => [ 8, 4, 3, 2 ]        , oeis => 'A011697' },
    { taps => [ 8, 6, 5, 4, 2, 1 ]  , oeis => 'A011698' },
    { taps => [ 8, 7, 5, 1 ]        , oeis => 'A011699' },
    { taps => [ 8, 7, 3, 1 ]        , oeis => 'A011700' },
    { taps => [ 8, 5, 4, 3, 2, 1 ]  , oeis => 'A011701' },
    { taps => [ 8, 7, 5, 4, 3, 2 ]  , oeis => 'A011702' },
    { taps => [ 8, 7, 6, 4, 3, 2 ]  , oeis => 'A011703' },
    { taps => [ 8, 6, 3, 2 ]        , oeis => 'A011704' },
    { taps => [ 8, 7, 3, 2 ]        , oeis => 'A011705' },
    { taps => [ 8, 6, 5, 2 ]        , oeis => 'A011706' },
    { taps => [ 8, 7, 6, 4, 2, 1 ]  , oeis => 'A011707' },
    { taps => [ 8, 7, 6, 3, 2, 1 ]  , oeis => 'A011708' },
    { taps => [ 8, 7, 2, 1 ]        , oeis => 'A011709' },
    { taps => [ 8, 7, 6, 1 ]        , oeis => 'A011710' },
    { taps => [ 8, 7, 6, 5, 2, 1 ]  , oeis => 'A011711' },
    { taps => [ 8, 7, 5, 4 ]        , oeis => 'A011712' },
    { taps => [ 8, 6, 5, 1 ]        , oeis => 'A011713' },
    { taps => [ 8, 4, 3, 1 ]        , oeis => 'A011714' },
    { taps => [ 8, 6, 5, 4 ]        , oeis => 'A011715' },
    { taps => [ 8, 7, 6, 5, 4, 1 ]  , oeis => 'A011716' },
    { taps => [ 8, 5, 3, 2 ]        , oeis => 'A011717' },
    { taps => [ 8, 6, 5, 4, 3, 1 ]  , oeis => 'A011718' },
    { taps => [ 8, 5, 3, 1 ]        , oeis => 'A011719' },
    { taps => [ 8, 7, 4, 3, 2, 1 ]  , oeis => 'A011720' },
    { taps => [ 8, 6, 5, 3 ]        , oeis => 'A011721' },
    { taps => [ 9, 4 ]              , oeis => 'A011722' },
    { taps => [ 10, 3 ]             , oeis => 'A011723' },
    { taps => [ 11, 2 ]             , oeis => 'A011724' },
    { taps => [ 12, 7, 4, 3 ]       , oeis => 'A011725' },
    { taps => [ 13, 4, 3, 1 ]       , oeis => 'A011726' },
    { taps => [ 14, 12, 11, 1 ]     , oeis => 'A011727' },
    { taps => [ 15, 1 ]             , oeis => 'A011728' },
    { taps => [ 16, 5, 3, 2 ]       , oeis => 'A011729' },
    { taps => [ 17, 3 ]             , oeis => 'A011730' },
    { taps => [ 18, 7 ]             , oeis => 'A011731' },
    { taps => [ 19, 6, 5, 1 ]       , oeis => 'A011732' },
    { taps => [ 20, 3 ]             , oeis => 'A011733' },
    { taps => [ 21, 2 ]             , oeis => 'A011734' },
    { taps => [ 22, 1 ]             , oeis => 'A011735' },
    { taps => [ 23, 5 ]             , oeis => 'A011736' },
    { taps => [ 24, 4, 3, 1 ]       , oeis => 'A011737' },
    { taps => [ 25, 3 ]             , oeis => 'A011738' },
    { taps => [ 26, 8, 7, 1 ]       , oeis => 'A011739' },
    { taps => [ 27, 8, 7, 1 ]       , oeis => 'A011740' },
    { taps => [ 28, 3 ]             , oeis => 'A011741' },
    { taps => [ 29, 2 ]             , oeis => 'A011742' },
    { taps => [ 30, 16, 15, 1 ]     , oeis => 'A011743' },
    { taps => [ 31, 3 ]             , oeis => 'A011744' },
    { taps => [ 32, 28, 27, 1 ]     , oeis => 'A011745' },
    # and test the four
    { taps => [ 7, 6 ]              , oeis => 'A011686' },
    { taps => [ 15, 14 ]            , oeis => undef },
    { taps => [ 23, 18 ]            , oeis => undef },
    { taps => [ 31, 28 ]            , oeis => undef },
);

foreach my $t ( @tests ) {
    my $seq = Math::PRBS->new( taps => $t->{taps} );
    is $seq->oeis_anum, $t->{oeis}, 'taps[' . join(',', @{$t->{taps}}) . ']->oeis_anum';
}

done_testing( scalar @tests );