/* -*- buffer-read-only: t -*-
 * !!!!!!!   DO NOT EDIT THIS FILE   !!!!!!!
 * This file is built by regen/mk_invlists.pl from mph.pl.
 * Any changes made here will be lost!
 */


#if defined(PERL_CORE) || defined(PERL_EXT_RE_BUILD)

#define MPH_VALt I16

/*
rows: 7264
seed: 1348825708
full length of keys: 101931
blob length: 10351
ref length: 58112
data size: 68463 (%67.17)
*/

STATIC const unsigned char mph_blob[] =
    "unifiedcanadianaboriginalsyllabicsextendedcjkcompatibilityideogra"
    "phssupplementarabicmathematicalalphabeticsymbolscombiningdiacriti"
    "calmarksforsymbolscombiningdiacriticalmarkssupplementmiscellaneou"
    "ssymbolsandpictographscombiningdiacriticalmarksextendedmiscellane"
    "ousmathematicalsymbolsamiscellaneousmathematicalsymbolsbsupplemen"
    "talmathematicaloperatorssupplementalsymbolsandpictographsegyptian"
    "hieroglyphformatcontrolsideographicdescriptioncharactersideograph"
    "icsymbolsandpunctuationmathematicalalphanumericsymbolscjkunifiedi"
    "deographsextensionacjkunifiedideographsextensionbcjkunifiedideogr"
    "aphsextensionccjkunifiedideographsextensiondcjkunifiedideographse"
    "xtensionecjkunifiedideographsextensionfcjkunifiedideographsextens"
    "iongcuneiformnumbersandpunctuationenclosedalphanumericsupplements"
    "ymbolsandpictographsextendedaenclosedideographicsupplementmiscell"
    "aneoussymbolsandarrowsphoneticextensionssupplementsupplementarypr"
    "ivateuseareaasupplementaryprivateuseareabvariationselectorssupple"
    "mentalphabeticpresentationformsancientgreekmusicalnotationenclose"
    "dcjklettersandmonthsopticalcharacterrecognitionprependedconcatena"
    "tionmark=changeswhennfkccasefolded=conditionaljapanesestarterdefa"
    "ultignorablecodepoint=halfwidthandfullwidthformskatakanaphonetice"
    "xtensionsconsonantinitialpostfixedfullcompositionexclusion=supers"
    "criptsandsubscriptssymbolsandpictographsextasymbolsforlegacycompu"
    "tingarabicpresentationformsaarabicpresentationformsbcanonicalcomb"
    "iningclass=cjksymbolsandpunctuationcombiningmarksforsymbolsconson"
    "antsucceedingrephahighprivateusesurrogatesindicpositionalcategory"
    "=supsymbolsandpictographsbyzantinemusicalsymbolsconsonantprecedin"
    "grephageometricshapesextendedhangulcompatibilityjamolatinextended"
    "additionalshorthandformatcontrolssupplementalpunctuationbidipaire"
    "dbrackettype=changeswhencasefolded=changeswhencasemapped=changesw"
    "henlowercased=changeswhentitlecased=changeswhenuppercased=cjkcomp"
    "atideographssupcommonindicnumberformsdiacriticalsforsymbolsearlyd"
    "ynasticcuneiformindicsyllabiccategory=logicalorderexception=misce"
    "llaneoustechnicalnoncharactercodepoint=spacingmodifierletterstran"
    "sportandmapsymbolscjkcompatibilityformscjkradicalssupplementcyril"
    "licsupplementaryextendedpictographic=graphemeclusterbreak=hanifir"
    "ohingyakinnayainscriptionalparthianmeeteimayekextensionspopdirect"
    "ionalisolatesinhalaarchaicnumbersyijinghexagramsymbolsanatolianhi"
    "eroglyphsconnectorpunctuationconsonantplaceholderconsonantwithsta"
    "ckerglagoliticsupplementinscriptionalpahlavilefttorightembeddingn"
    "yiakengpuachuehmongpopdirectionalformatrighttoleftembeddingtermin"
    "alpunctuation=topandbottomandrightverticalorientation=ancientgree"
    "knumbersbrahmijoiningnumberburushaskiyehbarreeconsonantheadletter"
    "countingrodnumeralsegyptianhieroglyphsenclosedalphanumsuphangulja"
    "moextendedahanguljamoextendedbhangulsyllabletype=idstrinaryoperat"
    "or=lefttorightoverridemeroitichieroglyphsmodifiertonelettersmongo"
    "liansupplementottomansiyaqnumbersrighttoleftoverridesundanesesupp"
    "lementsupplementalarrowsasupplementalarrowsbsupplementalarrowscto"
    "pandbottomandleftattachedaboverightcherokeesupplementcombininghal"
    "fmarksconsonantsubjoinedcopticepactnumbersdecompositiontype=devan"
    "agariextendedemojimodifierbase=emojipresentation=ethiopicsuppleme"
    "nteuropeanterminatorfirststrongisolategeneralpunctuationgeorgians"
    "upplementidsbinaryoperator=initialpunctuationlatinextadditionalle"
    "fttorightisolateornamentaldingbatsparagraphseparatorpatternwhites"
    "pace=regionalindicator=righttoleftisolateruminumeralsymbolssmallk"
    "anaextensiontaixuanjingsymbolstopandleftandrighttransformedrotate"
    "dtransformeduprightvariationselector=alchemicalsymbolsattachedbel"
    "owleftcanadiansyllabicscaucasianalbanianconsonantprefixedcyrillic"
    "extendedacyrillicextendedbcyrillicextendedcethiopicextendedaeurop"
    "eanseparatoridentifierstatus=indicsiyaqnumberskhitansmallscriptle"
    "tterlikesymbolsmanichaeandhamedhmanichaeanhundredmanichaeanthamed"
    "hscriptextensions=sentenceterminal=smallformvariantssuttonsignwri"
    "tingunifiedideograph=arabicsupplementbopomofoextendedcantillation"
    "markcloseparenthesisclosepunctuationcypriotsyllabaryfinalpunctuat"
    "iongeneralcategory=georgianextendedhalfandfullformshanifirohingya"
    "pahighpusurrogatesinvisiblestackerlatin1supplementlinearbideogram"
    "slinearbsyllabarymanichaeandalethmanichaeanlamedhmanichaeansamekh"
    "manichaeantwentymiscmathsymbolsamiscmathsymbolsbmyanmarextendedam"
    "yanmarextendedbotherpunctuationsegmentseparatorsupmathoperatorssy"
    "llablemodifiersyriacsupplementtangutcomponentstangutsupplementvow"
    "elindependentarabicextendedabamumsupplementboundaryneutralbraille"
    "patternscommonseparatorconsonantkillerconsonantmedialcontingentbr"
    "eakcontrolpicturescurrencysymbolsdashpunctuationdiacriticalsextdi"
    "acriticalssupeastasianwidth=emojicomponent=graphemeextend=hanguls"
    "yllablesidentifiertype=imperialaramaiclowercaselettermanichaeanal"
    "ephmanichaeangimelmanichaeansadhemanichaeanzayinmeroiticcursivemi"
    "scpictographsmodifyingletternfkcquickcheck=nfkdquickcheck=oldnort"
    "harabianoldsoutharabianopenpunctuationregistershiftertamilsupplem"
    "enttitlecaseletteruppercaselettervedicextensionsvisualorderleftza"
    "nabazarsquareancientsymbolsasciihexdigit=carriagereturncaseignora"
    "ble=cjkcompatformscomplexcontextconsonantfinalemojimodifier=europ"
    "eannumbergeminationmarkgreekandcoptichamzaonhehgoalhighsurrogates"
    "kanasupplementkangxiradicalslatinextendedblatinextendedclatinexte"
    "ndeddlatinextendedelisusupplementmandatorybreakmanichaeanayinmani"
    "chaeanbethmanichaeanfivemanichaeanhethmanichaeankaphmanichaeanqop"
    "hmanichaeanreshmanichaeantethmanichaeanyodhmodifiersymbolnfcquick"
    "check=nfdquickcheck=nojoininggroupnonspacingmarkpatternsyntax=pho"
    "neticextsuppostfixnumericpsalterpahlaviquotationmark=sentencebrea"
    "k=spaceseparatorsuppunctuationtehmarbutagoalvoweldependent1000000"
    "000000aegeannumbersbidimirrored=blockelementsconsonantdeaddecimal"
    "numberenclosingmarkgraphemebase=greekextendediotasubscriptipaexte"
    "nsionsjoininggroup=kanaextendedalineseparatorlowsurrogatesmalayal"
    "amlllamalayalamnnnamanichaeanmemmanichaeannunmanichaeanonemanicha"
    "eantawmanichaeantenmanichaeanwawmayannumeralsmisctechnicalnotappl"
    "icablenumericvalue=prefixnumericverticalformsalphabeticpfarabicle"
    "tterarabicnumberbidicontrol=breaksymbolschesssymbolscyrillicextac"
    "yrillicextbcyrillicextcethiopicextaextendnumletfinalsemkathglueaf"
    "terzwjgunjalagondihebrewletterideographic=infixnumericjoincontrol"
    "=joiningtype=khmersymbolsletternumbermahjongtilesmalayalambhamala"
    "yalamllamalayalamngamalayalamnnamalayalamnyamalayalamssamalayalam"
    "ttamanichaeanpemasaramgondimathalphanummendekikakuinoncanonicalno"
    "tcharacternotreorderednumberjoinernumerictype=oldhungarianotherne"
    "utralphaistosdiscplayingcardsrightjoiningtrailingjamoxidcontinue="
    "africannoonalphabetic=breakbeforecasedletterdeprecated=dominotile"
    "sdoubleabovedoublebelowdoublequotedualjoiningexclamationinseparab"
    "leinseperablejoincausingkanavoicingkatakanaextleadingjamoleftjoin"
    "inglvtsyllablemalayalamjamalayalamramedefaidrinmiscsymbolsmyanmar"
    "extamyanmarextbnandinagariotherletterothernumberothersymbolpahawh"
    "hmongrecommendedrohingyayehsinglequotesoftdotted=sorasompengstrai"
    "ghtwawsuperandsubsylotinagritopandrighttransparentuncommonuseyehw"
    "ithtailyisyllablesafricanfehafricanqafarabicextabasiclatinbelowri"
    "ghtbidiclass=boxdrawingbreakafterchorasmiancjkstrokescompatjamoda"
    "lathrishdiacritic=divesakuruhanreadingkharoshthiknottedhehlimited"
    "uselinebreak=lowercase=lvsyllablemiscarrowsnonjoiningnonstarterol"
    "dpersianoldsogdianoverstruckphoenicianpresentin=purekillerrestric"
    "tedreversedpesaurashtrasmallformssuparrowsasuparrowsbsuparrowscun"
    "assigneduppercase=warangcitiwordbreak=wordjoineryiradicals-5.00e-"
    "01aboveleftambiguousarabicpfaarabicpfbbhaiksukibreakbothemoticons"
    "extender=inclusioninheritedkhudawadilatinextblatinextclatinextdmi"
    "dlettermidnumletnabataeannewtailuenonjoinerolditalicoldpermicoldt"
    "urkicpalmyrenepaucinhausamaritanscontinuesyriacwawvoweljamowsegsp"
    "acexidstart=1.00e-011.11e-011.25e-011.25e-021.43e-011.50e+001.50e"
    "-011.56e-021.67e-011.88e-012.00e-012.50e+002.50e-012.50e-02200000"
    "003.12e-023.13e-023.13e-033.33e-013.50e+003.75e-013.75e-024.00e-0"
    "14.17e-014.50e+004.69e-025.00e-025.50e+005.83e-016.00e-016.25e-01"
    "6.25e-026.25e-036.50e+006.67e-017.50e+007.50e-018.00e-018.33e-018"
    ".33e-028.50e+008.75e-019.17e-01armenianavagrahabalinesebassavahbu"
    "gineseduployanebasegazextpict=farsiyehfractiongujaratigurmukhihir"
    "aganaisolatedjamoextajamoextbjavanesekanaextalinefeedmahajaninext"
    "lineobsoleteradical=specialsswashkaftagbanwatifinaghtonemarkugari"
    "ticaletterallowedavestanbengalicjkextacjkextbcjkextccjkextdcjkext"
    "ecjkextfcjkextgcompex=deseretelbasanelymaicgranthagrbase=hanunooh"
    "yphen=kannadakayahlilinearamakasarmandaicmarchenmultaninewlinenfk"
    "cqc=nfkdqc=noblocknobreaknotnfkcolchikioletterosmanyaoverlaypatsy"
    "n=phagspascript=sharadashaviansiddhamsoyombosuppuaasuppuabtagalog"
    "taithamtaiviettibetantirhutaucasextunknownvisargawspace=zwspace21"
    "6000300000400000432000500000600000700000800000900000alpha=bidic=b"
    "idim=block=carianccc103ccc107ccc118ccc122ccc129ccc130ccc132ccc133"
    "chakmacirclecwkcf=ecomp=emoji=epres=gothicgrext=hatranjoinc=kaith"
    "ikanbunkhojkilamadhlepchalower=lycianlydiannarrownchar=nfcqc=nfdq"
    "c=notxidpatws=qmark=rejangsterm=teluguthaanauideo=upper=viramawan"
    "choyezidiyudhhe1/1601/32011/12adlamahex=alaphatermbatakbindubuhid"
    "ccc14ccc15ccc16ccc17ccc18ccc19ccc20ccc21ccc22ccc23ccc24ccc25ccc26"
    "ccc27ccc28ccc29ccc30ccc31ccc32ccc33ccc34ccc35ccc36ccc84ccc91cntrl"
    "cwcf=cwcm=dash=dograemod=falseidsb=idst=inpc=insc=khaphlimbumath="
    "maybenuktanushuoghamoriyaosagerunictailetakrivssupxidc=xids=zhain"
    "-1/21/101/201/401/641/8010.011.011/212.113.013/215/217/23/163/203"
    "/643/805/127/12adlmage=aghbahomalefarmiarmnataratblavstbatkbhksbl"
    "k=bpt=buhdcakmcansccc=chrscprtcwl=cwt=cwu=cyrldep=dia=diakdsrtfon"
    "tgcb=gonggonmgrekgujrguruhanohluwhmnghmnphst=kalikhmrkitskndakthi"
    "lanalaoolatnlinalinbloe=medfmeemmercmiaomlymmroomteimymrnarbnbatn"
    "ewankoonshuogamolckorkhoryaosgepcm=phlpphnxplrdprtiqaacqaaiqaphrj"
    "ngrohgrunrsamrsarbscx=seensgnwshawshinshrdsogosyrctagstaletalutam"
    "ltavttfngtglgthaitibttruev100v110v120v121v130vaiiwchowidexpeoxsux"
    "yiiizainzanbzinhzyyyzzzz1/51/71/92/32/520221421822222422622823023"
    "22332342403.23/43/54/55.15.25/65/86.16.37.07/89.09/2bc=behci=di=d"
    "t=ea=ebgfsigafgc=jg=jt=lb=lrelrilromimnv=ocrpdfrehri=sd=smlsqrtah"
    "v20v21v30v31v32v40v41v50v51v52v60v61v62v63v70v80v90vo=vs=wb=yes38"
    "39444546474849b2bkh2h3jljvkvl&l_vrxxzlzpzs_perl_problematic_local"
    "e_foldeds_is_in_multi_char_fold_perl_folds_to_perl_charname_begin"
    "any_foldsquotemetaisxposixisposixblankprintishorizisxperlisperlis"
    "spaceisvertisuni";
/* mph_blob length: 10351 */

struct mph_struct {
    U16 seed2;
    U16 pfx;
    U16 sfx;
    U8  pfx_len;
    U8  sfx_len;
    MPH_VALt value;
};

#define MPH_RSHIFT 8
#define MPH_BUCKETS 7264

STATIC const U32 MPH_SEED1 = 0x5065726c;
STATIC const U32 MPH_FNV_CONST = 0x01000193;

/* The comments give the input key for the row it is in */
STATIC const struct mph_struct mph_table[MPH_BUCKETS] = {
  {     2,  9768,  9632,   4,   4, UNI_LINA }   /* scx=lina */,
  {     2,  5791,  6572,  13,   4, UNI_JG__NOON }   /* joininggroup=noon */,
  {     1,  7325,  9384,   3,   4, UNI_IN__10 }   /* in=10.0 */,
  {     2,  9488,  7188,   4,  10, UNI_INKHAROSHTHI }   /* blk=kharoshthi */,
  {     1,  1417,    23,  24,   2, UNI_CCC__AL }   /* canonicalcombiningclass=al */,
  {     0,   184,  2666,   3,  10, UNI_COUNTINGROD }   /* iscountingrod */,
  {     0,  1654,     0,  23,   0, UNI_COMPATJAMO }   /* hangulcompatibilityjamo */,
  {     8,  7158,  9836,  10,   4, UNI_DIA }   /* diacritic=true */,
  {     2,  8780,  8373,   7,   6, UNI_CJKEXTD }   /* block=cjkextd */,
  {     1,  5986,  9973,  13,   3, UNI_NV__5_SLASH_6 }   /* numericvalue=5/6 */,
  {     1, 10027,  6323,   3,   5, UNI_JG__GAMAL }   /* jg=gamal */,
  {     0,  8900,     0,   6,   0, UNI_KTHI }   /* kaithi */,
  {     6,  1537,  2455,  24,   5, UNI_INPC__RIGHT }   /* indicpositionalcategory=right */,
  {     0,  7398,     0,  10,   0, UNI_SUPARROWSC }   /* suparrowsc */,
  {     1,  9002,     0,   6,   0, UNI_TELU }   /* telugu */,
  {     4, 10024,  9503,   3,   2, UNI_MC }   /* gc=mc */,
  {     0,  7218,    18,  10,   2, UNI_RI }   /* linebreak=ri */,
  {     0,  1856,     0,  21,   0, UNI_CWU }   /* changeswhenuppercased */,
  {     1,  2779,     0,   3,   0, UNI_IDS }   /* ids */,
  {     8, 10048,  9061,   3,   4, UNI_NV__1_SLASH_12 }   /* nv=1/12 */,
  {     0, 10006, 10135,   3,   3, UNI_DI }   /* di=yes */,
  {     0,  8780,  5947,   6,  13, UNI_MAYANNUMERALS }   /* block=mayannumerals */,
  {     1,  9444, 10108,   4,   3, UNI_AGE__6_DOT_1 }   /* age=v61 */,
  {     0,  5186,     0,  14,   0, UNI_HIGHSURROGATES }   /* highsurrogates */,
  {     0, 10333,  1528,   3,   8, UNI__PERL_SURROGATE }   /* issurrogate */,
  {     1,  7739,     3,   8,   1, -UNI_IDS }   /* idstart=f */,
  {     0,   184,  6840,   2,  11, UNI_NAND }   /* isnandinagari */,
  {     0,   446,     0,  32,   0, UNI_IDEOGRAPHICSYMBOLS }   /* ideographicsymbolsandpunctuation */,
  {     4,  9448,     0,   4,   0, UNI_AGHB }   /* aghb */,
  {     3,  3836,  9712,  17,   4, UNI_OSGE }   /* scriptextensions=osge */,
  {     0,  9270,  7685,   3,   8, UNI_INPAUCINHAU }   /* inpaucinhau */,
  {     0, 10048,  9055,   3,   3, UNI_NV__1_SLASH_3 }   /* nv=1/3 */,
  {     7,  1834, 10135,  22,   3, UNI_CWT }   /* changeswhentitlecased=yes */,
  {     1,  9768,  8414,   4,   7, UNI_ELBA }   /* scx=elbasan */,
  {     4,  8780,  1673,   6,   4, UNI_JAMO }   /* block=jamo */,
  {     0,  8688,  5662,   3,  12, UNI_AEGEANNUMBERS }   /* isaegeannumbers */,
  {     0,  1552,  5040,   9,   5, UNI_XPOSIXDIGIT }   /* category=digit */,
  {     4, 10296,    25,   3,   1, UNI_PS }   /* isps */,
  {     0,  1536,     0,   4,   0, UNI_SIND }   /* sind */,
  {     0,  1417,  8807,  24,   3, UNI_CCC__118 }   /* canonicalcombiningclass=118 */,
  {     5,  8774,  9836,   6,   4, UNI_BIDIM }   /* bidim=true */,
  {     2,  9488,   283,   4,  33, UNI_MISCMATHSYMBOLSB }   /* blk=miscellaneousmathematicalsymbolsb */,
  {     0,  1823,     0,   9,   0, UNI_XPOSIXLOWER }   /* lowercase */,
  {     1,   184,  8924,   2,   4, UNI_LEPC }   /* islepc */,
  {     0,  9277,  8243,   3,   8, UNI_SC__MAHJ }   /* sc=mahajani */,
  {     1,  9277,  9315,   3,   5, UNI_SC__ORYA }   /* sc=oriya */,
  {     3,  9768,  8936,   4,   6, UNI_LYCI }   /* scx=lycian */,
  {     1,  5270,     0,  14,   0, UNI_LATINEXTE }   /* latinextendede */,
  {     1,  3836,  4448,  17,   4, UNI_BAMU }   /* scriptextensions=bamu */,
  {     0,  8267,    26,   8,   1, UNI_RADICAL }   /* radical=y */,
  {     0,    32,     0,   2,   0, UNI__PERL_SURROGATE }   /* cs */,
  {    16,  1417,  3564,  24,  13, UNI_CCC__202 }   /* canonicalcombiningclass=attachedbelow */,
  {     0, 10024,  4943,   3,  15, UNI_TITLE }   /* gc=titlecaseletter */,
  {     0,  2182,   406,  21,   7, UNI_GCB__CN }   /* graphemeclusterbreak=control */,
  {     1,  6241,    24,  12,   1, UNI_JT__L }   /* joiningtype=l */,
  {     0, 10048,  9973,   3,   3, UNI_NV__5_SLASH_6 }   /* nv=5/6 */,
  {     1,    21,  7585,   2,   9, UNI_LATINEXTC }   /* inlatinextc */,
  {     0,  3836,  9864,  17,   4, UNI_WCHO }   /* scriptextensions=wcho */,
  {     1,  3367,    26,  18,   1, UNI__PERL_PATWS }   /* patternwhitespace=y */,
  {     0,  8780,  2469,   6,  20, UNI_INNYIAKENGPUACHUEHMONG }   /* block=nyiakengpuachuehmong */,
  {     1,  8780,   749,   6,  21, UNI_ENCLOSEDALPHANUM }   /* block=enclosedalphanumerics */,
  {     2,   184,  9576,   2,   4, UNI_GURU }   /* isguru */,
  {     0, 10333,  9793,   3,   3, UNI_SOGO }   /* issogo */,
  {     0, 10048,  7771,   3,   8, UNI_NV__1_SLASH_80 }   /* nv=1.25e-02 */,
  {     1,  9444,  9991,   4,   3, UNI_AGE__9 }   /* age=9.0 */,
  {     0,  9488,   567,   4,   2, UNI_NB }   /* blk=nb */,
  {     0,  9488,  1922,   4,  12, UNI_DIACRITICALS }   /* blk=diacriticals */,
  {    13,  1537,  2555,  24,   6, UNI_INPC__BOTTOM }   /* indicpositionalcategory=bottom */,
  {     1, 10024,  5497,   3,  11, UNI_MC }   /* gc=spacingmark */,
  {     3,  2784,    80,   4,   8, UNI_ARABICMATH }   /* inarabicmath */,
  {     0,  5791,  5620,  13,  14, UNI_JG__HAMZAONHEHGOAL }   /* joininggroup=tehmarbutagoal */,
  {    32,  4791,  1595,   3,  13, UNI_MUSIC }   /* inmusicalsymbols */,
  {     0,  8589,  2329,   7,  20, UNI_HLUW }   /* script=anatolianhieroglyphs */,
  {     0,  7088,  3374,  10,  10, UNI_BC__WS }   /* bidiclass=whitespace */,
  {     0,   184,  7168,   2,  10, UNI_DIAK }   /* isdivesakuru */,
  {     0,   184,  9636,   2,   4, UNI_LINB }   /* islinb */,
  {     0,  9488,  7684,   4,   9, UNI_INPAUCINHAU }   /* blk=paucinhau */,
  {     0,  6939,     0,  11,   0, UNI_SORA }   /* sorasompeng */,
  {     3,  9768,  8131,   4,   8, UNI_DUPL }   /* scx=duployan */,
  {     1,  9488,   629,   4,  30, UNI_CJKEXTE }   /* blk=cjkunifiedideographsextensione */,
  {     8,  9488,  2098,   4,  21, UNI_CJKCOMPATFORMS }   /* blk=cjkcompatibilityforms */,
  {     1, 10290,    96,   6,   5, UNI_XPOSIXALPHA }   /* xposixalpha */,
  {     1,  9732,     0,   4,   0, UNI_PRTI }   /* prti */,
  {     0,  8589,  3241,   7,   8, UNI_SC__GEOR }   /* script=georgian */,
  {     1,  5032,     0,  14,   0, UNI_ahex_values_index }   /* asciihexdigit= */,
  {     1,  3529,    36,  18,   1, UNI_VS }   /* variationselector=t */,
  {     0,  2569,   409,  20,   2, UNI_VO__TR }   /* verticalorientation=tr */,
  {     3,  2182,  6763,  21,   3, UNI_LB__H3 }   /* graphemeclusterbreak=lvt */,
  {     1,  9768,  8299,   4,   8, UNI_TFNG }   /* scx=tifinagh */,
  {     0,  6553,     0,  11,   0, UNI_XIDC }   /* xidcontinue */,
  {     0,  3836,  4793,  17,  15, UNI_MERC }   /* scriptextensions=meroiticcursive */,
  {    10,   341,     0,   2,   0, UNI_PE }   /* pe */,
  {     1,  3097,  8846,  18,   6, UNI_DT__ENC }   /* decompositiontype=circle */,
  {     2,  4688,  6609,  15,  10, UNI_DEP }   /* identifiertype=deprecated */,
  {     0,   184,  9231,   3,   3, UNI_CWCF }   /* iscwcf */,
  {     2,  8780,  6829,   6,  11, UNI_MYANMAREXTB }   /* block=myanmarextb */,
  {     0,  5986,  7781,  13,   1, UNI_NV__4 }   /* numericvalue=4 */,
  {     1,     0,     0,  34,   0, UNI_UCAS }   /* unifiedcanadianaboriginalsyllabics */,
  {     1,  1417,  3007,  24,  18, UNI_CCC__216 }   /* canonicalcombiningclass=attachedaboveright */,
  {     1,  1966,  9090,  22,   5, UNI_INSC__BINDU }   /* indicsyllabiccategory=bindu */,
  {     0,  6229,  1025,  12,   2, -UNI_JOINC }   /* joincontrol=no */,
  {     2,  9997,  2893,   3,  19, UNI_BC__RLO }   /* bc=righttoleftoverride */,
  {     5,  8780,   149,   7,  34, UNI_DIACRITICALSSUP }   /* block=combiningdiacriticalmarkssupplement */,
  {     1,  9528,     0,   4,   0, UNI_cwu_values_index }   /* cwu= */,
  {     0,  9277,  9440,   3,   4, UNI_SC__ADLM }   /* sc=adlm */,
  {     1,  9488,  9032,   4,   6, UNI_INWANCHO }   /* blk=wancho */,
  {     7, 10048,  8756,   3,   2, UNI_NV__90 }   /* nv=90 */,
  {     0,  9277,  9812,   3,   4, UNI_SC__TAML }   /* sc=taml */,
  {     8,  5986,  8720,  13,   6, UNI_NV__400000 }   /* numericvalue=400000 */,
  {     1, 10009,  1253,   3,   4, UNI_DT__INIT }   /* dt=init */,
  {     0,  7218,   866,  10,   2, UNI_LB__SP }   /* linebreak=sp */,
  {     3,  9997,  2449,   3,  11, UNI_BC__L }   /* bc=lefttoright */,
  {     2,  3115,     0,  13,   0, UNI_DEVANAGARIEXT }   /* devanagariext */,
  {     1,  5791,  3785,  13,  17, UNI_JG__MANICHAEANDHAMEDH }   /* joininggroup=manichaeandhamedh */,
  {     1,  9508,  7178,   4,  10, UNI_CCC__6 }   /* ccc=hanreading */,
  {     4,  5986,  8750,  13,   3, UNI_NV__800 }   /* numericvalue=800 */,
  {     5,  5060,  9255,  14,   5, -UNI_CI }   /* caseignorable=false */,
  {     2,   184,  6818,   2,  11, UNI_MYANMAREXTA }   /* ismyanmarexta */,
  {     0,  5037,     1,   9,   1, -UNI_XPOSIXXDIGIT }   /* hexdigit=n */,
  {     0,    21,  5662,   3,  12, UNI_AEGEANNUMBERS }   /* inaegeannumbers */,
  {     1,  4898,     0,  15,   0, UNI_PS }   /* openpunctuation */,
  {     8,  5986,  8714,  13,   4, UNI_NV__3000 }   /* numericvalue=3000 */,
  {     0,  8589,  9736,   7,   4, UNI_SC__COPT }   /* script=qaac */,
  {     0,  7088, 10036,  10,   3, UNI_BC__LRE }   /* bidiclass=lre */,
  {     2,  5564,  9836,  14,   4, UNI_QMARK }   /* quotationmark=true */,
  {     1,  9277,  9864,   3,   4, UNI_WCHO }   /* sc=wcho */,
  {     3,  9508,  7978,   4,   2, UNI_CCC__16 }   /* ccc=16 */,
  {     2,  5564,    26,  14,   1, UNI_QMARK }   /* quotationmark=y */,
  {     0,  6231,  2120,   3,  20, UNI_CJKRADICALSSUP }   /* incjkradicalssupplement */,
  {     7, 10048,  8732,   3,   6, UNI_NV__500000 }   /* nv=500000 */,
  {     1,  3836,  9660,  17,   4, UNI_MLYM }   /* scriptextensions=mlym */,
  {     0,  1552,  1899,   9,   2, UNI_PC }   /* category=pc */,
  {     0,  9768,    78,   4,   4, UNI_ARAB }   /* scx=arab */,
  {    21, 10296,  7676,   3,   8, UNI_PALM }   /* ispalmyrene */,
  {     0,    27,     0,   2,   0, UNI_LOWERCASELETTER }   /* ll */,
  {     1,  1823,     0,   5,   0, UNI_XPOSIXLOWER }   /* lower */,
  {     0, 10027,  6349,   3,  12, UNI_JG__MALAYALAMSSA }   /* jg=malayalamssa */,
  {     3,  8780,  2203,   6,  14, UNI_INHANIFIROHINGYA }   /* block=hanifirohingya */,
  {     2,   184,  8219,   2,   4, UNI_JAVA }   /* isjava */,
  {     0,  9488,  4568,   4,  15, UNI_CURRENCYSYMBOLS }   /* blk=currencysymbols */,
  {     1,  6420,  1061,   3,  26, UNI_OCR }   /* inopticalcharacterrecognition */,
  {     2,  5791,  3802,  13,  17, UNI_JG__MANICHAEANHUNDRED }   /* joininggroup=manichaeanhundred */,
  {    16,  1188,  8646,   3,   6, UNI_INTAITHAM }   /* intaitham */,
  {     9,  1018,     0,   5,   0, UNI_MUSIC }   /* music */,
  {     0,  9488,  7495,   4,   9, UNI_ARABICPFA }   /* blk=arabicpfa */,
  {     1,  9260,     0,   5,   0, UNI_idsb_values_index }   /* idsb= */,
  {     0,  8589,  9700,   7,   4, UNI_OLCK }   /* script=olck */,
  {     0,  1417,  1756,  24,   2, UNI_CCC__BR }   /* canonicalcombiningclass=br */,
  {     4,  9270,   472,   3,   2, UNI_PUA }   /* inpua */,
  {     0,   184,  9652,   2,   4, UNI_MERC }   /* ismerc */,
  {     4,  1189,     0,   3,   0, UNI_nt_values_index }   /* nt= */,
  {     8,  9275,  4353,   5,  16, UNI_INSC__SYLLABLEMODIFIER }   /* insc=syllablemodifier */,
  {     3, 10288,  2779,   3,   3, UNI_XIDS }   /* isxids */,
  {     1,   184,     0,   4,   0, UNI_CE }   /* isce */,
  {     3,  8688,  5019,   3,  13, UNI_ANCIENTSYMBOLS }   /* isancientsymbols */,
  {     1,  9508,  8823,   5,   4, UNI_CCC__13 }   /* ccc=ccc13 */,
  {     1,  9768,  8219,   4,   8, UNI_JAVA }   /* scx=javanese */,
  {     2,  8400,    26,   7,   1, UNI_COMPEX }   /* compex=y */,
  {     1, 10027,  7016,   3,  11, UNI_JG__YEHWITHTAIL }   /* jg=yehwithtail */,
  {     1,  7155,    34,   3,   2, UNI_XPOSIXXDIGIT }   /* ishex */,
  {     0,  5986,  7915,  13,   8, UNI_NV__3_SLASH_80 }   /* numericvalue=3.75e-02 */,
  {    17,  9997,     1,   4,   1, UNI_BC__BN }   /* bc=bn */,
  {     6,  1188,  2077,   3,  21, UNI_TRANSPORTANDMAP }   /* intransportandmapsymbols */,
  {     0,   184, 10176,   2,   2, UNI_ZL }   /* iszl */,
  {     2,  6469,    11,  12,   2, UNI_NT__DI }   /* numerictype=di */,
  {     8, 10033,  7512,   3,   2, UNI_LB__BB }   /* lb=bb */,
  {     0,  7325,  9985,   3,   3, UNI_IN__7 }   /* in=7.0 */,
  {     0,  2224,     0,  21,   0, UNI_PRTI }   /* inscriptionalparthian */,
  {     7,  9768,  9636,   4,   4, UNI_LINB }   /* scx=linb */,
  {     1,  8936,     0,   6,   0, UNI_LYCI }   /* lycian */,
  {     0,  9997,  3313,   3,  18, UNI_BC__LRI }   /* bc=lefttorightisolate */,
  {     2,  8589,  8421,   7,   4, UNI_ELYM }   /* script=elym */,
  {     2,  2182,  4305,  21,   5, UNI_GCB__XX }   /* graphemeclusterbreak=other */,
  {     1,  8780,  8394,   7,   6, UNI_CJKEXTG }   /* block=cjkextg */,
  {     5,  9864,     0,   4,   0, UNI_WCHO }   /* wcho */,
  {     0,  9768,  9335,   4,   4, UNI_TAKR }   /* scx=takr */,
  {     0,  1828,     0,   6,   0, UNI_cased_values_index }   /* cased= */,
  {     2,   184,  4569,   3,  13, UNI_SC }   /* iscurrencysymbol */,
  {     2,  8780,  2061,   6,   4, UNI_INMODI }   /* block=modi */,
  {     2,   184,  3241,   2,   4, UNI_GEOR }   /* isgeor */,
  {     8,  3836,  7651,  17,   4, UNI_ITAL }   /* scriptextensions=ital */,
  {     0,   184,    62,   2,   5, UNI_XPOSIXGRAPH }   /* isgraph */,
  {     0,  8589,  1628,   7,   4, UNI_SC__PHAG }   /* script=phag */,
  {     0,  9014,  1025,   6,   2, -UNI_UIDEO }   /* uideo=no */,
  {     2,   979,     0,  27,   0, UNI_ALPHABETICPF }   /* alphabeticpresentationforms */,
  {     0,  8589,  2288,   8,   3, UNI_SC__SINH }   /* script=sinh */,
  {     2,  8589,  5003,   7,  15, UNI_ZANB }   /* script=zanabazarsquare */,
  {     4,  9277,  9704,   3,   4, UNI_ORKH }   /* sc=orkh */,
  {     0,  5986,  7899,  13,   8, UNI_NV__7_SLASH_2 }   /* numericvalue=3.50e+00 */,
  {     6,  9488,  8673,   4,   7, UNI_UCASEXT }   /* blk=ucasext */,
  {     0,  8477,     0,   4,   0, UNI_MAKA }   /* maka */,
  {     5,  1417,  8793,  25,   4, UNI_CCC__10 }   /* canonicalcombiningclass=ccc10 */,
  {     0,  2245,     0,  14,   0, UNI_MEETEIMAYEKEXT }   /* meeteimayekext */,
  {     0,  9277,  8876,   3,   4, UNI_GOTH }   /* sc=goth */,
  {     0,   112,     0,   2,   0, UNI_SC }   /* sc */,
  {     2,  3836,  9820,  17,   4, UNI_TFNG }   /* scriptextensions=tfng */,
  {     1, 10048,  9361,   3,   3, UNI_NV__1_SLASH_2 }   /* nv=1/2 */,
  {    11,  8509,   751,   4,  19, UNI_ENCLOSEDALPHANUM }   /* inenclosedalphanumerics */,
  {     0,  8780,  3600,   8,  15, UNI_INCAUCASIANALBANIAN }   /* block=caucasianalbanian */,
  {     0,  9488,  8171,   4,   8, UNI_INGUJARATI }   /* blk=gujarati */,
  {     1,  8780,  2855,   6,   9, UNI_INMONGOLIAN }   /* block=mongolian */,
  {     1,    21,  8203,   2,   8, UNI_JAMOEXTA }   /* injamoexta */,
  {     5,  4916,  8653,   3,   6, UNI_TAVT }   /* istaiviet */,
  {     0,  9488,   250,   4,  33, UNI_MISCMATHSYMBOLSA }   /* blk=miscellaneousmathematicalsymbolsa */,
  {     0,  8688,  2469,   3,   2, UNI_ANY }   /* isany */,
  {     0,  6241,     7,  12,   1, UNI_JT__C }   /* joiningtype=c */,
  {     9,  8786,     0,   6,   0, UNI_CARI }   /* carian */,
  {     8,  5256,     0,  14,   0, UNI_LATINEXTD }   /* latinextendedd */,
  {     3,  5791,  5179,  13,   3, UNI_JG__HEH }   /* joininggroup=heh */,
  {     0,  7218,   414,  10,  11, UNI_LB__ID }   /* linebreak=ideographic */,
  {     0,  9277,  8107,   3,   8, UNI_BALI }   /* sc=balinese */,
  {     3, 10048,  7835,   3,   8, UNI_NV__5_SLASH_2 }   /* nv=2.50e+00 */,
  {     1,  8780,  4273,   6,  16, UNI_MYANMAREXTA }   /* block=myanmarextendeda */,
  {     0,  9277,  8888,   3,   4, UNI_HATR }   /* sc=hatr */,
  {     1,  7558,  6195,   4,   4, UNI_INHEBREW }   /* inhebrew */,
  {     7,  8589,  8187,   7,   8, UNI_SC__HIRA }   /* script=hiragana */,
  {     2, 10027,  5410,   3,  14, UNI_JG__MANICHAEANTETH }   /* jg=manichaeanteth */,
  {     0,  1417, 10166,  24,   2, UNI_CCC__8 }   /* canonicalcombiningclass=kv */,
  {     2,   184,  9640,   2,   3, UNI_LOE }   /* isloe */,
  {     0,  8870,     1,   6,   1, -UNI_EPRES }   /* epres=n */,
  {     4,  9524,     0,   4,   0, UNI_cwt_values_index }   /* cwt= */,
  {     0,  1166,  9255,  26,   5, -UNI_DI }   /* defaultignorablecodepoint=false */,
  {     1,  8780,  1922,   6,  12, UNI_DIACRITICALS }   /* block=diacriticals */,
  {    13,  3836,  2684,  17,  19, UNI_EGYP }   /* scriptextensions=egyptianhieroglyphs */,
  {     2,  8780,  8673,   6,   7, UNI_UCASEXT }   /* block=ucasext */,
  {     0,  8780,  8645,   6,   7, UNI_INTAITHAM }   /* block=taitham */,
  {     5,  5986,  7843,  13,   8, UNI_NV__1_SLASH_4 }   /* numericvalue=2.50e-01 */,
  {     2,   217,     0,  33,   0, UNI_DIACRITICALSEXT }   /* combiningdiacriticalmarksextended */,
  {     5, 10024,  6851,   3,  11, UNI_LO }   /* gc=otherletter */,
  {     2,  9997,    23,   3,   2, UNI_BC__AL }   /* bc=al */,
  {     6,  8780,  2912,   6,  12, UNI_SUNDANESESUP }   /* block=sundanesesup */,
  {     1,  3836,  8659,  17,   7, UNI_TIBT }   /* scriptextensions=tibetan */,
  {     0,  8645,     0,   7,   0, UNI_LANA }   /* taitham */,
  {     2,  9277,  8786,   3,   6, UNI_CARI }   /* sc=carian */,
  {     0,  7418,    26,  10,   1, UNI_XPOSIXUPPER }   /* uppercase=y */,
  {    20,  7318, 10114,  10,   3, UNI_IN__6_DOT_3 }   /* presentin=v63 */,
  {     5,  1188,  3458,   3,  10, UNI_TAIXUANJING }   /* intaixuanjing */,
  {     3,   184,  9632,   2,   4, UNI_LINA }   /* islina */,
  {     2,  9997,  2489,   3,  20, UNI_BC__PDF }   /* bc=popdirectionalformat */,
  {     4,  8780,  8547,   6,   7, UNI_OLCK }   /* block=olchiki */,
  {     0,  8942,     0,   4,   0, UNI_LYDI }   /* lydi */,
  {     0,  6035,     0,   2,   0, UNI_PF }   /* pf */,
  {     7,  9265, 10135,   5,   3, UNI_IDST }   /* idst=yes */,
  {     0,   184,  2061,   2,  14, UNI_LM }   /* ismodifierletter */,
  {     1,   184,  2287,   2,  21, UNI_SINHALAARCHAICNUMBERS }   /* issinhalaarchaicnumbers */,
  {     3,  2569,   471,  20,   2, UNI_VO__TU }   /* verticalorientation=tu */,
  {     2,   184,  1631,   2,  18, UNI_GEOMETRICSHAPESEXT }   /* isgeometricshapesext */,
  {     4, 10048,  9924,   3,   2, UNI_NV__42 }   /* nv=42 */,
  {     2,   184,   339,   2,   2, UNI_LO }   /* islo */,
  {     1,  9768,  9330,   4,   5, UNI_TALE }   /* scx=taile */,
  {     0,  9277,  6193,   3,   6, UNI_HEBR }   /* sc=hebrew */,
  {     1,   184,  8491,   2,   4, UNI_MARC }   /* ismarc */,
  {     0,  8780,   467,   6,  11, UNI_INPUNCTUATION }   /* block=punctuation */,
  {    16,  9071,     1,   4,   1, -UNI_XPOSIXXDIGIT }   /* hex=n */,
  {     1,  9270,  7309,   3,   9, UNI_INPHOENICIAN }   /* inphoenician */,
  {    16,  3836,  8414,  17,   7, UNI_ELBA }   /* scriptextensions=elbasan */,
  {     0,  3836,  8463,  17,   7, UNI_KALI }   /* scriptextensions=kayahli */,
  {     0,  9768,  7188,   4,   4, UNI_KHAR }   /* scx=khar */,
  {     0, 10296,  1629,   3,   3, UNI_PHAG }   /* isphag */,
  {     2,  5746,    26,   6,   1, UNI_EBASE }   /* ebase=y */,
  {     1,  8780,  8315,   6,   8, UNI_INUGARITIC }   /* block=ugaritic */,
  {     0,  9277,  9632,   3,   4, UNI_SC__LINA }   /* sc=lina */,
  {     5,  8884,  9255,   4,   5, -UNI_EXT }   /* ext=false */,
  {     0, 10129,     3,   3,   1, -UNI_VS }   /* vs=f */,
  {     3,  9528,    26,   4,   1, UNI_CWU }   /* cwu=y */,
  {     1,  6229,     1,  12,   1, -UNI_JOINC }   /* joincontrol=n */,
  {     5,   184,  9544,   2,   4, UNI_DIAK }   /* isdiak */,
  {     5,  9704,     0,   4,   0, UNI_ORKH }   /* orkh */,
  {     0,  9768,  7657,   4,   9, UNI_PERM }   /* scx=oldpermic */,
  {     0,  9277,  8291,   3,   8, UNI_SC__TAGB }   /* sc=tagbanwa */,
  {     1,  8780,  7531,   6,   9, UNI_EMOTICONS }   /* block=emoticons */,
  {     1,  9488,  7504,   4,   9, UNI_ARABICPFB }   /* blk=arabicpfb */,
  {     1,  8870,  9836,   6,   4, UNI_EPRES }   /* epres=true */,
  {     1,  9270,     0,   5,   0, UNI_inpc_values_index }   /* inpc= */,
  {     1,  8694,  9255,   7,   5, -UNI_XPOSIXSPACE }   /* wspace=false */,
  {    16,  4791,  2837,   3,  18, UNI_MODIFIERTONELETTERS }   /* inmodifiertoneletters */,
  {     1,  9277,  8414,   3,   4, UNI_ELBA }   /* sc=elba */,
  {     1,  9768,  9516,   4,   4, UNI_CPRT }   /* scx=cprt */,
  {     6,  7318, 10117,  10,   3, UNI_IN__7 }   /* presentin=v70 */,
  {     1,  9640,  1025,   4,   2, -UNI_LOE }   /* loe=no */,
  {     0,   184,  1587,   2,   1, UNI_Z }   /* isz */,
  {     4,  7218,  9557,  10,   2, UNI_LB__CB }   /* linebreak=cb */,
  {    16,  9275,  8307,   5,   8, UNI_INSC__TONEMARK }   /* insc=tonemark */,
  {     0,  9277,  8936,   3,   6, UNI_LYCI }   /* sc=lycian */,
  {     1,  2722,     0,  19,   0, UNI_JAMOEXTA }   /* hanguljamoextendeda */,
  {     0,  8512,    17,   8,   1, UNI_NFKCQC__N }   /* nfkcqc=no */,
  {     2,  9270,   909,   3,  13, UNI_PUA }   /* inprivateusearea */,
  {     0,  9275,  5700,   5,  13, UNI_INSC__CONSONANTDEAD }   /* insc=consonantdead */,
  {     2,  9484,     0,   4,   0, UNI_BHKS }   /* bhks */,
  {     7,  9768,  4448,   4,   5, UNI_BAMU }   /* scx=bamum */,
  {     1,  8589,  3115,   7,  10, UNI_SC__DEVA }   /* script=devanagari */,
  {     0,  8852,     0,   6,   0, UNI_cwkcf_values_index }   /* cwkcf= */,
  {     2,  6805,  2014,   6,  18, UNI_MISCTECHNICAL }   /* inmiscellaneoustechnical */,
  {     4,  8589,  4001,   7,   7, UNI_SC__CPRT }   /* script=cypriot */,
  {     4,  9488,  1192,   4,  26, UNI_HALFANDFULLFORMS }   /* blk=halfwidthandfullwidthforms */,
  {     2,  8780,  5550,   6,  14, UNI_INPSALTERPAHLAVI }   /* block=psalterpahlavi */,
  {     3,   132,     0,   2,   0, UNI_LM }   /* lm */,
  {    16,  5986,  7851,  13,   8, UNI_NV__1_SLASH_40 }   /* numericvalue=2.50e-02 */,
  {     2,  8780,  8442,   6,   7, UNI_INHANUNOO }   /* block=hanunoo */,
  {     1,  9275,  8687,   5,   7, UNI_INSC__VISARGA }   /* insc=visarga */,
  {     4, 10033,  8449,   3,   2, UNI_LB__HY }   /* lb=hy */,
  {     0,  6805,   861,   6,   6, UNI_MISCARROWS }   /* inmiscarrows */,
  {     0,  9488,   599,   4,  30, UNI_CJKEXTD }   /* blk=cjkunifiedideographsextensiond */,
  {     0,  9277,  4478,   3,   7, UNI_BRAI }   /* sc=braille */,
  {     0, 10033,    25,   3,   2, UNI_LB__SY }   /* lb=sy */,
  {     0,  7325,     0,   3,   0, UNI_in_values_index }   /* in= */,
  {     2,  7249,   533,   4,   2, UNI_CANS }   /* iscans */,
  {     0,  4542,  1633,   4,  16, UNI_GEOMETRICSHAPESEXT }   /* ingeometricshapesext */,
  {     3,  9488,  3598,   4,  17, UNI_INCAUCASIANALBANIAN }   /* blk=caucasianalbanian */,
  {     1,  3836,  3241,  17,   4, UNI_GEOR }   /* scriptextensions=geor */,
  {     0,  4033,  7408,  16,  10, UNI_CN }   /* generalcategory=unassigned */,
  {     1,  2224,  3871,   3,  16, UNI_SMALLFORMS }   /* insmallformvariants */,
  {     0,  3836,  4145,  17,   7, UNI_LINB }   /* scriptextensions=linearb */,
  {     2,  9768,  2140,   4,   8, UNI_CYRL }   /* scx=cyrillic */,
  {     0,  9070, 10135,   5,   3, UNI_POSIXXDIGIT }   /* ahex=yes */,
  {    10,  8589,  6409,   7,   4, UNI_MEND }   /* script=mend */,
  {     1,  6609,     0,  11,   0, UNI_dep_values_index }   /* deprecated= */,
  {     0,  9277,  8491,   3,   7, UNI_MARC }   /* sc=marchen */,
  {     2,  9508,  9101,   5,   4, UNI_CCC__14 }   /* ccc=ccc14 */,
  {     5,   184,  3887,   2,  17, UNI_SUTTONSIGNWRITING }   /* issuttonsignwriting */,
  {     1,    21,  9325,   2,   5, UNI_INRUNIC }   /* inrunic */,
  {     2, 10024,  8855,   3,   2, UNI_CF }   /* gc=cf */,
  {     8,  1417,  8823,  25,   4, UNI_CCC__13 }   /* canonicalcombiningclass=ccc13 */,
  {     5,  4113,    25,   3,   1, UNI_INVS }   /* invs */,
  {     2,  5986,  8011,  13,   8, UNI_NV__13_SLASH_2 }   /* numericvalue=6.50e+00 */,
  {     2,  4853,     1,  15,   1, UNI_NFKDQC__N }   /* nfkdquickcheck=n */,
  {     0, 10027,  4209,   3,  16, UNI_JG__MANICHAEANSAMEKH }   /* jg=manichaeansamekh */,
  {     1,   569,     0,  30,   0, UNI_CJKEXTC }   /* cjkunifiedideographsextensionc */,
  {     2,  9345,  9255,   5,   5, -UNI_XIDC }   /* xidc=false */,
  {     1,  9488,  8936,   4,   6, UNI_INLYCIAN }   /* blk=lycian */,
  {     0,   184,  3151,   2,  17, UNI_EPRES }   /* isemojipresentation */,
  {     1,  8978,  1025,   6,   2, -UNI__PERL_PATWS }   /* patws=no */,
  {     1, 10033,  7522,   3,   9, UNI_LB__B2 }   /* lb=breakboth */,
  {     2,  1417,  2809,  24,   2, UNI_CCC__1 }   /* canonicalcombiningclass=ov */,
  {     1,  8780,  8387,   7,   6, UNI_CJKEXTF }   /* block=cjkextf */,
  {     3,  9015,    26,   5,   1, UNI_IDEO }   /* ideo=y */,
  {     0,  1552,  6598,   9,  11, UNI_CASEDLETTER }   /* category=casedletter */,
  {     1,  9540,  1025,   4,   2, -UNI_DIA }   /* dia=no */,
  {     0,    21,  5830,   2,  13, UNI_LOWSURROGATES }   /* inlowsurrogates */,
  {     0,  3259,    26,  18,   1, UNI_IDSB }   /* idsbinaryoperator=y */,
  {     0,    57,     0,   2,   0, UNI_YI }   /* yi */,
  {     1,   184,  2817,   2,  19, UNI_MERO }   /* ismeroitichieroglyphs */,
  {     1,  8589,  9804,   7,   4, UNI_SC__TALE }   /* script=tale */,
  {     2,  6609,     1,  11,   1, -UNI_DEP }   /* deprecated=n */,
  {     2,  5986,  9055,  13,   4, UNI_NV__1_SLASH_32 }   /* numericvalue=1/32 */,
  {     0,  9262,   400,   3,   6, UNI_SB__FO }   /* sb=format */,
  {     8,  8780,  8414,   6,   7, UNI_INELBASAN }   /* block=elbasan */,
  {     0,  7088,  6049,  10,  12, UNI_BC__AN }   /* bidiclass=arabicnumber */,
  {     1, 10048,  9364,   3,   4, UNI_NV__1_SLASH_10 }   /* nv=1/10 */,
  {     0,  8780,  6961,   6,  11, UNI_SUPERANDSUB }   /* block=superandsub */,
  {     3,   184,  5284,   2,  14, UNI_LISUSUP }   /* islisusupplement */,
  {     7,  9492,     7,   4,   1, UNI_BPT__C }   /* bpt=c */,
  {     8,  9768,  8414,   4,   4, UNI_ELBA }   /* scx=elba */,
  {     5, 10024,   467,   3,   5, UNI_P }   /* gc=punct */,
  {     0,  1966,  8099,  22,   8, UNI_INSC__AVAGRAHA }   /* indicsyllabiccategory=avagraha */,
  {     3,  9275,  4523,   5,  15, UNI_INSC__CONSONANTMEDIAL }   /* insc=consonantmedial */,
  {     1,  8589,  9680,   7,   4, UNI_NBAT }   /* script=nbat */,
  {     1, 10048,  7747,   3,   8, UNI_NV__1_SLASH_10 }   /* nv=1.00e-01 */,
  {     1,  9488,  4065,   4,  16, UNI_HALFANDFULLFORMS }   /* blk=halfandfullforms */,
  {    11,  7438,  8139,  10,   8, UNI_WB__EB }   /* wordbreak=ebasegaz */,
  {     0,  2224,  2970,   3,  18, UNI_SUPARROWSC }   /* insupplementalarrowsc */,
  {     0,  9524,    26,   4,   1, UNI_CWT }   /* cwt=y */,
  {     1,  9277,  9572,   3,   4, UNI_SC__GUJR }   /* sc=gujr */,
  {     4,  1552,   107,  10,   5, UNI_S }   /* category=symbol */,
  {     0, 10048,  5648,   3,   4, UNI_NV__1000 }   /* nv=1000 */,
  {     0, 10009,  8163,   3,   3, UNI_DT__FRA }   /* dt=fra */,
  {     0,  7558,     0,   9,   0, UNI_QAAI }   /* inherited */,
  {     3,  1768,    26,  22,   1, UNI_CWCF }   /* changeswhencasefolded=y */,
  {     0,  3836,  2913,  18,   8, UNI_SUND }   /* scriptextensions=sundanese */,
  {    10,  9277,  8547,   3,   7, UNI_OLCK }   /* sc=olchiki */,
  {     0,  9488,    42,   4,  16, UNI_CJKCOMPAT }   /* blk=cjkcompatibility */,
  {     2,  3836,  8315,  17,   4, UNI_UGAR }   /* scriptextensions=ugar */,
  {     0,  8996,     0,   7,   0, UNI_STERM }   /* sterm=t */,
  {     0,  9488,  4928,   4,  15, UNI_TAMILSUP }   /* blk=tamilsupplement */,
  {     0,  3836,  7558,  17,   9, UNI_QAAI }   /* scriptextensions=inherited */,
  {     0,  1552,    17,  10,   1, UNI_SO }   /* category=so */,
  {     0,  9277,  7675,   3,   4, UNI_PALM }   /* sc=palm */,
  {     0,  8780,  7513,   6,   9, UNI_INBHAIKSUKI }   /* block=bhaiksuki */,
  {     1,  9250,     0,   5,   0, UNI_emod_values_index }   /* emod= */,
  {     4,  8589,   719,   7,   9, UNI_XSUX }   /* script=cuneiform */,
  {     0,  9240,  1025,   5,   2, -UNI_DASH }   /* dash=no */,
  {     3,  8780,  6807,   6,  11, UNI_MISCSYMBOLS }   /* block=miscsymbols */,
  {     1, 10048,  9055,   3,   5, UNI_NV__1_SLASH_320 }   /* nv=1/320 */,
  {     1,  4628,     9,  15,   2, UNI_EA__NA }   /* eastasianwidth=na */,
  {     0,   184,  1673,   2,   4, UNI_JAMO }   /* isjamo */,
  {     3,  7155,  4098,   3,  15, UNI_HIGHPUSURROGATES }   /* ishighpusurrogates */,
  {     3,  2779,    36,  19,   1, UNI_IDST }   /* idstrinaryoperator=t */,
  {     2, 10027,  7348,   3,  10, UNI_JG__REVERSEDPE }   /* jg=reversedpe */,
  {     6,  9488,  2224,   4,  21, UNI_ININSCRIPTIONALPARTHIAN }   /* blk=inscriptionalparthian */,
  {     1,  7088,     0,  10,   0, UNI_bc_values_index }   /* bidiclass= */,
  {     0,  8589,  8291,   7,   8, UNI_SC__TAGB }   /* script=tagbanwa */,
  {     0,  4033, 10180,  16,   2, UNI_ZS }   /* generalcategory=zs */,
  {     0,  8780,  1631,   6,  18, UNI_GEOMETRICSHAPESEXT }   /* block=geometricshapesext */,
  {     0,  7318, 10111,  10,   3, UNI_IN__6_DOT_2 }   /* presentin=v62 */,
  {     0,  8894,  1025,   6,   2, -UNI_JOINC }   /* joinc=no */,
  {     2,  3836,  1115,  17,   4, UNI_HANG }   /* scriptextensions=hang */,
  {     2,  9596,     9,   4,   2, UNI_HST__NA }   /* hst=na */,
  {     1,  8780,   250,   6,  33, UNI_MISCMATHSYMBOLSA }   /* block=miscellaneousmathematicalsymbolsa */,
  {     3, 10009,  2280,   3,   3, UNI_DT__ISO }   /* dt=iso */,
  {     4,  9488,  5752,   4,  13, UNI_GREEKEXT }   /* blk=greekextended */,
  {    17,  7378,     0,  10,   0, UNI_SUPARROWSA }   /* suparrowsa */,
  {     2,  9520,     0,   3,   0, UNI_CWL }   /* cwl */,
  {     2,  9556, 10174,   4,   2, UNI_GCB__XX }   /* gcb=xx */,
  {     1, 10048,  7781,   3,   2, UNI_NV__43 }   /* nv=43 */,
  {     1,  8780,  3115,   6,  13, UNI_DEVANAGARIEXT }   /* block=devanagariext */,
  {     4,  3836,  6253,  17,   5, UNI_KHMR }   /* scriptextensions=khmer */,
  {     8,  3836,  2288,  18,   6, UNI_SINH }   /* scriptextensions=sinhala */,
  {     0, 10048, 10144,   3,   2, UNI_NV__45 }   /* nv=45 */,
  {    42,  9488,   569,   4,  30, UNI_CJKEXTC }   /* blk=cjkunifiedideographsextensionc */,
  {     9,  9536,    26,   4,   1, UNI_DEP }   /* dep=y */,
  {     0,  1790,    26,  22,   1, UNI_CWCM }   /* changeswhencasemapped=y */,
  {     2, 10048,  8710,   3,   4, UNI_NV__6000 }   /* nv=6000 */,
  {    10,  9262,  1159,   3,   2, UNI_SB__ST }   /* sb=st */,
  {     0,    21,  4129,   2,  16, UNI_LATIN1 }   /* inlatin1supplement */,
  {     1,  3836,  7288,  17,  10, UNI_SOGO }   /* scriptextensions=oldsogdian */,
  {     0,    21,  3295,   2,   9, UNI_LATINEXTA }   /* inlatinexta */,
  {     1,   184,  9600,   2,   4, UNI_KALI }   /* iskali */,
  {     3,  1552,  3359,  10,   8, UNI_Z }   /* category=separator */,
  {    12,  5986,  5648,  13,  13, UNI_NV__1000000000000 }   /* numericvalue=1000000000000 */,
  {     2,  3382,    26,   3,   1, UNI_CE }   /* ce=y */,
  {     1,  5214,     0,  14,   0, UNI_KANGXI }   /* kangxiradicals */,
  {     4,  9716,  9836,   4,   4, UNI_PCM }   /* pcm=true */,
  {     0, 10132, 10174,   3,   2, UNI_WB__XX }   /* wb=xx */,
  {     3,  8780,  6840,   6,  11, UNI_INNANDINAGARI }   /* block=nandinagari */,
  {     0,  8589,  2608,   7,   6, UNI_BRAH }   /* script=brahmi */,
  {     2,  9277,  9636,   3,   4, UNI_SC__LINB }   /* sc=linb */,
  {     0,  3169,     0,  18,   0, UNI_ETHIOPICSUP }   /* ethiopicsupplement */,
  {     2,  2224,  2913,   3,  11, UNI_SUNDANESESUP }   /* insundanesesup */,
  {     2,  9275,  5102,   5,  14, UNI_INSC__CONSONANTFINAL }   /* insc=consonantfinal */,
  {     0,  8780,  1906,   6,  16, UNI_INDICNUMBERFORMS }   /* block=indicnumberforms */,
  {     5,  8780,  3547,   6,  10, UNI_ALCHEMICAL }   /* block=alchemical */,
  {     0,  8780,   316,   6,  33, UNI_SUPMATHOPERATORS }   /* block=supplementalmathematicaloperators */,
  {     3,    21,  8942,   2,   6, UNI_INLYDIAN }   /* inlydian */,
  {     2,  9277,  2140,   3,   8, UNI_SC__CYRL }   /* sc=cyrillic */,
  {     0,  1867,     0,   9,   0, UNI_XPOSIXUPPER }   /* uppercase */,
  {     6,  7088,   865,  10,   2, UNI_BC__WS }   /* bidiclass=ws */,
  {     1,  4033,  1287,  16,   2, UNI_UPPERCASELETTER }   /* generalcategory=lu */,
  {     6,  7218,  6675,  10,  11, UNI_LB__EX }   /* linebreak=exclamation */,
  {     0,  8589,  1900,   7,   6, UNI_SC__ZYYY }   /* script=common */,
  {     1,  9768,  8428,   4,   4, UNI_GRAN }   /* scx=gran */,
  {     0,  8596,     0,   7,   0, UNI_SHRD }   /* sharada */,
  {     3,  1537,  3475,  24,  18, UNI_INPC__TOPANDLEFTANDRIGHT }   /* indicpositionalcategory=topandleftandright */,
  {     1,  9488,  8942,   4,   6, UNI_INLYDIAN }   /* blk=lydian */,
  {     0,  1552,  4305,   9,   5, UNI_C }   /* category=other */,
  {     0,  9277,  8876,   3,   6, UNI_GOTH }   /* sc=gothic */,
  {     0,   184,  7531,   2,   9, UNI_EMOTICONS }   /* isemoticons */,
  {     0,  1966,  4508,  22,  15, UNI_INSC__CONSONANTKILLER }   /* indicsyllabiccategory=consonantkiller */,
  {     1,  9556,  5746,   4,   5, UNI_WB__EB }   /* gcb=ebase */,
  {     3,  9277,  6481,   3,  12, UNI_HUNG }   /* sc=oldhungarian */,
  {     0,  4643,     0,  14,   0, UNI_ECOMP }   /* emojicomponent */,
  {     3,  2224,  8618,   3,   6, UNI_INSOYOMBO }   /* insoyombo */,
  {     5,  8780,  2817,   6,  19, UNI_MERO }   /* block=meroitichieroglyphs */,
  {     3,  8435,     1,   7,   1, -UNI_GRBASE }   /* grbase=n */,
  {     7,  8512,     0,   8,   0, UNI_NFKCQC__N }   /* nfkcqc=n */,
  {     0,    48,     0,   1,   0, UNI_P }   /* p */,
  {     1,  1812,  1025,  22,   2, -UNI_CWL }   /* changeswhenlowercased=no */,
  {     0,  7155,  2204,   3,   3, UNI_HAN }   /* ishani */,
  {     1,  9270,  2994,   5,  13, UNI_INPC__BOTTOMANDLEFT }   /* inpc=bottomandleft */,
  {     0,   184,  8456,   2,   7, UNI_KNDA }   /* iskannada */,
  {     0,  8762,    36,   6,   1, UNI_XPOSIXALPHA }   /* alpha=t */,
  {     2,  3937,     0,  11,   0, UNI_BOPOMOFOEXT }   /* bopomofoext */,
  {     7, 10024,  1066,   3,   2, UNI_CASEDLETTER }   /* gc=lc */,
  {     2,  8477,     0,   7,   0, UNI_MAKA }   /* makasar */,
  {     0,  9488,  2140,   4,  21, UNI_CYRILLICSUP }   /* blk=cyrillicsupplementary */,
  {     0,  8780,   446,   6,  18, UNI_IDEOGRAPHICSYMBOLS }   /* block=ideographicsymbols */,
  {     0,  9488,  9285,   4,   5, UNI_INLIMBU }   /* blk=limbu */,
  {     1,  5986,  7795,  13,   8, UNI_NV__3_SLASH_20 }   /* numericvalue=1.50e-01 */,
  {     0,  1417,  7477,  24,   9, UNI_CCC__AL }   /* canonicalcombiningclass=aboveleft */,
  {     0,  9997,  3700,   3,  17, UNI_BC__ES }   /* bc=europeanseparator */,
  {     2,   184,  6972,   2,  11, UNI_SYLO }   /* issylotinagri */,
  {     0,  5032,  9255,  14,   5, -UNI_POSIXXDIGIT }   /* asciihexdigit=false */,
  {     3,  8688,  3923,   4,   7, UNI_ARABICSUP }   /* isarabicsup */,
  {     0,  8780,  2931,   6,  19, UNI_SUPARROWSA }   /* block=supplementalarrowsa */,
  {     2,  9488,  2308,   4,  21, UNI_YIJING }   /* blk=yijinghexagramsymbols */,
  {     0,  5661,     0,  13,   0, UNI_AEGEANNUMBERS }   /* aegeannumbers */,
  {     5,  7076,  4479,   3,   6, UNI_BRAI }   /* inbraille */,
  {     0,   184,  4245,   2,  10, UNI_SM }   /* ismathsymbol */,
  {    13,  8780,  1585,   6,  14, UNI_BYZANTINEMUSIC }   /* block=byzantinemusic */,
  {     0,  9508,  9106,   5,   4, UNI_CCC__15 }   /* ccc=ccc15 */,
  {     2,  9768,  4385,   4,   6, UNI_TANG }   /* scx=tangut */,
  {     3,  1537,  3343,   4,   6, UNI_DINGBATS }   /* indingbats */,
  {     8,  9488,  2054,   4,  22, UNI_MODIFIERLETTERS }   /* blk=spacingmodifierletters */,
  {     4,   539,     0,  30,   0, UNI_CJKEXTB }   /* cjkunifiedideographsextensionb */,
  {     1,   184,  3439,   2,  12, UNI_SMALLKANAEXT }   /* issmallkanaext */,
  {     0,  1269,     3,  25,   1, -UNI_COMPEX }   /* fullcompositionexclusion=f */,
  {    26,  9275,  2646,   5,  19, UNI_INSC__CONSONANTHEADLETTER }   /* insc=consonantheadletter */,
  {     1,  5986,  9428,  13,   4, UNI_NV__3_SLASH_80 }   /* numericvalue=3/80 */,
  {     0,  8780,  8352,   7,   6, UNI_CJKEXTA }   /* block=cjkexta */,
  {     1,  8884,    26,   4,   1, UNI_EXT }   /* ext=y */,
  {     0,  9997,     8,   3,   2, UNI_BC__AN }   /* bc=an */,
  {     6,  9736,     0,   4,   0, UNI_COPT }   /* qaac */,
  {     0,  3097,  5012,  18,   6, UNI_DT__SQR }   /* decompositiontype=square */,
  {     1,  2119,     0,  21,   0, UNI_CJKRADICALSSUP }   /* cjkradicalssupplement */,
  {     0, 10048,  5648,   3,   6, UNI_NV__100000 }   /* nv=100000 */,
  {     9,  9270,  3481,   5,  12, UNI_INPC__LEFTANDRIGHT }   /* inpc=leftandright */,
  {     0,  8589,  2469,   7,  20, UNI_HMNP }   /* script=nyiakengpuachuehmong */,
  {     4,  9488,  6277,   4,   7, UNI_MAHJONG }   /* blk=mahjong */,
  {     6,  1552,   341,   9,   2, UNI_PE }   /* category=pe */,
  {     0,  3097,  8533,  18,   7, UNI_DT__NB }   /* decompositiontype=nobreak */,
  {     0,  3836,  6940,  18,  10, UNI_SORA }   /* scriptextensions=sorasompeng */,
  {     0,  4033,   467,  16,   5, UNI_P }   /* generalcategory=punct */,
  {     0,  8780,  3870,   6,  17, UNI_SMALLFORMS }   /* block=smallformvariants */,
  {     3, 10333,  2913,   3,   3, UNI_SUND }   /* issund */,
  {     2, 10024,   727,   3,   2, UNI_MN }   /* gc=mn */,
  {     2,  6231,    43,   3,   8, UNI_CJKCOMPAT }   /* incjkcompat */,
  {    17,  8589,  9797,   8,   3, UNI_SC__SYRC }   /* script=syrc */,
  {     1,  1417,  8811,  25,   4, UNI_CCC__12 }   /* canonicalcombiningclass=ccc12 */,
  {     1,  3379,    36,   6,   1, UNI_XPOSIXSPACE }   /* space=t */,
  {     1, 10296,  1867,   7,   5, UNI_POSIXUPPER }   /* isposixupper */,
  {     1,  3259,     3,  18,   1, -UNI_IDSB }   /* idsbinaryoperator=f */,
  {     3,  1417,  3007,  24,  13, UNI_CCC__214 }   /* canonicalcombiningclass=attachedabove */,
  {     1,  7028,  9039,   3,   5, UNI_YEZI }   /* isyezidi */,
  {     4,  7218,  4360,  10,   9, UNI_EMOD }   /* linebreak=emodifier */,
  {     1,  1417,  2455,  24,   5, UNI_CCC__R }   /* canonicalcombiningclass=right */,
  {     0,  1273, 10135,  21,   3, UNI_CE }   /* compositionexclusion=yes */,
  {     1,  8780,  8603,   6,   7, UNI_SHAW }   /* block=shavian */,
  {     3,  9768,  8876,   4,   4, UNI_GOTH }   /* scx=goth */,
  {     4,  2182,     0,  21,   0, UNI_gcb_values_index }   /* graphemeclusterbreak= */,
  {     0,  8780,  8652,   6,   7, UNI_INTAIVIET }   /* block=taiviet */,
  {     8,  9886,  5006,   5,  12, UNI_INZANABAZARSQUARE }   /* inzanabazarsquare */,
  {     0,  8589,  8638,   7,   7, UNI_SC__TGLG }   /* script=tagalog */,
  {    16,  1768,  1025,  22,   2, -UNI_CWCF }   /* changeswhencasefolded=no */,
  {     1,  2224,  2951,   3,  18, UNI_SUPARROWSB }   /* insupplementalarrowsb */,
  {     0,  6553,    36,  12,   1, UNI_XIDC }   /* xidcontinue=t */,
  {     1,  9564,     0,   4,   0, UNI_GONM }   /* gonm */,
  {     7,  8780,  8131,   6,   8, UNI_INDUPLOYAN }   /* block=duployan */,
  {     1,  9768,  8786,   4,   4, UNI_CARI }   /* scx=cari */,
  {     3,  9277,  1654,   3,   6, UNI_SC__HANG }   /* sc=hangul */,
  {     0,   184,  3421,   2,   4, UNI_RUMI }   /* isrumi */,
  {     3,  9768,  2817,   4,   4, UNI_MERO }   /* scx=mero */,
  {     0,   184,  3785,   2,   4, UNI_MANI }   /* ismani */,
  {    11,  9488,  5606,   4,  14, UNI_SUPPUNCTUATION }   /* blk=suppunctuation */,
  {     1, 10250,  6556,  15,   8, UNI__PERL_CHARNAME_CONTINUE }   /* _perl_charname_continue */,
  {     0,  8780,  8561,   6,   7, UNI_INOSMANYA }   /* block=osmanya */,
  {     1, 10027,  9044,   3,   6, UNI_JG__YUDHHE }   /* jg=yudhhe */,
  {     0,  9768,  8652,   4,   7, UNI_TAVT }   /* scx=taiviet */,
  {     0, 10012,  1192,   3,   9, UNI_EA__H }   /* ea=halfwidth */,
  {     3,  3836,  9704,  17,   4, UNI_ORKH }   /* scriptextensions=orkh */,
  {     1,  7318, 10108,  10,   3, UNI_IN__6_DOT_1 }   /* presentin=v61 */,
  {    12,  5791,  6349,  13,  12, UNI_JG__MALAYALAMSSA }   /* joininggroup=malayalamssa */,
  {     0, 10048,  8744,   3,   4, UNI_NV__7000 }   /* nv=7000 */,
  {     0,  3367,    36,  18,   1, UNI__PERL_PATWS }   /* patternwhitespace=t */,
  {     0,  4853,     0,  15,   0, UNI_nfkdqc_values_index }   /* nfkdquickcheck= */,
  {     2,  9488,   809,   4,  29, UNI_ENCLOSEDIDEOGRAPHICSUP }   /* blk=enclosedideographicsupplement */,
  {     4,   184,   749,   2,  30, UNI_ENCLOSEDALPHANUMSUP }   /* isenclosedalphanumericsupplement */,
  {     1,  9020, 10135,   6,   3, UNI_XPOSIXUPPER }   /* upper=yes */,
  {     1,  5986,  8750,  13,   5, UNI_NV__80000 }   /* numericvalue=80000 */,
  {     0,  9768,  8171,   4,   8, UNI_GUJR }   /* scx=gujarati */,
  {     0,  3379, 10135,   6,   3, UNI_XPOSIXSPACE }   /* space=yes */,
  {     1,  9768,  8582,   4,   7, UNI_PHAG }   /* scx=phagspa */,
  {     0,  3836,  3785,  17,  10, UNI_MANI }   /* scriptextensions=manichaean */,
  {     5,  9488,  4793,   4,  15, UNI_INMEROITICCURSIVE }   /* blk=meroiticcursive */,
  {     0,   184,  6277,   2,  12, UNI_MAHJONG }   /* ismahjongtiles */,
  {     0,  9997,  1353,   3,   3, UNI_BC__RLE }   /* bc=rle */,
  {     2,   184,  9245,   2,   4, UNI_DOGR }   /* isdogr */,
  {    32,  9768,  9644,   4,   4, UNI_MEDF }   /* scx=medf */,
  {     0,  9768,  6409,   4,  12, UNI_MEND }   /* scx=mendekikakui */,
  {     8, 10132,  5746,   3,   5, UNI_WB__EB }   /* wb=ebase */,
  {     0, 10048,  7826,   3,   2, UNI_NV__12 }   /* nv=12 */,
  {     6, 10132,  4856,   3,   2, UNI_WB__DQ }   /* wb=dq */,
  {     9, 10132,    34,   3,   6, UNI_WB__EXTEND }   /* wb=extend */,
  {     6, 10027,  4778,   3,  15, UNI_JG__MANICHAEANZAYIN }   /* jg=manichaeanzayin */,
  {     0,  8484,     0,   7,   0, UNI_MAND }   /* mandaic */,
  {     2,   184,  9888,   2,   4, UNI_ZANB }   /* iszanb */,
  {     1,  3367,  9255,  18,   5, -UNI__PERL_PATWS }   /* patternwhitespace=false */,
  {     1,  8589,  1222,   7,   4, UNI_SC__KANA }   /* script=kana */,
  {    11, 10024,  2061,   3,  14, UNI_LM }   /* gc=modifierletter */,
  {     2,  9488,  8786,   4,   6, UNI_INCARIAN }   /* blk=carian */,
  {     3,  9488,    78,   4,   6, UNI_INARABIC }   /* blk=arabic */,
  {     2,  5791,  7348,  13,  10, UNI_JG__REVERSEDPE }   /* joininggroup=reversedpe */,
  {     4, 10296,  5718,   7,   5, UNI_POSIXALNUM }   /* isposixalnum */,
  {     1,  8589,  6193,   7,   4, UNI_HEBR }   /* script=hebr */,
  {     2, 10048, 10142,   3,   2, UNI_NV__44 }   /* nv=44 */,
  {     1,  9070,  9255,   5,   5, -UNI_POSIXXDIGIT }   /* ahex=false */,
  {     5,  9768,  9452,   4,   4, UNI_AHOM }   /* scx=ahom */,
  {     6,  1966,  8307,  22,   8, UNI_INSC__TONEMARK }   /* indicsyllabiccategory=tonemark */,
  {     8,  2032,     0,  22,   0, UNI_nchar_values_index }   /* noncharactercodepoint= */,
  {     0,   184,  4049,   2,  16, UNI_GEORGIANEXT }   /* isgeorgianextended */,
  {     0,  9488,   539,   4,  30, UNI_CJKEXTB }   /* blk=cjkunifiedideographsextensionb */,
  {     0,   106,     0,   6,   0, UNI_S }   /* symbol */,
  {     1,  8780,  6481,   6,  12, UNI_INOLDHUNGARIAN }   /* block=oldhungarian */,
  {     2,  9997,     0,   4,   0, UNI_BC__B }   /* bc=b */,
  {     1,  8780,  6818,   6,  11, UNI_MYANMAREXTA }   /* block=myanmarexta */,
  {    12,  2760,  6763,  19,   3, UNI_LB__H3 }   /* hangulsyllabletype=lvt */,
  {     1,  8780,  4129,   6,   6, UNI_LATIN1 }   /* block=latin1 */,
  {     2,  5986,  7859,  13,   5, UNI_NV__20000 }   /* numericvalue=20000 */,
  {     6,  7218, 10158,  10,   2, UNI_LB__H2 }   /* linebreak=h2 */,
  {     0, 10048,  7931,   3,   8, UNI_NV__5_SLASH_12 }   /* nv=4.17e-01 */,
  {    10,  4916,  9817,   3,   3, UNI_TAVT }   /* istavt */,
  {     0,  4033,    25,  16,   1, UNI_S }   /* generalcategory=s */,
  {     1,  8131,     0,   8,   0, UNI_DUPL }   /* duployan */,
  {     1,  9716,    26,   4,   1, UNI_PCM }   /* pcm=y */,
  {     8, 10180,     0,   2,   0, UNI_ZS }   /* zs */,
  {     1,  9488,  3921,   4,  16, UNI_ARABICSUP }   /* blk=arabicsupplement */,
  {     2, 10322,  3379,   5,   5, UNI_XPOSIXSPACE }   /* xperlspace */,
  {     1,   184,   183,   2,  20, UNI_MISCSYMBOLS }   /* ismiscellaneoussymbols */,
  {     0,  7318,  7931,  10,   3, UNI_IN__4_DOT_1 }   /* presentin=4.1 */,
  {     3,  8978,     0,   5,   0, UNI__PERL_PATWS }   /* patws */,
  {     0,  9556,    34,   4,   2, UNI_GCB__EX }   /* gcb=ex */,
  {     4,  9020,     1,   6,   1, -UNI_XPOSIXUPPER }   /* upper=n */,
  {     0,  5986,  8710,  13,   2, UNI_NV__60 }   /* numericvalue=60 */,
  {     0,  9544,     0,   4,   0, UNI_DIAK }   /* diak */,
  {     0, 10308,     0,   5,   0, UNI_XPOSIXPRINT }   /* print */,
  {     2,  1966,  5634,  22,  14, UNI_INSC__VOWELDEPENDENT }   /* indicsyllabiccategory=voweldependent */,
  {     1,  4033,  1171,  16,   2, UNI_TITLE }   /* generalcategory=lt */,
  {     4,  6231,  6098,   3,  11, UNI_CYRILLICEXTA }   /* incyrillicexta */,
  {     0,  7325,  9852,   3,   4, UNI_IN__12_DOT_1 }   /* in=v121 */,
  {     1,  5564,    36,  14,   1, UNI_QMARK }   /* quotationmark=t */,
  {     0,  9091,  8133,   4,   6, UNI_INDUPLOYAN }   /* induployan */,
  {     0,  8780,  2308,   6,  21, UNI_YIJING }   /* block=yijinghexagramsymbols */,
  {     8,  8930, 10135,   6,   3, UNI_XPOSIXLOWER }   /* lower=yes */,
  {     0,  8954, 10135,   6,   3, UNI__PERL_NCHAR }   /* nchar=yes */,
  {     2,   184,     3,   3,   1, UNI_CF }   /* iscf */,
  {     1,  8589,  3169,   7,   4, UNI_ETHI }   /* script=ethi */,
  {     7,  9637,  5690,   5,  10, UNI_BLOCKELEMENTS }   /* inblockelements */,
  {     0,  9508,  9111,   5,   4, UNI_CCC__16 }   /* ccc=ccc16 */,
  {     5,  8589,  9644,   7,   4, UNI_MEDF }   /* script=medf */,
  {     8,  5466,     0,  15,   0, UNI_DT__CAN }   /* nfdquickcheck=n */,
  {     1,  8589,  3079,   7,   6, UNI_SC__COPT }   /* script=coptic */,
  {    10,  8688,   183,   4,   2, UNI_ARMI }   /* isarmi */,
  {     4,  8589,  4703,   7,  15, UNI_ARMI }   /* script=imperialaramaic */,
  {     0,  3836,  9285,  17,   4, UNI_LIMB }   /* scriptextensions=limb */,
  {     0,  8589,  6884,   7,  11, UNI_HMNG }   /* script=pahawhhmong */,
  {    17,   184,  1033,   2,  27, UNI_ENCLOSEDCJK }   /* isenclosedcjklettersandmonths */,
  {     1,  8589,  9720,   7,   4, UNI_SC__PHLP }   /* script=phlp */,
  {     1,   339,     0,   2,   0, UNI_LO }   /* lo */,
  {     3,  9488,   838,   4,  29, UNI_MISCARROWS }   /* blk=miscellaneoussymbolsandarrows */,
  {     4,  8966,    26,   6,   1, UNI_NFDQC__Y }   /* nfdqc=y */,
  {     1,  8780,  4369,   6,  16, UNI_SYRIACSUP }   /* block=syriacsupplement */,
  {     1,  1417,  9151,  25,   4, UNI_CCC__24 }   /* canonicalcombiningclass=ccc24 */,
  {     0,    21,  5200,   2,   7, UNI_KANASUP }   /* inkanasup */,
  {     5,  1273,     0,  20,   0, UNI_CE }   /* compositionexclusion */,
  {     1,  8780,  2950,   6,  19, UNI_SUPARROWSB }   /* block=supplementalarrowsb */,
  {     1,  3457,     0,  11,   0, UNI_TAIXUANJING }   /* taixuanjing */,
  {     0,  5578,    36,  15,   1, UNI_SB__ST }   /* sentencebreak=st */,
  {     2,   184,    43,   3,  35, UNI_CJKCOMPATIDEOGRAPHSSUP }   /* iscjkcompatibilityideographssupplement */,
  {     0,   184,  4478,   2,   7, UNI_BRAI }   /* isbraille */,
  {     1,  8589,  4385,   7,   6, UNI_TANG }   /* script=tangut */,
  {     0, 10033,  9713,   3,   2, UNI_LB__SG }   /* lb=sg */,
  {     0,  1192,     0,  26,   0, UNI_HALFANDFULLFORMS }   /* halfwidthandfullwidthforms */,
  {     2,    38,     0,   2,   0, UNI_XPOSIXDIGIT }   /* nd */,
  {     1,  8589,  9305,   7,   5, UNI_NSHU }   /* script=nushu */,
  {     1,  9270,     9,   5,   2, UNI_INPC__NA }   /* inpc=na */,
  {     4,  1552,  2268,   9,   2, UNI_PD }   /* category=pd */,
  {     0,   629,     0,  30,   0, UNI_CJKEXTE }   /* cjkunifiedideographsextensione */,
  {    12,  7249,  5062,   4,  11, UNI_CI }   /* iscaseignorable */,
  {     3,  5986,  9412,  13,   4, UNI_NV__17_SLASH_2 }   /* numericvalue=17/2 */,
  {     0,  8589,  9588,   7,   4, UNI_HMNG }   /* script=hmng */,
  {     1,  7325,  9848,   3,   4, UNI_IN__12 }   /* in=v120 */,
  {     0,  8780,  8275,   6,   8, UNI_SPECIALS }   /* block=specials */,
  {     6,  9488,  7428,   4,  10, UNI_INWARANGCITI }   /* blk=warangciti */,
  {     6,  7228,     1,  10,   1, -UNI_XPOSIXLOWER }   /* lowercase=n */,
  {     6,  5986,  8726,  13,   6, UNI_NV__432000 }   /* numericvalue=432000 */,
  {     1,  1537,  6621,   3,  10, UNI_DOMINO }   /* indominotiles */,
  {     0,  9540,     3,   4,   1, -UNI_DIA }   /* dia=f */,
  {     0,  7155,  1514,   3,  23, UNI_HIGHPUSURROGATES }   /* ishighprivateusesurrogates */,
  {     0,  5032,  9836,  14,   4, UNI_POSIXXDIGIT }   /* asciihexdigit=true */,
  {     0, 10033, 10154,   3,   2, UNI_LB__B2 }   /* lb=b2 */,
  {     6,  3904,     0,  17,   0, UNI_uideo_values_index }   /* unifiedideograph= */,
  {     1,  3385,  9255,  18,   5, -UNI_RI }   /* regionalindicator=false */,
  {     0,  9488,  3734,   4,  17, UNI_INDICSIYAQNUMBERS }   /* blk=indicsiyaqnumbers */,
  {     2,  9860,     0,   4,   0, UNI_VAI }   /* vaii */,
  {     4,  5791,  4209,  13,  16, UNI_JG__MANICHAEANSAMEKH }   /* joininggroup=manichaeansamekh */,
  {     0,  5791,    87,  13,   2, UNI_JG__HE }   /* joininggroup=he */,
  {     0,  8589,  9335,   7,   5, UNI_SC__TAKR }   /* script=takri */,
  {    13,  9277,  9708,   3,   4, UNI_SC__ORYA }   /* sc=orya */,
  {     1,  9277,  2061,   3,   4, UNI_SC__MODI }   /* sc=modi */,
  {     2, 10027,  6785,   3,  11, UNI_JG__MALAYALAMRA }   /* jg=malayalamra */,
  {     1,  7567,     0,   9,   0, UNI_SIND }   /* khudawadi */,
  {     0,   184,   728,   2,   6, UNI_N }   /* isnumber */,
  {     0,  9708,     0,   4,   0, UNI_ORYA }   /* orya */,
  {     1,  1906,     0,  16,   0, UNI_INDICNUMBERFORMS }   /* indicnumberforms */,
  {     0,  8780,  8924,   6,   6, UNI_INLEPCHA }   /* block=lepcha */,
  {     0, 10048,  9050,   3,   4, UNI_NV__1_SLASH_16 }   /* nv=1/16 */,
  {     0, 10288,  5718,   8,   5, UNI_XPOSIXALNUM }   /* isxposixalnum */,
  {     6,  9488,  5661,   4,  13, UNI_AEGEANNUMBERS }   /* blk=aegeannumbers */,
  {     8,  3983,     0,  18,   0, UNI_PE }   /* isclosepunctuation */,
  {    11,  3097,  4532,  18,   6, UNI_DT__MED }   /* decompositiontype=medial */,
  {     0, 10132,  6169,   3,  12, UNI_WB__EB }   /* wb=glueafterzwj */,
  {     0,  5791,  5895,  13,  13, UNI_JG__MANICHAEANONE }   /* joininggroup=manichaeanone */,
  {     0,  8954,     3,   6,   1, -UNI__PERL_NCHAR }   /* nchar=f */,
  {     3,  4658,    36,  15,   1, UNI_GREXT }   /* graphemeextend=t */,
  {     2,  7418, 10135,  10,   3, UNI_XPOSIXUPPER }   /* uppercase=yes */,
  {     1, 10296,     0,   4,   0, UNI_PO }   /* ispo */,
  {     0,  8589,  3785,   7,   4, UNI_SC__MANI }   /* script=mani */,
  {     1,  3836,  4703,  17,  15, UNI_ARMI }   /* scriptextensions=imperialaramaic */,
  {     1,  2224,  2932,   3,  18, UNI_SUPARROWSA }   /* insupplementalarrowsa */,
  {    13,  8780,  4401,   6,   9, UNI_TANGUTSUP }   /* block=tangutsup */,
  {     8,  8780,  7129,   7,   9, UNI_CJKSTROKES }   /* block=cjkstrokes */,
  {     0,    21,  8211,   2,   8, UNI_JAMOEXTB }   /* injamoextb */,
  {     0,    45,     0,   2,   0, UNI_CO }   /* co */,
  {     4,  3097,  6421,  18,   8, UNI_DT__NONCANON }   /* decompositiontype=noncanon */,
  {    16,   184,  1166,   2,  25, UNI_DI }   /* isdefaultignorablecodepoint */,
  {     2,  9277,  9860,   3,   3, UNI_VAI }   /* sc=vai */,
  {     1,  8491,     0,   7,   0, UNI_MARC }   /* marchen */,
  {     4,   184,  5564,   2,  13, UNI_QMARK }   /* isquotationmark */,
  {     2, 10024,  5713,   3,  13, UNI_XPOSIXDIGIT }   /* gc=decimalnumber */,
  {     1, 10033,   184,   3,   2, UNI_LB__IS }   /* lb=is */,
  {     1,  9315,     0,   5,   0, UNI_ORYA }   /* oriya */,
  {     0,  9812,     0,   4,   0, UNI_TAML }   /* taml */,
  {     0,  4989,  1868,   3,   4, UNI_XPOSIXUPPER }   /* isupper */,
  {     0,  5986,  5648,  13,   5, UNI_NV__10000 }   /* numericvalue=10000 */,
  {    16,  8780,  3026,   7,  10, UNI_CHEROKEESUP }   /* block=cherokeesup */,
  {     1,  8780,  8610,   6,   7, UNI_INSIDDHAM }   /* block=siddham */,
  {     1,  2161,     3,  21,   1, -UNI_EXTPICT }   /* extendedpictographic=f */,
  {     1,  9488,  8091,   4,   8, UNI_INARMENIAN }   /* blk=armenian */,
  {     1,  9277,  9065,   3,   5, UNI_SC__ADLM }   /* sc=adlam */,
  {    12,  3836,  8344,  17,   7, UNI_BENG }   /* scriptextensions=bengali */,
  {     0,  2032,     0,  21,   0, UNI__PERL_NCHAR }   /* noncharactercodepoint */,
  {     8,  3421,     0,  18,   0, UNI_RUMI }   /* ruminumeralsymbols */,
  {     1,  9277,  8115,   3,   4, UNI_BASS }   /* sc=bass */,
  {     1,   184,  3169,   2,   8, UNI_ETHI }   /* isethiopic */,
  {     0,  3836,  9824,  17,   4, UNI_TGLG }   /* scriptextensions=tglg */,
  {     0,   184,  8942,   2,   4, UNI_LYDI }   /* islydi */,
  {     0,  1812,     0,  22,   0, UNI_cwl_values_index }   /* changeswhenlowercased= */,
  {     3,  7318, 10105,  10,   3, UNI_IN__6 }   /* presentin=v60 */,
  {     5, 10296,  9721,   3,   3, UNI_PHLP }   /* isphlp */,
  {     3, 10132,  7603,   3,   9, UNI_WB__ML }   /* wb=midletter */,
  {     4,  2224,  7694,   3,   8, UNI_INSAMARITAN }   /* insamaritan */,
  {     4, 10048, 10148,   3,   2, UNI_NV__47 }   /* nv=47 */,
  {     1,  5986,  9409,  13,   3, UNI_NV__5_SLASH_2 }   /* numericvalue=5/2 */,
  {     5,   184,  4448,   2,   8, UNI_BAMUMSUP }   /* isbamumsup */,
  {     2,  9488,   509,   4,  30, UNI_CJKEXTA }   /* blk=cjkunifiedideographsextensiona */,
  {     0, 10027,  4733,   3,  15, UNI_JG__MANICHAEANALEPH }   /* jg=manichaeanaleph */,
  {    13, 10033, 10030,   3,   2, UNI_GCB__T }   /* lb=jt */,
  {     1,  9277,  6840,   3,   4, UNI_SC__NAND }   /* sc=nand */,
  {     2,  9997,  2798,   3,  19, UNI_BC__LRO }   /* bc=lefttorightoverride */,
  {     4,  1269, 10135,  25,   3, UNI_COMPEX }   /* fullcompositionexclusion=yes */,
  {     1,  8780,  2684,   6,  19, UNI_INEGYPTIANHIEROGLYPHS }   /* block=egyptianhieroglyphs */,
  {     0,  8589,  8611,   8,   3, UNI_SIDD }   /* script=sidd */,
  {    15,  1591,  2685,   3,  18, UNI_INEGYPTIANHIEROGLYPHS }   /* inegyptianhieroglyphs */,
  {     0, 10027,  7198,   3,  10, UNI_JG__KNOTTEDHEH }   /* jg=knottedheh */,
  {     1,  8589,  8611,   8,   6, UNI_SIDD }   /* script=siddham */,
  {     0,  9065,     0,   5,   0, UNI_ADLM }   /* adlam */,
  {     1,  8589,  6973,   8,   3, UNI_SC__SYLO }   /* script=sylo */,
  {     0,  1114,    26,  26,   1, UNI_CWKCF }   /* changeswhennfkccasefolded=y */,
  {     1,  9768,  2288,   5,   3, UNI_SINH }   /* scx=sinh */,
  {     7, 10009,  6421,   3,   8, UNI_DT__NONCANON }   /* dt=noncanon */,
  {     0,  9768,  8115,   4,   4, UNI_BASS }   /* scx=bass */,
  {    16,  6231,   720,   3,   8, UNI_INCUNEIFORM }   /* incuneiform */,
  {    19,  1417,  9211,  25,   4, UNI_CCC__36 }   /* canonicalcombiningclass=ccc36 */,
  {     9,  2569,  3511,  20,  18, UNI_VO__TU }   /* verticalorientation=transformedupright */,
  {     2,  2529,     1,  20,   1, -UNI_TERM }   /* terminalpunctuation=n */,
  {     0,   184,  1911,   2,  11, UNI_NUMBERFORMS }   /* isnumberforms */,
  {     0,  3836,  5843,  17,   9, UNI_MLYM }   /* scriptextensions=malayalam */,
  {     1,  9508,  9300,   4,   5, UNI_CCC__7 }   /* ccc=nukta */,
  {     0,  5674,     1,  13,   1, -UNI_BIDIM }   /* bidimirrored=n */,
  {     0, 10132,  1218,   3,   2, UNI_WB__KA }   /* wb=ka */,
  {     6, 10182,    25,  29,   1, UNI__PERL_PROBLEMATIC_LOCALE_FOLDS }   /* _perl_problematic_locale_folds */,
  {     0,  6554,    36,  11,   1, UNI_IDC }   /* idcontinue=t */,
  {     0,  1417,  8813,  24,   3, UNI_CCC__122 }   /* canonicalcombiningclass=122 */,
  {     1,  7218, 10160,  10,   2, UNI_LB__H3 }   /* linebreak=h3 */,
  {    14,   184,  9496,   2,   4, UNI_BUHD }   /* isbuhd */,
  {    21,  6231,   720,   3,  15, UNI_CUNEIFORMNUMBERS }   /* incuneiformnumbers */,
  {     1,  9277,  9712,   3,   4, UNI_OSGE }   /* sc=osge */,
  {     1, 10178,     0,   2,   0, UNI_ZP }   /* zp */,
  {     5,  9488,  8840,   4,   6, UNI_INCHAKMA }   /* blk=chakma */,
  {     2,  8589,  2429,   7,  20, UNI_PHLI }   /* script=inscriptionalpahlavi */,
  {     1,  5791,  4081,  13,  16, UNI_JG__HANIFIROHINGYAPA }   /* joininggroup=hanifirohingyapa */,
  {     2,  6928, 10135,  11,   3, UNI_SD }   /* softdotted=yes */,
  {     1,  7088,  3403,  10,  18, UNI_BC__RLI }   /* bidiclass=righttoleftisolate */,
  {     1,  8589,  1537,   8,   3, UNI_SC__SIND }   /* script=sind */,
  {     0,  5986,  9428,  13,   3, UNI_NV__3_SLASH_8 }   /* numericvalue=3/8 */,
  {     4,  3836,  4478,  17,   4, UNI_BRAI }   /* scriptextensions=brai */,
  {     0,  8984,    36,   6,   1, UNI_QMARK }   /* qmark=t */,
  {     0,  4791,  8499,   3,   6, UNI_INMULTANI }   /* inmultani */,
  {     9, 10024,  1899,   3,   2, UNI_PC }   /* gc=pc */,
  {     2,  3836,  9624,  17,   4, UNI_LAO }   /* scriptextensions=laoo */,
  {     4,  9488,  8526,   4,   7, UNI_NB }   /* blk=noblock */,
  {     1,  9277,  9038,   3,   6, UNI_SC__YEZI }   /* sc=yezidi */,
  {     2,  9768,  8611,   5,   6, UNI_SIDD }   /* scx=siddham */,
  {     0,  2741,     0,  19,   0, UNI_JAMOEXTB }   /* hanguljamoextendedb */,
  {     8,  8589,  1013,   7,   5, UNI_SC__GREK }   /* script=greek */,
  {     1,  9488,  7378,   4,  10, UNI_SUPARROWSA }   /* blk=suparrowsa */,
  {     0, 10290, 10308,   6,   5, UNI_XPOSIXPRINT }   /* xposixprint */,
  {     1,  5060,    26,  14,   1, UNI_CI }   /* caseignorable=y */,
  {     3,   184,  2245,   2,  11, UNI_MTEI }   /* ismeeteimayek */,
  {     1, 10063,     3,   3,   1, -UNI_SD }   /* sd=f */,
  {     6,  7318,  7923,  10,   3, UNI_IN__4 }   /* presentin=4.0 */,
  {     1,  8589,  4448,   7,   5, UNI_BAMU }   /* script=bamum */,
  {     1,  5986,  8750,  13,   2, UNI_NV__80 }   /* numericvalue=80 */,
  {     0,  9768,  9544,   4,   4, UNI_DIAK }   /* scx=diak */,
  {     0,  7155,  1418,   3,   3, UNI_HANO }   /* ishano */,
  {     3,  8780,  1442,   7,   9, UNI_CJKSYMBOLS }   /* block=cjksymbols */,
  {     0, 10009,  4017,   3,   3, UNI_DT__FIN }   /* dt=fin */,
  {     6,  8589,  7675,   7,   9, UNI_PALM }   /* script=palmyrene */,
  {     0,  9488,  7657,   4,   9, UNI_INOLDPERMIC }   /* blk=oldpermic */,
  {     4,  1417,  7178,  24,   4, UNI_CCC__6 }   /* canonicalcombiningclass=hanr */,
  {     0,  6862,     0,  11,   0, UNI_NO }   /* othernumber */,
  {     0,   867,     0,  18,   0, UNI_PHONETICEXT }   /* phoneticextensions */,
  {     0, 10009,  3501,   3,   3, UNI_DT__MED }   /* dt=med */,
  {     5,  1417,  9156,  25,   4, UNI_CCC__25 }   /* canonicalcombiningclass=ccc25 */,
  {     3,  5986,  9055,  13,   5, UNI_NV__1_SLASH_320 }   /* numericvalue=1/320 */,
  {     0,  8589,  6792,   8,   3, UNI_SAMR }   /* script=samr */,
  {     0,  9488,  8463,   4,   7, UNI_KALI }   /* blk=kayahli */,
  {    24,  7076,  3938,   3,  10, UNI_BOPOMOFOEXT }   /* inbopomofoext */,
  {     1,  9508,     0,   4,   0, UNI_ccc_values_index }   /* ccc= */,
  {     1,  8780,  2969,   6,  19, UNI_SUPARROWSC }   /* block=supplementalarrowsc */,
  {    21,  4628,  4471,  15,   7, UNI_EA__N }   /* eastasianwidth=neutral */,
  {     2,  9277,  9038,   3,   4, UNI_SC__YEZI }   /* sc=yezi */,
  {     1,  8780,  5158,   6,  14, UNI_INGREEK }   /* block=greekandcoptic */,
  {     4,  9508,  9116,   5,   4, UNI_CCC__17 }   /* ccc=ccc17 */,
  {     5,  8780,  8366,   7,   6, UNI_CJKEXTC }   /* block=cjkextc */,
  {     0,   599,     0,  30,   0, UNI_CJKEXTD }   /* cjkunifiedideographsextensiond */,
  {     0,    21,  8219,   2,   8, UNI_INJAVANESE }   /* injavanese */,
  {     0,  9262,    34,   3,   6, UNI_SB__EX }   /* sb=extend */,
  {     1,  7438, 10174,  10,   2, UNI_WB__XX }   /* wordbreak=xx */,
  {     0,  8589,  7684,   7,   9, UNI_PAUC }   /* script=paucinhau */,
  {     0,  6469,    39,  12,   2, UNI_XPOSIXDIGIT }   /* numerictype=de */,
  {     0, 10003,     0,   3,   0, UNI_ci_values_index }   /* ci= */,
  {     0,  9488,  6253,   4,   5, UNI_INKHMER }   /* blk=khmer */,
  {     0,  9015,    36,   5,   1, UNI_IDEO }   /* ideo=t */,
  {     0,  1189,    39,   3,   2, UNI_XPOSIXDIGIT }   /* nt=de */,
  {     1,  4916,  8646,   3,   6, UNI_LANA }   /* istaitham */,
  {     4,  6193,     0,   6,   0, UNI_HEBR }   /* hebrew */,
  {     2,  7318,  9396,  10,   4, UNI_IN__12_DOT_1 }   /* presentin=12.1 */,
  {     7,  9488,  2703,   4,  19, UNI_ENCLOSEDALPHANUMSUP }   /* blk=enclosedalphanumsup */,
  {     8,  9277,  7558,   3,   9, UNI_SC__QAAI }   /* sc=inherited */,
  {     0,  8780,  3734,   6,  17, UNI_INDICSIYAQNUMBERS }   /* block=indicsiyaqnumbers */,
  {     1,  1269,  1025,  25,   2, -UNI_COMPEX }   /* fullcompositionexclusion=no */,
  {     1,  8966,     0,   8,   0, UNI_DT__CAN }   /* nfdqc=no */,
  {     0, 10033,  1186,   3,   2, UNI_LB__PO }   /* lb=po */,
  {     1,  8780,   114,   7,  34, UNI_DIACRITICALSFORSYMBOLS }   /* block=combiningdiacriticalmarksforsymbols */,
  {     0,  1184,     0,   3,   0, UNI_DEP }   /* dep */,
  {     1,  3836,  9560,  17,   4, UNI_GONG }   /* scriptextensions=gong */,
  {    35,  9070,    36,   5,   1, UNI_POSIXXDIGIT }   /* ahex=t */,
  {     0,  9768,  9572,   4,   4, UNI_GUJR }   /* scx=gujr */,
  {     0,   184,  9736,   2,   4, UNI_COPT }   /* isqaac */,
  {     0,  7249,    12,   5,   3, UNI_CARI }   /* iscarian */,
  {     3, 10027,   341,   3,   2, UNI_JG__PE }   /* jg=pe */,
  {     1, 10027,  5480,   3,  14, UNI_JG__NOJOININGGROUP }   /* jg=nojoininggroup */,
  {     0,  7325, 10120,   3,   3, UNI_IN__8 }   /* in=v80 */,
  {     2,  8780,  4340,   6,  13, UNI_MATHOPERATORS }   /* block=mathoperators */,
  {     3,  9492,  5904,   4,   4, UNI_BPT__N }   /* bpt=none */,
  {     4,   184,  8179,   2,   8, UNI_GURU }   /* isgurmukhi */,
  {     0,  9346, 10135,   4,   3, UNI_IDC }   /* idc=yes */,
  {     4,  7076,  1219,   3,   4, UNI_INBATAK }   /* inbatak */,
  {     5,  6928,     3,  11,   1, -UNI_SD }   /* softdotted=f */,
  {     0,   184,  9680,   2,   4, UNI_NBAT }   /* isnbat */,
  {     0,  9488,  4369,   4,  16, UNI_SYRIACSUP }   /* blk=syriacsupplement */,
  {     1,  8780,  5214,   6,   6, UNI_KANGXI }   /* block=kangxi */,
  {     1, 10132,    34,   3,   2, UNI_WB__EX }   /* wb=ex */,
  {     3,  9768,  8219,   4,   4, UNI_JAVA }   /* scx=java */,
  {     9,  9768,  3751,   4,  17, UNI_KITS }   /* scx=khitansmallscript */,
  {     5,  9556,  5633,   4,   2, UNI_LB__H2 }   /* gcb=lv */,
  {     3, 10132,  8144,   3,   3, UNI_WB__EB }   /* wb=gaz */,
  {     1,  4385,     0,   4,   0, UNI_TANG }   /* tang */,
  {     1,  3734,     0,  17,   0, UNI_INDICSIYAQNUMBERS }   /* indicsiyaqnumbers */,
  {     0,  9488,  4385,   4,  16, UNI_TANGUTCOMPONENTS }   /* blk=tangutcomponents */,
  {     8, 10048,  8756,   3,   4, UNI_NV__9000 }   /* nv=9000 */,
  {     6,  8780,  3457,   6,  18, UNI_TAIXUANJING }   /* block=taixuanjingsymbols */,
  {     2,   184,  3026,   3,  17, UNI_CHEROKEESUP }   /* ischerokeesupplement */,
  {     0,  9488,  8624,   4,   7, UNI_SUPPUAA }   /* blk=suppuaa */,
  {     1,  8774,  1025,   6,   2, -UNI_BIDIM }   /* bidim=no */,
  {     2,  7438,   108,  10,   2, UNI_WB__MB }   /* wordbreak=mb */,
  {     2,  1910,     0,   2,   0, UNI_CN }   /* cn */,
  {     4,  5564, 10135,  14,   3, UNI_QMARK }   /* quotationmark=yes */,
  {     1,  7218,     3,  11,   1, UNI_LB__LF }   /* linebreak=lf */,
  {     5,  4116,  5779,   3,  12, UNI_IPAEXT }   /* isipaextensions */,
  {     8,  9262,   138,   3,   2, UNI_SB__FO }   /* sb=fo */,
  {     0,  3097,  3439,  18,   5, UNI_DT__SML }   /* decompositiontype=small */,
  {    10,  8589,  6385,   7,  12, UNI_SC__GONM }   /* script=masaramgondi */,
  {     5,  4791,  2856,   3,  11, UNI_MONGOLIANSUP }   /* inmongoliansup */,
  {     2,  8780,  6397,   6,  12, UNI_MATHALPHANUM }   /* block=mathalphanum */,
  {    10,  8589,  2409,   7,  10, UNI_SC__GLAG }   /* script=glagolitic */,
  {     0,  8589,  9692,   7,   4, UNI_NSHU }   /* script=nshu */,
  {     0,  8780,  8491,   6,   7, UNI_INMARCHEN }   /* block=marchen */,
  {     4,  9488,  2329,   4,  20, UNI_INANATOLIANHIEROGLYPHS }   /* blk=anatolianhieroglyphs */,
  {    18,  3836,  9616,  17,   4, UNI_KTHI }   /* scriptextensions=kthi */,
  {     1,  6420,  6482,   3,  11, UNI_INOLDHUNGARIAN }   /* inoldhungarian */,
  {     0,  1505,  2254,   5,   5, UNI_GREEKEXT }   /* ingreekext */,
  {     2,   184,  8526,   2,   7, UNI_NB }   /* isnoblock */,
  {     0,   719,     0,  16,   0, UNI_CUNEIFORMNUMBERS }   /* cuneiformnumbers */,
  {    20,  9488,  2741,   4,  19, UNI_JAMOEXTB }   /* blk=hanguljamoextendedb */,
  {     0,  4688,  8259,  15,   8, UNI_IDENTIFIERTYPE__OBSOLETE }   /* identifiertype=obsolete */,
  {     8,  9488,  3921,   4,   9, UNI_ARABICSUP }   /* blk=arabicsup */,
  {     2,  5060, 10135,  14,   3, UNI_CI }   /* caseignorable=yes */,
  {     3,  9488,  7388,   4,  10, UNI_SUPARROWSB }   /* blk=suparrowsb */,
  {     9,  4033, 10178,  16,   2, UNI_ZP }   /* generalcategory=zp */,
  {     4,  8589,  8477,   7,   7, UNI_MAKA }   /* script=makasar */,
  {     0,  6469,   495,  12,   2, UNI_NT__NU }   /* numerictype=nu */,
  {    18, 10027,  5843,   3,  13, UNI_JG__MALAYALAMLLLA }   /* jg=malayalamllla */,
  {     0,  8780,  3052,   6,   9, UNI_HALFMARKS }   /* block=halfmarks */,
  {     2,  8780,   283,   6,  33, UNI_MISCMATHSYMBOLSB }   /* block=miscellaneousmathematicalsymbolsb */,
  {     3,  8978,    36,   6,   1, UNI__PERL_PATWS }   /* patws=t */,
  {     8,  3836,  8652,  17,   7, UNI_TAVT }   /* scriptextensions=taiviet */,
  {     5,  9444,  7408,   4,  10, UNI_AGE__NA }   /* age=unassigned */,
  {    10,  9260,     3,   5,   1, -UNI_IDSB }   /* idsb=f */,
  {     8,  4628,   865,  15,   1, UNI_EA__W }   /* eastasianwidth=w */,
  {     1,  9768,  6840,   4,  11, UNI_NAND }   /* scx=nandinagari */,
  {     2, 10048, 10146,   3,   2, UNI_NV__46 }   /* nv=46 */,
  {     2,  9230,  9836,   5,   4, UNI_CWCF }   /* cwcf=true */,
  {     4,  8894, 10135,   6,   3, UNI_JOINC }   /* joinc=yes */,
  {     3,  2032,    26,  22,   1, UNI__PERL_NCHAR }   /* noncharactercodepoint=y */,
  {     0,   184,  1066,   2,   2, UNI_CASEDLETTER }   /* islc */,
  {     4, 10048,  7877,   3,   2, UNI_NV__13 }   /* nv=13 */,
  {     0,  8780,  5214,   6,  14, UNI_KANGXI }   /* block=kangxiradicals */,
  {     0,  3836,  9320,  17,   5, UNI_OSGE }   /* scriptextensions=osage */,
  {     1, 10024,     0,   3,   0, UNI_gc_values_index }   /* gc= */,
  {     1,    21,  7594,   2,   9, UNI_LATINEXTD }   /* inlatinextd */,
  {     6,  9488,  5214,   4,   6, UNI_KANGXI }   /* blk=kangxi */,
  {     8,  9508,  3564,   4,  17, UNI_WB__EB }   /* ccc=attachedbelowleft */,
  {    26,  6193,     0,   4,   0, UNI_HEBR }   /* hebr */,
  {     2,  4289,     0,  16,   0, UNI_MYANMAREXTB }   /* myanmarextendedb */,
  {     4,  9277,  9804,   3,   4, UNI_SC__TALE }   /* sc=tale */,
  {     0,  9230,     3,   5,   1, -UNI_CWCF }   /* cwcf=f */,
  {    16,  6231,  7119,   3,   9, UNI_INCHORASMIAN }   /* inchorasmian */,
  {     2, 10048,  5648,   3,   2, UNI_NV__10 }   /* nv=10 */,
  {     0,  4916,  4402,   3,   8, UNI_TANGUTSUP }   /* istangutsup */,
  {     0,  8449, 10135,   7,   3, UNI_HYPHEN }   /* hyphen=yes */,
  {    16, 10182, 10270,   6,   9, UNI__PERL_ANY_FOLDS }   /* _perl_any_folds */,
  {     0, 10027,  9884,   3,   4, UNI_JG__ZAIN }   /* jg=zain */,
  {    12, 10250, 10265,  15,   5, UNI__PERL_CHARNAME_BEGIN }   /* _perl_charname_begin */,
  {     0,  3836,   719,  17,   9, UNI_XSUX }   /* scriptextensions=cuneiform */,
  {     0,  4033,   727,  16,   2, UNI_MN }   /* generalcategory=mn */,
  {     0,   184,  3044,   3,  17, UNI_HALFMARKS }   /* iscombininghalfmarks */,
  {    11,  7249,  1017,   4,   2, UNI_CAKM }   /* iscakm */,
  {     0,  7358,     0,  10,   0, UNI_SAUR }   /* saurashtra */,
  {     0, 10027,  5921,   3,  13, UNI_JG__MANICHAEANTEN }   /* jg=manichaeanten */,
  {     1,  9277,  2608,   3,   6, UNI_BRAH }   /* sc=brahmi */,
  {     0,    21,  4129,   2,   9, UNI_LATIN1 }   /* inlatin1sup */,
  {     0,  7531,     0,   9,   0, UNI_EMOTICONS }   /* emoticons */,
  {    13,  3836,  2608,  17,   4, UNI_BRAH }   /* scriptextensions=brah */,
  {     4,  9640,  9255,   4,   5, -UNI_LOE }   /* loe=false */,
  {     0,  8780,  3583,   8,  15, UNI_UCAS }   /* block=canadiansyllabics */,
  {     0,  9592,     0,   4,   0, UNI_HMNP }   /* hmnp */,
  {     9, 10027,  2637,   3,   3, UNI_JG__YEH }   /* jg=yeh */,
  {     3,  8780,  6939,   6,  11, UNI_INSORASOMPENG }   /* block=sorasompeng */,
  {     2,  6231,  6122,   3,  11, UNI_CYRILLICEXTC }   /* incyrillicextc */,
  {     4,  4033,  5817,  16,  13, UNI_ZL }   /* generalcategory=lineseparator */,
  {     1,  5791,  4733,  13,  15, UNI_JG__MANICHAEANALEPH }   /* joininggroup=manichaeanaleph */,
  {     1,  3836,    57,  17,   2, UNI_YI }   /* scriptextensions=yi */,
  {     5,  9444,  9396,   4,   4, UNI_AGE__12_DOT_1 }   /* age=12.1 */,
  {     1,  7318,  8043,  10,   3, UNI_IN__8 }   /* presentin=8.0 */,
  {     1,  5791,  6785,  13,  11, UNI_JG__MALAYALAMRA }   /* joininggroup=malayalamra */,
  {     0,  8870,     0,   5,   0, UNI_EPRES }   /* epres */,
  {     0,  8519,    26,   7,   1, UNI_DT__NONE }   /* nfkdqc=y */,
  {     2,  5578,  1823,  14,   5, UNI_SB__LO }   /* sentencebreak=lower */,
  {     1,  9277,  9728,   3,   4, UNI_MIAO }   /* sc=plrd */,
  {     0,  9008,     0,   6,   0, UNI_THAA }   /* thaana */,
  {     8,    25,     0,   1,   0, UNI_S }   /* s */,
  {     2,  4989,  8316,   3,   7, UNI_UGAR }   /* isugaritic */,
  {     0,  8984, 10135,   6,   3, UNI_QMARK }   /* qmark=yes */,
  {     0,  4718,     0,  15,   0, UNI_LOWERCASELETTER }   /* lowercaseletter */,
  {     0,   184,  4129,   2,   9, UNI_LATIN1 }   /* islatin1sup */,
  {     0,  8780,  2287,   6,  21, UNI_SINHALAARCHAICNUMBERS }   /* block=sinhalaarchaicnumbers */,
  {     0,  4033,  4718,  16,  15, UNI_LOWERCASELETTER }   /* generalcategory=lowercaseletter */,
  {    32,  8780,   867,   6,  11, UNI_PHONETICEXT }   /* block=phoneticext */,
  {     0,  7218,  6193,  10,  12, UNI_LB__HL }   /* linebreak=hebrewletter */,
  {     1,  3133,     1,  18,   1, -UNI_EBASE }   /* emojimodifierbase=n */,
  {     0,  8780,  5606,   6,  14, UNI_SUPPUNCTUATION }   /* block=suppunctuation */,
  {     1,  1166,     0,  26,   0, UNI_di_values_index }   /* defaultignorablecodepoint= */,
  {     0, 10012,  9868,   3,   4, UNI_EA__W }   /* ea=wide */,
  {     1,  9488,  4479,   5,   6, UNI_BRAI }   /* blk=braille */,
  {     0,  9508,  3007,   4,  13, UNI_CCC__214 }   /* ccc=attachedabove */,
  {     1,  1417,  9161,  25,   4, UNI_CCC__26 }   /* canonicalcombiningclass=ccc26 */,
  {     0,    21,  8912,   2,   6, UNI_INKHOJKI }   /* inkhojki */,
  {     0,  8858,    26,   6,   1, UNI_ECOMP }   /* ecomp=y */,
  {    16,  9768,  9724,   4,   4, UNI_PHNX }   /* scx=phnx */,
  {     6,  9768,  8091,   4,   8, UNI_ARMN }   /* scx=armenian */,
  {     4,  9277,  8107,   3,   4, UNI_BALI }   /* sc=bali */,
  {     6, 10132, 10015,   3,   3, UNI_WB__EB }   /* wb=ebg */,
  {     0,   689,     0,  30,   0, UNI_CJKEXTG }   /* cjkunifiedideographsextensiong */,
  {     3,  6231,  3026,   3,  10, UNI_CHEROKEESUP }   /* incherokeesup */,
  {     1,  4703,     0,  15,   0, UNI_ARMI }   /* imperialaramaic */,
  {     0,  8589,  8924,   7,   6, UNI_LEPC }   /* script=lepcha */,
  {     0,  1552,  6035,   9,   2, UNI_PF }   /* category=pf */,
  {    18,   567,     0,   2,   0, UNI_NB }   /* nb */,
  {     4,  7218,   908,  10,   2, UNI_LB__PR }   /* linebreak=pr */,
  {     0,  4916,  9331,   3,   4, UNI_TALE }   /* istaile */,
  {     0,    21,  9038,   2,   6, UNI_INYEZIDI }   /* inyezidi */,
  {     6,  5986,  7789,  13,   2, UNI_NV__50 }   /* numericvalue=50 */,
  {     5, 10315,  3379,   5,   5, UNI_XPOSIXBLANK }   /* horizspace */,
  {     1,   184,  8841,   3,   5, UNI_CAKM }   /* ischakma */,
  {     1,  8884,    36,   4,   1, UNI_EXT }   /* ext=t */,
  {     0,  9768,  9812,   4,   4, UNI_TAML }   /* scx=taml */,
  {     0,  8780,  6620,   6,   6, UNI_DOMINO }   /* block=domino */,
  {     1,  8589,  8618,   8,   6, UNI_SOYO }   /* script=soyombo */,
  {     3,  3836,  2224,  17,  21, UNI_PRTI }   /* scriptextensions=inscriptionalparthian */,
  {     0,  8780,    43,   7,   2, UNI_CJK }   /* block=cjk */,
  {     0,  7318, 10078,  10,   3, UNI_IN__2_DOT_1 }   /* presentin=v21 */,
  {     5,  8780,  8359,   7,   6, UNI_CJKEXTB }   /* block=cjkextb */,
  {     6,   184,  3133,   2,  17, UNI_EBASE }   /* isemojimodifierbase */,
  {     0,  8780,  8912,   6,   6, UNI_INKHOJKI }   /* block=khojki */,
  {     0,  9277,  3785,   3,  10, UNI_SC__MANI }   /* sc=manichaean */,
  {     2, 10003,    36,   3,   1, UNI_CI }   /* ci=t */,
  {     1,  9277,  9512,   3,   4, UNI_CHRS }   /* sc=chrs */,
  {     3,  3367,     1,  18,   1, -UNI__PERL_PATWS }   /* patternwhitespace=n */,
  {     3,  8123,     0,   8,   0, UNI_BUGI }   /* buginese */,
  {     1, 10132,  4360,   3,   9, UNI_WB__EB }   /* wb=emodifier */,
  {     8,  8780,  2703,   6,  19, UNI_ENCLOSEDALPHANUMSUP }   /* block=enclosedalphanumsup */,
  {     1,  8780,   749,   6,  16, UNI_ENCLOSEDALPHANUM }   /* block=enclosedalphanum */,
  {     3,  8666,     0,   7,   0, UNI_TIRH }   /* tirhuta */,
  {     7,  9997, 10054,   3,   3, UNI_BC__PDF }   /* bc=pdf */,
  {     2,  8589,  9085,   7,   5, UNI_BATK }   /* script=batak */,
  {     1,  9488,    42,   4,   3, UNI_CJK }   /* blk=cjk */,
  {     1, 10033,    18,   3,   2, UNI_RI }   /* lb=ri */,
  {     1,  1188,  9003,   3,   5, UNI_INTELUGU }   /* intelugu */,
  {    17,   184,  1018,   2,   5, UNI_MUSIC }   /* ismusic */,
  {     3, 10024,  1587,   3,   1, UNI_Z }   /* gc=z */,
  {     1,  8491,     0,   4,   0, UNI_MARC }   /* marc */,
  {    14,  6231,    43,   3,  35, UNI_CJKCOMPATIDEOGRAPHSSUP }   /* incjkcompatibilityideographssupplement */,
  {     0,  5037,  9836,   9,   4, UNI_XPOSIXXDIGIT }   /* hexdigit=true */,
  {     0,  6420,  7279,   3,   9, UNI_INOLDPERSIAN }   /* inoldpersian */,
  {     0,  9488,  8116,   5,   7, UNI_INBASSAVAH }   /* blk=bassavah */,
  {     6,  9235,     0,   4,   0, UNI_CWCM }   /* cwcm */,
  {     6,  9488,  7693,   4,   9, UNI_INSAMARITAN }   /* blk=samaritan */,
  {     8,  1417,  9206,  25,   4, UNI_CCC__35 }   /* canonicalcombiningclass=ccc35 */,
  {     0, 10296,     2,   3,   1, UNI_PI }   /* ispi */,
  {     2,  9768,  9464,   4,   4, UNI_ARMN }   /* scx=armn */,
  {     0,  5508,     3,  14,   1, -UNI_PATSYN }   /* patternsyntax=f */,
  {     0,  1008,     0,   2,   0, UNI_CI }   /* ci */,
  {     0,  9277,  7291,   3,   4, UNI_SC__SOGD }   /* sc=sogd */,
  {    11,   184,  6840,   2,   4, UNI_NAND }   /* isnand */,
  {    11,  8147,  1025,   8,   2, -UNI_EXTPICT }   /* extpict=no */,
  {     0,   184,   720,   3,  29, UNI_CUNEIFORMNUMBERS }   /* iscuneiformnumbersandpunctuation */,
  {     1,  5986,  7819,  13,   8, UNI_NV__3_SLASH_16 }   /* numericvalue=1.88e-01 */,
  {     0,  9488,   183,   4,  20, UNI_MISCSYMBOLS }   /* blk=miscellaneoussymbols */,
  {     0,  9488,  8407,   4,   7, UNI_DSRT }   /* blk=deseret */,
  {     0, 10129,  9255,   3,   5, -UNI_VS }   /* vs=false */,
  {     0,  5032,     3,  14,   1, -UNI_POSIXXDIGIT }   /* asciihexdigit=f */,
  {     1,   184,  5284,   2,   7, UNI_LISUSUP }   /* islisusup */,
  {     2,  9488,  8631,   4,   7, UNI_SUPPUAB }   /* blk=suppuab */,
  {    10,  1552,     7,  10,   1, UNI_SC }   /* category=sc */,
  {     4,   184,   720,   3,  15, UNI_CUNEIFORMNUMBERS }   /* iscuneiformnumbers */,
  {    10,  3151,     0,  18,   0, UNI_epres_values_index }   /* emojipresentation= */,
  {     6,  5791,  5382,  13,  14, UNI_JG__MANICHAEANQOPH }   /* joininggroup=manichaeanqoph */,
  {     1,  8267,     0,   8,   0, UNI_radical_values_index }   /* radical= */,
  {     3,  3374,    26,  11,   1, UNI_XPOSIXSPACE }   /* whitespace=y */,
  {    10,  9464,     0,   4,   0, UNI_ARMN }   /* armn */,
  {     3,  7028,  9039,   3,   3, UNI_YEZI }   /* isyezi */,
  {     1,  8780,  3026,   7,   7, UNI_INCHEROKEE }   /* block=cherokee */,
  {     0, 10063,     0,   3,   0, UNI_sd_values_index }   /* sd= */,
  {     2,  3836,  1537,  18,   3, UNI_SIND }   /* scriptextensions=sind */,
  {     0,  8894,     1,   6,   1, -UNI_JOINC }   /* joinc=n */,
  {    10, 10296,  9729,   3,   3, UNI_MIAO }   /* isplrd */,
  {     0,  9488,  2722,   4,  19, UNI_JAMOEXTA }   /* blk=hanguljamoextendeda */,
  {     1, 10009,  8948,   3,   6, UNI_DT__NAR }   /* dt=narrow */,
  {     1,  8780,  6884,   6,  11, UNI_INPAHAWHHMONG }   /* block=pahawhhmong */,
  {     2,  3836,  7308,  17,  10, UNI_PHNX }   /* scriptextensions=phoenician */,
  {     0,  9235,    36,   5,   1, UNI_CWCM }   /* cwcm=t */,
  {     8,  8589,  9688,   7,   4, UNI_NKO }   /* script=nkoo */,
  {     1,  9508,  7078,   4,  10, UNI_CCC__BR }   /* ccc=belowright */,
  {     4,  6133,     0,  12,   0, UNI_ETHIOPICEXTA }   /* ethiopicexta */,
  {     1, 10033, 10164,   3,   2, UNI_GCB__V }   /* lb=jv */,
  {     3,  9768,  1222,   4,   4, UNI_KANA }   /* scx=kana */,
  {     0, 10048,  9060,   3,   5, UNI_NV__11_SLASH_12 }   /* nv=11/12 */,
  {     2,  4033,    48,  16,   1, UNI_P }   /* generalcategory=p */,
  {     7,  9997,  4321,   3,  16, UNI_BC__S }   /* bc=segmentseparator */,
  {     1,  9768,  9828,   4,   4, UNI_THAI }   /* scx=thai */,
  {     0,   184,  5508,   2,  13, UNI_PATSYN }   /* ispatternsyntax */,
  {     0,  9277,  2912,   3,   4, UNI_SUND }   /* sc=sund */,
  {     0,  3836,  9532,  17,   4, UNI_CYRL }   /* scriptextensions=cyrl */,
  {     1,   184,    43,   3,  15, UNI_CJKCOMPAT }   /* iscjkcompatibility */,
  {     2,  3529,     1,  18,   1, -UNI_VS }   /* variationselector=n */,
  {     0,  9768,  9668,   4,   4, UNI_MTEI }   /* scx=mtei */,
  {     0,  8589,  9752,   7,   4, UNI_SC__ROHG }   /* script=rohg */,
  {    14,  4583,     0,   4,   0, UNI_DASH }   /* dash */,
  {     6,  5986, 10152,  13,   2, UNI_NV__49 }   /* numericvalue=49 */,
  {     0,   184,  1060,   3,   3, UNI_COPT }   /* iscopt */,
  {     7,   117,  1908,   4,  14, UNI_INDICNUMBERFORMS }   /* inindicnumberforms */,
  {     3,  1899,     0,   2,   0, UNI_PC }   /* pc */,
  {     0,  7155,  5187,   3,  13, UNI_HIGHSURROGATES }   /* ishighsurrogates */,
  {     1,  2182,    34,  21,   2, UNI_GCB__EX }   /* graphemeclusterbreak=ex */,
  {     0, 10048,  7754,   3,   2, UNI_NV__11 }   /* nv=11 */,
  {     2,  3259,     0,  18,   0, UNI_idsb_values_index }   /* idsbinaryoperator= */,
  {     0,    21,  1677,   2,   9, UNI_LATINEXTE }   /* inlatinexte */,
  {     0,  8589,  2061,   7,   4, UNI_SC__MODI }   /* script=modi */,
  {     6,  7158,  1025,  10,   2, -UNI_DIA }   /* diacritic=no */,
  {     0, 10296,   909,   3,   9, UNI_CO }   /* isprivateuse */,
  {     0,  1417,  9201,  25,   4, UNI_CCC__34 }   /* canonicalcombiningclass=ccc34 */,
  {     0,  7739,    26,   8,   1, UNI_IDS }   /* idstart=y */,
  {     0,   809,     0,  22,   0, UNI_ENCLOSEDIDEOGRAPHICSUP }   /* enclosedideographicsup */,
  {     3,  9277,  2203,   3,  14, UNI_SC__ROHG }   /* sc=hanifirohingya */,
  {     8,  1537,  4600,   4,  13, UNI_DIACRITICALSEXT }   /* indiacriticalsext */,
  {    10,  3836,  9038,  17,   4, UNI_YEZI }   /* scriptextensions=yezi */,
  {    15,  9997,  3403,   3,  18, UNI_BC__RLI }   /* bc=righttoleftisolate */,
  {     0,   184,  6928,   2,  10, UNI_SD }   /* issoftdotted */,
  {    12,  9444,     9,   4,   2, UNI_AGE__NA }   /* age=na */,
  {     0,    21,  5256,   2,  14, UNI_LATINEXTD }   /* inlatinextendedd */,
  {     1,  7739,  9255,   8,   5, -UNI_IDS }   /* idstart=false */,
  {     3,   184,  3937,   2,   4, UNI_BOPO }   /* isbopo */,
  {    22, 10290, 10303,   6,   5, UNI_XPOSIXBLANK }   /* xposixblank */,
  {     1,  3151,     3,  18,   1, -UNI_EPRES }   /* emojipresentation=f */,
  {     1,  5037,    36,   9,   1, UNI_XPOSIXXDIGIT }   /* hexdigit=t */,
  {     1,  3025,     0,  18,   0, UNI_CHEROKEESUP }   /* cherokeesupplement */,
  {     0,  7155,  4066,   3,  15, UNI_HALFANDFULLFORMS }   /* ishalfandfullforms */,
  {     0, 10340,  3379,   6,   5, UNI_VERTSPACE }   /* isvertspace */,
  {     4, 10012,     9,   3,   2, UNI_EA__NA }   /* ea=na */,
  {     6,  8780,  8990,   6,   6, UNI_INREJANG }   /* block=rejang */,
  {     0,  7228,    36,  10,   1, UNI_XPOSIXLOWER }   /* lowercase=t */,
  {     8,  3836,  9860,  17,   4, UNI_VAI }   /* scriptextensions=vaii */,
  {     0,  1417,  8799,  25,   5, UNI_CCC__107 }   /* canonicalcombiningclass=ccc107 */,
  {     1,  6231,  6110,   3,  11, UNI_CYRILLICEXTB }   /* incyrillicextb */,
  {     0,  9444,  7826,   4,   4, UNI_AGE__12 }   /* age=12.0 */,
  {     4,  1812, 10135,  22,   3, UNI_CWL }   /* changeswhenlowercased=yes */,
  {     0,   406,     0,   7,   0, UNI_XPOSIXCNTRL }   /* control */,
  {     1,  9488,  6884,   4,  11, UNI_INPAHAWHHMONG }   /* blk=pahawhhmong */,
  {    11,  8589,  9480,   7,   4, UNI_BATK }   /* script=batk */,
  {     3,  5739,  9255,  13,   5, -UNI_GRBASE }   /* graphemebase=false */,
  {     7,  8589,  8840,   7,   6, UNI_SC__CAKM }   /* script=chakma */,
  {     0,  9488,  7398,   4,  10, UNI_SUPARROWSC }   /* blk=suparrowsc */,
  {     0,  9768,  2409,   4,   4, UNI_GLAG }   /* scx=glag */,
  {     1,  9277,  2287,   3,   7, UNI_SC__SINH }   /* sc=sinhala */,
  {    12, 10024,   339,   3,   2, UNI_LO }   /* gc=lo */,
  {     0,  7438,   125,  10,   2, UNI_LB__CR }   /* wordbreak=cr */,
  {     0,  9277,  2855,   3,   9, UNI_SC__MONG }   /* sc=mongolian */,
  {     1,  8414,     0,   7,   0, UNI_ELBA }   /* elbasan */,
  {     0, 10296,  2571,   3,   3, UNI_PRTI }   /* isprti */,
  {     1,  3836,  3025,  17,   8, UNI_CHER }   /* scriptextensions=cherokee */,
  {     1,  1591,  3170,   3,   7, UNI_INETHIOPIC }   /* inethiopic */,
  {     0,  8780,  6620,   6,  11, UNI_DOMINO }   /* block=dominotiles */,
  {     0,  1417,  9166,  25,   4, UNI_CCC__27 }   /* canonicalcombiningclass=ccc27 */,
  {     2,  4116,  3278,   3,  17, UNI_PI }   /* isinitialpunctuation */,
  {    18,  8888,     0,   4,   0, UNI_HATR }   /* hatr */,
  {     0,  8589,  7292,   8,   6, UNI_SC__SOGD }   /* script=sogdian */,
  {     3,  4791,  2062,   3,   3, UNI_INMODI }   /* inmodi */,
  {     1,  2218,  9689,   3,   2, UNI_INNKO }   /* innko */,
  {     4,  8930,  9255,   6,   5, -UNI_XPOSIXLOWER }   /* lower=false */,
  {     1,  3836,  1654,  17,   6, UNI_HANG }   /* scriptextensions=hangul */,
  {     2,  8780,  1466,   7,  23, UNI_DIACRITICALSFORSYMBOLS }   /* block=combiningmarksforsymbols */,
  {     2,  8589,  8936,   7,   4, UNI_LYCI }   /* script=lyci */,
  {     6,   184,     7,   3,   1, UNI_XPOSIXCNTRL }   /* iscc */,
  {     1,  9277,  8786,   3,   4, UNI_CARI }   /* sc=cari */,
  {     2,   184,   114,   3,  24, UNI_DIACRITICALS }   /* iscombiningdiacriticalmarks */,
  {     5,  9488,  7278,   4,  10, UNI_INOLDPERSIAN }   /* blk=oldpersian */,
  {    20,  1552,   206,   9,   2, UNI_PI }   /* category=pi */,
  {     1,  9508, 10172,   4,   2, UNI_CCC__9 }   /* ccc=vr */,
  {     0,   184,  1442,   3,  23, UNI_CJKSYMBOLS }   /* iscjksymbolsandpunctuation */,
  {     2, 10024,   598,   3,   2, UNI_XPOSIXCNTRL }   /* gc=cc */,
  {    14,  7325, 10096,   3,   3, UNI_IN__5 }   /* in=v50 */,
  {     0,  9277,  8680,   3,   7, UNI_ZZZZ }   /* sc=unknown */,
  {     0,  9270,  2555,   5,   6, UNI_INPC__BOTTOM }   /* inpc=bottom */,
  {     4,  8589,  1176,   8,   3, UNI_SORA }   /* script=sora */,
  {     2,   659,     0,  30,   0, UNI_CJKEXTF }   /* cjkunifiedideographsextensionf */,
  {     0,  8960,    17,   7,   1, UNI_COMPEX }   /* nfcqc=no */,
  {     1,  1417,  9468,  24,   4, UNI_CCC__216 }   /* canonicalcombiningclass=atar */,
  {     4,  8694,  1025,   7,   2, -UNI_XPOSIXSPACE }   /* wspace=no */,
  {     0,  9888,     0,   4,   0, UNI_ZANB }   /* zanb */,
  {    14,  8780,  3341,   6,   8, UNI_DINGBATS }   /* block=dingbats */,
  {     1,  7218,  5746,  10,   5, UNI_EBASE }   /* linebreak=ebase */,
  {     1,  8575,     1,   7,   1, -UNI_PATSYN }   /* patsyn=n */,
  {     0, 10048,  9380,   3,   4, UNI_NV__1_SLASH_80 }   /* nv=1/80 */,
  {     3,  9800,     0,   4,   0, UNI_TAGS }   /* tags */,
  {     1, 10290,  5039,   6,   6, UNI_XPOSIXXDIGIT }   /* xposixxdigit */,
  {     0,  9488,  2874,   4,  19, UNI_OTTOMANSIYAQNUMBERS }   /* blk=ottomansiyaqnumbers */,
  {     1,  9997,  6049,   3,  12, UNI_BC__AN }   /* bc=arabicnumber */,
  {     0,  4916,  8292,   3,   7, UNI_TAGB }   /* istagbanwa */,
  {     1,  4628,     0,  15,   0, UNI_ea_values_index }   /* eastasianwidth= */,
  {     0,   184,  8924,   2,   6, UNI_LEPC }   /* islepcha */,
  {     0,  7693,     0,   9,   0, UNI_SAMR }   /* samaritan */,
  {     0,  7318, 10075,  10,   3, UNI_IN__2 }   /* presentin=v20 */,
  {     5,  9488,  1294,   4,  25, UNI_SUPERANDSUB }   /* blk=superscriptsandsubscripts */,
  {     0, 10048,  7859,   3,   4, UNI_NV__2000 }   /* nv=2000 */,
  {    12,    21,  7188,   2,  10, UNI_INKHAROSHTHI }   /* inkharoshthi */,
  {     7,  3836,  3937,  17,   8, UNI_BOPO }   /* scriptextensions=bopomofo */,
  {     0,  9556,  6178,   4,   3, UNI_LB__ZWJ }   /* gcb=zwj */,
  {     2,   184,   149,   3,  34, UNI_DIACRITICALSSUP }   /* iscombiningdiacriticalmarkssupplement */,
  {    14,  6420,  4869,   3,  14, UNI_NARB }   /* inoldnortharabian */,
  {     0, 10030,     0,   4,   0, UNI_JT__L }   /* jt=l */,
  {     1,  2203,     0,  14,   0, UNI_ROHG }   /* hanifirohingya */,
  {     1,  5791,  6346,  13,   3, UNI_JG__NYA }   /* joininggroup=nya */,
  {     0,  8780,  6505,   6,   8, UNI_PHAISTOS }   /* block=phaistos */,
  {     4,   184,  9684,   2,   4, UNI_NEWA }   /* isnewa */,
  {    32,  4033,   908,  16,  10, UNI_CO }   /* generalcategory=privateuse */,
  {    12,  9277,  9484,   3,   4, UNI_BHKS }   /* sc=bhks */,
  {     5,   509,     0,  20,   0, UNI_CJK }   /* cjkunifiedideographs */,
  {     1, 10027,  7048,   3,  10, UNI_JG__AFRICANQAF }   /* jg=africanqaf */,
  {     0,  7438,  5851,  10,   2, UNI_WB__ML }   /* wordbreak=ml */,
  {     3,  9612,     0,   4,   0, UNI_KNDA }   /* knda */,
  {     1,  9488,   148,   4,  35, UNI_DIACRITICALSSUP }   /* blk=combiningdiacriticalmarkssupplement */,
  {     3,  7325,  7755,   3,   3, UNI_IN__1_DOT_1 }   /* in=1.1 */,
  {     0,  1552,    32,   9,   2, UNI__PERL_SURROGATE }   /* category=cs */,
  {     2,  9508,  6445,   4,  12, UNI_CCC__0 }   /* ccc=notreordered */,
  {     0,  2218,  7631,   3,   8, UNI_INNEWTAILUE }   /* innewtailue */,
  {     4,  9488,  8227,   4,   8, UNI_KANAEXTA }   /* blk=kanaexta */,
  {     0,  1988,  1025,  22,   2, -UNI_LOE }   /* logicalorderexception=no */,
  {    26,  8960,    47,   6,   1, UNI_NFCQC__M }   /* nfcqc=m */,
  {     0,  5986,  7859,  13,   3, UNI_NV__200 }   /* numericvalue=200 */,
  {     4,  3937,     0,   4,   0, UNI_BOPO }   /* bopo */,
  {     0,  8894,  9255,   6,   5, -UNI_JOINC }   /* joinc=false */,
  {     0,    21,  8924,   2,   6, UNI_INLEPCHA }   /* inlepcha */,
  {     0,  6553,     0,  12,   0, UNI_xidc_values_index }   /* xidcontinue= */,
  {     7,  7076,  4449,   3,   4, UNI_INBAMUM }   /* inbamum */,
  {     1, 10027,  4773,   3,   3, UNI_JG__SAD }   /* jg=sad */,
  {     0,  7218, 10174,  10,   2, UNI_LB__XX }   /* linebreak=xx */,
  {     0,  8780,  5284,   6,   7, UNI_LISUSUP }   /* block=lisusup */,
  {     0,  5578,  9080,  14,   5, UNI_SB__AT }   /* sentencebreak=aterm */,
  {     0, 10033,  4360,   3,   9, UNI_EMOD }   /* lb=emodifier */,
  {     1,  9277,  1536,   3,   4, UNI_SC__SIND }   /* sc=sind */,
  {     1,  8589,  8484,   7,   7, UNI_SC__MAND }   /* script=mandaic */,
  {     0,  3385,     0,  18,   0, UNI_ri_values_index }   /* regionalindicator= */,
  {     6,  3836,  9888,  17,   4, UNI_ZANB }   /* scriptextensions=zanb */,
  {     4,  9768,  2560,   4,   4, UNI_MAND }   /* scx=mand */,
  {     0,  6517,     0,  12,   0, UNI_PLAYINGCARDS }   /* playingcards */,
  {     1,  8780,    43,   7,  25, UNI_CJKCOMPATIDEOGRAPHS }   /* block=cjkcompatibilityideographs */,
  {     3,  8147,     0,   9,   0, -UNI_EXTPICT }   /* extpict=f */,
  {     0,  8780,  6517,   6,  12, UNI_PLAYINGCARDS }   /* block=playingcards */,
  {     1, 10027,  5856,   3,  13, UNI_JG__MALAYALAMNNNA }   /* jg=malayalamnnna */,
  {     1,  6420,  3332,   3,  17, UNI_ORNAMENTALDINGBATS }   /* inornamentaldingbats */,
  {     0,  9277,   497,   5,   3, UNI_KHMR }   /* sc=khmer */,
  {     0,  8780,  8942,   6,   6, UNI_INLYDIAN }   /* block=lydian */,
  {     1,  9488,   749,   4,  21, UNI_ENCLOSEDALPHANUM }   /* blk=enclosedalphanumerics */,
  {     0,  4033,   132,  16,   2, UNI_LM }   /* generalcategory=lm */,
  {     0,  8780,  3457,   6,  11, UNI_TAIXUANJING }   /* block=taixuanjing */,
  {     2,  2224,   896,   3,  27, UNI_SUPPUAA }   /* insupplementaryprivateuseareaa */,
  {     0,  3379,  1025,   6,   2, -UNI_XPOSIXSPACE }   /* space=no */,
  {     0,  1812,    26,  22,   1, UNI_CWL }   /* changeswhenlowercased=y */,
  {     0,  9768,  9680,   4,   4, UNI_NBAT }   /* scx=nbat */,
  {     0,  4791,   393,   3,   2, UNI_INMRO }   /* inmro */,
  {     1,   184,  9664,   2,   3, UNI_MRO }   /* ismro */,
  {     2,  9488,  5804,   4,  13, UNI_KANAEXTA }   /* blk=kanaextendeda */,
  {     0, 10132,     0,   3,   0, UNI_wb_values_index }   /* wb= */,
  {     0,  8924,     0,   4,   0, UNI_LEPC }   /* lepc */,
  {     6,  8659,     0,   7,   0, UNI_TIBT }   /* tibetan */,
  {     2,   184,  1060,   3,   5, UNI_COPT }   /* iscoptic */,
  {    22,  9508,  9026,   4,   6, UNI_CCC__9 }   /* ccc=virama */,
  {     1,  9270,   868,   3,  10, UNI_PHONETICEXT }   /* inphoneticext */,
  {     0,  1677,     0,   5,   0, UNI_LATN }   /* latin */,
  {     1,  3385,  9836,  18,   4, UNI_RI }   /* regionalindicator=true */,
  {     0,  1790,    36,  22,   1, UNI_CWCM }   /* changeswhencasemapped=t */,
  {     3,  8589,  9660,   7,   4, UNI_SC__MLYM }   /* script=mlym */,
  {     0, 10033,  6169,   3,   4, UNI_LB__GL }   /* lb=glue */,
  {     4,  1537,  2988,  24,  19, UNI_INPC__TOPANDBOTTOMANDLEFT }   /* indicpositionalcategory=topandbottomandleft */,
  {     3,  5791,  3819,  13,  17, UNI_JG__MANICHAEANTHAMEDH }   /* joininggroup=manichaeanthamedh */,
  {     4,  5986, 10150,  13,   2, UNI_NV__48 }   /* numericvalue=48 */,
  {     4,   184,  6796,   2,  11, UNI_MEDF }   /* ismedefaidrin */,
  {    18,  3382,    36,   3,   1, UNI_CE }   /* ce=t */,
  {     8, 10048,  7978,   3,   2, UNI_NV__16 }   /* nv=16 */,
  {     1,  7438,    73,  10,   2, UNI_WB__EB }   /* wordbreak=em */,
  {     2,  1417,  9196,  25,   4, UNI_CCC__33 }   /* canonicalcombiningclass=ccc33 */,
  {    19,  9768,  9620,   4,   4, UNI_LANA }   /* scx=lana */,
  {     2,  3382, 10135,   3,   3, UNI_CE }   /* ce=yes */,
  {    17,  8780,  4883,   6,  15, UNI_SARB }   /* block=oldsoutharabian */,
  {    17,  8243,     0,   8,   0, UNI_MAHJ }   /* mahajani */,
  {     1,  5674,     0,  13,   0, UNI_bidim_values_index }   /* bidimirrored= */,
  {     2,  9488,   867,   4,  18, UNI_PHONETICEXT }   /* blk=phoneticextensions */,
  {     0,  6229,    36,  12,   1, UNI_JOINC }   /* joincontrol=t */,
  {    16,  3836,  9576,  17,   4, UNI_GURU }   /* scriptextensions=guru */,
  {     4,  5791,  5620,  13,  10, UNI_JG__TEHMARBUTA }   /* joininggroup=tehmarbuta */,
  {     2, 10048,  9055,   3,   4, UNI_NV__1_SLASH_32 }   /* nv=1/32 */,
  {     0,    21,  5270,   2,  14, UNI_LATINEXTE }   /* inlatinextendede */,
  {     1, 10030,     0,   3,   1, UNI_JT__U }   /* jt=u */,
  {     0,   184,  9226,   3,   4, UNI_XPOSIXCNTRL }   /* iscntrl */,
  {     0,  7218,    25,  10,   2, UNI_LB__SY }   /* linebreak=sy */,
  {     7,  3097, 10066,  18,   3, UNI_DT__SML }   /* decompositiontype=sml */,
  {    12,   184,  9533,   3,   3, UNI_CYRL }   /* iscyrl */,
  {     1,  4791,  2856,   3,  18, UNI_MONGOLIANSUP }   /* inmongoliansupplement */,
  {    10,  4658,  9836,  15,   4, UNI_GREXT }   /* graphemeextend=true */,
  {     9,  7218, 10156,  10,   2, UNI_LB__BK }   /* linebreak=bk */,
  {     1,  9488,  4673,   4,  15, UNI_INHANGUL }   /* blk=hangulsyllables */,
  {     3,   184,  2010,   2,  22, UNI_MISCTECHNICAL }   /* ismiscellaneoustechnical */,
  {     3,  4033,  5592,  16,  14, UNI_ZS }   /* generalcategory=spaceseparator */,
  {     1, 10048,  9413,   3,   3, UNI_NV__7_SLASH_2 }   /* nv=7/2 */,
  {     0,  7088,  3773,  10,   3, UNI_BC__RLI }   /* bidiclass=rli */,
  {     4,  9488,  3683,   4,  17, UNI_ETHIOPICEXTA }   /* blk=ethiopicextendeda */,
  {     2,  9230,    26,   5,   1, UNI_CWCF }   /* cwcf=y */,
  {     0,  8589,  9002,   7,   6, UNI_SC__TELU }   /* script=telugu */,
  {     0, 10009,    45,   3,   6, UNI_DT__COM }   /* dt=compat */,
  {     0,  9240,  9255,   5,   5, -UNI_DASH }   /* dash=false */,
  {     0, 10024,  4718,   3,  15, UNI_LOWERCASELETTER }   /* gc=lowercaseletter */,
  {     1,  5986,  8720,  13,   3, UNI_NV__400 }   /* numericvalue=400 */,
  {     0,  2280,  9316,   3,   4, UNI_ORYA }   /* isoriya */,
  {     0,  3374,  1025,  11,   2, -UNI_XPOSIXSPACE }   /* whitespace=no */,
  {     1,  8688,  2314,   3,   3, UNI_POSIXXDIGIT }   /* isahex */,
  {     6,  9768,  9664,   4,   4, UNI_MRO }   /* scx=mroo */,
  {     0,  9768,  2855,   4,   9, UNI_MONG }   /* scx=mongolian */,
  {     0,  8780,  6086,   7,  11, UNI_CHESSSYMBOLS }   /* block=chesssymbols */,
  {     3,   184,   895,   2,  28, UNI_SUPPUAA }   /* issupplementaryprivateuseareaa */,
  {     8,  8882, 10135,   6,   3, UNI_GREXT }   /* grext=yes */,
  {     0,  9768,  9748,   4,   4, UNI_RJNG }   /* scx=rjng */,
  {     2,  8780,   690,   7,  29, UNI_CJKEXTG }   /* block=cjkunifiedideographsextensiong */,
  {     8,  2218,  8527,   3,   6, UNI_NB }   /* innoblock */,
  {     2,  8589,  9664,   7,   3, UNI_MRO }   /* script=mro */,
  {     0, 10063,  9255,   3,   5, -UNI_SD }   /* sd=false */,
  {    20,  4033,   106,  16,   6, UNI_S }   /* generalcategory=symbol */,
  {     2, 10027,  9456,   3,   4, UNI_JG__ALEF }   /* jg=alef */,
  {     0,  4916,  9009,   3,   5, UNI_THAA }   /* isthaana */,
  {     7,  7325,  7827,   3,   3, UNI_IN__2 }   /* in=2.0 */,
  {     0,  1417,  9131,  25,   4, UNI_CCC__20 }   /* canonicalcombiningclass=ccc20 */,
  {     1,  3374,     0,  10,   0, UNI_XPOSIXSPACE }   /* whitespace */,
  {     2,   184,  1700,   2,  23, UNI_SHORTHANDFORMATCONTROLS }   /* isshorthandformatcontrols */,
  {     0,  8638,     0,   7,   0, UNI_TGLG }   /* tagalog */,
  {     9,  8780,  9002,   6,   6, UNI_INTELUGU }   /* block=telugu */,
  {    10,  9488,  1654,   4,   6, UNI_INHANGUL }   /* blk=hangul */,
  {     4,  9488,  8610,   4,   7, UNI_INSIDDHAM }   /* blk=siddham */,
  {     1, 10012,  4471,   3,   7, UNI_EA__N }   /* ea=neutral */,
  {     1,  3836,  9732,  17,   4, UNI_PRTI }   /* scriptextensions=prti */,
  {     1,   184,  1218,   2,  26, UNI_KATAKANAEXT }   /* iskatakanaphoneticextensions */,
  {     7,  9277,  7569,   5,   7, UNI_SC__SIND }   /* sc=khudawadi */,
  {     0, 10291,    62,   5,   5, UNI_POSIXGRAPH }   /* posixgraph */,
  {    23,   184,  6620,   2,  11, UNI_DOMINO }   /* isdominotiles */,
  {     0,  9896,     0,   4,   0, UNI_ZYYY }   /* zyyy */,
  {     0, 10027,  5354,   3,  14, UNI_JG__MANICHAEANHETH }   /* jg=manichaeanheth */,
  {     4,  5986,  7468,  13,   9, UNI_NV___MINUS_1_SLASH_2 }   /* numericvalue=-5.00e-01 */,
  {     0, 10048,  8043,   3,   8, UNI_NV__4_SLASH_5 }   /* nv=8.00e-01 */,
  {     0,  3836,  7657,  17,   9, UNI_PERM }   /* scriptextensions=oldpermic */,
  {     1,   184,  1835,   3,  20, UNI_CWT }   /* ischangeswhentitlecased */,
  {     4,  9488,  1677,   4,  23, UNI_LATINEXTADDITIONAL }   /* blk=latinextendedadditional */,
  {     1,  2280,  9709,   3,   3, UNI_ORYA }   /* isorya */,
  {     2,  3836,  8924,  17,   6, UNI_LEPC }   /* scriptextensions=lepcha */,
  {     1,  9768,  6193,   4,   4, UNI_HEBR }   /* scx=hebr */,
  {     2,  9488,  5816,   5,   7, UNI_INBALINESE }   /* blk=balinese */,
  {     1,  9508,  2455,   4,   5, UNI_CCC__R }   /* ccc=right */,
  {     0,  1677,     0,   9,   0, UNI_LATINEXTE }   /* latinexte */,
  {     0,  9277,  2409,   3,   4, UNI_SC__GLAG }   /* sc=glag */,
  {     2,  9488,  5522,   4,  14, UNI_PHONETICEXTSUP }   /* blk=phoneticextsup */,
  {     0,  7438,  6917,  10,  11, UNI_WB__SQ }   /* wordbreak=singlequote */,
  {     1,  2182,  5633,  21,   2, UNI_LB__H2 }   /* graphemeclusterbreak=lv */,
  {    40,  6231,  3026,   3,  17, UNI_CHEROKEESUP }   /* incherokeesupplement */,
  {     6,   467,     0,   5,   0, UNI_P }   /* punct */,
  {     1, 10024,  5817,   3,  13, UNI_ZL }   /* gc=lineseparator */,
  {     0,  9768,  8337,   4,   7, UNI_AVST }   /* scx=avestan */,
  {     1,   184,   114,   3,  34, UNI_DIACRITICALSFORSYMBOLS }   /* iscombiningdiacriticalmarksforsymbols */,
  {     4,  9488,  1513,   4,  24, UNI_HIGHPUSURROGATES }   /* blk=highprivateusesurrogates */,
  {     0,  9277,  4001,   3,   7, UNI_SC__CPRT }   /* sc=cypriot */,
  {     0,  5986,  9380,  13,   4, UNI_NV__1_SLASH_80 }   /* numericvalue=1/80 */,
  {     0, 10291,  5040,   5,   5, UNI_POSIXDIGIT }   /* posixdigit */,
  {     6,  8589,  9310,   7,   5, UNI_OGAM }   /* script=ogham */,
  {     0,   184,  2245,   2,  21, UNI_MEETEIMAYEKEXT }   /* ismeeteimayekextensions */,
  {     1,  3836,  8442,  17,   7, UNI_HANO }   /* scriptextensions=hanunoo */,
  {     1,  6241,  7258,  12,  10, UNI_JT__U }   /* joiningtype=nonjoining */,
  {     2, 10009,  4017,   3,   5, UNI_DT__FIN }   /* dt=final */,
  {     9,  3836,  6277,  17,   4, UNI_MAHJ }   /* scriptextensions=mahj */,
  {     3,  4989,  1129,   3,   3, UNI_UCAS }   /* isucas */,
  {     2,  8509,  2705,   4,  17, UNI_ENCLOSEDALPHANUMSUP }   /* inenclosedalphanumsup */,
  {     5, 10051,     0,   3,   0, UNI_OCR }   /* ocr */,
  {     1,  3717,  8330,  17,   7, UNI_IDENTIFIERSTATUS__ALLOWED }   /* identifierstatus=allowed */,
  {     0,  9768,  1628,   4,   4, UNI_PHAG }   /* scx=phag */,
  {     1, 10024,  6265,   3,  12, UNI_NL }   /* gc=letternumber */,
  {     0,  8996,  9837,   7,   3, UNI_STERM }   /* sterm=true */,
  {     0,  9488,  3683,   4,  11, UNI_ETHIOPICEXT }   /* blk=ethiopicext */,
  {     1,  9768,  6484,   4,   4, UNI_HUNG }   /* scx=hung */,
  {     9,  9038,     0,   6,   0, UNI_YEZI }   /* yezidi */,
  {     0,  6231,  7129,   3,   9, UNI_CJKSTROKES }   /* incjkstrokes */,
  {     2, 10033,     0,   3,   0, UNI_lb_values_index }   /* lb= */,
  {     0,  8960,     0,   7,   0, UNI_COMPEX }   /* nfcqc=n */,
  {     0,  1189,  5713,   3,   7, UNI_XPOSIXDIGIT }   /* nt=decimal */,
  {     4,  6241,     6,  12,   1, UNI_JT__D }   /* joiningtype=d */,
  {     0,  9277,  4883,   3,  15, UNI_SARB }   /* sc=oldsoutharabian */,
  {     0,  6805,   206,   6,  11, UNI_MISCPICTOGRAPHS }   /* inmiscpictographs */,
  {     8, 10024,   467,   3,  11, UNI_P }   /* gc=punctuation */,
  {     9,  9768,  8187,   4,   4, UNI_HIRA }   /* scx=hira */,
  {     4,   184,  7513,   2,   9, UNI_BHKS }   /* isbhaiksuki */,
  {     2,  5986,  9376,  13,   4, UNI_NV__1_SLASH_64 }   /* numericvalue=1/64 */,
  {    21,  9488,  7531,   4,   9, UNI_EMOTICONS }   /* blk=emoticons */,
  {     6,  7684,     0,   4,   0, UNI_PAUC }   /* pauc */,
  {    12,  4273,     0,   7,   0, UNI_MYMR }   /* myanmar */,
  {    12,  7657,     0,   9,   0, UNI_PERM }   /* oldpermic */,
  {     0,  6231,   510,   3,  19, UNI_CJK }   /* incjkunifiedideographs */,
  {     8,   184,  9644,   2,   4, UNI_MEDF }   /* ismedf */,
  {     3,   951,     0,  18,   0, UNI_INVS }   /* variationselectors */,
  {     0,  8780,  5018,   6,  14, UNI_ANCIENTSYMBOLS }   /* block=ancientsymbols */,
  {     5,  1417,  3015,  24,  10, UNI_CCC__AR }   /* canonicalcombiningclass=aboveright */,
  {     1,  4116,  3260,   3,   3, UNI_IDSB }   /* isidsb */,
  {    68,  1966,  2389,  22,  20, UNI_INSC__CONSONANTWITHSTACKER }   /* indicsyllabiccategory=consonantwithstacker */,
  {     3, 10126,    18,   3,   1, UNI_VO__R }   /* vo=r */,
  {     8,  8688,  9441,   3,   3, UNI_ADLM }   /* isadlm */,
  {     6,  9277,  2608,   3,   4, UNI_BRAH }   /* sc=brah */,
  {    10, 10333,     6,   3,   1, UNI_SD }   /* issd */,
  {     0,  4033,    27,  16,   2, UNI_LOWERCASELETTER }   /* generalcategory=ll */,
  {     9,  5791,  4778,  13,  15, UNI_JG__MANICHAEANZAYIN }   /* joininggroup=manichaeanzayin */,
  {     0,  8780,  1631,   6,  15, UNI_GEOMETRICSHAPES }   /* block=geometricshapes */,
  {     0,  8870,     0,   6,   0, UNI_epres_values_index }   /* epres= */,
  {     1,  9716,    36,   4,   1, UNI_PCM }   /* pcm=t */,
  {     0,  3836,  8498,  17,   7, UNI_MULT }   /* scriptextensions=multani */,
  {     0,   184,  4360,   2,   4, UNI_EMOD }   /* isemod */,
  {     0, 10033,    42,   3,   2, UNI_LB__CJ }   /* lb=cj */,
  {     1,  5986,  8744,  13,   4, UNI_NV__7000 }   /* numericvalue=7000 */,
  {     0,  1591,  7533,   4,   7, UNI_EMOTICONS }   /* inemoticons */,
  {     2,  9488, 10051,   4,   3, UNI_OCR }   /* blk=ocr */,
  {     9,  9768,  7292,   5,   3, UNI_SOGD }   /* scx=sogd */,
  {     0,  9768,  9564,   4,   4, UNI_GONM }   /* scx=gonm */,
  {     2,  3836,  8477,  17,   7, UNI_MAKA }   /* scriptextensions=makasar */,
  {    34,  3836,  6973,  18,  10, UNI_SYLO }   /* scriptextensions=sylotinagri */,
  {     2,  1417,  4134,  24,   1, UNI_CCC__1 }   /* canonicalcombiningclass=1 */,
  {     9,  9556,  6763,   4,   3, UNI_LB__H3 }   /* gcb=lvt */,
  {     0,   184,  1585,   2,  23, UNI_BYZANTINEMUSIC }   /* isbyzantinemusicalsymbols */,
  {     0,  1537,     0,  24,   0, UNI_inpc_values_index }   /* indicpositionalcategory= */,
  {     0,  1979,  4720,  11,  13, UNI_LOWERCASELETTER }   /* category=lowercaseletter */,
  {     0,  5986,  9404,  13,   4, UNI_NV__13_SLASH_2 }   /* numericvalue=13/2 */,
  {     0,  8780,   779,   6,  30, UNI_SYMBOLSANDPICTOGRAPHSEXTA }   /* block=symbolsandpictographsextendeda */,
  {    17,  9277,  8428,   3,   4, UNI_SC__GRAN }   /* sc=gran */,
  {     0,  9768,  9692,   4,   4, UNI_NSHU }   /* scx=nshu */,
  {     0,  4273,     0,  16,   0, UNI_MYANMAREXTA }   /* myanmarextendeda */,
  {     0,  7218,  6178,  10,   3, UNI_LB__ZWJ }   /* linebreak=zwj */,
  {     1,  8768,     3,   6,   1, -UNI_BIDIC }   /* bidic=f */,
  {     3,  8930,  1025,   6,   2, -UNI_XPOSIXLOWER }   /* lower=no */,
  {     8, 10048,  7933,   3,   2, UNI_NV__17 }   /* nv=17 */,
  {     1,  1417,  9191,  25,   4, UNI_CCC__32 }   /* canonicalcombiningclass=ccc32 */,
  {     5,  9444, 10084,   4,   3, UNI_AGE__3_DOT_1 }   /* age=v31 */,
  {     0,  9488,  8582,   4,   7, UNI_INPHAGSPA }   /* blk=phagspa */,
  {     4,  8589,  2817,   7,   4, UNI_MERO }   /* script=mero */,
  {     8,  8449,     3,   7,   1, -UNI_HYPHEN }   /* hyphen=f */,
  {    13,  8997,     3,   5,   1, -UNI_TERM }   /* term=f */,
  {     0, 10048,  8708,   3,   6, UNI_NV__216000 }   /* nv=216000 */,
  {     0,  7438,  1194,  10,   2, UNI_LB__LF }   /* wordbreak=lf */,
  {     1,  3836,  6884,  17,  11, UNI_HMNG }   /* scriptextensions=pahawhhmong */,
  {     1, 10027,  9772,   3,   4, UNI_JG__SEEN }   /* jg=seen */,
  {     9,  3836,  9448,  17,   4, UNI_AGHB }   /* scriptextensions=aghb */,
  {     0,  3836,  3895,  18,   3, UNI_SGNW }   /* scriptextensions=sgnw */,
  {    32, 10030,    36,   3,   1, UNI_JT__T }   /* jt=t */,
  {    10,  3836,  8171,  17,   8, UNI_GUJR }   /* scriptextensions=gujarati */,
  {    15,    21,  5228,   2,  14, UNI_LATINEXTB }   /* inlatinextendedb */,
  {     1,  9444,  9985,   4,   3, UNI_AGE__7 }   /* age=7.0 */,
  {     9,  4422,  3117,   4,  16, UNI_DEVANAGARIEXT }   /* indevanagariextended */,
  {     0,   184,  9480,   2,   4, UNI_BATK }   /* isbatk */,
  {     1, 10333,  7292,   3,   3, UNI_SOGD }   /* issogd */,
  {     0,  1812,    36,  22,   1, UNI_CWL }   /* changeswhenlowercased=t */,
  {     0,  8864,  1025,   6,   2, -UNI_EMOJI }   /* emoji=no */,
  {     2,  9508,  8795,   4,   3, UNI_CCC__103 }   /* ccc=103 */,
  {     6,  8603,     0,   7,   0, UNI_SHAW }   /* shavian */,
  {     0,  4145,     0,   7,   0, UNI_LINB }   /* linearb */,
  {     1,  1979,  1045,  10,   5, UNI_L }   /* category=letter */,
  {     4,  8456,     0,   7,   0, UNI_KNDA }   /* kannada */,
  {     0,  1552,  3349,   9,  18, UNI_ZP }   /* category=paragraphseparator */,
  {     2,  9277,  8421,   3,   4, UNI_ELYM }   /* sc=elym */,
  {     2,  4688,  7005,  15,  11, UNI_IDENTIFIERTYPE__UNCOMMONUSE }   /* identifiertype=uncommonuse */,
  {     1,  4688,  6895,  15,  11, UNI_IDENTIFIERTYPE__RECOMMENDED }   /* identifiertype=recommended */,
  {     0,  1417,  9136,  25,   4, UNI_CCC__21 }   /* canonicalcombiningclass=ccc21 */,
  {     0,  8688,  1395,   4,  22, UNI_ARABICPFB }   /* isarabicpresentationformsb */,
  {     1,  2224,  7292,   3,   6, UNI_INSOGDIAN }   /* insogdian */,
  {     9,  8589,  7630,   7,   9, UNI_TALU }   /* script=newtailue */,
  {     1,  8780,  4385,   6,  16, UNI_TANGUTCOMPONENTS }   /* block=tangutcomponents */,
  {     3,  4033,  3349,  16,  18, UNI_ZP }   /* generalcategory=paragraphseparator */,
  {     4, 10048,  7963,   3,   8, UNI_NV__11_SLASH_2 }   /* nv=5.50e+00 */,
  {     2,  8768,     0,   6,   0, UNI_bidic_values_index }   /* bidic= */,
  {     6,   184,   923,   2,  28, UNI_SUPPUAB }   /* issupplementaryprivateuseareab */,
  {     3,  9262, 10174,   3,   2, UNI_SB__XX }   /* sb=xx */,
  {     2,  2224,  7369,   3,   9, UNI_SMALLFORMS }   /* insmallforms */,
  {     0,  8864, 10135,   6,   3, UNI_EMOJI }   /* emoji=yes */,
  {    10, 10024,   132,   3,   2, UNI_LM }   /* gc=lm */,
  {     0,  8780,  4433,   6,  15, UNI_ARABICEXTA }   /* block=arabicextendeda */,
  {     5,  1171,     0,   2,   0, UNI_TITLE }   /* lt */,
  {     0,  9444, 10117,   4,   3, UNI_AGE__7 }   /* age=v70 */,
  {     0,  8589,    78,   7,   6, UNI_SC__ARAB }   /* script=arabic */,
  {     1,  8780,  9330,   6,   5, UNI_INTAILE }   /* block=taile */,
  {     6,  9277,  3785,   3,   4, UNI_SC__MANI }   /* sc=mani */,
  {     0,  9997,  6037,   3,  12, UNI_BC__AL }   /* bc=arabicletter */,
  {     5,  6241,     0,  12,   0, UNI_jt_values_index }   /* joiningtype= */,
  {     0,  4791,  6819,   3,  10, UNI_MYANMAREXTA }   /* inmyanmarexta */,
  {     3,  9277,  8617,   3,   7, UNI_SOYO }   /* sc=soyombo */,
  {     0,  2288,  1195,   5,  23, UNI_HALFANDFULLFORMS }   /* inhalfwidthandfullwidthforms */,
  {     2,  8470,     0,   7,   0, UNI_LINA }   /* lineara */,
  {     5,  3374,  9836,  11,   4, UNI_XPOSIXSPACE }   /* whitespace=true */,
  {     5,  9014,    26,   6,   1, UNI_UIDEO }   /* uideo=y */,
  {     0,  9768,  9824,   4,   4, UNI_TGLG }   /* scx=tglg */,
  {    12,  5578, 10174,  14,   2, UNI_SB__XX }   /* sentencebreak=xx */,
  {     2,  1537,  2449,  24,   4, UNI_INPC__LEFT }   /* indicpositionalcategory=left */,
  {     2,  9488,   867,   4,  28, UNI_PHONETICEXTSUP }   /* blk=phoneticextensionssupplement */,
  {     1,   184,  3115,   2,  10, UNI_DEVA }   /* isdevanagari */,
  {     3,  9262,    49,   3,   2, UNI_SB__AT }   /* sb=at */,
  {     9,  8589,  8498,   7,   7, UNI_SC__MULT }   /* script=multani */,
  {     0,  9277,  9824,   3,   4, UNI_SC__TGLG }   /* sc=tglg */,
  {     2,  1087,    36,  27,   1, UNI_PCM }   /* prependedconcatenationmark=t */,
  {     0,  3311,     0,   3,   0, UNI_ALL }   /* all */,
  {     1,  8930,     1,   6,   1, -UNI_XPOSIXLOWER }   /* lower=n */,
  {     4,  3901,  6184,   5,   9, UNI_INGUNJALAGONDI }   /* ingunjalagondi */,
  {     0,  6420,  7667,   3,   8, UNI_INOLDTURKIC }   /* inoldturkic */,
  {     1,  8589,  9892,   7,   4, UNI_SC__QAAI }   /* script=zinh */,
  {     0,   184,  8876,   2,   4, UNI_GOTH }   /* isgoth */,
  {     5, 10003,    26,   3,   1, UNI_CI }   /* ci=y */,
  {     1, 10182,  8979,   7,   4, UNI__PERL_PATWS }   /* _perl_patws */,
  {    14,  7158,     1,  10,   1, -UNI_DIA }   /* diacritic=n */,
  {     1,  9488,  6253,   4,  12, UNI_KHMERSYMBOLS }   /* blk=khmersymbols */,
  {     5,  9290,    36,   5,   1, UNI_MATH }   /* math=t */,
  {     0,   184,   435,   2,   5, UNI__PERL_NCHAR }   /* isnchar */,
  {     3,  9596,  5633,   4,   2, UNI_LB__H2 }   /* hst=lv */,
  {     2,  9277,  9452,   3,   4, UNI_AHOM }   /* sc=ahom */,
  {     0,   184,  8477,   2,   4, UNI_MAKA }   /* ismaka */,
  {     3,  7594,     0,   9,   0, UNI_LATINEXTD }   /* latinextd */,
  {     1,  9277,  7358,   3,   4, UNI_SAUR }   /* sc=saur */,
  {     3,  9488,  5284,   4,   7, UNI_LISUSUP }   /* blk=lisusup */,
  {     0,  9020,     0,   6,   0, UNI_upper_values_index }   /* upper= */,
  {     6,  8864,     0,   6,   0, UNI_emoji_values_index }   /* emoji= */,
  {     0,  4422,  3117,   4,  11, UNI_DEVANAGARIEXT }   /* indevanagariext */,
  {     0,  8688,    80,   4,  33, UNI_ARABICMATH }   /* isarabicmathematicalalphabeticsymbols */,
  {     1,  3836,     0,  17,   0, UNI_scx_values_index }   /* scriptextensions= */,
  {     4,  9488,  7308,   4,  10, UNI_INPHOENICIAN }   /* blk=phoenician */,
  {     3,  5791,  6313,  13,  12, UNI_JG__MALAYALAMNGA }   /* joininggroup=malayalamnga */,
  {     9,  3836,  7168,  17,  10, UNI_DIAK }   /* scriptextensions=divesakuru */,
  {     1,  9277,  1219,   4,   7, UNI_SC__KANA }   /* sc=katakana */,
  {     0,  4033,   133,  16,   4, UNI_M }   /* generalcategory=mark */,
  {     1, 10048,  7939,   3,   8, UNI_NV__9_SLASH_2 }   /* nv=4.50e+00 */,
  {     1,  2288,  4098,   3,  15, UNI_HIGHPUSURROGATES }   /* inhighpusurrogates */,
  {     4,  9277,  9664,   3,   3, UNI_MRO }   /* sc=mro */,
  {     2,  7291,     0,   7,   0, UNI_SOGD }   /* sogdian */,
  {     1,  1417,  8837,  24,   3, UNI_WB__EB }   /* canonicalcombiningclass=133 */,
  {     0,  4033,   339,  16,   2, UNI_LO }   /* generalcategory=lo */,
  {     0,  7540,    36,   9,   1, UNI_EXT }   /* extender=t */,
  {     3, 10296,     6,   3,   1, UNI_PD }   /* ispd */,
  {     9,  9508,    24,   4,   1, UNI_CCC__L }   /* ccc=l */,
  {     0,  1417,  9952,  24,   3, UNI_CCC__IS }   /* canonicalcombiningclass=240 */,
  {     0,  7438,   727,  10,   2, UNI_WB__MN }   /* wordbreak=mn */,
  {    32,  9488,  1878,   4,  22, UNI_CJKCOMPATIDEOGRAPHSSUP }   /* blk=cjkcompatideographssup */,
  {    48,   184,  4145,   2,  16, UNI_LINEARBIDEOGRAMS }   /* islinearbideograms */,
  {     0,  3836,  9245,  17,   4, UNI_DOGR }   /* scriptextensions=dogr */,
  {     0,  1552,  6862,   9,  11, UNI_NO }   /* category=othernumber */,
  {    14,   184,  9656,   2,   4, UNI_MIAO }   /* ismiao */,
  {     0,  6576,    36,  11,   1, UNI_XPOSIXALPHA }   /* alphabetic=t */,
  {     0,  5791,  6162,  13,   7, UNI_JG__SEMKATH }   /* joininggroup=semkath */,
  {     5,   184,  8219,   2,   8, UNI_JAVA }   /* isjavanese */,
  {     3,  3836,  8491,  17,   7, UNI_MARC }   /* scriptextensions=marchen */,
  {     4,  4033,   400,  16,   6, UNI_CF }   /* generalcategory=format */,
  {     9,  8780,  4369,   6,   9, UNI_SYRIACSUP }   /* block=syriacsup */,
  {     0,  9488,  3581,   4,  17, UNI_UCAS }   /* blk=canadiansyllabics */,
  {     0, 10027,  2627,   3,  19, UNI_JG__BURUSHASKIYEHBARREE }   /* jg=burushaskiyehbarree */,
  {     1,  8780,  3080,   7,  17, UNI_COPTICEPACTNUMBERS }   /* block=copticepactnumbers */,
  {     1,  9277,  2287,   3,   4, UNI_SC__SINH }   /* sc=sinh */,
  {     6,  9716,  1025,   4,   2, -UNI_PCM }   /* pcm=no */,
  {     0,   184,  3937,   2,  16, UNI_BOPOMOFOEXT }   /* isbopomofoextended */,
  {     0,  8870,     3,   6,   1, -UNI_EPRES }   /* epres=f */,
  {     0,  3223,     0,  18,   0, UNI_INPUNCTUATION }   /* generalpunctuation */,
  {     3,  8589,  6277,   7,   4, UNI_SC__MAHJ }   /* script=mahj */,
  {     3,  9997,    32,   3,   2, UNI_BC__CS }   /* bc=cs */,
  {     0,  3151,  1025,  18,   2, -UNI_EPRES }   /* emojipresentation=no */,
  {     0,   184,  1677,   2,   9, UNI_LATINEXTE }   /* islatinexte */,
  {     0,  7438,     0,   4,   0, UNI_XPOSIXWORD }   /* word */,
  {     0,  4033,   112,  16,   2, UNI_SC }   /* generalcategory=sc */,
  {     1,  9488,  7621,   4,   9, UNI_INNABATAEAN }   /* blk=nabataean */,
  {     0,  9277,  9672,   3,   4, UNI_SC__MYMR }   /* sc=mymr */,
  {     3,  7218,   533,  10,   2, UNI_LB__NS }   /* linebreak=ns */,
  {     2,  8780,  8115,   6,   8, UNI_INBASSAVAH }   /* block=bassavah */,
  {     3,   951,     0,  17,   0, UNI_VS }   /* variationselector */,
  {     1,  8589,  9038,   7,   4, UNI_SC__YEZI }   /* script=yezi */,
  {     6,  9277,  9736,   3,   4, UNI_SC__COPT }   /* sc=qaac */,
  {     0,  8688,    97,   3,   4, UNI_XPOSIXALPHA }   /* isalpha */,
  {     2,  4033,  4305,  16,  16, UNI_PO }   /* generalcategory=otherpunctuation */,
  {     1, 10132,  6193,   3,  12, UNI_LB__HL }   /* wb=hebrewletter */,
  {    17,  1417,  6719,  24,  11, UNI_CCC__8 }   /* canonicalcombiningclass=kanavoicing */,
  {     2,  1188,  4386,   3,   5, UNI_INTANGUT }   /* intangut */,
  {     1,  9277,  4273,   3,   7, UNI_SC__MYMR }   /* sc=myanmar */,
  {    46,  8924,     0,   6,   0, UNI_LEPC }   /* lepcha */,
  {     1,  1417,  5649,  24,   1, UNI_CCC__0 }   /* canonicalcombiningclass=0 */,
  {     1,  8589,  9896,   7,   4, UNI_SC__ZYYY }   /* script=zyyy */,
  {    16, 10009,     0,   3,   0, UNI_dt_values_index }   /* dt= */,
  {     6,  2784,   863,   4,   4, UNI_ARROWS }   /* inarrows */,
  {    16,  9277,  4478,   3,   4, UNI_BRAI }   /* sc=brai */,
  {    11,  9444, 10081,   4,   3, UNI_AGE__3 }   /* age=v30 */,
  {    10,  9516,     0,   4,   0, UNI_CPRT }   /* cprt */,
  {     2,   184,  9668,   2,   4, UNI_MTEI }   /* ismtei */,
  {     0,   184,  6961,   2,  11, UNI_SUPERANDSUB }   /* issuperandsub */,
  {     0, 10048,  7930,   3,   2, UNI_NV__14 }   /* nv=14 */,
  {     1,  9270,   868,   3,  27, UNI_PHONETICEXTSUP }   /* inphoneticextensionssupplement */,
  {     0,   184,  5214,   2,   6, UNI_KANGXI }   /* iskangxi */,
  {     0,  9277,  8187,   3,   4, UNI_SC__HIRA }   /* sc=hira */,
  {     0,   184,   133,   2,   4, UNI_M }   /* ismark */,
  {     3,  7188,     0,  10,   0, UNI_KHAR }   /* kharoshthi */,
  {     0,  2280,  8549,   4,   5, UNI_OLCK }   /* isolchiki */,
  {     1,   184,  8131,   2,   4, UNI_DUPL }   /* isdupl */,
  {     0,  9444,  7806,   4,   1, UNI_AGE__6 }   /* age=6 */,
  {     0,  1417,  9186,  25,   4, UNI_CCC__31 }   /* canonicalcombiningclass=ccc31 */,
  {     0,  1878,     0,  19,   0, UNI_CJKCOMPATIDEOGRAPHS }   /* cjkcompatideographs */,
  {     2,  1417,  6642,  24,  11, UNI_CCC__DB }   /* canonicalcombiningclass=doublebelow */,
  {     0,  4916,  8292,   3,   3, UNI_TAGB }   /* istagb */,
  {     5, 10027,  6162,   3,   7, UNI_JG__SEMKATH }   /* jg=semkath */,
  {     6,   184,  2061,   2,   4, UNI_MODI }   /* ismodi */,
  {     4,  2784,  7497,   4,   7, UNI_ARABICPFA }   /* inarabicpfa */,
  {     0,  8780,  5778,   6,   6, UNI_IPAEXT }   /* block=ipaext */,
  {     1,  3836,  4149,  18,   3, UNI_SARB }   /* scriptextensions=sarb */,
  {     1, 10027,  4225,   3,  16, UNI_JG__MANICHAEANTWENTY }   /* jg=manichaeantwenty */,
  {     1,    21,  5242,   2,  14, UNI_LATINEXTC }   /* inlatinextendedc */,
  {     1,  5986,  7787,  13,   8, UNI_NV__3_SLASH_2 }   /* numericvalue=1.50e+00 */,
  {     2,   184,  7567,   2,   9, UNI_SIND }   /* iskhudawadi */,
  {    21,   184,  3169,   2,  11, UNI_ETHIOPICSUP }   /* isethiopicsup */,
  {     1,  2533,   982,   5,  24, UNI_ALPHABETICPF }   /* inalphabeticpresentationforms */,
  {     2,  9310,     0,   5,   0, UNI_OGAM }   /* ogham */,
  {    10,  5986,  9368,  13,   4, UNI_NV__1_SLASH_20 }   /* numericvalue=1/20 */,
  {     1,  7088,  3349,  10,  18, UNI_BC__B }   /* bidiclass=paragraphseparator */,
  {     5, 10048,  9392,   3,   4, UNI_NV__11_SLASH_2 }   /* nv=11/2 */,
  {     5, 10024,    27,   3,   2, UNI_LOWERCASELETTER }   /* gc=ll */,
  {     8,  9488,   749,   4,  16, UNI_ENCLOSEDALPHANUM }   /* blk=enclosedalphanum */,
  {     0,  9071,     3,   4,   1, -UNI_XPOSIXXDIGIT }   /* hex=f */,
  {     0,  9997,     0,   3,   0, UNI_bc_values_index }   /* bc= */,
  {     0,  5564,     1,  14,   1, -UNI_QMARK }   /* quotationmark=n */,
  {     0,  4113,   952,   3,  27, UNI_VSSUP }   /* invariationselectorssupplement */,
  {     7,   382,     0,   4,   0, UNI_EGYP }   /* egyp */,
  {     2,  7088,  5829,  10,   3, UNI_BC__RLO }   /* bidiclass=rlo */,
  {     1,  9488,   183,   4,  34, UNI_MISCPICTOGRAPHS }   /* blk=miscellaneoussymbolsandpictographs */,
  {     0,  8912,     0,   6,   0, UNI_KHOJ }   /* khojki */,
  {     1,  9804,     0,   4,   0, UNI_TALE }   /* tale */,
  {     0,  8688,  1007,   3,  16, UNI_ANCIENTGREEKMUSIC }   /* isancientgreekmusic */,
  {     6,  8575,     0,   7,   0, UNI_patsyn_values_index }   /* patsyn= */,
  {     2,  9768,  6385,   4,  12, UNI_GONM }   /* scx=masaramgondi */,
  {    20,  3385,    36,  18,   1, UNI_RI }   /* regionalindicator=t */,
  {    14,    21,  4129,   2,   6, UNI_LATIN1 }   /* inlatin1 */,
  {     7,  8780,   446,   6,  32, UNI_IDEOGRAPHICSYMBOLS }   /* block=ideographicsymbolsandpunctuation */,
  {     1,  8589,  7648,   7,   9, UNI_ITAL }   /* script=olditalic */,
  {     4,  5791, 10072,  13,   3, UNI_JG__TAH }   /* joininggroup=tah */,
  {     9,  1188,  4929,   3,  14, UNI_TAMILSUP }   /* intamilsupplement */,
  {     0,  9488,  8337,   4,   7, UNI_INAVESTAN }   /* blk=avestan */,
  {     0, 10033,  8449,   3,   6, UNI_LB__HY }   /* lb=hyphen */,
  {     0, 10333,  2529,   3,   4, UNI_STERM }   /* issterm */,
  {    11,  9508,  6719,   4,  11, UNI_CCC__8 }   /* ccc=kanavoicing */,
  {     1,  3836,  9315,  17,   5, UNI_ORYA }   /* scriptextensions=oriya */,
  {     4,  1287,     0,   2,   0, UNI_UPPERCASELETTER }   /* lu */,
  {     4,  1417,  7859,  24,   3, UNI_WB__EB }   /* canonicalcombiningclass=200 */,
  {    10,   184,   478,   2,  31, UNI_MATHALPHANUM }   /* ismathematicalalphanumericsymbols */,
  {    18, 10033,   202,   3,   2, UNI_LB__SA }   /* lb=sa */,
  {     0,  1417,  9472,  24,   4, UNI_WB__EB }   /* canonicalcombiningclass=atbl */,
  {     0, 10296,  1823,   7,   5, UNI_POSIXLOWER }   /* isposixlower */,
  {     1,  1417,  9141,  25,   4, UNI_CCC__22 }   /* canonicalcombiningclass=ccc22 */,
  {     1, 10288, 10308,   8,   5, UNI_XPOSIXPRINT }   /* isxposixprint */,
  {     0,   113,     0,  25,   0, UNI_DIACRITICALS }   /* combiningdiacriticalmarks */,
  {     2,  7218,    42,  10,   2, UNI_LB__CJ }   /* linebreak=cj */,
  {    20,  2287,     0,   7,   0, UNI_SINH }   /* sinhala */,
  {     6,  9768,  9588,   4,   4, UNI_HMNG }   /* scx=hmng */,
  {     4,  2280,  6852,   3,  10, UNI_LO }   /* isotherletter */,
  {     0,  6205,     0,  12,   0, UNI_ideo_values_index }   /* ideographic= */,
  {     8,  8780,  7139,   7,   9, UNI_COMPATJAMO }   /* block=compatjamo */,
  {     0,  9488,   779,   4,  30, UNI_SYMBOLSANDPICTOGRAPHSEXTA }   /* blk=symbolsandpictographsextendeda */,
  {     0, 10027,  4177,   3,  16, UNI_JG__MANICHAEANDALETH }   /* jg=manichaeandaleth */,
  {     3, 10024,  1910,   3,   2, UNI_CN }   /* gc=cn */,
  {     0,  1188,  3458,   3,  17, UNI_TAIXUANJING }   /* intaixuanjingsymbols */,
  {     0,  9640,    26,   4,   1, UNI_LOE }   /* loe=y */,
  {     2,  8688,  1371,   4,  22, UNI_ARABICPFA }   /* isarabicpresentationformsa */,
  {     0,  8589,  7660,   7,   4, UNI_SC__PERM }   /* script=perm */,
  {     3,  8852,  9836,   6,   4, UNI_CWKCF }   /* cwkcf=true */,
  {     0,  1845,     0,   5,   0, UNI_TITLE }   /* title */,
  {    70,  5986,  7875,  13,   8, UNI_NV__1_SLASH_32 }   /* numericvalue=3.13e-02 */,
  {     1,  1812,     0,  21,   0, UNI_CWL }   /* changeswhenlowercased */,
  {    13,  9548,     0,   4,   0, UNI_DSRT }   /* dsrt */,
  {     0,  1269,    26,  25,   1, UNI_COMPEX }   /* fullcompositionexclusion=y */,
  {     1,  8780,  8227,   6,   8, UNI_KANAEXTA }   /* block=kanaexta */,
  {     0,  3836,  9245,  17,   5, UNI_DOGR }   /* scriptextensions=dogra */,
  {     0,  5804,     0,  13,   0, UNI_KANAEXTA }   /* kanaextendeda */,
  {     4,  1966,  1244,  22,   9, UNI_INSC__CONSONANT }   /* indicsyllabiccategory=consonant */,
  {     1,  3836,  1218,  17,   8, UNI_KANA }   /* scriptextensions=katakana */,
  {     0,  9277,  9684,   3,   4, UNI_NEWA }   /* sc=newa */,
  {     5,  7155,  6194,   3,   5, UNI_HEBR }   /* ishebrew */,
  {     0,  3836,  9896,  17,   4, UNI_ZYYY }   /* scriptextensions=zyyy */,
  {    28,  4791,  2338,  10,  11, UNI_MERO }   /* inmeroitichieroglyphs */,
  {     1,  6609,     3,  11,   1, -UNI_DEP }   /* deprecated=f */,
  {     0,   184,  3223,   2,  18, UNI_INPUNCTUATION }   /* isgeneralpunctuation */,
  {     0,  8780,  4973,   6,  15, UNI_VEDICEXT }   /* block=vedicextensions */,
  {     8,  9488,  7069,   5,   9, UNI_ASCII }   /* blk=basiclatin */,
  {     1,  6505,     0,   8,   0, UNI_PHAISTOS }   /* phaistos */,
  {     0,  8780,  7458,   6,  10, UNI_YIRADICALS }   /* block=yiradicals */,
  {     4,  7621,     0,   9,   0, UNI_NBAT }   /* nabataean */,
  {     1,  5986,  8732,  13,   4, UNI_NV__5000 }   /* numericvalue=5000 */,
  {     1,  8589,  9476,   7,   4, UNI_AVST }   /* script=avst */,
  {     0,  8966, 10135,   6,   3, UNI_NFDQC__Y }   /* nfdqc=yes */,
  {     2,  8780,  3937,   6,  11, UNI_BOPOMOFOEXT }   /* block=bopomofoext */,
  {     2,    21,  1007,   3,  16, UNI_ANCIENTGREEKMUSIC }   /* inancientgreekmusic */,
  {     2, 10048,  9910,   3,   3, UNI_NV__1_SLASH_9 }   /* nv=1/9 */,
  {     0,  1417,  8831,  24,   3, UNI_CCC__132 }   /* canonicalcombiningclass=132 */,
  {     1, 10033,   395,   3,   2, UNI_LB__GL }   /* lb=gl */,
  {     3,   184,  8906,   2,   6, UNI_KANBUN }   /* iskanbun */,
  {     0,  8589,   865,  10,   1, UNI_SHAW }   /* script=shaw */,
  {     5,  9277,  9008,   3,   6, UNI_SC__THAA }   /* sc=thaana */,
  {     2, 10048,  8750,   3,   2, UNI_NV__80 }   /* nv=80 */,
  {     0,  1631,     0,  18,   0, UNI_GEOMETRICSHAPESEXT }   /* geometricshapesext */,
  {    33, 10327,     0,   4,   0, UNI_PE }   /* ispe */,
  {     1,  8780,  5960,   6,  13, UNI_MISCTECHNICAL }   /* block=misctechnical */,
  {     2,   184,   867,   2,  28, UNI_PHONETICEXTSUP }   /* isphoneticextensionssupplement */,
  {     0,  9488,  7630,   4,   9, UNI_INNEWTAILUE }   /* blk=newtailue */,
  {     0,  9277,  8315,   3,   8, UNI_UGAR }   /* sc=ugaritic */,
  {     1,  8884,     0,   4,   0, UNI_ext_values_index }   /* ext= */,
  {     0,   184,   720,   3,   8, UNI_XSUX }   /* iscuneiform */,
  {     0,  9275,  2844,   5,  10, UNI_INSC__TONELETTER }   /* insc=toneletter */,
  {     0,  5791,  5420,  13,   4, UNI_JG__TETH }   /* joininggroup=teth */,
  {     1,    21,  5200,   2,  14, UNI_KANASUP }   /* inkanasupplement */,
  {     3,   186,     0,   2,   0, UNI_CE }   /* ce */,
  {     4,  9250,    26,   5,   1, UNI_EMOD }   /* emod=y */,
  {     1,  9235, 10135,   5,   3, UNI_CWCM }   /* cwcm=yes */,
  {     1,  2061,     0,  14,   0, UNI_LM }   /* modifierletter */,
  {     4,  9768,  9700,   4,   4, UNI_OLCK }   /* scx=olck */,
  {     0,  3382,     1,   3,   1, -UNI_CE }   /* ce=n */,
  {    20,  9270,  8583,   3,   6, UNI_INPHAGSPA }   /* inphagspa */,
  {     1,  7218,  6587,  10,  11, UNI_LB__BB }   /* linebreak=breakbefore */,
  {     0,  9768,  8491,   4,   7, UNI_MARC }   /* scx=marchen */,
  {     0,  9444,  9856,   4,   4, UNI_AGE__13 }   /* age=v130 */,
  {     0,  7418,     3,  10,   1, -UNI_XPOSIXUPPER }   /* uppercase=f */,
  {     1,  7651,     0,   4,   0, UNI_ITAL }   /* ital */,
  {     3,   184,    43,   3,   8, UNI_CJKCOMPAT }   /* iscjkcompat */,
  {     1,  3836,  9756,  17,   4, UNI_RUNR }   /* scriptextensions=runr */,
  {     2,  9277,  8924,   3,   6, UNI_LEPC }   /* sc=lepcha */,
  {     0,  9768,  3785,   4,   4, UNI_MANI }   /* scx=mani */,
  {     0,   184,   510,   3,  19, UNI_CJK }   /* iscjkunifiedideographs */,
  {     1, 10027,  5172,   3,  14, UNI_JG__HAMZAONHEHGOAL }   /* jg=hamzaonhehgoal */,
  {     4,  9492,     0,   4,   0, UNI_bpt_values_index }   /* bpt= */,
  {    13,  4791,  6411,   4,  10, UNI_INMENDEKIKAKUI }   /* inmendekikakui */,
  {     3,  9768,  6792,   5,   3, UNI_SAMR }   /* scx=samr */,
  {     2,  5791,  9648,  13,   4, UNI_JG__MEEM }   /* joininggroup=meem */,
  {     0,  9768,  9804,   4,   4, UNI_TALE }   /* scx=tale */,
  {     1,  9488,  1465,   4,  24, UNI_DIACRITICALSFORSYMBOLS }   /* blk=combiningmarksforsymbols */,
  {     8, 10048, 10138,   3,   2, UNI_NV__38 }   /* nv=38 */,
  {     0,  3379, 10183,   5,   4, UNI_XPOSIXSPACE }   /* spaceperl */,
  {     5,  2224,   924,   3,  27, UNI_SUPPUAB }   /* insupplementaryprivateuseareab */,
  {     1,  8589,  8618,   8,   3, UNI_SOYO }   /* script=soyo */,
  {     8,  4838,    26,  15,   1, UNI_NFKCQC__Y }   /* nfkcquickcheck=y */,
  {    10,  3836,  2913,  18,   3, UNI_SUND }   /* scriptextensions=sund */,
  {     1,  1417,  7814,  24,   1, UNI_CCC__7 }   /* canonicalcombiningclass=7 */,
  {    34,  1417,    78,  24,   2, UNI_CCC__AR }   /* canonicalcombiningclass=ar */,
  {     0, 10333,  3895,   3,   3, UNI_SGNW }   /* issgnw */,
  {     1,   184,  7139,   3,   9, UNI_COMPATJAMO }   /* iscompatjamo */,
  {     6,  1186,     0,   2,   0, UNI_PO }   /* po */,
  {    40, 10048,  9108,   3,   2, UNI_NV__15 }   /* nv=15 */,
  {     0,  9488,  1906,   4,  16, UNI_INDICNUMBERFORMS }   /* blk=indicnumberforms */,
  {     1,  9351,  9255,   4,   5, -UNI_IDS }   /* ids=false */,
  {    32,  3421,     0,   4,   0, UNI_RUMI }   /* rumi */,
  {    21,  9576,     0,   4,   0, UNI_GURU }   /* guru */,
  {    10, 10048,  7899,   3,   8, UNI_NV__7_SLASH_2 }   /* nv=3.50e+00 */,
  {     4,   184,  7594,   2,   9, UNI_LATINEXTD }   /* islatinextd */,
  {     1,  5986, 10144,  13,   2, UNI_NV__45 }   /* numericvalue=45 */,
  {    58,  9768,  8912,   4,   4, UNI_KHOJ }   /* scx=khoj */,
  {     0,  3836,  9310,  17,   5, UNI_OGAM }   /* scriptextensions=ogham */,
  {     0,  9351,    36,   4,   1, UNI_IDS }   /* ids=t */,
  {    16,  8864,     3,   6,   1, -UNI_EMOJI }   /* emoji=f */,
  {     1,  1417,  9181,  25,   4, UNI_CCC__30 }   /* canonicalcombiningclass=ccc30 */,
  {     0,   184,  8407,   2,   7, UNI_DSRT }   /* isdeseret */,
  {     0,  9444,  7814,   4,   1, UNI_AGE__7 }   /* age=7 */,
  {    14,  7088,    37,  10,   2, UNI_BC__EN }   /* bidiclass=en */,
  {    16,   184,  3115,   2,   4, UNI_DEVA }   /* isdeva */,
  {     0,  8589,  3785,   7,  10, UNI_SC__MANI }   /* script=manichaean */,
  {     8, 10296,  5039,   7,   6, UNI_POSIXXDIGIT }   /* isposixxdigit */,
  {     2,  9250,     0,  10,   0, -UNI_EMOD }   /* emod=false */,
  {     2,  9277,  2429,   3,  20, UNI_PHLI }   /* sc=inscriptionalpahlavi */,
  {     6,  1417,  7874,  24,   2, UNI_CCC__23 }   /* canonicalcombiningclass=23 */,
  {     0,  9488,  1700,   4,  23, UNI_SHORTHANDFORMATCONTROLS }   /* blk=shorthandformatcontrols */,
  {    32,  9277,  8123,   3,   4, UNI_SC__BUGI }   /* sc=bugi */,
  {    10,  4033,  9503,  16,   2, UNI_MC }   /* generalcategory=mc */,
  {     0,  9872,     0,   4,   0, UNI_XPEO }   /* xpeo */,
  {    20,  9540,  9836,   4,   4, UNI_DIA }   /* dia=true */,
  {     0,  2912,     0,  12,   0, UNI_SUNDANESESUP }   /* sundanesesup */,
  {     0,  7218,  5564,  10,   9, UNI_LB__QU }   /* linebreak=quotation */,
  {     6,  9768,  7168,   4,  10, UNI_DIAK }   /* scx=divesakuru */,
  {     0,  1465,     0,  24,   0, UNI_DIACRITICALSFORSYMBOLS }   /* combiningmarksforsymbols */,
  {    16,  3836,  8936,  17,   6, UNI_LYCI }   /* scriptextensions=lycian */,
  {     8,  8589,  2409,   7,   4, UNI_SC__GLAG }   /* script=glag */,
  {    32,  9768,  9604,   4,   4, UNI_KHMR }   /* scx=khmr */,
  {    17,  8780,  3768,   6,  17, UNI_LETTERLIKESYMBOLS }   /* block=letterlikesymbols */,
  {     2,  8694,     0,   7,   0, UNI_wspace_values_index }   /* wspace= */,
  {     7,  8978, 10135,   6,   3, UNI__PERL_PATWS }   /* patws=yes */,
  {     5,  9275,  2369,   5,  20, UNI_INSC__CONSONANTPLACEHOLDER }   /* insc=consonantplaceholder */,
  {     1,  9768,  8291,   4,   8, UNI_TAGB }   /* scx=tagbanwa */,
  {     3,  3133,     0,  17,   0, UNI_EBASE }   /* emojimodifierbase */,
  {     0,  7218,    83,  10,   2, UNI_LB__CM }   /* linebreak=cm */,
  {     0,  9277,  9245,   3,   4, UNI_SC__DOGR }   /* sc=dogr */,
  {     0,  8780,  6193,   6,   6, UNI_INHEBREW }   /* block=hebrew */,
  {     1, 10288,  9877,   3,   3, UNI_XSUX }   /* isxsux */,
  {     0,  1417,  8793,  25,   5, UNI_CCC__103 }   /* canonicalcombiningclass=ccc103 */,
  {    16,   184,  3768,   2,  17, UNI_LETTERLIKESYMBOLS }   /* isletterlikesymbols */,
  {     0,  8780,  7675,   6,   9, UNI_PALM }   /* block=palmyrene */,
  {     0,  8780,  8582,   6,   7, UNI_INPHAGSPA }   /* block=phagspa */,
  {     0,  3115,     0,   4,   0, UNI_DEVA }   /* deva */,
  {     0,  1552,  4943,   9,  15, UNI_TITLE }   /* category=titlecaseletter */,
  {     1,  8780,  8428,   6,   7, UNI_INGRANTHA }   /* block=grantha */,
  {     0,  8435,     3,   7,   1, -UNI_GRBASE }   /* grbase=f */,
  {     2,  9768,  9480,   4,   4, UNI_BATK }   /* scx=batk */,
  {     0,  8589,  9820,   7,   4, UNI_TFNG }   /* script=tfng */,
  {     4, 10132,  5012,   3,   2, UNI_WB__SQ }   /* wb=sq */,
  {     0, 10027, 10045,   3,   3, UNI_JG__MIM }   /* jg=mim */,
  {    12,  7218,    34,  10,   2, UNI_LB__EX }   /* linebreak=ex */,
  {     0,  1790,     0,  22,   0, UNI_cwcm_values_index }   /* changeswhencasemapped= */,
  {     8,  4097,     0,  16,   0, UNI_HIGHPUSURROGATES }   /* highpusurrogates */,
  {     4,  1417,  3572,  24,   9, UNI_CCC__BL }   /* canonicalcombiningclass=belowleft */,
  {     2,  6609,  9836,  11,   4, UNI_DEP }   /* deprecated=true */,
  {     0,  3097,  4017,  18,   3, UNI_DT__FIN }   /* decompositiontype=fin */,
  {     0,  8589,  9572,   7,   4, UNI_SC__GUJR }   /* script=gujr */,
  {     2,  1033,     0,  11,   0, UNI_ENCLOSEDCJK }   /* enclosedcjk */,
  {     2,  1591,  3684,   3,  16, UNI_ETHIOPICEXTA }   /* inethiopicextendeda */,
  {     2,  1790,  9836,  22,   4, UNI_CWCM }   /* changeswhencasemapped=true */,
  {     1,  1417,  9146,  25,   4, UNI_CCC__23 }   /* canonicalcombiningclass=ccc23 */,
  {     0,  9345,    36,   5,   1, UNI_XIDC }   /* xidc=t */,
  {     2,  9277,  9584,   3,   4, UNI_HLUW }   /* sc=hluw */,
  {    32,  8858,    36,   6,   1, UNI_ECOMP }   /* ecomp=t */,
  {     0,   184,  5739,   2,  12, UNI_GRBASE }   /* isgraphemebase */,
  {     5,   184,  4161,   2,  16, UNI_LINEARBSYLLABARY }   /* islinearbsyllabary */,
  {     0,   184,    17,   3,   1, UNI_CO }   /* isco */,
  {     0,  1966,  4417,  22,  16, UNI_INSC__VOWELINDEPENDENT }   /* indicsyllabiccategory=vowelindependent */,
  {     0,  3836,  5550,  17,  14, UNI_PHLP }   /* scriptextensions=psalterpahlavi */,
  {     1,  1025,     0,   2,   0, UNI_NO }   /* no */,
  {     0,  5986,  7883,  13,   8, UNI_NV__1_SLASH_320 }   /* numericvalue=3.13e-03 */,
  {     1,  5791,  9456,  13,   4, UNI_JG__ALEF }   /* joininggroup=alef */,
  {     1,  8589,  7188,   7,   4, UNI_KHAR }   /* script=khar */,
  {     0,  3836,  8888,  17,   4, UNI_HATR }   /* scriptextensions=hatr */,
  {     0,  9640, 10135,   4,   3, UNI_LOE }   /* loe=yes */,
  {    11,  7228,  9255,  10,   5, -UNI_XPOSIXLOWER }   /* lowercase=false */,
  {     1,  8512,  9295,   7,   5, UNI_NFCQC__M }   /* nfkcqc=maybe */,
  {    33,  9508,  7859,   4,   2, UNI_CCC__20 }   /* ccc=20 */,
  {     8,  1856,    26,  22,   1, UNI_CWU }   /* changeswhenuppercased=y */,
  {     1,  8780,  9085,   6,   5, UNI_INBATAK }   /* block=batak */,
  {     9,  9536,  1025,   4,   2, -UNI_DEP }   /* dep=no */,
  {    17,  8688,  4435,   4,  13, UNI_ARABICEXTA }   /* isarabicextendeda */,
  {     0,  8780,  7630,   6,   9, UNI_INNEWTAILUE }   /* block=newtailue */,
  {     1, 10024,  4305,   3,  16, UNI_PO }   /* gc=otherpunctuation */,
  {     0,  8997,  1025,   5,   2, -UNI_TERM }   /* term=no */,
  {    65,  6554, 10135,  11,   3, UNI_IDC }   /* idcontinue=yes */,
  {    32,  9508,  9211,   5,   4, UNI_CCC__36 }   /* ccc=ccc36 */,
  {    10, 10033,  6697,   3,  11, UNI_LB__IN }   /* lb=inseperable */,
  {     1,  8936,     0,   4,   0, UNI_LYCI }   /* lyci */,
  {     2,  1269,     0,  24,   0, UNI_COMPEX }   /* fullcompositionexclusion */,
  {     0,  8589,  8291,   7,   4, UNI_SC__TAGB }   /* script=tagb */,
  {     1,  8780,  4161,   6,  16, UNI_LINEARBSYLLABARY }   /* block=linearbsyllabary */,
  {     1,   184,  9740,   2,   4, UNI_QAAI }   /* isqaai */,
  {     2,  8780,  8219,   6,   8, UNI_INJAVANESE }   /* block=javanese */,
  {     0,  8780,  2224,   6,  21, UNI_ININSCRIPTIONALPARTHIAN }   /* block=inscriptionalparthian */,
  {     3,  2874,     0,  19,   0, UNI_OTTOMANSIYAQNUMBERS }   /* ottomansiyaqnumbers */,
  {     6,  3259,     1,  18,   1, -UNI_IDSB }   /* idsbinaryoperator=n */,
  {     8,  2569,  3504,  20,   7, UNI_VO__R }   /* verticalorientation=rotated */,
  {    34,  9768,  7188,   4,  10, UNI_KHAR }   /* scx=kharoshthi */,
  {    16,   184,  1025,   2,   2, UNI_NO }   /* isno */,
  {     1, 10024,   133,   3,   4, UNI_M }   /* gc=mark */,
  {     2, 10024,    45,   3,   2, UNI_CO }   /* gc=co */,
  {     1,  9488,  3768,   4,  17, UNI_LETTERLIKESYMBOLS }   /* blk=letterlikesymbols */,
  {    81,  2224,  4338,   3,  15, UNI_SUPMATHOPERATORS }   /* insupmathoperators */,
  {    12,  2224,   317,   3,  32, UNI_SUPMATHOPERATORS }   /* insupplementalmathematicaloperators */,
  {     8,  7088,  4493,  10,  15, UNI_BC__CS }   /* bidiclass=commonseparator */,
  {     1, 10048,  9380,   3,   3, UNI_NV__1_SLASH_8 }   /* nv=1/8 */,
  {     1,   184,  1791,   3,  20, UNI_CWCM }   /* ischangeswhencasemapped */,
  {     2,  1834,     0,  21,   0, UNI_CWT }   /* changeswhentitlecased */,
  {     1,  9277,  7278,   3,  10, UNI_XPEO }   /* sc=oldpersian */,
  {     0,  3097,     7,  18,   3, UNI_DT__CAN }   /* decompositiontype=can */,
  {    20,   184,  7358,   2,  10, UNI_SAUR }   /* issaurashtra */,
  {     0,  5116, 10135,  14,   3, UNI_EMOD }   /* emojimodifier=yes */,
  {     3, 10296,     3,   3,   1, UNI_PF }   /* ispf */,
  {     0, 10132,    18,   3,   2, UNI_RI }   /* wb=ri */,
  {     7,  8512,     0,   7,   0, UNI_nfkcqc_values_index }   /* nfkcqc= */,
  {    16,  9488,  2912,   4,   9, UNI_INSUNDANESE }   /* blk=sundanese */,
  {     4,  9768,  8187,   4,   8, UNI_HIRA }   /* scx=hiragana */,
  {     2,  9608,     0,   4,   0, UNI_KITS }   /* kits */,
  {     5,  9768,  5550,   4,  14, UNI_PHLP }   /* scx=psalterpahlavi */,
  {     1,  1552,  4017,   9,  16, UNI_PF }   /* category=finalpunctuation */,
  {     0,  9512,     0,   4,   0, UNI_CHRS }   /* chrs */,
  {     1,  7325, 10102,   3,   3, UNI_IN__5_DOT_2 }   /* in=v52 */,
  {    32,  9277,  8115,   3,   8, UNI_BASS }   /* sc=bassavah */,
  {     0,  7218,  8701,  10,   7, UNI_LB__ZW }   /* linebreak=zwspace */,
  {     4,  3836,  7567,  17,   9, UNI_SIND }   /* scriptextensions=khudawadi */,
  {     4, 10048,  7814,   3,   1, UNI_NV__7 }   /* nv=7 */,
  {     0,  9768,  8942,   4,   6, UNI_LYDI }   /* scx=lydian */,
  {     2,  8930,     0,   6,   0, UNI_lower_values_index }   /* lower= */,
  {     5,  9768,  2913,   5,   8, UNI_SUND }   /* scx=sundanese */,
  {     0,   184,  2950,   2,  19, UNI_SUPARROWSB }   /* issupplementalarrowsb */,
  {     0,  3836,  9008,  17,   4, UNI_THAA }   /* scriptextensions=thaa */,
  {     0, 10048,  7971,   3,   8, UNI_NV__7_SLASH_12 }   /* nv=5.83e-01 */,
  {    12,  8589,  8414,   7,   4, UNI_ELBA }   /* script=elba */,
  {     0,  7738,    26,   9,   1, UNI_XIDS }   /* xidstart=y */,
  {     1,  8400, 10135,   7,   3, UNI_COMPEX }   /* compex=yes */,
  {     0,  9596,  6741,   4,  11, UNI_GCB__L }   /* hst=leadingjamo */,
  {     1,  8780,  4401,   6,  16, UNI_TANGUTSUP }   /* block=tangutsupplement */,
  {     1,  8589,  2913,   8,   3, UNI_SUND }   /* script=sund */,
  {     0, 10182,  6554,   6,   6, UNI__PERL_IDCONT }   /* _perl_idcont */,
  {     1,  9488,  9828,   4,   4, UNI_INTHAI }   /* blk=thai */,
  {     1,  8589,  9504,   7,   4, UNI_CANS }   /* script=cans */,
  {     2,  8589,  9496,   7,   4, UNI_SC__BUHD }   /* script=buhd */,
  {     1,  8780,  4145,   6,  16, UNI_LINEARBIDEOGRAMS }   /* block=linearbideograms */,
  {     0,  8780,  8477,   6,   7, UNI_INMAKASAR }   /* block=makasar */,
  {     0,  1552,  1587,   9,   1, UNI_Z }   /* category=z */,
  {     1, 10048, 10140,   3,   2, UNI_NV__39 }   /* nv=39 */,
  {     2,  9588,     0,   4,   0, UNI_HMNG }   /* hmng */,
  {     0,  2760,  6763,  19,  11, UNI_LB__H3 }   /* hangulsyllabletype=lvtsyllable */,
  {     3,  8978,     1,   6,   1, -UNI__PERL_PATWS }   /* patws=n */,
  {     5,  5791,  9355,  13,   5, UNI_JG__ZHAIN }   /* joininggroup=zhain */,
  {     2,  8589,  2485,   7,   4, UNI_SC__MONG }   /* script=mong */,
  {     0,  9556,    24,   4,   1, UNI_GCB__L }   /* gcb=l */,
  {     2,  9444, 10087,   4,   3, UNI_AGE__3_DOT_2 }   /* age=v32 */,
  {     1,  1417,  7806,  24,   1, UNI_CCC__6 }   /* canonicalcombiningclass=6 */,
  {     0,  5986,  8750,  13,   4, UNI_NV__8000 }   /* numericvalue=8000 */,
  {     3,  9488,  1631,   4,  15, UNI_GEOMETRICSHAPES }   /* blk=geometricshapes */,
  {     5,  8780,  2409,   6,  20, UNI_GLAGOLITICSUP }   /* block=glagoliticsupplement */,
  {     1,  8780,  7358,   6,  10, UNI_INSAURASHTRA }   /* block=saurashtra */,
  {     3,  4791,  4290,   3,  15, UNI_MYANMAREXTB }   /* inmyanmarextendedb */,
  {    16,  7076,  8116,   3,   7, UNI_INBASSAVAH }   /* inbassavah */,
  {     1,  9528,  9836,   4,   4, UNI_CWU }   /* cwu=true */,
  {     5,  4033,  5497,  16,  11, UNI_MC }   /* generalcategory=spacingmark */,
  {     0,  5986, 10142,  13,   2, UNI_NV__44 }   /* numericvalue=44 */,
  {     4,  8780,     0,  12,   0, UNI_INCARIAN }   /* block=carian */,
  {     2,  9277,  8582,   3,   7, UNI_SC__PHAG }   /* sc=phagspa */,
  {     0,  9277,  9516,   3,   4, UNI_SC__CPRT }   /* sc=cprt */,
  {     5,  9444,  7781,   4,   1, UNI_AGE__4 }   /* age=4 */,
  {     0,  4113,  6013,   3,  12, UNI_VERTICALFORMS }   /* inverticalforms */,
  {     0,  5791,     3,  15,   1, UNI_JG__KAF }   /* joininggroup=kaf */,
  {    12, 10006,  1025,   3,   2, -UNI_DI }   /* di=no */,
  {    34,  1505,  5755,   5,  10, UNI_GREEKEXT }   /* ingreekextended */,
  {     2,  8589,  7675,   7,   4, UNI_PALM }   /* script=palm */,
  {     1,  1417,  7858,  24,   2, UNI_CCC__22 }   /* canonicalcombiningclass=22 */,
  {    17,  1417,  4912,  24,   2, UNI_CCC__0 }   /* canonicalcombiningclass=nr */,
  {     0,  7155,  8443,   3,   6, UNI_HANO }   /* ishanunoo */,
  {     2,  6061,  1025,  12,   2, -UNI_BIDIC }   /* bidicontrol=no */,
  {     1,  7438,    72,  10,   2, UNI_WB__LE }   /* wordbreak=le */,
  {     0,  8997,     0,   5,   0, UNI_term_values_index }   /* term= */,
  {     0, 10290,  5718,   6,   5, UNI_XPOSIXALNUM }   /* xposixalnum */,
  {     7, 10048,  9424,   3,   4, UNI_NV__3_SLASH_64 }   /* nv=3/64 */,
  {     0,   478,     0,  31,   0, UNI_MATHALPHANUM }   /* mathematicalalphanumericsymbols */,
  {     0,  1979,     7,  10,   1, UNI_CASEDLETTER }   /* category=lc */,
  {     0,  1114,  9836,  26,   4, UNI_CWKCF }   /* changeswhennfkccasefolded=true */,
  {     1,    21,  1677,   2,  14, UNI_LATINEXTA }   /* inlatinextendeda */,
  {     2,  9997,  3349,   3,  18, UNI_BC__B }   /* bc=paragraphseparator */,
  {     0,    42,     0,   3,   0, UNI_CJK }   /* cjk */,
  {    15, 10333,  1176,   3,   3, UNI_SORA }   /* issora */,
  {    10,  9488,  4868,   4,  15, UNI_NARB }   /* blk=oldnortharabian */,
  {    15,  9488,  2855,   4,   9, UNI_INMONGOLIAN }   /* blk=mongolian */,
  {     0,  2203,     0,   4,   0, UNI_HAN }   /* hani */,
  {     0,  4116,   447,   3,  17, UNI_IDEOGRAPHICSYMBOLS }   /* isideographicsymbols */,
  {     5, 10012,   865,   3,   1, UNI_EA__W }   /* ea=w */,
  {     3,  8688,    29,   4,   4, UNI_ARAB }   /* isarabic */,
  {     1,  8589,  4273,   7,   7, UNI_SC__MYMR }   /* script=myanmar */,
  {    12,  7218,  6697,  10,  11, UNI_LB__IN }   /* linebreak=inseperable */,
  {     1,  6420,  9311,   3,   4, UNI_INOGHAM }   /* inogham */,
  {     5,  7228,    26,  10,   1, UNI_XPOSIXLOWER }   /* lowercase=y */,
  {     0,  7218,   751,  10,   2, UNI_LB__CL }   /* linebreak=cl */,
  {     8,  9508,  1179,   4,   2, UNI_CCC__BL }   /* ccc=bl */,
  {    19,  2760,  5973,  19,  13, UNI_HST__NA }   /* hangulsyllabletype=notapplicable */,
  {     8,  8589,  2140,   7,   8, UNI_SC__CYRL }   /* script=cyrillic */,
  {     0,  5739,  1025,  13,   2, -UNI_GRBASE }   /* graphemebase=no */,
  {     0,  3133,    36,  18,   1, UNI_EBASE }   /* emojimodifierbase=t */,
  {     0,   184,  1631,   2,  23, UNI_GEOMETRICSHAPESEXT }   /* isgeometricshapesextended */,
  {     1,  8589,  4448,   7,   4, UNI_BAMU }   /* script=bamu */,
  {     4,  9488,  3043,   4,  18, UNI_HALFMARKS }   /* blk=combininghalfmarks */,
  {     2,  1393,     0,  24,   0, UNI_ARABICPFB }   /* arabicpresentationformsb */,
  {     0,  9277,  4868,   3,  15, UNI_NARB }   /* sc=oldnortharabian */,
  {     1, 10290,    62,   6,   5, UNI_XPOSIXGRAPH }   /* xposixgraph */,
  {     0, 10027,  5420,   3,   4, UNI_JG__TETH }   /* jg=teth */,
  {     2,   184,  4569,   3,  14, UNI_CURRENCYSYMBOLS }   /* iscurrencysymbols */,
  {     2, 10024,   106,   3,   6, UNI_S }   /* gc=symbol */,
  {     1, 10048,  8756,   3,   5, UNI_NV__90000 }   /* nv=90000 */,
  {     0,  3836,  3751,  17,  17, UNI_KITS }   /* scriptextensions=khitansmallscript */,
  {     0,   184,  3080,   3,  17, UNI_COPTICEPACTNUMBERS }   /* iscopticepactnumbers */,
  {     6,  8780,  8179,   6,   8, UNI_INGURMUKHI }   /* block=gurmukhi */,
  {     3,  3439,     0,  18,   0, UNI_SMALLKANAEXT }   /* smallkanaextension */,
  {     6,  1537,  2994,  24,  13, UNI_INPC__BOTTOMANDLEFT }   /* indicpositionalcategory=bottomandleft */,
  {     2,  1417,  9919,  24,   3, UNI_CCC__202 }   /* canonicalcombiningclass=202 */,
  {    64,  6231,  1467,   4,  22, UNI_DIACRITICALSFORSYMBOLS }   /* incombiningmarksforsymbols */,
  {     0,  8780,  1700,   6,  23, UNI_SHORTHANDFORMATCONTROLS }   /* block=shorthandformatcontrols */,
  {     0,    21,  3549,   4,   8, UNI_ALCHEMICAL }   /* inalchemical */,
  {     7,    21,  5284,   2,   7, UNI_LISUSUP }   /* inlisusup */,
  {     1,  2224,  3440,   3,  17, UNI_SMALLKANAEXT }   /* insmallkanaextension */,
  {     0,   184,     1,   3,   1, UNI_CN }   /* iscn */,
  {     0, 10132,   400,   3,   6, UNI_WB__FO }   /* wb=format */,
  {     1,  3836,  8942,  17,   6, UNI_LYDI }   /* scriptextensions=lydian */,
  {     3,  5060,     0,  14,   0, UNI_ci_values_index }   /* caseignorable= */,
  {    34,  9768,  3598,   4,  17, UNI_AGHB }   /* scx=caucasianalbanian */,
  {     1,  8509,   751,   4,  28, UNI_ENCLOSEDALPHANUMSUP }   /* inenclosedalphanumericsupplement */,
  {    11,  1822,     0,   2,   0, UNI_NL }   /* nl */,
  {     8,  9277,  4703,   3,  15, UNI_ARMI }   /* sc=imperialaramaic */,
  {     9,  8780,  5752,   6,  13, UNI_GREEKEXT }   /* block=greekextended */,
  {     0,  8589,  8123,   7,   8, UNI_SC__BUGI }   /* script=buginese */,
  {     6,   184,  3026,   3,   7, UNI_CHER }   /* ischerokee */,
  {     0,  1537,  2549,  24,  12, UNI_INPC__TOPANDBOTTOM }   /* indicpositionalcategory=topandbottom */,
  {     2,  9540,     1,   4,   1, -UNI_DIA }   /* dia=n */,
  {     0,  7318, 10102,  10,   3, UNI_IN__5_DOT_2 }   /* presentin=v52 */,
  {     0,  9508,  9468,   4,   4, UNI_CCC__216 }   /* ccc=atar */,
  {     0,   184,  9560,   2,   4, UNI_GONG }   /* isgong */,
  {     0,  2161,     0,  20,   0, UNI_EXTPICT }   /* extendedpictographic */,
  {     0,  8768,  1025,   6,   2, -UNI_BIDIC }   /* bidic=no */,
  {    14,  8780,  3295,   6,   9, UNI_LATINEXTA }   /* block=latinexta */,
  {     2,  2280,  2875,   3,  18, UNI_OTTOMANSIYAQNUMBERS }   /* isottomansiyaqnumbers */,
  {     3, 10296,  8979,   3,   4, UNI__PERL_PATWS }   /* ispatws */,
  {     1,  9508,  7778,   4,   2, UNI_CCC__21 }   /* ccc=21 */,
  {     3,  7325,  9397,   3,   3, UNI_IN__2_DOT_1 }   /* in=2.1 */,
  {     4,  4868,     0,  15,   0, UNI_NARB }   /* oldnortharabian */,
  {    32,  2098,     0,  21,   0, UNI_CJKCOMPATFORMS }   /* cjkcompatibilityforms */,
  {     0,  3295,     0,   9,   0, UNI_LATINEXTA }   /* latinexta */,
  {     3,  3836,  8123,  17,   8, UNI_BUGI }   /* scriptextensions=buginese */,
  {     1,  9488,  3241,   4,  11, UNI_GEORGIANSUP }   /* blk=georgiansup */,
  {     8,  1417,  8805,  25,   5, UNI_CCC__118 }   /* canonicalcombiningclass=ccc118 */,
  {     2,  9277,  7666,   3,   9, UNI_ORKH }   /* sc=oldturkic */,
  {     1,  8774, 10135,   6,   3, UNI_BIDIM }   /* bidim=yes */,
  {     5,  8954,     0,   7,   0, -UNI__PERL_NCHAR }   /* nchar=n */,
  {     0,   184,  1822,   2,   2, UNI_NL }   /* isnl */,
  {     0, 10310,  8301,   4,   6, UNI_INTIFINAGH }   /* intifinagh */,
  {     0,  8780,   114,   7,  24, UNI_DIACRITICALS }   /* block=combiningdiacriticalmarks */,
  {     0,  1677,     0,  23,   0, UNI_LATINEXTADDITIONAL }   /* latinextendedadditional */,
  {     3,  2161,     1,  21,   1, -UNI_EXTPICT }   /* extendedpictographic=n */,
  {     2,  1552,   406,   9,   7, UNI_XPOSIXCNTRL }   /* category=control */,
  {    11,  7218,    58,  10,   2, UNI_LB__ID }   /* linebreak=id */,
  {    16,  4916,  1116,   3,   3, UNI_TANG }   /* istang */,
  {     0,  5578,   495,  14,   7, UNI_SB__NU }   /* sentencebreak=numeric */,
  {     0,  1417,  8825,  24,   3, UNI_CCC__130 }   /* canonicalcombiningclass=130 */,
  {     1, 10288,  5039,   8,   6, UNI_XPOSIXXDIGIT }   /* isxposixxdigit */,
  {     1,  9444,  9852,   4,   4, UNI_AGE__12_DOT_1 }   /* age=v121 */,
  {     0,  9277,  9448,   3,   4, UNI_AGHB }   /* sc=aghb */,
  {     0,  5986,  7827,  13,   8, UNI_NV__1_SLASH_5 }   /* numericvalue=2.00e-01 */,
  {     3,  1188,  8653,   3,   6, UNI_INTAIVIET }   /* intaiviet */,
  {     4,  2182,  5497,  21,  11, UNI_GCB__SM }   /* graphemeclusterbreak=spacingmark */,
  {     1,  8589,  9676,   7,   4, UNI_NARB }   /* script=narb */,
  {     2,  4369,     0,   6,   0, UNI_SYRC }   /* syriac */,
  {     2,  4305,     0,  16,   0, UNI_PO }   /* otherpunctuation */,
  {     0,  9524,  1025,   4,   2, -UNI_CWT }   /* cwt=no */,
  {     2,  1966,   728,  22,   6, UNI_INSC__NUMBER }   /* indicsyllabiccategory=number */,
  {    12,  2287,     0,   4,   0, UNI_SINH }   /* sinh */,
  {     0, 10009,  5012,   3,   6, UNI_DT__SQR }   /* dt=square */,
  {     0,  9488,  8421,   4,   7, UNI_INELYMAIC }   /* blk=elymaic */,
  {     1,  9277,  7657,   3,   9, UNI_SC__PERM }   /* sc=oldpermic */,
  {     2,  9340,     0,   5,   0, UNI_VSSUP }   /* vssup */,
  {     1,  8882,     0,   6,   0, UNI_grext_values_index }   /* grext= */,
  {     0,  9277,  8219,   3,   8, UNI_SC__JAVA }   /* sc=javanese */,
  {     3,  5791,  2637,  13,   3, UNI_JG__YEH }   /* joininggroup=yeh */,
  {    21,  3836,  8498,  17,   4, UNI_MULT }   /* scriptextensions=mult */,
  {     5,  8774,     1,   6,   1, -UNI_BIDIM }   /* bidim=n */,
  {    16,  1188,  9336,   3,   4, UNI_INTAKRI }   /* intakri */,
  {    18, 10048,  7806,   3,   1, UNI_NV__6 }   /* nv=6 */,
  {     1,  3836,  8131,  17,   8, UNI_DUPL }   /* scriptextensions=duployan */,
  {     2,  5739,     1,  13,   1, -UNI_GRBASE }   /* graphemebase=n */,
  {     1,  8978,  9836,   6,   4, UNI__PERL_PATWS }   /* patws=true */,
  {     5,  9351,  1025,   4,   2, -UNI_IDS }   /* ids=no */,
  {     1, 10033,    96,   3,  10, UNI_LB__AL }   /* lb=alphabetic */,
  {     0,  7325, 10099,   3,   3, UNI_IN__5_DOT_1 }   /* in=v51 */,
  {     0,  1537,  6621,   3,   5, UNI_DOMINO }   /* indomino */,
  {     1,  9488,   719,   4,   9, UNI_INCUNEIFORM }   /* blk=cuneiform */,
  {    10,  9488,  8603,   4,   7, UNI_SHAW }   /* blk=shavian */,
  {    12,  9240,     0,   5,   0, UNI_dash_values_index }   /* dash= */,
  {     5, 10027,  6373,   3,  12, UNI_JG__MANICHAEANPE }   /* jg=manichaeanpe */,
  {     0,  1552,  4305,   9,  16, UNI_PO }   /* category=otherpunctuation */,
  {     1,   184,  8115,   2,   8, UNI_BASS }   /* isbassavah */,
  {     3,  8894,    36,   6,   1, UNI_JOINC }   /* joinc=t */,
  {     0,  9488,  6409,   4,  12, UNI_INMENDEKIKAKUI }   /* blk=mendekikakui */,
  {     0,  8449,  9255,   7,   5, -UNI_HYPHEN }   /* hyphen=false */,
  {     0,  8762,    26,   6,   1, UNI_XPOSIXALPHA }   /* alpha=y */,
  {     2,  9277,  7428,   3,  10, UNI_WARA }   /* sc=warangciti */,
  {     0,  2569,  3493,  20,  18, UNI_VO__TR }   /* verticalorientation=transformedrotated */,
  {     0,  3836,  8315,  17,   8, UNI_UGAR }   /* scriptextensions=ugaritic */,
  {     0,  8589,  5843,   7,   9, UNI_SC__MLYM }   /* script=malayalam */,
  {     1,  1585,     0,  14,   0, UNI_BYZANTINEMUSIC }   /* byzantinemusic */,
  {     0, 10027,  8155,   3,   8, UNI_JG__FARSIYEH }   /* jg=farsiyeh */,
  {     0,  6805,   287,   6,  29, UNI_MISCMATHSYMBOLSB }   /* inmiscellaneousmathematicalsymbolsb */,
  {     2,  9488,  9310,   4,   5, UNI_INOGHAM }   /* blk=ogham */,
  {     4,  6231,  3796,   3,   3, UNI_INCHAM }   /* incham */,
  {     8,   184,  2931,   2,  19, UNI_SUPARROWSA }   /* issupplementalarrowsa */,
  {    17,  7076,  7069,   3,   9, UNI_ASCII }   /* inbasiclatin */,
  {     0,  1441,     0,  24,   0, UNI_CJKSYMBOLS }   /* cjksymbolsandpunctuation */,
  {     2,  8589,  4145,   7,   7, UNI_SC__LINB }   /* script=linearb */,
  {     4,  7660,     0,   4,   0, UNI_PERM }   /* perm */,
  {    18,  9768,  3937,   4,   8, UNI_BOPO }   /* scx=bopomofo */,
  {     0,  9277,  3079,   3,   4, UNI_SC__COPT }   /* sc=copt */,
  {     3,  8617,     0,   7,   0, UNI_SOYO }   /* soyombo */,
  {     2,  4916,  8300,   3,   7, UNI_TFNG }   /* istifinagh */,
  {     2,  3836,  8912,  17,   4, UNI_KHOJ }   /* scriptextensions=khoj */,
  {    13,  9508,  7859,   4,   3, UNI_WB__EB }   /* ccc=200 */,
  {     0,  9768,  9732,   4,   4, UNI_PRTI }   /* scx=prti */,
  {     0,  2784,  7506,   4,   7, UNI_ARABICPFB }   /* inarabicpfb */,
  {     1,  6061,     0,  11,   0, UNI_BIDIC }   /* bidicontrol */,
  {     0,  9444,  7469,   4,   1, UNI_AGE__5 }   /* age=5 */,
  {     1,  9768,  9325,   4,   5, UNI_RUNR }   /* scx=runic */,
  {     0,  6231,  2141,   3,  20, UNI_CYRILLICSUP }   /* incyrillicsupplementary */,
  {     1,  8589,  9008,   7,   4, UNI_SC__THAA }   /* script=thaa */,
  {     0,   184,  5040,   2,   5, UNI_XPOSIXDIGIT }   /* isdigit */,
  {     1,  8589,  8876,   7,   6, UNI_GOTH }   /* script=gothic */,
  {     8,  9768,    57,   4,   2, UNI_YI }   /* scx=yi */,
  {     0,  4049,     0,  16,   0, UNI_GEORGIANEXT }   /* georgianextended */,
  {     0,  1189,   495,   3,   2, UNI_NT__NU }   /* nt=nu */,
  {     0,  3374,    36,  11,   1, UNI_XPOSIXSPACE }   /* whitespace=t */,
  {     0,   206,     0,   2,   0, UNI_PI }   /* pi */,
  {     2,  3379,     0,   5,   0, UNI_XPOSIXSPACE }   /* space */,
  {    20,  3836,  9285,  17,   5, UNI_LIMB }   /* scriptextensions=limbu */,
  {     5,  3836,  3169,  17,   4, UNI_ETHI }   /* scriptextensions=ethi */,
  {     0,  5578,    34,  14,   6, UNI_SB__EX }   /* sentencebreak=extend */,
  {     0,  3836,  7666,  17,   9, UNI_ORKH }   /* scriptextensions=oldturkic */,
  {     0,  8780,  9325,   6,   5, UNI_INRUNIC }   /* block=runic */,
  {     1,  9014,     0,   5,   0, UNI_UIDEO }   /* uideo */,
  {     2, 10024,   406,   3,   7, UNI_XPOSIXCNTRL }   /* gc=control */,
  {     8,   184,  3349,   2,  18, UNI_ZP }   /* isparagraphseparator */,
  {     1, 10126,  3504,   3,   7, UNI_VO__R }   /* vo=rotated */,
  {     0, 10009,  2569,   3,   8, UNI_DT__VERT }   /* dt=vertical */,
  {     3,  5674,     3,  13,   1, -UNI_BIDIM }   /* bidimirrored=f */,
  {     0,  9488,   951,   4,  28, UNI_VSSUP }   /* blk=variationselectorssupplement */,
  {    37,  5324,  6279,   4,  10, UNI_MAHJONG }   /* inmahjongtiles */,
  {    18,  9508,  8801,   4,   3, UNI_CCC__107 }   /* ccc=107 */,
  {     0,  9768,  6884,   4,  11, UNI_HMNG }   /* scx=pahawhhmong */,
  {     1,  5986, 10148,  13,   2, UNI_NV__47 }   /* numericvalue=47 */,
  {     1,  8780,  5200,   6,   7, UNI_KANASUP }   /* block=kanasup */,
  {     4,  9768,     0,   4,   0, UNI_scx_values_index }   /* scx= */,
  {    28,  7738,     0,   4,   0, UNI_XIDS }   /* xids */,
  {     0,  5778,     0,  13,   0, UNI_IPAEXT }   /* ipaextensions */,
  {     2,  7738,  9836,   9,   4, UNI_XIDS }   /* xidstart=true */,
  {     0,  1768,  9255,  22,   5, -UNI_CWCF }   /* changeswhencasefolded=false */,
  {     0, 10048,  9913,   3,   3, UNI_NV__2_SLASH_3 }   /* nv=2/3 */,
  {     2,  6609,    26,  11,   1, UNI_DEP }   /* deprecated=y */,
  {    34,    21,  1007,   3,  26, UNI_ANCIENTGREEKMUSIC }   /* inancientgreekmusicalnotation */,
  {     0,  2182,  5585,  21,   2, UNI_WB__EB }   /* graphemeclusterbreak=eb */,
  {     0,  1988, 10135,  22,   3, UNI_LOE }   /* logicalorderexception=yes */,
  {     0,   184,  3367,   2,  17, UNI__PERL_PATWS }   /* ispatternwhitespace */,
  {     2,  3385,    26,  18,   1, UNI_RI }   /* regionalindicator=y */,
  {     1,   184,  6012,   2,  13, UNI_VERTICALFORMS }   /* isverticalforms */,
  {     1,  9270,  6885,   3,  10, UNI_INPAHAWHHMONG }   /* inpahawhhmong */,
  {     1,  9768,  7428,   4,   4, UNI_WARA }   /* scx=wara */,
  {     1,  8780,  2076,   6,  15, UNI_TRANSPORTANDMAP }   /* block=transportandmap */,
  {     2,    78,     0,   4,   0, UNI_ARAB }   /* arab */,
  {     0,  9275,  1489,   5,  24, UNI_INSC__CONSONANTSUCCEEDINGREPHA }   /* insc=consonantsucceedingrepha */,
  {    12,  9277,  7660,   3,   4, UNI_SC__PERM }   /* sc=perm */,
  {     3,   184,  1922,   2,  22, UNI_DIACRITICALSFORSYMBOLS }   /* isdiacriticalsforsymbols */,
  {     2,  8589,  9283,   7,   4, UNI_PHLI }   /* script=phli */,
  {     6, 10024,  1025,   3,   2, UNI_NO }   /* gc=no */,
  {     0, 10009,  2569,   3,   4, UNI_DT__VERT }   /* dt=vert */,
  {     6,  4033,  2349,  16,  20, UNI_PC }   /* generalcategory=connectorpunctuation */,
  {     0, 10027,  5908,   3,  13, UNI_JG__MANICHAEANTAW }   /* jg=manichaeantaw */,
  {     9, 10132,  1218,   3,   8, UNI_WB__KA }   /* wb=katakana */,
  {     8,  7228,     0,  10,   0, UNI_lower_values_index }   /* lowercase= */,
  {     0,  8780,  8841,   7,   5, UNI_INCHAKMA }   /* block=chakma */,
  {     1,   184,     2,   3,   1, UNI_CI }   /* isci */,
  {     0,  9768,  4928,   4,   5, UNI_TAML }   /* scx=tamil */,
  {     3,  5746, 10135,   6,   3, UNI_EBASE }   /* ebase=yes */,
  {     1,  9768,  1218,   4,   8, UNI_KANA }   /* scx=katakana */,
  {     1,  2224,  4370,   3,   8, UNI_SYRIACSUP }   /* insyriacsup */,
  {     0, 10024,  1822,   3,   2, UNI_NL }   /* gc=nl */,
  {    16,   184,  1823,   2,   9, UNI_XPOSIXLOWER }   /* islowercase */,
  {    16, 10048,  7979,   3,   8, UNI_NV__3_SLASH_5 }   /* nv=6.00e-01 */,
  {     3,  3379,     1,   6,   1, -UNI_XPOSIXSPACE }   /* space=n */,
  {     4,  1552,  1186,   9,   2, UNI_PO }   /* category=po */,
  {     0,  6623,  2876,   4,  17, UNI_OTTOMANSIYAQNUMBERS }   /* inottomansiyaqnumbers */,
  {    17,  9277,  8171,   3,   8, UNI_SC__GUJR }   /* sc=gujarati */,
  {     4,  9508,  9201,   5,   4, UNI_CCC__34 }   /* ccc=ccc34 */,
  {     2,  9488,    42,   4,  36, UNI_CJKCOMPATIDEOGRAPHSSUP }   /* blk=cjkcompatibilityideographssupplement */,
  {     0, 10048,  9420,   3,   4, UNI_NV__3_SLASH_20 }   /* nv=3/20 */,
  {     2,  9346,     0,   4,   0, UNI_idc_values_index }   /* idc= */,
  {     0, 10027,  1511,   3,   3, UNI_JG__HAH }   /* jg=hah */,
  {     0, 10027,  5340,   3,  14, UNI_JG__MANICHAEANFIVE }   /* jg=manichaeanfive */,
  {     0,  2912,     0,  19,   0, UNI_SUNDANESESUP }   /* sundanesesupplement */,
  {    17,  9768,   719,   4,   9, UNI_XSUX }   /* scx=cuneiform */,
  {     0,  3259,     0,   4,   0, UNI_IDSB }   /* idsb */,
  {     0,  8589,  8582,   7,   7, UNI_SC__PHAG }   /* script=phagspa */,
  {    17,  1552,  9503,   9,   2, UNI_MC }   /* category=mc */,
  {    14,  3836,  7684,  17,   9, UNI_PAUC }   /* scriptextensions=paucinhau */,
  {     0,  4916,  4944,   3,  14, UNI_TITLE }   /* istitlecaseletter */,
  {     5,  9496,     0,   4,   0, UNI_BUHD }   /* buhd */,
  {     0,  9508,  7858,   4,   2, UNI_CCC__22 }   /* ccc=22 */,
  {     1,   184,  1319,   2,  25, UNI_SYMBOLSANDPICTOGRAPHSEXTA }   /* issymbolsandpictographsexta */,
  {     1, 10296,     0,  12,   0, UNI_POSIXBLANK }   /* isposixblank */,
  {     1,  6928,     1,  11,   1, -UNI_SD }   /* softdotted=n */,
  {     2,  3836,  9002,  17,   4, UNI_TELU }   /* scriptextensions=telu */,
  {     6,   184,  3683,   2,  11, UNI_ETHIOPICEXT }   /* isethiopicext */,
  {     9,  9290,  9255,   5,   5, -UNI_MATH }   /* math=false */,
  {     0,  8780,   895,   6,  28, UNI_SUPPUAA }   /* block=supplementaryprivateuseareaa */,
  {    16,  8219,     0,   4,   0, UNI_JAVA }   /* java */,
  {     0,  9488,  8442,   4,   7, UNI_INHANUNOO }   /* blk=hanunoo */,
  {     0,  5791,  4225,  13,  16, UNI_JG__MANICHAEANTWENTY }   /* joininggroup=manichaeantwenty */,
  {    19,   184,  6409,   2,   4, UNI_MEND }   /* ismend */,
  {     3,  5037,  9255,   9,   5, -UNI_XPOSIXXDIGIT }   /* hexdigit=false */,
  {     9,  9560,     0,   4,   0, UNI_GONG }   /* gong */,
  {     0,   117,  2226,   4,  19, UNI_ININSCRIPTIONALPARTHIAN }   /* ininscriptionalparthian */,
  {     3,  8589,  9512,   7,   4, UNI_CHRS }   /* script=chrs */,
  {     3,  5739,     0,  13,   0, UNI_grbase_values_index }   /* graphemebase= */,
  {     0,  7218,  6169,  10,   4, UNI_LB__GL }   /* linebreak=glue */,
  {     0,   184,  1901,   3,  21, UNI_INDICNUMBERFORMS }   /* iscommonindicnumberforms */,
  {     0, 10024,     7,   3,   1, UNI_C }   /* gc=c */,
  {     1,   117,  5779,   3,   5, UNI_IPAEXT }   /* inipaext */,
  {     1,  8688,    15,   4,   2, UNI_ARAB }   /* isarab */,
  {     4,  9444,  9848,   4,   4, UNI_AGE__12 }   /* age=v120 */,
  {     3,  9768,  9664,   4,   3, UNI_MRO }   /* scx=mro */,
  {    16,  9460,     0,   4,   0, UNI_ARMI }   /* armi */,
  {     1,  8589,  3895,   8,   3, UNI_SGNW }   /* script=sgnw */,
  {     2,  3836,  8407,  17,   7, UNI_DSRT }   /* scriptextensions=deseret */,
  {     0, 10048,  9050,   3,   5, UNI_NV__1_SLASH_160 }   /* nv=1/160 */,
  {     1,  9768,  9008,   4,   4, UNI_THAA }   /* scx=thaa */,
  {    14,  8960,     0,   6,   0, UNI_nfcqc_values_index }   /* nfcqc= */,
  {     3,  9262,  8554,   3,   7, UNI_SB__LE }   /* sb=oletter */,
  {     1,  8267,    36,   8,   1, UNI_RADICAL }   /* radical=t */,
  {     0,  8855,     0,   2,   0, UNI_CF }   /* cf */,
  {     8,  1417,   184,  24,   2, UNI_CCC__IS }   /* canonicalcombiningclass=is */,
  {     0,  9250,    36,   5,   1, UNI_EMOD }   /* emod=t */,
  {     0,  7155,  8188,   3,   7, UNI_HIRA }   /* ishiragana */,
  {    19,  9556,  5497,   4,  11, UNI_GCB__SM }   /* gcb=spacingmark */,
  {     2,   184,  6061,   2,   5, UNI_BIDIC }   /* isbidic */,
  {     2,  7540, 10135,   9,   3, UNI_EXT }   /* extender=yes */,
  {     3,  8780,  8470,   6,   7, UNI_INLINEARA }   /* block=lineara */,
  {     8, 10291, 10308,   5,   5, UNI_POSIXPRINT }   /* posixprint */,
  {     0, 10027,  6313,   3,  12, UNI_JG__MALAYALAMNGA }   /* jg=malayalamnga */,
  {     3, 10048,  7469,   3,   1, UNI_NV__5 }   /* nv=5 */,
  {    51,  9351,    26,   4,   1, UNI_IDS }   /* ids=y */,
  {     1,  9997,  5829,   3,   3, UNI_BC__RLO }   /* bc=rlo */,
  {     0,  9488,  9684,   4,   4, UNI_INNEWA }   /* blk=newa */,
  {     2,  9768,  3025,   4,   8, UNI_CHER }   /* scx=cherokee */,
  {     0,  1417, 10172,  24,   2, UNI_CCC__9 }   /* canonicalcombiningclass=vr */,
  {    15, 10333,     7,   3,   1, UNI_SC }   /* issc */,
  {     0,  7318,  7950,  10,   1, UNI_IN__9 }   /* presentin=9 */,
  {     0,  2288,  5187,   3,  13, UNI_HIGHSURROGATES }   /* inhighsurrogates */,
  {    14, 10009,  4532,   3,   6, UNI_DT__MED }   /* dt=medial */,
  {     0,  6231,  2099,   3,  20, UNI_CJKCOMPATFORMS }   /* incjkcompatibilityforms */,
  {    16,  3241,     0,   8,   0, UNI_GEOR }   /* georgian */,
  {     0,  9270,  6506,   3,  11, UNI_PHAISTOS }   /* inphaistosdisc */,
  {     8,  4643,     0,  15,   0, UNI_ecomp_values_index }   /* emojicomponent= */,
  {    17,  5791,  8283,  13,   8, UNI_JG__SWASHKAF }   /* joininggroup=swashkaf */,
  {     0,  5986,  9050,  13,   4, UNI_NV__1_SLASH_16 }   /* numericvalue=1/16 */,
  {     5,  9508,  3015,   4,  10, UNI_CCC__AR }   /* ccc=aboveright */,
  {     4,  2280,  9713,   3,   3, UNI_OSGE }   /* isosge */,
  {     1,  9768,  4868,   4,  15, UNI_NARB }   /* scx=oldnortharabian */,
  {     1,  9260,     1,   5,   1, -UNI_IDSB }   /* idsb=n */,
  {     1,  5986,  7803,  13,   8, UNI_NV__1_SLASH_64 }   /* numericvalue=1.56e-02 */,
  {     2,  8179,     0,   8,   0, UNI_GURU }   /* gurmukhi */,
  {     3,  9488,  8179,   4,   8, UNI_INGURMUKHI }   /* blk=gurmukhi */,
  {     0,  9277,  7648,   3,   9, UNI_ITAL }   /* sc=olditalic */,
  {     1,  8882,    36,   6,   1, UNI_GREXT }   /* grext=t */,
  {    32,  9768,  9315,   4,   5, UNI_ORYA }   /* scx=oriya */,
  {     0, 10024,  3358,   3,   9, UNI_Z }   /* gc=separator */,
  {     1,  2429,     0,  20,   0, UNI_PHLI }   /* inscriptionalpahlavi */,
  {     3,  5986, 10146,  13,   2, UNI_NV__46 }   /* numericvalue=46 */,
  {    22, 10048,  8042,   3,   2, UNI_NV__18 }   /* nv=18 */,
  {     5,  8954,  9836,   6,   4, UNI__PERL_NCHAR }   /* nchar=true */,
  {     0,  4401,     0,  16,   0, UNI_TANGUTSUP }   /* tangutsupplement */,
  {     0,  8780,  5284,   6,   4, UNI_INLISU }   /* block=lisu */,
  {     0,  9536,    36,   4,   1, UNI_DEP }   /* dep=t */,
  {    19,    21,  7027,   2,  11, UNI_YISYLLABLES }   /* inyisyllables */,
  {     0,  9444,  7765,   4,   1, UNI_AGE__2 }   /* age=2 */,
  {     0,  9768,  3115,   4,  10, UNI_DEVA }   /* scx=devanagari */,
  {     0,   184,  3295,   2,   9, UNI_LATINEXTA }   /* islatinexta */,
  {     2,  4422,  8409,   4,   5, UNI_DSRT }   /* indeseret */,
  {     2,  4478,     0,  15,   0, UNI_BRAI }   /* braillepatterns */,
  {     0,  8589,  8470,   7,   7, UNI_SC__LINA }   /* script=lineara */,
  {     9,  1988,     1,  22,   1, -UNI_LOE }   /* logicalorderexception=n */,
  {     1,  1417,  7859,  24,   2, UNI_CCC__20 }   /* canonicalcombiningclass=20 */,
  {    13,  9488,  6517,   4,  12, UNI_PLAYINGCARDS }   /* blk=playingcards */,
  {     2,   895,     0,  28,   0, UNI_SUPPUAA }   /* supplementaryprivateuseareaa */,
  {     0, 10027,  6950,   3,  11, UNI_JG__STRAIGHTWAW }   /* jg=straightwaw */,
  {     0,  2722,     0,  10,   0, UNI_JAMO }   /* hanguljamo */,
  {     1,  2224,  5607,   3,  13, UNI_SUPPUNCTUATION }   /* insuppunctuation */,
  {     0,  9277,  3079,   3,   6, UNI_SC__COPT }   /* sc=coptic */,
  {     1,  5032,     0,   5,   0, UNI_ASCII }   /* ascii */,
  {     0,  3836,  9484,  17,   4, UNI_BHKS }   /* scriptextensions=bhks */,
  {     0, 10006,    26,   3,   1, UNI_DI }   /* di=y */,
  {     1, 10048,  9432,   3,   4, UNI_NV__5_SLASH_12 }   /* nv=5/12 */,
  {     0,  1979,    47,  10,   1, UNI_LM }   /* category=lm */,
  {     5,  9688,     0,   3,   0, UNI_NKO }   /* nko */,
  {     2,  9700,     0,   4,   0, UNI_OLCK }   /* olck */,
  {     1,  9580,     0,   4,   0, UNI_HANO }   /* hano */,
  {     3,  2182,  1910,  21,   2, UNI_GCB__CN }   /* graphemeclusterbreak=cn */,
  {     0,  8780,  9038,   6,   6, UNI_INYEZIDI }   /* block=yezidi */,
  {     0,  6553, 10135,  12,   3, UNI_XIDC }   /* xidcontinue=yes */,
  {     0,   184,  7428,   2,   4, UNI_WARA }   /* iswara */,
  {     9,  7088,  2798,  10,  19, UNI_BC__LRO }   /* bidiclass=lefttorightoverride */,
  {     1,  9768,  6409,   4,   4, UNI_MEND }   /* scx=mend */,
  {     4,  1417,   756,  24,   2, UNI_CCC__DA }   /* canonicalcombiningclass=da */,
  {     1,  9768,  6940,   5,  10, UNI_SORA }   /* scx=sorasompeng */,
  {    13,   400,     0,   6,   0, UNI_CF }   /* format */,
  {     3,  2182,  3385,  21,  17, UNI_RI }   /* graphemeclusterbreak=regionalindicator */,
  {     0, 10288,   467,   8,   5, UNI_XPOSIXPUNCT }   /* isxposixpunct */,
  {     0,  5452,     0,  14,   0, UNI_nfcqc_values_index }   /* nfcquickcheck= */,
  {     4, 10296,   131,   3,   3, UNI_PALM }   /* ispalm */,
  {     1,  4033,  1527,  16,   9, UNI__PERL_SURROGATE }   /* generalcategory=surrogate */,
  {     9,  3836,  4370,  18,   5, UNI_SYRC }   /* scriptextensions=syriac */,
  {     7,  8984,  1025,   6,   2, -UNI_QMARK }   /* qmark=no */,
  {     0,  4033,    32,  16,   2, UNI__PERL_SURROGATE }   /* generalcategory=cs */,
  {     2,  8575,     0,   6,   0, UNI_PATSYN }   /* patsyn */,
  {    15,  9488,  3295,   4,  18, UNI_LATINEXTADDITIONAL }   /* blk=latinextadditional */,
  {     1,  8589,  9864,   7,   4, UNI_WCHO }   /* script=wcho */,
  {     0,  8435,  1025,   7,   2, -UNI_GRBASE }   /* grbase=no */,
  {    11,  9277,  9796,   3,   4, UNI_SC__SYRC }   /* sc=syrc */,
  {     0,  8780,  3887,   6,  17, UNI_SUTTONSIGNWRITING }   /* block=suttonsignwriting */,
  {     1,  9277,  2560,   3,   4, UNI_SC__MAND }   /* sc=mand */,
  {    20,  3151,     0,  17,   0, UNI_EPRES }   /* emojipresentation */,
  {    41, 10012,  8948,   3,   6, UNI_EA__NA }   /* ea=narrow */,
  {     2,   184,  8414,   2,   7, UNI_ELBA }   /* iselbasan */,
  {     8,  8589,  7666,   7,   9, UNI_ORKH }   /* script=oldturkic */,
  {     1,  5578,  2529,  15,   4, UNI_SB__ST }   /* sentencebreak=sterm */,
  {     1,  9277,  7118,   3,  10, UNI_CHRS }   /* sc=chorasmian */,
  {     2,  4433,     0,  15,   0, UNI_ARABICEXTA }   /* arabicextendeda */,
  {     0,  2855,     0,  12,   0, UNI_MONGOLIANSUP }   /* mongoliansup */,
  {     1,  1166,     0,  25,   0, UNI_DI }   /* defaultignorablecodepoint */,
  {     0,  5508,     0,  13,   0, UNI_PATSYN }   /* patternsyntax */,
  {     0,  6796,     0,  11,   0, UNI_MEDF }   /* medefaidrin */,
  {     0,   184,   218,   3,  32, UNI_DIACRITICALSEXT }   /* iscombiningdiacriticalmarksextended */,
  {     1,  9488,  4973,   4,  15, UNI_VEDICEXT }   /* blk=vedicextensions */,
  {     4,  8400,    36,   7,   1, UNI_COMPEX }   /* compex=t */,
  {     0,  3836,   382,  17,   4, UNI_EGYP }   /* scriptextensions=egyp */,
  {     1,  9014,    36,   6,   1, UNI_UIDEO }   /* uideo=t */,
  {     1,  5791,  5179,  13,   7, UNI_JG__HEHGOAL }   /* joininggroup=hehgoal */,
  {     1,  6205,  9836,  12,   4, UNI_IDEO }   /* ideographic=true */,
  {     0,  8882,  1025,   6,   2, -UNI_GREXT }   /* grext=no */,
  {     1,  3259, 10135,  18,   3, UNI_IDSB }   /* idsbinaryoperator=yes */,
  {     9,  9275,  6463,   5,   6, UNI_LB__ZWJ }   /* insc=joiner */,
  {     0,   184,    43,   3,  25, UNI_CJKCOMPATIDEOGRAPHS }   /* iscjkcompatibilityideographs */,
  {     0, 10030,  7258,   3,  10, UNI_JT__U }   /* jt=nonjoining */,
  {     0,  7318, 10096,  10,   3, UNI_IN__5 }   /* presentin=v50 */,
  {     4, 10027,  5378,   3,   4, UNI_JG__KAPH }   /* jg=kaph */,
  {    18, 10048,  5648,   3,  11, UNI_NV__10000000000 }   /* nv=10000000000 */,
  {     0,  9345,    26,   5,   1, UNI_XIDC }   /* xidc=y */,
  {     0,  8997, 10135,   5,   3, UNI_TERM }   /* term=yes */,
  {     5,  8780,  7585,   6,   9, UNI_LATINEXTC }   /* block=latinextc */,
  {     5, 10030,     0,   3,   0, UNI_jt_values_index }   /* jt= */,
  {     4,   867,     0,  11,   0, UNI_PHONETICEXT }   /* phoneticext */,
  {     1,  8780,    43,   7,  15, UNI_CJKCOMPAT }   /* block=cjkcompatibility */,
  {     1,  3097,  9552,  18,   4, UNI_DT__FONT }   /* decompositiontype=font */,
  {     0,   184,  8936,   2,   4, UNI_LYCI }   /* islyci */,
  {     5,  7585,     0,   9,   0, UNI_LATINEXTC }   /* latinextc */,
  {     0,  9488,  8638,   4,   7, UNI_INTAGALOG }   /* blk=tagalog */,
  {     3,  9508,  7874,   4,   2, UNI_CCC__23 }   /* ccc=23 */,
  {    40,  7218,  1751,  10,   2, UNI_LB__AI }   /* linebreak=ai */,
  {     0,  9508,  9206,   5,   4, UNI_CCC__35 }   /* ccc=ccc35 */,
  {     0,  9488,  5830,   4,  13, UNI_LOWSURROGATES }   /* blk=lowsurrogates */,
  {     0,  9488,  7027,   4,  11, UNI_YISYLLABLES }   /* blk=yisyllables */,
  {     1,  4791,  2247,   4,   9, UNI_INMEETEIMAYEK }   /* inmeeteimayek */,
  {     8,  6231,  4569,   3,  14, UNI_CURRENCYSYMBOLS }   /* incurrencysymbols */,
  {     3,  9768,  2817,   4,  19, UNI_MERO }   /* scx=meroitichieroglyphs */,
  {     1,  8780,  2874,   6,  19, UNI_OTTOMANSIYAQNUMBERS }   /* block=ottomansiyaqnumbers */,
  {     0, 10048,  7781,   3,   1, UNI_NV__4 }   /* nv=4 */,
  {     0,  8780,  3937,   6,  16, UNI_BOPOMOFOEXT }   /* block=bopomofoextended */,
  {     6,  9508,  3564,   4,  13, UNI_CCC__202 }   /* ccc=attachedbelow */,
  {     1,  7076,  4479,   3,  14, UNI_BRAI }   /* inbraillepatterns */,
  {     4,  2280,  4306,   3,   4, UNI_C }   /* isother */,
  {     0,  9488,  8243,   4,   8, UNI_INMAHAJANI }   /* blk=mahajani */,
  {    17,  8780,   809,   6,  29, UNI_ENCLOSEDIDEOGRAPHICSUP }   /* block=enclosedideographicsupplement */,
  {     2,  9768,  8243,   4,   8, UNI_MAHJ }   /* scx=mahajani */,
  {     1,  9492,  4898,   4,   4, UNI_BPT__O }   /* bpt=open */,
  {     9,  5791,  7048,  13,  10, UNI_JG__AFRICANQAF }   /* joininggroup=africanqaf */,
  {     0,  4916,  2532,   5,  16, UNI_TERM }   /* isterminalpunctuation */,
  {     1,  5986,  8714,  13,   6, UNI_NV__300000 }   /* numericvalue=300000 */,
  {     0,  4116,   415,   3,  10, UNI_IDEO }   /* isideographic */,
  {    21,  1465,     0,  13,   0, UNI_M }   /* combiningmark */,
  {     0,  8780,   923,   6,  28, UNI_SUPPUAB }   /* block=supplementaryprivateuseareab */,
  {     2,  9768,  6481,   4,  12, UNI_HUNG }   /* scx=oldhungarian */,
  {     2,  1417,  9026,  24,   6, UNI_CCC__9 }   /* canonicalcombiningclass=virama */,
  {     1,  9277,  7684,   3,   9, UNI_PAUC }   /* sc=paucinhau */,
  {     1,   184,   951,   2,  17, UNI_VS }   /* isvariationselector */,
  {     0,   184,  9604,   2,   4, UNI_KHMR }   /* iskhmr */,
  {    10,  6576,    26,  11,   1, UNI_XPOSIXALPHA }   /* alphabetic=y */,
  {    11,  7318,  7821,  10,   1, UNI_IN__8 }   /* presentin=8 */,
  {     1,  3097,   567,  18,   2, UNI_DT__NB }   /* decompositiontype=nb */,
  {     2,  7325,  9844,   3,   4, UNI_IN__11 }   /* in=v110 */,
  {     0,  8780,  9320,   6,   5, UNI_INOSAGE }   /* block=osage */,
  {     0,  4643,  1025,  15,   2, -UNI_ECOMP }   /* emojicomponent=no */,
  {     8,  3259,  9255,  18,   5, -UNI_IDSB }   /* idsbinaryoperator=false */,
  {     2,   184,  3341,   2,   8, UNI_DINGBATS }   /* isdingbats */,
  {     0,   184,  8227,   2,   8, UNI_KANAEXTA }   /* iskanaexta */,
  {     8,  8780,  8666,   6,   7, UNI_INTIRHUTA }   /* block=tirhuta */,
  {     1,  8589,  8344,   7,   7, UNI_SC__BENG }   /* script=bengali */,
  {     0,  5032,     1,  14,   1, -UNI_POSIXXDIGIT }   /* asciihexdigit=n */,
  {     6,  1417,  9300,  24,   5, UNI_CCC__7 }   /* canonicalcombiningclass=nukta */,
  {     1, 10298,     0,  10,   0, UNI_POSIXBLANK }   /* posixblank */,
  {     3, 10009, 10069,   3,   3, UNI_DT__SQR }   /* dt=sqr */,
  {    67,  8589,  8888,   7,   6, UNI_HATR }   /* script=hatran */,
  {     0,  2182, 10015,  21,   3, UNI_WB__EB }   /* graphemeclusterbreak=ebg */,
  {     3,  1417,  5765,  24,  13, UNI_CCC__IS }   /* canonicalcombiningclass=iotasubscript */,
  {    11,  5003,     0,  15,   0, UNI_ZANB }   /* zanabazarsquare */,
  {    24,  9277,  8123,   3,   8, UNI_SC__BUGI }   /* sc=buginese */,
  {     2,  9508,    78,   4,   2, UNI_CCC__AR }   /* ccc=ar */,
  {     0,  5432,     0,   3,   0, UNI_ANY }   /* any */,
  {     1,  8589,  9628,   7,   4, UNI_SC__LATN }   /* script=latn */,
  {     0, 10048,  9428,   3,   4, UNI_NV__3_SLASH_80 }   /* nv=3/80 */,
  {     1,  7438,     0,  10,   0, UNI_wb_values_index }   /* wordbreak= */,
  {    10,   184,  6229,   2,   5, UNI_JOINC }   /* isjoinc */,
  {     1,  9488,  8652,   4,   7, UNI_INTAIVIET }   /* blk=taiviet */,
  {     0,  8147,    26,   8,   1, UNI_EXTPICT }   /* extpict=y */,
  {     8, 10048,  9203,   3,   2, UNI_NV__34 }   /* nv=34 */,
  {     0,  9528,  9255,   4,   5, -UNI_CWU }   /* cwu=false */,
  {     1,  6553,    26,  12,   1, UNI_XIDC }   /* xidcontinue=y */,
  {     1,  3836,  6796,  17,  11, UNI_MEDF }   /* scriptextensions=medefaidrin */,
  {    16,  3836,  2409,  17,  10, UNI_GLAG }   /* scriptextensions=glagolitic */,
  {     2,  1114,     0,  26,   0, UNI_cwkcf_values_index }   /* changeswhennfkccasefolded= */,
  {    10,  9508,  9919,   4,   3, UNI_CCC__202 }   /* ccc=202 */,
  {    11,  8589,  9812,   7,   4, UNI_SC__TAML }   /* script=taml */,
  {     5,  9444,  7782,   4,   1, UNI_AGE__3 }   /* age=3 */,
  {     4,   184,  2969,   2,  19, UNI_SUPARROWSC }   /* issupplementalarrowsc */,
  {     2, 10048,  8082,   3,   2, UNI_NV__19 }   /* nv=19 */,
  {     1,  6231,    43,   3,   2, UNI_CJK }   /* incjk */,
  {     0,  5074,     0,  14,   0, UNI_CJKCOMPATFORMS }   /* cjkcompatforms */,
  {     0,  8435,     0,   7,   0, UNI_grbase_values_index }   /* grbase= */,
  {     1,  8509,  1035,   4,  25, UNI_ENCLOSEDCJK }   /* inenclosedcjklettersandmonths */,
  {     3,  9508,  7178,   4,   4, UNI_CCC__6 }   /* ccc=hanr */,
  {     2,  6253,     0,   5,   0, UNI_KHMR }   /* khmer */,
  {     0,  8589,  3241,   7,   4, UNI_SC__GEOR }   /* script=geor */,
  {     8,  9488,  1586,   5,  22, UNI_BYZANTINEMUSIC }   /* blk=byzantinemusicalsymbols */,
  {     1, 10027,  2637,   3,   9, UNI_JG__YEHBARREE }   /* jg=yehbarree */,
  {     2, 10027,  5336,   3,   4, UNI_JG__BETH }   /* jg=beth */,
  {     0,  5986,  9379,  13,   2, UNI_NV__41 }   /* numericvalue=41 */,
  {     0,  7218,  8680,  10,   7, UNI_LB__XX }   /* linebreak=unknown */,
  {     4,  4658,  1025,  15,   2, -UNI_GREXT }   /* graphemeextend=no */,
  {     1,  8876,     0,   6,   0, UNI_GOTH }   /* gothic */,
  {     2,  7410,     0,   8,   0, UNI_ASSIGNED }   /* assigned */,
  {     1,  2912,     0,   9,   0, UNI_SUND }   /* sundanese */,
  {     2,  8780,  8638,   6,   7, UNI_INTAGALOG }   /* block=tagalog */,
  {     0,  7318,  9848,  10,   4, UNI_IN__12 }   /* presentin=v120 */,
  {     1,  1417,  9168,  24,   2, UNI_CCC__27 }   /* canonicalcombiningclass=27 */,
  {     3,   923,     0,  28,   0, UNI_SUPPUAB }   /* supplementaryprivateuseareab */,
  {     2,  9488,  2409,   4,  13, UNI_GLAGOLITICSUP }   /* blk=glagoliticsup */,
  {     5,    21,  6253,   2,   5, UNI_INKHMER }   /* inkhmer */,
  {     0,  5986,  7859,  13,   6, UNI_NV__200000 }   /* numericvalue=200000 */,
  {     0,  4989,     1,   3,  33, UNI_UCAS }   /* isunifiedcanadianaboriginalsyllabics */,
  {     2,  9520,     3,   4,   1, -UNI_CWL }   /* cwl=f */,
  {     4,  9768,     7,   4,  18, UNI_CANS }   /* scx=canadianaboriginal */,
  {     6,  8780,  7657,   6,   9, UNI_INOLDPERMIC }   /* block=oldpermic */,
  {     1,  3581,     0,  17,   0, UNI_UCAS }   /* canadiansyllabics */,
  {     0,  7325, 10123,   3,   3, UNI_IN__9 }   /* in=v90 */,
  {     0,  4791,  4274,   3,  15, UNI_MYANMAREXTA }   /* inmyanmarextendeda */,
  {     2,  1979,    24,  10,   1, UNI_LOWERCASELETTER }   /* category=ll */,
  {     3,  3133,     0,  13,   0, UNI_EMOD }   /* emojimodifier */,
  {    85,  9277,  8421,   3,   7, UNI_ELYM }   /* sc=elymaic */,
  {     0,  8780,  1631,   6,  23, UNI_GEOMETRICSHAPESEXT }   /* block=geometricshapesextended */,
  {     9,  5578,  4305,  14,   5, UNI_SB__XX }   /* sentencebreak=other */,
  {     2,  8688,    80,   4,   8, UNI_ARABICMATH }   /* isarabicmath */,
  {     0, 10030,    18,   3,   1, UNI_JT__R }   /* jt=r */,
  {    33, 10012,    66,   3,   1, UNI_EA__H }   /* ea=h */,
  {     5,  3836,  8604,  18,   6, UNI_SHAW }   /* scriptextensions=shavian */,
  {     2,  9488,  2469,   4,  20, UNI_INNYIAKENGPUACHUEHMONG }   /* blk=nyiakengpuachuehmong */,
  {     0,  6231,    43,   3,  25, UNI_CJKCOMPATIDEOGRAPHS }   /* incjkcompatibilityideographs */,
  {     0,  3836,  2608,  17,   6, UNI_BRAH }   /* scriptextensions=brahmi */,
  {     1, 10048,  9916,   3,   3, UNI_NV__2_SLASH_5 }   /* nv=2/5 */,
  {     0,  9277,  9888,   3,   4, UNI_ZANB }   /* sc=zanb */,
  {     0,  8509,   751,   4,  14, UNI_ENCLOSEDALPHANUM }   /* inenclosedalphanum */,
  {     5, 10033,  5536,   3,  14, UNI_LB__PO }   /* lb=postfixnumeric */,
  {     0,  7739,  9836,   8,   4, UNI_IDS }   /* idstart=true */,
  {     4, 10033,  4538,   3,  15, UNI_LB__CB }   /* lb=contingentbreak */,
  {    18,  9277,  9644,   3,   4, UNI_MEDF }   /* sc=medf */,
  {    18,  9556,   125,   4,   2, UNI_LB__CR }   /* gcb=cr */,
  {     3,  3836,  8611,  18,   6, UNI_SIDD }   /* scriptextensions=siddham */,
  {     3,  6265,     0,  12,   0, UNI_NL }   /* letternumber */,
  {    33,   184,   316,   2,  33, UNI_SUPMATHOPERATORS }   /* issupplementalmathematicaloperators */,
  {     1,  9997,  5130,   3,  14, UNI_BC__EN }   /* bc=europeannumber */,
  {    14,  9488,  7138,   4,  10, UNI_COMPATJAMO }   /* blk=compatjamo */,
  {     0,  8780,  8498,   6,   7, UNI_INMULTANI }   /* block=multani */,
  {     2,  9768,  8666,   4,   4, UNI_TIRH }   /* scx=tirh */,
  {     2,  8780,  1018,   6,   5, UNI_MUSIC }   /* block=music */,
  {     3,  9488,  3115,   4,  13, UNI_DEVANAGARIEXT }   /* blk=devanagariext */,
  {     1,  9277,  6972,   3,  11, UNI_SC__SYLO }   /* sc=sylotinagri */,
  {     0,  3836,  7660,  17,   4, UNI_PERM }   /* scriptextensions=perm */,
  {     0,  8589,  8337,   7,   7, UNI_AVST }   /* script=avestan */,
  {     4,  8589,  8456,   7,   7, UNI_SC__KNDA }   /* script=kannada */,
  {     6,  9768,  9560,   4,   4, UNI_GONG }   /* scx=gong */,
  {     0,  9768,  9660,   4,   4, UNI_MLYM }   /* scx=mlym */,
  {     0,  2280,  6323,   3,   3, UNI_OGAM }   /* isogam */,
  {     0,  8780,  7567,   6,   9, UNI_INKHUDAWADI }   /* block=khudawadi */,
  {     0,  9277,  7168,   3,  10, UNI_DIAK }   /* sc=divesakuru */,
  {     0,  7318, 10099,  10,   3, UNI_IN__5_DOT_1 }   /* presentin=v51 */,
  {     3,  8589,  8561,   7,   7, UNI_OSMA }   /* script=osmanya */,
  {     1,  8780,   951,   6,  18, UNI_INVS }   /* block=variationselectors */,
  {     9,  2665,     0,  19,   0, UNI_COUNTINGROD }   /* countingrodnumerals */,
  {     0,  8688,    97,   3,   9, UNI_XPOSIXALPHA }   /* isalphabetic */,
  {     3,  3374,     0,  11,   0, UNI_wspace_values_index }   /* whitespace= */,
  {     8,  9277,    18,   6,   1, UNI_KHAR }   /* sc=khar */,
  {     2,  6231,   115,   4,  23, UNI_DIACRITICALS }   /* incombiningdiacriticalmarks */,
  {    16,  9640,    36,   4,   1, UNI_LOE }   /* loe=t */,
  {     9,  1591,   383,   3,  31, UNI_EGYPTIANHIEROGLYPHFORMATCONTROLS }   /* inegyptianhieroglyphformatcontrols */,
  {    20,  9488,  2140,   4,  18, UNI_CYRILLICSUP }   /* blk=cyrillicsupplement */,
  {     2,  8780,  2666,   7,  10, UNI_COUNTINGROD }   /* block=countingrod */,
  {     5,  8589,  8315,   7,   8, UNI_UGAR }   /* script=ugaritic */,
  {     0,  5986,  8738,  13,   6, UNI_NV__600000 }   /* numericvalue=600000 */,
  {    14,  1537,  2555,  24,  14, UNI_INPC__BOTTOMANDRIGHT }   /* indicpositionalcategory=bottomandright */,
  {    18,  8780,  7576,   6,   9, UNI_LATINEXTB }   /* block=latinextb */,
  {     1, 10296,   467,   7,   5, UNI_POSIXPUNCT }   /* isposixpunct */,
  {     2,  9020,  9255,   6,   5, -UNI_XPOSIXUPPER }   /* upper=false */,
  {     1,  4049,     0,  11,   0, UNI_GEORGIANEXT }   /* georgianext */,
  {     7,  3025,     0,   8,   0, UNI_CHER }   /* cherokee */,
  {     0,  8589,  9592,   7,   4, UNI_HMNP }   /* script=hmnp */,
  {     4, 10048,  7987,   3,   8, UNI_NV__5_SLASH_8 }   /* nv=6.25e-01 */,
  {     0, 10033,  1140,   3,  26, UNI_LB__CJ }   /* lb=conditionaljapanesestarter */,
  {     0,  6241,  6708,  12,  11, UNI_JT__C }   /* joiningtype=joincausing */,
  {     0,  2122,     0,   7,   0, UNI_RADICAL }   /* radical */,
  {     0,  3836,  3025,  17,   4, UNI_CHER }   /* scriptextensions=cher */,
  {     0, 10027,  5620,   3,  14, UNI_JG__HAMZAONHEHGOAL }   /* jg=tehmarbutagoal */,
  {     0,  7068,     0,  10,   0, UNI_ASCII }   /* basiclatin */,
  {     0,  3836,  9335,  17,   5, UNI_TAKR }   /* scriptextensions=takri */,
  {     9,   328,     0,  21,   0, UNI_MATHOPERATORS }   /* mathematicaloperators */,
  {     0,    21,  1218,   2,   8, UNI_INKATAKANA }   /* inkatakana */,
  {     2,   184,  6086,   3,  11, UNI_CHESSSYMBOLS }   /* ischesssymbols */,
  {    37, 10012,     0,   3,   0, UNI_ea_values_index }   /* ea= */,
  {     1,  5324,  6387,   4,  10, UNI_INMASARAMGONDI }   /* inmasaramgondi */,
  {     0,  8589,  7684,   7,   4, UNI_PAUC }   /* script=pauc */,
  {    16,  2140,     0,  11,   0, UNI_CYRILLICSUP }   /* cyrillicsup */,
  {     1,  5986, 10138,  13,   2, UNI_NV__38 }   /* numericvalue=38 */,
  {     3,  9488,  4097,   4,  16, UNI_HIGHPUSURROGATES }   /* blk=highpusurrogates */,
  {     1,  9488,  8124,   5,   7, UNI_INBUGINESE }   /* blk=buginese */,
  {     5,   184,   382,   2,   4, UNI_EGYP }   /* isegyp */,
  {     2,  8780,  3683,   6,  11, UNI_ETHIOPICEXT }   /* block=ethiopicext */,
  {    43,  1552,  5498,  10,  10, UNI_MC }   /* category=spacingmark */,
  {     4, 10048,  8750,   3,   3, UNI_NV__800 }   /* nv=800 */,
  {     1,  3529,     3,  18,   1, -UNI_VS }   /* variationselector=f */,
  {    12,  9768,  9002,   4,   4, UNI_TELU }   /* scx=telu */,
  {     0,  7028,     2,   3,   1, UNI_YI }   /* isyi */,
  {     0,  9528,  1025,   4,   2, -UNI_CWU }   /* cwu=no */,
  {     1,  4643,     1,  15,   1, -UNI_ECOMP }   /* emojicomponent=n */,
  {     0, 10009,  1294,   3,   5, UNI_DT__SUP }   /* dt=super */,
  {     1,  9524,    36,   4,   1, UNI_CWT }   /* cwt=t */,
  {    27,  8589,  3937,   7,   4, UNI_SC__BOPO }   /* script=bopo */,
  {     1,  7088,  5130,  10,  14, UNI_BC__EN }   /* bidiclass=europeannumber */,
  {     0, 10291,  5718,   5,   5, UNI_POSIXALNUM }   /* posixalnum */,
  {    14,  8858,  1025,   6,   2, -UNI_ECOMP }   /* ecomp=no */,
  {    25,  8780,  1879,   7,  18, UNI_CJKCOMPATIDEOGRAPHS }   /* block=cjkcompatideographs */,
  {     3,  8780,   510,   7,  19, UNI_CJK }   /* block=cjkunifiedideographs */,
  {     1,  4001,     0,   7,   0, UNI_CPRT }   /* cypriot */,
  {     1,  5986,  9055,  13,   3, UNI_NV__1_SLASH_3 }   /* numericvalue=1/3 */,
  {     9,  9997,  6493,   3,  12, UNI_BC__ON }   /* bc=otherneutral */,
  {    15,  9508,  6642,   4,  11, UNI_CCC__DB }   /* ccc=doublebelow */,
  {     6,  8780,  9684,   6,   4, UNI_INNEWA }   /* block=newa */,
  {     0, 10033,    21,   3,   2, UNI_LB__IN }   /* lb=in */,
  {     2,  1537,  2549,  24,   3, UNI_INPC__TOP }   /* indicpositionalcategory=top */,
  {    28,  4017,     0,  16,   0, UNI_PF }   /* finalpunctuation */,
  {     0,  8996,    26,   6,   1, UNI_STERM }   /* sterm=y */,
  {     3,  8780,  1060,   6,  27, UNI_OCR }   /* block=opticalcharacterrecognition */,
  {     5, 10333,  8611,   3,   3, UNI_SIDD }   /* issidd */,
  {     0,  2140,     0,   8,   0, UNI_CYRL }   /* cyrillic */,
  {     0, 10048,  7782,   3,   1, UNI_NV__3 }   /* nv=3 */,
  {     4,  9997,  3773,   3,   3, UNI_BC__RLI }   /* bc=rli */,
  {     2,  3836,  3785,  17,   4, UNI_MANI }   /* scriptextensions=mani */,
  {     1, 10126,     0,   3,   1, UNI_VO__U }   /* vo=u */,
  {     2,   184,  5497,   2,  11, UNI_MC }   /* isspacingmark */,
  {     2,  2779,    26,  19,   1, UNI_IDST }   /* idstrinaryoperator=y */,
  {     3,   184,  2855,   2,  19, UNI_MONGOLIANSUP }   /* ismongoliansupplement */,
  {     2, 10033,  8236,   4,   7, UNI_LB__LF }   /* lb=linefeed */,
  {    38,  1768,     0,  22,   0, UNI_cwcf_values_index }   /* changeswhencasefolded= */,
  {    18, 10333,    47,   3,   1, UNI_SM }   /* issm */,
  {     0,   908,     0,  14,   0, UNI_PUA }   /* privateusearea */,
  {     1,   184,   510,   3,  29, UNI_CJKEXTA }   /* iscjkunifiedideographsextensiona */,
  {     1,  8435,     0,   6,   0, UNI_GRBASE }   /* grbase */,
  {     0, 10048,  9208,   3,   2, UNI_NV__35 }   /* nv=35 */,
  {     0,  7218,   495,  10,   2, UNI_LB__NU }   /* linebreak=nu */,
  {     0, 10048,  8744,   3,   6, UNI_NV__700000 }   /* nv=700000 */,
  {    17,   184,  9628,   2,   4, UNI_LATN }   /* islatn */,
  {     0,  8589,  9568,   7,   4, UNI_SC__GREK }   /* script=grek */,
  {     0,  8575,     3,   7,   1, -UNI_PATSYN }   /* patsyn=f */,
  {     1,  9508,  9191,   5,   4, UNI_CCC__32 }   /* ccc=ccc32 */,
  {     0, 10333,  8618,   3,   3, UNI_SOYO }   /* issoyo */,
  {     8,  7576,     0,   9,   0, UNI_LATINEXTB }   /* latinextb */,
  {    13,  3836,  8219,  17,   4, UNI_JAVA }   /* scriptextensions=java */,
  {     3,  3836,  9476,  17,   4, UNI_AVST }   /* scriptextensions=avst */,
  {     2,  9640,     0,   3,   0, UNI_LOE }   /* loe */,
  {     1,  1966,  6463,  22,   6, UNI_LB__ZWJ }   /* indicsyllabiccategory=joiner */,
  {     0,  6805,   254,   6,  29, UNI_MISCMATHSYMBOLSA }   /* inmiscellaneousmathematicalsymbolsa */,
  {     0,  8780,  7058,   6,  10, UNI_ARABICEXTA }   /* block=arabicexta */,
  {     0,   184,  9325,   2,   5, UNI_RUNR }   /* isrunic */,
  {     7, 10024,  9225,   3,   5, UNI_XPOSIXCNTRL }   /* gc=cntrl */,
  {     8,  9596,   911,   4,   1, UNI_GCB__V }   /* hst=v */,
  {     0,  9277,  4385,   3,   6, UNI_TANG }   /* sc=tangut */,
  {    64,  8780,  1911,   6,  11, UNI_NUMBERFORMS }   /* block=numberforms */,
  {    38,  5986,  8720,  13,   2, UNI_NV__40 }   /* numericvalue=40 */,
  {     1,  8780,     0,   6,  34, UNI_UCAS }   /* block=unifiedcanadianaboriginalsyllabics */,
  {     1,   184,  7585,   2,   9, UNI_LATINEXTC }   /* islatinextc */,
  {     1,  3836,  9572,  17,   4, UNI_GUJR }   /* scriptextensions=gujr */,
  {     1,  8589,  2245,   7,  11, UNI_MTEI }   /* script=meeteimayek */,
  {    12,  9488,  3649,   4,  17, UNI_CYRILLICEXTB }   /* blk=cyrillicextendedb */,
  {     4,  7438,  8144,  10,   3, UNI_WB__EB }   /* wordbreak=gaz */,
  {    10,  7155,  5038,   3,   7, UNI_XPOSIXXDIGIT }   /* ishexdigit */,
  {     0,  7540,     1,   9,   1, -UNI_EXT }   /* extender=n */,
  {     0,    21,  7567,   2,   9, UNI_INKHUDAWADI }   /* inkhudawadi */,
  {     9,  9488,  1219,   5,   4, UNI_INBATAK }   /* blk=batak */,
  {     2,  7088,   426,  10,   2, UNI_BC__ES }   /* bidiclass=es */,
  {     2,  3836,  9676,  17,   4, UNI_NARB }   /* scriptextensions=narb */,
  {     2,  1417,  8002,  24,   2, UNI_CCC__26 }   /* canonicalcombiningclass=26 */,
  {     4, 10063,     1,   3,   1, -UNI_SD }   /* sd=n */,
  {     0,  4033,  1587,  16,   1, UNI_Z }   /* generalcategory=z */,
  {     6,    18,     0,   2,   0, UNI_RI }   /* ri */,
  {     0,  6554,    26,  11,   1, UNI_IDC }   /* idcontinue=y */,
  {     6,  6829,     0,  11,   0, UNI_MYANMAREXTB }   /* myanmarextb */,
  {     1,  7318,  9991,  10,   3, UNI_IN__9 }   /* presentin=9.0 */,
  {     0,  9277,  9330,   3,   5, UNI_SC__TALE }   /* sc=taile */,
  {     0,  9480,     0,   4,   0, UNI_BATK }   /* batk */,
  {    31,  1979,     0,  11,   0, UNI_LO }   /* category=lo */,
  {     2,  4116,  7559,   3,   8, UNI_QAAI }   /* isinherited */,
  {     0,  1417,  7778,  24,   2, UNI_CCC__21 }   /* canonicalcombiningclass=21 */,
  {     2,  8780,  6133,   6,  12, UNI_ETHIOPICEXTA }   /* block=ethiopicexta */,
  {     5,  7228, 10135,  10,   3, UNI_XPOSIXLOWER }   /* lowercase=yes */,
  {     0,  9277,  7308,   3,  10, UNI_PHNX }   /* sc=phoenician */,
  {     2,  9720,     0,   4,   0, UNI_PHLP }   /* phlp */,
  {     0,  8589,  9668,   7,   4, UNI_MTEI }   /* script=mtei */,
  {     0,  9768,  8876,   4,   6, UNI_GOTH }   /* scx=gothic */,
  {     0,  2224,  2913,   3,   8, UNI_INSUNDANESE }   /* insundanese */,
  {    41,  8780,  1344,   6,  25, UNI_SYMBOLSFORLEGACYCOMPUTING }   /* block=symbolsforlegacycomputing */,
  {     0,   184,  9748,   2,   4, UNI_RJNG }   /* isrjng */,
  {     1, 10048,  8744,   3,   2, UNI_NV__70 }   /* nv=70 */,
  {     0,  5843,     0,   9,   0, UNI_MLYM }   /* malayalam */,
  {     7,  9275,  4417,   5,  16, UNI_INSC__VOWELINDEPENDENT }   /* insc=vowelindependent */,
  {     9,  9488,  8456,   4,   7, UNI_INKANNADA }   /* blk=kannada */,
  {     8, 10129,    26,   3,   1, UNI_VS }   /* vs=y */,
  {     1,  8780,  4973,   6,   8, UNI_VEDICEXT }   /* block=vedicext */,
  {     1, 10182,   435,   6,   5, UNI__PERL_NCHAR }   /* _perl_nchar */,
  {     2,  4791,  2247,   4,  19, UNI_MEETEIMAYEKEXT }   /* inmeeteimayekextensions */,
  {    28,   184,  1585,   2,  14, UNI_BYZANTINEMUSIC }   /* isbyzantinemusic */,
  {     3,  9270,   909,   3,   9, UNI_PUA }   /* inprivateuse */,
  {     1,  2182,  8144,  21,   3, UNI_WB__EB }   /* graphemeclusterbreak=gaz */,
  {     0,  9290, 10135,   5,   3, UNI_MATH }   /* math=yes */,
  {     0,  9277,  9310,   3,   5, UNI_OGAM }   /* sc=ogham */,
  {     0,  8449,     0,   6,   0, UNI_HYPHEN }   /* hyphen */,
  {    16,    11,     0,   2,   0, UNI_DI }   /* di */,
  {     0,  8688,  8338,   3,   6, UNI_AVST }   /* isavestan */,
  {     2, 10033,  7486,   3,   9, UNI_LB__AI }   /* lb=ambiguous */,
  {     0,  1828,     3,   6,   1, -UNI_CASED }   /* cased=f */,
  {     0, 10288,  9225,   8,   5, UNI_XPOSIXCNTRL }   /* isxposixcntrl */,
  {     7,  3169,     0,   4,   0, UNI_ETHI }   /* ethi */,
  {    24,  1552,  5713,   9,  13, UNI_XPOSIXDIGIT }   /* category=decimalnumber */,
  {     0,  8780,    78,   6,   6, UNI_INARABIC }   /* block=arabic */,
  {     1,  8780,   382,   6,  32, UNI_EGYPTIANHIEROGLYPHFORMATCONTROLS }   /* block=egyptianhieroglyphformatcontrols */,
  {     2,  1417,  9171,  25,   4, UNI_CCC__28 }   /* canonicalcombiningclass=ccc28 */,
  {     4,  8589,  7428,   7,   4, UNI_WARA }   /* script=wara */,
  {    50,  1768, 10135,  22,   3, UNI_CWCF }   /* changeswhencasefolded=yes */,
  {     0,  7438,  3385,  10,  17, UNI_RI }   /* wordbreak=regionalindicator */,
  {     0,  9536,  9255,   4,   5, -UNI_DEP }   /* dep=false */,
  {    32,  7218,  3379,  10,   5, UNI_LB__SP }   /* linebreak=space */,
  {     3,  1552,  5438,   9,  14, UNI_SK }   /* category=modifiersymbol */,
  {     5,  5791, 10045,  13,   3, UNI_JG__MIM }   /* joininggroup=mim */,
  {     2,    42,     0,  36,   0, UNI_CJKCOMPATIDEOGRAPHSSUP }   /* cjkcompatibilityideographssupplement */,
  {     7,  8780,  8596,   6,   7, UNI_SC__SHRD }   /* block=sharada */,
  {     3,  9488,  8414,   4,   7, UNI_INELBASAN }   /* blk=elbasan */,
  {     9,  9488,  5778,   4,  13, UNI_IPAEXT }   /* blk=ipaextensions */,
  {    19,  7288,     0,  10,   0, UNI_SOGO }   /* oldsogdian */,
  {     1, 10296,    83,   3,   2, UNI_PCM }   /* ispcm */,
  {     0,  6231,  6086,   3,  11, UNI_CHESSSYMBOLS }   /* inchesssymbols */,
  {     2,  3632,     0,  17,   0, UNI_CYRILLICEXTA }   /* cyrillicextendeda */,
  {     0,  8780,  9664,   6,   3, UNI_INMRO }   /* block=mro */,
  {     4, 10009,  9552,   3,   4, UNI_DT__FONT }   /* dt=font */,
  {     3,  5986,  8744,  13,   6, UNI_NV__700000 }   /* numericvalue=700000 */,
  {     6,  7438,  8323,  10,   7, UNI_WB__LE }   /* wordbreak=aletter */,
  {     0,  8930,  9836,   6,   4, UNI_XPOSIXLOWER }   /* lower=true */,
  {     4,  1417,  3015,  24,   5, UNI_CCC__A }   /* canonicalcombiningclass=above */,
  {     2,  9488,  8187,   4,   8, UNI_INHIRAGANA }   /* blk=hiragana */,
  {     0,  8780,  1677,   6,   9, UNI_LATINEXTE }   /* block=latinexte */,
  {     1,  5324,  8493,   4,   5, UNI_INMARCHEN }   /* inmarchen */,
  {     0,  9508,  7765,   4,   2, UNI_CCC__25 }   /* ccc=25 */,
  {    10,  9245,     0,   5,   0, UNI_DOGR }   /* dogra */,
  {    16,   184,  4658,   2,  14, UNI_GREXT }   /* isgraphemeextend */,
  {     0,  1966,  4823,  22,  15, UNI_INSC__MODIFYINGLETTER }   /* indicsyllabiccategory=modifyingletter */,
  {     0,  2182,    34,  21,   6, UNI_GCB__EX }   /* graphemeclusterbreak=extend */,
  {     0,  9508,  9196,   5,   4, UNI_CCC__33 }   /* ccc=ccc33 */,
  {     0,  5986, 10140,  13,   2, UNI_NV__39 }   /* numericvalue=39 */,
  {     4,  8780,   720,   7,  15, UNI_CUNEIFORMNUMBERS }   /* block=cuneiformnumbers */,
  {    14,  8780,  1013,   6,   5, UNI_INGREEK }   /* block=greek */,
  {     0,  4129,     0,   9,   0, UNI_LATIN1 }   /* latin1sup */,
  {     0, 10048,  7995,   3,   8, UNI_NV__1_SLASH_16 }   /* nv=6.25e-02 */,
  {     6,  9070,    26,   5,   1, UNI_POSIXXDIGIT }   /* ahex=y */,
  {     1,  8589,  2684,   7,  19, UNI_EGYP }   /* script=egyptianhieroglyphs */,
  {     0,  7218,  6178,  10,   2, UNI_LB__ZW }   /* linebreak=zw */,
  {     0,   184,  1677,   2,  23, UNI_LATINEXTADDITIONAL }   /* islatinextendedadditional */,
  {     0,  8589,  9065,   7,   5, UNI_SC__ADLM }   /* script=adlam */,
  {    32,  6231,   219,   4,  31, UNI_DIACRITICALSEXT }   /* incombiningdiacriticalmarksextended */,
  {     4,  8589,  4793,   7,  15, UNI_MERC }   /* script=meroiticcursive */,
  {     0,  3836,  9700,  17,   4, UNI_OLCK }   /* scriptextensions=olck */,
  {     0,  1966,  4417,  22,   5, UNI_INSC__VOWEL }   /* indicsyllabiccategory=vowel */,
  {     1, 10048,  5648,   3,  13, UNI_NV__1000000000000 }   /* nv=1000000000000 */,
  {     0, 10024,  4898,   3,  15, UNI_PS }   /* gc=openpunctuation */,
  {     1,  2218,  2470,   3,  19, UNI_INNYIAKENGPUACHUEHMONG }   /* innyiakengpuachuehmong */,
  {     0,   184,  7068,   2,  10, UNI_ASCII }   /* isbasiclatin */,
  {     2,  9488,  8131,   4,   8, UNI_INDUPLOYAN }   /* blk=duployan */,
  {     0,  5986,  7987,  13,   8, UNI_NV__5_SLASH_8 }   /* numericvalue=6.25e-01 */,
  {     0,  4989,  1368,   3,   3, UNI_UGAR }   /* isugar */,
  {    12,  1417,  8817,  25,   5, UNI_CCC__129 }   /* canonicalcombiningclass=ccc129 */,
  {     0,  9756,     0,   4,   0, UNI_RUNR }   /* runr */,
  {     1,  8780,  8456,   6,   7, UNI_INKANNADA }   /* block=kannada */,
  {     8,  8780,   838,   6,  29, UNI_MISCARROWS }   /* block=miscellaneoussymbolsandarrows */,
  {     3,  5791,  5368,  13,  14, UNI_JG__MANICHAEANKAPH }   /* joininggroup=manichaeankaph */,
  {     2,   184,  3421,   2,  18, UNI_RUMI }   /* isruminumeralsymbols */,
  {     0, 10296,     7,   3,   1, UNI_PC }   /* ispc */,
  {     5, 10048,  8010,   3,   2, UNI_NV__36 }   /* nv=36 */,
  {    41,   598,     0,   2,   0, UNI_XPOSIXCNTRL }   /* cc */,
  {     1,  5830,     0,  13,   0, UNI_LOWSURROGATES }   /* lowsurrogates */,
  {     1,  9488,  6972,   4,  11, UNI_INSYLOTINAGRI }   /* blk=sylotinagri */,
  {     2,  4688,  1284,  15,   9, UNI_IDENTIFIERTYPE__EXCLUSION }   /* identifiertype=exclusion */,
  {    32,  8852,     3,   6,   1, -UNI_CWKCF }   /* cwkcf=f */,
  {     0,  9508,  7922,   4,   2, UNI_CCC__24 }   /* ccc=24 */,
  {     1,  6397,     0,  12,   0, UNI_MATHALPHANUM }   /* mathalphanum */,
  {     1,  8780,  8888,   6,   6, UNI_INHATRAN }   /* block=hatran */,
  {     1, 10048,  7765,   3,   1, UNI_NV__2 }   /* nv=2 */,
  {     4,  5986,  9361,  13,   3, UNI_NV__1_SLASH_2 }   /* numericvalue=1/2 */,
  {     0,  1966,  4305,  22,   5, UNI_INSC__OTHER }   /* indicsyllabiccategory=other */,
  {     0,  4033,    74,  16,   2, UNI_ME }   /* generalcategory=me */,
  {     2,  5986,  7995,  13,   8, UNI_NV__1_SLASH_16 }   /* numericvalue=6.25e-02 */,
  {     2,  6231,  2141,   3,  10, UNI_CYRILLICSUP }   /* incyrillicsup */,
  {     8,  8996,     3,   6,   1, -UNI_STERM }   /* sterm=f */,
  {     0,   184,  9032,   2,   6, UNI_WCHO }   /* iswancho */,
  {     8,  3937,     0,  16,   0, UNI_BOPOMOFOEXT }   /* bopomofoextended */,
  {    10, 10048,  8066,   3,   2, UNI_NV__28 }   /* nv=28 */,
  {     8,  2779,     3,  19,   1, -UNI_IDST }   /* idstrinaryoperator=f */,
  {     6, 10009,  1417,   3,   9, UNI_DT__CAN }   /* dt=canonical */,
  {     1,  3836,  9748,  17,   4, UNI_RJNG }   /* scriptextensions=rjng */,
  {    22,  3836,  7675,  17,   9, UNI_PALM }   /* scriptextensions=palmyrene */,
  {    14,  4643, 10135,  15,   3, UNI_ECOMP }   /* emojicomponent=yes */,
  {     8, 10033,   125,   3,   2, UNI_LB__CR }   /* lb=cr */,
  {     0,  8780,  8187,   6,   8, UNI_INHIRAGANA }   /* block=hiragana */,
  {    12,  9500,     0,   4,   0, UNI_CAKM }   /* cakm */,
  {     0,  4542,  4051,   4,  14, UNI_GEORGIANEXT }   /* ingeorgianextended */,
  {     0,  9235,     1,   5,   1, -UNI_CWCM }   /* cwcm=n */,
  {     0,  8780,  4569,   7,  14, UNI_CURRENCYSYMBOLS }   /* block=currencysymbols */,
  {     9,  3836,  4273,  17,   7, UNI_MYMR }   /* scriptextensions=myanmar */,
  {     1,  3836,  3115,  17,  10, UNI_DEVA }   /* scriptextensions=devanagari */,
  {     0,  8589,  8786,   7,   6, UNI_CARI }   /* script=carian */,
  {     8,  9277,  9680,   3,   4, UNI_NBAT }   /* sc=nbat */,
  {     0,  1417,  7950,  24,   1, UNI_CCC__9 }   /* canonicalcombiningclass=9 */,
  {     1,  9277,  9900,   3,   4, UNI_ZZZZ }   /* sc=zzzz */,
  {     0,  9680,     0,   4,   0, UNI_NBAT }   /* nbat */,
  {    11,  3836,  9504,  17,   4, UNI_CANS }   /* scriptextensions=cans */,
  {     0,  1417,  7765,  24,   2, UNI_CCC__25 }   /* canonicalcombiningclass=25 */,
  {     0,  2032,    36,  22,   1, UNI__PERL_NCHAR }   /* noncharactercodepoint=t */,
  {    33, 10290,   467,   6,   5, UNI_XPOSIXPUNCT }   /* xposixpunct */,
  {     0,  2076,     0,  15,   0, UNI_TRANSPORTANDMAP }   /* transportandmap */,
  {    34,  9508,  5649,   4,   1, UNI_CCC__0 }   /* ccc=0 */,
  {    18,  9260,  9255,   5,   5, -UNI_IDSB }   /* idsb=false */,
  {     4,  5986,  7781,  13,   2, UNI_NV__43 }   /* numericvalue=43 */,
  {     1,   184,  9305,   2,   5, UNI_NSHU }   /* isnushu */,
  {     3,  5986,  7779,  13,   8, UNI_NV__1_SLASH_7 }   /* numericvalue=1.43e-01 */,
  {     0, 10132,   495,   3,   2, UNI_WB__NU }   /* wb=nu */,
  {     0, 10033,  5746,   3,   5, UNI_EBASE }   /* lb=ebase */,
  {     1,  1166,    26,  26,   1, UNI_DI }   /* defaultignorablecodepoint=y */,
  {     1,  9768,  1537,   5,   3, UNI_SIND }   /* scx=sind */,
  {     0,  7218,  4842,  10,   2, UNI_LB__QU }   /* linebreak=qu */,
  {     0,  3921,     0,   9,   0, UNI_ARABICSUP }   /* arabicsup */,
  {     1,  7088,   102,  10,   2, UNI_BC__ET }   /* bidiclass=et */,
  {     6,  8768,     1,   6,   1, -UNI_BIDIC }   /* bidic=n */,
  {     1,  1417,  2449,  24,   4, UNI_CCC__L }   /* canonicalcombiningclass=left */,
  {     0,   184,  7576,   2,   9, UNI_LATINEXTB }   /* islatinextb */,
  {     1,  9488,  3666,   4,  17, UNI_CYRILLICEXTC }   /* blk=cyrillicextendedc */,
  {     1,  7076,  2609,   3,   5, UNI_INBRAHMI }   /* inbrahmi */,
  {     0,  8449,     1,   7,   1, -UNI_HYPHEN }   /* hyphen=n */,
  {    86,  9556,  1087,   4,   7, UNI_GCB__PP }   /* gcb=prepend */,
  {     0,  8997,     1,   5,   1, -UNI_TERM }   /* term=n */,
  {     1,  9265,     0,   5,   0, UNI_idst_values_index }   /* idst= */,
  {     0,  4033,  2061,  16,  14, UNI_LM }   /* generalcategory=modifierletter */,
  {     0,  9488,  2245,   4,  14, UNI_MEETEIMAYEKEXT }   /* blk=meeteimayekext */,
  {     0,  8589,  8561,   7,   4, UNI_OSMA }   /* script=osma */,
  {     6,  3836,  2485,  17,   4, UNI_MONG }   /* scriptextensions=mong */,
  {     0,  2182,   262,  21,   2, UNI_GCB__SM }   /* graphemeclusterbreak=sm */,
  {    10,  8589,  3598,   7,  17, UNI_AGHB }   /* script=caucasianalbanian */,
  {   100,  3836,  2288,  18,   3, UNI_SINH }   /* scriptextensions=sinh */,
  {    14,  9768,  9880,   4,   4, UNI_YI }   /* scx=yiii */,
  {     1, 10027, 10000,   3,   3, UNI_JG__BEH }   /* jg=beh */,
  {     2,  9488,  4049,   4,  16, UNI_GEORGIANEXT }   /* blk=georgianextended */,
  {     1,  5037,  1025,   9,   2, -UNI_XPOSIXXDIGIT }   /* hexdigit=no */,
  {     0,  7684,     0,   9,   0, UNI_PAUC }   /* paucinhau */,
  {     2,  9070,  9836,   5,   4, UNI_POSIXXDIGIT }   /* ahex=true */,
  {     0,  8589,  8187,   7,   4, UNI_SC__HIRA }   /* script=hira */,
  {    16,  9768,  9628,   4,   4, UNI_LATN }   /* scx=latn */,
  {     0,  1417,  1755,  24,   2, UNI_CCC__DB }   /* canonicalcombiningclass=db */,
  {     6, 10048,  1249,   3,   3, UNI_NV__NAN }   /* nv=nan */,
  {    32,  2061,     0,   4,   0, UNI_MODI }   /* modi */,
  {     2,  9524,  9255,   4,   5, -UNI_CWT }   /* cwt=false */,
  {     5, 10288,  5040,   8,   5, UNI_XPOSIXDIGIT }   /* isxposixdigit */,
  {     5,   184,  4598,   2,  15, UNI_DIACRITICALSEXT }   /* isdiacriticalsext */,
  {     0,  9346,  9255,   4,   5, -UNI_IDC }   /* idc=false */,
  {     0,  6181,     0,  12,   0, UNI_GONG }   /* gunjalagondi */,
  {     4,  6928,  9836,  11,   4, UNI_SD }   /* softdotted=true */,
  {     0,    21,  1673,   2,   4, UNI_JAMO }   /* injamo */,
  {     0,  8762,     3,   6,   1, -UNI_XPOSIXALPHA }   /* alpha=f */,
  {     3,  1700,     0,  23,   0, UNI_SHORTHANDFORMATCONTROLS }   /* shorthandformatcontrols */,
  {     5,  8589,  9712,   7,   4, UNI_OSGE }   /* script=osge */,
  {    98,  1417,  9940,  24,   3, UNI_CCC__A }   /* canonicalcombiningclass=230 */,
  {     1,  5791,   756,  13,   3, UNI_JG__DAL }   /* joininggroup=dal */,
  {     4,   184,   122,   2,   9, UNI_DIA }   /* isdiacritic */,
  {     0,  7218,  5585,  10,   2, UNI_EBASE }   /* linebreak=eb */,
  {     0, 10291,    96,   5,   5, UNI_POSIXALPHA }   /* posixalpha */,
  {     1, 10024,  1287,   3,   2, UNI_UPPERCASELETTER }   /* gc=lu */,
  {    41,  9235,  1025,   5,   2, -UNI_CWCM }   /* cwcm=no */,
  {     2,  7408,     0,  10,   0, UNI_CN }   /* unassigned */,
  {    18,  9262,     0,   3,   0, UNI_sb_values_index }   /* sb= */,
  {     0,  3836,  9797,  18,   3, UNI_SYRC }   /* scriptextensions=syrc */,
  {     2,  7155,  1655,   3,   5, UNI_HANG }   /* ishangul */,
  {     1,   382,     0,  32,   0, UNI_EGYPTIANHIEROGLYPHFORMATCONTROLS }   /* egyptianhieroglyphformatcontrols */,
  {     0,  5746,     3,   6,   1, -UNI_EBASE }   /* ebase=f */,
  {     1,  3385, 10135,  18,   3, UNI_RI }   /* regionalindicator=yes */,
  {     7,  9240,  9836,   5,   4, UNI_DASH }   /* dash=true */,
  {     1,  7218,     0,  10,   0, UNI_lb_values_index }   /* linebreak= */,
  {     4,  1417,  9176,  25,   4, UNI_CCC__29 }   /* canonicalcombiningclass=ccc29 */,
  {     1, 10288,  6554,   3,   3, UNI_XIDC }   /* isxidc */,
  {     0,  3901,  8173,   4,   6, UNI_INGUJARATI }   /* ingujarati */,
  {     1,  3649,     0,  17,   0, UNI_CYRILLICEXTB }   /* cyrillicextendedb */,
  {     0,  9277,  7684,   3,   4, UNI_PAUC }   /* sc=pauc */,
  {     1,  1417,  7978,  24,   2, UNI_CCC__16 }   /* canonicalcombiningclass=16 */,
  {    11,  5214,     0,   6,   0, UNI_KANGXI }   /* kangxi */,
  {     0,  5578,   400,  14,   6, UNI_SB__FO }   /* sentencebreak=format */,
  {    52,  9277,  2245,   3,  11, UNI_MTEI }   /* sc=meeteimayek */,
  {     1,  8780,  9315,   6,   5, UNI_INORIYA }   /* block=oriya */,
  {     0,  2218,    16,   3,   1, UNI_NB }   /* innb */,
  {     0,  9277,  3241,   3,   4, UNI_SC__GEOR }   /* sc=geor */,
  {     2,  1768,     0,  21,   0, UNI_CWCF }   /* changeswhencasefolded */,
  {     2,  1856,    36,  22,   1, UNI_CWU }   /* changeswhenuppercased=t */,
  {     8,  8589,  8942,   7,   6, UNI_LYDI }   /* script=lydian */,
  {    13,  9488,  7368,   4,  10, UNI_SMALLFORMS }   /* blk=smallforms */,
  {     0,  8930,     3,   6,   1, -UNI_XPOSIXLOWER }   /* lower=f */,
  {    20,  9488,  3600,   4,   4, UNI_UCAS }   /* blk=ucas */,
  {     0,  4033,  6851,  16,  11, UNI_LO }   /* generalcategory=otherletter */,
  {    16,  8780,  7594,   6,   9, UNI_LATINEXTD }   /* block=latinextd */,
  {     1,  7088,  3187,  10,  18, UNI_BC__ET }   /* bidiclass=europeanterminator */,
  {    18,  7318,  9982,  10,   3, UNI_IN__6_DOT_3 }   /* presentin=6.3 */,
  {     2,  9508,  8002,   4,   2, UNI_CCC__26 }   /* ccc=26 */,
  {     1,  8780,  3937,   6,   8, UNI_INBOPOMOFO }   /* block=bopomofo */,
  {     0,  9508,  9181,   5,   4, UNI_CCC__30 }   /* ccc=ccc30 */,
  {     0,  5452,    26,  14,   1, UNI_NFCQC__Y }   /* nfcquickcheck=y */,
  {     0,  1867,     0,   5,   0, UNI_XPOSIXUPPER }   /* upper */,
  {     1, 10033,  3379,   3,   5, UNI_LB__SP }   /* lb=space */,
  {     1, 10009,  6421,   3,  12, UNI_DT__NONCANON }   /* dt=noncanonical */,
  {     1,  9488,     0,   4,  34, UNI_UCAS }   /* blk=unifiedcanadianaboriginalsyllabics */,
  {     0, 10048,  8003,   3,   8, UNI_NV__1_SLASH_160 }   /* nv=6.25e-03 */,
  {     0,  5116,    26,  14,   1, UNI_EMOD }   /* emojimodifier=y */,
  {     0,  8780,   478,   6,  31, UNI_MATHALPHANUM }   /* block=mathematicalalphanumericsymbols */,
  {     0, 10333,  8618,   3,   6, UNI_SOYO }   /* issoyombo */,
  {     6,  9488,  8666,   4,   7, UNI_INTIRHUTA }   /* blk=tirhuta */,
  {     0,  8996,  9255,   6,   5, -UNI_STERM }   /* sterm=false */,
  {     0,  8780,  4002,   7,  15, UNI_CYPRIOTSYLLABARY }   /* block=cypriotsyllabary */,
  {     1, 10290,  7438,   6,   4, UNI_XPOSIXWORD }   /* xposixword */,
  {     1,  1585,     0,  23,   0, UNI_BYZANTINEMUSIC }   /* byzantinemusicalsymbols */,
  {     0,  4113,   952,   3,  17, UNI_INVS }   /* invariationselectors */,
  {     0,  2280,  9321,   3,   4, UNI_OSGE }   /* isosage */,
  {     6,  9672,     0,   4,   0, UNI_MYMR }   /* mymr */,
  {    18,  9277,     0,   3,   0, UNI_sc_values_index }   /* sc= */,
  {     0,  9277,  9008,   3,   4, UNI_SC__THAA }   /* sc=thaa */,
  {     0,  9277,  7428,   3,   4, UNI_WARA }   /* sc=wara */,
  {    12,   184,  6385,   2,  12, UNI_GONM }   /* ismasaramgondi */,
  {     0,  5947,     0,  13,   0, UNI_MAYANNUMERALS }   /* mayannumerals */,
  {     0,  9277,  9628,   3,   4, UNI_SC__LATN }   /* sc=latn */,
  {     4,  8894,     0,   6,   0, UNI_joinc_values_index }   /* joinc= */,
  {     0,  9275,  6457,   5,  12, UNI_INSC__NUMBERJOINER }   /* insc=numberjoiner */,
  {     0,  5986,  9061,  13,   4, UNI_NV__1_SLASH_12 }   /* numericvalue=1/12 */,
  {     2,  8187,     0,   8,   0, UNI_HIRA }   /* hiragana */,
  {     0,   184,  1879,   3,  21, UNI_CJKCOMPATIDEOGRAPHSSUP }   /* iscjkcompatideographssup */,
  {     9,  9508,  3572,   4,   9, UNI_CCC__BL }   /* ccc=belowleft */,
  {     1,  3683,     0,  16,   0, UNI_ETHIOPICEXT }   /* ethiopicextended */,
  {     0,   184,  3358,   2,   9, UNI_Z }   /* isseparator */,
  {     1,  1966,  4523,  22,  15, UNI_INSC__CONSONANTMEDIAL }   /* indicsyllabiccategory=consonantmedial */,
  {     0,  9768,  9484,   4,   4, UNI_BHKS }   /* scx=bhks */,
  {     1,  8780,  4613,   6,  15, UNI_DIACRITICALSSUP }   /* block=diacriticalssup */,
  {     0,  9277,  9792,   3,   4, UNI_SOGO }   /* sc=sogo */,
  {    17,   184,  9692,   2,   4, UNI_NSHU }   /* isnshu */,
  {     1,  2182,  6169,  21,  12, UNI_WB__EB }   /* graphemeclusterbreak=glueafterzwj */,
  {     0,  7318,  9856,  10,   4, UNI_IN__13 }   /* presentin=v130 */,
  {     1,  3836,  9832,  17,   4, UNI_TIBT }   /* scriptextensions=tibt */,
  {     0,  9270,   468,   3,  10, UNI_INPUNCTUATION }   /* inpunctuation */,
  {     2,  5791,  5843,  13,  13, UNI_JG__MALAYALAMLLLA }   /* joininggroup=malayalamllla */,
  {     2,  3097,    45,  18,   3, UNI_DT__COM }   /* decompositiontype=com */,
  {     0, 10048,  4134,   3,   1, UNI_NV__1 }   /* nv=1 */,
  {     0,  8463,     0,   7,   0, UNI_KALI }   /* kayahli */,
  {     0,  8435,  9836,   7,   4, UNI_GRBASE }   /* grbase=true */,
  {    24,  6553,     3,  12,   1, -UNI_XIDC }   /* xidcontinue=f */,
  {     1,  4583,     0,  15,   0, UNI_PD }   /* dashpunctuation */,
  {    16, 10288,  5040,   3,   5, UNI_XPOSIXXDIGIT }   /* isxdigit */,
  {     0,  9768,  9736,   4,   4, UNI_COPT }   /* scx=qaac */,
  {     2,  8780,  4928,   6,  15, UNI_TAMILSUP }   /* block=tamilsupplement */,
  {     2,  9768,  9900,   4,   4, UNI_ZZZZ }   /* scx=zzzz */,
  {    44, 10333,    17,   3,   1, UNI_SO }   /* isso */,
  {     1,  8442,     0,   7,   0, UNI_HANO }   /* hanunoo */,
  {     1,  1828,     0,   5,   0, UNI_CASED }   /* cased */,
  {     0,  8894,    26,   6,   1, UNI_JOINC }   /* joinc=y */,
  {     1,  1834,    26,  22,   1, UNI_CWT }   /* changeswhentitlecased=y */,
  {     0,    78,     0,  35,   0, UNI_ARABICMATH }   /* arabicmathematicalalphabeticsymbols */,
  {     0, 10033,  3385,   3,  17, UNI_RI }   /* lb=regionalindicator */,
  {     1,  8589,  2288,   8,   6, UNI_SC__SINH }   /* script=sinhala */,
  {     0,  8688,  5033,   3,  12, UNI_POSIXXDIGIT }   /* isasciihexdigit */,
  {     8,  3374, 10135,  11,   3, UNI_XPOSIXSPACE }   /* whitespace=yes */,
  {     2,  7158,     3,  10,   1, -UNI_DIA }   /* diacritic=f */,
  {     2,  8589,  1218,   7,   8, UNI_SC__KANA }   /* script=katakana */,
  {     2,  5986,  9924,  13,   2, UNI_NV__42 }   /* numericvalue=42 */,
  {     4,   184,  8853,   3,   4, UNI_CWKCF }   /* iscwkcf */,
  {     3, 10048,  9984,   3,   2, UNI_NV__37 }   /* nv=37 */,
  {     0,  1845,     0,   9,   0, UNI_TITLE }   /* titlecase */,
  {     0,  9350,     0,   5,   0, UNI_xids_values_index }   /* xids= */,
  {     2,  8780,  6253,   6,   5, UNI_INKHMER }   /* block=khmer */,
  {     0,   184,   570,   3,  29, UNI_CJKEXTC }   /* iscjkunifiedideographsextensionc */,
  {     0,  5791,  7016,  13,  11, UNI_JG__YEHWITHTAIL }   /* joininggroup=yehwithtail */,
  {     3, 10009,  1253,   3,   7, UNI_DT__INIT }   /* dt=initial */,
  {     3,   184,  4808,   2,  15, UNI_MISCPICTOGRAPHS }   /* ismiscpictographs */,
  {     3,  9488,  2684,   4,  19, UNI_INEGYPTIANHIEROGLYPHS }   /* blk=egyptianhieroglyphs */,
  {     3,  2529,    26,  20,   1, UNI_TERM }   /* terminalpunctuation=y */,
  {     1,  9488,  4479,   5,  14, UNI_BRAI }   /* blk=braillepatterns */,
  {     1,  2224,  4370,   3,  15, UNI_SYRIACSUP }   /* insyriacsupplement */,
  {     0,  8589,  9516,   7,   4, UNI_SC__CPRT }   /* script=cprt */,
  {     0,  7088,     0,  11,   0, UNI_BC__B }   /* bidiclass=b */,
  {     0,  1417,  7922,  24,   2, UNI_CCC__24 }   /* canonicalcombiningclass=24 */,
  {    10,  3836,  8243,  17,   8, UNI_MAHJ }   /* scriptextensions=mahajani */,
  {     0,  8589,  9484,   7,   4, UNI_BHKS }   /* script=bhks */,
  {     5,   184,  6229,   2,  11, UNI_JOINC }   /* isjoincontrol */,
  {     0,  4033,  1217,  16,   2, UNI_SK }   /* generalcategory=sk */,
  {     3,  9640,  9836,   4,   4, UNI_LOE }   /* loe=true */,
  {     0,  7739,    36,   8,   1, UNI_IDS }   /* idstart=t */,
  {     2,  9277,  9668,   3,   4, UNI_MTEI }   /* sc=mtei */,
  {     0,  9997,    24,   3,   1, UNI_BC__L }   /* bc=l */,
  {     1,   184,  4448,   2,   4, UNI_BAMU }   /* isbamu */,
  {     3,  9277,  9592,   3,   4, UNI_HMNP }   /* sc=hmnp */,
  {    34,  9277,  9776,   3,   4, UNI_SGNW }   /* sc=sgnw */,
  {     3,  6205,    36,  12,   1, UNI_IDEO }   /* ideographic=t */,
  {    16,  7088,  3756,  10,   3, UNI_BC__NSM }   /* bidiclass=nsm */,
  {     0,    21,  9032,   2,   6, UNI_INWANCHO }   /* inwancho */,
  {     3,  2182,   125,  21,   2, UNI_LB__CR }   /* graphemeclusterbreak=cr */,
  {    17,  8589,  8179,   7,   8, UNI_SC__GURU }   /* script=gurmukhi */,
  {     2,  9277,  8337,   3,   7, UNI_AVST }   /* sc=avestan */,
  {     0,  9536,  9836,   4,   4, UNI_DEP }   /* dep=true */,
  {     0,  9262,    69,   3,   2, UNI_SB__UP }   /* sb=up */,
  {     6,  2054,     0,  22,   0, UNI_MODIFIERLETTERS }   /* spacingmodifierletters */,
  {     1,  7218,  7512,  10,   2, UNI_LB__BB }   /* linebreak=bb */,
  {     0,  5674,     0,  12,   0, UNI_BIDIM }   /* bidimirrored */,
  {     2,  9488,  6481,   4,  12, UNI_INOLDHUNGARIAN }   /* blk=oldhungarian */,
  {    10,   184,    11,   2,   3, UNI_DIA }   /* isdia */,
  {     6,  4116,  3260,   3,  16, UNI_IDSB }   /* isidsbinaryoperator */,
  {     1,  5037,    26,   9,   1, UNI_XPOSIXXDIGIT }   /* hexdigit=y */,
  {    32,  9508,  7890,   4,   2, UNI_CCC__33 }   /* ccc=33 */,
  {     0,  9277,  9548,   3,   4, UNI_DSRT }   /* sc=dsrt */,
  {     0,  5791,  7055,  13,   3, UNI_JG__QAF }   /* joininggroup=qaf */,
  {     4,    21,  9285,   2,   5, UNI_INLIMBU }   /* inlimbu */,
  {    16,  9277,   719,   3,   9, UNI_XSUX }   /* sc=cuneiform */,
  {     8,  8780,  1218,   6,   8, UNI_INKATAKANA }   /* block=katakana */,
  {     2,  9488,  1319,   4,  25, UNI_SYMBOLSANDPICTOGRAPHSEXTA }   /* blk=symbolsandpictographsexta */,
  {     0,  1417,  7821,  24,   1, UNI_CCC__8 }   /* canonicalcombiningclass=8 */,
  {     6, 10296,    96,   7,   5, UNI_POSIXALPHA }   /* isposixalpha */,
  {     0,  8780,  4448,   6,  15, UNI_BAMUMSUP }   /* block=bamumsupplement */,
  {     8,  7218,  3385,  10,  17, UNI_RI }   /* linebreak=regionalindicator */,
  {     1,  9636,     0,   4,   0, UNI_LINB }   /* linb */,
  {     0,  9488,   467,   4,  11, UNI_INPUNCTUATION }   /* blk=punctuation */,
  {    17,  9277,  8942,   3,   6, UNI_LYDI }   /* sc=lydian */,
  {     2, 10024,  1171,   3,   2, UNI_TITLE }   /* gc=lt */,
  {     0,  4033,  4017,  16,  16, UNI_PF }   /* generalcategory=finalpunctuation */,
  {     0, 10033,  6179,   3,   2, UNI_LB__WJ }   /* lb=wj */,
  {    38,  4658,  9255,  15,   5, -UNI_GREXT }   /* graphemeextend=false */,
  {    16, 10048,  8714,   3,   3, UNI_NV__300 }   /* nv=300 */,
  {     1,  9235,     0,   5,   0, UNI_cwcm_values_index }   /* cwcm= */,
  {     0,  9596,    36,   4,   1, UNI_GCB__T }   /* hst=t */,
  {    20,  9768,  9283,   4,   4, UNI_PHLI }   /* scx=phli */,
  {     0,  8762,  9255,   6,   5, -UNI_XPOSIXALPHA }   /* alpha=false */,
  {     4,  3836,  8561,  17,   7, UNI_OSMA }   /* scriptextensions=osmanya */,
  {     0,  8589,     7,   7,  18, UNI_CANS }   /* script=canadianaboriginal */,
  {     1,  9488,  6554,   4,   3, UNI_INIDC }   /* blk=idc */,
  {     0,  8984,     1,   6,   1, -UNI_QMARK }   /* qmark=n */,
  {    24, 10027,  6301,   3,  12, UNI_JG__MALAYALAMLLA }   /* jg=malayalamlla */,
  {     3,   184,  9564,   2,   4, UNI_GONM }   /* isgonm */,
  {     0,  4033,  6873,  16,  11, UNI_SO }   /* generalcategory=othersymbol */,
  {     0,  8780,  6385,   6,  12, UNI_INMASARAMGONDI }   /* block=masaramgondi */,
  {    49,  8762,  9836,   6,   4, UNI_XPOSIXALPHA }   /* alpha=true */,
  {     0,   184, 10170,   2,   2, UNI_CASEDLETTER }   /* isl_ */,
  {     0,  8589,  9900,   7,   4, UNI_ZZZZ }   /* script=zzzz */,
  {     0, 10063,  9836,   3,   4, UNI_SD }   /* sd=true */,
  {     0,  9488,  3169,   4,  18, UNI_ETHIOPICSUP }   /* blk=ethiopicsupplement */,
  {     2,  6229,     0,  11,   0, UNI_JOINC }   /* joincontrol */,
  {     1,  9277,  9002,   3,   6, UNI_SC__TELU }   /* sc=telugu */,
  {     1,  8780,  7119,   7,   9, UNI_INCHORASMIAN }   /* block=chorasmian */,
  {    13,  6553,  9255,  12,   5, -UNI_XIDC }   /* xidcontinue=false */,
  {     2,  9277,  9335,   3,   5, UNI_SC__TAKR }   /* sc=takri */,
  {     0,  4829,  2411,   4,  18, UNI_GLAGOLITICSUP }   /* inglagoliticsupplement */,
  {     2,  8589,  8491,   7,   7, UNI_MARC }   /* script=marchen */,
  {     0,  1856,  9255,  22,   5, -UNI_CWU }   /* changeswhenuppercased=false */,
  {     4, 10048,  7923,   3,   8, UNI_NV__2_SLASH_5 }   /* nv=4.00e-01 */,
  {    49,  9768,  8942,   4,   4, UNI_LYDI }   /* scx=lydi */,
  {     4,  7318,  7987,  10,   3, UNI_IN__6_DOT_2 }   /* presentin=6.2 */,
  {     0,  3666,     0,  17,   0, UNI_CYRILLICEXTC }   /* cyrillicextendedc */,
  {     5,  9032,     0,   6,   0, UNI_WCHO }   /* wancho */,
  {     1, 10027,  6157,   3,  12, UNI_JG__FINALSEMKATH }   /* jg=finalsemkath */,
  {     0,  9540,    36,   4,   1, UNI_DIA }   /* dia=t */,
  {     0,  3836,  9516,  17,   4, UNI_CPRT }   /* scriptextensions=cprt */,
  {     2,  9277,     7,   3,  18, UNI_CANS }   /* sc=canadianaboriginal */,
  {     2,  9277,  3025,   3,   4, UNI_CHER }   /* sc=cher */,
  {     2,   184,  9752,   2,   4, UNI_ROHG }   /* isrohg */,
  {     0,  5564,     3,  14,   1, -UNI_QMARK }   /* quotationmark=f */,
  {     1,  9508,  9186,   5,   4, UNI_CCC__31 }   /* ccc=ccc31 */,
  {     3,  8780,  9310,   6,   5, UNI_INOGHAM }   /* block=ogham */,
  {     1,  9277,  2224,   3,  21, UNI_PRTI }   /* sc=inscriptionalparthian */,
  {     0,  1552,  1465,   9,  13, UNI_M }   /* category=combiningmark */,
  {     1,  2280,   125,   3,   2, UNI_OCR }   /* isocr */,
  {     0,  9508,  9223,   4,   2, UNI_CCC__91 }   /* ccc=91 */,
  {    12,  5791,    65,  15,   2, UNI_JG__KAPH }   /* joininggroup=kaph */,
  {     0,   184,   951,   2,  18, UNI_INVS }   /* isvariationselectors */,
  {     1, 10126,  3511,   3,  18, UNI_VO__TU }   /* vo=transformedupright */,
  {     5,  9277,  1115,   3,   4, UNI_SC__HANG }   /* sc=hang */,
  {    32,  7218,    21,  10,   2, UNI_LB__IN }   /* linebreak=in */,
  {     5,  4916,  9336,   3,   4, UNI_TAKR }   /* istakri */,
  {     1,  9277,  8407,   3,   7, UNI_DSRT }   /* sc=deseret */,
  {    50, 10132,  8505,   3,   7, UNI_WB__NL }   /* wb=newline */,
  {     0,  1417,  7933,  24,   2, UNI_CCC__17 }   /* canonicalcombiningclass=17 */,
  {     6,  5791,  2627,  13,  19, UNI_JG__BURUSHASKIYEHBARREE }   /* joininggroup=burushaskiyehbarree */,
  {     0,  8780,  2141,   7,   7, UNI_INCYRILLIC }   /* block=cyrillic */,
  {     6, 10333,  8604,   3,   6, UNI_SHAW }   /* isshavian */,
  {     2, 10027,  5934,   3,  13, UNI_JG__MANICHAEANWAW }   /* jg=manichaeanwaw */,
  {     0,   184,  5494,   2,  14, UNI_MN }   /* isnonspacingmark */,
  {     9,  5986,  8003,  13,   8, UNI_NV__1_SLASH_160 }   /* numericvalue=6.25e-03 */,
  {     0, 10132,    72,   3,   2, UNI_WB__LE }   /* wb=le */,
  {    14,  7076,  8346,   4,   5, UNI_INBENGALI }   /* inbengali */,
  {    18,    21,  9624,   2,   3, UNI_INLAO }   /* inlao */,
  {     1,  9488,  2076,   4,  22, UNI_TRANSPORTANDMAP }   /* blk=transportandmapsymbols */,
  {     0,  1988,     0,  21,   0, UNI_LOE }   /* logicalorderexception */,
  {    10,  4916,  2077,   3,  14, UNI_TRANSPORTANDMAP }   /* istransportandmap */,
  {     2,  5578,     0,  14,   0, UNI_sb_values_index }   /* sentencebreak= */,
  {     2,  4791,  6830,   3,  10, UNI_MYANMAREXTB }   /* inmyanmarextb */,
  {     0,  8780,  5661,   6,  13, UNI_AEGEANNUMBERS }   /* block=aegeannumbers */,
  {     0, 10024,  5592,   3,  14, UNI_ZS }   /* gc=spaceseparator */,
  {     6,  2140,     0,  21,   0, UNI_CYRILLICSUP }   /* cyrillicsupplementary */,
  {     0,  8852, 10135,   6,   3, UNI_CWKCF }   /* cwkcf=yes */,
  {     0,  9488,   923,   4,  28, UNI_SUPPUAB }   /* blk=supplementaryprivateuseareab */,
  {     3,  8147,  1942,  10,   3, -UNI_EXTPICT }   /* extpict=false */,
  {     2,  8780,  6181,   6,  12, UNI_INGUNJALAGONDI }   /* block=gunjalagondi */,
  {     3,  8589,  9732,   7,   4, UNI_PRTI }   /* script=prti */,
  {     6,  3382,     3,   3,   1, -UNI_CE }   /* ce=f */,
  {     8, 10048,  5649,   3,   1, UNI_NV__0 }   /* nv=0 */,
  {     0,  9508,  4134,   4,   1, UNI_CCC__1 }   /* ccc=1 */,
  {     0,  7218,  7486,  10,   9, UNI_LB__AI }   /* linebreak=ambiguous */,
  {     0,  7308,     0,  10,   0, UNI_PHNX }   /* phoenician */,
  {     1,  9277,    57,   3,   2, UNI_SC__YI }   /* sc=yi */,
  {     1,  8589,  9832,   7,   4, UNI_TIBT }   /* script=tibt */,
  {     2,  1552,  5593,  10,  13, UNI_ZS }   /* category=spaceseparator */,
  {     0,  8547,     0,   7,   0, UNI_OLCK }   /* olchiki */,
  {     4,  3836,  7621,  17,   9, UNI_NBAT }   /* scriptextensions=nabataean */,
  {     0,  6805,   187,   6,  16, UNI_MISCSYMBOLS }   /* inmiscellaneoussymbols */,
  {     0,   749,     0,  21,   0, UNI_ENCLOSEDALPHANUM }   /* enclosedalphanumerics */,
  {     8,  9768,  8123,   4,   4, UNI_BUGI }   /* scx=bugi */,
  {     1,    21,  5033,   3,   4, UNI_ASCII }   /* inascii */,
  {     2,  3836,  8942,  17,   4, UNI_LYDI }   /* scriptextensions=lydi */,
  {     1,  9768,  9872,   4,   4, UNI_XPEO }   /* scx=xpeo */,
  {    28, 10033,   414,   3,  11, UNI_LB__ID }   /* lb=ideographic */,
  {    19,  9444, 10120,   4,   3, UNI_AGE__8 }   /* age=v80 */,
  {     4, 10033,   988,   3,   2, UNI_LB__CP }   /* lb=cp */,
  {     0, 10048,  8714,   3,   2, UNI_NV__30 }   /* nv=30 */,
  {    43,  5791,  5892,  13,   3, UNI_JG__NUN }   /* joininggroup=nun */,
  {     1, 10129,  9836,   3,   4, UNI_VS }   /* vs=true */,
  {     3,   184,   540,   3,  29, UNI_CJKEXTB }   /* iscjkunifiedideographsextensionb */,
  {     0,  1552,     0,  10,   0, UNI_S }   /* category=s */,
  {     1,  8780,  4793,   6,  15, UNI_INMEROITICCURSIVE }   /* block=meroiticcursive */,
  {     4,  9997,  2509,   3,  20, UNI_BC__RLE }   /* bc=righttoleftembedding */,
  {    11,  3836,  9592,  17,   4, UNI_HMNP }   /* scriptextensions=hmnp */,
  {     0,  3079,     0,  18,   0, UNI_COPTICEPACTNUMBERS }   /* copticepactnumbers */,
  {    40,  3836,  9604,  17,   4, UNI_KHMR }   /* scriptextensions=khmr */,
  {     0,  8780,  3683,   6,  17, UNI_ETHIOPICEXTA }   /* block=ethiopicextendeda */,
  {     0,  7158,    26,  10,   1, UNI_DIA }   /* diacritic=y */,
  {     1,  4916,  1846,   3,   8, UNI_TITLE }   /* istitlecase */,
  {     1,  8400,     0,   6,   0, UNI_COMPEX }   /* compex */,
  {     0,  6469,  5713,  12,   7, UNI_XPOSIXDIGIT }   /* numerictype=decimal */,
  {    64, 10024,   728,   3,   6, UNI_N }   /* gc=number */,
  {     1,  9508,  7806,   4,   1, UNI_CCC__6 }   /* ccc=6 */,
  {     0,  3836,  7630,  17,   9, UNI_TALU }   /* scriptextensions=newtailue */,
  {    17,  9277,  9095,   3,   5, UNI_SC__BUHD }   /* sc=buhid */,
  {     2,  9728,     0,   4,   0, UNI_MIAO }   /* plrd */,
  {     2,  7088,  4321,  10,  16, UNI_BC__S }   /* bidiclass=segmentseparator */,
  {    17,  8780,  1294,   6,  25, UNI_SUPERANDSUB }   /* block=superscriptsandsubscripts */,
  {     2,  5674,    26,  13,   1, UNI_BIDIM }   /* bidimirrored=y */,
  {     9,  9488,  3632,   4,  17, UNI_CYRILLICEXTA }   /* blk=cyrillicextendeda */,
  {     0,  3836,  9812,  17,   4, UNI_TAML }   /* scriptextensions=taml */,
  {     0,    21,  6253,   2,  12, UNI_KHMERSYMBOLS }   /* inkhmersymbols */,
  {     0,  8694,    36,   7,   1, UNI_XPOSIXSPACE }   /* wspace=t */,
  {     0,  8864,     1,   6,   1, -UNI_EMOJI }   /* emoji=n */,
  {     0,  3836,  8618,  18,   3, UNI_SOYO }   /* scriptextensions=soyo */,
  {     3,  8589,  9560,   7,   4, UNI_SC__GONG }   /* script=gong */,
  {    32,   184,  4478,   2,  15, UNI_BRAI }   /* isbraillepatterns */,
  {     1,  7155,  8889,   3,   5, UNI_HATR }   /* ishatran */,
  {     1,  9488,  8275,   4,   8, UNI_SPECIALS }   /* blk=specials */,
  {     0,  9508,  8727,   4,   2, UNI_CCC__32 }   /* ccc=32 */,
  {     0,  9768,  9704,   4,   4, UNI_ORKH }   /* scx=orkh */,
  {     2,  3097,   749,  18,   3, UNI_DT__ENC }   /* decompositiontype=enc */,
  {     0,  9768,  1176,   5,   3, UNI_SORA }   /* scx=sora */,
  {     0, 10327,    47,   5,   1, UNI_PERM }   /* isperm */,
  {    17,  5060,  9836,  14,   4, UNI_CI }   /* caseignorable=true */,
  {     2,  8267,  1025,   8,   2, -UNI_RADICAL }   /* radical=no */,
  {     1, 10048,  5648,   3,   9, UNI_NV__100000000 }   /* nv=100000000 */,
  {     0,   184,  9612,   2,   4, UNI_KNDA }   /* isknda */,
  {     0,  7325,  7754,   3,   2, UNI_IN__11 }   /* in=11 */,
  {     0,  5791,  6325,  13,  12, UNI_JG__MALAYALAMNNA }   /* joininggroup=malayalamnna */,
  {     0,  5060,     3,  14,   1, -UNI_CI }   /* caseignorable=f */,
  {    45,  6818,     0,  11,   0, UNI_MYANMAREXTA }   /* myanmarexta */,
  {     1,  5578,    34,  14,   2, UNI_SB__EX }   /* sentencebreak=ex */,
  {     0,  8589,  8786,   7,   4, UNI_CARI }   /* script=cari */,
  {     3,  1552,   728,   9,   6, UNI_N }   /* category=number */,
  {     6,  5986,  7947,  13,   8, UNI_NV__3_SLASH_64 }   /* numericvalue=4.69e-02 */,
  {     0,  8589,  9448,   7,   4, UNI_AGHB }   /* script=aghb */,
  {     0,  4116,  5779,   3,   5, UNI_IPAEXT }   /* isipaext */,
  {     7,  8780,   720,   7,  29, UNI_CUNEIFORMNUMBERS }   /* block=cuneiformnumbersandpunctuation */,
  {     1, 10320,    17,   5,   1, UNI_XPEO }   /* isxpeo */,
  {    14,  9508,  9121,   5,   4, UNI_CCC__18 }   /* ccc=ccc18 */,
  {     0,  6231,  2120,   3,  13, UNI_CJKRADICALSSUP }   /* incjkradicalssup */,
  {     1,  9277,  6385,   3,  12, UNI_SC__GONM }   /* sc=masaramgondi */,
  {     0,  8575,  9836,   7,   4, UNI_PATSYN }   /* patsyn=true */,
  {     4,  8589,  8491,   7,   4, UNI_MARC }   /* script=marc */,
  {     3,  9277,  8840,   3,   6, UNI_SC__CAKM }   /* sc=chakma */,
  {     0,  1417,  9943,  24,   3, UNI_CCC__AR }   /* canonicalcombiningclass=232 */,
  {     2,  2784,  3923,   4,  14, UNI_ARABICSUP }   /* inarabicsupplement */,
  {     0,  9768,  8315,   4,   8, UNI_UGAR }   /* scx=ugaritic */,
  {     0,  9632,     0,   4,   0, UNI_LINA }   /* lina */,
  {     0, 10027,  4773,   3,   5, UNI_JG__SADHE }   /* jg=sadhe */,
  {     1,  7249,     9,   4,  16, UNI_CANS }   /* iscanadianaboriginal */,
  {     0,  2182,    70,  21,   2, UNI_GCB__PP }   /* graphemeclusterbreak=pp */,
  {     1,  6928,  1025,  11,   2, -UNI_SD }   /* softdotted=no */,
  {     2, 10129,    36,   3,   1, UNI_VS }   /* vs=t */,
  {    13,  9768,  1654,   4,   6, UNI_HANG }   /* scx=hangul */,
  {     7,  8780,   749,   6,  30, UNI_ENCLOSEDALPHANUMSUP }   /* block=enclosedalphanumericsupplement */,
  {     0,  7249,   754,   4,   3, UNI_CASED }   /* iscased */,
  {     2,  3295,     0,  18,   0, UNI_LATINEXTADDITIONAL }   /* latinextadditional */,
  {    34,  8882,  9836,   6,   4, UNI_GREXT }   /* grext=true */,
  {     0,  5578,     7,  15,   1, UNI_SB__SC }   /* sentencebreak=sc */,
  {     0,  2529,  9837,  21,   3, UNI_TERM }   /* terminalpunctuation=true */,
  {     0,   316,     0,  33,   0, UNI_SUPMATHOPERATORS }   /* supplementalmathematicaloperators */,
  {     0,  9262,  3358,   3,   3, UNI_SB__SE }   /* sb=sep */,
  {     0,  6231,  3045,   4,  16, UNI_HALFMARKS }   /* incombininghalfmarks */,
  {    16,   184,  1857,   3,  20, UNI_CWU }   /* ischangeswhenuppercased */,
  {     1, 10009,   435,   4,   2, UNI_DT__ENC }   /* dt=enc */,
  {     0,  1552,  4898,   9,  15, UNI_PS }   /* category=openpunctuation */,
  {     0,  8589,  6973,   8,  10, UNI_SC__SYLO }   /* script=sylotinagri */,
  {     6,   184,  5752,   2,  13, UNI_GREEKEXT }   /* isgreekextended */,
  {     3,  7458,     0,  10,   0, UNI_YIRADICALS }   /* yiradicals */,
  {     0, 10027,  4203,   3,   3, UNI_JG__LAM }   /* jg=lam */,
  {     0,  1828,  1025,   6,   2, -UNI_CASED }   /* cased=no */,
  {     0, 10048,  8820,   3,   2, UNI_NV__29 }   /* nv=29 */,
  {     0,  1087,     1,  27,   1, -UNI_PCM }   /* prependedconcatenationmark=n */,
  {     3,  9768,  8315,   4,   4, UNI_UGAR }   /* scx=ugar */,
  {     0,  5564,  9255,  14,   5, -UNI_QMARK }   /* quotationmark=false */,
  {     1,  7218,  6686,  10,  11, UNI_LB__IN }   /* linebreak=inseparable */,
  {     8,  7738,  1025,   9,   2, -UNI_XIDS }   /* xidstart=no */,
  {     8,    42,     0,   9,   0, UNI_CJKCOMPAT }   /* cjkcompat */,
  {     2,  8617,     0,   4,   0, UNI_SOYO }   /* soyo */,
  {     6,  3598,     0,  17,   0, UNI_AGHB }   /* caucasianalbanian */,
  {     0,  9768,  8107,   4,   8, UNI_BALI }   /* scx=balinese */,
  {     2,  8996,     0,   6,   0, UNI_sterm_values_index }   /* sterm= */,
  {     0,  6409,     0,   4,   0, UNI_MEND }   /* mend */,
  {     1,  7318,  9979,  10,   3, UNI_IN__6_DOT_1 }   /* presentin=6.1 */,
  {     0,  1552,    74,   9,   2, UNI_ME }   /* category=me */,
  {     0,  6620,     0,  11,   0, UNI_DOMINO }   /* dominotiles */,
  {     0,  9488,  2076,   4,  15, UNI_TRANSPORTANDMAP }   /* blk=transportandmap */,
  {     0,  1922,     0,  22,   0, UNI_DIACRITICALSFORSYMBOLS }   /* diacriticalsforsymbols */,
  {    16,  7218,  7108,  10,  10, UNI_LB__BA }   /* linebreak=breakafter */,
  {     0,  9444, 10090,   4,   3, UNI_AGE__4 }   /* age=v40 */,
  {     4,  9245,     0,   4,   0, UNI_DOGR }   /* dogr */,
  {     5,  5986,  7811,  13,   8, UNI_NV__1_SLASH_6 }   /* numericvalue=1.67e-01 */,
  {    21,  4033,  1822,  16,   2, UNI_NL }   /* generalcategory=nl */,
  {     0,  7218,    23,  10,   2, UNI_LB__AL }   /* linebreak=al */,
  {     0,  8589,  8407,   7,   7, UNI_DSRT }   /* script=deseret */,
  {     0,  9488,  3079,   4,  18, UNI_COPTICEPACTNUMBERS }   /* blk=copticepactnumbers */,
  {     0,  9768,  9708,   4,   4, UNI_ORYA }   /* scx=orya */,
  {     3,  6205,  1025,  12,   2, -UNI_IDEO }   /* ideographic=no */,
  {     2,   184,  3241,   2,   8, UNI_GEOR }   /* isgeorgian */,
  {     0,  5746,     0,   6,   0, UNI_ebase_values_index }   /* ebase= */,
  {     3,   184,    34,   2,   3, UNI_EXT }   /* isext */,
  {     1, 10027,  8283,   3,   8, UNI_JG__SWASHKAF }   /* jg=swashkaf */,
  {     1,   184,  8990,   2,   6, UNI_RJNG }   /* isrejang */,
  {     4,  8780,  2836,   6,  19, UNI_MODIFIERTONELETTERS }   /* block=modifiertoneletters */,
  {     0,   184,  9620,   2,   4, UNI_LANA }   /* islana */,
  {     1,  5791, 10021,  13,   3, UNI_JG__GAF }   /* joininggroup=gaf */,
  {    18,   184,  3439,   2,  18, UNI_SMALLKANAEXT }   /* issmallkanaextension */,
  {     1, 10132,  1194,   3,   2, UNI_LB__LF }   /* wb=lf */,
  {     9,  9071,  9836,   4,   4, UNI_XPOSIXXDIGIT }   /* hex=true */,
  {     0,  1417,  7930,  24,   2, UNI_CCC__14 }   /* canonicalcombiningclass=14 */,
  {     8,  9277,  8442,   3,   7, UNI_SC__HANO }   /* sc=hanunoo */,
  {     1,  6231,  1879,   3,  18, UNI_CJKCOMPATIDEOGRAPHS }   /* incjkcompatideographs */,
  {     1,  6469,  5040,  12,   5, UNI_NT__DI }   /* numerictype=digit */,
  {     0,  2032, 10135,  22,   3, UNI__PERL_NCHAR }   /* noncharactercodepoint=yes */,
  {     1,  5986,  9364,  13,   4, UNI_NV__1_SLASH_10 }   /* numericvalue=1/10 */,
  {    16,  3904,     1,  17,   1, -UNI_UIDEO }   /* unifiedideograph=n */,
  {    11,  5791,  7045,  13,   2, UNI_JG__FE }   /* joininggroup=fe */,
  {    17,  9584,     0,   4,   0, UNI_HLUW }   /* hluw */,
  {     4,   113,     0,  35,   0, UNI_DIACRITICALSFORSYMBOLS }   /* combiningdiacriticalmarksforsymbols */,
  {     1,  5791,  9044,  13,   6, UNI_JG__YUDHHE }   /* joininggroup=yudhhe */,
  {     0,  7318,  7782,  10,   1, UNI_IN__3 }   /* presentin=3 */,
  {     3,  9508,  8066,   4,   2, UNI_CCC__28 }   /* ccc=28 */,
  {     6,  9277,  9740,   3,   4, UNI_SC__QAAI }   /* sc=qaai */,
  {     0,  9508,  8831,   4,   3, UNI_CCC__132 }   /* ccc=132 */,
  {     8,   184,  4289,   2,  16, UNI_MYANMAREXTB }   /* ismyanmarextendedb */,
  {     1,  9488,  7058,   4,  10, UNI_ARABICEXTA }   /* blk=arabicexta */,
  {     8,  6553,  9836,  12,   4, UNI_XIDC }   /* xidcontinue=true */,
  {     0,  9556,  8139,   4,   8, UNI_WB__EB }   /* gcb=ebasegaz */,
  {     1,  7291,     0,   4,   0, UNI_SOGD }   /* sogd */,
  {     0,  5986,  9907,  13,   3, UNI_NV__1_SLASH_7 }   /* numericvalue=1/7 */,
  {     2,  7028,  2309,   3,   5, UNI_YIJING }   /* isyijing */,
  {    97,  9768,  8900,   4,   6, UNI_KTHI }   /* scx=kaithi */,
  {     0,  9768,  7308,   4,  10, UNI_PHNX }   /* scx=phoenician */,
  {     0, 10027,  5895,   3,  13, UNI_JG__MANICHAEANONE }   /* jg=manichaeanone */,
  {     0, 10003,  9255,   3,   5, -UNI_CI }   /* ci=false */,
  {    44,  3751,     0,  17,   0, UNI_KITS }   /* khitansmallscript */,
  {     3,  8780,  8344,   6,   7, UNI_INBENGALI }   /* block=bengali */,
  {     0,  8780,  7666,   6,   9, UNI_INOLDTURKIC }   /* block=oldturkic */,
  {    34,  7218,  6179,  10,   2, UNI_LB__WJ }   /* linebreak=wj */,
  {     0,  3836,  9828,  17,   4, UNI_THAI }   /* scriptextensions=thai */,
  {     0,  9488,  8299,   4,   8, UNI_INTIFINAGH }   /* blk=tifinagh */,
  {     2,  8780,  4097,   6,  16, UNI_HIGHPUSURROGATES }   /* block=highpusurrogates */,
  {     0,  8780,  3547,   6,  17, UNI_ALCHEMICAL }   /* block=alchemicalsymbols */,
  {     0,  7325,  9400,   3,   4, UNI_IN__13 }   /* in=13.0 */,
  {     0,  2760,    24,  19,   1, UNI_GCB__L }   /* hangulsyllabletype=l */,
  {     8,  4113,  1751,   3,   2, UNI_INVAI }   /* invai */,
  {     3,  4916,  9821,   3,   3, UNI_TFNG }   /* istfng */,
  {     0,  4033,     7,  16,   1, UNI_C }   /* generalcategory=c */,
  {     0,   184,   630,   3,  29, UNI_CJKEXTE }   /* iscjkunifiedideographsextensione */,
  {     0,  9345, 10135,   5,   3, UNI_XIDC }   /* xidc=yes */,
  {     0,  9488,  8547,   4,   7, UNI_OLCK }   /* blk=olchiki */,
  {    33,  9768,  9532,   4,   4, UNI_CYRL }   /* scx=cyrl */,
  {     0,  6939,     0,   4,   0, UNI_SORA }   /* sora */,
  {     3, 10033,  6686,   3,  11, UNI_LB__IN }   /* lb=inseparable */,
  {     0,  8400,  9836,   7,   4, UNI_COMPEX }   /* compex=true */,
  {     6,  8978,     3,   6,   1, -UNI__PERL_PATWS }   /* patws=f */,
  {     2,  9488,   446,   4,  32, UNI_IDEOGRAPHICSYMBOLS }   /* blk=ideographicsymbolsandpunctuation */,
  {     0,  7138,     0,  10,   0, UNI_COMPATJAMO }   /* compatjamo */,
  {     0,  4989,     1,   3,  41, UNI_UCASEXT }   /* isunifiedcanadianaboriginalsyllabicsextended */,
  {     1,   184,  3385,   2,  17, UNI_RI }   /* isregionalindicator */,
  {     0,  5508,  1025,  14,   2, -UNI_PATSYN }   /* patternsyntax=no */,
  {     6, 10290,  3379,   6,   5, UNI_XPOSIXSPACE }   /* xposixspace */,
  {     0,   184,  2409,   2,  13, UNI_GLAGOLITICSUP }   /* isglagoliticsup */,
  {     0,  9508,  7814,   4,   1, UNI_CCC__7 }   /* ccc=7 */,
  {     8,  8561,     0,   7,   0, UNI_OSMA }   /* osmanya */,
  {    14,  7438,  6193,  10,  12, UNI_LB__HL }   /* wordbreak=hebrewletter */,
  {     2,   184,  8203,   2,   8, UNI_JAMOEXTA }   /* isjamoexta */,
  {     5,  1166,    36,  26,   1, UNI_DI }   /* defaultignorablecodepoint=t */,
  {     7,  8774,  9255,   6,   5, -UNI_BIDIM }   /* bidim=false */,
  {     9,  7088,    24,  10,   1, UNI_BC__L }   /* bidiclass=l */,
  {    24,  9277,  8936,   3,   4, UNI_LYCI }   /* sc=lyci */,
  {     0,  9277,  8914,   5,   4, UNI_SC__KHOJ }   /* sc=khojki */,
  {     0,  9528,     3,   4,   1, -UNI_CWU }   /* cwu=f */,
  {     0,  4033,   262,  16,   2, UNI_SM }   /* generalcategory=sm */,
  {     2,  6609,  1025,  11,   2, -UNI_DEP }   /* deprecated=no */,
  {     0,  9768,  7684,   4,   4, UNI_PAUC }   /* scx=pauc */,
  {     4,  7325,  5648,   3,   2, UNI_IN__10 }   /* in=10 */,
  {     1,  9997,    18,   3,   1, UNI_BC__R }   /* bc=r */,
  {    30,  9085,     0,   5,   0, UNI_BATK }   /* batak */,
  {     1,   184,  2409,   2,  10, UNI_GLAG }   /* isglagolitic */,
  {     0,  9768,  2608,   4,   6, UNI_BRAH }   /* scx=brahmi */,
  {     0,  8780,  8299,   6,   8, UNI_INTIFINAGH }   /* block=tifinagh */,
  {     1,  8780,  6025,   6,  12, UNI_ALPHABETICPF }   /* block=alphabeticpf */,
  {     4,   119,  8877,   3,   5, UNI_INGOTHIC }   /* ingothic */,
  {     0, 10024,    32,   3,   2, UNI__PERL_SURROGATE }   /* gc=cs */,
  {    45,  3115,     0,  10,   0, UNI_DEVA }   /* devanagari */,
  {     0,  9270,  6506,   3,   7, UNI_PHAISTOS }   /* inphaistos */,
  {    14,   184,  4145,   2,   7, UNI_LINB }   /* islinearb */,
  {     3,  9508,  9126,   5,   4, UNI_CCC__19 }   /* ccc=ccc19 */,
  {     0, 10033,  6073,   3,  12, UNI_LB__SY }   /* lb=breaksymbols */,
  {     0,  9277,  2912,   3,   9, UNI_SUND }   /* sc=sundanese */,
  {     1,  3259,     0,  17,   0, UNI_IDSB }   /* idsbinaryoperator */,
  {     0,  3836,  2245,  17,  11, UNI_MTEI }   /* scriptextensions=meeteimayek */,
  {     1,  1856,     0,  22,   0, UNI_cwu_values_index }   /* changeswhenuppercased= */,
  {     6,    24,     0,   1,   0, UNI_L }   /* l */,
  {     2,   184,  4643,   2,  14, UNI_ECOMP }   /* isemojicomponent */,
  {     1,  7218,  8449,  10,   6, UNI_LB__HY }   /* linebreak=hyphen */,
  {     1, 10048,  9408,   3,   4, UNI_NV__15_SLASH_2 }   /* nv=15/2 */,
  {     1,  7028,  5219,   3,   9, UNI_YIRADICALS }   /* isyiradicals */,
  {     5,  7076,  9096,   3,   4, UNI_INBUHID }   /* inbuhid */,
  {     1,   184,  7632,   3,   2, UNI_CWT }   /* iscwt */,
  {    34,  9277,  9760,   3,   4, UNI_SAMR }   /* sc=samr */,
  {     3,  9488,  3223,   4,  18, UNI_INPUNCTUATION }   /* blk=generalpunctuation */,
  {    12,  7088,  1353,  10,   3, UNI_BC__RLE }   /* bidiclass=rle */,
  {     1,  8780,  3044,   7,  17, UNI_HALFMARKS }   /* block=combininghalfmarks */,
  {     0,    21,  7428,   2,  10, UNI_INWARANGCITI }   /* inwarangciti */,
  {    19,  1417,  9946,  24,   3, UNI_CCC__DB }   /* canonicalcombiningclass=233 */,
  {     1,   184,  1922,   2,  12, UNI_DIACRITICALS }   /* isdiacriticals */,
  {     0,  9768,  9728,   4,   4, UNI_MIAO }   /* scx=plrd */,
  {     2,  9768,  8344,   4,   7, UNI_BENG }   /* scx=bengali */,
  {     1,  9326,  1183,   4,   3, UNI_ANY }   /* unicode */,
  {    23,  8589,  7359,   8,   3, UNI_SAUR }   /* script=saur */,
  {    12,  5752,     0,  13,   0, UNI_GREEKEXT }   /* greekextended */,
  {     0,  4542,  3243,   4,   9, UNI_GEORGIANSUP }   /* ingeorgiansup */,
  {     4,  4658,     0,  14,   0, UNI_GREXT }   /* graphemeextend */,
  {     0,  9275,  9090,   5,   5, UNI_INSC__BINDU }   /* insc=bindu */,
  {     0,  2308,     0,   6,   0, UNI_YIJING }   /* yijing */,
  {     1,  9277,  8561,   3,   7, UNI_OSMA }   /* sc=osmanya */,
  {     0,  3358,     0,   9,   0, UNI_Z }   /* separator */,
  {     0,  8589,  9604,   7,   4, UNI_KHMR }   /* script=khmr */,
  {     1,  2529,     0,  19,   0, UNI_TERM }   /* terminalpunctuation */,
  {     1, 10027,  6337,   3,  12, UNI_JG__MALAYALAMNYA }   /* jg=malayalamnya */,
  {     1,  3259,  1025,  18,   2, -UNI_IDSB }   /* idsbinaryoperator=no */,
  {     0,   184,  5687,   2,  13, UNI_BLOCKELEMENTS }   /* isblockelements */,
  {     8,  8984,     0,   6,   0, UNI_qmark_values_index }   /* qmark= */,
  {     8,  4688,  8540,  15,   7, UNI_IDENTIFIERTYPE__NOTNFKC }   /* identifiertype=notnfkc */,
  {     2, 10132,    73,   3,   2, UNI_WB__EB }   /* wb=em */,
  {     1,  7438,  7612,  10,   9, UNI_WB__MB }   /* wordbreak=midnumlet */,
  {     1,  9692,     0,   4,   0, UNI_NSHU }   /* nshu */,
  {    14,  1966,  7328,  22,  10, UNI_INSC__PUREKILLER }   /* indicsyllabiccategory=purekiller */,
  {    19,  8589,  1677,   7,   5, UNI_SC__LATN }   /* script=latin */,
  {     1,  9488,  9656,   4,   4, UNI_INMIAO }   /* blk=miao */,
  {    18, 10126,  3522,   3,   7, UNI_VO__U }   /* vo=upright */,
  {     0,  2569,  3522,  20,   7, UNI_VO__U }   /* verticalorientation=upright */,
  {     0,  3836,  3241,  17,   8, UNI_GEOR }   /* scriptextensions=georgian */,
  {    17,  9768,  7428,   4,  10, UNI_WARA }   /* scx=warangciti */,
  {     2,  8688,  8093,   4,   6, UNI_ARMN }   /* isarmenian */,
  {     0,  7218,   340,  10,   2, UNI_LB__OP }   /* linebreak=op */,
  {     0,   184,   838,   2,  29, UNI_MISCARROWS }   /* ismiscellaneoussymbolsandarrows */,
  {    12,  5791,  6361,  13,  12, UNI_JG__MALAYALAMTTA }   /* joininggroup=malayalamtta */,
  {     0,  8984,     0,   5,   0, UNI_QMARK }   /* qmark */,
  {     3, 10003,     3,   3,   1, -UNI_CI }   /* ci=f */,
  {     1,  3836,  3894,  18,  10, UNI_SGNW }   /* scriptextensions=signwriting */,
  {     0,  3424,  8316,   3,   7, UNI_INUGARITIC }   /* inugaritic */,
  {     0,   184,  2120,   3,  20, UNI_CJKRADICALSSUP }   /* iscjkradicalssupplement */,
  {   102,  8780,  6730,   6,  11, UNI_KATAKANAEXT }   /* block=katakanaext */,
  {     0,  9071,     0,   4,   0, UNI_hex_values_index }   /* hex= */,
  {     4,  9508,  8820,   4,   2, UNI_CCC__29 }   /* ccc=29 */,
  {     2,  4829,  2411,   4,   8, UNI_INGLAGOLITIC }   /* inglagolitic */,
  {     1,  8780,  3439,   6,  18, UNI_SMALLKANAEXT }   /* block=smallkanaextension */,
  {     0,  7318,  7979,  10,   3, UNI_IN__6 }   /* presentin=6.0 */,
  {     0,  3836,  2061,  17,   4, UNI_MODI }   /* scriptextensions=modi */,
  {    10,  9290,    26,   5,   1, UNI_MATH }   /* math=y */,
  {     1,  9444, 10093,   4,   3, UNI_AGE__4_DOT_1 }   /* age=v41 */,
  {    16,  7418,  1025,  10,   2, -UNI_XPOSIXUPPER }   /* uppercase=no */,
  {     0,  8780,   630,   7,  29, UNI_CJKEXTE }   /* block=cjkunifiedideographsextensione */,
  {    11, 10327,  7438,   6,   4, UNI_POSIXWORD }   /* isperlword */,
  {    10,   184,    38,   2,   2, UNI_XPOSIXDIGIT }   /* isnd */,
  {     1,  1188,  4929,   3,   4, UNI_INTAMIL }   /* intamil */,
  {     0,  9508,  3572,   4,   5, UNI_CCC__B }   /* ccc=below */,
  {     0,  5986,  9420,  13,   4, UNI_NV__3_SLASH_20 }   /* numericvalue=3/20 */,
  {    11, 10063,  1025,   3,   2, -UNI_SD }   /* sd=no */,
  {    36,  3853,  9836,  17,   4, UNI_STERM }   /* sentenceterminal=true */,
  {    17,  3870,     0,  17,   0, UNI_SMALLFORMS }   /* smallformvariants */,
  {     0,  4916,  5994,   3,   3, UNI_TALU }   /* istalu */,
  {     1,  5791,  5326,  13,  14, UNI_JG__MANICHAEANBETH }   /* joininggroup=manichaeanbeth */,
  {     3,  2280,  9311,   3,   4, UNI_OGAM }   /* isogham */,
  {     0,  1417,  9108,  24,   2, UNI_CCC__15 }   /* canonicalcombiningclass=15 */,
  {     0, 10048,  5648,   3,   7, UNI_NV__1000000 }   /* nv=1000000 */,
  {     1,  9488,  6730,   4,  11, UNI_KATAKANAEXT }   /* blk=katakanaext */,
  {     0,  8884,  1025,   4,   2, -UNI_EXT }   /* ext=no */,
  {     4,  6231,  3667,   3,  16, UNI_CYRILLICEXTC }   /* incyrillicextendedc */,
  {    54, 10009,  8533,   3,   7, UNI_DT__NB }   /* dt=nobreak */,
  {    13,  9768,  9888,   4,   4, UNI_ZANB }   /* scx=zanb */,
  {     0, 10296,  8576,   3,   5, UNI_PATSYN }   /* ispatsyn */,
  {    20,  4478,     0,   4,   0, UNI_BRAI }   /* brai */,
  {     0,  4033,  6265,  16,  12, UNI_NL }   /* generalcategory=letternumber */,
  {     1,  9488,  8365,   4,   7, UNI_CJKEXTC }   /* blk=cjkextc */,
  {     4,  7318,  7765,  10,   1, UNI_IN__2 }   /* presentin=2 */,
  {     0,  5116,    36,  14,   1, UNI_EMOD }   /* emojimodifier=t */,
  {     0,  2569,  3379,   4,   5, UNI_VERTSPACE }   /* vertspace */,
  {     0,  8996, 10135,   6,   3, UNI_STERM }   /* sterm=yes */,
  {     0,  5687,     0,  13,   0, UNI_BLOCKELEMENTS }   /* blockelements */,
  {     1,  9488,  8645,   4,   7, UNI_INTAITHAM }   /* blk=taitham */,
  {     2, 10303,     0,   5,   0, UNI_XPOSIXBLANK }   /* blank */,
  {     0,  8589,  9500,   7,   4, UNI_SC__CAKM }   /* script=cakm */,
  {     0,  8589,  9245,   7,   4, UNI_SC__DOGR }   /* script=dogr */,
  {     0,  5986,  8750,  13,   6, UNI_NV__800000 }   /* numericvalue=800000 */,
  {     0,  3904, 10135,  17,   3, UNI_UIDEO }   /* unifiedideograph=yes */,
  {     2,  3836,  3079,  17,   4, UNI_COPT }   /* scriptextensions=copt */,
  {     1,  9768,  6253,   4,   5, UNI_KHMR }   /* scx=khmer */,
  {     1,  8996,  1025,   6,   2, -UNI_STERM }   /* sterm=no */,
  {    64,  9768,  8990,   4,   6, UNI_RJNG }   /* scx=rejang */,
  {     1,  1188,  9331,   3,   4, UNI_INTAILE }   /* intaile */,
  {     5,  8780,  7278,   6,  10, UNI_INOLDPERSIAN }   /* block=oldpersian */,
  {     1,  8774,     3,   6,   1, -UNI_BIDIM }   /* bidim=f */,
  {     0,  4809,  1162,   4,   2, UNI_CPRT }   /* iscprt */,
  {     0,  9508,  8837,   4,   3, UNI_WB__EB }   /* ccc=133 */,
  {     8, 10033,  6193,   3,  12, UNI_LB__HL }   /* lb=hebrewletter */,
  {     1, 10048,  9428,   3,   3, UNI_NV__3_SLASH_8 }   /* nv=3/8 */,
  {     1,  8519,     0,   7,   0, UNI_nfkdqc_values_index }   /* nfkdqc= */,
  {     8,  9488,  7248,   4,  10, UNI_MISCARROWS }   /* blk=miscarrows */,
  {    32,   184,  4002,   3,  15, UNI_CYPRIOTSYLLABARY }   /* iscypriotsyllabary */,
  {     0,  1966,  5700,  22,  13, UNI_INSC__CONSONANTDEAD }   /* indicsyllabiccategory=consonantdead */,
  {     0,  1834,    36,  22,   1, UNI_CWT }   /* changeswhentitlecased=t */,
  {   121,  9277,  8091,   3,   8, UNI_ARMN }   /* sc=armenian */,
  {     6, 10048,  8727,   3,   2, UNI_NV__32 }   /* nv=32 */,
  {     0,  1505,  1016,   5,   2, UNI_INGREEK }   /* ingreek */,
  {     1,  3836,  4448,  17,   5, UNI_BAMU }   /* scriptextensions=bamum */,
  {     2,  9488,   113,   4,  35, UNI_DIACRITICALSFORSYMBOLS }   /* blk=combiningdiacriticalmarksforsymbols */,
  {     1,  8942,     0,   6,   0, UNI_LYDI }   /* lydian */,
  {     3,  9277,  9476,   3,   4, UNI_AVST }   /* sc=avst */,
  {     0,  7418,     1,  10,   1, -UNI_XPOSIXUPPER }   /* uppercase=n */,
  {     6,  9488,   719,   4,  16, UNI_CUNEIFORMNUMBERS }   /* blk=cuneiformnumbers */,
  {     0,  4853, 10135,  15,   3, UNI_DT__NONE }   /* nfkdquickcheck=yes */,
  {     0,  8589,  8666,   7,   7, UNI_SC__TIRH }   /* script=tirhuta */,
  {     4,   184,   328,   2,  21, UNI_MATHOPERATORS }   /* ismathematicaloperators */,
  {     1,   184,   600,   3,  29, UNI_CJKEXTD }   /* iscjkunifiedideographsextensiond */,
  {     0,  9488,  6193,   4,   6, UNI_INHEBREW }   /* blk=hebrew */,
  {     3,  8780,   720,   7,   8, UNI_INCUNEIFORM }   /* block=cuneiform */,
  {     9,  9508,  6631,   4,  11, UNI_CCC__DA }   /* ccc=doubleabove */,
  {     0,  4628,     3,  15,   1, UNI_EA__F }   /* eastasianwidth=f */,
  {     9,  9488,  1060,   4,  27, UNI_OCR }   /* blk=opticalcharacterrecognition */,
  {     0,  8589,  9440,   7,   4, UNI_SC__ADLM }   /* script=adlm */,
  {     9, 10296,  7309,   3,   9, UNI_PHNX }   /* isphoenician */,
  {     4,   184,  3853,   2,  16, UNI_STERM }   /* issentenceterminal */,
  {     9,  9277,  9496,   3,   4, UNI_SC__BUHD }   /* sc=buhd */,
  {    25, 10027,     0,   3,   0, UNI_jg_values_index }   /* jg= */,
  {     4,  3836,  6193,  17,   6, UNI_HEBR }   /* scriptextensions=hebrew */,
  {     0,  3097,  1417,  18,   9, UNI_DT__CAN }   /* decompositiontype=canonical */,
  {     1,  7076,  7514,   3,   8, UNI_INBHAIKSUKI }   /* inbhaiksuki */,
  {     3,  3836,  7359,  18,   3, UNI_SAUR }   /* scriptextensions=saur */,
  {     1,  3836,  9728,  17,   4, UNI_MIAO }   /* scriptextensions=plrd */,
  {     0,  3836,  8876,  17,   6, UNI_GOTH }   /* scriptextensions=gothic */,
  {     0,  1273,     3,  21,   1, -UNI_CE }   /* compositionexclusion=f */,
  {     5,  3836,  8547,  17,   7, UNI_OLCK }   /* scriptextensions=olchiki */,
  {     2,  9768,  4385,   4,   4, UNI_TANG }   /* scx=tang */,
  {     5,  9997,    25,   3,   1, UNI_BC__S }   /* bc=s */,
  {     0,  6229,    26,  12,   1, UNI_JOINC }   /* joincontrol=y */,
  {    61, 10048,  8051,   3,   8, UNI_NV__5_SLASH_6 }   /* nv=8.33e-01 */,
  {     7,  9014,  9255,   6,   5, -UNI_UIDEO }   /* uideo=false */,
  {    32,  9768,  7292,   5,   6, UNI_SOGD }   /* scx=sogdian */,
  {     2,  3151,    26,  18,   1, UNI_EPRES }   /* emojipresentation=y */,
  {     3,  8589,  8131,   7,   4, UNI_SC__DUPL }   /* script=dupl */,
  {     1,  7218,  2640,  10,   2, UNI_LB__BA }   /* linebreak=ba */,
  {     1,  8780,  5843,   6,   9, UNI_INMALAYALAM }   /* block=malayalam */,
  {    17,  4916,  8667,   3,   3, UNI_TIRH }   /* istirh */,
  {     0,  5324,   330,   4,  19, UNI_MATHOPERATORS }   /* inmathematicaloperators */,
  {     7,  1417,  8820,  24,   2, UNI_CCC__29 }   /* canonicalcombiningclass=29 */,
  {     7,  4916,  9833,   3,   3, UNI_TIBT }   /* istibt */,
  {     0,  9508,  8714,   4,   2, UNI_CCC__30 }   /* ccc=30 */,
  {     0,  9277,  8645,   3,   7, UNI_LANA }   /* sc=taitham */,
  {    17,  6229,  9255,  12,   5, -UNI_JOINC }   /* joincontrol=false */,
  {     2,  4033,  5438,  16,  14, UNI_SK }   /* generalcategory=modifiersymbol */,
  {     8,  7218, 10154,  10,   2, UNI_LB__B2 }   /* linebreak=b2 */,
  {     0,    47,     0,   1,   0, UNI_M }   /* m */,
  {     3, 10333,  9797,   3,   3, UNI_SYRC }   /* issyrc */,
  {     9,   184,  8211,   2,   8, UNI_JAMOEXTB }   /* isjamoextb */,
  {     1, 10168,     0,   2,   0, UNI_CASEDLETTER }   /* l& */,
  {     0,  9277,  9880,   3,   4, UNI_SC__YI }   /* sc=yiii */,
  {     0,  8589,  7657,   7,   9, UNI_SC__PERM }   /* script=oldpermic */,
  {     2,  9488,  2409,   4,  20, UNI_GLAGOLITICSUP }   /* blk=glagoliticsupplement */,
  {     1,   184,  7188,   2,  10, UNI_KHAR }   /* iskharoshthi */,
  {     4,   184,  9529,   3,   2, UNI_CWU }   /* iscwu */,
  {    71,  8147, 10135,   8,   3, UNI_EXTPICT }   /* extpict=yes */,
  {     6,  7325,  7923,   3,   3, UNI_IN__4 }   /* in=4.0 */,
  {     0,  1417,  9949,  24,   3, UNI_CCC__DA }   /* canonicalcombiningclass=234 */,
  {     5, 10291,  1823,   5,   5, UNI_POSIXLOWER }   /* posixlower */,
  {     0,  2224,  6973,   3,  10, UNI_INSYLOTINAGRI }   /* insylotinagri */,
  {     3,  7076,  4449,   3,   7, UNI_BAMUMSUP }   /* inbamumsup */,
  {    21,  9768,  9038,   4,   6, UNI_YEZI }   /* scx=yezidi */,
  {    22,  9476,     0,   4,   0, UNI_AVST }   /* avst */,
  {     0,  8780,  3223,   6,  18, UNI_INPUNCTUATION }   /* block=generalpunctuation */,
  {     6,  9488,  8428,   4,   7, UNI_INGRANTHA }   /* blk=grantha */,
  {     0,  7325,  7877,   3,   2, UNI_IN__13 }   /* in=13 */,
  {     2,  5578,     5,  15,   1, UNI_SB__SE }   /* sentencebreak=se */,
  {     3,  9508,  9188,   4,   2, UNI_CCC__31 }   /* ccc=31 */,
  {     7,  9488,  8358,   4,   7, UNI_CJKEXTB }   /* blk=cjkextb */,
  {     0,  9277,  9624,   3,   3, UNI_LAO }   /* sc=lao */,
  {     0,   184,  9548,   2,   4, UNI_DSRT }   /* isdsrt */,
  {    96,  7325, 10111,   3,   3, UNI_IN__6_DOT_2 }   /* in=v62 */,
  {    10,  9508,  8823,   5,   5, UNI_CCC__130 }   /* ccc=ccc130 */,
  {    32,  9488,  1561,   4,  24, UNI_SUPSYMBOLSANDPICTOGRAPHS }   /* blk=supsymbolsandpictographs */,
  {     0, 10340,    25,   3,   1, UNI_VS }   /* isvs */,
  {     0,  5032,    36,  14,   1, UNI_POSIXXDIGIT }   /* asciihexdigit=t */,
  {     0,  9524,  9836,   4,   4, UNI_CWT }   /* cwt=true */,
  {    19,  7438, 10015,  10,   3, UNI_WB__EB }   /* wordbreak=ebg */,
  {     5, 10048,  8059,   3,   8, UNI_NV__1_SLASH_12 }   /* nv=8.33e-02 */,
  {     4, 10290,  1823,   6,   5, UNI_XPOSIXLOWER }   /* xposixlower */,
  {     1,  5739,     3,  13,   1, -UNI_GRBASE }   /* graphemebase=f */,
  {     0,   184,  5242,   2,  14, UNI_LATINEXTC }   /* islatinextendedc */,
  {    48,  3379,     3,   6,   1, -UNI_XPOSIXSPACE }   /* space=f */,
  {     1, 10024,    38,   3,   2, UNI_XPOSIXDIGIT }   /* gc=nd */,
  {     0, 10027,  6346,   3,   3, UNI_JG__NYA }   /* jg=nya */,
  {     2,  2224,  8276,   3,   7, UNI_SPECIALS }   /* inspecials */,
  {     2,  8780,  7308,   6,  10, UNI_INPHOENICIAN }   /* block=phoenician */,
  {     3,  8780,  8337,   6,   7, UNI_INAVESTAN }   /* block=avestan */,
  {     0,  9488,  4401,   4,   9, UNI_TANGUTSUP }   /* blk=tangutsup */,
  {     9,  8780,  7098,   6,  10, UNI_BOXDRAWING }   /* block=boxdrawing */,
  {     0, 10048,  9168,   3,   2, UNI_NV__27 }   /* nv=27 */,
  {     6,  4916,  1846,   3,   4, UNI_TITLE }   /* istitle */,
  {     2,   184,  9896,   2,   4, UNI_ZYYY }   /* iszyyy */,
  {     1,   184,  3241,   2,  18, UNI_GEORGIANSUP }   /* isgeorgiansupplement */,
  {    18, 10048,  9188,   3,   2, UNI_NV__31 }   /* nv=31 */,
  {     0, 10033,  1751,   3,   2, UNI_LB__AI }   /* lb=ai */,
  {     0, 10048,  8744,   3,   5, UNI_NV__70000 }   /* nv=70000 */,
  {     2, 10012,     1,   3,   1, UNI_EA__N }   /* ea=n */,
  {     0,  1269,    36,  25,   1, UNI_COMPEX }   /* fullcompositionexclusion=t */,
  {     0,  3836,  9789,  18,   3, UNI_SHRD }   /* scriptextensions=shrd */,
  {    32,  9540,    26,   4,   1, UNI_DIA }   /* dia=y */,
  {    27,  1552,     0,   9,   0, UNI_gc_values_index }   /* category= */,
  {     0,  9488,  5947,   4,  13, UNI_MAYANNUMERALS }   /* blk=mayannumerals */,
  {     1,  7438,  1218,  10,   8, UNI_WB__KA }   /* wordbreak=katakana */,
  {     0,  2329,     0,  20,   0, UNI_HLUW }   /* anatolianhieroglyphs */,
  {     1, 10027,  5312,   3,  14, UNI_JG__MANICHAEANAYIN }   /* jg=manichaeanayin */,
  {     0,  7318,  7469,  10,   3, UNI_IN__5 }   /* presentin=5.0 */,
  {     0,  1417,  8829,  25,   5, UNI_CCC__132 }   /* canonicalcombiningclass=ccc132 */,
  {    26,  3097,    68,  18,   3, UNI_DT__SUP }   /* decompositiontype=sup */,
  {    20,  9240,    36,   5,   1, UNI_DASH }   /* dash=t */,
  {    11,  8780,   600,   7,  29, UNI_CJKEXTD }   /* block=cjkunifiedideographsextensiond */,
  {     1,  8780,  9656,   6,   4, UNI_INMIAO }   /* block=miao */,
  {    20,  9997, 10039,   3,   3, UNI_BC__LRI }   /* bc=lri */,
  {     0,  7325, 10114,   3,   3, UNI_IN__6_DOT_3 }   /* in=v63 */,
  {     6,  5986,  9376,  13,   3, UNI_NV__1_SLASH_6 }   /* numericvalue=1/6 */,
  {     0,   184,  9688,   2,   4, UNI_NKO }   /* isnkoo */,
  {     0,  8780,  9245,   6,   5, UNI_INDOGRA }   /* block=dogra */,
  {     5,  1417,  7826,  24,   2, UNI_CCC__12 }   /* canonicalcombiningclass=12 */,
  {     1,  8589,  9724,   7,   4, UNI_PHNX }   /* script=phnx */,
  {     0,  5791,  7711,  13,   9, UNI_JG__SYRIACWAW }   /* joininggroup=syriacwaw */,
  {     0,    58,     0,   4,   0, UNI_IDEO }   /* ideo */,
  {     2,  8780,  9860,   6,   3, UNI_INVAI }   /* block=vai */,
  {     1,  9508,  5765,   4,  13, UNI_CCC__IS }   /* ccc=iotasubscript */,
  {     0,  9768,  7694,   5,   8, UNI_SAMR }   /* scx=samaritan */,
  {     0,  9277,  2684,   3,  19, UNI_EGYP }   /* sc=egyptianhieroglyphs */,
  {     2,  5324,  6399,   4,  10, UNI_MATHALPHANUM }   /* inmathalphanum */,
  {     0,  2784,    29,   4,   4, UNI_INARABIC }   /* inarabic */,
  {     0,  2608,     0,   4,   0, UNI_BRAH }   /* brah */,
  {     0,  4658, 10135,  15,   3, UNI_GREXT }   /* graphemeextend=yes */,
  {     5,  9488,  5843,   4,   9, UNI_INMALAYALAM }   /* blk=malayalam */,
  {     6,  1417,  7178,  24,  10, UNI_CCC__6 }   /* canonicalcombiningclass=hanreading */,
  {     0,  4643,  9836,  15,   4, UNI_ECOMP }   /* emojicomponent=true */,
  {     2, 10033,  4842,   3,   2, UNI_LB__QU }   /* lb=qu */,
  {     0,  9768,  7630,   4,   9, UNI_TALU }   /* scx=newtailue */,
  {     0,  9508,  8825,   4,   3, UNI_CCC__130 }   /* ccc=130 */,
  {     0,  9488,   895,   4,  28, UNI_SUPPUAA }   /* blk=supplementaryprivateuseareaa */,
  {     5,  3836,  9876,  17,   4, UNI_XSUX }   /* scriptextensions=xsux */,
  {     1,   184,  9095,   2,   5, UNI_BUHD }   /* isbuhid */,
  {     0,  9277,   859,   4,   3, UNI_SC__KNDA }   /* sc=knda */,
  {     0,  5324,  6279,   4,   5, UNI_MAHJONG }   /* inmahjong */,
  {     0,  4553,     0,  15,   0, UNI_CONTROLPICTURES }   /* controlpictures */,
  {     0,  5986,  9904,  13,   3, UNI_NV__1_SLASH_5 }   /* numericvalue=1/5 */,
  {     2,  3424,  8674,   3,   6, UNI_UCASEXT }   /* inucasext */,
  {     5,  8589,  9624,   7,   3, UNI_LAO }   /* script=lao */,
  {    17,  8589,  8421,   7,   7, UNI_ELYM }   /* script=elymaic */,
  {     1,   184,  3633,   3,  16, UNI_CYRILLICEXTA }   /* iscyrillicextendeda */,
  {     7,  8589,  9616,   7,   4, UNI_SC__KTHI }   /* script=kthi */,
  {     0,  9488,  6818,   4,  11, UNI_MYANMAREXTA }   /* blk=myanmarexta */,
  {    10,  1834,  9255,  22,   5, -UNI_CWT }   /* changeswhentitlecased=false */,
  {     1,  1828,  9836,   6,   4, UNI_CASED }   /* cased=true */,
  {     0,  9444,  7827,   4,   3, UNI_AGE__2 }   /* age=2.0 */,
  {     0,  9277,   493,   3,   3, UNI_SC__HAN }   /* sc=han */,
  {   194,   184,  2245,   2,  14, UNI_MEETEIMAYEKEXT }   /* ismeeteimayekext */,
  {     0,  1552,    48,   9,   1, UNI_P }   /* category=p */,
  {     1,  9768,  3115,   4,   4, UNI_DEVA }   /* scx=deva */,
  {     0, 10333,    44,   3,   1, UNI_SK }   /* issk */,
  {     0,  7218,  8236,  11,   7, UNI_LB__LF }   /* linebreak=linefeed */,
  {     1,  9277,  7693,   3,   9, UNI_SAMR }   /* sc=samaritan */,
  {    18,  5986,  7755,  13,   8, UNI_NV__1_SLASH_9 }   /* numericvalue=1.11e-01 */,
  {     7,   184,  4049,   2,  11, UNI_GEORGIANEXT }   /* isgeorgianext */,
  {     2,  8960,  9295,   6,   5, UNI_NFCQC__M }   /* nfcqc=maybe */,
  {     4,  9014,  9836,   6,   4, UNI_UIDEO }   /* uideo=true */,
  {    16, 10048,  7890,   3,   2, UNI_NV__33 }   /* nv=33 */,
  {     0,  8589,  5171,   7,   4, UNI_CHAM }   /* script=cham */,
  {     3,  5791,  4763,  13,  15, UNI_JG__MANICHAEANSADHE }   /* joininggroup=manichaeansadhe */,
  {     0, 10048,  8714,   3,   6, UNI_NV__300000 }   /* nv=300000 */,
  {     1,  9277,  9732,   3,   4, UNI_PRTI }   /* sc=prti */,
  {     1,  8780,  5075,   7,  13, UNI_CJKCOMPATFORMS }   /* block=cjkcompatforms */,
  {    20,   184,   690,   3,  29, UNI_CJKEXTG }   /* iscjkunifiedideographsextensiong */,
  {     1,   184,  5522,   2,  14, UNI_PHONETICEXTSUP }   /* isphoneticextsup */,
  {    34,  7248,     0,  10,   0, UNI_MISCARROWS }   /* miscarrows */,
  {     3,  1966,  8687,  22,   7, UNI_INSC__VISARGA }   /* indicsyllabiccategory=visarga */,
  {    17,  9508,  8835,   5,   5, UNI_WB__EB }   /* ccc=ccc133 */,
  {     9,  9283,     0,   4,   0, UNI_PHLI }   /* phli */,
  {     0,  9624,     0,   4,   0, UNI_LAO }   /* laoo */,
  {     6, 10333,  7359,   3,   3, UNI_SAUR }   /* issaur */,
  {     0,  6469,   495,  12,   7, UNI_NT__NU }   /* numerictype=numeric */,
  {     1,   184,   727,   2,   2, UNI_MN }   /* ismn */,
  {    51, 10033,    58,   3,   2, UNI_LB__ID }   /* lb=id */,
  {     1,  9488,  9624,   4,   3, UNI_INLAO }   /* blk=lao */,
  {     1,  1988,     3,  22,   1, -UNI_LOE }   /* logicalorderexception=f */,
  {     0,  1513,     0,  24,   0, UNI_HIGHPUSURROGATES }   /* highprivateusesurrogates */,
  {     8,  1552,  1025,   9,   2, UNI_NO }   /* category=no */,
  {     1,  9768,  8428,   4,   7, UNI_GRAN }   /* scx=grantha */,
  {     1, 10048,  8075,   3,   8, UNI_NV__7_SLASH_8 }   /* nv=8.75e-01 */,
  {     0,  8780,  7621,   6,   9, UNI_INNABATAEAN }   /* block=nabataean */,
  {     0,   184,  1274,   3,  19, UNI_CE }   /* iscompositionexclusion */,
  {     0,  5791,  1511,  13,   3, UNI_JG__HAH }   /* joininggroup=hah */,
  {     0,  9277,  9808,   3,   4, UNI_TALU }   /* sc=talu */,
  {     2,  4033,  1059,  16,   2, UNI_SO }   /* generalcategory=so */,
  {    17,  6554,  9836,  11,   4, UNI_IDC }   /* idcontinue=true */,
  {     3,  3836,  4883,  17,  15, UNI_SARB }   /* scriptextensions=oldsoutharabian */,
  {     8,   184,  2122,   2,   7, UNI_RADICAL }   /* isradical */,
  {     1,  7325,  7826,   3,   2, UNI_IN__12 }   /* in=12 */,
  {    17,  7158, 10135,  10,   3, UNI_DIA }   /* diacritic=yes */,
  {     1,  8589,  7168,   7,  10, UNI_DIAK }   /* script=divesakuru */,
  {     0,  9330,     0,   5,   0, UNI_TALE }   /* taile */,
  {     1,  1417,  8066,  24,   2, UNI_CCC__28 }   /* canonicalcombiningclass=28 */,
  {     0, 10296,  7438,   7,   4, UNI_POSIXWORD }   /* isposixword */,
  {     2,   184,  1033,   2,  11, UNI_ENCLOSEDCJK }   /* isenclosedcjk */,
  {    34,  7368,     0,  10,   0, UNI_SMALLFORMS }   /* smallforms */,
  {     4,   184,  9900,   2,   4, UNI_ZZZZ }   /* iszzzz */,
  {     3, 10027,  4748,   3,  15, UNI_JG__MANICHAEANGIMEL }   /* jg=manichaeangimel */,
  {     9,  3836,  6409,  17,   4, UNI_MEND }   /* scriptextensions=mend */,
  {     0, 10012,     8,   3,   1, UNI_EA__A }   /* ea=a */,
  {     0,  1834,  1025,  22,   2, -UNI_CWT }   /* changeswhentitlecased=no */,
  {     2,  7155,  4674,   3,  14, UNI_INHANGUL }   /* ishangulsyllables */,
  {   128, 10033,  3985,   3,  16, UNI_LB__CL }   /* lb=closepunctuation */,
  {     7, 10132,   495,   3,   7, UNI_WB__NU }   /* wb=numeric */,
  {     0,     1,     0,   1,   0, UNI_N }   /* n */,
  {   131,  5986,  8710,  13,   3, UNI_NV__600 }   /* numericvalue=600 */,
  {     0,  9768,  6193,   4,   6, UNI_HEBR }   /* scx=hebrew */,
  {     1,  1115,     0,   4,   0, UNI_HANG }   /* hang */,
  {     0,  1417,  9121,  25,   4, UNI_CCC__18 }   /* canonicalcombiningclass=ccc18 */,
  {     0,  7325,  7931,   3,   3, UNI_IN__4_DOT_1 }   /* in=4.1 */,
  {     0,  9277,  8610,   3,   4, UNI_SIDD }   /* sc=sidd */,
  {     0,   184,  3115,   2,  18, UNI_DEVANAGARIEXT }   /* isdevanagariextended */,
  {     2,  9277,  2240,   4,   3, UNI_SC__KTHI }   /* sc=kthi */,
  {     0,  5986,  7891,  13,   8, UNI_NV__1_SLASH_3 }   /* numericvalue=3.33e-01 */,
  {     0,  7218,  8251,  10,   8, UNI_LB__NL }   /* linebreak=nextline */,
  {     3,  9768,  9896,   4,   4, UNI_ZYYY }   /* scx=zyyy */,
  {     0,  7218,  6217,  10,  12, UNI_LB__IS }   /* linebreak=infixnumeric */,
  {     4,  9277,  9756,   3,   4, UNI_RUNR }   /* sc=runr */,
  {     8,  9488,  9008,   4,   6, UNI_INTHAANA }   /* blk=thaana */,
  {     0,  6409,     0,  12,   0, UNI_MEND }   /* mendekikakui */,
  {     0,  4305,     0,   5,   0, UNI_C }   /* other */,
  {     0,  7325,  8043,   3,   3, UNI_IN__8 }   /* in=8.0 */,
  {     1,  9277,  9480,   3,   4, UNI_BATK }   /* sc=batk */,
  {     0,  8589,  9608,   7,   4, UNI_KITS }   /* script=kits */,
  {     3,  3785,     0,   4,   0, UNI_MANI }   /* mani */,
  {     0,  9660,     0,   4,   0, UNI_MLYM }   /* mlym */,
  {     9,  6061,    36,  12,   1, UNI_BIDIC }   /* bidicontrol=t */,
  {     1,  9652,     0,   4,   0, UNI_MERC }   /* merc */,
  {     0, 10024,  4568,   3,  14, UNI_SC }   /* gc=currencysymbol */,
  {   168,  1856,  1025,  22,   2, -UNI_CWU }   /* changeswhenuppercased=no */,
  {     0,  9488,  2203,   4,  14, UNI_INHANIFIROHINGYA }   /* blk=hanifirohingya */,
  {     2,   184,  8435,   2,   6, UNI_GRBASE }   /* isgrbase */,
  {     4,  8688,  5033,   3,   4, UNI_ASCII }   /* isascii */,
  {     9,  9768,  4478,   4,   7, UNI_BRAI }   /* scx=braille */,
  {     0,  9768,  8547,   4,   7, UNI_OLCK }   /* scx=olchiki */,
  {     4,  7648,     0,   9,   0, UNI_ITAL }   /* olditalic */,
  {     0,  9277,  8942,   3,   4, UNI_LYDI }   /* sc=lydi */,
  {    19,  1552,  4245,   9,  10, UNI_SM }   /* category=mathsymbol */,
  {     0,  8589,  8547,   7,   7, UNI_OLCK }   /* script=olchiki */,
  {     1, 10132,  6917,   3,  11, UNI_WB__SQ }   /* wb=singlequote */,
  {     1,  8780,  8936,   6,   6, UNI_INLYCIAN }   /* block=lycian */,
  {     1,  9488,  4257,   4,  16, UNI_MISCMATHSYMBOLSB }   /* blk=miscmathsymbolsb */,
  {     3,  4033,  4305,  16,   5, UNI_C }   /* generalcategory=other */,
  {     0,  8780,  9065,   6,   5, UNI_INADLAM }   /* block=adlam */,
  {     0,  8780,  9340,   6,   5, UNI_VSSUP }   /* block=vssup */,
  {     0, 10236, 10220,  14,  11, UNI__PERL_FOLDS_TO_MULTI_CHAR }   /* _perl_folds_to_multi_char */,
  {     1,  3836,  4385,  17,   4, UNI_TANG }   /* scriptextensions=tang */,
  {     2, 10048,  8002,   3,   2, UNI_NV__26 }   /* nv=26 */,
  {     1,  6884,     0,  11,   0, UNI_HMNG }   /* pahawhhmong */,
  {    10,  2288,  2076,   4,   4, UNI_INHATRAN }   /* inhatran */,
  {    32,   184,  5200,   2,  14, UNI_KANASUP }   /* iskanasupplement */,
  {    33,  3097,    45,  18,   6, UNI_DT__COM }   /* decompositiontype=compat */,
  {     0,  7218,  3969,  10,  16, UNI_LB__CP }   /* linebreak=closeparenthesis */,
  {    16,  7318,  9967,  10,   3, UNI_IN__5_DOT_1 }   /* presentin=5.1 */,
  {     0,  2032,  9255,  22,   5, -UNI__PERL_NCHAR }   /* noncharactercodepoint=false */,
  {     9,  1417,  7877,  24,   2, UNI_CCC__13 }   /* canonicalcombiningclass=13 */,
  {    11,  9997,   865,   3,   2, UNI_BC__WS }   /* bc=ws */,
  {     1,   184,  5713,   2,  13, UNI_XPOSIXDIGIT }   /* isdecimalnumber */,
  {     4,  3836,  3115,  17,   4, UNI_DEVA }   /* scriptextensions=deva */,
  {     0,  8780,  2120,   7,  13, UNI_CJKRADICALSSUP }   /* block=cjkradicalssup */,
  {    38,  9488,  3341,   4,   8, UNI_DINGBATS }   /* blk=dingbats */,
  {     0,  5158,     0,  14,   0, UNI_INGREEK }   /* greekandcoptic */,
  {     0,  3079,     0,   4,   0, UNI_COPT }   /* copt */,
  {     0,  8589,  9032,   7,   6, UNI_WCHO }   /* script=wancho */,
  {     0,  9277,  5171,   3,   4, UNI_CHAM }   /* sc=cham */,
  {     0,  9277,  9724,   3,   4, UNI_PHNX }   /* sc=phnx */,
  {     0,  9860,     0,   3,   0, UNI_VAI }   /* vai */,
  {     4,   184,  7248,   2,  10, UNI_MISCARROWS }   /* ismiscarrows */,
  {    68,  7738, 10135,   9,   3, UNI_XIDS }   /* xidstart=yes */,
  {    21,   184,   567,   2,   2, UNI_NB }   /* isnb */,
  {     8,  1417,  9216,  25,   4, UNI_CCC__84 }   /* canonicalcombiningclass=ccc84 */,
  {     0,    21,  3421,   2,   4, UNI_RUMI }   /* inrumi */,
  {     0,  4448,     0,   5,   0, UNI_BAMU }   /* bamum */,
  {     1,  8589,  9460,   7,   4, UNI_ARMI }   /* script=armi */,
  {     0,  7325,  7821,   3,   1, UNI_IN__8 }   /* in=8 */,
  {     4,  9768,  4448,   4,   4, UNI_BAMU }   /* scx=bamu */,
  {    16,  9488,  6012,   4,  13, UNI_VERTICALFORMS }   /* blk=verticalforms */,
  {    34,  8589,  9728,   7,   4, UNI_MIAO }   /* script=plrd */,
  {     0,  9444,  9397,   4,   3, UNI_AGE__2_DOT_1 }   /* age=2.1 */,
  {     0,   719,     0,  30,   0, UNI_CUNEIFORMNUMBERS }   /* cuneiformnumbersandpunctuation */,
  {     0,  9768,  3169,   4,   4, UNI_ETHI }   /* scx=ethi */,
  {     0,  8780,  2010,   6,  22, UNI_MISCTECHNICAL }   /* block=miscellaneoustechnical */,
  {     0, 10126,     0,   3,   0, UNI_vo_values_index }   /* vo= */,
  {     7,  1988,  9836,  22,   4, UNI_LOE }   /* logicalorderexception=true */,
  {     2,  8589,    57,   7,   2, UNI_SC__YI }   /* script=yi */,
  {     0,  8400,  1025,   7,   2, -UNI_COMPEX }   /* compex=no */,
  {     1,  3836,  8666,  17,   4, UNI_TIRH }   /* scriptextensions=tirh */,
  {     1, 10060,     0,   3,   0, UNI_ri_values_index }   /* ri= */,
  {     1,  8449,     0,   7,   0, UNI_hyphen_values_index }   /* hyphen= */,
  {     0,  9488,  6829,   4,  11, UNI_MYANMAREXTB }   /* blk=myanmarextb */,
  {     0,  5578,  8554,  14,   7, UNI_SB__LE }   /* sentencebreak=oletter */,
  {    50,  6231,  3633,   3,  16, UNI_CYRILLICEXTA }   /* incyrillicextendeda */,
  {     4, 10033, 10174,   3,   2, UNI_LB__XX }   /* lb=xx */,
  {     0,   184,  9236,   3,   3, UNI_CWCM }   /* iscwcm */,
  {     1,  3836,  8414,  17,   4, UNI_ELBA }   /* scriptextensions=elba */,
  {     0,   184,  6277,   2,   7, UNI_MAHJONG }   /* ismahjong */,
  {     0,  5791,  6906,  13,  11, UNI_JG__ROHINGYAYEH }   /* joininggroup=rohingyayeh */,
  {     0,    11,     0,   3,   0, UNI_DIA }   /* dia */,
  {     1,  9488,  3547,   4,  10, UNI_ALCHEMICAL }   /* blk=alchemical */,
  {     0, 10060,  1025,   3,   2, -UNI_RI }   /* ri=no */,
  {    23,  8954,  9255,   6,   5, -UNI__PERL_NCHAR }   /* nchar=false */,
  {    11,  7738,    36,   9,   1, UNI_XIDS }   /* xidstart=t */,
  {    16,  1628,     0,   4,   0, UNI_PHAG }   /* phag */,
  {     0,  9488,  8351,   4,   7, UNI_CJKEXTA }   /* blk=cjkexta */,
  {     5,  4916,  9825,   3,   3, UNI_TGLG }   /* istglg */,
  {     2,  1417,  8835,  25,   5, UNI_WB__EB }   /* canonicalcombiningclass=ccc133 */,
  {     1,   184,  3650,   3,  16, UNI_CYRILLICEXTB }   /* iscyrillicextendedb */,
  {     7,  5986,  9372,  13,   3, UNI_NV__1_SLASH_4 }   /* numericvalue=1/4 */,
  {     1, 10033,  6178,   3,   2, UNI_LB__ZW }   /* lb=zw */,
  {    79,  1591,  3684,   3,  15, UNI_ETHIOPICEXT }   /* inethiopicextended */,
  {     0,  8780,  4673,   6,  15, UNI_INHANGUL }   /* block=hangulsyllables */,
  {     0,  4116,  2780,   3,   3, UNI_IDST }   /* isidst */,
  {     0,  8780,  3169,   6,  18, UNI_ETHIOPICSUP }   /* block=ethiopicsupplement */,
  {   195,  7325,  9991,   3,   3, UNI_IN__9 }   /* in=9.0 */,
  {     1,  1537,  2549,  24,  20, UNI_INPC__TOPANDBOTTOMANDRIGHT }   /* indicpositionalcategory=topandbottomandright */,
  {     2,  8589,  8888,   7,   4, UNI_HATR }   /* script=hatr */,
  {    24,  9225,     0,   5,   0, UNI_XPOSIXCNTRL }   /* cntrl */,
  {    17,  9768,  9568,   4,   4, UNI_GREK }   /* scx=grek */,
  {     0,  9290,     0,   5,   0, UNI_math_values_index }   /* math= */,
  {     0,  7218,    73,  10,   2, UNI_EMOD }   /* linebreak=em */,
  {     0, 10333,  8597,   3,   6, UNI_SHRD }   /* issharada */,
  {     1, 10129,  1025,   3,   2, -UNI_VS }   /* vs=no */,
  {     0,   184,   660,   3,  29, UNI_CJKEXTF }   /* iscjkunifiedideographsextensionf */,
  {    21,  9488,  6133,   4,  12, UNI_ETHIOPICEXTA }   /* blk=ethiopicexta */,
  {     0,  9768,  9038,   4,   4, UNI_YEZI }   /* scx=yezi */,
  {     0,  5791,   341,  13,   2, UNI_JG__PE }   /* joininggroup=pe */,
  {     3,  9346,     3,   4,   1, -UNI_IDC }   /* idc=f */,
  {     1,  9508,  8829,   5,   5, UNI_CCC__132 }   /* ccc=ccc132 */,
  {     8,  2032,     1,  22,   1, -UNI__PERL_NCHAR }   /* noncharactercodepoint=n */,
  {     0,  8780,  4129,   6,   9, UNI_LATIN1 }   /* block=latin1sup */,
  {     0,   184,    11,   2,   2, UNI_DI }   /* isdi */,
  {     5,  9230,  1025,   5,   2, -UNI_CWCF }   /* cwcf=no */,
  {     1, 10063, 10135,   3,   3, UNI_SD }   /* sd=yes */,
  {     3,  5986,  8059,  13,   8, UNI_NV__1_SLASH_12 }   /* numericvalue=8.33e-02 */,
  {    17, 10009,    68,   3,   3, UNI_DT__SUP }   /* dt=sup */,
  {    12,  9528, 10135,   4,   3, UNI_CWU }   /* cwu=yes */,
  {     0,  7318, 10093,  10,   3, UNI_IN__4_DOT_1 }   /* presentin=v41 */,
  {    11,   184,  5228,   2,  14, UNI_LATINEXTB }   /* islatinextendedb */,
  {    32,    62,     0,   5,   0, UNI_XPOSIXGRAPH }   /* graph */,
  {    49,  3836,  8299,  17,   8, UNI_TFNG }   /* scriptextensions=tifinagh */,
  {    11,  9277,  9688,   3,   4, UNI_NKO }   /* sc=nkoo */,
  {     0,   184,  4273,   2,  16, UNI_MYANMAREXTA }   /* ismyanmarextendeda */,
  {     1, 10060,    26,   3,   1, UNI_RI }   /* ri=y */,
  {    19, 10310,  8661,   4,   5, UNI_INTIBETAN }   /* intibetan */,
  {     8,  9768,  2608,   4,   4, UNI_BRAH }   /* scx=brah */,
  {     0,  2288,  2743,   4,  17, UNI_JAMOEXTB }   /* inhanguljamoextendedb */,
  {     0,  8509,  1035,   4,   9, UNI_ENCLOSEDCJK }   /* inenclosedcjk */,
  {     0,  1273,  1025,  21,   2, -UNI_CE }   /* compositionexclusion=no */,
  {     0,  8894,  9836,   6,   4, UNI_JOINC }   /* joinc=true */,
  {     1,  9488,  7567,   4,   9, UNI_INKHUDAWADI }   /* blk=khudawadi */,
  {     6,  9556,  5585,   4,   2, UNI_WB__EB }   /* gcb=eb */,
  {     1,  3836,  2469,  17,  20, UNI_HMNP }   /* scriptextensions=nyiakengpuachuehmong */,
  {     0,  9768,  9892,   4,   4, UNI_QAAI }   /* scx=zinh */,
  {     1,  9444,  9844,   4,   4, UNI_AGE__11 }   /* age=v110 */,
  {     5,  9768,  4793,   4,  15, UNI_MERC }   /* scx=meroiticcursive */,
  {    16,  9275,  7328,   5,  10, UNI_INSC__PUREKILLER }   /* insc=purekiller */,
  {     2,  9488,  3547,   4,  17, UNI_ALCHEMICAL }   /* blk=alchemicalsymbols */,
  {     0,  9071,  1025,   4,   2, -UNI_XPOSIXXDIGIT }   /* hex=no */,
  {     1,  9277,  9696,   3,   4, UNI_OGAM }   /* sc=ogam */,
  {     2,  9768,  2684,   4,  19, UNI_EGYP }   /* scx=egyptianhieroglyphs */,
  {     3,  9536, 10135,   4,   3, UNI_DEP }   /* dep=yes */,
  {     7,  6554,     0,  11,   0, UNI_idc_values_index }   /* idcontinue= */,
  {     1,  7438,  5585,  10,   2, UNI_WB__EB }   /* wordbreak=eb */,
  {     3,  9768,  9820,   4,   4, UNI_TFNG }   /* scx=tfng */,
  {     0,  4033,   406,  16,   7, UNI_XPOSIXCNTRL }   /* generalcategory=control */,
  {     0,  8984,     3,   6,   1, -UNI_QMARK }   /* qmark=f */,
  {     0,  9768,  9335,   4,   5, UNI_TAKR }   /* scx=takri */,
  {    16,  8147,     0,   7,   0, UNI_EXTPICT }   /* extpict */,
  {    44,  4688,  1166,  15,  16, UNI_IDENTIFIERTYPE__DEFAULTIGNORABLE }   /* identifiertype=defaultignorable */,
  {     0,  8780,  9624,   6,   3, UNI_INLAO }   /* block=lao */,
  {    24, 10027,  5944,   3,   3, UNI_JG__WAW }   /* jg=waw */,
  {     1,  3836,  8840,  17,   6, UNI_CAKM }   /* scriptextensions=chakma */,
  {     2,  8519,     0,   8,   0, UNI_NFKDQC__N }   /* nfkdqc=n */,
  {     2,  2182,  8139,  21,   8, UNI_WB__EB }   /* graphemeclusterbreak=ebasegaz */,
  {     5, 10024,    74,   3,   2, UNI_ME }   /* gc=me */,
  {     1,  9520,     1,   4,   1, -UNI_CWL }   /* cwl=n */,
  {    21, 10048,  8738,   3,   5, UNI_NV__60000 }   /* nv=60000 */,
  {     3, 10063,    36,   3,   1, UNI_SD }   /* sd=t */,
  {     0,   184,  1013,   2,   5, UNI_GREK }   /* isgreek */,
  {     2,  9240, 10135,   5,   3, UNI_DASH }   /* dash=yes */,
  {    14,  9768,  9832,   4,   4, UNI_TIBT }   /* scx=tibt */,
  {     0,  8780,   979,   6,  27, UNI_ALPHABETICPF }   /* block=alphabeticpresentationforms */,
  {     2,  8780,  3295,   6,  18, UNI_LATINEXTADDITIONAL }   /* block=latinextadditional */,
  {     0,   184,   779,   2,  30, UNI_SYMBOLSANDPICTOGRAPHSEXTA }   /* issymbolsandpictographsextendeda */,
  {     0,  9488,  6961,   4,  11, UNI_SUPERANDSUB }   /* blk=superandsub */,
  {     1,  9350,     3,   5,   1, -UNI_XIDS }   /* xids=f */,
  {     2,  8589,  8243,   7,   8, UNI_SC__MAHJ }   /* script=mahajani */,
  {     0,  2409,     0,   4,   0, UNI_GLAG }   /* glag */,
  {     0,  5986,  8051,  13,   8, UNI_NV__5_SLASH_6 }   /* numericvalue=8.33e-01 */,
  {     0,  1552, 10176,   9,   2, UNI_ZL }   /* category=zl */,
  {     4,  3133,    26,  18,   1, UNI_EBASE }   /* emojimodifierbase=y */,
  {     1,  7325, 10105,   3,   3, UNI_IN__6 }   /* in=v60 */,
  {     0, 10048,  8720,   3,   4, UNI_NV__4000 }   /* nv=4000 */,
  {     1,  1417,  9126,  25,   4, UNI_CCC__19 }   /* canonicalcombiningclass=ccc19 */,
  {    43,  3836,  9305,  17,   5, UNI_NSHU }   /* scriptextensions=nushu */,
  {     0, 10027,  6325,   3,  12, UNI_JG__MALAYALAMNNA }   /* jg=malayalamnna */,
  {     1,  9508,  8010,   4,   2, UNI_CCC__36 }   /* ccc=36 */,
  {     0,  8780,  2722,   6,  10, UNI_JAMO }   /* block=hanguljamo */,
  {     1,  6808,     0,   4,   0, UNI__PERL_SURROGATE }   /* iscs */,
  {     0,    42,     0,  16,   0, UNI_CJKCOMPAT }   /* cjkcompatibility */,
  {    14,  8589,  6796,   7,  11, UNI_MEDF }   /* script=medefaidrin */,
  {     1,  5508,     0,  14,   0, UNI_patsyn_values_index }   /* patternsyntax= */,
  {     0, 10288,  1867,   8,   5, UNI_XPOSIXUPPER }   /* isxposixupper */,
  {     3,  8589,  7567,   7,   9, UNI_SC__SIND }   /* script=khudawadi */,
  {     0,  7325, 10075,   3,   3, UNI_IN__2 }   /* in=v20 */,
  {    24,  9604,     0,   4,   0, UNI_KHMR }   /* khmr */,
  {     1,  8780,     0,   6,  42, UNI_UCASEXT }   /* block=unifiedcanadianaboriginalsyllabicsextended */,
  {     1,  1537,    61,   3,   4, UNI_INDOGRA }   /* indogra */,
  {    38, 10027,  6565,   3,  11, UNI_JG__AFRICANNOON }   /* jg=africannoon */,
  {     1,   184,  9285,   2,   4, UNI_LIMB }   /* islimb */,
  {     3,  5466,     0,  16,   0, UNI_DT__CAN }   /* nfdquickcheck=no */,
  {     0,  7438,  6145,  10,  12, UNI_WB__EX }   /* wordbreak=extendnumlet */,
  {     7,  1790, 10135,  22,   3, UNI_CWCM }   /* changeswhencasemapped=yes */,
  {     1,  8421,     0,   4,   0, UNI_ELYM }   /* elym */,
  {     0,  9488,  4001,   4,  16, UNI_CYPRIOTSYLLABARY }   /* blk=cypriotsyllabary */,
  {     1,  3836,  8179,  17,   8, UNI_GURU }   /* scriptextensions=gurmukhi */,
  {     3, 10006,  9255,   3,   5, -UNI_DI }   /* di=false */,
  {     4,  9277,  8187,   3,   8, UNI_SC__HIRA }   /* sc=hiragana */,
  {     1, 10009,    45,   3,   3, UNI_DT__COM }   /* dt=com */,
  {     1,  6598,     0,  11,   0, UNI_CASEDLETTER }   /* casedletter */,
  {     1,  9351,     0,   4,   0, UNI_ids_values_index }   /* ids= */,
  {     0,  2950,     0,  19,   0, UNI_SUPARROWSB }   /* supplementalarrowsb */,
  {     0,  2784,  8093,   4,   6, UNI_INARMENIAN }   /* inarmenian */,
  {    16,  9768,  8115,   4,   8, UNI_BASS }   /* scx=bassavah */,
  {     8,  8610,     0,   4,   0, UNI_SIDD }   /* sidd */,
  {     2,  5032,  1025,  14,   2, -UNI_POSIXXDIGIT }   /* asciihexdigit=no */,
  {     1,  8780,   660,   7,  29, UNI_CJKEXTF }   /* block=cjkunifiedideographsextensionf */,
  {    35,  8589,  8171,   7,   8, UNI_SC__GUJR }   /* script=gujarati */,
  {     5,   184,  8912,   2,   6, UNI_KHOJ }   /* iskhojki */,
  {     0,  3836,  9708,  17,   4, UNI_ORYA }   /* scriptextensions=orya */,
  {     7,  7325,  7950,   3,   1, UNI_IN__9 }   /* in=9 */,
  {     0,  5986,  8714,  13,   2, UNI_NV__30 }   /* numericvalue=30 */,
  {     1,  9488,  5018,   4,  14, UNI_ANCIENTSYMBOLS }   /* blk=ancientsymbols */,
  {     0,  2224,  6940,   3,  10, UNI_INSORASOMPENG }   /* insorasompeng */,
  {     5,  3367,  9836,  18,   4, UNI__PERL_PATWS }   /* patternwhitespace=true */,
  {     4,  9488,  6025,   4,  12, UNI_ALPHABETICPF }   /* blk=alphabeticpf */,
  {     0,  1417,  5648,  24,   2, UNI_CCC__10 }   /* canonicalcombiningclass=10 */,
  {     3, 10024,    47,   3,   1, UNI_M }   /* gc=m */,
  {     0,  3836,  8107,  17,   8, UNI_BALI }   /* scriptextensions=balinese */,
  {     0,  2224,  2055,   3,  21, UNI_MODIFIERLETTERS }   /* inspacingmodifierletters */,
  {     8,  3836,  7513,  17,   9, UNI_BHKS }   /* scriptextensions=bhaiksuki */,
  {    38,  3836,  8484,  17,   7, UNI_MAND }   /* scriptextensions=mandaic */,
  {     3,  5791,  2637,  13,   9, UNI_JG__YEHBARREE }   /* joininggroup=yehbarree */,
  {     0,  4643,     3,  15,   1, -UNI_ECOMP }   /* emojicomponent=f */,
  {     3,  1417,  8823,  25,   5, UNI_CCC__130 }   /* canonicalcombiningclass=ccc130 */,
  {     4,  7325, 10078,   3,   3, UNI_IN__2_DOT_1 }   /* in=v21 */,
  {    25,  3836,  9612,  17,   4, UNI_KNDA }   /* scriptextensions=knda */,
  {     1, 10048,  9404,   3,   4, UNI_NV__13_SLASH_2 }   /* nv=13/2 */,
  {     2,    21,  8338,   3,   6, UNI_INAVESTAN }   /* inavestan */,
  {     2,   184,  3026,   3,   3, UNI_CHER }   /* ischer */,
  {     1,  3836,  9720,  17,   4, UNI_PHLP }   /* scriptextensions=phlp */,
  {     0,  7318,  7814,  10,   1, UNI_IN__7 }   /* presentin=7 */,
  {     0,  9488,  5214,   4,  14, UNI_KANGXI }   /* blk=kangxiradicals */,
  {     2,  3836,  8131,  17,   4, UNI_DUPL }   /* scriptextensions=dupl */,
  {    16,  8780,  2141,   7,  20, UNI_CYRILLICSUP }   /* block=cyrillicsupplementary */,
  {     1,  4928,     0,  15,   0, UNI_TAMILSUP }   /* tamilsupplement */,
  {     1,   184,  8401,   3,   5, UNI_COMPEX }   /* iscompex */,
  {    50,  1537,  3475,  24,  10, UNI_INPC__TOPANDLEFT }   /* indicpositionalcategory=topandleft */,
  {     1,  7325,  9955,   3,   3, UNI_IN__3_DOT_2 }   /* in=3.2 */,
  {    37,  9277,  5550,   3,  14, UNI_SC__PHLP }   /* sc=psalterpahlavi */,
  {    51, 10288,  7739,   3,   7, UNI_XIDS }   /* isxidstart */,
  {     4,  7318,  9970,  10,   3, UNI_IN__5_DOT_2 }   /* presentin=5.2 */,
  {     0,  3547,     0,  10,   0, UNI_ALCHEMICAL }   /* alchemical */,
  {    32,  9997,  3205,   3,  18, UNI_BC__FSI }   /* bc=firststrongisolate */,
  {     0,  5986,  8732,  13,   5, UNI_NV__50000 }   /* numericvalue=50000 */,
  {    32,  9536,     0,   4,   0, UNI_dep_values_index }   /* dep= */,
  {     1,  8780,    78,   6,  10, UNI_ARABICMATH }   /* block=arabicmath */,
  {     3,   184,   407,   3,   6, UNI_XPOSIXCNTRL }   /* iscontrol */,
  {     0,   184,  1677,   2,  14, UNI_LATINEXTA }   /* islatinextendeda */,
  {     2,  3836,  9584,  17,   4, UNI_HLUW }   /* scriptextensions=hluw */,
  {     2,  9488,     0,   4,   0, UNI_blk_values_index }   /* blk= */,
  {     0,  8589,    78,   7,   4, UNI_SC__ARAB }   /* script=arab */,
  {     1,   184,  3667,   3,  16, UNI_CYRILLICEXTC }   /* iscyrillicextendedc */,
  {     0,  8774,    26,   6,   1, UNI_BIDIM }   /* bidim=y */,
  {   179,   184,  5726,   2,  13, UNI_ME }   /* isenclosingmark */,
  {     5,  9270,  2549,   5,   3, UNI_INPC__TOP }   /* inpc=top */,
  {     5,  9488,  9340,   4,   5, UNI_VSSUP }   /* blk=vssup */,
  {    44,  8589,  8414,   7,   7, UNI_ELBA }   /* script=elbasan */,
  {     4,  1189,   495,   3,   7, UNI_NT__NU }   /* nt=numeric */,
  {     1,  4033,  1044,  16,   6, UNI_L }   /* generalcategory=letter */,
  {     0,  4033,  5494,  16,  14, UNI_MN }   /* generalcategory=nonspacingmark */,
  {    11, 10340,  1751,   3,   2, UNI_VAI }   /* isvai */,
  {    20,   184,  9572,   2,   4, UNI_GUJR }   /* isgujr */,
  {     8,  3836,  8291,  17,   4, UNI_TAGB }   /* scriptextensions=tagb */,
  {     0,  8589,  9688,   7,   3, UNI_NKO }   /* script=nko */,
  {    60,  2855,     0,   9,   0, UNI_MONG }   /* mongolian */,
  {     2,   184,  2608,   2,   6, UNI_BRAH }   /* isbrahmi */,
  {     0,   184,  1218,   2,   8, UNI_KANA }   /* iskatakana */,
  {     0,  9536,     1,   4,   1, -UNI_DEP }   /* dep=n */,
  {     3,  8780,  1513,   6,  24, UNI_HIGHPUSURROGATES }   /* block=highprivateusesurrogates */,
  {     0,  7318, 10090,  10,   3, UNI_IN__4 }   /* presentin=v40 */,
  {     0,  4628,     8,  15,   1, UNI_EA__A }   /* eastasianwidth=a */,
  {     1,    78,     0,  10,   0, UNI_ARABICMATH }   /* arabicmath */,
  {    12,  9277,  6939,   3,   4, UNI_SORA }   /* sc=sora */,
  {     1,  4791,  1019,   3,   4, UNI_MUSIC }   /* inmusic */,
  {     0,  7218,  2444,  10,   2, UNI_LB__HL }   /* linebreak=hl */,
  {    33,  4673,     0,  15,   0, UNI_INHANGUL }   /* hangulsyllables */,
  {     1,   184,  8428,   2,   7, UNI_GRAN }   /* isgrantha */,
  {     4,  3382,  9255,   3,   5, -UNI_CE }   /* ce=false */,
  {     2,  4033,  1563,  16,   2, UNI_PS }   /* generalcategory=ps */,
  {     0,  1746,   752,  23,   4, UNI_BPT__C }   /* bidipairedbrackettype=close */,
  {     0,   184,  8882,   2,   5, UNI_GREXT }   /* isgrext */,
  {     3,  6231,  3026,   3,   7, UNI_INCHEROKEE }   /* incherokee */,
  {     0,   184,  7098,   2,  10, UNI_BOXDRAWING }   /* isboxdrawing */,
  {     0,  7540,     3,   9,   1, -UNI_EXT }   /* extender=f */,
  {     0,  1591,  6134,   3,  11, UNI_ETHIOPICEXTA }   /* inethiopicexta */,
  {     0, 10340,    67,   3,   4, UNI_VSSUP }   /* isvssup */,
  {     2,  9520,  9836,   4,   4, UNI_CWL }   /* cwl=true */,
  {    57,  8780,  6796,   6,  11, UNI_INMEDEFAIDRIN }   /* block=medefaidrin */,
  {     6,  9488,  3421,   4,  18, UNI_RUMI }   /* blk=ruminumeralsymbols */,
  {    12,  9265,     3,   5,   1, -UNI_IDST }   /* idst=f */,
  {     4,  9508,  9208,   4,   2, UNI_CCC__35 }   /* ccc=35 */,
  {     1,  6805,   187,   6,  30, UNI_MISCPICTOGRAPHS }   /* inmiscellaneoussymbolsandpictographs */,
  {     5,  5466,     0,  14,   0, UNI_nfdqc_values_index }   /* nfdquickcheck= */,
  {     1,  9488,  6939,   4,  11, UNI_INSORASOMPENG }   /* blk=sorasompeng */,
  {     0,  9230,    36,   5,   1, UNI_CWCF }   /* cwcf=t */,
  {     1,  9444,  7821,   4,   1, UNI_AGE__8 }   /* age=8 */,
  {     0,  6554,  9255,  11,   5, -UNI_IDC }   /* idcontinue=false */,
  {     0,  9277,  7291,   3,   7, UNI_SC__SOGD }   /* sc=sogdian */,
  {    13,  8589,  9285,   7,   4, UNI_SC__LIMB }   /* script=limb */,
  {     3,  3836,  9496,  17,   4, UNI_BUHD }   /* scriptextensions=buhd */,
  {     0,  2931,     0,  19,   0, UNI_SUPARROWSA }   /* supplementalarrowsa */,
  {    64,   184,  2684,   2,  19, UNI_EGYP }   /* isegyptianhieroglyphs */,
  {     2,  8509,   811,   4,  27, UNI_ENCLOSEDIDEOGRAPHICSUP }   /* inenclosedideographicsupplement */,
  {     0,  9277,  6793,   5,   2, UNI_KHMR }   /* sc=khmr */,
  {     0,  8780,  1319,   6,  25, UNI_SYMBOLSANDPICTOGRAPHSEXTA }   /* block=symbolsandpictographsexta */,
  {    69,  5986,  8820,  13,   2, UNI_NV__29 }   /* numericvalue=29 */,
  {     0,   184,  5947,   2,  13, UNI_MAYANNUMERALS }   /* ismayannumerals */,
  {     9,  6805,  2023,   6,   9, UNI_MISCTECHNICAL }   /* inmisctechnical */,
  {     1,  9277,  8603,   3,   7, UNI_SHAW }   /* sc=shavian */,
  {     0,  1828, 10135,   6,   3, UNI_CASED }   /* cased=yes */,
  {     0,  9768,  4478,   4,   4, UNI_BRAI }   /* scx=brai */,
  {     5,  9768,  8666,   4,   7, UNI_TIRH }   /* scx=tirhuta */,
  {     0,  9275,  7639,   5,   9, UNI_INSC__NONJOINER }   /* insc=nonjoiner */,
  {     1,  1114,    36,  26,   1, UNI_CWKCF }   /* changeswhennfkccasefolded=t */,
  {     0,  3836,  9564,  17,   4, UNI_GONM }   /* scriptextensions=gonm */,
  {     0,  8589,  9612,   7,   4, UNI_SC__KNDA }   /* script=knda */,
  {     0,  4958,     0,  15,   0, UNI_UPPERCASELETTER }   /* uppercaseletter */,
  {     1, 10333,  4149,   3,   3, UNI_SARB }   /* issarb */,
  {     7,  1828,     1,   6,   1, -UNI_CASED }   /* cased=n */,
  {     0,  9277,  9002,   3,   4, UNI_SC__TELU }   /* sc=telu */,
  {     0,  9444,  9384,   4,   4, UNI_AGE__10 }   /* age=10.0 */,
  {     0,  8780,  3921,   6,  16, UNI_ARABICSUP }   /* block=arabicsupplement */,
  {     0,  8589,  9532,   7,   4, UNI_SC__CYRL }   /* script=cyrl */,
  {     1,  5986,  9436,  13,   4, UNI_NV__7_SLASH_12 }   /* numericvalue=7/12 */,
  {     1,  1561,     0,  24,   0, UNI_SUPSYMBOLSANDPICTOGRAPHS }   /* supsymbolsandpictographs */,
  {     0,  4916,  4402,   3,  15, UNI_TANGUTSUP }   /* istangutsupplement */,
  {    48,  7325,  9840,   3,   4, UNI_IN__10 }   /* in=v100 */,
  {     1,  7325, 10108,   3,   3, UNI_IN__6_DOT_1 }   /* in=v61 */,
  {     2,  7318,  7755,  10,   3, UNI_IN__1_DOT_1 }   /* presentin=1.1 */,
  {     7,  9070,     0,   4,   0, UNI_POSIXXDIGIT }   /* ahex */,
  {     1,  3836,  7188,  17,   4, UNI_KHAR }   /* scriptextensions=khar */,
  {     0,   719,     0,   9,   0, UNI_XSUX }   /* cuneiform */,
  {    96,  8780,  4448,   6,   8, UNI_BAMUMSUP }   /* block=bamumsup */,
  {     0,  9488,  1441,   4,  10, UNI_CJKSYMBOLS }   /* blk=cjksymbols */,
  {    21, 10132,  6653,   3,  11, UNI_WB__DQ }   /* wb=doublequote */,
  {     1,  8780,  6972,   6,  11, UNI_INSYLOTINAGRI }   /* block=sylotinagri */,
  {     0,  3836,  2817,  17,  19, UNI_MERO }   /* scriptextensions=meroitichieroglyphs */,
  {     0,   184,  3683,   2,  16, UNI_ETHIOPICEXT }   /* isethiopicextended */,
  {     0,  9014,     1,   6,   1, -UNI_UIDEO }   /* uideo=n */,
  {     1,  8400,     1,   7,   1, -UNI_COMPEX }   /* compex=n */,
  {     0,  9277,  8888,   3,   6, UNI_HATR }   /* sc=hatran */,
  {     0,  1166,  9836,  26,   4, UNI_DI }   /* defaultignorablecodepoint=true */,
  {     0, 10291,  1867,   5,   5, UNI_POSIXUPPER }   /* posixupper */,
  {     0,  6231,  3650,   3,  16, UNI_CYRILLICEXTB }   /* incyrillicextendedb */,
  {     1,  8589,   493,   7,   3, UNI_SC__HAN }   /* script=han */,
  {     0,  8780,  2099,   7,  20, UNI_CJKCOMPATFORMS }   /* block=cjkcompatibilityforms */,
  {     2,  5986,  7979,  13,   8, UNI_NV__3_SLASH_5 }   /* numericvalue=6.00e-01 */,
  {     2, 10048,  7922,   3,   2, UNI_NV__24 }   /* nv=24 */,
  {     3,  2469,     0,  20,   0, UNI_HMNP }   /* nyiakengpuachuehmong */,
  {    25,  4829,  2411,   4,  11, UNI_GLAGOLITICSUP }   /* inglagoliticsup */,
  {     3,    21,  4145,   2,  16, UNI_LINEARBIDEOGRAMS }   /* inlinearbideograms */,
  {     0,   809,     0,  29,   0, UNI_ENCLOSEDIDEOGRAPHICSUP }   /* enclosedideographicsupplement */,
  {     0,  1856,     1,  22,   1, -UNI_CWU }   /* changeswhenuppercased=n */,
  {     0,   184,  2141,   3,  20, UNI_CYRILLICSUP }   /* iscyrillicsupplementary */,
  {     0,  5986,  9188,  13,   2, UNI_NV__31 }   /* numericvalue=31 */,
  {     2,  8780,    43,   7,  35, UNI_CJKCOMPATIDEOGRAPHSSUP }   /* block=cjkcompatibilityideographssupplement */,
  {     1, 10033,    23,   3,   2, UNI_LB__AL }   /* lb=al */,
  {     0, 10027,    87,   3,   2, UNI_JG__HE }   /* jg=he */,
  {     4, 10132,   108,   3,   2, UNI_WB__MB }   /* wb=mb */,
  {     2,  4033,  1465,  16,  13, UNI_M }   /* generalcategory=combiningmark */,
  {     1,  9325,     0,   5,   0, UNI_RUNR }   /* runic */,
  {     1,  1552,   727,   9,   2, UNI_MN }   /* category=mn */,
  {     0,  7088, 10054,  10,   3, UNI_BC__PDF }   /* bidiclass=pdf */,
  {     1,  9656,     0,   4,   0, UNI_MIAO }   /* miao */,
  {     0,  2969,     0,  19,   0, UNI_SUPARROWSC }   /* supplementalarrowsc */,
  {     1,  9508,  8708,   4,   3, UNI_CCC__216 }   /* ccc=216 */,
  {     0,  9768,  9616,   4,   4, UNI_KTHI }   /* scx=kthi */,
  {     0,  6609,    36,  11,   1, UNI_DEP }   /* deprecated=t */,
  {     0,  8780,   510,   7,  29, UNI_CJKEXTA }   /* block=cjkunifiedideographsextensiona */,
  {     6, 10027,  6572,   3,   4, UNI_JG__NOON }   /* jg=noon */,
  {     1,  2182,  1194,  21,   2, UNI_LB__LF }   /* graphemeclusterbreak=lf */,
  {     0,  8589,  4478,   7,   4, UNI_BRAI }   /* script=brai */,
  {     1,  9768,  9576,   4,   4, UNI_GURU }   /* scx=guru */,
  {     0,  8780,  1006,   6,  27, UNI_ANCIENTGREEKMUSIC }   /* block=ancientgreekmusicalnotation */,
  {     0,  8858,  9836,   6,   4, UNI_ECOMP }   /* ecomp=true */,
  {    16,  8780,  3241,   6,   8, UNI_INGEORGIAN }   /* block=georgian */,
  {     0,  5739,     0,  12,   0, UNI_GRBASE }   /* graphemebase */,
  {    40,  4928,     0,   5,   0, UNI_TAML }   /* tamil */,
  {     0, 10024,    24,   3,   1, UNI_L }   /* gc=l */,
  {     0,  9768,  9793,   5,   3, UNI_SOGO }   /* scx=sogo */,
  {    25,  1768,     3,  22,   1, -UNI_CWCF }   /* changeswhencasefolded=f */,
  {    29,  1417,  7754,  24,   2, UNI_CCC__11 }   /* canonicalcombiningclass=11 */,
  {     0,  8589,  7651,   7,   4, UNI_ITAL }   /* script=ital */,
  {     0,  9488,  8393,   4,   7, UNI_CJKEXTG }   /* blk=cjkextg */,
  {     1,  9508,    18,   4,   1, UNI_CCC__R }   /* ccc=r */,
  {    34,  8688,  7411,   3,   7, UNI_ASSIGNED }   /* isassigned */,
  {     0,    21,  3295,   2,  18, UNI_LATINEXTADDITIONAL }   /* inlatinextadditional */,
  {     1,  9997,  4464,   4,  14, UNI_BC__BN }   /* bc=boundaryneutral */,
  {     0,  2760,     9,  19,   2, UNI_HST__NA }   /* hangulsyllabletype=na */,
  {     1,  7318,  7806,  10,   1, UNI_IN__6 }   /* presentin=6 */,
  {    43, 10033,  6587,   3,  11, UNI_LB__BB }   /* lb=breakbefore */,
  {     1,  9716,     0,   4,   0, UNI_pcm_values_index }   /* pcm= */,
  {     0,  9277,  1628,   3,   4, UNI_SC__PHAG }   /* sc=phag */,
  {     3,  2529,  9255,  20,   5, -UNI_TERM }   /* terminalpunctuation=false */,
  {     0,  9488,  5032,   4,   5, UNI_ASCII }   /* blk=ascii */,
  {     0,  9488,  8484,   4,   7, UNI_INMANDAIC }   /* blk=mandaic */,
  {     8,  8852,     1,   6,   1, -UNI_CWKCF }   /* cwkcf=n */,
  {     4,  7325,  7867,   3,   3, UNI_IN__3_DOT_1 }   /* in=3.1 */,
  {     0,  9275,  1608,   5,  23, UNI_INSC__CONSONANTPRECEDINGREPHA }   /* insc=consonantprecedingrepha */,
  {     0,  1273,  9255,  21,   5, -UNI_CE }   /* compositionexclusion=false */,
  {     1,  8996,     1,   6,   1, -UNI_STERM }   /* sterm=n */,
  {     1,  9792,     0,   4,   0, UNI_SOGO }   /* sogo */,
  {     0,   184,  6409,   2,  12, UNI_MEND }   /* ismendekikakui */,
  {     3,  9508,  9168,   4,   2, UNI_CCC__27 }   /* ccc=27 */,
  {     5,  4853,    26,  15,   1, UNI_DT__NONE }   /* nfkdquickcheck=y */,
  {     6,  9277,  8344,   3,   7, UNI_SC__BENG }   /* sc=bengali */,
  {     2,  9277,  2469,   3,  20, UNI_HMNP }   /* sc=nyiakengpuachuehmong */,
  {     1,  1417,  9928,  24,   3, UNI_CCC__BR }   /* canonicalcombiningclass=222 */,
  {     0,  3836,  3937,  17,   4, UNI_BOPO }   /* scriptextensions=bopo */,
  {     4,  3836,  7118,  17,  10, UNI_CHRS }   /* scriptextensions=chorasmian */,
  {     6,  8589,  9756,   7,   4, UNI_RUNR }   /* script=runr */,
  {     0,  9277,  5003,   3,  15, UNI_ZANB }   /* sc=zanabazarsquare */,
  {     0,  2182,  6178,  21,   3, UNI_LB__ZWJ }   /* graphemeclusterbreak=zwj */,
  {     2,  9508,  5377,   4,   2, UNI_CCC__7 }   /* ccc=nk */,
  {     0,  2779,     1,  19,   1, -UNI_IDST }   /* idstrinaryoperator=n */,
  {     2,  9488,  2010,   4,  22, UNI_MISCTECHNICAL }   /* blk=miscellaneoustechnical */,
  {    19,  1966,     0,  22,   0, UNI_insc_values_index }   /* indicsyllabiccategory= */,
  {     0,  9277,  7288,   3,  10, UNI_SOGO }   /* sc=oldsogdian */,
  {     2,  9488,  9688,   4,   3, UNI_INNKO }   /* blk=nko */,
  {    16,  8589,  8123,   7,   4, UNI_SC__BUGI }   /* script=bugi */,
  {     1,  5986,  8756,  13,   3, UNI_NV__900 }   /* numericvalue=900 */,
  {     0,  9235,     3,   5,   1, -UNI_CWCM }   /* cwcm=f */,
  {     6,  8589,  9704,   7,   4, UNI_ORKH }   /* script=orkh */,
  {     4,  8780,  4808,   6,  15, UNI_MISCPICTOGRAPHS }   /* block=miscpictographs */,
  {     2,  9520,  1025,   4,   2, -UNI_CWL }   /* cwl=no */,
  {     0,  9277,  9720,   3,   4, UNI_SC__PHLP }   /* sc=phlp */,
  {    64,  7738,     0,   8,   0, UNI_XIDS }   /* xidstart */,
  {    42,  9768,  5284,   4,   4, UNI_LISU }   /* scx=lisu */,
  {     0,  8561,     0,   4,   0, UNI_OSMA }   /* osma */,
  {   145,  6241,  6664,  12,  11, UNI_JT__D }   /* joiningtype=dualjoining */,
  {     4,  8882,    26,   6,   1, UNI_GREXT }   /* grext=y */,
  {     3,  1552,  1822,   9,   2, UNI_NL }   /* category=nl */,
  {     5,  3529, 10135,  18,   3, UNI_VS }   /* variationselector=yes */,
  {     0,  7675,     0,   4,   0, UNI_PALM }   /* palm */,
  {     0, 10009,  8195,   3,   8, UNI_DT__ISO }   /* dt=isolated */,
  {    16,  7504,     0,   9,   0, UNI_ARABICPFB }   /* arabicpfb */,
  {     0,  9760,     0,   4,   0, UNI_SAMR }   /* samr */,
  {     1,  9508,  7821,   4,   1, UNI_CCC__8 }   /* ccc=8 */,
  {     2,   184,  9503,   2,   2, UNI_MC }   /* ismc */,
  {     2,  3836,  8924,  17,   4, UNI_LEPC }   /* scriptextensions=lepc */,
  {     0,  9556,    70,   4,   2, UNI_GCB__PP }   /* gcb=pp */,
  {     3,   184,  8428,   2,   4, UNI_GRAN }   /* isgran */,
  {    49,  6576,  9836,  11,   4, UNI_XPOSIXALPHA }   /* alphabetic=true */,
  {     0, 10048,  9368,   3,   4, UNI_NV__1_SLASH_20 }   /* nv=1/20 */,
  {    15,  9488,    78,   4,  10, UNI_ARABICMATH }   /* blk=arabicmath */,
  {     0,  8864,    36,   6,   1, UNI_EMOJI }   /* emoji=t */,
  {     1,  9350,  9255,   5,   5, -UNI_XIDS }   /* xids=false */,
  {     1,  7438,  6178,  10,   3, UNI_LB__ZWJ }   /* wordbreak=zwj */,
  {    40,  4928,     0,   8,   0, UNI_TAMILSUP }   /* tamilsup */,
  {     0,  9270,  6518,   3,  11, UNI_PLAYINGCARDS }   /* inplayingcards */,
  {    31,  9275,  4823,   5,  15, UNI_INSC__MODIFYINGLETTER }   /* insc=modifyingletter */,
  {     0,  3836,  9085,  17,   5, UNI_BATK }   /* scriptextensions=batak */,
  {     0,  8688,  3548,   3,  16, UNI_ALCHEMICAL }   /* isalchemicalsymbols */,
  {     0,  9508,  9203,   4,   2, UNI_CCC__34 }   /* ccc=34 */,
  {     7,  2589,     0,  19,   0, UNI_ANCIENTGREEKNUMBERS }   /* ancientgreeknumbers */,
  {     2, 10006,    36,   3,   1, UNI_DI }   /* di=t */,
  {     0,  8997,  9255,   5,   5, -UNI_TERM }   /* term=false */,
  {     0, 10030,     6,   3,   1, UNI_JT__D }   /* jt=d */,
  {     1,  9768,  2203,   4,  14, UNI_ROHG }   /* scx=hanifirohingya */,
  {     1,   184,    24,   2,   1, UNI_L }   /* isl */,
  {     1,  2760,  7238,  19,  10, UNI_LB__H2 }   /* hangulsyllabletype=lvsyllable */,
  {     4,  8589,  8498,   7,   4, UNI_SC__MULT }   /* script=mult */,
  {     0,  1114, 10135,  26,   3, UNI_CWKCF }   /* changeswhennfkccasefolded=yes */,
  {     0,  3985,     0,  16,   0, UNI_PE }   /* closepunctuation */,
  {    10,  9768,  8491,   4,   4, UNI_MARC }   /* scx=marc */,
  {     1,  9768,  4273,   4,   7, UNI_MYMR }   /* scx=myanmar */,
  {     4,  5466, 10135,  14,   3, UNI_NFDQC__Y }   /* nfdquickcheck=yes */,
  {     1,  5986,  8066,  13,   2, UNI_NV__28 }   /* numericvalue=28 */,
  {     1,  7228,     3,  10,   1, -UNI_XPOSIXLOWER }   /* lowercase=f */,
  {   139,  8780,  2912,   6,   9, UNI_INSUNDANESE }   /* block=sundanese */,
  {     0,  5746,  9836,   6,   4, UNI_EBASE }   /* ebase=true */,
  {     1,  5791,  9044,  13,   4, UNI_JG__YUDH }   /* joininggroup=yudh */,
  {     0,  8780,  1654,   6,  23, UNI_COMPATJAMO }   /* block=hangulcompatibilityjamo */,
  {    22, 10132,   138,   3,   2, UNI_WB__FO }   /* wb=fo */,
  {     0, 10027, 10057,   3,   3, UNI_JG__REH }   /* jg=reh */,
  {     0,  5986,  9424,  13,   4, UNI_NV__3_SLASH_64 }   /* numericvalue=3/64 */,
  {     0,  8589,  7359,   8,   9, UNI_SAUR }   /* script=saurashtra */,
  {     4,  1417,  3564,  24,  17, UNI_WB__EB }   /* canonicalcombiningclass=attachedbelowleft */,
  {     0, 10033,  6178,   3,   3, UNI_LB__ZWJ }   /* lb=zwj */,
  {     3,  8762,     1,   6,   1, -UNI_XPOSIXALPHA }   /* alpha=n */,
  {     8,  7088,     8,  10,   2, UNI_BC__AN }   /* bidiclass=an */,
  {     1,   184,    18,   2,   2, UNI_RI }   /* isri */,
  {    17, 10027,  5382,   3,  14, UNI_JG__MANICHAEANQOPH }   /* jg=manichaeanqoph */,
  {     1,  9768,  7660,   4,   4, UNI_PERM }   /* scx=perm */,
  {     0,  3836,  9464,  17,   4, UNI_ARMN }   /* scriptextensions=armn */,
  {     0,   512,     0,  16,   0, UNI_UIDEO }   /* unifiedideograph */,
  {     0,  9488,  2245,   4,  21, UNI_MEETEIMAYEKEXT }   /* blk=meeteimayekextensions */,
  {     3,  7738,  9255,   9,   5, -UNI_XIDS }   /* xidstart=false */,
  {    33,  8694, 10135,   7,   3, UNI_XPOSIXSPACE }   /* wspace=yes */,
  {    17,  9444,  7950,   4,   1, UNI_AGE__9 }   /* age=9 */,
  {    74,  2817,     0,  19,   0, UNI_MERO }   /* meroitichieroglyphs */,
  {     0,  8589,  9620,   7,   4, UNI_LANA }   /* script=lana */,
  {     0,  9768,  5003,   4,  15, UNI_ZANB }   /* scx=zanabazarsquare */,
  {     1,  5746,     1,   6,   1, -UNI_EBASE }   /* ebase=n */,
  {     0,  8780,  9032,   6,   6, UNI_INWANCHO }   /* block=wancho */,
  {     8,  5284,     0,   4,   0, UNI_LISU }   /* lisu */,
  {    20,  1900,     0,  22,   0, UNI_INDICNUMBERFORMS }   /* commonindicnumberforms */,
  {     0,  6576, 10135,  11,   3, UNI_XPOSIXALPHA }   /* alphabetic=yes */,
  {     0,  1006,     0,  17,   0, UNI_ANCIENTGREEKMUSIC }   /* ancientgreekmusic */,
  {     0,  5986,  8714,  13,   3, UNI_NV__300 }   /* numericvalue=300 */,
  {     0,  3043,     0,  18,   0, UNI_HALFMARKS }   /* combininghalfmarks */,
  {     0,  9277,  9335,   3,   4, UNI_SC__TAKR }   /* sc=takr */,
  {     8,  7738,     0,   9,   0, UNI_xids_values_index }   /* xidstart= */,
  {     0,   184,  9756,   2,   4, UNI_RUNR }   /* isrunr */,
  {     1,   184,  7188,   2,   4, UNI_KHAR }   /* iskhar */,
  {     3,  8884,     1,   4,   1, -UNI_EXT }   /* ext=n */,
  {     4,  9351, 10135,   4,   3, UNI_IDS }   /* ids=yes */,
  {     1,   184,  3169,   2,   4, UNI_ETHI }   /* isethi */,
  {    10,  2224,  1345,   3,  24, UNI_SYMBOLSFORLEGACYCOMPUTING }   /* insymbolsforlegacycomputing */,
  {     2,  8780,  3026,   7,  17, UNI_CHEROKEESUP }   /* block=cherokeesupplement */,
  {     4,  9444,  9844,   4,   3, UNI_IN__1_DOT_1 }   /* age=v11 */,
  {     0,  9768,   382,   4,   4, UNI_EGYP }   /* scx=egyp */,
  {    89,  3277,     0,  18,   0, UNI_PI }   /* initialpunctuation */,
  {     4,  9488,  9664,   4,   3, UNI_INMRO }   /* blk=mro */,
  {     0,  9277,  8561,   3,   4, UNI_OSMA }   /* sc=osma */,
  {     0,  3098,     0,   5,   0, UNI_ECOMP }   /* ecomp */,
  {     0, 10012,  1204,   3,   9, UNI_EA__F }   /* ea=fullwidth */,
  {    16,  1537,     9,  24,   2, UNI_INPC__NA }   /* indicpositionalcategory=na */,
  {     0, 10048,  7874,   3,   2, UNI_NV__23 }   /* nv=23 */,
  {     0,  5791,  5354,  13,  14, UNI_JG__MANICHAEANHETH }   /* joininggroup=manichaeanheth */,
  {     1,  1114,  1025,  26,   2, -UNI_CWKCF }   /* changeswhennfkccasefolded=no */,
  {     2,  3853,  9255,  17,   5, -UNI_STERM }   /* sentenceterminal=false */,
  {     0,  7088,  2268,  10,   3, UNI_BC__PDI }   /* bidiclass=pdi */,
  {     2,   184,  9616,   2,   4, UNI_KTHI }   /* iskthi */,
  {     4, 10027,     5,   3,   1, UNI_JG__E }   /* jg=e */,
  {     0,  1344,     0,  25,   0, UNI_SYMBOLSFORLEGACYCOMPUTING }   /* symbolsforlegacycomputing */,
  {     0,  2703,     0,  19,   0, UNI_ENCLOSEDALPHANUMSUP }   /* enclosedalphanumsup */,
  {     1,  7318,  9852,  10,   4, UNI_IN__12_DOT_1 }   /* presentin=v121 */,
  {     1,  8589,  2608,   7,   4, UNI_BRAH }   /* script=brah */,
  {    58,  9488,  6109,   4,  12, UNI_CYRILLICEXTB }   /* blk=cyrillicextb */,
  {    35,  6231,   720,   3,  29, UNI_CUNEIFORMNUMBERS }   /* incuneiformnumbersandpunctuation */,
  {    98,  9277,  9828,   3,   4, UNI_THAI }   /* sc=thai */,
  {    37,  2288,  3055,   5,   6, UNI_HALFMARKS }   /* inhalfmarks */,
  {     7,  5986,  8727,  13,   2, UNI_NV__32 }   /* numericvalue=32 */,
  {     0,  8852,     0,   5,   0, UNI_CWKCF }   /* cwkcf */,
  {     2,  9488,  6807,   4,  11, UNI_MISCSYMBOLS }   /* blk=miscsymbols */,
  {     1,  8589,  9872,   7,   4, UNI_XPEO }   /* script=xpeo */,
  {     3,  1979,  5818,  10,  12, UNI_ZL }   /* category=lineseparator */,
  {     3,  1417,  3572,  24,   5, UNI_CCC__B }   /* canonicalcombiningclass=below */,
  {    17,  1369,     0,  24,   0, UNI_ARABICPFA }   /* arabicpresentationformsa */,
  {    82,  9262,   751,   3,   5, UNI_SB__CL }   /* sb=close */,
  {    13,  2529,     0,  21,   0, UNI_TERM }   /* terminalpunctuation=t */,
  {     3,  9488,  4241,   4,  16, UNI_MISCMATHSYMBOLSA }   /* blk=miscmathsymbolsa */,
  {     0,  9488,  8386,   4,   7, UNI_CJKEXTF }   /* blk=cjkextf */,
  {    12,  8780,  1033,   6,  11, UNI_ENCLOSEDCJK }   /* block=enclosedcjk */,
  {     1,  9277,  8428,   3,   7, UNI_SC__GRAN }   /* sc=grantha */,
  {     0,   749,     0,  16,   0, UNI_ENCLOSEDALPHANUM }   /* enclosedalphanum */,
  {     0,  9488,  1369,   4,  24, UNI_ARABICPFA }   /* blk=arabicpresentationformsa */,
  {     2,  3331,     0,  18,   0, UNI_ORNAMENTALDINGBATS }   /* ornamentaldingbats */,
  {     1,  9524,     1,   4,   1, -UNI_CWT }   /* cwt=n */,
  {     0,  7076,  4449,   3,  14, UNI_BAMUMSUP }   /* inbamumsupplement */,
  {     2,  7318,  7469,  10,   1, UNI_IN__5 }   /* presentin=5 */,
  {     0,  9230,     0,   4,   0, UNI_CWCF }   /* cwcf */,
  {     1,  9277,  9688,   3,   3, UNI_NKO }   /* sc=nko */,
  {     0,  8631,     0,   7,   0, UNI_SUPPUAB }   /* suppuab */,
  {   142,  9540,  9255,   4,   5, -UNI_DIA }   /* dia=false */,
  {     2,  4033,  4568,  16,  14, UNI_SC }   /* generalcategory=currencysymbol */,
  {    30,  8870,    26,   6,   1, UNI_EPRES }   /* epres=y */,
  {     1,  9768,  6886,   5,   3, UNI_SHAW }   /* scx=shaw */,
  {     1,  5032,    26,  14,   1, UNI_POSIXXDIGIT }   /* asciihexdigit=y */,
  {     6,  5986,  9910,  13,   3, UNI_NV__1_SLASH_9 }   /* numericvalue=1/9 */,
  {     0,  3836,  9688,  17,   4, UNI_NKO }   /* scriptextensions=nkoo */,
  {     0,  9277,  9780,   3,   4, UNI_SHAW }   /* sc=shaw */,
  {     6, 10048,  7950,   3,   1, UNI_NV__9 }   /* nv=9 */,
  {     0,  7325,  9401,   3,   3, UNI_IN__3 }   /* in=3.0 */,
  {    24,  5739,    26,  13,   1, UNI_GRBASE }   /* graphemebase=y */,
  {     3,   184,  2836,   2,  19, UNI_MODIFIERTONELETTERS }   /* ismodifiertoneletters */,
  {     2,  1834,     0,  22,   0, UNI_cwt_values_index }   /* changeswhentitlecased= */,
  {     0,   184,   951,   2,  28, UNI_VSSUP }   /* isvariationselectorssupplement */,
  {     0,  9768,  9448,   4,   4, UNI_AGHB }   /* scx=aghb */,
  {     1,  9768,  9789,   5,   3, UNI_SHRD }   /* scx=shrd */,
  {     0,  9508,  8805,   5,   5, UNI_CCC__118 }   /* ccc=ccc118 */,
  {     6,  6085,     0,  12,   0, UNI_CHESSSYMBOLS }   /* chesssymbols */,
  {     3, 10048,  8710,   3,   2, UNI_NV__60 }   /* nv=60 */,
  {     0,  3097, 10069,  18,   3, UNI_DT__SQR }   /* decompositiontype=sqr */,
  {     1,  6553,     1,  12,   1, -UNI_XIDC }   /* xidcontinue=n */,
  {     0,  8147,    36,   8,   1, UNI_EXTPICT }   /* extpict=t */,
  {     1,  8780,   809,   6,  22, UNI_ENCLOSEDIDEOGRAPHICSUP }   /* block=enclosedideographicsup */,
  {     5,   117,  4704,   3,  14, UNI_INIMPERIALARAMAIC }   /* inimperialaramaic */,
  {    24,  9277,  3937,   3,   8, UNI_SC__BOPO }   /* sc=bopomofo */,
  {     0,  8996,     0,   5,   0, UNI_STERM }   /* sterm */,
  {     5,   184,  6620,   2,   6, UNI_DOMINO }   /* isdomino */,
  {     0,  3836,  4478,  17,   7, UNI_BRAI }   /* scriptextensions=braille */,
  {     3,  8147,     0,   8,   0, UNI_extpict_values_index }   /* extpict= */,
  {     1,  4422,  3117,   4,   8, UNI_INDEVANAGARI }   /* indevanagari */,
  {     0,  5578,   751,  14,   2, UNI_SB__CL }   /* sentencebreak=cl */,
  {     0, 10048,  7765,   3,   2, UNI_NV__25 }   /* nv=25 */,
  {     7,  8954,     0,   6,   0, UNI_nchar_values_index }   /* nchar= */,
  {    26,  9488,  7118,   4,  10, UNI_INCHORASMIAN }   /* blk=chorasmian */,
  {     5,   184,  1466,   3,  12, UNI_M }   /* iscombiningmark */,
  {     0, 10296, 10309,   3,   4, UNI_XPOSIXPRINT }   /* isprint */,
  {     1, 10048,     0,   3,   0, UNI_nv_values_index }   /* nv= */,
  {     8,  7218,  7268,  10,  10, UNI_LB__NS }   /* linebreak=nonstarter */,
  {     2,  5791,  4177,  13,  16, UNI_JG__MANICHAEANDALETH }   /* joininggroup=manichaeandaleth */,
  {     5,  8589,  8606,  10,   4, UNI_SHAW }   /* script=shavian */,
  {     1,  9688,     0,   4,   0, UNI_NKO }   /* nkoo */,
  {     0,  8780,  2589,   6,  19, UNI_ANCIENTGREEKNUMBERS }   /* block=ancientgreeknumbers */,
  {     0,  8589,  9696,   7,   4, UNI_OGAM }   /* script=ogam */,
  {    33, 10027,  6774,   3,  11, UNI_JG__MALAYALAMJA }   /* jg=malayalamja */,
  {     0,  3853, 10135,  17,   3, UNI_STERM }   /* sentenceterminal=yes */,
  {    17,  2288,  2724,   4,  17, UNI_JAMOEXTA }   /* inhanguljamoextendeda */,
  {     0,  7155,  9585,   3,   3, UNI_HLUW }   /* ishluw */,
  {     0, 10048,  9376,   3,   4, UNI_NV__1_SLASH_64 }   /* nv=1/64 */,
  {     0,   184,  3133,   2,   5, UNI_EMOJI }   /* isemoji */,
  {    42,  2140,     0,  18,   0, UNI_CYRILLICSUP }   /* cyrillicsupplement */,
  {     4,   184,  4793,   2,  15, UNI_MERC }   /* ismeroiticcursive */,
  {    11,  7540,  9836,   9,   4, UNI_EXT }   /* extender=true */,
  {     0,    78,     0,   6,   0, UNI_ARAB }   /* arabic */,
  {     0,  9520,  9255,   4,   5, -UNI_CWL }   /* cwl=false */,
  {     1,   184,  2032,   2,  21, UNI__PERL_NCHAR }   /* isnoncharactercodepoint */,
  {     5,  8351,     0,   7,   0, UNI_CJKEXTA }   /* cjkexta */,
  {     5,  7438,  4856,  10,   2, UNI_WB__DQ }   /* wordbreak=dq */,
  {     0,  8589,  8299,   7,   8, UNI_TFNG }   /* script=tifinagh */,
  {    13,  4628,  1192,  15,   9, UNI_EA__H }   /* eastasianwidth=halfwidth */,
  {     2,  9508,  9934,   4,   3, UNI_CCC__R }   /* ccc=226 */,
  {     0,  8589,  8990,   7,   6, UNI_RJNG }   /* script=rejang */,
  {    29, 10048,  7803,   3,   8, UNI_NV__1_SLASH_64 }   /* nv=1.56e-02 */,
  {     0,  8780,   951,   6,  28, UNI_VSSUP }   /* block=variationselectorssupplement */,
  {     0,  6484,     0,   4,   0, UNI_HUNG }   /* hung */,
  {     2,  3097,  6421,  18,  12, UNI_DT__NONCANON }   /* decompositiontype=noncanonical */,
  {     0,  3836,  7428,  17,   4, UNI_WARA }   /* scriptextensions=wara */,
  {     6, 10060,    36,   3,   1, UNI_RI }   /* ri=t */,
  {     2,  1188,  8292,   3,   7, UNI_INTAGBANWA }   /* intagbanwa */,
  {     3,   184,    47,   2,   1, UNI_M }   /* ism */,
  {    12,  6710,  3881,   4,   4, UNI_INCARIAN }   /* incarian */,
  {     0,  8780,  4273,   6,   7, UNI_INMYANMAR }   /* block=myanmar */,
  {     3,  9275,  3061,   5,  18, UNI_INSC__CONSONANTSUBJOINED }   /* insc=consonantsubjoined */,
  {     0,  9508,  9221,   5,   4, UNI_CCC__91 }   /* ccc=ccc91 */,
  {    13,  8589,  4385,   7,   4, UNI_TANG }   /* script=tang */,
  {     0,  7088,  2893,  10,  19, UNI_BC__RLO }   /* bidiclass=righttoleftoverride */,
  {     0,  8589,  7558,   7,   9, UNI_SC__QAAI }   /* script=inherited */,
  {     1,  7088, 10018,  10,   3, UNI_BC__FSI }   /* bidiclass=fsi */,
  {     3,  8780,  6505,   6,  12, UNI_PHAISTOS }   /* block=phaistosdisc */,
  {     0, 10024, 10168,   3,   2, UNI_CASEDLETTER }   /* gc=l& */,
  {     2, 10033,  5564,   3,   9, UNI_LB__QU }   /* lb=quotation */,
  {     3,  9488,  1033,   4,  27, UNI_ENCLOSEDCJK }   /* blk=enclosedcjklettersandmonths */,
  {     6,  2224,   780,   3,  29, UNI_SYMBOLSANDPICTOGRAPHSEXTA }   /* insymbolsandpictographsextendeda */,
  {     1,   184,  3870,   2,  17, UNI_SMALLFORMS }   /* issmallformvariants */,
  {     0,  9808,     0,   4,   0, UNI_TALU }   /* talu */,
  {     5,  6805,  4261,   6,  12, UNI_MISCMATHSYMBOLSB }   /* inmiscmathsymbolsb */,
  {     8,  3836,  9008,  17,   6, UNI_THAA }   /* scriptextensions=thaana */,
  {     6,  9277,    78,   3,   4, UNI_SC__ARAB }   /* sc=arab */,
  {     1,  2218,  9685,   3,   3, UNI_INNEWA }   /* innewa */,
  {     1,  3367,     0,  18,   0, UNI_patws_values_index }   /* patternwhitespace= */,
  {     1,  6061, 10135,  12,   3, UNI_BIDIC }   /* bidicontrol=yes */,
  {     0,  8780,  9305,   6,   5, UNI_INNUSHU }   /* block=nushu */,
  {     1,  9488,  8596,   4,   7, UNI_SC__SHRD }   /* blk=sharada */,
  {     0,  9768,  8344,   4,   4, UNI_BENG }   /* scx=beng */,
  {     6,  3853,     3,  17,   1, -UNI_STERM }   /* sentenceterminal=f */,
  {     1,   779,     0,  30,   0, UNI_SYMBOLSANDPICTOGRAPHSEXTA }   /* symbolsandpictographsextendeda */,
  {     1,  9260,  1025,   5,   2, -UNI_IDSB }   /* idsb=no */,
  {     1,  9768,  7621,   4,   9, UNI_NBAT }   /* scx=nabataean */,
  {     3,  8780,  2076,   6,  22, UNI_TRANSPORTANDMAP }   /* block=transportandmapsymbols */,
  {     0,  6469,     0,  12,   0, UNI_nt_values_index }   /* numerictype= */,
  {     0,  7218,  7522,  10,   9, UNI_LB__B2 }   /* linebreak=breakboth */,
  {     0,  9277,  9245,   3,   5, UNI_SC__DOGR }   /* sc=dogra */,
  {     0,  9488,   908,   4,  10, UNI_PUA }   /* blk=privateuse */,
  {     7, 10027,  6906,   3,  11, UNI_JG__ROHINGYAYEH }   /* jg=rohingyayeh */,
  {     3,  2288,  1656,   4,  21, UNI_COMPATJAMO }   /* inhangulcompatibilityjamo */,
  {     2,  3097,  1294,  18,   5, UNI_DT__SUP }   /* decompositiontype=super */,
  {     2,  9488,  4598,   4,  15, UNI_DIACRITICALSEXT }   /* blk=diacriticalsext */,
  {     0,  9508,  7950,   4,   1, UNI_CCC__9 }   /* ccc=9 */,
  {     5,  4065,     0,  16,   0, UNI_HALFANDFULLFORMS }   /* halfandfullforms */,
  {     2,  7088,  3700,  10,  17, UNI_BC__ES }   /* bidiclass=europeanseparator */,
  {    48,  8589,  2855,   7,   9, UNI_SC__MONG }   /* script=mongolian */,
  {     0,  7218,   395,  10,   2, UNI_LB__GL }   /* linebreak=gl */,
  {     1,  9008,     0,   4,   0, UNI_THAA }   /* thaa */,
  {     3,  9488,  6121,   4,  12, UNI_CYRILLICEXTC }   /* blk=cyrillicextc */,
  {     4,   184,  1944,   2,  22, UNI_EARLYDYNASTICCUNEIFORM }   /* isearlydynasticcuneiform */,
  {     8, 10024,  6035,   3,   2, UNI_PF }   /* gc=pf */,
  {     0, 10048,  8750,   3,   4, UNI_NV__8000 }   /* nv=8000 */,
  {     2,  4116,     6,   3,   2, UNI_IDC }   /* isidc */,
  {     7, 10048,  7858,   3,   2, UNI_NV__22 }   /* nv=22 */,
  {     1,  9488,  2609,   5,   5, UNI_INBRAHMI }   /* blk=brahmi */,
  {     0,  8115,     0,   4,   0, UNI_BASS }   /* bass */,
  {     2,  9768,  8477,   4,   7, UNI_MAKA }   /* scx=makasar */,
  {     0,  8780,   570,   7,  29, UNI_CJKEXTC }   /* block=cjkunifiedideographsextensionc */,
  {     0, 10033,  5585,   3,   2, UNI_EBASE }   /* lb=eb */,
  {    14,  2119,     0,  14,   0, UNI_CJKRADICALSSUP }   /* cjkradicalssup */,
  {     0,   493,     0,   3,   0, UNI_HAN }   /* han */,
  {     1,  3836,  2817,  17,   4, UNI_MERO }   /* scriptextensions=mero */,
  {     1, 10288,  6554,   3,  10, UNI_XIDC }   /* isxidcontinue */,
  {    65,   184,  6807,   2,  11, UNI_MISCSYMBOLS }   /* ismiscsymbols */,
  {    65,  9508,  9922,   4,   3, UNI_CCC__214 }   /* ccc=214 */,
  {   100,  8275,     0,   8,   0, UNI_SPECIALS }   /* specials */,
  {     0,  5986,  7890,  13,   2, UNI_NV__33 }   /* numericvalue=33 */,
  {     0,  2288,  1514,   3,  23, UNI_HIGHPUSURROGATES }   /* inhighprivateusesurrogates */,
  {    24,  2760,  5633,  19,   2, UNI_LB__H2 }   /* hangulsyllabletype=lv */,
  {    17,   184,   908,   2,  14, UNI_PUA }   /* isprivateusearea */,
  {     0,  9768,  8659,   4,   7, UNI_TIBT }   /* scx=tibetan */,
  {     4, 10129, 10135,   3,   3, UNI_VS }   /* vs=yes */,
  {     1,  7540,  9255,   9,   5, -UNI_EXT }   /* extender=false */,
  {     1,  9350,  1025,   5,   2, -UNI_XIDS }   /* xids=no */,
  {     1,  9768,  8645,   4,   7, UNI_LANA }   /* scx=taitham */,
  {     0,  8589,  2817,   7,  19, UNI_MERO }   /* script=meroitichieroglyphs */,
  {    11,  9504,     0,   4,   0, UNI_CANS }   /* cans */,
  {     0,  9277,  9580,   3,   4, UNI_SC__HANO }   /* sc=hano */,
  {    15, 10024,     1,   3,   1, UNI_N }   /* gc=n */,
  {    21,  3836,  9740,  17,   4, UNI_QAAI }   /* scriptextensions=qaai */,
  {    22, 10033,  5088,   3,  14, UNI_LB__SA }   /* lb=complexcontext */,
  {     0,  1417,  9223,  24,   2, UNI_CCC__91 }   /* canonicalcombiningclass=91 */,
  {     0,  9596,  6541,   4,  12, UNI_GCB__T }   /* hst=trailingjamo */,
  {     0,  8688,  3923,   4,  14, UNI_ARABICSUP }   /* isarabicsupplement */,
  {     4,   184,  3893,   2,  11, UNI_SGNW }   /* issignwriting */,
  {     0,  7118,     0,  10,   0, UNI_CHRS }   /* chorasmian */,
  {     4,     0,     0,  42,   0, UNI_UCASEXT }   /* unifiedcanadianaboriginalsyllabicsextended */,
  {     3, 10333,  6973,   3,   3, UNI_SYLO }   /* issylo */,
  {     5,  7088,  2509,  10,  11, UNI_BC__R }   /* bidiclass=righttoleft */,
  {     5,  9275,  4417,   5,   5, UNI_INSC__VOWEL }   /* insc=vowel */,
  {     0, 10024,  5494,   3,  14, UNI_MN }   /* gc=nonspacingmark */,
  {    32,  1552,  9225,   9,   5, UNI_XPOSIXCNTRL }   /* category=cntrl */,
  {    16,  9262,  9080,   3,   5, UNI_SB__AT }   /* sb=aterm */,
  {     0, 10033,   908,   3,   2, UNI_LB__PR }   /* lb=pr */,
  {     0,  7318,  7781,  10,   1, UNI_IN__4 }   /* presentin=4 */,
  {     0,  4883,     0,  15,   0, UNI_SARB }   /* oldsoutharabian */,
  {     0,  5791,  4773,  13,   3, UNI_JG__SAD }   /* joininggroup=sad */,
  {     1,   183,     0,  20,   0, UNI_MISCSYMBOLS }   /* miscellaneoussymbols */,
  {     1,  6231,  3081,   4,  16, UNI_COPTICEPACTNUMBERS }   /* incopticepactnumbers */,
  {     1,  5116,     1,  14,   1, -UNI_EMOD }   /* emojimodifier=n */,
  {     0,  3836,  9636,  17,   4, UNI_LINB }   /* scriptextensions=linb */,
  {    32,  8780,   349,   6,  33, UNI_SUPSYMBOLSANDPICTOGRAPHS }   /* block=supplementalsymbolsandpictographs */,
  {     0,  5018,     0,  14,   0, UNI_ANCIENTSYMBOLS }   /* ancientsymbols */,
  {     4, 10048,  7821,   3,   1, UNI_NV__8 }   /* nv=8 */,
  {     3,  5986,  9380,  13,   3, UNI_NV__1_SLASH_8 }   /* numericvalue=1/8 */,
  {     3,  9488,  8379,   4,   7, UNI_CJKEXTE }   /* blk=cjkexte */,
  {    24,  4916,  3458,   3,  10, UNI_TAIXUANJING }   /* istaixuanjing */,
  {     1,  8864,  9255,   6,   5, -UNI_EMOJI }   /* emoji=false */,
  {     1,  3836,  2560,  17,   4, UNI_MAND }   /* scriptextensions=mand */,
  {     1,  8912,     0,   4,   0, UNI_KHOJ }   /* khoj */,
  {     0,  8780,  8243,   6,   8, UNI_INMAHAJANI }   /* block=mahajani */,
  {     1,  9277,  3241,   3,   8, UNI_SC__GEOR }   /* sc=georgian */,
  {     1,  8187,     0,   4,   0, UNI_HIRA }   /* hira */,
  {    23,   184,  2054,   2,  22, UNI_MODIFIERLETTERS }   /* isspacingmodifierletters */,
  {     0,  1417,  7858,  24,   3, UNI_CCC__B }   /* canonicalcombiningclass=220 */,
  {     0,  9290,  9836,   5,   4, UNI_MATH }   /* math=true */,
  {     1,  5986,  9432,  13,   4, UNI_NV__5_SLASH_12 }   /* numericvalue=5/12 */,
  {     1,  9768,  9808,   4,   4, UNI_TALU }   /* scx=talu */,
  {    15,  3529,  9255,  18,   5, -UNI_VS }   /* variationselector=false */,
  {     0,  1537,  7170,   4,   8, UNI_INDIVESAKURU }   /* indivesakuru */,
  {     1,  3529,  9836,  18,   4, UNI_VS }   /* variationselector=true */,
  {     8,  1834,     1,  22,   1, -UNI_CWT }   /* changeswhentitlecased=n */,
  {     0,  3097,  2569,  18,   4, UNI_DT__VERT }   /* decompositiontype=vert */,
  {     2,  4916,  2297,   3,   3, UNI_THAI }   /* isthai */,
  {    51,  9556,    34,   4,   6, UNI_GCB__EX }   /* gcb=extend */,
  {     1,   184,  2350,   3,  19, UNI_PC }   /* isconnectorpunctuation */,
  {     8,  7158,     0,  10,   0, UNI_dia_values_index }   /* diacritic= */,
  {     2,  4033,   728,  16,   6, UNI_N }   /* generalcategory=number */,
  {     0, 10048,  8756,   3,   3, UNI_NV__900 }   /* nv=900 */,
  {     2,  9488,   113,   4,  25, UNI_DIACRITICALS }   /* blk=combiningdiacriticalmarks */,
  {     1,    96,     0,  10,   0, UNI_XPOSIXALPHA }   /* alphabetic */,
  {     0,  9488,  1677,   4,   9, UNI_LATINEXTE }   /* blk=latinexte */,
  {     0,   184,   809,   2,  29, UNI_ENCLOSEDIDEOGRAPHICSUP }   /* isenclosedideographicsupplement */,
  {     3,  8589,  8876,   7,   4, UNI_GOTH }   /* script=goth */,
  {     0, 10048,  7778,   3,   2, UNI_NV__21 }   /* nv=21 */,
  {     1,  2529,  1025,  20,   2, -UNI_TERM }   /* terminalpunctuation=no */,
  {     1,   184,  5746,   2,   5, UNI_EBASE }   /* isebase */,
  {     0,  8589,  1115,   7,   4, UNI_SC__HANG }   /* script=hang */,
  {    54,   184,  3295,   2,  18, UNI_LATINEXTADDITIONAL }   /* islatinextadditional */,
  {    31,  9488,  3683,   4,  16, UNI_ETHIOPICEXT }   /* blk=ethiopicextended */,
  {     3,  7438,  5746,  10,   5, UNI_WB__EB }   /* wordbreak=ebase */,
  {     5,  8589,  8091,   7,   8, UNI_ARMN }   /* script=armenian */,
  {    22,  7076,  1586,   3,  22, UNI_BYZANTINEMUSIC }   /* inbyzantinemusicalsymbols */,
  {     0,  7155,  8450,   3,   5, UNI_HYPHEN }   /* ishyphen */,
  {     0,  5791,     5,  13,   1, UNI_JG__E }   /* joininggroup=e */,
  {     1,  9277,  9656,   3,   4, UNI_MIAO }   /* sc=miao */,
  {     3, 10132,  8139,   3,   8, UNI_WB__EB }   /* wb=ebasegaz */,
  {     2,  1417,     0,  24,   0, UNI_ccc_values_index }   /* canonicalcombiningclass= */,
  {     1,  2529, 10135,  20,   3, UNI_TERM }   /* terminalpunctuation=yes */,
  {     4,  9816,     0,   4,   0, UNI_TAVT }   /* tavt */,
  {     5,  8768,    36,   6,   1, UNI_BIDIC }   /* bidic=t */,
  {     0,  9768,  8107,   4,   4, UNI_BALI }   /* scx=bali */,
  {     0,  8449,    36,   7,   1, UNI_HYPHEN }   /* hyphen=t */,
  {     1,  9444, 10102,   4,   3, UNI_AGE__5_DOT_2 }   /* age=v52 */,
  {    14,  5986,  8732,  13,   6, UNI_NV__500000 }   /* numericvalue=500000 */,
  {     0,  4916,  8584,   3,   3, UNI_TAGS }   /* istags */,
  {     8,  9788,     0,   4,   0, UNI_SHRD }   /* shrd */,
  {     2,  9488,  4973,   4,   8, UNI_VEDICEXT }   /* blk=vedicext */,
  {     1,  9488,  2855,   4,  12, UNI_MONGOLIANSUP }   /* blk=mongoliansup */,
  {     0,  9020,    36,   6,   1, UNI_XPOSIXUPPER }   /* upper=t */,
  {    24,  1417,  9221,  25,   4, UNI_CCC__91 }   /* canonicalcombiningclass=ccc91 */,
  {     1,  9488,  2429,   4,  20, UNI_ININSCRIPTIONALPAHLAVI }   /* blk=inscriptionalpahlavi */,
  {     1,  6277,     0,  12,   0, UNI_MAHJONG }   /* mahjongtiles */,
  {     0,   184,  8484,   2,   7, UNI_MAND }   /* ismandaic */,
  {     3,  8780,  2666,   7,  18, UNI_COUNTINGROD }   /* block=countingrodnumerals */,
  {     1,   184,  9864,   2,   4, UNI_WCHO }   /* iswcho */,
  {    33,  5060,     1,  14,   1, -UNI_CI }   /* caseignorable=n */,
  {     0,   184,     1,   2,   1, UNI_N }   /* isn */,
  {     7,  8780,  4478,   6,   7, UNI_BRAI }   /* block=braille */,
  {     8,  5578,  1867,  14,   5, UNI_SB__UP }   /* sentencebreak=upper */,
  {     6,  9768,  7651,   4,   4, UNI_ITAL }   /* scx=ital */,
  {     4, 10048,  8738,   3,   6, UNI_NV__600000 }   /* nv=600000 */,
  {    13,  3079,     0,   6,   0, UNI_COPT }   /* coptic */,
  {     8,  8589,  2224,   7,  21, UNI_PRTI }   /* script=inscriptionalparthian */,
  {     1,  3836,  9600,  17,   4, UNI_KALI }   /* scriptextensions=kali */,
  {    47,  1417,    16,  24,   1, UNI_CCC__B }   /* canonicalcombiningclass=b */,
  {     1,  8589,  2913,   8,   8, UNI_SUND }   /* script=sundanese */,
  {    33, 10048,  8019,   3,   8, UNI_NV__2_SLASH_3 }   /* nv=6.67e-01 */,
  {    32,  3424,     1,   3,  41, UNI_UCASEXT }   /* inunifiedcanadianaboriginalsyllabicsextended */,
  {    16,  9768,  8442,   4,   7, UNI_HANO }   /* scx=hanunoo */,
  {    26,  9070,  1025,   5,   2, -UNI_POSIXXDIGIT }   /* ahex=no */,
  {     0,   184,  8936,   2,   6, UNI_LYCI }   /* islycian */,
  {     1,  6253,     0,  12,   0, UNI_KHMERSYMBOLS }   /* khmersymbols */,
  {     0,  9768,  5843,   4,   9, UNI_MLYM }   /* scx=malayalam */,
  {     0, 10024,   341,   3,   2, UNI_PE }   /* gc=pe */,
  {     7,  9488,  3331,   4,  18, UNI_ORNAMENTALDINGBATS }   /* blk=ornamentaldingbats */,
  {     4,  9508,  3015,   4,   5, UNI_CCC__A }   /* ccc=above */,
  {     1,  9488,  3457,   4,  18, UNI_TAIXUANJING }   /* blk=taixuanjingsymbols */,
  {     0,  5791,  7199,  14,   9, UNI_JG__KNOTTEDHEH }   /* joininggroup=knottedheh */,
  {     5,  1417,  8795,  24,   3, UNI_CCC__103 }   /* canonicalcombiningclass=103 */,
  {     1,  5791, 10057,  13,   3, UNI_JG__REH }   /* joininggroup=reh */,
  {     3,  9488,  5688,   5,  12, UNI_BLOCKELEMENTS }   /* blk=blockelements */,
  {     0,  1878,     0,  22,   0, UNI_CJKCOMPATIDEOGRAPHSSUP }   /* cjkcompatideographssup */,
  {     1,  7318,  9840,  10,   4, UNI_IN__10 }   /* presentin=v100 */,
  {     0,  8780,  7291,   6,   7, UNI_INSOGDIAN }   /* block=sogdian */,
  {    24,  9277,  8990,   3,   6, UNI_RJNG }   /* sc=rejang */,
  {     0, 10027,  9648,   3,   4, UNI_JG__MEEM }   /* jg=meem */,
  {     5,  9724,     0,   4,   0, UNI_PHNX }   /* phnx */,
  {     2,   184,  2855,   2,  12, UNI_MONGOLIANSUP }   /* ismongoliansup */,
  {     1,  9768,  3241,   4,   8, UNI_GEOR }   /* scx=georgian */,
  {     4, 10033, 10160,   3,   2, UNI_LB__H3 }   /* lb=h3 */,
  {     2,  9492,   751,   4,   5, UNI_BPT__C }   /* bpt=close */,
  {     8,  8407,     0,   7,   0, UNI_DSRT }   /* deseret */,
  {    56, 10048,  8750,   3,   6, UNI_NV__800000 }   /* nv=800000 */,
  {     1,  2409,     0,  13,   0, UNI_GLAGOLITICSUP }   /* glagoliticsup */,
  {    16,  9768,  9592,   4,   4, UNI_HMNP }   /* scx=hmnp */,
  {     9,  8589,  9584,   7,   4, UNI_HLUW }   /* script=hluw */,
  {     1,  2280,  4885,   4,  13, UNI_SARB }   /* isoldsoutharabian */,
  {     1,  3836,  9664,  17,   4, UNI_MRO }   /* scriptextensions=mroo */,
  {   176,  6420,  9321,   3,   4, UNI_INOSAGE }   /* inosage */,
  {     1,  8780,  8906,   6,   6, UNI_KANBUN }   /* block=kanbun */,
  {    81,  1944,     0,  22,   0, UNI_EARLYDYNASTICCUNEIFORM }   /* earlydynasticcuneiform */,
  {     2,  9277,   382,   3,   4, UNI_EGYP }   /* sc=egyp */,
  {     0,  1087,     3,  27,   1, -UNI_PCM }   /* prependedconcatenationmark=f */,
  {     0,  8589,  7288,   7,  10, UNI_SOGO }   /* script=oldsogdian */,
  {    10,  9488,  5270,   4,  14, UNI_LATINEXTE }   /* blk=latinextendede */,
  {   112,  3836,  9900,  17,   4, UNI_ZZZZ }   /* scriptextensions=zzzz */,
  {     0,  8688,  2590,   3,  18, UNI_ANCIENTGREEKNUMBERS }   /* isancientgreeknumbers */,
  {    65,  9997, 10042,   3,   3, UNI_BC__LRO }   /* bc=lro */,
  {     0, 10033,  1465,   3,  13, UNI_LB__CM }   /* lb=combiningmark */,
  {    28,  8780,    43,   7,   8, UNI_CJKCOMPAT }   /* block=cjkcompat */,
  {    32,  7630,     0,   9,   0, UNI_TALU }   /* newtailue */,
  {     3,  9768,   493,   4,   3, UNI_HAN }   /* scx=han */,
  {     4, 10340,  9861,   3,   3, UNI_VAI }   /* isvaii */,
  {     4, 10027,  7045,   3,   3, UNI_JG__FEH }   /* jg=feh */,
  {     1,  6710,  3583,   4,  15, UNI_UCAS }   /* incanadiansyllabics */,
  {     2,  4791,  6798,   4,   9, UNI_INMEDEFAIDRIN }   /* inmedefaidrin */,
  {     4,  9768,  8456,   4,   7, UNI_KNDA }   /* scx=kannada */,
  {    56,  1527,     0,   9,   0, UNI__PERL_SURROGATE }   /* surrogate */,
  {     1,  8780,  2855,   6,  12, UNI_MONGOLIANSUP }   /* block=mongoliansup */,
  {     0,  6807,     0,  11,   0, UNI_MISCSYMBOLS }   /* miscsymbols */,
  {     1,  9290,     3,   5,   1, -UNI_MATH }   /* math=f */,
  {     0,  8780,  1677,   6,  23, UNI_LATINEXTADDITIONAL }   /* block=latinextendedadditional */,
  {     7,  9071, 10135,   4,   3, UNI_XPOSIXXDIGIT }   /* hex=yes */,
  {     0,  5986,  9203,  13,   2, UNI_NV__34 }   /* numericvalue=34 */,
  {     2,  8780,   540,   7,  29, UNI_CJKEXTB }   /* block=cjkunifiedideographsextensionb */,
  {     0,  9038,     0,   4,   0, UNI_YEZI }   /* yezi */,
  {    33,  5284,     0,  14,   0, UNI_LISUSUP }   /* lisusupplement */,
  {     9,  4033,  4958,  16,  15, UNI_UPPERCASELETTER }   /* generalcategory=uppercaseletter */,
  {     0,  3836,  9808,  17,   4, UNI_TALU }   /* scriptextensions=talu */,
  {     8,  3836,  9860,  17,   3, UNI_VAI }   /* scriptextensions=vai */,
  {     5,  9768,  9008,   4,   6, UNI_THAA }   /* scx=thaana */,
  {     0,  8589,  7278,   7,  10, UNI_XPEO }   /* script=oldpersian */,
  {     0,  3836,  3169,  17,   8, UNI_ETHI }   /* scriptextensions=ethiopic */,
  {     9,  1828,  9255,   6,   5, -UNI_CASED }   /* cased=false */,
  {     0, 10030,  6994,   3,  11, UNI_JT__T }   /* jt=transparent */,
  {     0,  9768,  8421,   4,   4, UNI_ELYM }   /* scx=elym */,
  {     2,  9488,  2061,   4,  15, UNI_MODIFIERLETTERS }   /* blk=modifierletters */,
  {     1,  8589,  9464,   7,   4, UNI_ARMN }   /* script=armn */,
  {     7,  9488,  8372,   4,   7, UNI_CJKEXTD }   /* blk=cjkextd */,
  {   100,  8589,  8912,   7,   6, UNI_SC__KHOJ }   /* script=khojki */,
  {     0,  9488,  4449,   5,   4, UNI_INBAMUM }   /* blk=bamum */,
  {    57,  8780,  8659,   6,   7, UNI_INTIBETAN }   /* block=tibetan */,
  {     2,  9235,  9255,   5,   5, -UNI_CWCM }   /* cwcm=false */,
  {     0,  3904,     3,  17,   1, -UNI_UIDEO }   /* unifiedideograph=f */,
  {     0,  7188,     0,   4,   0, UNI_KHAR }   /* khar */,
  {     2,  8780,  2477,   6,   3, UNI_PUA }   /* block=pua */,
  {    32,  8780,  7248,   6,  10, UNI_MISCARROWS }   /* block=miscarrows */,
  {   138,  9270,  5523,   3,  13, UNI_PHONETICEXTSUP }   /* inphoneticextsup */,
  {     0,  4916,  4929,   3,  14, UNI_TAMILSUP }   /* istamilsupplement */,
  {     1,  3836,  9632,  17,   4, UNI_LINA }   /* scriptextensions=lina */,
  {     0,  8780,     0,   6,   0, UNI_blk_values_index }   /* block= */,
  {    68,  8589,  9002,   7,   4, UNI_SC__TELU }   /* script=telu */,
  {    22,  5578,   339,  14,   2, UNI_SB__LO }   /* sentencebreak=lo */,
  {     0,  2349,     0,  20,   0, UNI_PC }   /* connectorpunctuation */,
  {     1,   184,  5674,   2,   5, UNI_BIDIM }   /* isbidim */,
  {    24, 10024,   908,   3,  10, UNI_CO }   /* gc=privateuse */,
  {    64,    21,  2308,   2,  21, UNI_YIJING }   /* inyijinghexagramsymbols */,
  {     0,  3836,  7648,  17,   9, UNI_ITAL }   /* scriptextensions=olditalic */,
  {     0,  9508,  3007,   4,  18, UNI_CCC__216 }   /* ccc=attachedaboveright */,
  {     2,  9503,     0,   2,   0, UNI_MC }   /* mc */,
  {     8,  9277,  5843,   3,   9, UNI_SC__MLYM }   /* sc=malayalam */,
  {     0,  9716,     1,   4,   1, -UNI_PCM }   /* pcm=n */,
  {    29,  9997,  2266,   3,  21, UNI_BC__PDI }   /* bc=popdirectionalisolate */,
  {     0, 10296, 10308,   7,   5, UNI_POSIXPRINT }   /* isposixprint */,
  {    32, 10027,  4193,   3,  16, UNI_JG__MANICHAEANLAMEDH }   /* jg=manichaeanlamedh */,
  {   138, 10333,  6886,   3,   3, UNI_SHAW }   /* isshaw */,
  {     0,  9488,  5074,   4,  14, UNI_CJKCOMPATFORMS }   /* blk=cjkcompatforms */,
  {    31,  3683,     0,  11,   0, UNI_ETHIOPICEXT }   /* ethiopicext */,
  {    17,  9768,  9740,   4,   4, UNI_QAAI }   /* scx=qaai */,
  {     3,  7218,   495,  10,   7, UNI_LB__NU }   /* linebreak=numeric */,
  {     6,  9540,     0,   4,   0, UNI_dia_values_index }   /* dia= */,
  {     0,  9070,     0,   5,   0, UNI_ahex_values_index }   /* ahex= */,
  {     0,  8780,  3633,   7,  16, UNI_CYRILLICEXTA }   /* block=cyrillicextendeda */,
  {     2,  4385,     0,  16,   0, UNI_TANGUTCOMPONENTS }   /* tangutcomponents */,
  {    50,  8780,  6098,   7,  11, UNI_CYRILLICEXTA }   /* block=cyrillicexta */,
  {     0,  9275,  4113,   5,  16, UNI_INSC__INVISIBLESTACKER }   /* insc=invisiblestacker */,
  {     0,  9488,  1344,   4,  25, UNI_SYMBOLSFORLEGACYCOMPUTING }   /* blk=symbolsforlegacycomputing */,
  {     1,  4542,  1633,   4,  13, UNI_GEOMETRICSHAPES }   /* ingeometricshapes */,
  {     4,  9488,  6397,   4,  12, UNI_MATHALPHANUM }   /* blk=mathalphanum */,
  {     4,  9345,     0,   5,   0, UNI_xidc_values_index }   /* xidc= */,
  {     1,  3836,  9588,  17,   4, UNI_HMNG }   /* scriptextensions=hmng */,
  {     0,  7228,  9836,  10,   4, UNI_XPOSIXLOWER }   /* lowercase=true */,
  {   166, 10024,   400,   3,   6, UNI_CF }   /* gc=format */,
  {     2,  9488,  5158,   4,  14, UNI_INGREEK }   /* blk=greekandcoptic */,
  {     1,   838,     0,  29,   0, UNI_MISCARROWS }   /* miscellaneoussymbolsandarrows */,
  {     4,  8882,     3,   6,   1, -UNI_GREXT }   /* grext=f */,
  {    16,  2288,  4675,   4,  13, UNI_INHANGUL }   /* inhangulsyllables */,
  {     0,  9270,  2549,   5,  20, UNI_INPC__TOPANDBOTTOMANDRIGHT }   /* inpc=topandbottomandright */,
  {     0,  3921,     0,  16,   0, UNI_ARABICSUP }   /* arabicsupplement */,
  {     8,    21,  2308,   2,   6, UNI_YIJING }   /* inyijing */,
  {     0,  7495,     0,   9,   0, UNI_ARABICPFA }   /* arabicpfa */,
  {     0,   184,  4340,   2,  13, UNI_MATHOPERATORS }   /* ismathoperators */,
  {     0,  9488,  5778,   4,   6, UNI_IPAEXT }   /* blk=ipaext */,
  {     0, 10027,  5620,   3,  10, UNI_JG__TEHMARBUTA }   /* jg=tehmarbuta */,
  {     0,  2182,    73,  21,   2, UNI_WB__EB }   /* graphemeclusterbreak=em */,
  {     0,  1979, 10169,  10,   1, UNI_CASEDLETTER }   /* category=l& */,
  {     0,  9528,     1,   4,   1, -UNI_CWU }   /* cwu=n */,
  {     0,  2760,  7720,  19,   9, UNI_GCB__V }   /* hangulsyllabletype=voweljamo */,
  {     5,   184, 10168,   2,   2, UNI_CASEDLETTER }   /* isl& */,
  {   182,  8365,     0,   7,   0, UNI_CJKEXTC }   /* cjkextc */,
  {     4,  9768,  2224,   4,  21, UNI_PRTI }   /* scx=inscriptionalparthian */,
  {     2,  9320,     0,   5,   0, UNI_OSGE }   /* osage */,
  {   144,  9020,  1025,   6,   2, -UNI_XPOSIXUPPER }   /* upper=no */,
  {     0,  9488,  1900,   4,  22, UNI_INDICNUMBERFORMS }   /* blk=commonindicnumberforms */,
  {     1,  5986,  8075,  13,   8, UNI_NV__7_SLASH_8 }   /* numericvalue=8.75e-01 */,
  {     0,  5116,  1025,  14,   2, -UNI_EMOD }   /* emojimodifier=no */,
  {   141,  9444, 10099,   4,   3, UNI_AGE__5_DOT_1 }   /* age=v51 */,
  {     0,  8688,  5719,   3,   4, UNI_XPOSIXALNUM }   /* isalnum */,
  {    12, 10333,     0,   7,   0, UNI_XPOSIXSPACE }   /* isspace */,
  {     2,  1631,     0,  23,   0, UNI_GEOMETRICSHAPESEXT }   /* geometricshapesextended */,
  {     1,  2288,  8188,   3,   7, UNI_INHIRAGANA }   /* inhiragana */,
  {     3,  9230, 10135,   5,   3, UNI_CWCF }   /* cwcf=yes */,
  {     9,  9508,  9931,   4,   3, UNI_CCC__L }   /* ccc=224 */,
  {     8,  9768,  9245,   4,   4, UNI_DOGR }   /* scx=dogr */,
  {     1,  6420,  7649,   3,   8, UNI_INOLDITALIC }   /* inolditalic */,
  {     0,  9768,  6973,   5,   3, UNI_SYLO }   /* scx=sylo */,
  {    37,  5578,    69,  14,   2, UNI_SB__UP }   /* sentencebreak=up */,
  {     2,  2280,  7290,   4,   8, UNI_SOGO }   /* isoldsogdian */,
  {     0,  5116,  9836,  14,   4, UNI_EMOD }   /* emojimodifier=true */,
  {     0,  9277,  6409,   3,   4, UNI_MEND }   /* sc=mend */,
  {   113, 10333,  2913,   3,   8, UNI_SUND }   /* issundanese */,
  {     2,  3836,  7675,  17,   4, UNI_PALM }   /* scriptextensions=palm */,
  {    34,  8589,  9548,   7,   4, UNI_DSRT }   /* script=dsrt */,
  {    10,  9768,  7118,   4,  10, UNI_CHRS }   /* scx=chorasmian */,
  {     0,  9997,  3374,   3,  10, UNI_BC__WS }   /* bc=whitespace */,
  {     1,  8852,  1025,   6,   2, -UNI_CWKCF }   /* cwkcf=no */,
  {     7,  2477,     0,   3,   0, UNI_PUA }   /* pua */,
  {     1,   184,   809,   2,  22, UNI_ENCLOSEDIDEOGRAPHICSUP }   /* isenclosedideographicsup */,
  {     0,  1417,     8,  24,   1, UNI_CCC__A }   /* canonicalcombiningclass=a */,
  {    46,  5466,    26,  14,   1, UNI_NFDQC__Y }   /* nfdquickcheck=y */,
  {     0,  2182,    24,  21,   1, UNI_GCB__L }   /* graphemeclusterbreak=l */,
  {     5,  9275,  1244,   5,   9, UNI_INSC__CONSONANT }   /* insc=consonant */,
  {     1, 10048,  8732,   3,   5, UNI_NV__50000 }   /* nv=50000 */,
  {     0, 10024, 10176,   3,   2, UNI_ZL }   /* gc=zl */,
  {     5,  9488,  4883,   4,  15, UNI_SARB }   /* blk=oldsoutharabian */,
  {    43,   184,  5270,   2,  14, UNI_LATINEXTE }   /* islatinextendede */,
  {     0, 10063,    26,   3,   1, UNI_SD }   /* sd=y */,
  {     0,  5791,  5918,  13,   3, UNI_JG__TAW }   /* joininggroup=taw */,
  {    10,  3385,     3,  18,   1, -UNI_RI }   /* regionalindicator=f */,
  {     2,  9488,  7594,   4,   9, UNI_LATINEXTD }   /* blk=latinextd */,
  {     0,  3836,  1900,  17,   6, UNI_ZYYY }   /* scriptextensions=common */,
  {     0, 10033, 10158,   3,   2, UNI_LB__H2 }   /* lb=h2 */,
  {   144,  9768,  7359,   5,   3, UNI_SAUR }   /* scx=saur */,
  {     1, 10048,  7859,   3,   6, UNI_NV__200000 }   /* nv=200000 */,
  {     0,  5986,  7923,  13,   8, UNI_NV__2_SLASH_5 }   /* numericvalue=4.00e-01 */,
  {    32,   184,  2141,   3,  10, UNI_CYRILLICSUP }   /* iscyrillicsup */,
  {     0,  4916,  3458,   3,  17, UNI_TAIXUANJING }   /* istaixuanjingsymbols */,
  {     4,  8780,  2141,   7,  17, UNI_CYRILLICSUP }   /* block=cyrillicsupplement */,
  {     7,  8780,  4448,   6,   5, UNI_INBAMUM }   /* block=bamum */,
  {     1,  8091,     0,   8,   0, UNI_ARMN }   /* armenian */,
  {    32,   184,     0,   3,   0, UNI_C }   /* isc */,
  {     0,   184,  8115,   2,   4, UNI_BASS }   /* isbass */,
  {     3,   184,  4583,   2,   4, UNI_DASH }   /* isdash */,
  {     1,  9488,  4401,   4,  16, UNI_TANGUTSUP }   /* blk=tangutsupplement */,
  {     1,  8780,  4257,   6,  16, UNI_MISCMATHSYMBOLSB }   /* block=miscmathsymbolsb */,
  {     2,  9015,     1,   5,   1, -UNI_IDEO }   /* ideo=n */,
  {     0,   184,  1677,   2,   5, UNI_LATN }   /* islatin */,
  {    12, 10288,  3379,   8,   5, UNI_XPOSIXSPACE }   /* isxposixspace */,
  {    89,  9488,  3439,   4,  18, UNI_SMALLKANAEXT }   /* blk=smallkanaextension */,
  {     1,  2569,     0,  20,   0, UNI_vo_values_index }   /* verticalorientation= */,
  {     0, 10024,  2268,   3,   2, UNI_PD }   /* gc=pd */,
  {    30,  9488,  5256,   4,  14, UNI_LATINEXTD }   /* blk=latinextendedd */,
  {     0,  8780,   567,   6,   2, UNI_NB }   /* block=nb */,
  {     4, 10048,  7859,   3,   2, UNI_NV__20 }   /* nv=20 */,
  {     0,  9444, 10123,   4,   3, UNI_AGE__9 }   /* age=v90 */,
  {     0,  1417,  8811,  25,   5, UNI_CCC__122 }   /* canonicalcombiningclass=ccc122 */,
  {     0,  9488,  7291,   4,   7, UNI_INSOGDIAN }   /* blk=sogdian */,
  {    36, 10003,     1,   3,   1, -UNI_CI }   /* ci=n */,
  {     1,  9277,  2817,   3,   4, UNI_MERO }   /* sc=mero */,
  {     0, 10030,  6529,   3,  12, UNI_JT__R }   /* jt=rightjoining */,
  {     2,  3836,  9325,  17,   5, UNI_RUNR }   /* scriptextensions=runic */,
  {     0,  7058,     0,  10,   0, UNI_ARABICEXTA }   /* arabicexta */,
  {     0,  3836,  8786,  17,   6, UNI_CARI }   /* scriptextensions=carian */,
  {     8,  4658,     1,  15,   1, -UNI_GREXT }   /* graphemeextend=n */,
  {     6,  9768,  1900,   4,   6, UNI_ZYYY }   /* scx=common */,
  {    25,  9488,  2817,   4,  19, UNI_MERO }   /* blk=meroitichieroglyphs */,
  {     0,    21,  5214,   2,   6, UNI_KANGXI }   /* inkangxi */,
  {    65,  9488,  8990,   4,   6, UNI_INREJANG }   /* blk=rejang */,
  {     0,  7318,  9955,  10,   3, UNI_IN__3_DOT_2 }   /* presentin=3.2 */,
  {     0,  7325,  9388,   3,   4, UNI_IN__11 }   /* in=11.0 */,
  {     1,  5791,  4193,  13,  16, UNI_JG__MANICHAEANLAMEDH }   /* joininggroup=manichaeanlamedh */,
  {     3, 10027,  3785,   3,  17, UNI_JG__MANICHAEANDHAMEDH }   /* jg=manichaeandhamedh */,
  {     2,  2855,     0,  19,   0, UNI_MONGOLIANSUP }   /* mongoliansupplement */,
  {     0,   749,     0,  30,   0, UNI_ENCLOSEDALPHANUMSUP }   /* enclosedalphanumericsupplement */,
  {     0,  8780,  6012,   6,  13, UNI_VERTICALFORMS }   /* block=verticalforms */,
  {     1,  7325,  7765,   3,   1, UNI_IN__2 }   /* in=2 */,
  {     2,  9488,  6097,   4,  12, UNI_CYRILLICEXTA }   /* blk=cyrillicexta */,
  {     2,  8589,     0,   7,   0, UNI_sc_values_index }   /* script= */,
  {     3,   446,     0,  18,   0, UNI_IDEOGRAPHICSYMBOLS }   /* ideographicsymbols */,
  {     0,  5986,  9208,  13,   2, UNI_NV__35 }   /* numericvalue=35 */,
  {     0,  9277,  2203,   3,   4, UNI_SC__HAN }   /* sc=hani */,
  {    10,  9277,  2409,   3,  10, UNI_SC__GLAG }   /* sc=glagolitic */,
  {     2,  8984,  9836,   6,   4, UNI_QMARK }   /* qmark=true */,
  {     3,  5452,  9295,  14,   5, UNI_NFCQC__M }   /* nfcquickcheck=maybe */,
  {     0,  9508,  9218,   4,   2, UNI_CCC__84 }   /* ccc=84 */,
  {     1,  5791,  5312,  13,  14, UNI_JG__MANICHAEANAYIN }   /* joininggroup=manichaeanayin */,
  {     3,   184,  3683,   2,  17, UNI_ETHIOPICEXTA }   /* isethiopicextendeda */,
  {     2, 10027,  7055,   3,   3, UNI_JG__QAF }   /* jg=qaf */,
  {     0,  2076,     0,  22,   0, UNI_TRANSPORTANDMAP }   /* transportandmapsymbols */,
  {     2,    21,  8900,   2,   6, UNI_INKAITHI }   /* inkaithi */,
  {     0,  8882,     0,   5,   0, UNI_GREXT }   /* grext */,
  {    24,  9488,  1393,   4,  24, UNI_ARABICPFB }   /* blk=arabicpresentationformsb */,
  {    64,  1552,  4583,   9,  15, UNI_PD }   /* category=dashpunctuation */,
  {     0,  7438,  7730,  11,   8, UNI_WB__WSEGSPACE }   /* wordbreak=wsegspace */,
  {     0,  9768,  9864,   4,   4, UNI_WCHO }   /* scx=wcho */,
  {     1, 10024, 10178,   3,   2, UNI_ZP }   /* gc=zp */,
  {     0, 10027,  6361,   3,  12, UNI_JG__MALAYALAMTTA }   /* jg=malayalamtta */,
  {    40,  5986,  9408,  13,   4, UNI_NV__15_SLASH_2 }   /* numericvalue=15/2 */,
  {     5,  5791,  5410,  13,  14, UNI_JG__MANICHAEANTETH }   /* joininggroup=manichaeanteth */,
  {    13,  7088,  6493,  10,  12, UNI_BC__ON }   /* bidiclass=otherneutral */,
  {    32,  8780,  1060,   7,   5, UNI_INCOPTIC }   /* block=coptic */,
  {    32,  9488,  5186,   4,  14, UNI_HIGHSURROGATES }   /* blk=highsurrogates */,
  {     8,  9768,  7648,   4,   9, UNI_ITAL }   /* scx=olditalic */,
  {    37,  3529,     0,  18,   0, UNI_vs_values_index }   /* variationselector= */,
  {     3,  8624,     0,   7,   0, UNI_SUPPUAA }   /* suppuaa */,
  {     0,  1188,  2077,   3,  14, UNI_TRANSPORTANDMAP }   /* intransportandmap */,
  {    97,  9488,  4449,   5,   7, UNI_BAMUMSUP }   /* blk=bamumsup */,
  {     1,   184,  8344,   2,   4, UNI_BENG }   /* isbeng */,
  {     1,  1417,  9934,  24,   3, UNI_CCC__R }   /* canonicalcombiningclass=226 */,
  {     6,  9768,  9816,   4,   4, UNI_TAVT }   /* scx=tavt */,
  {    82,  7738,     1,   9,   1, -UNI_XIDS }   /* xidstart=n */,
  {     2,  8123,     0,   4,   0, UNI_BUGI }   /* bugi */,
  {   166,  4257,     0,  16,   0, UNI_MISCMATHSYMBOLSB }   /* miscmathsymbolsb */,
  {    56,  5986,  9416,  13,   4, UNI_NV__3_SLASH_16 }   /* numericvalue=3/16 */,
  {     0,  9768,  8924,   4,   6, UNI_LEPC }   /* scx=lepcha */,
  {    33,  8966,     0,   6,   0, UNI_nfdqc_values_index }   /* nfdqc= */,
  {     0,  1087,  9255,  27,   5, -UNI_PCM }   /* prependedconcatenationmark=false */,
  {     0,  8780,  3169,   6,   8, UNI_INETHIOPIC }   /* block=ethiopic */,
  {     0,   184,  5256,   2,  14, UNI_LATINEXTD }   /* islatinextendedd */,
  {     0,  8589,  8115,   7,   4, UNI_BASS }   /* script=bass */,
  {     0,  7155,  1655,   3,  22, UNI_COMPATJAMO }   /* ishangulcompatibilityjamo */,
  {     0,  8780,  3650,   7,  16, UNI_CYRILLICEXTB }   /* block=cyrillicextendedb */,
  {    53,  9997,  5494,   3,  14, UNI_BC__NSM }   /* bc=nonspacingmark */,
  {     0,  5791,  5396,  13,  14, UNI_JG__MANICHAEANRESH }   /* joininggroup=manichaeanresh */,
  {     2,  9556,    18,   4,   2, UNI_RI }   /* gcb=ri */,
  {     2,  8780,  6110,   7,  11, UNI_CYRILLICEXTB }   /* block=cyrillicextb */,
  {     3,  9488,  3079,   4,   6, UNI_INCOPTIC }   /* blk=coptic */,
  {     8,  7155,  6485,   3,   3, UNI_HUNG }   /* ishung */,
  {     0,  5791,  5882,  13,  13, UNI_JG__MANICHAEANNUN }   /* joininggroup=manichaeannun */,
  {     1,  5791,  7038,  13,  10, UNI_JG__AFRICANFEH }   /* joininggroup=africanfeh */,
  {     2,  4628,     1,  15,   1, UNI_EA__N }   /* eastasianwidth=n */,
  {     1,  9768,  3169,   4,   8, UNI_ETHI }   /* scx=ethiopic */,
  {     1,  8780,  7504,   6,   9, UNI_ARABICPFB }   /* block=arabicpfb */,
  {     0, 10033, 10162,   3,   2, UNI_GCB__L }   /* lb=jl */,
  {     0,  9277,  9764,   3,   4, UNI_SARB }   /* sc=sarb */,
  {     3,    21,  5284,   2,   4, UNI_INLISU }   /* inlisu */,
  {     0,  8780,  9452,   6,   4, UNI_INAHOM }   /* block=ahom */,
  {     0,  3097,  8163,  18,   3, UNI_DT__FRA }   /* decompositiontype=fra */,
  {     1,  9260, 10135,   5,   3, UNI_IDSB }   /* idsb=yes */,
  {     3,  9262,   112,   3,   2, UNI_SB__SC }   /* sb=sc */,
  {     6,  9768,  3937,   4,   4, UNI_BOPO }   /* scx=bopo */,
  {     3,  3382,     0,   3,   0, UNI_ce_values_index }   /* ce= */,
  {     0,  5986,  5648,  13,   3, UNI_NV__100 }   /* numericvalue=100 */,
  {     1,  7438,   138,  10,   2, UNI_WB__FO }   /* wordbreak=fo */,
  {   214,  8882,  9255,   6,   5, -UNI_GREXT }   /* grext=false */,
  {     1,  9351,     3,   4,   1, -UNI_IDS }   /* ids=f */,
  {     0,  1273,     1,  21,   1, -UNI_CE }   /* compositionexclusion=n */,
  {     1,  9277,  9788,   3,   4, UNI_SC__SHRD }   /* sc=shrd */,
  {     1,  9488,  4161,   4,  16, UNI_LINEARBSYLLABARY }   /* blk=linearbsyllabary */,
  {     0,    21,  8456,   2,   7, UNI_INKANNADA }   /* inkannada */,
  {     0,  8589,  6181,   7,  12, UNI_SC__GONG }   /* script=gunjalagondi */,
  {    16,  8358,     0,   7,   0, UNI_CJKEXTB }   /* cjkextb */,
  {     1,  9262,   125,   3,   2, UNI_LB__CR }   /* sb=cr */,
  {     1, 10027,  5882,   3,  13, UNI_JG__MANICHAEANNUN }   /* jg=manichaeannun */,
  {     2,  8589,  9564,   7,   4, UNI_SC__GONM }   /* script=gonm */,
  {     0,  9768,  9095,   4,   5, UNI_BUHD }   /* scx=buhid */,
  {     0,  9444, 10096,   4,   3, UNI_AGE__5 }   /* age=v50 */,
  {     2,  1188,  4929,   3,   7, UNI_TAMILSUP }   /* intamilsup */,
  {     8,  7218,   202,  10,   2, UNI_LB__SA }   /* linebreak=sa */,
  {    33,  9277,  7358,   3,  10, UNI_SAUR }   /* sc=saurashtra */,
  {     0,  7218,   988,  10,   2, UNI_LB__CP }   /* linebreak=cp */,
  {     1,  7088,  2489,  10,  20, UNI_BC__PDF }   /* bidiclass=popdirectionalformat */,
  {     5, 10027,  5179,   3,   7, UNI_JG__HEHGOAL }   /* jg=hehgoal */,
  {     8, 10024,  2349,   3,  20, UNI_PC }   /* gc=connectorpunctuation */,
  {     9,  1966,  3061,  22,  18, UNI_INSC__CONSONANTSUBJOINED }   /* indicsyllabiccategory=consonantsubjoined */,
  {    48,  7325,  9396,   3,   4, UNI_IN__12_DOT_1 }   /* in=12.1 */,
  {     0,  7438,    34,  10,   2, UNI_WB__EX }   /* wordbreak=ex */,
  {    24, 10012,     3,   3,   1, UNI_EA__F }   /* ea=f */,
  {     1,  4033,  5040,  16,   5, UNI_XPOSIXDIGIT }   /* generalcategory=digit */,
  {     2, 10333,  8632,   3,   6, UNI_SUPPUAB }   /* issuppuab */,
  {   105,  9768,  9684,   4,   4, UNI_NEWA }   /* scx=newa */,
  {    32,  1166,  1025,  26,   2, -UNI_DI }   /* defaultignorablecodepoint=no */,
  {     3,  9488,  7128,   4,  10, UNI_CJKSTROKES }   /* blk=cjkstrokes */,
  {     0,  5791,  4773,  13,   5, UNI_JG__SADHE }   /* joininggroup=sadhe */,
  {    14,  4033,   467,  16,  11, UNI_P }   /* generalcategory=punctuation */,
  {     0,  8780,  8291,   6,   8, UNI_INTAGBANWA }   /* block=tagbanwa */,
  {     1,  6553,     0,   4,   0, UNI_XIDC }   /* xidc */,
  {    10,  8435,    26,   7,   1, UNI_GRBASE }   /* grbase=y */,
  {    16,  9488,   809,   4,  22, UNI_ENCLOSEDIDEOGRAPHICSUP }   /* blk=enclosedideographicsup */,
  {    36,  6805,  4245,   6,  12, UNI_MISCMATHSYMBOLSA }   /* inmiscmathsymbolsa */,
  {   137,   184,  5752,   2,   8, UNI_GREEKEXT }   /* isgreekext */,
  {     3,  7088,  2266,  10,  21, UNI_BC__PDI }   /* bidiclass=popdirectionalisolate */,
  {    67,  9270,  2455,   5,   5, UNI_INPC__RIGHT }   /* inpc=right */,
  {     0,  1417,  7078,  24,  10, UNI_CCC__BR }   /* canonicalcombiningclass=belowright */,
  {     4,  4916,  4929,   3,   4, UNI_TAML }   /* istamil */,
  {    65,  7088,  2509,  10,  20, UNI_BC__RLE }   /* bidiclass=righttoleftembedding */,
  {     0,  9768,  8421,   4,   7, UNI_ELYM }   /* scx=elymaic */,
  {     9,  8694,  9836,   7,   4, UNI_XPOSIXSPACE }   /* wspace=true */,
  {     0,  3836,  7359,  18,   9, UNI_SAUR }   /* scriptextensions=saurashtra */,
  {     4,  7076,  8124,   3,   7, UNI_INBUGINESE }   /* inbuginese */,
  {     0,  1966,  5102,  22,  14, UNI_INSC__CONSONANTFINAL }   /* indicsyllabiccategory=consonantfinal */,
  {     4,  9768,  8131,   4,   4, UNI_DUPL }   /* scx=dupl */,
  {     0,  8780,  1006,   6,  17, UNI_ANCIENTGREEKMUSIC }   /* block=ancientgreekmusic */,
  {     1,  9488,  8291,   4,   8, UNI_INTAGBANWA }   /* blk=tagbanwa */,
  {     3,   184,  4129,   2,  16, UNI_LATIN1 }   /* islatin1supplement */,
  {     0,  9265,  9836,   5,   4, UNI_IDST }   /* idst=true */,
  {    42,  9488,  5171,   4,   4, UNI_INCHAM }   /* blk=cham */,
  {     3,  9488,  2287,   4,  21, UNI_SINHALAARCHAICNUMBERS }   /* blk=sinhalaarchaicnumbers */,
  {     1,  9488,  7585,   4,   9, UNI_LATINEXTC }   /* blk=latinextc */,
  {     0,  9488,   328,   4,  21, UNI_MATHOPERATORS }   /* blk=mathematicaloperators */,
  {     0,  4628,  9868,  15,   4, UNI_EA__W }   /* eastasianwidth=wide */,
  {    57, 10333,  2288,   3,   6, UNI_SINH }   /* issinhala */,
  {     0,  4033,  3358,  16,   9, UNI_Z }   /* generalcategory=separator */,
  {    12,  5791,  6323,  13,   5, UNI_JG__GAMAL }   /* joininggroup=gamal */,
  {     0,  9488,  5003,   4,  15, UNI_INZANABAZARSQUARE }   /* blk=zanabazarsquare */,
  {     2,  9345,     3,   5,   1, -UNI_XIDC }   /* xidc=f */,
  {    16,  3836,  9880,  17,   4, UNI_YI }   /* scriptextensions=yiii */,
  {   260,  3836,  8666,  17,   7, UNI_TIRH }   /* scriptextensions=tirhuta */,
  {     0,  5791,  8155,  13,   8, UNI_JG__FARSIYEH }   /* joininggroup=farsiyeh */,
  {     0,  8780,  4241,   6,  16, UNI_MISCMATHSYMBOLSA }   /* block=miscmathsymbolsa */,
  {     3, 10009,  5904,   3,   4, UNI_DT__NONE }   /* dt=none */,
  {   275,   184,  8352,   3,   6, UNI_CJKEXTA }   /* iscjkexta */,
  {     0,  9277,  6884,   3,  11, UNI_HMNG }   /* sc=pahawhhmong */,
  {    19, 10033,  5046,   3,  14, UNI_LB__CR }   /* lb=carriagereturn */,
  {     2,  2224,  1562,   3,  23, UNI_SUPSYMBOLSANDPICTOGRAPHS }   /* insupsymbolsandpictographs */,
  {     5,  9488,    42,   4,  26, UNI_CJKCOMPATIDEOGRAPHS }   /* blk=cjkcompatibilityideographs */,
  {    93,  7088,    23,  10,   2, UNI_BC__AL }   /* bidiclass=al */,
  {     9,  8780,  5270,   6,  14, UNI_LATINEXTE }   /* block=latinextendede */,
  {     1,  9488,  7168,   4,  10, UNI_INDIVESAKURU }   /* blk=divesakuru */,
  {     2,   184,  4017,   2,  16, UNI_PF }   /* isfinalpunctuation */,
  {     2,  5986,  8067,  13,   8, UNI_NV__17_SLASH_2 }   /* numericvalue=8.50e+00 */,
  {     0,  8780,  8484,   6,   7, UNI_INMANDAIC }   /* block=mandaic */,
  {     6,  8780,  3421,   6,   4, UNI_RUMI }   /* block=rumi */,
  {     0, 10027,  5326,   3,  14, UNI_JG__MANICHAEANBETH }   /* jg=manichaeanbeth */,
  {     0,  3836,    78,  17,   4, UNI_ARAB }   /* scriptextensions=arab */,
  {     5,  3836,  8645,  17,   7, UNI_LANA }   /* scriptextensions=taitham */,
  {     1,  9277,  8477,   3,   4, UNI_MAKA }   /* sc=maka */,
  {     1,  1537,  7298,  24,  10, UNI_INPC__OVERSTRUCK }   /* indicpositionalcategory=overstruck */,
  {     1,  9488,  9800,   4,   4, UNI_TAGS }   /* blk=tags */,
  {     0,  5606,     0,  14,   0, UNI_SUPPUNCTUATION }   /* suppunctuation */,
  {     0,  6554,     0,   3,   0, UNI_IDC }   /* idc */,
  {    86,  3836,  5284,  17,   4, UNI_LISU }   /* scriptextensions=lisu */,
  {     1,  9488,  3887,   4,  17, UNI_SUTTONSIGNWRITING }   /* blk=suttonsignwriting */,
  {     0,  8435, 10135,   7,   3, UNI_GRBASE }   /* grbase=yes */,
  {     0,   184,  4002,   3,   6, UNI_CPRT }   /* iscypriot */,
  {     0, 10033,  9557,   3,   2, UNI_LB__CB }   /* lb=cb */,
  {     0,  8780,  2141,   7,  10, UNI_CYRILLICSUP }   /* block=cyrillicsup */,
  {     1,  3836,    78,  17,   6, UNI_ARAB }   /* scriptextensions=arabic */,
  {    13,   184,  9608,   2,   4, UNI_KITS }   /* iskits */,
  {   137,   184,  7540,   2,   8, UNI_EXT }   /* isextender */,
  {     1,  7325,  7782,   3,   1, UNI_IN__3 }   /* in=3 */,
  {    36,  2308,     0,  21,   0, UNI_YIJING }   /* yijinghexagramsymbols */,
  {     0,  5986,  8010,  13,   2, UNI_NV__36 }   /* numericvalue=36 */,
  {     1,  5578,  1089,  15,   2, UNI_SB__SE }   /* sentencebreak=sep */,
  {     3,  9668,     0,   4,   0, UNI_MTEI }   /* mtei */,
  {     2,  3379,  9836,   6,   4, UNI_XPOSIXSPACE }   /* space=true */,
  {     0,  6061,  9255,  12,   5, -UNI_BIDIC }   /* bidicontrol=false */,
  {     0,  6609,     0,  10,   0, UNI_DEP }   /* deprecated */,
  {     2, 10048,  7947,   3,   8, UNI_NV__3_SLASH_64 }   /* nv=4.69e-02 */,
  {     3,  4643,  9255,  15,   5, -UNI_ECOMP }   /* emojicomponent=false */,
  {    64,  8780,  8631,   6,   7, UNI_SUPPUAB }   /* block=suppuab */,
  {     3,   184,  8498,   2,   4, UNI_MULT }   /* ismult */,
  {     1,  9644,     0,   4,   0, UNI_MEDF }   /* medf */,
  {     0, 10048,  9416,   3,   4, UNI_NV__3_SLASH_16 }   /* nv=3/16 */,
  {     1,  9265,  1025,   5,   2, -UNI_IDST }   /* idst=no */,
  {     0,  1006,     0,  27,   0, UNI_ANCIENTGREEKMUSIC }   /* ancientgreekmusicalnotation */,
  {     1,  8589,  9672,   7,   4, UNI_SC__MYMR }   /* script=mymr */,
  {     1,    21,  3751,   2,  17, UNI_INKHITANSMALLSCRIPT }   /* inkhitansmallscript */,
  {     0,  4116,   415,   3,  31, UNI_INIDC }   /* isideographicdescriptioncharacters */,
  {     3, 10024, 10180,   3,   2, UNI_ZS }   /* gc=zs */,
  {     1, 10033,   340,   3,   2, UNI_LB__OP }   /* lb=op */,
  {     5,  9488,   749,   4,  30, UNI_ENCLOSEDALPHANUMSUP }   /* blk=enclosedalphanumericsupplement */,
  {    14,   184,  1184,   2,   3, UNI_DEP }   /* isdep */,
  {     2,  6231,  2667,   4,  17, UNI_COUNTINGROD }   /* incountingrodnumerals */,
  {     0,  8780,  8526,   6,   7, UNI_NB }   /* block=noblock */,
  {    79,  7438,  7612,  10,   6, UNI_WB__MN }   /* wordbreak=midnum */,
  {   136,  5986,  7955,  13,   8, UNI_NV__1_SLASH_20 }   /* numericvalue=5.00e-02 */,
  {     5,   184,  2161,   2,  20, UNI_EXTPICT }   /* isextendedpictographic */,
  {     3,  2280,  1759,   4,   2, UNI_OLCK }   /* isolck */,
  {     0,   184,  1115,   3,  24, UNI_CWKCF }   /* ischangeswhennfkccasefolded */,
  {     2,  9071,  9255,   4,   5, -UNI_XPOSIXXDIGIT }   /* hex=false */,
  {     0,   184,  1044,   2,   6, UNI_L }   /* isletter */,
  {     0,  9768,  3785,   4,  10, UNI_MANI }   /* scx=manichaean */,
  {     4,  3836,  6484,  17,   4, UNI_HUNG }   /* scriptextensions=hung */,
  {     0,  9488,   979,   4,  27, UNI_ALPHABETICPF }   /* blk=alphabeticpresentationforms */,
  {     4,  5791,  9884,  13,   4, UNI_JG__ZAIN }   /* joininggroup=zain */,
  {    31,  8780,  7239,   6,   2, UNI_INVS }   /* block=vs */,
  {    72,  9997,  4493,   3,  15, UNI_BC__CS }   /* bc=commonseparator */,
  {     2,  1768,  9836,  22,   4, UNI_CWCF }   /* changeswhencasefolded=true */,
  {     0,  7318,     0,  10,   0, UNI_in_values_index }   /* presentin= */,
  {    13, 10024,  4017,   3,  16, UNI_PF }   /* gc=finalpunctuation */,
  {     2, 10048,  9360,   3,   4, UNI_NV___MINUS_1_SLASH_2 }   /* nv=-1/2 */,
  {     0,  4241,     0,  16,   0, UNI_MISCMATHSYMBOLSA }   /* miscmathsymbolsa */,
  {     0, 10048,  8726,   3,   6, UNI_NV__432000 }   /* nv=432000 */,
  {     0,  3836,  9688,  17,   3, UNI_NKO }   /* scriptextensions=nko */,
  {     1,  8780,  6122,   7,  11, UNI_CYRILLICEXTC }   /* block=cyrillicextc */,
  {     4,  8780,  2061,   6,  15, UNI_MODIFIERLETTERS }   /* block=modifierletters */,
  {     0,  8780,  8123,   6,   8, UNI_INBUGINESE }   /* block=buginese */,
  {     3,  8780,  3667,   7,  16, UNI_CYRILLICEXTC }   /* block=cyrillicextendedc */,
  {   137,   414,     0,  32,   0, UNI_INIDC }   /* ideographicdescriptioncharacters */,
  {   290,  9488,  7288,   4,  10, UNI_INOLDSOGDIAN }   /* blk=oldsogdian */,
  {     0,  9786,  8598,   4,   5, UNI_SC__SHRD }   /* insharada */,
  {     0,  9768,  8463,   4,   7, UNI_KALI }   /* scx=kayahli */,
  {     0,  1188,  4402,   3,   8, UNI_TANGUTSUP }   /* intangutsup */,
  {     0,   184,   867,   2,  11, UNI_PHONETICEXT }   /* isphoneticext */,
  {     4, 10296,  7207,   3,   3, UNI_PHLI }   /* isphli */,
  {    11,  9508,  9928,   4,   3, UNI_CCC__BR }   /* ccc=222 */,
  {     8,  3367,     0,  17,   0, UNI__PERL_PATWS }   /* patternwhitespace */,
  {     1,  5986,  7859,  13,   8, UNI_NV__20000000 }   /* numericvalue=20000000 */,
  {     0,   728,     0,   6,   0, UNI_N }   /* number */,
  {     1, 10048,  7779,   3,   8, UNI_NV__1_SLASH_7 }   /* nv=1.43e-01 */,
  {     1,  1166,     1,  26,   1, -UNI_DI }   /* defaultignorablecodepoint=n */,
  {     9,  9752,     0,   4,   0, UNI_ROHG }   /* rohg */,
  {     0,  1966,  3615,  22,  17, UNI_INSC__CONSONANTPREFIXED }   /* indicsyllabiccategory=consonantprefixed */,
  {     6,  8780,  7388,   6,  10, UNI_SUPARROWSB }   /* block=suparrowsb */,
  {     2,  1966,  2369,  22,  20, UNI_INSC__CONSONANTPLACEHOLDER }   /* indicsyllabiccategory=consonantplaceholder */,
  {     0,  5986,  7859,  13,   4, UNI_NV__2000 }   /* numericvalue=2000 */,
  {     4,  4129,     0,   6,   0, UNI_LATIN1 }   /* latin1 */,
  {     4, 10033,     3,   4,   1, UNI_LB__LF }   /* lb=lf */,
  {     5,  9275,  3953,   5,  16, UNI_INSC__CANTILLATIONMARK }   /* insc=cantillationmark */,
  {    36,  4033,   206,  16,   2, UNI_PI }   /* generalcategory=pi */,
  {     7,  9572,     0,   4,   0, UNI_GUJR }   /* gujr */,
  {     1,  6961,     0,  11,   0, UNI_SUPERANDSUB }   /* superandsub */,
  {     5,  9488,   509,   4,  20, UNI_CJK }   /* blk=cjkunifiedideographs */,
  {     0,  1294,     0,  25,   0, UNI_SUPERANDSUB }   /* superscriptsandsubscripts */,
  {    76,  9277,  8659,   3,   7, UNI_TIBT }   /* sc=tibetan */,
  {     1,  7249,  6600,   4,   9, UNI_CASEDLETTER }   /* iscasedletter */,
  {     0,  4033,  3985,  16,  16, UNI_PE }   /* generalcategory=closepunctuation */,
  {     0,  9270,  3475,   5,  10, UNI_INPC__TOPANDLEFT }   /* inpc=topandleft */,
  {     1,  3836,  8115,  17,   4, UNI_BASS }   /* scriptextensions=bass */,
  {     2,  8780,  7027,   6,  11, UNI_YISYLLABLES }   /* block=yisyllables */,
  {     1,  9351,  9836,   4,   4, UNI_IDS }   /* ids=true */,
  {     0,  8379,     0,   7,   0, UNI_CJKEXTE }   /* cjkexte */,
  {     0,  8780,  4129,   6,  16, UNI_LATIN1 }   /* block=latin1supplement */,
  {    43,  9277,  9876,   3,   4, UNI_XSUX }   /* sc=xsux */,
  {     0, 10030,     7,   3,   1, UNI_JT__C }   /* jt=c */,
  {     0,  5986,  7874,  13,   2, UNI_NV__23 }   /* numericvalue=23 */,
  {     0,  9488,  6620,   4,   6, UNI_DOMINO }   /* blk=domino */,
  {     8,  9508,  8568,   4,   7, UNI_CCC__1 }   /* ccc=overlay */,
  {     3,   184,  7388,   2,  10, UNI_SUPARROWSB }   /* issuparrowsb */,
  {     0,  3836,  8597,  18,   6, UNI_SHRD }   /* scriptextensions=sharada */,
  {    39,  9488,  3751,   4,  17, UNI_INKHITANSMALLSCRIPT }   /* blk=khitansmallscript */,
  {     0,  9488,  7576,   4,   9, UNI_LATINEXTB }   /* blk=latinextb */,
  {    31,  8589,  7694,   8,   8, UNI_SAMR }   /* script=samaritan */,
  {    82,  9997,  2449,   3,  20, UNI_BC__LRE }   /* bc=lefttorightembedding */,
  {     1,  9768,  1677,   4,   5, UNI_LATN }   /* scx=latin */,
  {    32,  1537,  4615,   4,  13, UNI_DIACRITICALSSUP }   /* indiacriticalssup */,
  {     0,  4116,  2225,   3,  20, UNI_PRTI }   /* isinscriptionalparthian */,
  {     2,  5037,     0,   9,   0, UNI_hex_values_index }   /* hexdigit= */,
  {     0,  1966,  9300,  22,   5, UNI_INSC__NUKTA }   /* indicsyllabiccategory=nukta */,
  {     1,  6710,  3601,   5,  14, UNI_INCAUCASIANALBANIAN }   /* incaucasianalbanian */,
  {    26,  7155,  5585,   3,   3, UNI_HEBR }   /* ishebr */,
  {     0,  7325,  9967,   3,   3, UNI_IN__5_DOT_1 }   /* in=5.1 */,
  {    65,  1746,     0,  23,   0, UNI_BPT__C }   /* bidipairedbrackettype=c */,
  {     0, 10003,  1025,   3,   2, -UNI_CI }   /* ci=no */,
  {    74,  4033,   598,  16,   2, UNI_XPOSIXCNTRL }   /* generalcategory=cc */,
  {     0,   184,  9085,   2,   5, UNI_BATK }   /* isbatak */,
  {     1,  9488,  4613,   4,  15, UNI_DIACRITICALSSUP }   /* blk=diacriticalssup */,
  {     0,  9488,  2140,   4,   8, UNI_INCYRILLIC }   /* blk=cyrillic */,
  {     1,  3379,  9255,   6,   5, -UNI_XPOSIXSPACE }   /* space=false */,
  {     1,  3836,  6481,  17,  12, UNI_HUNG }   /* scriptextensions=oldhungarian */,
  {     2,  8780,  1192,   6,  26, UNI_HALFANDFULLFORMS }   /* block=halfwidthandfullwidthforms */,
  {     0,  1189,  5040,   3,   5, UNI_NT__DI }   /* nt=digit */,
  {    55,  3836,  3079,  17,   6, UNI_COPT }   /* scriptextensions=coptic */,
  {    16,   184,  5438,   2,  14, UNI_SK }   /* ismodifiersymbol */,
  {     0, 10183,  3379,   4,   5, UNI_POSIXSPACE }   /* perlspace */,
  {     2,  5986,  9413,  13,   3, UNI_NV__7_SLASH_2 }   /* numericvalue=7/2 */,
  {     3,  3133, 10135,  18,   3, UNI_EBASE }   /* emojimodifierbase=yes */,
  {     2, 10027,  7038,   3,  10, UNI_JG__AFRICANFEH }   /* jg=africanfeh */,
  {     1,  8858,     1,   6,   1, -UNI_ECOMP }   /* ecomp=n */,
  {     0,  9488,  1673,   4,   4, UNI_JAMO }   /* blk=jamo */,
  {     0,  5578,   125,  14,   2, UNI_LB__CR }   /* sentencebreak=cr */,
  {     3,  3382,  9836,   3,   4, UNI_CE }   /* ce=true */,
  {     0,  3836,  9668,  17,   4, UNI_MTEI }   /* scriptextensions=mtei */,
  {     2,  8978,     0,   6,   0, UNI_patws_values_index }   /* patws= */,
  {     0,  9768,  7675,   4,   4, UNI_PALM }   /* scx=palm */,
  {     3,  3836,  6193,  17,   4, UNI_HEBR }   /* scriptextensions=hebr */,
  {     1,  3904,  9836,  17,   4, UNI_UIDEO }   /* unifiedideograph=true */,
  {    13,  1552,  1563,   9,   2, UNI_PS }   /* category=ps */,
  {     0,   184,   349,   2,  33, UNI_SUPSYMBOLSANDPICTOGRAPHS }   /* issupplementalsymbolsandpictographs */,
  {    68,  1087,  1025,  27,   2, -UNI_PCM }   /* prependedconcatenationmark=no */,
  {    73,  9277,  8131,   3,   4, UNI_SC__DUPL }   /* sc=dupl */,
  {     0,  9488,  2140,   4,  11, UNI_CYRILLICSUP }   /* blk=cyrillicsup */,
  {     8, 10340,  4975,   4,   6, UNI_VEDICEXT }   /* isvedicext */,
  {    64,  9488,  8876,   4,   6, UNI_INGOTHIC }   /* blk=gothic */,
  {     1,  8589,  7188,   7,  10, UNI_KHAR }   /* script=kharoshthi */,
  {     2,  1417,  8708,  24,   3, UNI_CCC__216 }   /* canonicalcombiningclass=216 */,
  {    11,  1591,  8415,   3,   6, UNI_INELBASAN }   /* inelbasan */,
  {   142,  8780,  5256,   6,  14, UNI_LATINEXTD }   /* block=latinextendedd */,
  {   138,  9768,  1115,   4,   4, UNI_HANG }   /* scx=hang */,
  {    33,  4688,  7550,  16,   8, UNI_IDENTIFIERTYPE__INCLUSION }   /* identifiertype=inclusion */,
  {    48,  8589,  9684,   7,   4, UNI_NEWA }   /* script=newa */,
  {    58,  9768,  9476,   4,   4, UNI_AVST }   /* scx=avst */,
  {   158,  5508,    26,  14,   1, UNI_PATSYN }   /* patternsyntax=y */,
  {     0,  5986,  9964,  13,   3, UNI_NV__4_SLASH_5 }   /* numericvalue=4/5 */,
  {     0,  9900,     0,   4,   0, UNI_ZZZZ }   /* zzzz */,
  {    24, 10048,  7907,   3,   8, UNI_NV__3_SLASH_8 }   /* nv=3.75e-01 */,
  {     3,  9488,  4273,   4,  16, UNI_MYANMAREXTA }   /* blk=myanmarextendeda */,
  {     0,  9768,  9624,   4,   4, UNI_LAO }   /* scx=laoo */,
  {     1,  5739, 10135,  13,   3, UNI_GRBASE }   /* graphemebase=yes */,
  {     0, 10048,  5648,   3,   3, UNI_NV__100 }   /* nv=100 */,
  {     5,  8852,    36,   6,   1, UNI_CWKCF }   /* cwkcf=t */,
  {     9,   184,  8107,   2,   8, UNI_BALI }   /* isbalinese */,
  {     2, 10048,  9964,   3,   3, UNI_NV__4_SLASH_5 }   /* nv=4/5 */,
  {     1,  9508,  9925,   4,   3, UNI_CCC__BL }   /* ccc=218 */,
  {     0,  9768,  4703,   4,  15, UNI_ARMI }   /* scx=imperialaramaic */,
  {     0,  9488,  5200,   4,  14, UNI_KANASUP }   /* blk=kanasupplement */,
  {    20,  5986,  9984,  13,   2, UNI_NV__37 }   /* numericvalue=37 */,
  {     1,    21,  8227,   2,   8, UNI_KANAEXTA }   /* inkanaexta */,
  {     2,  8131,     0,   4,   0, UNI_DUPL }   /* dupl */,
  {     3,  9768,  9688,   4,   4, UNI_NKO }   /* scx=nkoo */,
  {     0,  3836,  9892,  17,   4, UNI_QAAI }   /* scriptextensions=zinh */,
  {     6,  7218,  7448,  10,  10, UNI_LB__WJ }   /* linebreak=wordjoiner */,
  {     2,  9488,  2245,   4,  11, UNI_INMEETEIMAYEK }   /* blk=meeteimayek */,
  {     5,  9768,  8840,   4,   6, UNI_CAKM }   /* scx=chakma */,
  {    37,  9488,   478,   4,  31, UNI_MATHALPHANUM }   /* blk=mathematicalalphanumericsymbols */,
  {     1,  5791,  5340,  13,  14, UNI_JG__MANICHAEANFIVE }   /* joininggroup=manichaeanfive */,
  {     1, 10048,  9405,   3,   3, UNI_NV__3_SLASH_2 }   /* nv=3/2 */,
  {     1,   184,  7129,   3,   9, UNI_CJKSTROKES }   /* iscjkstrokes */,
  {     0,  3836,  2429,  17,  20, UNI_PHLI }   /* scriptextensions=inscriptionalpahlavi */,
  {     1,  9488,  2409,   4,  10, UNI_INGLAGOLITIC }   /* blk=glagolitic */,
  {     1,  9556,  6170,   5,  11, UNI_WB__EB }   /* gcb=glueafterzwj */,
  {     0,  9997,    37,   3,   2, UNI_BC__EN }   /* bc=en */,
  {    33,  9768,  2469,   4,  20, UNI_HMNP }   /* scx=nyiakengpuachuehmong */,
  {     0,   184,  5817,   2,  13, UNI_ZL }   /* islineseparator */,
  {    13,  3904,    26,  17,   1, UNI_UIDEO }   /* unifiedideograph=y */,
  {     0,  9768,  2485,   4,   4, UNI_MONG }   /* scx=mong */,
  {     0,  5116,     0,  14,   0, UNI_emod_values_index }   /* emojimodifier= */,
  {     0, 10288,  1823,   8,   5, UNI_XPOSIXLOWER }   /* isxposixlower */,
  {     7,  9768,  7278,   4,  10, UNI_XPEO }   /* scx=oldpersian */,
  {     0,  9262,   495,   3,   2, UNI_SB__NU }   /* sb=nu */,
  {     2,  9508,  7477,   4,   9, UNI_CCC__AL }   /* ccc=aboveleft */,
  {     1,  8449,  9836,   7,   4, UNI_HYPHEN }   /* hyphen=true */,
  {     2,  3836,  9568,  17,   4, UNI_GREK }   /* scriptextensions=grek */,
  {    84, 10048,  8720,   3,   6, UNI_NV__400000 }   /* nv=400000 */,
  {     1,  1552,  7408,   9,  10, UNI_CN }   /* category=unassigned */,
  {     0,  7418,     0,  10,   0, UNI_upper_values_index }   /* uppercase= */,
  {     1,  4033, 10176,  16,   2, UNI_ZL }   /* generalcategory=zl */,
  {     2,  4793,     0,  15,   0, UNI_MERC }   /* meroiticcursive */,
  {     0,  8589,  6484,   7,   4, UNI_HUNG }   /* script=hung */,
  {     0,   184,  8942,   2,   6, UNI_LYDI }   /* islydian */,
  {     0,  3367,     3,  18,   1, -UNI__PERL_PATWS }   /* patternwhitespace=f */,
  {    48,  5791,  9744,  13,   4, UNI_JG__QAPH }   /* joininggroup=qaph */,
  {    90,  4916,  8660,   3,   6, UNI_TIBT }   /* istibetan */,
  {     1,  3097,  8163,  18,   8, UNI_DT__FRA }   /* decompositiontype=fraction */,
  {     2,  2784,  3923,   4,   7, UNI_ARABICSUP }   /* inarabicsup */,
  {     3,   184,  3796,   3,   3, UNI_CHAM }   /* ischam */,
  {     0,  4116,  1907,   3,  15, UNI_INDICNUMBERFORMS }   /* isindicnumberforms */,
  {     1,  3836,  2203,  17,  14, UNI_ROHG }   /* scriptextensions=hanifirohingya */,
  {     1,  1966,  4353,  22,  16, UNI_INSC__SYLLABLEMODIFIER }   /* indicsyllabiccategory=syllablemodifier */,
  {     1,  1417,  9931,  24,   3, UNI_CCC__L }   /* canonicalcombiningclass=224 */,
  {     1,  9488,  7099,   5,   9, UNI_BOXDRAWING }   /* blk=boxdrawing */,
  {     0,  8589,  8428,   7,   7, UNI_SC__GRAN }   /* script=grantha */,
  {     1,  9768,  8912,   4,   6, UNI_KHOJ }   /* scx=khojki */,
  {     5,  9488,  9065,   4,   5, UNI_INADLAM }   /* blk=adlam */,
  {     0,   184,  5960,   2,  13, UNI_MISCTECHNICAL }   /* ismisctechnical */,
  {    66,  7325,  7408,   3,  10, UNI_AGE__NA }   /* in=unassigned */,
  {     0,  9556,   911,   4,   1, UNI_GCB__V }   /* gcb=v */,
  {     0,  9275,  4305,   5,   5, UNI_INSC__OTHER }   /* insc=other */,
  {     1,  9600,     0,   4,   0, UNI_KALI }   /* kali */,
  {     0,  8852,  9255,   6,   5, -UNI_CWKCF }   /* cwkcf=false */,
  {    10, 10296,  9225,   7,   5, UNI_POSIXCNTRL }   /* isposixcntrl */,
  {     1,  7318,  9401,  10,   3, UNI_IN__3 }   /* presentin=3.0 */,
  {    28,  8267, 10135,   8,   3, UNI_RADICAL }   /* radical=yes */,
  {     0,  9768,  7513,   4,   9, UNI_BHKS }   /* scx=bhaiksuki */,
  {     0,  5039,     0,   6,   0, UNI_XPOSIXXDIGIT }   /* xdigit */,
  {     0,  9488,  5284,   4,   4, UNI_INLISU }   /* blk=lisu */,
  {     1,  5986,  8708,  13,   6, UNI_NV__216000 }   /* numericvalue=216000 */,
  {     3,  8780,  4928,   6,   8, UNI_TAMILSUP }   /* block=tamilsup */,
  {    16,  8780,  9335,   6,   5, UNI_INTAKRI }   /* block=takri */,
  {     0,  9346,     1,   4,   1, -UNI_IDC }   /* idc=n */,
  {     0,  2032,     3,  22,   1, -UNI__PERL_NCHAR }   /* noncharactercodepoint=f */,
  {     1,  6928,     0,  10,   0, UNI_SD }   /* softdotted */,
  {     0,  3893,     0,  11,   0, UNI_SGNW }   /* signwriting */,
  {     3,  8780,  4065,   6,  16, UNI_HALFANDFULLFORMS }   /* block=halfandfullforms */,
  {     0,  9440,     0,   4,   0, UNI_ADLM }   /* adlm */,
  {     1,  9262,    33,   3,   2, UNI_SB__SE }   /* sb=se */,
  {     0,  4628,    66,  15,   1, UNI_EA__H }   /* eastasianwidth=h */,
  {    66,  1988,    26,  22,   1, UNI_LOE }   /* logicalorderexception=y */,
  {     0,  8780,  7398,   6,  10, UNI_SUPARROWSC }   /* block=suparrowsc */,
  {    20,  7028,  2309,   3,  20, UNI_YIJING }   /* isyijinghexagramsymbols */,
  {     3,   184,  7398,   2,  10, UNI_SUPARROWSC }   /* issuparrowsc */,
  {     0,  9768,  8618,   5,   3, UNI_SOYO }   /* scx=soyo */,
  {     9,  8780,   908,   6,  10, UNI_PUA }   /* block=privateuse */,
  {     0,  1790,     1,  22,   1, -UNI_CWCM }   /* changeswhencasemapped=n */,
  {    34,  8589,  9600,   7,   4, UNI_SC__KALI }   /* script=kali */,
  {    16,  8372,     0,   7,   0, UNI_CJKEXTD }   /* cjkextd */,
  {     0,  1188,  4402,   3,  15, UNI_TANGUTSUP }   /* intangutsupplement */,
  {    69,  9275,  5144,   5,  14, UNI_INSC__GEMINATIONMARK }   /* insc=geminationmark */,
  {     6,  8780,  3169,   6,  11, UNI_ETHIOPICSUP }   /* block=ethiopicsup */,
  {     7,  9488,   414,   4,  32, UNI_INIDC }   /* blk=ideographicdescriptioncharacters */,
  {     1,  8589,  9320,   7,   5, UNI_OSGE }   /* script=osage */,
  {     0,  9768,  8561,   4,   7, UNI_OSMA }   /* scx=osmanya */,
  {    33,  8780,  5522,   6,  14, UNI_PHONETICEXTSUP }   /* block=phoneticextsup */,
  {     4, 10006,     1,   3,   1, -UNI_DI }   /* di=n */,
  {    72,   184,  2061,   2,  15, UNI_MODIFIERLETTERS }   /* ismodifierletters */,
  {     0,  9508,  1756,   4,   2, UNI_CCC__BR }   /* ccc=br */,
  {     0,  5986,  7858,  13,   2, UNI_NV__22 }   /* numericvalue=22 */,
  {     1,  9540, 10135,   4,   3, UNI_DIA }   /* dia=yes */,
  {    35,  6205,    26,  12,   1, UNI_IDEO }   /* ideographic=y */,
  {     4,  4146,  1947,   5,  19, UNI_EARLYDYNASTICCUNEIFORM }   /* inearlydynasticcuneiform */,
  {     1,  6231,   600,   3,  29, UNI_CJKEXTD }   /* incjkunifiedideographsextensiond */,
  {     1,  5674,    36,  13,   1, UNI_BIDIM }   /* bidimirrored=t */,
  {     5,  3836,  8115,  17,   8, UNI_BASS }   /* scriptextensions=bassavah */,
  {     0,  9508,  8082,   4,   2, UNI_CCC__19 }   /* ccc=19 */,
  {     3,  7325,  7469,   3,   3, UNI_IN__5 }   /* in=5.0 */,
  {     2,  7438,  8505,  10,   7, UNI_WB__NL }   /* wordbreak=newline */,
  {     1,  7218,   125,  10,   2, UNI_LB__CR }   /* linebreak=cr */,
  {     7,  9444,  7755,   4,   3, UNI_IN__1_DOT_1 }   /* age=1.1 */,
  {    78,  9488,  2836,   4,  19, UNI_MODIFIERTONELETTERS }   /* blk=modifiertoneletters */,
  {     1,  9488,  4289,   4,  16, UNI_MYANMAREXTB }   /* blk=myanmarextendedb */,
  {     2, 10296,  5040,   7,   5, UNI_POSIXDIGIT }   /* isposixdigit */,
  {     1,  5791,  9281,  14,   4, UNI_JG__KHAPH }   /* joininggroup=khaph */,
  {     0,  7325,  9856,   3,   4, UNI_IN__13 }   /* in=v130 */,
  {     2,  3853,  1025,  17,   2, -UNI_STERM }   /* sentenceterminal=no */,
  {     0, 10024,  4958,   3,  15, UNI_UPPERCASELETTER }   /* gc=uppercaseletter */,
  {     0,   184,  8131,   2,   8, UNI_DUPL }   /* isduployan */,
  {     2,    21,  3768,   2,  17, UNI_LETTERLIKESYMBOLS }   /* inletterlikesymbols */,
  {     7,  7325, 10084,   3,   3, UNI_IN__3_DOT_1 }   /* in=v31 */,
  {     0,  7155,  5219,   3,   3, UNI_HIRA }   /* ishira */,
  {     2,  9508,   184,   4,   2, UNI_CCC__IS }   /* ccc=is */,
  {   197,  1417,  8801,  24,   3, UNI_CCC__107 }   /* canonicalcombiningclass=107 */,
  {    68,  9768,  7288,   4,  10, UNI_SOGO }   /* scx=oldsogdian */,
  {     3,   184,    74,   2,   2, UNI_ME }   /* isme */,
  {     1,  9997, 10018,   3,   3, UNI_BC__FSI }   /* bc=fsi */,
  {    40,  9350,     1,   5,   1, -UNI_XIDS }   /* xids=n */,
  {    10,  7325,  7826,   3,   4, UNI_IN__12 }   /* in=12.0 */,
  {     1,  9488,  3295,   4,   9, UNI_LATINEXTA }   /* blk=latinexta */,
  {   124,  5986,  8720,  13,   4, UNI_NV__4000 }   /* numericvalue=4000 */,
  {     0,  5791,  6301,  13,  12, UNI_JG__MALAYALAMLLA }   /* joininggroup=malayalamlla */,
  {     4,  1631,     0,  15,   0, UNI_GEOMETRICSHAPES }   /* geometricshapes */,
  {    34,  1087,     0,  26,   0, UNI_PCM }   /* prependedconcatenationmark */,
  {     1,  1746,  5904,  22,   4, UNI_BPT__N }   /* bidipairedbrackettype=none */,
  {     1,  2161,  9255,  21,   5, -UNI_EXTPICT }   /* extendedpictographic=false */,
  {    18,  8589,  8107,   7,   4, UNI_BALI }   /* script=bali */,
  {     0,  8673,     0,   7,   0, UNI_UCASEXT }   /* ucasext */,
  {    35,  1417,  1179,  24,   2, UNI_CCC__BL }   /* canonicalcombiningclass=bl */,
  {     0,  8780,  5242,   6,  14, UNI_LATINEXTC }   /* block=latinextendedc */,
  {     1,   184,  8366,   3,   6, UNI_CJKEXTC }   /* iscjkextc */,
  {     0,  9305,     0,   5,   0, UNI_NSHU }   /* nushu */,
  {     6,  9488,  2061,   4,   4, UNI_INMODI }   /* blk=modi */,
  {     0,  2061,     0,  15,   0, UNI_MODIFIERLETTERS }   /* modifierletters */,
  {   149,  8780,  8107,   6,   8, UNI_INBALINESE }   /* block=balinese */,
  {     3,  4628,  8948,  15,   6, UNI_EA__NA }   /* eastasianwidth=narrow */,
  {     0,  7318,  7867,  10,   3, UNI_IN__3_DOT_1 }   /* presentin=3.1 */,
  {   128, 10024,   206,   3,   2, UNI_PI }   /* gc=pi */,
  {    40,  7155,  2507,   3,   3, UNI_HATR }   /* ishatr */,
  {     0, 10310,  8668,   4,   5, UNI_INTIRHUTA }   /* intirhuta */,
  {    10,  9488,  1677,   4,  14, UNI_LATINEXTA }   /* blk=latinextendeda */,
  {     8,  4568,     0,  15,   0, UNI_CURRENCYSYMBOLS }   /* currencysymbols */,
  {    16,  9768,  8123,   4,   8, UNI_BUGI }   /* scx=buginese */,
  {     0,  8780,  8407,   6,   7, UNI_DSRT }   /* block=deseret */,
  {   100,    21,  4161,   2,  16, UNI_LINEARBSYLLABARY }   /* inlinearbsyllabary */,
  {    23,   184,  4337,   2,  16, UNI_SUPMATHOPERATORS }   /* issupmathoperators */,
  {     2,  8780,   183,   6,  34, UNI_MISCPICTOGRAPHS }   /* block=miscellaneoussymbolsandpictographs */,
  {     0,  9556,  4360,   4,   9, UNI_WB__EB }   /* gcb=emodifier */,
  {     0,  8589,  9808,   7,   4, UNI_TALU }   /* script=talu */,
  {     3,  9488,  1218,   4,  26, UNI_KATAKANAEXT }   /* blk=katakanaphoneticextensions */,
  {     0,  9596,  6763,   4,   3, UNI_LB__H3 }   /* hst=lvt */,
  {     0,  9596,     0,   4,   0, UNI_hst_values_index }   /* hst= */,
  {     0,  8171,     0,   8,   0, UNI_GUJR }   /* gujarati */,
  {    34,  9277,  8617,   3,   4, UNI_SOYO }   /* sc=soyo */,
  {     1,  3259,    36,  18,   1, UNI_IDSB }   /* idsbinaryoperator=t */,
  {     2,  8575,  9255,   7,   5, -UNI_PATSYN }   /* patsyn=false */,
  {     0, 10048,  7915,   3,   8, UNI_NV__3_SLASH_80 }   /* nv=3.75e-02 */,
  {   104,  5778,     0,   6,   0, UNI_IPAEXT }   /* ipaext */,
  {     0,  3367,  1025,  18,   2, -UNI__PERL_PATWS }   /* patternwhitespace=no */,
  {   201,  9488,  4273,   4,   7, UNI_INMYANMAR }   /* blk=myanmar */,
  {     1,   349,     0,  33,   0, UNI_SUPSYMBOLSANDPICTOGRAPHS }   /* supplementalsymbolsandpictographs */,
  {   251, 10126,   409,   3,   2, UNI_VO__TR }   /* vo=tr */,
  {     2,  2161,    36,  21,   1, UNI_EXTPICT }   /* extendedpictographic=t */,
  {     1,  9508,  9146,   5,   4, UNI_CCC__23 }   /* ccc=ccc23 */,
  {     0,  6420,   125,   3,   2, UNI_OCR }   /* inocr */,
  {    16,  8589,     0,  14,   0, UNI_SC__SHRD }   /* script=sharada */,
  {     2,  8694,    26,   7,   1, UNI_XPOSIXSPACE }   /* wspace=y */,
  {   195,  1417,  8042,  24,   2, UNI_CCC__18 }   /* canonicalcombiningclass=18 */,
  {     1,  7318, 10123,  10,   3, UNI_IN__9 }   /* presentin=v90 */,
  {     0,  8954,    36,   6,   1, UNI__PERL_NCHAR }   /* nchar=t */,
  {     5,  4628,  7486,  15,   9, UNI_EA__A }   /* eastasianwidth=ambiguous */,
  {     4,   184,  3241,   2,  11, UNI_GEORGIANSUP }   /* isgeorgiansup */,
  {     0,  2224,  3440,   3,  11, UNI_SMALLKANAEXT }   /* insmallkanaext */,
  {     1,  7318,  9400,  10,   4, UNI_IN__13 }   /* presentin=13.0 */,
  {     0,  8589,  2203,   7,  14, UNI_SC__ROHG }   /* script=hanifirohingya */,
  {     0,  1552,  1910,   9,   2, UNI_CN }   /* category=cn */,
  {     2,   184,  4554,   3,  14, UNI_CONTROLPICTURES }   /* iscontrolpictures */,
  {     3, 10027,  6289,   3,  12, UNI_JG__MALAYALAMBHA }   /* jg=malayalambha */,
  {     2,  4116,  7740,   3,   6, UNI_IDS }   /* isidstart */,
  {     6,  9768,  2288,   5,   6, UNI_SINH }   /* scx=sinhala */,
  {    16,  6241,    18,  12,   1, UNI_JT__R }   /* joiningtype=r */,
  {     6,  7318,  7827,  10,   3, UNI_IN__2 }   /* presentin=2.0 */,
  {     0, 10132,  4305,   3,   5, UNI_WB__XX }   /* wb=other */,
  {     4, 10048,  9961,   3,   3, UNI_NV__3_SLASH_5 }   /* nv=3/5 */,
  {    13,  9556,  5008,   5,   2, UNI_WB__EB }   /* gcb=gaz */,
  {     0,  9768,  3079,   4,   6, UNI_COPT }   /* scx=coptic */,
  {     0,  9768,  9612,   4,   4, UNI_KNDA }   /* scx=knda */,
  {     0,  9235,  9836,   5,   4, UNI_CWCM }   /* cwcm=true */,
  {     0,  8780,  5003,   6,  15, UNI_INZANABAZARSQUARE }   /* block=zanabazarsquare */,
  {     8,  5674,     0,   5,   0, UNI_BIDIM }   /* bidim */,
  {     7,  2161,     0,  21,   0, UNI_extpict_values_index }   /* extendedpictographic= */,
  {     1,  9768,  9624,   4,   3, UNI_LAO }   /* scx=lao */,
  {     0,  8780,  2409,   6,  10, UNI_INGLAGOLITIC }   /* block=glagolitic */,
  {     0,  3836,  8936,  17,   4, UNI_LYCI }   /* scriptextensions=lyci */,
  {     5,  4791,  4274,   3,   6, UNI_INMYANMAR }   /* inmyanmar */,
  {    83,  8589,  8680,   7,   7, UNI_ZZZZ }   /* script=unknown */,
  {     1,  9277,  2278,   4,   3, UNI_SC__KALI }   /* sc=kali */,
  {     3,  9488,  8477,   4,   7, UNI_INMAKASAR }   /* blk=makasar */,
  {    32,  4568,     0,  14,   0, UNI_SC }   /* currencysymbol */,
  {     0,   184,  7693,   2,   9, UNI_SAMR }   /* issamaritan */,
  {     2,  5986,  5648,  13,   9, UNI_NV__100000000 }   /* numericvalue=100000000 */,
  {     0,   184,  3026,   3,  10, UNI_CHEROKEESUP }   /* ischerokeesup */,
  {     3,  5718,     0,   5,   0, UNI_XPOSIXALNUM }   /* alnum */,
  {    32,  8780,   414,   6,  32, UNI_INIDC }   /* block=ideographicdescriptioncharacters */,
  {     0,  9488,  6085,   4,  12, UNI_CHESSSYMBOLS }   /* blk=chesssymbols */,
  {   193,  8780,  2409,   6,  13, UNI_GLAGOLITICSUP }   /* block=glagoliticsup */,
  {     2,  8589,  6840,   7,  11, UNI_SC__NAND }   /* script=nandinagari */,
  {     4,  9277,  8498,   3,   7, UNI_SC__MULT }   /* sc=multani */,
  {     1,  7155,  2723,   3,  18, UNI_JAMOEXTA }   /* ishanguljamoextendeda */,
  {    11,   184,   250,   2,  33, UNI_MISCMATHSYMBOLSA }   /* ismiscellaneousmathematicalsymbolsa */,
  {     0,  9488,  7675,   4,   9, UNI_PALM }   /* blk=palmyrene */,
  {     9,  9262,  7702,   3,   9, UNI_SB__SC }   /* sb=scontinue */,
  {     1, 10132,  6178,   3,   3, UNI_LB__ZWJ }   /* wb=zwj */,
  {     4,  8589,  4370,   8,   5, UNI_SC__SYRC }   /* script=syriac */,
  {    33,  9768,  8611,   5,   3, UNI_SIDD }   /* scx=sidd */,
  {    11,  5986,  7939,  13,   8, UNI_NV__9_SLASH_2 }   /* numericvalue=4.50e+00 */,
  {     0,  7158,    36,  10,   1, UNI_DIA }   /* diacritic=t */,
  {     1,  1552,     1,   9,   1, UNI_N }   /* category=n */,
  {    83,  3836,  8618,  18,   6, UNI_SOYO }   /* scriptextensions=soyombo */,
  {     3,   184,  5200,   2,   7, UNI_KANASUP }   /* iskanasup */,
  {     5,  9277,  9283,   3,   4, UNI_PHLI }   /* sc=phli */,
  {    96,  9275,     0,   5,   0, UNI_insc_values_index }   /* insc= */,
  {     0,  8428,     0,   4,   0, UNI_GRAN }   /* gran */,
  {     0,  9346,  9836,   4,   4, UNI_IDC }   /* idc=true */,
  {     2,  3836,  9624,  17,   3, UNI_LAO }   /* scriptextensions=lao */,
  {     0,    21,  1218,   2,  26, UNI_KATAKANAEXT }   /* inkatakanaphoneticextensions */,
  {    17,  2161,  1025,  21,   2, -UNI_EXTPICT }   /* extendedpictographic=no */,
  {     0,  8780,  1218,   6,  26, UNI_KATAKANAEXT }   /* block=katakanaphoneticextensions */,
  {    12,  9768,  2913,   5,   3, UNI_SUND }   /* scx=sund */,
  {     0,   184,  1269,   2,  24, UNI_COMPEX }   /* isfullcompositionexclusion */,
  {     1, 10048,  7827,   3,   8, UNI_NV__1_SLASH_5 }   /* nv=2.00e-01 */,
  {     3,  9488,  6277,   4,  12, UNI_MAHJONG }   /* blk=mahjongtiles */,
  {   352,  9262,   495,   3,   7, UNI_SB__NU }   /* sb=numeric */,
  {     1, 10296,  9725,   3,   3, UNI_PHNX }   /* isphnx */,
  {     2,  8780,  7495,   6,   9, UNI_ARABICPFA }   /* block=arabicpfa */,
  {     0,  6805,     0,  13,   0, UNI_MISCSYMBOLS }   /* inmiscsymbols */,
  {     0,  9716,     0,   3,   0, UNI_PCM }   /* pcm */,
  {   258,  9277,  3598,   3,  17, UNI_AGHB }   /* sc=caucasianalbanian */,
  {     4,  8768,    26,   6,   1, UNI_BIDIC }   /* bidic=y */,
  {     2,  8780,  9095,   6,   5, UNI_INBUHID }   /* block=buhid */,
  {     1,  8393,     0,   7,   0, UNI_CJKEXTG }   /* cjkextg */,
  {     3,   117,   415,   3,  31, UNI_INIDC }   /* inideographicdescriptioncharacters */,
  {     0,  1417,  6631,  24,  11, UNI_CCC__DA }   /* canonicalcombiningclass=doubleabove */,
  {    80,  9265,     1,   5,   1, -UNI_IDST }   /* idst=n */,
  {    63,  9488,  3115,   4,  10, UNI_INDEVANAGARI }   /* blk=devanagari */,
  {     0,  2224,  4370,   3,   5, UNI_INSYRIAC }   /* insyriac */,
  {     0,  6205,     3,  12,   1, -UNI_IDEO }   /* ideographic=f */,
  {    37,   184,  9660,   2,   4, UNI_MLYM }   /* ismlym */,
  {     1,  5791,  4748,  13,  15, UNI_JG__MANICHAEANGIMEL }   /* joininggroup=manichaeangimel */,
  {     1,   184,  5592,   2,  14, UNI_ZS }   /* isspaceseparator */,
  {     9,  6554,     3,  11,   1, -UNI_IDC }   /* idcontinue=f */,
  {     3,  5986,  7778,  13,   2, UNI_NV__21 }   /* numericvalue=21 */,
  {     2,  9508,  7858,   4,   3, UNI_CCC__B }   /* ccc=220 */,
  {     0,  1900,     0,   6,   0, UNI_ZYYY }   /* common */,
  {    25,  3836,  9452,  17,   4, UNI_AHOM }   /* scriptextensions=ahom */,
  {     0,  9508,  9136,   5,   4, UNI_CCC__21 }   /* ccc=ccc21 */,
  {     0,  2529,     0,  20,   0, UNI_term_values_index }   /* terminalpunctuation= */,
  {     1,  8768,  9836,   6,   4, UNI_BIDIC }   /* bidic=true */,
  {     0,  8780,  3785,   6,  10, UNI_INMANICHAEAN }   /* block=manichaean */,
  {     8, 10333,  8625,   3,   6, UNI_SUPPUAA }   /* issuppuaa */,
  {   256, 10024,   112,   3,   2, UNI_SC }   /* gc=sc */,
  {     4,  9508,  8042,   4,   2, UNI_CCC__18 }   /* ccc=18 */,
  {   177, 10048,  8067,   3,   8, UNI_NV__17_SLASH_2 }   /* nv=8.50e+00 */,
  {    96,  9768,  8638,   4,   7, UNI_TGLG }   /* scx=tagalog */,
  {     0,  4791,  2856,   3,   8, UNI_INMONGOLIAN }   /* inmongolian */,
  {     0,  8688,  9477,   3,   3, UNI_AVST }   /* isavst */,
  {    11,  9488,  8498,   4,   7, UNI_INMULTANI }   /* blk=multani */,
  {    42,  6231,   630,   3,  29, UNI_CJKEXTE }   /* incjkunifiedideographsextensione */,
  {     2,  6231,  1061,   4,   4, UNI_INCOPTIC }   /* incoptic */,
  {     1,  7325, 10081,   3,   3, UNI_IN__3 }   /* in=v30 */,
  {     5,  1552,   908,   9,  10, UNI_CO }   /* category=privateuse */,
  {     0,  1591,  8422,   3,   6, UNI_INELYMAIC }   /* inelymaic */,
  {    64,  9275,  9300,   5,   5, UNI_INSC__NUKTA }   /* insc=nukta */,
  {     5,  3836,  9460,  17,   4, UNI_ARMI }   /* scriptextensions=armi */,
  {     0,  8688,  9449,   3,   3, UNI_AGHB }   /* isaghb */,
  {     0,  3097,  3501,  18,   3, UNI_DT__MED }   /* decompositiontype=med */,
  {     0,   184,  8123,   2,   4, UNI_BUGI }   /* isbugi */,
  {     8,  9014, 10135,   6,   3, UNI_UIDEO }   /* uideo=yes */,
  {     5,  9536,     3,   4,   1, -UNI_DEP }   /* dep=f */,
  {     2,  8589,  9888,   7,   4, UNI_ZANB }   /* script=zanb */,
  {     9, 10048,  8732,   3,   3, UNI_NV__500 }   /* nv=500 */,
  {     1,   184,  8870,   2,   5, UNI_EPRES }   /* isepres */,
  {     0,  9277,  8477,   3,   7, UNI_MAKA }   /* sc=makasar */,
  {    10,  3382,  1025,   3,   2, -UNI_CE }   /* ce=no */,
  {    10,  5324,   480,   4,  29, UNI_MATHALPHANUM }   /* inmathematicalalphanumericsymbols */,
  {     1, 10033,  5999,   3,  13, UNI_LB__PR }   /* lb=prefixnumeric */,
  {     1,  2779,     0,  18,   0, UNI_IDST }   /* idstrinaryoperator */,
  {     0,  4033,  5726,  16,  13, UNI_ME }   /* generalcategory=enclosingmark */,
  {     0, 10027,  5364,   3,   4, UNI_JG__HETH }   /* jg=heth */,
  {     0,  1979,  6266,  10,  11, UNI_NL }   /* category=letternumber */,
  {     3,  9488,  2665,   4,  19, UNI_COUNTINGROD }   /* blk=countingrodnumerals */,
  {   208,  8780,  7188,   6,  10, UNI_INKHAROSHTHI }   /* block=kharoshthi */,
  {    84,   184,  8359,   3,   6, UNI_CJKEXTB }   /* iscjkextb */,
  {     0,  9768,  2203,   4,   4, UNI_HAN }   /* scx=hani */,
  {     0,  2182,  1087,  21,   7, UNI_GCB__PP }   /* graphemeclusterbreak=prepend */,
  {   288,  2409,     0,  20,   0, UNI_GLAGOLITICSUP }   /* glagoliticsupplement */,
  {   256,  9488,  2912,   4,  12, UNI_SUNDANESESUP }   /* blk=sundanesesup */,
  {     0,  8780,  4703,   6,  15, UNI_INIMPERIALARAMAIC }   /* block=imperialaramaic */,
  {     6,  9014,     3,   6,   1, -UNI_UIDEO }   /* uideo=f */,
  {     0,  7218,  1186,  10,   2, UNI_LB__PO }   /* linebreak=po */,
  {     0,  7438,  6169,  10,  12, UNI_WB__EB }   /* wordbreak=glueafterzwj */,
  {     0,   184,  6181,   2,  12, UNI_GONG }   /* isgunjalagondi */,
  {     1, 10033,    34,   3,   2, UNI_LB__EX }   /* lb=ex */,
  {     2,  2280,  6874,   3,  10, UNI_SO }   /* isothersymbol */,
  {     1,  9277,  3115,   3,   4, UNI_SC__DEVA }   /* sc=deva */,
  {     0,  9488,  6505,   4,  12, UNI_PHAISTOS }   /* blk=phaistosdisc */,
  {   176,  8780,  5228,   6,  14, UNI_LATINEXTB }   /* block=latinextendedb */,
  {    25,  2533,  6028,   5,   9, UNI_ALPHABETICPF }   /* inalphabeticpf */,
  {     5,  9997,  2509,   3,  11, UNI_BC__R }   /* bc=righttoleft */,
  {     0,  8780,  7288,   6,  10, UNI_INOLDSOGDIAN }   /* block=oldsogdian */,
  {   186,  9277,  8131,   3,   8, UNI_SC__DUPL }   /* sc=duployan */,
  {    45,  1673,     0,   4,   0, UNI_JAMO }   /* jamo */,
  {    66,  6061,     0,  12,   0, UNI_bidic_values_index }   /* bidicontrol= */,
  {     0,  8589,  9038,   7,   6, UNI_SC__YEZI }   /* script=yezidi */,
  {     0,  1856,     3,  22,   1, -UNI_CWU }   /* changeswhenuppercased=f */,
  {   256, 10183,  7438,   4,   4, UNI_POSIXWORD }   /* perlword */,
  {     1,  9070,     3,   5,   1, -UNI_POSIXXDIGIT }   /* ahex=f */,
  {     0,  9277,  8596,   3,   7, UNI_SC__SHRD }   /* sc=sharada */,
  {     3,  5986,     0,  13,   0, UNI_nv_values_index }   /* numericvalue= */,
  {     3,   184,  8243,   2,   8, UNI_MAHJ }   /* ismahajani */,
  {     0,  9240,    26,   5,   1, UNI_DASH }   /* dash=y */,
  {     4,  3025,     0,  11,   0, UNI_CHEROKEESUP }   /* cherokeesup */,
  {     2,  6420,  4884,   3,  14, UNI_SARB }   /* inoldsoutharabian */,
  {     1,  9262,    72,   3,   2, UNI_SB__LE }   /* sb=le */,
  {     0,  9520,     0,   4,   0, UNI_cwl_values_index }   /* cwl= */,
  {     2,  7325,  7806,   3,   1, UNI_IN__6 }   /* in=6 */,
  {     2,  1417,  9922,  24,   3, UNI_CCC__214 }   /* canonicalcombiningclass=214 */,
  {     0,  3836,  9283,  17,   4, UNI_PHLI }   /* scriptextensions=phli */,
  {     0,  4916,    47,   5,   1, UNI_TERM }   /* isterm */,
  {   104,  7318,  9388,  10,   4, UNI_IN__11 }   /* presentin=11.0 */,
  {     0,  1417,  8082,  24,   2, UNI_CCC__19 }   /* canonicalcombiningclass=19 */,
  {     0,  2182,   911,  21,   1, UNI_GCB__V }   /* graphemeclusterbreak=v */,
  {     1,   262,     0,   2,   0, UNI_SM }   /* sm */,
  {    98,  1552,  5494,   9,  14, UNI_MN }   /* category=nonspacingmark */,
  {     1,   184,  1222,   2,   4, UNI_KANA }   /* iskana */,
  {     1,  5986,  7469,  13,   8, UNI_NV__1_SLASH_2 }   /* numericvalue=5.00e-01 */,
  {    57,  8780,  8624,   6,   7, UNI_SUPPUAA }   /* block=suppuaa */,
  {     3,    21,  5019,   3,  13, UNI_ANCIENTSYMBOLS }   /* inancientsymbols */,
  {     0,  3836,  4928,  17,   5, UNI_TAML }   /* scriptextensions=tamil */,
  {     0,  1552,    45,   9,   2, UNI_CO }   /* category=co */,
  {     3,  9444,  9388,   4,   4, UNI_AGE__11 }   /* age=11.0 */,
  {     1,  4161,     0,  16,   0, UNI_LINEARBSYLLABARY }   /* linearbsyllabary */,
  {     0,  9768,  2245,   4,  11, UNI_MTEI }   /* scx=meeteimayek */,
  {     3, 10024,  4305,   3,   5, UNI_C }   /* gc=other */,
  {     1,  1768,     1,  22,   1, -UNI_CWCF }   /* changeswhencasefolded=n */,
  {     2,  5752,     0,   8,   0, UNI_GREEKEXT }   /* greekext */,
  {    34,  9768,  8477,   4,   4, UNI_MAKA }   /* scx=maka */,
  {     2, 10048,  9958,   3,   3, UNI_NV__3_SLASH_4 }   /* nv=3/4 */,
  {    20,   184,   749,   2,  16, UNI_ENCLOSEDALPHANUM }   /* isenclosedalphanum */,
  {     0,  9488,  9320,   4,   5, UNI_INOSAGE }   /* blk=osage */,
  {     0,  8227,     0,   8,   0, UNI_KANAEXTA }   /* kanaexta */,
  {    22,  4448,     0,   8,   0, UNI_BAMUMSUP }   /* bamumsup */,
  {    65,  3836,  8888,  17,   6, UNI_HATR }   /* scriptextensions=hatran */,
  {     0,  3904,  9255,  17,   5, -UNI_UIDEO }   /* unifiedideograph=false */,
  {     3,  9444,  9840,   4,   4, UNI_AGE__10 }   /* age=v100 */,
  {    36,  3836,  9548,  17,   4, UNI_DSRT }   /* scriptextensions=dsrt */,
  {   128, 10048,  7795,   3,   8, UNI_NV__3_SLASH_20 }   /* nv=1.50e-01 */,
  {    11,  3529,  1025,  18,   2, -UNI_VS }   /* variationselector=no */,
  {     0,  3768,     0,  17,   0, UNI_LETTERLIKESYMBOLS }   /* letterlikesymbols */,
  {    40,  8400,     3,   7,   1, -UNI_COMPEX }   /* compex=f */,
  {     0,   184,  3751,   2,  17, UNI_KITS }   /* iskhitansmallscript */,
  {     0,  9488,  1654,   4,  23, UNI_COMPATJAMO }   /* blk=hangulcompatibilityjamo */,
  {     1, 10027,  3819,   3,  17, UNI_JG__MANICHAEANTHAMEDH }   /* jg=manichaeanthamedh */,
  {     0,   414,     0,  11,   0, UNI_IDEO }   /* ideographic */,
  {    16,   184,  4448,   2,   5, UNI_BAMU }   /* isbamum */,
  {   259, 10048,  7859,   3,   5, UNI_NV__20000 }   /* nv=20000 */,
  {     1,  1966,  7639,  22,   9, UNI_INSC__NONJOINER }   /* indicsyllabiccategory=nonjoiner */,
  {     0,  9488,  1218,   4,   8, UNI_INKATAKANA }   /* blk=katakana */,
  {   288,  1591,  3170,   3,  10, UNI_ETHIOPICSUP }   /* inethiopicsup */,
  {     9,  8780,  4049,   6,  11, UNI_GEORGIANEXT }   /* block=georgianext */,
  {     4,  9768,  8470,   4,   7, UNI_LINA }   /* scx=lineara */,
  {     1,  3097,  2569,  18,   8, UNI_DT__VERT }   /* decompositiontype=vertical */,
  {     2,  3133,  9255,  18,   5, -UNI_EBASE }   /* emojimodifierbase=false */,
  {     4,  7325, 10117,   3,   3, UNI_IN__7 }   /* in=v70 */,
  {     6,  4033,     1,  16,   1, UNI_N }   /* generalcategory=n */,
  {   296,  9556,    36,   4,   1, UNI_GCB__T }   /* gcb=t */,
  {     0,  1552,    47,   9,   1, UNI_M }   /* category=m */,
  {     1,  5791,  9772,  13,   4, UNI_JG__SEEN }   /* joininggroup=seen */,
  {     1,  9270,  3475,   5,  18, UNI_INPC__TOPANDLEFTANDRIGHT }   /* inpc=topandleftandright */,
  {    33,  9532,     0,   4,   0, UNI_CYRL }   /* cyrl */,
  {     2,  1087, 10135,  27,   3, UNI_PCM }   /* prependedconcatenationmark=yes */,
  {     1,  7318,  9384,  10,   4, UNI_IN__10 }   /* presentin=10.0 */,
  {     0,  5986,  7950,  13,   1, UNI_NV__9 }   /* numericvalue=9 */,
  {     1,  4116,  2780,   3,  17, UNI_IDST }   /* isidstrinaryoperator */,
  {    49,  9768,  8888,   4,   4, UNI_HATR }   /* scx=hatr */,
  {     0,  4116,    59,   3,   3, UNI_IDEO }   /* isideo */,
  {     0,  9488,   951,   4,  18, UNI_INVS }   /* blk=variationselectors */,
  {   289,  3385,     0,  17,   0, UNI_RI }   /* regionalindicator */,
  {     1,  8780,  7378,   6,  10, UNI_SUPARROWSA }   /* block=suparrowsa */,
  {     8,  7088,    25,  10,   1, UNI_BC__S }   /* bidiclass=s */,
  {     1,  1552,    38,   9,   2, UNI_XPOSIXDIGIT }   /* category=nd */,
  {    65,  4448,     0,   4,   0, UNI_BAMU }   /* bamu */,
  {     0,  7438,   495,  10,   2, UNI_WB__NU }   /* wordbreak=nu */,
  {     1,  5324,  5845,   4,   7, UNI_INMALAYALAM }   /* inmalayalam */,
  {    18,  9488,  1922,   4,  22, UNI_DIACRITICALSFORSYMBOLS }   /* blk=diacriticalsforsymbols */,
  {     3,  3785,     0,  10,   0, UNI_MANI }   /* manichaean */,
  {    98,  6231,   150,   4,  33, UNI_DIACRITICALSSUP }   /* incombiningdiacriticalmarkssupplement */,
  {    10,  1273,  9836,  21,   4, UNI_CE }   /* compositionexclusion=true */,
  {     1,  6481,     0,  12,   0, UNI_HUNG }   /* oldhungarian */,
  {     0,  8386,     0,   7,   0, UNI_CJKEXTF }   /* cjkextf */,
  {     4,  3385,  1025,  18,   2, -UNI_RI }   /* regionalindicator=no */,
  {    16,  2224,  2288,   3,   6, UNI_INSINHALA }   /* insinhala */,
  {     0,  8589,  6409,   7,  12, UNI_MEND }   /* script=mendekikakui */,
  {     1,  4989,  1868,   3,   8, UNI_XPOSIXUPPER }   /* isuppercase */,
  {     0,  5791,  2223,  13,   3, UNI_JG__AIN }   /* joininggroup=ain */,
  {   197,  8780,   328,   6,  21, UNI_MATHOPERATORS }   /* block=mathematicaloperators */,
  {     0,  6420,  8548,   3,   6, UNI_OLCK }   /* inolchiki */,
  {     0,  9488,  8345,   5,   6, UNI_INBENGALI }   /* blk=bengali */,
  {     0,  9488,  4553,   4,  15, UNI_CONTROLPICTURES }   /* blk=controlpictures */,
  {   130,   184,  7378,   2,  10, UNI_SUPARROWSA }   /* issuparrowsa */,
  {     4, 10048,  8750,   3,   5, UNI_NV__80000 }   /* nv=80000 */,
  {    17,  9488,  7666,   4,   9, UNI_INOLDTURKIC }   /* blk=oldturkic */,
  {     5,  3836,  8582,  17,   7, UNI_PHAG }   /* scriptextensions=phagspa */,
  {     2,  1552,   133,   9,   4, UNI_M }   /* category=mark */,
  {     1,  5986,  7859,  13,   2, UNI_NV__20 }   /* numericvalue=20 */,
  {    32,  9776,     0,   4,   0, UNI_SGNW }   /* sgnw */,
  {     1,  8780,  4337,   6,  16, UNI_SUPMATHOPERATORS }   /* block=supmathoperators */,
  {     0,  6231,   660,   3,  29, UNI_CJKEXTF }   /* incjkunifiedideographsextensionf */,
  {     0,  9508,  9131,   5,   4, UNI_CCC__20 }   /* ccc=ccc20 */,
  {     0,  7428,     0,  10,   0, UNI_WARA }   /* warangciti */,
  {     0,  7438,  6653,  10,  11, UNI_WB__DQ }   /* wordbreak=doublequote */,
  {     1,   250,     0,  33,   0, UNI_MISCMATHSYMBOLSA }   /* miscellaneousmathematicalsymbolsa */,
  {     0,  3367, 10135,  18,   3, UNI__PERL_PATWS }   /* patternwhitespace=yes */,
  {    21,  9277,  2329,   3,  20, UNI_HLUW }   /* sc=anatolianhieroglyphs */,
  {     3,  1033,     0,  27,   0, UNI_ENCLOSEDCJK }   /* enclosedcjklettersandmonths */,
  {     3,  9768,  9584,   4,   4, UNI_HLUW }   /* scx=hluw */,
  {    35,  6231,  8359,   3,   6, UNI_CJKEXTB }   /* incjkextb */,
  {     0,  7325,  9970,   3,   3, UNI_IN__5_DOT_2 }   /* in=5.2 */,
  {     1,  8512,    26,   7,   1, UNI_NFKCQC__Y }   /* nfkcqc=y */,
  {     0,  8589,  9325,   7,   5, UNI_RUNR }   /* script=runic */,
  {     0,  3836,  9095,  17,   5, UNI_BUHD }   /* scriptextensions=buhid */,
  {     0,  9488,  2912,   4,  19, UNI_SUNDANESESUP }   /* blk=sundanesesupplement */,
  {     1,   184,  8984,   2,   5, UNI_QMARK }   /* isqmark */,
  {     1, 10170,     0,   2,   0, UNI_CASEDLETTER }   /* l_ */,
  {     0,  4033,  8855,  16,   2, UNI_CF }   /* generalcategory=cf */,
  {     1, 10290,  9225,   6,   5, UNI_XPOSIXCNTRL }   /* xposixcntrl */,
  {    18,  9488,  1013,   4,   5, UNI_INGREEK }   /* blk=greek */,
  {    64,  9488,  3025,   4,  11, UNI_CHEROKEESUP }   /* blk=cherokeesup */,
  {     0,  2560,     0,   4,   0, UNI_MAND }   /* mand */,
  {     3,  9270,  7298,   5,  10, UNI_INPC__OVERSTRUCK }   /* inpc=overstruck */,
  {     0,  9277,  9860,   3,   4, UNI_VAI }   /* sc=vaii */,
  {    97,  3836,  9480,  17,   4, UNI_BATK }   /* scriptextensions=batk */,
  {    12,  9488,  9452,   4,   4, UNI_INAHOM }   /* blk=ahom */,
  {     0,  9277,  3169,   3,   4, UNI_ETHI }   /* sc=ethi */,
  {    47,   184, 10180,   2,   2, UNI_ZS }   /* iszs */,
  {     0,  5171,     0,   4,   0, UNI_CHAM }   /* cham */,
  {     4,  5674,  1025,  13,   2, -UNI_BIDIM }   /* bidimirrored=no */,
  {    19,  2684,     0,  19,   0, UNI_EGYP }   /* egyptianhieroglyphs */,
  {     0, 10009,  3439,   3,   5, UNI_DT__SML }   /* dt=small */,
  {     1,  8780,  9285,   6,   5, UNI_INLIMBU }   /* block=limbu */,
  {     0,  9596,  7238,   4,  10, UNI_LB__H2 }   /* hst=lvsyllable */,
  {     5,  7318,  9397,  10,   3, UNI_IN__2_DOT_1 }   /* presentin=2.1 */,
  {    36,  6229, 10135,  12,   3, UNI_JOINC }   /* joincontrol=yes */,
  {   130,  9768,  3894,   5,  10, UNI_SGNW }   /* scx=signwriting */,
  {     6,  3717,     0,  17,   0, UNI_identifierstatus_values_index }   /* identifierstatus= */,
  {   112,  8589,  6253,   7,   5, UNI_KHMR }   /* script=khmer */,
  {     2,  8780,  2329,   6,  20, UNI_INANATOLIANHIEROGLYPHS }   /* block=anatolianhieroglyphs */,
  {     0,  1273,     0,  21,   0, UNI_ce_values_index }   /* compositionexclusion= */,
  {     1, 10024,  1186,   3,   2, UNI_PO }   /* gc=po */,
  {     4,  9488,  8659,   4,   7, UNI_INTIBETAN }   /* blk=tibetan */,
  {   394,  5674,  9255,  13,   5, -UNI_BIDIM }   /* bidimirrored=false */,
  {    22,  9488,  5242,   4,  14, UNI_LATINEXTC }   /* blk=latinextendedc */,
  {     1,  8780,  1677,   6,  14, UNI_LATINEXTA }   /* block=latinextendeda */,
  {     0,   184,  8380,   3,   6, UNI_CJKEXTE }   /* iscjkexte */,
  {     0,  9488,  2855,   4,  19, UNI_MONGOLIANSUP }   /* blk=mongoliansupplement */,
  {     0,  3052,     0,   9,   0, UNI_HALFMARKS }   /* halfmarks */,
  {     0,  8780,  1944,   6,  22, UNI_EARLYDYNASTICCUNEIFORM }   /* block=earlydynasticcuneiform */,
  {     0,  8780,  9008,   6,   6, UNI_INTHAANA }   /* block=thaana */,
  {     6,  8884,     3,   4,   1, -UNI_EXT }   /* ext=f */,
  {     2,   184,  1988,   2,  21, UNI_LOE }   /* islogicalorderexception */,
  {     0,  5986,  8738,  13,   5, UNI_NV__60000 }   /* numericvalue=60000 */,
  {     0,    21,  3549,   4,  15, UNI_ALCHEMICAL }   /* inalchemicalsymbols */,
  {     2,  5986,  7867,  13,   8, UNI_NV__1_SLASH_32 }   /* numericvalue=3.12e-02 */,
  {     0,  5986,  7971,  13,   8, UNI_NV__7_SLASH_12 }   /* numericvalue=5.83e-01 */,
  {     0,  5508,    36,  14,   1, UNI_PATSYN }   /* patternsyntax=t */,
  {     0,  5739,  9836,  13,   4, UNI_GRBASE }   /* graphemebase=true */,
  {     0,  2182,    18,  21,   2, UNI_RI }   /* graphemeclusterbreak=ri */,
  {     4,  4033,  6862,  16,  11, UNI_NO }   /* generalcategory=othernumber */,
  {     0,  8780,  5778,   6,  13, UNI_IPAEXT }   /* block=ipaextensions */,
  {     0,  9768,  9712,   4,   4, UNI_OSGE }   /* scx=osge */,
  {     0,  9262,  1194,   3,   2, UNI_LB__LF }   /* sb=lf */,
  {   182,  2218,  9306,   3,   4, UNI_INNUSHU }   /* innushu */,
  {     0,   117,  2431,   4,  18, UNI_ININSCRIPTIONALPAHLAVI }   /* ininscriptionalpahlavi */,
  {     0,  3836,  1628,  17,   4, UNI_PHAG }   /* scriptextensions=phag */,
  {     2,  5284,     0,   7,   0, UNI_LISUSUP }   /* lisusup */,
  {     0,  7325,  7814,   3,   1, UNI_IN__7 }   /* in=7 */,
  {     1,  9997, 10036,   3,   3, UNI_BC__LRE }   /* bc=lre */,
  {    10,  6231,  2141,   3,  17, UNI_CYRILLICSUP }   /* incyrillicsupplement */,
  {     0,  8780,  9800,   6,   4, UNI_TAGS }   /* block=tags */,
  {    56, 10048,  8714,   3,   4, UNI_NV__3000 }   /* nv=3000 */,
  {     0,  8780,  3439,   6,  12, UNI_SMALLKANAEXT }   /* block=smallkanaext */,
  {     0,  1591,  3684,   3,  10, UNI_ETHIOPICEXT }   /* inethiopicext */,
  {     0,  7318, 10081,  10,   3, UNI_IN__3 }   /* presentin=v30 */,
  {     3, 10009,     7,   3,   3, UNI_DT__CAN }   /* dt=can */,
  {     0,  5791,  5424,  13,  14, UNI_JG__MANICHAEANYODH }   /* joininggroup=manichaeanyodh */,
  {     3,  1188,  2297,   3,   3, UNI_INTHAI }   /* inthai */,
  {     0,  8589,  6940,   8,  10, UNI_SORA }   /* script=sorasompeng */,
  {     0,  9277,  7191,   6,   7, UNI_KHAR }   /* sc=kharoshthi */,
  {    20,   184,  9513,   3,   3, UNI_CHRS }   /* ischrs */,
  {     0,  8780,  5687,   6,  13, UNI_BLOCKELEMENTS }   /* block=blockelements */,
  {     5,  1552,  6851,   9,  11, UNI_LO }   /* category=otherletter */,
  {     0,  9488,  3241,   4,  18, UNI_GEORGIANSUP }   /* blk=georgiansupplement */,
  {    11,  3836,  9684,  17,   4, UNI_NEWA }   /* scriptextensions=newa */,
  {     0,  9524,     3,   4,   1, -UNI_CWT }   /* cwt=f */,
  {     2,  9488,  8924,   4,   6, UNI_INLEPCHA }   /* blk=lepcha */,
  {    32,  1441,     0,  10,   0, UNI_CJKSYMBOLS }   /* cjksymbols */,
  {     0,  6420,  7289,   3,   9, UNI_INOLDSOGDIAN }   /* inoldsogdian */,
  {     1,  7438,   495,  10,   7, UNI_WB__NU }   /* wordbreak=numeric */,
  {     0,  8589,  5550,   7,  14, UNI_SC__PHLP }   /* script=psalterpahlavi */,
  {     3, 10048,  7755,   3,   8, UNI_NV__1_SLASH_9 }   /* nv=1.11e-01 */,
  {     0,  8589,  9828,   7,   4, UNI_THAI }   /* script=thai */,
  {     2, 10033,  6217,   3,  12, UNI_LB__IS }   /* lb=infixnumeric */,
  {     0,  8852,    26,   6,   1, UNI_CWKCF }   /* cwkcf=y */,
  {     3,   184,  2409,   2,   4, UNI_GLAG }   /* isglag */,
  {     2,  6061,     0,   5,   0, UNI_BIDIC }   /* bidic */,
  {    85,  5578,    72,  14,   2, UNI_SB__LE }   /* sentencebreak=le */,
  {   162,  1966,  1489,  22,  24, UNI_INSC__CONSONANTSUCCEEDINGREPHA }   /* indicsyllabiccategory=consonantsucceedingrepha */,
  {     0,  3836,  9664,  17,   3, UNI_MRO }   /* scriptextensions=mro */,
  {     0,  5986,  5648,  13,   8, UNI_NV__10000000 }   /* numericvalue=10000000 */,
  {     0,   184,  5075,   3,  13, UNI_CJKCOMPATFORMS }   /* iscjkcompatforms */,
  {     0, 10033,  7108,   3,  10, UNI_LB__BA }   /* lb=breakafter */,
  {     0,  2182,  4360,  21,   9, UNI_WB__EB }   /* graphemeclusterbreak=emodifier */,
  {    21,  6231,  1442,   3,  23, UNI_CJKSYMBOLS }   /* incjksymbolsandpunctuation */,
  {    35,  6873,     0,  11,   0, UNI_SO }   /* othersymbol */,
  {     0,  8589,  9860,   7,   3, UNI_VAI }   /* script=vai */,
  {     0,  8688,  6026,   3,  11, UNI_ALPHABETICPF }   /* isalphabeticpf */,
  {     0,  9277,  8457,   4,   6, UNI_SC__KNDA }   /* sc=kannada */,
  {    38,  6805,  5176,   4,   2, UNI_INMIAO }   /* inmiao */,
  {     8,  9768,  8888,   4,   6, UNI_HATR }   /* scx=hatran */,
  {     0,   184,   749,   2,  21, UNI_ENCLOSEDALPHANUM }   /* isenclosedalphanumerics */,
  {     0,  8589,  9315,   7,   5, UNI_SC__ORYA }   /* script=oriya */,
  {   133,  7438,  5012,  10,   2, UNI_WB__SQ }   /* wordbreak=sq */,
  {     0,  9275,  9026,   5,   6, UNI_INSC__VIRAMA }   /* insc=virama */,
  {     2,  4973,     0,   8,   0, UNI_VEDICEXT }   /* vedicext */,
  {    52,    74,     0,   2,   0, UNI_ME }   /* me */,
  {    26,  1979,     0,  10,   0, UNI_L }   /* category=l */,
  {     0,  5986,  9060,  13,   5, UNI_NV__11_SLASH_12 }   /* numericvalue=11/12 */,
  {     1,  8589,  8219,   7,   4, UNI_SC__JAVA }   /* script=java */,
  {     0,  4033,    47,  16,   1, UNI_M }   /* generalcategory=m */,
  {     6, 10048,  7787,   3,   8, UNI_NV__3_SLASH_2 }   /* nv=1.50e+00 */,
  {     1,  1966,  4113,  22,  16, UNI_INSC__INVISIBLESTACKER }   /* indicsyllabiccategory=invisiblestacker */,
  {     1,  4033,  4943,  16,  15, UNI_TITLE }   /* generalcategory=titlecaseletter */,
  {     0,  8589,  6840,   7,   4, UNI_SC__NAND }   /* script=nand */,
  {     1, 10060, 10135,   3,   3, UNI_RI }   /* ri=yes */,
  {   256,  9488,    78,   4,  35, UNI_ARABICMATH }   /* blk=arabicmathematicalalphabeticsymbols */,
  {     0,  9716, 10135,   4,   3, UNI_PCM }   /* pcm=yes */,
  {     6,  9768,  9285,   4,   5, UNI_LIMB }   /* scx=limbu */,
  {     1,  9768,  8484,   4,   7, UNI_MAND }   /* scx=mandaic */,
  {     5,  3836,  1013,  17,   5, UNI_GREK }   /* scriptextensions=greek */,
  {     6,  7325, 10087,   3,   3, UNI_IN__3_DOT_2 }   /* in=v32 */,
  {     0,  5324,  4342,   4,  11, UNI_MATHOPERATORS }   /* inmathoperators */,
  {     1,  4001,     0,  16,   0, UNI_CYPRIOTSYLLABARY }   /* cypriotsyllabary */,
  {     0,  8299,     0,   8,   0, UNI_TFNG }   /* tifinagh */,
  {   196,  2288,  1656,   4,   4, UNI_INHANGUL }   /* inhangul */,
  {     2,  5986,  7821,  13,   1, UNI_NV__8 }   /* numericvalue=8 */,
  {    64,   184,  7428,   2,  10, UNI_WARA }   /* iswarangciti */,
  {     1,  3836,  6409,  17,  12, UNI_MEND }   /* scriptextensions=mendekikakui */,
  {     3,  5986,  8744,  13,   5, UNI_NV__70000 }   /* numericvalue=70000 */,
  {     1,  9488,  4129,   4,   9, UNI_LATIN1 }   /* blk=latin1sup */,
  {     0,  7088,    18,  10,   1, UNI_BC__R }   /* bidiclass=r */,
  {     0,  6231,  8366,   3,   6, UNI_CJKEXTC }   /* incjkextc */,
  {     2,   183,     0,  34,   0, UNI_MISCPICTOGRAPHS }   /* miscellaneoussymbolsandpictographs */,
  {     0,  2280,  6863,   3,  10, UNI_NO }   /* isothernumber */,
  {     0,  9528,    36,   4,   1, UNI_CWU }   /* cwu=t */,
  {   265,  8589,  8900,   7,   6, UNI_SC__KTHI }   /* script=kaithi */,
  {    46,  6231,    43,   3,  15, UNI_CJKCOMPAT }   /* incjkcompatibility */,
  {     0,  9277,  8484,   3,   7, UNI_SC__MAND }   /* sc=mandaic */,
  {     4,   184,  9624,   2,   4, UNI_LAO }   /* islaoo */,
  {     3,  3836,  9692,  17,   4, UNI_NSHU }   /* scriptextensions=nshu */,
  {     1,  3151,    36,  18,   1, UNI_EPRES }   /* emojipresentation=t */,
  {    58,  3836,  7292,  18,   3, UNI_SOGD }   /* scriptextensions=sogd */,
  {    81,  9488,  8561,   4,   7, UNI_INOSMANYA }   /* blk=osmanya */,
  {     3,    21,  8990,   2,   6, UNI_INREJANG }   /* inrejang */,
  {    32,  7088, 10039,  10,   3, UNI_BC__LRI }   /* bidiclass=lri */,
  {     4, 10024,  1563,   3,   2, UNI_PS }   /* gc=ps */,
  {     1,  3836,  8680,  17,   7, UNI_ZZZZ }   /* scriptextensions=unknown */,
  {     1,  9768,  9672,   4,   4, UNI_MYMR }   /* scx=mymr */,
  {     0,  9071,    26,   4,   1, UNI_XPOSIXXDIGIT }   /* hex=y */,
  {     0,  5986,  9168,  13,   2, UNI_NV__27 }   /* numericvalue=27 */,
  {     0, 10033,   495,   3,   2, UNI_LB__NU }   /* lb=nu */,
  {    31,  8780,  2722,   6,  19, UNI_JAMOEXTA }   /* block=hanguljamoextendeda */,
  {     1,   184,  8414,   2,   4, UNI_ELBA }   /* iselba */,
  {    99,  2784,    80,   4,  33, UNI_ARABICMATH }   /* inarabicmathematicalalphabeticsymbols */,
  {     0,  6277,     0,   4,   0, UNI_MAHJ }   /* mahj */,
  {    35,   117,  3736,   4,  15, UNI_INDICSIYAQNUMBERS }   /* inindicsiyaqnumbers */,
  {     1,  8589,  9330,   7,   5, UNI_SC__TALE }   /* script=taile */,
  {     0,  9277,  9085,   3,   5, UNI_BATK }   /* sc=batak */,
  {     0,  9488,  4928,   4,   5, UNI_INTAMIL }   /* blk=tamil */,
  {    49,  3341,     0,   8,   0, UNI_DINGBATS }   /* dingbats */,
  {     0,  9488,  2665,   4,  11, UNI_COUNTINGROD }   /* blk=countingrod */,
  {    35,  4033,     0,  16,   0, UNI_gc_values_index }   /* generalcategory= */,
  {     4,  1114,     1,  26,   1, -UNI_CWKCF }   /* changeswhennfkccasefolded=n */,
  {     7,  6231,   690,   3,  29, UNI_CJKEXTG }   /* incjkunifiedideographsextensiong */,
  {     3,  7438,    18,  10,   2, UNI_RI }   /* wordbreak=ri */,
  {     0,   184, 10178,   2,   2, UNI_ZP }   /* iszp */,
  {     3,  5986,  9916,  13,   3, UNI_NV__2_SLASH_5 }   /* numericvalue=2/5 */,
  {     2,  8780,  8900,   6,   6, UNI_INKAITHI }   /* block=kaithi */,
  {     0,  2817,     0,   4,   0, UNI_MERO }   /* mero */,
  {     0, 10024,  4583,   3,  15, UNI_PD }   /* gc=dashpunctuation */,
  {     0,  7675,     0,   9,   0, UNI_PALM }   /* palmyrene */,
  {    16,   184,  2141,   3,  17, UNI_CYRILLICSUP }   /* iscyrillicsupplement */,
  {     3,  8780,  5830,   6,  13, UNI_LOWSURROGATES }   /* block=lowsurrogates */,
  {     0,  4033,  9225,  16,   5, UNI_XPOSIXCNTRL }   /* generalcategory=cntrl */,
  {     8,    21,  8936,   2,   6, UNI_INLYCIAN }   /* inlycian */,
  {    16,  5791,  9075,  13,   5, UNI_JG__ALAPH }   /* joininggroup=alaph */,
  {     3,  4989,  4959,   3,  14, UNI_UPPERCASELETTER }   /* isuppercaseletter */,
  {   120,   184,  3937,   2,   8, UNI_BOPO }   /* isbopomofo */,
  {     0, 10132,  8323,   3,   7, UNI_WB__LE }   /* wb=aletter */,
  {     4,  8589,  9245,   7,   5, UNI_SC__DOGR }   /* script=dogra */,
  {    67,  3853,     1,  17,   1, -UNI_STERM }   /* sentenceterminal=n */,
  {     0, 10182,  1159,  33,   5, UNI__PERL_PROBLEMATIC_LOCALE_FOLDEDS_START }   /* _perl_problematic_locale_foldeds_start */,
  {     3,  9768,  9002,   4,   6, UNI_TELU }   /* scx=telugu */,
  {     0,  5040,     0,   5,   0, UNI_XPOSIXDIGIT }   /* digit */,
  {     2,  5564,  1025,  14,   2, -UNI_QMARK }   /* quotationmark=no */,
  {     0,     7,     0,   1,   0, UNI_C }   /* c */,
  {     1,  9640,     1,   4,   1, -UNI_LOE }   /* loe=n */,
  {     0,  8780,  3921,   6,   9, UNI_ARABICSUP }   /* block=arabicsup */,
  {     0,  9828,     0,   4,   0, UNI_THAI }   /* thai */,
  {     0,  9488,  3241,   4,   8, UNI_INGEORGIAN }   /* blk=georgian */,
  {     0,  3836,  9440,  17,   4, UNI_ADLM }   /* scriptextensions=adlm */,
  {   163,  6609, 10135,  11,   3, UNI_DEP }   /* deprecated=yes */,
  {     4, 10296,    62,   7,   5, UNI_POSIXGRAPH }   /* isposixgraph */,
  {     0,   184,  8373,   3,   6, UNI_CJKEXTD }   /* iscjkextd */,
  {   103,  9488,  5228,   4,  14, UNI_LATINEXTB }   /* blk=latinextendedb */,
  {     1,  4791,     0,  17,   0, UNI_INMEROITICCURSIVE }   /* inmeroiticcursive */,
  {     4,  1812,  9255,  22,   5, -UNI_CWL }   /* changeswhenlowercased=false */,
  {     0,  9768,  8498,   4,   7, UNI_MULT }   /* scx=multani */,
  {     1,  9277,  4369,   3,   6, UNI_SC__SYRC }   /* sc=syriac */,
  {     1,  9270,  7676,   3,   8, UNI_PALM }   /* inpalmyrene */,
  {     0,  9277,  9325,   3,   5, UNI_RUNR }   /* sc=runic */,
  {   474,  1552,   467,   9,   5, UNI_P }   /* category=punct */,
  {     0,  4116,  6555,   3,   9, UNI_IDC }   /* isidcontinue */,
  {     0,  9716,     3,   4,   1, -UNI_PCM }   /* pcm=f */,
  {     0,  6620,     0,   6,   0, UNI_DOMINO }   /* domino */,
  {     0,  3836,  4868,  17,  15, UNI_NARB }   /* scriptextensions=oldnortharabian */,
  {     2,   184,  4973,   2,  15, UNI_VEDICEXT }   /* isvedicextensions */,
  {    11,  1828,    36,   6,   1, UNI_CASED }   /* cased=t */,
  {    20,  9488,  8315,   4,   8, UNI_INUGARITIC }   /* blk=ugaritic */,
  {     0,  7218,   184,  10,   2, UNI_LB__IS }   /* linebreak=is */,
  {     0,  7739,  1025,   8,   2, -UNI_IDS }   /* idstart=no */,
  {     4,  9488,  9038,   4,   6, UNI_INYEZIDI }   /* blk=yezidi */,
  {     0,  8589,  9285,   7,   5, UNI_SC__LIMB }   /* script=limbu */,
  {     2,  7325,  7987,   3,   3, UNI_IN__6_DOT_2 }   /* in=6.2 */,
  {     3,  7155,  2723,   3,   9, UNI_JAMO }   /* ishanguljamo */,
  {     0,  7318, 10084,  10,   3, UNI_IN__3_DOT_1 }   /* presentin=v31 */,
  {     1,  3097,  9868,  18,   4, UNI_EA__F }   /* decompositiontype=wide */,
  {   106,  9277,  6939,   3,  11, UNI_SORA }   /* sc=sorasompeng */,
  {     0,  9488,  8211,   4,   8, UNI_JAMOEXTB }   /* blk=jamoextb */,
  {    12,  9556,     0,   4,   0, UNI_gcb_values_index }   /* gcb= */,
  {    41,  2182,    36,  21,   1, UNI_GCB__T }   /* graphemeclusterbreak=t */,
  {     0,  7325,  7781,   3,   1, UNI_IN__4 }   /* in=4 */,
  {     3,  8762, 10135,   6,   3, UNI_XPOSIXALPHA }   /* alpha=yes */,
  {     0,  1552,  6873,   9,  11, UNI_SO }   /* category=othersymbol */,
  {     5,  1059,     0,   2,   0, UNI_SO }   /* so */,
  {     0,  9556,  1194,   4,   2, UNI_LB__LF }   /* gcb=lf */,
  {     0,  3836,  8786,  17,   4, UNI_CARI }   /* scriptextensions=cari */,
  {     0, 10333,  8611,   3,   6, UNI_SIDD }   /* issiddham */,
  {     7,  5986,  9994,  13,   3, UNI_NV__9_SLASH_2 }   /* numericvalue=9/2 */,
  {    48,  5578,   138,  14,   2, UNI_SB__FO }   /* sentencebreak=fo */,
  {     6,  9277,  8638,   3,   7, UNI_SC__TGLG }   /* sc=tagalog */,
  {    69,  4643,    26,  15,   1, UNI_ECOMP }   /* emojicomponent=y */,
  {   128,  5200,     0,  14,   0, UNI_KANASUP }   /* kanasupplement */,
  {     1,  5986,  8042,  13,   2, UNI_NV__18 }   /* numericvalue=18 */,
  {     0,  8906,     0,   6,   0, UNI_KANBUN }   /* kanbun */,
  {     2,  4916,  9336,   3,   3, UNI_TAKR }   /* istakr */,
  {     1,   184,  2120,   3,  13, UNI_CJKRADICALSSUP }   /* iscjkradicalssup */,
  {    18,  3097,  1253,  18,   4, UNI_DT__INIT }   /* decompositiontype=init */,
  {     3,  9640,     0,   4,   0, UNI_loe_values_index }   /* loe= */,
  {    25,  3097,  5904,  18,   4, UNI_DT__NONE }   /* decompositiontype=none */,
  {     9,  7318, 10120,  10,   3, UNI_IN__8 }   /* presentin=v80 */,
  {     0,  6097,     0,  12,   0, UNI_CYRILLICEXTA }   /* cyrillicexta */,
  {    88,  9488,  2119,   4,  21, UNI_CJKRADICALSSUP }   /* blk=cjkradicalssupplement */,
  {     6,   184,  7621,   2,   9, UNI_NBAT }   /* isnabataean */,
  {     1,  8780,  7368,   6,  10, UNI_SMALLFORMS }   /* block=smallforms */,
  {     1,  8884,  9836,   4,   4, UNI_EXT }   /* ext=true */,
  {     3,  8610,     0,   7,   0, UNI_SIDD }   /* siddham */,
  {   344,  5116,     3,  14,   1, -UNI_EMOD }   /* emojimodifier=f */,
  {     0,  9508,  9940,   4,   3, UNI_CCC__A }   /* ccc=230 */,
  {     1,   908,     0,  10,   0, UNI_CO }   /* privateuse */,
  {     1,   184, 10303,   2,   5, UNI_XPOSIXBLANK }   /* isblank */,
  {     0,  3836,  9672,  17,   4, UNI_MYMR }   /* scriptextensions=mymr */,
  {     0,  9768,  9512,   4,   4, UNI_CHRS }   /* scx=chrs */,
  {    38,  6231,  5075,   3,  13, UNI_CJKCOMPATFORMS }   /* incjkcompatforms */,
  {     5,  5564,     0,  13,   0, UNI_QMARK }   /* quotationmark */,
  {     0,   184,   283,   2,  33, UNI_MISCMATHSYMBOLSB }   /* ismiscellaneousmathematicalsymbolsb */,
  {     5,  1417,  9937,  24,   3, UNI_CCC__AL }   /* canonicalcombiningclass=228 */,
  {     1,  1188,  9009,   3,   5, UNI_INTHAANA }   /* inthaana */,
  {     0,  4033,    24,  16,   1, UNI_L }   /* generalcategory=l */,
  {     8,  9277,  2817,   3,  19, UNI_MERO }   /* sc=meroitichieroglyphs */,
  {     4,  3836,  9628,  17,   4, UNI_LATN }   /* scriptextensions=latn */,
  {     1,  1834,     3,  22,   1, -UNI_CWT }   /* changeswhentitlecased=f */,
  {     2,  8774,    36,   6,   1, UNI_BIDIM }   /* bidim=t */,
  {     0,  5791,  5856,  13,  13, UNI_JG__MALAYALAMNNNA }   /* joininggroup=malayalamnnna */,
  {    11,  5791,  6289,  13,  12, UNI_JG__MALAYALAMBHA }   /* joininggroup=malayalambha */,
  {    99,  7218,  4538,  10,  15, UNI_LB__CB }   /* linebreak=contingentbreak */,
  {    84,  2218,  6842,   4,   9, UNI_INNANDINAGARI }   /* innandinagari */,
  {     5,  4916,  9009,   3,   3, UNI_THAA }   /* isthaa */,
  {     1,  1552,     7,   9,   1, UNI_C }   /* category=c */,
  {   150,  2218,  1912,   3,  10, UNI_NUMBERFORMS }   /* innumberforms */,
  {     5,  9277,  9285,   3,   5, UNI_SC__LIMB }   /* sc=limbu */,
  {   135,  9768,  9797,   5,   3, UNI_SYRC }   /* scx=syrc */,
  {    10,   184,  4273,   2,   7, UNI_MYMR }   /* ismyanmar */,
  {     3,  8780,  4598,   6,  15, UNI_DIACRITICALSEXT }   /* block=diacriticalsext */,
  {     0,  9488,  3025,   4,  18, UNI_CHEROKEESUP }   /* blk=cherokeesupplement */,
  {     1,  1790,     0,  21,   0, UNI_CWCM }   /* changeswhencasemapped */,
  {     1,  7155,  2742,   3,  18, UNI_JAMOEXTB }   /* ishanguljamoextendedb */,
  {    23,  8780,  4478,   6,  15, UNI_BRAI }   /* block=braillepatterns */,
  {     0, 10333, 10183,   7,   4, UNI_XPOSIXSPACE }   /* isspaceperl */,
  {     6, 10027,  5179,   3,   3, UNI_JG__HEH }   /* jg=heh */,
  {     0,  8589,  9580,   7,   4, UNI_SC__HANO }   /* script=hano */,
  {    26, 10182,  7739,   6,   7, UNI__PERL_IDSTART }   /* _perl_idstart */,
  {     0,  9350,    36,   5,   1, UNI_XIDS }   /* xids=t */,
  {   306,  2224,  3888,   3,  16, UNI_SUTTONSIGNWRITING }   /* insuttonsignwriting */,
  {    88,  7325,  9982,   3,   3, UNI_IN__6_DOT_3 }   /* in=6.3 */,
  {   258, 10006,  9836,   3,   4, UNI_DI }   /* di=true */,
  {     0,  8954,    17,   7,   1, -UNI__PERL_NCHAR }   /* nchar=no */,
  {     0,   184,  1723,   2,  23, UNI_SUPPUNCTUATION }   /* issupplementalpunctuation */,
  {     0, 10024,  1527,   3,   9, UNI__PERL_SURROGATE }   /* gc=surrogate */,
  {     0,  3836,  9724,  17,   4, UNI_PHNX }   /* scriptextensions=phnx */,
  {   232,  6840,     0,   4,   0, UNI_NAND }   /* nand */,
  {     1, 10027,  5892,   3,   3, UNI_JG__NUN }   /* jg=nun */,
  {    32, 10327,  3379,   6,   5, UNI_POSIXSPACE }   /* isperlspace */,
  {     0,  7168,     0,  10,   0, UNI_DIAK }   /* divesakuru */,
  {     1,  2836,     0,  19,   0, UNI_MODIFIERTONELETTERS }   /* modifiertoneletters */,
  {     1,  8858, 10135,   6,   3, UNI_ECOMP }   /* ecomp=yes */,
  {     0,  9768,  9500,   4,   4, UNI_CAKM }   /* scx=cakm */,
  {     1,  7218,  9713,  10,   2, UNI_LB__SG }   /* linebreak=sg */,
  {     0,  9768,  7558,   4,   9, UNI_QAAI }   /* scx=inherited */,
  {    33,  9250, 10135,   5,   3, UNI_EMOD }   /* emod=yes */,
  {     0,  1273,    36,  21,   1, UNI_CE }   /* compositionexclusion=t */,
  {     0,  1417,  5377,  24,   2, UNI_CCC__7 }   /* canonicalcombiningclass=nk */,
  {     0,  1979,     0,  10,   1, UNI_UPPERCASELETTER }   /* category=lu */,
  {     1,  9488,  6181,   4,  12, UNI_INGUNJALAGONDI }   /* blk=gunjalagondi */,
  {     0,  9277,  9305,   3,   5, UNI_NSHU }   /* sc=nushu */,
  {     2,  7128,     0,  10,   0, UNI_CJKSTROKES }   /* cjkstrokes */,
  {     1,  9488,  7358,   4,  10, UNI_INSAURASHTRA }   /* blk=saurashtra */,
  {     2,   184,  9624,   2,   3, UNI_LAO }   /* islao */,
  {     0,  5986,  8002,  13,   2, UNI_NV__26 }   /* numericvalue=26 */,
  {     0,  7218, 10162,  10,   2, UNI_GCB__L }   /* linebreak=jl */,
  {    32,  9508,  9141,   5,   4, UNI_CCC__22 }   /* ccc=ccc22 */,
  {     3,  3836,  8900,  17,   6, UNI_KTHI }   /* scriptextensions=kaithi */,
  {     1,  4360,     0,   4,   0, UNI_EMOD }   /* emod */,
  {    97, 10132,  1822,   3,   2, UNI_WB__NL }   /* wb=nl */,
  {     1,  3836,  9500,  17,   4, UNI_CAKM }   /* scriptextensions=cakm */,
  {     1,  9768,  2429,   4,  20, UNI_PHLI }   /* scx=inscriptionalpahlavi */,
  {     0,  9488,  9335,   4,   5, UNI_INTAKRI }   /* blk=takri */,
  {     0,  5438,     0,  14,   0, UNI_SK }   /* modifiersymbol */,
  {     0,  8512, 10135,   7,   3, UNI_NFKCQC__Y }   /* nfkcqc=yes */,
  {    64,  9768,  9876,   4,   4, UNI_XSUX }   /* scx=xsux */,
  {     0,  5037, 10135,   9,   3, UNI_XPOSIXXDIGIT }   /* hexdigit=yes */,
  {    11,  2161, 10135,  21,   3, UNI_EXTPICT }   /* extendedpictographic=yes */,
  {     1,  6928,  9255,  11,   5, -UNI_SD }   /* softdotted=false */,
  {     0,  1189,  5904,   3,   4, UNI_NV__NAN }   /* nt=none */,
  {    32,  1856, 10135,  22,   3, UNI_CWU }   /* changeswhenuppercased=yes */,
  {     4,  9488,     0,   4,  42, UNI_UCASEXT }   /* blk=unifiedcanadianaboriginalsyllabicsextended */,
  {     6,  8315,     0,   4,   0, UNI_UGAR }   /* ugar */,
  {    81,  5986,  8732,  13,   3, UNI_NV__500 }   /* numericvalue=500 */,
  {    12,  6928,     0,  11,   0, UNI_sd_values_index }   /* softdotted= */,
  {     0,  9277,  7675,   3,   9, UNI_PALM }   /* sc=palmyrene */,
  {     1,  9768,  4370,   5,   5, UNI_SYRC }   /* scx=syriac */,
  {     2,  7438,  1218,  10,   2, UNI_WB__KA }   /* wordbreak=ka */,
  {     4,  9768,  9676,   4,   4, UNI_NARB }   /* scx=narb */,
  {     0,  2760,     0,  19,   0, UNI_hst_values_index }   /* hangulsyllabletype= */,
  {     9,  2760,  6541,  19,  12, UNI_GCB__T }   /* hangulsyllabletype=trailingjamo */,
  {     3,  3836,  6886,  18,   3, UNI_SHAW }   /* scriptextensions=shaw */,
  {   332,  6061,    26,  12,   1, UNI_BIDIC }   /* bidicontrol=y */,
  {     0,  3836,     7,  17,  18, UNI_CANS }   /* scriptextensions=canadianaboriginal */,
  {    30,  7228,  1025,  10,   2, -UNI_XPOSIXLOWER }   /* lowercase=no */,
  {     8,  9444,  9400,   4,   4, UNI_AGE__13 }   /* age=13.0 */,
  {     4,  2032,  9836,  22,   4, UNI__PERL_NCHAR }   /* noncharactercodepoint=true */,
  {     0,  6840,     0,  11,   0, UNI_NAND }   /* nandinagari */,
  {     1, 10333,  6792,   3,   3, UNI_SAMR }   /* issamr */,
  {     0,  9488,  2119,   4,  14, UNI_CJKRADICALSSUP }   /* blk=cjkradicalssup */,
  {     0,  5550,     0,  14,   0, UNI_PHLP }   /* psalterpahlavi */,
  {     0,  9768,  9496,   4,   4, UNI_BUHD }   /* scx=buhd */,
  {     0,  2280,  7650,   4,   7, UNI_ITAL }   /* isolditalic */,
  {     4, 10048,  7789,   3,   2, UNI_NV__50 }   /* nv=50 */,
  {   532,  9277,  9532,   3,   4, UNI_SC__CYRL }   /* sc=cyrl */,
  {   117,  5791, 10000,  13,   3, UNI_JG__BEH }   /* joininggroup=beh */,
  {     0,  8589,  8942,   7,   4, UNI_LYDI }   /* script=lydi */,
  {     4,  8589,  8666,   7,   4, UNI_SC__TIRH }   /* script=tirh */,
  {   512,  9277,  3169,   3,   8, UNI_ETHI }   /* sc=ethiopic */,
  {     0,  9768,  9860,   4,   3, UNI_VAI }   /* scx=vai */,
  {   544,  4688,  7208,  15,  10, UNI_IDENTIFIERTYPE__LIMITEDUSE }   /* identifiertype=limiteduse */,
  {     0,  9488,  1723,   4,  23, UNI_SUPPUNCTUATION }   /* blk=supplementalpunctuation */,
  {     0,  7218,  5046,  10,  14, UNI_LB__CR }   /* linebreak=carriagereturn */,
  {     0,   184,  8394,   3,   6, UNI_CJKEXTG }   /* iscjkextg */,
  {     2,  4916,  4188,   3,   3, UNI_TALE }   /* istale */,
  {     0,  6609,  9255,  11,   5, -UNI_DEP }   /* deprecated=false */,
  {    26,  8780,  3115,   6,  18, UNI_DEVANAGARIEXT }   /* block=devanagariextended */,
  {     1,  9488,  2589,   4,  19, UNI_ANCIENTGREEKNUMBERS }   /* blk=ancientgreeknumbers */,
  {     0,  5324,  8245,   4,   6, UNI_INMAHAJANI }   /* inmahajani */,
  {     0,  8858,     3,   6,   1, -UNI_ECOMP }   /* ecomp=f */,
  {     0,  9768,  6796,   4,  11, UNI_MEDF }   /* scx=medefaidrin */,
  {     0,  5986,  8082,  13,   2, UNI_NV__19 }   /* numericvalue=19 */,
  {     0,  7318,  7408,  10,  10, UNI_AGE__NA }   /* presentin=unassigned */,
  {    32,  6231,  8841,   3,   5, UNI_INCHAKMA }   /* inchakma */,
  {     0,  1087,     0,  27,   0, UNI_pcm_values_index }   /* prependedconcatenationmark= */,
  {     1,  8780,  9828,   6,   4, UNI_INTHAI }   /* block=thai */,
  {     0,  2287,     0,  21,   0, UNI_SINHALAARCHAICNUMBERS }   /* sinhalaarchaicnumbers */,
  {     0,  9290,     1,   5,   1, -UNI_MATH }   /* math=n */,
  {    40,  9768,  2061,   4,   4, UNI_MODI }   /* scx=modi */,
  {     0,  1060,     0,  27,   0, UNI_OCR }   /* opticalcharacterrecognition */,
  {     0,  3097,  1309,  18,   3, UNI_DT__SUB }   /* decompositiontype=sub */,
  {    82, 10027,  7148,   3,  10, UNI_JG__DALATHRISH }   /* jg=dalathrish */,
  {     0,  7318, 10087,  10,   3, UNI_IN__3_DOT_2 }   /* presentin=v32 */,
  {    65, 10033,   751,   3,   2, UNI_LB__CL }   /* lb=cl */,
  {     0,  9240,     3,   5,   1, -UNI_DASH }   /* dash=f */,
  {     0,  3836,  9544,  17,   4, UNI_DIAK }   /* scriptextensions=diak */,
  {     0,  9275,  1244,   5,  25, UNI_INSC__CONSONANTINITIALPOSTFIXED }   /* insc=consonantinitialpostfixed */,
  {     1,  4116,   447,   3,  31, UNI_IDEOGRAPHICSYMBOLS }   /* isideographicsymbolsandpunctuation */,
  {     0,  9488,  7648,   4,   9, UNI_INOLDITALIC }   /* blk=olditalic */,
  {     1,  7325,  7469,   3,   1, UNI_IN__5 }   /* in=5 */,
  {    11,  4628,  1204,  15,   9, UNI_EA__F }   /* eastasianwidth=fullwidth */,
  {     9,  3133,  9836,  18,   4, UNI_EBASE }   /* emojimodifierbase=true */,
  {    73,  9277,  6972,   3,   4, UNI_SC__SYLO }   /* sc=sylo */,
  {     4,  6061,  9836,  12,   4, UNI_BIDIC }   /* bidicontrol=true */,
  {     0,   184,  5284,   2,   4, UNI_LISU }   /* islisu */,
  {     1,  3836,  8421,  17,   7, UNI_ELYM }   /* scriptextensions=elymaic */,
  {     0,  9230,     0,   5,   0, UNI_cwcf_values_index }   /* cwcf= */,
  {     0,   184,  1561,   2,  24, UNI_SUPSYMBOLSANDPICTOGRAPHS }   /* issupsymbolsandpictographs */,
  {     0,  4658,     3,  15,   1, -UNI_GREXT }   /* graphemeextend=f */,
  {     1,  9488,   217,   4,  33, UNI_DIACRITICALSEXT }   /* blk=combiningdiacriticalmarksextended */,
  {     1,  5578,  6556,  15,   8, UNI_SB__SC }   /* sentencebreak=scontinue */,
  {     3,  9250,  9836,   5,   4, UNI_EMOD }   /* emod=true */,
  {    98,  9260,    36,   5,   1, UNI_IDSB }   /* idsb=t */,
  {   173,  1966,  6457,  22,  12, UNI_INSC__NUMBERJOINER }   /* indicsyllabiccategory=numberjoiner */,
  {   104,  4688,     0,  15,   0, UNI_identifiertype_values_index }   /* identifiertype= */,
  {   260,  8589,  9576,   7,   4, UNI_SC__GURU }   /* script=guru */,
  {    16,  3836,  9696,  17,   4, UNI_OGAM }   /* scriptextensions=ogam */,
  {     1,  8400,  9255,   7,   5, -UNI_COMPEX }   /* compex=false */,
  {    36, 10296,  3379,   7,   5, UNI_POSIXSPACE }   /* isposixspace */,
  {     0,  9508,  9946,   4,   3, UNI_CCC__DB }   /* ccc=233 */,
  {     0,  6109,     0,  12,   0, UNI_CYRILLICEXTB }   /* cyrillicextb */,
  {     0,   184,  8900,   2,   6, UNI_KTHI }   /* iskaithi */,
  {     0,   951,     0,  28,   0, UNI_VSSUP }   /* variationselectorssupplement */,
  {   276,  9596,  5973,   4,  13, UNI_HST__NA }   /* hst=notapplicable */,
  {    61,  1723,     0,  23,   0, UNI_SUPPUNCTUATION }   /* supplementalpunctuation */,
  {     3,  3097,  4017,  18,   5, UNI_DT__FIN }   /* decompositiontype=final */,
  {     0,  9345,  9836,   5,   4, UNI_XIDC }   /* xidc=true */,
  {   461,  8589,  9793,   8,   3, UNI_SOGO }   /* script=sogo */,
  {     0,  8780,  5032,   6,   5, UNI_ASCII }   /* block=ascii */,
  {     0,  8589,  9624,   7,   4, UNI_LAO }   /* script=laoo */,
  {     5,  2288,  2205,   4,  12, UNI_INHANIFIROHINGYA }   /* inhanifirohingya */,
  {     3,    42,     0,  26,   0, UNI_CJKCOMPATIDEOGRAPHS }   /* cjkcompatibilityideographs */,
  {     1,  8780,  5284,   6,  14, UNI_LISUSUP }   /* block=lisusupplement */,
  {     0,  8291,     0,   4,   0, UNI_TAGB }   /* tagb */,
  {     0,  4989,  7409,   3,   9, UNI_CN }   /* isunassigned */,
  {    10,  8870,    36,   6,   1, UNI_EPRES }   /* epres=t */,
  {     1,  9488,  5960,   4,  13, UNI_MISCTECHNICAL }   /* blk=misctechnical */,
  {     6,  8589,  8645,   7,   7, UNI_LANA }   /* script=taitham */,
  {     5,  9488,  1006,   4,  27, UNI_ANCIENTGREEKMUSIC }   /* blk=ancientgreekmusicalnotation */,
  {     0,  4113,  4974,   3,   7, UNI_VEDICEXT }   /* invedicext */,
  {     2,   122,     0,   9,   0, UNI_DIA }   /* diacritic */,
  {     0,  1812,     1,  22,   1, -UNI_CWL }   /* changeswhenlowercased=n */,
  {    71,  9488,  3870,   4,  17, UNI_SMALLFORMS }   /* blk=smallformvariants */,
  {     0,  2224,  1724,   3,  22, UNI_SUPPUNCTUATION }   /* insupplementalpunctuation */,
  {    32,   184,    84,   2,   4, UNI_MATH }   /* ismath */,
  {     0,  6231,  1879,   3,  21, UNI_CJKCOMPATIDEOGRAPHSSUP }   /* incjkcompatideographssup */,
  {     0,  8780,  7648,   6,   9, UNI_INOLDITALIC }   /* block=olditalic */,
  {     0,  9768,  8179,   4,   8, UNI_GURU }   /* scx=gurmukhi */,
  {     3,   184,  1171,   2,   2, UNI_TITLE }   /* islt */,
  {     0,  3836,  6840,  17,  11, UNI_NAND }   /* scriptextensions=nandinagari */,
  {     0,  1966,  2844,  22,  10, UNI_INSC__TONELETTER }   /* indicsyllabiccategory=toneletter */,
  {     1,  3547,     0,  17,   0, UNI_ALCHEMICAL }   /* alchemicalsymbols */,
  {     0,  8421,     0,   7,   0, UNI_ELYM }   /* elymaic */,
  {     3, 10048, 10152,   3,   2, UNI_NV__49 }   /* nv=49 */,
  {     0,  9488,  9315,   4,   5, UNI_INORIYA }   /* blk=oriya */,
  {    35,  9277,  8315,   3,   4, UNI_UGAR }   /* sc=ugar */,
  {     0,  9508,  9156,   5,   4, UNI_CCC__25 }   /* ccc=ccc25 */,
  {    36,  3836,  5171,  17,   4, UNI_CHAM }   /* scriptextensions=cham */,
  {     6,  4033,  1186,  16,   2, UNI_PO }   /* generalcategory=po */,
  {     2,  8882,     1,   6,   1, -UNI_GREXT }   /* grext=n */,
  {    17,  9277,  9816,   3,   4, UNI_TAVT }   /* sc=tavt */,
  {     0,  1563,     0,   2,   0, UNI_PS }   /* ps */,
  {    66,  9488,  8906,   4,   6, UNI_KANBUN }   /* blk=kanbun */,
  {     0,  9444,  8043,   4,   3, UNI_AGE__8 }   /* age=8.0 */,
  {     0,  9290,  1025,   5,   2, -UNI_MATH }   /* math=no */,
  {    11,  1979,    36,  10,   1, UNI_TITLE }   /* category=lt */,
  {     3, 10048,  9976,   3,   3, UNI_NV__5_SLASH_8 }   /* nv=5/8 */,
  {     0,  8997,     0,   6,   0, UNI_TERM }   /* term=t */,
  {     0,   184,  6730,   2,  11, UNI_KATAKANAEXT }   /* iskatakanaext */,
  {   262,  8780,  3600,   6,   4, UNI_UCAS }   /* block=ucas */,
  {     8,  7155,  9593,   3,   3, UNI_HMNP }   /* ishmnp */,
  {     5,  7155,  1193,   3,  25, UNI_HALFANDFULLFORMS }   /* ishalfwidthandfullwidthforms */,
  {   316,  9768,  8597,   5,   6, UNI_SHRD }   /* scx=sharada */,
  {     0,  1988,    36,  22,   1, UNI_LOE }   /* logicalorderexception=t */,
  {     0,  3374,     1,  11,   1, -UNI_XPOSIXSPACE }   /* whitespace=n */,
  {     0,  9444, 10075,   4,   3, UNI_AGE__2 }   /* age=v20 */,
  {     8,  9444,  9955,   4,   3, UNI_AGE__3_DOT_2 }   /* age=3.2 */,
  {     0,  2288,  8444,   4,   5, UNI_INHANUNOO }   /* inhanunoo */,
  {     0,  6231,   510,   3,  29, UNI_CJKEXTA }   /* incjkunifiedideographsextensiona */,
  {     2,   184,  6098,   3,  11, UNI_CYRILLICEXTA }   /* iscyrillicexta */,
  {     0, 10060,     1,   3,   1, -UNI_RI }   /* ri=n */,
  {     0,  6231,  8352,   3,   6, UNI_CJKEXTA }   /* incjkexta */,
  {     0,  1988,  9255,  22,   5, -UNI_LOE }   /* logicalorderexception=false */,
  {     2,  5791,  7045,  13,   3, UNI_JG__FEH }   /* joininggroup=feh */,
  {    64,  4116,   325,   3,   3, UNI_ITAL }   /* isital */,
  {     0,  7088, 10042,  10,   3, UNI_BC__LRO }   /* bidiclass=lro */,
  {    47,  7155,     8,   3,   2, UNI_HAN }   /* ishan */,
  {     0,  5986,  7765,  13,   2, UNI_NV__25 }   /* numericvalue=25 */,
  {     3,  9488,  4340,   4,  13, UNI_MATHOPERATORS }   /* blk=mathoperators */,
  {     0, 10033,  8680,   3,   7, UNI_LB__XX }   /* lb=unknown */,
  {     2, 10024,  1059,   3,   2, UNI_SO }   /* gc=so */,
  {     8,  7088,   407,  10,   2, UNI_BC__ON }   /* bidiclass=on */,
  {     3,  4245,     0,  10,   0, UNI_SM }   /* mathsymbol */,
  {    32,  8780,  4928,   6,   5, UNI_INTAMIL }   /* block=tamil */,
  {     0,  9488,  5550,   4,  14, UNI_INPSALTERPAHLAVI }   /* blk=psalterpahlavi */,
  {     3,  8870,  1025,   6,   2, -UNI_EPRES }   /* epres=no */,
  {     4,  9876,     0,   4,   0, UNI_XSUX }   /* xsux */,
  {     3,  8966,     0,   7,   0, UNI_DT__CAN }   /* nfdqc=n */,
  {     4,  9265,  9255,   5,   5, -UNI_IDST }   /* idst=false */,
  {    11,  7218,  5088,  10,  14, UNI_LB__SA }   /* linebreak=complexcontext */,
  {     1,  3836,  3598,  17,  17, UNI_AGHB }   /* scriptextensions=caucasianalbanian */,
  {     0,  8780,  4049,   6,  16, UNI_GEORGIANEXT }   /* block=georgianextended */,
  {    10,  3385,     1,  18,   1, -UNI_RI }   /* regionalindicator=n */,
  {     0,  8589,  9095,   7,   5, UNI_SC__BUHD }   /* script=buhid */,
  {     1, 10024, 10170,   3,   2, UNI_CASEDLETTER }   /* gc=l_ */,
  {     1,  5791,  6774,  13,  11, UNI_JG__MALAYALAMJA }   /* joininggroup=malayalamja */,
  {     4,   117,  5779,   3,  12, UNI_IPAEXT }   /* inipaextensions */,
  {    56,  5986,  8756,  13,   6, UNI_NV__900000 }   /* numericvalue=900000 */,
  {     2,  8589,  3169,   7,   8, UNI_ETHI }   /* script=ethiopic */,
  {     0, 10033,  2444,   3,   2, UNI_LB__HL }   /* lb=hl */,
  {     6,  1114,  9255,  26,   5, -UNI_CWKCF }   /* changeswhennfkccasefolded=false */,
  {     0, 10027,  9044,   3,   4, UNI_JG__YUDH }   /* jg=yudh */,
  {     2,  4385,     0,   6,   0, UNI_TANG }   /* tangut */,
  {     2,  8780,  2245,   6,  14, UNI_MEETEIMAYEKEXT }   /* block=meeteimayekext */,
  {    32,  3836,  9330,  17,   5, UNI_TALE }   /* scriptextensions=taile */,
  {     0,  3836,  8107,  17,   4, UNI_BALI }   /* scriptextensions=bali */,
  {    32,  5986,  5648,  13,   7, UNI_NV__1000000 }   /* numericvalue=1000000 */,
  {    24,  8780,  4369,   6,   6, UNI_INSYRIAC }   /* block=syriac */,
  {   206,  4838,    17,  16,   1, UNI_NFKCQC__N }   /* nfkcquickcheck=no */,
  {     2,  6061,     3,  12,   1, -UNI_BIDIC }   /* bidicontrol=f */,
  {     0,  9277,  8344,   3,   4, UNI_SC__BENG }   /* sc=beng */,
  {     0,  9277,  9544,   3,   4, UNI_DIAK }   /* sc=diak */,
  {   426,  4369,     0,  16,   0, UNI_SYRIACSUP }   /* syriacsupplement */,
  {     1,  6231,  1902,   4,  20, UNI_INDICNUMBERFORMS }   /* incommonindicnumberforms */,
  {     1, 10027,  9075,   3,   5, UNI_JG__ALAPH }   /* jg=alaph */,
  {     2,  4478,     0,   7,   0, UNI_BRAI }   /* braille */,
  {     1,  8589,  1654,   7,   6, UNI_SC__HANG }   /* script=hangul */,
  {    68,  9508,  8817,   5,   5, UNI_CCC__129 }   /* ccc=ccc129 */,
  {     0,  9015,     3,   5,   1, -UNI_IDEO }   /* ideo=f */,
  {     8,  1417,  9472,  24,   3, UNI_CCC__202 }   /* canonicalcombiningclass=atb */,
  {    24,   184,  4613,   2,  15, UNI_DIACRITICALSSUP }   /* isdiacriticalssup */,
  {     0,  9488,  4337,   4,  16, UNI_SUPMATHOPERATORS }   /* blk=supmathoperators */,
  {     7,  1594,     0,  14,   0, UNI_MUSIC }   /* musicalsymbols */,
  {    97,  4791,  2247,   4,  12, UNI_MEETEIMAYEKEXT }   /* inmeeteimayekext */,
  {     3,   184,  1344,   2,  25, UNI_SYMBOLSFORLEGACYCOMPUTING }   /* issymbolsforlegacycomputing */,
  {    51,  9488,   446,   4,  18, UNI_IDEOGRAPHICSYMBOLS }   /* blk=ideographicsymbols */,
  {    10,  9488,  5284,   4,  14, UNI_LISUSUP }   /* blk=lisusupplement */,
  {     0,  9620,     0,   4,   0, UNI_LANA }   /* lana */,
  {     0,  9488,  1631,   4,  23, UNI_GEOMETRICSHAPESEXT }   /* blk=geometricshapesextended */,
  {     0,  6231,  1442,   3,   9, UNI_CJKSYMBOLS }   /* incjksymbols */,
  {     0, 10132,   727,   3,   2, UNI_WB__MN }   /* wb=mn */,
  {    68,  1166, 10135,  26,   3, UNI_DI }   /* defaultignorablecodepoint=yes */,
  {     0,  1188,  8639,   3,   6, UNI_INTAGALOG }   /* intagalog */,
  {   320,  9488,  6796,   4,  11, UNI_INMEDEFAIDRIN }   /* blk=medefaidrin */,
  {   402,  3836,  8491,  17,   4, UNI_MARC }   /* scriptextensions=marc */,
  {     4,  9488,  5752,   4,   8, UNI_GREEKEXT }   /* blk=greekext */,
  {     1,  7088,  4465,  12,  13, UNI_BC__BN }   /* bidiclass=boundaryneutral */,
  {    91,  8688,   863,   4,   4, UNI_ARROWS }   /* isarrows */,
  {     0,   184,   867,   2,  18, UNI_PHONETICEXT }   /* isphoneticextensions */,
  {     0,  8107,     0,   4,   0, UNI_BALI }   /* bali */,
  {     1, 10333,  4370,   3,   8, UNI_SYRIACSUP }   /* issyriacsup */,
  {     0,  8337,     0,   7,   0, UNI_AVST }   /* avestan */,
  {     8,   184,    43,   3,   2, UNI_CJK }   /* iscjk */,
  {     0,  9488,  8470,   4,   7, UNI_INLINEARA }   /* blk=lineara */,
  {     0,  9768,  4145,   4,   7, UNI_LINB }   /* scx=linearb */,
  {   496,  7325,  7979,   3,   3, UNI_IN__6 }   /* in=6.0 */,
  {     0,  2218,  7623,   4,   7, UNI_INNABATAEAN }   /* innabataean */,
  {    22,  9748,     0,   4,   0, UNI_RJNG }   /* rjng */,
  {     0,  3836,  9736,  17,   4, UNI_COPT }   /* scriptextensions=qaac */,
  {    97,  2784,  4435,   4,  13, UNI_ARABICEXTA }   /* inarabicextendeda */,
  {    38,  9444,  9967,   4,   3, UNI_AGE__5_DOT_1 }   /* age=5.1 */,
  {   121,  3836,  8876,  17,   4, UNI_GOTH }   /* scriptextensions=goth */,
  {     5, 10033,    83,   3,   2, UNI_LB__CM }   /* lb=cm */,
  {     4,  9997,   102,   3,   2, UNI_BC__ET }   /* bc=et */,
  {     0,  5452, 10135,  14,   3, UNI_NFCQC__Y }   /* nfcquickcheck=yes */,
  {    12,  9488,  3025,   4,   8, UNI_INCHEROKEE }   /* blk=cherokee */,
  {    72,  9524, 10135,   4,   3, UNI_CWT }   /* cwt=yes */,
  {    22,  9277,  2485,   3,   4, UNI_SC__MONG }   /* sc=mong */,
  {   136,  8267,     1,   8,   1, -UNI_RADICAL }   /* radical=n */,
  {    68,  8219,     0,   8,   0, UNI_JAVA }   /* javanese */,
  {     1,    21,  9066,   3,   4, UNI_INADLAM }   /* inadlam */,
  {   385,  1966,  1608,  22,  23, UNI_INSC__CONSONANTPRECEDINGREPHA }   /* indicsyllabiccategory=consonantprecedingrepha */,
  {     0,  6576,     3,  11,   1, -UNI_XPOSIXALPHA }   /* alphabetic=f */,
  {     8,  5986,  7978,  13,   2, UNI_NV__16 }   /* numericvalue=16 */,
  {    41,  1552,   598,   9,   2, UNI_XPOSIXCNTRL }   /* category=cc */,
  {     8,  6241,     0,  12,   1, UNI_JT__U }   /* joiningtype=u */,
  {     2, 10024,  6598,   3,  11, UNI_CASEDLETTER }   /* gc=casedletter */,
  {     0,  9250,     1,   5,   1, -UNI_EMOD }   /* emod=n */,
  {     1,  6121,     0,  12,   0, UNI_CYRILLICEXTC }   /* cyrillicextc */,
  {     0,  6554,     0,  10,   0, UNI_IDC }   /* idcontinue */,
  {     0,  2760,  6741,  19,  11, UNI_GCB__L }   /* hangulsyllabletype=leadingjamo */,
  {     2,  5986,  9988,  13,   3, UNI_NV__7_SLASH_8 }   /* numericvalue=7/8 */,
  {    38,  5578,  1194,  14,   2, UNI_LB__LF }   /* sentencebreak=lf */,
  {     7, 10132,  3385,   3,  17, UNI_RI }   /* wb=regionalindicator */,
  {     2,  8589,  8428,   7,   4, UNI_SC__GRAN }   /* script=gran */,
  {     1,  4838,  9295,  15,   5, UNI_NFCQC__M }   /* nfkcquickcheck=maybe */,
  {     0,  9768,  9310,   4,   5, UNI_OGAM }   /* scx=ogham */,
  {     1,  3424,     1,   3,  33, UNI_UCAS }   /* inunifiedcanadianaboriginalsyllabics */,
  {    12,    21,  5804,   2,  13, UNI_KANAEXTA }   /* inkanaextendeda */,
  {     1,  1044,     0,   6,   0, UNI_L }   /* letter */,
  {   106,  9508,  9943,   4,   3, UNI_CCC__AR }   /* ccc=232 */,
  {     0,  7738,     3,   9,   1, -UNI_XIDS }   /* xidstart=f */,
  {     0,   184,  8491,   2,   7, UNI_MARC }   /* ismarchen */,
  {    32,  8589,  3751,   7,  17, UNI_KITS }   /* script=khitansmallscript */,
  {     0,  2280,  4899,   3,  14, UNI_PS }   /* isopenpunctuation */,
  {     1,  8780,  3241,   6,  11, UNI_GEORGIANSUP }   /* block=georgiansup */,
  {     1,  5791,  2203,  13,  21, UNI_JG__HANIFIROHINGYAKINNAYA }   /* joininggroup=hanifirohingyakinnaya */,
  {    92,  1966,  5144,  22,  14, UNI_INSC__GEMINATIONMARK }   /* indicsyllabiccategory=geminationmark */,
  {     0,  9768,  9085,   4,   5, UNI_BATK }   /* scx=batak */,
  {     1,  9768,  9652,   4,   4, UNI_MERC }   /* scx=merc */,
  {     0,    96,     0,   5,   0, UNI_XPOSIXALPHA }   /* alpha */,
  {    12,  8589,  9632,   7,   4, UNI_SC__LINA }   /* script=lina */,
  {     4,  8498,     0,   7,   0, UNI_MULT }   /* multani */,
  {    17,  1966,  9026,  22,   6, UNI_INSC__VIRAMA }   /* indicsyllabiccategory=virama */,
  {     0,  7438,  2444,  10,   2, UNI_LB__HL }   /* wordbreak=hl */,
  {   258,  7318,  9844,  10,   4, UNI_IN__11 }   /* presentin=v110 */,
  {     0,  9768,  9440,   4,   4, UNI_ADLM }   /* scx=adlm */,
  {     0,  8589,  7118,   7,  10, UNI_CHRS }   /* script=chorasmian */,
  {    36,  5508,  9836,  14,   4, UNI_PATSYN }   /* patternsyntax=true */,
  {     2,  3836,  9656,  17,   4, UNI_MIAO }   /* scriptextensions=miao */,
  {    25,  3097,  8195,  18,   8, UNI_DT__ISO }   /* decompositiontype=isolated */,
  {    45,  5791,  5336,  13,   4, UNI_JG__BETH }   /* joininggroup=beth */,
  {     3, 10048, 10150,   3,   2, UNI_NV__48 }   /* nv=48 */,
  {     4,  4853,  1025,  15,   2, UNI_NFKDQC__N }   /* nfkdquickcheck=no */,
  {     1, 10048,  8756,   3,   6, UNI_NV__900000 }   /* nv=900000 */,
  {     7,  9346,    36,   4,   1, UNI_IDC }   /* idc=t */,
  {     1, 10024,  5438,   3,  14, UNI_SK }   /* gc=modifiersymbol */,
  {     0,  9444,  7923,   4,   3, UNI_AGE__4 }   /* age=4.0 */,
  {     1,  9488,  4369,   4,   6, UNI_INSYRIAC }   /* blk=syriac */,
  {    69,  4916,  9004,   4,   4, UNI_TELU }   /* istelugu */,
  {     8,   184,  1287,   2,   2, UNI_UPPERCASELETTER }   /* islu */,
  {     0,  8589,  2203,   7,   4, UNI_SC__HAN }   /* script=hani */,
  {     1,  6928,    36,  11,   1, UNI_SD }   /* softdotted=t */,
  {    14,  9508,  9472,   4,   3, UNI_CCC__202 }   /* ccc=atb */,
  {     3,  3836,  9816,  17,   4, UNI_TAVT }   /* scriptextensions=tavt */,
  {     0,  9277,  9620,   3,   4, UNI_LANA }   /* sc=lana */,
  {     0,  7739,     1,   8,   1, -UNI_IDS }   /* idstart=n */,
  {     5,  7218,  8449,  10,   2, UNI_LB__HY }   /* linebreak=hy */,
  {    49,  8780,  3331,   6,  18, UNI_ORNAMENTALDINGBATS }   /* block=ornamentaldingbats */,
  {     0,  8780,  8091,   6,   8, UNI_INARMENIAN }   /* block=armenian */,
  {    41,  9488,  4049,   4,  11, UNI_GEORGIANEXT }   /* blk=georgianext */,
  {     0,  9351,     1,   4,   1, -UNI_IDS }   /* ids=n */,
  {    49,  9444, 10078,   4,   3, UNI_AGE__2_DOT_1 }   /* age=v21 */,
  {   134, 10009,  1309,   3,   3, UNI_DT__SUB }   /* dt=sub */,
  {   296,  9277,  9464,   3,   4, UNI_ARMN }   /* sc=armn */,
  {     6,  8780,  7168,   6,  10, UNI_INDIVESAKURU }   /* block=divesakuru */,
  {     0,  8694,     3,   7,   1, -UNI_XPOSIXSPACE }   /* wspace=f */,
  {   100, 10132,  7729,   3,   9, UNI_WB__WSEGSPACE }   /* wb=wsegspace */,
  {     1,  5791,  5480,  13,  14, UNI_JG__NOJOININGGROUP }   /* joininggroup=nojoininggroup */,
  {   257,  3259,  9836,  18,   4, UNI_IDSB }   /* idsbinaryoperator=true */,
  {   590,  5986,  9961,  13,   3, UNI_NV__3_SLASH_5 }   /* numericvalue=3/5 */,
  {     2,  7218,  5536,  10,  14, UNI_LB__PO }   /* linebreak=postfixnumeric */,
  {    39,  7428,     0,   4,   0, UNI_WARA }   /* wara */,
  {     0,  6231,  8387,   3,   6, UNI_CJKEXTF }   /* incjkextf */,
  {     0,   184,  8123,   2,   8, UNI_BUGI }   /* isbuginese */,
  {     0,  8509,   811,   4,  20, UNI_ENCLOSEDIDEOGRAPHICSUP }   /* inenclosedideographicsup */,
  {     1,  5986,  7922,  13,   2, UNI_NV__24 }   /* numericvalue=24 */,
  {     0,  9277,  7630,   3,   9, UNI_TALU }   /* sc=newtailue */,
  {    32,  8780,  2741,   6,  19, UNI_JAMOEXTB }   /* block=hanguljamoextendedb */,
  {     2, 10346,  1182,   5,   4, UNI_ANY }   /* isunicode */,
  {   128,  5060,    36,  14,   1, UNI_CI }   /* caseignorable=t */,
  {     0,  9508,  9151,   5,   4, UNI_CCC__24 }   /* ccc=ccc24 */,
  {     0,  9071,    36,   4,   1, UNI_XPOSIXXDIGIT }   /* hex=t */,
  {     0,  6231,   540,   3,  29, UNI_CJKEXTB }   /* incjkunifiedideographsextensionb */,
  {   107, 10296,     0,   3,   0, UNI_P }   /* isp */,
  {     0,  8115,     0,   8,   0, UNI_BASS }   /* bassavah */,
  {    16,  7540,     0,   9,   0, UNI_ext_values_index }   /* extender= */,
  {   128,   184,  9484,   2,   4, UNI_BHKS }   /* isbhks */,
  {    21,  8864,    26,   6,   1, UNI_EMOJI }   /* emoji=y */,
  {     0,  5986,  5648,  13,  11, UNI_NV__10000000000 }   /* numericvalue=10000000000 */,
  {     0,  4340,     0,  13,   0, UNI_MATHOPERATORS }   /* mathoperators */,
  {     0,  9768,  7359,   5,   9, UNI_SAUR }   /* scx=saurashtra */,
  {     6, 10132,  7612,   3,   9, UNI_WB__MB }   /* wb=midnumlet */,
  {    66,  1066,     0,   2,   0, UNI_CASEDLETTER }   /* lc */,
  {     0, 10027,  7112,   3,   3, UNI_JG__KAF }   /* jg=kaf */,
  {     0,  8876,     0,   4,   0, UNI_GOTH }   /* goth */,
  {     6,  6231,  2141,   3,   7, UNI_INCYRILLIC }   /* incyrillic */,
  {     0,  8589,  1165,   9,   2, UNI_SC__SHRD }   /* script=shrd */,
  {    40,  1552, 10180,   9,   2, UNI_ZS }   /* category=zs */,
  {     0,  4033,  5713,  16,  13, UNI_XPOSIXDIGIT }   /* generalcategory=decimalnumber */,
  {   577,  9015,  9255,   5,   5, -UNI_IDEO }   /* ideo=false */,
  {     0,  8780,  9688,   6,   3, UNI_INNKO }   /* block=nko */,
  {   132,  9277,  8414,   3,   7, UNI_ELBA }   /* sc=elbasan */,
  {     0, 10048,  8720,   3,   3, UNI_NV__400 }   /* nv=400 */,
  {     2,  1828,    26,   6,   1, UNI_CASED }   /* cased=y */,
  {     0,   184,  8912,   2,   4, UNI_KHOJ }   /* iskhoj */,
  {    32,  9768,  6181,   4,  12, UNI_GONG }   /* scx=gunjalagondi */,
  {    21,   184,  6517,   2,  12, UNI_PLAYINGCARDS }   /* isplayingcards */,
  {     0,  3097,  2280,  18,   3, UNI_DT__ISO }   /* decompositiontype=iso */,
  {     0,  4033,  6598,  16,  11, UNI_CASEDLETTER }   /* generalcategory=casedletter */,
  {    10,  8780,  4868,   6,  15, UNI_NARB }   /* block=oldnortharabian */,
  {     0,   184,  3133,   2,  13, UNI_EMOD }   /* isemojimodifier */,
  {    68, 10048,  8720,   3,   5, UNI_NV__40000 }   /* nv=40000 */,
  {     4, 10048,  7819,   3,   8, UNI_NV__3_SLASH_16 }   /* nv=1.88e-01 */,
  {     2,  9488,  6620,   4,  11, UNI_DOMINO }   /* blk=dominotiles */,
  {   428,  9345,     1,   5,   1, -UNI_XIDC }   /* xidc=n */,
  {     0,  3836,  2855,  17,   9, UNI_MONG }   /* scriptextensions=mongolian */,
  {     5, 10333,  8277,   4,   6, UNI_SPECIALS }   /* isspecials */,
  {    32, 10048,  7867,   3,   8, UNI_NV__1_SLASH_32 }   /* nv=3.12e-02 */,
  {     0,  7088,    32,  10,   2, UNI_BC__CS }   /* bidiclass=cs */,
  {     1,  9488,  7458,   4,  10, UNI_YIRADICALS }   /* blk=yiradicals */,
  {     0,  4838,     0,  15,   0, UNI_nfkcqc_values_index }   /* nfkcquickcheck= */,
  {     1,  8589,  8115,   7,   8, UNI_BASS }   /* script=bassavah */,
  {    71,  7438,  4305,  10,   5, UNI_WB__XX }   /* wordbreak=other */,
  {     1,  9277,  8498,   3,   4, UNI_SC__MULT }   /* sc=mult */,
  {     3,  5817,     0,  13,   0, UNI_ZL }   /* lineseparator */,
  {     5,  9277,  9832,   3,   4, UNI_TIBT }   /* sc=tibt */,
  {     1, 10033, 10156,   3,   2, UNI_LB__BK }   /* lb=bk */,
  {     0, 10030,  6664,   3,  11, UNI_JT__D }   /* jt=dualjoining */,
  {    17,   184,  8344,   2,   7, UNI_BENG }   /* isbengali */,
  {   108,  6231,   115,   4,  33, UNI_DIACRITICALSFORSYMBOLS }   /* incombiningdiacriticalmarksforsymbols */,
  {     0,  9277,  8666,   3,   4, UNI_SC__TIRH }   /* sc=tirh */,
  {    39,   184,  6110,   3,  11, UNI_CYRILLICEXTB }   /* iscyrillicextb */,
  {     1,  6972,     0,   4,   0, UNI_SYLO }   /* sylo */,
  {    60,    84,     0,   4,   0, UNI_MATH }   /* math */,
  {     3,  1552,  3985,   9,  16, UNI_PE }   /* category=closepunctuation */,
  {     0,  9768,  9032,   4,   6, UNI_WCHO }   /* scx=wancho */,
  {     5,  7325,  9979,   3,   3, UNI_IN__6_DOT_1 }   /* in=6.1 */,
  {     0,  1269,  9836,  25,   4, UNI_COMPEX }   /* fullcompositionexclusion=true */,
  {     0,  6231,  4002,   3,  15, UNI_CYPRIOTSYLLABARY }   /* incypriotsyllabary */,
  {    16,  7438,    34,  10,   6, UNI_WB__EXTEND }   /* wordbreak=extend */,
  {     0,  9275,  2389,   5,  20, UNI_INSC__CONSONANTWITHSTACKER }   /* insc=consonantwithstacker */,
  {    20,  9277,  9664,   3,   4, UNI_MRO }   /* sc=mroo */,
  {     0,  1417,  6445,  24,  12, UNI_CCC__0 }   /* canonicalcombiningclass=notreordered */,
  {   100,  9277,  9564,   3,   4, UNI_SC__GONM }   /* sc=gonm */,
  {     0,  9444,  7867,   4,   3, UNI_AGE__3_DOT_1 }   /* age=3.1 */,
  {     0,  4145,     0,  16,   0, UNI_LINEARBIDEOGRAMS }   /* linearbideograms */,
  {     1,  7076,  3938,   3,  15, UNI_BOPOMOFOEXT }   /* inbopomofoextended */,
  {     1,  8780,  7428,   6,  10, UNI_INWARANGCITI }   /* block=warangciti */,
  {     1,  5564,     0,  14,   0, UNI_qmark_values_index }   /* quotationmark= */,
  {    27,  9444,  7469,   4,   3, UNI_AGE__5 }   /* age=5.0 */,
  {     0,  9488,  8203,   4,   8, UNI_JAMOEXTA }   /* blk=jamoexta */,
  {    16,  8780,  1654,   6,   6, UNI_INHANGUL }   /* block=hangul */,
  {     1,  8884, 10135,   4,   3, UNI_EXT }   /* ext=yes */,
  {     0,  9002,     0,   4,   0, UNI_TELU }   /* telu */,
  {     1, 10003, 10135,   3,   3, UNI_CI }   /* ci=yes */,
  {     3,  9768,  4149,   5,   3, UNI_SARB }   /* scx=sarb */,
  {     1,  5986,  7963,  13,   8, UNI_NV__11_SLASH_2 }   /* numericvalue=5.50e+00 */,
  {   549,  6231,  7140,   4,   8, UNI_COMPATJAMO }   /* incompatjamo */,
  {     0,  8780,  3241,   6,  18, UNI_GEORGIANSUP }   /* block=georgiansupplement */,
  {     3,  4643,    36,  15,   1, UNI_ECOMP }   /* emojicomponent=t */,
  {     0,  1269,  9255,  25,   5, -UNI_COMPEX }   /* fullcompositionexclusion=false */,
  {     4,  1552,   467,   9,  11, UNI_P }   /* category=punctuation */,
  {     3,  6241,    36,  12,   1, UNI_JT__T }   /* joiningtype=t */,
  {     3,    21,  8463,   2,   7, UNI_KALI }   /* inkayahli */,
  {   334,  9508,  2449,   4,   4, UNI_CCC__L }   /* ccc=left */,
  {    41, 10033,  8251,   3,   8, UNI_LB__NL }   /* lb=nextline */,
  {     6,  9335,     0,   5,   0, UNI_TAKR }   /* takri */,
  {     2,  9488,   861,   4,   6, UNI_ARROWS }   /* blk=arrows */,
  {     0,  9350,  9836,   5,   4, UNI_XIDS }   /* xids=true */,
  {     7,  5986,  7933,  13,   2, UNI_NV__17 }   /* numericvalue=17 */,
  {     0,   184,  8107,   2,   4, UNI_BALI }   /* isbali */,
  {     0,  8780,  8617,   6,   7, UNI_INSOYOMBO }   /* block=soyombo */,
  {     0, 10048,  7955,   3,   8, UNI_NV__1_SLASH_20 }   /* nv=5.00e-02 */,
  {     4,  3836,  8187,  17,   8, UNI_HIRA }   /* scriptextensions=hiragana */,
  {   512,  3836,  8611,  18,   3, UNI_SIDD }   /* scriptextensions=sidd */,
  {     0,  9488,  8912,   4,   6, UNI_INKHOJKI }   /* blk=khojki */,
  {     3,  9444,     0,   4,   0, UNI_age_values_index }   /* age= */,
  {    67,  7666,     0,   9,   0, UNI_ORKH }   /* oldturkic */,
  {     1, 10333,  4370,   3,   5, UNI_SYRC }   /* issyriac */,
  {   399,   184,  8694,   2,   6, UNI_XPOSIXSPACE }   /* iswspace */,
  {    64,   184,  1594,   2,  14, UNI_MUSIC }   /* ismusicalsymbols */,
  {    16,  9488,  6505,   4,   8, UNI_PHAISTOS }   /* blk=phaistos */,
  {     4,  9277,  7513,   3,   9, UNI_BHKS }   /* sc=bhaiksuki */,
  {   164,  3836,  8337,  17,   7, UNI_AVST }   /* scriptextensions=avestan */,
  {     5,  8589,  7513,   7,   9, UNI_BHKS }   /* script=bhaiksuki */,
  {    18,  9508,    23,   4,   2, UNI_CCC__AL }   /* ccc=al */,
  {     0,  8780,  6409,   6,  12, UNI_INMENDEKIKAKUI }   /* block=mendekikakui */,
  {   104,  9768,  9752,   4,   4, UNI_ROHG }   /* scx=rohg */,
  {   234,  2010,     0,  22,   0, UNI_MISCTECHNICAL }   /* miscellaneoustechnical */,
  {     0,  3836,  2203,  17,   4, UNI_HAN }   /* scriptextensions=hani */,
  {     6, 10333,   107,   3,   5, UNI_S }   /* issymbol */,
  {     0,  6851,     0,  11,   0, UNI_LO }   /* otherletter */,
  {     1,  5791,  4203,  13,   3, UNI_JG__LAM }   /* joininggroup=lam */,
  {     0,  7438,  4360,  10,   9, UNI_WB__EB }   /* wordbreak=emodifier */,
  {   263, 10027,  2203,   3,  21, UNI_JG__HANIFIROHINGYAKINNAYA }   /* jg=hanifirohingyakinnaya */,
  {     0,  7218,  3985,  10,  16, UNI_LB__CL }   /* linebreak=closepunctuation */,
  {     0,  9277,  9872,   3,   4, UNI_XPEO }   /* sc=xpeo */,
  {   128, 10320,  3379,   7,   5, UNI_XPOSIXSPACE }   /* isxperlspace */,
  {   280,  9488,  1878,   4,  19, UNI_CJKCOMPATIDEOGRAPHS }   /* blk=cjkcompatideographs */,
  {     0,  8780,  2287,   6,   7, UNI_INSINHALA }   /* block=sinhala */,
  {     2, 10033,  8701,   3,   7, UNI_LB__ZW }   /* lb=zwspace */,
  {     7,  9488,  1594,   4,  14, UNI_MUSIC }   /* blk=musicalsymbols */,
  {    64, 10288,    96,   8,   5, UNI_XPOSIXALPHA }   /* isxposixalpha */,
  {     0,   184,  3169,   2,  18, UNI_ETHIOPICSUP }   /* isethiopicsupplement */,
  {     0,  8688,  7060,   4,   8, UNI_ARABICEXTA }   /* isarabicexta */,
  {    38, 10033,  6675,   3,  11, UNI_LB__EX }   /* lb=exclamation */,
  {    12,  6231,  8394,   3,   6, UNI_CJKEXTG }   /* incjkextg */,
  {     1,  9277,  9896,   3,   4, UNI_SC__ZYYY }   /* sc=zyyy */,
  {     0,  5986,  9372,  13,   4, UNI_NV__1_SLASH_40 }   /* numericvalue=1/40 */,
  {     2,    21,  9453,   3,   3, UNI_INAHOM }   /* inahom */,
  {   512,  9277,  9752,   3,   4, UNI_SC__ROHG }   /* sc=rohg */,
  {    11,  9444,  7931,   4,   3, UNI_AGE__4_DOT_1 }   /* age=4.1 */,
  {     0,  4838, 10135,  15,   3, UNI_NFKCQC__Y }   /* nfkcquickcheck=yes */,
  {     0,  8780,  3683,   6,  16, UNI_ETHIOPICEXT }   /* block=ethiopicextended */,
  {     7,  9508,  1219,   4,   3, UNI_CCC__214 }   /* ccc=ata */,
  {     0,  9277,  9460,   3,   4, UNI_ARMI }   /* sc=armi */,
  {   512,   184,  2666,   3,  18, UNI_COUNTINGROD }   /* iscountingrodnumerals */,
  {     3,  9277,  1900,   3,   6, UNI_SC__ZYYY }   /* sc=common */,
  {     0,  5986,  8043,  13,   8, UNI_NV__4_SLASH_5 }   /* numericvalue=8.00e-01 */,
  {     1,  7218,  6073,  10,  12, UNI_LB__SY }   /* linebreak=breaksymbols */,
  {     0,  3836,  2140,  17,   8, UNI_CYRL }   /* scriptextensions=cyrillic */,
  {     2,   867,     0,  28,   0, UNI_PHONETICEXTSUP }   /* phoneticextensionssupplement */,
  {     2,  8780,  1033,   6,  27, UNI_ENCLOSEDCJK }   /* block=enclosedcjklettersandmonths */,
  {     0,  8449,    26,   7,   1, UNI_HYPHEN }   /* hyphen=y */,
  {     4,  1166,     3,  26,   1, -UNI_DI }   /* defaultignorablecodepoint=f */,
  {     0,  1273,    26,  21,   1, UNI_CE }   /* compositionexclusion=y */,
  {   132, 10048,  7875,   3,   8, UNI_NV__1_SLASH_32 }   /* nv=3.13e-02 */,
  {    17,  8589,  9708,   7,   4, UNI_SC__ORYA }   /* script=orya */,
  {     0,  9997,  2268,   3,   3, UNI_BC__PDI }   /* bc=pdi */,
  {    44,  9265,    36,   5,   1, UNI_IDST }   /* idst=t */,
  {    35,  1552,  4958,   9,  15, UNI_UPPERCASELETTER }   /* category=uppercaseletter */,
  {     6,  9556,    73,   4,   2, UNI_WB__EB }   /* gcb=em */,
  {     0, 10048,  8011,   3,   8, UNI_NV__13_SLASH_2 }   /* nv=6.50e+00 */,
  {     1,  9250,  1025,   5,   2, -UNI_EMOD }   /* emod=no */,
  {     0,  5986,  7763,  13,   8, UNI_NV__1_SLASH_8 }   /* numericvalue=1.25e-01 */,
  {     0,  9020,    26,   6,   1, UNI_XPOSIXUPPER }   /* upper=y */,
  {     0,  9277,  6277,   3,   4, UNI_SC__MAHJ }   /* sc=mahj */,
  {     0,  5037,     3,   9,   1, -UNI_XPOSIXXDIGIT }   /* hexdigit=f */,
  {   135,  9277,  1677,   3,   5, UNI_SC__LATN }   /* sc=latin */,
  {    36, 10024,  1044,   3,   6, UNI_L }   /* gc=letter */,
  {    15,  4033,  1066,  16,   2, UNI_CASEDLETTER }   /* generalcategory=lc */,
  {     0, 10048,  8744,   3,   3, UNI_NV__700 }   /* nv=700 */,
  {     0,  9508,  9166,   5,   4, UNI_CCC__27 }   /* ccc=ccc27 */,
  {     3,   184,  6122,   3,  11, UNI_CYRILLICEXTC }   /* iscyrillicextc */,
  {    64,  9262,    34,   3,   2, UNI_SB__EX }   /* sb=ex */,
  {     0,   184,  9892,   2,   4, UNI_QAAI }   /* iszinh */,
  {     1, 10024,   262,   3,   2, UNI_SM }   /* gc=sm */,
  {   393,  9768,  7567,   4,   9, UNI_SIND }   /* scx=khudawadi */,
  {     0, 10129,     1,   3,   1, -UNI_VS }   /* vs=n */,
  {     2,  4369,     0,   9,   0, UNI_SYRIACSUP }   /* syriacsup */,
  {   177,    21,  2590,   3,  18, UNI_ANCIENTGREEKNUMBERS }   /* inancientgreeknumbers */,
  {     2,  3836,  4385,  17,   6, UNI_TANG }   /* scriptextensions=tangut */,
  {     5, 10048,  8714,   3,   5, UNI_NV__30000 }   /* nv=30000 */,
  {     2,  5986,  7747,  13,   8, UNI_NV__1_SLASH_10 }   /* numericvalue=1.00e-01 */,
  {     1,   184,  9672,   2,   4, UNI_MYMR }   /* ismymr */,
  {     1,  3836,  9065,  17,   5, UNI_ADLM }   /* scriptextensions=adlam */,
  {    17,  8997,  9837,   6,   3, UNI_TERM }   /* term=true */,
  {     0,  9556,  3385,   4,  17, UNI_RI }   /* gcb=regionalindicator */,
  {     1,  7318,  9985,  10,   3, UNI_IN__7 }   /* presentin=7.0 */,
  {     0, 10132,  6145,   3,  12, UNI_WB__EX }   /* wb=extendnumlet */,
  {     0, 10333,  7292,   3,   6, UNI_SOGD }   /* issogdian */,
  {     1,  7513,     0,   9,   0, UNI_BHKS }   /* bhaiksuki */,
  {     0,  1114,     0,  25,   0, UNI_CWKCF }   /* changeswhennfkccasefolded */,
  {     1,  3836,  7292,  18,   6, UNI_SOGD }   /* scriptextensions=sogdian */,
  {     6,  1966,  2608,  22,  19, UNI_INSC__BRAHMIJOININGNUMBER }   /* indicsyllabiccategory=brahmijoiningnumber */,
  {     3, 10033,   866,   3,   2, UNI_LB__SP }   /* lb=sp */,
  {    22,  9488,  5200,   4,   7, UNI_KANASUP }   /* blk=kanasup */,
  {     0,   184,  6253,   2,   5, UNI_KHMR }   /* iskhmer */,
  {     4,  9664,     0,   3,   0, UNI_MRO }   /* mro */,
  {     1,  1911,     0,  11,   0, UNI_NUMBERFORMS }   /* numberforms */,
  {     3,  9768,  9600,   4,   4, UNI_KALI }   /* scx=kali */,
  {     1, 10033,  4898,   3,  15, UNI_LB__OP }   /* lb=openpunctuation */,
  {     1,  4033,  4245,  16,  10, UNI_SM }   /* generalcategory=mathsymbol */,
  {     0,  8589,  7621,   7,   9, UNI_NBAT }   /* script=nabataean */,
  {     5,  9488,  3938,   5,   7, UNI_INBOPOMOFO }   /* blk=bopomofo */,
  {     0,  9488,  3115,   4,  18, UNI_DEVANAGARIEXT }   /* blk=devanagariextended */,
  {     5,   117,     6,   3,   2, UNI_INIDC }   /* inidc */,
  {     5,  9277,  3135,   5,   2, UNI_SC__KHOJ }   /* sc=khoj */,
  {   598,  1319,     0,  25,   0, UNI_SYMBOLSANDPICTOGRAPHSEXTA }   /* symbolsandpictographsexta */,
  {     0,  9768,  9580,   4,   4, UNI_HANO }   /* scx=hano */,
  {    79,  8780,  1594,   6,  14, UNI_MUSIC }   /* block=musicalsymbols */,
  {     0,  5791,  6157,  13,  12, UNI_JG__FINALSEMKATH }   /* joininggroup=finalsemkath */,
  {    64,  4033,  4898,  16,  15, UNI_PS }   /* generalcategory=openpunctuation */,
  {     1,  4989,  8674,   3,   6, UNI_UCASEXT }   /* isucasext */,
  {     0,   184,  3785,   2,  10, UNI_MANI }   /* ismanichaean */,
  {     0,   184,  1813,   3,  20, UNI_CWL }   /* ischangeswhenlowercased */,
  {     0,  9740,     0,   4,   0, UNI_QAAI }   /* qaai */,
  {     0,  5986,  8083,  13,   8, UNI_NV__11_SLASH_12 }   /* numericvalue=9.17e-01 */,
  {     0,  9488,  1631,   4,  18, UNI_GEOMETRICSHAPESEXT }   /* blk=geometricshapesext */,
  {     0,   184,  8463,   2,   7, UNI_KALI }   /* iskayahli */,
  {     4, 10027,  4081,   3,  16, UNI_JG__HANIFIROHINGYAPA }   /* jg=hanifirohingyapa */,
  {     0,  3836,  9512,  17,   4, UNI_CHRS }   /* scriptextensions=chrs */,
  {    19,  7318,  7826,  10,   2, UNI_IN__12 }   /* presentin=12 */,
  {    64,  9556,   262,   4,   2, UNI_GCB__SM }   /* gcb=sm */,
  {     3, 10132,  5851,   3,   2, UNI_WB__ML }   /* wb=ml */,
  {     1,  9488,  1586,   5,  13, UNI_BYZANTINEMUSIC }   /* blk=byzantinemusic */,
  {     3,  3133,     0,  18,   0, UNI_ebase_values_index }   /* emojimodifierbase= */,
  {   206, 10027,  9355,   3,   5, UNI_JG__ZHAIN }   /* jg=zhain */,
  {   204,  9277,  3937,   3,   4, UNI_SC__BOPO }   /* sc=bopo */,
  {     1, 10291,  9225,   5,   5, UNI_POSIXCNTRL }   /* posixcntrl */,
  {     3,    34,     0,   3,   0, UNI_EXT }   /* ext */,
  {    25,  7088,  2449,  10,  11, UNI_BC__L }   /* bidiclass=lefttoright */,
  {     2,  5986,  9958,  13,   3, UNI_NV__3_SLASH_4 }   /* numericvalue=3/4 */,
  {    66,  4973,     0,  15,   0, UNI_VEDICEXT }   /* vedicextensions */,
  {     1,  9444,  9401,   4,   3, UNI_AGE__3 }   /* age=3.0 */,
  {    41,  9014,     0,   6,   0, UNI_uideo_values_index }   /* uideo= */,
  {    26,  9768,  3079,   4,   4, UNI_COPT }   /* scx=copt */,
  {     0, 10024,  6873,   3,  11, UNI_SO }   /* gc=othersymbol */,
  {    14,  9277,  6484,   3,   4, UNI_HUNG }   /* sc=hung */,
  {     0,  1834,  9836,  22,   4, UNI_CWT }   /* changeswhentitlecased=true */,
  {     0,  6277,     0,   7,   0, UNI_MAHJONG }   /* mahjong */,
  {    41,  9015,  1025,   5,   2, -UNI_IDEO }   /* ideo=no */,
  {   208,  9488,  8219,   4,   8, UNI_INJAVANESE }   /* blk=javanese */,
  {     1,  9488,  1033,   4,  11, UNI_ENCLOSEDCJK }   /* blk=enclosedcjk */,
  {     5,  9277,  6193,   3,   4, UNI_HEBR }   /* sc=hebr */,
  {     0,  1217,     0,   2,   0, UNI_SK }   /* sk */,
  {     4, 10024,  7408,   3,  10, UNI_CN }   /* gc=unassigned */,
  {     0, 10030,  6753,   4,  10, UNI_JT__L }   /* jt=leftjoining */,
  {     0,  9277,  9032,   3,   6, UNI_WCHO }   /* sc=wancho */,
  {    16,  9444,  5648,   4,   2, UNI_AGE__10 }   /* age=10 */,
  {     0,  2280,  9705,   3,   3, UNI_ORKH }   /* isorkh */,
  {     0,  4658,    26,  15,   1, UNI_GREXT }   /* graphemeextend=y */,
  {     0,  9997,  3187,   3,  18, UNI_BC__ET }   /* bc=europeanterminator */,
  {   329,  7155,  2204,   3,  13, UNI_ROHG }   /* ishanifirohingya */,
  {     0,  9508,  8799,   5,   5, UNI_CCC__107 }   /* ccc=ccc107 */,
  {    74,  9508,  9216,   5,   4, UNI_CCC__84 }   /* ccc=ccc84 */,
  {     1,  8589,  8463,   7,   7, UNI_SC__KALI }   /* script=kayahli */,
  {     0, 10291,   467,   5,   5, UNI_POSIXPUNCT }   /* posixpunct */,
  {     0,  8780,  2855,   6,  19, UNI_MONGOLIANSUP }   /* block=mongoliansupplement */,
  {     0,  5986,  7930,  13,   2, UNI_NV__14 }   /* numericvalue=14 */,
  {     1,  8589,  3894,   8,  10, UNI_SGNW }   /* script=signwriting */,
  {    88, 10182, 10215,   6,  21, UNI__PERL_IS_IN_MULTI_CHAR_FOLD }   /* _perl_is_in_multi_char_fold */,
  {    14,  8589,  3115,   7,   4, UNI_SC__DEVA }   /* script=deva */,
  {     5,  7318,  5648,  10,   2, UNI_IN__10 }   /* presentin=10 */,
  {     9,  6229,  9836,  12,   4, UNI_JOINC }   /* joincontrol=true */,
  {     4,  9508,  8793,   5,   5, UNI_CCC__103 }   /* ccc=ccc103 */,
  {    10,  9488,  1944,   4,  22, UNI_EARLYDYNASTICCUNEIFORM }   /* blk=earlydynasticcuneiform */,
  {     1,  9508,  9949,   4,   3, UNI_CCC__DA }   /* ccc=234 */,
  {   224,  3836,  9620,  17,   4, UNI_LANA }   /* scriptextensions=lana */,
  {   292,  9488,  4433,   4,  15, UNI_ARABICEXTA }   /* blk=arabicextendeda */,
  {     0,  2224,  8625,   3,   6, UNI_SUPPUAA }   /* insuppuaa */,
  {     1,   184,  8387,   3,   6, UNI_CJKEXTF }   /* iscjkextf */,
  {     1,  3424,  1129,   3,   3, UNI_UCAS }   /* inucas */,
  {   516,  5508, 10135,  14,   3, UNI_PATSYN }   /* patternsyntax=yes */,
  {     5,  8688,    27,   3,   2, UNI_ALL }   /* isall */,
  {     0,   184,  8876,   2,   6, UNI_GOTH }   /* isgothic */,
  {     0,  5739,    36,  13,   1, UNI_GRBASE }   /* graphemebase=t */,
  {     2,  9556,  4305,   4,   5, UNI_GCB__XX }   /* gcb=other */,
  {    21,    21,  1677,   2,  23, UNI_LATINEXTADDITIONAL }   /* inlatinextendedadditional */,
  {     0,   184,   400,   2,   6, UNI_CF }   /* isformat */,
  {   261,  7739,     0,   8,   0, UNI_ids_values_index }   /* idstart= */,
  {     0,    21,  8906,   2,   6, UNI_KANBUN }   /* inkanbun */,
  {    37,    21,  5214,   2,  14, UNI_KANGXI }   /* inkangxiradicals */,
  {   334,  9235,    26,   5,   1, UNI_CWCM }   /* cwcm=y */,
  {    37,  8780,  6253,   6,  12, UNI_KHMERSYMBOLS }   /* block=khmersymbols */,
  {     0, 10048,  7883,   3,   8, UNI_NV__1_SLASH_320 }   /* nv=3.13e-03 */,
  {    36,  4033, 10170,  16,   2, UNI_CASEDLETTER }   /* generalcategory=l_ */,
  {     0,   184,  4369,   2,  16, UNI_SYRIACSUP }   /* issyriacsupplement */,
  {     5,  8688,  7506,   4,   7, UNI_ARABICPFB }   /* isarabicpfb */,
  {     0,  7739,     0,   7,   0, UNI_IDS }   /* idstart */,
  {     1,   184,  6939,   2,  11, UNI_SORA }   /* issorasompeng */,
  {     0,  7088,  2449,  10,  20, UNI_BC__LRE }   /* bidiclass=lefttorightembedding */,
  {     0,  1966,  2646,  22,  19, UNI_INSC__CONSONANTHEADLETTER }   /* indicsyllabiccategory=consonantheadletter */,
  {   135,  7218,  1822,  10,   2, UNI_LB__NL }   /* linebreak=nl */,
  {     1,  9768,  2409,   4,  10, UNI_GLAG }   /* scx=glagolitic */,
  {     0,  8589,  4883,   7,  15, UNI_SARB }   /* script=oldsoutharabian */,
  {   207,  3133,     0,   5,   0, UNI_EMOJI }   /* emoji */,
  {     5,  9444,  7754,   4,   2, UNI_AGE__11 }   /* age=11 */,
  {     0,  4033,  4583,  16,  15, UNI_PD }   /* generalcategory=dashpunctuation */,
  {    32,  5522,     0,  14,   0, UNI_PHONETICEXTSUP }   /* phoneticextsup */,
  {   128,  9508,  1755,   4,   2, UNI_CCC__DB }   /* ccc=db */,
  {     0,  9488,  6840,   4,  11, UNI_INNANDINAGARI }   /* blk=nandinagari */,
  {   392,  1537,  3481,  24,  12, UNI_INPC__LEFTANDRIGHT }   /* indicpositionalcategory=leftandright */,
  {     0,  8997,    26,   5,   1, UNI_TERM }   /* term=y */,
  {     1,  9277,  9748,   3,   4, UNI_RJNG }   /* sc=rjng */,
  {     0,  1790,     3,  22,   1, -UNI_CWCM }   /* changeswhencasemapped=f */,
  {     0,   184,  6133,   2,  12, UNI_ETHIOPICEXTA }   /* isethiopicexta */,
  {    26,  3241,     0,  18,   0, UNI_GEORGIANSUP }   /* georgiansupplement */,
  {     0,  2280,  7659,   4,   7, UNI_PERM }   /* isoldpermic */,
  {     8,  5986,  7782,  13,   1, UNI_NV__3 }   /* numericvalue=3 */,
  {     9,  9488,  9330,   4,   5, UNI_INTAILE }   /* blk=taile */,
  {    33,  6229,     3,  12,   1, -UNI_JOINC }   /* joincontrol=f */,
  {   128,   184,  1879,   3,  18, UNI_CJKCOMPATIDEOGRAPHS }   /* iscjkcompatideographs */,
  {     3, 10030,  6708,   3,  11, UNI_JT__C }   /* jt=joincausing */,
  {   141,  6231,   570,   3,  29, UNI_CJKEXTC }   /* incjkunifiedideographsextensionc */,
  {    32,  9277,  3025,   3,   8, UNI_CHER }   /* sc=cherokee */,
  {     0,  3836,  8344,  17,   4, UNI_BENG }   /* scriptextensions=beng */,
  {     2,  3151,  9836,  18,   4, UNI_EPRES }   /* emojipresentation=true */,
  {     0,  9262,   751,   3,   2, UNI_SB__CL }   /* sb=cl */,
  {    37,  6231,  8373,   3,   6, UNI_CJKEXTD }   /* incjkextd */,
  {     4,  3836,  9793,  18,   3, UNI_SOGO }   /* scriptextensions=sogo */,
  {     1,  3836,  8456,  17,   7, UNI_KNDA }   /* scriptextensions=kannada */,
  {     4,  9488,  4385,   4,   6, UNI_INTANGUT }   /* blk=tangut */,
  {    17,  8428,     0,   7,   0, UNI_GRAN }   /* grantha */,
  {    48, 10006,     3,   3,   1, -UNI_DI }   /* di=f */,
  {    32,  1552,  1529,  11,   7, UNI__PERL_SURROGATE }   /* category=surrogate */,
  {    18, 10313,  3379,   7,   5, UNI_XPOSIXBLANK }   /* ishorizspace */,
  {     0,  8589,  3025,   7,   4, UNI_CHER }   /* script=cher */,
  {   193,  9270,  6983,   5,  11, UNI_INPC__TOPANDRIGHT }   /* inpc=topandright */,
  {     0,  2779, 10135,  19,   3, UNI_IDST }   /* idstrinaryoperator=yes */,
  {     0, 10027,  5424,   3,  14, UNI_JG__MANICHAEANYODH }   /* jg=manichaeanyodh */,
  {     1, 10296,   468,   3,   4, UNI_P }   /* ispunct */,
  {     0,  9508,  9161,   5,   4, UNI_CCC__26 }   /* ccc=ccc26 */,
  {   290,  5986,  8744,  13,   2, UNI_NV__70 }   /* numericvalue=70 */,
  {     1,  7218,  4898,  10,  15, UNI_LB__OP }   /* linebreak=openpunctuation */,
  {     0,  7088,  3205,  10,  18, UNI_BC__FSI }   /* bidiclass=firststrongisolate */,
  {     3,  6025,     0,  12,   0, UNI_ALPHABETICPF }   /* alphabeticpf */,
  {     0,  9768,  9065,   4,   5, UNI_ADLM }   /* scx=adlam */,
  {   257,  8519,     0,   9,   0, UNI_NFKDQC__N }   /* nfkdqc=no */,
  {     4,  9488,  3785,   4,  10, UNI_INMANICHAEAN }   /* blk=manichaean */,
  {     0,   117,   447,   3,  17, UNI_IDEOGRAPHICSYMBOLS }   /* inideographicsymbols */,
  {    10,  8780,   867,   6,  28, UNI_PHONETICEXTSUP }   /* block=phoneticextensionssupplement */,
  {    33,  8589,  9008,   7,   6, UNI_SC__THAA }   /* script=thaana */,
  {     1,  2314,     0,   3,   0, UNI_XPOSIXXDIGIT }   /* hex */,
  {     1,  9508,  7754,   4,   2, UNI_CCC__11 }   /* ccc=11 */,
  {    34,  5791,  5908,  13,  13, UNI_JG__MANICHAEANTAW }   /* joininggroup=manichaeantaw */,
  {     0,  3836,  8123,  17,   4, UNI_BUGI }   /* scriptextensions=bugi */,
  {   118, 10048,  7891,   3,   8, UNI_NV__1_SLASH_3 }   /* nv=3.33e-01 */,
  {     0,  8575,  1025,   7,   2, -UNI_PATSYN }   /* patsyn=no */,
  {     0,   184,  1087,   2,  26, UNI_PCM }   /* isprependedconcatenationmark */,
  {     0,  9015, 10135,   5,   3, UNI_IDEO }   /* ideo=yes */,
  {    75, 10296,   468,   3,  10, UNI_P }   /* ispunctuation */,
  {   108,  5986,  8756,  13,   5, UNI_NV__90000 }   /* numericvalue=90000 */,
  {    32,  8589,  8652,   7,   7, UNI_TAVT }   /* script=taiviet */,
  {     4,  2224,  1320,   3,  24, UNI_SYMBOLSANDPICTOGRAPHSEXTA }   /* insymbolsandpictographsexta */,
  {    90,  8435,  9255,   7,   5, -UNI_GRBASE }   /* grbase=false */,
  {    30,  1552,  3277,   9,  18, UNI_PI }   /* category=initialpunctuation */,
  {     0,  8344,     0,   4,   0, UNI_BENG }   /* beng */,
  {     1,  3169,     0,   8,   0, UNI_ETHI }   /* ethiopic */,
  {     1,  1417,  8714,  24,   2, UNI_CCC__30 }   /* canonicalcombiningclass=30 */,
  {     0,  9508,    16,   4,   1, UNI_CCC__B }   /* ccc=b */,
  {   593,  9488,  9325,   4,   5, UNI_INRUNIC }   /* blk=runic */,
  {     1,  7218,  5298,  10,  14, UNI_LB__BK }   /* linebreak=mandatorybreak */,
  {    96,  3439,     0,  12,   0, UNI_SMALLKANAEXT }   /* smallkanaext */,
  {   321,  3836,  9002,  17,   6, UNI_TELU }   /* scriptextensions=telugu */,
  {     2,  9768,  9504,   4,   4, UNI_CANS }   /* scx=cans */,
  {   338,  8688,  9453,   3,   3, UNI_AHOM }   /* isahom */,
  {     0,  7318,  7826,  10,   4, UNI_IN__12 }   /* presentin=12.0 */,
  {   518,  8688,   980,   3,  26, UNI_ALPHABETICPF }   /* isalphabeticpresentationforms */,
  {     0,  2409,     0,  10,   0, UNI_GLAG }   /* glagolitic */,
  {     1,  9508,  8813,   4,   3, UNI_CCC__122 }   /* ccc=122 */,
  {   185,  1417,  1219,  24,   3, UNI_CCC__214 }   /* canonicalcombiningclass=ata */,
  {    47,  9444,  9970,   4,   3, UNI_AGE__5_DOT_2 }   /* age=5.2 */,
  {    70,  9260,  9836,   5,   4, UNI_IDSB }   /* idsb=true */,
  {   416,  2224,  2913,   3,  18, UNI_SUNDANESESUP }   /* insundanesesupplement */,
  {     0, 10048,  5648,   3,   5, UNI_NV__10000 }   /* nv=10000 */,
  {     0, 10027,  5869,   3,  13, UNI_JG__MANICHAEANMEM }   /* jg=manichaeanmem */,
  {    72, 10132,  5585,   3,   2, UNI_WB__EB }   /* wb=eb */,
  {     1,  6241,  6752,  12,  11, UNI_JT__L }   /* joiningtype=leftjoining */,
  {   129,  7318,  7877,  10,   2, UNI_IN__13 }   /* presentin=13 */,
  {     0,  8575,    26,   7,   1, UNI_PATSYN }   /* patsyn=y */,
  {    68,  9270,  4988,   5,  15, UNI_LOE }   /* inpc=visualorderleft */,
  {     8,  5674,  9836,  13,   4, UNI_BIDIM }   /* bidimirrored=true */,
  {     1,  5746,     0,   5,   0, UNI_EBASE }   /* ebase */,
  {     7, 10027,  9280,   3,   5, UNI_JG__KHAPH }   /* jg=khaph */,
  {     0,  9277,  8924,   3,   4, UNI_LEPC }   /* sc=lepc */,
  {     0,  9277,  9676,   3,   4, UNI_NARB }   /* sc=narb */,
  {     0,    21,  5284,   2,  14, UNI_LISUSUP }   /* inlisusupplement */,
  {     2, 10024,  3349,   3,  18, UNI_ZP }   /* gc=paragraphseparator */,
  {    84, 10126,  3493,   3,  18, UNI_VO__TR }   /* vo=transformedrotated */,
  {     0,  9277,  9660,   3,   4, UNI_SC__MLYM }   /* sc=mlym */,
  {   192,  9768,  3895,   5,   3, UNI_SGNW }   /* scx=sgnw */,
  {    25,  6229,     0,  12,   0, UNI_joinc_values_index }   /* joincontrol= */,
  {     0,   184,  1769,   3,  20, UNI_CWCF }   /* ischangeswhencasefolded */,
  {     0,  8780,  1901,   7,  21, UNI_INDICNUMBERFORMS }   /* block=commonindicnumberforms */,
  {     0,  9768,  7666,   4,   9, UNI_ORKH }   /* scx=oldturkic */,
  {     5,  8780,  8463,   6,   7, UNI_KALI }   /* block=kayahli */,
  {     6,  8147,  9836,   8,   4, UNI_EXTPICT }   /* extpict=true */,
  {     0,  8780,  2245,   6,  11, UNI_INMEETEIMAYEK }   /* block=meeteimayek */,
  {     3,  9277,  9692,   3,   4, UNI_NSHU }   /* sc=nshu */,
  {     2,  2245,     0,  11,   0, UNI_MTEI }   /* meeteimayek */,
  {   512,  9508,  8807,   4,   3, UNI_CCC__118 }   /* ccc=118 */,
  {   135,  9270,  2988,   5,  19, UNI_INPC__TOPANDBOTTOMANDLEFT }   /* inpc=topandbottomandleft */,
  {     1,  2485,     0,   4,   0, UNI_MONG }   /* mong */,
  {     0,  9488,  3457,   4,  11, UNI_TAIXUANJING }   /* blk=taixuanjing */,
  {   150, 10048,  5648,   3,   8, UNI_NV__10000000 }   /* nv=10000000 */,
  {     2,  9488,  8888,   4,   6, UNI_INHATRAN }   /* blk=hatran */,
  {     0,  2280,  8562,   3,   6, UNI_OSMA }   /* isosmanya */,
  {     1,  9488,  9860,   4,   3, UNI_INVAI }   /* blk=vai */,
  {   714,  9277,  8901,   4,   5, UNI_SC__KTHI }   /* sc=kaithi */,
  {    69, 10296,  3599,   3,   3, UNI_PAUC }   /* ispauc */,
  {   184,  1552,  8855,   9,   2, UNI_CF }   /* category=cf */,
  {     2, 10027,  7045,   3,   2, UNI_JG__FE }   /* jg=fe */,
  {   198, 10048,  7859,   3,   3, UNI_NV__200 }   /* nv=200 */,
  {   288, 10027, 10072,   3,   3, UNI_JG__TAH }   /* jg=tah */,
  {   128,  3097,  1253,  18,   7, UNI_DT__INIT }   /* decompositiontype=initial */,
  {     1,  3836,  8912,  17,   6, UNI_KHOJ }   /* scriptextensions=khojki */,
  {     0,  3836,  7684,  17,   4, UNI_PAUC }   /* scriptextensions=pauc */,
  {     0,  5242,     0,  14,   0, UNI_LATINEXTC }   /* latinextendedc */,
  {    11,  2569,     0,  20,   1, UNI_VO__U }   /* verticalorientation=u */,
  {   585,  5986,  9108,  13,   2, UNI_NV__15 }   /* numericvalue=15 */,
  {     0,  3241,     0,   4,   0, UNI_GEOR }   /* geor */,
  {     0,  1013,     0,   5,   0, UNI_GREK }   /* greek */,
  {     0,   184,  5214,   2,  14, UNI_KANGXI }   /* iskangxiradicals */,
  {    12,  4943,     0,  15,   0, UNI_TITLE }   /* titlecaseletter */,
  {    11,  9596,  6763,   4,  11, UNI_LB__H3 }   /* hst=lvtsyllable */,
  {     0,  5324,  8487,   5,   4, UNI_INMANDAIC }   /* inmandaic */,
  {     0,  6576,     0,  11,   0, UNI_alpha_values_index }   /* alphabetic= */,
  {     0,  3836,  8428,  17,   7, UNI_GRAN }   /* scriptextensions=grantha */,
  {   513,  5986,  8744,  13,   3, UNI_NV__700 }   /* numericvalue=700 */,
  {     0, 10009,   567,   3,   2, UNI_DT__NB }   /* dt=nb */,
  {     4,  8589,  8219,   7,   8, UNI_SC__JAVA }   /* script=javanese */,
  {     9,  8780,  2054,   6,  22, UNI_MODIFIERLETTERS }   /* block=spacingmodifierletters */,
  {   516,  3457,     0,  18,   0, UNI_TAIXUANJING }   /* taixuanjingsymbols */,
  {     4,  7088,  6037,  10,  12, UNI_BC__AL }   /* bidiclass=arabicletter */,
  {   128,  9488,   382,   4,  32, UNI_EGYPTIANHIEROGLYPHFORMATCONTROLS }   /* blk=egyptianhieroglyphformatcontrols */,
  {    25,   148,     0,  35,   0, UNI_DIACRITICALSSUP }   /* combiningdiacriticalmarkssupplement */,
  {     0,  1552,  2061,   9,  14, UNI_LM }   /* category=modifierletter */,
  {     2,  9015,  9836,   5,   4, UNI_IDEO }   /* ideo=true */,
  {     2,  7325, 10090,   3,   3, UNI_IN__4 }   /* in=v40 */,
  {     1,  7158,  9255,  10,   5, -UNI_DIA }   /* diacritic=false */,
  {     2,  3836,  9580,  17,   4, UNI_HANO }   /* scriptextensions=hano */,
  {     7,  8780,  1585,   6,  23, UNI_BYZANTINEMUSIC }   /* block=byzantinemusicalsymbols */,
  {     0,  5791,  5172,  13,  14, UNI_JG__HAMZAONHEHGOAL }   /* joininggroup=hamzaonhehgoal */,
  {    13,  2280,  6483,   4,  10, UNI_HUNG }   /* isoldhungarian */,
  {     0,  8589,  9636,   7,   4, UNI_SC__LINB }   /* script=linb */,
  {     0,  8780,    78,   6,  35, UNI_ARABICMATH }   /* block=arabicmathematicalalphabeticsymbols */,
  {     0,  8344,     0,   7,   0, UNI_BENG }   /* bengali */,
  {     0,  8291,     0,   8,   0, UNI_TAGB }   /* tagbanwa */,
  {     3, 10132,  2444,   3,   2, UNI_LB__HL }   /* wb=hl */,
  {     0,  8589,  9860,   7,   4, UNI_VAI }   /* script=vaii */,
  {   320,  8589,  8936,   7,   6, UNI_LYCI }   /* script=lycian */,
  {     0,  9260,    26,   5,   1, UNI_IDSB }   /* idsb=y */,
  {    20,  9524,     0,   3,   0, UNI_CWT }   /* cwt */,
  {   512,  8978,    26,   6,   1, UNI__PERL_PATWS }   /* patws=y */,
  {   256,  9892,     0,   4,   0, UNI_QAAI }   /* zinh */,
  {     3, 10048,  8732,   3,   4, UNI_NV__5000 }   /* nv=5000 */,
  {     0,  9488,  7514,   5,   8, UNI_INBHAIKSUKI }   /* blk=bhaiksuki */,
  {    99,  9488,  2950,   4,  19, UNI_SUPARROWSB }   /* blk=supplementalarrowsb */,
  {    11,  8786,     0,   4,   0, UNI_CARI }   /* cari */,
  {     2,  2779,  9255,  19,   5, -UNI_IDST }   /* idstrinaryoperator=false */,
  {     2,  5986,  7765,  13,   1, UNI_NV__2 }   /* numericvalue=2 */,
  {   129,   184,  8498,   2,   7, UNI_MULT }   /* ismultani */,
  {     3, 10027,  3802,   3,  17, UNI_JG__MANICHAEANHUNDRED }   /* jg=manichaeanhundred */,
  {    27,  4033,  1899,  16,   2, UNI_PC }   /* generalcategory=pc */,
  {     2, 10024,  6862,   3,  11, UNI_NO }   /* gc=othernumber */,
  {     0,   184,  4257,   2,  16, UNI_MISCMATHSYMBOLSB }   /* ismiscmathsymbolsb */,
  {    65,  3887,     0,  17,   0, UNI_SUTTONSIGNWRITING }   /* suttonsignwriting */,
  {     0,  8519, 10135,   7,   3, UNI_DT__NONE }   /* nfkdqc=yes */,
  {    47,  7249,     2,   5,   1, UNI_CARI }   /* iscari */,
  {     0,  8888,     0,   6,   0, UNI_HATR }   /* hatran */,
  {     0,  3097,  8948,  18,   6, UNI_DT__NAR }   /* decompositiontype=narrow */,
  {     3,  9488,  9305,   4,   5, UNI_INNUSHU }   /* blk=nushu */,
  {    12,  9277,  9609,   4,   3, UNI_KITS }   /* sc=kits */,
  {     0,  9346,    26,   4,   1, UNI_IDC }   /* idc=y */,
  {     0,  6928,    26,  11,   1, UNI_SD }   /* softdotted=y */,
  {     1,   184,  3374,   2,  10, UNI_XPOSIXSPACE }   /* iswhitespace */,
  {   290,  6554,     1,  11,   1, -UNI_IDC }   /* idcontinue=n */,
  {    48,  7438,  1822,  10,   2, UNI_WB__NL }   /* wordbreak=nl */,
  {    53,  4916,  1287,   4,   2, UNI_TELU }   /* istelu */,
  {    97,   184,  2141,   3,   7, UNI_CYRL }   /* iscyrillic */,
  {   513,  9277,  4928,   3,   5, UNI_SC__TAML }   /* sc=tamil */,
  {     6,  3836,  8477,  17,   4, UNI_MAKA }   /* scriptextensions=maka */,
  {     1,  6205,     1,  12,   1, -UNI_IDEO }   /* ideographic=n */,
  {   153,   184,  5606,   2,  14, UNI_SUPPUNCTUATION }   /* issuppunctuation */,
  {     2,  7358,     0,   4,   0, UNI_SAUR }   /* saur */,
  {     4,  9508,  9937,   4,   3, UNI_CCC__AL }   /* ccc=228 */,
  {     0,  8780,  5200,   6,  14, UNI_KANASUP }   /* block=kanasupplement */,
  {     9,  9277,  8179,   3,   8, UNI_SC__GURU }   /* sc=gurmukhi */,
  {     0,  9488,  9002,   4,   6, UNI_INTELUGU }   /* blk=telugu */,
  {     6,  6231,  8380,   3,   6, UNI_CJKEXTE }   /* incjkexte */,
  {   249, 10333,     0,   3,   0, UNI_S }   /* iss */,
  {     1,  8589,  9740,   7,   4, UNI_SC__QAAI }   /* script=qaai */,
  {     1,  9508,  9176,   5,   4, UNI_CCC__29 }   /* ccc=ccc29 */,
  {     7, 10033,   533,   3,   2, UNI_LB__NS }   /* lb=ns */,
  {    24,  7540,     0,   8,   0, UNI_EXT }   /* extender */,
  {     1,  8780,  3115,   6,  10, UNI_INDEVANAGARI }   /* block=devanagari */,
  {     1,  9277,    78,   3,   6, UNI_SC__ARAB }   /* sc=arabic */,
  {     3,  9768,  9720,   4,   4, UNI_PHLP }   /* scx=phlp */,
  {     0,  8589,  9452,   7,   4, UNI_AHOM }   /* script=ahom */,
  {    10,  8414,     0,   4,   0, UNI_ELBA }   /* elba */,
  {     0,  9508,  5648,   4,   2, UNI_CCC__10 }   /* ccc=10 */,
  {     0, 10024,  1217,   3,   2, UNI_SK }   /* gc=sk */,
  {     4, 10182, 10279,   6,   9, UNI__PERL_QUOTEMETA }   /* _perl_quotemeta */,
  {     0,  4033,    38,  16,   2, UNI_XPOSIXDIGIT }   /* generalcategory=nd */,
  {   131,  3853,     0,  16,   0, UNI_STERM }   /* sentenceterminal */,
  {    37,   184,  5804,   2,  13, UNI_KANAEXTA }   /* iskanaextendeda */,
  {   357,   861,     0,   6,   0, UNI_ARROWS }   /* arrows */,
  {   133,   184,  8147,   2,   7, UNI_EXTPICT }   /* isextpict */,
  {    64,  3836,  8638,  17,   7, UNI_TGLG }   /* scriptextensions=tagalog */,
  {     1,    21,  2330,   3,  19, UNI_INANATOLIANHIEROGLYPHS }   /* inanatolianhieroglyphs */,
  {     7,   184,  7438,   2,   4, UNI_XPOSIXWORD }   /* isword */,
  {     2,   184,  7630,   2,   9, UNI_TALU }   /* isnewtailue */,
  {    35,  5986,  9913,  13,   3, UNI_NV__2_SLASH_3 }   /* numericvalue=2/3 */,
  {   146,  9350,    26,   5,   1, UNI_XIDS }   /* xids=y */,
  {     0,  8780,  2120,   7,  20, UNI_CJKRADICALSSUP }   /* block=cjkradicalssupplement */,
  {    33,  1922,     0,  12,   0, UNI_DIACRITICALS }   /* diacriticals */,
  {     0,  1552, 10178,   9,   2, UNI_ZP }   /* category=zp */,
  {     0, 10027,  8918,   3,   6, UNI_JG__LAMADH }   /* jg=lamadh */,
  {     0,  8400,     0,   7,   0, UNI_compex_values_index }   /* compex= */,
  {   215,  7278,     0,  10,   0, UNI_XPEO }   /* oldpersian */,
  {   256,  4916,  4386,   3,   5, UNI_TANG }   /* istangut */,
  {   516,  3853,    36,  17,   1, UNI_STERM }   /* sentenceterminal=t */,
  {     0, 10333,  2288,   3,   3, UNI_SINH }   /* issinh */,
  {     0,  9277,  3893,   3,  11, UNI_SGNW }   /* sc=signwriting */,
  {   171,  1269,     1,  25,   1, -UNI_COMPEX }   /* fullcompositionexclusion=n */,
  {   311,  9270,  2555,   5,  14, UNI_INPC__BOTTOMANDRIGHT }   /* inpc=bottomandright */,
  {     0,  2224,  6962,   3,  10, UNI_SUPERANDSUB }   /* insuperandsub */,
  {   314,  3241,     0,  11,   0, UNI_GEORGIANSUP }   /* georgiansup */,
  {     0,  5791,  5869,  13,  13, UNI_JG__MANICHAEANMEM }   /* joininggroup=manichaeanmem */,
  {   152,  5986,  8035,  13,   8, UNI_NV__3_SLASH_4 }   /* numericvalue=7.50e-01 */,
  {   288,  8858,     0,   6,   0, UNI_ecomp_values_index }   /* ecomp= */,
  {     0,  7739, 10135,   8,   3, UNI_IDS }   /* idstart=yes */,
  {     1,  8780,  2912,   6,  19, UNI_SUNDANESESUP }   /* block=sundanesesupplement */,
  {   512, 10060,  9255,   3,   5, -UNI_RI }   /* ri=false */,
  {     4,  8589,  8477,   7,   4, UNI_MAKA }   /* script=maka */,
  {     0,  9616,     0,   4,   0, UNI_KTHI }   /* kthi */,
  {    35,  8589,  8442,   7,   7, UNI_SC__HANO }   /* script=hanunoo */,
  {   603,  5791,  7148,  13,  10, UNI_JG__DALATHRISH }   /* joininggroup=dalathrish */,
  {     2,  7088,     1,  11,   1, UNI_BC__BN }   /* bidiclass=bn */,
  {   265,  2779,     0,   4,   0, UNI_IDST }   /* idst */,
  {    28, 10048,  8035,   3,   8, UNI_NV__3_SLASH_4 }   /* nv=7.50e-01 */,
  {     0, 10033,   495,   3,   7, UNI_LB__NU }   /* lb=numeric */,
  {     0,  4989,    58,   3,   4, UNI_UIDEO }   /* isuideo */,
  {    13,  8768,  9255,   6,   5, -UNI_BIDIC }   /* bidic=false */,
  {   292,  3836,  2409,  17,   4, UNI_GLAG }   /* scriptextensions=glag */,
  {     1,  9277,  9652,   3,   4, UNI_MERC }   /* sc=merc */,
  {     1,  9277,  8666,   3,   7, UNI_SC__TIRH }   /* sc=tirhuta */,
  {    64,  9277,  8291,   3,   4, UNI_SC__TAGB }   /* sc=tagb */,
  {    13,  4916,  8639,   3,   6, UNI_TGLG }   /* istagalog */,
  {     0,  9277,  8470,   3,   7, UNI_SC__LINA }   /* sc=lineara */,
  {     5,   184,  5830,   2,  13, UNI_LOWSURROGATES }   /* islowsurrogates */,
  {   714,   184,  2855,   2,   9, UNI_MONG }   /* ismongolian */,
  {    73,  9070,     1,   5,   1, -UNI_POSIXXDIGIT }   /* ahex=n */,
  {    36,  9488,  1018,   4,   5, UNI_MUSIC }   /* blk=music */,
  {    65,  5746,  1025,   6,   2, -UNI_EBASE }   /* ebase=no */,
  {   161, 10288,  7438,   8,   4, UNI_XPOSIXWORD }   /* isxposixword */,
  {    25,  8107,     0,   8,   0, UNI_BALI }   /* balinese */,
  {     2,  4613,     0,  15,   0, UNI_DIACRITICALSSUP }   /* diacriticalssup */,
  {     0,  9596,  7720,   4,   9, UNI_GCB__V }   /* hst=voweljamo */,
  {   212,  8780,  7684,   6,   9, UNI_INPAUCINHAU }   /* block=paucinhau */,
  {     1,  9262,  1823,   3,   5, UNI_SB__LO }   /* sb=lower */,
  {     0,  8498,     0,   4,   0, UNI_MULT }   /* mult */,
  {     0,  2245,     0,  21,   0, UNI_MEETEIMAYEKEXT }   /* meeteimayekextensions */,
  {     0,  9275,  2608,   5,  19, UNI_INSC__BRAHMIJOININGNUMBER }   /* insc=brahmijoiningnumber */,
  {   543,  9488,  3052,   4,   9, UNI_HALFMARKS }   /* blk=halfmarks */,
  {     0,  3097,  2785,  18,   3, UNI_DT__NAR }   /* decompositiontype=nar */,
  {    16,  4916,  5850,   3,   3, UNI_TAML }   /* istaml */,
  {     0,  3717,  7338,  17,  10, UNI_IDENTIFIERSTATUS__RESTRICTED }   /* identifierstatus=restricted */,
  {     3,  4129,     0,  16,   0, UNI_LATIN1 }   /* latin1supplement */,
  {     0,  3836,  2329,  17,  20, UNI_HLUW }   /* scriptextensions=anatolianhieroglyphs */,
  {     0, 10024,  4245,   3,  10, UNI_SM }   /* gc=mathsymbol */,
  {   389,   184,  1294,   2,  25, UNI_SUPERANDSUB }   /* issuperscriptsandsubscripts */,
  {     0,  5674, 10135,  13,   3, UNI_BIDIM }   /* bidimirrored=yes */,
  {    73,  4542,  1633,   4,  21, UNI_GEOMETRICSHAPESEXT }   /* ingeometricshapesextended */,
  {     1,  9768,  9860,   4,   4, UNI_VAI }   /* scx=vaii */,
  {  1024,  6576,  9255,  11,   5, -UNI_XPOSIXALPHA }   /* alphabetic=false */,
  {     0,  5228,     0,  14,   0, UNI_LATINEXTB }   /* latinextendedb */,
  {     0,    21,  3421,   2,  18, UNI_RUMI }   /* inruminumeralsymbols */,
  {     0,  5986,  7826,  13,   2, UNI_NV__12 }   /* numericvalue=12 */,
  {   513,  9488,  4129,   4,  16, UNI_LATIN1 }   /* blk=latin1supplement */,
  {     1, 10291,  7438,   5,   4, UNI_POSIXWORD }   /* posixword */,
  {     0,  8960,    26,   6,   1, UNI_NFCQC__Y }   /* nfcqc=y */,
  {   199,  9508,  9472,   4,   4, UNI_WB__EB }   /* ccc=atbl */,
  {     2,  9277,  8610,   3,   7, UNI_SIDD }   /* sc=siddham */,
  {     0, 10009,  9868,   3,   4, UNI_EA__F }   /* dt=wide */,
  {     0, 10048,  7469,   3,   8, UNI_NV__1_SLASH_2 }   /* nv=5.00e-01 */,
  {    16,  5986,  8756,  13,   2, UNI_NV__90 }   /* numericvalue=90 */,
  {     3,  2760,    36,  19,   1, UNI_GCB__T }   /* hangulsyllabletype=t */,
  {    31,  9568,     0,   4,   0, UNI_GREK }   /* grek */,
  {     0,   184,  8421,   2,   7, UNI_ELYM }   /* iselymaic */,
  {     5,  3937,     0,   8,   0, UNI_BOPO }   /* bopomofo */,
  {   815,  8680,     0,   7,   0, UNI_ZZZZ }   /* unknown */,
  {     3,  5324,     0,  12,   0, UNI_INMANICHAEAN }   /* inmanichaean */,
  {     2,  3836,  1222,  17,   4, UNI_KANA }   /* scriptextensions=kana */,
  {     0,  9285,     0,   4,   0, UNI_LIMB }   /* limb */,
  {    71,   184,  3115,   2,  13, UNI_DEVANAGARIEXT }   /* isdevanagariext */,
  {   518,  1505,  3827,   4,   5, UNI_INGRANTHA }   /* ingrantha */,
  {   151, 10033,  5298,   3,  14, UNI_LB__BK }   /* lb=mandatorybreak */,
  {     0,  8589,  9816,   7,   4, UNI_TAVT }   /* script=tavt */,
  {    67,  9488,  9245,   4,   5, UNI_INDOGRA }   /* blk=dogra */,
  {     0,  3836,  9752,  17,   4, UNI_ROHG }   /* scriptextensions=rohg */,
  {    32,  9270,  2549,   5,  12, UNI_INPC__TOPANDBOTTOM }   /* inpc=topandbottom */,
  {     0,   184,  5003,   2,  15, UNI_ZANB }   /* iszanabazarsquare */,
  {     6,  8203,     0,   8,   0, UNI_JAMOEXTA }   /* jamoexta */,
  {     1,  5037,     0,   8,   0, UNI_XPOSIXXDIGIT }   /* hexdigit */,
  {    48,  9335,     0,   4,   0, UNI_TAKR }   /* takr */,
  {     0,  1537,  1924,   4,  10, UNI_DIACRITICALS }   /* indiacriticals */,
  {     1,  9444,  7877,   4,   2, UNI_AGE__13 }   /* age=13 */,
  {     0,   727,     0,   2,   0, UNI_MN }   /* mn */,
  {     1,  9488,  2969,   4,  19, UNI_SUPARROWSC }   /* blk=supplementalarrowsc */,
  {     1,  5986,  8027,  13,   8, UNI_NV__15_SLASH_2 }   /* numericvalue=7.50e+00 */,
  {    34,  4838,     0,  16,   0, UNI_NFKCQC__N }   /* nfkcquickcheck=n */,
  {     0,  4401,     0,   9,   0, UNI_TANGUTSUP }   /* tangutsup */,
  {    32,  8589,  8131,   7,   8, UNI_SC__DUPL }   /* script=duployan */,
  {    21,  9275,  4913,   5,  15, UNI_INSC__REGISTERSHIFTER }   /* insc=registershifter */,
  {    52,  9528,     0,   3,   0, UNI_CWU }   /* cwu */,
  {     2,   184,  6061,   2,  11, UNI_BIDIC }   /* isbidicontrol */,
  {     0, 10033,  3969,   3,  16, UNI_LB__CP }   /* lb=closeparenthesis */,
  {   128,  9488,  4703,   4,  15, UNI_INIMPERIALARAMAIC }   /* blk=imperialaramaic */,
  {    84,  3529,    26,  18,   1, UNI_VS }   /* variationselector=y */,
  {     0,  8582,     0,   7,   0, UNI_PHAG }   /* phagspa */,
  {   545,  9277,  8491,   3,   4, UNI_MARC }   /* sc=marc */,
  {     0, 10048,  8083,   3,   8, UNI_NV__11_SLASH_12 }   /* nv=9.17e-01 */,
  {     0,  9768,    78,   4,   6, UNI_ARAB }   /* scx=arabic */,
  {     4,  9452,     0,   4,   0, UNI_AHOM }   /* ahom */,
  {     5,   184,  4241,   2,  16, UNI_MISCMATHSYMBOLSA }   /* ismiscmathsymbolsa */,
  {   129,  9488,  3169,   4,  11, UNI_ETHIOPICSUP }   /* blk=ethiopicsup */,
  {     0,  6229,     0,   5,   0, UNI_JOINC }   /* joinc */,
  {     0,  9277,  5284,   3,   4, UNI_LISU }   /* sc=lisu */,
  {   928,  8315,     0,   8,   0, UNI_UGAR }   /* ugaritic */,
  {     0,  1552,   400,   9,   6, UNI_CF }   /* category=format */,
  {     0, 10048,  9994,   3,   3, UNI_NV__9_SLASH_2 }   /* nv=9/2 */,
  {   279, 10048,  7811,   3,   8, UNI_NV__1_SLASH_6 }   /* nv=1.67e-01 */,
  {     0,  8978,  9255,   6,   5, -UNI__PERL_PATWS }   /* patws=false */,
  {   581,  3836,  1677,  17,   5, UNI_LATN }   /* scriptextensions=latin */,
  {   562,  9488,  1441,   4,  24, UNI_CJKSYMBOLS }   /* blk=cjksymbolsandpunctuation */,
  {    32,  1417,  8819,  24,   3, UNI_CCC__129 }   /* canonicalcombiningclass=129 */,
  {     1,  5452,    17,  15,   1, UNI_COMPEX }   /* nfcquickcheck=no */,
  {   128,  9277,  9504,   3,   4, UNI_CANS }   /* sc=cans */,
  {     0, 10006,     0,   3,   0, UNI_di_values_index }   /* di= */,
  {     2,  8780,  6277,   6,   7, UNI_MAHJONG }   /* block=mahjong */,
  {   145,  8780,  5186,   6,  14, UNI_HIGHSURROGATES }   /* block=highsurrogates */,
  {     0,  1417,  9188,  24,   2, UNI_CCC__31 }   /* canonicalcombiningclass=31 */,
  {     0,  1856,  9836,  22,   4, UNI_CWU }   /* changeswhenuppercased=true */,
  {   139,  9277,  9588,   3,   4, UNI_HMNG }   /* sc=hmng */,
  {   716,  9265,    26,   5,   1, UNI_IDST }   /* idst=y */,
  {    12,  4688,  2023,  15,   9, UNI_IDENTIFIERTYPE__TECHNICAL }   /* identifiertype=technical */,
  {     0,  7218, 10164,  10,   2, UNI_GCB__V }   /* linebreak=jv */,
  {     1, 10182,  1527,   6,   9, UNI__PERL_SURROGATE }   /* _perl_surrogate */,
  {     0,  2224,   350,   3,  32, UNI_SUPSYMBOLSANDPICTOGRAPHS }   /* insupplementalsymbolsandpictographs */,
  {     0,  1505,  5161,   5,  11, UNI_INGREEK }   /* ingreekandcoptic */,
  {    65,  8589,  4868,   7,  15, UNI_NARB }   /* script=oldnortharabian */,
  {     0,  8589,  9656,   7,   4, UNI_MIAO }   /* script=miao */,
  {   301,   184,  4583,   2,  15, UNI_PD }   /* isdashpunctuation */,
  {     1,  9508,  9171,   5,   4, UNI_CCC__28 }   /* ccc=ccc28 */,
  {     1,  4113,    67,   3,   4, UNI_VSSUP }   /* invssup */,
  {   390,  2280,  4306,   3,  15, UNI_PO }   /* isotherpunctuation */,
  {   138, 10024,  1465,   3,  13, UNI_M }   /* gc=combiningmark */,
  {     1,  9508,  7877,   4,   2, UNI_CCC__13 }   /* ccc=13 */,
  {     4,   184,  4129,   2,   6, UNI_LATIN1 }   /* islatin1 */,
  {   147,  6241,  6529,  12,  12, UNI_JT__R }   /* joiningtype=rightjoining */,
  {     2,  6231,  2667,   4,   9, UNI_COUNTINGROD }   /* incountingrod */,
  {     2,  2280,  3332,   3,  17, UNI_ORNAMENTALDINGBATS }   /* isornamentaldingbats */,
  {     0,  5986,  7771,  13,   8, UNI_NV__1_SLASH_80 }   /* numericvalue=1.25e-02 */,
  {     0,  1417,    24,  24,   1, UNI_CCC__L }   /* canonicalcombiningclass=l */,
  {     2,  9020,     3,   6,   1, -UNI_XPOSIXUPPER }   /* upper=f */,
  {     3,  1746,     1,  22,   1, UNI_BPT__N }   /* bidipairedbrackettype=n */,
  {     1,  6730,     0,  11,   0, UNI_KATAKANAEXT }   /* katakanaext */,
  {     1,  9880,     0,   4,   0, UNI_YI }   /* yiii */,
  {   321,  9556,   406,   4,   7, UNI_GCB__CN }   /* gcb=control */,
  {     0,  9488,  3169,   4,   8, UNI_INETHIOPIC }   /* blk=ethiopic */,
  {     0,  9768,  8291,   4,   4, UNI_TAGB }   /* scx=tagb */,
  {     0, 10009,  8846,   3,   6, UNI_DT__ENC }   /* dt=circle */,
  {     0,  4033,  1910,  16,   2, UNI_CN }   /* generalcategory=cn */,
  {     0,  9508,  8811,   5,   5, UNI_CCC__122 }   /* ccc=ccc122 */,
  {     0,  9768,  7684,   4,   9, UNI_PAUC }   /* scx=paucinhau */,
  {     0,  2224,  8632,   3,   6, UNI_SUPPUAB }   /* insuppuab */,
  {    38,  9768,  8407,   4,   7, UNI_DSRT }   /* scx=deseret */,
  {     1,  8589,  3937,   7,   8, UNI_SC__BOPO }   /* script=bopomofo */,
  {     0, 10027,   756,   3,   3, UNI_JG__DAL }   /* jg=dal */,
  {   555,   435,     0,   5,   0, UNI__PERL_NCHAR }   /* nchar */,
  {    19,  3836,  8428,  17,   4, UNI_GRAN }   /* scriptextensions=gran */,
  {     0,  3097,     0,  18,   0, UNI_dt_values_index }   /* decompositiontype= */,
  {     3,  7076,  7099,   3,   9, UNI_BOXDRAWING }   /* inboxdrawing */,
  {     2,  1988,     0,  22,   0, UNI_loe_values_index }   /* logicalorderexception= */,
  {   641,  1966,  3953,  22,  16, UNI_INSC__CANTILLATIONMARK }   /* indicsyllabiccategory=cantillationmark */,
  {     0,  8870, 10135,   6,   3, UNI_EPRES }   /* epres=yes */,
  {   523,  1790,  1025,  22,   2, -UNI_CWCM }   /* changeswhencasemapped=no */,
  {     0,  9488,  2287,   4,   7, UNI_INSINHALA }   /* blk=sinhala */,
  {    16,  1087,    26,  27,   1, UNI_PCM }   /* prependedconcatenationmark=y */,
  {     0,  8780,  1561,   6,  24, UNI_SUPSYMBOLSANDPICTOGRAPHS }   /* block=supsymbolsandpictographs */,
  {     0,  2665,     0,  11,   0, UNI_COUNTINGROD }   /* countingrod */,
  {     0,  1417,  9106,  25,   4, UNI_CCC__15 }   /* canonicalcombiningclass=ccc15 */,
  {     1,  8780,  8876,   6,   6, UNI_INGOTHIC }   /* block=gothic */,
  {     0,    21,  7458,   2,  10, UNI_YIRADICALS }   /* inyiradicals */,
  {     4,  3836,  9680,  17,   4, UNI_NBAT }   /* scriptextensions=nbat */,
  {     1,  8780,  2429,   6,  20, UNI_ININSCRIPTIONALPAHLAVI }   /* block=inscriptionalpahlavi */,
  {     9, 10003,  9836,   3,   4, UNI_CI }   /* ci=true */,
  {   768,  7076,  5816,   3,   7, UNI_INBALINESE }   /* inbalinese */,
  {     5,  2779,     0,  19,   0, UNI_idst_values_index }   /* idstrinaryoperator= */,
  {     0,  8930,    26,   6,   1, UNI_XPOSIXLOWER }   /* lower=y */,
  {     0,  9277,  4448,   3,   4, UNI_BAMU }   /* sc=bamu */,
  {    14,  7318,  7754,  10,   2, UNI_IN__11 }   /* presentin=11 */,
  {     0,  3115,     0,  18,   0, UNI_DEVANAGARIEXT }   /* devanagariextended */,
  {     0,  9095,     0,   5,   0, UNI_BUHD }   /* buhid */,
  {    32,  5452,     0,  15,   0, UNI_COMPEX }   /* nfcquickcheck=n */,
  {     0,  1746,     0,  22,   0, UNI_bpt_values_index }   /* bidipairedbrackettype= */,
  {    22,  3374,  9255,  11,   5, -UNI_XPOSIXSPACE }   /* whitespace=false */,
  {    27,  8688,  2330,   3,  19, UNI_HLUW }   /* isanatolianhieroglyphs */,
  {    40,  5497,     0,  11,   0, UNI_MC }   /* spacingmark */,
  {     2,  9768,  9608,   4,   4, UNI_KITS }   /* scx=kits */,
  {    43,  2784,  1395,   4,  22, UNI_ARABICPFB }   /* inarabicpresentationformsb */,
  {     0,  9768,  6840,   4,   4, UNI_NAND }   /* scx=nand */,
  {   104,  3836,  7188,  17,  10, UNI_KHAR }   /* scriptextensions=kharoshthi */,
  {    23,  5986,  9392,  13,   4, UNI_NV__11_SLASH_2 }   /* numericvalue=11/2 */,
  {   320, 10048,  9372,   3,   4, UNI_NV__1_SLASH_40 }   /* nv=1/40 */,
  {     0,  9768,  6277,   4,   4, UNI_MAHJ }   /* scx=mahj */,
  {     6,  9997,   407,   3,   2, UNI_BC__ON }   /* bc=on */,
  {    72,  6205,  9255,  12,   5, -UNI_IDEO }   /* ideographic=false */,
  {   258,   184,  6277,   2,   4, UNI_MAHJ }   /* ismahj */,
  {   192,  7540,  1025,   9,   2, -UNI_EXT }   /* extender=no */,
  {     0,  9277,  9892,   3,   4, UNI_SC__QAAI }   /* sc=zinh */,
  {     9,  2912,     0,   4,   0, UNI_SUND }   /* sund */,
  {     0,  8688,  1007,   3,  26, UNI_ANCIENTGREEKMUSIC }   /* isancientgreekmusicalnotation */,
  {   379,  9488,   719,   4,  30, UNI_CUNEIFORMNUMBERS }   /* blk=cuneiformnumbersandpunctuation */,
  {     0,    21,  8470,   2,   7, UNI_INLINEARA }   /* inlineara */,
  {     0,  9277,  9624,   3,   4, UNI_LAO }   /* sc=laoo */,
  {     1,  5791,  5364,  13,   4, UNI_JG__HETH }   /* joininggroup=heth */,
  {     1,  3025,     0,   4,   0, UNI_CHER }   /* cher */,
  {    38, 10048,  9907,   3,   3, UNI_NV__1_SLASH_7 }   /* nv=1/7 */,
  {     0,  2224,  7399,   3,   9, UNI_SUPARROWSC }   /* insuparrowsc */,
  {     6,  7325, 10093,   3,   3, UNI_IN__4_DOT_1 }   /* in=v41 */,
  {     1, 10024,    48,   3,   1, UNI_P }   /* gc=p */,
  {     0,  1921,     0,   2,   0, UNI_SD }   /* sd */,
  {     0,  9488,    42,   4,   9, UNI_CJKCOMPAT }   /* blk=cjkcompat */,
  {     0,  5791,  9784,  13,   4, UNI_JG__SHIN }   /* joininggroup=shin */,
  {     0,  8589,  9544,   7,   4, UNI_DIAK }   /* script=diak */,
  {   105,  9997,   426,   3,   2, UNI_BC__ES }   /* bc=es */,
  {   459,  3904,    36,  17,   1, UNI_UIDEO }   /* unifiedideograph=t */,
  {    40,  9345,  1025,   5,   2, -UNI_XIDC }   /* xidc=no */,
  {     0,  5986,  7877,  13,   2, UNI_NV__13 }   /* numericvalue=13 */,
  {     0,  1677,     0,  14,   0, UNI_LATINEXTA }   /* latinextendeda */,
  {     0,  7218,    96,  10,  10, UNI_LB__AL }   /* linebreak=alphabetic */,
  {     0, 10009,  2785,   3,   3, UNI_DT__NAR }   /* dt=nar */,
  {   572,   283,     0,  33,   0, UNI_MISCMATHSYMBOLSB }   /* miscellaneousmathematicalsymbolsb */,
  {     2,  9768,  4883,   4,  15, UNI_SARB }   /* scx=oldsoutharabian */,
  {     0,  8526,     0,   7,   0, UNI_NB }   /* noblock */,
  {    20,  9824,     0,   4,   0, UNI_TGLG }   /* tglg */,
  {     0,  9768,  8561,   4,   4, UNI_OSMA }   /* scx=osma */,
  {     0,  9285,     0,   5,   0, UNI_LIMB }   /* limbu */,
  {     6,  9277,  4145,   3,   7, UNI_SC__LINB }   /* sc=linearb */,
  {   330,  9275,  4508,   5,  15, UNI_INSC__CONSONANTKILLER }   /* insc=consonantkiller */,
  {     0,  5986,  4134,  13,   1, UNI_NV__1 }   /* numericvalue=1 */,
  {    20,  9640,     3,   4,   1, -UNI_LOE }   /* loe=f */,
  {     0,  3836,  4001,  17,   7, UNI_CPRT }   /* scriptextensions=cypriot */,
  {     0,  6972,     0,  11,   0, UNI_SYLO }   /* sylotinagri */,
  {   306,  5986,  8710,  13,   4, UNI_NV__6000 }   /* numericvalue=6000 */,
  {    11,  5746,  9255,   6,   5, -UNI_EBASE }   /* ebase=false */,
  {   962,   184,  6397,   2,  12, UNI_MATHALPHANUM }   /* ismathalphanum */,
  {     1,  5032,     0,  13,   0, UNI_POSIXXDIGIT }   /* asciihexdigit */,
  {     0,  9277,  1013,   3,   5, UNI_SC__GREK }   /* sc=greek */,
  {     0,  1979, 10171,  10,   1, UNI_CASEDLETTER }   /* category=l_ */,
  {     0, 10126,   471,   3,   2, UNI_VO__TU }   /* vo=tu */,
  {     0,  9508,  4912,   4,   2, UNI_CCC__0 }   /* ccc=nr */,
  {     0,  9832,     0,   4,   0, UNI_TIBT }   /* tibt */,
  {     1,  8435,    36,   7,   1, UNI_GRBASE }   /* grbase=t */,
  {     0,  9508,   756,   4,   2, UNI_CCC__DA }   /* ccc=da */,
  {     4,  8211,     0,   8,   0, UNI_JAMOEXTB }   /* jamoextb */,
  {   125,  1537,  4988,  24,  15, UNI_LOE }   /* indicpositionalcategory=visualorderleft */,
  {     0, 10048,  7843,   3,   8, UNI_NV__1_SLASH_4 }   /* nv=2.50e-01 */,
  {     0,  5200,     0,   7,   0, UNI_KANASUP }   /* kanasup */,
  {     0,  8780,   861,   6,   6, UNI_ARROWS }   /* block=arrows */,
  {     1,  6805,   842,   6,  25, UNI_MISCARROWS }   /* inmiscellaneoussymbolsandarrows */,
  {     0,  9596,    24,   4,   1, UNI_GCB__L }   /* hst=l */,
  {     0,  5986,  8714,  13,   5, UNI_NV__30000 }   /* numericvalue=30000 */,
  {     8,  9277,  4385,   3,   4, UNI_TANG }   /* sc=tang */,
  {     0,  8575, 10135,   7,   3, UNI_PATSYN }   /* patsyn=yes */,
  {     0,  1218,     0,  26,   0, UNI_KATAKANAEXT }   /* katakanaphoneticextensions */,
  {     3,  5986,  5649,  13,   1, UNI_NV__0 }   /* numericvalue=0 */,
  {    64, 10027,  5368,   3,  14, UNI_JG__MANICHAEANKAPH }   /* jg=manichaeankaph */,
  {     0, 10048,  9409,   3,   3, UNI_NV__5_SLASH_2 }   /* nv=5/2 */,
  {   776,   184,  5843,   2,   9, UNI_MLYM }   /* ismalayalam */,
  {     0,  4116,  2430,   3,  19, UNI_PHLI }   /* isinscriptionalpahlavi */,
  {   557,  9444,  7826,   4,   2, UNI_AGE__12 }   /* age=12 */,
  {     9, 10009, 10066,   3,   3, UNI_DT__SML }   /* dt=sml */,
  {     0,  9488,  4808,   4,  15, UNI_MISCPICTOGRAPHS }   /* blk=miscpictographs */,
  {     0,  8589,  9652,   7,   4, UNI_MERC }   /* script=merc */,
  {     1,  8589,  8315,   7,   4, UNI_UGAR }   /* script=ugar */,
  {     3,  8589,  3025,   7,   8, UNI_CHER }   /* script=cherokee */,
  {     0,  2529,     3,  20,   1, -UNI_TERM }   /* terminalpunctuation=f */,
  {    66,  9262,  8996,   3,   5, UNI_SB__ST }   /* sb=sterm */,
  {     0,  6012,     0,  13,   0, UNI_VERTICALFORMS }   /* verticalforms */,
  {     0,  8990,     0,   6,   0, UNI_RJNG }   /* rejang */,
  {     0,  9488,  6385,   4,  12, UNI_INMASARAMGONDI }   /* blk=masaramgondi */,
  {     0,  8960, 10135,   6,   3, UNI_NFCQC__Y }   /* nfcqc=yes */,
  {     4,  9520,    36,   4,   1, UNI_CWL }   /* cwl=t */,
  {    75,  1222,     0,   4,   0, UNI_KANA }   /* kana */,
  {    41,  4033,   341,  16,   2, UNI_PE }   /* generalcategory=pe */,
  {    11,  9820,     0,   4,   0, UNI_TFNG }   /* tfng */,
  {     0,  2288,  4068,   5,  13, UNI_HALFANDFULLFORMS }   /* inhalfandfullforms */,
  {    10,  5060,  1025,  14,   2, -UNI_CI }   /* caseignorable=no */,
  {     0,  9262,  4305,   3,   5, UNI_SB__XX }   /* sb=other */,
  {    90,  7155,  3053,   3,   8, UNI_HALFMARKS }   /* ishalfmarks */,
  {   404, 10290,  5040,   6,   5, UNI_XPOSIXDIGIT }   /* xposixdigit */,
  {     0, 10027,  7711,   3,   9, UNI_JG__SYRIACWAW }   /* jg=syriacwaw */,
  {   672,  7098,     0,  10,   0, UNI_BOXDRAWING }   /* boxdrawing */,
  {     1,  9768,  1013,   4,   5, UNI_GREK }   /* scx=greek */,
  {     0,  9444,  7987,   4,   3, UNI_AGE__6_DOT_2 }   /* age=6.2 */,
  {     0,  3133,  1025,  18,   2, -UNI_EBASE }   /* emojimodifierbase=no */,
  {    16,  1812,  9836,  22,   4, UNI_CWL }   /* changeswhenlowercased=true */,
  {     1,   117,   447,   3,  31, UNI_IDEOGRAPHICSYMBOLS }   /* inideographicsymbolsandpunctuation */,
  {    87,  1417,  8727,  24,   2, UNI_CCC__32 }   /* canonicalcombiningclass=32 */,
  {   546,  9768,  7675,   4,   9, UNI_PALM }   /* scx=palmyrene */,
  {    32,  9768,  3241,   4,   4, UNI_GEOR }   /* scx=geor */,
  {     0,  9764,     0,   4,   0, UNI_SARB }   /* sarb */,
  {     0, 10033,    73,   3,   2, UNI_EMOD }   /* lb=em */,
  {     4,  3836,  9335,  17,   4, UNI_TAKR }   /* scriptextensions=takr */,
  {  1097, 10291,  5039,   5,   6, UNI_POSIXXDIGIT }   /* posixxdigit */,
  {   128,  7249,  3583,   4,  15, UNI_UCAS }   /* iscanadiansyllabics */,
  {   268,  8589,  7308,   7,  10, UNI_PHNX }   /* script=phoenician */,
  {    36,   184,  2485,   2,   4, UNI_MONG }   /* ismong */,
  {     0,  8694,     0,   6,   0, UNI_XPOSIXSPACE }   /* wspace */,
  {     2,  9508,  7826,   4,   2, UNI_CCC__12 }   /* ccc=12 */,
  {    15,  1587,     0,   1,   0, UNI_Z }   /* z */,
  {    10, 10048,  9436,   3,   4, UNI_NV__7_SLASH_12 }   /* nv=7/12 */,
  {     2,  9488,  2308,   4,   6, UNI_YIJING }   /* blk=yijing */,
  {     0,  2182, 10174,  21,   2, UNI_GCB__XX }   /* graphemeclusterbreak=xx */,
  {     0,  1746,    17,  22,   1, UNI_BPT__O }   /* bidipairedbrackettype=o */,
  {     0,  3836,   493,  17,   3, UNI_HAN }   /* scriptextensions=han */,
  {     1,  1087,  9836,  27,   4, UNI_PCM }   /* prependedconcatenationmark=true */,
  {     0,  7418,  9255,  10,   5, -UNI_XPOSIXUPPER }   /* uppercase=false */,
  {     4,  1114,     3,  26,   1, -UNI_CWKCF }   /* changeswhennfkccasefolded=f */,
  {     0,  7028,  9881,   3,   3, UNI_YI }   /* isyiii */,
  {     4,  4033,    45,  16,   2, UNI_CO }   /* generalcategory=co */,
  {     0,  4916,  2077,   3,  21, UNI_TRANSPORTANDMAP }   /* istransportandmapsymbols */,
  {     0,  8780,  8203,   6,   8, UNI_JAMOEXTA }   /* block=jamoexta */,
  {     7,  7155,  1116,   3,   3, UNI_HANG }   /* ishang */,
  {    89,  8780,  2308,   6,   6, UNI_YIJING }   /* block=yijing */,
  {    21,   184,  8171,   2,   8, UNI_GUJR }   /* isgujarati */,
  {  1024,  9768,  8924,   4,   4, UNI_LEPC }   /* scx=lepc */,
  {     5, 10129,     0,   3,   0, UNI_vs_values_index }   /* vs= */,
  {     3,  9664,     0,   4,   0, UNI_MRO }   /* mroo */,
  {     0,  8780,  2245,   6,  21, UNI_MEETEIMAYEKEXT }   /* block=meeteimayekextensions */,
  {     0,  6576,  1025,  11,   2, -UNI_XPOSIXALPHA }   /* alphabetic=no */,
  {    29,   184,   382,   2,  32, UNI_EGYPTIANHIEROGLYPHFORMATCONTROLS }   /* isegyptianhieroglyphformatcontrols */,
  {     2,  9270,   868,   3,  17, UNI_PHONETICEXT }   /* inphoneticextensions */,
  {     9,  9015,     0,   5,   0, UNI_ideo_values_index }   /* ideo= */,
  {     0, 10033,  7448,   3,  10, UNI_LB__WJ }   /* lb=wordjoiner */,
  {     7,  7239,     0,   2,   0, UNI_VS }   /* vs */,
  {   352,  9488,  3938,   5,  15, UNI_BOPOMOFOEXT }   /* blk=bopomofoextended */,
  {     0,  9488,  2477,   4,   3, UNI_PUA }   /* blk=pua */,
  {     7,   184,  2817,   2,   4, UNI_MERO }   /* ismero */,
  {     0,  5960,     0,  13,   0, UNI_MISCTECHNICAL }   /* misctechnical */,
  {   160,  8840,     0,   6,   0, UNI_CAKM }   /* chakma */,
  {   521,  5726,     0,  13,   0, UNI_ME }   /* enclosingmark */,
  {    23,  1417,  9101,  25,   4, UNI_CCC__14 }   /* canonicalcombiningclass=ccc14 */,
  {     2,  8688,   727,   4,   2, UNI_ARMN }   /* isarmn */,
  {     2,   184,  2469,   2,  20, UNI_HMNP }   /* isnyiakengpuachuehmong */,
  {   757, 10290,  1867,   6,   5, UNI_XPOSIXUPPER }   /* xposixupper */,
  {     8, 10132,   125,   3,   2, UNI_LB__CR }   /* wb=cr */,
  {   161,  9768,  4001,   4,   7, UNI_CPRT }   /* scx=cypriot */,
  {     0,   184,  1442,   3,   9, UNI_CJKSYMBOLS }   /* iscjksymbols */,
  {     0,  9768,  9548,   4,   4, UNI_DSRT }   /* scx=dsrt */,
  {     0,  3836,  6792,  18,   3, UNI_SAMR }   /* scriptextensions=samr */,
  {   144,  4542,  3226,   5,  15, UNI_INPUNCTUATION }   /* ingeneralpunctuation */,
  {   634,  4116,  1308,   3,   2, UNI_IDS }   /* isids */,
  {    10,  9346,  1025,   4,   2, -UNI_IDC }   /* idc=no */,
  {    32,   184,  8421,   2,   4, UNI_ELYM }   /* iselym */,
  {     4,  9275,  8099,   5,   8, UNI_INSC__AVAGRAHA }   /* insc=avagraha */,
  {   132,  8575,    36,   7,   1, UNI_PATSYN }   /* patsyn=t */,
  {     0,  3836,  8091,  17,   8, UNI_ARMN }   /* scriptextensions=armenian */,
  {     0,  5791,  6565,  13,  11, UNI_JG__AFRICANNOON }   /* joininggroup=africannoon */,
  {     1,  2288,  2724,   4,   8, UNI_JAMO }   /* inhanguljamo */,
  {     0,  5452,    47,  14,   1, UNI_NFCQC__M }   /* nfcquickcheck=m */,
  {     1,  9684,     0,   4,   0, UNI_NEWA }   /* newa */,
  {   549,  9488,   867,   4,  11, UNI_PHONETICEXT }   /* blk=phoneticext */,
  {   513,  8762,  1025,   6,   2, -UNI_XPOSIXALPHA }   /* alpha=no */,
  {   455,  8780,  5804,   6,  13, UNI_KANAEXTA }   /* block=kanaextendeda */,
  {     1,   184,  3937,   2,  11, UNI_BOPOMOFOEXT }   /* isbopomofoext */,
  {   783,  5986,  9050,  13,   5, UNI_NV__1_SLASH_160 }   /* numericvalue=1/160 */,
  {     7, 10024,  3277,   3,  18, UNI_PI }   /* gc=initialpunctuation */,
  {     0,  9262,   339,   3,   2, UNI_SB__LO }   /* sb=lo */,
  {     0,  2161,    26,  21,   1, UNI_EXTPICT }   /* extendedpictographic=y */,
  {  1140,  7249,  3600,   4,  15, UNI_AGHB }   /* iscaucasianalbanian */,
  {     3,  9768,  9320,   4,   5, UNI_OSGE }   /* scx=osage */,
  {     0,  5060,     0,  13,   0, UNI_CI }   /* caseignorable */,
  {   147, 10048,  9376,   3,   3, UNI_NV__1_SLASH_6 }   /* nv=1/6 */,
  {   301,  7027,     0,  11,   0, UNI_YISYLLABLES }   /* yisyllables */,
  {     9, 10033,  7268,   3,  10, UNI_LB__NS }   /* lb=nonstarter */,
  {   192,  5508,  9255,  14,   5, -UNI_PATSYN }   /* patternsyntax=false */,
  {     1,  8954,    26,   6,   1, UNI__PERL_NCHAR }   /* nchar=y */,
  {     1,  5986,  5648,  13,   6, UNI_NV__100000 }   /* numericvalue=100000 */,
  {     5,  2224,  7389,   3,   9, UNI_SUPARROWSB }   /* insuparrowsb */,
  {     0, 10024,    25,   3,   1, UNI_S }   /* gc=s */,
  {     0,  5986,  7835,  13,   8, UNI_NV__5_SLASH_2 }   /* numericvalue=2.50e+00 */,
  {   303,  5986,  1249,  13,   3, UNI_NV__NAN }   /* numericvalue=nan */,
  {     1,  1768,    36,  22,   1, UNI_CWCF }   /* changeswhencasefolded=t */,
  {     0,  8688,  7497,   4,   7, UNI_ARABICPFA }   /* isarabicpfa */,
  {   264,  8780,   183,   6,  20, UNI_MISCSYMBOLS }   /* block=miscellaneoussymbols */,
  {     0,  9277,  6796,   3,  11, UNI_MEDF }   /* sc=medefaidrin */,
  {   672,   184,  1466,   3,  23, UNI_DIACRITICALSFORSYMBOLS }   /* iscombiningmarksforsymbols */,
  {     3,  9997,  3756,   3,   3, UNI_BC__NSM }   /* bc=nsm */,
  {     4,  2569,    18,  20,   1, UNI_VO__R }   /* verticalorientation=r */,
  {     3,  9508, 10166,   4,   2, UNI_CCC__8 }   /* ccc=kv */,
  {     0,  8762,     0,   6,   0, UNI_alpha_values_index }   /* alpha= */,
  {    13,  9768,  8498,   4,   4, UNI_MULT }   /* scx=mult */,
  {     2,  5986,  5648,  13,   2, UNI_NV__10 }   /* numericvalue=10 */,
  {     0,  8864,  9836,   6,   4, UNI_EMOJI }   /* emoji=true */,
  {     0,  2224,  7359,   3,   9, UNI_INSAURASHTRA }   /* insaurashtra */,
  {   514,  9444, 10111,   4,   3, UNI_AGE__6_DOT_2 }   /* age=v62 */,
  {     1,   184,  2703,   2,  19, UNI_ENCLOSEDALPHANUMSUP }   /* isenclosedalphanumsup */,
  {     0,  9768,  9305,   4,   5, UNI_NSHU }   /* scx=nushu */,
  {   152,  1746,  4898,  22,   4, UNI_BPT__O }   /* bidipairedbrackettype=open */,
  {    15,   184,   183,   2,  34, UNI_MISCPICTOGRAPHS }   /* ismiscellaneoussymbolsandpictographs */,
  {   617,  7438,  7603,  10,   9, UNI_WB__ML }   /* wordbreak=midletter */,
  {     0,  5986,  8019,  13,   8, UNI_NV__2_SLASH_3 }   /* numericvalue=6.67e-01 */,
  {  2306,  9277,  9700,   3,   4, UNI_OLCK }   /* sc=olck */,
  {  2184,  9488,   349,   4,  33, UNI_SUPSYMBOLSANDPICTOGRAPHS }   /* blk=supplementalsymbolsandpictographs */,
  {     3,  5324,  8479,   4,   5, UNI_INMAKASAR }   /* inmakasar */,
  {     1,  9277,  9500,   3,   4, UNI_SC__CAKM }   /* sc=cakm */,
  {     2,  3836,  1176,  18,   3, UNI_SORA }   /* scriptextensions=sora */,
  {     0,  8589,  7292,   8,   3, UNI_SC__SOGD }   /* script=sogd */,
  {     0,  3836,  9038,  17,   6, UNI_YEZI }   /* scriptextensions=yezidi */,
  {     0,  5791,  5944,  13,   3, UNI_JG__WAW }   /* joininggroup=waw */,
  {    22,  6505,     0,  12,   0, UNI_PHAISTOS }   /* phaistosdisc */,
  {     9,  8858,  9255,   6,   5, -UNI_ECOMP }   /* ecomp=false */,
  {     1,  9020,  9836,   6,   4, UNI_XPOSIXUPPER }   /* upper=true */,
  {   355,  2760,   911,  19,   1, UNI_GCB__V }   /* hangulsyllabletype=v */,
  {     0,  1417,  8010,  24,   2, UNI_CCC__36 }   /* canonicalcombiningclass=36 */,
  {     0,  9277,  9820,   3,   4, UNI_TFNG }   /* sc=tfng */,
  {     1,  1537,  6983,  24,  11, UNI_INPC__TOPANDRIGHT }   /* indicpositionalcategory=topandright */,
  {     0,  9277,     8,   4,   3, UNI_SC__KANA }   /* sc=kana */,
  {     1,   184,  4718,   2,  15, UNI_LOWERCASELETTER }   /* islowercaseletter */,
  {     1,  2529,     0,   4,   0, UNI_TERM }   /* term */,
  {    90,  9768,  5171,   4,   4, UNI_CHAM }   /* scx=cham */,
  {  1157,  8589,  3079,   7,   4, UNI_SC__COPT }   /* script=copt */,
  {  1116,  9488,  2931,   4,  19, UNI_SUPARROWSA }   /* blk=supplementalarrowsa */,
  {     1,  8589,  4928,   7,   5, UNI_SC__TAML }   /* script=tamil */,
  {  2148,  4598,     0,  15,   0, UNI_DIACRITICALSEXT }   /* diacriticalsext */,
  {    10,  9277,  8652,   3,   7, UNI_TAVT }   /* sc=taiviet */,
  {     0,  9277,  6181,   3,  12, UNI_SC__GONG }   /* sc=gunjalagondi */,
  {   531,  9277,  4448,   3,   5, UNI_BAMU }   /* sc=bamum */,
  {    49,  6420,  9316,   3,   4, UNI_INORIYA }   /* inoriya */,
  {     1, 10048,  7859,   3,   8, UNI_NV__20000000 }   /* nv=20000000 */,
  {     0, 10048,  7851,   3,   8, UNI_NV__1_SLASH_40 }   /* nv=2.50e-02 */,
  {     6,  9768,  8786,   4,   6, UNI_CARI }   /* scx=carian */,
  {     1,  5986,  7814,  13,   1, UNI_NV__7 }   /* numericvalue=7 */,
  {     1,  4033,  3277,  16,  18, UNI_PI }   /* generalcategory=initialpunctuation */,
  {     0,  4916,  4386,   3,  15, UNI_TANGUTCOMPONENTS }   /* istangutcomponents */,
  {   253,  8652,     0,   7,   0, UNI_TAVT }   /* taiviet */,
  {     0,  9488,   908,   4,  14, UNI_PUA }   /* blk=privateusearea */,
  {     0, 10288, 10303,   8,   5, UNI_XPOSIXBLANK }   /* isxposixblank */,
  {     0, 10048,  7763,   3,   8, UNI_NV__1_SLASH_8 }   /* nv=1.25e-01 */,
  {    26,  9488,  3421,   4,   4, UNI_RUMI }   /* blk=rumi */,
  {     4,  9488,  4928,   4,   8, UNI_TAMILSUP }   /* blk=tamilsup */,
  {  1540,  7088,  3313,  10,  18, UNI_BC__LRI }   /* bidiclass=lefttorightisolate */,
  {     0,  3151, 10135,  18,   3, UNI_EPRES }   /* emojipresentation=yes */,
  {     0,  4033,  2268,  16,   2, UNI_PD }   /* generalcategory=pd */,
  {  2343,  4113,  4974,   3,  14, UNI_VEDICEXT }   /* invedicextensions */,
  {   100,  9768,  8936,   4,   4, UNI_LYCI }   /* scx=lyci */,
  {     0,  3836,  8291,  17,   8, UNI_TAGB }   /* scriptextensions=tagbanwa */,
  {     0,   467,     0,  11,   0, UNI_P }   /* punctuation */,
  {    17, 10048,  8710,   3,   3, UNI_NV__600 }   /* nv=600 */,
  {     0,  3836,  8421,  17,   4, UNI_ELYM }   /* scriptextensions=elym */,
  {    66,  8589,  8924,   7,   4, UNI_LEPC }   /* script=lepc */,
  {     2,  9230,     1,   5,   1, -UNI_CWCF }   /* cwcf=n */,
  {     6,  9488,  8617,   4,   7, UNI_INSOYOMBO }   /* blk=soyombo */,
  {     0,  2608,     0,   6,   0, UNI_BRAH }   /* brahmi */,
  {   357,   184,  6829,   2,  11, UNI_MYANMAREXTB }   /* ismyanmarextb */,
  {  2136,  9444,  9982,   4,   3, UNI_AGE__6_DOT_3 }   /* age=6.3 */,
  {  1655,  9768,  9688,   4,   3, UNI_NKO }   /* scx=nko */,
  {  1541,  1417,  7890,  24,   2, UNI_CCC__33 }   /* canonicalcombiningclass=33 */,
  {     1,  8774,     0,   6,   0, UNI_bidim_values_index }   /* bidim= */,
  {     0,  9768,  9245,   4,   5, UNI_DOGR }   /* scx=dogra */,
  {    12,  9508,  9108,   4,   2, UNI_CCC__15 }   /* ccc=15 */,
  {     0, 10027,  9784,   3,   4, UNI_JG__SHIN }   /* jg=shin */,
  {   280,  8589,  8659,   7,   7, UNI_TIBT }   /* script=tibetan */,
  {    17, 10033,  1822,   3,   2, UNI_LB__NL }   /* lb=nl */,
  {     1,  3904,  1025,  17,   2, -UNI_UIDEO }   /* unifiedideograph=no */,
  {   227, 10048,  9988,   3,   3, UNI_NV__7_SLASH_8 }   /* nv=7/8 */,
  {     0,  9768,  3025,   4,   4, UNI_CHER }   /* scx=cher */,
  {     2,  3836,  9652,  17,   4, UNI_MERC }   /* scriptextensions=merc */,
  {     0,  1417,    18,  24,   1, UNI_CCC__R }   /* canonicalcombiningclass=r */,
  {     1,  3836,  8219,  17,   8, UNI_JAVA }   /* scriptextensions=javanese */,
  {     0,  4989,   513,   3,  15, UNI_UIDEO }   /* isunifiedideograph */,
  {     3,   184,  4478,   2,   4, UNI_BRAI }   /* isbrai */,
  {    17,   184,  5158,   2,  14, UNI_INGREEK }   /* isgreekandcoptic */,
  {   304,  3836,  7428,  17,  10, UNI_WARA }   /* scriptextensions=warangciti */,
  {   832,  2779,  9836,  19,   4, UNI_IDST }   /* idstrinaryoperator=true */,
  {   192,  9768,  9285,   4,   4, UNI_LIMB }   /* scx=limb */,
  {     5,  3853,     0,  17,   0, UNI_sterm_values_index }   /* sentenceterminal= */,
  {     0, 10024,  3985,   3,  16, UNI_PE }   /* gc=closepunctuation */,
  {     0,  7088,  5494,  10,  14, UNI_BC__NSM }   /* bidiclass=nonspacingmark */,
  {  1232,  4542,  3243,   4,  16, UNI_GEORGIANSUP }   /* ingeorgiansupplement */,
  {  1026,  8780,  8211,   6,   8, UNI_JAMOEXTB }   /* block=jamoextb */,
  {     8,  9556,  1910,   4,   2, UNI_GCB__CN }   /* gcb=cn */,
  {     1,  3133,     3,  18,   1, -UNI_EBASE }   /* emojimodifierbase=f */,
  {     0,  8589,  8912,   7,   4, UNI_SC__KHOJ }   /* script=khoj */,
  {     0,   184,  8470,   2,   7, UNI_LINA }   /* islineara */,
  {     1,  7218, 10030,  10,   2, UNI_GCB__T }   /* linebreak=jt */,
  {   136, 10291,  3379,   5,   5, UNI_POSIXSPACE }   /* posixspace */,
  {    26,  4116,  4704,   3,  14, UNI_ARMI }   /* isimperialaramaic */,
  {     0,  5592,     0,  14,   0, UNI_ZS }   /* spaceseparator */,
  {    39, 10048,  7468,   3,   9, UNI_NV___MINUS_1_SLASH_2 }   /* nv=-5.00e-01 */,
  {  2405,  8984,  9255,   6,   5, -UNI_QMARK }   /* qmark=false */,
  {     1,  8589,  9880,   7,   4, UNI_SC__YI }   /* script=yiii */,
  {     0,    21,  6730,   2,  11, UNI_KATAKANAEXT }   /* inkatakanaext */,
  {   776,   184,  8477,   2,   7, UNI_MAKA }   /* ismakasar */,
  {     1,  2224,  2288,   3,  20, UNI_SINHALAARCHAICNUMBERS }   /* insinhalaarchaicnumbers */,
  {  1540, 10296,  8583,   3,   6, UNI_PHAG }   /* isphagspa */,
  {    19,  9508,  8793,   5,   4, UNI_CCC__10 }   /* ccc=ccc10 */,
  {     0,  9270,  5551,   3,  13, UNI_INPSALTERPAHLAVI }   /* inpsalterpahlavi */,
  {    36,  2032,  1025,  22,   2, -UNI__PERL_NCHAR }   /* noncharactercodepoint=no */,
  {    23,  9488,  4145,   4,  16, UNI_LINEARBIDEOGRAMS }   /* blk=linearbideograms */,
  {   617,  3379,    26,   6,   1, UNI_XPOSIXSPACE }   /* space=y */,
  {   137,   184,  2912,   2,  19, UNI_SUNDANESESUP }   /* issundanesesupplement */,
  {   770,  9508,  2809,   4,   2, UNI_CCC__1 }   /* ccc=ov */,
  {     0,  1417,  9116,  25,   4, UNI_CCC__17 }   /* canonicalcombiningclass=ccc17 */,
  {   271,  5986,  7907,  13,   8, UNI_NV__3_SLASH_8 }   /* numericvalue=3.75e-01 */,
  {  1028,  8780,  4554,   7,  14, UNI_CONTROLPICTURES }   /* block=controlpictures */,
  {   400,  8780,  8421,   6,   7, UNI_INELYMAIC }   /* block=elymaic */,
  {     0,  9270,  2449,   5,   4, UNI_INPC__LEFT }   /* inpc=left */,
  {     0,  8688,  9066,   3,   4, UNI_ADLM }   /* isadlam */,
  {     0,  8589,  9748,   7,   4, UNI_RJNG }   /* script=rjng */,
  {     0,  9230,  9255,   5,   5, -UNI_CWCF }   /* cwcf=false */,
  {     3,  5116,  9255,  14,   5, -UNI_EMOD }   /* emojimodifier=false */,
  {   259,  5578,    49,  14,   2, UNI_SB__AT }   /* sentencebreak=at */,
  {     0,  9277,  7621,   3,   9, UNI_NBAT }   /* sc=nabataean */,
  {     2,   184,  3098,   2,   5, UNI_ECOMP }   /* isecomp */,
  {    36,  3836,  9872,  17,   4, UNI_XPEO }   /* scriptextensions=xpeo */,
  {  1808, 10027,  2223,   3,   3, UNI_JG__AIN }   /* jg=ain */,
  {     0,  4116,  3735,   3,  16, UNI_INDICSIYAQNUMBERS }   /* isindicsiyaqnumbers */,
  {     0, 10033,  2640,   3,   2, UNI_LB__BA }   /* lb=ba */,
  {     0, 10346,  8682,   4,   5, UNI_ZZZZ }   /* isunknown */,
  {     1,  9277,  9560,   3,   4, UNI_SC__GONG }   /* sc=gong */,
  {    14,  5508,     1,  14,   1, -UNI_PATSYN }   /* patternsyntax=n */,
  {     1, 10009,  8163,   3,   8, UNI_DT__FRA }   /* dt=fraction */,
  {    13,  8589,   382,   7,   4, UNI_EGYP }   /* script=egyp */,
  {     0,  2182,  5746,  21,   5, UNI_WB__EB }   /* graphemeclusterbreak=ebase */,
  {   542,   184,  7368,   2,  10, UNI_SMALLFORMS }   /* issmallforms */,
  {     0,  9240,     1,   5,   1, -UNI_DASH }   /* dash=n */,
  {     0,  3836,  6840,  17,   4, UNI_NAND }   /* scriptextensions=nand */,
  {     0,  9277,  6840,   3,  11, UNI_SC__NAND }   /* sc=nandinagari */,
  {     0,  8780,  1723,   6,  23, UNI_SUPPUNCTUATION }   /* block=supplementalpunctuation */,
  {     0,  9492,    17,   4,   1, UNI_BPT__O }   /* bpt=o */,
  {     1,  3600,     0,   4,   0, UNI_UCAS }   /* ucas */,
  {   329,  5578,   495,  14,   2, UNI_SB__NU }   /* sentencebreak=nu */,
  {     0,  8780, 10051,   6,   3, UNI_OCR }   /* block=ocr */,
  {  1295, 10296,  6506,   3,   7, UNI_PHAISTOS }   /* isphaistos */,
  {    72,  3836,  9804,  17,   4, UNI_TALE }   /* scriptextensions=tale */,
  {     0, 10027,  5396,   3,  14, UNI_JG__MANICHAEANRESH }   /* jg=manichaeanresh */,
  {     4, 10048,  9904,   3,   3, UNI_NV__1_SLASH_5 }   /* nv=1/5 */,
  {  2184,   133,     0,   4,   0, UNI_M }   /* mark */,
  {     1,   184,  6609,   2,  10, UNI_DEP }   /* isdeprecated */,
  {    76,  4688,  6433,  15,  12, UNI_IDENTIFIERTYPE__NOTCHARACTER }   /* identifiertype=notcharacter */,
  {     0,  2224,  1295,   3,  24, UNI_SUPERANDSUB }   /* insuperscriptsandsubscripts */,
  {     0,  9277,  3115,   3,  10, UNI_SC__DEVA }   /* sc=devanagari */,
  {     0,  2224,  7379,   3,   9, UNI_SUPARROWSA }   /* insuparrowsa */,
  {     0, 10048,  8027,   3,   8, UNI_NV__15_SLASH_2 }   /* nv=7.50e+00 */,
  {    12,  1552,    44,  10,   1, UNI_SK }   /* category=sk */,
  {     0,   184,  2560,   2,   4, UNI_MAND }   /* ismand */,
  {     0,  9508,     8,   4,   1, UNI_CCC__A }   /* ccc=a */,
  {   261,  6385,     0,  12,   0, UNI_GONM }   /* masaramgondi */,
  {     1,  8780,  1393,   6,  24, UNI_ARABICPFB }   /* block=arabicpresentationformsb */,
  {    62,  1417,  8568,  24,   7, UNI_CCC__1 }   /* canonicalcombiningclass=overlay */,
  {   386,  5986,  7754,  13,   2, UNI_NV__11 }   /* numericvalue=11 */,
  {     0,  9628,     0,   4,   0, UNI_LATN }   /* latn */,
  {     0,  9275,  5634,   5,  14, UNI_INSC__VOWELDEPENDENT }   /* insc=voweldependent */,
  {     0,  9444, 10114,   4,   3, UNI_AGE__6_DOT_3 }   /* age=v63 */,
  {   139,  8780,  2608,   6,   6, UNI_INBRAHMI }   /* block=brahmi */,
  {     0,  8780,  4289,   6,  16, UNI_MYANMAREXTB }   /* block=myanmarextendedb */,
  {    91, 10060,     3,   3,   1, -UNI_RI }   /* ri=f */,
  {    74,  8589,  9824,   7,   4, UNI_SC__TGLG }   /* script=tglg */,
  {    15,  9277,  3753,   5,  15, UNI_KITS }   /* sc=khitansmallscript */,
  {     0,  9676,     0,   4,   0, UNI_NARB }   /* narb */,
  {     1,  2784,  7060,   4,   8, UNI_ARABICEXTA }   /* inarabicexta */,
  {     6,  8589,  9876,   7,   4, UNI_XSUX }   /* script=xsux */,
  {     0,  2280,  7280,   4,   8, UNI_XPEO }   /* isoldpersian */,
  {     0,   184,  5674,   2,  12, UNI_BIDIM }   /* isbidimirrored */,
  {  1305,  8894,     3,   6,   1, -UNI_JOINC }   /* joinc=f */,
  {    13,  5791,  6337,  13,  12, UNI_JG__MALAYALAMNYA }   /* joininggroup=malayalamnya */,
  {   798,   184,  1631,   2,  15, UNI_GEOMETRICSHAPES }   /* isgeometricshapes */,
  {     1,  1188,  4386,   3,  15, UNI_TANGUTCOMPONENTS }   /* intangutcomponents */,
  {   513, 10033,  1527,   3,   9, UNI_LB__SG }   /* lb=surrogate */,
  {     5,   184,  7119,   3,   9, UNI_CHRS }   /* ischorasmian */,
  {   224,  9712,     0,   4,   0, UNI_OSGE }   /* osge */,
  {     0,  8267,  9836,   8,   4, UNI_RADICAL }   /* radical=true */,
  {    59,  9768,  6973,   5,  10, UNI_SYLO }   /* scx=sylotinagri */,
  {     1,  8780,   218,   7,  32, UNI_DIACRITICALSEXT }   /* block=combiningdiacriticalmarksextended */,
  {   608,  5986,  9976,  13,   3, UNI_NV__5_SLASH_8 }   /* numericvalue=5/8 */,
  {     2,  5986,  9360,  13,   4, UNI_NV___MINUS_1_SLASH_2 }   /* numericvalue=-1/2 */,
  {   705, 10024,  5726,   3,  13, UNI_ME }   /* gc=enclosingmark */,
  {    82,  8589,  4149,   8,   3, UNI_SARB }   /* script=sarb */,
  {     0,  7418,    36,  10,   1, UNI_XPOSIXUPPER }   /* uppercase=t */,
  {     0,  5791,  8918,  13,   6, UNI_JG__LAMADH }   /* joininggroup=lamadh */,
  {   514,  8589,  8107,   7,   8, UNI_BALI }   /* script=balinese */,
  {     0,  2161,  9836,  21,   4, UNI_EXTPICT }   /* extendedpictographic=true */,
  {    64,  3836,  8187,  17,   4, UNI_HIRA }   /* scriptextensions=hira */,
  {    16,  9488,  7239,   4,   2, UNI_INVS }   /* blk=vs */,
  {  1616,  8589,  7428,   7,  10, UNI_WARA }   /* script=warangciti */,
  {     0, 10288,    62,   8,   5, UNI_XPOSIXGRAPH }   /* isxposixgraph */,
  {     1,  3379,     0,   6,   0, UNI_wspace_values_index }   /* space= */,
  {  1042,  4658,     0,  15,   0, UNI_grext_values_index }   /* graphemeextend= */,
  {     1, 10048,  9379,   3,   2, UNI_NV__41 }   /* nv=41 */,
  {     5,  2280,   262,   3,   3, UNI_OSMA }   /* isosma */,
  {     0,  1966,  4913,  22,  15, UNI_INSC__REGISTERSHIFTER }   /* indicsyllabiccategory=registershifter */,
  {     0,  1812,     3,  22,   1, -UNI_CWL }   /* changeswhenlowercased=f */,
  {     0,   184,    27,   2,   2, UNI_LOWERCASELETTER }   /* isll */,
  {     0,  8780,  1879,   7,  21, UNI_CJKCOMPATIDEOGRAPHSSUP }   /* block=cjkcompatideographssup */,
  {     0, 10048,  9412,   3,   4, UNI_NV__17_SLASH_2 }   /* nv=17/2 */,
  {     0,  9262,   866,   3,   2, UNI_SB__SP }   /* sb=sp */,
  {    37,  4838,    47,  15,   1, UNI_NFCQC__M }   /* nfkcquickcheck=m */,
  {   224,  8589,  9664,   7,   4, UNI_MRO }   /* script=mroo */,
  {     1,  9488,   689,   4,  30, UNI_CJKEXTG }   /* blk=cjkunifiedideographsextensiong */,
  {     1,   184,  9285,   2,   5, UNI_LIMB }   /* islimbu */,
  {    17,  5986,  7806,  13,   1, UNI_NV__6 }   /* numericvalue=6 */,
  {     0,  7540,    26,   9,   1, UNI_EXT }   /* extender=y */,
  {   607,  9277,  9320,   3,   5, UNI_OSGE }   /* sc=osage */,
  {     2,  9768,  8618,   5,   6, UNI_SOYO }   /* scx=soyombo */,
  {     0,  5746,    36,   6,   1, UNI_EBASE }   /* ebase=t */,
  {     0,  3836,  8990,  17,   6, UNI_RJNG }   /* scriptextensions=rejang */,
  {     5,  9768,  9696,   4,   4, UNI_OGAM }   /* scx=ogam */,
  {     4,  3374,     3,  11,   1, -UNI_XPOSIXSPACE }   /* whitespace=f */,
  {    12,   184,  1901,   3,   5, UNI_ZYYY }   /* iscommon */,
  {   546, 10296,  7685,   3,   8, UNI_PAUC }   /* ispaucinhau */,
  {     0,  6469,  5904,  12,   4, UNI_NV__NAN }   /* numerictype=none */,
  {    80,  9277,  4793,   3,  15, UNI_MERC }   /* sc=meroiticcursive */,
  {   128,  8780,  6554,   6,   3, UNI_INIDC }   /* block=idc */,
  {     2,  9444,  7979,   4,   3, UNI_AGE__6 }   /* age=6.0 */,
  {     0,  1269,     0,  25,   0, UNI_compex_values_index }   /* fullcompositionexclusion= */,
  {  1040,  9277,  8464,   4,   6, UNI_SC__KALI }   /* sc=kayahli */,
  {     1,  1417,  9203,  24,   2, UNI_CCC__34 }   /* canonicalcombiningclass=34 */,
  {    29,  3836,  6181,  17,  12, UNI_GONG }   /* scriptextensions=gunjalagondi */,
  {     0,  3151,     1,  18,   1, -UNI_EPRES }   /* emojipresentation=n */,
  {    45,  5791,  6373,  13,  12, UNI_JG__MANICHAEANPE }   /* joininggroup=manichaeanpe */,
  {     0,  2224,  8611,   3,   6, UNI_INSIDDHAM }   /* insiddham */,
  {    24,  6061,     1,  12,   1, -UNI_BIDIC }   /* bidicontrol=n */,
  {     4,   184,  6505,   2,  12, UNI_PHAISTOS }   /* isphaistosdisc */,
  {     0,  5986,  9405,  13,   3, UNI_NV__3_SLASH_2 }   /* numericvalue=3/2 */,
  {     0,  1552,  4568,   9,  14, UNI_SC }   /* category=currencysymbol */,
  {    80, 10333,  9789,   3,   3, UNI_SHRD }   /* isshrd */,
  {     3,  9275,  3615,   5,  17, UNI_INSC__CONSONANTPREFIXED }   /* insc=consonantprefixed */,
  {     0,  9508,  7930,   4,   2, UNI_CCC__14 }   /* ccc=14 */,
  {     0,  9277,  6409,   3,  12, UNI_MEND }   /* sc=mendekikakui */,
  {    33,  9277,  9576,   3,   4, UNI_SC__GURU }   /* sc=guru */,
  {     0,  4916,  4929,   3,   7, UNI_TAMILSUP }   /* istamilsup */,
  {    18,  9488,  3938,   5,  10, UNI_BOPOMOFOEXT }   /* blk=bopomofoext */,
  {    19,   184,  2608,   2,   4, UNI_BRAH }   /* isbrah */,
  {     1,  9488,  8900,   4,   6, UNI_INKAITHI }   /* blk=kaithi */,
  {     0,  5791,  6950,  13,  11, UNI_JG__STRAIGHTWAW }   /* joininggroup=straightwaw */,
  {    16,  9262,  1867,   3,   5, UNI_SB__UP }   /* sb=upper */,
  {     2,  4916,  8667,   3,   6, UNI_TIRH }   /* istirhuta */,
  {     3,  8267,  9255,   8,   5, -UNI_RADICAL }   /* radical=false */,
  {  2185,  9488,  4129,   4,   6, UNI_LATIN1 }   /* blk=latin1 */,
  {   986,   184,  2099,   3,  20, UNI_CJKCOMPATFORMS }   /* iscjkcompatibilityforms */,
  {   680,  3901,  8181,   4,   6, UNI_INGURMUKHI }   /* ingurmukhi */,
  {  1185,  1188,  8584,   3,   3, UNI_TAGS }   /* intags */,
  {   242,  9768,  8604,   5,   6, UNI_SHAW }   /* scx=shavian */,
  {     0,   184,  3576,   3,   2, UNI_CWL }   /* iscwl */,
  {     0,  1417,  9925,  24,   3, UNI_CCC__BL }   /* canonicalcombiningclass=218 */,
  {   436,  3836,  6385,  17,  12, UNI_GONM }   /* scriptextensions=masaramgondi */,
  {     0,   184,  9568,   2,   4, UNI_GREK }   /* isgrek */,
  {     6,  4542,  4051,   4,   9, UNI_GEORGIANEXT }   /* ingeorgianext */,
  {     0,  3836,  9032,  17,   6, UNI_WCHO }   /* scriptextensions=wancho */,
  {     0,  4688,  8972,  15,   6, UNI_IDENTIFIERTYPE__NOTXID }   /* identifiertype=notxid */,
  {     1,  9520, 10135,   4,   3, UNI_CWL }   /* cwl=yes */,
  {   232,   184,  1823,   2,   5, UNI_XPOSIXLOWER }   /* islower */,
  {     2,   184,  6265,   2,  12, UNI_NL }   /* isletternumber */,
  {   462,  9508,  9952,   4,   3, UNI_CCC__IS }   /* ccc=240 */,
  {   133,  3836,  8470,  17,   7, UNI_LINA }   /* scriptextensions=lineara */,
  {   164,  9716,  9255,   4,   5, -UNI_PCM }   /* pcm=false */,
  {  1876, 10333,  1537,   3,   3, UNI_SIND }   /* issind */,
  {     0,  9508,  8805,   5,   4, UNI_CCC__11 }   /* ccc=ccc11 */,
  {     3,  8589,  4478,   7,   7, UNI_BRAI }   /* script=braille */,
  {    17,  9508,  8819,   4,   3, UNI_CCC__129 }   /* ccc=129 */,
  {     1,  3349,     0,  18,   0, UNI_ZP }   /* paragraphseparator */,
  {  2098,  8780,  4385,   6,   6, UNI_INTANGUT }   /* block=tangut */,
  {     0, 10027, 10021,   3,   3, UNI_JG__GAF }   /* jg=gaf */,
  {     0,  7218,  5999,  10,  13, UNI_LB__PR }   /* linebreak=prefixnumeric */,
  {    49,  1417,  9111,  25,   4, UNI_CCC__16 }   /* canonicalcombiningclass=ccc16 */,
  {    45,  2779,  1025,  19,   2, -UNI_IDST }   /* idstrinaryoperator=no */,
  {     0,  5324,  5949,   4,  11, UNI_MAYANNUMERALS }   /* inmayannumerals */,
  {   216,  7218,  1465,  10,  13, UNI_LB__CM }   /* linebreak=combiningmark */,
  {  1408,  4337,     0,  16,   0, UNI_SUPMATHOPERATORS }   /* supmathoperators */,
  {     0,  1552,  2349,   9,  20, UNI_PC }   /* category=connectorpunctuation */,
  {     0,  8930,    36,   6,   1, UNI_XPOSIXLOWER }   /* lower=t */,
  {     0,  5578,   751,  14,   5, UNI_SB__CL }   /* sentencebreak=close */,
  {     0,  5791,     0,  13,   0, UNI_jg_values_index }   /* joininggroup= */,
  {     8,   184,  2912,   2,  12, UNI_SUNDANESESUP }   /* issundanesesup */,
  {  1363,  5494,     0,  14,   0, UNI_MN }   /* nonspacingmark */,
  {     0,  9488,  8491,   4,   7, UNI_INMARCHEN }   /* blk=marchen */,
  {     0,  3836,  6973,  18,   3, UNI_SYLO }   /* scriptextensions=sylo */,
  {     0,  7388,     0,  10,   0, UNI_SUPARROWSB }   /* suparrowsb */,
  {   927,  9768,  9756,   4,   4, UNI_RUNR }   /* scx=runr */,
  {     0,  3151,  9255,  18,   5, -UNI_EPRES }   /* emojipresentation=false */,
  {     0,  6420,  8562,   3,   6, UNI_INOSMANYA }   /* inosmanya */,
  {     5,  9488,  1006,   4,  17, UNI_ANCIENTGREEKMUSIC }   /* blk=ancientgreekmusic */,
  {     0,  9556, 10015,   4,   3, UNI_WB__EB }   /* gcb=ebg */,
  {     0,  8780,   867,   6,  18, UNI_PHONETICEXT }   /* block=phoneticextensions */,
  {     0,  3836,  9644,  17,   4, UNI_MEDF }   /* scriptextensions=medf */,
  {     0,  5986,  7931,  13,   8, UNI_NV__5_SLASH_12 }   /* numericvalue=4.17e-01 */,
  {     0,  9275,   728,   5,   6, UNI_INSC__NUMBER }   /* insc=number */,
  {     1,  5986,  8720,  13,   5, UNI_NV__40000 }   /* numericvalue=40000 */,
  {   769,  5791,  5934,  13,  13, UNI_JG__MANICHAEANWAW }   /* joininggroup=manichaeanwaw */,
  {  2308,  3836,  5003,  17,  15, UNI_ZANB }   /* scriptextensions=zanabazarsquare */,
  {    10,  2784,  1371,   4,  22, UNI_ARABICPFA }   /* inarabicpresentationformsa */,
  {     0,  9492,     1,   4,   1, UNI_BPT__N }   /* bpt=n */,
  {     1,  9780,     0,   4,   0, UNI_SHAW }   /* shaw */,
  {    40,  7076,  1586,   3,  13, UNI_BYZANTINEMUSIC }   /* inbyzantinemusic */,
  {     0,  9488,  9096,   5,   4, UNI_INBUHID }   /* blk=buhid */,
  {  1364,  8589,  2560,   7,   4, UNI_SC__MAND }   /* script=mand */,
  {   541,  2280,  7668,   4,   7, UNI_ORKH }   /* isoldturkic */,
  {    11, 10048,  9372,   3,   3, UNI_NV__1_SLASH_4 }   /* nv=1/4 */,
  {     0,  3836,  9608,  17,   4, UNI_KITS }   /* scriptextensions=kits */,
  {     1,  9277,  7651,   3,   4, UNI_ITAL }   /* sc=ital */,
  {     0,  8780,  8171,   6,   8, UNI_INGUJARATI }   /* block=gujarati */,
  {     4, 10027,  4763,   3,  15, UNI_JG__MANICHAEANSADHE }   /* jg=manichaeansadhe */,
  {  2560,  8780,  3421,   6,  18, UNI_RUMI }   /* block=ruminumeralsymbols */,
  {   691, 10027,  5918,   3,   3, UNI_JG__TAW }   /* jg=taw */,
  {     1, 10024,  5040,   3,   5, UNI_XPOSIXDIGIT }   /* gc=digit */,
  {     0,  8780,  1922,   6,  22, UNI_DIACRITICALSFORSYMBOLS }   /* block=diacriticalsforsymbols */,
  {     7,  9768,  9460,   4,   4, UNI_ARMI }   /* scx=armi */,
  {     0,  9768,  2329,   4,  20, UNI_HLUW }   /* scx=anatolianhieroglyphs */,
  {   786,  1552,  5726,   9,  13, UNI_ME }   /* category=enclosingmark */,
  {     5,  8267,     3,   8,   1, -UNI_RADICAL }   /* radical=f */,
  {  3779,  8780,  1369,   6,  24, UNI_ARABICPFA }   /* block=arabicpresentationformsa */,
  {     0,  7438,   400,  10,   6, UNI_WB__FO }   /* wordbreak=format */,
  {  1028,  7218,  1527,  10,   9, UNI_LB__SG }   /* linebreak=surrogate */,
  {     0,  9768,  9656,   4,   4, UNI_MIAO }   /* scx=miao */,
  {     0,  9277,  9285,   3,   4, UNI_SC__LIMB }   /* sc=limb */,
  {    21,  9444, 10105,   4,   3, UNI_AGE__6 }   /* age=v60 */,
  {     0,  4448,     0,  15,   0, UNI_BAMUMSUP }   /* bamumsupplement */,
  {   404,   184,  9245,   2,   5, UNI_DOGR }   /* isdogra */,
  {     0,  3169,     0,  11,   0, UNI_ETHIOPICSUP }   /* ethiopicsup */,
  {   833,   184,  4448,   2,  15, UNI_BAMUMSUP }   /* isbamumsupplement */,
  {     0,  9488,  2722,   4,  10, UNI_JAMO }   /* blk=hanguljamo */,
  {    11,  9696,     0,   4,   0, UNI_OGAM }   /* ogam */,
  {  1713,  8589,  9335,   7,   4, UNI_SC__TAKR }   /* script=takr */,
  {     5, 10060,  9836,   3,   4, UNI_RI }   /* ri=true */,
  {     0,  8780,  7068,   6,  10, UNI_ASCII }   /* block=basiclatin */,
  {    16,  9796,     0,   4,   0, UNI_SYRC }   /* syrc */,
  {  1097,  6576,     1,  11,   1, -UNI_XPOSIXALPHA }   /* alphabetic=n */,
  {     0,  4033, 10168,  16,   2, UNI_CASEDLETTER }   /* generalcategory=l& */,
  {     0,  7076,  3938,   3,   7, UNI_INBOPOMOFO }   /* inbopomofo */,
  {     0,  8780,  3796,   7,   3, UNI_INCHAM }   /* block=cham */,
  {    18,   184,  6884,   2,  11, UNI_HMNG }   /* ispahawhhmong */,
  {  1061,  8147,     1,   8,   1, -UNI_EXTPICT }   /* extpict=n */,
  {  1898, 10296,   472,   3,   2, UNI_PUA }   /* ispua */,
  {     1,  9786,  1702,   4,  21, UNI_SHORTHANDFORMATCONTROLS }   /* inshorthandformatcontrols */,
  {  1921,  8780,  1442,   7,  23, UNI_CJKSYMBOLS }   /* block=cjksymbolsandpunctuation */,
  {     5,  4808,     0,  15,   0, UNI_MISCPICTOGRAPHS }   /* miscpictographs */,
  {     0,  1966,  1244,  22,  25, UNI_INSC__CONSONANTINITIALPOSTFIXED }   /* indicsyllabiccategory=consonantinitialpostfixed */,
  {   576,  5986,  8756,  13,   4, UNI_NV__9000 }   /* numericvalue=9000 */,
  {     2,  8780,  8380,   7,   6, UNI_CJKEXTE }   /* block=cjkexte */,
  {     0,  9488,   316,   4,  33, UNI_SUPMATHOPERATORS }   /* blk=supplementalmathematicaloperators */,
  {   243,  9488,   659,   4,  30, UNI_CJKEXTF }   /* blk=cjkunifiedideographsextensionf */,
  {     0,   184,  9664,   2,   4, UNI_MRO }   /* ismroo */,
  {     0,  9488,  3439,   4,  12, UNI_SMALLKANAEXT }   /* blk=smallkanaext */,
  {   184,   184,  6253,   2,  12, UNI_KHMERSYMBOLS }   /* iskhmersymbols */,
  {   476,  3836,  7278,  17,  10, UNI_XPEO }   /* scriptextensions=oldpersian */,
  {     0,  8666,     0,   4,   0, UNI_TIRH }   /* tirh */,
  {   224,   184,  2409,   2,  20, UNI_GLAGOLITICSUP }   /* isglagoliticsupplement */,
  {   626,  8589,  5284,   7,   4, UNI_LISU }   /* script=lisu */,
  {    20,  2280,  1061,   3,  26, UNI_OCR }   /* isopticalcharacterrecognition */,
  {   568,  9277,  8299,   3,   8, UNI_TFNG }   /* sc=tifinagh */,
  {     0,  6205, 10135,  12,   3, UNI_IDEO }   /* ideographic=yes */,
  {     0,  5713,     0,  13,   0, UNI_XPOSIXDIGIT }   /* decimalnumber */,
  {     0,    21,  7576,   2,   9, UNI_LATINEXTB }   /* inlatinextb */,
  {  3194, 10048,  8720,   3,   2, UNI_NV__40 }   /* nv=40 */,
  {     0,  5791,  5921,  13,  13, UNI_JG__MANICHAEANTEN }   /* joininggroup=manichaeanten */,
  {     4,  6231,  4560,   9,   8, UNI_CONTROLPICTURES }   /* incontrolpictures */,
  {  1284,  8768, 10135,   6,   3, UNI_BIDIC }   /* bidic=yes */,
  {  3068,  2268,     0,   2,   0, UNI_PD }   /* pd */,
  {     0,  6553,  1025,  12,   2, -UNI_XIDC }   /* xidcontinue=no */,
  {    14,   184,   132,   2,   2, UNI_LM }   /* islm */,
  {     8,  8589,  6481,   7,  12, UNI_HUNG }   /* script=oldhungarian */,
  {     0, 10132,  7612,   3,   6, UNI_WB__MN }   /* wb=midnum */,
  {     0,  4033,  6035,  16,   2, UNI_PF }   /* generalcategory=pf */,
  {     4,  9520,    26,   4,   1, UNI_CWL }   /* cwl=y */,
  {     1,  5986,  7469,  13,   1, UNI_NV__5 }   /* numericvalue=5 */,
  {     0,  9488,  4449,   5,  14, UNI_BAMUMSUP }   /* blk=bamumsupplement */,
  {     4,  8780,   908,   6,  14, UNI_PUA }   /* block=privateusearea */,
  {  2707,  8694,     1,   7,   1, -UNI_XPOSIXSPACE }   /* wspace=n */,
  {   292,  3683,     0,  17,   0, UNI_ETHIOPICEXTA }   /* ethiopicextendeda */,
  {     0,  9768,  8680,   4,   7, UNI_ZZZZ }   /* scx=unknown */,
  {   323,  4791,  2062,   3,  14, UNI_MODIFIERLETTERS }   /* inmodifierletters */,
  {    20,  7028,  7028,   3,  10, UNI_YISYLLABLES }   /* isyisyllables */,
  {     1,  9624,     0,   3,   0, UNI_LAO }   /* lao */,
  {     2,  8870,  9255,   6,   5, -UNI_EPRES }   /* epres=false */,
  {   529,  3836,  7694,  18,   8, UNI_SAMR }   /* scriptextensions=samaritan */,
  {  3055,  9444,  9979,   4,   3, UNI_AGE__6_DOT_1 }   /* age=6.1 */,
  {  3202, 10012,  7486,   3,   9, UNI_EA__A }   /* ea=ambiguous */,
  {     0,  1417,  9208,  24,   2, UNI_CCC__35 }   /* canonicalcombiningclass=35 */,
  {     1,   184,  9688,   2,   3, UNI_NKO }   /* isnko */,
  {     0,  9350, 10135,   5,   3, UNI_XIDS }   /* xids=yes */,
  {   161,  7418,  9836,  10,   4, UNI_XPOSIXUPPER }   /* uppercase=true */,
  {     0,  1552,    47,  10,   1, UNI_SM }   /* category=sm */,
  {     0,  9277,  9568,   3,   4, UNI_SC__GREK }   /* sc=grek */,
  {     0,  8589,  6193,   7,   6, UNI_HEBR }   /* script=hebrew */,
  {  3120,   184,  5550,   2,  14, UNI_PHLP }   /* ispsalterpahlavi */,
  {  1046,  7155,  6321,   3,   3, UNI_HMNG }   /* ishmng */,
  {     0,  8984,    26,   6,   1, UNI_QMARK }   /* qmark=y */,
  {    73,  1218,     0,   8,   0, UNI_KANA }   /* katakana */,
  {     0,  8589,  8344,   7,   4, UNI_SC__BENG }   /* script=beng */,
  {  1289,     7,     0,  18,   0, UNI_CANS }   /* canadianaboriginal */,
  {  1836,  1591,  3170,   3,  17, UNI_ETHIOPICSUP }   /* inethiopicsupplement */,
  {  3201,  5032, 10135,  14,   3, UNI_POSIXXDIGIT }   /* asciihexdigit=yes */,
  {     7,  8449,  1025,   7,   2, -UNI_HYPHEN }   /* hyphen=no */,
  {   136,  9488,  1911,   4,  11, UNI_NUMBERFORMS }   /* blk=numberforms */,
  {  1674,  9508,  7933,   4,   2, UNI_CCC__17 }   /* ccc=17 */,
  {     0,  8512,    47,   7,   1, UNI_NFCQC__M }   /* nfkcqc=m */,
  {   139,  9786,  8605,   4,   5, UNI_SHAW }   /* inshavian */,
  {     0,  6420,  7658,   3,   8, UNI_INOLDPERMIC }   /* inoldpermic */,
  {     0,  1654,     0,   6,   0, UNI_HANG }   /* hangul */,
  {     0,  5578,     0,  16,   0, UNI_SB__SP }   /* sentencebreak=sp */,
  {   332,  4033,  1025,  16,   2, UNI_NO }   /* generalcategory=no */,
  {  2690,  1417,  9218,  24,   2, UNI_CCC__84 }   /* canonicalcombiningclass=84 */,
  {     0,  1189,    11,   3,   2, UNI_NT__DI }   /* nt=di */,
  {    12,  7218,  1140,  10,  26, UNI_LB__CJ }   /* linebreak=conditionaljapanesestarter */,
  {  3801,  6241,  6994,  12,  11, UNI_JT__T }   /* joiningtype=transparent */,
  {     0,  8688,  3548,   3,   9, UNI_ALCHEMICAL }   /* isalchemical */,
  {   816,  6554,  1025,  11,   2, -UNI_IDC }   /* idcontinue=no */,
  {     1, 10176,     0,   2,   0, UNI_ZL }   /* zl */,
  {    24,  9250,     0,   6,   0, -UNI_EMOD }   /* emod=f */,
  {     0,  1790,  9255,  22,   5, -UNI_CWCM }   /* changeswhencasemapped=false */,
  {  2428, 10027,  9744,   3,   4, UNI_JG__QAPH }   /* jg=qaph */,
  {     1,  3853,    26,  17,   1, UNI_STERM }   /* sentenceterminal=y */,
  {  2398,  4542,  3243,   4,   6, UNI_INGEORGIAN }   /* ingeorgian */,
  {   531,   184,  9676,   2,   4, UNI_NARB }   /* isnarb */,
  {    12,  8780,  7693,   6,   9, UNI_INSAMARITAN }   /* block=samaritan */,
  {     5,  1417,  8805,  25,   4, UNI_CCC__11 }   /* canonicalcombiningclass=ccc11 */,
  {     0,  9488,  4369,   4,   9, UNI_SYRIACSUP }   /* blk=syriacsup */,
  {  4367,  8780,  5752,   6,   8, UNI_GREEKEXT }   /* block=greekext */,
  {     0,  1537,  1924,   4,  20, UNI_DIACRITICALSFORSYMBOLS }   /* indiacriticalsforsymbols */,
  {     0,  3836,  8561,  17,   4, UNI_OSMA }   /* scriptextensions=osma */,
  {  3590,  9508,  8811,   5,   4, UNI_CCC__12 }   /* ccc=ccc12 */,
  {  7694,   509,     0,  30,   0, UNI_CJKEXTA }   /* cjkunifiedideographsextensiona */,
  {     0,  8780,  6277,   6,  12, UNI_MAHJONG }   /* block=mahjongtiles */,
  {     4,  5986,  5648,  13,   4, UNI_NV__1000 }   /* numericvalue=1000 */,
  {     0,  2280,  4870,   4,  13, UNI_NARB }   /* isoldnortharabian */,
  {  7122,  8780,  3751,   6,  17, UNI_INKHITANSMALLSCRIPT }   /* block=khitansmallscript */,
  {     5,  9277,  8219,   3,   4, UNI_SC__JAVA }   /* sc=java */
};

MPH_VALt match_uniprop( const unsigned char * const key, const U16 key_len ) {
    const unsigned char * ptr= key;
    const unsigned char * ptr_end= key + key_len;
    U32 h= MPH_SEED1;
    U32 s;
    U32 n;
    do {
        h ^= NATIVE_TO_LATIN1(*ptr);    /* table collated in Latin1 */
        h *= MPH_FNV_CONST;
    } while ( ++ptr < ptr_end );
    n= h % MPH_BUCKETS;
    s = mph_table[n].seed2;
    if (s) {
        h= (h >> MPH_RSHIFT) ^ s;
        n = h % MPH_BUCKETS;
        if (
            ( mph_table[n].pfx_len + mph_table[n].sfx_len == key_len ) &&
            ( memcmp(mph_blob + mph_table[n].pfx, key, mph_table[n].pfx_len) == 0 ) &&
            ( !mph_table[n].sfx_len || memcmp(mph_blob + mph_table[n].sfx,
                key + mph_table[n].pfx_len, mph_table[n].sfx_len) == 0 )
        ) {
            return mph_table[n].value;
        }
    }
    return 0;
}

#endif /* #if defined(PERL_CORE) || defined(PERL_EXT_RE_BUILD) */

/* Generated from:
 * 26aa85b574ac779fd2410086b50f847bf049461f001c3d9a6b4348961b84ec63 lib/Unicode/UCD.pm
 * ce96627d4fc91b4fd886c409caeb9b76cf7bd345e12f05c6701add7f233f6437 lib/unicore/ArabicShaping.txt
 * 40c23de860bd5067e30dad8eda38f74be0735798a6efd3f63f218806e748280b lib/unicore/BidiBrackets.txt
 * 190c7356515b2ecf6173756c00f3307a3c528a3f192679349ab7f410bb97900c lib/unicore/BidiMirroring.txt
 * 81a82b6a9fcf1a9c12f588d7a1decd73a9afdc4cac95b0eb7e576e7942d6c19f lib/unicore/Blocks.txt
 * 99d231d7c91688bbe8ca8ccebcc2f46b5b222f844babe4827295bae11e2abe5f lib/unicore/CaseFolding.txt
 * b75ba2f17b36a57c8637a29e24a96144437984a97b13005dbcc8592b5faf029f lib/unicore/CompositionExclusions.txt
 * e779a443d3aa2a3166a15becaa2b737c922480e32c0453d5956093633555078f lib/unicore/DAge.txt
 * a5d45f59b39deaab3c72ce8c1a2e212a5e086dff11b1f9d5bb0e352642e82248 lib/unicore/DCoreProperties.txt
 * 3ac44e11c84bdaf6b207d2c2c20eed857ae17052393fc7f71b0fe951186ba906 lib/unicore/DNormalizationProps.txt
 * 4f822ec7a9ebbb3138ad29bade8b9688d25b39c7a3c0b7431f01e7229e4fcb6e lib/unicore/EastAsianWidth.txt
 * fc535aa1047a70105ab9a22c2b4c3f363a2ff02fe48ebbc5eeb9873b2752ff0b lib/unicore/EquivalentUnifiedIdeograph.txt
 * b9c5158ce944d2fec57e0e4ecb716bdabfc3bdde73525f1772fe03f61a30d473 lib/unicore/HangulSyllableType.txt
 * 36c1b2a626ff1fb23b8b21e6ea8712698f8ce668dded1cb48b8ddf6a6a1b04e9 lib/unicore/IdStatus.txt
 * 4857c4ffa3898e6128b2d46b0a02e499a663fb91464a69ef3611096f01293acc lib/unicore/IdType.txt
 * 69197b019fa5f2fb0d8c6ed1ed8acb9f2e8b5b8f45a947953ffa652f3bf54983 lib/unicore/IndicPositionalCategory.txt
 * 6604e2f0fde7428675364aa0006bc686b79488dcc60ae8cb29800af2be3352e8 lib/unicore/IndicSyllabicCategory.txt
 * 84ead63924aaa74b988b2eaf254a8733276ed108633ce2ef77a9ee1de7818162 lib/unicore/Jamo.txt
 * d5abcd8f54c8a2aa912924c485ccf7f968ad98feaa303d8e9a29ad89172f1faf lib/unicore/LineBreak.txt
 * 985128e8c8b2540233331d9b27d897d2c23bd5bcf1d05da960befce6efc59542 lib/unicore/NameAliases.txt
 * 106dfbfdb136009152d18ee0a123e4188fb3c16c2744666bc8af6f5188e3f0dc lib/unicore/NamedSequences.txt
 * 485b5a3ed25dbf1f94dfa5a9b69d8b4550ffd0c33045ccc55ccfd7c80b2a40cf lib/unicore/PropList.txt
 * 6b3902e9268cd843fe65cbdea992108c9528343ec0679f800b96f356bb553e5a lib/unicore/PropValueAliases.txt
 * 2bd5777847e3d6add3c7e5c0d1393ddcab89e5a0ac3ff498cb0c53041f0b86e4 lib/unicore/PropertyAliases.txt
 * 03a61dc89422e44cc2b73e8e893321007880ab69e2a4d281c0f1bc29c602b9d0 lib/unicore/ScriptExtensions.txt
 * 9a5ed1ec9b5f0d7147e9371ad792ab39203611af7637cff2aa4a5c663b172cde lib/unicore/Scripts.txt
 * 6424312f1dc39b22e0ff9c0ffb13dfad424d9b03e6a6dc6bca941f6bf5ef1ffd lib/unicore/SpecialCasing.txt
 * bdbffbbfc8ad4d3a6d01b5891510458f3d36f7170422af4ea2bed3211a73e8bb lib/unicore/UnicodeData.txt
 * 160f41816234addb511901d5f21febd69574578dd93de6ef8153e35693325575 lib/unicore/VerticalOrientation.txt
 * 32dfb37d21db530529a6ec3dc13d96f21f8e7c7faf7ff3db8a9760cd76cec81d lib/unicore/auxiliary/GCBTest.txt
 * 2bd3c5e2d62701ff81fb3ec318e179a4618cabb1493b1e0dd2b4e7e56c5437c4 lib/unicore/auxiliary/GraphemeBreakProperty.txt
 * c51fbebfa82a0f36473b44bfd71d5ef6cb6a1f81fb313375dc9a1910d79bb2b6 lib/unicore/auxiliary/LBTest.txt
 * 80b0107750818d8f370bd120b6fe56b6855b60581f72affe8b60409a469b4b65 lib/unicore/auxiliary/SBTest.txt
 * 09e3166ebab166ac630a227f77f4e794ebd433271abd5588f5a67e7f199c71ee lib/unicore/auxiliary/SentenceBreakProperty.txt
 * bf5373ce28a5df06796c93dc159dd15a997bb2950c92704b40ae8190cfc3716d lib/unicore/auxiliary/WBTest.txt
 * a2b7373cf2fe3fa3b26dbb53405ca849985f771ff47f1c61743978003ff80499 lib/unicore/auxiliary/WordBreakProperty.txt
 * d2686f400a638c80775d7c662556fb8fa8dd3bbe4aa548d9d31624264c6e1bb1 lib/unicore/emoji/emoji.txt
 * b827ae5da8c2b08947cc9a120a7b7fd2f1676fb160b508df78075381635b127c lib/unicore/extracted/DBidiClass.txt
 * 6fdc5b5ef40444a8f0c772e6b67c00498d4216fe0c0fdf76744ce338f2ad3810 lib/unicore/extracted/DBinaryProperties.txt
 * e14928a5bf6ad5958a80332bd42e96e14420080a95c660e5da29384e496755d0 lib/unicore/extracted/DCombiningClass.txt
 * 579a03281fbe87b78d5d9a8523de4d255edd7e4ca6eab0e4c7729de97e9b89b1 lib/unicore/extracted/DDecompositionType.txt
 * ad83c59b257e9d480ffd3001d4ac240c5fed7cb1919453e1c4e8877035256bcd lib/unicore/extracted/DEastAsianWidth.txt
 * 4502f0969e4e6558c4b4c6ca4c23dad70b863d61dd3d5eed1a62a6c3c99fd570 lib/unicore/extracted/DGeneralCategory.txt
 * 00bb88b89e2adb646f3177f9444e2d3192386b81a5de9556104b338274b253e1 lib/unicore/extracted/DJoinGroup.txt
 * ac835b6e11a60c9820d3cf2d1cb0558dd68efb8f53f404a51632e4726690a6d7 lib/unicore/extracted/DJoinType.txt
 * baba9dfc133e3cb770a89aaf0973b1341fa61c2da6c176baf6428898b3b568d8 lib/unicore/extracted/DLineBreak.txt
 * 6d4a8c945dd7db83ed617cbb7d937de7f4ecf016ff22970d846e996a7c9a2a5d lib/unicore/extracted/DNumType.txt
 * 5b7c14380d5cceeaffcfbc18db1ed936391d2af2d51f5a41f1a17b692c77e59b lib/unicore/extracted/DNumValues.txt
 * 696e706fddd3ce8cd48c7ea91caf4c9edf5c296432d320aa7b78631f69aa9eac lib/unicore/mktables
 * 50b85a67451145545a65cea370dab8d3444fbfe07e9c34cef560c5b7da9d3eef lib/unicore/version
 * 24120d5e0c9685c442c93bc1dbea9b85ef973bf8e9474baf0e55b160c288226b regen/charset_translations.pl
 * 9f74e34278592ddf58fef8c32236b294e94ea5e12627f911f4563e8040a07292 regen/mk_PL_charclass.pl
 * 5eb9e6c825496cc9aa705e3cd33bc6d5a9657dcca16d4c4acc4824ff30b34a26 regen/mk_invlists.pl
 * cf1d68efb7d919d302c4005641eae8d36da6d7850816ad374b0c00b45e609f43 regen/mph.pl
 * ex: set ro: */
