package WebService::PayPal::PaymentsAdvanced::Role::HasUA;
$WebService::PayPal::PaymentsAdvanced::Role::HasUA::VERSION = '0.000008';
use Moo::Role;

use LWP::UserAgent;
use Types::Standard qw( InstanceOf );

has ua => (
    is      => 'ro',
    isa     => InstanceOf ['LWP::UserAgent'],
    default => sub {
        my $ua = LWP::UserAgent->new;
        $ua->timeout(5);
        return $ua;
    },
);

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

WebService::PayPal::PaymentsAdvanced::Role::HasUA

=head1 VERSION

version 0.000008

=head1 AUTHOR

Olaf Alders <olaf@wundercounter.com>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2015 by MaxMind, Inc..

This is free software, licensed under:

  The Artistic License 2.0 (GPL Compatible)

=cut
