# Generated by default/object.tt
package Paws::AccessAnalyzer::VpcConfiguration;
  use Moose;
  has VpcId => (is => 'ro', isa => 'Str', request_name => 'vpcId', traits => ['NameInRequest'], required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::AccessAnalyzer::VpcConfiguration

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::AccessAnalyzer::VpcConfiguration object:

  $service_obj->Method(Att1 => { VpcId => $value, ..., VpcId => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::AccessAnalyzer::VpcConfiguration object:

  $result = $service_obj->Method(...);
  $result->Att1->VpcId

=head1 DESCRIPTION

The proposed virtual private cloud (VPC) configuration for the Amazon
S3 access point. For more information, see VpcConfiguration
(https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_VpcConfiguration.html).

=head1 ATTRIBUTES


=head2 B<REQUIRED> VpcId => Str

If this field is specified, this access point will only allow
connections from the specified VPC ID.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::AccessAnalyzer>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

