package Archive::Any::Tar;
use strict;

use Archive::Tar;
use Cwd;

=head1 NAME

Archive::Any::Tar - Archive::Any wrapper around Archive::Tar

=head1 SYNOPSIS

B<DO NOT USE THIS MODULE DIRECTLY>

Use Archive::Any instead.

=head1 DESCRIPTION

Wrapper around Archive::Tar for Archive::Any.

=cut

sub can_handle {
    return ( [ 'tar','tar.gz','tgz' ] );
}

sub files {
    my( $self, $file ) = @_;
    my $t = Archive::Tar->new( $file );
    $t->list_files;
}

sub extract {
    my ( $self, $file, $dir ) = @_;

    my $t = Archive::Tar->new( $file );

    my $orig_dir;
    if ($dir) {
        $orig_dir = getcwd;
        chdir $dir;
    }

    my $success = $t->extract;

    if ($dir) {
        chdir $orig_dir;
    }
    return $success;
}

=head1 AUTHOR

Michael G Schwern E<lt>schwern@pobox.comE<gt>

=head1 SEE ALSO

Archive::Any, Archive::Tar

=cut

1;
