package VM::HetznerCloud::API::LoadBalancers;

# ABSTRACT: LoadBalancers

# ---
# This class is auto-generated by bin/get_hetzner_info.pl
# ---

use v5.24;

use Moo;
use Types::Standard qw(:all);

use Mojo::Base -strict, -signatures;

extends 'VM::HetznerCloud::APIBase';

use utf8;

our $VERSION = '0.0.3'; # VERSION

has endpoint  => ( is => 'ro', isa => Str, default => sub { 'load_balancers' } );

sub list ($self, %params) {
    my $request_params = {
        'label_selector' => {
            'in'       => 'query',
            'required' => 0,
            'validate' => 'string',
        },
        'name' => {
            'in'       => 'query',
            'required' => 0,
            'validate' => 'string',
        },
        'sort' => {
            'in'       => 'query',
            'required' => 0,
            'validate' => 'string',
        },
    };

    return $self->_request( '', \%params, $request_params, { type => 'get', oid => '/load_balancers#get' } );
}

sub create ($self, %params) {
    my $request_params = {};
    return $self->_request( '', \%params, $request_params, { type => 'post', oid => '/load_balancers#post' } );
}

sub delete ($self, %params) {
    my $request_params = {
        'id' => {
            'in'       => 'path',
            'required' => 1,
            'validate' => 'int64',
        },
    };

    return $self->_request( '/:id', \%params, $request_params, { type => 'delete', oid => '/load_balancers/{id}#delete' } );
}

sub get ($self, %params) {
    my $request_params = {
        'id' => {
            'in'       => 'path',
            'required' => 1,
            'validate' => 'int64',
        },
    };

    return $self->_request( '/:id', \%params, $request_params, { type => 'get', oid => '/load_balancers/{id}#get' } );
}

sub put ($self, %params) {
    my $request_params = {
        'id' => {
            'in'       => 'path',
            'required' => 1,
            'validate' => 'int64',
        },
    };

    return $self->_request( '/:id', \%params, $request_params, { type => 'put', oid => '/load_balancers/{id}#put' } );
}

sub list_actions ($self, %params) {
    my $request_params = {
        'id' => {
            'in'       => 'path',
            'required' => 1,
            'validate' => 'int64',
        },
        'sort' => {
            'in'       => 'query',
            'required' => 0,
            'validate' => 'string',
        },
        'status' => {
            'in'       => 'query',
            'required' => 0,
            'validate' => 'string',
        },
    };

    return $self->_request( '/:id/actions', \%params, $request_params, { type => 'get', oid => '/load_balancers/{id}/actions#get' } );
}

sub add_service ($self, %params) {
    my $request_params = {
        'id' => {
            'in'       => 'path',
            'required' => 1,
            'validate' => 'int64',
        },
    };

    return $self->_request( '/:id/actions/add_service', \%params, $request_params, { type => 'post', oid => '/load_balancers/{id}/actions/add_service#post' } );
}

sub add_target ($self, %params) {
    my $request_params = {
        'id' => {
            'in'       => 'path',
            'required' => 1,
            'validate' => 'int64',
        },
    };

    return $self->_request( '/:id/actions/add_target', \%params, $request_params, { type => 'post', oid => '/load_balancers/{id}/actions/add_target#post' } );
}

sub attach_to_network ($self, %params) {
    my $request_params = {
        'id' => {
            'in'       => 'path',
            'required' => 1,
            'validate' => 'int64',
        },
    };

    return $self->_request( '/:id/actions/attach_to_network', \%params, $request_params, { type => 'post', oid => '/load_balancers/{id}/actions/attach_to_network#post' } );
}

sub change_algorithm ($self, %params) {
    my $request_params = {
        'id' => {
            'in'       => 'path',
            'required' => 1,
            'validate' => 'int64',
        },
    };

    return $self->_request( '/:id/actions/change_algorithm', \%params, $request_params, { type => 'post', oid => '/load_balancers/{id}/actions/change_algorithm#post' } );
}

sub change_dns_ptr ($self, %params) {
    my $request_params = {
        'id' => {
            'in'       => 'path',
            'required' => 1,
            'validate' => 'int64',
        },
    };

    return $self->_request( '/:id/actions/change_dns_ptr', \%params, $request_params, { type => 'post', oid => '/load_balancers/{id}/actions/change_dns_ptr#post' } );
}

sub change_protection ($self, %params) {
    my $request_params = {
        'id' => {
            'in'       => 'path',
            'required' => 1,
            'validate' => 'int64',
        },
    };

    return $self->_request( '/:id/actions/change_protection', \%params, $request_params, { type => 'post', oid => '/load_balancers/{id}/actions/change_protection#post' } );
}

sub change_type ($self, %params) {
    my $request_params = {
        'id' => {
            'in'       => 'path',
            'required' => 1,
            'validate' => 'int64',
        },
    };

    return $self->_request( '/:id/actions/change_type', \%params, $request_params, { type => 'post', oid => '/load_balancers/{id}/actions/change_type#post' } );
}

sub delete_service ($self, %params) {
    my $request_params = {
        'id' => {
            'in'       => 'path',
            'required' => 1,
            'validate' => 'int64',
        },
    };

    return $self->_request( '/:id/actions/delete_service', \%params, $request_params, { type => 'post', oid => '/load_balancers/{id}/actions/delete_service#post' } );
}

sub detach_from_network ($self, %params) {
    my $request_params = {
        'id' => {
            'in'       => 'path',
            'required' => 1,
            'validate' => 'int64',
        },
    };

    return $self->_request( '/:id/actions/detach_from_network', \%params, $request_params, { type => 'post', oid => '/load_balancers/{id}/actions/detach_from_network#post' } );
}

sub disable_public_interface ($self, %params) {
    my $request_params = {
        'id' => {
            'in'       => 'path',
            'required' => 1,
            'validate' => 'int64',
        },
    };

    return $self->_request( '/:id/actions/disable_public_interface', \%params, $request_params, { type => 'post', oid => '/load_balancers/{id}/actions/disable_public_interface#post' } );
}

sub enable_public_interface ($self, %params) {
    my $request_params = {
        'id' => {
            'in'       => 'path',
            'required' => 1,
            'validate' => 'int64',
        },
    };

    return $self->_request( '/:id/actions/enable_public_interface', \%params, $request_params, { type => 'post', oid => '/load_balancers/{id}/actions/enable_public_interface#post' } );
}

sub remove_target ($self, %params) {
    my $request_params = {
        'id' => {
            'in'       => 'path',
            'required' => 1,
            'validate' => 'int64',
        },
    };

    return $self->_request( '/:id/actions/remove_target', \%params, $request_params, { type => 'post', oid => '/load_balancers/{id}/actions/remove_target#post' } );
}

sub update_service ($self, %params) {
    my $request_params = {
        'id' => {
            'in'       => 'path',
            'required' => 1,
            'validate' => 'int64',
        },
    };

    return $self->_request( '/:id/actions/update_service', \%params, $request_params, { type => 'post', oid => '/load_balancers/{id}/actions/update_service#post' } );
}

sub get_actions ($self, %params) {
    my $request_params = {
        'action_id' => {
            'in'       => 'path',
            'required' => 1,
            'validate' => 'int64',
        },
        'id' => {
            'in'       => 'path',
            'required' => 1,
            'validate' => 'int64',
        },
    };

    return $self->_request( '/:id/actions/:action_id', \%params, $request_params, { type => 'get', oid => '/load_balancers/{id}/actions/{action_id}#get' } );
}

sub list_metrics ($self, %params) {
    my $request_params = {
        'end' => {
            'in'       => 'query',
            'required' => 1,
            'validate' => 'string',
        },
        'id' => {
            'in'       => 'path',
            'required' => 1,
            'validate' => 'int64',
        },
        'start' => {
            'in'       => 'query',
            'required' => 1,
            'validate' => 'string',
        },
        'step' => {
            'in'       => 'query',
            'required' => 0,
            'validate' => 'string',
        },
        'type' => {
            'in'       => 'query',
            'required' => 1,
            'validate' => 'string',
        },
    };

    return $self->_request( '/:id/metrics', \%params, $request_params, { type => 'get', oid => '/load_balancers/{id}/metrics#get' } );
}


1;

__END__

=pod

=encoding UTF-8

=head1 NAME

VM::HetznerCloud::API::LoadBalancers - LoadBalancers

=head1 VERSION

version 0.0.3

=head1 SYNOPSIS

    use VM::HetznerCloud;

    my $api_key = '1234abc';
    my $cloud   = VM::HetznerCloud->new(
        token => $api_key,
    );

    $cloud->records->create(
    );

=head1 ATTRIBUTES

=over 4

=item * endpoint

=back

=head1 METHODS

=head2 list

Gets all existing Load Balancers that you have available.

    $cloud->load_balancers->list(
        label_selector => 'test',
        name => 'test',
        sort => 'test',
    );

=head2 create

Creates a Load Balancer.

#### Call specific error codes

| Code                                    | Description                                                                                           |
|-----------------------------------------|-------------------------------------------------------------------------------------------------------|
| `cloud_resource_ip_not_allowed`         | The IP you are trying to add as a target belongs to a Hetzner Cloud resource                          |
| `ip_not_owned`                          | The IP is not owned by the owner of the project of the Load Balancer                                  |
| `load_balancer_not_attached_to_network` | The Load Balancer is not attached to a network                                                        |
| `robot_unavailable`                     | Robot was not available. The caller may retry the operation after a short delay.                      |
| `server_not_attached_to_network`        | The server you are trying to add as a target is not attached to the same network as the Load Balancer |
| `source_port_already_used`              | The source port you are trying to add is already in use                                               |
| `target_already_defined`                | The Load Balancer target you are trying to define is already defined                                  |

    $cloud->load_balancers->create();

=head2 delete

Deletes a Load Balancer.

    $cloud->load_balancers->delete(
        id => 'test',
    );

=head2 get

Gets a specific Load Balancer object.

    $cloud->load_balancers->get(
        id => 'test',
    );

=head2 put

Updates a Load Balancer. You can update a Load Balancer’s name and a Load Balancer’s labels.

Note that when updating labels, the Load Balancer’s current set of labels will be replaced with the labels provided in the request body. So, for example, if you want to add a new label, you have to provide all existing labels plus the new label in the request body.

Note: if the Load Balancer object changes during the request, the response will be a “conflict” error.

    $cloud->load_balancers->put(
        id => 'test',
    );

=head2 list_actions

Returns all Action objects for a Load Balancer. You can sort the results by using the `sort` URI parameter, and filter them with the `status` parameter.

    $cloud->load_balancers->list_actions(
        id => 'test',
        sort => 'test',
        status => 'test',
    );

=head2 add_service

Adds a service to a Load Balancer.

#### Call specific error codes

| Code                       | Description                                             |
|----------------------------|---------------------------------------------------------|
| `source_port_already_used` | The source port you are trying to add is already in use |

    $cloud->load_balancers->add_service(
        id => 'test',
    );

=head2 add_target

Adds a target to a Load Balancer.

#### Call specific error codes

| Code                                    | Description                                                                                           |
|-----------------------------------------|-------------------------------------------------------------------------------------------------------|
| `cloud_resource_ip_not_allowed`         | The IP you are trying to add as a target belongs to a Hetzner Cloud resource                          |
| `ip_not_owned`                          | The IP you are trying to add as a target is not owned by the Project owner                            |
| `load_balancer_not_attached_to_network` | The Load Balancer is not attached to a network                                                        |
| `robot_unavailable`                     | Robot was not available. The caller may retry the operation after a short delay.                      |
| `server_not_attached_to_network`        | The server you are trying to add as a target is not attached to the same network as the Load Balancer |
| `target_already_defined`                | The Load Balancer target you are trying to define is already defined                                  |

    $cloud->load_balancers->add_target(
        id => 'test',
    );

=head2 attach_to_network

Attach a Load Balancer to a Network.

**Call specific error codes**

| Code                             | Description                                                           |
|----------------------------------|-----------------------------------------------------------------------|
| `load_balancer_already_attached` | The Load Balancer is already attached to a network                    |
| `ip_not_available`               | The provided Network IP is not available                              |
| `no_subnet_available`            | No Subnet or IP is available for the Load Balancer within the network |

    $cloud->load_balancers->attach_to_network(
        id => 'test',
    );

=head2 change_algorithm

Change the algorithm that determines to which target new requests are sent.

    $cloud->load_balancers->change_algorithm(
        id => 'test',
    );

=head2 change_dns_ptr

Changes the hostname that will appear when getting the hostname belonging to the public IPs (IPv4 and IPv6) of this Load Balancer.

Floating IPs assigned to the Server are not affected by this.

    $cloud->load_balancers->change_dns_ptr(
        id => 'test',
    );

=head2 change_protection

Changes the protection configuration of a Load Balancer.

    $cloud->load_balancers->change_protection(
        id => 'test',
    );

=head2 change_type

Changes the type (Max Services, Max Targets and Max Connections) of a Load Balancer.

**Call specific error codes**

| Code                         | Description                                                     |
|------------------------------|-----------------------------------------------------------------|
| `invalid_load_balancer_type` | The Load Balancer type does not fit for the given Load Balancer |

    $cloud->load_balancers->change_type(
        id => 'test',
    );

=head2 delete_service

Delete a service of a Load Balancer.

    $cloud->load_balancers->delete_service(
        id => 'test',
    );

=head2 detach_from_network

Detaches a Load Balancer from a network.

    $cloud->load_balancers->detach_from_network(
        id => 'test',
    );

=head2 disable_public_interface

Disable the public interface of a Load Balancer. The Load Balancer will be not accessible from the internet via its public IPs.

#### Call specific error codes

| Code                                      | Description                                                                    |
|-------------------------------------------|--------------------------------------------------------------------------------|
| `load_balancer_not_attached_to_network`   |  The Load Balancer is not attached to a network                                |
| `targets_without_use_private_ip`          | The Load Balancer has targets that use the public IP instead of the private IP |

    $cloud->load_balancers->disable_public_interface(
        id => 'test',
    );

=head2 enable_public_interface

Enable the public interface of a Load Balancer. The Load Balancer will be accessible from the internet via its public IPs.

    $cloud->load_balancers->enable_public_interface(
        id => 'test',
    );

=head2 remove_target

Removes a target from a Load Balancer.

    $cloud->load_balancers->remove_target(
        id => 'test',
    );

=head2 update_service

Updates a Load Balancer Service.

#### Call specific error codes

| Code                       | Description                                             |
|----------------------------|---------------------------------------------------------|
| `source_port_already_used` | The source port you are trying to add is already in use |

    $cloud->load_balancers->update_service(
        id => 'test',
    );

=head2 get_actions

Returns a specific Action for a Load Balancer.

    $cloud->load_balancers->get_actions(
        action_id => 'test',
        id => 'test',
    );

=head2 list_metrics

You must specify the type of metric to get: `open_connections`, `connections_per_second`, `requests_per_second` or `bandwidth`. You can also specify more than one type by comma separation, e.g. `requests_per_second,bandwidth`.

Depending on the type you will get different time series data:

|Type | Timeseries | Unit | Description |
|---- |------------|------|-------------|
| open_connections | open_connections | number | Open connections |
| connections_per_second | connections_per_second | connections/s | Connections per second |
| requests_per_second | requests_per_second | requests/s | Requests per second |
| bandwidth | bandwidth.in | bytes/s | Ingress bandwidth |
|| bandwidth.out | bytes/s | Egress bandwidth |

Metrics are available for the last 30 days only.

If you do not provide the step argument we will automatically adjust it so that 200 samples are returned.

We limit the number of samples to a maximum of 500 and will adjust the step parameter accordingly.

    $cloud->load_balancers->list_metrics(
        end => 'test',
        id => 'test',
        start => 'test',
        step => 'test',
        type => 'test',
    );

=head1 AUTHOR

Renee Baecker <reneeb@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2018 by Renee Baecker.

This is free software, licensed under:

  The Artistic License 2.0 (GPL Compatible)

=cut
