#!perl
use strict;
use warnings;

use Test::More;
use Test::Number::Delta relative => 1E-10;

BEGIN {
    use_ok('Time::Moment');
}

{
    my @tests = (
        [ '0001-01-01T00:00:00Z',     -678575.0          ],
        [ '0001-01-01T00:00:00.001Z', -678574.9999999885 ],
        [ '0001-01-01T00:00:00.002Z', -678574.9999999768 ],
        [ '0001-01-01T00:00:00.010Z', -678574.9999998843 ],
        [ '0001-01-01T00:00:00.020Z', -678574.9999997686 ],
        [ '0001-01-01T00:00:00.100Z', -678574.9999988426 ],
        [ '0001-01-01T00:00:00.200Z', -678574.9999976852 ],
        [ '0001-01-01T00:00:00.300Z', -678574.9999965278 ],
        [ '0001-01-01T00:00:00.400Z', -678574.9999953704 ],
        [ '0001-01-01T00:00:00.490Z', -678574.9999943287 ],
        [ '0001-01-01T00:00:00.499Z', -678574.9999942245 ],
        [ '0001-01-01T00:00:00.500Z', -678574.999994213  ],
        [ '0001-01-01T00:00:00.501Z', -678574.9999942014 ],
        [ '0001-01-01T00:00:00.510Z', -678574.9999940973 ],
        [ '0001-01-01T00:00:00.600Z', -678574.9999930556 ],
        [ '0001-01-01T00:00:00.700Z', -678574.9999918982 ],
        [ '0001-01-01T00:00:00.800Z', -678574.9999907408 ],
        [ '0001-01-01T00:00:00.900Z', -678574.9999895834 ],
        [ '0001-01-01T00:00:00.980Z', -678574.9999886574 ],
        [ '0001-01-01T00:00:00.990Z', -678574.9999885417 ],
        [ '0001-01-01T00:00:00.998Z', -678574.999988449  ],
        [ '0001-01-01T00:00:00.999Z', -678574.9999884375 ],
        [ '0001-01-01T00:00:01Z',     -678574.9999884259 ],
        [ '0001-01-01T00:00:01.001Z', -678574.9999884143 ],
        [ '0001-01-01T00:00:01.002Z', -678574.9999884028 ],
        [ '0001-01-01T00:00:01.010Z', -678574.9999883102 ],
        [ '0001-01-01T00:00:01.020Z', -678574.9999881944 ],
        [ '0001-01-01T00:00:01.100Z', -678574.9999872685 ],
        [ '0001-01-01T00:00:01.200Z', -678574.9999861111 ],
        [ '1899-12-31T00:00:00Z',     15019.0            ],
        [ '1900-01-01T00:00:00Z',     15020.0            ],
        [ '1900-02-27T00:00:00Z',     15077.0            ],
        [ '1900-02-28T00:00:00Z',     15078.0            ],
        [ '1900-03-01T00:00:00Z',     15079.0            ],
        [ '1900-03-02T00:00:00Z',     15080.0            ],
        [ '1969-12-31T23:59:58Z',     40586.9999768519   ],
        [ '1969-12-31T23:59:58.500Z', 40586.9999826389   ],
        [ '1969-12-31T23:59:58.800Z', 40586.9999861111   ],
        [ '1969-12-31T23:59:58.900Z', 40586.9999872685   ],
        [ '1969-12-31T23:59:58.980Z', 40586.9999881944   ],
        [ '1969-12-31T23:59:58.990Z', 40586.9999883102   ],
        [ '1969-12-31T23:59:58.998Z', 40586.9999884028   ],
        [ '1969-12-31T23:59:58.999Z', 40586.9999884144   ],
        [ '1969-12-31T23:59:59Z',     40586.9999884259   ],
        [ '1969-12-31T23:59:59.001Z', 40586.9999884375   ],
        [ '1969-12-31T23:59:59.002Z', 40586.9999884491   ],
        [ '1969-12-31T23:59:59.010Z', 40586.9999885417   ],
        [ '1969-12-31T23:59:59.020Z', 40586.9999886574   ],
        [ '1969-12-31T23:59:59.100Z', 40586.9999895833   ],
        [ '1969-12-31T23:59:59.200Z', 40586.9999907407   ],
        [ '1969-12-31T23:59:59.300Z', 40586.9999918981   ],
        [ '1969-12-31T23:59:59.400Z', 40586.9999930556   ],
        [ '1969-12-31T23:59:59.490Z', 40586.9999940972   ],
        [ '1969-12-31T23:59:59.499Z', 40586.9999942014   ],
        [ '1969-12-31T23:59:59.500Z', 40586.999994213    ],
        [ '1969-12-31T23:59:59.501Z', 40586.9999942245   ],
        [ '1969-12-31T23:59:59.510Z', 40586.9999943287   ],
        [ '1969-12-31T23:59:59.600Z', 40586.9999953704   ],
        [ '1969-12-31T23:59:59.700Z', 40586.9999965278   ],
        [ '1969-12-31T23:59:59.800Z', 40586.9999976852   ],
        [ '1969-12-31T23:59:59.900Z', 40586.9999988426   ],
        [ '1969-12-31T23:59:59.980Z', 40586.9999997685   ],
        [ '1969-12-31T23:59:59.990Z', 40586.9999998843   ],
        [ '1969-12-31T23:59:59.998Z', 40586.9999999769   ],
        [ '1969-12-31T23:59:59.999Z', 40586.9999999884   ],
        [ '1970-01-01T00:00:00Z',     40587.0            ],
        [ '1970-01-01T00:00:00.001Z', 40587.0000000116   ],
        [ '1970-01-01T00:00:00.002Z', 40587.0000000231   ],
        [ '1970-01-01T00:00:00.010Z', 40587.0000001157   ],
        [ '1970-01-01T00:00:00.020Z', 40587.0000002315   ],
        [ '1970-01-01T00:00:00.100Z', 40587.0000011574   ],
        [ '1970-01-01T00:00:00.200Z', 40587.0000023148   ],
        [ '1970-01-01T00:00:00.300Z', 40587.0000034722   ],
        [ '1970-01-01T00:00:00.400Z', 40587.0000046296   ],
        [ '1970-01-01T00:00:00.490Z', 40587.0000056713   ],
        [ '1970-01-01T00:00:00.499Z', 40587.0000057755   ],
        [ '1970-01-01T00:00:00.500Z', 40587.000005787    ],
        [ '1970-01-01T00:00:00.501Z', 40587.0000057986   ],
        [ '1970-01-01T00:00:00.510Z', 40587.0000059028   ],
        [ '1970-01-01T00:00:00.600Z', 40587.0000069444   ],
        [ '1970-01-01T00:00:00.700Z', 40587.0000081019   ],
        [ '1970-01-01T00:00:00.800Z', 40587.0000092593   ],
        [ '1970-01-01T00:00:00.900Z', 40587.0000104167   ],
        [ '1970-01-01T00:00:00.980Z', 40587.0000113426   ],
        [ '1970-01-01T00:00:00.990Z', 40587.0000114583   ],
        [ '1970-01-01T00:00:00.998Z', 40587.0000115509   ],
        [ '1970-01-01T00:00:00.999Z', 40587.0000115625   ],
        [ '1970-01-01T00:00:01Z',     40587.0000115741   ],
        [ '1970-01-01T00:00:01.001Z', 40587.0000115856   ],
        [ '1970-01-01T00:00:01.002Z', 40587.0000115972   ],
        [ '1970-01-01T00:00:01.010Z', 40587.0000116898   ],
        [ '1970-01-01T00:00:01.020Z', 40587.0000118056   ],
        [ '1970-01-01T00:00:01.100Z', 40587.0000127315   ],
        [ '1970-01-01T00:00:01.200Z', 40587.0000138889   ],
        [ '1982-08-25T00:15:20.213Z', 45206.0106506134   ],
        [ '2065-04-19T00:16:48.290Z', 75394.0116700231   ],
        [ '2147-12-15T00:55:25.446Z', 105583.0384889583  ],
        [ '2230-08-10T01:02:46.891Z', 135771.0435982755  ],
        [ '2313-04-06T01:04:15.597Z', 165960.0446249653  ],
        [ '2395-11-30T01:09:40.889Z', 196148.048389919   ],
        [ '2478-07-25T01:11:32.560Z', 226336.0496824074  ],
        [ '2561-03-21T01:30:19.169Z', 256525.0627218634  ],
        [ '2643-11-15T01:48:25.580Z', 286713.0752960648  ],
        [ '2726-07-12T02:03:31.919Z', 316902.0857860995  ],
        [ '2809-03-06T02:11:11.986Z', 347090.0911109491  ],
        [ '2891-10-31T02:24:37.095Z', 377279.1004293403  ],
        [ '2974-06-26T02:35:07.220Z', 407467.1077224537  ],
        [ '3057-02-19T02:45:12.109Z', 437655.1147234838  ],
        [ '3139-10-17T03:06:39.990Z', 467844.1296295139  ],
        [ '3222-06-11T03:08:08.251Z', 498032.1306510532  ],
        [ '3305-02-05T03:19:12.576Z', 528221.1383399999  ],
        [ '3387-10-01T03:29:42.574Z', 558409.1456316435  ],
        [ '3470-05-27T03:37:30.813Z', 588597.1510510764  ],
        [ '3553-01-21T04:14:38.231Z', 618786.1768313773  ],
        [ '3635-09-16T04:16:28.559Z', 648974.1781083217  ],
        [ '3718-05-13T04:17:58.222Z', 679163.179146088   ],
        [ '3801-01-06T04:21:41.794Z', 709351.1817337269  ],
        [ '3883-09-02T04:56:35.792Z', 739540.2059698148  ],
        [ '3966-04-28T05:25:14.885Z', 769728.2258667245  ],
        [ '4048-12-21T05:26:05.724Z', 799916.2264551389  ],
        [ '4131-08-18T05:46:44.068Z', 830105.240787824   ],
        [ '4214-04-13T05:48:01.141Z', 860293.2416798727  ],
        [ '4296-12-07T05:53:52.315Z', 890482.2457443866  ],
        [ '4379-08-03T06:14:48.580Z', 920670.2602844908  ],
        [ '4462-03-28T06:46:15.738Z', 950858.2821265972  ],
        [ '4544-11-22T07:31:20.407Z', 981047.3134306365  ],
        [ '4627-07-19T07:58:33.754Z', 1011235.3323351158 ],
        [ '4710-03-15T08:07:43.130Z', 1041424.3386936343 ],
        [ '4792-11-07T08:29:11.091Z', 1071612.3536005903 ],
        [ '4875-07-04T09:08:15.328Z', 1101801.3807329629 ],
        [ '4958-02-27T09:30:41.781Z', 1131989.3963169097 ],
        [ '5040-10-23T09:34:04.462Z', 1162177.3986627546 ],
        [ '5123-06-20T09:37:23.945Z', 1192366.4009715857 ],
        [ '5206-02-12T09:37:56.655Z', 1222554.4013501736 ],
        [ '5288-10-08T09:45:12.230Z', 1252743.406391551  ],
        [ '5371-06-04T09:54:14.782Z', 1282931.412671088  ],
        [ '5454-01-28T09:54:22.108Z', 1313119.4127558796 ],
        [ '5536-09-24T10:01:36.151Z', 1343308.4177795255 ],
        [ '5619-05-20T12:09:48.602Z', 1373496.5068125231 ],
        [ '5702-01-14T12:34:08.549Z', 1403685.5237100578 ],
        [ '5784-09-08T12:56:06.495Z', 1433873.5389640625 ],
        [ '5867-05-06T12:58:58.217Z', 1464062.5409515856 ],
        [ '5949-12-30T12:59:54.263Z', 1494250.5416002662 ],
        [ '6032-08-24T13:34:41.331Z', 1524438.5657561459 ],
        [ '6115-04-21T13:58:28.601Z', 1554627.5822754744 ],
        [ '6197-12-14T14:02:16.899Z', 1584815.5849178126 ],
        [ '6280-08-10T14:36:17.444Z', 1615004.6085352316 ],
        [ '6363-04-06T14:37:57.451Z', 1645192.60969272   ],
        [ '6445-11-30T14:57:42.757Z', 1675381.6234115392 ],
        [ '6528-07-26T15:10:48.307Z', 1705569.6325035533 ],
        [ '6611-03-22T15:14:39.890Z', 1735757.635183912  ],
        [ '6693-11-15T15:19:47.988Z', 1765946.6387498612 ],
        [ '6776-07-11T16:04:24.344Z', 1796134.6697262037 ],
        [ '6859-03-07T16:22:23.952Z', 1826323.6822216667 ],
        [ '6941-10-31T16:29:55.999Z', 1856511.6874536921 ],
        [ '7024-06-26T16:58:20.259Z', 1886699.7071789235 ],
        [ '7107-02-21T17:04:02.415Z', 1916888.7111390624 ],
        [ '7189-10-16T17:18:29.630Z', 1947076.7211762732 ],
        [ '7272-06-11T17:47:21.323Z', 1977265.7412190163 ],
        [ '7355-02-05T17:53:29.866Z', 2007453.7454845603 ],
        [ '7437-10-02T17:53:41.076Z', 2037642.7456143056 ],
        [ '7520-05-28T17:55:06.044Z', 2067830.7465977315 ],
        [ '7603-01-21T18:14:49.151Z', 2098018.7602910995 ],
        [ '7685-09-16T18:17:45.738Z', 2128207.7623349307 ],
        [ '7768-05-12T18:29:59.700Z', 2158395.7708298611 ],
        [ '7851-01-07T18:33:21.233Z', 2188584.773162419  ],
        [ '7933-09-02T19:14:24.673Z', 2218772.8016744559 ],
        [ '8016-04-27T19:17:12.816Z', 2248960.8036205554 ],
        [ '8098-12-22T19:23:36.418Z', 2279149.8080603937 ],
        [ '8181-08-17T19:46:25.908Z', 2309337.8239109721 ],
        [ '8264-04-13T20:07:47.314Z', 2339526.8387420601 ],
        [ '8346-12-08T20:31:37.603Z', 2369714.855296331  ],
        [ '8429-08-03T20:39:57.770Z', 2399903.8610853008 ],
        [ '8512-03-29T20:50:17.067Z', 2430091.8682530904 ],
        [ '8594-11-22T21:02:57.827Z', 2460279.8770581828 ],
        [ '8677-07-19T21:23:05.519Z', 2490468.8910360998 ],
        [ '8760-03-14T21:34:49.572Z', 2520656.8991848612 ],
        [ '8842-11-08T21:39:05.944Z', 2550845.9021521294 ],
        [ '8925-07-04T21:39:18.426Z', 2581033.9022965971 ],
        [ '9008-02-28T21:46:07.769Z', 2611221.9070343636 ],
        [ '9090-10-24T21:57:55.662Z', 2641410.9152275696 ],
        [ '9173-06-19T22:19:11.732Z', 2671598.9299968979 ],
        [ '9256-02-13T22:23:51.376Z', 2701787.9332335186 ],
        [ '9338-10-09T22:27:58.771Z', 2731975.9360968866 ],
        [ '9421-06-05T22:43:30.392Z', 2762164.9468795368 ],
        [ '9504-01-30T22:48:25.834Z', 2792352.9502990046 ],
        [ '9586-09-24T22:53:51.727Z', 2822540.9540709145 ],
        [ '9669-05-20T23:12:56.536Z', 2852729.9673210187 ],
        [ '9752-01-14T23:15:54.109Z', 2882917.9693762613 ],
        [ '9834-09-10T23:17:12.632Z', 2913106.9702850925 ],
        [ '9999-12-31T23:59:58Z',     2973483.999976852  ],
        [ '9999-12-31T23:59:58.500Z', 2973483.9999826388 ],
        [ '9999-12-31T23:59:58.800Z', 2973483.9999861112 ],
        [ '9999-12-31T23:59:58.900Z', 2973483.9999872684 ],
        [ '9999-12-31T23:59:58.980Z', 2973483.9999881946 ],
        [ '9999-12-31T23:59:58.990Z', 2973483.99998831   ],
        [ '9999-12-31T23:59:58.998Z', 2973483.9999884027 ],
        [ '9999-12-31T23:59:58.999Z', 2973483.9999884143 ],
        [ '9999-12-31T23:59:59Z',     2973483.999988426  ],
        [ '9999-12-31T23:59:59Z',     2973483.999988426  ],
        [ '9999-12-31T23:59:59.001Z', 2973483.9999884376 ],
        [ '9999-12-31T23:59:59.002Z', 2973483.9999884493 ],
        [ '9999-12-31T23:59:59.010Z', 2973483.9999885415 ],
        [ '9999-12-31T23:59:59.020Z', 2973483.9999886574 ],
        [ '9999-12-31T23:59:59.100Z', 2973483.9999895832 ],
        [ '9999-12-31T23:59:59.200Z', 2973483.9999907408 ],
        [ '9999-12-31T23:59:59.300Z', 2973483.999991898  ],
        [ '9999-12-31T23:59:59.400Z', 2973483.9999930556 ],
        [ '9999-12-31T23:59:59.490Z', 2973483.9999940973 ],
        [ '9999-12-31T23:59:59.499Z', 2973483.9999942016 ],
        [ '9999-12-31T23:59:59.500Z', 2973483.9999942128 ],
        [ '9999-12-31T23:59:59.501Z', 2973483.9999942244 ],
        [ '9999-12-31T23:59:59.510Z', 2973483.9999943287 ],
        [ '9999-12-31T23:59:59.600Z', 2973483.9999953704 ],
        [ '9999-12-31T23:59:59.700Z', 2973483.9999965276 ],
        [ '9999-12-31T23:59:59.800Z', 2973483.9999976852 ],
        [ '9999-12-31T23:59:59.900Z', 2973483.9999988424 ],
        [ '9999-12-31T23:59:59.980Z', 2973483.9999997686 ],
        [ '9999-12-31T23:59:59.990Z', 2973483.9999998841 ],
        [ '9999-12-31T23:59:59.998Z', 2973483.9999999767 ],
        [ '9999-12-31T23:59:59.999Z', 2973483.9999999884 ],
    );

    foreach my $test (@tests) {
        my ($string, $mjd) = @$test;
    
        my $tm = Time::Moment->from_mjd($mjd);
        is($tm->to_string, $string, "Time::Moment->from_mjd($mjd)");
        delta_ok($tm->mjd, $mjd, "$tm->mjd"); 
    }
}

{
    my $tm = Time::Moment->from_mjd(0, epoch => 719163);
    is($tm->to_string, '1970-01-01T00:00:00Z');
}

{
    my $tm = Time::Moment->from_mjd(0, epoch => 719163);
    is($tm->to_string, '1970-01-01T00:00:00Z');
}

{
    my $tm = Time::Moment->from_mjd(0.000001428888889, epoch => 719163, precision => 6);
    is($tm->to_string, '1970-01-01T00:00:00.123456Z');
}

done_testing();
