package Graphics::ColorNamesCMYK::ToutesLesCouleursCom::White;

use strict;

our $AUTHORITY = 'cpan:PERLANCAR'; # AUTHORITY
our $DATE = '2024-05-06'; # DATE
our $DIST = 'Graphics-ColorNamesCMYK-ToutesLesCouleursCom'; # DIST
our $VERSION = '0.001'; # VERSION

our $NAMES_CMYK_TABLE = {
  'white' => 0x00000000, # 0,0,0,0
  'alabaster' => 0x00000000, # 0,0,0,0
  'clay' => 0x00000006, # 0,0,0,6
  'azur mist' => 0x06000000, # 6,0,0,0
  'light beige' => 0x00000a28, # 0,0,10,40
  '-white' => 0x00000b00, # 0,0,11,0
  'white lead white' => 0x00000000, # 0,0,0,0
  'white cream' => 0x00051b01, # 0,5,27,1
  'white silver' => 0x00000000, # 0,0,0,0
  'white milk' => 0x00000101, # 0,0,1,1
  'flax white' => 0x00040802, # 0,4,8,2
  'white platinum' => 0x00041502, # 0,4,21,2
  'lead white' => 0x00000000, # 0,0,0,0
  'white saturn' => 0x00000000, # 0,0,0,0
  'white troyes' => 0x00000600, # 0,0,6,0
  'zinc white' => 0x03000000, # 3,0,0,0
  'white of spain' => 0x00000600, # 0,0,6,0
  'white ivory' => 0x00001164, # 0,0,17,100
  'ecru white' => 0x00000c00, # 0,0,12,0
  'lunar white' => 0x04000000, # 4,0,0,0
  'snow white' => 0x00000000, # 0,0,0,0
  'white opal' => 0x05000000, # 5,0,0,0
  'white-blue' => 0x00000000, # 0,0,0,0
  'eggshell' => 0x00080b01, # 0,8,11,1
  'nymph thigh' => 0x00090600, # 0,9,6,0
};


1;
# ABSTRACT: CMYK colors from http://toutes-les-couleurs.com/ (white)

__END__

=pod

=encoding UTF-8

=head1 NAME

Graphics::ColorNamesCMYK::ToutesLesCouleursCom::White - CMYK colors from http://toutes-les-couleurs.com/ (white)

=head1 VERSION

This document describes version 0.001 of Graphics::ColorNamesCMYK::ToutesLesCouleursCom::White (from Perl distribution Graphics-ColorNamesCMYK-ToutesLesCouleursCom), released on 2024-05-06.

=head1 DESCRIPTION

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Graphics-ColorNamesCMYK-ToutesLesCouleursCom>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Graphics-ColorNamesCMYK-ToutesLesCouleursCom>.

=head1 SEE ALSO

Other C<Graphics::ColorNamesCMYK::ToutesLesCoulersCom::*> modules.

Other C<Graphics::ColorNamesCMYK::*> modules.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 CONTRIBUTING


To contribute, you can send patches by email/via RT, or send pull requests on
GitHub.

Most of the time, you don't need to build the distribution yourself. You can
simply modify the code, then test via:

 % prove -l

If you want to build the distribution (e.g. to try to install it locally on your
system), you can install L<Dist::Zilla>,
L<Dist::Zilla::PluginBundle::Author::PERLANCAR>,
L<Pod::Weaver::PluginBundle::Author::PERLANCAR>, and sometimes one or two other
Dist::Zilla- and/or Pod::Weaver plugins. Any additional steps required beyond
that are considered a bug and can be reported to me.

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2024 by perlancar <perlancar@cpan.org>.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Graphics-ColorNamesCMYK-ToutesLesCouleursCom>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=cut
