/*
 * Decompiled with CFR 0.152.
 */
package org.idpf.epubcheck.util.css;

import com.google.common.base.Charsets;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;

final class Messages {
    private static final String BUNDLE_NAME = "org.idpf.epubcheck.util.css.messages";
    private static final ResourceBundle RESOURCE_BUNDLE = ResourceBundle.getBundle("org.idpf.epubcheck.util.css.messages", Locale.getDefault(), new UTF8Control());

    static String get(String key) {
        try {
            return RESOURCE_BUNDLE.getString(key);
        }
        catch (MissingResourceException e) {
            return key;
        }
    }

    static String get(String key, Object ... arguments) {
        try {
            return MessageFormat.format(RESOURCE_BUNDLE.getString(key), arguments);
        }
        catch (MissingResourceException e) {
            return key;
        }
    }

    private Messages() {
    }

    static class UTF8Control
    extends ResourceBundle.Control {
        UTF8Control() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ResourceBundle newBundle(String baseName, Locale locale, String format, ClassLoader loader, boolean reload) throws IllegalAccessException, InstantiationException, IOException {
            String bundleName = this.toBundleName(baseName, locale);
            String resourceName = this.toResourceName(bundleName, "properties");
            PropertyResourceBundle bundle = null;
            InputStream stream = null;
            if (reload) {
                URLConnection connection;
                URL url = loader.getResource(resourceName);
                if (url != null && (connection = url.openConnection()) != null) {
                    connection.setUseCaches(false);
                    stream = connection.getInputStream();
                }
            } else {
                stream = loader.getResourceAsStream(resourceName);
            }
            if (stream != null) {
                try {
                    bundle = new PropertyResourceBundle(new BufferedReader(new InputStreamReader(stream, Charsets.UTF_8)));
                }
                finally {
                    stream.close();
                }
            }
            return bundle;
        }
    }
}

