/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions.regex;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.functions.regex.JDK15RegexTranslator;
import net.sf.saxon.functions.regex.RegexSyntaxException;
import net.sf.saxon.lib.ParseOptions;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.pattern.NameTest;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.util.FastStringBuffer;

public class UnicodeBlocks {
    private static Map<String, JDK15RegexTranslator.CharClass> blocks = null;

    public static JDK15RegexTranslator.CharClass getBlock(String name) throws RegexSyntaxException {
        JDK15RegexTranslator.CharClass cc;
        if (blocks == null) {
            UnicodeBlocks.readBlocks(new Configuration());
        }
        if ((cc = blocks.get(name)) != null) {
            return cc;
        }
        cc = blocks.get(UnicodeBlocks.normalizeBlockName(name));
        return cc;
    }

    private static String normalizeBlockName(String name) {
        FastStringBuffer fsb = new FastStringBuffer(name.length());
        block3: for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            switch (c) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': 
                case '_': {
                    continue block3;
                }
                default: {
                    fsb.append(c);
                }
            }
        }
        return fsb.toString();
    }

    private static synchronized void readBlocks(Configuration config) throws RegexSyntaxException {
        Object item;
        DocumentInfo doc;
        blocks = new HashMap<String, JDK15RegexTranslator.CharClass>(250);
        InputStream in = Configuration.locateResource("unicodeBlocks.xml", new ArrayList<String>(), new ArrayList<ClassLoader>());
        if (in == null) {
            throw new RegexSyntaxException("Unable to read unicodeBlocks.xml file");
        }
        ParseOptions options = new ParseOptions();
        options.setSchemaValidationMode(4);
        options.setStripSpace(2);
        try {
            doc = config.buildDocument(new StreamSource(in, "unicodeBlocks.xml"), options);
        }
        catch (XPathException e) {
            throw new RegexSyntaxException("Failed to process unicodeBlocks.xml: " + e.getMessage());
        }
        AxisIterator iter = doc.iterateAxis((byte)4, new NameTest(1, "", "block", config.getNamePool()));
        while ((item = iter.next()) != null) {
            Object rangeElement;
            String blockName = UnicodeBlocks.normalizeBlockName(item.getAttributeValue("", "name"));
            JDK15RegexTranslator.CharClass range = null;
            AxisIterator ranges = item.iterateAxis((byte)3, NodeKindTest.ELEMENT);
            while ((rangeElement = ranges.next()) != null) {
                int from = Integer.parseInt(rangeElement.getAttributeValue("", "from").substring(2), 16);
                int to = Integer.parseInt(rangeElement.getAttributeValue("", "to").substring(2), 16);
                JDK15RegexTranslator.CharRange cr = new JDK15RegexTranslator.CharRange(from, to);
                if (range == null) {
                    range = cr;
                    continue;
                }
                range = new JDK15RegexTranslator.Union(range, cr);
            }
            blocks.put(blockName, range);
        }
    }
}

