use Test::More tests => 1 + 1 + 10;
BEGIN {
    use_ok('Text::Outdent', qw/
        outdent_quote
    /);
}

###############################################################################

use strict;

sub f { my ($str) = @_; $str =~ tr/./ /; return $str }
sub g { my ($str) = @_; $str =~ tr/ /./; return $str }

my ($in, $out);

ok(defined &Text::Outdent::heredocify);

my $test = sub {
    local $Test::Builder::Level = $Test::Builder::Level + 1;
    is(g(Text::Outdent::heredocify(f($in))), g(f($out)));
};

###############################################################################

$in = q{
};

$out = <<'_OUT_';
_OUT_

$test->();

###############################################################################

    $in = q{
    };

$out = <<'_OUT_';
_OUT_

$test->();

###############################################################################

$in = q{....
};

$out = <<'_OUT_';
_OUT_

$test->();

###############################################################################

$in = q{
....};

$out = <<'_OUT_';
_OUT_

$test->();

###############################################################################

$in = q{....
....};

$out = <<'_OUT_';
_OUT_

$test->();

###############################################################################

$in = q{
a
};

$out = <<'_OUT_';
a
_OUT_

$test->();

###############################################################################

    $in = q{
a
    };

$out = <<'_OUT_';
a
_OUT_

$test->();

###############################################################################

$in = q{....
a
};

$out = <<'_OUT_';
a
_OUT_

$test->();

###############################################################################

$in = q{
a
....};

$out = <<'_OUT_';
a
_OUT_

$test->();

###############################################################################

$in = q{....
a
....};

$out = <<'_OUT_';
a
_OUT_

$test->();

###############################################################################
