# Wasm3 demos

- **In-browser Wasm3 (with MetaWASI support) on Webassembly.sh** │ [try it](https://webassembly.sh/?run-command=wasm3)
- **PyGame + pywasm3 examples** | [github](https://github.com/wasm3/pywasm3/tree/main/examples)
- **DOOM compiled to WASI, running on pywasm3** |  [video](https://twitter.com/wasm3_engine/status/1393588527863144450), [github](https://github.com/wasm3/pywasm3-doom-demo)
- **WebAssembly On Your Nintendo DS** |  [blog](https://softwayre.com/blog/2021/09/13/webassembly-on-your-nintendo-ds), [github](https://github.com/moxon6/snake-assemblyscript-ds)
- **Each pixel on this ESP32 board is controlled by a different WebAssembly app** |  [video](https://twitter.com/zubr_kabbi/status/1436833749359017985), [github](https://github.com/kabbi/m5-atom-wasms)
- **Wasm3 self-compilation using `clang.wasm`** |  [github](https://github.com/wasm3/wasm3-self-compiling)
- **Dino game**
  - on PyBadge/Arduino | [video](https://twitter.com/vshymanskyy/status/1345048053041029121), [github](https://github.com/wasm3/wasm3-arduino/tree/main/examples/Wasm_Dino_PyBadge)
  - on Raspberry Pi Pico | [github](https://github.com/vshymanskyy/wasm3_dino_rpi_pico)
  - on ESP32 TTGO TDisplay | [github](https://github.com/wasm3/wasm3-arduino/tree/main/examples/Wasm_Dino_ESP32_TDisplay)
- **Basic WiFi/Gpio access, updating `wasm` file over-the-air** │ [video](https://twitter.com/alvaroviebrantz/status/1221618910803513344), [github](https://github.com/alvarowolfx/wasm-arduino-wifi) [ESP32 / Web] 
- **RGB lamp animation using WebAssembly** │ [video](https://twitter.com/wasm3_engine/status/1222835097289752576), [github](https://github.com/vshymanskyy/Wasm3_RGB_Lamp) [nRF51 / nRF52 / ESP8266 / ESP32]
- **LCD display rendering with AssemblyScript** │ [video](https://twitter.com/h1romas4/status/1228581467850100736), [github](https://github.com/h1romas4/m5stack-wasm3-testing) [M5Stack / ESP32]
- **Conway's Game Of Life with AssemblyScript** │ [video](https://www.youtube.com/watch?v=Hc2sbhGMrig), [github](https://github.com/h1romas4/maixduino-wasm3-testing) [Maixduino / K210]

