#! perl

use Test2::V0;
use Test::Alien::CPP;

use constant PACKAGE_NAME => 'Alien::TRNG';
use Alien::TRNG;
use Package::Stash;
use version 0.77;

alien_ok PACKAGE_NAME;
my $xs = do { local $/; <DATA> };
xs_ok { xs => $xs, verbose => 1 }, with_subtest {
    my ( $module ) = @_;
    my $stash      = Package::Stash->new( $module );
    my $one_half   = $stash->get_symbol( '&do_something' )->();
    ok( $one_half == 0.5, 'constant one_half == 0.5' )
      or note( "Got one_half == $one_half" );
};

done_testing;

__DATA__

#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"

#include <cstdlib>
#include <iostream>
#include <trng/constants.hpp>

MODULE = TA_MODULE PACKAGE = TA_MODULE

float
do_something( )
 CODE:
   RETVAL = trng::math::constants<double>::one_half;
 OUTPUT:
   RETVAL
