## no critic qw(RequirePodSections)    # -*- cperl -*-
# This file is auto-generated by the Perl TeX::Hyphen::Pattern Suite hyphen
# pattern catalog generator. This code generator comes with the
# TeX::Hyphen::Pattern module distribution in the tools/ directory
#
# Do not edit this file directly.

package TeX::Hyphen::Pattern::Eo_il3 v1.1.5;
use strict;
use warnings;
use 5.014000;
use utf8;

use Moose;

my $pattern_file = q{};
while (<DATA>) {
    $pattern_file .= $_;
}

sub pattern_data {
    return $pattern_file;
}

sub version {
    return $TeX::Hyphen::Pattern::Eo_il3::VERSION;
}

1;
## no critic qw(RequirePodAtEnd RequireASCII ProhibitFlagComments)

=encoding utf8

=head1 C<Eo_il3> hyphenation pattern class

=head1 SUBROUTINES/METHODS

=over 4

=item $pattern-E<gt>pattern_data();

Returns the pattern data.

=item $pattern-E<gt>version();

Returns the version of the pattern package.

=back

=head1 Copyright

The copyright of the patterns is not covered by the copyright of this package
since this pattern is generated from the source at
L<svn://tug.org/texhyphen/trunk/hyph-utf8/tex/generic/hyph-utf8/patterns/ptex/hyph-eo.il3.tex>

The copyright of the source can be found in the DATA section in the source of
this package file.

=cut

__DATA__
% pTeX-friendly hyphenation patterns
%
% language: esperanto (eo)
% encoding: il3
%
% This file has been auto-generated from hyph-eo.tex
% with a script [texmf]/scripts/generic/hyph-utf8/generate-ptex-patterns.rb
% See the original file for details about author, licence etc.
%
\bgroup
\lccode"E6="E6
\lccode"F8="F8
\lccode"B6="B6
\lccode"BC="BC
\lccode"FE="FE
\lccode"FD="FD
\patterns{
a1
e1
i1
o1
u1
2aj.
2ajn.
2an.
2as.
en.
is.
2oj.
2ojn.
2on.
2os.
2us.
a3a
e3a
i3a
o3a
u3a
a3e
e3e
i3e
o3e
u3e
a3i
e3i
i3i
o3i
u3i
a3o
e3o
i3o
o3o
u3o
a3u
e3u
i3u
o3u
u3u
e2sper
2jn.
2lp.
2lt.
2nk.
2ns.
2nt.
2st.
.bl4
.br4
.dr4
.dl4
.fl4
.fr4
.gl4
.gn4
.gr4
.kl4
.kn4
.kr4
.kv4
.pl4
.pr4
.ps4
.pt4
.sf4
.sk4
.skl4
.skr4
.skv4
.sl4
.sm4
.sn4
.sp4
.spl4
.spr4
.st4
.str4
.sv4
.^^fel4
.^^fem4
.^^fen4
.^^fep4
.^^fer4
.^^fepr4
.^^fet4
.^^fetr4
.^^fev4
.tr4
.vr4
1a2^^e6a.
1a2^^e6aj.
1a2^^e6ajn.
1a2^^e6an.
1a2^^e6e.
1a2^^e6o.
1a2^^e6oj.
1a2^^e6ojn.
1a2^^e6on.
1a2da.
1a2daj.
1a2dajn.
1a2dan.
1a2de.
1a2do.
1a2doj.
1a2dojn.
1a2don.
1a2das.
1a2di.
1a2dis.
1a2dos.
1a2du.
1a2dus.
.avok2a3d
.bal2a3d
^^e6okol2a3d
.fas2a3d
.inv2a3d
kamar2a3d
.kan2a3d
limon2a3d
persv2a3d
.pom2a3d
seren2a3d
1a2^^bca.
1a2^^bcaj.
1a2^^bcajn.
1a2^^bcan.
1a2^^bce.
1a2^^bco.
1a2^^bcoj.
1a2^^bcojn.
1a2^^bcon.
.al2t
al3tabl
al3t2a3r
al3ter
al3trui
1a2na.
1a2naj.
1a2najn.
1a2nan.
1a2ne.
1a2no.
1a2noj.
1a2nojn.
1a2non.
1a2nas.
1a2ni.
1a2nis.
1a2nos.
1a2nu.
1a2nus.
1a2nism
1a2n1i2n
afg2a3n
akomp2a3n
arg2a3n
ark2a3n
ban2a3n
but2a3n
cig2a3n
^^e6ambel2a3n
^^e6amp2a3n
^^e6arlat2a3n
^^e6ik2a3n
dek2a3n
dog2a3n
el2a3n
faz2a3n
font2a3n
galv2a3n
germ2a3n
^^f8entlem2a3n
hisp2a3n
.^^b6a3n
inf2a3n
ir2a3n
jap2a3n
.ka3n
kalk2a3n
kank2a3n
kapit2a3n
kard2a3n
karav2a3n
kor2a3n
.ma3n
marcip2a3n
membr2a3n
met2a3n
nirv2a3n
.on2a3n
org2a3n
.pa3n
partiz2a3n
pelik2a3n
porcel2a3n
prof2a3n
.ra3n
rum2a3n
.sa3n
3s2log2a3n
sopr2a3n
stef2a3n
sufrag2a3n
sult2a3n
^^feam2a3n
teher2a3n
tir2a3n
turb2a3n
.va3n
vatik2a3n
veter2a3n
vulk2a3n
.ka3n2i3n
safr2a3n2i3n
.ta3n2i3n
1an2ta.
1an2taj.
1an2tajn.
1an2tan.
1an2te.
1an2to.
1an2toj.
1an2tojn.
1an2ton.
adjut2an3t
.arog2an3t
.atl2an3t
.ban3t
.brok2an3t
.diam2an3t
dilet2an3t
disk2an3t
elef2an3t
.gal2an3t
.gig2an3t
inf2a4n3t
inst2an3t
konson2an3t
.kan3t
konst2an3t
kvadr2an3t
.kv2an3t
le^^fdten2an3t
mom2an3t
.okt2an3t
.ped2an3t
.plan3t
tal2an3t
batal3an4t
1an2t3ar
an3t2arkt
kan3t2arel
1an2t1ig
1an2t1ec
.apu2d1
1a2ra.
1a2raj.
1a2rajn.
1a2ran.
1a2re.
1a2ro.
1a2roj.
1a2rojn.
1a2ron.
1a2rig
1a2ri^^f8
am2a3r
barb2a3r
baz2a3r
biz2a3r
boj2a3r
bulg2a3r
.ci3d2a3r
cig2a3r
din2a3r
dol2a3r
er2a3r
fanf2a3r
.f2a3r
formul2a3r
garg2a3r
git2a3r
.ha3r2
hung2a3r
invent2a3r
izob2a3r
jug2u3l2a3r
kalend2a3r
kap2i3l2a3r
kla3r
komp2a3r
kulin2a3r
kvatern2a3r
lap2i3d2a3r
.mol2a3r
najb4a1r
om2a3r
ordin2a3r
partik2u3l2a3r
.pol2a3r
pop2u3l2a3r
prep2a3r
prim2a3r
rad2a3r
remp2a3r
rip2a3r
sa3m2ov2a3r
sanit2a3r
sek2u3l2ar
sekund2a3r
sing2u3l2ar
skal2a3r
.st2a3r
sol2i3d2a3r
tal2a3r
tat2a3r
.vel2a3r
vulg2a3r
1a2ta.
1a2taj.
1a2tajn.
1a2tan.
1a2te.
1a2to.
1a2toj.
1a2tojn.
1a2ton.
1a2t1ec
adiab2a3t
agreg2a3t
a^^fdtom2a3t
a^^fdtorit2a3t
.ab2a3t
.adekv2a3t
advok2a3t
afrik2a3t
.ag2a3t
akrob2a3t
.akur2a3t
alop2a3t
.apar2a3t
apost2a3t
arom2a3t
.ba3t
.bl2a3t
.brok2a3t
.deb2a3t
delik2a3t
diplom2a3t
.duk2a3t
.et2a3t
fakult2a3t
.fr2a3t
.gefr2a3t
.gla3t
.gran2a3t
.hep2a3t
kandid2a3t
.kar2a3t
.kazem2a3t
.klim2a3t
.kom2a3t
.komit2a3t
.komp2a3t
konkord2a3t
.konst2a3t
.krav2a3t
kro3m2a3t
.kvadr2a3t
magistr2a3t
.magn2a3t
majorit2a3t
malgl2a3t
.mals2a3t
.mand2a3t
.mecen2a3t
minorit2a3t
.mon2a3t
.mul2a3t
.musk2a3t
ordin2a3t
.pal2a3t
.pir2a3t
.prel2a3t
.prim2a3t
priorit2a3t
.priv2a3t
.rab2a3t
.ren2a3t
.ril2a3t
.sab2a3t
.sal2a3t
.sen2a3t
sindik2a3t
.skarl2a3t
.sold2a3t
.son2a3t
.sp2a3t
stigm2a3t
substr2a3t
surog2a3t
.tok2a3t
.tom2a3t
.ultim2a3t
universit2a3t
.vulg2a3t
.^^e6e2f1
.^^e6i4a
.^^e6ia4m1
.^^e6i4e
.^^e6ie4s
.^^e6i4o
.^^e6io4m
.^^e6i4u
^^e6i3el1
3^^e62jo
.di2s1
.di3s2ert
.di3s2erv
.di3s2ip
.di3s2oci
.di3s2a.
.di3s2aj.
.di3s2ajn.
.di3s2an.
.di3s2e.
.di3s2en.
.du2m1
dump2in3g
.du2on1
1e2bla.
1e2blaj.
1e2blajn.
1e2blan.
1e2ble.
1e2blo.
1e2bloj.
1e2blojn.
1e2blon.
1e2blas.
1e2bli.
1e2blis.
1e2blos.
1e2blu.
1e2blus.
1e2bl1ec
1e2bl1a^^bc
.fe3b1l
.me3b1l
1e2ca.
1e2caj.
1e2cajn.
1e2can.
1e2ce.
1e2co.
1e2coj.
1e2cojn.
1e2con.
.apr2e3c
.de3c
.pe3c
sp2e3c
1e2ga.
1e2gaj.
1e2gajn.
1e2gan.
1e2ge.
1e2go.
1e2goj.
1e2gojn.
1e2gon.
1e2gas.
1e2gi.
1e2gis.
1e2gos.
1e2gu.
1e2gus.
.del2e3g
.fl2e3g
kol2e3g
.om2e3g
.prel2e3g
.strat2e3g
.norv2e3g
1e2ja.
1e2jaj.
1e2jajn.
1e2jan.
1e2je.
1e2jo.
1e2joj.
1e2jojn.
1e2jon.
1e2j1ig
1e2j1i^^f8
.be3j
.pl2ej
malpl2ej
.ek2s1
.ek3s2ci
ek4s3cit
ek4s3ciz
.ek3s2id
.ek1i2r
.ek1rid
1e2kzem
.ekste2r1
.ekste3ra.
.ekste3raj.
.ekste3rajn.
.ekste3ran.
.ekste3re.
.ekste3ro.
.ekste3roj.
.ekste3rojn.
.ekste3ron.
.ekste3ras.
.ekste3ri.
.ekste3ris.
.ekste3ros.
.ekste3ru.
.ekste3rus.
.el1i2r
.el1a^^e6et
.el1uz
1e2ma.
1e2maj.
1e2majn.
1e2man.
1e2me.
1e2mo.
1e2moj.
1e2mojn.
1e2mon.
1e2mas.
1e2mi.
1e2mis.
1e2mos.
1e2mu.
1e2mus.
1e2m1ec
.alpr2e3m
.anat2e3m
blasf2e3m
.boh2e3m
diad2e3m
.dil2e3m
.ed2e3m
ekstr2e3m
.ektr2e3m
.ekpr2e3m
embl2e3m
emfiz2e3m
.ekz2e3m
.har2e3m
jerusal2e3m
krizant2e3m
.le3m
.po2e3m
.pr2e3m
.probl2e3m
.sk2e3m
.te3m
.tand2e3m
.teor2e3m
.tot2e3m
.tr2e3m
sist2e3m
.en1ir2
1en2da.
1en2daj.
1en2dajn.
1en2dan.
1en2de.
1en2das.
1en2di.
1en2dis.
1en2dos.
1en2du.
1en2dus.
1en2do.
1en2don.
.am2en3d
.at2en3d
.def2en3d
.et2en3d
.kal2en3d
kres^^e62en3d
.men3d
.of2en3d
.pen3d
.pl2en3d
pret2en3d
rekom2en3d
.sen3d
sc2en3d
.ten3d
.ven3d
1e2ta.
1e2taj.
1e2tajn.
1e2tan.
1e2te.
1e2to.
1e2toj.
1e2tojn.
1e2ton.
1e2taas.
1e2tai.
1e2tais.
1e2taos.
1e2tau.
1e2taus.
a2^^e62e3t
alfab2e3t
alum2e3t
amul2e3t
.ask2e3t
.atl2e3t
.be3t
bajon2e3t
bil2e3t
.bol2e3t
bracel2e3t
brev2e3t
.bu^^f82e3t
.deb2e3t
.dem2e3t
diab2e3t
elizab2e3t
.enk2e3t
epit2e3t
.form2e3t
.gaz2e3t
.herm2e3t
.^^b6e3t
.^^bcak2e3t
^^bc2e3t
kabin2e3t
.kad2e3t
kastanj2e3t
.kin2e3t
klarn2e3t
kloz2e3t
.kom2e3t
kompl2e3t
.konf2e3t
kors2e3t
korv2e3t
kotl2e3t
.krik2e3t
.krok2e3t
kvodlib2e3t
.me3t
magn2e3t
marion2e3t
.mot2e3t
.ne3t
.oml2e3t
pamfl2e3t
parg2e3t
.pl2e3t
.po2e3t
.prof2e3t
.prol2e3t
.rak2e3t
.rem2e3t
.rip2e3t
sekr2e3t
skel2e3t
.son2e3t
.sov2e3t
spag2e3t
spin2e3t
staf2e3t
.stil2e3t
^^feibol2e3t
.tib2e3t
tual2e3t
.ve3t
.veg2e3t
.vend2e3t
vinj2e3t
1es2tr
.fo2r1
.fo3r2in3t
.fo3r2u3m
.fo3r2a.
.fo3r2aj.
.fo3r2ajn.
.fo3r2an.
.fo3r2e.
.fo3r2o.
.fo3r2oj.
.fo3r2ojn.
.fo3r2on.
.fo3r2en
.fo3r2as.
.fo3r2i.
.fo3r2is.
.fo3r2os.
.fo3r2u.
.fo3r2us.
.^^f8i2s1
1i2da.
1i2daj.
1i2dajn.
1i2dan.
1i2de.
1i2do.
1i2doj.
1i2dojn.
1i2don.
.abs2i3d
.ac2i3d
.akr2i3d
.aps2i3d
.ar2i3d
.askar2i3d
.asp2i3d
.av2i3d
.bi3d
.bol2i3d
.br2i3d
cirkumc2i3d
.dav2i3d
.dec2i3d
.e^^fdkl2i3d
.eg2i3d
.fi3d
.flor2i3d
.fr2i3d
frig2i3d
genoc2i3d
.gv2i3d
hibr2i3d
hum2i3d
^^b6lam2i3d
.inc2i3d
.ins2i3d
inval2i3d
.ji3d
kan3t2ar2i3d
koinc2i3d
.konf2i3d
krizal2i3d
.li3d
.lib2i3d
likv2i3d
.liv2i3d
.luc2i3d
.madr2i3d
morb2i3d
.muc2i3d
perf2i3d
piram2i3d
.prez2i3d
.ri3d
rap2i3d
rez2i3d
rig2i3d
.si3d
.sol2i3d
.str2i3d
telev2i3d
.tim2i3d
.vi3d
.val2i3d
1i2d1ar
1i2d1i2n
.pir2i3d2in
1i2ga.
1i2gaj.
1i2gajn.
1i2gan.
1i2ge.
1i2go.
1i2goj.
1i2gojn.
1i2gon.
1i2gas.
1i2gi.
1i2gis.
1i2gos.
1i2gu.
1i2gus.
.br2i3g
.di3g
.fi3g
.in3d2i3g
.inst2i3g
.intr2i3g
.kvadr2i3g
.li3g
pfen2i3g
.pi3g
.prod2i3g
.ri3g
.rodr2i3g
.str2i3g
.ti3g
.nav2i3g
1i2gebl
1i2gant
1i2gint
1i2gont
1i2gat
al2i3g2a3tor
l2i3g2a3turo
1i2git
1i2got
1i2g1a2d
br2i3g2a3d
1i2g1e2m
1i2g1i2l
1i2^^f8a.
1i2^^f8aj.
1i2^^f8ajn.
1i2^^f8an.
1i2^^f8e.
1i2^^f8o.
1i2^^f8oj.
1i2^^f8ojn.
1i2^^f8on.
1i2^^f8as.
1i2^^f8i.
1i2^^f8is.
1i2^^f8os.
1i2^^f8u.
1i2^^f8us.
1i2^^f8ant
1i2^^f8int
1i2^^f8ont
.br2i3^^f8
.negl2i3^^f8
.prest2i3^^f8
.vert2i3^^f8
.vest2i3^^f8
1i2^^f81a2d
1i2^^f81e2m
1i2la.
1i2laj.
1i2lajn.
1i2lan.
1i2le.
1i2lo.
1i2loj.
1i2lojn.
1i2lon.
abut2i3l
acet2i3l
.ang2i3l
.apr2i3l
.arg2i3l
.az2i3l
.bab2i3l
.bac2i3l
.baz2i3l
.ber2i3l
.bi3l
.br2i3l
.braz2i3l
.ced2i3l
.civ2i3l
.^^e6i3l
^^e6in^^e62i3l
.dakt2i3l
.deb2i3l
.def2i3l
.dist2i3l
.domic2i3l
.dr2i3l
.ed2i3l
.ekz2i3l
.eps2i3l
.et2i3l
.fi3l
.fac2i3l
.fus2i3l
.gor2i3l
.gr2i3l
.^^f8ent2i3l
.hum2i3l
.jub2i3l
.ki3l
.kamar2i3l
kamom2i3l
.komp2i3l
.kons2i3l
krokod2i3l
.mi3l
.mant2i3l
.met2i3l
mob2i3l
.mut2i3l
na^^fdt2i3l
of2i3l
.osc2i3l
paskv2i3l
.ps2i3l
pterodakt2i3l
.pup2i3l
sen2il
sim2i3l
.st2i3l
.stab2i3l
stenc2i3l
strob2i3l
subt2i3l
svah2i3l
trankv2i3l
.ut2i3l
.vi3l
.van2i3l
.vig2i3l
vodev2i3l
volat2i3l
1i2l1ar
b2i3l2a3rd
dakt2i3l2a3rb
pl2i3l2a3r^^f8
f2i3l2a3ri
frit2i3l2a3ri
f2i3l2a3rb
1e2str1i2na.
1e2str1i2naj.
1e2str1i2najn.
1e2str1i2nan.
1e2str1i2ne.
1e2str1i2no.
1e2str1i2noj.
1e2str1i2nojn.
1e2str1i2non.
1i2s2t1i2na.
1i2s2t1i2naj.
1i2s2t1i2najn.
1i2s2t1i2nan.
1i2s2t1i2ne.
1i2s2t1i2no.
1i2s2t1i2noj.
1i2s2t1i2nojn.
1i2s2t1i2non.
d2is3t2ingo
1u2l1i2na.
1u2l1i2naj.
1u2l1i2najn.
1u2l1i2nan.
1u2l1i2ne.
1u2l1i2no.
1u2l1i2noj.
1u2l1i2nojn.
1u2l1i2non.
ins2ul2i3n
1an2t1i2na.
1an2t1i2naj.
1an2t1i2najn.
1an2t1i2nan.
1an2t1i2ne.
1an2t1i2no.
1an2t1i2noj.
1an2t1i2nojn.
1an2t1i2non.
adam2a4n3t2i3n
a4n3t2i3nom
brig2a4n3t2i3n
gal2a4n3t2i3n
.k2a4n3t2i3n
strof2a4n3t2i3n
1in2da.
1in2daj.
1in2dajn.
1in2dan.
1in2de.
1in2das.
1in2di.
1in2dis.
1in2dos.
1in2du.
1in2dus.
1in2do.
1in2don.
1in2d3ec
1in2d3ig
1in2d3i^^f8
.bin3d
.hin3d
.lin3d
rozal4in3d
.bl4in3d
.pin3d
tamar4in3d
.^^fein3d
.vin3d
.in3d2ign
in3d2i^^f8en
1in2ga.
1in2gaj.
1in2gajn.
1in2gan.
1in2ge.
1in2go.
1in2goj.
1in2gojn.
1in2gon.
1in2gig
.din3g
.pud2in3g
.vik2in3g
3s2mok2in3g
^^feil2in3g
.klin3g
sterl2in3g
dom2in3g
men2in3g
salp2in3g
.rin3g
.far2in3g
.har2in3g
.lar2in3g
.mer2in3g
.fr2in3g
.sir2in3g
.krin3g
str2in3g
vrin3g
.at2in3g
.mit2in3g
.est2in3g
.dist2in3g
.svin3g
1in2ta.
1in2taj.
1in2tajn.
1in2tan.
1in2te.
1in2to.
1in2toj.
1in2tojn.
1in2ton.
1in2t3ar
1in2t3ec
1in2t3us
.abs2in3t
.fin3t
hiac2in3t
.jac2in3t
.kvin3t
labir2in3t
.pin3t
.pl2in3t
.tin3t
tereb2in3t
.inte2r1
.inte3r2es
.inte3r2ez
.inte3r2upt
.inte3ra.
.inte3raj.
.inte3rajn.
.inte3ran.
.inte3re.
.inte3ro.
.inte3roj.
.inte3rojn.
.inte3ron.
.inte3ras.
.inte3ri.
.inte3ris.
.inte3ros.
.inte3ru.
.inte3rus.
.inte3ren.
1is2ma.
1is2maj.
1is2majn.
1is2man.
1is2me.
1is2mo.
1is2moj.
1is2mojn.
1is2mon.
1i2s2m3ec
.pr2is3m
.ris3m
.sk2is3m
.sis3m
1i2s2ta.
1i2s2taj.
1i2s2tajn.
1i2s2tan.
1i2s2te.
1i2s2to.
1i2s2toj.
1i2s2tojn.
1i2s2ton.
1i2s2t3ec
1i2s2t3ar
.amet2i3s3t
antikr2i3s3t
aor2i3s3t
.ar2i3s3t
.bal2i3s3t
.bat2i3s3t
.ci3s3t
.di3s3t
ekz2i3s3t
.gen2i3s3t
.gi3s3t
.hi3s3t
ins2i3s3t
kons2i3s3t
.ki3s3t
.kr2i3s3t
.li3s3t
.pi3s3t
pers2i3s3t
.rez2i3s3t
.sk2i3s3t
.vi3s3t
1i2ta.
1i2taj.
1i2tajn.
1i2tan.
1i2te.
1i2to.
1i2toj.
1i2tojn.
1i2ton.
1i2t3ec
p2i3t4eci
.ag2i3t
akred2i3t
antrac2i3t
.apet2i3t
.bi3t
.band2i3t
biskv2i3t
.br2i3t
.ci3t
.cenob2i3t
.cirkv2i3t
.civ2i3t
.deb2i3t
defic2i3t
.di3g2i3t
dinam2i3t
.efr2i3t
.eksc2i3t
eksplic2i3t
.el2i3t
.emer2i3t
.erm2i3t
.erud2i3t
.ev2i3t
.fr2i3t
.gamb2i3t
.gl2i3t
.graf2i3t
.gran2i3t
.grav2i3t
hermafrod2i3t
.hez2i3t
hipokr2i3t
.im2i3t
.inc2i3t
infin2i3t
inkogn2i3t
interm2i3t
.inv2i3t
kapac2i3t
komprom2i3t
.konf2i3t
.kred2i3t
.kv2i3t
.kval2i3t
.kviv2i3t
.li3t
.mi3t
malak2i3t
.margar2i3t
.marm2i3t
.med2i3t
megal2i3t
.mer2i3t
mil2i3t
asimil3i4t
.mosk2i3t
.neof2i3t
okcip2i3t
ol2i3t
.orb2i3t
palp2i3t
.paraz2i3t
.pir2i3t
plebisc2i3t
precip2i3t
prestid2i3g2i3t
preter2i3t
prof2i3t
prozel2i3t
.ri3t
rehabil2i3t
.rekviz2i3t
sanskr2i3t
.satel2i3t
sibar2i3t
.sk2i3t
.sp2i3t
.spir2i3t
.spl2i3t
.spr2i3t
stalagm2i3t
stalakt2i3t
.stil2i3t
.su3b2i3t
.^^fev2i3t
.term2i3t
.trans2i3t
troglod2i3t
.vi3t
.viz2i3t
.zen2i3t
.kel2k
.kro2m1
.kro3ma.
.kro3maj.
.kro3majn.
.kro3man.
.kro3me.
krom2o
.ku2n1
ku3n2ikl
.li4a
li5an
li5as
.ma2l1
ma3l2ic
.malno2v
.me2m1
me3m2or
.mi4a
mi5asm
mi5a^^fd
.mi2s1
.mi3s2al
mi3s2il
.mi3s2ia
.mi3s2ie
.mi3s2ii
.mi3s2io
.mi3s2iu
.me2z1
mez2alianc
me3z2embri
me3z2enter
.me3z2ere
.mez2o
me3z2ur
.ni4a
3nja.
3njaj.
3njajn.
3njan.
3nje.
3njo.
3njoj.
3njojn.
3njon.
.no2v
1o2bla.
1o2blaj.
1o2blajn.
1o2blan.
1o2ble.
1o2blo.
1o2bloj.
1o2blojn.
1o2blon.
1o2bl1ec
gren2o3bl
malno3bl
.no3bl
.vo3bl
du3ona.
du3onaj.
du3onajn.
du3onan.
du3one.
du3ono.
du3onoj.
du3onojn.
du3onon.
.trio2n
.kvar3o2n
.kvin3o2n
.ses3o2n
.sep3o2n
.ok3o2na.
.ok3o2naj.
.ok3o2najn.
.ok3o2nan.
.ok3o2ne.
.ok3o2no.
.ok3o2noj.
.ok3o2nojn.
.ok3o2non.
.na^^fdo4n
dek3o2na.
dek3o2naj.
dek3o2najn.
dek3o2nan.
dek3o2ne.
dek3o2no.
dek3o2noj.
dek3o2nojn.
dek3o2non.
cent3o2na.
cent3o2naj.
cent3o2najn.
cent3o2nan.
cent3o2ne.
cent3o2no.
cent3o2noj.
cent3o2nojn.
cent3o2non.
mil3o2na.
mil3o2naj.
mil3o2najn.
mil3o2nan.
mil3o2ne.
mil3o2no.
mil3o2noj.
mil3o2nojn.
mil3o2non.
1on2ta.
1on2taj.
1on2tajn.
1on2tan.
1on2te.
1on2to.
1on2toj.
1on2tojn.
1on2ton.
disk2on3t
.fon3t
.fr2on3t
.hon3t
horiz2on3t
.kon3t
konfr2on3t
.mon3t
mastod2on3t
.melol2on3t
.pon3t
.rak2on3t
.rem2on3t
.renk2on3t
.sp2on3t
vol2on3t
duo2pa.
duo2paj.
duo2pajn.
duo2pan.
duo2pe.
duo2po.
duo2poj.
duo2pojn.
duo2pon.
.trio2p
kvar3o2p
kvin3o2p
ses3o2p
sep3o2p
.ok3o2pa.
.ok3o2paj.
.ok3o2pajn.
.ok3o2pan.
.ok3o2pe.
.ok3o2po.
.ok3o2poj.
.ok3o2pojn.
.ok3o2pon.
na^^fdo4p
dek3o2pa.
dek3o2paj.
dek3o2pajn.
dek3o2pan.
dek3o2pe.
dek3o2po.
dek3o2poj.
dek3o2pojn.
dek3o2pon.
cent3o2pa.
cent3o2paj.
cent3o2pajn.
cent3o2pan.
cent3o2pe.
cent3o2po.
cent3o2poj.
cent3o2pojn.
cent3o2pon.
mil3o2pa.
mil3o2paj.
mil3o2pajn.
mil3o2pan.
mil3o2pe.
mil3o2po.
mil3o2poj.
mil3o2pojn.
mil3o2pon.
1o2ta.
1o2taj.
1o2tajn.
1o2tan.
1o2te.
1o2to.
1o2toj.
1o2tojn.
1o2ton.
abrik2o3t
anekd2o3t
antid2o3t
asimpt2o3t
.az2o3t
.bo3t
.bal2o3t
bankr2o3t
.behem2o3t
bergam2o3t
.bi3g2o3t
.bisk2o3t
bojk2o3t
.do3t
.dep2o3t
.desp2o3t
.dev2o3t
dorl2o3t
.ekz2o3t
.er2o3t
.erg2o3t
.fo3t
.fag2o3t
.fakt2o3t
.fl2o3t
fokstr2o3t
.fr2o3t
.go3t
.gav2o3t
.golg2o3t
.gr2o3t
.herod2o3t
hipn2o3t
hotent2o3t
.jo3t
^^bcab2o3t
.ko3t
.ka^^e6al2o3t
kalik2o3t
.kaml2o3t
.kan2o3t
.kap2o3t
.kar2o3t
.koj2o3t
.komp2o3t
kompl2o3t
kreoz2o3t
.kul2o3t
.kv2o3t
.alikv2o3t
.lo3t
.lit2o3t
.mo3t
.mar2o3t
.mark2o3t
marm2o3t
.mioz2o3t
.no3t
nark2o3t
.po3t
perlam2o3t
.pier2o3t
.pil2o3t
.piv2o3t
.pl2o3t
poligl2o3t
.ro3t
.rab2o3t
reding2o3t
.rob2o3t
.sab2o3t
sacerd2o3t
.sk2o3t
.skler2o3t
.skr2o3t
.sp2o3t
.^^feo3t
^^feevj2o3t
.terak2o3t
.tr2o3t
.trik2o3t
.vo3t
.zel2o3t
.po2r
.pos2t1
pos3t2ament
pos3t2iljon
pos3t2u3l
.prete2r1
.re2f3l2ig
.re2spond
.re2spublik
.re2storaci
.re2tro
.sa2m
sam2ar
.sa3m2u3m
sa3m2uraj
.se2n1
.se3n2aa
.se3n2ao
sen2at
sen2eskal
.si4a
.su2b1
.su3b2ute
.supe2r1
.supe3ra.
.supe3raj.
.supe3rajn.
.supe3ran.
.supe3re.
.supe3ro.
.supe3roj.
.supe3rojn.
.supe3ron.
.supe3ras.
.supe3ri.
.supe3ris.
.supe3ros.
.supe3ru.
.supe3rus.
.^^fei4a
.tran2s
tran3scend
tran3sept
tran3sistor
tran3sit
tran3s2pir
.tu2t1
.tu3ta.
.tu3taj.
.tu3tajn.
.tu3tan.
.tu3te.
.tu3to.
.tu3toj.
.tu3tojn.
.tu3ton.
1u2ja.
1u2jaj.
1u2jajn.
1u2jan.
1u2je.
1u2jo.
1u2joj.
1u2jojn.
1u2jon.
1u2j1ig
1u2j1i^^f8
.and2u3j
.halel2u3j
1u2la.
1u2laj.
1u2lajn.
1u2lan.
1u2le.
1u2lo.
1u2loj.
1u2lojn.
1u2lon.
1e2m1u2l
e3m2u3ls
1u2l3ec
1u2l3ej
.akum2u3l
.ang2u3l
.bu3l
.bet2u3l
.bru3l
.ejak2u3l
.fist2u3l
form2u3l
.fu3l
galin2u3l
.gran2u3l
.grat2u3l
.herk2u3l
hierod2u3l
homunk2u3l
.inok2u3l
.ins2u3l
.instanb2u3l
.ju3l
.^^bcu3l
.ku3l
.kab2u3l
kalend2u3l
kalk2u3l
kapit2u3l
kaps2u3l
koag2u3l
.kons2u3l
.kop2u3l
korpusk2u3l
.kum2u3l
.lu3l
.liverp2u3l
.mu3l
.mak2u3l
manip2u3l
matrik2u3l
.mod2u3l
molek2u3l
.nu3l
.neb2u3l
.ok2u3l
.pu3l
.pa^^e62u3l
partik2u3l
.pust2u3l
.ru3l
.reg2u3l
retik2u3l
.ruk2u3l
.sim2u3l
skrup2u3l
somnamb2u3l
speg2u3l
.spek2u3l
.stim2u3l
.tu3l
.tab2u3l
tarant2u3l
.tru3l
tuberk2u3l
turb2u3l
.ul2u3l
.uv2u3l
.vist2u3l
1u2l1ar
2u3l2ari
2u3l2ard
.pedik2u3l2ar
1u2ma.
1u2maj.
1u2majn.
1u2man.
1u2me.
1u2mo.
1u2moj.
1u2mojn.
1u2mon.
1u2mas.
1u2mi.
1u2mis.
1u2mos.
1u2mu.
1u2mus.
1u2m3ec
.alb2u3m
.bu3m
.opid2u3m
referend2u3m
.fu3m
parf2u3m
.gu3m
.hu3m
.kuk2u3m
.luk2u3m
.lu3m
vol2u3m
.plu3m
.stern2u3m
.pu3m
.ru3m
.ser2u3m
.gru3m
.kvor2u3m
.tru3m
.stru3m
.su3m
.res2u3m
kons2u3m
opos2u3m
.bit2u3m
.kost2u3m
.zu3m
.vi4a
vi5and
vi5atik
.vi2c1
.vi3ca.
.vi3caj.
.vi3cajn.
.vi3can.
.vi3ce.
.vi3co.
.vi3coj.
.vi3cojn.
.vi3con.
.vi3c2ia
.vi3c2io
.vi2r1
vir2us
vi1r2ulent
1a2fabl
1a2gra
1a2kr
1a2per
1a2va1r
4ologi
4ografi
2fik
fre2m2d3l
4b1c
4b1b2
4b1d
4b1f
4b1g
4b1h4
4b1j2
4b1k
4b1m
4b1n
4b1p
4b1s
4b1s2k
4b1t
4b1v
4b1z
4b1^^e6
4b1^^f8
4b1^^bc
4b1^^fe
4c1b
4c1c2
4c1^^e6
4c1d
4c1f
4c1g
4c1^^f8
4c1h4
4c1j2
4c1^^bc
4c1k
4c1l
4c1m
4c1n
4c1p
4c1r
4c1s
4c1^^fe
4c1t
4c1v
4c1z
4^^e61b
4^^e61c
4^^e61d
4^^e61f
4^^e61g
4^^e61h4
4^^e61j2
4^^e61k
4^^e61l
4^^e61m
4^^e61n
4^^e61p
4^^e61s
4^^e61t
4^^e61v
4^^e61z
4^^e61^^e6
4^^e61^^f8
4^^e61^^bc
4^^e61^^fe
4d1b
4d1c
4d1d2
4d1f
4d1g
4d1h4
4d1j2
4d1k
4d1l
4d1m
4d1n
4d1p
4d1s
4d1t
4d1v
4d1z
4d1^^e6
4d1^^f8
4d1^^bc
4d1^^fe
1e2ben
1e2d2z
1e2gal
1e2le1g2an3t
4f1b
4f1c
4f1^^e6
4f1d
4f1f2
4f1g
4f1^^f8
4f1h4
4f1j2
4f1^^bc
4f1k
4f1m
4f1n
4f1p
4f1s
4f1^^fe
f1t
4f1v
4f1z
4g1b
4g1c
4g1^^e6
g1d
4g1f
4g1g2
4g1^^f8
4g1h4
4g1j2
4g1^^bc
4g1k
g1m
g1n
4g1p
4g1s
4g1^^fe
4g1t
g1v
4g1z
4^^f81b
4^^f81c
4^^f81d
4^^f81f
4^^f81g
4^^f81h4
4^^f81j2
4^^f81k
4^^f81l
4^^f81m
4^^f81n
4^^f81p
4^^f81s
4^^f81t
4^^f81v
4^^f81z
4^^f81^^e6
4^^f81^^f8
4^^f81^^bc
4^^f81^^fe
4h1^^e6
4h1^^f8
4h1^^bc
4h1^^fe
4^^b61b
4^^b61c
4^^b61d
4^^b61f
4^^b61g
4^^b61h4
4^^b61j2
4^^b61k
4^^b61m
4^^b61n
4^^b61p
4^^b61s
4^^b61t
4^^b61v
4^^b61z
4^^b61^^e6
4^^b61^^f8
4^^b61^^bc
4^^b61^^fe
1i2dent
4j1b
4j1c
4j1d
4j1f
4j1g
4j1h4
4j1k
4j1l
4j1m
4j1n
4j1p
4j1r
4j1s
4j1t
4j1v
4j1z
4j1^^e6
4j1^^f8
4j1^^bc
4j1^^fe
4^^bc1b
4^^bc1c
4^^bc1d
4^^bc1f
4^^bc1g
4^^bc1h4
4^^bc1j2
4^^bc1k
4^^bc1l
4^^bc1m
4^^bc1n
4^^bc1p
4^^bc1s
4^^bc1t
4^^bc1v
4^^bc1z
4^^bc1^^e6
4^^bc1^^f8
4^^bc1^^bc
4^^bc1^^fe
4k1b
4k1c
4k1d
4k1f
4k1g
4k1h4
4k1j2
4k1m
4k1n
4k1p
4k1s
k1s2t2r
4k1t
k1v
4k1z
4k1^^e6
4k1^^f8
4k1^^bc
4k1^^fe
4l1b
4l1c
4l1d
4l1f
4l1g
4l1h4
4l1j2
4l1k
4l1l2
4l1m
4l1n
4l1p
4l1r
4l1s2
4l1t
4l1v
4l1z
4l1^^e6
4l1^^f8
4l1^^bc
4l5^^fe2
4m1b
4m1c
4m1d
4m1f
4m1g
4m1h4
4m1j2
4m1k
4m1l
4m1m2
4m1n
4m1p
4m1r
4m1s
4m1t
4m1v
4m1z
4m1^^e6
4m1^^f8
4m1^^bc
4m1^^fe
mul2t1
mult2e
mul2t3eg
mul3ta
mul3te.
mul3to
mul4t3obl
4n1b
4n1c
4n1d
4n1f
4n1g
4n1h4
4n1j
4n1k
n2kv
4n1l
n1m
4n1n
4n1p
4n1r
4n1s
n1s2c
n1s2t
4n1t
4n1v2
4n1z
4n1^^e6
4n1^^f8
4n1^^bc
4n1^^fe
n2k1c
n2s1f
nor2d1af
nor2d1am
nor2d1az
nor2d1e^^fd
nor2d1rus
nor2d1germ
1o2be
1o2kup
1o2por1tun
4p1b
4p1c
4p1d
p1f
4p1g
4p1h4
p1j2
p1k
p1m
p1n
p1s
p1t
4p1v
4p1z
4p1^^e6
4p1^^f8
4p1^^bc
p1^^fe
4r1b
4r1c
4r1d
4r1f
4r1g
4r1h4
4r1j2
4r1k
4r1l
4r1m
4r1n
4r1p
4r1s
4r1t
4r1v
4r1z
4r1^^e6
4r1^^f8
4r1^^bc
4r1^^fe
s1b
s1c
4s1^^e6
4s1d
s1f
s1g
4s1^^f8
4s1h4
4s1j2
4s1^^bc
s1k
4s1l
3s2lab
3s2lalom
3s2lang
3s2lav
3s2led
3s2lip
3s2lojd
3s2lovak
3s2loven
3s2lup
3s2lofoks
4s1m
3s2malt
3s2merald
3s2milak
3s2mirg
3s2mut
4s1n
3s2nob
3s2nuf
s1p
s1r
4s1s
4s1^^fe
s1t
1s2tu1d
s1v
4s1z
.su2d1af
.su2d1am
.su2d1azi
.su2d1e^^fdr
.su2d1rus
4^^fe1b
4^^fe1c
4^^fe1d
4^^fe1f
4^^fe1g
4^^fe1h4
4^^fe1j2
4^^fe1k
^^fe1m
^^fe1n
^^fe1p
4^^fe1s
^^fe1t
^^fe1v
4^^fe1z
4^^fe1^^e6
4^^fe1^^f8
4^^fe1^^bc
4^^fe1^^fe
1^^fe2tel
4t1b
4t1c
4t1d
4t1f
4t1g
4t1h4
4t1j2
4t1k
4t1m
4t1n
4t1p
4t1s
4t1t
4t1v
4t1z
4t1^^e6
4t1^^f8
4t1^^bc
4t1^^fe
4^^fd1
^^fd2s1k
4v1b
4v1c
4v1d
4v1f
4v1g
4v1h4
4v1j2
4v1k
4v1l
4v1m
4v1n
4v1p
4v1s
4v1t
4v1v
4v1z
4v1^^e6
4v1^^f8
4v1^^bc
4v1^^fe
4z1b
4z1c
4z1d
4z1f
4z1g
4z1h4
4z1j2
4z1k
4z1l
z2lot
4z1m
4z1n
4z1p
4z1r
4z1s
4z1t
4z1v
4z1^^e6
4z1^^f8
4z1^^bc
4z1^^fe
}
\egroup

