use Test2::V0 -target => 'DBIx::QuickORM', '!meta', '!pass';
use DBIx::QuickORM;
use Carp::Always;

use lib 't/lib';
use DBIx::QuickORM::Test;

do_for_all_dbs {
    my $db = shift;

    db mydb => sub {
        dialect curdialect();
        db_name 'quickdb';
        connect sub { $db->connect };
    };

    orm my_orm => sub {
        db 'mydb';

        autofill sub {
            autotype 'UUID';
        };

        schema my_schema => sub {
            table example => sub {
                column uuid => sub { default sub { DBIx::QuickORM::Type::UUID->new } };
            };
        };
    };

    ok(my $orm = orm('my_orm')->connect, "Got a connection");
    my $s = $orm->handle('example');

    ok(my $row = $s->insert({name => 'a'}), "Inserted a row");
    ok($row->row_data->{stored}->{uuid}, "A UUID was generated by perl");
    ok(DBIx::QuickORM::Type::UUID::looks_like_uuid($row->field('uuid')), "Valid UUID");

    ok(my $row2 = $s->insert({name => 'b', uuid => undef}), "Inserted another row row");
    ok(!$row2->row_data->{stored}->{uuid}, "No UUID default when given undef");
    ok(!$row2->field('uuid'), "NULL UUID");
};

done_testing;

