######################################################################
#
# 5138_jipse_by_utf8.1_RT_DBCS.t
#
# Copyright (c) 2018, 2019 INABA Hitoshi <ina@cpan.org> in a CPAN
######################################################################

use strict;
use FindBin;
use lib "$FindBin::Bin/../lib";

BEGIN {
    use vars qw(@test);
    @test = (
        ["\xE3\x80\x80",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4F\x4F"],
        ["\x4F\x4F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x80"],

        ["\xE3\x80\x81",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4F\x7F"],
        ["\x4F\x7F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x81"],

        ["\xE3\x80\x82",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4F\x7B"],
        ["\x4F\x7B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x82"],

        ["\xEF\xBC\x8C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4F\xE0"],
        ["\x4F\xE0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x8C"],

        ["\xEF\xBC\x8E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4F\x6C"],
        ["\x4F\x6C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x8E"],

        ["\xE3\x83\xBB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4F\x50"],
        ["\x4F\x50",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xBB"],

        ["\xEF\xBC\x9A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4F\x7D"],
        ["\x4F\x7D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x9A"],

        ["\xEF\xBC\x9B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4F\x4D"],
        ["\x4F\x4D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x9B"],

        ["\xEF\xBC\x9F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4F\x5D"],
        ["\x4F\x5D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x9F"],

        ["\xEF\xBC\x81",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4F\x5C"],
        ["\x4F\x5C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x81"],

        ["\xE3\x82\x9B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4F\x4E"],
        ["\x4F\x4E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\x9B"],

        ["\xE3\x82\x9C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4F\x6B"],
        ["\x4F\x6B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\x9C"],

        ["\xC2\xB4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4F\x60"],
        ["\x4F\x60",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xB4"],

        ["\xEF\xBD\x80",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4F\x4B"],
        ["\x4F\x4B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x80"],

        ["\xC2\xA8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4F\x61"],
        ["\x4F\x61",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xA8"],

        ["\xEF\xBC\xBE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4F\xF0"],
        ["\x4F\xF0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xBE"],

        ["\xEF\xBF\xA3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4F\xF1"],
        ["\x4F\xF1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBF\xA3"],

        ["\xEF\xBC\xBF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4F\xF2"],
        ["\x4F\xF2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xBF"],

        ["\xE3\x83\xBD",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4F\xF3"],
        ["\x4F\xF3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xBD"],

        ["\xE3\x83\xBE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4F\xF4"],
        ["\x4F\xF4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xBE"],

        ["\xE3\x82\x9D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4F\xF5"],
        ["\x4F\xF5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\x9D"],

        ["\xE3\x82\x9E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4F\xF6"],
        ["\x4F\xF6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\x9E"],

        ["\xE3\x80\x83",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4F\xF7"],
        ["\x4F\xF7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x83"],

        ["\xE4\xBB\x9D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4F\xF8"],
        ["\x4F\xF8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\x9D"],

        ["\xE3\x80\x85",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4F\xF9"],
        ["\x4F\xF9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x85"],

        ["\xE3\x80\x86",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4F\x7A"],
        ["\x4F\x7A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x86"],

        ["\xE3\x80\x87",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4F\x5E"],
        ["\x4F\x5E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x87"],

        ["\xE3\x83\xBC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4F\x4C"],
        ["\x4F\x4C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xBC"],

        ["\xE2\x80\x94",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4F\x7E"],
        ["\x4F\x7E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x80\x94"],

        ["\xE2\x80\x90",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4F\x6E"],
        ["\x4F\x6E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x80\x90"],

        ["\xEF\xBC\x8F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4F\x6F"],
        ["\x4F\x6F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x8F"],

        ["\xEF\xBC\xBC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4F\x7C"],
        ["\x4F\x7C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xBC"],

        ["\xE3\x80\x9C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4F\xC1"],
        ["\x4F\xC1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x9C"],

        ["\xE2\x80\x96",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4F\xC2"],
        ["\x4F\xC2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x80\x96"],

        ["\xEF\xBD\x9C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4F\xC3"],
        ["\x4F\xC3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x9C"],

        ["\xE2\x80\xA6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4F\xC4"],
        ["\x4F\xC4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x80\xA6"],

        ["\xE2\x80\xA5",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4F\xC5"],
        ["\x4F\xC5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x80\xA5"],

        ["\xE2\x80\x98",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4F\xC6"],
        ["\x4F\xC6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x80\x98"],

        ["\xE2\x80\x99",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4F\xC7"],
        ["\x4F\xC7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x80\x99"],

        ["\xE2\x80\x9C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4F\xC8"],
        ["\x4F\xC8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x80\x9C"],

        ["\xE2\x80\x9D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4F\xC9"],
        ["\x4F\xC9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x80\x9D"],

        ["\xEF\xBC\x88",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4F\xD1"],
        ["\x4F\xD1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x88"],

        ["\xEF\xBC\x89",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4F\xD2"],
        ["\x4F\xD2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x89"],

        ["\xE3\x80\x94",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4F\xD3"],
        ["\x4F\xD3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x94"],

        ["\xE3\x80\x95",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4F\xD4"],
        ["\x4F\xD4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x95"],

        ["\xEF\xBC\xBB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4F\xD5"],
        ["\x4F\xD5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xBB"],

        ["\xEF\xBC\xBD",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4F\xD6"],
        ["\x4F\xD6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xBD"],

        ["\xEF\xBD\x9B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4F\xD7"],
        ["\x4F\xD7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x9B"],

        ["\xEF\xBD\x9D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4F\xD8"],
        ["\x4F\xD8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x9D"],

        ["\xE3\x80\x88",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4F\xD9"],
        ["\x4F\xD9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x88"],

        ["\xE3\x80\x89",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4F\xE2"],
        ["\x4F\xE2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x89"],

        ["\xE3\x80\x8A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4F\xE3"],
        ["\x4F\xE3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x8A"],

        ["\xE3\x80\x8B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4F\xE4"],
        ["\x4F\xE4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x8B"],

        ["\xE3\x80\x8C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4F\xE5"],
        ["\x4F\xE5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x8C"],

        ["\xE3\x80\x8D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4F\xE6"],
        ["\x4F\xE6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x8D"],

        ["\xE3\x80\x8E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4F\xE7"],
        ["\x4F\xE7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x8E"],

        ["\xE3\x80\x8F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4F\xE8"],
        ["\x4F\xE8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x8F"],

        ["\xE3\x80\x90",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4F\xE9"],
        ["\x4F\xE9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x90"],

        ["\xE3\x80\x91",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4F\x4A"],
        ["\x4F\x4A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x91"],

        ["\xEF\xBC\x8B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4F\x5B"],
        ["\x4F\x5B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x8B"],

        ["\xE2\x88\x92",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4F\x5A"],
        ["\x4F\x5A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x88\x92"],

        ["\xC2\xB1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4F\x5F"],
        ["\x4F\x5F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xB1"],

        ["\xC3\x97",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4F\x6D"],
        ["\x4F\x6D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\x97"],

        ["\xC3\xB7",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4F\x79"],
        ["\x4F\x79",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xB7"],

        ["\xEF\xBC\x9D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4F\x57"],
        ["\x4F\x57",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x9D"],

        ["\xE2\x89\xA0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4F\x59"],
        ["\x4F\x59",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x89\xA0"],

        ["\xEF\xBC\x9C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4F\x62"],
        ["\x4F\x62",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x9C"],

        ["\xEF\xBC\x9E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4F\x63"],
        ["\x4F\x63",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x9E"],

        ["\xE2\x89\xA6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4F\x64"],
        ["\x4F\x64",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x89\xA6"],

        ["\xE2\x89\xA7",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4F\x65"],
        ["\x4F\x65",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x89\xA7"],

        ["\xE2\x88\x9E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4F\x66"],
        ["\x4F\x66",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x88\x9E"],

        ["\xE2\x88\xB4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4F\x67"],
        ["\x4F\x67",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x88\xB4"],

        ["\xE2\x99\x82",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4F\x68"],
        ["\x4F\x68",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x99\x82"],

        ["\xE2\x99\x80",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4F\x69"],
        ["\x4F\x69",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x99\x80"],

        ["\xC2\xB0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4F\x70"],
        ["\x4F\x70",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xB0"],

        ["\xE2\x80\xB2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4F\x71"],
        ["\x4F\x71",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x80\xB2"],

        ["\xE2\x80\xB3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4F\x72"],
        ["\x4F\x72",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x80\xB3"],

        ["\xE2\x84\x83",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4F\x73"],
        ["\x4F\x73",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x84\x83"],

        ["\xEF\xBF\xA5",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4F\x74"],
        ["\x4F\x74",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBF\xA5"],

        ["\xEF\xBC\x84",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4F\x75"],
        ["\x4F\x75",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x84"],

        ["\xEF\xBF\xA0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4F\x76"],
        ["\x4F\x76",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBF\xA0"],

        ["\xEF\xBF\xA1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4F\x77"],
        ["\x4F\x77",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBF\xA1"],

        ["\xEF\xBC\x85",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4F\x78"],
        ["\x4F\x78",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x85"],

        ["\xEF\xBC\x83",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4F\x80"],
        ["\x4F\x80",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x83"],

        ["\xEF\xBC\x86",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4F\x8B"],
        ["\x4F\x8B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x86"],

        ["\xEF\xBC\x8A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4F\x9B"],
        ["\x4F\x9B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x8A"],

        ["\xEF\xBC\xA0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4F\x9C"],
        ["\x4F\x9C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xA0"],

        ["\xC2\xA7",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4F\xA0"],
        ["\x4F\xA0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xA7"],

        ["\xE2\x98\x86",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4F\xAB"],
        ["\x4F\xAB",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x98\x86"],

        ["\xE2\x98\x85",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4F\xB0"],
        ["\x4F\xB0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x98\x85"],

        ["\xE2\x97\x8B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4F\xC0"],
        ["\x4F\xC0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x97\x8B"],

        ["\xE2\x97\x8F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4F\x6A"],
        ["\x4F\x6A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x97\x8F"],

        ["\xE2\x97\x8E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4F\xD0"],
        ["\x4F\xD0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x97\x8E"],

        ["\xE2\x97\x87",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4F\xA1"],
        ["\x4F\xA1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x97\x87"],

        ["\xE2\x97\x86",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7F\x4F"],
        ["\x7F\x4F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x97\x86"],

        ["\xE2\x96\xA1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7F\x7F"],
        ["\x7F\x7F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x96\xA1"],

        ["\xE2\x96\xA0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7F\x7B"],
        ["\x7F\x7B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x96\xA0"],

        ["\xE2\x96\xB3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7F\xE0"],
        ["\x7F\xE0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x96\xB3"],

        ["\xE2\x96\xB2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7F\x6C"],
        ["\x7F\x6C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x96\xB2"],

        ["\xE2\x96\xBD",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7F\x50"],
        ["\x7F\x50",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x96\xBD"],

        ["\xE2\x96\xBC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7F\x7D"],
        ["\x7F\x7D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x96\xBC"],

        ["\xE2\x80\xBB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7F\x4D"],
        ["\x7F\x4D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x80\xBB"],

        ["\xE3\x80\x92",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7F\x5D"],
        ["\x7F\x5D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x92"],

        ["\xE2\x86\x92",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7F\x5C"],
        ["\x7F\x5C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x86\x92"],

        ["\xE2\x86\x90",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7F\x4E"],
        ["\x7F\x4E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x86\x90"],

        ["\xE2\x86\x91",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7F\x6B"],
        ["\x7F\x6B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x86\x91"],

        ["\xE2\x86\x93",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7F\x60"],
        ["\x7F\x60",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x86\x93"],

        ["\xE3\x80\x93",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7F\x4B"],
        ["\x7F\x4B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x93"],

        ["\xE2\x88\x88",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x45\xA9"],
        ["\x45\xA9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x88\x88"],

        ["\xE2\x88\x8B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x45\xAA"],
        ["\x45\xAA",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x88\x8B"],

        ["\xE2\x8A\x86",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x46\xEA"],
        ["\x46\xEA",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x8A\x86"],

        ["\xE2\x8A\x87",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x46\xEB"],
        ["\x46\xEB",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x8A\x87"],

        ["\xE2\x8A\x82",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x45\xA7"],
        ["\x45\xA7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x8A\x82"],

        ["\xE2\x8A\x83",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x45\xA8"],
        ["\x45\xA8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x8A\x83"],

        ["\xE2\x88\xAA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x60\x6A"],
        ["\x60\x6A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x88\xAA"],

        ["\xE2\x88\xA9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x60\xC0"],
        ["\x60\xC0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x88\xA9"],

        ["\xE2\x88\xA7",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x45\xA5"],
        ["\x45\xA5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x88\xA7"],

        ["\xE2\x88\xA8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x45\xA6"],
        ["\x45\xA6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x88\xA8"],

        ["\xEF\xBF\xA2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x80\x4F"],
        ["\x80\x4F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBF\xA2"],

        ["\xE2\x87\x92",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x46\xEC"],
        ["\x46\xEC",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x87\x92"],

        ["\xE2\x87\x94",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x46\xED"],
        ["\x46\xED",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x87\x94"],

        ["\xE2\x88\x80",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x45\xB9"],
        ["\x45\xB9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x88\x80"],

        ["\xE2\x88\x83",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x45\xCA"],
        ["\x45\xCA",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x88\x83"],

        ["\xE2\x88\xA0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x60\x9C"],
        ["\x60\x9C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x88\xA0"],

        ["\xE2\x8A\xA5",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x60\x9B"],
        ["\x60\x9B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x8A\xA5"],

        ["\xE2\x8C\x92",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x46\xEE"],
        ["\x46\xEE",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x8C\x92"],

        ["\xE2\x88\x82",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x45\x9D"],
        ["\x45\x9D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x88\x82"],

        ["\xE2\x88\x87",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x46\xEF"],
        ["\x46\xEF",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x88\x87"],

        ["\xE2\x89\xA1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x60\x76"],
        ["\x60\x76",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x89\xA1"],

        ["\xE2\x89\x92",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x60\x75"],
        ["\x60\x75",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x89\x92"],

        ["\xE2\x89\xAA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x45\xB3"],
        ["\x45\xB3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x89\xAA"],

        ["\xE2\x89\xAB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x45\xB4"],
        ["\x45\xB4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x89\xAB"],

        ["\xE2\x88\x9A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x60\x8B"],
        ["\x60\x8B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x88\x9A"],

        ["\xE2\x88\xBD",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x45\xBD"],
        ["\x45\xBD",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x88\xBD"],

        ["\xE2\x88\x9D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x45\xBC"],
        ["\x45\xBC",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x88\x9D"],

        ["\xE2\x88\xB5",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x60\xB0"],
        ["\x60\xB0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x88\xB5"],

        ["\xE2\x88\xAB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x60\x77"],
        ["\x60\x77",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x88\xAB"],

        ["\xE2\x88\xAC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x46\xFA"],
        ["\x46\xFA",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x88\xAC"],

        ["\xE2\x84\xAB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x44\xBF"],
        ["\x44\xBF",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x84\xAB"],

        ["\xE2\x80\xB0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x44\xFE"],
        ["\x44\xFE",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x80\xB0"],

        ["\xE2\x99\xAF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x46\xFB"],
        ["\x46\xFB",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x99\xAF"],

        ["\xE2\x99\xAD",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x46\xFC"],
        ["\x46\xFC",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x99\xAD"],

        ["\xE2\x99\xAA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x46\xFD"],
        ["\x46\xFD",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x99\xAA"],

        ["\xE2\x80\xA0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x45\xDA"],
        ["\x45\xDA",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x80\xA0"],

        ["\xE2\x80\xA1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x45\xDB"],
        ["\x45\xDB",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x80\xA1"],

        ["\xC2\xB6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x45\xDC"],
        ["\x45\xDC",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xB6"],

        ["\xE2\x97\xAF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x46\xFE"],
        ["\x46\xFE",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x97\xAF"],

        ["\xEF\xBC\x90",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7B\xF0"],
        ["\x7B\xF0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x90"],

        ["\xEF\xBC\x91",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7B\xF1"],
        ["\x7B\xF1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x91"],

        ["\xEF\xBC\x92",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7B\xF2"],
        ["\x7B\xF2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x92"],

        ["\xEF\xBC\x93",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7B\xF3"],
        ["\x7B\xF3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x93"],

        ["\xEF\xBC\x94",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7B\xF4"],
        ["\x7B\xF4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x94"],

        ["\xEF\xBC\x95",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7B\xF5"],
        ["\x7B\xF5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x95"],

        ["\xEF\xBC\x96",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7B\xF6"],
        ["\x7B\xF6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x96"],

        ["\xEF\xBC\x97",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7B\xF7"],
        ["\x7B\xF7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x97"],

        ["\xEF\xBC\x98",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7B\xF8"],
        ["\x7B\xF8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x98"],

        ["\xEF\xBC\x99",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7B\xF9"],
        ["\x7B\xF9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x99"],

        ["\xEF\xBC\xA1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7B\xC1"],
        ["\x7B\xC1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xA1"],

        ["\xEF\xBC\xA2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7B\xC2"],
        ["\x7B\xC2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xA2"],

        ["\xEF\xBC\xA3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7B\xC3"],
        ["\x7B\xC3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xA3"],

        ["\xEF\xBC\xA4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7B\xC4"],
        ["\x7B\xC4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xA4"],

        ["\xEF\xBC\xA5",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7B\xC5"],
        ["\x7B\xC5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xA5"],

        ["\xEF\xBC\xA6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7B\xC6"],
        ["\x7B\xC6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xA6"],

        ["\xEF\xBC\xA7",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7B\xC7"],
        ["\x7B\xC7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xA7"],

        ["\xEF\xBC\xA8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7B\xC8"],
        ["\x7B\xC8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xA8"],

        ["\xEF\xBC\xA9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7B\xC9"],
        ["\x7B\xC9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xA9"],

        ["\xEF\xBC\xAA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7B\xD1"],
        ["\x7B\xD1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xAA"],

        ["\xEF\xBC\xAB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7B\xD2"],
        ["\x7B\xD2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xAB"],

        ["\xEF\xBC\xAC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7B\xD3"],
        ["\x7B\xD3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xAC"],

        ["\xEF\xBC\xAD",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7B\xD4"],
        ["\x7B\xD4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xAD"],

        ["\xEF\xBC\xAE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7B\xD5"],
        ["\x7B\xD5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xAE"],

        ["\xEF\xBC\xAF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7B\xD6"],
        ["\x7B\xD6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xAF"],

        ["\xEF\xBC\xB0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7B\xD7"],
        ["\x7B\xD7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xB0"],

        ["\xEF\xBC\xB1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7B\xD8"],
        ["\x7B\xD8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xB1"],

        ["\xEF\xBC\xB2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7B\xD9"],
        ["\x7B\xD9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xB2"],

        ["\xEF\xBC\xB3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7B\xE2"],
        ["\x7B\xE2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xB3"],

        ["\xEF\xBC\xB4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7B\xE3"],
        ["\x7B\xE3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xB4"],

        ["\xEF\xBC\xB5",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7B\xE4"],
        ["\x7B\xE4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xB5"],

        ["\xEF\xBC\xB6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7B\xE5"],
        ["\x7B\xE5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xB6"],

        ["\xEF\xBC\xB7",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7B\xE6"],
        ["\x7B\xE6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xB7"],

        ["\xEF\xBC\xB8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7B\xE7"],
        ["\x7B\xE7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xB8"],

        ["\xEF\xBC\xB9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7B\xE8"],
        ["\x7B\xE8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xB9"],

        ["\xEF\xBC\xBA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7B\xE9"],
        ["\x7B\xE9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xBA"],

        ["\xEF\xBD\x81",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7B\x57"],
        ["\x7B\x57",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x81"],

        ["\xEF\xBD\x82",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7B\x59"],
        ["\x7B\x59",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x82"],

        ["\xEF\xBD\x83",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7B\x62"],
        ["\x7B\x62",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x83"],

        ["\xEF\xBD\x84",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7B\x63"],
        ["\x7B\x63",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x84"],

        ["\xEF\xBD\x85",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7B\x64"],
        ["\x7B\x64",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x85"],

        ["\xEF\xBD\x86",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7B\x65"],
        ["\x7B\x65",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x86"],

        ["\xEF\xBD\x87",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7B\x66"],
        ["\x7B\x66",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x87"],

        ["\xEF\xBD\x88",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7B\x67"],
        ["\x7B\x67",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x88"],

        ["\xEF\xBD\x89",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7B\x68"],
        ["\x7B\x68",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x89"],

        ["\xEF\xBD\x8A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7B\x69"],
        ["\x7B\x69",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x8A"],

        ["\xEF\xBD\x8B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7B\x70"],
        ["\x7B\x70",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x8B"],

        ["\xEF\xBD\x8C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7B\x71"],
        ["\x7B\x71",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x8C"],

        ["\xEF\xBD\x8D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7B\x72"],
        ["\x7B\x72",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x8D"],

        ["\xEF\xBD\x8E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7B\x73"],
        ["\x7B\x73",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x8E"],

        ["\xEF\xBD\x8F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7B\x74"],
        ["\x7B\x74",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x8F"],

        ["\xEF\xBD\x90",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7B\x75"],
        ["\x7B\x75",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x90"],

        ["\xEF\xBD\x91",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7B\x76"],
        ["\x7B\x76",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x91"],

        ["\xEF\xBD\x92",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7B\x77"],
        ["\x7B\x77",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x92"],

        ["\xEF\xBD\x93",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7B\x78"],
        ["\x7B\x78",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x93"],

        ["\xEF\xBD\x94",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7B\x80"],
        ["\x7B\x80",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x94"],

        ["\xEF\xBD\x95",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7B\x8B"],
        ["\x7B\x8B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x95"],

        ["\xEF\xBD\x96",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7B\x9B"],
        ["\x7B\x9B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x96"],

        ["\xEF\xBD\x97",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7B\x9C"],
        ["\x7B\x9C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x97"],

        ["\xEF\xBD\x98",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7B\xA0"],
        ["\x7B\xA0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x98"],

        ["\xEF\xBD\x99",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7B\xAB"],
        ["\x7B\xAB",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x99"],

        ["\xEF\xBD\x9A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7B\xB0"],
        ["\x7B\xB0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x9A"],

        ["\xE3\x81\x81",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE0\x4F"],
        ["\xE0\x4F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x81"],

        ["\xE3\x81\x82",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE0\x7F"],
        ["\xE0\x7F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x82"],

        ["\xE3\x81\x83",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE0\x7B"],
        ["\xE0\x7B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x83"],

        ["\xE3\x81\x84",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE0\xE0"],
        ["\xE0\xE0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x84"],

        ["\xE3\x81\x85",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE0\x6C"],
        ["\xE0\x6C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x85"],

        ["\xE3\x81\x86",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE0\x50"],
        ["\xE0\x50",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x86"],

        ["\xE3\x81\x87",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE0\x7D"],
        ["\xE0\x7D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x87"],

        ["\xE3\x81\x88",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE0\x4D"],
        ["\xE0\x4D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x88"],

        ["\xE3\x81\x89",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE0\x5D"],
        ["\xE0\x5D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x89"],

        ["\xE3\x81\x8A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE0\x5C"],
        ["\xE0\x5C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x8A"],

        ["\xE3\x81\x8B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE0\x4E"],
        ["\xE0\x4E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x8B"],

        ["\xE3\x81\x8C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE0\x6B"],
        ["\xE0\x6B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x8C"],

        ["\xE3\x81\x8D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE0\x60"],
        ["\xE0\x60",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x8D"],

        ["\xE3\x81\x8E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE0\x4B"],
        ["\xE0\x4B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x8E"],

        ["\xE3\x81\x8F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE0\x61"],
        ["\xE0\x61",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x8F"],

        ["\xE3\x81\x90",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE0\xF0"],
        ["\xE0\xF0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x90"],

        ["\xE3\x81\x91",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE0\xF1"],
        ["\xE0\xF1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x91"],

        ["\xE3\x81\x92",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE0\xF2"],
        ["\xE0\xF2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x92"],

        ["\xE3\x81\x93",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE0\xF3"],
        ["\xE0\xF3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x93"],

        ["\xE3\x81\x94",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE0\xF4"],
        ["\xE0\xF4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x94"],

        ["\xE3\x81\x95",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE0\xF5"],
        ["\xE0\xF5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x95"],

        ["\xE3\x81\x96",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE0\xF6"],
        ["\xE0\xF6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x96"],

        ["\xE3\x81\x97",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE0\xF7"],
        ["\xE0\xF7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x97"],

        ["\xE3\x81\x98",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE0\xF8"],
        ["\xE0\xF8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x98"],

        ["\xE3\x81\x99",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE0\xF9"],
        ["\xE0\xF9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x99"],

        ["\xE3\x81\x9A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE0\x7A"],
        ["\xE0\x7A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x9A"],

        ["\xE3\x81\x9B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE0\x5E"],
        ["\xE0\x5E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x9B"],

        ["\xE3\x81\x9C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE0\x4C"],
        ["\xE0\x4C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x9C"],

        ["\xE3\x81\x9D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE0\x7E"],
        ["\xE0\x7E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x9D"],

        ["\xE3\x81\x9E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE0\x6E"],
        ["\xE0\x6E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x9E"],

        ["\xE3\x81\x9F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE0\x6F"],
        ["\xE0\x6F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x9F"],

        ["\xE3\x81\xA0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE0\x7C"],
        ["\xE0\x7C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xA0"],

        ["\xE3\x81\xA1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE0\xC1"],
        ["\xE0\xC1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xA1"],

        ["\xE3\x81\xA2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE0\xC2"],
        ["\xE0\xC2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xA2"],

        ["\xE3\x81\xA3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE0\xC3"],
        ["\xE0\xC3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xA3"],

        ["\xE3\x81\xA4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE0\xC4"],
        ["\xE0\xC4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xA4"],

        ["\xE3\x81\xA5",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE0\xC5"],
        ["\xE0\xC5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xA5"],

        ["\xE3\x81\xA6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE0\xC6"],
        ["\xE0\xC6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xA6"],

        ["\xE3\x81\xA7",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE0\xC7"],
        ["\xE0\xC7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xA7"],

        ["\xE3\x81\xA8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE0\xC8"],
        ["\xE0\xC8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xA8"],

        ["\xE3\x81\xA9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE0\xC9"],
        ["\xE0\xC9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xA9"],

        ["\xE3\x81\xAA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE0\xD1"],
        ["\xE0\xD1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xAA"],

        ["\xE3\x81\xAB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE0\xD2"],
        ["\xE0\xD2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xAB"],

        ["\xE3\x81\xAC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE0\xD3"],
        ["\xE0\xD3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xAC"],

        ["\xE3\x81\xAD",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE0\xD4"],
        ["\xE0\xD4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xAD"],

        ["\xE3\x81\xAE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE0\xD5"],
        ["\xE0\xD5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xAE"],

        ["\xE3\x81\xAF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE0\xD6"],
        ["\xE0\xD6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xAF"],

        ["\xE3\x81\xB0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE0\xD7"],
        ["\xE0\xD7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xB0"],

        ["\xE3\x81\xB1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE0\xD8"],
        ["\xE0\xD8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xB1"],

        ["\xE3\x81\xB2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE0\xD9"],
        ["\xE0\xD9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xB2"],

        ["\xE3\x81\xB3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE0\xE2"],
        ["\xE0\xE2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xB3"],

        ["\xE3\x81\xB4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE0\xE3"],
        ["\xE0\xE3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xB4"],

        ["\xE3\x81\xB5",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE0\xE4"],
        ["\xE0\xE4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xB5"],

        ["\xE3\x81\xB6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE0\xE5"],
        ["\xE0\xE5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xB6"],

        ["\xE3\x81\xB7",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE0\xE6"],
        ["\xE0\xE6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xB7"],

        ["\xE3\x81\xB8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE0\xE7"],
        ["\xE0\xE7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xB8"],

        ["\xE3\x81\xB9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE0\xE8"],
        ["\xE0\xE8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xB9"],

        ["\xE3\x81\xBA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE0\xE9"],
        ["\xE0\xE9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xBA"],

        ["\xE3\x81\xBB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE0\x4A"],
        ["\xE0\x4A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xBB"],

        ["\xE3\x81\xBC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE0\x5B"],
        ["\xE0\x5B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xBC"],

        ["\xE3\x81\xBD",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE0\x5A"],
        ["\xE0\x5A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xBD"],

        ["\xE3\x81\xBE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE0\x5F"],
        ["\xE0\x5F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xBE"],

        ["\xE3\x81\xBF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE0\x6D"],
        ["\xE0\x6D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xBF"],

        ["\xE3\x82\x80",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE0\x79"],
        ["\xE0\x79",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\x80"],

        ["\xE3\x82\x81",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE0\x57"],
        ["\xE0\x57",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\x81"],

        ["\xE3\x82\x82",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE0\x59"],
        ["\xE0\x59",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\x82"],

        ["\xE3\x82\x83",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE0\x62"],
        ["\xE0\x62",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\x83"],

        ["\xE3\x82\x84",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE0\x63"],
        ["\xE0\x63",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\x84"],

        ["\xE3\x82\x85",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE0\x64"],
        ["\xE0\x64",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\x85"],

        ["\xE3\x82\x86",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE0\x65"],
        ["\xE0\x65",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\x86"],

        ["\xE3\x82\x87",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE0\x66"],
        ["\xE0\x66",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\x87"],

        ["\xE3\x82\x88",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE0\x67"],
        ["\xE0\x67",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\x88"],

        ["\xE3\x82\x89",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE0\x68"],
        ["\xE0\x68",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\x89"],

        ["\xE3\x82\x8A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE0\x69"],
        ["\xE0\x69",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\x8A"],

        ["\xE3\x82\x8B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE0\x70"],
        ["\xE0\x70",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\x8B"],

        ["\xE3\x82\x8C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE0\x71"],
        ["\xE0\x71",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\x8C"],

        ["\xE3\x82\x8D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE0\x72"],
        ["\xE0\x72",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\x8D"],

        ["\xE3\x82\x8E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE0\x73"],
        ["\xE0\x73",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\x8E"],

        ["\xE3\x82\x8F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE0\x74"],
        ["\xE0\x74",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\x8F"],

        ["\xE3\x82\x90",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE0\x75"],
        ["\xE0\x75",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\x90"],

        ["\xE3\x82\x91",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE0\x76"],
        ["\xE0\x76",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\x91"],

        ["\xE3\x82\x92",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE0\x77"],
        ["\xE0\x77",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\x92"],

        ["\xE3\x82\x93",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE0\x78"],
        ["\xE0\x78",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\x93"],

        ["\xE3\x82\xA1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6C\x4F"],
        ["\x6C\x4F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xA1"],

        ["\xE3\x82\xA2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6C\x7F"],
        ["\x6C\x7F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xA2"],

        ["\xE3\x82\xA3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6C\x7B"],
        ["\x6C\x7B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xA3"],

        ["\xE3\x82\xA4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6C\xE0"],
        ["\x6C\xE0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xA4"],

        ["\xE3\x82\xA5",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6C\x6C"],
        ["\x6C\x6C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xA5"],

        ["\xE3\x82\xA6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6C\x50"],
        ["\x6C\x50",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xA6"],

        ["\xE3\x82\xA7",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6C\x7D"],
        ["\x6C\x7D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xA7"],

        ["\xE3\x82\xA8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6C\x4D"],
        ["\x6C\x4D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xA8"],

        ["\xE3\x82\xA9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6C\x5D"],
        ["\x6C\x5D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xA9"],

        ["\xE3\x82\xAA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6C\x5C"],
        ["\x6C\x5C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xAA"],

        ["\xE3\x82\xAB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6C\x4E"],
        ["\x6C\x4E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xAB"],

        ["\xE3\x82\xAC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6C\x6B"],
        ["\x6C\x6B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xAC"],

        ["\xE3\x82\xAD",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6C\x60"],
        ["\x6C\x60",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xAD"],

        ["\xE3\x82\xAE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6C\x4B"],
        ["\x6C\x4B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xAE"],

        ["\xE3\x82\xAF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6C\x61"],
        ["\x6C\x61",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xAF"],

        ["\xE3\x82\xB0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6C\xF0"],
        ["\x6C\xF0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xB0"],

        ["\xE3\x82\xB1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6C\xF1"],
        ["\x6C\xF1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xB1"],

        ["\xE3\x82\xB2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6C\xF2"],
        ["\x6C\xF2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xB2"],

        ["\xE3\x82\xB3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6C\xF3"],
        ["\x6C\xF3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xB3"],

        ["\xE3\x82\xB4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6C\xF4"],
        ["\x6C\xF4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xB4"],

        ["\xE3\x82\xB5",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6C\xF5"],
        ["\x6C\xF5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xB5"],

        ["\xE3\x82\xB6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6C\xF6"],
        ["\x6C\xF6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xB6"],

        ["\xE3\x82\xB7",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6C\xF7"],
        ["\x6C\xF7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xB7"],

        ["\xE3\x82\xB8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6C\xF8"],
        ["\x6C\xF8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xB8"],

        ["\xE3\x82\xB9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6C\xF9"],
        ["\x6C\xF9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xB9"],

        ["\xE3\x82\xBA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6C\x7A"],
        ["\x6C\x7A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xBA"],

        ["\xE3\x82\xBB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6C\x5E"],
        ["\x6C\x5E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xBB"],

        ["\xE3\x82\xBC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6C\x4C"],
        ["\x6C\x4C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xBC"],

        ["\xE3\x82\xBD",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6C\x7E"],
        ["\x6C\x7E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xBD"],

        ["\xE3\x82\xBE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6C\x6E"],
        ["\x6C\x6E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xBE"],

        ["\xE3\x82\xBF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6C\x6F"],
        ["\x6C\x6F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xBF"],

        ["\xE3\x83\x80",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6C\x7C"],
        ["\x6C\x7C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x80"],

        ["\xE3\x83\x81",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6C\xC1"],
        ["\x6C\xC1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x81"],

        ["\xE3\x83\x82",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6C\xC2"],
        ["\x6C\xC2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x82"],

        ["\xE3\x83\x83",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6C\xC3"],
        ["\x6C\xC3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x83"],

        ["\xE3\x83\x84",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6C\xC4"],
        ["\x6C\xC4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x84"],

        ["\xE3\x83\x85",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6C\xC5"],
        ["\x6C\xC5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x85"],

        ["\xE3\x83\x86",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6C\xC6"],
        ["\x6C\xC6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x86"],

        ["\xE3\x83\x87",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6C\xC7"],
        ["\x6C\xC7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x87"],

        ["\xE3\x83\x88",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6C\xC8"],
        ["\x6C\xC8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x88"],

        ["\xE3\x83\x89",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6C\xC9"],
        ["\x6C\xC9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x89"],

        ["\xE3\x83\x8A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6C\xD1"],
        ["\x6C\xD1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x8A"],

        ["\xE3\x83\x8B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6C\xD2"],
        ["\x6C\xD2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x8B"],

        ["\xE3\x83\x8C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6C\xD3"],
        ["\x6C\xD3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x8C"],

        ["\xE3\x83\x8D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6C\xD4"],
        ["\x6C\xD4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x8D"],

        ["\xE3\x83\x8E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6C\xD5"],
        ["\x6C\xD5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x8E"],

        ["\xE3\x83\x8F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6C\xD6"],
        ["\x6C\xD6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x8F"],

        ["\xE3\x83\x90",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6C\xD7"],
        ["\x6C\xD7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x90"],

        ["\xE3\x83\x91",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6C\xD8"],
        ["\x6C\xD8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x91"],

        ["\xE3\x83\x92",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6C\xD9"],
        ["\x6C\xD9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x92"],

        ["\xE3\x83\x93",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6C\xE2"],
        ["\x6C\xE2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x93"],

        ["\xE3\x83\x94",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6C\xE3"],
        ["\x6C\xE3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x94"],

        ["\xE3\x83\x95",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6C\xE4"],
        ["\x6C\xE4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x95"],

        ["\xE3\x83\x96",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6C\xE5"],
        ["\x6C\xE5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x96"],

        ["\xE3\x83\x97",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6C\xE6"],
        ["\x6C\xE6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x97"],

        ["\xE3\x83\x98",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6C\xE7"],
        ["\x6C\xE7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x98"],

        ["\xE3\x83\x99",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6C\xE8"],
        ["\x6C\xE8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x99"],

        ["\xE3\x83\x9A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6C\xE9"],
        ["\x6C\xE9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x9A"],

        ["\xE3\x83\x9B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6C\x4A"],
        ["\x6C\x4A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x9B"],

        ["\xE3\x83\x9C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6C\x5B"],
        ["\x6C\x5B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x9C"],

        ["\xE3\x83\x9D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6C\x5A"],
        ["\x6C\x5A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x9D"],

        ["\xE3\x83\x9E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6C\x5F"],
        ["\x6C\x5F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x9E"],

        ["\xE3\x83\x9F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6C\x6D"],
        ["\x6C\x6D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x9F"],

        ["\xE3\x83\xA0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6C\x79"],
        ["\x6C\x79",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xA0"],

        ["\xE3\x83\xA1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6C\x57"],
        ["\x6C\x57",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xA1"],

        ["\xE3\x83\xA2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6C\x59"],
        ["\x6C\x59",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xA2"],

        ["\xE3\x83\xA3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6C\x62"],
        ["\x6C\x62",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xA3"],

        ["\xE3\x83\xA4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6C\x63"],
        ["\x6C\x63",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xA4"],

        ["\xE3\x83\xA5",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6C\x64"],
        ["\x6C\x64",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xA5"],

        ["\xE3\x83\xA6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6C\x65"],
        ["\x6C\x65",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xA6"],

        ["\xE3\x83\xA7",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6C\x66"],
        ["\x6C\x66",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xA7"],

        ["\xE3\x83\xA8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6C\x67"],
        ["\x6C\x67",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xA8"],

        ["\xE3\x83\xA9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6C\x68"],
        ["\x6C\x68",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xA9"],

        ["\xE3\x83\xAA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6C\x69"],
        ["\x6C\x69",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xAA"],

        ["\xE3\x83\xAB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6C\x70"],
        ["\x6C\x70",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xAB"],

        ["\xE3\x83\xAC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6C\x71"],
        ["\x6C\x71",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xAC"],

        ["\xE3\x83\xAD",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6C\x72"],
        ["\x6C\x72",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xAD"],

        ["\xE3\x83\xAE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6C\x73"],
        ["\x6C\x73",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xAE"],

        ["\xE3\x83\xAF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6C\x74"],
        ["\x6C\x74",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xAF"],

        ["\xE3\x83\xB0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6C\x75"],
        ["\x6C\x75",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xB0"],

        ["\xE3\x83\xB1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6C\x76"],
        ["\x6C\x76",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xB1"],

        ["\xE3\x83\xB2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6C\x77"],
        ["\x6C\x77",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xB2"],

        ["\xE3\x83\xB3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6C\x78"],
        ["\x6C\x78",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xB3"],

        ["\xE3\x83\xB4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6C\x80"],
        ["\x6C\x80",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xB4"],

        ["\xE3\x83\xB5",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6C\x8B"],
        ["\x6C\x8B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xB5"],

        ["\xE3\x83\xB6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6C\x9B"],
        ["\x6C\x9B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xB6"],

        ["\xCE\x91",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x50\x4F"],
        ["\x50\x4F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\x91"],

        ["\xCE\x92",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x50\x7F"],
        ["\x50\x7F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\x92"],

        ["\xCE\x93",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x50\x7B"],
        ["\x50\x7B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\x93"],

        ["\xCE\x94",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x50\xE0"],
        ["\x50\xE0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\x94"],

        ["\xCE\x95",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x50\x6C"],
        ["\x50\x6C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\x95"],

        ["\xCE\x96",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x50\x50"],
        ["\x50\x50",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\x96"],

        ["\xCE\x97",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x50\x7D"],
        ["\x50\x7D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\x97"],

        ["\xCE\x98",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x50\x4D"],
        ["\x50\x4D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\x98"],

        ["\xCE\x99",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x50\x5D"],
        ["\x50\x5D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\x99"],

        ["\xCE\x9A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x50\x5C"],
        ["\x50\x5C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\x9A"],

        ["\xCE\x9B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x50\x4E"],
        ["\x50\x4E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\x9B"],

        ["\xCE\x9C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x50\x6B"],
        ["\x50\x6B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\x9C"],

        ["\xCE\x9D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x50\x60"],
        ["\x50\x60",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\x9D"],

        ["\xCE\x9E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x50\x4B"],
        ["\x50\x4B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\x9E"],

        ["\xCE\x9F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x50\x61"],
        ["\x50\x61",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\x9F"],

        ["\xCE\xA0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x50\xF0"],
        ["\x50\xF0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xA0"],

        ["\xCE\xA1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x50\xF1"],
        ["\x50\xF1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xA1"],

        ["\xCE\xA3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x50\xF2"],
        ["\x50\xF2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xA3"],

        ["\xCE\xA4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x50\xF3"],
        ["\x50\xF3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xA4"],

        ["\xCE\xA5",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x50\xF4"],
        ["\x50\xF4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xA5"],

        ["\xCE\xA6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x50\xF5"],
        ["\x50\xF5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xA6"],

        ["\xCE\xA7",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x50\xF6"],
        ["\x50\xF6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xA7"],

        ["\xCE\xA8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x50\xF7"],
        ["\x50\xF7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xA8"],

        ["\xCE\xA9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x50\xF8"],
        ["\x50\xF8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xA9"],

        ["\xCE\xB1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x50\xC1"],
        ["\x50\xC1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xB1"],

        ["\xCE\xB2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x50\xC2"],
        ["\x50\xC2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xB2"],

        ["\xCE\xB3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x50\xC3"],
        ["\x50\xC3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xB3"],

        ["\xCE\xB4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x50\xC4"],
        ["\x50\xC4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xB4"],

        ["\xCE\xB5",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x50\xC5"],
        ["\x50\xC5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xB5"],

        ["\xCE\xB6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x50\xC6"],
        ["\x50\xC6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xB6"],

        ["\xCE\xB7",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x50\xC7"],
        ["\x50\xC7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xB7"],

        ["\xCE\xB8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x50\xC8"],
        ["\x50\xC8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xB8"],

        ["\xCE\xB9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x50\xC9"],
        ["\x50\xC9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xB9"],

        ["\xCE\xBA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x50\xD1"],
        ["\x50\xD1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xBA"],

        ["\xCE\xBB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x50\xD2"],
        ["\x50\xD2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xBB"],

        ["\xCE\xBC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x50\xD3"],
        ["\x50\xD3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xBC"],

        ["\xCE\xBD",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x50\xD4"],
        ["\x50\xD4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xBD"],

        ["\xCE\xBE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x50\xD5"],
        ["\x50\xD5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xBE"],

        ["\xCE\xBF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x50\xD6"],
        ["\x50\xD6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xBF"],

        ["\xCF\x80",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x50\xD7"],
        ["\x50\xD7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xCF\x80"],

        ["\xCF\x81",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x50\xD8"],
        ["\x50\xD8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xCF\x81"],

        ["\xCF\x83",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x50\xD9"],
        ["\x50\xD9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xCF\x83"],

        ["\xCF\x84",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x50\xE2"],
        ["\x50\xE2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xCF\x84"],

        ["\xCF\x85",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x50\xE3"],
        ["\x50\xE3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xCF\x85"],

        ["\xCF\x86",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x50\xE4"],
        ["\x50\xE4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xCF\x86"],

        ["\xCF\x87",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x50\xE5"],
        ["\x50\xE5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xCF\x87"],

        ["\xCF\x88",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x50\xE6"],
        ["\x50\xE6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xCF\x88"],

        ["\xCF\x89",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x50\xE7"],
        ["\x50\xE7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xCF\x89"],

        ["\xD0\x90",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7D\x4F"],
        ["\x7D\x4F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\x90"],

        ["\xD0\x91",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7D\x7F"],
        ["\x7D\x7F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\x91"],

        ["\xD0\x92",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7D\x7B"],
        ["\x7D\x7B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\x92"],

        ["\xD0\x93",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7D\xE0"],
        ["\x7D\xE0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\x93"],

        ["\xD0\x94",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7D\x6C"],
        ["\x7D\x6C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\x94"],

        ["\xD0\x95",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7D\x50"],
        ["\x7D\x50",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\x95"],

        ["\xD0\x81",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7D\x7D"],
        ["\x7D\x7D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\x81"],

        ["\xD0\x96",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7D\x4D"],
        ["\x7D\x4D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\x96"],

        ["\xD0\x97",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7D\x5D"],
        ["\x7D\x5D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\x97"],

        ["\xD0\x98",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7D\x5C"],
        ["\x7D\x5C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\x98"],

        ["\xD0\x99",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7D\x4E"],
        ["\x7D\x4E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\x99"],

        ["\xD0\x9A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7D\x6B"],
        ["\x7D\x6B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\x9A"],

        ["\xD0\x9B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7D\x60"],
        ["\x7D\x60",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\x9B"],

        ["\xD0\x9C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7D\x4B"],
        ["\x7D\x4B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\x9C"],

        ["\xD0\x9D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7D\x61"],
        ["\x7D\x61",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\x9D"],

        ["\xD0\x9E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7D\xF0"],
        ["\x7D\xF0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\x9E"],

        ["\xD0\x9F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7D\xF1"],
        ["\x7D\xF1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\x9F"],

        ["\xD0\xA0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7D\xF2"],
        ["\x7D\xF2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xA0"],

        ["\xD0\xA1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7D\xF3"],
        ["\x7D\xF3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xA1"],

        ["\xD0\xA2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7D\xF4"],
        ["\x7D\xF4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xA2"],

        ["\xD0\xA3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7D\xF5"],
        ["\x7D\xF5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xA3"],

        ["\xD0\xA4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7D\xF6"],
        ["\x7D\xF6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xA4"],

        ["\xD0\xA5",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7D\xF7"],
        ["\x7D\xF7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xA5"],

        ["\xD0\xA6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7D\xF8"],
        ["\x7D\xF8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xA6"],

        ["\xD0\xA7",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7D\xF9"],
        ["\x7D\xF9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xA7"],

        ["\xD0\xA8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7D\x7A"],
        ["\x7D\x7A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xA8"],

        ["\xD0\xA9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7D\x5E"],
        ["\x7D\x5E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xA9"],

        ["\xD0\xAA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7D\x4C"],
        ["\x7D\x4C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xAA"],

        ["\xD0\xAB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7D\x7E"],
        ["\x7D\x7E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xAB"],

        ["\xD0\xAC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7D\x6E"],
        ["\x7D\x6E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xAC"],

        ["\xD0\xAD",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7D\x6F"],
        ["\x7D\x6F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xAD"],

        ["\xD0\xAE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7D\x7C"],
        ["\x7D\x7C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xAE"],

        ["\xD0\xAF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7D\xC1"],
        ["\x7D\xC1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xAF"],

        ["\xD0\xB0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7D\xD8"],
        ["\x7D\xD8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xB0"],

        ["\xD0\xB1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7D\xD9"],
        ["\x7D\xD9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xB1"],

        ["\xD0\xB2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7D\xE2"],
        ["\x7D\xE2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xB2"],

        ["\xD0\xB3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7D\xE3"],
        ["\x7D\xE3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xB3"],

        ["\xD0\xB4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7D\xE4"],
        ["\x7D\xE4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xB4"],

        ["\xD0\xB5",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7D\xE5"],
        ["\x7D\xE5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xB5"],

        ["\xD1\x91",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7D\xE6"],
        ["\x7D\xE6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\x91"],

        ["\xD0\xB6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7D\xE7"],
        ["\x7D\xE7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xB6"],

        ["\xD0\xB7",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7D\xE8"],
        ["\x7D\xE8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xB7"],

        ["\xD0\xB8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7D\xE9"],
        ["\x7D\xE9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xB8"],

        ["\xD0\xB9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7D\x4A"],
        ["\x7D\x4A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xB9"],

        ["\xD0\xBA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7D\x5B"],
        ["\x7D\x5B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xBA"],

        ["\xD0\xBB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7D\x5A"],
        ["\x7D\x5A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xBB"],

        ["\xD0\xBC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7D\x5F"],
        ["\x7D\x5F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xBC"],

        ["\xD0\xBD",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7D\x6D"],
        ["\x7D\x6D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xBD"],

        ["\xD0\xBE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7D\x79"],
        ["\x7D\x79",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xBE"],

        ["\xD0\xBF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7D\x57"],
        ["\x7D\x57",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xBF"],

        ["\xD1\x80",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7D\x59"],
        ["\x7D\x59",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\x80"],

        ["\xD1\x81",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7D\x62"],
        ["\x7D\x62",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\x81"],

        ["\xD1\x82",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7D\x63"],
        ["\x7D\x63",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\x82"],

        ["\xD1\x83",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7D\x64"],
        ["\x7D\x64",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\x83"],

        ["\xD1\x84",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7D\x65"],
        ["\x7D\x65",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\x84"],

        ["\xD1\x85",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7D\x66"],
        ["\x7D\x66",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\x85"],

        ["\xD1\x86",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7D\x67"],
        ["\x7D\x67",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\x86"],

        ["\xD1\x87",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7D\x68"],
        ["\x7D\x68",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\x87"],

        ["\xD1\x88",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7D\x69"],
        ["\x7D\x69",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\x88"],

        ["\xD1\x89",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7D\x70"],
        ["\x7D\x70",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\x89"],

        ["\xD1\x8A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7D\x71"],
        ["\x7D\x71",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\x8A"],

        ["\xD1\x8B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7D\x72"],
        ["\x7D\x72",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\x8B"],

        ["\xD1\x8C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7D\x73"],
        ["\x7D\x73",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\x8C"],

        ["\xD1\x8D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7D\x74"],
        ["\x7D\x74",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\x8D"],

        ["\xD1\x8E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7D\x75"],
        ["\x7D\x75",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\x8E"],

        ["\xD1\x8F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7D\x76"],
        ["\x7D\x76",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\x8F"],

        ["\xE2\x94\x80",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6B\xE0"],
        ["\x6B\xE0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\x80"],

        ["\xE2\x94\x82",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6B\x50"],
        ["\x6B\x50",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\x82"],

        ["\xE2\x94\x8C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6B\xF0"],
        ["\x6B\xF0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\x8C"],

        ["\xE2\x94\x90",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6B\xF4"],
        ["\x6B\xF4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\x90"],

        ["\xE2\x94\x98",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6B\x4C"],
        ["\x6B\x4C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\x98"],

        ["\xE2\x94\x94",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6B\xF8"],
        ["\x6B\xF8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\x94"],

        ["\xE2\x94\x9C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6B\x7C"],
        ["\x6B\x7C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\x9C"],

        ["\xE2\x94\xAC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6B\xD7"],
        ["\x6B\xD7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\xAC"],

        ["\xE2\x94\xA4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6B\xC8"],
        ["\x6B\xC8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\xA4"],

        ["\xE2\x94\xB4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6B\xE7"],
        ["\x6B\xE7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\xB4"],

        ["\xE2\x94\xBC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6B\x79"],
        ["\x6B\x79",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\xBC"],

        ["\xE2\x94\x81",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6B\x6C"],
        ["\x6B\x6C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\x81"],

        ["\xE2\x94\x83",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6B\x7D"],
        ["\x6B\x7D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\x83"],

        ["\xE2\x94\x8F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6B\xF3"],
        ["\x6B\xF3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\x8F"],

        ["\xE2\x94\x93",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6B\xF7"],
        ["\x6B\xF7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\x93"],

        ["\xE2\x94\x9B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6B\x6F"],
        ["\x6B\x6F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\x9B"],

        ["\xE2\x94\x97",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6B\x5E"],
        ["\x6B\x5E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\x97"],

        ["\xE2\x94\xA3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6B\xC7"],
        ["\x6B\xC7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\xA3"],

        ["\xE2\x94\xB3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6B\xE6"],
        ["\x6B\xE6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\xB3"],

        ["\xE2\x94\xAB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6B\xD6"],
        ["\x6B\xD6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\xAB"],

        ["\xE2\x94\xBB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6B\x6D"],
        ["\x6B\x6D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\xBB"],

        ["\xE2\x95\x8B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6B\x74"],
        ["\x6B\x74",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x95\x8B"],

        ["\xE2\x94\xA0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6B\xC4"],
        ["\x6B\xC4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\xA0"],

        ["\xE2\x94\xAF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6B\xE2"],
        ["\x6B\xE2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\xAF"],

        ["\xE2\x94\xA8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6B\xD3"],
        ["\x6B\xD3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\xA8"],

        ["\xE2\x94\xB7",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6B\x4A"],
        ["\x6B\x4A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\xB7"],

        ["\xE2\x94\xBF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6B\x62"],
        ["\x6B\x62",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\xBF"],

        ["\xE2\x94\x9D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6B\xC1"],
        ["\x6B\xC1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\x9D"],

        ["\xE2\x94\xB0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6B\xE3"],
        ["\x6B\xE3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\xB0"],

        ["\xE2\x94\xA5",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6B\xC9"],
        ["\x6B\xC9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\xA5"],

        ["\xE2\x94\xB8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6B\x5B"],
        ["\x6B\x5B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\xB8"],

        ["\xE2\x95\x82",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6B\x65"],
        ["\x6B\x65",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x95\x82"],

        ["\xE2\x91\xA0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x60\x4F"],
        ["\x60\x4F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x91\xA0"],

        ["\xE2\x91\xA1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x60\x7F"],
        ["\x60\x7F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x91\xA1"],

        ["\xE2\x91\xA2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x60\x7B"],
        ["\x60\x7B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x91\xA2"],

        ["\xE2\x91\xA3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x60\xE0"],
        ["\x60\xE0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x91\xA3"],

        ["\xE2\x91\xA4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x60\x6C"],
        ["\x60\x6C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x91\xA4"],

        ["\xE2\x91\xA5",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x60\x50"],
        ["\x60\x50",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x91\xA5"],

        ["\xE2\x91\xA6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x60\x7D"],
        ["\x60\x7D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x91\xA6"],

        ["\xE2\x91\xA7",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x60\x4D"],
        ["\x60\x4D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x91\xA7"],

        ["\xE2\x91\xA8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x60\x5D"],
        ["\x60\x5D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x91\xA8"],

        ["\xE2\x91\xA9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x60\x5C"],
        ["\x60\x5C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x91\xA9"],

        ["\xE2\x91\xAA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x60\x4E"],
        ["\x60\x4E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x91\xAA"],

        ["\xE2\x91\xAB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x60\x6B"],
        ["\x60\x6B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x91\xAB"],

        ["\xE2\x91\xAC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x60\x60"],
        ["\x60\x60",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x91\xAC"],

        ["\xE2\x91\xAD",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x60\x4B"],
        ["\x60\x4B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x91\xAD"],

        ["\xE2\x91\xAE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x60\x61"],
        ["\x60\x61",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x91\xAE"],

        ["\xE2\x91\xAF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x60\xF0"],
        ["\x60\xF0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x91\xAF"],

        ["\xE2\x91\xB0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x60\xF1"],
        ["\x60\xF1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x91\xB0"],

        ["\xE2\x91\xB1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x60\xF2"],
        ["\x60\xF2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x91\xB1"],

        ["\xE2\x91\xB2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x60\xF3"],
        ["\x60\xF3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x91\xB2"],

        ["\xE2\x91\xB3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x60\xF4"],
        ["\x60\xF4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x91\xB3"],

        ["\xE2\x85\xA0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x60\xF5"],
        ["\x60\xF5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x85\xA0"],

        ["\xE2\x85\xA1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x60\xF6"],
        ["\x60\xF6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x85\xA1"],

        ["\xE2\x85\xA2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x60\xF7"],
        ["\x60\xF7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x85\xA2"],

        ["\xE2\x85\xA3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x60\xF8"],
        ["\x60\xF8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x85\xA3"],

        ["\xE2\x85\xA4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x60\xF9"],
        ["\x60\xF9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x85\xA4"],

        ["\xE2\x85\xA5",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x60\x7A"],
        ["\x60\x7A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x85\xA5"],

        ["\xE2\x85\xA6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x60\x5E"],
        ["\x60\x5E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x85\xA6"],

        ["\xE2\x85\xA7",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x60\x4C"],
        ["\x60\x4C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x85\xA7"],

        ["\xE2\x85\xA8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x60\x7E"],
        ["\x60\x7E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x85\xA8"],

        ["\xE2\x85\xA9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x60\x6E"],
        ["\x60\x6E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x85\xA9"],

        ["\xE3\x8D\x89",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x60\x7C"],
        ["\x60\x7C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x8D\x89"],

        ["\xE3\x8C\x94",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x60\xC1"],
        ["\x60\xC1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x8C\x94"],

        ["\xE3\x8C\xA2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x60\xC2"],
        ["\x60\xC2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x8C\xA2"],

        ["\xE3\x8D\x8D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x60\xC3"],
        ["\x60\xC3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x8D\x8D"],

        ["\xE3\x8C\x98",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x60\xC4"],
        ["\x60\xC4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x8C\x98"],

        ["\xE3\x8C\xA7",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x60\xC5"],
        ["\x60\xC5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x8C\xA7"],

        ["\xE3\x8C\x83",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x60\xC6"],
        ["\x60\xC6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x8C\x83"],

        ["\xE3\x8C\xB6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x60\xC7"],
        ["\x60\xC7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x8C\xB6"],

        ["\xE3\x8D\x91",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x60\xC8"],
        ["\x60\xC8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x8D\x91"],

        ["\xE3\x8D\x97",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x60\xC9"],
        ["\x60\xC9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x8D\x97"],

        ["\xE3\x8C\x8D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x60\xD1"],
        ["\x60\xD1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x8C\x8D"],

        ["\xE3\x8C\xA6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x60\xD2"],
        ["\x60\xD2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x8C\xA6"],

        ["\xE3\x8C\xA3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x60\xD3"],
        ["\x60\xD3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x8C\xA3"],

        ["\xE3\x8C\xAB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x60\xD4"],
        ["\x60\xD4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x8C\xAB"],

        ["\xE3\x8D\x8A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x60\xD5"],
        ["\x60\xD5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x8D\x8A"],

        ["\xE3\x8C\xBB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x60\xD6"],
        ["\x60\xD6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x8C\xBB"],

        ["\xE3\x8E\x9C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x60\xD7"],
        ["\x60\xD7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x8E\x9C"],

        ["\xE3\x8E\x9D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x60\xD8"],
        ["\x60\xD8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x8E\x9D"],

        ["\xE3\x8E\x9E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x60\xD9"],
        ["\x60\xD9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x8E\x9E"],

        ["\xE3\x8E\x8E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x60\xE2"],
        ["\x60\xE2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x8E\x8E"],

        ["\xE3\x8E\x8F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x60\xE3"],
        ["\x60\xE3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x8E\x8F"],

        ["\xE3\x8F\x84",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x60\xE4"],
        ["\x60\xE4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x8F\x84"],

        ["\xE3\x8E\xA1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x60\xE5"],
        ["\x60\xE5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x8E\xA1"],

        ["\xE3\x8D\xBB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x60\x6D"],
        ["\x60\x6D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x8D\xBB"],

        ["\xE3\x80\x9D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x60\x79"],
        ["\x60\x79",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x9D"],

        ["\xE3\x80\x9F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x60\x57"],
        ["\x60\x57",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x9F"],

        ["\xE2\x84\x96",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x60\x59"],
        ["\x60\x59",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x84\x96"],

        ["\xE3\x8F\x8D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x60\x62"],
        ["\x60\x62",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x8F\x8D"],

        ["\xE2\x84\xA1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x60\x63"],
        ["\x60\x63",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x84\xA1"],

        ["\xE3\x8A\xA4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x60\x64"],
        ["\x60\x64",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x8A\xA4"],

        ["\xE3\x8A\xA5",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x60\x65"],
        ["\x60\x65",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x8A\xA5"],

        ["\xE3\x8A\xA6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x60\x66"],
        ["\x60\x66",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x8A\xA6"],

        ["\xE3\x8A\xA7",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x60\x67"],
        ["\x60\x67",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x8A\xA7"],

        ["\xE3\x8A\xA8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x60\x68"],
        ["\x60\x68",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x8A\xA8"],

        ["\xE3\x88\xB1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x60\x69"],
        ["\x60\x69",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x88\xB1"],

        ["\xE3\x88\xB2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x60\x70"],
        ["\x60\x70",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x88\xB2"],

        ["\xE3\x88\xB9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x60\x71"],
        ["\x60\x71",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x88\xB9"],

        ["\xE3\x8D\xBE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x60\x72"],
        ["\x60\x72",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x8D\xBE"],

        ["\xE3\x8D\xBD",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x60\x73"],
        ["\x60\x73",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x8D\xBD"],

        ["\xE3\x8D\xBC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x60\x74"],
        ["\x60\x74",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x8D\xBC"],

        ["\xE2\x88\xAE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x60\x78"],
        ["\x60\x78",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x88\xAE"],

        ["\xE2\x88\x91",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x60\x80"],
        ["\x60\x80",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x88\x91"],

        ["\xE2\x88\x9F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x60\xA0"],
        ["\x60\xA0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x88\x9F"],

        ["\xE2\x8A\xBF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x60\xAB"],
        ["\x60\xAB",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x8A\xBF"],

        ["\xE4\xBA\x9C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF0\x4F"],
        ["\xF0\x4F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\x9C"],

        ["\xE5\x94\x96",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF0\x7F"],
        ["\xF0\x7F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x94\x96"],

        ["\xE5\xA8\x83",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF0\x7B"],
        ["\xF0\x7B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA8\x83"],

        ["\xE9\x98\xBF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF0\xE0"],
        ["\xF0\xE0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x98\xBF"],

        ["\xE5\x93\x80",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF0\x6C"],
        ["\xF0\x6C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x93\x80"],

        ["\xE6\x84\x9B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF0\x50"],
        ["\xF0\x50",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\x9B"],

        ["\xE6\x8C\xA8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF0\x7D"],
        ["\xF0\x7D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8C\xA8"],

        ["\xE5\xA7\xB6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF0\x4D"],
        ["\xF0\x4D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA7\xB6"],

        ["\xE9\x80\xA2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF0\x5D"],
        ["\xF0\x5D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\xA2"],

        ["\xE8\x91\xB5",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF0\x5C"],
        ["\xF0\x5C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x91\xB5"],

        ["\xE8\x8C\x9C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF0\x4E"],
        ["\xF0\x4E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C\x9C"],

        ["\xE7\xA9\x90",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF0\x6B"],
        ["\xF0\x6B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\x90"],

        ["\xE6\x82\xAA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF0\x60"],
        ["\xF0\x60",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\xAA"],

        ["\xE6\x8F\xA1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF0\x4B"],
        ["\xF0\x4B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8F\xA1"],

        ["\xE6\xB8\xA5",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF0\x61"],
        ["\xF0\x61",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\xA5"],

        ["\xE6\x97\xAD",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF0\xF0"],
        ["\xF0\xF0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\xAD"],

        ["\xE8\x91\xA6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF0\xF1"],
        ["\xF0\xF1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x91\xA6"],

        ["\xE8\x8A\xA6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF0\xF2"],
        ["\xF0\xF2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8A\xA6"],

        ["\xE9\xAF\xB5",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x77\xD4"],
        ["\x77\xD4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xAF\xB5"],

        ["\xE6\xA2\x93",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF0\xF4"],
        ["\xF0\xF4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\x93"],

        ["\xE5\x9C\xA7",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF0\xF5"],
        ["\xF0\xF5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C\xA7"],

        ["\xE6\x96\xA1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF0\xF6"],
        ["\xF0\xF6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\xA1"],

        ["\xE6\x89\xB1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF0\xF7"],
        ["\xF0\xF7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\xB1"],

        ["\xE5\xAE\x9B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF0\xF8"],
        ["\xF0\xF8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\x9B"],

        ["\xE5\xA7\x90",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF0\xF9"],
        ["\xF0\xF9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA7\x90"],

        ["\xE8\x99\xBB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF0\x7A"],
        ["\xF0\x7A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x99\xBB"],

        ["\xE9\xA3\xB4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF0\x5E"],
        ["\xF0\x5E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA3\xB4"],

        ["\xE7\xB5\xA2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF0\x4C"],
        ["\xF0\x4C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\xA2"],

        ["\xE7\xB6\xBE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF0\x7E"],
        ["\xF0\x7E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\xBE"],

        ["\xE9\xAE\x8E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF0\x6E"],
        ["\xF0\x6E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xAE\x8E"],

        ["\xE6\x88\x96",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF0\x6F"],
        ["\xF0\x6F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\x96"],

        ["\xE7\xB2\x9F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF0\x7C"],
        ["\xF0\x7C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\x9F"],

        ["\xE8\xA2\xB7",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF0\xC1"],
        ["\xF0\xC1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA2\xB7"],

        ["\xE5\xAE\x89",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF0\xC2"],
        ["\xF0\xC2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\x89"],

        ["\xE5\xBA\xB5",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF0\xC3"],
        ["\xF0\xC3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBA\xB5"],

        ["\xE6\x8C\x89",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF0\xC4"],
        ["\xF0\xC4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8C\x89"],

        ["\xE6\x9A\x97",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF0\xC5"],
        ["\xF0\xC5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A\x97"],

        ["\xE6\xA1\x88",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF0\xC6"],
        ["\xF0\xC6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\x88"],

        ["\xE9\x97\x87",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF0\xC7"],
        ["\xF0\xC7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x97\x87"],

        ["\xE9\x9E\x8D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF0\xC8"],
        ["\xF0\xC8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9E\x8D"],

        ["\xE6\x9D\x8F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF0\xC9"],
        ["\xF0\xC9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\x8F"],

        ["\xE4\xBB\xA5",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF0\xD1"],
        ["\xF0\xD1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\xA5"],

        ["\xE4\xBC\x8A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF0\xD2"],
        ["\xF0\xD2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBC\x8A"],

        ["\xE4\xBD\x8D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF0\xD3"],
        ["\xF0\xD3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\x8D"],

        ["\xE4\xBE\x9D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF0\xD4"],
        ["\xF0\xD4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE\x9D"],

        ["\xE5\x81\x89",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF0\xD5"],
        ["\xF0\xD5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x81\x89"],

        ["\xE5\x9B\xB2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF0\xD6"],
        ["\xF0\xD6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B\xB2"],

        ["\xE5\xA4\xB7",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF0\xD7"],
        ["\xF0\xD7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\xB7"],

        ["\xE5\xA7\x94",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF0\xD8"],
        ["\xF0\xD8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA7\x94"],

        ["\xE5\xA8\x81",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF0\xD9"],
        ["\xF0\xD9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA8\x81"],

        ["\xE5\xB0\x89",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF0\xE2"],
        ["\xF0\xE2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\x89"],

        ["\xE6\x83\x9F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF0\xE3"],
        ["\xF0\xE3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\x9F"],

        ["\xE6\x84\x8F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF0\xE4"],
        ["\xF0\xE4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\x8F"],

        ["\xE6\x85\xB0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF0\xE5"],
        ["\xF0\xE5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\xB0"],

        ["\xE6\x98\x93",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF0\xE6"],
        ["\xF0\xE6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\x93"],

        ["\xE6\xA4\x85",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF0\xE7"],
        ["\xF0\xE7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\x85"],

        ["\xE7\x82\xBA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF0\xE8"],
        ["\xF0\xE8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x82\xBA"],

        ["\xE7\x95\x8F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF0\xE9"],
        ["\xF0\xE9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\x8F"],

        ["\xE7\x95\xB0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF0\x4A"],
        ["\xF0\x4A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\xB0"],

        ["\xE7\xA7\xBB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF0\x5B"],
        ["\xF0\x5B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA7\xBB"],

        ["\xE7\xB6\xAD",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF0\x5A"],
        ["\xF0\x5A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\xAD"],

        ["\xE7\xB7\xAF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF0\x5F"],
        ["\xF0\x5F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7\xAF"],

        ["\xE8\x83\x83",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF0\x6D"],
        ["\xF0\x6D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x83\x83"],

        ["\xE8\x90\x8E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF0\x79"],
        ["\xF0\x79",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x90\x8E"],

        ["\xE8\xA1\xA3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF0\x57"],
        ["\xF0\x57",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\xA3"],

        ["\xE8\xAC\x82",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF0\x59"],
        ["\xF0\x59",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC\x82"],

        ["\xE9\x81\x95",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF0\x62"],
        ["\xF0\x62",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\x95"],

        ["\xE9\x81\xBA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF0\x63"],
        ["\xF0\x63",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\xBA"],

        ["\xE5\x8C\xBB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF0\x64"],
        ["\xF0\x64",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\xBB"],

        ["\xE4\xBA\x95",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF0\x65"],
        ["\xF0\x65",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\x95"],

        ["\xE4\xBA\xA5",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF0\x66"],
        ["\xF0\x66",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\xA5"],

        ["\xE5\x9F\x9F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF0\x67"],
        ["\xF0\x67",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9F\x9F"],

        ["\xE8\x82\xB2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF0\x68"],
        ["\xF0\x68",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x82\xB2"],

        ["\xE9\x83\x81",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF0\x69"],
        ["\xF0\x69",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x83\x81"],

        ["\xE7\xA3\xAF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF0\x70"],
        ["\xF0\x70",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA3\xAF"],

        ["\xE4\xB8\x80",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF0\x71"],
        ["\xF0\x71",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\x80"],

        ["\xE5\xA3\xB1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF0\x72"],
        ["\xF0\x72",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\xB1"],

        ["\xE6\xBA\xA2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF0\x73"],
        ["\xF0\x73",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBA\xA2"],

        ["\xE9\x80\xB8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF0\x74"],
        ["\xF0\x74",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\xB8"],

        ["\xE7\xA8\xB2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF0\x75"],
        ["\xF0\x75",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8\xB2"],

        ["\xE8\x8C\xA8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF0\x76"],
        ["\xF0\x76",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C\xA8"],

        ["\xE8\x8A\x8B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF0\x77"],
        ["\xF0\x77",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8A\x8B"],

        ["\xE9\xB0\xAF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF0\x78"],
        ["\xF0\x78",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0\xAF"],

        ["\xE5\x85\x81",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF0\x80"],
        ["\xF0\x80",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\x81"],

        ["\xE5\x8D\xB0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF0\x8B"],
        ["\xF0\x8B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\xB0"],

        ["\xE5\x92\xBD",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF0\x9B"],
        ["\xF0\x9B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\xBD"],

        ["\xE5\x93\xA1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF0\x9C"],
        ["\xF0\x9C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x93\xA1"],

        ["\xE5\x9B\xA0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF0\xA0"],
        ["\xF0\xA0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B\xA0"],

        ["\xE5\xA7\xBB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF0\xAB"],
        ["\xF0\xAB",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA7\xBB"],

        ["\xE5\xBC\x95",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF0\xB0"],
        ["\xF0\xB0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\x95"],

        ["\xE9\xA3\xB2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF0\xC0"],
        ["\xF0\xC0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA3\xB2"],

        ["\xE6\xB7\xAB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF0\x6A"],
        ["\xF0\x6A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\xAB"],

        ["\xE8\x83\xA4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF0\xD0"],
        ["\xF0\xD0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x83\xA4"],

        ["\xE8\x94\xAD",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF0\xA1"],
        ["\xF0\xA1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x94\xAD"],

        ["\xE9\x99\xA2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF1\x4F"],
        ["\xF1\x4F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x99\xA2"],

        ["\xE9\x99\xB0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF1\x7F"],
        ["\xF1\x7F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x99\xB0"],

        ["\xE9\x9A\xA0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF1\x7B"],
        ["\xF1\x7B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\xA0"],

        ["\xE9\x9F\xBB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF1\xE0"],
        ["\xF1\xE0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9F\xBB"],

        ["\xE5\x90\x8B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF1\x6C"],
        ["\xF1\x6C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\x8B"],

        ["\xE5\x8F\xB3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF1\x50"],
        ["\xF1\x50",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\xB3"],

        ["\xE5\xAE\x87",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF1\x7D"],
        ["\xF1\x7D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\x87"],

        ["\xE7\x83\x8F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF1\x4D"],
        ["\xF1\x4D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x83\x8F"],

        ["\xE7\xBE\xBD",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF1\x5D"],
        ["\xF1\x5D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\xBD"],

        ["\xE8\xBF\x82",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF1\x5C"],
        ["\xF1\x5C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF\x82"],

        ["\xE9\x9B\xA8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF1\x4E"],
        ["\xF1\x4E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\xA8"],

        ["\xE5\x8D\xAF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF1\x6B"],
        ["\xF1\x6B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\xAF"],

        ["\xE9\xB5\x9C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF1\x60"],
        ["\xF1\x60",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB5\x9C"],

        ["\xE7\xAA\xBA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF1\x4B"],
        ["\xF1\x4B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAA\xBA"],

        ["\xE4\xB8\x91",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF1\x61"],
        ["\xF1\x61",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\x91"],

        ["\xE7\xA2\x93",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF1\xF0"],
        ["\xF1\xF0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA2\x93"],

        ["\xE8\x87\xBC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF1\xF1"],
        ["\xF1\xF1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\xBC"],

        ["\xE6\xB8\xA6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF1\xF2"],
        ["\xF1\xF2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\xA6"],

        ["\xE5\x98\x98",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF1\xF3"],
        ["\xF1\xF3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x98\x98"],

        ["\xE5\x94\x84",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF1\xF4"],
        ["\xF1\xF4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x94\x84"],

        ["\xE6\xAC\x9D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF1\xF5"],
        ["\xF1\xF5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAC\x9D"],

        ["\xE8\x94\x9A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF1\xF6"],
        ["\xF1\xF6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x94\x9A"],

        ["\xE9\xB0\xBB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF1\xF7"],
        ["\xF1\xF7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0\xBB"],

        ["\xE5\xA7\xA5",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF1\xF8"],
        ["\xF1\xF8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA7\xA5"],

        ["\xE5\x8E\xA9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF1\xF9"],
        ["\xF1\xF9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8E\xA9"],

        ["\xE6\xB5\xA6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF1\x7A"],
        ["\xF1\x7A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB5\xA6"],

        ["\xE7\x93\x9C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF1\x5E"],
        ["\xF1\x5E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x93\x9C"],

        ["\xE9\x96\x8F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF1\x4C"],
        ["\xF1\x4C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\x8F"],

        ["\xE5\x99\x82",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF1\x7E"],
        ["\xF1\x7E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x99\x82"],

        ["\xE4\xBA\x91",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF1\x6E"],
        ["\xF1\x6E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\x91"],

        ["\xE9\x81\x8B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF1\x6F"],
        ["\xF1\x6F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\x8B"],

        ["\xE9\x9B\xB2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF1\x7C"],
        ["\xF1\x7C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\xB2"],

        ["\xE8\x8D\x8F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF1\xC1"],
        ["\xF1\xC1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8D\x8F"],

        ["\xE9\xA4\x8C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF1\xC2"],
        ["\xF1\xC2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA4\x8C"],

        ["\xE5\x8F\xA1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF1\xC3"],
        ["\xF1\xC3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\xA1"],

        ["\xE5\x96\xB6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF1\xC4"],
        ["\xF1\xC4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x96\xB6"],

        ["\xE5\xAC\xB0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF1\xC5"],
        ["\xF1\xC5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAC\xB0"],

        ["\xE5\xBD\xB1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF1\xC6"],
        ["\xF1\xC6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\xB1"],

        ["\xE6\x98\xA0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF1\xC7"],
        ["\xF1\xC7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\xA0"],

        ["\xE6\x9B\xB3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF1\xC8"],
        ["\xF1\xC8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\xB3"],

        ["\xE6\xA0\x84",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF1\xC9"],
        ["\xF1\xC9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA0\x84"],

        ["\xE6\xB0\xB8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF1\xD1"],
        ["\xF1\xD1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB0\xB8"],

        ["\xE6\xB3\xB3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF1\xD2"],
        ["\xF1\xD2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\xB3"],

        ["\xE6\xB4\xA9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF1\xD3"],
        ["\xF1\xD3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4\xA9"],

        ["\xE7\x91\x9B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF1\xD4"],
        ["\xF1\xD4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x91\x9B"],

        ["\xE7\x9B\x88",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF1\xD5"],
        ["\xF1\xD5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\x88"],

        ["\xE7\xA9\x8E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF1\xD6"],
        ["\xF1\xD6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\x8E"],

        ["\xE9\xA0\xB4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF1\xD7"],
        ["\xF1\xD7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0\xB4"],

        ["\xE8\x8B\xB1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF1\xD8"],
        ["\xF1\xD8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8B\xB1"],

        ["\xE8\xA1\x9B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF1\xD9"],
        ["\xF1\xD9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\x9B"],

        ["\xE8\xA9\xA0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF1\xE2"],
        ["\xF1\xE2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\xA0"],

        ["\xE9\x8B\xAD",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF1\xE3"],
        ["\xF1\xE3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8B\xAD"],

        ["\xE6\xB6\xB2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF1\xE4"],
        ["\xF1\xE4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB6\xB2"],

        ["\xE7\x96\xAB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF1\xE5"],
        ["\xF1\xE5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x96\xAB"],

        ["\xE7\x9B\x8A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF1\xE6"],
        ["\xF1\xE6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\x8A"],

        ["\xE9\xA7\x85",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF1\xE7"],
        ["\xF1\xE7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA7\x85"],

        ["\xE6\x82\xA6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF1\xE8"],
        ["\xF1\xE8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\xA6"],

        ["\xE8\xAC\x81",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF1\xE9"],
        ["\xF1\xE9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC\x81"],

        ["\xE8\xB6\x8A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF1\x4A"],
        ["\xF1\x4A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB6\x8A"],

        ["\xE9\x96\xB2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF1\x5B"],
        ["\xF1\x5B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\xB2"],

        ["\xE6\xA6\x8E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF1\x5A"],
        ["\xF1\x5A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA6\x8E"],

        ["\xE5\x8E\xAD",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF1\x5F"],
        ["\xF1\x5F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8E\xAD"],

        ["\xE5\x86\x86",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF1\x6D"],
        ["\xF1\x6D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\x86"],

        ["\xE5\x9C\x92",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF1\x79"],
        ["\xF1\x79",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C\x92"],

        ["\xE5\xA0\xB0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF1\x57"],
        ["\xF1\x57",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA0\xB0"],

        ["\xE5\xA5\x84",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF1\x59"],
        ["\xF1\x59",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\x84"],

        ["\xE5\xAE\xB4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF1\x62"],
        ["\xF1\x62",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\xB4"],

        ["\xE5\xBB\xB6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF1\x63"],
        ["\xF1\x63",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\xB6"],

        ["\xE6\x80\xA8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF1\x64"],
        ["\xF1\x64",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x80\xA8"],

        ["\xE6\x8E\xA9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF1\x65"],
        ["\xF1\x65",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\xA9"],

        ["\xE6\x8F\xB4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF1\x66"],
        ["\xF1\x66",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8F\xB4"],

        ["\xE6\xB2\xBF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF1\x67"],
        ["\xF1\x67",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\xBF"],

        ["\xE6\xBC\x94",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF1\x68"],
        ["\xF1\x68",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBC\x94"],

        ["\xE7\x82\x8E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF1\x69"],
        ["\xF1\x69",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x82\x8E"],

        ["\xE7\x84\x94",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF1\x70"],
        ["\xF1\x70",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x84\x94"],

        ["\xE7\x85\x99",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF1\x71"],
        ["\xF1\x71",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x85\x99"],

        ["\xE7\x87\x95",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF1\x72"],
        ["\xF1\x72",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x87\x95"],

        ["\xE7\x8C\xBF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF1\x73"],
        ["\xF1\x73",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8C\xBF"],

        ["\xE7\xB8\x81",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF1\x74"],
        ["\xF1\x74",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\x81"],

        ["\xE8\x89\xB6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF1\x75"],
        ["\xF1\x75",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x89\xB6"],

        ["\xE8\x8B\x91",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF1\x76"],
        ["\xF1\x76",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8B\x91"],

        ["\xE8\x96\x97",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF1\x77"],
        ["\xF1\x77",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\x97"],

        ["\xE9\x81\xA0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF1\x78"],
        ["\xF1\x78",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\xA0"],

        ["\xE9\x89\x9B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF1\x80"],
        ["\xF1\x80",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x89\x9B"],

        ["\xE9\xB4\x9B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF1\x8B"],
        ["\xF1\x8B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB4\x9B"],

        ["\xE5\xA1\xA9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF1\x9B"],
        ["\xF1\x9B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA1\xA9"],

        ["\xE6\x96\xBC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF1\x9C"],
        ["\xF1\x9C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\xBC"],

        ["\xE6\xB1\x9A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF1\xA0"],
        ["\xF1\xA0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1\x9A"],

        ["\xE7\x94\xA5",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF1\xAB"],
        ["\xF1\xAB",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\xA5"],

        ["\xE5\x87\xB9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF1\xB0"],
        ["\xF1\xB0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\xB9"],

        ["\xE5\xA4\xAE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF1\xC0"],
        ["\xF1\xC0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\xAE"],

        ["\xE5\xA5\xA5",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF1\x6A"],
        ["\xF1\x6A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\xA5"],

        ["\xE5\xBE\x80",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF1\xD0"],
        ["\xF1\xD0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\x80"],

        ["\xE5\xBF\x9C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF1\xA1"],
        ["\xF1\xA1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF\x9C"],

        ["\xE6\x8A\xBC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF2\x4F"],
        ["\xF2\x4F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A\xBC"],

        ["\xE6\x97\xBA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF2\x7F"],
        ["\xF2\x7F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\xBA"],

        ["\xE6\xA8\xAA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF2\x7B"],
        ["\xF2\x7B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\xAA"],

        ["\xE6\xAC\xA7",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF2\xE0"],
        ["\xF2\xE0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAC\xA7"],

        ["\xE6\xAE\xB4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF2\x6C"],
        ["\xF2\x6C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\xB4"],

        ["\xE7\x8E\x8B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF2\x50"],
        ["\xF2\x50",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8E\x8B"],

        ["\xE7\xBF\x81",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF2\x7D"],
        ["\xF2\x7D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBF\x81"],

        ["\xE8\xA5\x96",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF2\x4D"],
        ["\xF2\x4D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA5\x96"],

        ["\xE9\xB4\xAC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x77\x80"],
        ["\x77\x80",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB4\xAC"],

        ["\xE9\xB4\x8E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF2\x5C"],
        ["\xF2\x5C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB4\x8E"],

        ["\xE9\xBB\x84",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF2\x4E"],
        ["\xF2\x4E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xBB\x84"],

        ["\xE5\xB2\xA1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF2\x6B"],
        ["\xF2\x6B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB2\xA1"],

        ["\xE6\xB2\x96",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF2\x60"],
        ["\xF2\x60",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\x96"],

        ["\xE8\x8D\xBB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF2\x4B"],
        ["\xF2\x4B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8D\xBB"],

        ["\xE5\x84\x84",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF2\x61"],
        ["\xF2\x61",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x84\x84"],

        ["\xE5\xB1\x8B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF2\xF0"],
        ["\xF2\xF0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\x8B"],

        ["\xE6\x86\xB6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF2\xF1"],
        ["\xF2\xF1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x86\xB6"],

        ["\xE8\x87\x86",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF2\xF2"],
        ["\xF2\xF2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\x86"],

        ["\xE6\xA1\xB6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF2\xF3"],
        ["\xF2\xF3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\xB6"],

        ["\xE7\x89\xA1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF2\xF4"],
        ["\xF2\xF4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x89\xA1"],

        ["\xE4\xB9\x99",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF2\xF5"],
        ["\xF2\xF5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xB9\x99"],

        ["\xE4\xBF\xBA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF2\xF6"],
        ["\xF2\xF6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\xBA"],

        ["\xE5\x8D\xB8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF2\xF7"],
        ["\xF2\xF7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\xB8"],

        ["\xE6\x81\xA9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF2\xF8"],
        ["\xF2\xF8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\xA9"],

        ["\xE6\xB8\xA9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF2\xF9"],
        ["\xF2\xF9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\xA9"],

        ["\xE7\xA9\x8F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF2\x7A"],
        ["\xF2\x7A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\x8F"],

        ["\xE9\x9F\xB3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF2\x5E"],
        ["\xF2\x5E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9F\xB3"],

        ["\xE4\xB8\x8B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF2\x4C"],
        ["\xF2\x4C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\x8B"],

        ["\xE5\x8C\x96",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF2\x7E"],
        ["\xF2\x7E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\x96"],

        ["\xE4\xBB\xAE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF2\x6E"],
        ["\xF2\x6E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\xAE"],

        ["\xE4\xBD\x95",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF2\x6F"],
        ["\xF2\x6F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\x95"],

        ["\xE4\xBC\xBD",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF2\x7C"],
        ["\xF2\x7C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBC\xBD"],

        ["\xE4\xBE\xA1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF2\xC1"],
        ["\xF2\xC1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE\xA1"],

        ["\xE4\xBD\xB3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF2\xC2"],
        ["\xF2\xC2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\xB3"],

        ["\xE5\x8A\xA0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF2\xC3"],
        ["\xF2\xC3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\xA0"],

        ["\xE5\x8F\xAF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF2\xC4"],
        ["\xF2\xC4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\xAF"],

        ["\xE5\x98\x89",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF2\xC5"],
        ["\xF2\xC5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x98\x89"],

        ["\xE5\xA4\x8F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF2\xC6"],
        ["\xF2\xC6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\x8F"],

        ["\xE5\xAB\x81",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF2\xC7"],
        ["\xF2\xC7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAB\x81"],

        ["\xE5\xAE\xB6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF2\xC8"],
        ["\xF2\xC8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\xB6"],

        ["\xE5\xAF\xA1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF2\xC9"],
        ["\xF2\xC9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\xA1"],

        ["\xE7\xA7\x91",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF2\xD1"],
        ["\xF2\xD1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA7\x91"],

        ["\xE6\x9A\x87",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF2\xD2"],
        ["\xF2\xD2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A\x87"],

        ["\xE6\x9E\x9C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF2\xD3"],
        ["\xF2\xD3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E\x9C"],

        ["\xE6\x9E\xB6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF2\xD4"],
        ["\xF2\xD4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E\xB6"],

        ["\xE6\xAD\x8C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF2\xD5"],
        ["\xF2\xD5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\x8C"],

        ["\xE6\xB2\xB3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF2\xD6"],
        ["\xF2\xD6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\xB3"],

        ["\xE7\x81\xAB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF2\xD7"],
        ["\xF2\xD7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x81\xAB"],

        ["\xE7\x8F\x82",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF2\xD8"],
        ["\xF2\xD8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8F\x82"],

        ["\xE7\xA6\x8D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF2\xD9"],
        ["\xF2\xD9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6\x8D"],

        ["\xE7\xA6\xBE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF2\xE2"],
        ["\xF2\xE2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6\xBE"],

        ["\xE7\xA8\xBC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF2\xE3"],
        ["\xF2\xE3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8\xBC"],

        ["\xE7\xAE\x87",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF2\xE4"],
        ["\xF2\xE4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAE\x87"],

        ["\xE8\x8A\xB1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF2\xE5"],
        ["\xF2\xE5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8A\xB1"],

        ["\xE8\x8B\x9B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF2\xE6"],
        ["\xF2\xE6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8B\x9B"],

        ["\xE8\x8C\x84",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF2\xE7"],
        ["\xF2\xE7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C\x84"],

        ["\xE8\x8D\xB7",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF2\xE8"],
        ["\xF2\xE8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8D\xB7"],

        ["\xE8\x8F\xAF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF2\xE9"],
        ["\xF2\xE9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F\xAF"],

        ["\xE8\x8F\x93",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF2\x4A"],
        ["\xF2\x4A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F\x93"],

        ["\xE8\x9D\xA6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF2\x5B"],
        ["\xF2\x5B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9D\xA6"],

        ["\xE8\xAA\xB2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF2\x5A"],
        ["\xF2\x5A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\xB2"],

        ["\xE5\x98\xA9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF2\x5F"],
        ["\xF2\x5F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x98\xA9"],

        ["\xE8\xB2\xA8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF2\x6D"],
        ["\xF2\x6D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\xA8"],

        ["\xE8\xBF\xA6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF2\x79"],
        ["\xF2\x79",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF\xA6"],

        ["\xE9\x81\x8E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF2\x57"],
        ["\xF2\x57",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\x8E"],

        ["\xE9\x9C\x9E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF2\x59"],
        ["\xF2\x59",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9C\x9E"],

        ["\xE8\x9A\x8A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF2\x62"],
        ["\xF2\x62",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9A\x8A"],

        ["\xE4\xBF\x84",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF2\x63"],
        ["\xF2\x63",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\x84"],

        ["\xE5\xB3\xA8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF2\x64"],
        ["\xF2\x64",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB3\xA8"],

        ["\xE6\x88\x91",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF2\x65"],
        ["\xF2\x65",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\x91"],

        ["\xE7\x89\x99",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF2\x66"],
        ["\xF2\x66",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x89\x99"],

        ["\xE7\x94\xBB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF2\x67"],
        ["\xF2\x67",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\xBB"],

        ["\xE8\x87\xA5",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF2\x68"],
        ["\xF2\x68",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\xA5"],

        ["\xE8\x8A\xBD",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF2\x69"],
        ["\xF2\x69",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8A\xBD"],

        ["\xE8\x9B\xBE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF2\x70"],
        ["\xF2\x70",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9B\xBE"],

        ["\xE8\xB3\x80",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF2\x71"],
        ["\xF2\x71",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\x80"],

        ["\xE9\x9B\x85",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF2\x72"],
        ["\xF2\x72",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\x85"],

        ["\xE9\xA4\x93",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF2\x73"],
        ["\xF2\x73",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA4\x93"],

        ["\xE9\xA7\x95",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF2\x74"],
        ["\xF2\x74",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA7\x95"],

        ["\xE4\xBB\x8B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF2\x75"],
        ["\xF2\x75",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\x8B"],

        ["\xE4\xBC\x9A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF2\x76"],
        ["\xF2\x76",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBC\x9A"],

        ["\xE8\xA7\xA3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF2\x77"],
        ["\xF2\x77",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA7\xA3"],

        ["\xE5\x9B\x9E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF2\x78"],
        ["\xF2\x78",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B\x9E"],

        ["\xE5\xA1\x8A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF2\x80"],
        ["\xF2\x80",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA1\x8A"],

        ["\xE5\xA3\x8A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF2\x8B"],
        ["\xF2\x8B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\x8A"],

        ["\xE5\xBB\xBB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF2\x9B"],
        ["\xF2\x9B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\xBB"],

        ["\xE5\xBF\xAB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF2\x9C"],
        ["\xF2\x9C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF\xAB"],

        ["\xE6\x80\xAA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF2\xA0"],
        ["\xF2\xA0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x80\xAA"],

        ["\xE6\x82\x94",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF2\xAB"],
        ["\xF2\xAB",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\x94"],

        ["\xE6\x81\xA2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF2\xB0"],
        ["\xF2\xB0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\xA2"],

        ["\xE6\x87\x90",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF2\xC0"],
        ["\xF2\xC0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x87\x90"],

        ["\xE6\x88\x92",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF2\x6A"],
        ["\xF2\x6A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\x92"],

        ["\xE6\x8B\x90",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF2\xD0"],
        ["\xF2\xD0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\x90"],

        ["\xE6\x94\xB9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF2\xA1"],
        ["\xF2\xA1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x94\xB9"],

        ["\xE9\xAD\x81",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF3\x4F"],
        ["\xF3\x4F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xAD\x81"],

        ["\xE6\x99\xA6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF3\x7F"],
        ["\xF3\x7F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\xA6"],

        ["\xE6\xA2\xB0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF3\x7B"],
        ["\xF3\x7B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\xB0"],

        ["\xE6\xB5\xB7",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF3\xE0"],
        ["\xF3\xE0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB5\xB7"],

        ["\xE7\x81\xB0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF3\x6C"],
        ["\xF3\x6C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x81\xB0"],

        ["\xE7\x95\x8C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF3\x50"],
        ["\xF3\x50",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\x8C"],

        ["\xE7\x9A\x86",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF3\x7D"],
        ["\xF3\x7D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\x86"],

        ["\xE7\xB5\xB5",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF3\x4D"],
        ["\xF3\x4D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\xB5"],

        ["\xE8\x8A\xA5",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF3\x5D"],
        ["\xF3\x5D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8A\xA5"],

        ["\xE8\x9F\xB9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF3\x5C"],
        ["\xF3\x5C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9F\xB9"],

        ["\xE9\x96\x8B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF3\x4E"],
        ["\xF3\x4E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\x8B"],

        ["\xE9\x9A\x8E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF3\x6B"],
        ["\xF3\x6B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\x8E"],

        ["\xE8\xB2\x9D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF3\x60"],
        ["\xF3\x60",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\x9D"],

        ["\xE5\x87\xB1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF3\x4B"],
        ["\xF3\x4B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\xB1"],

        ["\xE5\x8A\xBE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF3\x61"],
        ["\xF3\x61",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\xBE"],

        ["\xE5\xA4\x96",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF3\xF0"],
        ["\xF3\xF0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\x96"],

        ["\xE5\x92\xB3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF3\xF1"],
        ["\xF3\xF1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\xB3"],

        ["\xE5\xAE\xB3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF3\xF2"],
        ["\xF3\xF2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\xB3"],

        ["\xE5\xB4\x96",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF3\xF3"],
        ["\xF3\xF3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB4\x96"],

        ["\xE6\x85\xA8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF3\xF4"],
        ["\xF3\xF4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\xA8"],

        ["\xE6\xA6\x82",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF3\xF5"],
        ["\xF3\xF5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA6\x82"],

        ["\xE6\xB6\xAF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF3\xF6"],
        ["\xF3\xF6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB6\xAF"],

        ["\xE7\xA2\x8D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF3\xF7"],
        ["\xF3\xF7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA2\x8D"],

        ["\xE8\x93\x8B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF3\xF8"],
        ["\xF3\xF8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x93\x8B"],

        ["\xE8\xA1\x97",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF3\xF9"],
        ["\xF3\xF9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\x97"],

        ["\xE8\xA9\xB2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF3\x7A"],
        ["\xF3\x7A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\xB2"],

        ["\xE9\x8E\xA7",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF3\x5E"],
        ["\xF3\x5E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8E\xA7"],

        ["\xE9\xAA\xB8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF3\x4C"],
        ["\xF3\x4C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xAA\xB8"],

        ["\xE6\xB5\xAC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF3\x7E"],
        ["\xF3\x7E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB5\xAC"],

        ["\xE9\xA6\xA8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF3\x6E"],
        ["\xF3\x6E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA6\xA8"],

        ["\xE8\x9B\x99",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF3\x6F"],
        ["\xF3\x6F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9B\x99"],

        ["\xE5\x9E\xA3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF3\x7C"],
        ["\xF3\x7C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9E\xA3"],

        ["\xE6\x9F\xBF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF3\xC1"],
        ["\xF3\xC1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\xBF"],

        ["\xE8\x9B\x8E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x68\xE9"],
        ["\x68\xE9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9B\x8E"],

        ["\xE9\x88\x8E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF3\xC3"],
        ["\xF3\xC3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x88\x8E"],

        ["\xE5\x8A\x83",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF3\xC4"],
        ["\xF3\xC4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\x83"],

        ["\xE5\x9A\x87",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF3\xC5"],
        ["\xF3\xC5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9A\x87"],

        ["\xE5\x90\x84",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF3\xC6"],
        ["\xF3\xC6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\x84"],

        ["\xE5\xBB\x93",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF3\xC7"],
        ["\xF3\xC7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\x93"],

        ["\xE6\x8B\xA1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF3\xC8"],
        ["\xF3\xC8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\xA1"],

        ["\xE6\x92\xB9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE8\xA0"],
        ["\xE8\xA0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x92\xB9"],

        ["\xE6\xA0\xBC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF3\xD1"],
        ["\xF3\xD1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA0\xBC"],

        ["\xE6\xA0\xB8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF3\xD2"],
        ["\xF3\xD2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA0\xB8"],

        ["\xE6\xAE\xBB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF3\xD3"],
        ["\xF3\xD3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\xBB"],

        ["\xE7\x8D\xB2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF3\xD4"],
        ["\xF3\xD4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8D\xB2"],

        ["\xE7\xA2\xBA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF3\xD5"],
        ["\xF3\xD5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA2\xBA"],

        ["\xE7\xA9\xAB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF3\xD6"],
        ["\xF3\xD6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\xAB"],

        ["\xE8\xA6\x9A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF3\xD7"],
        ["\xF3\xD7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\x9A"],

        ["\xE8\xA7\x92",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF3\xD8"],
        ["\xF3\xD8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA7\x92"],

        ["\xE8\xB5\xAB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF3\xD9"],
        ["\xF3\xD9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB5\xAB"],

        ["\xE8\xBC\x83",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF3\xE2"],
        ["\xF3\xE2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC\x83"],

        ["\xE9\x83\xAD",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF3\xE3"],
        ["\xF3\xE3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x83\xAD"],

        ["\xE9\x96\xA3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF3\xE4"],
        ["\xF3\xE4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\xA3"],

        ["\xE9\x9A\x94",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF3\xE5"],
        ["\xF3\xE5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\x94"],

        ["\xE9\x9D\xA9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF3\xE6"],
        ["\xF3\xE6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9D\xA9"],

        ["\xE5\xAD\xA6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF3\xE7"],
        ["\xF3\xE7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\xA6"],

        ["\xE5\xB2\xB3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF3\xE8"],
        ["\xF3\xE8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB2\xB3"],

        ["\xE6\xA5\xBD",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF3\xE9"],
        ["\xF3\xE9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\xBD"],

        ["\xE9\xA1\x8D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF3\x4A"],
        ["\xF3\x4A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA1\x8D"],

        ["\xE9\xA1\x8E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF3\x5B"],
        ["\xF3\x5B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA1\x8E"],

        ["\xE6\x8E\x9B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF3\x5A"],
        ["\xF3\x5A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\x9B"],

        ["\xE7\xAC\xA0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF3\x5F"],
        ["\xF3\x5F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC\xA0"],

        ["\xE6\xA8\xAB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF3\x6D"],
        ["\xF3\x6D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\xAB"],

        ["\xE6\xA9\xBF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF3\x79"],
        ["\xF3\x79",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA9\xBF"],

        ["\xE6\xA2\xB6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF3\x57"],
        ["\xF3\x57",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\xB6"],

        ["\xE9\xB0\x8D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF3\x59"],
        ["\xF3\x59",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0\x8D"],

        ["\xE6\xBD\x9F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF3\x62"],
        ["\xF3\x62",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBD\x9F"],

        ["\xE5\x89\xB2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF3\x63"],
        ["\xF3\x63",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\xB2"],

        ["\xE5\x96\x9D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF3\x64"],
        ["\xF3\x64",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x96\x9D"],

        ["\xE6\x81\xB0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF3\x65"],
        ["\xF3\x65",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\xB0"],

        ["\xE6\x8B\xAC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF3\x66"],
        ["\xF3\x66",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\xAC"],

        ["\xE6\xB4\xBB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF3\x67"],
        ["\xF3\x67",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4\xBB"],

        ["\xE6\xB8\x87",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF3\x68"],
        ["\xF3\x68",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\x87"],

        ["\xE6\xBB\x91",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF3\x69"],
        ["\xF3\x69",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBB\x91"],

        ["\xE8\x91\x9B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF3\x70"],
        ["\xF3\x70",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x91\x9B"],

        ["\xE8\xA4\x90",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF3\x71"],
        ["\xF3\x71",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA4\x90"],

        ["\xE8\xBD\x84",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF3\x72"],
        ["\xF3\x72",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBD\x84"],

        ["\xE4\xB8\x94",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF3\x73"],
        ["\xF3\x73",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\x94"],

        ["\xE9\xB0\xB9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF3\x74"],
        ["\xF3\x74",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0\xB9"],

        ["\xE5\x8F\xB6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF3\x75"],
        ["\xF3\x75",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\xB6"],

        ["\xE6\xA4\x9B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF3\x76"],
        ["\xF3\x76",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\x9B"],

        ["\xE6\xA8\xBA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF3\x77"],
        ["\xF3\x77",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\xBA"],

        ["\xE9\x9E\x84",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF3\x78"],
        ["\xF3\x78",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9E\x84"],

        ["\xE6\xA0\xAA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF3\x80"],
        ["\xF3\x80",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA0\xAA"],

        ["\xE5\x85\x9C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF3\x8B"],
        ["\xF3\x8B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\x9C"],

        ["\xE7\xAB\x83",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x62\x5F"],
        ["\x62\x5F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\x83"],

        ["\xE8\x92\xB2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF3\x9C"],
        ["\xF3\x9C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x92\xB2"],

        ["\xE9\x87\x9C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF3\xA0"],
        ["\xF3\xA0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\x9C"],

        ["\xE9\x8E\x8C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF3\xAB"],
        ["\xF3\xAB",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8E\x8C"],

        ["\xE5\x99\x9B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0"],
        ["\xF3\xB0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x99\x9B"],

        ["\xE9\xB4\xA8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF3\xC0"],
        ["\xF3\xC0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB4\xA8"],

        ["\xE6\xA0\xA2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF3\x6A"],
        ["\xF3\x6A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA0\xA2"],

        ["\xE8\x8C\x85",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF3\xD0"],
        ["\xF3\xD0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C\x85"],

        ["\xE8\x90\xB1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF3\xA1"],
        ["\xF3\xA1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x90\xB1"],

        ["\xE7\xB2\xA5",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF4\x4F"],
        ["\xF4\x4F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\xA5"],

        ["\xE5\x88\x88",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF4\x7F"],
        ["\xF4\x7F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\x88"],

        ["\xE8\x8B\x85",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF4\x7B"],
        ["\xF4\x7B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8B\x85"],

        ["\xE7\x93\xA6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF4\xE0"],
        ["\xF4\xE0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x93\xA6"],

        ["\xE4\xB9\xBE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF4\x6C"],
        ["\xF4\x6C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xB9\xBE"],

        ["\xE4\xBE\x83",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF4\x50"],
        ["\xF4\x50",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE\x83"],

        ["\xE5\x86\xA0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF4\x7D"],
        ["\xF4\x7D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\xA0"],

        ["\xE5\xAF\x92",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF4\x4D"],
        ["\xF4\x4D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\x92"],

        ["\xE5\x88\x8A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF4\x5D"],
        ["\xF4\x5D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\x8A"],

        ["\xE5\x8B\x98",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF4\x5C"],
        ["\xF4\x5C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\x98"],

        ["\xE5\x8B\xA7",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF4\x4E"],
        ["\xF4\x4E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\xA7"],

        ["\xE5\xB7\xBB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF4\x6B"],
        ["\xF4\x6B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\xBB"],

        ["\xE5\x96\x9A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF4\x60"],
        ["\xF4\x60",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x96\x9A"],

        ["\xE5\xA0\xAA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF4\x4B"],
        ["\xF4\x4B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA0\xAA"],

        ["\xE5\xA7\xA6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF4\x61"],
        ["\xF4\x61",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA7\xA6"],

        ["\xE5\xAE\x8C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF4\xF0"],
        ["\xF4\xF0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\x8C"],

        ["\xE5\xAE\x98",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF4\xF1"],
        ["\xF4\xF1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\x98"],

        ["\xE5\xAF\x9B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF4\xF2"],
        ["\xF4\xF2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\x9B"],

        ["\xE5\xB9\xB2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF4\xF3"],
        ["\xF4\xF3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\xB2"],

        ["\xE5\xB9\xB9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF4\xF4"],
        ["\xF4\xF4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\xB9"],

        ["\xE6\x82\xA3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF4\xF5"],
        ["\xF4\xF5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\xA3"],

        ["\xE6\x84\x9F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF4\xF6"],
        ["\xF4\xF6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\x9F"],

        ["\xE6\x85\xA3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF4\xF7"],
        ["\xF4\xF7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\xA3"],

        ["\xE6\x86\xBE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF4\xF8"],
        ["\xF4\xF8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x86\xBE"],

        ["\xE6\x8F\x9B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF4\xF9"],
        ["\xF4\xF9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8F\x9B"],

        ["\xE6\x95\xA2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF4\x7A"],
        ["\xF4\x7A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x95\xA2"],

        ["\xE6\x9F\x91",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF4\x5E"],
        ["\xF4\x5E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\x91"],

        ["\xE6\xA1\x93",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF4\x4C"],
        ["\xF4\x4C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\x93"],

        ["\xE6\xA3\xBA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF4\x7E"],
        ["\xF4\x7E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\xBA"],

        ["\xE6\xAC\xBE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF4\x6E"],
        ["\xF4\x6E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAC\xBE"],

        ["\xE6\xAD\x93",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF4\x6F"],
        ["\xF4\x6F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\x93"],

        ["\xE6\xB1\x97",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF4\x7C"],
        ["\xF4\x7C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1\x97"],

        ["\xE6\xBC\xA2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF4\xC1"],
        ["\xF4\xC1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBC\xA2"],

        ["\xE6\xBE\x97",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF4\xC2"],
        ["\xF4\xC2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBE\x97"],

        ["\xE6\xBD\x85",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5F\x8B"],
        ["\x5F\x8B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBD\x85"],

        ["\xE7\x92\xB0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF4\xC4"],
        ["\xF4\xC4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x92\xB0"],

        ["\xE7\x94\x98",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF4\xC5"],
        ["\xF4\xC5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\x98"],

        ["\xE7\x9B\xA3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF4\xC6"],
        ["\xF4\xC6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\xA3"],

        ["\xE7\x9C\x8B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF4\xC7"],
        ["\xF4\xC7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9C\x8B"],

        ["\xE7\xAB\xBF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF4\xC8"],
        ["\xF4\xC8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\xBF"],

        ["\xE7\xAE\xA1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF4\xC9"],
        ["\xF4\xC9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAE\xA1"],

        ["\xE7\xB0\xA1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF4\xD1"],
        ["\xF4\xD1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB0\xA1"],

        ["\xE7\xB7\xA9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF4\xD2"],
        ["\xF4\xD2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7\xA9"],

        ["\xE7\xBC\xB6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF4\xD3"],
        ["\xF4\xD3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBC\xB6"],

        ["\xE7\xBF\xB0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF4\xD4"],
        ["\xF4\xD4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBF\xB0"],

        ["\xE8\x82\x9D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF4\xD5"],
        ["\xF4\xD5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x82\x9D"],

        ["\xE8\x89\xA6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF4\xD6"],
        ["\xF4\xD6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x89\xA6"],

        ["\xE8\x8E\x9E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF4\xD7"],
        ["\xF4\xD7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8E\x9E"],

        ["\xE8\xA6\xB3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF4\xD8"],
        ["\xF4\xD8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\xB3"],

        ["\xE8\xAB\x8C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x70\x5A"],
        ["\x70\x5A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\x8C"],

        ["\xE8\xB2\xAB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF4\xE2"],
        ["\xF4\xE2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\xAB"],

        ["\xE9\x82\x84",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF4\xE3"],
        ["\xF4\xE3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x82\x84"],

        ["\xE9\x91\x91",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF4\xE4"],
        ["\xF4\xE4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x91\x91"],

        ["\xE9\x96\x93",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF4\xE5"],
        ["\xF4\xE5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\x93"],

        ["\xE9\x96\x91",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF4\xE6"],
        ["\xF4\xE6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\x91"],

        ["\xE9\x96\xA2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF4\xE7"],
        ["\xF4\xE7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\xA2"],

        ["\xE9\x99\xA5",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF4\xE8"],
        ["\xF4\xE8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x99\xA5"],

        ["\xE9\x9F\x93",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF4\xE9"],
        ["\xF4\xE9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9F\x93"],

        ["\xE9\xA4\xA8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF4\x4A"],
        ["\xF4\x4A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA4\xA8"],

        ["\xE8\x88\x98",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF4\x5B"],
        ["\xF4\x5B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\x98"],

        ["\xE4\xB8\xB8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF4\x5A"],
        ["\xF4\x5A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\xB8"],

        ["\xE5\x90\xAB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF4\x5F"],
        ["\xF4\x5F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\xAB"],

        ["\xE5\xB2\xB8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF4\x6D"],
        ["\xF4\x6D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB2\xB8"],

        ["\xE5\xB7\x8C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF4\x79"],
        ["\xF4\x79",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\x8C"],

        ["\xE7\x8E\xA9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF4\x57"],
        ["\xF4\x57",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8E\xA9"],

        ["\xE7\x99\x8C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF4\x59"],
        ["\xF4\x59",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\x8C"],

        ["\xE7\x9C\xBC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF4\x62"],
        ["\xF4\x62",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9C\xBC"],

        ["\xE5\xB2\xA9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF4\x63"],
        ["\xF4\x63",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB2\xA9"],

        ["\xE7\xBF\xAB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF4\x64"],
        ["\xF4\x64",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBF\xAB"],

        ["\xE8\xB4\x8B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF4\x65"],
        ["\xF4\x65",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB4\x8B"],

        ["\xE9\x9B\x81",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF4\x66"],
        ["\xF4\x66",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\x81"],

        ["\xE9\xA0\x91",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF4\x67"],
        ["\xF4\x67",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0\x91"],

        ["\xE9\xA1\x94",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF4\x68"],
        ["\xF4\x68",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA1\x94"],

        ["\xE9\xA1\x98",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF4\x69"],
        ["\xF4\x69",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA1\x98"],

        ["\xE4\xBC\x81",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF4\x70"],
        ["\xF4\x70",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBC\x81"],

        ["\xE4\xBC\x8E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF4\x71"],
        ["\xF4\x71",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBC\x8E"],

        ["\xE5\x8D\xB1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF4\x72"],
        ["\xF4\x72",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\xB1"],

        ["\xE5\x96\x9C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF4\x73"],
        ["\xF4\x73",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x96\x9C"],

        ["\xE5\x99\xA8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF4\x74"],
        ["\xF4\x74",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x99\xA8"],

        ["\xE5\x9F\xBA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF4\x75"],
        ["\xF4\x75",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9F\xBA"],

        ["\xE5\xA5\x87",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF4\x76"],
        ["\xF4\x76",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\x87"],

        ["\xE5\xAC\x89",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF4\x77"],
        ["\xF4\x77",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAC\x89"],

        ["\xE5\xAF\x84",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF4\x78"],
        ["\xF4\x78",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\x84"],

        ["\xE5\xB2\x90",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF4\x80"],
        ["\xF4\x80",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB2\x90"],

        ["\xE5\xB8\x8C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF4\x8B"],
        ["\xF4\x8B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8\x8C"],

        ["\xE5\xB9\xBE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF4\x9B"],
        ["\xF4\x9B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\xBE"],

        ["\xE5\xBF\x8C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF4\x9C"],
        ["\xF4\x9C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF\x8C"],

        ["\xE6\x8F\xAE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF4\xA0"],
        ["\xF4\xA0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8F\xAE"],

        ["\xE6\x9C\xBA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF4\xAB"],
        ["\xF4\xAB",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\xBA"],

        ["\xE6\x97\x97",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF4\xB0"],
        ["\xF4\xB0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\x97"],

        ["\xE6\x97\xA2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF4\xC0"],
        ["\xF4\xC0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\xA2"],

        ["\xE6\x9C\x9F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF4\x6A"],
        ["\xF4\x6A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\x9F"],

        ["\xE6\xA3\x8B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF4\xD0"],
        ["\xF4\xD0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\x8B"],

        ["\xE6\xA3\x84",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF4\xA1"],
        ["\xF4\xA1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\x84"],

        ["\xE6\xA9\x9F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF5\x4F"],
        ["\xF5\x4F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA9\x9F"],

        ["\xE5\xB8\xB0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF5\x7F"],
        ["\xF5\x7F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8\xB0"],

        ["\xE6\xAF\x85",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF5\x7B"],
        ["\xF5\x7B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAF\x85"],

        ["\xE6\xB0\x97",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF5\xE0"],
        ["\xF5\xE0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB0\x97"],

        ["\xE6\xB1\xBD",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF5\x6C"],
        ["\xF5\x6C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1\xBD"],

        ["\xE7\x95\xBF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF5\x50"],
        ["\xF5\x50",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\xBF"],

        ["\xE7\xA5\x88",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF5\x7D"],
        ["\xF5\x7D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5\x88"],

        ["\xE5\xAD\xA3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF5\x4D"],
        ["\xF5\x4D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\xA3"],

        ["\xE7\xA8\x80",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF5\x5D"],
        ["\xF5\x5D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8\x80"],

        ["\xE7\xB4\x80",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF5\x5C"],
        ["\xF5\x5C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\x80"],

        ["\xE5\xBE\xBD",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF5\x4E"],
        ["\xF5\x4E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\xBD"],

        ["\xE8\xA6\x8F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF5\x6B"],
        ["\xF5\x6B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\x8F"],

        ["\xE8\xA8\x98",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF5\x60"],
        ["\xF5\x60",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\x98"],

        ["\xE8\xB2\xB4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF5\x4B"],
        ["\xF5\x4B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\xB4"],

        ["\xE8\xB5\xB7",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF5\x61"],
        ["\xF5\x61",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB5\xB7"],

        ["\xE8\xBB\x8C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF5\xF0"],
        ["\xF5\xF0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBB\x8C"],

        ["\xE8\xBC\x9D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF5\xF1"],
        ["\xF5\xF1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC\x9D"],

        ["\xE9\xA3\xA2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF5\xF2"],
        ["\xF5\xF2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA3\xA2"],

        ["\xE9\xA8\x8E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF5\xF3"],
        ["\xF5\xF3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA8\x8E"],

        ["\xE9\xAC\xBC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF5\xF4"],
        ["\xF5\xF4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xAC\xBC"],

        ["\xE4\xBA\x80",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF5\xF5"],
        ["\xF5\xF5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\x80"],

        ["\xE5\x81\xBD",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF5\xF6"],
        ["\xF5\xF6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x81\xBD"],

        ["\xE5\x84\x80",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF5\xF7"],
        ["\xF5\xF7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x84\x80"],

        ["\xE5\xA6\x93",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF5\xF8"],
        ["\xF5\xF8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA6\x93"],

        ["\xE5\xAE\x9C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF5\xF9"],
        ["\xF5\xF9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\x9C"],

        ["\xE6\x88\xAF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF5\x7A"],
        ["\xF5\x7A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\xAF"],

        ["\xE6\x8A\x80",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF5\x5E"],
        ["\xF5\x5E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A\x80"],

        ["\xE6\x93\xAC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF5\x4C"],
        ["\xF5\x4C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\xAC"],

        ["\xE6\xAC\xBA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF5\x7E"],
        ["\xF5\x7E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAC\xBA"],

        ["\xE7\x8A\xA0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF5\x6E"],
        ["\xF5\x6E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8A\xA0"],

        ["\xE7\x96\x91",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF5\x6F"],
        ["\xF5\x6F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x96\x91"],

        ["\xE7\xA5\x87",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF5\x7C"],
        ["\xF5\x7C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5\x87"],

        ["\xE7\xBE\xA9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF5\xC1"],
        ["\xF5\xC1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\xA9"],

        ["\xE8\x9F\xBB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF5\xC2"],
        ["\xF5\xC2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9F\xBB"],

        ["\xE8\xAA\xBC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF5\xC3"],
        ["\xF5\xC3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\xBC"],

        ["\xE8\xAD\xB0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF5\xC4"],
        ["\xF5\xC4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD\xB0"],

        ["\xE6\x8E\xAC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF5\xC5"],
        ["\xF5\xC5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\xAC"],

        ["\xE8\x8F\x8A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF5\xC6"],
        ["\xF5\xC6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F\x8A"],

        ["\xE9\x9E\xA0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF5\xC7"],
        ["\xF5\xC7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9E\xA0"],

        ["\xE5\x90\x89",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF5\xC8"],
        ["\xF5\xC8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\x89"],

        ["\xE5\x90\x83",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF5\xC9"],
        ["\xF5\xC9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\x83"],

        ["\xE5\x96\xAB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF5\xD1"],
        ["\xF5\xD1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x96\xAB"],

        ["\xE6\xA1\x94",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF5\xD2"],
        ["\xF5\xD2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\x94"],

        ["\xE6\xA9\x98",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF5\xD3"],
        ["\xF5\xD3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA9\x98"],

        ["\xE8\xA9\xB0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF5\xD4"],
        ["\xF5\xD4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\xB0"],

        ["\xE7\xA0\xA7",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF5\xD5"],
        ["\xF5\xD5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA0\xA7"],

        ["\xE6\x9D\xB5",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF5\xD6"],
        ["\xF5\xD6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\xB5"],

        ["\xE9\xBB\x8D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF5\xD7"],
        ["\xF5\xD7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xBB\x8D"],

        ["\xE5\x8D\xB4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF5\xD8"],
        ["\xF5\xD8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\xB4"],

        ["\xE5\xAE\xA2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF5\xD9"],
        ["\xF5\xD9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\xA2"],

        ["\xE8\x84\x9A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF5\xE2"],
        ["\xF5\xE2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x84\x9A"],

        ["\xE8\x99\x90",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF5\xE3"],
        ["\xF5\xE3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x99\x90"],

        ["\xE9\x80\x86",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF5\xE4"],
        ["\xF5\xE4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\x86"],

        ["\xE4\xB8\x98",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF5\xE5"],
        ["\xF5\xE5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\x98"],

        ["\xE4\xB9\x85",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF5\xE6"],
        ["\xF5\xE6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xB9\x85"],

        ["\xE4\xBB\x87",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF5\xE7"],
        ["\xF5\xE7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\x87"],

        ["\xE4\xBC\x91",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF5\xE8"],
        ["\xF5\xE8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBC\x91"],

        ["\xE5\x8F\x8A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF5\xE9"],
        ["\xF5\xE9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\x8A"],

        ["\xE5\x90\xB8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF5\x4A"],
        ["\xF5\x4A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\xB8"],

        ["\xE5\xAE\xAE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF5\x5B"],
        ["\xF5\x5B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\xAE"],

        ["\xE5\xBC\x93",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF5\x5A"],
        ["\xF5\x5A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\x93"],

        ["\xE6\x80\xA5",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF5\x5F"],
        ["\xF5\x5F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x80\xA5"],

        ["\xE6\x95\x91",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF5\x6D"],
        ["\xF5\x6D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x95\x91"],

        ["\xE6\x9C\xBD",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF5\x79"],
        ["\xF5\x79",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\xBD"],

        ["\xE6\xB1\x82",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF5\x57"],
        ["\xF5\x57",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1\x82"],

        ["\xE6\xB1\xB2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF5\x59"],
        ["\xF5\x59",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1\xB2"],

        ["\xE6\xB3\xA3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF5\x62"],
        ["\xF5\x62",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\xA3"],

        ["\xE7\x81\xB8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF5\x63"],
        ["\xF5\x63",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x81\xB8"],

        ["\xE7\x90\x83",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF5\x64"],
        ["\xF5\x64",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x90\x83"],

        ["\xE7\xA9\xB6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF5\x65"],
        ["\xF5\x65",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\xB6"],

        ["\xE7\xAA\xAE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF5\x66"],
        ["\xF5\x66",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAA\xAE"],

        ["\xE7\xAC\x88",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF5\x67"],
        ["\xF5\x67",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC\x88"],

        ["\xE7\xB4\x9A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF5\x68"],
        ["\xF5\x68",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\x9A"],

        ["\xE7\xB3\xBE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF5\x69"],
        ["\xF5\x69",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3\xBE"],

        ["\xE7\xB5\xA6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF5\x70"],
        ["\xF5\x70",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\xA6"],

        ["\xE6\x97\xA7",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF5\x71"],
        ["\xF5\x71",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\xA7"],

        ["\xE7\x89\x9B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF5\x72"],
        ["\xF5\x72",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x89\x9B"],

        ["\xE5\x8E\xBB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF5\x73"],
        ["\xF5\x73",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8E\xBB"],

        ["\xE5\xB1\x85",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF5\x74"],
        ["\xF5\x74",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\x85"],

        ["\xE5\xB7\xA8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF5\x75"],
        ["\xF5\x75",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\xA8"],

        ["\xE6\x8B\x92",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF5\x76"],
        ["\xF5\x76",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\x92"],

        ["\xE6\x8B\xA0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF5\x77"],
        ["\xF5\x77",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\xA0"],

        ["\xE6\x8C\x99",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF5\x78"],
        ["\xF5\x78",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8C\x99"],

        ["\xE6\xB8\xA0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF5\x80"],
        ["\xF5\x80",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\xA0"],

        ["\xE8\x99\x9A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF5\x8B"],
        ["\xF5\x8B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x99\x9A"],

        ["\xE8\xA8\xB1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF5\x9B"],
        ["\xF5\x9B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\xB1"],

        ["\xE8\xB7\x9D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF5\x9C"],
        ["\xF5\x9C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB7\x9D"],

        ["\xE9\x8B\xB8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF5\xA0"],
        ["\xF5\xA0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8B\xB8"],

        ["\xE6\xBC\x81",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF5\xAB"],
        ["\xF5\xAB",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBC\x81"],

        ["\xE7\xA6\xA6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF5\xB0"],
        ["\xF5\xB0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6\xA6"],

        ["\xE9\xAD\x9A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF5\xC0"],
        ["\xF5\xC0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xAD\x9A"],

        ["\xE4\xBA\xA8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF5\x6A"],
        ["\xF5\x6A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\xA8"],

        ["\xE4\xBA\xAB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF5\xD0"],
        ["\xF5\xD0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\xAB"],

        ["\xE4\xBA\xAC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF5\xA1"],
        ["\xF5\xA1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\xAC"],

        ["\xE4\xBE\x9B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF6\x4F"],
        ["\xF6\x4F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE\x9B"],

        ["\xE4\xBE\xA0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF6\x7F"],
        ["\xF6\x7F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE\xA0"],

        ["\xE5\x83\x91",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF6\x7B"],
        ["\xF6\x7B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x83\x91"],

        ["\xE5\x85\x87",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF6\xE0"],
        ["\xF6\xE0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\x87"],

        ["\xE7\xAB\xB6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF6\x6C"],
        ["\xF6\x6C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\xB6"],

        ["\xE5\x85\xB1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF6\x50"],
        ["\xF6\x50",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\xB1"],

        ["\xE5\x87\xB6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF6\x7D"],
        ["\xF6\x7D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\xB6"],

        ["\xE5\x8D\x94",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF6\x4D"],
        ["\xF6\x4D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\x94"],

        ["\xE5\x8C\xA1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF6\x5D"],
        ["\xF6\x5D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\xA1"],

        ["\xE5\x8D\xBF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF6\x5C"],
        ["\xF6\x5C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\xBF"],

        ["\xE5\x8F\xAB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF6\x4E"],
        ["\xF6\x4E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\xAB"],

        ["\xE5\x96\xAC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF6\x6B"],
        ["\xF6\x6B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x96\xAC"],

        ["\xE5\xA2\x83",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF6\x60"],
        ["\xF6\x60",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA2\x83"],

        ["\xE5\xB3\xA1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF6\x4B"],
        ["\xF6\x4B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB3\xA1"],

        ["\xE5\xBC\xB7",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF6\x61"],
        ["\xF6\x61",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\xB7"],

        ["\xE5\xBD\x8A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF6\xF0"],
        ["\xF6\xF0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\x8A"],

        ["\xE6\x80\xAF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF6\xF1"],
        ["\xF6\xF1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x80\xAF"],

        ["\xE6\x81\x90",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF6\xF2"],
        ["\xF6\xF2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\x90"],

        ["\xE6\x81\xAD",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF6\xF3"],
        ["\xF6\xF3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\xAD"],

        ["\xE6\x8C\x9F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF6\xF4"],
        ["\xF6\xF4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8C\x9F"],

        ["\xE6\x95\x99",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF6\xF5"],
        ["\xF6\xF5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x95\x99"],

        ["\xE6\xA9\x8B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF6\xF6"],
        ["\xF6\xF6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA9\x8B"],

        ["\xE6\xB3\x81",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF6\xF7"],
        ["\xF6\xF7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\x81"],

        ["\xE7\x8B\x82",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF6\xF8"],
        ["\xF6\xF8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8B\x82"],

        ["\xE7\x8B\xAD",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF6\xF9"],
        ["\xF6\xF9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8B\xAD"],

        ["\xE7\x9F\xAF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF6\x7A"],
        ["\xF6\x7A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9F\xAF"],

        ["\xE8\x83\xB8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF6\x5E"],
        ["\xF6\x5E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x83\xB8"],

        ["\xE8\x84\x85",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF6\x4C"],
        ["\xF6\x4C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x84\x85"],

        ["\xE8\x88\x88",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF6\x7E"],
        ["\xF6\x7E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\x88"],

        ["\xE8\x95\x8E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF6\x6E"],
        ["\xF6\x6E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x95\x8E"],

        ["\xE9\x83\xB7",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF6\x6F"],
        ["\xF6\x6F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x83\xB7"],

        ["\xE9\x8F\xA1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF6\x7C"],
        ["\xF6\x7C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8F\xA1"],

        ["\xE9\x9F\xBF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF6\xC1"],
        ["\xF6\xC1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9F\xBF"],

        ["\xE9\xA5\x97",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF6\xC2"],
        ["\xF6\xC2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA5\x97"],

        ["\xE9\xA9\x9A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF6\xC3"],
        ["\xF6\xC3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA9\x9A"],

        ["\xE4\xBB\xB0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF6\xC4"],
        ["\xF6\xC4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\xB0"],

        ["\xE5\x87\x9D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF6\xC5"],
        ["\xF6\xC5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\x9D"],

        ["\xE5\xB0\xAD",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x86\xBA"],
        ["\x86\xBA",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\xAD"],

        ["\xE6\x9A\x81",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF6\xC7"],
        ["\xF6\xC7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A\x81"],

        ["\xE6\xA5\xAD",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF6\xC8"],
        ["\xF6\xC8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\xAD"],

        ["\xE5\xB1\x80",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF6\xC9"],
        ["\xF6\xC9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\x80"],

        ["\xE6\x9B\xB2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF6\xD1"],
        ["\xF6\xD1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\xB2"],

        ["\xE6\xA5\xB5",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF6\xD2"],
        ["\xF6\xD2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\xB5"],

        ["\xE7\x8E\x89",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF6\xD3"],
        ["\xF6\xD3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8E\x89"],

        ["\xE6\xA1\x90",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF6\xD4"],
        ["\xF6\xD4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\x90"],

        ["\xE7\xB2\x81",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF6\xD5"],
        ["\xF6\xD5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\x81"],

        ["\xE5\x83\x85",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF6\xD6"],
        ["\xF6\xD6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x83\x85"],

        ["\xE5\x8B\xA4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF6\xD7"],
        ["\xF6\xD7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\xA4"],

        ["\xE5\x9D\x87",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF6\xD8"],
        ["\xF6\xD8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9D\x87"],

        ["\xE5\xB7\xBE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF6\xD9"],
        ["\xF6\xD9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\xBE"],

        ["\xE9\x8C\xA6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF6\xE2"],
        ["\xF6\xE2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8C\xA6"],

        ["\xE6\x96\xA4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF6\xE3"],
        ["\xF6\xE3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\xA4"],

        ["\xE6\xAC\xA3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF6\xE4"],
        ["\xF6\xE4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAC\xA3"],

        ["\xE6\xAC\xBD",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF6\xE5"],
        ["\xF6\xE5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAC\xBD"],

        ["\xE7\x90\xB4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF6\xE6"],
        ["\xF6\xE6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x90\xB4"],

        ["\xE7\xA6\x81",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF6\xE7"],
        ["\xF6\xE7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6\x81"],

        ["\xE7\xA6\xBD",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF6\xE8"],
        ["\xF6\xE8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6\xBD"],

        ["\xE7\xAD\x8B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF6\xE9"],
        ["\xF6\xE9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\x8B"],

        ["\xE7\xB7\x8A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF6\x4A"],
        ["\xF6\x4A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7\x8A"],

        ["\xE8\x8A\xB9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF6\x5B"],
        ["\xF6\x5B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8A\xB9"],

        ["\xE8\x8F\x8C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF6\x5A"],
        ["\xF6\x5A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F\x8C"],

        ["\xE8\xA1\xBF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF6\x5F"],
        ["\xF6\x5F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\xBF"],

        ["\xE8\xA5\x9F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF6\x6D"],
        ["\xF6\x6D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA5\x9F"],

        ["\xE8\xAC\xB9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF6\x79"],
        ["\xF6\x79",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC\xB9"],

        ["\xE8\xBF\x91",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF6\x57"],
        ["\xF6\x57",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF\x91"],

        ["\xE9\x87\x91",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF6\x59"],
        ["\xF6\x59",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\x91"],

        ["\xE5\x90\x9F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF6\x62"],
        ["\xF6\x62",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\x9F"],

        ["\xE9\x8A\x80",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF6\x63"],
        ["\xF6\x63",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8A\x80"],

        ["\xE4\xB9\x9D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF6\x64"],
        ["\xF6\x64",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xB9\x9D"],

        ["\xE5\x80\xB6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF6\x65"],
        ["\xF6\x65",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\xB6"],

        ["\xE5\x8F\xA5",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF6\x66"],
        ["\xF6\x66",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\xA5"],

        ["\xE5\x8C\xBA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF6\x67"],
        ["\xF6\x67",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\xBA"],

        ["\xE7\x8B\x97",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF6\x68"],
        ["\xF6\x68",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8B\x97"],

        ["\xE7\x8E\x96",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF6\x69"],
        ["\xF6\x69",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8E\x96"],

        ["\xE7\x9F\xA9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF6\x70"],
        ["\xF6\x70",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9F\xA9"],

        ["\xE8\x8B\xA6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF6\x71"],
        ["\xF6\x71",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8B\xA6"],

        ["\xE8\xBA\xAF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF6\x72"],
        ["\xF6\x72",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBA\xAF"],

        ["\xE9\xA7\x86",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF6\x73"],
        ["\xF6\x73",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA7\x86"],

        ["\xE9\xA7\x88",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF6\x74"],
        ["\xF6\x74",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA7\x88"],

        ["\xE9\xA7\x92",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF6\x75"],
        ["\xF6\x75",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA7\x92"],

        ["\xE5\x85\xB7",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF6\x76"],
        ["\xF6\x76",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\xB7"],

        ["\xE6\x84\x9A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF6\x77"],
        ["\xF6\x77",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\x9A"],

        ["\xE8\x99\x9E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF6\x78"],
        ["\xF6\x78",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x99\x9E"],

        ["\xE5\x96\xB0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF6\x80"],
        ["\xF6\x80",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x96\xB0"],

        ["\xE7\xA9\xBA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF6\x8B"],
        ["\xF6\x8B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\xBA"],

        ["\xE5\x81\xB6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF6\x9B"],
        ["\xF6\x9B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x81\xB6"],

        ["\xE5\xAF\x93",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF6\x9C"],
        ["\xF6\x9C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\x93"],

        ["\xE9\x81\x87",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF6\xA0"],
        ["\xF6\xA0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\x87"],

        ["\xE9\x9A\x85",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF6\xAB"],
        ["\xF6\xAB",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\x85"],

        ["\xE4\xB8\xB2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF6\xB0"],
        ["\xF6\xB0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\xB2"],

        ["\xE6\xAB\x9B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF6\xC0"],
        ["\xF6\xC0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAB\x9B"],

        ["\xE9\x87\xA7",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF6\x6A"],
        ["\xF6\x6A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\xA7"],

        ["\xE5\xB1\x91",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF6\xD0"],
        ["\xF6\xD0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\x91"],

        ["\xE5\xB1\x88",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF6\xA1"],
        ["\xF6\xA1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\x88"],

        ["\xE6\x8E\x98",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF7\x4F"],
        ["\xF7\x4F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\x98"],

        ["\xE7\xAA\x9F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF7\x7F"],
        ["\xF7\x7F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAA\x9F"],

        ["\xE6\xB2\x93",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF7\x7B"],
        ["\xF7\x7B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\x93"],

        ["\xE9\x9D\xB4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF7\xE0"],
        ["\xF7\xE0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9D\xB4"],

        ["\xE8\xBD\xA1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF7\x6C"],
        ["\xF7\x6C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBD\xA1"],

        ["\xE7\xAA\xAA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF7\x50"],
        ["\xF7\x50",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAA\xAA"],

        ["\xE7\x86\x8A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF7\x7D"],
        ["\xF7\x7D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x86\x8A"],

        ["\xE9\x9A\x88",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF7\x4D"],
        ["\xF7\x4D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\x88"],

        ["\xE7\xB2\x82",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF7\x5D"],
        ["\xF7\x5D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\x82"],

        ["\xE6\xA0\x97",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF7\x5C"],
        ["\xF7\x5C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA0\x97"],

        ["\xE7\xB9\xB0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF7\x4E"],
        ["\xF7\x4E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\xB0"],

        ["\xE6\xA1\x91",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF7\x6B"],
        ["\xF7\x6B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\x91"],

        ["\xE9\x8D\xAC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF7\x60"],
        ["\xF7\x60",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8D\xAC"],

        ["\xE5\x8B\xB2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF7\x4B"],
        ["\xF7\x4B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\xB2"],

        ["\xE5\x90\x9B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF7\x61"],
        ["\xF7\x61",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\x9B"],

        ["\xE8\x96\xAB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF7\xF0"],
        ["\xF7\xF0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\xAB"],

        ["\xE8\xA8\x93",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF7\xF1"],
        ["\xF7\xF1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\x93"],

        ["\xE7\xBE\xA4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF7\xF2"],
        ["\xF7\xF2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\xA4"],

        ["\xE8\xBB\x8D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF7\xF3"],
        ["\xF7\xF3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBB\x8D"],

        ["\xE9\x83\xA1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF7\xF4"],
        ["\xF7\xF4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x83\xA1"],

        ["\xE5\x8D\xA6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF7\xF5"],
        ["\xF7\xF5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\xA6"],

        ["\xE8\xA2\x88",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF7\xF6"],
        ["\xF7\xF6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA2\x88"],

        ["\xE7\xA5\x81",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF7\xF7"],
        ["\xF7\xF7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5\x81"],

        ["\xE4\xBF\x82",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF7\xF8"],
        ["\xF7\xF8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\x82"],

        ["\xE5\x82\xBE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF7\xF9"],
        ["\xF7\xF9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x82\xBE"],

        ["\xE5\x88\x91",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF7\x7A"],
        ["\xF7\x7A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\x91"],

        ["\xE5\x85\x84",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF7\x5E"],
        ["\xF7\x5E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\x84"],

        ["\xE5\x95\x93",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF7\x4C"],
        ["\xF7\x4C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x95\x93"],

        ["\xE5\x9C\xAD",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF7\x7E"],
        ["\xF7\x7E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C\xAD"],

        ["\xE7\x8F\xAA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF7\x6E"],
        ["\xF7\x6E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8F\xAA"],

        ["\xE5\x9E\x8B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF7\x6F"],
        ["\xF7\x6F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9E\x8B"],

        ["\xE5\xA5\x91",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF7\x7C"],
        ["\xF7\x7C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\x91"],

        ["\xE5\xBD\xA2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF7\xC1"],
        ["\xF7\xC1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\xA2"],

        ["\xE5\xBE\x84",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF7\xC2"],
        ["\xF7\xC2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\x84"],

        ["\xE6\x81\xB5",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF7\xC3"],
        ["\xF7\xC3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\xB5"],

        ["\xE6\x85\xB6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF7\xC4"],
        ["\xF7\xC4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\xB6"],

        ["\xE6\x85\xA7",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF7\xC5"],
        ["\xF7\xC5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\xA7"],

        ["\xE6\x86\xA9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF7\xC6"],
        ["\xF7\xC6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x86\xA9"],

        ["\xE6\x8E\xB2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF7\xC7"],
        ["\xF7\xC7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\xB2"],

        ["\xE6\x90\xBA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF7\xC8"],
        ["\xF7\xC8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x90\xBA"],

        ["\xE6\x95\xAC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF7\xC9"],
        ["\xF7\xC9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x95\xAC"],

        ["\xE6\x99\xAF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF7\xD1"],
        ["\xF7\xD1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\xAF"],

        ["\xE6\xA1\x82",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF7\xD2"],
        ["\xF7\xD2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\x82"],

        ["\xE6\xB8\x93",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF7\xD3"],
        ["\xF7\xD3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\x93"],

        ["\xE7\x95\xA6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF7\xD4"],
        ["\xF7\xD4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\xA6"],

        ["\xE7\xA8\xBD",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF7\xD5"],
        ["\xF7\xD5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8\xBD"],

        ["\xE7\xB3\xBB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF7\xD6"],
        ["\xF7\xD6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3\xBB"],

        ["\xE7\xB5\x8C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF7\xD7"],
        ["\xF7\xD7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\x8C"],

        ["\xE7\xB6\x99",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF7\xD8"],
        ["\xF7\xD8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\x99"],

        ["\xE7\xB9\x8B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF7\xD9"],
        ["\xF7\xD9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\x8B"],

        ["\xE7\xBD\xAB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF7\xE2"],
        ["\xF7\xE2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\xAB"],

        ["\xE8\x8C\x8E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF7\xE3"],
        ["\xF7\xE3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C\x8E"],

        ["\xE8\x8D\x8A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF7\xE4"],
        ["\xF7\xE4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8D\x8A"],

        ["\xE8\x9B\x8D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF7\xE5"],
        ["\xF7\xE5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9B\x8D"],

        ["\xE8\xA8\x88",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF7\xE6"],
        ["\xF7\xE6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\x88"],

        ["\xE8\xA9\xA3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF7\xE7"],
        ["\xF7\xE7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\xA3"],

        ["\xE8\xAD\xA6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF7\xE8"],
        ["\xF7\xE8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD\xA6"],

        ["\xE8\xBB\xBD",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF7\xE9"],
        ["\xF7\xE9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBB\xBD"],

        ["\xE9\xA0\x9A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x75\x80"],
        ["\x75\x80",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0\x9A"],

        ["\xE9\xB6\x8F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF7\x5B"],
        ["\xF7\x5B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB6\x8F"],

        ["\xE8\x8A\xB8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF7\x5A"],
        ["\xF7\x5A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8A\xB8"],

        ["\xE8\xBF\x8E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF7\x5F"],
        ["\xF7\x5F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF\x8E"],

        ["\xE9\xAF\xA8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF7\x6D"],
        ["\xF7\x6D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xAF\xA8"],

        ["\xE5\x8A\x87",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF7\x79"],
        ["\xF7\x79",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\x87"],

        ["\xE6\x88\x9F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF7\x57"],
        ["\xF7\x57",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\x9F"],

        ["\xE6\x92\x83",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF7\x59"],
        ["\xF7\x59",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x92\x83"],

        ["\xE6\xBF\x80",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF7\x62"],
        ["\xF7\x62",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF\x80"],

        ["\xE9\x9A\x99",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF7\x63"],
        ["\xF7\x63",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\x99"],

        ["\xE6\xA1\x81",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF7\x64"],
        ["\xF7\x64",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\x81"],

        ["\xE5\x82\x91",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF7\x65"],
        ["\xF7\x65",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x82\x91"],

        ["\xE6\xAC\xA0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF7\x66"],
        ["\xF7\x66",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAC\xA0"],

        ["\xE6\xB1\xBA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF7\x67"],
        ["\xF7\x67",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1\xBA"],

        ["\xE6\xBD\x94",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF7\x68"],
        ["\xF7\x68",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBD\x94"],

        ["\xE7\xA9\xB4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF7\x69"],
        ["\xF7\x69",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\xB4"],

        ["\xE7\xB5\x90",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF7\x70"],
        ["\xF7\x70",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\x90"],

        ["\xE8\xA1\x80",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF7\x71"],
        ["\xF7\x71",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\x80"],

        ["\xE8\xA8\xA3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF7\x72"],
        ["\xF7\x72",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\xA3"],

        ["\xE6\x9C\x88",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF7\x73"],
        ["\xF7\x73",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\x88"],

        ["\xE4\xBB\xB6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF7\x74"],
        ["\xF7\x74",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\xB6"],

        ["\xE5\x80\xB9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF7\x75"],
        ["\xF7\x75",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\xB9"],

        ["\xE5\x80\xA6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF7\x76"],
        ["\xF7\x76",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\xA6"],

        ["\xE5\x81\xA5",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF7\x77"],
        ["\xF7\x77",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x81\xA5"],

        ["\xE5\x85\xBC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF7\x78"],
        ["\xF7\x78",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\xBC"],

        ["\xE5\x88\xB8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF7\x80"],
        ["\xF7\x80",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\xB8"],

        ["\xE5\x89\xA3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF7\x8B"],
        ["\xF7\x8B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\xA3"],

        ["\xE5\x96\xA7",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF7\x9B"],
        ["\xF7\x9B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x96\xA7"],

        ["\xE5\x9C\x8F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF7\x9C"],
        ["\xF7\x9C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C\x8F"],

        ["\xE5\xA0\x85",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF7\xA0"],
        ["\xF7\xA0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA0\x85"],

        ["\xE5\xAB\x8C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF7\xAB"],
        ["\xF7\xAB",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAB\x8C"],

        ["\xE5\xBB\xBA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF7\xB0"],
        ["\xF7\xB0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\xBA"],

        ["\xE6\x86\xB2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF7\xC0"],
        ["\xF7\xC0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x86\xB2"],

        ["\xE6\x87\xB8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF7\x6A"],
        ["\xF7\x6A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x87\xB8"],

        ["\xE6\x8B\xB3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF7\xD0"],
        ["\xF7\xD0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\xB3"],

        ["\xE6\x8D\xB2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF7\xA1"],
        ["\xF7\xA1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8D\xB2"],

        ["\xE6\xA4\x9C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF8\x4F"],
        ["\xF8\x4F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\x9C"],

        ["\xE6\xA8\xA9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF8\x7F"],
        ["\xF8\x7F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\xA9"],

        ["\xE7\x89\xBD",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF8\x7B"],
        ["\xF8\x7B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x89\xBD"],

        ["\xE7\x8A\xAC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF8\xE0"],
        ["\xF8\xE0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8A\xAC"],

        ["\xE7\x8C\xAE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF8\x6C"],
        ["\xF8\x6C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8C\xAE"],

        ["\xE7\xA0\x94",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF8\x50"],
        ["\xF8\x50",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA0\x94"],

        ["\xE7\xA1\xAF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF8\x7D"],
        ["\xF8\x7D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA1\xAF"],

        ["\xE7\xB5\xB9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF8\x4D"],
        ["\xF8\x4D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\xB9"],

        ["\xE7\x9C\x8C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF8\x5D"],
        ["\xF8\x5D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9C\x8C"],

        ["\xE8\x82\xA9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF8\x5C"],
        ["\xF8\x5C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x82\xA9"],

        ["\xE8\xA6\x8B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF8\x4E"],
        ["\xF8\x4E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\x8B"],

        ["\xE8\xAC\x99",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF8\x6B"],
        ["\xF8\x6B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC\x99"],

        ["\xE8\xB3\xA2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF8\x60"],
        ["\xF8\x60",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\xA2"],

        ["\xE8\xBB\x92",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF8\x4B"],
        ["\xF8\x4B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBB\x92"],

        ["\xE9\x81\xA3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF8\x61"],
        ["\xF8\x61",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\xA3"],

        ["\xE9\x8D\xB5",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF8\xF0"],
        ["\xF8\xF0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8D\xB5"],

        ["\xE9\x99\xBA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF8\xF1"],
        ["\xF8\xF1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x99\xBA"],

        ["\xE9\xA1\x95",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF8\xF2"],
        ["\xF8\xF2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA1\x95"],

        ["\xE9\xA8\x93",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF8\xF3"],
        ["\xF8\xF3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA8\x93"],

        ["\xE9\xB9\xB8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF8\xF4"],
        ["\xF8\xF4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB9\xB8"],

        ["\xE5\x85\x83",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF8\xF5"],
        ["\xF8\xF5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\x83"],

        ["\xE5\x8E\x9F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF8\xF6"],
        ["\xF8\xF6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8E\x9F"],

        ["\xE5\x8E\xB3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF8\xF7"],
        ["\xF8\xF7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8E\xB3"],

        ["\xE5\xB9\xBB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF8\xF8"],
        ["\xF8\xF8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\xBB"],

        ["\xE5\xBC\xA6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF8\xF9"],
        ["\xF8\xF9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\xA6"],

        ["\xE6\xB8\x9B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF8\x7A"],
        ["\xF8\x7A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\x9B"],

        ["\xE6\xBA\x90",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF8\x5E"],
        ["\xF8\x5E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBA\x90"],

        ["\xE7\x8E\x84",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF8\x4C"],
        ["\xF8\x4C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8E\x84"],

        ["\xE7\x8F\xBE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF8\x7E"],
        ["\xF8\x7E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8F\xBE"],

        ["\xE7\xB5\x83",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF8\x6E"],
        ["\xF8\x6E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\x83"],

        ["\xE8\x88\xB7",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF8\x6F"],
        ["\xF8\x6F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\xB7"],

        ["\xE8\xA8\x80",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF8\x7C"],
        ["\xF8\x7C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\x80"],

        ["\xE8\xAB\xBA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF8\xC1"],
        ["\xF8\xC1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\xBA"],

        ["\xE9\x99\x90",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF8\xC2"],
        ["\xF8\xC2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x99\x90"],

        ["\xE4\xB9\x8E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF8\xC3"],
        ["\xF8\xC3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xB9\x8E"],

        ["\xE5\x80\x8B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF8\xC4"],
        ["\xF8\xC4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\x8B"],

        ["\xE5\x8F\xA4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF8\xC5"],
        ["\xF8\xC5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\xA4"],

        ["\xE5\x91\xBC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF8\xC6"],
        ["\xF8\xC6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x91\xBC"],

        ["\xE5\x9B\xBA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF8\xC7"],
        ["\xF8\xC7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B\xBA"],

        ["\xE5\xA7\x91",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF8\xC8"],
        ["\xF8\xC8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA7\x91"],

        ["\xE5\xAD\xA4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF8\xC9"],
        ["\xF8\xC9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\xA4"],

        ["\xE5\xB7\xB1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF8\xD1"],
        ["\xF8\xD1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\xB1"],

        ["\xE5\xBA\xAB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF8\xD2"],
        ["\xF8\xD2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBA\xAB"],

        ["\xE5\xBC\xA7",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF8\xD3"],
        ["\xF8\xD3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\xA7"],

        ["\xE6\x88\xB8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF8\xD4"],
        ["\xF8\xD4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\xB8"],

        ["\xE6\x95\x85",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF8\xD5"],
        ["\xF8\xD5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x95\x85"],

        ["\xE6\x9E\xAF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF8\xD6"],
        ["\xF8\xD6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E\xAF"],

        ["\xE6\xB9\x96",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF8\xD7"],
        ["\xF8\xD7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB9\x96"],

        ["\xE7\x8B\x90",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF8\xD8"],
        ["\xF8\xD8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8B\x90"],

        ["\xE7\xB3\x8A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF8\xD9"],
        ["\xF8\xD9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3\x8A"],

        ["\xE8\xA2\xB4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF8\xE2"],
        ["\xF8\xE2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA2\xB4"],

        ["\xE8\x82\xA1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF8\xE3"],
        ["\xF8\xE3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x82\xA1"],

        ["\xE8\x83\xA1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF8\xE4"],
        ["\xF8\xE4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x83\xA1"],

        ["\xE8\x8F\xB0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF8\xE5"],
        ["\xF8\xE5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F\xB0"],

        ["\xE8\x99\x8E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF8\xE6"],
        ["\xF8\xE6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x99\x8E"],

        ["\xE8\xAA\x87",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF8\xE7"],
        ["\xF8\xE7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\x87"],

        ["\xE8\xB7\xA8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF8\xE8"],
        ["\xF8\xE8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB7\xA8"],

        ["\xE9\x88\xB7",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF8\xE9"],
        ["\xF8\xE9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x88\xB7"],

        ["\xE9\x9B\x87",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF8\x4A"],
        ["\xF8\x4A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\x87"],

        ["\xE9\xA1\xA7",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF8\x5B"],
        ["\xF8\x5B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA1\xA7"],

        ["\xE9\xBC\x93",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF8\x5A"],
        ["\xF8\x5A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xBC\x93"],

        ["\xE4\xBA\x94",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF8\x5F"],
        ["\xF8\x5F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\x94"],

        ["\xE4\xBA\x92",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF8\x6D"],
        ["\xF8\x6D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\x92"],

        ["\xE4\xBC\x8D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF8\x79"],
        ["\xF8\x79",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBC\x8D"],

        ["\xE5\x8D\x88",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF8\x57"],
        ["\xF8\x57",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\x88"],

        ["\xE5\x91\x89",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF8\x59"],
        ["\xF8\x59",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x91\x89"],

        ["\xE5\x90\xBE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF8\x62"],
        ["\xF8\x62",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\xBE"],

        ["\xE5\xA8\xAF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF8\x63"],
        ["\xF8\x63",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA8\xAF"],

        ["\xE5\xBE\x8C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF8\x64"],
        ["\xF8\x64",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\x8C"],

        ["\xE5\xBE\xA1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF8\x65"],
        ["\xF8\x65",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\xA1"],

        ["\xE6\x82\x9F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF8\x66"],
        ["\xF8\x66",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\x9F"],

        ["\xE6\xA2\xA7",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF8\x67"],
        ["\xF8\x67",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\xA7"],

        ["\xE6\xAA\x8E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF8\x68"],
        ["\xF8\x68",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAA\x8E"],

        ["\xE7\x91\x9A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF8\x69"],
        ["\xF8\x69",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x91\x9A"],

        ["\xE7\xA2\x81",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF8\x70"],
        ["\xF8\x70",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA2\x81"],

        ["\xE8\xAA\x9E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF8\x71"],
        ["\xF8\x71",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\x9E"],

        ["\xE8\xAA\xA4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF8\x72"],
        ["\xF8\x72",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\xA4"],

        ["\xE8\xAD\xB7",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF8\x73"],
        ["\xF8\x73",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD\xB7"],

        ["\xE9\x86\x90",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF8\x74"],
        ["\xF8\x74",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x86\x90"],

        ["\xE4\xB9\x9E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF8\x75"],
        ["\xF8\x75",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xB9\x9E"],

        ["\xE9\xAF\x89",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF8\x76"],
        ["\xF8\x76",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xAF\x89"],

        ["\xE4\xBA\xA4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF8\x77"],
        ["\xF8\x77",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\xA4"],

        ["\xE4\xBD\xBC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF8\x78"],
        ["\xF8\x78",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\xBC"],

        ["\xE4\xBE\xAF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF8\x80"],
        ["\xF8\x80",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE\xAF"],

        ["\xE5\x80\x99",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF8\x8B"],
        ["\xF8\x8B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\x99"],

        ["\xE5\x80\x96",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF8\x9B"],
        ["\xF8\x9B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\x96"],

        ["\xE5\x85\x89",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF8\x9C"],
        ["\xF8\x9C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\x89"],

        ["\xE5\x85\xAC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF8\xA0"],
        ["\xF8\xA0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\xAC"],

        ["\xE5\x8A\x9F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF8\xAB"],
        ["\xF8\xAB",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\x9F"],

        ["\xE5\x8A\xB9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF8\xB0"],
        ["\xF8\xB0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\xB9"],

        ["\xE5\x8B\xBE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF8\xC0"],
        ["\xF8\xC0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\xBE"],

        ["\xE5\x8E\x9A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF8\x6A"],
        ["\xF8\x6A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8E\x9A"],

        ["\xE5\x8F\xA3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF8\xD0"],
        ["\xF8\xD0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\xA3"],

        ["\xE5\x90\x91",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF8\xA1"],
        ["\xF8\xA1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\x91"],

        ["\xE5\x90\x8E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF9\x4F"],
        ["\xF9\x4F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\x8E"],

        ["\xE5\x96\x89",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF9\x7F"],
        ["\xF9\x7F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x96\x89"],

        ["\xE5\x9D\x91",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF9\x7B"],
        ["\xF9\x7B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9D\x91"],

        ["\xE5\x9E\xA2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF9\xE0"],
        ["\xF9\xE0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9E\xA2"],

        ["\xE5\xA5\xBD",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF9\x6C"],
        ["\xF9\x6C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\xBD"],

        ["\xE5\xAD\x94",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF9\x50"],
        ["\xF9\x50",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\x94"],

        ["\xE5\xAD\x9D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF9\x7D"],
        ["\xF9\x7D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\x9D"],

        ["\xE5\xAE\x8F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF9\x4D"],
        ["\xF9\x4D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\x8F"],

        ["\xE5\xB7\xA5",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF9\x5D"],
        ["\xF9\x5D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\xA5"],

        ["\xE5\xB7\xA7",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF9\x5C"],
        ["\xF9\x5C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\xA7"],

        ["\xE5\xB7\xB7",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF9\x4E"],
        ["\xF9\x4E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\xB7"],

        ["\xE5\xB9\xB8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF9\x6B"],
        ["\xF9\x6B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\xB8"],

        ["\xE5\xBA\x83",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF9\x60"],
        ["\xF9\x60",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBA\x83"],

        ["\xE5\xBA\x9A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF9\x4B"],
        ["\xF9\x4B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBA\x9A"],

        ["\xE5\xBA\xB7",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF9\x61"],
        ["\xF9\x61",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBA\xB7"],

        ["\xE5\xBC\x98",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF9\xF0"],
        ["\xF9\xF0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\x98"],

        ["\xE6\x81\x92",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF9\xF1"],
        ["\xF9\xF1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\x92"],

        ["\xE6\x85\x8C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF9\xF2"],
        ["\xF9\xF2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\x8C"],

        ["\xE6\x8A\x97",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF9\xF3"],
        ["\xF9\xF3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A\x97"],

        ["\xE6\x8B\x98",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF9\xF4"],
        ["\xF9\xF4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\x98"],

        ["\xE6\x8E\xA7",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF9\xF5"],
        ["\xF9\xF5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\xA7"],

        ["\xE6\x94\xBB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF9\xF6"],
        ["\xF9\xF6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x94\xBB"],

        ["\xE6\x98\x82",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x8E\x86"],
        ["\x8E\x86",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\x82"],

        ["\xE6\x99\x83",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF9\xF8"],
        ["\xF9\xF8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\x83"],

        ["\xE6\x9B\xB4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF9\xF9"],
        ["\xF9\xF9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\xB4"],

        ["\xE6\x9D\xAD",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF9\x7A"],
        ["\xF9\x7A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\xAD"],

        ["\xE6\xA0\xA1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF9\x5E"],
        ["\xF9\x5E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA0\xA1"],

        ["\xE6\xA2\x97",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF9\x4C"],
        ["\xF9\x4C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\x97"],

        ["\xE6\xA7\x8B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF9\x7E"],
        ["\xF9\x7E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\x8B"],

        ["\xE6\xB1\x9F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF9\x6E"],
        ["\xF9\x6E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1\x9F"],

        ["\xE6\xB4\xAA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF9\x6F"],
        ["\xF9\x6F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4\xAA"],

        ["\xE6\xB5\xA9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF9\x7C"],
        ["\xF9\x7C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB5\xA9"],

        ["\xE6\xB8\xAF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF9\xC1"],
        ["\xF9\xC1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\xAF"],

        ["\xE6\xBA\x9D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF9\xC2"],
        ["\xF9\xC2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBA\x9D"],

        ["\xE7\x94\xB2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF9\xC3"],
        ["\xF9\xC3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\xB2"],

        ["\xE7\x9A\x87",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF9\xC4"],
        ["\xF9\xC4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\x87"],

        ["\xE7\xA1\xAC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF9\xC5"],
        ["\xF9\xC5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA1\xAC"],

        ["\xE7\xA8\xBF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF9\xC6"],
        ["\xF9\xC6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8\xBF"],

        ["\xE7\xB3\xA0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF9\xC7"],
        ["\xF9\xC7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3\xA0"],

        ["\xE7\xB4\x85",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF9\xC8"],
        ["\xF9\xC8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\x85"],

        ["\xE7\xB4\x98",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF9\xC9"],
        ["\xF9\xC9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\x98"],

        ["\xE7\xB5\x9E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF9\xD1"],
        ["\xF9\xD1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\x9E"],

        ["\xE7\xB6\xB1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF9\xD2"],
        ["\xF9\xD2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\xB1"],

        ["\xE8\x80\x95",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF9\xD3"],
        ["\xF9\xD3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\x95"],

        ["\xE8\x80\x83",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF9\xD4"],
        ["\xF9\xD4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\x83"],

        ["\xE8\x82\xAF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF9\xD5"],
        ["\xF9\xD5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x82\xAF"],

        ["\xE8\x82\xB1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF9\xD6"],
        ["\xF9\xD6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x82\xB1"],

        ["\xE8\x85\x94",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF9\xD7"],
        ["\xF9\xD7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x85\x94"],

        ["\xE8\x86\x8F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF9\xD8"],
        ["\xF9\xD8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x86\x8F"],

        ["\xE8\x88\xAA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF9\xD9"],
        ["\xF9\xD9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\xAA"],

        ["\xE8\x8D\x92",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF9\xE2"],
        ["\xF9\xE2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8D\x92"],

        ["\xE8\xA1\x8C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF9\xE3"],
        ["\xF9\xE3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\x8C"],

        ["\xE8\xA1\xA1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF9\xE4"],
        ["\xF9\xE4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\xA1"],

        ["\xE8\xAC\x9B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF9\xE5"],
        ["\xF9\xE5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC\x9B"],

        ["\xE8\xB2\xA2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF9\xE6"],
        ["\xF9\xE6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\xA2"],

        ["\xE8\xB3\xBC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF9\xE7"],
        ["\xF9\xE7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\xBC"],

        ["\xE9\x83\x8A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF9\xE8"],
        ["\xF9\xE8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x83\x8A"],

        ["\xE9\x85\xB5",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF9\xE9"],
        ["\xF9\xE9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x85\xB5"],

        ["\xE9\x89\xB1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF9\x4A"],
        ["\xF9\x4A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x89\xB1"],

        ["\xE7\xA0\xBF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x59\x67"],
        ["\x59\x67",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA0\xBF"],

        ["\xE9\x8B\xBC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF9\x5A"],
        ["\xF9\x5A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8B\xBC"],

        ["\xE9\x96\xA4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF9\x5F"],
        ["\xF9\x5F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\xA4"],

        ["\xE9\x99\x8D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF9\x6D"],
        ["\xF9\x6D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x99\x8D"],

        ["\xE9\xA0\x85",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF9\x79"],
        ["\xF9\x79",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0\x85"],

        ["\xE9\xA6\x99",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF9\x57"],
        ["\xF9\x57",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA6\x99"],

        ["\xE9\xAB\x98",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF9\x59"],
        ["\xF9\x59",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xAB\x98"],

        ["\xE9\xB4\xBB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF9\x62"],
        ["\xF9\x62",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB4\xBB"],

        ["\xE5\x89\x9B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF9\x63"],
        ["\xF9\x63",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\x9B"],

        ["\xE5\x8A\xAB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF9\x64"],
        ["\xF9\x64",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\xAB"],

        ["\xE5\x8F\xB7",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF9\x65"],
        ["\xF9\x65",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\xB7"],

        ["\xE5\x90\x88",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF9\x66"],
        ["\xF9\x66",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\x88"],

        ["\xE5\xA3\x95",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF9\x67"],
        ["\xF9\x67",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\x95"],

        ["\xE6\x8B\xB7",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF9\x68"],
        ["\xF9\x68",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\xB7"],

        ["\xE6\xBF\xA0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF9\x69"],
        ["\xF9\x69",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF\xA0"],

        ["\xE8\xB1\xAA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF9\x70"],
        ["\xF9\x70",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB1\xAA"],

        ["\xE8\xBD\x9F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF9\x71"],
        ["\xF9\x71",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBD\x9F"],

        ["\xE9\xBA\xB9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xAC\x8C"],
        ["\xAC\x8C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xBA\xB9"],

        ["\xE5\x85\x8B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF9\x73"],
        ["\xF9\x73",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\x8B"],

        ["\xE5\x88\xBB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF9\x74"],
        ["\xF9\x74",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\xBB"],

        ["\xE5\x91\x8A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF9\x75"],
        ["\xF9\x75",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x91\x8A"],

        ["\xE5\x9B\xBD",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF9\x76"],
        ["\xF9\x76",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B\xBD"],

        ["\xE7\xA9\x80",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF9\x77"],
        ["\xF9\x77",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\x80"],

        ["\xE9\x85\xB7",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF9\x78"],
        ["\xF9\x78",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x85\xB7"],

        ["\xE9\xB5\xA0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF9\x80"],
        ["\xF9\x80",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB5\xA0"],

        ["\xE9\xBB\x92",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF9\x8B"],
        ["\xF9\x8B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xBB\x92"],

        ["\xE7\x8D\x84",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF9\x9B"],
        ["\xF9\x9B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8D\x84"],

        ["\xE6\xBC\x89",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF9\x9C"],
        ["\xF9\x9C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBC\x89"],

        ["\xE8\x85\xB0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF9\xA0"],
        ["\xF9\xA0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x85\xB0"],

        ["\xE7\x94\x91",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF9\xAB"],
        ["\xF9\xAB",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\x91"],

        ["\xE5\xBF\xBD",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF9\xB0"],
        ["\xF9\xB0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF\xBD"],

        ["\xE6\x83\x9A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF9\xC0"],
        ["\xF9\xC0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\x9A"],

        ["\xE9\xAA\xA8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF9\x6A"],
        ["\xF9\x6A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xAA\xA8"],

        ["\xE7\x8B\x9B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF9\xD0"],
        ["\xF9\xD0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8B\x9B"],

        ["\xE8\xBE\xBC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF9\xA1"],
        ["\xF9\xA1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBE\xBC"],

        ["\xE6\xAD\xA4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7A\x4F"],
        ["\x7A\x4F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\xA4"],

        ["\xE9\xA0\x83",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7A\x7F"],
        ["\x7A\x7F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0\x83"],

        ["\xE4\xBB\x8A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7A\x7B"],
        ["\x7A\x7B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\x8A"],

        ["\xE5\x9B\xB0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7A\xE0"],
        ["\x7A\xE0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B\xB0"],

        ["\xE5\x9D\xA4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7A\x6C"],
        ["\x7A\x6C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9D\xA4"],

        ["\xE5\xA2\xBE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7A\x50"],
        ["\x7A\x50",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA2\xBE"],

        ["\xE5\xA9\x9A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7A\x7D"],
        ["\x7A\x7D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA9\x9A"],

        ["\xE6\x81\xA8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7A\x4D"],
        ["\x7A\x4D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\xA8"],

        ["\xE6\x87\x87",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7A\x5D"],
        ["\x7A\x5D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x87\x87"],

        ["\xE6\x98\x8F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7A\x5C"],
        ["\x7A\x5C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\x8F"],

        ["\xE6\x98\x86",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7A\x4E"],
        ["\x7A\x4E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\x86"],

        ["\xE6\xA0\xB9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7A\x6B"],
        ["\x7A\x6B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA0\xB9"],

        ["\xE6\xA2\xB1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7A\x60"],
        ["\x7A\x60",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\xB1"],

        ["\xE6\xB7\xB7",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7A\x4B"],
        ["\x7A\x4B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\xB7"],

        ["\xE7\x97\x95",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7A\x61"],
        ["\x7A\x61",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\x95"],

        ["\xE7\xB4\xBA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7A\xF0"],
        ["\x7A\xF0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\xBA"],

        ["\xE8\x89\xAE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7A\xF1"],
        ["\x7A\xF1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x89\xAE"],

        ["\xE9\xAD\x82",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7A\xF2"],
        ["\x7A\xF2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xAD\x82"],

        ["\xE4\xBA\x9B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7A\xF3"],
        ["\x7A\xF3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\x9B"],

        ["\xE4\xBD\x90",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7A\xF4"],
        ["\x7A\xF4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\x90"],

        ["\xE5\x8F\x89",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7A\xF5"],
        ["\x7A\xF5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\x89"],

        ["\xE5\x94\x86",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7A\xF6"],
        ["\x7A\xF6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x94\x86"],

        ["\xE5\xB5\xAF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7A\xF7"],
        ["\x7A\xF7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB5\xAF"],

        ["\xE5\xB7\xA6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7A\xF8"],
        ["\x7A\xF8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\xA6"],

        ["\xE5\xB7\xAE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7A\xF9"],
        ["\x7A\xF9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\xAE"],

        ["\xE6\x9F\xBB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7A\x7A"],
        ["\x7A\x7A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\xBB"],

        ["\xE6\xB2\x99",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7A\x5E"],
        ["\x7A\x5E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\x99"],

        ["\xE7\x91\xB3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7A\x4C"],
        ["\x7A\x4C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x91\xB3"],

        ["\xE7\xA0\x82",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7A\x7E"],
        ["\x7A\x7E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA0\x82"],

        ["\xE8\xA9\x90",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7A\x6E"],
        ["\x7A\x6E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\x90"],

        ["\xE9\x8E\x96",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7A\x6F"],
        ["\x7A\x6F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8E\x96"],

        ["\xE8\xA3\x9F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7A\x7C"],
        ["\x7A\x7C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\x9F"],

        ["\xE5\x9D\x90",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7A\xC1"],
        ["\x7A\xC1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9D\x90"],

        ["\xE5\xBA\xA7",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7A\xC2"],
        ["\x7A\xC2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBA\xA7"],

        ["\xE6\x8C\xAB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7A\xC3"],
        ["\x7A\xC3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8C\xAB"],

        ["\xE5\x82\xB5",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7A\xC4"],
        ["\x7A\xC4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x82\xB5"],

        ["\xE5\x82\xAC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7A\xC5"],
        ["\x7A\xC5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x82\xAC"],

        ["\xE5\x86\x8D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7A\xC6"],
        ["\x7A\xC6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\x8D"],

        ["\xE6\x9C\x80",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7A\xC7"],
        ["\x7A\xC7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\x80"],

        ["\xE5\x93\x89",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7A\xC8"],
        ["\x7A\xC8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x93\x89"],

        ["\xE5\xA1\x9E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7A\xC9"],
        ["\x7A\xC9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA1\x9E"],

        ["\xE5\xA6\xBB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7A\xD1"],
        ["\x7A\xD1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA6\xBB"],

        ["\xE5\xAE\xB0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7A\xD2"],
        ["\x7A\xD2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\xB0"],

        ["\xE5\xBD\xA9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7A\xD3"],
        ["\x7A\xD3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\xA9"],

        ["\xE6\x89\x8D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7A\xD4"],
        ["\x7A\xD4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\x8D"],

        ["\xE6\x8E\xA1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7A\xD5"],
        ["\x7A\xD5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\xA1"],

        ["\xE6\xA0\xBD",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7A\xD6"],
        ["\x7A\xD6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA0\xBD"],

        ["\xE6\xAD\xB3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7A\xD7"],
        ["\x7A\xD7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\xB3"],

        ["\xE6\xB8\x88",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7A\xD8"],
        ["\x7A\xD8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\x88"],

        ["\xE7\x81\xBD",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7A\xD9"],
        ["\x7A\xD9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x81\xBD"],

        ["\xE9\x87\x87",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7A\xE2"],
        ["\x7A\xE2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\x87"],

        ["\xE7\x8A\x80",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7A\xE3"],
        ["\x7A\xE3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8A\x80"],

        ["\xE7\xA0\x95",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7A\xE4"],
        ["\x7A\xE4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA0\x95"],

        ["\xE7\xA0\xA6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7A\xE5"],
        ["\x7A\xE5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA0\xA6"],

        ["\xE7\xA5\xAD",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7A\xE6"],
        ["\x7A\xE6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5\xAD"],

        ["\xE6\x96\x8E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7A\xE7"],
        ["\x7A\xE7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\x8E"],

        ["\xE7\xB4\xB0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7A\xE8"],
        ["\x7A\xE8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\xB0"],

        ["\xE8\x8F\x9C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7A\xE9"],
        ["\x7A\xE9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F\x9C"],

        ["\xE8\xA3\x81",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7A\x4A"],
        ["\x7A\x4A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\x81"],

        ["\xE8\xBC\x89",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7A\x5B"],
        ["\x7A\x5B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC\x89"],

        ["\xE9\x9A\x9B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7A\x5A"],
        ["\x7A\x5A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\x9B"],

        ["\xE5\x89\xA4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7A\x5F"],
        ["\x7A\x5F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\xA4"],

        ["\xE5\x9C\xA8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7A\x6D"],
        ["\x7A\x6D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C\xA8"],

        ["\xE6\x9D\x90",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7A\x79"],
        ["\x7A\x79",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\x90"],

        ["\xE7\xBD\xAA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7A\x57"],
        ["\x7A\x57",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\xAA"],

        ["\xE8\xB2\xA1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7A\x59"],
        ["\x7A\x59",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\xA1"],

        ["\xE5\x86\xB4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7A\x62"],
        ["\x7A\x62",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\xB4"],

        ["\xE5\x9D\x82",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7A\x63"],
        ["\x7A\x63",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9D\x82"],

        ["\xE9\x98\xAA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7A\x64"],
        ["\x7A\x64",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x98\xAA"],

        ["\xE5\xA0\xBA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7A\x65"],
        ["\x7A\x65",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA0\xBA"],

        ["\xE6\xA6\x8A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7A\x66"],
        ["\x7A\x66",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA6\x8A"],

        ["\xE8\x82\xB4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7A\x67"],
        ["\x7A\x67",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x82\xB4"],

        ["\xE5\x92\xB2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7A\x68"],
        ["\x7A\x68",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\xB2"],

        ["\xE5\xB4\x8E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7A\x69"],
        ["\x7A\x69",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB4\x8E"],

        ["\xE5\x9F\xBC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7A\x70"],
        ["\x7A\x70",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9F\xBC"],

        ["\xE7\xA2\x95",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7A\x71"],
        ["\x7A\x71",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA2\x95"],

        ["\xE9\xB7\xBA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7A\x72"],
        ["\x7A\x72",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB7\xBA"],

        ["\xE4\xBD\x9C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7A\x73"],
        ["\x7A\x73",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\x9C"],

        ["\xE5\x89\x8A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7A\x74"],
        ["\x7A\x74",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\x8A"],

        ["\xE5\x92\x8B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7A\x75"],
        ["\x7A\x75",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\x8B"],

        ["\xE6\x90\xBE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7A\x76"],
        ["\x7A\x76",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x90\xBE"],

        ["\xE6\x98\xA8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7A\x77"],
        ["\x7A\x77",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\xA8"],

        ["\xE6\x9C\x94",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7A\x78"],
        ["\x7A\x78",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\x94"],

        ["\xE6\x9F\xB5",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7A\x80"],
        ["\x7A\x80",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\xB5"],

        ["\xE7\xAA\x84",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7A\x8B"],
        ["\x7A\x8B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAA\x84"],

        ["\xE7\xAD\x96",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7A\x9B"],
        ["\x7A\x9B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\x96"],

        ["\xE7\xB4\xA2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7A\x9C"],
        ["\x7A\x9C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\xA2"],

        ["\xE9\x8C\xAF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7A\xA0"],
        ["\x7A\xA0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8C\xAF"],

        ["\xE6\xA1\x9C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7A\xAB"],
        ["\x7A\xAB",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\x9C"],

        ["\xE9\xAE\xAD",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7A\xB0"],
        ["\x7A\xB0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xAE\xAD"],

        ["\xE7\xAC\xB9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7A\xC0"],
        ["\x7A\xC0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC\xB9"],

        ["\xE5\x8C\x99",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7A\x6A"],
        ["\x7A\x6A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\x99"],

        ["\xE5\x86\x8A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7A\xD0"],
        ["\x7A\xD0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\x8A"],

        ["\xE5\x88\xB7",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7A\xA1"],
        ["\x7A\xA1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\xB7"],

        ["\xE5\xAF\x9F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5E\x4F"],
        ["\x5E\x4F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\x9F"],

        ["\xE6\x8B\xB6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5E\x7F"],
        ["\x5E\x7F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\xB6"],

        ["\xE6\x92\xAE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5E\x7B"],
        ["\x5E\x7B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x92\xAE"],

        ["\xE6\x93\xA6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5E\xE0"],
        ["\x5E\xE0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\xA6"],

        ["\xE6\x9C\xAD",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5E\x6C"],
        ["\x5E\x6C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\xAD"],

        ["\xE6\xAE\xBA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5E\x50"],
        ["\x5E\x50",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\xBA"],

        ["\xE8\x96\xA9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5E\x7D"],
        ["\x5E\x7D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\xA9"],

        ["\xE9\x9B\x91",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5E\x4D"],
        ["\x5E\x4D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\x91"],

        ["\xE7\x9A\x90",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5E\x5D"],
        ["\x5E\x5D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\x90"],

        ["\xE9\xAF\x96",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5E\x5C"],
        ["\x5E\x5C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xAF\x96"],

        ["\xE6\x8D\x8C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5E\x4E"],
        ["\x5E\x4E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8D\x8C"],

        ["\xE9\x8C\x86",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5E\x6B"],
        ["\x5E\x6B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8C\x86"],

        ["\xE9\xAE\xAB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5E\x60"],
        ["\x5E\x60",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xAE\xAB"],

        ["\xE7\x9A\xBF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5E\x4B"],
        ["\x5E\x4B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\xBF"],

        ["\xE6\x99\x92",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5E\x61"],
        ["\x5E\x61",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\x92"],

        ["\xE4\xB8\x89",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5E\xF0"],
        ["\x5E\xF0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\x89"],

        ["\xE5\x82\x98",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5E\xF1"],
        ["\x5E\xF1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x82\x98"],

        ["\xE5\x8F\x82",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5E\xF2"],
        ["\x5E\xF2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\x82"],

        ["\xE5\xB1\xB1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5E\xF3"],
        ["\x5E\xF3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\xB1"],

        ["\xE6\x83\xA8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5E\xF4"],
        ["\x5E\xF4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\xA8"],

        ["\xE6\x92\x92",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5E\xF5"],
        ["\x5E\xF5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x92\x92"],

        ["\xE6\x95\xA3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5E\xF6"],
        ["\x5E\xF6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x95\xA3"],

        ["\xE6\xA1\x9F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5E\xF7"],
        ["\x5E\xF7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\x9F"],

        ["\xE7\x87\xA6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5E\xF8"],
        ["\x5E\xF8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x87\xA6"],

        ["\xE7\x8F\x8A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5E\xF9"],
        ["\x5E\xF9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8F\x8A"],

        ["\xE7\x94\xA3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5E\x7A"],
        ["\x5E\x7A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\xA3"],

        ["\xE7\xAE\x97",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5E\x5E"],
        ["\x5E\x5E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAE\x97"],

        ["\xE7\xBA\x82",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5E\x4C"],
        ["\x5E\x4C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBA\x82"],

        ["\xE8\x9A\x95",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5E\x7E"],
        ["\x5E\x7E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9A\x95"],

        ["\xE8\xAE\x83",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5E\x6E"],
        ["\x5E\x6E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAE\x83"],

        ["\xE8\xB3\x9B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5E\x6F"],
        ["\x5E\x6F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\x9B"],

        ["\xE9\x85\xB8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5E\x7C"],
        ["\x5E\x7C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x85\xB8"],

        ["\xE9\xA4\x90",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5E\xC1"],
        ["\x5E\xC1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA4\x90"],

        ["\xE6\x96\xAC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5E\xC2"],
        ["\x5E\xC2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\xAC"],

        ["\xE6\x9A\xAB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5E\xC3"],
        ["\x5E\xC3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A\xAB"],

        ["\xE6\xAE\x8B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5E\xC4"],
        ["\x5E\xC4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\x8B"],

        ["\xE4\xBB\x95",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5E\xC5"],
        ["\x5E\xC5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\x95"],

        ["\xE4\xBB\x94",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5E\xC6"],
        ["\x5E\xC6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\x94"],

        ["\xE4\xBC\xBA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5E\xC7"],
        ["\x5E\xC7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBC\xBA"],

        ["\xE4\xBD\xBF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5E\xC8"],
        ["\x5E\xC8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\xBF"],

        ["\xE5\x88\xBA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5E\xC9"],
        ["\x5E\xC9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\xBA"],

        ["\xE5\x8F\xB8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5E\xD1"],
        ["\x5E\xD1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\xB8"],

        ["\xE5\x8F\xB2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5E\xD2"],
        ["\x5E\xD2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\xB2"],

        ["\xE5\x97\xA3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5E\xD3"],
        ["\x5E\xD3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x97\xA3"],

        ["\xE5\x9B\x9B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5E\xD4"],
        ["\x5E\xD4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B\x9B"],

        ["\xE5\xA3\xAB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5E\xD5"],
        ["\x5E\xD5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\xAB"],

        ["\xE5\xA7\x8B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5E\xD6"],
        ["\x5E\xD6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA7\x8B"],

        ["\xE5\xA7\x89",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5E\xD7"],
        ["\x5E\xD7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA7\x89"],

        ["\xE5\xA7\xBF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5E\xD8"],
        ["\x5E\xD8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA7\xBF"],

        ["\xE5\xAD\x90",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5E\xD9"],
        ["\x5E\xD9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\x90"],

        ["\xE5\xB1\x8D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5E\xE2"],
        ["\x5E\xE2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\x8D"],

        ["\xE5\xB8\x82",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5E\xE3"],
        ["\x5E\xE3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8\x82"],

        ["\xE5\xB8\xAB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5E\xE4"],
        ["\x5E\xE4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8\xAB"],

        ["\xE5\xBF\x97",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5E\xE5"],
        ["\x5E\xE5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF\x97"],

        ["\xE6\x80\x9D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5E\xE6"],
        ["\x5E\xE6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x80\x9D"],

        ["\xE6\x8C\x87",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5E\xE7"],
        ["\x5E\xE7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8C\x87"],

        ["\xE6\x94\xAF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5E\xE8"],
        ["\x5E\xE8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x94\xAF"],

        ["\xE5\xAD\x9C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5E\xE9"],
        ["\x5E\xE9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\x9C"],

        ["\xE6\x96\xAF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5E\x4A"],
        ["\x5E\x4A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\xAF"],

        ["\xE6\x96\xBD",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5E\x5B"],
        ["\x5E\x5B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\xBD"],

        ["\xE6\x97\xA8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5E\x5A"],
        ["\x5E\x5A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\xA8"],

        ["\xE6\x9E\x9D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5E\x5F"],
        ["\x5E\x5F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E\x9D"],

        ["\xE6\xAD\xA2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5E\x6D"],
        ["\x5E\x6D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\xA2"],

        ["\xE6\xAD\xBB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5E\x79"],
        ["\x5E\x79",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\xBB"],

        ["\xE6\xB0\x8F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5E\x57"],
        ["\x5E\x57",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB0\x8F"],

        ["\xE7\x8D\x85",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5E\x59"],
        ["\x5E\x59",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8D\x85"],

        ["\xE7\xA5\x89",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5E\x62"],
        ["\x5E\x62",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5\x89"],

        ["\xE7\xA7\x81",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5E\x63"],
        ["\x5E\x63",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA7\x81"],

        ["\xE7\xB3\xB8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5E\x64"],
        ["\x5E\x64",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3\xB8"],

        ["\xE7\xB4\x99",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5E\x65"],
        ["\x5E\x65",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\x99"],

        ["\xE7\xB4\xAB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5E\x66"],
        ["\x5E\x66",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\xAB"],

        ["\xE8\x82\xA2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5E\x67"],
        ["\x5E\x67",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x82\xA2"],

        ["\xE8\x84\x82",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5E\x68"],
        ["\x5E\x68",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x84\x82"],

        ["\xE8\x87\xB3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5E\x69"],
        ["\x5E\x69",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\xB3"],

        ["\xE8\xA6\x96",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5E\x70"],
        ["\x5E\x70",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\x96"],

        ["\xE8\xA9\x9E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5E\x71"],
        ["\x5E\x71",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\x9E"],

        ["\xE8\xA9\xA9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5E\x72"],
        ["\x5E\x72",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\xA9"],

        ["\xE8\xA9\xA6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5E\x73"],
        ["\x5E\x73",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\xA6"],

        ["\xE8\xAA\x8C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5E\x74"],
        ["\x5E\x74",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\x8C"],

        ["\xE8\xAB\xAE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5E\x75"],
        ["\x5E\x75",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\xAE"],

        ["\xE8\xB3\x87",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5E\x76"],
        ["\x5E\x76",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\x87"],

        ["\xE8\xB3\x9C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5E\x77"],
        ["\x5E\x77",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\x9C"],

        ["\xE9\x9B\x8C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5E\x78"],
        ["\x5E\x78",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\x8C"],

        ["\xE9\xA3\xBC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5E\x80"],
        ["\x5E\x80",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA3\xBC"],

        ["\xE6\xAD\xAF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5E\x8B"],
        ["\x5E\x8B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\xAF"],

        ["\xE4\xBA\x8B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5E\x9B"],
        ["\x5E\x9B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\x8B"],

        ["\xE4\xBC\xBC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5E\x9C"],
        ["\x5E\x9C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBC\xBC"],

        ["\xE4\xBE\x8D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5E\xA0"],
        ["\x5E\xA0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE\x8D"],

        ["\xE5\x85\x90",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5E\xAB"],
        ["\x5E\xAB",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\x90"],

        ["\xE5\xAD\x97",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5E\xB0"],
        ["\x5E\xB0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\x97"],

        ["\xE5\xAF\xBA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5E\xC0"],
        ["\x5E\xC0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\xBA"],

        ["\xE6\x85\x88",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5E\x6A"],
        ["\x5E\x6A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\x88"],

        ["\xE6\x8C\x81",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5E\xD0"],
        ["\x5E\xD0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8C\x81"],

        ["\xE6\x99\x82",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5E\xA1"],
        ["\x5E\xA1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\x82"],

        ["\xE6\xAC\xA1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4C\x4F"],
        ["\x4C\x4F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAC\xA1"],

        ["\xE6\xBB\x8B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4C\x7F"],
        ["\x4C\x7F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBB\x8B"],

        ["\xE6\xB2\xBB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4C\x7B"],
        ["\x4C\x7B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\xBB"],

        ["\xE7\x88\xBE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4C\xE0"],
        ["\x4C\xE0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x88\xBE"],

        ["\xE7\x92\xBD",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4C\x6C"],
        ["\x4C\x6C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x92\xBD"],

        ["\xE7\x97\x94",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4C\x50"],
        ["\x4C\x50",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\x94"],

        ["\xE7\xA3\x81",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4C\x7D"],
        ["\x4C\x7D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA3\x81"],

        ["\xE7\xA4\xBA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4C\x4D"],
        ["\x4C\x4D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA4\xBA"],

        ["\xE8\x80\x8C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4C\x5D"],
        ["\x4C\x5D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\x8C"],

        ["\xE8\x80\xB3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4C\x5C"],
        ["\x4C\x5C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\xB3"],

        ["\xE8\x87\xAA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4C\x4E"],
        ["\x4C\x4E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\xAA"],

        ["\xE8\x92\x94",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4C\x6B"],
        ["\x4C\x6B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x92\x94"],

        ["\xE8\xBE\x9E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4C\x60"],
        ["\x4C\x60",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBE\x9E"],

        ["\xE6\xB1\x90",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4C\x4B"],
        ["\x4C\x4B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1\x90"],

        ["\xE9\xB9\xBF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4C\x61"],
        ["\x4C\x61",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB9\xBF"],

        ["\xE5\xBC\x8F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4C\xF0"],
        ["\x4C\xF0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\x8F"],

        ["\xE8\xAD\x98",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4C\xF1"],
        ["\x4C\xF1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD\x98"],

        ["\xE9\xB4\xAB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4C\xF2"],
        ["\x4C\xF2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB4\xAB"],

        ["\xE7\xAB\xBA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4C\xF3"],
        ["\x4C\xF3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\xBA"],

        ["\xE8\xBB\xB8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4C\xF4"],
        ["\x4C\xF4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBB\xB8"],

        ["\xE5\xAE\x8D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4C\xF5"],
        ["\x4C\xF5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\x8D"],

        ["\xE9\x9B\xAB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4C\xF6"],
        ["\x4C\xF6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\xAB"],

        ["\xE4\xB8\x83",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4C\xF7"],
        ["\x4C\xF7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\x83"],

        ["\xE5\x8F\xB1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4C\xF8"],
        ["\x4C\xF8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\xB1"],

        ["\xE5\x9F\xB7",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4C\xF9"],
        ["\x4C\xF9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9F\xB7"],

        ["\xE5\xA4\xB1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4C\x7A"],
        ["\x4C\x7A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\xB1"],

        ["\xE5\xAB\x89",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4C\x5E"],
        ["\x4C\x5E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAB\x89"],

        ["\xE5\xAE\xA4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4C\x4C"],
        ["\x4C\x4C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\xA4"],

        ["\xE6\x82\x89",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4C\x7E"],
        ["\x4C\x7E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\x89"],

        ["\xE6\xB9\xBF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4C\x6E"],
        ["\x4C\x6E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB9\xBF"],

        ["\xE6\xBC\x86",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4C\x6F"],
        ["\x4C\x6F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBC\x86"],

        ["\xE7\x96\xBE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4C\x7C"],
        ["\x4C\x7C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x96\xBE"],

        ["\xE8\xB3\xAA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4C\xC1"],
        ["\x4C\xC1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\xAA"],

        ["\xE5\xAE\x9F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4C\xC2"],
        ["\x4C\xC2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\x9F"],

        ["\xE8\x94\x80",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4C\xC3"],
        ["\x4C\xC3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x94\x80"],

        ["\xE7\xAF\xA0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4C\xC4"],
        ["\x4C\xC4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAF\xA0"],

        ["\xE5\x81\xB2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4C\xC5"],
        ["\x4C\xC5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x81\xB2"],

        ["\xE6\x9F\xB4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4C\xC6"],
        ["\x4C\xC6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\xB4"],

        ["\xE8\x8A\x9D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4C\xC7"],
        ["\x4C\xC7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8A\x9D"],

        ["\xE5\xB1\xA1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4C\xC8"],
        ["\x4C\xC8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\xA1"],

        ["\xE8\x95\x8A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x68\x7F"],
        ["\x68\x7F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x95\x8A"],

        ["\xE7\xB8\x9E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4C\xD1"],
        ["\x4C\xD1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\x9E"],

        ["\xE8\x88\x8E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4C\xD2"],
        ["\x4C\xD2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\x8E"],

        ["\xE5\x86\x99",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4C\xD3"],
        ["\x4C\xD3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\x99"],

        ["\xE5\xB0\x84",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4C\xD4"],
        ["\x4C\xD4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\x84"],

        ["\xE6\x8D\xA8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4C\xD5"],
        ["\x4C\xD5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8D\xA8"],

        ["\xE8\xB5\xA6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4C\xD6"],
        ["\x4C\xD6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB5\xA6"],

        ["\xE6\x96\x9C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4C\xD7"],
        ["\x4C\xD7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\x9C"],

        ["\xE7\x85\xAE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4C\xD8"],
        ["\x4C\xD8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x85\xAE"],

        ["\xE7\xA4\xBE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4C\xD9"],
        ["\x4C\xD9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA4\xBE"],

        ["\xE7\xB4\x97",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4C\xE2"],
        ["\x4C\xE2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\x97"],

        ["\xE8\x80\x85",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4C\xE3"],
        ["\x4C\xE3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\x85"],

        ["\xE8\xAC\x9D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4C\xE4"],
        ["\x4C\xE4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC\x9D"],

        ["\xE8\xBB\x8A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4C\xE5"],
        ["\x4C\xE5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBB\x8A"],

        ["\xE9\x81\xAE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4C\xE6"],
        ["\x4C\xE6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\xAE"],

        ["\xE8\x9B\x87",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4C\xE7"],
        ["\x4C\xE7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9B\x87"],

        ["\xE9\x82\xAA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4C\xE8"],
        ["\x4C\xE8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x82\xAA"],

        ["\xE5\x80\x9F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4C\xE9"],
        ["\x4C\xE9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\x9F"],

        ["\xE5\x8B\xBA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4C\x4A"],
        ["\x4C\x4A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\xBA"],

        ["\xE5\xB0\xBA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4C\x5B"],
        ["\x4C\x5B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\xBA"],

        ["\xE6\x9D\x93",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4C\x5A"],
        ["\x4C\x5A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\x93"],

        ["\xE7\x81\xBC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4C\x5F"],
        ["\x4C\x5F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x81\xBC"],

        ["\xE7\x88\xB5",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4C\x6D"],
        ["\x4C\x6D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x88\xB5"],

        ["\xE9\x85\x8C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4C\x79"],
        ["\x4C\x79",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x85\x8C"],

        ["\xE9\x87\x88",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4C\x57"],
        ["\x4C\x57",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\x88"],

        ["\xE9\x8C\xAB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4C\x59"],
        ["\x4C\x59",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8C\xAB"],

        ["\xE8\x8B\xA5",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4C\x62"],
        ["\x4C\x62",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8B\xA5"],

        ["\xE5\xAF\x82",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4C\x63"],
        ["\x4C\x63",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\x82"],

        ["\xE5\xBC\xB1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4C\x64"],
        ["\x4C\x64",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\xB1"],

        ["\xE6\x83\xB9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4C\x65"],
        ["\x4C\x65",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\xB9"],

        ["\xE4\xB8\xBB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4C\x66"],
        ["\x4C\x66",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\xBB"],

        ["\xE5\x8F\x96",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4C\x67"],
        ["\x4C\x67",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\x96"],

        ["\xE5\xAE\x88",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4C\x68"],
        ["\x4C\x68",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\x88"],

        ["\xE6\x89\x8B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4C\x69"],
        ["\x4C\x69",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\x8B"],

        ["\xE6\x9C\xB1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4C\x70"],
        ["\x4C\x70",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\xB1"],

        ["\xE6\xAE\x8A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4C\x71"],
        ["\x4C\x71",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\x8A"],

        ["\xE7\x8B\xA9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4C\x72"],
        ["\x4C\x72",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8B\xA9"],

        ["\xE7\x8F\xA0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4C\x73"],
        ["\x4C\x73",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8F\xA0"],

        ["\xE7\xA8\xAE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4C\x74"],
        ["\x4C\x74",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8\xAE"],

        ["\xE8\x85\xAB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4C\x75"],
        ["\x4C\x75",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x85\xAB"],

        ["\xE8\xB6\xA3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4C\x76"],
        ["\x4C\x76",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB6\xA3"],

        ["\xE9\x85\x92",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4C\x77"],
        ["\x4C\x77",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x85\x92"],

        ["\xE9\xA6\x96",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4C\x78"],
        ["\x4C\x78",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA6\x96"],

        ["\xE5\x84\x92",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4C\x80"],
        ["\x4C\x80",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x84\x92"],

        ["\xE5\x8F\x97",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4C\x8B"],
        ["\x4C\x8B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\x97"],

        ["\xE5\x91\xAA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4C\x9B"],
        ["\x4C\x9B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x91\xAA"],

        ["\xE5\xAF\xBF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4C\x9C"],
        ["\x4C\x9C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\xBF"],

        ["\xE6\x8E\x88",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4C\xA0"],
        ["\x4C\xA0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\x88"],

        ["\xE6\xA8\xB9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4C\xAB"],
        ["\x4C\xAB",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\xB9"],

        ["\xE7\xB6\xAC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4C\xB0"],
        ["\x4C\xB0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\xAC"],

        ["\xE9\x9C\x80",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4C\xC0"],
        ["\x4C\xC0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9C\x80"],

        ["\xE5\x9B\x9A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4C\x6A"],
        ["\x4C\x6A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B\x9A"],

        ["\xE5\x8F\x8E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4C\xD0"],
        ["\x4C\xD0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\x8E"],

        ["\xE5\x91\xA8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4C\xA1"],
        ["\x4C\xA1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x91\xA8"],

        ["\xE5\xAE\x97",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7E\x4F"],
        ["\x7E\x4F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\x97"],

        ["\xE5\xB0\xB1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7E\x7F"],
        ["\x7E\x7F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\xB1"],

        ["\xE5\xB7\x9E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7E\x7B"],
        ["\x7E\x7B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\x9E"],

        ["\xE4\xBF\xAE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7E\xE0"],
        ["\x7E\xE0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\xAE"],

        ["\xE6\x84\x81",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7E\x6C"],
        ["\x7E\x6C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\x81"],

        ["\xE6\x8B\xBE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7E\x50"],
        ["\x7E\x50",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\xBE"],

        ["\xE6\xB4\xB2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7E\x7D"],
        ["\x7E\x7D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4\xB2"],

        ["\xE7\xA7\x80",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7E\x4D"],
        ["\x7E\x4D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA7\x80"],

        ["\xE7\xA7\x8B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7E\x5D"],
        ["\x7E\x5D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA7\x8B"],

        ["\xE7\xB5\x82",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7E\x5C"],
        ["\x7E\x5C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\x82"],

        ["\xE7\xB9\x8D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7E\x4E"],
        ["\x7E\x4E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\x8D"],

        ["\xE7\xBF\x92",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7E\x6B"],
        ["\x7E\x6B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBF\x92"],

        ["\xE8\x87\xAD",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7E\x60"],
        ["\x7E\x60",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\xAD"],

        ["\xE8\x88\x9F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7E\x4B"],
        ["\x7E\x4B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\x9F"],

        ["\xE8\x92\x90",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7E\x61"],
        ["\x7E\x61",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x92\x90"],

        ["\xE8\xA1\x86",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7E\xF0"],
        ["\x7E\xF0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\x86"],

        ["\xE8\xA5\xB2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7E\xF1"],
        ["\x7E\xF1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA5\xB2"],

        ["\xE8\xAE\x90",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7E\xF2"],
        ["\x7E\xF2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAE\x90"],

        ["\xE8\xB9\xB4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7E\xF3"],
        ["\x7E\xF3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB9\xB4"],

        ["\xE8\xBC\xAF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7E\xF4"],
        ["\x7E\xF4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC\xAF"],

        ["\xE9\x80\xB1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7E\xF5"],
        ["\x7E\xF5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\xB1"],

        ["\xE9\x85\x8B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7E\xF6"],
        ["\x7E\xF6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x85\x8B"],

        ["\xE9\x85\xAC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7E\xF7"],
        ["\x7E\xF7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x85\xAC"],

        ["\xE9\x9B\x86",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7E\xF8"],
        ["\x7E\xF8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\x86"],

        ["\xE9\x86\x9C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7E\xF9"],
        ["\x7E\xF9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x86\x9C"],

        ["\xE4\xBB\x80",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7E\x7A"],
        ["\x7E\x7A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\x80"],

        ["\xE4\xBD\x8F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7E\x5E"],
        ["\x7E\x5E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\x8F"],

        ["\xE5\x85\x85",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7E\x4C"],
        ["\x7E\x4C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\x85"],

        ["\xE5\x8D\x81",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7E\x7E"],
        ["\x7E\x7E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\x81"],

        ["\xE5\xBE\x93",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7E\x6E"],
        ["\x7E\x6E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\x93"],

        ["\xE6\x88\x8E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7E\x6F"],
        ["\x7E\x6F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\x8E"],

        ["\xE6\x9F\x94",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7E\x7C"],
        ["\x7E\x7C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\x94"],

        ["\xE6\xB1\x81",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7E\xC1"],
        ["\x7E\xC1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1\x81"],

        ["\xE6\xB8\x8B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7E\xC2"],
        ["\x7E\xC2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\x8B"],

        ["\xE7\x8D\xA3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7E\xC3"],
        ["\x7E\xC3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8D\xA3"],

        ["\xE7\xB8\xA6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7E\xC4"],
        ["\x7E\xC4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\xA6"],

        ["\xE9\x87\x8D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7E\xC5"],
        ["\x7E\xC5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\x8D"],

        ["\xE9\x8A\x83",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7E\xC6"],
        ["\x7E\xC6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8A\x83"],

        ["\xE5\x8F\x94",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7E\xC7"],
        ["\x7E\xC7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\x94"],

        ["\xE5\xA4\x99",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7E\xC8"],
        ["\x7E\xC8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\x99"],

        ["\xE5\xAE\xBF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7E\xC9"],
        ["\x7E\xC9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\xBF"],

        ["\xE6\xB7\x91",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7E\xD1"],
        ["\x7E\xD1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\x91"],

        ["\xE7\xA5\x9D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7E\xD2"],
        ["\x7E\xD2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5\x9D"],

        ["\xE7\xB8\xAE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7E\xD3"],
        ["\x7E\xD3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\xAE"],

        ["\xE7\xB2\x9B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7E\xD4"],
        ["\x7E\xD4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\x9B"],

        ["\xE5\xA1\xBE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7E\xD5"],
        ["\x7E\xD5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA1\xBE"],

        ["\xE7\x86\x9F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7E\xD6"],
        ["\x7E\xD6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x86\x9F"],

        ["\xE5\x87\xBA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7E\xD7"],
        ["\x7E\xD7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\xBA"],

        ["\xE8\xA1\x93",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7E\xD8"],
        ["\x7E\xD8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\x93"],

        ["\xE8\xBF\xB0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7E\xD9"],
        ["\x7E\xD9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF\xB0"],

        ["\xE4\xBF\x8A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7E\xE2"],
        ["\x7E\xE2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\x8A"],

        ["\xE5\xB3\xBB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7E\xE3"],
        ["\x7E\xE3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB3\xBB"],

        ["\xE6\x98\xA5",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7E\xE4"],
        ["\x7E\xE4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\xA5"],

        ["\xE7\x9E\xAC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7E\xE5"],
        ["\x7E\xE5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9E\xAC"],

        ["\xE7\xAB\xA3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7E\xE6"],
        ["\x7E\xE6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\xA3"],

        ["\xE8\x88\x9C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7E\xE7"],
        ["\x7E\xE7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\x9C"],

        ["\xE9\xA7\xBF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7E\xE8"],
        ["\x7E\xE8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA7\xBF"],

        ["\xE5\x87\x86",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7E\xE9"],
        ["\x7E\xE9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\x86"],

        ["\xE5\xBE\xAA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7E\x4A"],
        ["\x7E\x4A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\xAA"],

        ["\xE6\x97\xAC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7E\x5B"],
        ["\x7E\x5B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\xAC"],

        ["\xE6\xA5\xAF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7E\x5A"],
        ["\x7E\x5A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\xAF"],

        ["\xE6\xAE\x89",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7E\x5F"],
        ["\x7E\x5F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\x89"],

        ["\xE6\xB7\xB3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7E\x6D"],
        ["\x7E\x6D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\xB3"],

        ["\xE6\xBA\x96",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7E\x79"],
        ["\x7E\x79",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBA\x96"],

        ["\xE6\xBD\xA4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7E\x57"],
        ["\x7E\x57",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBD\xA4"],

        ["\xE7\x9B\xBE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7E\x59"],
        ["\x7E\x59",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\xBE"],

        ["\xE7\xB4\x94",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7E\x62"],
        ["\x7E\x62",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\x94"],

        ["\xE5\xB7\xA1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7E\x63"],
        ["\x7E\x63",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\xA1"],

        ["\xE9\x81\xB5",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7E\x64"],
        ["\x7E\x64",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\xB5"],

        ["\xE9\x86\x87",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7E\x65"],
        ["\x7E\x65",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x86\x87"],

        ["\xE9\xA0\x86",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7E\x66"],
        ["\x7E\x66",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0\x86"],

        ["\xE5\x87\xA6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7E\x67"],
        ["\x7E\x67",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\xA6"],

        ["\xE5\x88\x9D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7E\x68"],
        ["\x7E\x68",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\x9D"],

        ["\xE6\x89\x80",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7E\x69"],
        ["\x7E\x69",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\x80"],

        ["\xE6\x9A\x91",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7E\x70"],
        ["\x7E\x70",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A\x91"],

        ["\xE6\x9B\x99",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7E\x71"],
        ["\x7E\x71",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\x99"],

        ["\xE6\xB8\x9A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7E\x72"],
        ["\x7E\x72",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\x9A"],

        ["\xE5\xBA\xB6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7E\x73"],
        ["\x7E\x73",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBA\xB6"],

        ["\xE7\xB7\x92",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7E\x74"],
        ["\x7E\x74",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7\x92"],

        ["\xE7\xBD\xB2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7E\x75"],
        ["\x7E\x75",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\xB2"],

        ["\xE6\x9B\xB8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7E\x76"],
        ["\x7E\x76",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\xB8"],

        ["\xE8\x96\xAF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7E\x77"],
        ["\x7E\x77",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\xAF"],

        ["\xE8\x97\xB7",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7E\x78"],
        ["\x7E\x78",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x97\xB7"],

        ["\xE8\xAB\xB8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7E\x80"],
        ["\x7E\x80",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\xB8"],

        ["\xE5\x8A\xA9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7E\x8B"],
        ["\x7E\x8B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\xA9"],

        ["\xE5\x8F\x99",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7E\x9B"],
        ["\x7E\x9B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\x99"],

        ["\xE5\xA5\xB3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7E\x9C"],
        ["\x7E\x9C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\xB3"],

        ["\xE5\xBA\x8F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7E\xA0"],
        ["\x7E\xA0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBA\x8F"],

        ["\xE5\xBE\x90",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7E\xAB"],
        ["\x7E\xAB",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\x90"],

        ["\xE6\x81\x95",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7E\xB0"],
        ["\x7E\xB0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\x95"],

        ["\xE9\x8B\xA4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7E\xC0"],
        ["\x7E\xC0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8B\xA4"],

        ["\xE9\x99\xA4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7E\x6A"],
        ["\x7E\x6A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x99\xA4"],

        ["\xE5\x82\xB7",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7E\xD0"],
        ["\x7E\xD0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x82\xB7"],

        ["\xE5\x84\x9F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7E\xA1"],
        ["\x7E\xA1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x84\x9F"],

        ["\xE5\x8B\x9D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6E\x4F"],
        ["\x6E\x4F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\x9D"],

        ["\xE5\x8C\xA0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6E\x7F"],
        ["\x6E\x7F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\xA0"],

        ["\xE5\x8D\x87",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6E\x7B"],
        ["\x6E\x7B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\x87"],

        ["\xE5\x8F\xAC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6E\xE0"],
        ["\x6E\xE0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\xAC"],

        ["\xE5\x93\xA8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6E\x6C"],
        ["\x6E\x6C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x93\xA8"],

        ["\xE5\x95\x86",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6E\x50"],
        ["\x6E\x50",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x95\x86"],

        ["\xE5\x94\xB1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6E\x7D"],
        ["\x6E\x7D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x94\xB1"],

        ["\xE5\x98\x97",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6E\x4D"],
        ["\x6E\x4D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x98\x97"],

        ["\xE5\xA5\xA8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6E\x5D"],
        ["\x6E\x5D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\xA8"],

        ["\xE5\xA6\xBE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6E\x5C"],
        ["\x6E\x5C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA6\xBE"],

        ["\xE5\xA8\xBC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6E\x4E"],
        ["\x6E\x4E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA8\xBC"],

        ["\xE5\xAE\xB5",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6E\x6B"],
        ["\x6E\x6B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\xB5"],

        ["\xE5\xB0\x86",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6E\x60"],
        ["\x6E\x60",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\x86"],

        ["\xE5\xB0\x8F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6E\x4B"],
        ["\x6E\x4B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\x8F"],

        ["\xE5\xB0\x91",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6E\x61"],
        ["\x6E\x61",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\x91"],

        ["\xE5\xB0\x9A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6E\xF0"],
        ["\x6E\xF0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\x9A"],

        ["\xE5\xBA\x84",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6E\xF1"],
        ["\x6E\xF1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBA\x84"],

        ["\xE5\xBA\x8A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6E\xF2"],
        ["\x6E\xF2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBA\x8A"],

        ["\xE5\xBB\xA0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6E\xF3"],
        ["\x6E\xF3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\xA0"],

        ["\xE5\xBD\xB0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6E\xF4"],
        ["\x6E\xF4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\xB0"],

        ["\xE6\x89\xBF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6E\xF5"],
        ["\x6E\xF5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\xBF"],

        ["\xE6\x8A\x84",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6E\xF6"],
        ["\x6E\xF6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A\x84"],

        ["\xE6\x8B\x9B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6E\xF7"],
        ["\x6E\xF7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\x9B"],

        ["\xE6\x8E\x8C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6E\xF8"],
        ["\x6E\xF8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\x8C"],

        ["\xE6\x8D\xB7",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6E\xF9"],
        ["\x6E\xF9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8D\xB7"],

        ["\xE6\x98\x87",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6E\x7A"],
        ["\x6E\x7A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\x87"],

        ["\xE6\x98\x8C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6E\x5E"],
        ["\x6E\x5E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\x8C"],

        ["\xE6\x98\xAD",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6E\x4C"],
        ["\x6E\x4C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\xAD"],

        ["\xE6\x99\xB6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6E\x7E"],
        ["\x6E\x7E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\xB6"],

        ["\xE6\x9D\xBE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6E\x6E"],
        ["\x6E\x6E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\xBE"],

        ["\xE6\xA2\xA2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6E\x6F"],
        ["\x6E\x6F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\xA2"],

        ["\xE6\xA8\x9F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6E\x7C"],
        ["\x6E\x7C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\x9F"],

        ["\xE6\xA8\xB5",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6E\xC1"],
        ["\x6E\xC1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\xB5"],

        ["\xE6\xB2\xBC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6E\xC2"],
        ["\x6E\xC2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\xBC"],

        ["\xE6\xB6\x88",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6E\xC3"],
        ["\x6E\xC3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB6\x88"],

        ["\xE6\xB8\x89",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6E\xC4"],
        ["\x6E\xC4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\x89"],

        ["\xE6\xB9\x98",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6E\xC5"],
        ["\x6E\xC5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB9\x98"],

        ["\xE7\x84\xBC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6E\xC6"],
        ["\x6E\xC6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x84\xBC"],

        ["\xE7\x84\xA6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6E\xC7"],
        ["\x6E\xC7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x84\xA6"],

        ["\xE7\x85\xA7",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6E\xC8"],
        ["\x6E\xC8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x85\xA7"],

        ["\xE7\x97\x87",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6E\xC9"],
        ["\x6E\xC9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\x87"],

        ["\xE7\x9C\x81",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6E\xD1"],
        ["\x6E\xD1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9C\x81"],

        ["\xE7\xA1\x9D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6E\xD2"],
        ["\x6E\xD2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA1\x9D"],

        ["\xE7\xA4\x81",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6E\xD3"],
        ["\x6E\xD3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA4\x81"],

        ["\xE7\xA5\xA5",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6E\xD4"],
        ["\x6E\xD4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5\xA5"],

        ["\xE7\xA7\xB0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6E\xD5"],
        ["\x6E\xD5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA7\xB0"],

        ["\xE7\xAB\xA0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6E\xD6"],
        ["\x6E\xD6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\xA0"],

        ["\xE7\xAC\x91",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6E\xD7"],
        ["\x6E\xD7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC\x91"],

        ["\xE7\xB2\xA7",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6E\xD8"],
        ["\x6E\xD8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\xA7"],

        ["\xE7\xB4\xB9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6E\xD9"],
        ["\x6E\xD9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\xB9"],

        ["\xE8\x82\x96",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6E\xE2"],
        ["\x6E\xE2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x82\x96"],

        ["\xE8\x8F\x96",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6E\xE3"],
        ["\x6E\xE3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F\x96"],

        ["\xE8\x92\x8B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6E\xE4"],
        ["\x6E\xE4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x92\x8B"],

        ["\xE8\x95\x89",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6E\xE5"],
        ["\x6E\xE5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x95\x89"],

        ["\xE8\xA1\x9D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6E\xE6"],
        ["\x6E\xE6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\x9D"],

        ["\xE8\xA3\xB3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6E\xE7"],
        ["\x6E\xE7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\xB3"],

        ["\xE8\xA8\x9F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6E\xE8"],
        ["\x6E\xE8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\x9F"],

        ["\xE8\xA8\xBC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6E\xE9"],
        ["\x6E\xE9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\xBC"],

        ["\xE8\xA9\x94",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6E\x4A"],
        ["\x6E\x4A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\x94"],

        ["\xE8\xA9\xB3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6E\x5B"],
        ["\x6E\x5B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\xB3"],

        ["\xE8\xB1\xA1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6E\x5A"],
        ["\x6E\x5A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB1\xA1"],

        ["\xE8\xB3\x9E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6E\x5F"],
        ["\x6E\x5F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\x9E"],

        ["\xE9\x86\xA4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6E\x6D"],
        ["\x6E\x6D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x86\xA4"],

        ["\xE9\x89\xA6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6E\x79"],
        ["\x6E\x79",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x89\xA6"],

        ["\xE9\x8D\xBE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6E\x57"],
        ["\x6E\x57",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8D\xBE"],

        ["\xE9\x90\x98",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6E\x59"],
        ["\x6E\x59",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x90\x98"],

        ["\xE9\x9A\x9C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6E\x62"],
        ["\x6E\x62",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\x9C"],

        ["\xE9\x9E\x98",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6E\x63"],
        ["\x6E\x63",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9E\x98"],

        ["\xE4\xB8\x8A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6E\x64"],
        ["\x6E\x64",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\x8A"],

        ["\xE4\xB8\x88",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6E\x65"],
        ["\x6E\x65",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\x88"],

        ["\xE4\xB8\x9E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6E\x66"],
        ["\x6E\x66",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\x9E"],

        ["\xE4\xB9\x97",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6E\x67"],
        ["\x6E\x67",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xB9\x97"],

        ["\xE5\x86\x97",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6E\x68"],
        ["\x6E\x68",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\x97"],

        ["\xE5\x89\xB0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6E\x69"],
        ["\x6E\x69",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\xB0"],

        ["\xE5\x9F\x8E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6E\x70"],
        ["\x6E\x70",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9F\x8E"],

        ["\xE5\xA0\xB4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6E\x71"],
        ["\x6E\x71",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA0\xB4"],

        ["\xE5\xA3\x8C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6E\x72"],
        ["\x6E\x72",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\x8C"],

        ["\xE5\xAC\xA2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6E\x73"],
        ["\x6E\x73",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAC\xA2"],

        ["\xE5\xB8\xB8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6E\x74"],
        ["\x6E\x74",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8\xB8"],

        ["\xE6\x83\x85",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6E\x75"],
        ["\x6E\x75",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\x85"],

        ["\xE6\x93\xBE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6E\x76"],
        ["\x6E\x76",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\xBE"],

        ["\xE6\x9D\xA1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6E\x77"],
        ["\x6E\x77",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\xA1"],

        ["\xE6\x9D\x96",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6E\x78"],
        ["\x6E\x78",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\x96"],

        ["\xE6\xB5\x84",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6E\x80"],
        ["\x6E\x80",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB5\x84"],

        ["\xE7\x8A\xB6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6E\x8B"],
        ["\x6E\x8B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8A\xB6"],

        ["\xE7\x95\xB3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6E\x9B"],
        ["\x6E\x9B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\xB3"],

        ["\xE7\xA9\xA3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6E\x9C"],
        ["\x6E\x9C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\xA3"],

        ["\xE8\x92\xB8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6E\xA0"],
        ["\x6E\xA0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x92\xB8"],

        ["\xE8\xAD\xB2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6E\xAB"],
        ["\x6E\xAB",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD\xB2"],

        ["\xE9\x86\xB8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6E\xB0"],
        ["\x6E\xB0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x86\xB8"],

        ["\xE9\x8C\xA0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6E\xC0"],
        ["\x6E\xC0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8C\xA0"],

        ["\xE5\x98\xB1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6E\x6A"],
        ["\x6E\x6A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x98\xB1"],

        ["\xE5\x9F\xB4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6E\xD0"],
        ["\x6E\xD0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9F\xB4"],

        ["\xE9\xA3\xBE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6E\xA1"],
        ["\x6E\xA1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA3\xBE"],

        ["\xE6\x8B\xAD",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6F\x4F"],
        ["\x6F\x4F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\xAD"],

        ["\xE6\xA4\x8D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6F\x7F"],
        ["\x6F\x7F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\x8D"],

        ["\xE6\xAE\x96",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6F\x7B"],
        ["\x6F\x7B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\x96"],

        ["\xE7\x87\xAD",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6F\xE0"],
        ["\x6F\xE0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x87\xAD"],

        ["\xE7\xB9\x94",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6F\x6C"],
        ["\x6F\x6C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\x94"],

        ["\xE8\x81\xB7",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6F\x50"],
        ["\x6F\x50",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x81\xB7"],

        ["\xE8\x89\xB2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6F\x7D"],
        ["\x6F\x7D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x89\xB2"],

        ["\xE8\xA7\xA6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6F\x4D"],
        ["\x6F\x4D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA7\xA6"],

        ["\xE9\xA3\x9F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6F\x5D"],
        ["\x6F\x5D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA3\x9F"],

        ["\xE8\x9D\x95",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6F\x5C"],
        ["\x6F\x5C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9D\x95"],

        ["\xE8\xBE\xB1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6F\x4E"],
        ["\x6F\x4E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBE\xB1"],

        ["\xE5\xB0\xBB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6F\x6B"],
        ["\x6F\x6B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\xBB"],

        ["\xE4\xBC\xB8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6F\x60"],
        ["\x6F\x60",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBC\xB8"],

        ["\xE4\xBF\xA1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6F\x4B"],
        ["\x6F\x4B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\xA1"],

        ["\xE4\xBE\xB5",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6F\x61"],
        ["\x6F\x61",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE\xB5"],

        ["\xE5\x94\x87",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6F\xF0"],
        ["\x6F\xF0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x94\x87"],

        ["\xE5\xA8\xA0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6F\xF1"],
        ["\x6F\xF1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA8\xA0"],

        ["\xE5\xAF\x9D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6F\xF2"],
        ["\x6F\xF2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\x9D"],

        ["\xE5\xAF\xA9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6F\xF3"],
        ["\x6F\xF3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\xA9"],

        ["\xE5\xBF\x83",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6F\xF4"],
        ["\x6F\xF4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF\x83"],

        ["\xE6\x85\x8E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6F\xF5"],
        ["\x6F\xF5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\x8E"],

        ["\xE6\x8C\xAF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6F\xF6"],
        ["\x6F\xF6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8C\xAF"],

        ["\xE6\x96\xB0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6F\xF7"],
        ["\x6F\xF7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\xB0"],

        ["\xE6\x99\x8B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6F\xF8"],
        ["\x6F\xF8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\x8B"],

        ["\xE6\xA3\xAE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6F\xF9"],
        ["\x6F\xF9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\xAE"],

        ["\xE6\xA6\x9B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6F\x7A"],
        ["\x6F\x7A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA6\x9B"],

        ["\xE6\xB5\xB8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6F\x5E"],
        ["\x6F\x5E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB5\xB8"],

        ["\xE6\xB7\xB1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6F\x4C"],
        ["\x6F\x4C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\xB1"],

        ["\xE7\x94\xB3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6F\x7E"],
        ["\x6F\x7E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\xB3"],

        ["\xE7\x96\xB9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6F\x6E"],
        ["\x6F\x6E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x96\xB9"],

        ["\xE7\x9C\x9F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6F\x6F"],
        ["\x6F\x6F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9C\x9F"],

        ["\xE7\xA5\x9E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6F\x7C"],
        ["\x6F\x7C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5\x9E"],

        ["\xE7\xA7\xA6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6F\xC1"],
        ["\x6F\xC1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA7\xA6"],

        ["\xE7\xB4\xB3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6F\xC2"],
        ["\x6F\xC2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\xB3"],

        ["\xE8\x87\xA3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6F\xC3"],
        ["\x6F\xC3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\xA3"],

        ["\xE8\x8A\xAF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6F\xC4"],
        ["\x6F\xC4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8A\xAF"],

        ["\xE8\x96\xAA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6F\xC5"],
        ["\x6F\xC5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\xAA"],

        ["\xE8\xA6\xAA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6F\xC6"],
        ["\x6F\xC6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\xAA"],

        ["\xE8\xA8\xBA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6F\xC7"],
        ["\x6F\xC7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\xBA"],

        ["\xE8\xBA\xAB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6F\xC8"],
        ["\x6F\xC8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBA\xAB"],

        ["\xE8\xBE\x9B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6F\xC9"],
        ["\x6F\xC9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBE\x9B"],

        ["\xE9\x80\xB2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6F\xD1"],
        ["\x6F\xD1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\xB2"],

        ["\xE9\x87\x9D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6F\xD2"],
        ["\x6F\xD2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\x9D"],

        ["\xE9\x9C\x87",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6F\xD3"],
        ["\x6F\xD3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9C\x87"],

        ["\xE4\xBA\xBA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6F\xD4"],
        ["\x6F\xD4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\xBA"],

        ["\xE4\xBB\x81",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6F\xD5"],
        ["\x6F\xD5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\x81"],

        ["\xE5\x88\x83",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6F\xD6"],
        ["\x6F\xD6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\x83"],

        ["\xE5\xA1\xB5",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6F\xD7"],
        ["\x6F\xD7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA1\xB5"],

        ["\xE5\xA3\xAC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6F\xD8"],
        ["\x6F\xD8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\xAC"],

        ["\xE5\xB0\x8B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6F\xD9"],
        ["\x6F\xD9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\x8B"],

        ["\xE7\x94\x9A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6F\xE2"],
        ["\x6F\xE2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\x9A"],

        ["\xE5\xB0\xBD",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6F\xE3"],
        ["\x6F\xE3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\xBD"],

        ["\xE8\x85\x8E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6F\xE4"],
        ["\x6F\xE4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x85\x8E"],

        ["\xE8\xA8\x8A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6F\xE5"],
        ["\x6F\xE5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\x8A"],

        ["\xE8\xBF\x85",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6F\xE6"],
        ["\x6F\xE6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF\x85"],

        ["\xE9\x99\xA3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6F\xE7"],
        ["\x6F\xE7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x99\xA3"],

        ["\xE9\x9D\xAD",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x75\xE6"],
        ["\x75\xE6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9D\xAD"],

        ["\xE7\xAC\xA5",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6F\xE9"],
        ["\x6F\xE9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC\xA5"],

        ["\xE8\xAB\x8F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6F\x4A"],
        ["\x6F\x4A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\x8F"],

        ["\xE9\xA0\x88",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6F\x5B"],
        ["\x6F\x5B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0\x88"],

        ["\xE9\x85\xA2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6F\x5A"],
        ["\x6F\x5A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x85\xA2"],

        ["\xE5\x9B\xB3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6F\x5F"],
        ["\x6F\x5F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B\xB3"],

        ["\xE5\x8E\xA8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6F\x6D"],
        ["\x6F\x6D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8E\xA8"],

        ["\xE9\x80\x97",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6F\x79"],
        ["\x6F\x79",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\x97"],

        ["\xE5\x90\xB9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6F\x57"],
        ["\x6F\x57",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\xB9"],

        ["\xE5\x9E\x82",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6F\x59"],
        ["\x6F\x59",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9E\x82"],

        ["\xE5\xB8\xA5",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6F\x62"],
        ["\x6F\x62",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8\xA5"],

        ["\xE6\x8E\xA8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6F\x63"],
        ["\x6F\x63",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\xA8"],

        ["\xE6\xB0\xB4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6F\x64"],
        ["\x6F\x64",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB0\xB4"],

        ["\xE7\x82\x8A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6F\x65"],
        ["\x6F\x65",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x82\x8A"],

        ["\xE7\x9D\xA1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6F\x66"],
        ["\x6F\x66",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9D\xA1"],

        ["\xE7\xB2\x8B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6F\x67"],
        ["\x6F\x67",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\x8B"],

        ["\xE7\xBF\xA0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6F\x68"],
        ["\x6F\x68",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBF\xA0"],

        ["\xE8\xA1\xB0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6F\x69"],
        ["\x6F\x69",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\xB0"],

        ["\xE9\x81\x82",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6F\x70"],
        ["\x6F\x70",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\x82"],

        ["\xE9\x85\x94",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6F\x71"],
        ["\x6F\x71",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x85\x94"],

        ["\xE9\x8C\x90",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6F\x72"],
        ["\x6F\x72",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8C\x90"],

        ["\xE9\x8C\x98",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6F\x73"],
        ["\x6F\x73",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8C\x98"],

        ["\xE9\x9A\x8F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6F\x74"],
        ["\x6F\x74",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\x8F"],

        ["\xE7\x91\x9E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6F\x75"],
        ["\x6F\x75",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x91\x9E"],

        ["\xE9\xAB\x84",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6F\x76"],
        ["\x6F\x76",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xAB\x84"],

        ["\xE5\xB4\x87",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6F\x77"],
        ["\x6F\x77",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB4\x87"],

        ["\xE5\xB5\xA9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6F\x78"],
        ["\x6F\x78",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB5\xA9"],

        ["\xE6\x95\xB0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6F\x80"],
        ["\x6F\x80",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x95\xB0"],

        ["\xE6\x9E\xA2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6F\x8B"],
        ["\x6F\x8B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E\xA2"],

        ["\xE8\xB6\xA8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6F\x9B"],
        ["\x6F\x9B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB6\xA8"],

        ["\xE9\x9B\x9B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6F\x9C"],
        ["\x6F\x9C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\x9B"],

        ["\xE6\x8D\xAE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6F\xA0"],
        ["\x6F\xA0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8D\xAE"],

        ["\xE6\x9D\x89",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6F\xAB"],
        ["\x6F\xAB",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\x89"],

        ["\xE6\xA4\x99",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6F\xB0"],
        ["\x6F\xB0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\x99"],

        ["\xE8\x8F\x85",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6F\xC0"],
        ["\x6F\xC0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F\x85"],

        ["\xE9\xA0\x97",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6F\x6A"],
        ["\x6F\x6A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0\x97"],

        ["\xE9\x9B\x80",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6F\xD0"],
        ["\x6F\xD0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\x80"],

        ["\xE8\xA3\xBE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6F\xA1"],
        ["\x6F\xA1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\xBE"],

        ["\xE6\xBE\x84",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7C\x4F"],
        ["\x7C\x4F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBE\x84"],

        ["\xE6\x91\xBA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7C\x7F"],
        ["\x7C\x7F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x91\xBA"],

        ["\xE5\xAF\xB8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7C\x7B"],
        ["\x7C\x7B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\xB8"],

        ["\xE4\xB8\x96",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7C\xE0"],
        ["\x7C\xE0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\x96"],

        ["\xE7\x80\xAC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7C\x6C"],
        ["\x7C\x6C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x80\xAC"],

        ["\xE7\x95\x9D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7C\x50"],
        ["\x7C\x50",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\x9D"],

        ["\xE6\x98\xAF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7C\x7D"],
        ["\x7C\x7D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\xAF"],

        ["\xE5\x87\x84",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7C\x4D"],
        ["\x7C\x4D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\x84"],

        ["\xE5\x88\xB6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7C\x5D"],
        ["\x7C\x5D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\xB6"],

        ["\xE5\x8B\xA2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7C\x5C"],
        ["\x7C\x5C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\xA2"],

        ["\xE5\xA7\x93",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7C\x4E"],
        ["\x7C\x4E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA7\x93"],

        ["\xE5\xBE\x81",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7C\x6B"],
        ["\x7C\x6B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\x81"],

        ["\xE6\x80\xA7",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7C\x60"],
        ["\x7C\x60",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x80\xA7"],

        ["\xE6\x88\x90",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7C\x4B"],
        ["\x7C\x4B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\x90"],

        ["\xE6\x94\xBF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7C\x61"],
        ["\x7C\x61",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x94\xBF"],

        ["\xE6\x95\xB4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7C\xF0"],
        ["\x7C\xF0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x95\xB4"],

        ["\xE6\x98\x9F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7C\xF1"],
        ["\x7C\xF1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\x9F"],

        ["\xE6\x99\xB4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7C\xF2"],
        ["\x7C\xF2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\xB4"],

        ["\xE6\xA3\xB2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7C\xF3"],
        ["\x7C\xF3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\xB2"],

        ["\xE6\xA0\x96",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7C\xF4"],
        ["\x7C\xF4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA0\x96"],

        ["\xE6\xAD\xA3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7C\xF5"],
        ["\x7C\xF5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\xA3"],

        ["\xE6\xB8\x85",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7C\xF6"],
        ["\x7C\xF6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\x85"],

        ["\xE7\x89\xB2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7C\xF7"],
        ["\x7C\xF7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x89\xB2"],

        ["\xE7\x94\x9F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7C\xF8"],
        ["\x7C\xF8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\x9F"],

        ["\xE7\x9B\x9B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7C\xF9"],
        ["\x7C\xF9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\x9B"],

        ["\xE7\xB2\xBE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7C\x7A"],
        ["\x7C\x7A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\xBE"],

        ["\xE8\x81\x96",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7C\x5E"],
        ["\x7C\x5E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x81\x96"],

        ["\xE5\xA3\xB0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7C\x4C"],
        ["\x7C\x4C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\xB0"],

        ["\xE8\xA3\xBD",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7C\x7E"],
        ["\x7C\x7E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\xBD"],

        ["\xE8\xA5\xBF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7C\x6E"],
        ["\x7C\x6E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA5\xBF"],

        ["\xE8\xAA\xA0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7C\x6F"],
        ["\x7C\x6F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\xA0"],

        ["\xE8\xAA\x93",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7C\x7C"],
        ["\x7C\x7C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\x93"],

        ["\xE8\xAB\x8B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7C\xC1"],
        ["\x7C\xC1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\x8B"],

        ["\xE9\x80\x9D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7C\xC2"],
        ["\x7C\xC2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\x9D"],

        ["\xE9\x86\x92",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7C\xC3"],
        ["\x7C\xC3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x86\x92"],

        ["\xE9\x9D\x92",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7C\xC4"],
        ["\x7C\xC4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9D\x92"],

        ["\xE9\x9D\x99",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7C\xC5"],
        ["\x7C\xC5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9D\x99"],

        ["\xE6\x96\x89",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7C\xC6"],
        ["\x7C\xC6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\x89"],

        ["\xE7\xA8\x8E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7C\xC7"],
        ["\x7C\xC7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8\x8E"],

        ["\xE8\x84\x86",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7C\xC8"],
        ["\x7C\xC8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x84\x86"],

        ["\xE9\x9A\xBB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7C\xC9"],
        ["\x7C\xC9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\xBB"],

        ["\xE5\xB8\xAD",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7C\xD1"],
        ["\x7C\xD1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8\xAD"],

        ["\xE6\x83\x9C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7C\xD2"],
        ["\x7C\xD2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\x9C"],

        ["\xE6\x88\x9A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7C\xD3"],
        ["\x7C\xD3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\x9A"],

        ["\xE6\x96\xA5",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7C\xD4"],
        ["\x7C\xD4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\xA5"],

        ["\xE6\x98\x94",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7C\xD5"],
        ["\x7C\xD5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\x94"],

        ["\xE6\x9E\x90",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7C\xD6"],
        ["\x7C\xD6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E\x90"],

        ["\xE7\x9F\xB3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7C\xD7"],
        ["\x7C\xD7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9F\xB3"],

        ["\xE7\xA9\x8D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7C\xD8"],
        ["\x7C\xD8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\x8D"],

        ["\xE7\xB1\x8D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7C\xD9"],
        ["\x7C\xD9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB1\x8D"],

        ["\xE7\xB8\xBE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7C\xE2"],
        ["\x7C\xE2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\xBE"],

        ["\xE8\x84\x8A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7C\xE3"],
        ["\x7C\xE3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x84\x8A"],

        ["\xE8\xB2\xAC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7C\xE4"],
        ["\x7C\xE4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\xAC"],

        ["\xE8\xB5\xA4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7C\xE5"],
        ["\x7C\xE5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB5\xA4"],

        ["\xE8\xB7\xA1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7C\xE6"],
        ["\x7C\xE6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB7\xA1"],

        ["\xE8\xB9\x9F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7C\xE7"],
        ["\x7C\xE7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB9\x9F"],

        ["\xE7\xA2\xA9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7C\xE8"],
        ["\x7C\xE8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA2\xA9"],

        ["\xE5\x88\x87",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7C\xE9"],
        ["\x7C\xE9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\x87"],

        ["\xE6\x8B\x99",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7C\x4A"],
        ["\x7C\x4A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\x99"],

        ["\xE6\x8E\xA5",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7C\x5B"],
        ["\x7C\x5B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\xA5"],

        ["\xE6\x91\x82",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7C\x5A"],
        ["\x7C\x5A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x91\x82"],

        ["\xE6\x8A\x98",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7C\x5F"],
        ["\x7C\x5F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A\x98"],

        ["\xE8\xA8\xAD",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7C\x6D"],
        ["\x7C\x6D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\xAD"],

        ["\xE7\xAA\x83",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7C\x79"],
        ["\x7C\x79",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAA\x83"],

        ["\xE7\xAF\x80",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7C\x57"],
        ["\x7C\x57",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAF\x80"],

        ["\xE8\xAA\xAC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7C\x59"],
        ["\x7C\x59",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\xAC"],

        ["\xE9\x9B\xAA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7C\x62"],
        ["\x7C\x62",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\xAA"],

        ["\xE7\xB5\xB6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7C\x63"],
        ["\x7C\x63",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\xB6"],

        ["\xE8\x88\x8C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7C\x64"],
        ["\x7C\x64",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\x8C"],

        ["\xE8\x9D\x89",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7C\x65"],
        ["\x7C\x65",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9D\x89"],

        ["\xE4\xBB\x99",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7C\x66"],
        ["\x7C\x66",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\x99"],

        ["\xE5\x85\x88",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7C\x67"],
        ["\x7C\x67",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\x88"],

        ["\xE5\x8D\x83",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7C\x68"],
        ["\x7C\x68",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\x83"],

        ["\xE5\x8D\xA0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7C\x69"],
        ["\x7C\x69",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\xA0"],

        ["\xE5\xAE\xA3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7C\x70"],
        ["\x7C\x70",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\xA3"],

        ["\xE5\xB0\x82",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7C\x71"],
        ["\x7C\x71",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\x82"],

        ["\xE5\xB0\x96",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7C\x72"],
        ["\x7C\x72",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\x96"],

        ["\xE5\xB7\x9D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7C\x73"],
        ["\x7C\x73",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\x9D"],

        ["\xE6\x88\xA6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7C\x74"],
        ["\x7C\x74",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\xA6"],

        ["\xE6\x89\x87",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7C\x75"],
        ["\x7C\x75",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\x87"],

        ["\xE6\x92\xB0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7C\x76"],
        ["\x7C\x76",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x92\xB0"],

        ["\xE6\xA0\x93",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7C\x77"],
        ["\x7C\x77",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA0\x93"],

        ["\xE6\xA0\xB4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7C\x78"],
        ["\x7C\x78",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA0\xB4"],

        ["\xE6\xB3\x89",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7C\x80"],
        ["\x7C\x80",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\x89"],

        ["\xE6\xB5\x85",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7C\x8B"],
        ["\x7C\x8B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB5\x85"],

        ["\xE6\xB4\x97",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7C\x9B"],
        ["\x7C\x9B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4\x97"],

        ["\xE6\x9F\x93",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7C\x9C"],
        ["\x7C\x9C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\x93"],

        ["\xE6\xBD\x9C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7C\xA0"],
        ["\x7C\xA0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBD\x9C"],

        ["\xE7\x85\x8E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7C\xAB"],
        ["\x7C\xAB",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x85\x8E"],

        ["\xE7\x85\xBD",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7C\xB0"],
        ["\x7C\xB0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x85\xBD"],

        ["\xE6\x97\x8B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7C\xC0"],
        ["\x7C\xC0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\x8B"],

        ["\xE7\xA9\xBF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7C\x6A"],
        ["\x7C\x6A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\xBF"],

        ["\xE7\xAE\xAD",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7C\xD0"],
        ["\x7C\xD0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAE\xAD"],

        ["\xE7\xB7\x9A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x7C\xA1"],
        ["\x7C\xA1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7\x9A"],

        ["\xE7\xB9\x8A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC1\x4F"],
        ["\xC1\x4F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\x8A"],

        ["\xE7\xBE\xA8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC1\x7F"],
        ["\xC1\x7F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\xA8"],

        ["\xE8\x85\xBA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC1\x7B"],
        ["\xC1\x7B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x85\xBA"],

        ["\xE8\x88\x9B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC1\xE0"],
        ["\xC1\xE0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\x9B"],

        ["\xE8\x88\xB9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC1\x6C"],
        ["\xC1\x6C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\xB9"],

        ["\xE8\x96\xA6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC1\x50"],
        ["\xC1\x50",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\xA6"],

        ["\xE8\xA9\xAE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC1\x7D"],
        ["\xC1\x7D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\xAE"],

        ["\xE8\xB3\x8E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x71\xD4"],
        ["\x71\xD4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\x8E"],

        ["\xE8\xB7\xB5",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC1\x5D"],
        ["\xC1\x5D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB7\xB5"],

        ["\xE9\x81\xB8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC1\x5C"],
        ["\xC1\x5C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\xB8"],

        ["\xE9\x81\xB7",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC1\x4E"],
        ["\xC1\x4E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\xB7"],

        ["\xE9\x8A\xAD",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC1\x6B"],
        ["\xC1\x6B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8A\xAD"],

        ["\xE9\x8A\x91",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC1\x60"],
        ["\xC1\x60",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8A\x91"],

        ["\xE9\x96\x83",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC1\x4B"],
        ["\xC1\x4B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\x83"],

        ["\xE9\xAE\xAE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC1\x61"],
        ["\xC1\x61",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xAE\xAE"],

        ["\xE5\x89\x8D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC1\xF0"],
        ["\xC1\xF0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\x8D"],

        ["\xE5\x96\x84",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC1\xF1"],
        ["\xC1\xF1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x96\x84"],

        ["\xE6\xBC\xB8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC1\xF2"],
        ["\xC1\xF2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBC\xB8"],

        ["\xE7\x84\xB6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC1\xF3"],
        ["\xC1\xF3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x84\xB6"],

        ["\xE5\x85\xA8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC1\xF4"],
        ["\xC1\xF4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\xA8"],

        ["\xE7\xA6\x85",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC1\xF5"],
        ["\xC1\xF5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6\x85"],

        ["\xE7\xB9\x95",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC1\xF6"],
        ["\xC1\xF6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\x95"],

        ["\xE8\x86\xB3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC1\xF7"],
        ["\xC1\xF7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x86\xB3"],

        ["\xE7\xB3\x8E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC1\xF8"],
        ["\xC1\xF8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3\x8E"],

        ["\xE5\x99\x8C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC1\xF9"],
        ["\xC1\xF9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x99\x8C"],

        ["\xE5\xA1\x91",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC1\x7A"],
        ["\xC1\x7A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA1\x91"],

        ["\xE5\xB2\xA8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC1\x5E"],
        ["\xC1\x5E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB2\xA8"],

        ["\xE6\x8E\xAA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC1\x4C"],
        ["\xC1\x4C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\xAA"],

        ["\xE6\x9B\xBE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC1\x7E"],
        ["\xC1\x7E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\xBE"],

        ["\xE6\x9B\xBD",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC1\x6E"],
        ["\xC1\x6E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\xBD"],

        ["\xE6\xA5\x9A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC1\x6F"],
        ["\xC1\x6F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\x9A"],

        ["\xE7\x8B\x99",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC1\x7C"],
        ["\xC1\x7C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8B\x99"],

        ["\xE7\x96\x8F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC1\xC1"],
        ["\xC1\xC1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x96\x8F"],

        ["\xE7\x96\x8E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC1\xC2"],
        ["\xC1\xC2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x96\x8E"],

        ["\xE7\xA4\x8E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC1\xC3"],
        ["\xC1\xC3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA4\x8E"],

        ["\xE7\xA5\x96",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC1\xC4"],
        ["\xC1\xC4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5\x96"],

        ["\xE7\xA7\x9F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC1\xC5"],
        ["\xC1\xC5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA7\x9F"],

        ["\xE7\xB2\x97",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC1\xC6"],
        ["\xC1\xC6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\x97"],

        ["\xE7\xB4\xA0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC1\xC7"],
        ["\xC1\xC7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\xA0"],

        ["\xE7\xB5\x84",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC1\xC8"],
        ["\xC1\xC8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\x84"],

        ["\xE8\x98\x87",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC1\xC9"],
        ["\xC1\xC9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x98\x87"],

        ["\xE8\xA8\xB4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC1\xD1"],
        ["\xC1\xD1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\xB4"],

        ["\xE9\x98\xBB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC1\xD2"],
        ["\xC1\xD2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x98\xBB"],

        ["\xE9\x81\xA1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC1\xD3"],
        ["\xC1\xD3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\xA1"],

        ["\xE9\xBC\xA0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC1\xD4"],
        ["\xC1\xD4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xBC\xA0"],

        ["\xE5\x83\xA7",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC1\xD5"],
        ["\xC1\xD5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x83\xA7"],

        ["\xE5\x89\xB5",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC1\xD6"],
        ["\xC1\xD6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\xB5"],

        ["\xE5\x8F\x8C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC1\xD7"],
        ["\xC1\xD7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\x8C"],

        ["\xE5\x8F\xA2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC1\xD8"],
        ["\xC1\xD8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\xA2"],

        ["\xE5\x80\x89",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC1\xD9"],
        ["\xC1\xD9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\x89"],

        ["\xE5\x96\xAA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC1\xE2"],
        ["\xC1\xE2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x96\xAA"],

        ["\xE5\xA3\xAE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC1\xE3"],
        ["\xC1\xE3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\xAE"],

        ["\xE5\xA5\x8F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC1\xE4"],
        ["\xC1\xE4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\x8F"],

        ["\xE7\x88\xBD",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC1\xE5"],
        ["\xC1\xE5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x88\xBD"],

        ["\xE5\xAE\x8B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC1\xE6"],
        ["\xC1\xE6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\x8B"],

        ["\xE5\xB1\xA4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC1\xE7"],
        ["\xC1\xE7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\xA4"],

        ["\xE5\x8C\x9D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC1\xE8"],
        ["\xC1\xE8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\x9D"],

        ["\xE6\x83\xA3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC1\xE9"],
        ["\xC1\xE9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\xA3"],

        ["\xE6\x83\xB3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC1\x4A"],
        ["\xC1\x4A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\xB3"],

        ["\xE6\x8D\x9C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC1\x5B"],
        ["\xC1\x5B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8D\x9C"],

        ["\xE6\x8E\x83",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC1\x5A"],
        ["\xC1\x5A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\x83"],

        ["\xE6\x8C\xBF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC1\x5F"],
        ["\xC1\x5F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8C\xBF"],

        ["\xE6\x8E\xBB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC1\x6D"],
        ["\xC1\x6D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\xBB"],

        ["\xE6\x93\x8D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC1\x79"],
        ["\xC1\x79",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\x8D"],

        ["\xE6\x97\xA9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC1\x57"],
        ["\xC1\x57",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\xA9"],

        ["\xE6\x9B\xB9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC1\x59"],
        ["\xC1\x59",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\xB9"],

        ["\xE5\xB7\xA3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC1\x62"],
        ["\xC1\x62",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\xA3"],

        ["\xE6\xA7\x8D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC1\x63"],
        ["\xC1\x63",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\x8D"],

        ["\xE6\xA7\xBD",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC1\x64"],
        ["\xC1\x64",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\xBD"],

        ["\xE6\xBC\x95",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC1\x65"],
        ["\xC1\x65",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBC\x95"],

        ["\xE7\x87\xA5",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC1\x66"],
        ["\xC1\x66",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x87\xA5"],

        ["\xE4\xBA\x89",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC1\x67"],
        ["\xC1\x67",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\x89"],

        ["\xE7\x97\xA9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC1\x68"],
        ["\xC1\x68",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\xA9"],

        ["\xE7\x9B\xB8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC1\x69"],
        ["\xC1\x69",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\xB8"],

        ["\xE7\xAA\x93",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC1\x70"],
        ["\xC1\x70",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAA\x93"],

        ["\xE7\xB3\x9F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC1\x71"],
        ["\xC1\x71",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3\x9F"],

        ["\xE7\xB7\x8F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC1\x72"],
        ["\xC1\x72",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7\x8F"],

        ["\xE7\xB6\x9C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC1\x73"],
        ["\xC1\x73",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\x9C"],

        ["\xE8\x81\xA1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC1\x74"],
        ["\xC1\x74",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x81\xA1"],

        ["\xE8\x8D\x89",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC1\x75"],
        ["\xC1\x75",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8D\x89"],

        ["\xE8\x8D\x98",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC1\x76"],
        ["\xC1\x76",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8D\x98"],

        ["\xE8\x91\xAC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC1\x77"],
        ["\xC1\x77",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x91\xAC"],

        ["\xE8\x92\xBC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC1\x78"],
        ["\xC1\x78",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x92\xBC"],

        ["\xE8\x97\xBB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC1\x80"],
        ["\xC1\x80",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x97\xBB"],

        ["\xE8\xA3\x85",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC1\x8B"],
        ["\xC1\x8B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\x85"],

        ["\xE8\xB5\xB0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC1\x9B"],
        ["\xC1\x9B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB5\xB0"],

        ["\xE9\x80\x81",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC1\x9C"],
        ["\xC1\x9C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\x81"],

        ["\xE9\x81\xAD",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC1\xA0"],
        ["\xC1\xA0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\xAD"],

        ["\xE9\x8E\x97",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC1\xAB"],
        ["\xC1\xAB",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8E\x97"],

        ["\xE9\x9C\x9C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC1\xB0"],
        ["\xC1\xB0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9C\x9C"],

        ["\xE9\xA8\x92",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC1\xC0"],
        ["\xC1\xC0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA8\x92"],

        ["\xE5\x83\x8F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC1\x6A"],
        ["\xC1\x6A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x83\x8F"],

        ["\xE5\xA2\x97",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC1\xD0"],
        ["\xC1\xD0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA2\x97"],

        ["\xE6\x86\x8E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC1\xA1"],
        ["\xC1\xA1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x86\x8E"],

        ["\xE8\x87\x93",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC2\x4F"],
        ["\xC2\x4F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\x93"],

        ["\xE8\x94\xB5",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC2\x7F"],
        ["\xC2\x7F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x94\xB5"],

        ["\xE8\xB4\x88",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC2\x7B"],
        ["\xC2\x7B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB4\x88"],

        ["\xE9\x80\xA0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC2\xE0"],
        ["\xC2\xE0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\xA0"],

        ["\xE4\xBF\x83",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC2\x6C"],
        ["\xC2\x6C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\x83"],

        ["\xE5\x81\xB4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC2\x50"],
        ["\xC2\x50",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x81\xB4"],

        ["\xE5\x89\x87",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC2\x7D"],
        ["\xC2\x7D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\x87"],

        ["\xE5\x8D\xB3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC2\x4D"],
        ["\xC2\x4D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\xB3"],

        ["\xE6\x81\xAF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC2\x5D"],
        ["\xC2\x5D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\xAF"],

        ["\xE6\x8D\x89",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC2\x5C"],
        ["\xC2\x5C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8D\x89"],

        ["\xE6\x9D\x9F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC2\x4E"],
        ["\xC2\x4E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\x9F"],

        ["\xE6\xB8\xAC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC2\x6B"],
        ["\xC2\x6B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\xAC"],

        ["\xE8\xB6\xB3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC2\x60"],
        ["\xC2\x60",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB6\xB3"],

        ["\xE9\x80\x9F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC2\x4B"],
        ["\xC2\x4B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\x9F"],

        ["\xE4\xBF\x97",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC2\x61"],
        ["\xC2\x61",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\x97"],

        ["\xE5\xB1\x9E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC2\xF0"],
        ["\xC2\xF0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\x9E"],

        ["\xE8\xB3\x8A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC2\xF1"],
        ["\xC2\xF1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\x8A"],

        ["\xE6\x97\x8F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC2\xF2"],
        ["\xC2\xF2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\x8F"],

        ["\xE7\xB6\x9A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC2\xF3"],
        ["\xC2\xF3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\x9A"],

        ["\xE5\x8D\x92",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC2\xF4"],
        ["\xC2\xF4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\x92"],

        ["\xE8\xA2\x96",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC2\xF5"],
        ["\xC2\xF5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA2\x96"],

        ["\xE5\x85\xB6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC2\xF6"],
        ["\xC2\xF6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\xB6"],

        ["\xE6\x8F\x83",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC2\xF7"],
        ["\xC2\xF7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8F\x83"],

        ["\xE5\xAD\x98",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC2\xF8"],
        ["\xC2\xF8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\x98"],

        ["\xE5\xAD\xAB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC2\xF9"],
        ["\xC2\xF9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\xAB"],

        ["\xE5\xB0\x8A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC2\x7A"],
        ["\xC2\x7A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\x8A"],

        ["\xE6\x90\x8D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC2\x5E"],
        ["\xC2\x5E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x90\x8D"],

        ["\xE6\x9D\x91",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC2\x4C"],
        ["\xC2\x4C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\x91"],

        ["\xE9\x81\x9C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC2\x7E"],
        ["\xC2\x7E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\x9C"],

        ["\xE4\xBB\x96",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC2\x6E"],
        ["\xC2\x6E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\x96"],

        ["\xE5\xA4\x9A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC2\x6F"],
        ["\xC2\x6F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\x9A"],

        ["\xE5\xA4\xAA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC2\x7C"],
        ["\xC2\x7C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\xAA"],

        ["\xE6\xB1\xB0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC2\xC1"],
        ["\xC2\xC1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1\xB0"],

        ["\xE8\xA9\x91",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC2\xC2"],
        ["\xC2\xC2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\x91"],

        ["\xE5\x94\xBE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC2\xC3"],
        ["\xC2\xC3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x94\xBE"],

        ["\xE5\xA0\x95",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC2\xC4"],
        ["\xC2\xC4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA0\x95"],

        ["\xE5\xA6\xA5",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC2\xC5"],
        ["\xC2\xC5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA6\xA5"],

        ["\xE6\x83\xB0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC2\xC6"],
        ["\xC2\xC6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\xB0"],

        ["\xE6\x89\x93",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC2\xC7"],
        ["\xC2\xC7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\x93"],

        ["\xE6\x9F\x81",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC2\xC8"],
        ["\xC2\xC8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\x81"],

        ["\xE8\x88\xB5",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC2\xC9"],
        ["\xC2\xC9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\xB5"],

        ["\xE6\xA5\x95",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC2\xD1"],
        ["\xC2\xD1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\x95"],

        ["\xE9\x99\x80",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC2\xD2"],
        ["\xC2\xD2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x99\x80"],

        ["\xE9\xA7\x84",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC2\xD3"],
        ["\xC2\xD3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA7\x84"],

        ["\xE9\xA8\xA8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC2\xD4"],
        ["\xC2\xD4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA8\xA8"],

        ["\xE4\xBD\x93",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC2\xD5"],
        ["\xC2\xD5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\x93"],

        ["\xE5\xA0\x86",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC2\xD6"],
        ["\xC2\xD6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA0\x86"],

        ["\xE5\xAF\xBE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC2\xD7"],
        ["\xC2\xD7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\xBE"],

        ["\xE8\x80\x90",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC2\xD8"],
        ["\xC2\xD8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\x90"],

        ["\xE5\xB2\xB1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC2\xD9"],
        ["\xC2\xD9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB2\xB1"],

        ["\xE5\xB8\xAF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC2\xE2"],
        ["\xC2\xE2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8\xAF"],

        ["\xE5\xBE\x85",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC2\xE3"],
        ["\xC2\xE3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\x85"],

        ["\xE6\x80\xA0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC2\xE4"],
        ["\xC2\xE4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x80\xA0"],

        ["\xE6\x85\x8B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC2\xE5"],
        ["\xC2\xE5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\x8B"],

        ["\xE6\x88\xB4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC2\xE6"],
        ["\xC2\xE6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\xB4"],

        ["\xE6\x9B\xBF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC2\xE7"],
        ["\xC2\xE7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\xBF"],

        ["\xE6\xB3\xB0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC2\xE8"],
        ["\xC2\xE8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\xB0"],

        ["\xE6\xBB\x9E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC2\xE9"],
        ["\xC2\xE9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBB\x9E"],

        ["\xE8\x83\x8E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC2\x4A"],
        ["\xC2\x4A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x83\x8E"],

        ["\xE8\x85\xBF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC2\x5B"],
        ["\xC2\x5B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x85\xBF"],

        ["\xE8\x8B\x94",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC2\x5A"],
        ["\xC2\x5A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8B\x94"],

        ["\xE8\xA2\x8B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC2\x5F"],
        ["\xC2\x5F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA2\x8B"],

        ["\xE8\xB2\xB8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC2\x6D"],
        ["\xC2\x6D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\xB8"],

        ["\xE9\x80\x80",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC2\x79"],
        ["\xC2\x79",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\x80"],

        ["\xE9\x80\xAE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC2\x57"],
        ["\xC2\x57",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\xAE"],

        ["\xE9\x9A\x8A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC2\x59"],
        ["\xC2\x59",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\x8A"],

        ["\xE9\xBB\x9B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC2\x62"],
        ["\xC2\x62",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xBB\x9B"],

        ["\xE9\xAF\x9B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC2\x63"],
        ["\xC2\x63",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xAF\x9B"],

        ["\xE4\xBB\xA3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC2\x64"],
        ["\xC2\x64",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\xA3"],

        ["\xE5\x8F\xB0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC2\x65"],
        ["\xC2\x65",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\xB0"],

        ["\xE5\xA4\xA7",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC2\x66"],
        ["\xC2\x66",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\xA7"],

        ["\xE7\xAC\xAC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC2\x67"],
        ["\xC2\x67",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC\xAC"],

        ["\xE9\x86\x8D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC2\x68"],
        ["\xC2\x68",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x86\x8D"],

        ["\xE9\xA1\x8C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC2\x69"],
        ["\xC2\x69",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA1\x8C"],

        ["\xE9\xB7\xB9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC2\x70"],
        ["\xC2\x70",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB7\xB9"],

        ["\xE6\xBB\x9D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC2\x71"],
        ["\xC2\x71",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBB\x9D"],

        ["\xE7\x80\xA7",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC2\x72"],
        ["\xC2\x72",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x80\xA7"],

        ["\xE5\x8D\x93",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC2\x73"],
        ["\xC2\x73",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\x93"],

        ["\xE5\x95\x84",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC2\x74"],
        ["\xC2\x74",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x95\x84"],

        ["\xE5\xAE\x85",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC2\x75"],
        ["\xC2\x75",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\x85"],

        ["\xE6\x89\x98",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC2\x76"],
        ["\xC2\x76",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\x98"],

        ["\xE6\x8A\x9E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC2\x77"],
        ["\xC2\x77",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A\x9E"],

        ["\xE6\x8B\x93",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC2\x78"],
        ["\xC2\x78",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\x93"],

        ["\xE6\xB2\xA2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC2\x80"],
        ["\xC2\x80",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\xA2"],

        ["\xE6\xBF\xAF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC2\x8B"],
        ["\xC2\x8B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF\xAF"],

        ["\xE7\x90\xA2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC2\x9B"],
        ["\xC2\x9B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x90\xA2"],

        ["\xE8\xA8\x97",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC2\x9C"],
        ["\xC2\x9C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\x97"],

        ["\xE9\x90\xB8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC2\xA0"],
        ["\xC2\xA0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x90\xB8"],

        ["\xE6\xBF\x81",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC2\xAB"],
        ["\xC2\xAB",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF\x81"],

        ["\xE8\xAB\xBE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC2\xB0"],
        ["\xC2\xB0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\xBE"],

        ["\xE8\x8C\xB8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC2\xC0"],
        ["\xC2\xC0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C\xB8"],

        ["\xE5\x87\xA7",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC2\x6A"],
        ["\xC2\x6A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\xA7"],

        ["\xE8\x9B\xB8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC2\xD0"],
        ["\xC2\xD0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9B\xB8"],

        ["\xE5\x8F\xAA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC2\xA1"],
        ["\xC2\xA1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\xAA"],

        ["\xE5\x8F\xA9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC3\x4F"],
        ["\xC3\x4F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\xA9"],

        ["\xE4\xBD\x86",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC3\x7F"],
        ["\xC3\x7F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\x86"],

        ["\xE9\x81\x94",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC3\x7B"],
        ["\xC3\x7B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\x94"],

        ["\xE8\xBE\xB0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC3\xE0"],
        ["\xC3\xE0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBE\xB0"],

        ["\xE5\xA5\xAA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC3\x6C"],
        ["\xC3\x6C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\xAA"],

        ["\xE8\x84\xB1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC3\x50"],
        ["\xC3\x50",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x84\xB1"],

        ["\xE5\xB7\xBD",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC3\x7D"],
        ["\xC3\x7D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\xBD"],

        ["\xE7\xAB\xAA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC3\x4D"],
        ["\xC3\x4D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\xAA"],

        ["\xE8\xBE\xBF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC3\x5D"],
        ["\xC3\x5D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBE\xBF"],

        ["\xE6\xA3\x9A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC3\x5C"],
        ["\xC3\x5C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\x9A"],

        ["\xE8\xB0\xB7",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC3\x4E"],
        ["\xC3\x4E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB0\xB7"],

        ["\xE7\x8B\xB8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC3\x6B"],
        ["\xC3\x6B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8B\xB8"],

        ["\xE9\xB1\x88",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC3\x60"],
        ["\xC3\x60",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB1\x88"],

        ["\xE6\xA8\xBD",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC3\x4B"],
        ["\xC3\x4B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\xBD"],

        ["\xE8\xAA\xB0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC3\x61"],
        ["\xC3\x61",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\xB0"],

        ["\xE4\xB8\xB9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC3\xF0"],
        ["\xC3\xF0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\xB9"],

        ["\xE5\x8D\x98",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC3\xF1"],
        ["\xC3\xF1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\x98"],

        ["\xE5\x98\x86",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC3\xF2"],
        ["\xC3\xF2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x98\x86"],

        ["\xE5\x9D\xA6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC3\xF3"],
        ["\xC3\xF3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9D\xA6"],

        ["\xE6\x8B\x85",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC3\xF4"],
        ["\xC3\xF4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\x85"],

        ["\xE6\x8E\xA2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC3\xF5"],
        ["\xC3\xF5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\xA2"],

        ["\xE6\x97\xA6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC3\xF6"],
        ["\xC3\xF6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\xA6"],

        ["\xE6\xAD\x8E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC3\xF7"],
        ["\xC3\xF7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\x8E"],

        ["\xE6\xB7\xA1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC3\xF8"],
        ["\xC3\xF8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\xA1"],

        ["\xE6\xB9\x9B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC3\xF9"],
        ["\xC3\xF9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB9\x9B"],

        ["\xE7\x82\xAD",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC3\x7A"],
        ["\xC3\x7A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x82\xAD"],

        ["\xE7\x9F\xAD",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC3\x5E"],
        ["\xC3\x5E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9F\xAD"],

        ["\xE7\xAB\xAF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC3\x4C"],
        ["\xC3\x4C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\xAF"],

        ["\xE7\xAE\xAA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC3\x7E"],
        ["\xC3\x7E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAE\xAA"],

        ["\xE7\xB6\xBB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC3\x6E"],
        ["\xC3\x6E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\xBB"],

        ["\xE8\x80\xBD",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC3\x6F"],
        ["\xC3\x6F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\xBD"],

        ["\xE8\x83\x86",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC3\x7C"],
        ["\xC3\x7C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x83\x86"],

        ["\xE8\x9B\x8B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC3\xC1"],
        ["\xC3\xC1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9B\x8B"],

        ["\xE8\xAA\x95",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC3\xC2"],
        ["\xC3\xC2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\x95"],

        ["\xE9\x8D\x9B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC3\xC3"],
        ["\xC3\xC3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8D\x9B"],

        ["\xE5\x9B\xA3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC3\xC4"],
        ["\xC3\xC4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B\xA3"],

        ["\xE5\xA3\x87",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC3\xC5"],
        ["\xC3\xC5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\x87"],

        ["\xE5\xBC\xBE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC3\xC6"],
        ["\xC3\xC6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\xBE"],

        ["\xE6\x96\xAD",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC3\xC7"],
        ["\xC3\xC7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\xAD"],

        ["\xE6\x9A\x96",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC3\xC8"],
        ["\xC3\xC8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A\x96"],

        ["\xE6\xAA\x80",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC3\xC9"],
        ["\xC3\xC9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAA\x80"],

        ["\xE6\xAE\xB5",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC3\xD1"],
        ["\xC3\xD1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\xB5"],

        ["\xE7\x94\xB7",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC3\xD2"],
        ["\xC3\xD2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\xB7"],

        ["\xE8\xAB\x87",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC3\xD3"],
        ["\xC3\xD3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\x87"],

        ["\xE5\x80\xA4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC3\xD4"],
        ["\xC3\xD4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\xA4"],

        ["\xE7\x9F\xA5",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC3\xD5"],
        ["\xC3\xD5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9F\xA5"],

        ["\xE5\x9C\xB0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC3\xD6"],
        ["\xC3\xD6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C\xB0"],

        ["\xE5\xBC\x9B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC3\xD7"],
        ["\xC3\xD7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\x9B"],

        ["\xE6\x81\xA5",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC3\xD8"],
        ["\xC3\xD8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\xA5"],

        ["\xE6\x99\xBA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC3\xD9"],
        ["\xC3\xD9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\xBA"],

        ["\xE6\xB1\xA0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC3\xE2"],
        ["\xC3\xE2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1\xA0"],

        ["\xE7\x97\xB4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC3\xE3"],
        ["\xC3\xE3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\xB4"],

        ["\xE7\xA8\x9A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC3\xE4"],
        ["\xC3\xE4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8\x9A"],

        ["\xE7\xBD\xAE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC3\xE5"],
        ["\xC3\xE5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\xAE"],

        ["\xE8\x87\xB4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC3\xE6"],
        ["\xC3\xE6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\xB4"],

        ["\xE8\x9C\x98",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC3\xE7"],
        ["\xC3\xE7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9C\x98"],

        ["\xE9\x81\x85",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC3\xE8"],
        ["\xC3\xE8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\x85"],

        ["\xE9\xA6\xB3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC3\xE9"],
        ["\xC3\xE9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA6\xB3"],

        ["\xE7\xAF\x89",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC3\x4A"],
        ["\xC3\x4A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAF\x89"],

        ["\xE7\x95\x9C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC3\x5B"],
        ["\xC3\x5B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\x9C"],

        ["\xE7\xAB\xB9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC3\x5A"],
        ["\xC3\x5A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\xB9"],

        ["\xE7\xAD\x91",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC3\x5F"],
        ["\xC3\x5F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\x91"],

        ["\xE8\x93\x84",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC3\x6D"],
        ["\xC3\x6D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x93\x84"],

        ["\xE9\x80\x90",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC3\x79"],
        ["\xC3\x79",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\x90"],

        ["\xE7\xA7\xA9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC3\x57"],
        ["\xC3\x57",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA7\xA9"],

        ["\xE7\xAA\x92",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC3\x59"],
        ["\xC3\x59",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAA\x92"],

        ["\xE8\x8C\xB6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC3\x62"],
        ["\xC3\x62",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C\xB6"],

        ["\xE5\xAB\xA1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC3\x63"],
        ["\xC3\x63",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAB\xA1"],

        ["\xE7\x9D\x80",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC3\x64"],
        ["\xC3\x64",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9D\x80"],

        ["\xE4\xB8\xAD",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC3\x65"],
        ["\xC3\x65",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\xAD"],

        ["\xE4\xBB\xB2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC3\x66"],
        ["\xC3\x66",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\xB2"],

        ["\xE5\xAE\x99",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC3\x67"],
        ["\xC3\x67",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\x99"],

        ["\xE5\xBF\xA0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC3\x68"],
        ["\xC3\x68",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF\xA0"],

        ["\xE6\x8A\xBD",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC3\x69"],
        ["\xC3\x69",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A\xBD"],

        ["\xE6\x98\xBC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC3\x70"],
        ["\xC3\x70",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\xBC"],

        ["\xE6\x9F\xB1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC3\x71"],
        ["\xC3\x71",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\xB1"],

        ["\xE6\xB3\xA8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC3\x72"],
        ["\xC3\x72",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\xA8"],

        ["\xE8\x99\xAB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC3\x73"],
        ["\xC3\x73",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x99\xAB"],

        ["\xE8\xA1\xB7",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC3\x74"],
        ["\xC3\x74",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\xB7"],

        ["\xE8\xA8\xBB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC3\x75"],
        ["\xC3\x75",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\xBB"],

        ["\xE9\x85\x8E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC3\x76"],
        ["\xC3\x76",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x85\x8E"],

        ["\xE9\x8B\xB3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC3\x77"],
        ["\xC3\x77",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8B\xB3"],

        ["\xE9\xA7\x90",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC3\x78"],
        ["\xC3\x78",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA7\x90"],

        ["\xE6\xA8\x97",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC3\x80"],
        ["\xC3\x80",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\x97"],

        ["\xE7\x80\xA6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC3\x8B"],
        ["\xC3\x8B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x80\xA6"],

        ["\xE7\x8C\xAA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC3\x9B"],
        ["\xC3\x9B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8C\xAA"],

        ["\xE8\x8B\xA7",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC3\x9C"],
        ["\xC3\x9C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8B\xA7"],

        ["\xE8\x91\x97",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC3\xA0"],
        ["\xC3\xA0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x91\x97"],

        ["\xE8\xB2\xAF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC3\xAB"],
        ["\xC3\xAB",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\xAF"],

        ["\xE4\xB8\x81",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC3\xB0"],
        ["\xC3\xB0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\x81"],

        ["\xE5\x85\x86",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC3\xC0"],
        ["\xC3\xC0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\x86"],

        ["\xE5\x87\x8B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC3\x6A"],
        ["\xC3\x6A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\x8B"],

        ["\xE5\x96\x8B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC3\xD0"],
        ["\xC3\xD0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x96\x8B"],

        ["\xE5\xAF\xB5",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC3\xA1"],
        ["\xC3\xA1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\xB5"],

        ["\xE5\xB8\x96",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC4\x4F"],
        ["\xC4\x4F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8\x96"],

        ["\xE5\xB8\xB3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC4\x7F"],
        ["\xC4\x7F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8\xB3"],

        ["\xE5\xBA\x81",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC4\x7B"],
        ["\xC4\x7B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBA\x81"],

        ["\xE5\xBC\x94",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC4\xE0"],
        ["\xC4\xE0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\x94"],

        ["\xE5\xBC\xB5",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC4\x6C"],
        ["\xC4\x6C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\xB5"],

        ["\xE5\xBD\xAB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC4\x50"],
        ["\xC4\x50",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\xAB"],

        ["\xE5\xBE\xB4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC4\x7D"],
        ["\xC4\x7D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\xB4"],

        ["\xE6\x87\xB2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC4\x4D"],
        ["\xC4\x4D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x87\xB2"],

        ["\xE6\x8C\x91",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC4\x5D"],
        ["\xC4\x5D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8C\x91"],

        ["\xE6\x9A\xA2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC4\x5C"],
        ["\xC4\x5C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A\xA2"],

        ["\xE6\x9C\x9D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC4\x4E"],
        ["\xC4\x4E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\x9D"],

        ["\xE6\xBD\xAE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC4\x6B"],
        ["\xC4\x6B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBD\xAE"],

        ["\xE7\x89\x92",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC4\x60"],
        ["\xC4\x60",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x89\x92"],

        ["\xE7\x94\xBA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC4\x4B"],
        ["\xC4\x4B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\xBA"],

        ["\xE7\x9C\xBA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC4\x61"],
        ["\xC4\x61",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9C\xBA"],

        ["\xE8\x81\xB4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC4\xF0"],
        ["\xC4\xF0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x81\xB4"],

        ["\xE8\x84\xB9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC4\xF1"],
        ["\xC4\xF1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x84\xB9"],

        ["\xE8\x85\xB8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC4\xF2"],
        ["\xC4\xF2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x85\xB8"],

        ["\xE8\x9D\xB6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC4\xF3"],
        ["\xC4\xF3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9D\xB6"],

        ["\xE8\xAA\xBF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC4\xF4"],
        ["\xC4\xF4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\xBF"],

        ["\xE8\xAB\x9C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC4\xF5"],
        ["\xC4\xF5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\x9C"],

        ["\xE8\xB6\x85",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC4\xF6"],
        ["\xC4\xF6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB6\x85"],

        ["\xE8\xB7\xB3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC4\xF7"],
        ["\xC4\xF7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB7\xB3"],

        ["\xE9\x8A\x9A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC4\xF8"],
        ["\xC4\xF8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8A\x9A"],

        ["\xE9\x95\xB7",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC4\xF9"],
        ["\xC4\xF9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x95\xB7"],

        ["\xE9\xA0\x82",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC4\x7A"],
        ["\xC4\x7A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0\x82"],

        ["\xE9\xB3\xA5",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC4\x5E"],
        ["\xC4\x5E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB3\xA5"],

        ["\xE5\x8B\x85",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC4\x4C"],
        ["\xC4\x4C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\x85"],

        ["\xE6\x8D\x97",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC4\x7E"],
        ["\xC4\x7E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8D\x97"],

        ["\xE7\x9B\xB4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC4\x6E"],
        ["\xC4\x6E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\xB4"],

        ["\xE6\x9C\x95",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC4\x6F"],
        ["\xC4\x6F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\x95"],

        ["\xE6\xB2\x88",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC4\x7C"],
        ["\xC4\x7C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\x88"],

        ["\xE7\x8F\x8D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC4\xC1"],
        ["\xC4\xC1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8F\x8D"],

        ["\xE8\xB3\x83",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC4\xC2"],
        ["\xC4\xC2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\x83"],

        ["\xE9\x8E\xAE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC4\xC3"],
        ["\xC4\xC3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8E\xAE"],

        ["\xE9\x99\xB3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC4\xC4"],
        ["\xC4\xC4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x99\xB3"],

        ["\xE6\xB4\xA5",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC4\xC5"],
        ["\xC4\xC5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4\xA5"],

        ["\xE5\xA2\x9C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC4\xC6"],
        ["\xC4\xC6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA2\x9C"],

        ["\xE6\xA4\x8E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC4\xC7"],
        ["\xC4\xC7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\x8E"],

        ["\xE6\xA7\x8C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC4\xC8"],
        ["\xC4\xC8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\x8C"],

        ["\xE8\xBF\xBD",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC4\xC9"],
        ["\xC4\xC9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF\xBD"],

        ["\xE9\x8E\x9A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC4\xD1"],
        ["\xC4\xD1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8E\x9A"],

        ["\xE7\x97\x9B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC4\xD2"],
        ["\xC4\xD2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\x9B"],

        ["\xE9\x80\x9A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC4\xD3"],
        ["\xC4\xD3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\x9A"],

        ["\xE5\xA1\x9A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x86\xEB"],
        ["\x86\xEB",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA1\x9A"],

        ["\xE6\xA0\x82",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC4\xD5"],
        ["\xC4\xD5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA0\x82"],

        ["\xE6\x8E\xB4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC4\xD6"],
        ["\xC4\xD6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\xB4"],

        ["\xE6\xA7\xBB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC4\xD7"],
        ["\xC4\xD7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\xBB"],

        ["\xE4\xBD\x83",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC4\xD8"],
        ["\xC4\xD8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\x83"],

        ["\xE6\xBC\xAC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC4\xD9"],
        ["\xC4\xD9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBC\xAC"],

        ["\xE6\x9F\x98",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC4\xE2"],
        ["\xC4\xE2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\x98"],

        ["\xE8\xBE\xBB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC4\xE3"],
        ["\xC4\xE3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBE\xBB"],

        ["\xE8\x94\xA6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC4\xE4"],
        ["\xC4\xE4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x94\xA6"],

        ["\xE7\xB6\xB4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC4\xE5"],
        ["\xC4\xE5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\xB4"],

        ["\xE9\x8D\x94",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC4\xE6"],
        ["\xC4\xE6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8D\x94"],

        ["\xE6\xA4\xBF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC4\xE7"],
        ["\xC4\xE7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\xBF"],

        ["\xE6\xBD\xB0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC4\xE8"],
        ["\xC4\xE8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBD\xB0"],

        ["\xE5\x9D\xAA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC4\xE9"],
        ["\xC4\xE9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9D\xAA"],

        ["\xE5\xA3\xB7",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE3\x63"],
        ["\xE3\x63",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\xB7"],

        ["\xE5\xAC\xAC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC4\x5B"],
        ["\xC4\x5B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAC\xAC"],

        ["\xE7\xB4\xAC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC4\x5A"],
        ["\xC4\x5A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\xAC"],

        ["\xE7\x88\xAA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC4\x5F"],
        ["\xC4\x5F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x88\xAA"],

        ["\xE5\x90\x8A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC4\x6D"],
        ["\xC4\x6D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\x8A"],

        ["\xE9\x87\xA3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC4\x79"],
        ["\xC4\x79",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\xA3"],

        ["\xE9\xB6\xB4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC4\x57"],
        ["\xC4\x57",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB6\xB4"],

        ["\xE4\xBA\xAD",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC4\x59"],
        ["\xC4\x59",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\xAD"],

        ["\xE4\xBD\x8E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC4\x62"],
        ["\xC4\x62",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\x8E"],

        ["\xE5\x81\x9C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC4\x63"],
        ["\xC4\x63",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x81\x9C"],

        ["\xE5\x81\xB5",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC4\x64"],
        ["\xC4\x64",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x81\xB5"],

        ["\xE5\x89\x83",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC4\x65"],
        ["\xC4\x65",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\x83"],

        ["\xE8\xB2\x9E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC4\x66"],
        ["\xC4\x66",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\x9E"],

        ["\xE5\x91\x88",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC4\x67"],
        ["\xC4\x67",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x91\x88"],

        ["\xE5\xA0\xA4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC4\x68"],
        ["\xC4\x68",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA0\xA4"],

        ["\xE5\xAE\x9A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC4\x69"],
        ["\xC4\x69",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\x9A"],

        ["\xE5\xB8\x9D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC4\x70"],
        ["\xC4\x70",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8\x9D"],

        ["\xE5\xBA\x95",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC4\x71"],
        ["\xC4\x71",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBA\x95"],

        ["\xE5\xBA\xAD",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC4\x72"],
        ["\xC4\x72",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBA\xAD"],

        ["\xE5\xBB\xB7",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC4\x73"],
        ["\xC4\x73",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\xB7"],

        ["\xE5\xBC\x9F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC4\x74"],
        ["\xC4\x74",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\x9F"],

        ["\xE6\x82\x8C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC4\x75"],
        ["\xC4\x75",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\x8C"],

        ["\xE6\x8A\xB5",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC4\x76"],
        ["\xC4\x76",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A\xB5"],

        ["\xE6\x8C\xBA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC4\x77"],
        ["\xC4\x77",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8C\xBA"],

        ["\xE6\x8F\x90",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC4\x78"],
        ["\xC4\x78",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8F\x90"],

        ["\xE6\xA2\xAF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC4\x80"],
        ["\xC4\x80",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\xAF"],

        ["\xE6\xB1\x80",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC4\x8B"],
        ["\xC4\x8B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1\x80"],

        ["\xE7\xA2\x87",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC4\x9B"],
        ["\xC4\x9B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA2\x87"],

        ["\xE7\xA6\x8E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC4\x9C"],
        ["\xC4\x9C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6\x8E"],

        ["\xE7\xA8\x8B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC4\xA0"],
        ["\xC4\xA0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8\x8B"],

        ["\xE7\xB7\xA0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC4\xAB"],
        ["\xC4\xAB",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7\xA0"],

        ["\xE8\x89\x87",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC4\xB0"],
        ["\xC4\xB0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x89\x87"],

        ["\xE8\xA8\x82",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC4\xC0"],
        ["\xC4\xC0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\x82"],

        ["\xE8\xAB\xA6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC4\x6A"],
        ["\xC4\x6A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\xA6"],

        ["\xE8\xB9\x84",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC4\xD0"],
        ["\xC4\xD0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB9\x84"],

        ["\xE9\x80\x93",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC4\xA1"],
        ["\xC4\xA1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\x93"],

        ["\xE9\x82\xB8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC5\x4F"],
        ["\xC5\x4F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x82\xB8"],

        ["\xE9\x84\xAD",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC5\x7F"],
        ["\xC5\x7F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x84\xAD"],

        ["\xE9\x87\x98",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC5\x7B"],
        ["\xC5\x7B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\x98"],

        ["\xE9\xBC\x8E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC5\xE0"],
        ["\xC5\xE0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xBC\x8E"],

        ["\xE6\xB3\xA5",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC5\x6C"],
        ["\xC5\x6C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\xA5"],

        ["\xE6\x91\x98",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC5\x50"],
        ["\xC5\x50",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x91\x98"],

        ["\xE6\x93\xA2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC5\x7D"],
        ["\xC5\x7D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\xA2"],

        ["\xE6\x95\xB5",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC5\x4D"],
        ["\xC5\x4D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x95\xB5"],

        ["\xE6\xBB\xB4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC5\x5D"],
        ["\xC5\x5D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBB\xB4"],

        ["\xE7\x9A\x84",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC5\x5C"],
        ["\xC5\x5C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\x84"],

        ["\xE7\xAC\x9B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC5\x4E"],
        ["\xC5\x4E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC\x9B"],

        ["\xE9\x81\xA9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC5\x6B"],
        ["\xC5\x6B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\xA9"],

        ["\xE9\x8F\x91",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC5\x60"],
        ["\xC5\x60",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8F\x91"],

        ["\xE6\xBA\xBA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC5\x4B"],
        ["\xC5\x4B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBA\xBA"],

        ["\xE5\x93\xB2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC5\x61"],
        ["\xC5\x61",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x93\xB2"],

        ["\xE5\xBE\xB9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC5\xF0"],
        ["\xC5\xF0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\xB9"],

        ["\xE6\x92\xA4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC5\xF1"],
        ["\xC5\xF1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x92\xA4"],

        ["\xE8\xBD\x8D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC5\xF2"],
        ["\xC5\xF2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBD\x8D"],

        ["\xE8\xBF\xAD",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC5\xF3"],
        ["\xC5\xF3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF\xAD"],

        ["\xE9\x89\x84",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC5\xF4"],
        ["\xC5\xF4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x89\x84"],

        ["\xE5\x85\xB8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC5\xF5"],
        ["\xC5\xF5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\xB8"],

        ["\xE5\xA1\xAB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xAC\xB8"],
        ["\xAC\xB8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA1\xAB"],

        ["\xE5\xA4\xA9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC5\xF7"],
        ["\xC5\xF7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\xA9"],

        ["\xE5\xB1\x95",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC5\xF8"],
        ["\xC5\xF8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\x95"],

        ["\xE5\xBA\x97",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC5\xF9"],
        ["\xC5\xF9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBA\x97"],

        ["\xE6\xB7\xBB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC5\x7A"],
        ["\xC5\x7A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\xBB"],

        ["\xE7\xBA\x8F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC5\x5E"],
        ["\xC5\x5E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBA\x8F"],

        ["\xE7\x94\x9C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC5\x4C"],
        ["\xC5\x4C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\x9C"],

        ["\xE8\xB2\xBC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC5\x7E"],
        ["\xC5\x7E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\xBC"],

        ["\xE8\xBB\xA2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC5\x6E"],
        ["\xC5\x6E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBB\xA2"],

        ["\xE9\xA1\x9B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xA9\x43"],
        ["\xA9\x43",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA1\x9B"],

        ["\xE7\x82\xB9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC5\x7C"],
        ["\xC5\x7C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x82\xB9"],

        ["\xE4\xBC\x9D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC5\xC1"],
        ["\xC5\xC1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBC\x9D"],

        ["\xE6\xAE\xBF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC5\xC2"],
        ["\xC5\xC2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\xBF"],

        ["\xE6\xBE\xB1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC5\xC3"],
        ["\xC5\xC3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBE\xB1"],

        ["\xE7\x94\xB0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC5\xC4"],
        ["\xC5\xC4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\xB0"],

        ["\xE9\x9B\xBB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC5\xC5"],
        ["\xC5\xC5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\xBB"],

        ["\xE5\x85\x8E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC5\xC6"],
        ["\xC5\xC6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\x8E"],

        ["\xE5\x90\x90",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC5\xC7"],
        ["\xC5\xC7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\x90"],

        ["\xE5\xA0\xB5",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC5\xC8"],
        ["\xC5\xC8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA0\xB5"],

        ["\xE5\xA1\x97",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC5\xC9"],
        ["\xC5\xC9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA1\x97"],

        ["\xE5\xA6\xAC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC5\xD1"],
        ["\xC5\xD1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA6\xAC"],

        ["\xE5\xB1\xA0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC5\xD2"],
        ["\xC5\xD2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\xA0"],

        ["\xE5\xBE\x92",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC5\xD3"],
        ["\xC5\xD3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\x92"],

        ["\xE6\x96\x97",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC5\xD4"],
        ["\xC5\xD4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\x97"],

        ["\xE6\x9D\x9C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC5\xD5"],
        ["\xC5\xD5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\x9C"],

        ["\xE6\xB8\xA1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC5\xD6"],
        ["\xC5\xD6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\xA1"],

        ["\xE7\x99\xBB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC5\xD7"],
        ["\xC5\xD7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\xBB"],

        ["\xE8\x8F\x9F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC5\xD8"],
        ["\xC5\xD8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F\x9F"],

        ["\xE8\xB3\xAD",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC5\xD9"],
        ["\xC5\xD9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\xAD"],

        ["\xE9\x80\x94",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC5\xE2"],
        ["\xC5\xE2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\x94"],

        ["\xE9\x83\xBD",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC5\xE3"],
        ["\xC5\xE3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x83\xBD"],

        ["\xE9\x8D\x8D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC5\xE4"],
        ["\xC5\xE4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8D\x8D"],

        ["\xE7\xA0\xA5",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC5\xE5"],
        ["\xC5\xE5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA0\xA5"],

        ["\xE7\xA0\xBA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x59\x69"],
        ["\x59\x69",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA0\xBA"],

        ["\xE5\x8A\xAA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC5\xE7"],
        ["\xC5\xE7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\xAA"],

        ["\xE5\xBA\xA6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC5\xE8"],
        ["\xC5\xE8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBA\xA6"],

        ["\xE5\x9C\x9F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC5\xE9"],
        ["\xC5\xE9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C\x9F"],

        ["\xE5\xA5\xB4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC5\x4A"],
        ["\xC5\x4A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\xB4"],

        ["\xE6\x80\x92",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC5\x5B"],
        ["\xC5\x5B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x80\x92"],

        ["\xE5\x80\x92",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC5\x5A"],
        ["\xC5\x5A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\x92"],

        ["\xE5\x85\x9A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC5\x5F"],
        ["\xC5\x5F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\x9A"],

        ["\xE5\x86\xAC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC5\x6D"],
        ["\xC5\x6D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\xAC"],

        ["\xE5\x87\x8D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC5\x79"],
        ["\xC5\x79",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\x8D"],

        ["\xE5\x88\x80",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC5\x57"],
        ["\xC5\x57",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\x80"],

        ["\xE5\x94\x90",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC5\x59"],
        ["\xC5\x59",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x94\x90"],

        ["\xE5\xA1\x94",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC5\x62"],
        ["\xC5\x62",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA1\x94"],

        ["\xE5\xA1\x98",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC5\x63"],
        ["\xC5\x63",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA1\x98"],

        ["\xE5\xA5\x97",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC5\x64"],
        ["\xC5\x64",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\x97"],

        ["\xE5\xAE\x95",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC5\x65"],
        ["\xC5\x65",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\x95"],

        ["\xE5\xB3\xB6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC5\x66"],
        ["\xC5\x66",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB3\xB6"],

        ["\xE5\xB6\x8B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC5\x67"],
        ["\xC5\x67",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB6\x8B"],

        ["\xE6\x82\xBC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC5\x68"],
        ["\xC5\x68",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\xBC"],

        ["\xE6\x8A\x95",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC5\x69"],
        ["\xC5\x69",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A\x95"],

        ["\xE6\x90\xAD",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC5\x70"],
        ["\xC5\x70",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x90\xAD"],

        ["\xE6\x9D\xB1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC5\x71"],
        ["\xC5\x71",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\xB1"],

        ["\xE6\xA1\x83",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC5\x72"],
        ["\xC5\x72",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\x83"],

        ["\xE6\xA2\xBC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4A\x72"],
        ["\x4A\x72",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\xBC"],

        ["\xE6\xA3\x9F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC5\x74"],
        ["\xC5\x74",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\x9F"],

        ["\xE7\x9B\x97",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC5\x75"],
        ["\xC5\x75",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\x97"],

        ["\xE6\xB7\x98",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC5\x76"],
        ["\xC5\x76",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\x98"],

        ["\xE6\xB9\xAF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC5\x77"],
        ["\xC5\x77",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB9\xAF"],

        ["\xE6\xB6\x9B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5F\xF9"],
        ["\x5F\xF9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB6\x9B"],

        ["\xE7\x81\xAF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC5\x80"],
        ["\xC5\x80",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x81\xAF"],

        ["\xE7\x87\x88",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC5\x8B"],
        ["\xC5\x8B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x87\x88"],

        ["\xE5\xBD\x93",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC5\x9B"],
        ["\xC5\x9B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\x93"],

        ["\xE7\x97\x98",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC5\x9C"],
        ["\xC5\x9C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\x98"],

        ["\xE7\xA5\xB7",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC5\xA0"],
        ["\xC5\xA0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5\xB7"],

        ["\xE7\xAD\x89",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC5\xAB"],
        ["\xC5\xAB",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\x89"],

        ["\xE7\xAD\x94",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC5\xB0"],
        ["\xC5\xB0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\x94"],

        ["\xE7\xAD\x92",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC5\xC0"],
        ["\xC5\xC0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\x92"],

        ["\xE7\xB3\x96",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC5\x6A"],
        ["\xC5\x6A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3\x96"],

        ["\xE7\xB5\xB1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC5\xD0"],
        ["\xC5\xD0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\xB1"],

        ["\xE5\x88\xB0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC5\xA1"],
        ["\xC5\xA1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\xB0"],

        ["\xE8\x91\xA3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC6\x4F"],
        ["\xC6\x4F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x91\xA3"],

        ["\xE8\x95\xA9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC6\x7F"],
        ["\xC6\x7F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x95\xA9"],

        ["\xE8\x97\xA4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC6\x7B"],
        ["\xC6\x7B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x97\xA4"],

        ["\xE8\xA8\x8E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC6\xE0"],
        ["\xC6\xE0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\x8E"],

        ["\xE8\xAC\x84",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC6\x6C"],
        ["\xC6\x6C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC\x84"],

        ["\xE8\xB1\x86",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC6\x50"],
        ["\xC6\x50",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB1\x86"],

        ["\xE8\xB8\x8F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC6\x7D"],
        ["\xC6\x7D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB8\x8F"],

        ["\xE9\x80\x83",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC6\x4D"],
        ["\xC6\x4D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\x83"],

        ["\xE9\x80\x8F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC6\x5D"],
        ["\xC6\x5D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\x8F"],

        ["\xE9\x90\x99",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC6\x5C"],
        ["\xC6\x5C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x90\x99"],

        ["\xE9\x99\xB6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC6\x4E"],
        ["\xC6\x4E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x99\xB6"],

        ["\xE9\xA0\xAD",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC6\x6B"],
        ["\xC6\x6B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0\xAD"],

        ["\xE9\xA8\xB0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC6\x60"],
        ["\xC6\x60",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA8\xB0"],

        ["\xE9\x97\x98",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC6\x4B"],
        ["\xC6\x4B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x97\x98"],

        ["\xE5\x83\x8D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC6\x61"],
        ["\xC6\x61",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x83\x8D"],

        ["\xE5\x8B\x95",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC6\xF0"],
        ["\xC6\xF0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\x95"],

        ["\xE5\x90\x8C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC6\xF1"],
        ["\xC6\xF1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\x8C"],

        ["\xE5\xA0\x82",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC6\xF2"],
        ["\xC6\xF2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA0\x82"],

        ["\xE5\xB0\x8E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC6\xF3"],
        ["\xC6\xF3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\x8E"],

        ["\xE6\x86\xA7",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC6\xF4"],
        ["\xC6\xF4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x86\xA7"],

        ["\xE6\x92\x9E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC6\xF5"],
        ["\xC6\xF5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x92\x9E"],

        ["\xE6\xB4\x9E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC6\xF6"],
        ["\xC6\xF6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4\x9E"],

        ["\xE7\x9E\xB3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC6\xF7"],
        ["\xC6\xF7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9E\xB3"],

        ["\xE7\xAB\xA5",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC6\xF8"],
        ["\xC6\xF8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\xA5"],

        ["\xE8\x83\xB4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC6\xF9"],
        ["\xC6\xF9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x83\xB4"],

        ["\xE8\x90\x84",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC6\x7A"],
        ["\xC6\x7A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x90\x84"],

        ["\xE9\x81\x93",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC6\x5E"],
        ["\xC6\x5E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\x93"],

        ["\xE9\x8A\x85",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC6\x4C"],
        ["\xC6\x4C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8A\x85"],

        ["\xE5\xB3\xA0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC6\x7E"],
        ["\xC6\x7E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB3\xA0"],

        ["\xE9\xB4\x87",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC6\x6E"],
        ["\xC6\x6E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB4\x87"],

        ["\xE5\x8C\xBF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC6\x6F"],
        ["\xC6\x6F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\xBF"],

        ["\xE5\xBE\x97",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC6\x7C"],
        ["\xC6\x7C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\x97"],

        ["\xE5\xBE\xB3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC6\xC1"],
        ["\xC6\xC1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\xB3"],

        ["\xE6\xB6\x9C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC6\xC2"],
        ["\xC6\xC2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB6\x9C"],

        ["\xE7\x89\xB9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC6\xC3"],
        ["\xC6\xC3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x89\xB9"],

        ["\xE7\x9D\xA3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC6\xC4"],
        ["\xC6\xC4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9D\xA3"],

        ["\xE7\xA6\xBF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC6\xC5"],
        ["\xC6\xC5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6\xBF"],

        ["\xE7\xAF\xA4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC6\xC6"],
        ["\xC6\xC6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAF\xA4"],

        ["\xE6\xAF\x92",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC6\xC7"],
        ["\xC6\xC7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAF\x92"],

        ["\xE7\x8B\xAC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC6\xC8"],
        ["\xC6\xC8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8B\xAC"],

        ["\xE8\xAA\xAD",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC6\xC9"],
        ["\xC6\xC9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\xAD"],

        ["\xE6\xA0\x83",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC6\xD1"],
        ["\xC6\xD1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA0\x83"],

        ["\xE6\xA9\xA1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC6\xD2"],
        ["\xC6\xD2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA9\xA1"],

        ["\xE5\x87\xB8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC6\xD3"],
        ["\xC6\xD3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\xB8"],

        ["\xE7\xAA\x81",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC6\xD4"],
        ["\xC6\xD4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAA\x81"],

        ["\xE6\xA4\xB4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC6\xD5"],
        ["\xC6\xD5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\xB4"],

        ["\xE5\xB1\x8A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC6\xD6"],
        ["\xC6\xD6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\x8A"],

        ["\xE9\xB3\xB6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC6\xD7"],
        ["\xC6\xD7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB3\xB6"],

        ["\xE8\x8B\xAB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC6\xD8"],
        ["\xC6\xD8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8B\xAB"],

        ["\xE5\xAF\x85",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC6\xD9"],
        ["\xC6\xD9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\x85"],

        ["\xE9\x85\x89",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC6\xE2"],
        ["\xC6\xE2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x85\x89"],

        ["\xE7\x80\x9E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC6\xE3"],
        ["\xC6\xE3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x80\x9E"],

        ["\xE5\x99\xB8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC6\xE4"],
        ["\xC6\xE4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x99\xB8"],

        ["\xE5\xB1\xAF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC6\xE5"],
        ["\xC6\xE5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\xAF"],

        ["\xE6\x83\x87",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC6\xE6"],
        ["\xC6\xE6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\x87"],

        ["\xE6\x95\xA6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC6\xE7"],
        ["\xC6\xE7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x95\xA6"],

        ["\xE6\xB2\x8C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC6\xE8"],
        ["\xC6\xE8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\x8C"],

        ["\xE8\xB1\x9A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC6\xE9"],
        ["\xC6\xE9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB1\x9A"],

        ["\xE9\x81\x81",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC6\x4A"],
        ["\xC6\x4A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\x81"],

        ["\xE9\xA0\x93",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC6\x5B"],
        ["\xC6\x5B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0\x93"],

        ["\xE5\x91\x91",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC6\x5A"],
        ["\xC6\x5A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x91\x91"],

        ["\xE6\x9B\x87",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC6\x5F"],
        ["\xC6\x5F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\x87"],

        ["\xE9\x88\x8D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC6\x6D"],
        ["\xC6\x6D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x88\x8D"],

        ["\xE5\xA5\x88",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC6\x79"],
        ["\xC6\x79",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\x88"],

        ["\xE9\x82\xA3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC6\x57"],
        ["\xC6\x57",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x82\xA3"],

        ["\xE5\x86\x85",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC6\x59"],
        ["\xC6\x59",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\x85"],

        ["\xE4\xB9\x8D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC6\x62"],
        ["\xC6\x62",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xB9\x8D"],

        ["\xE5\x87\xAA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC6\x63"],
        ["\xC6\x63",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\xAA"],

        ["\xE8\x96\x99",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC6\x64"],
        ["\xC6\x64",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\x99"],

        ["\xE8\xAC\x8E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC6\x65"],
        ["\xC6\x65",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC\x8E"],

        ["\xE7\x81\x98",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC6\x66"],
        ["\xC6\x66",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x81\x98"],

        ["\xE6\x8D\xBA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC6\x67"],
        ["\xC6\x67",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8D\xBA"],

        ["\xE9\x8D\x8B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC6\x68"],
        ["\xC6\x68",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8D\x8B"],

        ["\xE6\xA5\xA2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC6\x69"],
        ["\xC6\x69",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\xA2"],

        ["\xE9\xA6\xB4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC6\x70"],
        ["\xC6\x70",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA6\xB4"],

        ["\xE7\xB8\x84",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC6\x71"],
        ["\xC6\x71",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\x84"],

        ["\xE7\x95\xB7",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC6\x72"],
        ["\xC6\x72",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\xB7"],

        ["\xE5\x8D\x97",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC6\x73"],
        ["\xC6\x73",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\x97"],

        ["\xE6\xA5\xA0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC6\x74"],
        ["\xC6\x74",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\xA0"],

        ["\xE8\xBB\x9F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC6\x75"],
        ["\xC6\x75",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBB\x9F"],

        ["\xE9\x9B\xA3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC6\x76"],
        ["\xC6\x76",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\xA3"],

        ["\xE6\xB1\x9D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC6\x77"],
        ["\xC6\x77",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1\x9D"],

        ["\xE4\xBA\x8C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC6\x78"],
        ["\xC6\x78",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\x8C"],

        ["\xE5\xB0\xBC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC6\x80"],
        ["\xC6\x80",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\xBC"],

        ["\xE5\xBC\x90",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC6\x8B"],
        ["\xC6\x8B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\x90"],

        ["\xE8\xBF\xA9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x72\x73"],
        ["\x72\x73",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF\xA9"],

        ["\xE5\x8C\x82",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC6\x9C"],
        ["\xC6\x9C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\x82"],

        ["\xE8\xB3\x91",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC6\xA0"],
        ["\xC6\xA0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\x91"],

        ["\xE8\x82\x89",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC6\xAB"],
        ["\xC6\xAB",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x82\x89"],

        ["\xE8\x99\xB9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC6\xB0"],
        ["\xC6\xB0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x99\xB9"],

        ["\xE5\xBB\xBF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC6\xC0"],
        ["\xC6\xC0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\xBF"],

        ["\xE6\x97\xA5",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC6\x6A"],
        ["\xC6\x6A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\xA5"],

        ["\xE4\xB9\xB3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC6\xD0"],
        ["\xC6\xD0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xB9\xB3"],

        ["\xE5\x85\xA5",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC6\xA1"],
        ["\xC6\xA1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\xA5"],

        ["\xE5\xA6\x82",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC7\x4F"],
        ["\xC7\x4F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA6\x82"],

        ["\xE5\xB0\xBF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC7\x7F"],
        ["\xC7\x7F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\xBF"],

        ["\xE9\x9F\xAE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC7\x7B"],
        ["\xC7\x7B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9F\xAE"],

        ["\xE4\xBB\xBB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC7\xE0"],
        ["\xC7\xE0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\xBB"],

        ["\xE5\xA6\x8A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC7\x6C"],
        ["\xC7\x6C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA6\x8A"],

        ["\xE5\xBF\x8D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC7\x50"],
        ["\xC7\x50",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF\x8D"],

        ["\xE8\xAA\x8D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC7\x7D"],
        ["\xC7\x7D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\x8D"],

        ["\xE6\xBF\xA1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC7\x4D"],
        ["\xC7\x4D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF\xA1"],

        ["\xE7\xA6\xB0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC7\x5D"],
        ["\xC7\x5D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6\xB0"],

        ["\xE7\xA5\xA2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC7\x5C"],
        ["\xC7\x5C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5\xA2"],

        ["\xE5\xAF\xA7",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC7\x4E"],
        ["\xC7\x4E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\xA7"],

        ["\xE8\x91\xB1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC7\x6B"],
        ["\xC7\x6B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x91\xB1"],

        ["\xE7\x8C\xAB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC7\x60"],
        ["\xC7\x60",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8C\xAB"],

        ["\xE7\x86\xB1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC7\x4B"],
        ["\xC7\x4B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x86\xB1"],

        ["\xE5\xB9\xB4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC7\x61"],
        ["\xC7\x61",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\xB4"],

        ["\xE5\xBF\xB5",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC7\xF0"],
        ["\xC7\xF0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF\xB5"],

        ["\xE6\x8D\xBB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC7\xF1"],
        ["\xC7\xF1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8D\xBB"],

        ["\xE6\x92\x9A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC7\xF2"],
        ["\xC7\xF2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x92\x9A"],

        ["\xE7\x87\x83",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC7\xF3"],
        ["\xC7\xF3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x87\x83"],

        ["\xE7\xB2\x98",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC7\xF4"],
        ["\xC7\xF4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\x98"],

        ["\xE4\xB9\x83",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC7\xF5"],
        ["\xC7\xF5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xB9\x83"],

        ["\xE5\xBB\xBC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC7\xF6"],
        ["\xC7\xF6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\xBC"],

        ["\xE4\xB9\x8B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC7\xF7"],
        ["\xC7\xF7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xB9\x8B"],

        ["\xE5\x9F\x9C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC7\xF8"],
        ["\xC7\xF8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9F\x9C"],

        ["\xE5\x9A\xA2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC7\xF9"],
        ["\xC7\xF9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9A\xA2"],

        ["\xE6\x82\xA9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC7\x7A"],
        ["\xC7\x7A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\xA9"],

        ["\xE6\xBF\x83",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC7\x5E"],
        ["\xC7\x5E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF\x83"],

        ["\xE7\xB4\x8D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC7\x4C"],
        ["\xC7\x4C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\x8D"],

        ["\xE8\x83\xBD",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC7\x7E"],
        ["\xC7\x7E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x83\xBD"],

        ["\xE8\x84\xB3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC7\x6E"],
        ["\xC7\x6E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x84\xB3"],

        ["\xE8\x86\xBF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC7\x6F"],
        ["\xC7\x6F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x86\xBF"],

        ["\xE8\xBE\xB2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC7\x7C"],
        ["\xC7\x7C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBE\xB2"],

        ["\xE8\xA6\x97",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC7\xC1"],
        ["\xC7\xC1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\x97"],

        ["\xE8\x9A\xA4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC7\xC2"],
        ["\xC7\xC2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9A\xA4"],

        ["\xE5\xB7\xB4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC7\xC3"],
        ["\xC7\xC3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\xB4"],

        ["\xE6\x8A\x8A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC7\xC4"],
        ["\xC7\xC4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A\x8A"],

        ["\xE6\x92\xAD",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC7\xC5"],
        ["\xC7\xC5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x92\xAD"],

        ["\xE8\xA6\x87",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC7\xC6"],
        ["\xC7\xC6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\x87"],

        ["\xE6\x9D\xB7",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC7\xC7"],
        ["\xC7\xC7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\xB7"],

        ["\xE6\xB3\xA2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC7\xC8"],
        ["\xC7\xC8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\xA2"],

        ["\xE6\xB4\xBE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC7\xC9"],
        ["\xC7\xC9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4\xBE"],

        ["\xE7\x90\xB6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC7\xD1"],
        ["\xC7\xD1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x90\xB6"],

        ["\xE7\xA0\xB4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC7\xD2"],
        ["\xC7\xD2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA0\xB4"],

        ["\xE5\xA9\x86",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC7\xD3"],
        ["\xC7\xD3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA9\x86"],

        ["\xE7\xBD\xB5",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC7\xD4"],
        ["\xC7\xD4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\xB5"],

        ["\xE8\x8A\xAD",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC7\xD5"],
        ["\xC7\xD5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8A\xAD"],

        ["\xE9\xA6\xAC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC7\xD6"],
        ["\xC7\xD6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA6\xAC"],

        ["\xE4\xBF\xB3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC7\xD7"],
        ["\xC7\xD7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\xB3"],

        ["\xE5\xBB\x83",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC7\xD8"],
        ["\xC7\xD8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\x83"],

        ["\xE6\x8B\x9D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC7\xD9"],
        ["\xC7\xD9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\x9D"],

        ["\xE6\x8E\x92",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC7\xE2"],
        ["\xC7\xE2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\x92"],

        ["\xE6\x95\x97",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC7\xE3"],
        ["\xC7\xE3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x95\x97"],

        ["\xE6\x9D\xAF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC7\xE4"],
        ["\xC7\xE4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\xAF"],

        ["\xE7\x9B\x83",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC7\xE5"],
        ["\xC7\xE5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\x83"],

        ["\xE7\x89\x8C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC7\xE6"],
        ["\xC7\xE6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x89\x8C"],

        ["\xE8\x83\x8C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC7\xE7"],
        ["\xC7\xE7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x83\x8C"],

        ["\xE8\x82\xBA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC7\xE8"],
        ["\xC7\xE8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x82\xBA"],

        ["\xE8\xBC\xA9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC7\xE9"],
        ["\xC7\xE9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC\xA9"],

        ["\xE9\x85\x8D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC7\x4A"],
        ["\xC7\x4A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x85\x8D"],

        ["\xE5\x80\x8D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC7\x5B"],
        ["\xC7\x5B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\x8D"],

        ["\xE5\x9F\xB9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC7\x5A"],
        ["\xC7\x5A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9F\xB9"],

        ["\xE5\xAA\x92",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC7\x5F"],
        ["\xC7\x5F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAA\x92"],

        ["\xE6\xA2\x85",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC7\x6D"],
        ["\xC7\x6D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\x85"],

        ["\xE6\xA5\xB3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC7\x79"],
        ["\xC7\x79",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\xB3"],

        ["\xE7\x85\xA4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC7\x57"],
        ["\xC7\x57",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x85\xA4"],

        ["\xE7\x8B\xBD",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC7\x59"],
        ["\xC7\x59",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8B\xBD"],

        ["\xE8\xB2\xB7",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC7\x62"],
        ["\xC7\x62",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\xB7"],

        ["\xE5\xA3\xB2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC7\x63"],
        ["\xC7\x63",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\xB2"],

        ["\xE8\xB3\xA0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC7\x64"],
        ["\xC7\x64",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\xA0"],

        ["\xE9\x99\xAA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC7\x65"],
        ["\xC7\x65",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x99\xAA"],

        ["\xE9\x80\x99",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC7\x66"],
        ["\xC7\x66",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\x99"],

        ["\xE8\x9D\xBF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x69\xE0"],
        ["\x69\xE0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9D\xBF"],

        ["\xE7\xA7\xA4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC7\x68"],
        ["\xC7\x68",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA7\xA4"],

        ["\xE7\x9F\xA7",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC7\x69"],
        ["\xC7\x69",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9F\xA7"],

        ["\xE8\x90\xA9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC7\x70"],
        ["\xC7\x70",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x90\xA9"],

        ["\xE4\xBC\xAF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC7\x71"],
        ["\xC7\x71",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBC\xAF"],

        ["\xE5\x89\xA5",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC7\x72"],
        ["\xC7\x72",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\xA5"],

        ["\xE5\x8D\x9A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC7\x73"],
        ["\xC7\x73",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\x9A"],

        ["\xE6\x8B\x8D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC7\x74"],
        ["\xC7\x74",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\x8D"],

        ["\xE6\x9F\x8F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC7\x75"],
        ["\xC7\x75",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\x8F"],

        ["\xE6\xB3\x8A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC7\x76"],
        ["\xC7\x76",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\x8A"],

        ["\xE7\x99\xBD",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC7\x77"],
        ["\xC7\x77",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\xBD"],

        ["\xE7\xAE\x94",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC7\x78"],
        ["\xC7\x78",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAE\x94"],

        ["\xE7\xB2\x95",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC7\x80"],
        ["\xC7\x80",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\x95"],

        ["\xE8\x88\xB6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC7\x8B"],
        ["\xC7\x8B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\xB6"],

        ["\xE8\x96\x84",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC7\x9B"],
        ["\xC7\x9B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\x84"],

        ["\xE8\xBF\xAB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC7\x9C"],
        ["\xC7\x9C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF\xAB"],

        ["\xE6\x9B\x9D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC7\xA0"],
        ["\xC7\xA0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\x9D"],

        ["\xE6\xBC\xA0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC7\xAB"],
        ["\xC7\xAB",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBC\xA0"],

        ["\xE7\x88\x86",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC7\xB0"],
        ["\xC7\xB0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x88\x86"],

        ["\xE7\xB8\x9B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC7\xC0"],
        ["\xC7\xC0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\x9B"],

        ["\xE8\x8E\xAB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC7\x6A"],
        ["\xC7\x6A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8E\xAB"],

        ["\xE9\xA7\x81",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC7\xD0"],
        ["\xC7\xD0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA7\x81"],

        ["\xE9\xBA\xA6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC7\xA1"],
        ["\xC7\xA1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xBA\xA6"],

        ["\xE5\x87\xBD",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC8\x4F"],
        ["\xC8\x4F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\xBD"],

        ["\xE7\xAE\xB1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC8\x7F"],
        ["\xC8\x7F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAE\xB1"],

        ["\xE7\xA1\xB2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC8\x7B"],
        ["\xC8\x7B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA1\xB2"],

        ["\xE7\xAE\xB8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC8\xE0"],
        ["\xC8\xE0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAE\xB8"],

        ["\xE8\x82\x87",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC8\x6C"],
        ["\xC8\x6C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x82\x87"],

        ["\xE7\xAD\x88",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC8\x50"],
        ["\xC8\x50",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\x88"],

        ["\xE6\xAB\xA8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC8\x7D"],
        ["\xC8\x7D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAB\xA8"],

        ["\xE5\xB9\xA1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC8\x4D"],
        ["\xC8\x4D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\xA1"],

        ["\xE8\x82\x8C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC8\x5D"],
        ["\xC8\x5D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x82\x8C"],

        ["\xE7\x95\x91",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC8\x5C"],
        ["\xC8\x5C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\x91"],

        ["\xE7\x95\xA0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC8\x4E"],
        ["\xC8\x4E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\xA0"],

        ["\xE5\x85\xAB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC8\x6B"],
        ["\xC8\x6B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\xAB"],

        ["\xE9\x89\xA2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC8\x60"],
        ["\xC8\x60",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x89\xA2"],

        ["\xE6\xBA\x8C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC8\x4B"],
        ["\xC8\x4B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBA\x8C"],

        ["\xE7\x99\xBA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC8\x61"],
        ["\xC8\x61",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\xBA"],

        ["\xE9\x86\x97",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC8\xF0"],
        ["\xC8\xF0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x86\x97"],

        ["\xE9\xAB\xAA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC8\xF1"],
        ["\xC8\xF1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xAB\xAA"],

        ["\xE4\xBC\x90",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC8\xF2"],
        ["\xC8\xF2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBC\x90"],

        ["\xE7\xBD\xB0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC8\xF3"],
        ["\xC8\xF3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\xB0"],

        ["\xE6\x8A\x9C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC8\xF4"],
        ["\xC8\xF4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A\x9C"],

        ["\xE7\xAD\x8F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC8\xF5"],
        ["\xC8\xF5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\x8F"],

        ["\xE9\x96\xA5",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC8\xF6"],
        ["\xC8\xF6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\xA5"],

        ["\xE9\xB3\xA9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC8\xF7"],
        ["\xC8\xF7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB3\xA9"],

        ["\xE5\x99\xBA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC8\xF8"],
        ["\xC8\xF8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x99\xBA"],

        ["\xE5\xA1\x99",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC8\xF9"],
        ["\xC8\xF9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA1\x99"],

        ["\xE8\x9B\xA4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC8\x7A"],
        ["\xC8\x7A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9B\xA4"],

        ["\xE9\x9A\xBC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC8\x5E"],
        ["\xC8\x5E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\xBC"],

        ["\xE4\xBC\xB4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC8\x4C"],
        ["\xC8\x4C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBC\xB4"],

        ["\xE5\x88\xA4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC8\x7E"],
        ["\xC8\x7E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\xA4"],

        ["\xE5\x8D\x8A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC8\x6E"],
        ["\xC8\x6E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\x8A"],

        ["\xE5\x8F\x8D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC8\x6F"],
        ["\xC8\x6F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\x8D"],

        ["\xE5\x8F\x9B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC8\x7C"],
        ["\xC8\x7C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\x9B"],

        ["\xE5\xB8\x86",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC8\xC1"],
        ["\xC8\xC1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8\x86"],

        ["\xE6\x90\xAC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC8\xC2"],
        ["\xC8\xC2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x90\xAC"],

        ["\xE6\x96\x91",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC8\xC3"],
        ["\xC8\xC3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\x91"],

        ["\xE6\x9D\xBF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC8\xC4"],
        ["\xC8\xC4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\xBF"],

        ["\xE6\xB0\xBE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC8\xC5"],
        ["\xC8\xC5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB0\xBE"],

        ["\xE6\xB1\x8E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC8\xC6"],
        ["\xC8\xC6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1\x8E"],

        ["\xE7\x89\x88",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC8\xC7"],
        ["\xC8\xC7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x89\x88"],

        ["\xE7\x8A\xAF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC8\xC8"],
        ["\xC8\xC8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8A\xAF"],

        ["\xE7\x8F\xAD",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC8\xC9"],
        ["\xC8\xC9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8F\xAD"],

        ["\xE7\x95\x94",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC8\xD1"],
        ["\xC8\xD1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\x94"],

        ["\xE7\xB9\x81",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC8\xD2"],
        ["\xC8\xD2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\x81"],

        ["\xE8\x88\xAC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC8\xD3"],
        ["\xC8\xD3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\xAC"],

        ["\xE8\x97\xA9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC8\xD4"],
        ["\xC8\xD4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x97\xA9"],

        ["\xE8\xB2\xA9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC8\xD5"],
        ["\xC8\xD5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\xA9"],

        ["\xE7\xAF\x84",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC8\xD6"],
        ["\xC8\xD6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAF\x84"],

        ["\xE9\x87\x86",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC8\xD7"],
        ["\xC8\xD7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\x86"],

        ["\xE7\x85\xA9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC8\xD8"],
        ["\xC8\xD8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x85\xA9"],

        ["\xE9\xA0\x92",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC8\xD9"],
        ["\xC8\xD9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0\x92"],

        ["\xE9\xA3\xAF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC8\xE2"],
        ["\xC8\xE2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA3\xAF"],

        ["\xE6\x8C\xBD",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC8\xE3"],
        ["\xC8\xE3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8C\xBD"],

        ["\xE6\x99\xA9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC8\xE4"],
        ["\xC8\xE4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\xA9"],

        ["\xE7\x95\xAA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC8\xE5"],
        ["\xC8\xE5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\xAA"],

        ["\xE7\x9B\xA4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC8\xE6"],
        ["\xC8\xE6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\xA4"],

        ["\xE7\xA3\x90",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC8\xE7"],
        ["\xC8\xE7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA3\x90"],

        ["\xE8\x95\x83",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC8\xE8"],
        ["\xC8\xE8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x95\x83"],

        ["\xE8\x9B\xAE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC8\xE9"],
        ["\xC8\xE9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9B\xAE"],

        ["\xE5\x8C\xAA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC8\x4A"],
        ["\xC8\x4A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\xAA"],

        ["\xE5\x8D\x91",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC8\x5B"],
        ["\xC8\x5B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\x91"],

        ["\xE5\x90\xA6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC8\x5A"],
        ["\xC8\x5A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\xA6"],

        ["\xE5\xA6\x83",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC8\x5F"],
        ["\xC8\x5F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA6\x83"],

        ["\xE5\xBA\x87",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC8\x6D"],
        ["\xC8\x6D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBA\x87"],

        ["\xE5\xBD\xBC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC8\x79"],
        ["\xC8\x79",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\xBC"],

        ["\xE6\x82\xB2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC8\x57"],
        ["\xC8\x57",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\xB2"],

        ["\xE6\x89\x89",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC8\x59"],
        ["\xC8\x59",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\x89"],

        ["\xE6\x89\xB9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC8\x62"],
        ["\xC8\x62",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\xB9"],

        ["\xE6\x8A\xAB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC8\x63"],
        ["\xC8\x63",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A\xAB"],

        ["\xE6\x96\x90",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC8\x64"],
        ["\xC8\x64",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\x90"],

        ["\xE6\xAF\x94",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC8\x65"],
        ["\xC8\x65",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAF\x94"],

        ["\xE6\xB3\x8C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC8\x66"],
        ["\xC8\x66",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\x8C"],

        ["\xE7\x96\xB2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC8\x67"],
        ["\xC8\x67",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x96\xB2"],

        ["\xE7\x9A\xAE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC8\x68"],
        ["\xC8\x68",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\xAE"],

        ["\xE7\xA2\x91",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC8\x69"],
        ["\xC8\x69",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA2\x91"],

        ["\xE7\xA7\x98",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC8\x70"],
        ["\xC8\x70",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA7\x98"],

        ["\xE7\xB7\x8B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC8\x71"],
        ["\xC8\x71",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7\x8B"],

        ["\xE7\xBD\xB7",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC8\x72"],
        ["\xC8\x72",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\xB7"],

        ["\xE8\x82\xA5",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC8\x73"],
        ["\xC8\x73",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x82\xA5"],

        ["\xE8\xA2\xAB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC8\x74"],
        ["\xC8\x74",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA2\xAB"],

        ["\xE8\xAA\xB9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC8\x75"],
        ["\xC8\x75",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\xB9"],

        ["\xE8\xB2\xBB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC8\x76"],
        ["\xC8\x76",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\xBB"],

        ["\xE9\x81\xBF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC8\x77"],
        ["\xC8\x77",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\xBF"],

        ["\xE9\x9D\x9E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC8\x78"],
        ["\xC8\x78",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9D\x9E"],

        ["\xE9\xA3\x9B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC8\x80"],
        ["\xC8\x80",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA3\x9B"],

        ["\xE6\xA8\x8B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC8\x8B"],
        ["\xC8\x8B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\x8B"],

        ["\xE7\xB0\xB8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC8\x9B"],
        ["\xC8\x9B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB0\xB8"],

        ["\xE5\x82\x99",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC8\x9C"],
        ["\xC8\x9C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x82\x99"],

        ["\xE5\xB0\xBE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC8\xA0"],
        ["\xC8\xA0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\xBE"],

        ["\xE5\xBE\xAE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC8\xAB"],
        ["\xC8\xAB",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\xAE"],

        ["\xE6\x9E\x87",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC8\xB0"],
        ["\xC8\xB0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E\x87"],

        ["\xE6\xAF\x98",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC8\xC0"],
        ["\xC8\xC0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAF\x98"],

        ["\xE7\x90\xB5",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC8\x6A"],
        ["\xC8\x6A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x90\xB5"],

        ["\xE7\x9C\x89",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC8\xD0"],
        ["\xC8\xD0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9C\x89"],

        ["\xE7\xBE\x8E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC8\xA1"],
        ["\xC8\xA1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\x8E"],

        ["\xE9\xBC\xBB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC9\x4F"],
        ["\xC9\x4F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xBC\xBB"],

        ["\xE6\x9F\x8A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC9\x7F"],
        ["\xC9\x7F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\x8A"],

        ["\xE7\xA8\x97",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC9\x7B"],
        ["\xC9\x7B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8\x97"],

        ["\xE5\x8C\xB9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC9\xE0"],
        ["\xC9\xE0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\xB9"],

        ["\xE7\x96\x8B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC9\x6C"],
        ["\xC9\x6C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x96\x8B"],

        ["\xE9\xAB\xAD",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC9\x50"],
        ["\xC9\x50",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xAB\xAD"],

        ["\xE5\xBD\xA6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC9\x7D"],
        ["\xC9\x7D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\xA6"],

        ["\xE8\x86\x9D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC9\x4D"],
        ["\xC9\x4D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x86\x9D"],

        ["\xE8\x8F\xB1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC9\x5D"],
        ["\xC9\x5D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F\xB1"],

        ["\xE8\x82\x98",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC9\x5C"],
        ["\xC9\x5C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x82\x98"],

        ["\xE5\xBC\xBC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC9\x4E"],
        ["\xC9\x4E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\xBC"],

        ["\xE5\xBF\x85",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC9\x6B"],
        ["\xC9\x6B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF\x85"],

        ["\xE7\x95\xA2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC9\x60"],
        ["\xC9\x60",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\xA2"],

        ["\xE7\xAD\x86",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC9\x4B"],
        ["\xC9\x4B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\x86"],

        ["\xE9\x80\xBC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC9\x61"],
        ["\xC9\x61",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\xBC"],

        ["\xE6\xA1\xA7",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4A\xE7"],
        ["\x4A\xE7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\xA7"],

        ["\xE5\xA7\xAB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC9\xF1"],
        ["\xC9\xF1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA7\xAB"],

        ["\xE5\xAA\x9B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC9\xF2"],
        ["\xC9\xF2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAA\x9B"],

        ["\xE7\xB4\x90",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC9\xF3"],
        ["\xC9\xF3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\x90"],

        ["\xE7\x99\xBE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC9\xF4"],
        ["\xC9\xF4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\xBE"],

        ["\xE8\xAC\xAC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC9\xF5"],
        ["\xC9\xF5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC\xAC"],

        ["\xE4\xBF\xB5",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC9\xF6"],
        ["\xC9\xF6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\xB5"],

        ["\xE5\xBD\xAA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC9\xF7"],
        ["\xC9\xF7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\xAA"],

        ["\xE6\xA8\x99",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC9\xF8"],
        ["\xC9\xF8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\x99"],

        ["\xE6\xB0\xB7",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC9\xF9"],
        ["\xC9\xF9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB0\xB7"],

        ["\xE6\xBC\x82",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC9\x7A"],
        ["\xC9\x7A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBC\x82"],

        ["\xE7\x93\xA2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC9\x5E"],
        ["\xC9\x5E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x93\xA2"],

        ["\xE7\xA5\xA8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC9\x4C"],
        ["\xC9\x4C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5\xA8"],

        ["\xE8\xA1\xA8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC9\x7E"],
        ["\xC9\x7E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\xA8"],

        ["\xE8\xA9\x95",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC9\x6E"],
        ["\xC9\x6E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\x95"],

        ["\xE8\xB1\xB9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC9\x6F"],
        ["\xC9\x6F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB1\xB9"],

        ["\xE5\xBB\x9F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC9\x7C"],
        ["\xC9\x7C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\x9F"],

        ["\xE6\x8F\x8F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC9\xC1"],
        ["\xC9\xC1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8F\x8F"],

        ["\xE7\x97\x85",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC9\xC2"],
        ["\xC9\xC2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\x85"],

        ["\xE7\xA7\x92",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC9\xC3"],
        ["\xC9\xC3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA7\x92"],

        ["\xE8\x8B\x97",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC9\xC4"],
        ["\xC9\xC4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8B\x97"],

        ["\xE9\x8C\xA8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC9\xC5"],
        ["\xC9\xC5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8C\xA8"],

        ["\xE9\x8B\xB2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC9\xC6"],
        ["\xC9\xC6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8B\xB2"],

        ["\xE8\x92\x9C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC9\xC7"],
        ["\xC9\xC7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x92\x9C"],

        ["\xE8\x9B\xAD",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC9\xC8"],
        ["\xC9\xC8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9B\xAD"],

        ["\xE9\xB0\xAD",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC9\xC9"],
        ["\xC9\xC9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0\xAD"],

        ["\xE5\x93\x81",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC9\xD1"],
        ["\xC9\xD1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x93\x81"],

        ["\xE5\xBD\xAC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC9\xD2"],
        ["\xC9\xD2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\xAC"],

        ["\xE6\x96\x8C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC9\xD3"],
        ["\xC9\xD3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\x8C"],

        ["\xE6\xB5\x9C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC9\xD4"],
        ["\xC9\xD4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB5\x9C"],

        ["\xE7\x80\x95",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC9\xD5"],
        ["\xC9\xD5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x80\x95"],

        ["\xE8\xB2\xA7",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC9\xD6"],
        ["\xC9\xD6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\xA7"],

        ["\xE8\xB3\x93",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC9\xD7"],
        ["\xC9\xD7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\x93"],

        ["\xE9\xA0\xBB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC9\xD8"],
        ["\xC9\xD8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0\xBB"],

        ["\xE6\x95\x8F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC9\xD9"],
        ["\xC9\xD9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x95\x8F"],

        ["\xE7\x93\xB6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC9\xE2"],
        ["\xC9\xE2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x93\xB6"],

        ["\xE4\xB8\x8D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC9\xE3"],
        ["\xC9\xE3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\x8D"],

        ["\xE4\xBB\x98",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC9\xE4"],
        ["\xC9\xE4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\x98"],

        ["\xE5\x9F\xA0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC9\xE5"],
        ["\xC9\xE5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9F\xA0"],

        ["\xE5\xA4\xAB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC9\xE6"],
        ["\xC9\xE6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\xAB"],

        ["\xE5\xA9\xA6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC9\xE7"],
        ["\xC9\xE7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA9\xA6"],

        ["\xE5\xAF\x8C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC9\xE8"],
        ["\xC9\xE8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\x8C"],

        ["\xE5\x86\xA8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC9\xE9"],
        ["\xC9\xE9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\xA8"],

        ["\xE5\xB8\x83",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC9\x4A"],
        ["\xC9\x4A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8\x83"],

        ["\xE5\xBA\x9C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC9\x5B"],
        ["\xC9\x5B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBA\x9C"],

        ["\xE6\x80\x96",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC9\x5A"],
        ["\xC9\x5A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x80\x96"],

        ["\xE6\x89\xB6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC9\x5F"],
        ["\xC9\x5F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\xB6"],

        ["\xE6\x95\xB7",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC9\x6D"],
        ["\xC9\x6D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x95\xB7"],

        ["\xE6\x96\xA7",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC9\x79"],
        ["\xC9\x79",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\xA7"],

        ["\xE6\x99\xAE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC9\x57"],
        ["\xC9\x57",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\xAE"],

        ["\xE6\xB5\xAE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC9\x59"],
        ["\xC9\x59",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB5\xAE"],

        ["\xE7\x88\xB6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC9\x62"],
        ["\xC9\x62",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x88\xB6"],

        ["\xE7\xAC\xA6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC9\x63"],
        ["\xC9\x63",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC\xA6"],

        ["\xE8\x85\x90",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC9\x64"],
        ["\xC9\x64",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x85\x90"],

        ["\xE8\x86\x9A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC9\x65"],
        ["\xC9\x65",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x86\x9A"],

        ["\xE8\x8A\x99",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC9\x66"],
        ["\xC9\x66",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8A\x99"],

        ["\xE8\xAD\x9C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC9\x67"],
        ["\xC9\x67",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD\x9C"],

        ["\xE8\xB2\xA0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC9\x68"],
        ["\xC9\x68",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\xA0"],

        ["\xE8\xB3\xA6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC9\x69"],
        ["\xC9\x69",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\xA6"],

        ["\xE8\xB5\xB4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC9\x70"],
        ["\xC9\x70",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB5\xB4"],

        ["\xE9\x98\x9C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC9\x71"],
        ["\xC9\x71",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x98\x9C"],

        ["\xE9\x99\x84",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC9\x72"],
        ["\xC9\x72",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x99\x84"],

        ["\xE4\xBE\xAE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC9\x73"],
        ["\xC9\x73",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE\xAE"],

        ["\xE6\x92\xAB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC9\x74"],
        ["\xC9\x74",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x92\xAB"],

        ["\xE6\xAD\xA6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC9\x75"],
        ["\xC9\x75",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\xA6"],

        ["\xE8\x88\x9E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC9\x76"],
        ["\xC9\x76",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\x9E"],

        ["\xE8\x91\xA1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC9\x77"],
        ["\xC9\x77",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x91\xA1"],

        ["\xE8\x95\xAA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC9\x78"],
        ["\xC9\x78",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x95\xAA"],

        ["\xE9\x83\xA8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC9\x80"],
        ["\xC9\x80",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x83\xA8"],

        ["\xE5\xB0\x81",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC9\x8B"],
        ["\xC9\x8B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\x81"],

        ["\xE6\xA5\x93",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC9\x9B"],
        ["\xC9\x9B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\x93"],

        ["\xE9\xA2\xA8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC9\x9C"],
        ["\xC9\x9C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA2\xA8"],

        ["\xE8\x91\xBA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC9\xA0"],
        ["\xC9\xA0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x91\xBA"],

        ["\xE8\x95\x97",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC9\xAB"],
        ["\xC9\xAB",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x95\x97"],

        ["\xE4\xBC\x8F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC9\xB0"],
        ["\xC9\xB0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBC\x8F"],

        ["\xE5\x89\xAF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC9\xC0"],
        ["\xC9\xC0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\xAF"],

        ["\xE5\xBE\xA9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC9\x6A"],
        ["\xC9\x6A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\xA9"],

        ["\xE5\xB9\x85",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC9\xD0"],
        ["\xC9\xD0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\x85"],

        ["\xE6\x9C\x8D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC9\xA1"],
        ["\xC9\xA1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\x8D"],

        ["\xE7\xA6\x8F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD1\x4F"],
        ["\xD1\x4F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6\x8F"],

        ["\xE8\x85\xB9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD1\x7F"],
        ["\xD1\x7F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x85\xB9"],

        ["\xE8\xA4\x87",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD1\x7B"],
        ["\xD1\x7B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA4\x87"],

        ["\xE8\xA6\x86",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD1\xE0"],
        ["\xD1\xE0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\x86"],

        ["\xE6\xB7\xB5",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD1\x6C"],
        ["\xD1\x6C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\xB5"],

        ["\xE5\xBC\x97",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD1\x50"],
        ["\xD1\x50",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\x97"],

        ["\xE6\x89\x95",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD1\x7D"],
        ["\xD1\x7D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\x95"],

        ["\xE6\xB2\xB8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD1\x4D"],
        ["\xD1\x4D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\xB8"],

        ["\xE4\xBB\x8F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD1\x5D"],
        ["\xD1\x5D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\x8F"],

        ["\xE7\x89\xA9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD1\x5C"],
        ["\xD1\x5C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x89\xA9"],

        ["\xE9\xAE\x92",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD1\x4E"],
        ["\xD1\x4E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xAE\x92"],

        ["\xE5\x88\x86",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD1\x6B"],
        ["\xD1\x6B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\x86"],

        ["\xE5\x90\xBB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD1\x60"],
        ["\xD1\x60",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\xBB"],

        ["\xE5\x99\xB4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD1\x4B"],
        ["\xD1\x4B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x99\xB4"],

        ["\xE5\xA2\xB3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD1\x61"],
        ["\xD1\x61",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA2\xB3"],

        ["\xE6\x86\xA4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD1\xF0"],
        ["\xD1\xF0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x86\xA4"],

        ["\xE6\x89\xAE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD1\xF1"],
        ["\xD1\xF1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\xAE"],

        ["\xE7\x84\x9A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD1\xF2"],
        ["\xD1\xF2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x84\x9A"],

        ["\xE5\xA5\xAE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD1\xF3"],
        ["\xD1\xF3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\xAE"],

        ["\xE7\xB2\x89",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD1\xF4"],
        ["\xD1\xF4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\x89"],

        ["\xE7\xB3\x9E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD1\xF5"],
        ["\xD1\xF5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3\x9E"],

        ["\xE7\xB4\x9B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD1\xF6"],
        ["\xD1\xF6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\x9B"],

        ["\xE9\x9B\xB0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD1\xF7"],
        ["\xD1\xF7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\xB0"],

        ["\xE6\x96\x87",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD1\xF8"],
        ["\xD1\xF8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\x87"],

        ["\xE8\x81\x9E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD1\xF9"],
        ["\xD1\xF9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x81\x9E"],

        ["\xE4\xB8\x99",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD1\x7A"],
        ["\xD1\x7A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\x99"],

        ["\xE4\xBD\xB5",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD1\x5E"],
        ["\xD1\x5E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\xB5"],

        ["\xE5\x85\xB5",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD1\x4C"],
        ["\xD1\x4C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\xB5"],

        ["\xE5\xA1\x80",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD1\x7E"],
        ["\xD1\x7E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA1\x80"],

        ["\xE5\xB9\xA3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD1\x6E"],
        ["\xD1\x6E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\xA3"],

        ["\xE5\xB9\xB3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD1\x6F"],
        ["\xD1\x6F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\xB3"],

        ["\xE5\xBC\x8A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD1\x7C"],
        ["\xD1\x7C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\x8A"],

        ["\xE6\x9F\x84",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD1\xC1"],
        ["\xD1\xC1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\x84"],

        ["\xE4\xB8\xA6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD1\xC2"],
        ["\xD1\xC2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\xA6"],

        ["\xE8\x94\xBD",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD1\xC3"],
        ["\xD1\xC3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x94\xBD"],

        ["\xE9\x96\x89",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD1\xC4"],
        ["\xD1\xC4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\x89"],

        ["\xE9\x99\x9B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD1\xC5"],
        ["\xD1\xC5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x99\x9B"],

        ["\xE7\xB1\xB3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD1\xC6"],
        ["\xD1\xC6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB1\xB3"],

        ["\xE9\xA0\x81",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD1\xC7"],
        ["\xD1\xC7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0\x81"],

        ["\xE5\x83\xBB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD1\xC8"],
        ["\xD1\xC8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x83\xBB"],

        ["\xE5\xA3\x81",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD1\xC9"],
        ["\xD1\xC9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\x81"],

        ["\xE7\x99\x96",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD1\xD1"],
        ["\xD1\xD1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\x96"],

        ["\xE7\xA2\xA7",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD1\xD2"],
        ["\xD1\xD2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA2\xA7"],

        ["\xE5\x88\xA5",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD1\xD3"],
        ["\xD1\xD3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\xA5"],

        ["\xE7\x9E\xA5",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD1\xD4"],
        ["\xD1\xD4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9E\xA5"],

        ["\xE8\x94\x91",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD1\xD5"],
        ["\xD1\xD5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x94\x91"],

        ["\xE7\xAE\x86",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD1\xD6"],
        ["\xD1\xD6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAE\x86"],

        ["\xE5\x81\x8F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD1\xD7"],
        ["\xD1\xD7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x81\x8F"],

        ["\xE5\xA4\x89",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD1\xD8"],
        ["\xD1\xD8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\x89"],

        ["\xE7\x89\x87",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD1\xD9"],
        ["\xD1\xD9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x89\x87"],

        ["\xE7\xAF\x87",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD1\xE2"],
        ["\xD1\xE2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAF\x87"],

        ["\xE7\xB7\xA8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD1\xE3"],
        ["\xD1\xE3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7\xA8"],

        ["\xE8\xBE\xBA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD1\xE4"],
        ["\xD1\xE4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBE\xBA"],

        ["\xE8\xBF\x94",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD1\xE5"],
        ["\xD1\xE5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF\x94"],

        ["\xE9\x81\x8D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD1\xE6"],
        ["\xD1\xE6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\x8D"],

        ["\xE4\xBE\xBF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD1\xE7"],
        ["\xD1\xE7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE\xBF"],

        ["\xE5\x8B\x89",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD1\xE8"],
        ["\xD1\xE8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\x89"],

        ["\xE5\xA8\xA9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD1\xE9"],
        ["\xD1\xE9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA8\xA9"],

        ["\xE5\xBC\x81",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD1\x4A"],
        ["\xD1\x4A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\x81"],

        ["\xE9\x9E\xAD",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD1\x5B"],
        ["\xD1\x5B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9E\xAD"],

        ["\xE4\xBF\x9D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD1\x5A"],
        ["\xD1\x5A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\x9D"],

        ["\xE8\x88\x97",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD1\x5F"],
        ["\xD1\x5F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\x97"],

        ["\xE9\x8B\xAA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD1\x6D"],
        ["\xD1\x6D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8B\xAA"],

        ["\xE5\x9C\x83",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD1\x79"],
        ["\xD1\x79",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C\x83"],

        ["\xE6\x8D\x95",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD1\x57"],
        ["\xD1\x57",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8D\x95"],

        ["\xE6\xAD\xA9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD1\x59"],
        ["\xD1\x59",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\xA9"],

        ["\xE7\x94\xAB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD1\x62"],
        ["\xD1\x62",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\xAB"],

        ["\xE8\xA3\x9C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD1\x63"],
        ["\xD1\x63",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\x9C"],

        ["\xE8\xBC\x94",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD1\x64"],
        ["\xD1\x64",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC\x94"],

        ["\xE7\xA9\x82",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD1\x65"],
        ["\xD1\x65",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\x82"],

        ["\xE5\x8B\x9F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD1\x66"],
        ["\xD1\x66",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\x9F"],

        ["\xE5\xA2\x93",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD1\x67"],
        ["\xD1\x67",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA2\x93"],

        ["\xE6\x85\x95",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD1\x68"],
        ["\xD1\x68",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\x95"],

        ["\xE6\x88\x8A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD1\x69"],
        ["\xD1\x69",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\x8A"],

        ["\xE6\x9A\xAE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD1\x70"],
        ["\xD1\x70",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A\xAE"],

        ["\xE6\xAF\x8D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD1\x71"],
        ["\xD1\x71",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAF\x8D"],

        ["\xE7\xB0\xBF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD1\x72"],
        ["\xD1\x72",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB0\xBF"],

        ["\xE8\x8F\xA9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD1\x73"],
        ["\xD1\x73",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F\xA9"],

        ["\xE5\x80\xA3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD1\x74"],
        ["\xD1\x74",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\xA3"],

        ["\xE4\xBF\xB8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD1\x75"],
        ["\xD1\x75",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\xB8"],

        ["\xE5\x8C\x85",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD1\x76"],
        ["\xD1\x76",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\x85"],

        ["\xE5\x91\x86",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD1\x77"],
        ["\xD1\x77",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x91\x86"],

        ["\xE5\xA0\xB1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD1\x78"],
        ["\xD1\x78",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA0\xB1"],

        ["\xE5\xA5\x89",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD1\x80"],
        ["\xD1\x80",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\x89"],

        ["\xE5\xAE\x9D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD1\x8B"],
        ["\xD1\x8B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\x9D"],

        ["\xE5\xB3\xB0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD1\x9B"],
        ["\xD1\x9B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB3\xB0"],

        ["\xE5\xB3\xAF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD1\x9C"],
        ["\xD1\x9C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB3\xAF"],

        ["\xE5\xB4\xA9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD1\xA0"],
        ["\xD1\xA0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB4\xA9"],

        ["\xE5\xBA\x96",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD1\xAB"],
        ["\xD1\xAB",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBA\x96"],

        ["\xE6\x8A\xB1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD1\xB0"],
        ["\xD1\xB0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A\xB1"],

        ["\xE6\x8D\xA7",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD1\xC0"],
        ["\xD1\xC0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8D\xA7"],

        ["\xE6\x94\xBE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD1\x6A"],
        ["\xD1\x6A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x94\xBE"],

        ["\xE6\x96\xB9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD1\xD0"],
        ["\xD1\xD0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\xB9"],

        ["\xE6\x9C\x8B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD1\xA1"],
        ["\xD1\xA1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\x8B"],

        ["\xE6\xB3\x95",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD2\x4F"],
        ["\xD2\x4F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\x95"],

        ["\xE6\xB3\xA1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD2\x7F"],
        ["\xD2\x7F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\xA1"],

        ["\xE7\x83\xB9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD2\x7B"],
        ["\xD2\x7B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x83\xB9"],

        ["\xE7\xA0\xB2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD2\xE0"],
        ["\xD2\xE0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA0\xB2"],

        ["\xE7\xB8\xAB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD2\x6C"],
        ["\xD2\x6C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\xAB"],

        ["\xE8\x83\x9E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD2\x50"],
        ["\xD2\x50",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x83\x9E"],

        ["\xE8\x8A\xB3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD2\x7D"],
        ["\xD2\x7D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8A\xB3"],

        ["\xE8\x90\x8C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD2\x4D"],
        ["\xD2\x4D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x90\x8C"],

        ["\xE8\x93\xAC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD2\x5D"],
        ["\xD2\x5D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x93\xAC"],

        ["\xE8\x9C\x82",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD2\x5C"],
        ["\xD2\x5C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9C\x82"],

        ["\xE8\xA4\x92",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD2\x4E"],
        ["\xD2\x4E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA4\x92"],

        ["\xE8\xA8\xAA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD2\x6B"],
        ["\xD2\x6B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\xAA"],

        ["\xE8\xB1\x8A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD2\x60"],
        ["\xD2\x60",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB1\x8A"],

        ["\xE9\x82\xA6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD2\x4B"],
        ["\xD2\x4B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x82\xA6"],

        ["\xE9\x8B\x92",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD2\x61"],
        ["\xD2\x61",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8B\x92"],

        ["\xE9\xA3\xBD",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD2\xF0"],
        ["\xD2\xF0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA3\xBD"],

        ["\xE9\xB3\xB3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD2\xF1"],
        ["\xD2\xF1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB3\xB3"],

        ["\xE9\xB5\xAC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD2\xF2"],
        ["\xD2\xF2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB5\xAC"],

        ["\xE4\xB9\x8F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD2\xF3"],
        ["\xD2\xF3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xB9\x8F"],

        ["\xE4\xBA\xA1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD2\xF4"],
        ["\xD2\xF4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\xA1"],

        ["\xE5\x82\x8D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD2\xF5"],
        ["\xD2\xF5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x82\x8D"],

        ["\xE5\x89\x96",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD2\xF6"],
        ["\xD2\xF6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\x96"],

        ["\xE5\x9D\x8A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD2\xF7"],
        ["\xD2\xF7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9D\x8A"],

        ["\xE5\xA6\xA8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD2\xF8"],
        ["\xD2\xF8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA6\xA8"],

        ["\xE5\xB8\xBD",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD2\xF9"],
        ["\xD2\xF9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8\xBD"],

        ["\xE5\xBF\x98",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD2\x7A"],
        ["\xD2\x7A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF\x98"],

        ["\xE5\xBF\x99",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD2\x5E"],
        ["\xD2\x5E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF\x99"],

        ["\xE6\x88\xBF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD2\x4C"],
        ["\xD2\x4C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\xBF"],

        ["\xE6\x9A\xB4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD2\x7E"],
        ["\xD2\x7E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A\xB4"],

        ["\xE6\x9C\x9B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD2\x6E"],
        ["\xD2\x6E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\x9B"],

        ["\xE6\x9F\x90",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD2\x6F"],
        ["\xD2\x6F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\x90"],

        ["\xE6\xA3\x92",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD2\x7C"],
        ["\xD2\x7C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\x92"],

        ["\xE5\x86\x92",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD2\xC1"],
        ["\xD2\xC1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\x92"],

        ["\xE7\xB4\xA1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD2\xC2"],
        ["\xD2\xC2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\xA1"],

        ["\xE8\x82\xAA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD2\xC3"],
        ["\xD2\xC3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x82\xAA"],

        ["\xE8\x86\xA8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD2\xC4"],
        ["\xD2\xC4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x86\xA8"],

        ["\xE8\xAC\x80",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD2\xC5"],
        ["\xD2\xC5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC\x80"],

        ["\xE8\xB2\x8C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD2\xC6"],
        ["\xD2\xC6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\x8C"],

        ["\xE8\xB2\xBF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD2\xC7"],
        ["\xD2\xC7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\xBF"],

        ["\xE9\x89\xBE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD2\xC8"],
        ["\xD2\xC8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x89\xBE"],

        ["\xE9\x98\xB2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD2\xC9"],
        ["\xD2\xC9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x98\xB2"],

        ["\xE5\x90\xA0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD2\xD1"],
        ["\xD2\xD1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\xA0"],

        ["\xE9\xA0\xAC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD2\xD2"],
        ["\xD2\xD2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0\xAC"],

        ["\xE5\x8C\x97",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD2\xD3"],
        ["\xD2\xD3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\x97"],

        ["\xE5\x83\x95",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD2\xD4"],
        ["\xD2\xD4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x83\x95"],

        ["\xE5\x8D\x9C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD2\xD5"],
        ["\xD2\xD5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\x9C"],

        ["\xE5\xA2\xA8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD2\xD6"],
        ["\xD2\xD6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA2\xA8"],

        ["\xE6\x92\xB2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD2\xD7"],
        ["\xD2\xD7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x92\xB2"],

        ["\xE6\x9C\xB4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD2\xD8"],
        ["\xD2\xD8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\xB4"],

        ["\xE7\x89\xA7",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD2\xD9"],
        ["\xD2\xD9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x89\xA7"],

        ["\xE7\x9D\xA6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD2\xE2"],
        ["\xD2\xE2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9D\xA6"],

        ["\xE7\xA9\x86",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD2\xE3"],
        ["\xD2\xE3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\x86"],

        ["\xE9\x87\xA6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD2\xE4"],
        ["\xD2\xE4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\xA6"],

        ["\xE5\x8B\x83",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD2\xE5"],
        ["\xD2\xE5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\x83"],

        ["\xE6\xB2\xA1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD2\xE6"],
        ["\xD2\xE6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\xA1"],

        ["\xE6\xAE\x86",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD2\xE7"],
        ["\xD2\xE7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\x86"],

        ["\xE5\xA0\x80",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD2\xE8"],
        ["\xD2\xE8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA0\x80"],

        ["\xE5\xB9\x8C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD2\xE9"],
        ["\xD2\xE9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\x8C"],

        ["\xE5\xA5\x94",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD2\x4A"],
        ["\xD2\x4A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\x94"],

        ["\xE6\x9C\xAC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD2\x5B"],
        ["\xD2\x5B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\xAC"],

        ["\xE7\xBF\xBB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD2\x5A"],
        ["\xD2\x5A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBF\xBB"],

        ["\xE5\x87\xA1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD2\x5F"],
        ["\xD2\x5F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\xA1"],

        ["\xE7\x9B\x86",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD2\x6D"],
        ["\xD2\x6D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\x86"],

        ["\xE6\x91\xA9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD2\x79"],
        ["\xD2\x79",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x91\xA9"],

        ["\xE7\xA3\xA8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD2\x57"],
        ["\xD2\x57",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA3\xA8"],

        ["\xE9\xAD\x94",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD2\x59"],
        ["\xD2\x59",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xAD\x94"],

        ["\xE9\xBA\xBB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD2\x62"],
        ["\xD2\x62",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xBA\xBB"],

        ["\xE5\x9F\x8B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD2\x63"],
        ["\xD2\x63",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9F\x8B"],

        ["\xE5\xA6\xB9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD2\x64"],
        ["\xD2\x64",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA6\xB9"],

        ["\xE6\x98\xA7",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD2\x65"],
        ["\xD2\x65",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\xA7"],

        ["\xE6\x9E\x9A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD2\x66"],
        ["\xD2\x66",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E\x9A"],

        ["\xE6\xAF\x8E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD2\x67"],
        ["\xD2\x67",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAF\x8E"],

        ["\xE5\x93\xA9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD2\x68"],
        ["\xD2\x68",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x93\xA9"],

        ["\xE6\xA7\x99",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x90\xA3"],
        ["\x90\xA3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\x99"],

        ["\xE5\xB9\x95",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD2\x70"],
        ["\xD2\x70",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\x95"],

        ["\xE8\x86\x9C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD2\x71"],
        ["\xD2\x71",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x86\x9C"],

        ["\xE6\x9E\x95",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD2\x72"],
        ["\xD2\x72",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E\x95"],

        ["\xE9\xAE\xAA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD2\x73"],
        ["\xD2\x73",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xAE\xAA"],

        ["\xE6\x9F\xBE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD2\x74"],
        ["\xD2\x74",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\xBE"],

        ["\xE9\xB1\x92",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD2\x75"],
        ["\xD2\x75",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB1\x92"],

        ["\xE6\xA1\x9D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD2\x76"],
        ["\xD2\x76",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\x9D"],

        ["\xE4\xBA\xA6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD2\x77"],
        ["\xD2\x77",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\xA6"],

        ["\xE4\xBF\xA3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD2\x78"],
        ["\xD2\x78",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\xA3"],

        ["\xE5\x8F\x88",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD2\x80"],
        ["\xD2\x80",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\x88"],

        ["\xE6\x8A\xB9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD2\x8B"],
        ["\xD2\x8B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A\xB9"],

        ["\xE6\x9C\xAB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD2\x9B"],
        ["\xD2\x9B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\xAB"],

        ["\xE6\xB2\xAB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD2\x9C"],
        ["\xD2\x9C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\xAB"],

        ["\xE8\xBF\x84",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD2\xA0"],
        ["\xD2\xA0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF\x84"],

        ["\xE4\xBE\xAD",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD7\xE5"],
        ["\xD7\xE5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE\xAD"],

        ["\xE7\xB9\xAD",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD2\xB0"],
        ["\xD2\xB0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\xAD"],

        ["\xE9\xBA\xBF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD2\xC0"],
        ["\xD2\xC0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xBA\xBF"],

        ["\xE4\xB8\x87",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD2\x6A"],
        ["\xD2\x6A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\x87"],

        ["\xE6\x85\xA2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD2\xD0"],
        ["\xD2\xD0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\xA2"],

        ["\xE6\xBA\x80",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD2\xA1"],
        ["\xD2\xA1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBA\x80"],

        ["\xE6\xBC\xAB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD3\x4F"],
        ["\xD3\x4F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBC\xAB"],

        ["\xE8\x94\x93",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD3\x7F"],
        ["\xD3\x7F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x94\x93"],

        ["\xE5\x91\xB3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD3\x7B"],
        ["\xD3\x7B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x91\xB3"],

        ["\xE6\x9C\xAA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD3\xE0"],
        ["\xD3\xE0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\xAA"],

        ["\xE9\xAD\x85",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD3\x6C"],
        ["\xD3\x6C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xAD\x85"],

        ["\xE5\xB7\xB3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD3\x50"],
        ["\xD3\x50",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\xB3"],

        ["\xE7\xAE\x95",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD3\x7D"],
        ["\xD3\x7D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAE\x95"],

        ["\xE5\xB2\xAC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD3\x4D"],
        ["\xD3\x4D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB2\xAC"],

        ["\xE5\xAF\x86",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD3\x5D"],
        ["\xD3\x5D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\x86"],

        ["\xE8\x9C\x9C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD3\x5C"],
        ["\xD3\x5C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9C\x9C"],

        ["\xE6\xB9\x8A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD3\x4E"],
        ["\xD3\x4E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB9\x8A"],

        ["\xE8\x93\x91",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD3\x6B"],
        ["\xD3\x6B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x93\x91"],

        ["\xE7\xA8\x94",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD3\x60"],
        ["\xD3\x60",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8\x94"],

        ["\xE8\x84\x88",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD3\x4B"],
        ["\xD3\x4B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x84\x88"],

        ["\xE5\xA6\x99",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD3\x61"],
        ["\xD3\x61",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA6\x99"],

        ["\xE7\xB2\x8D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD3\xF0"],
        ["\xD3\xF0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\x8D"],

        ["\xE6\xB0\x91",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD3\xF1"],
        ["\xD3\xF1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB0\x91"],

        ["\xE7\x9C\xA0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD3\xF2"],
        ["\xD3\xF2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9C\xA0"],

        ["\xE5\x8B\x99",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD3\xF3"],
        ["\xD3\xF3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\x99"],

        ["\xE5\xA4\xA2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD3\xF4"],
        ["\xD3\xF4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\xA2"],

        ["\xE7\x84\xA1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD3\xF5"],
        ["\xD3\xF5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x84\xA1"],

        ["\xE7\x89\x9F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD3\xF6"],
        ["\xD3\xF6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x89\x9F"],

        ["\xE7\x9F\x9B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD3\xF7"],
        ["\xD3\xF7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9F\x9B"],

        ["\xE9\x9C\xA7",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD3\xF8"],
        ["\xD3\xF8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9C\xA7"],

        ["\xE9\xB5\xA1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD3\xF9"],
        ["\xD3\xF9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB5\xA1"],

        ["\xE6\xA4\x8B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD3\x7A"],
        ["\xD3\x7A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\x8B"],

        ["\xE5\xA9\xBF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD3\x5E"],
        ["\xD3\x5E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA9\xBF"],

        ["\xE5\xA8\x98",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD3\x4C"],
        ["\xD3\x4C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA8\x98"],

        ["\xE5\x86\xA5",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD3\x7E"],
        ["\xD3\x7E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\xA5"],

        ["\xE5\x90\x8D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD3\x6E"],
        ["\xD3\x6E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\x8D"],

        ["\xE5\x91\xBD",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD3\x6F"],
        ["\xD3\x6F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x91\xBD"],

        ["\xE6\x98\x8E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD3\x7C"],
        ["\xD3\x7C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\x8E"],

        ["\xE7\x9B\x9F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD3\xC1"],
        ["\xD3\xC1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\x9F"],

        ["\xE8\xBF\xB7",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD3\xC2"],
        ["\xD3\xC2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF\xB7"],

        ["\xE9\x8A\x98",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD3\xC3"],
        ["\xD3\xC3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8A\x98"],

        ["\xE9\xB3\xB4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD3\xC4"],
        ["\xD3\xC4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB3\xB4"],

        ["\xE5\xA7\xAA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD3\xC5"],
        ["\xD3\xC5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA7\xAA"],

        ["\xE7\x89\x9D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD3\xC6"],
        ["\xD3\xC6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x89\x9D"],

        ["\xE6\xBB\x85",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD3\xC7"],
        ["\xD3\xC7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBB\x85"],

        ["\xE5\x85\x8D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD3\xC8"],
        ["\xD3\xC8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\x8D"],

        ["\xE6\xA3\x89",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD3\xC9"],
        ["\xD3\xC9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\x89"],

        ["\xE7\xB6\xBF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD3\xD1"],
        ["\xD3\xD1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\xBF"],

        ["\xE7\xB7\xAC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD3\xD2"],
        ["\xD3\xD2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7\xAC"],

        ["\xE9\x9D\xA2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD3\xD3"],
        ["\xD3\xD3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9D\xA2"],

        ["\xE9\xBA\xBA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD3\xD4"],
        ["\xD3\xD4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xBA\xBA"],

        ["\xE6\x91\xB8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD3\xD5"],
        ["\xD3\xD5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x91\xB8"],

        ["\xE6\xA8\xA1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD3\xD6"],
        ["\xD3\xD6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\xA1"],

        ["\xE8\x8C\x82",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD3\xD7"],
        ["\xD3\xD7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C\x82"],

        ["\xE5\xA6\x84",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD3\xD8"],
        ["\xD3\xD8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA6\x84"],

        ["\xE5\xAD\x9F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD3\xD9"],
        ["\xD3\xD9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\x9F"],

        ["\xE6\xAF\x9B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD3\xE2"],
        ["\xD3\xE2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAF\x9B"],

        ["\xE7\x8C\x9B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD3\xE3"],
        ["\xD3\xE3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8C\x9B"],

        ["\xE7\x9B\xB2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD3\xE4"],
        ["\xD3\xE4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\xB2"],

        ["\xE7\xB6\xB2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD3\xE5"],
        ["\xD3\xE5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\xB2"],

        ["\xE8\x80\x97",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD3\xE6"],
        ["\xD3\xE6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\x97"],

        ["\xE8\x92\x99",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD3\xE7"],
        ["\xD3\xE7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x92\x99"],

        ["\xE5\x84\xB2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD3\xE8"],
        ["\xD3\xE8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x84\xB2"],

        ["\xE6\x9C\xA8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD3\xE9"],
        ["\xD3\xE9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\xA8"],

        ["\xE9\xBB\x99",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD3\x4A"],
        ["\xD3\x4A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xBB\x99"],

        ["\xE7\x9B\xAE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD3\x5B"],
        ["\xD3\x5B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\xAE"],

        ["\xE6\x9D\xA2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD3\x5A"],
        ["\xD3\x5A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\xA2"],

        ["\xE5\x8B\xBF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD3\x5F"],
        ["\xD3\x5F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\xBF"],

        ["\xE9\xA4\x85",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD3\x6D"],
        ["\xD3\x6D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA4\x85"],

        ["\xE5\xB0\xA4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD3\x79"],
        ["\xD3\x79",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\xA4"],

        ["\xE6\x88\xBB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD3\x57"],
        ["\xD3\x57",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\xBB"],

        ["\xE7\xB1\xBE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD3\x59"],
        ["\xD3\x59",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB1\xBE"],

        ["\xE8\xB2\xB0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD3\x62"],
        ["\xD3\x62",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\xB0"],

        ["\xE5\x95\x8F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD3\x63"],
        ["\xD3\x63",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x95\x8F"],

        ["\xE6\x82\xB6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD3\x64"],
        ["\xD3\x64",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\xB6"],

        ["\xE7\xB4\x8B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD3\x65"],
        ["\xD3\x65",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\x8B"],

        ["\xE9\x96\x80",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD3\x66"],
        ["\xD3\x66",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\x80"],

        ["\xE5\x8C\x81",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD3\x67"],
        ["\xD3\x67",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\x81"],

        ["\xE4\xB9\x9F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD3\x68"],
        ["\xD3\x68",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xB9\x9F"],

        ["\xE5\x86\xB6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD3\x69"],
        ["\xD3\x69",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\xB6"],

        ["\xE5\xA4\x9C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD3\x70"],
        ["\xD3\x70",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\x9C"],

        ["\xE7\x88\xBA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD3\x71"],
        ["\xD3\x71",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x88\xBA"],

        ["\xE8\x80\xB6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD3\x72"],
        ["\xD3\x72",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\xB6"],

        ["\xE9\x87\x8E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD3\x73"],
        ["\xD3\x73",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\x8E"],

        ["\xE5\xBC\xA5",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD3\x74"],
        ["\xD3\x74",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\xA5"],

        ["\xE7\x9F\xA2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD3\x75"],
        ["\xD3\x75",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9F\xA2"],

        ["\xE5\x8E\x84",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD3\x76"],
        ["\xD3\x76",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8E\x84"],

        ["\xE5\xBD\xB9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD3\x77"],
        ["\xD3\x77",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\xB9"],

        ["\xE7\xB4\x84",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD3\x78"],
        ["\xD3\x78",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\x84"],

        ["\xE8\x96\xAC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD3\x80"],
        ["\xD3\x80",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\xAC"],

        ["\xE8\xA8\xB3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD3\x8B"],
        ["\xD3\x8B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\xB3"],

        ["\xE8\xBA\x8D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD3\x9B"],
        ["\xD3\x9B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBA\x8D"],

        ["\xE9\x9D\x96",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD3\x9C"],
        ["\xD3\x9C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9D\x96"],

        ["\xE6\x9F\xB3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD3\xA0"],
        ["\xD3\xA0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\xB3"],

        ["\xE8\x96\xAE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x68\x4B"],
        ["\x68\x4B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\xAE"],

        ["\xE9\x91\x93",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD3\xB0"],
        ["\xD3\xB0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x91\x93"],

        ["\xE6\x84\x89",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD3\xC0"],
        ["\xD3\xC0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\x89"],

        ["\xE6\x84\x88",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD3\x6A"],
        ["\xD3\x6A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\x88"],

        ["\xE6\xB2\xB9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD3\xD0"],
        ["\xD3\xD0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\xB9"],

        ["\xE7\x99\x92",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD3\xA1"],
        ["\xD3\xA1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\x92"],

        ["\xE8\xAB\xAD",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD4\x4F"],
        ["\xD4\x4F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\xAD"],

        ["\xE8\xBC\xB8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD4\x7F"],
        ["\xD4\x7F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC\xB8"],

        ["\xE5\x94\xAF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD4\x7B"],
        ["\xD4\x7B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x94\xAF"],

        ["\xE4\xBD\x91",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD4\xE0"],
        ["\xD4\xE0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\x91"],

        ["\xE5\x84\xAA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD4\x6C"],
        ["\xD4\x6C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x84\xAA"],

        ["\xE5\x8B\x87",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD4\x50"],
        ["\xD4\x50",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\x87"],

        ["\xE5\x8F\x8B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD4\x7D"],
        ["\xD4\x7D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\x8B"],

        ["\xE5\xAE\xA5",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD4\x4D"],
        ["\xD4\x4D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\xA5"],

        ["\xE5\xB9\xBD",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD4\x5D"],
        ["\xD4\x5D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\xBD"],

        ["\xE6\x82\xA0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD4\x5C"],
        ["\xD4\x5C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\xA0"],

        ["\xE6\x86\x82",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD4\x4E"],
        ["\xD4\x4E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x86\x82"],

        ["\xE6\x8F\x96",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD4\x6B"],
        ["\xD4\x6B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8F\x96"],

        ["\xE6\x9C\x89",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD4\x60"],
        ["\xD4\x60",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\x89"],

        ["\xE6\x9F\x9A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD4\x4B"],
        ["\xD4\x4B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\x9A"],

        ["\xE6\xB9\xA7",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD4\x61"],
        ["\xD4\x61",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB9\xA7"],

        ["\xE6\xB6\x8C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD4\xF0"],
        ["\xD4\xF0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB6\x8C"],

        ["\xE7\x8C\xB6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD4\xF1"],
        ["\xD4\xF1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8C\xB6"],

        ["\xE7\x8C\xB7",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD4\xF2"],
        ["\xD4\xF2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8C\xB7"],

        ["\xE7\x94\xB1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD4\xF3"],
        ["\xD4\xF3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\xB1"],

        ["\xE7\xA5\x90",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD4\xF4"],
        ["\xD4\xF4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5\x90"],

        ["\xE8\xA3\x95",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD4\xF5"],
        ["\xD4\xF5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\x95"],

        ["\xE8\xAA\x98",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD4\xF6"],
        ["\xD4\xF6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\x98"],

        ["\xE9\x81\x8A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD4\xF7"],
        ["\xD4\xF7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\x8A"],

        ["\xE9\x82\x91",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD4\xF8"],
        ["\xD4\xF8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x82\x91"],

        ["\xE9\x83\xB5",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD4\xF9"],
        ["\xD4\xF9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x83\xB5"],

        ["\xE9\x9B\x84",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD4\x7A"],
        ["\xD4\x7A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\x84"],

        ["\xE8\x9E\x8D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD4\x5E"],
        ["\xD4\x5E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9E\x8D"],

        ["\xE5\xA4\x95",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD4\x4C"],
        ["\xD4\x4C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\x95"],

        ["\xE4\xBA\x88",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD4\x7E"],
        ["\xD4\x7E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\x88"],

        ["\xE4\xBD\x99",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD4\x6E"],
        ["\xD4\x6E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\x99"],

        ["\xE4\xB8\x8E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD4\x6F"],
        ["\xD4\x6F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\x8E"],

        ["\xE8\xAA\x89",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD4\x7C"],
        ["\xD4\x7C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\x89"],

        ["\xE8\xBC\xBF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD4\xC1"],
        ["\xD4\xC1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC\xBF"],

        ["\xE9\xA0\x90",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD4\xC2"],
        ["\xD4\xC2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0\x90"],

        ["\xE5\x82\xAD",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD4\xC3"],
        ["\xD4\xC3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x82\xAD"],

        ["\xE5\xB9\xBC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD4\xC4"],
        ["\xD4\xC4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\xBC"],

        ["\xE5\xA6\x96",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD4\xC5"],
        ["\xD4\xC5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA6\x96"],

        ["\xE5\xAE\xB9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD4\xC6"],
        ["\xD4\xC6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\xB9"],

        ["\xE5\xBA\xB8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD4\xC7"],
        ["\xD4\xC7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBA\xB8"],

        ["\xE6\x8F\x9A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD4\xC8"],
        ["\xD4\xC8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8F\x9A"],

        ["\xE6\x8F\xBA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD4\xC9"],
        ["\xD4\xC9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8F\xBA"],

        ["\xE6\x93\x81",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD4\xD1"],
        ["\xD4\xD1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\x81"],

        ["\xE6\x9B\x9C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD4\xD2"],
        ["\xD4\xD2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\x9C"],

        ["\xE6\xA5\x8A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD4\xD3"],
        ["\xD4\xD3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\x8A"],

        ["\xE6\xA7\x98",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD4\xD4"],
        ["\xD4\xD4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\x98"],

        ["\xE6\xB4\x8B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD4\xD5"],
        ["\xD4\xD5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4\x8B"],

        ["\xE6\xBA\xB6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD4\xD6"],
        ["\xD4\xD6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBA\xB6"],

        ["\xE7\x86\x94",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD4\xD7"],
        ["\xD4\xD7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x86\x94"],

        ["\xE7\x94\xA8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD4\xD8"],
        ["\xD4\xD8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\xA8"],

        ["\xE7\xAA\xAF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD4\xD9"],
        ["\xD4\xD9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAA\xAF"],

        ["\xE7\xBE\x8A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD4\xE2"],
        ["\xD4\xE2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\x8A"],

        ["\xE8\x80\x80",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD4\xE3"],
        ["\xD4\xE3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\x80"],

        ["\xE8\x91\x89",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD4\xE4"],
        ["\xD4\xE4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x91\x89"],

        ["\xE8\x93\x89",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD4\xE5"],
        ["\xD4\xE5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x93\x89"],

        ["\xE8\xA6\x81",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD4\xE6"],
        ["\xD4\xE6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\x81"],

        ["\xE8\xAC\xA1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD4\xE7"],
        ["\xD4\xE7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC\xA1"],

        ["\xE8\xB8\x8A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD4\xE8"],
        ["\xD4\xE8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB8\x8A"],

        ["\xE9\x81\xA5",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xA5\x95"],
        ["\xA5\x95",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\xA5"],

        ["\xE9\x99\xBD",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD4\x4A"],
        ["\xD4\x4A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x99\xBD"],

        ["\xE9\xA4\x8A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD4\x5B"],
        ["\xD4\x5B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA4\x8A"],

        ["\xE6\x85\xBE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD4\x5A"],
        ["\xD4\x5A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\xBE"],

        ["\xE6\x8A\x91",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD4\x5F"],
        ["\xD4\x5F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A\x91"],

        ["\xE6\xAC\xB2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD4\x6D"],
        ["\xD4\x6D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAC\xB2"],

        ["\xE6\xB2\x83",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD4\x79"],
        ["\xD4\x79",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\x83"],

        ["\xE6\xB5\xB4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD4\x57"],
        ["\xD4\x57",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB5\xB4"],

        ["\xE7\xBF\x8C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD4\x59"],
        ["\xD4\x59",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBF\x8C"],

        ["\xE7\xBF\xBC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD4\x62"],
        ["\xD4\x62",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBF\xBC"],

        ["\xE6\xB7\x80",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD4\x63"],
        ["\xD4\x63",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\x80"],

        ["\xE7\xBE\x85",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD4\x64"],
        ["\xD4\x64",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\x85"],

        ["\xE8\x9E\xBA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD4\x65"],
        ["\xD4\x65",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9E\xBA"],

        ["\xE8\xA3\xB8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD4\x66"],
        ["\xD4\x66",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\xB8"],

        ["\xE6\x9D\xA5",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD4\x67"],
        ["\xD4\x67",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\xA5"],

        ["\xE8\x8E\xB1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD4\x68"],
        ["\xD4\x68",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8E\xB1"],

        ["\xE9\xA0\xBC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD4\x69"],
        ["\xD4\x69",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0\xBC"],

        ["\xE9\x9B\xB7",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD4\x70"],
        ["\xD4\x70",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\xB7"],

        ["\xE6\xB4\x9B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD4\x71"],
        ["\xD4\x71",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4\x9B"],

        ["\xE7\xB5\xA1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD4\x72"],
        ["\xD4\x72",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\xA1"],

        ["\xE8\x90\xBD",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD4\x73"],
        ["\xD4\x73",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x90\xBD"],

        ["\xE9\x85\xAA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD4\x74"],
        ["\xD4\x74",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x85\xAA"],

        ["\xE4\xB9\xB1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD4\x75"],
        ["\xD4\x75",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xB9\xB1"],

        ["\xE5\x8D\xB5",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD4\x76"],
        ["\xD4\x76",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\xB5"],

        ["\xE5\xB5\x90",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD4\x77"],
        ["\xD4\x77",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB5\x90"],

        ["\xE6\xAC\x84",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD4\x78"],
        ["\xD4\x78",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAC\x84"],

        ["\xE6\xBF\xAB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD4\x80"],
        ["\xD4\x80",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF\xAB"],

        ["\xE8\x97\x8D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD4\x8B"],
        ["\xD4\x8B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x97\x8D"],

        ["\xE8\x98\xAD",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD4\x9B"],
        ["\xD4\x9B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x98\xAD"],

        ["\xE8\xA6\xA7",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD4\x9C"],
        ["\xD4\x9C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\xA7"],

        ["\xE5\x88\xA9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD4\xA0"],
        ["\xD4\xA0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\xA9"],

        ["\xE5\x90\x8F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD4\xAB"],
        ["\xD4\xAB",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\x8F"],

        ["\xE5\xB1\xA5",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD4\xB0"],
        ["\xD4\xB0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\xA5"],

        ["\xE6\x9D\x8E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD4\xC0"],
        ["\xD4\xC0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\x8E"],

        ["\xE6\xA2\xA8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD4\x6A"],
        ["\xD4\x6A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\xA8"],

        ["\xE7\x90\x86",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD4\xD0"],
        ["\xD4\xD0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x90\x86"],

        ["\xE7\x92\x83",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD4\xA1"],
        ["\xD4\xA1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x92\x83"],

        ["\xE7\x97\xA2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD5\x4F"],
        ["\xD5\x4F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\xA2"],

        ["\xE8\xA3\x8F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD5\x7F"],
        ["\xD5\x7F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\x8F"],

        ["\xE8\xA3\xA1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD5\x7B"],
        ["\xD5\x7B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\xA1"],

        ["\xE9\x87\x8C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD5\xE0"],
        ["\xD5\xE0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\x8C"],

        ["\xE9\x9B\xA2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD5\x6C"],
        ["\xD5\x6C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\xA2"],

        ["\xE9\x99\xB8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD5\x50"],
        ["\xD5\x50",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x99\xB8"],

        ["\xE5\xBE\x8B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD5\x7D"],
        ["\xD5\x7D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\x8B"],

        ["\xE7\x8E\x87",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD5\x4D"],
        ["\xD5\x4D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8E\x87"],

        ["\xE7\xAB\x8B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD5\x5D"],
        ["\xD5\x5D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\x8B"],

        ["\xE8\x91\x8E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD5\x5C"],
        ["\xD5\x5C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x91\x8E"],

        ["\xE6\x8E\xA0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD5\x4E"],
        ["\xD5\x4E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\xA0"],

        ["\xE7\x95\xA5",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD5\x6B"],
        ["\xD5\x6B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\xA5"],

        ["\xE5\x8A\x89",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD5\x60"],
        ["\xD5\x60",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\x89"],

        ["\xE6\xB5\x81",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD5\x4B"],
        ["\xD5\x4B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB5\x81"],

        ["\xE6\xBA\x9C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD5\x61"],
        ["\xD5\x61",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBA\x9C"],

        ["\xE7\x90\x89",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD5\xF0"],
        ["\xD5\xF0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x90\x89"],

        ["\xE7\x95\x99",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD5\xF1"],
        ["\xD5\xF1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\x99"],

        ["\xE7\xA1\xAB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD5\xF2"],
        ["\xD5\xF2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA1\xAB"],

        ["\xE7\xB2\x92",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD5\xF3"],
        ["\xD5\xF3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\x92"],

        ["\xE9\x9A\x86",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD5\xF4"],
        ["\xD5\xF4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\x86"],

        ["\xE7\xAB\x9C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD5\xF5"],
        ["\xD5\xF5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\x9C"],

        ["\xE9\xBE\x8D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD5\xF6"],
        ["\xD5\xF6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xBE\x8D"],

        ["\xE4\xBE\xB6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD5\xF7"],
        ["\xD5\xF7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE\xB6"],

        ["\xE6\x85\xAE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD5\xF8"],
        ["\xD5\xF8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\xAE"],

        ["\xE6\x97\x85",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD5\xF9"],
        ["\xD5\xF9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\x85"],

        ["\xE8\x99\x9C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD5\x7A"],
        ["\xD5\x7A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x99\x9C"],

        ["\xE4\xBA\x86",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD5\x5E"],
        ["\xD5\x5E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\x86"],

        ["\xE4\xBA\xAE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD5\x4C"],
        ["\xD5\x4C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\xAE"],

        ["\xE5\x83\x9A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD5\x7E"],
        ["\xD5\x7E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x83\x9A"],

        ["\xE4\xB8\xA1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD5\x6E"],
        ["\xD5\x6E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\xA1"],

        ["\xE5\x87\x8C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD5\x6F"],
        ["\xD5\x6F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\x8C"],

        ["\xE5\xAF\xAE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD5\x7C"],
        ["\xD5\x7C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\xAE"],

        ["\xE6\x96\x99",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD5\xC1"],
        ["\xD5\xC1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\x99"],

        ["\xE6\xA2\x81",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD5\xC2"],
        ["\xD5\xC2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\x81"],

        ["\xE6\xB6\xBC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD5\xC3"],
        ["\xD5\xC3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB6\xBC"],

        ["\xE7\x8C\x9F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD5\xC4"],
        ["\xD5\xC4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8C\x9F"],

        ["\xE7\x99\x82",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD5\xC5"],
        ["\xD5\xC5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\x82"],

        ["\xE7\x9E\xAD",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD5\xC6"],
        ["\xD5\xC6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9E\xAD"],

        ["\xE7\xA8\x9C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD5\xC7"],
        ["\xD5\xC7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8\x9C"],

        ["\xE7\xB3\xA7",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD5\xC8"],
        ["\xD5\xC8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3\xA7"],

        ["\xE8\x89\xAF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD5\xC9"],
        ["\xD5\xC9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x89\xAF"],

        ["\xE8\xAB\x92",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD5\xD1"],
        ["\xD5\xD1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\x92"],

        ["\xE9\x81\xBC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD5\xD2"],
        ["\xD5\xD2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\xBC"],

        ["\xE9\x87\x8F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD5\xD3"],
        ["\xD5\xD3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\x8F"],

        ["\xE9\x99\xB5",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD5\xD4"],
        ["\xD5\xD4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x99\xB5"],

        ["\xE9\xA0\x98",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD5\xD5"],
        ["\xD5\xD5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0\x98"],

        ["\xE5\x8A\x9B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD5\xD6"],
        ["\xD5\xD6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\x9B"],

        ["\xE7\xB7\x91",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD5\xD7"],
        ["\xD5\xD7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7\x91"],

        ["\xE5\x80\xAB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD5\xD8"],
        ["\xD5\xD8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\xAB"],

        ["\xE5\x8E\x98",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD5\xD9"],
        ["\xD5\xD9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8E\x98"],

        ["\xE6\x9E\x97",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD5\xE2"],
        ["\xD5\xE2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E\x97"],

        ["\xE6\xB7\x8B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD5\xE3"],
        ["\xD5\xE3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\x8B"],

        ["\xE7\x87\x90",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD5\xE4"],
        ["\xD5\xE4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x87\x90"],

        ["\xE7\x90\xB3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD5\xE5"],
        ["\xD5\xE5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x90\xB3"],

        ["\xE8\x87\xA8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD5\xE6"],
        ["\xD5\xE6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\xA8"],

        ["\xE8\xBC\xAA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD5\xE7"],
        ["\xD5\xE7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC\xAA"],

        ["\xE9\x9A\xA3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD5\xE8"],
        ["\xD5\xE8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\xA3"],

        ["\xE9\xB1\x97",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD5\xE9"],
        ["\xD5\xE9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB1\x97"],

        ["\xE9\xBA\x9F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD5\x4A"],
        ["\xD5\x4A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xBA\x9F"],

        ["\xE7\x91\xA0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD5\x5B"],
        ["\xD5\x5B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x91\xA0"],

        ["\xE5\xA1\x81",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD5\x5A"],
        ["\xD5\x5A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA1\x81"],

        ["\xE6\xB6\x99",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD5\x5F"],
        ["\xD5\x5F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB6\x99"],

        ["\xE7\xB4\xAF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD5\x6D"],
        ["\xD5\x6D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\xAF"],

        ["\xE9\xA1\x9E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD5\x79"],
        ["\xD5\x79",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA1\x9E"],

        ["\xE4\xBB\xA4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD5\x57"],
        ["\xD5\x57",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\xA4"],

        ["\xE4\xBC\xB6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD5\x59"],
        ["\xD5\x59",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBC\xB6"],

        ["\xE4\xBE\x8B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD5\x62"],
        ["\xD5\x62",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE\x8B"],

        ["\xE5\x86\xB7",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD5\x63"],
        ["\xD5\x63",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\xB7"],

        ["\xE5\x8A\xB1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD5\x64"],
        ["\xD5\x64",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\xB1"],

        ["\xE5\xB6\xBA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD5\x65"],
        ["\xD5\x65",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB6\xBA"],

        ["\xE6\x80\x9C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD5\x66"],
        ["\xD5\x66",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x80\x9C"],

        ["\xE7\x8E\xB2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD5\x67"],
        ["\xD5\x67",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8E\xB2"],

        ["\xE7\xA4\xBC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD5\x68"],
        ["\xD5\x68",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA4\xBC"],

        ["\xE8\x8B\x93",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD5\x69"],
        ["\xD5\x69",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8B\x93"],

        ["\xE9\x88\xB4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD5\x70"],
        ["\xD5\x70",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x88\xB4"],

        ["\xE9\x9A\xB7",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD5\x71"],
        ["\xD5\x71",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\xB7"],

        ["\xE9\x9B\xB6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD5\x72"],
        ["\xD5\x72",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\xB6"],

        ["\xE9\x9C\x8A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD5\x73"],
        ["\xD5\x73",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9C\x8A"],

        ["\xE9\xBA\x97",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD5\x74"],
        ["\xD5\x74",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xBA\x97"],

        ["\xE9\xBD\xA2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD5\x75"],
        ["\xD5\x75",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xBD\xA2"],

        ["\xE6\x9A\xA6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD5\x76"],
        ["\xD5\x76",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A\xA6"],

        ["\xE6\xAD\xB4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD5\x77"],
        ["\xD5\x77",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\xB4"],

        ["\xE5\x88\x97",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD5\x78"],
        ["\xD5\x78",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\x97"],

        ["\xE5\x8A\xA3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD5\x80"],
        ["\xD5\x80",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\xA3"],

        ["\xE7\x83\x88",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD5\x8B"],
        ["\xD5\x8B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x83\x88"],

        ["\xE8\xA3\x82",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD5\x9B"],
        ["\xD5\x9B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\x82"],

        ["\xE5\xBB\x89",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD5\x9C"],
        ["\xD5\x9C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\x89"],

        ["\xE6\x81\x8B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD5\xA0"],
        ["\xD5\xA0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\x8B"],

        ["\xE6\x86\x90",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD5\xAB"],
        ["\xD5\xAB",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x86\x90"],

        ["\xE6\xBC\xA3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD5\xB0"],
        ["\xD5\xB0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBC\xA3"],

        ["\xE7\x85\x89",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD5\xC0"],
        ["\xD5\xC0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x85\x89"],

        ["\xE7\xB0\xBE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD5\x6A"],
        ["\xD5\x6A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB0\xBE"],

        ["\xE7\xB7\xB4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD5\xD0"],
        ["\xD5\xD0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7\xB4"],

        ["\xE8\x81\xAF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD5\xA1"],
        ["\xD5\xA1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x81\xAF"],

        ["\xE8\x93\xAE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD6\x4F"],
        ["\xD6\x4F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x93\xAE"],

        ["\xE9\x80\xA3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD6\x7F"],
        ["\xD6\x7F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\xA3"],

        ["\xE9\x8C\xAC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD6\x7B"],
        ["\xD6\x7B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8C\xAC"],

        ["\xE5\x91\x82",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD6\xE0"],
        ["\xD6\xE0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x91\x82"],

        ["\xE9\xAD\xAF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD6\x6C"],
        ["\xD6\x6C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xAD\xAF"],

        ["\xE6\xAB\x93",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD6\x50"],
        ["\xD6\x50",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAB\x93"],

        ["\xE7\x82\x89",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD6\x7D"],
        ["\xD6\x7D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x82\x89"],

        ["\xE8\xB3\x82",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD6\x4D"],
        ["\xD6\x4D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\x82"],

        ["\xE8\xB7\xAF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD6\x5D"],
        ["\xD6\x5D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB7\xAF"],

        ["\xE9\x9C\xB2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD6\x5C"],
        ["\xD6\x5C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9C\xB2"],

        ["\xE5\x8A\xB4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD6\x4E"],
        ["\xD6\x4E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\xB4"],

        ["\xE5\xA9\x81",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD6\x6B"],
        ["\xD6\x6B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA9\x81"],

        ["\xE5\xBB\x8A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD6\x60"],
        ["\xD6\x60",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\x8A"],

        ["\xE5\xBC\x84",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD6\x4B"],
        ["\xD6\x4B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\x84"],

        ["\xE6\x9C\x97",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD6\x61"],
        ["\xD6\x61",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\x97"],

        ["\xE6\xA5\xBC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD6\xF0"],
        ["\xD6\xF0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\xBC"],

        ["\xE6\xA6\x94",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD6\xF1"],
        ["\xD6\xF1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA6\x94"],

        ["\xE6\xB5\xAA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD6\xF2"],
        ["\xD6\xF2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB5\xAA"],

        ["\xE6\xBC\x8F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD6\xF3"],
        ["\xD6\xF3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBC\x8F"],

        ["\xE7\x89\xA2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD6\xF4"],
        ["\xD6\xF4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x89\xA2"],

        ["\xE7\x8B\xBC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD6\xF5"],
        ["\xD6\xF5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8B\xBC"],

        ["\xE7\xAF\xAD",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x63\xC6"],
        ["\x63\xC6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAF\xAD"],

        ["\xE8\x80\x81",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD6\xF7"],
        ["\xD6\xF7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\x81"],

        ["\xE8\x81\xBE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD6\xF8"],
        ["\xD6\xF8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x81\xBE"],

        ["\xE8\x9D\x8B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD6\xF9"],
        ["\xD6\xF9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9D\x8B"],

        ["\xE9\x83\x8E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD6\x7A"],
        ["\xD6\x7A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x83\x8E"],

        ["\xE5\x85\xAD",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD6\x5E"],
        ["\xD6\x5E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\xAD"],

        ["\xE9\xBA\x93",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD6\x4C"],
        ["\xD6\x4C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xBA\x93"],

        ["\xE7\xA6\x84",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD6\x7E"],
        ["\xD6\x7E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6\x84"],

        ["\xE8\x82\x8B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD6\x6E"],
        ["\xD6\x6E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x82\x8B"],

        ["\xE9\x8C\xB2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD6\x6F"],
        ["\xD6\x6F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8C\xB2"],

        ["\xE8\xAB\x96",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD6\x7C"],
        ["\xD6\x7C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\x96"],

        ["\xE5\x80\xAD",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD6\xC1"],
        ["\xD6\xC1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\xAD"],

        ["\xE5\x92\x8C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD6\xC2"],
        ["\xD6\xC2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\x8C"],

        ["\xE8\xA9\xB1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD6\xC3"],
        ["\xD6\xC3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\xB1"],

        ["\xE6\xAD\xAA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD6\xC4"],
        ["\xD6\xC4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\xAA"],

        ["\xE8\xB3\x84",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD6\xC5"],
        ["\xD6\xC5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\x84"],

        ["\xE8\x84\x87",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD6\xC6"],
        ["\xD6\xC6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x84\x87"],

        ["\xE6\x83\x91",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD6\xC7"],
        ["\xD6\xC7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\x91"],

        ["\xE6\x9E\xA0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD6\xC8"],
        ["\xD6\xC8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E\xA0"],

        ["\xE9\xB7\xB2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD6\xC9"],
        ["\xD6\xC9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB7\xB2"],

        ["\xE4\xBA\x99",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD6\xD1"],
        ["\xD6\xD1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\x99"],

        ["\xE4\xBA\x98",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD6\xD2"],
        ["\xD6\xD2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\x98"],

        ["\xE9\xB0\x90",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD6\xD3"],
        ["\xD6\xD3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0\x90"],

        ["\xE8\xA9\xAB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD6\xD4"],
        ["\xD6\xD4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\xAB"],

        ["\xE8\x97\x81",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD6\xD5"],
        ["\xD6\xD5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x97\x81"],

        ["\xE8\x95\xA8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD6\xD6"],
        ["\xD6\xD6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x95\xA8"],

        ["\xE6\xA4\x80",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD6\xD7"],
        ["\xD6\xD7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\x80"],

        ["\xE6\xB9\xBE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD6\xD8"],
        ["\xD6\xD8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB9\xBE"],

        ["\xE7\xA2\x97",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD6\xD9"],
        ["\xD6\xD9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA2\x97"],

        ["\xE8\x85\x95",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD6\xE2"],
        ["\xD6\xE2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x85\x95"],

        ["\xE5\xBC\x8C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD7\x4F"],
        ["\xD7\x4F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\x8C"],

        ["\xE4\xB8\x90",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD7\x7F"],
        ["\xD7\x7F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\x90"],

        ["\xE4\xB8\x95",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD7\x7B"],
        ["\xD7\x7B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\x95"],

        ["\xE4\xB8\xAA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD7\xE0"],
        ["\xD7\xE0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\xAA"],

        ["\xE4\xB8\xB1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD7\x6C"],
        ["\xD7\x6C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\xB1"],

        ["\xE4\xB8\xB6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD7\x50"],
        ["\xD7\x50",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\xB6"],

        ["\xE4\xB8\xBC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD7\x7D"],
        ["\xD7\x7D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\xBC"],

        ["\xE4\xB8\xBF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD7\x4D"],
        ["\xD7\x4D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\xBF"],

        ["\xE4\xB9\x82",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD7\x5D"],
        ["\xD7\x5D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xB9\x82"],

        ["\xE4\xB9\x96",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD7\x5C"],
        ["\xD7\x5C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xB9\x96"],

        ["\xE4\xB9\x98",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD7\x4E"],
        ["\xD7\x4E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xB9\x98"],

        ["\xE4\xBA\x82",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD7\x6B"],
        ["\xD7\x6B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\x82"],

        ["\xE4\xBA\x85",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD7\x60"],
        ["\xD7\x60",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\x85"],

        ["\xE8\xB1\xAB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD7\x4B"],
        ["\xD7\x4B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB1\xAB"],

        ["\xE4\xBA\x8A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD7\x61"],
        ["\xD7\x61",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\x8A"],

        ["\xE8\x88\x92",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD7\xF0"],
        ["\xD7\xF0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\x92"],

        ["\xE5\xBC\x8D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD7\xF1"],
        ["\xD7\xF1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\x8D"],

        ["\xE4\xBA\x8E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD7\xF2"],
        ["\xD7\xF2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\x8E"],

        ["\xE4\xBA\x9E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD7\xF3"],
        ["\xD7\xF3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\x9E"],

        ["\xE4\xBA\x9F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD7\xF4"],
        ["\xD7\xF4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\x9F"],

        ["\xE4\xBA\xA0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD7\xF5"],
        ["\xD7\xF5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\xA0"],

        ["\xE4\xBA\xA2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD7\xF6"],
        ["\xD7\xF6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\xA2"],

        ["\xE4\xBA\xB0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD7\xF7"],
        ["\xD7\xF7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\xB0"],

        ["\xE4\xBA\xB3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD7\xF8"],
        ["\xD7\xF8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\xB3"],

        ["\xE4\xBA\xB6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD7\xF9"],
        ["\xD7\xF9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\xB6"],

        ["\xE4\xBB\x8E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD7\x7A"],
        ["\xD7\x7A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\x8E"],

        ["\xE4\xBB\x8D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD7\x5E"],
        ["\xD7\x5E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\x8D"],

        ["\xE4\xBB\x84",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD7\x4C"],
        ["\xD7\x4C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\x84"],

        ["\xE4\xBB\x86",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD7\x7E"],
        ["\xD7\x7E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\x86"],

        ["\xE4\xBB\x82",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD7\x6E"],
        ["\xD7\x6E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\x82"],

        ["\xE4\xBB\x97",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD7\x6F"],
        ["\xD7\x6F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\x97"],

        ["\xE4\xBB\x9E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD7\x7C"],
        ["\xD7\x7C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\x9E"],

        ["\xE4\xBB\xAD",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD7\xC1"],
        ["\xD7\xC1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\xAD"],

        ["\xE4\xBB\x9F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD7\xC2"],
        ["\xD7\xC2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\x9F"],

        ["\xE4\xBB\xB7",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD7\xC3"],
        ["\xD7\xC3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\xB7"],

        ["\xE4\xBC\x89",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD7\xC4"],
        ["\xD7\xC4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBC\x89"],

        ["\xE4\xBD\x9A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD7\xC5"],
        ["\xD7\xC5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\x9A"],

        ["\xE4\xBC\xB0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD7\xC6"],
        ["\xD7\xC6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBC\xB0"],

        ["\xE4\xBD\x9B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD7\xC7"],
        ["\xD7\xC7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\x9B"],

        ["\xE4\xBD\x9D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD7\xC8"],
        ["\xD7\xC8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\x9D"],

        ["\xE4\xBD\x97",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD7\xC9"],
        ["\xD7\xC9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\x97"],

        ["\xE4\xBD\x87",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD7\xD1"],
        ["\xD7\xD1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\x87"],

        ["\xE4\xBD\xB6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD7\xD2"],
        ["\xD7\xD2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\xB6"],

        ["\xE4\xBE\x88",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD7\xD3"],
        ["\xD7\xD3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE\x88"],

        ["\xE4\xBE\x8F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD7\xD4"],
        ["\xD7\xD4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE\x8F"],

        ["\xE4\xBE\x98",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD7\xD5"],
        ["\xD7\xD5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE\x98"],

        ["\xE4\xBD\xBB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD7\xD6"],
        ["\xD7\xD6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\xBB"],

        ["\xE4\xBD\xA9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD7\xD7"],
        ["\xD7\xD7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\xA9"],

        ["\xE4\xBD\xB0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD7\xD8"],
        ["\xD7\xD8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\xB0"],

        ["\xE4\xBE\x91",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD7\xD9"],
        ["\xD7\xD9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE\x91"],

        ["\xE4\xBD\xAF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD7\xE2"],
        ["\xD7\xE2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\xAF"],

        ["\xE4\xBE\x86",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD7\xE3"],
        ["\xD7\xE3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE\x86"],

        ["\xE4\xBE\x96",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD7\xE4"],
        ["\xD7\xE4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE\x96"],

        ["\xE5\x84\x98",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD2\xAB"],
        ["\xD2\xAB",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x84\x98"],

        ["\xE4\xBF\x94",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD7\xE6"],
        ["\xD7\xE6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\x94"],

        ["\xE4\xBF\x9F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD7\xE7"],
        ["\xD7\xE7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\x9F"],

        ["\xE4\xBF\x8E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD7\xE8"],
        ["\xD7\xE8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\x8E"],

        ["\xE4\xBF\x98",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD7\xE9"],
        ["\xD7\xE9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\x98"],

        ["\xE4\xBF\x9B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD7\x4A"],
        ["\xD7\x4A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\x9B"],

        ["\xE4\xBF\x91",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD7\x5B"],
        ["\xD7\x5B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\x91"],

        ["\xE4\xBF\x9A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD7\x5A"],
        ["\xD7\x5A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\x9A"],

        ["\xE4\xBF\x90",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD7\x5F"],
        ["\xD7\x5F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\x90"],

        ["\xE4\xBF\xA4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD7\x6D"],
        ["\xD7\x6D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\xA4"],

        ["\xE4\xBF\xA5",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD7\x79"],
        ["\xD7\x79",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\xA5"],

        ["\xE5\x80\x9A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD7\x57"],
        ["\xD7\x57",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\x9A"],

        ["\xE5\x80\xA8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD7\x59"],
        ["\xD7\x59",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\xA8"],

        ["\xE5\x80\x94",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD7\x62"],
        ["\xD7\x62",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\x94"],

        ["\xE5\x80\xAA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD7\x63"],
        ["\xD7\x63",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\xAA"],

        ["\xE5\x80\xA5",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD7\x64"],
        ["\xD7\x64",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\xA5"],

        ["\xE5\x80\x85",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD7\x65"],
        ["\xD7\x65",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\x85"],

        ["\xE4\xBC\x9C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD7\x66"],
        ["\xD7\x66",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBC\x9C"],

        ["\xE4\xBF\xB6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD7\x67"],
        ["\xD7\x67",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\xB6"],

        ["\xE5\x80\xA1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD7\x68"],
        ["\xD7\x68",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\xA1"],

        ["\xE5\x80\xA9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD7\x69"],
        ["\xD7\x69",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\xA9"],

        ["\xE5\x80\xAC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD7\x70"],
        ["\xD7\x70",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\xAC"],

        ["\xE4\xBF\xBE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD7\x71"],
        ["\xD7\x71",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\xBE"],

        ["\xE4\xBF\xAF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD7\x72"],
        ["\xD7\x72",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\xAF"],

        ["\xE5\x80\x91",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD7\x73"],
        ["\xD7\x73",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\x91"],

        ["\xE5\x80\x86",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD7\x74"],
        ["\xD7\x74",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\x86"],

        ["\xE5\x81\x83",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD7\x75"],
        ["\xD7\x75",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x81\x83"],

        ["\xE5\x81\x87",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD7\x76"],
        ["\xD7\x76",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x81\x87"],

        ["\xE6\x9C\x83",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD7\x77"],
        ["\xD7\x77",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\x83"],

        ["\xE5\x81\x95",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD7\x78"],
        ["\xD7\x78",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x81\x95"],

        ["\xE5\x81\x90",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD7\x80"],
        ["\xD7\x80",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x81\x90"],

        ["\xE5\x81\x88",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD7\x8B"],
        ["\xD7\x8B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x81\x88"],

        ["\xE5\x81\x9A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD7\x9B"],
        ["\xD7\x9B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x81\x9A"],

        ["\xE5\x81\x96",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD7\x9C"],
        ["\xD7\x9C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x81\x96"],

        ["\xE5\x81\xAC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD7\xA0"],
        ["\xD7\xA0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x81\xAC"],

        ["\xE5\x81\xB8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD7\xAB"],
        ["\xD7\xAB",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x81\xB8"],

        ["\xE5\x82\x80",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD7\xB0"],
        ["\xD7\xB0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x82\x80"],

        ["\xE5\x82\x9A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD7\xC0"],
        ["\xD7\xC0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x82\x9A"],

        ["\xE5\x82\x85",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD7\x6A"],
        ["\xD7\x6A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x82\x85"],

        ["\xE5\x82\xB4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD7\xD0"],
        ["\xD7\xD0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x82\xB4"],

        ["\xE5\x82\xB2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD7\xA1"],
        ["\xD7\xA1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x82\xB2"],

        ["\xE5\x83\x89",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD8\x4F"],
        ["\xD8\x4F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x83\x89"],

        ["\xE5\x83\x8A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD8\x7F"],
        ["\xD8\x7F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x83\x8A"],

        ["\xE5\x82\xB3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD8\x7B"],
        ["\xD8\x7B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x82\xB3"],

        ["\xE5\x83\x82",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD8\xE0"],
        ["\xD8\xE0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x83\x82"],

        ["\xE5\x83\x96",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD8\x6C"],
        ["\xD8\x6C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x83\x96"],

        ["\xE5\x83\x9E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD8\x50"],
        ["\xD8\x50",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x83\x9E"],

        ["\xE5\x83\xA5",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD8\x7D"],
        ["\xD8\x7D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x83\xA5"],

        ["\xE5\x83\xAD",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD8\x4D"],
        ["\xD8\x4D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x83\xAD"],

        ["\xE5\x83\xA3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD8\x5D"],
        ["\xD8\x5D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x83\xA3"],

        ["\xE5\x83\xAE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD8\x5C"],
        ["\xD8\x5C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x83\xAE"],

        ["\xE5\x83\xB9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD8\x4E"],
        ["\xD8\x4E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x83\xB9"],

        ["\xE5\x83\xB5",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD8\x6B"],
        ["\xD8\x6B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x83\xB5"],

        ["\xE5\x84\x89",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD8\x60"],
        ["\xD8\x60",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x84\x89"],

        ["\xE5\x84\x81",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD8\x4B"],
        ["\xD8\x4B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x84\x81"],

        ["\xE5\x84\x82",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD8\x61"],
        ["\xD8\x61",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x84\x82"],

        ["\xE5\x84\x96",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD8\xF0"],
        ["\xD8\xF0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x84\x96"],

        ["\xE5\x84\x95",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD8\xF1"],
        ["\xD8\xF1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x84\x95"],

        ["\xE5\x84\x94",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD8\xF2"],
        ["\xD8\xF2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x84\x94"],

        ["\xE5\x84\x9A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD8\xF3"],
        ["\xD8\xF3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x84\x9A"],

        ["\xE5\x84\xA1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD8\xF4"],
        ["\xD8\xF4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x84\xA1"],

        ["\xE5\x84\xBA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD8\xF5"],
        ["\xD8\xF5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x84\xBA"],

        ["\xE5\x84\xB7",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD8\xF6"],
        ["\xD8\xF6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x84\xB7"],

        ["\xE5\x84\xBC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD8\xF7"],
        ["\xD8\xF7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x84\xBC"],

        ["\xE5\x84\xBB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD8\xF8"],
        ["\xD8\xF8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x84\xBB"],

        ["\xE5\x84\xBF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD8\xF9"],
        ["\xD8\xF9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x84\xBF"],

        ["\xE5\x85\x80",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD8\x7A"],
        ["\xD8\x7A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\x80"],

        ["\xE5\x85\x92",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD8\x5E"],
        ["\xD8\x5E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\x92"],

        ["\xE5\x85\x8C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD8\x4C"],
        ["\xD8\x4C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\x8C"],

        ["\xE5\x85\x94",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD8\x7E"],
        ["\xD8\x7E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\x94"],

        ["\xE5\x85\xA2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD8\x6E"],
        ["\xD8\x6E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\xA2"],

        ["\xE7\xAB\xB8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD8\x6F"],
        ["\xD8\x6F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\xB8"],

        ["\xE5\x85\xA9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD8\x7C"],
        ["\xD8\x7C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\xA9"],

        ["\xE5\x85\xAA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD8\xC1"],
        ["\xD8\xC1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\xAA"],

        ["\xE5\x85\xAE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD8\xC2"],
        ["\xD8\xC2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\xAE"],

        ["\xE5\x86\x80",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD8\xC3"],
        ["\xD8\xC3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\x80"],

        ["\xE5\x86\x82",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD8\xC4"],
        ["\xD8\xC4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\x82"],

        ["\xE5\x9B\x98",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD8\xC5"],
        ["\xD8\xC5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B\x98"],

        ["\xE5\x86\x8C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD8\xC6"],
        ["\xD8\xC6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\x8C"],

        ["\xE5\x86\x89",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD8\xC7"],
        ["\xD8\xC7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\x89"],

        ["\xE5\x86\x8F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD8\xC8"],
        ["\xD8\xC8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\x8F"],

        ["\xE5\x86\x91",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD8\xC9"],
        ["\xD8\xC9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\x91"],

        ["\xE5\x86\x93",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD8\xD1"],
        ["\xD8\xD1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\x93"],

        ["\xE5\x86\x95",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD8\xD2"],
        ["\xD8\xD2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\x95"],

        ["\xE5\x86\x96",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD8\xD3"],
        ["\xD8\xD3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\x96"],

        ["\xE5\x86\xA4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD8\xD4"],
        ["\xD8\xD4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\xA4"],

        ["\xE5\x86\xA6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD8\xD5"],
        ["\xD8\xD5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\xA6"],

        ["\xE5\x86\xA2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD8\xD6"],
        ["\xD8\xD6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\xA2"],

        ["\xE5\x86\xA9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD8\xD7"],
        ["\xD8\xD7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\xA9"],

        ["\xE5\x86\xAA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD8\xD8"],
        ["\xD8\xD8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\xAA"],

        ["\xE5\x86\xAB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD8\xD9"],
        ["\xD8\xD9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\xAB"],

        ["\xE5\x86\xB3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD8\xE2"],
        ["\xD8\xE2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\xB3"],

        ["\xE5\x86\xB1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD8\xE3"],
        ["\xD8\xE3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\xB1"],

        ["\xE5\x86\xB2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD8\xE4"],
        ["\xD8\xE4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\xB2"],

        ["\xE5\x86\xB0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD8\xE5"],
        ["\xD8\xE5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\xB0"],

        ["\xE5\x86\xB5",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD8\xE6"],
        ["\xD8\xE6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\xB5"],

        ["\xE5\x86\xBD",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD8\xE7"],
        ["\xD8\xE7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\xBD"],

        ["\xE5\x87\x85",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD8\xE8"],
        ["\xD8\xE8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\x85"],

        ["\xE5\x87\x89",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD8\xE9"],
        ["\xD8\xE9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\x89"],

        ["\xE5\x87\x9B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD8\x4A"],
        ["\xD8\x4A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\x9B"],

        ["\xE5\x87\xA0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD8\x5B"],
        ["\xD8\x5B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\xA0"],

        ["\xE8\x99\x95",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD8\x5A"],
        ["\xD8\x5A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x99\x95"],

        ["\xE5\x87\xA9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD8\x5F"],
        ["\xD8\x5F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\xA9"],

        ["\xE5\x87\xAD",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD8\x6D"],
        ["\xD8\x6D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\xAD"],

        ["\xE5\x87\xB0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD8\x79"],
        ["\xD8\x79",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\xB0"],

        ["\xE5\x87\xB5",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD8\x57"],
        ["\xD8\x57",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\xB5"],

        ["\xE5\x87\xBE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD8\x59"],
        ["\xD8\x59",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\xBE"],

        ["\xE5\x88\x84",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD8\x62"],
        ["\xD8\x62",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\x84"],

        ["\xE5\x88\x8B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD8\x63"],
        ["\xD8\x63",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\x8B"],

        ["\xE5\x88\x94",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD8\x64"],
        ["\xD8\x64",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\x94"],

        ["\xE5\x88\x8E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD8\x65"],
        ["\xD8\x65",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\x8E"],

        ["\xE5\x88\xA7",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD8\x66"],
        ["\xD8\x66",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\xA7"],

        ["\xE5\x88\xAA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD8\x67"],
        ["\xD8\x67",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\xAA"],

        ["\xE5\x88\xAE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD8\x68"],
        ["\xD8\x68",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\xAE"],

        ["\xE5\x88\xB3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD8\x69"],
        ["\xD8\x69",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\xB3"],

        ["\xE5\x88\xB9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD8\x70"],
        ["\xD8\x70",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\xB9"],

        ["\xE5\x89\x8F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD8\x71"],
        ["\xD8\x71",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\x8F"],

        ["\xE5\x89\x84",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD8\x72"],
        ["\xD8\x72",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\x84"],

        ["\xE5\x89\x8B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD8\x73"],
        ["\xD8\x73",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\x8B"],

        ["\xE5\x89\x8C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD8\x74"],
        ["\xD8\x74",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\x8C"],

        ["\xE5\x89\x9E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD8\x75"],
        ["\xD8\x75",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\x9E"],

        ["\xE5\x89\x94",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD8\x76"],
        ["\xD8\x76",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\x94"],

        ["\xE5\x89\xAA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD8\x77"],
        ["\xD8\x77",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\xAA"],

        ["\xE5\x89\xB4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD8\x78"],
        ["\xD8\x78",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\xB4"],

        ["\xE5\x89\xA9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD8\x80"],
        ["\xD8\x80",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\xA9"],

        ["\xE5\x89\xB3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD8\x8B"],
        ["\xD8\x8B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\xB3"],

        ["\xE5\x89\xBF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD8\x9B"],
        ["\xD8\x9B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\xBF"],

        ["\xE5\x89\xBD",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD8\x9C"],
        ["\xD8\x9C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\xBD"],

        ["\xE5\x8A\x8D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD8\xA0"],
        ["\xD8\xA0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\x8D"],

        ["\xE5\x8A\x94",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD8\xAB"],
        ["\xD8\xAB",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\x94"],

        ["\xE5\x8A\x92",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD8\xB0"],
        ["\xD8\xB0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\x92"],

        ["\xE5\x89\xB1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD8\xC0"],
        ["\xD8\xC0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\xB1"],

        ["\xE5\x8A\x88",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD8\x6A"],
        ["\xD8\x6A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\x88"],

        ["\xE5\x8A\x91",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD8\xD0"],
        ["\xD8\xD0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\x91"],

        ["\xE8\xBE\xA8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD8\xA1"],
        ["\xD8\xA1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBE\xA8"],

        ["\xE8\xBE\xA7",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD9\x4F"],
        ["\xD9\x4F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBE\xA7"],

        ["\xE5\x8A\xAC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD9\x7F"],
        ["\xD9\x7F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\xAC"],

        ["\xE5\x8A\xAD",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD9\x7B"],
        ["\xD9\x7B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\xAD"],

        ["\xE5\x8A\xBC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD9\xE0"],
        ["\xD9\xE0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\xBC"],

        ["\xE5\x8A\xB5",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD9\x6C"],
        ["\xD9\x6C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\xB5"],

        ["\xE5\x8B\x81",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD9\x50"],
        ["\xD9\x50",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\x81"],

        ["\xE5\x8B\x8D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD9\x7D"],
        ["\xD9\x7D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\x8D"],

        ["\xE5\x8B\x97",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD9\x4D"],
        ["\xD9\x4D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\x97"],

        ["\xE5\x8B\x9E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD9\x5D"],
        ["\xD9\x5D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\x9E"],

        ["\xE5\x8B\xA3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD9\x5C"],
        ["\xD9\x5C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\xA3"],

        ["\xE5\x8B\xA6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD9\x4E"],
        ["\xD9\x4E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\xA6"],

        ["\xE9\xA3\xAD",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD9\x6B"],
        ["\xD9\x6B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA3\xAD"],

        ["\xE5\x8B\xA0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD9\x60"],
        ["\xD9\x60",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\xA0"],

        ["\xE5\x8B\xB3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD9\x4B"],
        ["\xD9\x4B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\xB3"],

        ["\xE5\x8B\xB5",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD9\x61"],
        ["\xD9\x61",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\xB5"],

        ["\xE5\x8B\xB8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD9\xF0"],
        ["\xD9\xF0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\xB8"],

        ["\xE5\x8B\xB9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD9\xF1"],
        ["\xD9\xF1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\xB9"],

        ["\xE5\x8C\x86",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD9\xF2"],
        ["\xD9\xF2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\x86"],

        ["\xE5\x8C\x88",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD9\xF3"],
        ["\xD9\xF3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\x88"],

        ["\xE7\x94\xB8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD9\xF4"],
        ["\xD9\xF4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\xB8"],

        ["\xE5\x8C\x8D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD9\xF5"],
        ["\xD9\xF5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\x8D"],

        ["\xE5\x8C\x90",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD9\xF6"],
        ["\xD9\xF6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\x90"],

        ["\xE5\x8C\x8F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD9\xF7"],
        ["\xD9\xF7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\x8F"],

        ["\xE5\x8C\x95",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD9\xF8"],
        ["\xD9\xF8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\x95"],

        ["\xE5\x8C\x9A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD9\xF9"],
        ["\xD9\xF9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\x9A"],

        ["\xE5\x8C\xA3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD9\x7A"],
        ["\xD9\x7A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\xA3"],

        ["\xE5\x8C\xAF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD9\x5E"],
        ["\xD9\x5E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\xAF"],

        ["\xE5\x8C\xB1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD9\x4C"],
        ["\xD9\x4C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\xB1"],

        ["\xE5\x8C\xB3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD9\x7E"],
        ["\xD9\x7E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\xB3"],

        ["\xE5\x8C\xB8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD9\x6E"],
        ["\xD9\x6E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\xB8"],

        ["\xE5\x8D\x80",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD9\x6F"],
        ["\xD9\x6F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\x80"],

        ["\xE5\x8D\x86",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD9\x7C"],
        ["\xD9\x7C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\x86"],

        ["\xE5\x8D\x85",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD9\xC1"],
        ["\xD9\xC1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\x85"],

        ["\xE4\xB8\x97",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD9\xC2"],
        ["\xD9\xC2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\x97"],

        ["\xE5\x8D\x89",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD9\xC3"],
        ["\xD9\xC3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\x89"],

        ["\xE5\x8D\x8D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD9\xC4"],
        ["\xD9\xC4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\x8D"],

        ["\xE5\x87\x96",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD9\xC5"],
        ["\xD9\xC5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\x96"],

        ["\xE5\x8D\x9E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD9\xC6"],
        ["\xD9\xC6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\x9E"],

        ["\xE5\x8D\xA9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD9\xC7"],
        ["\xD9\xC7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\xA9"],

        ["\xE5\x8D\xAE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD9\xC8"],
        ["\xD9\xC8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\xAE"],

        ["\xE5\xA4\x98",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD9\xC9"],
        ["\xD9\xC9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\x98"],

        ["\xE5\x8D\xBB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD9\xD1"],
        ["\xD9\xD1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\xBB"],

        ["\xE5\x8D\xB7",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD9\xD2"],
        ["\xD9\xD2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\xB7"],

        ["\xE5\x8E\x82",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD9\xD3"],
        ["\xD9\xD3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8E\x82"],

        ["\xE5\x8E\x96",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD9\xD4"],
        ["\xD9\xD4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8E\x96"],

        ["\xE5\x8E\xA0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD9\xD5"],
        ["\xD9\xD5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8E\xA0"],

        ["\xE5\x8E\xA6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD9\xD6"],
        ["\xD9\xD6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8E\xA6"],

        ["\xE5\x8E\xA5",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD9\xD7"],
        ["\xD9\xD7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8E\xA5"],

        ["\xE5\x8E\xAE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD9\xD8"],
        ["\xD9\xD8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8E\xAE"],

        ["\xE5\x8E\xB0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD9\xD9"],
        ["\xD9\xD9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8E\xB0"],

        ["\xE5\x8E\xB6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD9\xE2"],
        ["\xD9\xE2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8E\xB6"],

        ["\xE5\x8F\x83",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD9\xE3"],
        ["\xD9\xE3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\x83"],

        ["\xE7\xB0\x92",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD9\xE4"],
        ["\xD9\xE4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB0\x92"],

        ["\xE9\x9B\x99",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD9\xE5"],
        ["\xD9\xE5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\x99"],

        ["\xE5\x8F\x9F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD9\xE6"],
        ["\xD9\xE6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\x9F"],

        ["\xE6\x9B\xBC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD9\xE7"],
        ["\xD9\xE7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\xBC"],

        ["\xE7\x87\xAE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD9\xE8"],
        ["\xD9\xE8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x87\xAE"],

        ["\xE5\x8F\xAE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD9\xE9"],
        ["\xD9\xE9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\xAE"],

        ["\xE5\x8F\xA8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD9\x4A"],
        ["\xD9\x4A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\xA8"],

        ["\xE5\x8F\xAD",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD9\x5B"],
        ["\xD9\x5B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\xAD"],

        ["\xE5\x8F\xBA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD9\x5A"],
        ["\xD9\x5A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\xBA"],

        ["\xE5\x90\x81",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD9\x5F"],
        ["\xD9\x5F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\x81"],

        ["\xE5\x90\xBD",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD9\x6D"],
        ["\xD9\x6D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\xBD"],

        ["\xE5\x91\x80",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD9\x79"],
        ["\xD9\x79",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x91\x80"],

        ["\xE5\x90\xAC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD9\x57"],
        ["\xD9\x57",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\xAC"],

        ["\xE5\x90\xAD",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD9\x59"],
        ["\xD9\x59",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\xAD"],

        ["\xE5\x90\xBC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD9\x62"],
        ["\xD9\x62",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\xBC"],

        ["\xE5\x90\xAE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD9\x63"],
        ["\xD9\x63",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\xAE"],

        ["\xE5\x90\xB6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD9\x64"],
        ["\xD9\x64",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\xB6"],

        ["\xE5\x90\xA9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD9\x65"],
        ["\xD9\x65",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\xA9"],

        ["\xE5\x90\x9D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD9\x66"],
        ["\xD9\x66",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\x9D"],

        ["\xE5\x91\x8E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD9\x67"],
        ["\xD9\x67",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x91\x8E"],

        ["\xE5\x92\x8F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD9\x68"],
        ["\xD9\x68",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\x8F"],

        ["\xE5\x91\xB5",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD9\x69"],
        ["\xD9\x69",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x91\xB5"],

        ["\xE5\x92\x8E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD9\x70"],
        ["\xD9\x70",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\x8E"],

        ["\xE5\x91\x9F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD9\x71"],
        ["\xD9\x71",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x91\x9F"],

        ["\xE5\x91\xB1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD9\x72"],
        ["\xD9\x72",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x91\xB1"],

        ["\xE5\x91\xB7",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD9\x73"],
        ["\xD9\x73",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x91\xB7"],

        ["\xE5\x91\xB0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD9\x74"],
        ["\xD9\x74",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x91\xB0"],

        ["\xE5\x92\x92",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD9\x75"],
        ["\xD9\x75",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\x92"],

        ["\xE5\x91\xBB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD9\x76"],
        ["\xD9\x76",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x91\xBB"],

        ["\xE5\x92\x80",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD9\x77"],
        ["\xD9\x77",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\x80"],

        ["\xE5\x91\xB6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD9\x78"],
        ["\xD9\x78",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x91\xB6"],

        ["\xE5\x92\x84",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD9\x80"],
        ["\xD9\x80",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\x84"],

        ["\xE5\x92\x90",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD9\x8B"],
        ["\xD9\x8B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\x90"],

        ["\xE5\x92\x86",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD9\x9B"],
        ["\xD9\x9B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\x86"],

        ["\xE5\x93\x87",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD9\x9C"],
        ["\xD9\x9C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x93\x87"],

        ["\xE5\x92\xA2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD9\xA0"],
        ["\xD9\xA0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\xA2"],

        ["\xE5\x92\xB8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD9\xAB"],
        ["\xD9\xAB",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\xB8"],

        ["\xE5\x92\xA5",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD9\xB0"],
        ["\xD9\xB0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\xA5"],

        ["\xE5\x92\xAC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD9\xC0"],
        ["\xD9\xC0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\xAC"],

        ["\xE5\x93\x84",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD9\x6A"],
        ["\xD9\x6A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x93\x84"],

        ["\xE5\x93\x88",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD9\xD0"],
        ["\xD9\xD0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x93\x88"],

        ["\xE5\x92\xA8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD9\xA1"],
        ["\xD9\xA1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\xA8"],

        ["\xE5\x92\xAB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE2\x4F"],
        ["\xE2\x4F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\xAB"],

        ["\xE5\x93\x82",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE2\x7F"],
        ["\xE2\x7F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x93\x82"],

        ["\xE5\x92\xA4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE2\x7B"],
        ["\xE2\x7B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\xA4"],

        ["\xE5\x92\xBE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE2\xE0"],
        ["\xE2\xE0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\xBE"],

        ["\xE5\x92\xBC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE2\x6C"],
        ["\xE2\x6C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\xBC"],

        ["\xE5\x93\x98",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE2\x50"],
        ["\xE2\x50",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x93\x98"],

        ["\xE5\x93\xA5",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE2\x7D"],
        ["\xE2\x7D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x93\xA5"],

        ["\xE5\x93\xA6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE2\x4D"],
        ["\xE2\x4D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x93\xA6"],

        ["\xE5\x94\x8F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE2\x5D"],
        ["\xE2\x5D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x94\x8F"],

        ["\xE5\x94\x94",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE2\x5C"],
        ["\xE2\x5C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x94\x94"],

        ["\xE5\x93\xBD",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE2\x4E"],
        ["\xE2\x4E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x93\xBD"],

        ["\xE5\x93\xAE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE2\x6B"],
        ["\xE2\x6B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x93\xAE"],

        ["\xE5\x93\xAD",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE2\x60"],
        ["\xE2\x60",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x93\xAD"],

        ["\xE5\x93\xBA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE2\x4B"],
        ["\xE2\x4B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x93\xBA"],

        ["\xE5\x93\xA2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE2\x61"],
        ["\xE2\x61",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x93\xA2"],

        ["\xE5\x94\xB9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE2\xF0"],
        ["\xE2\xF0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x94\xB9"],

        ["\xE5\x95\x80",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE2\xF1"],
        ["\xE2\xF1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x95\x80"],

        ["\xE5\x95\xA3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE2\xF2"],
        ["\xE2\xF2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x95\xA3"],

        ["\xE5\x95\x8C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE2\xF3"],
        ["\xE2\xF3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x95\x8C"],

        ["\xE5\x94\xAE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE2\xF4"],
        ["\xE2\xF4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x94\xAE"],

        ["\xE5\x95\x9C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE2\xF5"],
        ["\xE2\xF5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x95\x9C"],

        ["\xE5\x95\x85",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE2\xF6"],
        ["\xE2\xF6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x95\x85"],

        ["\xE5\x95\x96",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE2\xF7"],
        ["\xE2\xF7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x95\x96"],

        ["\xE5\x95\x97",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE2\xF8"],
        ["\xE2\xF8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x95\x97"],

        ["\xE5\x94\xB8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE2\xF9"],
        ["\xE2\xF9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x94\xB8"],

        ["\xE5\x94\xB3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE2\x7A"],
        ["\xE2\x7A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x94\xB3"],

        ["\xE5\x95\x9D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE2\x5E"],
        ["\xE2\x5E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x95\x9D"],

        ["\xE5\x96\x99",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE2\x4C"],
        ["\xE2\x4C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x96\x99"],

        ["\xE5\x96\x80",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE2\x7E"],
        ["\xE2\x7E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x96\x80"],

        ["\xE5\x92\xAF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE2\x6E"],
        ["\xE2\x6E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\xAF"],

        ["\xE5\x96\x8A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE2\x6F"],
        ["\xE2\x6F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x96\x8A"],

        ["\xE5\x96\x9F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE2\x7C"],
        ["\xE2\x7C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x96\x9F"],

        ["\xE5\x95\xBB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE2\xC1"],
        ["\xE2\xC1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x95\xBB"],

        ["\xE5\x95\xBE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE2\xC2"],
        ["\xE2\xC2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x95\xBE"],

        ["\xE5\x96\x98",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE2\xC3"],
        ["\xE2\xC3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x96\x98"],

        ["\xE5\x96\x9E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE2\xC4"],
        ["\xE2\xC4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x96\x9E"],

        ["\xE5\x96\xAE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE2\xC5"],
        ["\xE2\xC5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x96\xAE"],

        ["\xE5\x95\xBC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE2\xC6"],
        ["\xE2\xC6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x95\xBC"],

        ["\xE5\x96\x83",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE2\xC7"],
        ["\xE2\xC7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x96\x83"],

        ["\xE5\x96\xA9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE2\xC8"],
        ["\xE2\xC8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x96\xA9"],

        ["\xE5\x96\x87",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE2\xC9"],
        ["\xE2\xC9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x96\x87"],

        ["\xE5\x96\xA8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE2\xD1"],
        ["\xE2\xD1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x96\xA8"],

        ["\xE5\x97\x9A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE2\xD2"],
        ["\xE2\xD2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x97\x9A"],

        ["\xE5\x97\x85",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE2\xD3"],
        ["\xE2\xD3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x97\x85"],

        ["\xE5\x97\x9F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE2\xD4"],
        ["\xE2\xD4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x97\x9F"],

        ["\xE5\x97\x84",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE2\xD5"],
        ["\xE2\xD5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x97\x84"],

        ["\xE5\x97\x9C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE2\xD6"],
        ["\xE2\xD6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x97\x9C"],

        ["\xE5\x97\xA4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE2\xD7"],
        ["\xE2\xD7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x97\xA4"],

        ["\xE5\x97\x94",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE2\xD8"],
        ["\xE2\xD8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x97\x94"],

        ["\xE5\x98\x94",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE2\xD9"],
        ["\xE2\xD9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x98\x94"],

        ["\xE5\x97\xB7",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE2\xE2"],
        ["\xE2\xE2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x97\xB7"],

        ["\xE5\x98\x96",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE2\xE3"],
        ["\xE2\xE3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x98\x96"],

        ["\xE5\x97\xBE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE2\xE4"],
        ["\xE2\xE4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x97\xBE"],

        ["\xE5\x97\xBD",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE2\xE5"],
        ["\xE2\xE5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x97\xBD"],

        ["\xE5\x98\x9B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE2\xE6"],
        ["\xE2\xE6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x98\x9B"],

        ["\xE5\x97\xB9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE2\xE7"],
        ["\xE2\xE7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x97\xB9"],

        ["\xE5\x99\x8E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE2\xE8"],
        ["\xE2\xE8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x99\x8E"],

        ["\xE5\x99\x90",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE2\xE9"],
        ["\xE2\xE9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x99\x90"],

        ["\xE7\x87\x9F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE2\x4A"],
        ["\xE2\x4A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x87\x9F"],

        ["\xE5\x98\xB4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE2\x5B"],
        ["\xE2\x5B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x98\xB4"],

        ["\xE5\x98\xB6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE2\x5A"],
        ["\xE2\x5A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x98\xB6"],

        ["\xE5\x98\xB2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE2\x5F"],
        ["\xE2\x5F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x98\xB2"],

        ["\xE5\x98\xB8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE2\x6D"],
        ["\xE2\x6D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x98\xB8"],

        ["\xE5\x99\xAB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE2\x79"],
        ["\xE2\x79",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x99\xAB"],

        ["\xE5\x99\xA4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE2\x57"],
        ["\xE2\x57",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x99\xA4"],

        ["\xE5\x98\xAF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE2\x59"],
        ["\xE2\x59",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x98\xAF"],

        ["\xE5\x99\xAC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE2\x62"],
        ["\xE2\x62",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x99\xAC"],

        ["\xE5\x99\xAA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE2\x63"],
        ["\xE2\x63",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x99\xAA"],

        ["\xE5\x9A\x86",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE2\x64"],
        ["\xE2\x64",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9A\x86"],

        ["\xE5\x9A\x80",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE2\x65"],
        ["\xE2\x65",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9A\x80"],

        ["\xE5\x9A\x8A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE2\x66"],
        ["\xE2\x66",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9A\x8A"],

        ["\xE5\x9A\xA0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE2\x67"],
        ["\xE2\x67",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9A\xA0"],

        ["\xE5\x9A\x94",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE2\x68"],
        ["\xE2\x68",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9A\x94"],

        ["\xE5\x9A\x8F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE2\x69"],
        ["\xE2\x69",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9A\x8F"],

        ["\xE5\x9A\xA5",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE2\x70"],
        ["\xE2\x70",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9A\xA5"],

        ["\xE5\x9A\xAE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE2\x71"],
        ["\xE2\x71",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9A\xAE"],

        ["\xE5\x9A\xB6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE2\x72"],
        ["\xE2\x72",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9A\xB6"],

        ["\xE5\x9A\xB4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE2\x73"],
        ["\xE2\x73",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9A\xB4"],

        ["\xE5\x9B\x82",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE2\x74"],
        ["\xE2\x74",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B\x82"],

        ["\xE5\x9A\xBC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE2\x75"],
        ["\xE2\x75",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9A\xBC"],

        ["\xE5\x9B\x81",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE2\x76"],
        ["\xE2\x76",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B\x81"],

        ["\xE5\x9B\x83",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE2\x77"],
        ["\xE2\x77",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B\x83"],

        ["\xE5\x9B\x80",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE2\x78"],
        ["\xE2\x78",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B\x80"],

        ["\xE5\x9B\x88",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE2\x80"],
        ["\xE2\x80",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B\x88"],

        ["\xE5\x9B\x8E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE2\x8B"],
        ["\xE2\x8B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B\x8E"],

        ["\xE5\x9B\x91",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE2\x9B"],
        ["\xE2\x9B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B\x91"],

        ["\xE5\x9B\x93",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE2\x9C"],
        ["\xE2\x9C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B\x93"],

        ["\xE5\x9B\x97",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE2\xA0"],
        ["\xE2\xA0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B\x97"],

        ["\xE5\x9B\xAE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE2\xAB"],
        ["\xE2\xAB",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B\xAE"],

        ["\xE5\x9B\xB9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE2\xB0"],
        ["\xE2\xB0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B\xB9"],

        ["\xE5\x9C\x80",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE2\xC0"],
        ["\xE2\xC0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C\x80"],

        ["\xE5\x9B\xBF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE2\x6A"],
        ["\xE2\x6A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B\xBF"],

        ["\xE5\x9C\x84",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE2\xD0"],
        ["\xE2\xD0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C\x84"],

        ["\xE5\x9C\x89",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE2\xA1"],
        ["\xE2\xA1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C\x89"],

        ["\xE5\x9C\x88",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE3\x4F"],
        ["\xE3\x4F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C\x88"],

        ["\xE5\x9C\x8B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE3\x7F"],
        ["\xE3\x7F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C\x8B"],

        ["\xE5\x9C\x8D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE3\x7B"],
        ["\xE3\x7B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C\x8D"],

        ["\xE5\x9C\x93",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE3\xE0"],
        ["\xE3\xE0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C\x93"],

        ["\xE5\x9C\x98",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE3\x6C"],
        ["\xE3\x6C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C\x98"],

        ["\xE5\x9C\x96",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE3\x50"],
        ["\xE3\x50",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C\x96"],

        ["\xE5\x97\x87",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE3\x7D"],
        ["\xE3\x7D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x97\x87"],

        ["\xE5\x9C\x9C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE3\x4D"],
        ["\xE3\x4D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C\x9C"],

        ["\xE5\x9C\xA6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE3\x5D"],
        ["\xE3\x5D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C\xA6"],

        ["\xE5\x9C\xB7",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE3\x5C"],
        ["\xE3\x5C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C\xB7"],

        ["\xE5\x9C\xB8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE3\x4E"],
        ["\xE3\x4E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C\xB8"],

        ["\xE5\x9D\x8E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE3\x6B"],
        ["\xE3\x6B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9D\x8E"],

        ["\xE5\x9C\xBB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE3\x60"],
        ["\xE3\x60",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C\xBB"],

        ["\xE5\x9D\x80",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE3\x4B"],
        ["\xE3\x4B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9D\x80"],

        ["\xE5\x9D\x8F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE3\x61"],
        ["\xE3\x61",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9D\x8F"],

        ["\xE5\x9D\xA9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE3\xF0"],
        ["\xE3\xF0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9D\xA9"],

        ["\xE5\x9F\x80",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE3\xF1"],
        ["\xE3\xF1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9F\x80"],

        ["\xE5\x9E\x88",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE3\xF2"],
        ["\xE3\xF2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9E\x88"],

        ["\xE5\x9D\xA1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE3\xF3"],
        ["\xE3\xF3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9D\xA1"],

        ["\xE5\x9D\xBF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE3\xF4"],
        ["\xE3\xF4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9D\xBF"],

        ["\xE5\x9E\x89",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE3\xF5"],
        ["\xE3\xF5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9E\x89"],

        ["\xE5\x9E\x93",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE3\xF6"],
        ["\xE3\xF6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9E\x93"],

        ["\xE5\x9E\xA0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE3\xF7"],
        ["\xE3\xF7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9E\xA0"],

        ["\xE5\x9E\xB3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE3\xF8"],
        ["\xE3\xF8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9E\xB3"],

        ["\xE5\x9E\xA4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE3\xF9"],
        ["\xE3\xF9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9E\xA4"],

        ["\xE5\x9E\xAA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE3\x7A"],
        ["\xE3\x7A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9E\xAA"],

        ["\xE5\x9E\xB0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE3\x5E"],
        ["\xE3\x5E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9E\xB0"],

        ["\xE5\x9F\x83",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE3\x4C"],
        ["\xE3\x4C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9F\x83"],

        ["\xE5\x9F\x86",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE3\x7E"],
        ["\xE3\x7E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9F\x86"],

        ["\xE5\x9F\x94",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE3\x6E"],
        ["\xE3\x6E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9F\x94"],

        ["\xE5\x9F\x92",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE3\x6F"],
        ["\xE3\x6F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9F\x92"],

        ["\xE5\x9F\x93",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE3\x7C"],
        ["\xE3\x7C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9F\x93"],

        ["\xE5\xA0\x8A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE3\xC1"],
        ["\xE3\xC1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA0\x8A"],

        ["\xE5\x9F\x96",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE3\xC2"],
        ["\xE3\xC2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9F\x96"],

        ["\xE5\x9F\xA3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE3\xC3"],
        ["\xE3\xC3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9F\xA3"],

        ["\xE5\xA0\x8B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE3\xC4"],
        ["\xE3\xC4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA0\x8B"],

        ["\xE5\xA0\x99",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE3\xC5"],
        ["\xE3\xC5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA0\x99"],

        ["\xE5\xA0\x9D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE3\xC6"],
        ["\xE3\xC6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA0\x9D"],

        ["\xE5\xA1\xB2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE3\xC7"],
        ["\xE3\xC7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA1\xB2"],

        ["\xE5\xA0\xA1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE3\xC8"],
        ["\xE3\xC8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA0\xA1"],

        ["\xE5\xA1\xA2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE3\xC9"],
        ["\xE3\xC9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA1\xA2"],

        ["\xE5\xA1\x8B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE3\xD1"],
        ["\xE3\xD1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA1\x8B"],

        ["\xE5\xA1\xB0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE3\xD2"],
        ["\xE3\xD2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA1\xB0"],

        ["\xE6\xAF\x80",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE3\xD3"],
        ["\xE3\xD3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAF\x80"],

        ["\xE5\xA1\x92",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE3\xD4"],
        ["\xE3\xD4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA1\x92"],

        ["\xE5\xA0\xBD",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE3\xD5"],
        ["\xE3\xD5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA0\xBD"],

        ["\xE5\xA1\xB9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE3\xD6"],
        ["\xE3\xD6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA1\xB9"],

        ["\xE5\xA2\x85",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE3\xD7"],
        ["\xE3\xD7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA2\x85"],

        ["\xE5\xA2\xB9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE3\xD8"],
        ["\xE3\xD8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA2\xB9"],

        ["\xE5\xA2\x9F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE3\xD9"],
        ["\xE3\xD9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA2\x9F"],

        ["\xE5\xA2\xAB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE3\xE2"],
        ["\xE3\xE2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA2\xAB"],

        ["\xE5\xA2\xBA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE3\xE3"],
        ["\xE3\xE3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA2\xBA"],

        ["\xE5\xA3\x9E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE3\xE4"],
        ["\xE3\xE4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\x9E"],

        ["\xE5\xA2\xBB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE3\xE5"],
        ["\xE3\xE5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA2\xBB"],

        ["\xE5\xA2\xB8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE3\xE6"],
        ["\xE3\xE6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA2\xB8"],

        ["\xE5\xA2\xAE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE3\xE7"],
        ["\xE3\xE7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA2\xAE"],

        ["\xE5\xA3\x85",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE3\xE8"],
        ["\xE3\xE8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\x85"],

        ["\xE5\xA3\x93",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE3\xE9"],
        ["\xE3\xE9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\x93"],

        ["\xE5\xA3\x91",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE3\x4A"],
        ["\xE3\x4A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\x91"],

        ["\xE5\xA3\x97",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE3\x5B"],
        ["\xE3\x5B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\x97"],

        ["\xE5\xA3\x99",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE3\x5A"],
        ["\xE3\x5A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\x99"],

        ["\xE5\xA3\x98",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE3\x5F"],
        ["\xE3\x5F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\x98"],

        ["\xE5\xA3\xA5",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE3\x6D"],
        ["\xE3\x6D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\xA5"],

        ["\xE5\xA3\x9C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE3\x79"],
        ["\xE3\x79",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\x9C"],

        ["\xE5\xA3\xA4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE3\x57"],
        ["\xE3\x57",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\xA4"],

        ["\xE5\xA3\x9F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE3\x59"],
        ["\xE3\x59",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\x9F"],

        ["\xE5\xA3\xAF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE3\x62"],
        ["\xE3\x62",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\xAF"],

        ["\xE5\xA3\xBA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC4\x4A"],
        ["\xC4\x4A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\xBA"],

        ["\xE5\xA3\xB9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE3\x64"],
        ["\xE3\x64",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\xB9"],

        ["\xE5\xA3\xBB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE3\x65"],
        ["\xE3\x65",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\xBB"],

        ["\xE5\xA3\xBC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE3\x66"],
        ["\xE3\x66",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\xBC"],

        ["\xE5\xA3\xBD",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE3\x67"],
        ["\xE3\x67",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\xBD"],

        ["\xE5\xA4\x82",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE3\x68"],
        ["\xE3\x68",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\x82"],

        ["\xE5\xA4\x8A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE3\x69"],
        ["\xE3\x69",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\x8A"],

        ["\xE5\xA4\x90",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE3\x70"],
        ["\xE3\x70",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\x90"],

        ["\xE5\xA4\x9B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE3\x71"],
        ["\xE3\x71",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\x9B"],

        ["\xE6\xA2\xA6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE3\x72"],
        ["\xE3\x72",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\xA6"],

        ["\xE5\xA4\xA5",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE3\x73"],
        ["\xE3\x73",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\xA5"],

        ["\xE5\xA4\xAC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE3\x74"],
        ["\xE3\x74",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\xAC"],

        ["\xE5\xA4\xAD",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE3\x75"],
        ["\xE3\x75",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\xAD"],

        ["\xE5\xA4\xB2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE3\x76"],
        ["\xE3\x76",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\xB2"],

        ["\xE5\xA4\xB8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE3\x77"],
        ["\xE3\x77",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\xB8"],

        ["\xE5\xA4\xBE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE3\x78"],
        ["\xE3\x78",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\xBE"],

        ["\xE7\xAB\x92",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE3\x80"],
        ["\xE3\x80",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\x92"],

        ["\xE5\xA5\x95",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE3\x8B"],
        ["\xE3\x8B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\x95"],

        ["\xE5\xA5\x90",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE3\x9B"],
        ["\xE3\x9B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\x90"],

        ["\xE5\xA5\x8E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE3\x9C"],
        ["\xE3\x9C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\x8E"],

        ["\xE5\xA5\x9A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE3\xA0"],
        ["\xE3\xA0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\x9A"],

        ["\xE5\xA5\x98",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE3\xAB"],
        ["\xE3\xAB",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\x98"],

        ["\xE5\xA5\xA2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE3\xB0"],
        ["\xE3\xB0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\xA2"],

        ["\xE5\xA5\xA0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE3\xC0"],
        ["\xE3\xC0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\xA0"],

        ["\xE5\xA5\xA7",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE3\x6A"],
        ["\xE3\x6A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\xA7"],

        ["\xE5\xA5\xAC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE3\xD0"],
        ["\xE3\xD0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\xAC"],

        ["\xE5\xA5\xA9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE3\xA1"],
        ["\xE3\xA1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\xA9"],

        ["\xE5\xA5\xB8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE4\x4F"],
        ["\xE4\x4F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\xB8"],

        ["\xE5\xA6\x81",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE4\x7F"],
        ["\xE4\x7F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA6\x81"],

        ["\xE5\xA6\x9D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE4\x7B"],
        ["\xE4\x7B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA6\x9D"],

        ["\xE4\xBD\x9E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE4\xE0"],
        ["\xE4\xE0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\x9E"],

        ["\xE4\xBE\xAB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE4\x6C"],
        ["\xE4\x6C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE\xAB"],

        ["\xE5\xA6\xA3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE4\x50"],
        ["\xE4\x50",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA6\xA3"],

        ["\xE5\xA6\xB2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE4\x7D"],
        ["\xE4\x7D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA6\xB2"],

        ["\xE5\xA7\x86",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE4\x4D"],
        ["\xE4\x4D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA7\x86"],

        ["\xE5\xA7\xA8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE4\x5D"],
        ["\xE4\x5D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA7\xA8"],

        ["\xE5\xA7\x9C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE4\x5C"],
        ["\xE4\x5C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA7\x9C"],

        ["\xE5\xA6\x8D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE4\x4E"],
        ["\xE4\x4E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA6\x8D"],

        ["\xE5\xA7\x99",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE4\x6B"],
        ["\xE4\x6B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA7\x99"],

        ["\xE5\xA7\x9A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE4\x60"],
        ["\xE4\x60",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA7\x9A"],

        ["\xE5\xA8\xA5",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE4\x4B"],
        ["\xE4\x4B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA8\xA5"],

        ["\xE5\xA8\x9F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE4\x61"],
        ["\xE4\x61",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA8\x9F"],

        ["\xE5\xA8\x91",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE4\xF0"],
        ["\xE4\xF0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA8\x91"],

        ["\xE5\xA8\x9C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE4\xF1"],
        ["\xE4\xF1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA8\x9C"],

        ["\xE5\xA8\x89",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE4\xF2"],
        ["\xE4\xF2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA8\x89"],

        ["\xE5\xA8\x9A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE4\xF3"],
        ["\xE4\xF3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA8\x9A"],

        ["\xE5\xA9\x80",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE4\xF4"],
        ["\xE4\xF4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA9\x80"],

        ["\xE5\xA9\xAC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE4\xF5"],
        ["\xE4\xF5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA9\xAC"],

        ["\xE5\xA9\x89",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE4\xF6"],
        ["\xE4\xF6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA9\x89"],

        ["\xE5\xA8\xB5",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE4\xF7"],
        ["\xE4\xF7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA8\xB5"],

        ["\xE5\xA8\xB6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE4\xF8"],
        ["\xE4\xF8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA8\xB6"],

        ["\xE5\xA9\xA2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE4\xF9"],
        ["\xE4\xF9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA9\xA2"],

        ["\xE5\xA9\xAA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE4\x7A"],
        ["\xE4\x7A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA9\xAA"],

        ["\xE5\xAA\x9A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE4\x5E"],
        ["\xE4\x5E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAA\x9A"],

        ["\xE5\xAA\xBC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE4\x4C"],
        ["\xE4\x4C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAA\xBC"],

        ["\xE5\xAA\xBE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE4\x7E"],
        ["\xE4\x7E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAA\xBE"],

        ["\xE5\xAB\x8B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE4\x6E"],
        ["\xE4\x6E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAB\x8B"],

        ["\xE5\xAB\x82",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE4\x6F"],
        ["\xE4\x6F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAB\x82"],

        ["\xE5\xAA\xBD",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE4\x7C"],
        ["\xE4\x7C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAA\xBD"],

        ["\xE5\xAB\xA3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE4\xC1"],
        ["\xE4\xC1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAB\xA3"],

        ["\xE5\xAB\x97",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE4\xC2"],
        ["\xE4\xC2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAB\x97"],

        ["\xE5\xAB\xA6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE4\xC3"],
        ["\xE4\xC3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAB\xA6"],

        ["\xE5\xAB\xA9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE4\xC4"],
        ["\xE4\xC4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAB\xA9"],

        ["\xE5\xAB\x96",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE4\xC5"],
        ["\xE4\xC5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAB\x96"],

        ["\xE5\xAB\xBA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE4\xC6"],
        ["\xE4\xC6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAB\xBA"],

        ["\xE5\xAB\xBB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE4\xC7"],
        ["\xE4\xC7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAB\xBB"],

        ["\xE5\xAC\x8C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE4\xC8"],
        ["\xE4\xC8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAC\x8C"],

        ["\xE5\xAC\x8B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE4\xC9"],
        ["\xE4\xC9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAC\x8B"],

        ["\xE5\xAC\x96",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE4\xD1"],
        ["\xE4\xD1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAC\x96"],

        ["\xE5\xAC\xB2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE4\xD2"],
        ["\xE4\xD2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAC\xB2"],

        ["\xE5\xAB\x90",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE4\xD3"],
        ["\xE4\xD3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAB\x90"],

        ["\xE5\xAC\xAA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE4\xD4"],
        ["\xE4\xD4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAC\xAA"],

        ["\xE5\xAC\xB6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE4\xD5"],
        ["\xE4\xD5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAC\xB6"],

        ["\xE5\xAC\xBE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE4\xD6"],
        ["\xE4\xD6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAC\xBE"],

        ["\xE5\xAD\x83",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE4\xD7"],
        ["\xE4\xD7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\x83"],

        ["\xE5\xAD\x85",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE4\xD8"],
        ["\xE4\xD8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\x85"],

        ["\xE5\xAD\x80",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE4\xD9"],
        ["\xE4\xD9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\x80"],

        ["\xE5\xAD\x91",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE4\xE2"],
        ["\xE4\xE2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\x91"],

        ["\xE5\xAD\x95",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE4\xE3"],
        ["\xE4\xE3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\x95"],

        ["\xE5\xAD\x9A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE4\xE4"],
        ["\xE4\xE4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\x9A"],

        ["\xE5\xAD\x9B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE4\xE5"],
        ["\xE4\xE5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\x9B"],

        ["\xE5\xAD\xA5",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE4\xE6"],
        ["\xE4\xE6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\xA5"],

        ["\xE5\xAD\xA9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE4\xE7"],
        ["\xE4\xE7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\xA9"],

        ["\xE5\xAD\xB0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE4\xE8"],
        ["\xE4\xE8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\xB0"],

        ["\xE5\xAD\xB3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE4\xE9"],
        ["\xE4\xE9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\xB3"],

        ["\xE5\xAD\xB5",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE4\x4A"],
        ["\xE4\x4A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\xB5"],

        ["\xE5\xAD\xB8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE4\x5B"],
        ["\xE4\x5B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\xB8"],

        ["\xE6\x96\x88",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE4\x5A"],
        ["\xE4\x5A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\x88"],

        ["\xE5\xAD\xBA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE4\x5F"],
        ["\xE4\x5F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\xBA"],

        ["\xE5\xAE\x80",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE4\x6D"],
        ["\xE4\x6D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\x80"],

        ["\xE5\xAE\x83",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE4\x79"],
        ["\xE4\x79",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\x83"],

        ["\xE5\xAE\xA6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE4\x57"],
        ["\xE4\x57",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\xA6"],

        ["\xE5\xAE\xB8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE4\x59"],
        ["\xE4\x59",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\xB8"],

        ["\xE5\xAF\x83",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE4\x62"],
        ["\xE4\x62",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\x83"],

        ["\xE5\xAF\x87",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE4\x63"],
        ["\xE4\x63",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\x87"],

        ["\xE5\xAF\x89",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE4\x64"],
        ["\xE4\x64",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\x89"],

        ["\xE5\xAF\x94",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE4\x65"],
        ["\xE4\x65",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\x94"],

        ["\xE5\xAF\x90",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE4\x66"],
        ["\xE4\x66",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\x90"],

        ["\xE5\xAF\xA4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE4\x67"],
        ["\xE4\x67",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\xA4"],

        ["\xE5\xAF\xA6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE4\x68"],
        ["\xE4\x68",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\xA6"],

        ["\xE5\xAF\xA2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE4\x69"],
        ["\xE4\x69",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\xA2"],

        ["\xE5\xAF\x9E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE4\x70"],
        ["\xE4\x70",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\x9E"],

        ["\xE5\xAF\xA5",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE4\x71"],
        ["\xE4\x71",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\xA5"],

        ["\xE5\xAF\xAB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE4\x72"],
        ["\xE4\x72",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\xAB"],

        ["\xE5\xAF\xB0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE4\x73"],
        ["\xE4\x73",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\xB0"],

        ["\xE5\xAF\xB6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE4\x74"],
        ["\xE4\x74",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\xB6"],

        ["\xE5\xAF\xB3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE4\x75"],
        ["\xE4\x75",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\xB3"],

        ["\xE5\xB0\x85",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE4\x76"],
        ["\xE4\x76",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\x85"],

        ["\xE5\xB0\x87",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE4\x77"],
        ["\xE4\x77",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\x87"],

        ["\xE5\xB0\x88",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE4\x78"],
        ["\xE4\x78",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\x88"],

        ["\xE5\xB0\x8D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE4\x80"],
        ["\xE4\x80",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\x8D"],

        ["\xE5\xB0\x93",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE4\x8B"],
        ["\xE4\x8B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\x93"],

        ["\xE5\xB0\xA0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE4\x9B"],
        ["\xE4\x9B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\xA0"],

        ["\xE5\xB0\xA2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE4\x9C"],
        ["\xE4\x9C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\xA2"],

        ["\xE5\xB0\xA8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE4\xA0"],
        ["\xE4\xA0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\xA8"],

        ["\xE5\xB0\xB8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE4\xAB"],
        ["\xE4\xAB",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\xB8"],

        ["\xE5\xB0\xB9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE4\xB0"],
        ["\xE4\xB0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\xB9"],

        ["\xE5\xB1\x81",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE4\xC0"],
        ["\xE4\xC0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\x81"],

        ["\xE5\xB1\x86",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE4\x6A"],
        ["\xE4\x6A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\x86"],

        ["\xE5\xB1\x8E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE4\xD0"],
        ["\xE4\xD0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\x8E"],

        ["\xE5\xB1\x93",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE4\xA1"],
        ["\xE4\xA1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\x93"],

        ["\xE5\xB1\x90",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE5\x4F"],
        ["\xE5\x4F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\x90"],

        ["\xE5\xB1\x8F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE5\x7F"],
        ["\xE5\x7F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\x8F"],

        ["\xE5\xAD\xB1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE5\x7B"],
        ["\xE5\x7B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\xB1"],

        ["\xE5\xB1\xAC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE5\xE0"],
        ["\xE5\xE0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\xAC"],

        ["\xE5\xB1\xAE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE5\x6C"],
        ["\xE5\x6C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\xAE"],

        ["\xE4\xB9\xA2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE5\x50"],
        ["\xE5\x50",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xB9\xA2"],

        ["\xE5\xB1\xB6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE5\x7D"],
        ["\xE5\x7D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\xB6"],

        ["\xE5\xB1\xB9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE5\x4D"],
        ["\xE5\x4D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\xB9"],

        ["\xE5\xB2\x8C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE5\x5D"],
        ["\xE5\x5D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB2\x8C"],

        ["\xE5\xB2\x91",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE5\x5C"],
        ["\xE5\x5C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB2\x91"],

        ["\xE5\xB2\x94",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE5\x4E"],
        ["\xE5\x4E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB2\x94"],

        ["\xE5\xA6\x9B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE5\x6B"],
        ["\xE5\x6B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA6\x9B"],

        ["\xE5\xB2\xAB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE5\x60"],
        ["\xE5\x60",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB2\xAB"],

        ["\xE5\xB2\xBB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE5\x4B"],
        ["\xE5\x4B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB2\xBB"],

        ["\xE5\xB2\xB6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE5\x61"],
        ["\xE5\x61",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB2\xB6"],

        ["\xE5\xB2\xBC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE5\xF0"],
        ["\xE5\xF0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB2\xBC"],

        ["\xE5\xB2\xB7",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE5\xF1"],
        ["\xE5\xF1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB2\xB7"],

        ["\xE5\xB3\x85",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE5\xF2"],
        ["\xE5\xF2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB3\x85"],

        ["\xE5\xB2\xBE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE5\xF3"],
        ["\xE5\xF3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB2\xBE"],

        ["\xE5\xB3\x87",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE5\xF4"],
        ["\xE5\xF4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB3\x87"],

        ["\xE5\xB3\x99",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE5\xF5"],
        ["\xE5\xF5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB3\x99"],

        ["\xE5\xB3\xA9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE5\xF6"],
        ["\xE5\xF6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB3\xA9"],

        ["\xE5\xB3\xBD",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE5\xF7"],
        ["\xE5\xF7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB3\xBD"],

        ["\xE5\xB3\xBA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE5\xF8"],
        ["\xE5\xF8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB3\xBA"],

        ["\xE5\xB3\xAD",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE5\xF9"],
        ["\xE5\xF9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB3\xAD"],

        ["\xE5\xB6\x8C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE5\x7A"],
        ["\xE5\x7A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB6\x8C"],

        ["\xE5\xB3\xAA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE5\x5E"],
        ["\xE5\x5E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB3\xAA"],

        ["\xE5\xB4\x8B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE5\x4C"],
        ["\xE5\x4C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB4\x8B"],

        ["\xE5\xB4\x95",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE5\x7E"],
        ["\xE5\x7E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB4\x95"],

        ["\xE5\xB4\x97",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE5\x6E"],
        ["\xE5\x6E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB4\x97"],

        ["\xE5\xB5\x9C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE5\x6F"],
        ["\xE5\x6F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB5\x9C"],

        ["\xE5\xB4\x9F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE5\x7C"],
        ["\xE5\x7C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB4\x9F"],

        ["\xE5\xB4\x9B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE5\xC1"],
        ["\xE5\xC1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB4\x9B"],

        ["\xE5\xB4\x91",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE5\xC2"],
        ["\xE5\xC2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB4\x91"],

        ["\xE5\xB4\x94",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE5\xC3"],
        ["\xE5\xC3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB4\x94"],

        ["\xE5\xB4\xA2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE5\xC4"],
        ["\xE5\xC4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB4\xA2"],

        ["\xE5\xB4\x9A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE5\xC5"],
        ["\xE5\xC5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB4\x9A"],

        ["\xE5\xB4\x99",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE5\xC6"],
        ["\xE5\xC6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB4\x99"],

        ["\xE5\xB4\x98",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE5\xC7"],
        ["\xE5\xC7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB4\x98"],

        ["\xE5\xB5\x8C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE5\xC8"],
        ["\xE5\xC8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB5\x8C"],

        ["\xE5\xB5\x92",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE5\xC9"],
        ["\xE5\xC9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB5\x92"],

        ["\xE5\xB5\x8E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE5\xD1"],
        ["\xE5\xD1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB5\x8E"],

        ["\xE5\xB5\x8B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE5\xD2"],
        ["\xE5\xD2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB5\x8B"],

        ["\xE5\xB5\xAC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE5\xD3"],
        ["\xE5\xD3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB5\xAC"],

        ["\xE5\xB5\xB3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE5\xD4"],
        ["\xE5\xD4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB5\xB3"],

        ["\xE5\xB5\xB6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE5\xD5"],
        ["\xE5\xD5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB5\xB6"],

        ["\xE5\xB6\x87",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE5\xD6"],
        ["\xE5\xD6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB6\x87"],

        ["\xE5\xB6\x84",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE5\xD7"],
        ["\xE5\xD7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB6\x84"],

        ["\xE5\xB6\x82",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE5\xD8"],
        ["\xE5\xD8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB6\x82"],

        ["\xE5\xB6\xA2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE5\xD9"],
        ["\xE5\xD9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB6\xA2"],

        ["\xE5\xB6\x9D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE5\xE2"],
        ["\xE5\xE2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB6\x9D"],

        ["\xE5\xB6\xAC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE5\xE3"],
        ["\xE5\xE3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB6\xAC"],

        ["\xE5\xB6\xAE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE5\xE4"],
        ["\xE5\xE4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB6\xAE"],

        ["\xE5\xB6\xBD",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE5\xE5"],
        ["\xE5\xE5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB6\xBD"],

        ["\xE5\xB6\x90",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE5\xE6"],
        ["\xE5\xE6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB6\x90"],

        ["\xE5\xB6\xB7",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE5\xE7"],
        ["\xE5\xE7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB6\xB7"],

        ["\xE5\xB6\xBC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE5\xE8"],
        ["\xE5\xE8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB6\xBC"],

        ["\xE5\xB7\x89",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE5\xE9"],
        ["\xE5\xE9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\x89"],

        ["\xE5\xB7\x8D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE5\x4A"],
        ["\xE5\x4A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\x8D"],

        ["\xE5\xB7\x93",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE5\x5B"],
        ["\xE5\x5B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\x93"],

        ["\xE5\xB7\x92",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE5\x5A"],
        ["\xE5\x5A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\x92"],

        ["\xE5\xB7\x96",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE5\x5F"],
        ["\xE5\x5F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\x96"],

        ["\xE5\xB7\x9B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE5\x6D"],
        ["\xE5\x6D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\x9B"],

        ["\xE5\xB7\xAB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE5\x79"],
        ["\xE5\x79",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\xAB"],

        ["\xE5\xB7\xB2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE5\x57"],
        ["\xE5\x57",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\xB2"],

        ["\xE5\xB7\xB5",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE5\x59"],
        ["\xE5\x59",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\xB5"],

        ["\xE5\xB8\x8B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE5\x62"],
        ["\xE5\x62",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8\x8B"],

        ["\xE5\xB8\x9A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE5\x63"],
        ["\xE5\x63",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8\x9A"],

        ["\xE5\xB8\x99",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE5\x64"],
        ["\xE5\x64",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8\x99"],

        ["\xE5\xB8\x91",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE5\x65"],
        ["\xE5\x65",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8\x91"],

        ["\xE5\xB8\x9B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE5\x66"],
        ["\xE5\x66",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8\x9B"],

        ["\xE5\xB8\xB6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE5\x67"],
        ["\xE5\x67",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8\xB6"],

        ["\xE5\xB8\xB7",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE5\x68"],
        ["\xE5\x68",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8\xB7"],

        ["\xE5\xB9\x84",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE5\x69"],
        ["\xE5\x69",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\x84"],

        ["\xE5\xB9\x83",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE5\x70"],
        ["\xE5\x70",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\x83"],

        ["\xE5\xB9\x80",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE5\x71"],
        ["\xE5\x71",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\x80"],

        ["\xE5\xB9\x8E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE5\x72"],
        ["\xE5\x72",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\x8E"],

        ["\xE5\xB9\x97",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE5\x73"],
        ["\xE5\x73",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\x97"],

        ["\xE5\xB9\x94",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE5\x74"],
        ["\xE5\x74",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\x94"],

        ["\xE5\xB9\x9F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE5\x75"],
        ["\xE5\x75",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\x9F"],

        ["\xE5\xB9\xA2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE5\x76"],
        ["\xE5\x76",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\xA2"],

        ["\xE5\xB9\xA4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE5\x77"],
        ["\xE5\x77",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\xA4"],

        ["\xE5\xB9\x87",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE5\x78"],
        ["\xE5\x78",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\x87"],

        ["\xE5\xB9\xB5",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE5\x80"],
        ["\xE5\x80",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\xB5"],

        ["\xE5\xB9\xB6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B"],
        ["\xE5\x8B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\xB6"],

        ["\xE5\xB9\xBA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B"],
        ["\xE5\x9B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\xBA"],

        ["\xE9\xBA\xBC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C"],
        ["\xE5\x9C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xBA\xBC"],

        ["\xE5\xB9\xBF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE5\xA0"],
        ["\xE5\xA0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\xBF"],

        ["\xE5\xBA\xA0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE5\xAB"],
        ["\xE5\xAB",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBA\xA0"],

        ["\xE5\xBB\x81",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0"],
        ["\xE5\xB0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\x81"],

        ["\xE5\xBB\x82",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE5\xC0"],
        ["\xE5\xC0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\x82"],

        ["\xE5\xBB\x88",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE5\x6A"],
        ["\xE5\x6A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\x88"],

        ["\xE5\xBB\x90",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE5\xD0"],
        ["\xE5\xD0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\x90"],

        ["\xE5\xBB\x8F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE5\xA1"],
        ["\xE5\xA1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\x8F"],

        ["\xE5\xBB\x96",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE6\x4F"],
        ["\xE6\x4F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\x96"],

        ["\xE5\xBB\xA3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE6\x7F"],
        ["\xE6\x7F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\xA3"],

        ["\xE5\xBB\x9D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE6\x7B"],
        ["\xE6\x7B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\x9D"],

        ["\xE5\xBB\x9A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE6\xE0"],
        ["\xE6\xE0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\x9A"],

        ["\xE5\xBB\x9B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE6\x6C"],
        ["\xE6\x6C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\x9B"],

        ["\xE5\xBB\xA2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE6\x50"],
        ["\xE6\x50",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\xA2"],

        ["\xE5\xBB\xA1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE6\x7D"],
        ["\xE6\x7D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\xA1"],

        ["\xE5\xBB\xA8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE6\x4D"],
        ["\xE6\x4D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\xA8"],

        ["\xE5\xBB\xA9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE6\x5D"],
        ["\xE6\x5D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\xA9"],

        ["\xE5\xBB\xAC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE6\x5C"],
        ["\xE6\x5C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\xAC"],

        ["\xE5\xBB\xB1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE6\x4E"],
        ["\xE6\x4E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\xB1"],

        ["\xE5\xBB\xB3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE6\x6B"],
        ["\xE6\x6B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\xB3"],

        ["\xE5\xBB\xB0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE6\x60"],
        ["\xE6\x60",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\xB0"],

        ["\xE5\xBB\xB4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE6\x4B"],
        ["\xE6\x4B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\xB4"],

        ["\xE5\xBB\xB8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE6\x61"],
        ["\xE6\x61",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\xB8"],

        ["\xE5\xBB\xBE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE6\xF0"],
        ["\xE6\xF0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\xBE"],

        ["\xE5\xBC\x83",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE6\xF1"],
        ["\xE6\xF1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\x83"],

        ["\xE5\xBC\x89",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE6\xF2"],
        ["\xE6\xF2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\x89"],

        ["\xE5\xBD\x9D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE6\xF3"],
        ["\xE6\xF3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\x9D"],

        ["\xE5\xBD\x9C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE6\xF4"],
        ["\xE6\xF4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\x9C"],

        ["\xE5\xBC\x8B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE6\xF5"],
        ["\xE6\xF5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\x8B"],

        ["\xE5\xBC\x91",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE6\xF6"],
        ["\xE6\xF6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\x91"],

        ["\xE5\xBC\x96",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE6\xF7"],
        ["\xE6\xF7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\x96"],

        ["\xE5\xBC\xA9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE6\xF8"],
        ["\xE6\xF8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\xA9"],

        ["\xE5\xBC\xAD",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE6\xF9"],
        ["\xE6\xF9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\xAD"],

        ["\xE5\xBC\xB8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE6\x7A"],
        ["\xE6\x7A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\xB8"],

        ["\xE5\xBD\x88",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE6\x4C"],
        ["\xE6\x4C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\x88"],

        ["\xE5\xBD\x8C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE6\x7E"],
        ["\xE6\x7E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\x8C"],

        ["\xE5\xBD\x8E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE6\x6E"],
        ["\xE6\x6E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\x8E"],

        ["\xE5\xBC\xAF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE6\x6F"],
        ["\xE6\x6F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\xAF"],

        ["\xE5\xBD\x91",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE6\x7C"],
        ["\xE6\x7C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\x91"],

        ["\xE5\xBD\x96",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE6\xC1"],
        ["\xE6\xC1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\x96"],

        ["\xE5\xBD\x97",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE6\xC2"],
        ["\xE6\xC2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\x97"],

        ["\xE5\xBD\x99",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE6\xC3"],
        ["\xE6\xC3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\x99"],

        ["\xE5\xBD\xA1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE6\xC4"],
        ["\xE6\xC4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\xA1"],

        ["\xE5\xBD\xAD",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE6\xC5"],
        ["\xE6\xC5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\xAD"],

        ["\xE5\xBD\xB3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE6\xC6"],
        ["\xE6\xC6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\xB3"],

        ["\xE5\xBD\xB7",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE6\xC7"],
        ["\xE6\xC7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\xB7"],

        ["\xE5\xBE\x83",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE6\xC8"],
        ["\xE6\xC8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\x83"],

        ["\xE5\xBE\x82",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE6\xC9"],
        ["\xE6\xC9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\x82"],

        ["\xE5\xBD\xBF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE6\xD1"],
        ["\xE6\xD1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\xBF"],

        ["\xE5\xBE\x8A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE6\xD2"],
        ["\xE6\xD2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\x8A"],

        ["\xE5\xBE\x88",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE6\xD3"],
        ["\xE6\xD3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\x88"],

        ["\xE5\xBE\x91",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE6\xD4"],
        ["\xE6\xD4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\x91"],

        ["\xE5\xBE\x87",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE6\xD5"],
        ["\xE6\xD5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\x87"],

        ["\xE5\xBE\x9E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE6\xD6"],
        ["\xE6\xD6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\x9E"],

        ["\xE5\xBE\x99",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE6\xD7"],
        ["\xE6\xD7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\x99"],

        ["\xE5\xBE\x98",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE6\xD8"],
        ["\xE6\xD8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\x98"],

        ["\xE5\xBE\xA0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE6\xD9"],
        ["\xE6\xD9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\xA0"],

        ["\xE5\xBE\xA8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE6\xE2"],
        ["\xE6\xE2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\xA8"],

        ["\xE5\xBE\xAD",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE6\xE3"],
        ["\xE6\xE3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\xAD"],

        ["\xE5\xBE\xBC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE6\xE4"],
        ["\xE6\xE4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\xBC"],

        ["\xE5\xBF\x96",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE6\xE5"],
        ["\xE6\xE5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF\x96"],

        ["\xE5\xBF\xBB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE6\xE6"],
        ["\xE6\xE6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF\xBB"],

        ["\xE5\xBF\xA4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE6\xE7"],
        ["\xE6\xE7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF\xA4"],

        ["\xE5\xBF\xB8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE6\xE8"],
        ["\xE6\xE8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF\xB8"],

        ["\xE5\xBF\xB1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE6\xE9"],
        ["\xE6\xE9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF\xB1"],

        ["\xE5\xBF\x9D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE6\x4A"],
        ["\xE6\x4A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF\x9D"],

        ["\xE6\x82\xB3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE6\x5B"],
        ["\xE6\x5B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\xB3"],

        ["\xE5\xBF\xBF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE6\x5A"],
        ["\xE6\x5A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF\xBF"],

        ["\xE6\x80\xA1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE6\x5F"],
        ["\xE6\x5F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x80\xA1"],

        ["\xE6\x81\xA0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE6\x6D"],
        ["\xE6\x6D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\xA0"],

        ["\xE6\x80\x99",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE6\x79"],
        ["\xE6\x79",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x80\x99"],

        ["\xE6\x80\x90",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE6\x57"],
        ["\xE6\x57",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x80\x90"],

        ["\xE6\x80\xA9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE6\x59"],
        ["\xE6\x59",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x80\xA9"],

        ["\xE6\x80\x8E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE6\x62"],
        ["\xE6\x62",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x80\x8E"],

        ["\xE6\x80\xB1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE6\x63"],
        ["\xE6\x63",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x80\xB1"],

        ["\xE6\x80\x9B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE6\x64"],
        ["\xE6\x64",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x80\x9B"],

        ["\xE6\x80\x95",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE6\x65"],
        ["\xE6\x65",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x80\x95"],

        ["\xE6\x80\xAB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE6\x66"],
        ["\xE6\x66",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x80\xAB"],

        ["\xE6\x80\xA6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE6\x67"],
        ["\xE6\x67",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x80\xA6"],

        ["\xE6\x80\x8F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE6\x68"],
        ["\xE6\x68",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x80\x8F"],

        ["\xE6\x80\xBA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE6\x69"],
        ["\xE6\x69",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x80\xBA"],

        ["\xE6\x81\x9A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE6\x70"],
        ["\xE6\x70",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\x9A"],

        ["\xE6\x81\x81",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE6\x71"],
        ["\xE6\x71",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\x81"],

        ["\xE6\x81\xAA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE6\x72"],
        ["\xE6\x72",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\xAA"],

        ["\xE6\x81\xB7",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE6\x73"],
        ["\xE6\x73",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\xB7"],

        ["\xE6\x81\x9F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE6\x74"],
        ["\xE6\x74",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\x9F"],

        ["\xE6\x81\x8A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE6\x75"],
        ["\xE6\x75",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\x8A"],

        ["\xE6\x81\x86",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE6\x76"],
        ["\xE6\x76",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\x86"],

        ["\xE6\x81\x8D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE6\x77"],
        ["\xE6\x77",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\x8D"],

        ["\xE6\x81\xA3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE6\x78"],
        ["\xE6\x78",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\xA3"],

        ["\xE6\x81\x83",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE6\x80"],
        ["\xE6\x80",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\x83"],

        ["\xE6\x81\xA4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B"],
        ["\xE6\x8B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\xA4"],

        ["\xE6\x81\x82",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B"],
        ["\xE6\x9B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\x82"],

        ["\xE6\x81\xAC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C"],
        ["\xE6\x9C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\xAC"],

        ["\xE6\x81\xAB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE6\xA0"],
        ["\xE6\xA0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\xAB"],

        ["\xE6\x81\x99",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE6\xAB"],
        ["\xE6\xAB",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\x99"],

        ["\xE6\x82\x81",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE6\xB0"],
        ["\xE6\xB0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\x81"],

        ["\xE6\x82\x8D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE6\xC0"],
        ["\xE6\xC0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\x8D"],

        ["\xE6\x83\xA7",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE6\x6A"],
        ["\xE6\x6A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\xA7"],

        ["\xE6\x82\x83",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE6\xD0"],
        ["\xE6\xD0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\x83"],

        ["\xE6\x82\x9A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1"],
        ["\xE6\xA1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\x9A"],

        ["\xE6\x82\x84",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE7\x4F"],
        ["\xE7\x4F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\x84"],

        ["\xE6\x82\x9B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE7\x7F"],
        ["\xE7\x7F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\x9B"],

        ["\xE6\x82\x96",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE7\x7B"],
        ["\xE7\x7B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\x96"],

        ["\xE6\x82\x97",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE7\xE0"],
        ["\xE7\xE0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\x97"],

        ["\xE6\x82\x92",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE7\x6C"],
        ["\xE7\x6C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\x92"],

        ["\xE6\x82\xA7",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE7\x50"],
        ["\xE7\x50",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\xA7"],

        ["\xE6\x82\x8B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE7\x7D"],
        ["\xE7\x7D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\x8B"],

        ["\xE6\x83\xA1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE7\x4D"],
        ["\xE7\x4D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\xA1"],

        ["\xE6\x82\xB8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE7\x5D"],
        ["\xE7\x5D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\xB8"],

        ["\xE6\x83\xA0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE7\x5C"],
        ["\xE7\x5C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\xA0"],

        ["\xE6\x83\x93",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE7\x4E"],
        ["\xE7\x4E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\x93"],

        ["\xE6\x82\xB4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE7\x6B"],
        ["\xE7\x6B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\xB4"],

        ["\xE5\xBF\xB0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE7\x60"],
        ["\xE7\x60",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF\xB0"],

        ["\xE6\x82\xBD",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE7\x4B"],
        ["\xE7\x4B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\xBD"],

        ["\xE6\x83\x86",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE7\x61"],
        ["\xE7\x61",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\x86"],

        ["\xE6\x82\xB5",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE7\xF0"],
        ["\xE7\xF0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\xB5"],

        ["\xE6\x83\x98",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE7\xF1"],
        ["\xE7\xF1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\x98"],

        ["\xE6\x85\x8D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE7\xF2"],
        ["\xE7\xF2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\x8D"],

        ["\xE6\x84\x95",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE7\xF3"],
        ["\xE7\xF3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\x95"],

        ["\xE6\x84\x86",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE7\xF4"],
        ["\xE7\xF4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\x86"],

        ["\xE6\x83\xB6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE7\xF5"],
        ["\xE7\xF5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\xB6"],

        ["\xE6\x83\xB7",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE7\xF6"],
        ["\xE7\xF6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\xB7"],

        ["\xE6\x84\x80",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE7\xF7"],
        ["\xE7\xF7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\x80"],

        ["\xE6\x83\xB4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE7\xF8"],
        ["\xE7\xF8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\xB4"],

        ["\xE6\x83\xBA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE7\xF9"],
        ["\xE7\xF9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\xBA"],

        ["\xE6\x84\x83",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE7\x7A"],
        ["\xE7\x7A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\x83"],

        ["\xE6\x84\xA1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE7\x5E"],
        ["\xE7\x5E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\xA1"],

        ["\xE6\x83\xBB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE7\x4C"],
        ["\xE7\x4C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\xBB"],

        ["\xE6\x83\xB1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE7\x7E"],
        ["\xE7\x7E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\xB1"],

        ["\xE6\x84\x8D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE7\x6E"],
        ["\xE7\x6E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\x8D"],

        ["\xE6\x84\x8E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE7\x6F"],
        ["\xE7\x6F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\x8E"],

        ["\xE6\x85\x87",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE7\x7C"],
        ["\xE7\x7C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\x87"],

        ["\xE6\x84\xBE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE7\xC1"],
        ["\xE7\xC1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\xBE"],

        ["\xE6\x84\xA8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE7\xC2"],
        ["\xE7\xC2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\xA8"],

        ["\xE6\x84\xA7",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE7\xC3"],
        ["\xE7\xC3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\xA7"],

        ["\xE6\x85\x8A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE7\xC4"],
        ["\xE7\xC4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\x8A"],

        ["\xE6\x84\xBF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE7\xC5"],
        ["\xE7\xC5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\xBF"],

        ["\xE6\x84\xBC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE7\xC6"],
        ["\xE7\xC6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\xBC"],

        ["\xE6\x84\xAC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE7\xC7"],
        ["\xE7\xC7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\xAC"],

        ["\xE6\x84\xB4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE7\xC8"],
        ["\xE7\xC8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\xB4"],

        ["\xE6\x84\xBD",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE7\xC9"],
        ["\xE7\xC9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\xBD"],

        ["\xE6\x85\x82",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE7\xD1"],
        ["\xE7\xD1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\x82"],

        ["\xE6\x85\x84",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE7\xD2"],
        ["\xE7\xD2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\x84"],

        ["\xE6\x85\xB3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE7\xD3"],
        ["\xE7\xD3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\xB3"],

        ["\xE6\x85\xB7",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE7\xD4"],
        ["\xE7\xD4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\xB7"],

        ["\xE6\x85\x98",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE7\xD5"],
        ["\xE7\xD5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\x98"],

        ["\xE6\x85\x99",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE7\xD6"],
        ["\xE7\xD6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\x99"],

        ["\xE6\x85\x9A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE7\xD7"],
        ["\xE7\xD7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\x9A"],

        ["\xE6\x85\xAB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE7\xD8"],
        ["\xE7\xD8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\xAB"],

        ["\xE6\x85\xB4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE7\xD9"],
        ["\xE7\xD9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\xB4"],

        ["\xE6\x85\xAF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE7\xE2"],
        ["\xE7\xE2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\xAF"],

        ["\xE6\x85\xA5",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE7\xE3"],
        ["\xE7\xE3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\xA5"],

        ["\xE6\x85\xB1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE7\xE4"],
        ["\xE7\xE4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\xB1"],

        ["\xE6\x85\x9F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE7\xE5"],
        ["\xE7\xE5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\x9F"],

        ["\xE6\x85\x9D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE7\xE6"],
        ["\xE7\xE6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\x9D"],

        ["\xE6\x85\x93",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE7\xE7"],
        ["\xE7\xE7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\x93"],

        ["\xE6\x85\xB5",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE7\xE8"],
        ["\xE7\xE8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\xB5"],

        ["\xE6\x86\x99",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE7\xE9"],
        ["\xE7\xE9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x86\x99"],

        ["\xE6\x86\x96",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE7\x4A"],
        ["\xE7\x4A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x86\x96"],

        ["\xE6\x86\x87",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE7\x5B"],
        ["\xE7\x5B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x86\x87"],

        ["\xE6\x86\xAC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE7\x5A"],
        ["\xE7\x5A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x86\xAC"],

        ["\xE6\x86\x94",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE7\x5F"],
        ["\xE7\x5F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x86\x94"],

        ["\xE6\x86\x9A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE7\x6D"],
        ["\xE7\x6D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x86\x9A"],

        ["\xE6\x86\x8A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE7\x79"],
        ["\xE7\x79",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x86\x8A"],

        ["\xE6\x86\x91",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE7\x57"],
        ["\xE7\x57",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x86\x91"],

        ["\xE6\x86\xAB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE7\x59"],
        ["\xE7\x59",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x86\xAB"],

        ["\xE6\x86\xAE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE7\x62"],
        ["\xE7\x62",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x86\xAE"],

        ["\xE6\x87\x8C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE7\x63"],
        ["\xE7\x63",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x87\x8C"],

        ["\xE6\x87\x8A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE7\x64"],
        ["\xE7\x64",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x87\x8A"],

        ["\xE6\x87\x89",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE7\x65"],
        ["\xE7\x65",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x87\x89"],

        ["\xE6\x87\xB7",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE7\x66"],
        ["\xE7\x66",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x87\xB7"],

        ["\xE6\x87\x88",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE7\x67"],
        ["\xE7\x67",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x87\x88"],

        ["\xE6\x87\x83",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE7\x68"],
        ["\xE7\x68",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x87\x83"],

        ["\xE6\x87\x86",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE7\x69"],
        ["\xE7\x69",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x87\x86"],

        ["\xE6\x86\xBA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE7\x70"],
        ["\xE7\x70",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x86\xBA"],

        ["\xE6\x87\x8B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE7\x71"],
        ["\xE7\x71",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x87\x8B"],

        ["\xE7\xBD\xB9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE7\x72"],
        ["\xE7\x72",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\xB9"],

        ["\xE6\x87\x8D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE7\x73"],
        ["\xE7\x73",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x87\x8D"],

        ["\xE6\x87\xA6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE7\x74"],
        ["\xE7\x74",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x87\xA6"],

        ["\xE6\x87\xA3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE7\x75"],
        ["\xE7\x75",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x87\xA3"],

        ["\xE6\x87\xB6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE7\x76"],
        ["\xE7\x76",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x87\xB6"],

        ["\xE6\x87\xBA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE7\x77"],
        ["\xE7\x77",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x87\xBA"],

        ["\xE6\x87\xB4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE7\x78"],
        ["\xE7\x78",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x87\xB4"],

        ["\xE6\x87\xBF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE7\x80"],
        ["\xE7\x80",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x87\xBF"],

        ["\xE6\x87\xBD",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE7\x8B"],
        ["\xE7\x8B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x87\xBD"],

        ["\xE6\x87\xBC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B"],
        ["\xE7\x9B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x87\xBC"],

        ["\xE6\x87\xBE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE7\x9C"],
        ["\xE7\x9C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x87\xBE"],

        ["\xE6\x88\x80",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE7\xA0"],
        ["\xE7\xA0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\x80"],

        ["\xE6\x88\x88",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB"],
        ["\xE7\xAB",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\x88"],

        ["\xE6\x88\x89",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE7\xB0"],
        ["\xE7\xB0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\x89"],

        ["\xE6\x88\x8D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE7\xC0"],
        ["\xE7\xC0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\x8D"],

        ["\xE6\x88\x8C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE7\x6A"],
        ["\xE7\x6A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\x8C"],

        ["\xE6\x88\x94",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE7\xD0"],
        ["\xE7\xD0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\x94"],

        ["\xE6\x88\x9B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE7\xA1"],
        ["\xE7\xA1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\x9B"],

        ["\xE6\x88\x9E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE8\x4F"],
        ["\xE8\x4F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\x9E"],

        ["\xE6\x88\xA1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE8\x7F"],
        ["\xE8\x7F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\xA1"],

        ["\xE6\x88\xAA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE8\x7B"],
        ["\xE8\x7B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\xAA"],

        ["\xE6\x88\xAE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE8\xE0"],
        ["\xE8\xE0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\xAE"],

        ["\xE6\x88\xB0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE8\x6C"],
        ["\xE8\x6C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\xB0"],

        ["\xE6\x88\xB2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE8\x50"],
        ["\xE8\x50",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\xB2"],

        ["\xE6\x88\xB3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE8\x7D"],
        ["\xE8\x7D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\xB3"],

        ["\xE6\x89\x81",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE8\x4D"],
        ["\xE8\x4D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\x81"],

        ["\xE6\x89\x8E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE8\x5D"],
        ["\xE8\x5D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\x8E"],

        ["\xE6\x89\x9E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE8\x5C"],
        ["\xE8\x5C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\x9E"],

        ["\xE6\x89\xA3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE8\x4E"],
        ["\xE8\x4E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\xA3"],

        ["\xE6\x89\x9B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE8\x6B"],
        ["\xE8\x6B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\x9B"],

        ["\xE6\x89\xA0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE8\x60"],
        ["\xE8\x60",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\xA0"],

        ["\xE6\x89\xA8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE8\x4B"],
        ["\xE8\x4B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\xA8"],

        ["\xE6\x89\xBC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE8\x61"],
        ["\xE8\x61",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\xBC"],

        ["\xE6\x8A\x82",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE8\xF0"],
        ["\xE8\xF0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A\x82"],

        ["\xE6\x8A\x89",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE8\xF1"],
        ["\xE8\xF1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A\x89"],

        ["\xE6\x89\xBE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE8\xF2"],
        ["\xE8\xF2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\xBE"],

        ["\xE6\x8A\x92",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE8\xF3"],
        ["\xE8\xF3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A\x92"],

        ["\xE6\x8A\x93",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE8\xF4"],
        ["\xE8\xF4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A\x93"],

        ["\xE6\x8A\x96",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE8\xF5"],
        ["\xE8\xF5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A\x96"],

        ["\xE6\x8B\x94",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE8\xF6"],
        ["\xE8\xF6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\x94"],

        ["\xE6\x8A\x83",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE8\xF7"],
        ["\xE8\xF7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A\x83"],

        ["\xE6\x8A\x94",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE8\xF8"],
        ["\xE8\xF8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A\x94"],

        ["\xE6\x8B\x97",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE8\xF9"],
        ["\xE8\xF9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\x97"],

        ["\xE6\x8B\x91",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE8\x7A"],
        ["\xE8\x7A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\x91"],

        ["\xE6\x8A\xBB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE8\x5E"],
        ["\xE8\x5E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A\xBB"],

        ["\xE6\x8B\x8F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE8\x4C"],
        ["\xE8\x4C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\x8F"],

        ["\xE6\x8B\xBF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE8\x7E"],
        ["\xE8\x7E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\xBF"],

        ["\xE6\x8B\x86",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE8\x6E"],
        ["\xE8\x6E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\x86"],

        ["\xE6\x93\x94",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE8\x6F"],
        ["\xE8\x6F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\x94"],

        ["\xE6\x8B\x88",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE8\x7C"],
        ["\xE8\x7C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\x88"],

        ["\xE6\x8B\x9C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE8\xC1"],
        ["\xE8\xC1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\x9C"],

        ["\xE6\x8B\x8C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE8\xC2"],
        ["\xE8\xC2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\x8C"],

        ["\xE6\x8B\x8A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE8\xC3"],
        ["\xE8\xC3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\x8A"],

        ["\xE6\x8B\x82",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE8\xC4"],
        ["\xE8\xC4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\x82"],

        ["\xE6\x8B\x87",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE8\xC5"],
        ["\xE8\xC5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\x87"],

        ["\xE6\x8A\x9B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE8\xC6"],
        ["\xE8\xC6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A\x9B"],

        ["\xE6\x8B\x89",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE8\xC7"],
        ["\xE8\xC7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\x89"],

        ["\xE6\x8C\x8C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE8\xC8"],
        ["\xE8\xC8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8C\x8C"],

        ["\xE6\x8B\xAE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE8\xC9"],
        ["\xE8\xC9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\xAE"],

        ["\xE6\x8B\xB1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE8\xD1"],
        ["\xE8\xD1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\xB1"],

        ["\xE6\x8C\xA7",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE8\xD2"],
        ["\xE8\xD2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8C\xA7"],

        ["\xE6\x8C\x82",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE8\xD3"],
        ["\xE8\xD3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8C\x82"],

        ["\xE6\x8C\x88",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE8\xD4"],
        ["\xE8\xD4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8C\x88"],

        ["\xE6\x8B\xAF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE8\xD5"],
        ["\xE8\xD5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\xAF"],

        ["\xE6\x8B\xB5",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE8\xD6"],
        ["\xE8\xD6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\xB5"],

        ["\xE6\x8D\x90",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE8\xD7"],
        ["\xE8\xD7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8D\x90"],

        ["\xE6\x8C\xBE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE8\xD8"],
        ["\xE8\xD8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8C\xBE"],

        ["\xE6\x8D\x8D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE8\xD9"],
        ["\xE8\xD9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8D\x8D"],

        ["\xE6\x90\x9C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE8\xE2"],
        ["\xE8\xE2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x90\x9C"],

        ["\xE6\x8D\x8F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE8\xE3"],
        ["\xE8\xE3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8D\x8F"],

        ["\xE6\x8E\x96",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE8\xE4"],
        ["\xE8\xE4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\x96"],

        ["\xE6\x8E\x8E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE8\xE5"],
        ["\xE8\xE5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\x8E"],

        ["\xE6\x8E\x80",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE8\xE6"],
        ["\xE8\xE6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\x80"],

        ["\xE6\x8E\xAB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE8\xE7"],
        ["\xE8\xE7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\xAB"],

        ["\xE6\x8D\xB6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE8\xE8"],
        ["\xE8\xE8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8D\xB6"],

        ["\xE6\x8E\xA3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE8\xE9"],
        ["\xE8\xE9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\xA3"],

        ["\xE6\x8E\x8F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE8\x4A"],
        ["\xE8\x4A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\x8F"],

        ["\xE6\x8E\x89",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE8\x5B"],
        ["\xE8\x5B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\x89"],

        ["\xE6\x8E\x9F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE8\x5A"],
        ["\xE8\x5A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\x9F"],

        ["\xE6\x8E\xB5",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE8\x5F"],
        ["\xE8\x5F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\xB5"],

        ["\xE6\x8D\xAB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE8\x6D"],
        ["\xE8\x6D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8D\xAB"],

        ["\xE6\x8D\xA9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE8\x79"],
        ["\xE8\x79",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8D\xA9"],

        ["\xE6\x8E\xBE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE8\x57"],
        ["\xE8\x57",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\xBE"],

        ["\xE6\x8F\xA9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE8\x59"],
        ["\xE8\x59",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8F\xA9"],

        ["\xE6\x8F\x80",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE8\x62"],
        ["\xE8\x62",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8F\x80"],

        ["\xE6\x8F\x86",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE8\x63"],
        ["\xE8\x63",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8F\x86"],

        ["\xE6\x8F\xA3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE8\x64"],
        ["\xE8\x64",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8F\xA3"],

        ["\xE6\x8F\x89",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE8\x65"],
        ["\xE8\x65",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8F\x89"],

        ["\xE6\x8F\x92",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE8\x66"],
        ["\xE8\x66",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8F\x92"],

        ["\xE6\x8F\xB6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE8\x67"],
        ["\xE8\x67",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8F\xB6"],

        ["\xE6\x8F\x84",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE8\x68"],
        ["\xE8\x68",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8F\x84"],

        ["\xE6\x90\x96",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE8\x69"],
        ["\xE8\x69",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x90\x96"],

        ["\xE6\x90\xB4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE8\x70"],
        ["\xE8\x70",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x90\xB4"],

        ["\xE6\x90\x86",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE8\x71"],
        ["\xE8\x71",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x90\x86"],

        ["\xE6\x90\x93",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE8\x72"],
        ["\xE8\x72",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x90\x93"],

        ["\xE6\x90\xA6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE8\x73"],
        ["\xE8\x73",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x90\xA6"],

        ["\xE6\x90\xB6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE8\x74"],
        ["\xE8\x74",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x90\xB6"],

        ["\xE6\x94\x9D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE8\x75"],
        ["\xE8\x75",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x94\x9D"],

        ["\xE6\x90\x97",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE8\x76"],
        ["\xE8\x76",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x90\x97"],

        ["\xE6\x90\xA8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE8\x77"],
        ["\xE8\x77",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x90\xA8"],

        ["\xE6\x90\x8F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE8\x78"],
        ["\xE8\x78",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x90\x8F"],

        ["\xE6\x91\xA7",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE8\x80"],
        ["\xE8\x80",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x91\xA7"],

        ["\xE6\x91\xAF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE8\x8B"],
        ["\xE8\x8B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x91\xAF"],

        ["\xE6\x91\xB6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE8\x9B"],
        ["\xE8\x9B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x91\xB6"],

        ["\xE6\x91\x8E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE8\x9C"],
        ["\xE8\x9C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x91\x8E"],

        ["\xE6\x94\xAA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF3\xC9"],
        ["\xF3\xC9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x94\xAA"],

        ["\xE6\x92\x95",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB"],
        ["\xE8\xAB",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x92\x95"],

        ["\xE6\x92\x93",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE8\xB0"],
        ["\xE8\xB0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x92\x93"],

        ["\xE6\x92\xA5",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE8\xC0"],
        ["\xE8\xC0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x92\xA5"],

        ["\xE6\x92\xA9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE8\x6A"],
        ["\xE8\x6A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x92\xA9"],

        ["\xE6\x92\x88",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE8\xD0"],
        ["\xE8\xD0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x92\x88"],

        ["\xE6\x92\xBC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1"],
        ["\xE8\xA1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x92\xBC"],

        ["\xE6\x93\x9A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE9\x4F"],
        ["\xE9\x4F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\x9A"],

        ["\xE6\x93\x92",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE9\x7F"],
        ["\xE9\x7F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\x92"],

        ["\xE6\x93\x85",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE9\x7B"],
        ["\xE9\x7B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\x85"],

        ["\xE6\x93\x87",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE9\xE0"],
        ["\xE9\xE0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\x87"],

        ["\xE6\x92\xBB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE9\x6C"],
        ["\xE9\x6C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x92\xBB"],

        ["\xE6\x93\x98",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE9\x50"],
        ["\xE9\x50",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\x98"],

        ["\xE6\x93\x82",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE9\x7D"],
        ["\xE9\x7D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\x82"],

        ["\xE6\x93\xB1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE9\x4D"],
        ["\xE9\x4D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\xB1"],

        ["\xE6\x93\xA7",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE9\x5D"],
        ["\xE9\x5D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\xA7"],

        ["\xE8\x88\x89",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE9\x5C"],
        ["\xE9\x5C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\x89"],

        ["\xE6\x93\xA0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE9\x4E"],
        ["\xE9\x4E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\xA0"],

        ["\xE6\x93\xA1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE9\x6B"],
        ["\xE9\x6B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\xA1"],

        ["\xE6\x8A\xAC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE9\x60"],
        ["\xE9\x60",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A\xAC"],

        ["\xE6\x93\xA3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE9\x4B"],
        ["\xE9\x4B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\xA3"],

        ["\xE6\x93\xAF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE9\x61"],
        ["\xE9\x61",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\xAF"],

        ["\xE6\x94\xAC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE9\xF0"],
        ["\xE9\xF0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x94\xAC"],

        ["\xE6\x93\xB6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE9\xF1"],
        ["\xE9\xF1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\xB6"],

        ["\xE6\x93\xB4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE9\xF2"],
        ["\xE9\xF2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\xB4"],

        ["\xE6\x93\xB2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE9\xF3"],
        ["\xE9\xF3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\xB2"],

        ["\xE6\x93\xBA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE9\xF4"],
        ["\xE9\xF4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\xBA"],

        ["\xE6\x94\x80",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE9\xF5"],
        ["\xE9\xF5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x94\x80"],

        ["\xE6\x93\xBD",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE9\xF6"],
        ["\xE9\xF6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\xBD"],

        ["\xE6\x94\x98",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE9\xF7"],
        ["\xE9\xF7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x94\x98"],

        ["\xE6\x94\x9C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE9\xF8"],
        ["\xE9\xF8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x94\x9C"],

        ["\xE6\x94\x85",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE9\xF9"],
        ["\xE9\xF9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x94\x85"],

        ["\xE6\x94\xA4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE9\x7A"],
        ["\xE9\x7A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x94\xA4"],

        ["\xE6\x94\xA3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE9\x5E"],
        ["\xE9\x5E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x94\xA3"],

        ["\xE6\x94\xAB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE9\x4C"],
        ["\xE9\x4C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x94\xAB"],

        ["\xE6\x94\xB4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE9\x7E"],
        ["\xE9\x7E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x94\xB4"],

        ["\xE6\x94\xB5",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE9\x6E"],
        ["\xE9\x6E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x94\xB5"],

        ["\xE6\x94\xB7",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE9\x6F"],
        ["\xE9\x6F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x94\xB7"],

        ["\xE6\x94\xB6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE9\x7C"],
        ["\xE9\x7C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x94\xB6"],

        ["\xE6\x94\xB8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE9\xC1"],
        ["\xE9\xC1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x94\xB8"],

        ["\xE7\x95\x8B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE9\xC2"],
        ["\xE9\xC2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\x8B"],

        ["\xE6\x95\x88",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE9\xC3"],
        ["\xE9\xC3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x95\x88"],

        ["\xE6\x95\x96",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE9\xC4"],
        ["\xE9\xC4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x95\x96"],

        ["\xE6\x95\x95",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE9\xC5"],
        ["\xE9\xC5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x95\x95"],

        ["\xE6\x95\x8D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE9\xC6"],
        ["\xE9\xC6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x95\x8D"],

        ["\xE6\x95\x98",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE9\xC7"],
        ["\xE9\xC7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x95\x98"],

        ["\xE6\x95\x9E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE9\xC8"],
        ["\xE9\xC8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x95\x9E"],

        ["\xE6\x95\x9D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE9\xC9"],
        ["\xE9\xC9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x95\x9D"],

        ["\xE6\x95\xB2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE9\xD1"],
        ["\xE9\xD1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x95\xB2"],

        ["\xE6\x95\xB8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE9\xD2"],
        ["\xE9\xD2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x95\xB8"],

        ["\xE6\x96\x82",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE9\xD3"],
        ["\xE9\xD3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\x82"],

        ["\xE6\x96\x83",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE9\xD4"],
        ["\xE9\xD4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\x83"],

        ["\xE8\xAE\x8A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE9\xD5"],
        ["\xE9\xD5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAE\x8A"],

        ["\xE6\x96\x9B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE9\xD6"],
        ["\xE9\xD6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\x9B"],

        ["\xE6\x96\x9F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE9\xD7"],
        ["\xE9\xD7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\x9F"],

        ["\xE6\x96\xAB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE9\xD8"],
        ["\xE9\xD8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\xAB"],

        ["\xE6\x96\xB7",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE9\xD9"],
        ["\xE9\xD9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\xB7"],

        ["\xE6\x97\x83",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE9\xE2"],
        ["\xE9\xE2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\x83"],

        ["\xE6\x97\x86",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE9\xE3"],
        ["\xE9\xE3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\x86"],

        ["\xE6\x97\x81",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE9\xE4"],
        ["\xE9\xE4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\x81"],

        ["\xE6\x97\x84",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE9\xE5"],
        ["\xE9\xE5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\x84"],

        ["\xE6\x97\x8C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE9\xE6"],
        ["\xE9\xE6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\x8C"],

        ["\xE6\x97\x92",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE9\xE7"],
        ["\xE9\xE7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\x92"],

        ["\xE6\x97\x9B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE9\xE8"],
        ["\xE9\xE8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\x9B"],

        ["\xE6\x97\x99",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE9\xE9"],
        ["\xE9\xE9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\x99"],

        ["\xE6\x97\xA0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE9\x4A"],
        ["\xE9\x4A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\xA0"],

        ["\xE6\x97\xA1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE9\x5B"],
        ["\xE9\x5B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\xA1"],

        ["\xE6\x97\xB1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE9\x5A"],
        ["\xE9\x5A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\xB1"],

        ["\xE6\x9D\xB2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE9\x5F"],
        ["\xE9\x5F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\xB2"],

        ["\xE6\x98\x8A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE9\x6D"],
        ["\xE9\x6D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\x8A"],

        ["\xE6\x98\x83",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE9\x79"],
        ["\xE9\x79",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\x83"],

        ["\xE6\x97\xBB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE9\x57"],
        ["\xE9\x57",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\xBB"],

        ["\xE6\x9D\xB3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE9\x59"],
        ["\xE9\x59",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\xB3"],

        ["\xE6\x98\xB5",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE9\x62"],
        ["\xE9\x62",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\xB5"],

        ["\xE6\x98\xB6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE9\x63"],
        ["\xE9\x63",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\xB6"],

        ["\xE6\x98\xB4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE9\x64"],
        ["\xE9\x64",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\xB4"],

        ["\xE6\x98\x9C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE9\x65"],
        ["\xE9\x65",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\x9C"],

        ["\xE6\x99\x8F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE9\x66"],
        ["\xE9\x66",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\x8F"],

        ["\xE6\x99\x84",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE9\x67"],
        ["\xE9\x67",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\x84"],

        ["\xE6\x99\x89",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE9\x68"],
        ["\xE9\x68",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\x89"],

        ["\xE6\x99\x81",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE9\x69"],
        ["\xE9\x69",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\x81"],

        ["\xE6\x99\x9E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE9\x70"],
        ["\xE9\x70",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\x9E"],

        ["\xE6\x99\x9D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE9\x71"],
        ["\xE9\x71",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\x9D"],

        ["\xE6\x99\xA4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE9\x72"],
        ["\xE9\x72",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\xA4"],

        ["\xE6\x99\xA7",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE9\x73"],
        ["\xE9\x73",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\xA7"],

        ["\xE6\x99\xA8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE9\x74"],
        ["\xE9\x74",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\xA8"],

        ["\xE6\x99\x9F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE9\x75"],
        ["\xE9\x75",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\x9F"],

        ["\xE6\x99\xA2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE9\x76"],
        ["\xE9\x76",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\xA2"],

        ["\xE6\x99\xB0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE9\x77"],
        ["\xE9\x77",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\xB0"],

        ["\xE6\x9A\x83",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE9\x78"],
        ["\xE9\x78",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A\x83"],

        ["\xE6\x9A\x88",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE9\x80"],
        ["\xE9\x80",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A\x88"],

        ["\xE6\x9A\x8E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE9\x8B"],
        ["\xE9\x8B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A\x8E"],

        ["\xE6\x9A\x89",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B"],
        ["\xE9\x9B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A\x89"],

        ["\xE6\x9A\x84",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE9\x9C"],
        ["\xE9\x9C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A\x84"],

        ["\xE6\x9A\x98",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0"],
        ["\xE9\xA0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A\x98"],

        ["\xE6\x9A\x9D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE9\xAB"],
        ["\xE9\xAB",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A\x9D"],

        ["\xE6\x9B\x81",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0"],
        ["\xE9\xB0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\x81"],

        ["\xE6\x9A\xB9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE9\xC0"],
        ["\xE9\xC0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A\xB9"],

        ["\xE6\x9B\x89",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE9\x6A"],
        ["\xE9\x6A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\x89"],

        ["\xE6\x9A\xBE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE9\xD0"],
        ["\xE9\xD0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A\xBE"],

        ["\xE6\x9A\xBC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xE9\xA1"],
        ["\xE9\xA1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A\xBC"],

        ["\xE6\x9B\x84",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4A\x4F"],
        ["\x4A\x4F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\x84"],

        ["\xE6\x9A\xB8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4A\x7F"],
        ["\x4A\x7F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A\xB8"],

        ["\xE6\x9B\x96",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4A\x7B"],
        ["\x4A\x7B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\x96"],

        ["\xE6\x9B\x9A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4A\xE0"],
        ["\x4A\xE0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\x9A"],

        ["\xE6\x9B\xA0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4A\x6C"],
        ["\x4A\x6C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\xA0"],

        ["\xE6\x98\xBF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4A\x50"],
        ["\x4A\x50",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\xBF"],

        ["\xE6\x9B\xA6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4A\x7D"],
        ["\x4A\x7D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\xA6"],

        ["\xE6\x9B\xA9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4A\x4D"],
        ["\x4A\x4D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\xA9"],

        ["\xE6\x9B\xB0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4A\x5D"],
        ["\x4A\x5D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\xB0"],

        ["\xE6\x9B\xB5",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4A\x5C"],
        ["\x4A\x5C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\xB5"],

        ["\xE6\x9B\xB7",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4A\x4E"],
        ["\x4A\x4E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\xB7"],

        ["\xE6\x9C\x8F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4A\x6B"],
        ["\x4A\x6B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\x8F"],

        ["\xE6\x9C\x96",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4A\x60"],
        ["\x4A\x60",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\x96"],

        ["\xE6\x9C\x9E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4A\x4B"],
        ["\x4A\x4B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\x9E"],

        ["\xE6\x9C\xA6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4A\x61"],
        ["\x4A\x61",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\xA6"],

        ["\xE6\x9C\xA7",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4A\xF0"],
        ["\x4A\xF0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\xA7"],

        ["\xE9\x9C\xB8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4A\xF1"],
        ["\x4A\xF1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9C\xB8"],

        ["\xE6\x9C\xAE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4A\xF2"],
        ["\x4A\xF2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\xAE"],

        ["\xE6\x9C\xBF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4A\xF3"],
        ["\x4A\xF3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\xBF"],

        ["\xE6\x9C\xB6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4A\xF4"],
        ["\x4A\xF4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\xB6"],

        ["\xE6\x9D\x81",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4A\xF5"],
        ["\x4A\xF5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\x81"],

        ["\xE6\x9C\xB8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4A\xF6"],
        ["\x4A\xF6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\xB8"],

        ["\xE6\x9C\xB7",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4A\xF7"],
        ["\x4A\xF7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\xB7"],

        ["\xE6\x9D\x86",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4A\xF8"],
        ["\x4A\xF8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\x86"],

        ["\xE6\x9D\x9E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4A\xF9"],
        ["\x4A\xF9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\x9E"],

        ["\xE6\x9D\xA0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4A\x7A"],
        ["\x4A\x7A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\xA0"],

        ["\xE6\x9D\x99",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4A\x5E"],
        ["\x4A\x5E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\x99"],

        ["\xE6\x9D\xA3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4A\x4C"],
        ["\x4A\x4C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\xA3"],

        ["\xE6\x9D\xA4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4A\x7E"],
        ["\x4A\x7E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\xA4"],

        ["\xE6\x9E\x89",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4A\x6E"],
        ["\x4A\x6E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E\x89"],

        ["\xE6\x9D\xB0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4A\x6F"],
        ["\x4A\x6F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\xB0"],

        ["\xE6\x9E\xA9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4A\x7C"],
        ["\x4A\x7C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E\xA9"],

        ["\xE6\x9D\xBC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4A\xC1"],
        ["\x4A\xC1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\xBC"],

        ["\xE6\x9D\xAA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4A\xC2"],
        ["\x4A\xC2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\xAA"],

        ["\xE6\x9E\x8C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4A\xC3"],
        ["\x4A\xC3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E\x8C"],

        ["\xE6\x9E\x8B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4A\xC4"],
        ["\x4A\xC4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E\x8B"],

        ["\xE6\x9E\xA6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4A\xC5"],
        ["\x4A\xC5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E\xA6"],

        ["\xE6\x9E\xA1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4A\xC6"],
        ["\x4A\xC6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E\xA1"],

        ["\xE6\x9E\x85",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4A\xC7"],
        ["\x4A\xC7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E\x85"],

        ["\xE6\x9E\xB7",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4A\xC8"],
        ["\x4A\xC8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E\xB7"],

        ["\xE6\x9F\xAF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4A\xC9"],
        ["\x4A\xC9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\xAF"],

        ["\xE6\x9E\xB4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4A\xD1"],
        ["\x4A\xD1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E\xB4"],

        ["\xE6\x9F\xAC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4A\xD2"],
        ["\x4A\xD2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\xAC"],

        ["\xE6\x9E\xB3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4A\xD3"],
        ["\x4A\xD3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E\xB3"],

        ["\xE6\x9F\xA9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4A\xD4"],
        ["\x4A\xD4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\xA9"],

        ["\xE6\x9E\xB8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4A\xD5"],
        ["\x4A\xD5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E\xB8"],

        ["\xE6\x9F\xA4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4A\xD6"],
        ["\x4A\xD6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\xA4"],

        ["\xE6\x9F\x9E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4A\xD7"],
        ["\x4A\xD7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\x9E"],

        ["\xE6\x9F\x9D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4A\xD8"],
        ["\x4A\xD8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\x9D"],

        ["\xE6\x9F\xA2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4A\xD9"],
        ["\x4A\xD9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\xA2"],

        ["\xE6\x9F\xAE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4A\xE2"],
        ["\x4A\xE2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\xAE"],

        ["\xE6\x9E\xB9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4A\xE3"],
        ["\x4A\xE3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E\xB9"],

        ["\xE6\x9F\x8E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4A\xE4"],
        ["\x4A\xE4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\x8E"],

        ["\xE6\x9F\x86",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4A\xE5"],
        ["\x4A\xE5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\x86"],

        ["\xE6\x9F\xA7",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4A\xE6"],
        ["\x4A\xE6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\xA7"],

        ["\xE6\xAA\x9C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC9\xF0"],
        ["\xC9\xF0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAA\x9C"],

        ["\xE6\xA0\x9E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4A\xE8"],
        ["\x4A\xE8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA0\x9E"],

        ["\xE6\xA1\x86",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4A\xE9"],
        ["\x4A\xE9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\x86"],

        ["\xE6\xA0\xA9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4A\x4A"],
        ["\x4A\x4A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA0\xA9"],

        ["\xE6\xA1\x80",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4A\x5B"],
        ["\x4A\x5B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\x80"],

        ["\xE6\xA1\x8D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4A\x5A"],
        ["\x4A\x5A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\x8D"],

        ["\xE6\xA0\xB2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4A\x5F"],
        ["\x4A\x5F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA0\xB2"],

        ["\xE6\xA1\x8E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4A\x6D"],
        ["\x4A\x6D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\x8E"],

        ["\xE6\xA2\xB3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4A\x79"],
        ["\x4A\x79",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\xB3"],

        ["\xE6\xA0\xAB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4A\x57"],
        ["\x4A\x57",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA0\xAB"],

        ["\xE6\xA1\x99",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4A\x59"],
        ["\x4A\x59",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\x99"],

        ["\xE6\xA1\xA3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4A\x62"],
        ["\x4A\x62",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\xA3"],

        ["\xE6\xA1\xB7",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4A\x63"],
        ["\x4A\x63",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\xB7"],

        ["\xE6\xA1\xBF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4A\x64"],
        ["\x4A\x64",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\xBF"],

        ["\xE6\xA2\x9F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4A\x65"],
        ["\x4A\x65",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\x9F"],

        ["\xE6\xA2\x8F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4A\x66"],
        ["\x4A\x66",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\x8F"],

        ["\xE6\xA2\xAD",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4A\x67"],
        ["\x4A\x67",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\xAD"],

        ["\xE6\xA2\x94",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4A\x68"],
        ["\x4A\x68",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\x94"],

        ["\xE6\xA2\x9D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4A\x69"],
        ["\x4A\x69",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\x9D"],

        ["\xE6\xA2\x9B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4A\x70"],
        ["\x4A\x70",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\x9B"],

        ["\xE6\xA2\x83",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4A\x71"],
        ["\x4A\x71",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\x83"],

        ["\xE6\xAA\xAE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC5\x73"],
        ["\xC5\x73",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAA\xAE"],

        ["\xE6\xA2\xB9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4A\x73"],
        ["\x4A\x73",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\xB9"],

        ["\xE6\xA1\xB4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4A\x74"],
        ["\x4A\x74",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\xB4"],

        ["\xE6\xA2\xB5",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4A\x75"],
        ["\x4A\x75",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\xB5"],

        ["\xE6\xA2\xA0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4A\x76"],
        ["\x4A\x76",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\xA0"],

        ["\xE6\xA2\xBA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4A\x77"],
        ["\x4A\x77",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\xBA"],

        ["\xE6\xA4\x8F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4A\x78"],
        ["\x4A\x78",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\x8F"],

        ["\xE6\xA2\x8D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4A\x80"],
        ["\x4A\x80",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\x8D"],

        ["\xE6\xA1\xBE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4A\x8B"],
        ["\x4A\x8B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\xBE"],

        ["\xE6\xA4\x81",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4A\x9B"],
        ["\x4A\x9B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\x81"],

        ["\xE6\xA3\x8A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4A\x9C"],
        ["\x4A\x9C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\x8A"],

        ["\xE6\xA4\x88",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4A\xA0"],
        ["\x4A\xA0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\x88"],

        ["\xE6\xA3\x98",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4A\xAB"],
        ["\x4A\xAB",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\x98"],

        ["\xE6\xA4\xA2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4A\xB0"],
        ["\x4A\xB0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\xA2"],

        ["\xE6\xA4\xA6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4A\xC0"],
        ["\x4A\xC0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\xA6"],

        ["\xE6\xA3\xA1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4A\x6A"],
        ["\x4A\x6A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\xA1"],

        ["\xE6\xA4\x8C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4A\xD0"],
        ["\x4A\xD0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\x8C"],

        ["\xE6\xA3\x8D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4A\xA1"],
        ["\x4A\xA1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\x8D"],

        ["\xE6\xA3\x94",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5B\x4F"],
        ["\x5B\x4F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\x94"],

        ["\xE6\xA3\xA7",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5B\x7F"],
        ["\x5B\x7F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\xA7"],

        ["\xE6\xA3\x95",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5B\x7B"],
        ["\x5B\x7B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\x95"],

        ["\xE6\xA4\xB6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5B\xE0"],
        ["\x5B\xE0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\xB6"],

        ["\xE6\xA4\x92",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5B\x6C"],
        ["\x5B\x6C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\x92"],

        ["\xE6\xA4\x84",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5B\x50"],
        ["\x5B\x50",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\x84"],

        ["\xE6\xA3\x97",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5B\x7D"],
        ["\x5B\x7D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\x97"],

        ["\xE6\xA3\xA3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5B\x4D"],
        ["\x5B\x4D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\xA3"],

        ["\xE6\xA4\xA5",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5B\x5D"],
        ["\x5B\x5D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\xA5"],

        ["\xE6\xA3\xB9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5B\x5C"],
        ["\x5B\x5C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\xB9"],

        ["\xE6\xA3\xA0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5B\x4E"],
        ["\x5B\x4E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\xA0"],

        ["\xE6\xA3\xAF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5B\x6B"],
        ["\x5B\x6B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\xAF"],

        ["\xE6\xA4\xA8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5B\x60"],
        ["\x5B\x60",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\xA8"],

        ["\xE6\xA4\xAA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5B\x4B"],
        ["\x5B\x4B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\xAA"],

        ["\xE6\xA4\x9A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5B\x61"],
        ["\x5B\x61",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\x9A"],

        ["\xE6\xA4\xA3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5B\xF0"],
        ["\x5B\xF0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\xA3"],

        ["\xE6\xA4\xA1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5B\xF1"],
        ["\x5B\xF1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\xA1"],

        ["\xE6\xA3\x86",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5B\xF2"],
        ["\x5B\xF2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\x86"],

        ["\xE6\xA5\xB9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5B\xF3"],
        ["\x5B\xF3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\xB9"],

        ["\xE6\xA5\xB7",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5B\xF4"],
        ["\x5B\xF4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\xB7"],

        ["\xE6\xA5\x9C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5B\xF5"],
        ["\x5B\xF5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\x9C"],

        ["\xE6\xA5\xB8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5B\xF6"],
        ["\x5B\xF6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\xB8"],

        ["\xE6\xA5\xAB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5B\xF7"],
        ["\x5B\xF7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\xAB"],

        ["\xE6\xA5\x94",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5B\xF8"],
        ["\x5B\xF8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\x94"],

        ["\xE6\xA5\xBE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5B\xF9"],
        ["\x5B\xF9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\xBE"],

        ["\xE6\xA5\xAE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5B\x7A"],
        ["\x5B\x7A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\xAE"],

        ["\xE6\xA4\xB9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5B\x5E"],
        ["\x5B\x5E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\xB9"],

        ["\xE6\xA5\xB4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5B\x4C"],
        ["\x5B\x4C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\xB4"],

        ["\xE6\xA4\xBD",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5B\x7E"],
        ["\x5B\x7E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\xBD"],

        ["\xE6\xA5\x99",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5B\x6E"],
        ["\x5B\x6E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\x99"],

        ["\xE6\xA4\xB0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5B\x6F"],
        ["\x5B\x6F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\xB0"],

        ["\xE6\xA5\xA1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5B\x7C"],
        ["\x5B\x7C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\xA1"],

        ["\xE6\xA5\x9E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5B\xC1"],
        ["\x5B\xC1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\x9E"],

        ["\xE6\xA5\x9D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5B\xC2"],
        ["\x5B\xC2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\x9D"],

        ["\xE6\xA6\x81",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5B\xC3"],
        ["\x5B\xC3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA6\x81"],

        ["\xE6\xA5\xAA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5B\xC4"],
        ["\x5B\xC4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\xAA"],

        ["\xE6\xA6\xB2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5B\xC5"],
        ["\x5B\xC5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA6\xB2"],

        ["\xE6\xA6\xAE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5B\xC6"],
        ["\x5B\xC6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA6\xAE"],

        ["\xE6\xA7\x90",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5B\xC7"],
        ["\x5B\xC7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\x90"],

        ["\xE6\xA6\xBF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5B\xC8"],
        ["\x5B\xC8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA6\xBF"],

        ["\xE6\xA7\x81",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5B\xC9"],
        ["\x5B\xC9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\x81"],

        ["\xE6\xA7\x93",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5B\xD1"],
        ["\x5B\xD1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\x93"],

        ["\xE6\xA6\xBE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5B\xD2"],
        ["\x5B\xD2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA6\xBE"],

        ["\xE6\xA7\x8E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5B\xD3"],
        ["\x5B\xD3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\x8E"],

        ["\xE5\xAF\xA8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5B\xD4"],
        ["\x5B\xD4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\xA8"],

        ["\xE6\xA7\x8A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5B\xD5"],
        ["\x5B\xD5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\x8A"],

        ["\xE6\xA7\x9D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5B\xD6"],
        ["\x5B\xD6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\x9D"],

        ["\xE6\xA6\xBB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5B\xD7"],
        ["\x5B\xD7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA6\xBB"],

        ["\xE6\xA7\x83",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5B\xD8"],
        ["\x5B\xD8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\x83"],

        ["\xE6\xA6\xA7",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5B\xD9"],
        ["\x5B\xD9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA6\xA7"],

        ["\xE6\xA8\xAE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5B\xE2"],
        ["\x5B\xE2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\xAE"],

        ["\xE6\xA6\x91",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5B\xE3"],
        ["\x5B\xE3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA6\x91"],

        ["\xE6\xA6\xA0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5B\xE4"],
        ["\x5B\xE4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA6\xA0"],

        ["\xE6\xA6\x9C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5B\xE5"],
        ["\x5B\xE5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA6\x9C"],

        ["\xE6\xA6\x95",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5B\xE6"],
        ["\x5B\xE6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA6\x95"],

        ["\xE6\xA6\xB4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5B\xE7"],
        ["\x5B\xE7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA6\xB4"],

        ["\xE6\xA7\x9E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5B\xE8"],
        ["\x5B\xE8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\x9E"],

        ["\xE6\xA7\xA8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5B\xE9"],
        ["\x5B\xE9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\xA8"],

        ["\xE6\xA8\x82",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5B\x4A"],
        ["\x5B\x4A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\x82"],

        ["\xE6\xA8\x9B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5B\x5B"],
        ["\x5B\x5B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\x9B"],

        ["\xE6\xA7\xBF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5B\x5A"],
        ["\x5B\x5A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\xBF"],

        ["\xE6\xAC\x8A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5B\x5F"],
        ["\x5B\x5F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAC\x8A"],

        ["\xE6\xA7\xB9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5B\x6D"],
        ["\x5B\x6D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\xB9"],

        ["\xE6\xA7\xB2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5B\x79"],
        ["\x5B\x79",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\xB2"],

        ["\xE6\xA7\xA7",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5B\x57"],
        ["\x5B\x57",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\xA7"],

        ["\xE6\xA8\x85",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5B\x59"],
        ["\x5B\x59",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\x85"],

        ["\xE6\xA6\xB1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5B\x62"],
        ["\x5B\x62",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA6\xB1"],

        ["\xE6\xA8\x9E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5B\x63"],
        ["\x5B\x63",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\x9E"],

        ["\xE6\xA7\xAD",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5B\x64"],
        ["\x5B\x64",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\xAD"],

        ["\xE6\xA8\x94",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5B\x65"],
        ["\x5B\x65",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\x94"],

        ["\xE6\xA7\xAB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5B\x66"],
        ["\x5B\x66",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\xAB"],

        ["\xE6\xA8\x8A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5B\x67"],
        ["\x5B\x67",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\x8A"],

        ["\xE6\xA8\x92",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5B\x68"],
        ["\x5B\x68",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\x92"],

        ["\xE6\xAB\x81",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5B\x69"],
        ["\x5B\x69",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAB\x81"],

        ["\xE6\xA8\xA3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5B\x70"],
        ["\x5B\x70",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\xA3"],

        ["\xE6\xA8\x93",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5B\x71"],
        ["\x5B\x71",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\x93"],

        ["\xE6\xA9\x84",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5B\x72"],
        ["\x5B\x72",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA9\x84"],

        ["\xE6\xA8\x8C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5B\x73"],
        ["\x5B\x73",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\x8C"],

        ["\xE6\xA9\xB2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5B\x74"],
        ["\x5B\x74",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA9\xB2"],

        ["\xE6\xA8\xB6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5B\x75"],
        ["\x5B\x75",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\xB6"],

        ["\xE6\xA9\xB8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5B\x76"],
        ["\x5B\x76",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA9\xB8"],

        ["\xE6\xA9\x87",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5B\x77"],
        ["\x5B\x77",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA9\x87"],

        ["\xE6\xA9\xA2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5B\x78"],
        ["\x5B\x78",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA9\xA2"],

        ["\xE6\xA9\x99",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5B\x80"],
        ["\x5B\x80",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA9\x99"],

        ["\xE6\xA9\xA6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5B\x8B"],
        ["\x5B\x8B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA9\xA6"],

        ["\xE6\xA9\x88",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5B\x9B"],
        ["\x5B\x9B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA9\x88"],

        ["\xE6\xA8\xB8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5B\x9C"],
        ["\x5B\x9C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\xB8"],

        ["\xE6\xA8\xA2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5B\xA0"],
        ["\x5B\xA0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\xA2"],

        ["\xE6\xAA\x90",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5B\xAB"],
        ["\x5B\xAB",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAA\x90"],

        ["\xE6\xAA\x8D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5B\xB0"],
        ["\x5B\xB0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAA\x8D"],

        ["\xE6\xAA\xA0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5B\xC0"],
        ["\x5B\xC0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAA\xA0"],

        ["\xE6\xAA\x84",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5B\x6A"],
        ["\x5B\x6A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAA\x84"],

        ["\xE6\xAA\xA2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5B\xD0"],
        ["\x5B\xD0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAA\xA2"],

        ["\xE6\xAA\xA3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5B\xA1"],
        ["\x5B\xA1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAA\xA3"],

        ["\xE6\xAA\x97",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5A\x4F"],
        ["\x5A\x4F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAA\x97"],

        ["\xE8\x98\x97",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5A\x7F"],
        ["\x5A\x7F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x98\x97"],

        ["\xE6\xAA\xBB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5A\x7B"],
        ["\x5A\x7B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAA\xBB"],

        ["\xE6\xAB\x83",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5A\xE0"],
        ["\x5A\xE0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAB\x83"],

        ["\xE6\xAB\x82",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5A\x6C"],
        ["\x5A\x6C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAB\x82"],

        ["\xE6\xAA\xB8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5A\x50"],
        ["\x5A\x50",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAA\xB8"],

        ["\xE6\xAA\xB3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5A\x7D"],
        ["\x5A\x7D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAA\xB3"],

        ["\xE6\xAA\xAC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5A\x4D"],
        ["\x5A\x4D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAA\xAC"],

        ["\xE6\xAB\x9E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5A\x5D"],
        ["\x5A\x5D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAB\x9E"],

        ["\xE6\xAB\x91",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5A\x5C"],
        ["\x5A\x5C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAB\x91"],

        ["\xE6\xAB\x9F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5A\x4E"],
        ["\x5A\x4E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAB\x9F"],

        ["\xE6\xAA\xAA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5A\x6B"],
        ["\x5A\x6B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAA\xAA"],

        ["\xE6\xAB\x9A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5A\x60"],
        ["\x5A\x60",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAB\x9A"],

        ["\xE6\xAB\xAA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5A\x4B"],
        ["\x5A\x4B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAB\xAA"],

        ["\xE6\xAB\xBB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5A\x61"],
        ["\x5A\x61",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAB\xBB"],

        ["\xE6\xAC\x85",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5A\xF0"],
        ["\x5A\xF0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAC\x85"],

        ["\xE8\x98\x96",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5A\xF1"],
        ["\x5A\xF1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x98\x96"],

        ["\xE6\xAB\xBA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5A\xF2"],
        ["\x5A\xF2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAB\xBA"],

        ["\xE6\xAC\x92",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5A\xF3"],
        ["\x5A\xF3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAC\x92"],

        ["\xE6\xAC\x96",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5A\xF4"],
        ["\x5A\xF4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAC\x96"],

        ["\xE9\xAC\xB1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5A\xF5"],
        ["\x5A\xF5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xAC\xB1"],

        ["\xE6\xAC\x9F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5A\xF6"],
        ["\x5A\xF6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAC\x9F"],

        ["\xE6\xAC\xB8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5A\xF7"],
        ["\x5A\xF7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAC\xB8"],

        ["\xE6\xAC\xB7",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5A\xF8"],
        ["\x5A\xF8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAC\xB7"],

        ["\xE7\x9B\x9C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5A\xF9"],
        ["\x5A\xF9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\x9C"],

        ["\xE6\xAC\xB9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5A\x7A"],
        ["\x5A\x7A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAC\xB9"],

        ["\xE9\xA3\xAE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5A\x5E"],
        ["\x5A\x5E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA3\xAE"],

        ["\xE6\xAD\x87",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5A\x4C"],
        ["\x5A\x4C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\x87"],

        ["\xE6\xAD\x83",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5A\x7E"],
        ["\x5A\x7E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\x83"],

        ["\xE6\xAD\x89",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5A\x6E"],
        ["\x5A\x6E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\x89"],

        ["\xE6\xAD\x90",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5A\x6F"],
        ["\x5A\x6F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\x90"],

        ["\xE6\xAD\x99",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5A\x7C"],
        ["\x5A\x7C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\x99"],

        ["\xE6\xAD\x94",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5A\xC1"],
        ["\x5A\xC1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\x94"],

        ["\xE6\xAD\x9B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5A\xC2"],
        ["\x5A\xC2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\x9B"],

        ["\xE6\xAD\x9F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5A\xC3"],
        ["\x5A\xC3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\x9F"],

        ["\xE6\xAD\xA1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5A\xC4"],
        ["\x5A\xC4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\xA1"],

        ["\xE6\xAD\xB8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5A\xC5"],
        ["\x5A\xC5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\xB8"],

        ["\xE6\xAD\xB9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5A\xC6"],
        ["\x5A\xC6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\xB9"],

        ["\xE6\xAD\xBF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5A\xC7"],
        ["\x5A\xC7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\xBF"],

        ["\xE6\xAE\x80",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5A\xC8"],
        ["\x5A\xC8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\x80"],

        ["\xE6\xAE\x84",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5A\xC9"],
        ["\x5A\xC9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\x84"],

        ["\xE6\xAE\x83",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5A\xD1"],
        ["\x5A\xD1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\x83"],

        ["\xE6\xAE\x8D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5A\xD2"],
        ["\x5A\xD2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\x8D"],

        ["\xE6\xAE\x98",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5A\xD3"],
        ["\x5A\xD3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\x98"],

        ["\xE6\xAE\x95",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5A\xD4"],
        ["\x5A\xD4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\x95"],

        ["\xE6\xAE\x9E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5A\xD5"],
        ["\x5A\xD5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\x9E"],

        ["\xE6\xAE\xA4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5A\xD6"],
        ["\x5A\xD6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\xA4"],

        ["\xE6\xAE\xAA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5A\xD7"],
        ["\x5A\xD7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\xAA"],

        ["\xE6\xAE\xAB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5A\xD8"],
        ["\x5A\xD8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\xAB"],

        ["\xE6\xAE\xAF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5A\xD9"],
        ["\x5A\xD9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\xAF"],

        ["\xE6\xAE\xB2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5A\xE2"],
        ["\x5A\xE2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\xB2"],

        ["\xE6\xAE\xB1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5A\xE3"],
        ["\x5A\xE3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\xB1"],

        ["\xE6\xAE\xB3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5A\xE4"],
        ["\x5A\xE4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\xB3"],

        ["\xE6\xAE\xB7",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5A\xE5"],
        ["\x5A\xE5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\xB7"],

        ["\xE6\xAE\xBC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5A\xE6"],
        ["\x5A\xE6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\xBC"],

        ["\xE6\xAF\x86",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5A\xE7"],
        ["\x5A\xE7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAF\x86"],

        ["\xE6\xAF\x8B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5A\xE8"],
        ["\x5A\xE8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAF\x8B"],

        ["\xE6\xAF\x93",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5A\xE9"],
        ["\x5A\xE9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAF\x93"],

        ["\xE6\xAF\x9F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5A\x4A"],
        ["\x5A\x4A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAF\x9F"],

        ["\xE6\xAF\xAC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5A\x5B"],
        ["\x5A\x5B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAF\xAC"],

        ["\xE6\xAF\xAB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5A\x5A"],
        ["\x5A\x5A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAF\xAB"],

        ["\xE6\xAF\xB3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5A\x5F"],
        ["\x5A\x5F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAF\xB3"],

        ["\xE6\xAF\xAF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5A\x6D"],
        ["\x5A\x6D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAF\xAF"],

        ["\xE9\xBA\xBE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5A\x79"],
        ["\x5A\x79",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xBA\xBE"],

        ["\xE6\xB0\x88",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5A\x57"],
        ["\x5A\x57",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB0\x88"],

        ["\xE6\xB0\x93",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5A\x59"],
        ["\x5A\x59",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB0\x93"],

        ["\xE6\xB0\x94",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5A\x62"],
        ["\x5A\x62",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB0\x94"],

        ["\xE6\xB0\x9B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5A\x63"],
        ["\x5A\x63",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB0\x9B"],

        ["\xE6\xB0\xA4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5A\x64"],
        ["\x5A\x64",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB0\xA4"],

        ["\xE6\xB0\xA3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5A\x65"],
        ["\x5A\x65",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB0\xA3"],

        ["\xE6\xB1\x9E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5A\x66"],
        ["\x5A\x66",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1\x9E"],

        ["\xE6\xB1\x95",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5A\x67"],
        ["\x5A\x67",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1\x95"],

        ["\xE6\xB1\xA2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5A\x68"],
        ["\x5A\x68",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1\xA2"],

        ["\xE6\xB1\xAA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5A\x69"],
        ["\x5A\x69",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1\xAA"],

        ["\xE6\xB2\x82",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5A\x70"],
        ["\x5A\x70",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\x82"],

        ["\xE6\xB2\x8D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5A\x71"],
        ["\x5A\x71",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\x8D"],

        ["\xE6\xB2\x9A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5A\x72"],
        ["\x5A\x72",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\x9A"],

        ["\xE6\xB2\x81",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5A\x73"],
        ["\x5A\x73",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\x81"],

        ["\xE6\xB2\x9B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5A\x74"],
        ["\x5A\x74",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\x9B"],

        ["\xE6\xB1\xBE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5A\x75"],
        ["\x5A\x75",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1\xBE"],

        ["\xE6\xB1\xA8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5A\x76"],
        ["\x5A\x76",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1\xA8"],

        ["\xE6\xB1\xB3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5A\x77"],
        ["\x5A\x77",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1\xB3"],

        ["\xE6\xB2\x92",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5A\x78"],
        ["\x5A\x78",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\x92"],

        ["\xE6\xB2\x90",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5A\x80"],
        ["\x5A\x80",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\x90"],

        ["\xE6\xB3\x84",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5A\x8B"],
        ["\x5A\x8B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\x84"],

        ["\xE6\xB3\xB1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5A\x9B"],
        ["\x5A\x9B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\xB1"],

        ["\xE6\xB3\x93",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5A\x9C"],
        ["\x5A\x9C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\x93"],

        ["\xE6\xB2\xBD",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5A\xA0"],
        ["\x5A\xA0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\xBD"],

        ["\xE6\xB3\x97",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5A\xAB"],
        ["\x5A\xAB",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\x97"],

        ["\xE6\xB3\x85",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5A\xB0"],
        ["\x5A\xB0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\x85"],

        ["\xE6\xB3\x9D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5A\xC0"],
        ["\x5A\xC0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\x9D"],

        ["\xE6\xB2\xAE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5A\x6A"],
        ["\x5A\x6A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\xAE"],

        ["\xE6\xB2\xB1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5A\xD0"],
        ["\x5A\xD0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\xB1"],

        ["\xE6\xB2\xBE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5A\xA1"],
        ["\x5A\xA1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\xBE"],

        ["\xE6\xB2\xBA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5F\x4F"],
        ["\x5F\x4F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\xBA"],

        ["\xE6\xB3\x9B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5F\x7F"],
        ["\x5F\x7F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\x9B"],

        ["\xE6\xB3\xAF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5F\x7B"],
        ["\x5F\x7B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\xAF"],

        ["\xE6\xB3\x99",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5F\xE0"],
        ["\x5F\xE0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\x99"],

        ["\xE6\xB3\xAA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5F\x6C"],
        ["\x5F\x6C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\xAA"],

        ["\xE6\xB4\x9F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5F\x50"],
        ["\x5F\x50",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4\x9F"],

        ["\xE8\xA1\x8D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5F\x7D"],
        ["\x5F\x7D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\x8D"],

        ["\xE6\xB4\xB6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5F\x4D"],
        ["\x5F\x4D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4\xB6"],

        ["\xE6\xB4\xAB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5F\x5D"],
        ["\x5F\x5D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4\xAB"],

        ["\xE6\xB4\xBD",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5F\x5C"],
        ["\x5F\x5C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4\xBD"],

        ["\xE6\xB4\xB8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5F\x4E"],
        ["\x5F\x4E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4\xB8"],

        ["\xE6\xB4\x99",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5F\x6B"],
        ["\x5F\x6B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4\x99"],

        ["\xE6\xB4\xB5",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5F\x60"],
        ["\x5F\x60",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4\xB5"],

        ["\xE6\xB4\xB3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5F\x4B"],
        ["\x5F\x4B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4\xB3"],

        ["\xE6\xB4\x92",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5F\x61"],
        ["\x5F\x61",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4\x92"],

        ["\xE6\xB4\x8C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5F\xF0"],
        ["\x5F\xF0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4\x8C"],

        ["\xE6\xB5\xA3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5F\xF1"],
        ["\x5F\xF1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB5\xA3"],

        ["\xE6\xB6\x93",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5F\xF2"],
        ["\x5F\xF2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB6\x93"],

        ["\xE6\xB5\xA4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5F\xF3"],
        ["\x5F\xF3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB5\xA4"],

        ["\xE6\xB5\x9A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5F\xF4"],
        ["\x5F\xF4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB5\x9A"],

        ["\xE6\xB5\xB9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5F\xF5"],
        ["\x5F\xF5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB5\xB9"],

        ["\xE6\xB5\x99",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5F\xF6"],
        ["\x5F\xF6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB5\x99"],

        ["\xE6\xB6\x8E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5F\xF7"],
        ["\x5F\xF7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB6\x8E"],

        ["\xE6\xB6\x95",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5F\xF8"],
        ["\x5F\xF8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB6\x95"],

        ["\xE6\xBF\xA4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC5\x78"],
        ["\xC5\x78",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF\xA4"],

        ["\xE6\xB6\x85",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5F\x7A"],
        ["\x5F\x7A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB6\x85"],

        ["\xE6\xB7\xB9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5F\x5E"],
        ["\x5F\x5E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\xB9"],

        ["\xE6\xB8\x95",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5F\x4C"],
        ["\x5F\x4C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\x95"],

        ["\xE6\xB8\x8A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5F\x7E"],
        ["\x5F\x7E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\x8A"],

        ["\xE6\xB6\xB5",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5F\x6E"],
        ["\x5F\x6E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB6\xB5"],

        ["\xE6\xB7\x87",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5F\x6F"],
        ["\x5F\x6F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\x87"],

        ["\xE6\xB7\xA6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5F\x7C"],
        ["\x5F\x7C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\xA6"],

        ["\xE6\xB6\xB8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5F\xC1"],
        ["\x5F\xC1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB6\xB8"],

        ["\xE6\xB7\x86",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5F\xC2"],
        ["\x5F\xC2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\x86"],

        ["\xE6\xB7\xAC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5F\xC3"],
        ["\x5F\xC3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\xAC"],

        ["\xE6\xB7\x9E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5F\xC4"],
        ["\x5F\xC4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\x9E"],

        ["\xE6\xB7\x8C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5F\xC5"],
        ["\x5F\xC5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\x8C"],

        ["\xE6\xB7\xA8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5F\xC6"],
        ["\x5F\xC6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\xA8"],

        ["\xE6\xB7\x92",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5F\xC7"],
        ["\x5F\xC7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\x92"],

        ["\xE6\xB7\x85",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5F\xC8"],
        ["\x5F\xC8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\x85"],

        ["\xE6\xB7\xBA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5F\xC9"],
        ["\x5F\xC9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\xBA"],

        ["\xE6\xB7\x99",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5F\xD1"],
        ["\x5F\xD1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\x99"],

        ["\xE6\xB7\xA4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5F\xD2"],
        ["\x5F\xD2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\xA4"],

        ["\xE6\xB7\x95",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5F\xD3"],
        ["\x5F\xD3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\x95"],

        ["\xE6\xB7\xAA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5F\xD4"],
        ["\x5F\xD4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\xAA"],

        ["\xE6\xB7\xAE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5F\xD5"],
        ["\x5F\xD5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\xAE"],

        ["\xE6\xB8\xAD",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5F\xD6"],
        ["\x5F\xD6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\xAD"],

        ["\xE6\xB9\xAE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5F\xD7"],
        ["\x5F\xD7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB9\xAE"],

        ["\xE6\xB8\xAE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5F\xD8"],
        ["\x5F\xD8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\xAE"],

        ["\xE6\xB8\x99",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5F\xD9"],
        ["\x5F\xD9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\x99"],

        ["\xE6\xB9\xB2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5F\xE2"],
        ["\x5F\xE2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB9\xB2"],

        ["\xE6\xB9\x9F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5F\xE3"],
        ["\x5F\xE3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB9\x9F"],

        ["\xE6\xB8\xBE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5F\xE4"],
        ["\x5F\xE4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\xBE"],

        ["\xE6\xB8\xA3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5F\xE5"],
        ["\x5F\xE5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\xA3"],

        ["\xE6\xB9\xAB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5F\xE6"],
        ["\x5F\xE6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB9\xAB"],

        ["\xE6\xB8\xAB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5F\xE7"],
        ["\x5F\xE7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\xAB"],

        ["\xE6\xB9\xB6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5F\xE8"],
        ["\x5F\xE8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB9\xB6"],

        ["\xE6\xB9\x8D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5F\xE9"],
        ["\x5F\xE9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB9\x8D"],

        ["\xE6\xB8\x9F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5F\x4A"],
        ["\x5F\x4A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\x9F"],

        ["\xE6\xB9\x83",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5F\x5B"],
        ["\x5F\x5B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB9\x83"],

        ["\xE6\xB8\xBA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5F\x5A"],
        ["\x5F\x5A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\xBA"],

        ["\xE6\xB9\x8E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5F\x5F"],
        ["\x5F\x5F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB9\x8E"],

        ["\xE6\xB8\xA4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5F\x6D"],
        ["\x5F\x6D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\xA4"],

        ["\xE6\xBB\xBF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5F\x79"],
        ["\x5F\x79",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBB\xBF"],

        ["\xE6\xB8\x9D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5F\x57"],
        ["\x5F\x57",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\x9D"],

        ["\xE6\xB8\xB8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5F\x59"],
        ["\x5F\x59",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\xB8"],

        ["\xE6\xBA\x82",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5F\x62"],
        ["\x5F\x62",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBA\x82"],

        ["\xE6\xBA\xAA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5F\x63"],
        ["\x5F\x63",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBA\xAA"],

        ["\xE6\xBA\x98",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5F\x64"],
        ["\x5F\x64",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBA\x98"],

        ["\xE6\xBB\x89",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5F\x65"],
        ["\x5F\x65",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBB\x89"],

        ["\xE6\xBA\xB7",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5F\x66"],
        ["\x5F\x66",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBA\xB7"],

        ["\xE6\xBB\x93",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5F\x67"],
        ["\x5F\x67",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBB\x93"],

        ["\xE6\xBA\xBD",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5F\x68"],
        ["\x5F\x68",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBA\xBD"],

        ["\xE6\xBA\xAF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5F\x69"],
        ["\x5F\x69",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBA\xAF"],

        ["\xE6\xBB\x84",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5F\x70"],
        ["\x5F\x70",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBB\x84"],

        ["\xE6\xBA\xB2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5F\x71"],
        ["\x5F\x71",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBA\xB2"],

        ["\xE6\xBB\x94",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5F\x72"],
        ["\x5F\x72",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBB\x94"],

        ["\xE6\xBB\x95",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5F\x73"],
        ["\x5F\x73",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBB\x95"],

        ["\xE6\xBA\x8F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5F\x74"],
        ["\x5F\x74",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBA\x8F"],

        ["\xE6\xBA\xA5",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5F\x75"],
        ["\x5F\x75",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBA\xA5"],

        ["\xE6\xBB\x82",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5F\x76"],
        ["\x5F\x76",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBB\x82"],

        ["\xE6\xBA\x9F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5F\x77"],
        ["\x5F\x77",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBA\x9F"],

        ["\xE6\xBD\x81",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5F\x78"],
        ["\x5F\x78",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBD\x81"],

        ["\xE6\xBC\x91",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5F\x80"],
        ["\x5F\x80",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBC\x91"],

        ["\xE7\x81\x8C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF4\xC3"],
        ["\xF4\xC3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x81\x8C"],

        ["\xE6\xBB\xAC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5F\x9B"],
        ["\x5F\x9B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBB\xAC"],

        ["\xE6\xBB\xB8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5F\x9C"],
        ["\x5F\x9C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBB\xB8"],

        ["\xE6\xBB\xBE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5F\xA0"],
        ["\x5F\xA0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBB\xBE"],

        ["\xE6\xBC\xBF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5F\xAB"],
        ["\x5F\xAB",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBC\xBF"],

        ["\xE6\xBB\xB2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5F\xB0"],
        ["\x5F\xB0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBB\xB2"],

        ["\xE6\xBC\xB1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5F\xC0"],
        ["\x5F\xC0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBC\xB1"],

        ["\xE6\xBB\xAF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5F\x6A"],
        ["\x5F\x6A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBB\xAF"],

        ["\xE6\xBC\xB2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5F\xD0"],
        ["\x5F\xD0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBC\xB2"],

        ["\xE6\xBB\x8C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x5F\xA1"],
        ["\x5F\xA1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBB\x8C"],

        ["\xE6\xBC\xBE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6D\x4F"],
        ["\x6D\x4F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBC\xBE"],

        ["\xE6\xBC\x93",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6D\x7F"],
        ["\x6D\x7F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBC\x93"],

        ["\xE6\xBB\xB7",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6D\x7B"],
        ["\x6D\x7B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBB\xB7"],

        ["\xE6\xBE\x86",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6D\xE0"],
        ["\x6D\xE0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBE\x86"],

        ["\xE6\xBD\xBA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6D\x6C"],
        ["\x6D\x6C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBD\xBA"],

        ["\xE6\xBD\xB8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6D\x50"],
        ["\x6D\x50",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBD\xB8"],

        ["\xE6\xBE\x81",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6D\x7D"],
        ["\x6D\x7D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBE\x81"],

        ["\xE6\xBE\x80",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6D\x4D"],
        ["\x6D\x4D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBE\x80"],

        ["\xE6\xBD\xAF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6D\x5D"],
        ["\x6D\x5D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBD\xAF"],

        ["\xE6\xBD\x9B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6D\x5C"],
        ["\x6D\x5C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBD\x9B"],

        ["\xE6\xBF\xB3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6D\x4E"],
        ["\x6D\x4E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF\xB3"],

        ["\xE6\xBD\xAD",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6D\x6B"],
        ["\x6D\x6B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBD\xAD"],

        ["\xE6\xBE\x82",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6D\x60"],
        ["\x6D\x60",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBE\x82"],

        ["\xE6\xBD\xBC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6D\x4B"],
        ["\x6D\x4B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBD\xBC"],

        ["\xE6\xBD\x98",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6D\x61"],
        ["\x6D\x61",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBD\x98"],

        ["\xE6\xBE\x8E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6D\xF0"],
        ["\x6D\xF0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBE\x8E"],

        ["\xE6\xBE\x91",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6D\xF1"],
        ["\x6D\xF1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBE\x91"],

        ["\xE6\xBF\x82",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6D\xF2"],
        ["\x6D\xF2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF\x82"],

        ["\xE6\xBD\xA6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6D\xF3"],
        ["\x6D\xF3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBD\xA6"],

        ["\xE6\xBE\xB3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6D\xF4"],
        ["\x6D\xF4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBE\xB3"],

        ["\xE6\xBE\xA3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6D\xF5"],
        ["\x6D\xF5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBE\xA3"],

        ["\xE6\xBE\xA1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6D\xF6"],
        ["\x6D\xF6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBE\xA1"],

        ["\xE6\xBE\xA4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6D\xF7"],
        ["\x6D\xF7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBE\xA4"],

        ["\xE6\xBE\xB9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6D\xF8"],
        ["\x6D\xF8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBE\xB9"],

        ["\xE6\xBF\x86",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6D\xF9"],
        ["\x6D\xF9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF\x86"],

        ["\xE6\xBE\xAA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6D\x7A"],
        ["\x6D\x7A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBE\xAA"],

        ["\xE6\xBF\x9F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6D\x5E"],
        ["\x6D\x5E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF\x9F"],

        ["\xE6\xBF\x95",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6D\x4C"],
        ["\x6D\x4C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF\x95"],

        ["\xE6\xBF\xAC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6D\x7E"],
        ["\x6D\x7E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF\xAC"],

        ["\xE6\xBF\x94",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6D\x6E"],
        ["\x6D\x6E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF\x94"],

        ["\xE6\xBF\x98",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6D\x6F"],
        ["\x6D\x6F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF\x98"],

        ["\xE6\xBF\xB1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6D\x7C"],
        ["\x6D\x7C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF\xB1"],

        ["\xE6\xBF\xAE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6D\xC1"],
        ["\x6D\xC1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF\xAE"],

        ["\xE6\xBF\x9B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6D\xC2"],
        ["\x6D\xC2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF\x9B"],

        ["\xE7\x80\x89",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6D\xC3"],
        ["\x6D\xC3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x80\x89"],

        ["\xE7\x80\x8B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6D\xC4"],
        ["\x6D\xC4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x80\x8B"],

        ["\xE6\xBF\xBA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6D\xC5"],
        ["\x6D\xC5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF\xBA"],

        ["\xE7\x80\x91",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6D\xC6"],
        ["\x6D\xC6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x80\x91"],

        ["\xE7\x80\x81",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6D\xC7"],
        ["\x6D\xC7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x80\x81"],

        ["\xE7\x80\x8F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6D\xC8"],
        ["\x6D\xC8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x80\x8F"],

        ["\xE6\xBF\xBE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6D\xC9"],
        ["\x6D\xC9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF\xBE"],

        ["\xE7\x80\x9B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6D\xD1"],
        ["\x6D\xD1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x80\x9B"],

        ["\xE7\x80\x9A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6D\xD2"],
        ["\x6D\xD2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x80\x9A"],

        ["\xE6\xBD\xB4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6D\xD3"],
        ["\x6D\xD3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBD\xB4"],

        ["\xE7\x80\x9D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6D\xD4"],
        ["\x6D\xD4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x80\x9D"],

        ["\xE7\x80\x98",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6D\xD5"],
        ["\x6D\xD5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x80\x98"],

        ["\xE7\x80\x9F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6D\xD6"],
        ["\x6D\xD6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x80\x9F"],

        ["\xE7\x80\xB0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6D\xD7"],
        ["\x6D\xD7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x80\xB0"],

        ["\xE7\x80\xBE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6D\xD8"],
        ["\x6D\xD8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x80\xBE"],

        ["\xE7\x80\xB2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6D\xD9"],
        ["\x6D\xD9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x80\xB2"],

        ["\xE7\x81\x91",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6D\xE2"],
        ["\x6D\xE2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x81\x91"],

        ["\xE7\x81\xA3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6D\xE3"],
        ["\x6D\xE3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x81\xA3"],

        ["\xE7\x82\x99",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6D\xE4"],
        ["\x6D\xE4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x82\x99"],

        ["\xE7\x82\x92",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6D\xE5"],
        ["\x6D\xE5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x82\x92"],

        ["\xE7\x82\xAF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6D\xE6"],
        ["\x6D\xE6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x82\xAF"],

        ["\xE7\x83\xB1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6D\xE7"],
        ["\x6D\xE7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x83\xB1"],

        ["\xE7\x82\xAC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6D\xE8"],
        ["\x6D\xE8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x82\xAC"],

        ["\xE7\x82\xB8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6D\xE9"],
        ["\x6D\xE9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x82\xB8"],

        ["\xE7\x82\xB3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6D\x4A"],
        ["\x6D\x4A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x82\xB3"],

        ["\xE7\x82\xAE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6D\x5B"],
        ["\x6D\x5B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x82\xAE"],

        ["\xE7\x83\x9F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6D\x5A"],
        ["\x6D\x5A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x83\x9F"],

        ["\xE7\x83\x8B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6D\x5F"],
        ["\x6D\x5F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x83\x8B"],

        ["\xE7\x83\x9D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6D\x6D"],
        ["\x6D\x6D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x83\x9D"],

        ["\xE7\x83\x99",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6D\x79"],
        ["\x6D\x79",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x83\x99"],

        ["\xE7\x84\x89",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6D\x57"],
        ["\x6D\x57",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x84\x89"],

        ["\xE7\x83\xBD",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6D\x59"],
        ["\x6D\x59",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x83\xBD"],

        ["\xE7\x84\x9C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6D\x62"],
        ["\x6D\x62",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x84\x9C"],

        ["\xE7\x84\x99",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6D\x63"],
        ["\x6D\x63",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x84\x99"],

        ["\xE7\x85\xA5",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6D\x64"],
        ["\x6D\x64",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x85\xA5"],

        ["\xE7\x85\x95",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6D\x65"],
        ["\x6D\x65",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x85\x95"],

        ["\xE7\x86\x88",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6D\x66"],
        ["\x6D\x66",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x86\x88"],

        ["\xE7\x85\xA6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6D\x67"],
        ["\x6D\x67",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x85\xA6"],

        ["\xE7\x85\xA2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6D\x68"],
        ["\x6D\x68",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x85\xA2"],

        ["\xE7\x85\x8C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6D\x69"],
        ["\x6D\x69",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x85\x8C"],

        ["\xE7\x85\x96",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6D\x70"],
        ["\x6D\x70",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x85\x96"],

        ["\xE7\x85\xAC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6D\x71"],
        ["\x6D\x71",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x85\xAC"],

        ["\xE7\x86\x8F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6D\x72"],
        ["\x6D\x72",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x86\x8F"],

        ["\xE7\x87\xBB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6D\x73"],
        ["\x6D\x73",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x87\xBB"],

        ["\xE7\x86\x84",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6D\x74"],
        ["\x6D\x74",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x86\x84"],

        ["\xE7\x86\x95",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6D\x75"],
        ["\x6D\x75",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x86\x95"],

        ["\xE7\x86\xA8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6D\x76"],
        ["\x6D\x76",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x86\xA8"],

        ["\xE7\x86\xAC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6D\x77"],
        ["\x6D\x77",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x86\xAC"],

        ["\xE7\x87\x97",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6D\x78"],
        ["\x6D\x78",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x87\x97"],

        ["\xE7\x86\xB9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6D\x80"],
        ["\x6D\x80",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x86\xB9"],

        ["\xE7\x86\xBE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6D\x8B"],
        ["\x6D\x8B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x86\xBE"],

        ["\xE7\x87\x92",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6D\x9B"],
        ["\x6D\x9B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x87\x92"],

        ["\xE7\x87\x89",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6D\x9C"],
        ["\x6D\x9C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x87\x89"],

        ["\xE7\x87\x94",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6D\xA0"],
        ["\x6D\xA0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x87\x94"],

        ["\xE7\x87\x8E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6D\xAB"],
        ["\x6D\xAB",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x87\x8E"],

        ["\xE7\x87\xA0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6D\xB0"],
        ["\x6D\xB0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x87\xA0"],

        ["\xE7\x87\xAC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6D\xC0"],
        ["\x6D\xC0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x87\xAC"],

        ["\xE7\x87\xA7",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6D\x6A"],
        ["\x6D\x6A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x87\xA7"],

        ["\xE7\x87\xB5",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6D\xD0"],
        ["\x6D\xD0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x87\xB5"],

        ["\xE7\x87\xBC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x6D\xA1"],
        ["\x6D\xA1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x87\xBC"],

        ["\xE7\x87\xB9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x79\x4F"],
        ["\x79\x4F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x87\xB9"],

        ["\xE7\x87\xBF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x79\x7F"],
        ["\x79\x7F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x87\xBF"],

        ["\xE7\x88\x8D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x79\x7B"],
        ["\x79\x7B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x88\x8D"],

        ["\xE7\x88\x90",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x79\xE0"],
        ["\x79\xE0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x88\x90"],

        ["\xE7\x88\x9B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x79\x6C"],
        ["\x79\x6C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x88\x9B"],

        ["\xE7\x88\xA8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x79\x50"],
        ["\x79\x50",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x88\xA8"],

        ["\xE7\x88\xAD",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x79\x7D"],
        ["\x79\x7D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x88\xAD"],

        ["\xE7\x88\xAC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x79\x4D"],
        ["\x79\x4D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x88\xAC"],

        ["\xE7\x88\xB0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x79\x5D"],
        ["\x79\x5D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x88\xB0"],

        ["\xE7\x88\xB2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x79\x5C"],
        ["\x79\x5C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x88\xB2"],

        ["\xE7\x88\xBB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x79\x4E"],
        ["\x79\x4E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x88\xBB"],

        ["\xE7\x88\xBC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x79\x6B"],
        ["\x79\x6B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x88\xBC"],

        ["\xE7\x88\xBF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x79\x60"],
        ["\x79\x60",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x88\xBF"],

        ["\xE7\x89\x80",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x79\x4B"],
        ["\x79\x4B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x89\x80"],

        ["\xE7\x89\x86",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x79\x61"],
        ["\x79\x61",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x89\x86"],

        ["\xE7\x89\x8B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x79\xF0"],
        ["\x79\xF0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x89\x8B"],

        ["\xE7\x89\x98",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x79\xF1"],
        ["\x79\xF1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x89\x98"],

        ["\xE7\x89\xB4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x79\xF2"],
        ["\x79\xF2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x89\xB4"],

        ["\xE7\x89\xBE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x79\xF3"],
        ["\x79\xF3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x89\xBE"],

        ["\xE7\x8A\x82",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x79\xF4"],
        ["\x79\xF4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8A\x82"],

        ["\xE7\x8A\x81",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x79\xF5"],
        ["\x79\xF5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8A\x81"],

        ["\xE7\x8A\x87",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x79\xF6"],
        ["\x79\xF6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8A\x87"],

        ["\xE7\x8A\x92",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x79\xF7"],
        ["\x79\xF7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8A\x92"],

        ["\xE7\x8A\x96",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x79\xF8"],
        ["\x79\xF8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8A\x96"],

        ["\xE7\x8A\xA2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x79\xF9"],
        ["\x79\xF9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8A\xA2"],

        ["\xE7\x8A\xA7",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x79\x7A"],
        ["\x79\x7A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8A\xA7"],

        ["\xE7\x8A\xB9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x79\x5E"],
        ["\x79\x5E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8A\xB9"],

        ["\xE7\x8A\xB2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x79\x4C"],
        ["\x79\x4C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8A\xB2"],

        ["\xE7\x8B\x83",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x79\x7E"],
        ["\x79\x7E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8B\x83"],

        ["\xE7\x8B\x86",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x79\x6E"],
        ["\x79\x6E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8B\x86"],

        ["\xE7\x8B\x84",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x79\x6F"],
        ["\x79\x6F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8B\x84"],

        ["\xE7\x8B\x8E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x79\x7C"],
        ["\x79\x7C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8B\x8E"],

        ["\xE7\x8B\x92",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x79\xC1"],
        ["\x79\xC1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8B\x92"],

        ["\xE7\x8B\xA2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x79\xC2"],
        ["\x79\xC2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8B\xA2"],

        ["\xE7\x8B\xA0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x79\xC3"],
        ["\x79\xC3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8B\xA0"],

        ["\xE7\x8B\xA1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x79\xC4"],
        ["\x79\xC4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8B\xA1"],

        ["\xE7\x8B\xB9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x79\xC5"],
        ["\x79\xC5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8B\xB9"],

        ["\xE7\x8B\xB7",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x79\xC6"],
        ["\x79\xC6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8B\xB7"],

        ["\xE5\x80\x8F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x79\xC7"],
        ["\x79\xC7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\x8F"],

        ["\xE7\x8C\x97",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x79\xC8"],
        ["\x79\xC8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8C\x97"],

        ["\xE7\x8C\x8A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x79\xC9"],
        ["\x79\xC9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8C\x8A"],

        ["\xE7\x8C\x9C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x79\xD1"],
        ["\x79\xD1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8C\x9C"],

        ["\xE7\x8C\x96",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x79\xD2"],
        ["\x79\xD2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8C\x96"],

        ["\xE7\x8C\x9D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x79\xD3"],
        ["\x79\xD3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8C\x9D"],

        ["\xE7\x8C\xB4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x79\xD4"],
        ["\x79\xD4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8C\xB4"],

        ["\xE7\x8C\xAF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x79\xD5"],
        ["\x79\xD5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8C\xAF"],

        ["\xE7\x8C\xA9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x79\xD6"],
        ["\x79\xD6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8C\xA9"],

        ["\xE7\x8C\xA5",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x79\xD7"],
        ["\x79\xD7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8C\xA5"],

        ["\xE7\x8C\xBE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x79\xD8"],
        ["\x79\xD8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8C\xBE"],

        ["\xE7\x8D\x8E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x79\xD9"],
        ["\x79\xD9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8D\x8E"],

        ["\xE7\x8D\x8F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x79\xE2"],
        ["\x79\xE2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8D\x8F"],

        ["\xE9\xBB\x98",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x79\xE3"],
        ["\x79\xE3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xBB\x98"],

        ["\xE7\x8D\x97",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x79\xE4"],
        ["\x79\xE4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8D\x97"],

        ["\xE7\x8D\xAA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x79\xE5"],
        ["\x79\xE5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8D\xAA"],

        ["\xE7\x8D\xA8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x79\xE6"],
        ["\x79\xE6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8D\xA8"],

        ["\xE7\x8D\xB0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x79\xE7"],
        ["\x79\xE7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8D\xB0"],

        ["\xE7\x8D\xB8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x79\xE8"],
        ["\x79\xE8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8D\xB8"],

        ["\xE7\x8D\xB5",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x79\xE9"],
        ["\x79\xE9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8D\xB5"],

        ["\xE7\x8D\xBB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x79\x4A"],
        ["\x79\x4A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8D\xBB"],

        ["\xE7\x8D\xBA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x79\x5B"],
        ["\x79\x5B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8D\xBA"],

        ["\xE7\x8F\x88",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x79\x5A"],
        ["\x79\x5A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8F\x88"],

        ["\xE7\x8E\xB3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x79\x5F"],
        ["\x79\x5F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8E\xB3"],

        ["\xE7\x8F\x8E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x79\x6D"],
        ["\x79\x6D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8F\x8E"],

        ["\xE7\x8E\xBB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x79\x79"],
        ["\x79\x79",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8E\xBB"],

        ["\xE7\x8F\x80",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x79\x57"],
        ["\x79\x57",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8F\x80"],

        ["\xE7\x8F\xA5",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x79\x59"],
        ["\x79\x59",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8F\xA5"],

        ["\xE7\x8F\xAE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x79\x62"],
        ["\x79\x62",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8F\xAE"],

        ["\xE7\x8F\x9E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x79\x63"],
        ["\x79\x63",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8F\x9E"],

        ["\xE7\x92\xA2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x79\x64"],
        ["\x79\x64",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x92\xA2"],

        ["\xE7\x90\x85",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x79\x65"],
        ["\x79\x65",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x90\x85"],

        ["\xE7\x91\xAF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x79\x66"],
        ["\x79\x66",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x91\xAF"],

        ["\xE7\x90\xA5",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x79\x67"],
        ["\x79\x67",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x90\xA5"],

        ["\xE7\x8F\xB8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x79\x68"],
        ["\x79\x68",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8F\xB8"],

        ["\xE7\x90\xB2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x79\x69"],
        ["\x79\x69",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x90\xB2"],

        ["\xE7\x90\xBA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x79\x70"],
        ["\x79\x70",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x90\xBA"],

        ["\xE7\x91\x95",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x79\x71"],
        ["\x79\x71",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x91\x95"],

        ["\xE7\x90\xBF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x79\x72"],
        ["\x79\x72",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x90\xBF"],

        ["\xE7\x91\x9F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x79\x73"],
        ["\x79\x73",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x91\x9F"],

        ["\xE7\x91\x99",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x79\x74"],
        ["\x79\x74",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x91\x99"],

        ["\xE7\x91\x81",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x79\x75"],
        ["\x79\x75",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x91\x81"],

        ["\xE7\x91\x9C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x79\x76"],
        ["\x79\x76",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x91\x9C"],

        ["\xE7\x91\xA9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x79\x77"],
        ["\x79\x77",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x91\xA9"],

        ["\xE7\x91\xB0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x79\x78"],
        ["\x79\x78",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x91\xB0"],

        ["\xE7\x91\xA3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x79\x80"],
        ["\x79\x80",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x91\xA3"],

        ["\xE7\x91\xAA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x79\x8B"],
        ["\x79\x8B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x91\xAA"],

        ["\xE7\x91\xB6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x95\xCA"],
        ["\x95\xCA",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x91\xB6"],

        ["\xE7\x91\xBE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x79\x9C"],
        ["\x79\x9C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x91\xBE"],

        ["\xE7\x92\x8B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x79\xA0"],
        ["\x79\xA0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x92\x8B"],

        ["\xE7\x92\x9E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x79\xAB"],
        ["\x79\xAB",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x92\x9E"],

        ["\xE7\x92\xA7",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x79\xB0"],
        ["\x79\xB0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x92\xA7"],

        ["\xE7\x93\x8A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x79\xC0"],
        ["\x79\xC0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x93\x8A"],

        ["\xE7\x93\x8F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x79\x6A"],
        ["\x79\x6A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x93\x8F"],

        ["\xE7\x93\x94",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x79\xD0"],
        ["\x79\xD0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x93\x94"],

        ["\xE7\x8F\xB1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x79\xA1"],
        ["\x79\xA1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8F\xB1"],

        ["\xE7\x93\xA0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x57\x4F"],
        ["\x57\x4F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x93\xA0"],

        ["\xE7\x93\xA3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x57\x7F"],
        ["\x57\x7F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x93\xA3"],

        ["\xE7\x93\xA7",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x57\x7B"],
        ["\x57\x7B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x93\xA7"],

        ["\xE7\x93\xA9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x57\xE0"],
        ["\x57\xE0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x93\xA9"],

        ["\xE7\x93\xAE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x57\x6C"],
        ["\x57\x6C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x93\xAE"],

        ["\xE7\x93\xB2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x57\x50"],
        ["\x57\x50",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x93\xB2"],

        ["\xE7\x93\xB0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x57\x7D"],
        ["\x57\x7D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x93\xB0"],

        ["\xE7\x93\xB1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x57\x4D"],
        ["\x57\x4D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x93\xB1"],

        ["\xE7\x93\xB8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x57\x5D"],
        ["\x57\x5D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x93\xB8"],

        ["\xE7\x93\xB7",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x57\x5C"],
        ["\x57\x5C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x93\xB7"],

        ["\xE7\x94\x84",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x57\x4E"],
        ["\x57\x4E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\x84"],

        ["\xE7\x94\x83",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x57\x6B"],
        ["\x57\x6B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\x83"],

        ["\xE7\x94\x85",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x57\x60"],
        ["\x57\x60",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\x85"],

        ["\xE7\x94\x8C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x57\x4B"],
        ["\x57\x4B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\x8C"],

        ["\xE7\x94\x8E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x57\x61"],
        ["\x57\x61",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\x8E"],

        ["\xE7\x94\x8D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x57\xF0"],
        ["\x57\xF0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\x8D"],

        ["\xE7\x94\x95",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x57\xF1"],
        ["\x57\xF1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\x95"],

        ["\xE7\x94\x93",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x57\xF2"],
        ["\x57\xF2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\x93"],

        ["\xE7\x94\x9E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x57\xF3"],
        ["\x57\xF3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\x9E"],

        ["\xE7\x94\xA6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x57\xF4"],
        ["\x57\xF4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\xA6"],

        ["\xE7\x94\xAC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x57\xF5"],
        ["\x57\xF5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\xAC"],

        ["\xE7\x94\xBC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x57\xF6"],
        ["\x57\xF6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\xBC"],

        ["\xE7\x95\x84",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x57\xF7"],
        ["\x57\xF7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\x84"],

        ["\xE7\x95\x8D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x57\xF8"],
        ["\x57\xF8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\x8D"],

        ["\xE7\x95\x8A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x57\xF9"],
        ["\x57\xF9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\x8A"],

        ["\xE7\x95\x89",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x57\x7A"],
        ["\x57\x7A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\x89"],

        ["\xE7\x95\x9B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x57\x5E"],
        ["\x57\x5E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\x9B"],

        ["\xE7\x95\x86",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x57\x4C"],
        ["\x57\x4C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\x86"],

        ["\xE7\x95\x9A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x57\x7E"],
        ["\x57\x7E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\x9A"],

        ["\xE7\x95\xA9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x57\x6E"],
        ["\x57\x6E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\xA9"],

        ["\xE7\x95\xA4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x57\x6F"],
        ["\x57\x6F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\xA4"],

        ["\xE7\x95\xA7",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x57\x7C"],
        ["\x57\x7C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\xA7"],

        ["\xE7\x95\xAB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x57\xC1"],
        ["\x57\xC1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\xAB"],

        ["\xE7\x95\xAD",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x57\xC2"],
        ["\x57\xC2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\xAD"],

        ["\xE7\x95\xB8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x57\xC3"],
        ["\x57\xC3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\xB8"],

        ["\xE7\x95\xB6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x57\xC4"],
        ["\x57\xC4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\xB6"],

        ["\xE7\x96\x86",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x57\xC5"],
        ["\x57\xC5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x96\x86"],

        ["\xE7\x96\x87",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x57\xC6"],
        ["\x57\xC6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x96\x87"],

        ["\xE7\x95\xB4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x57\xC7"],
        ["\x57\xC7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\xB4"],

        ["\xE7\x96\x8A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x57\xC8"],
        ["\x57\xC8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x96\x8A"],

        ["\xE7\x96\x89",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x57\xC9"],
        ["\x57\xC9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x96\x89"],

        ["\xE7\x96\x82",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x57\xD1"],
        ["\x57\xD1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x96\x82"],

        ["\xE7\x96\x94",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x57\xD2"],
        ["\x57\xD2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x96\x94"],

        ["\xE7\x96\x9A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x57\xD3"],
        ["\x57\xD3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x96\x9A"],

        ["\xE7\x96\x9D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x57\xD4"],
        ["\x57\xD4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x96\x9D"],

        ["\xE7\x96\xA5",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x57\xD5"],
        ["\x57\xD5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x96\xA5"],

        ["\xE7\x96\xA3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x57\xD6"],
        ["\x57\xD6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x96\xA3"],

        ["\xE7\x97\x82",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x57\xD7"],
        ["\x57\xD7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\x82"],

        ["\xE7\x96\xB3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x57\xD8"],
        ["\x57\xD8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x96\xB3"],

        ["\xE7\x97\x83",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x57\xD9"],
        ["\x57\xD9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\x83"],

        ["\xE7\x96\xB5",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x57\xE2"],
        ["\x57\xE2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x96\xB5"],

        ["\xE7\x96\xBD",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x57\xE3"],
        ["\x57\xE3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x96\xBD"],

        ["\xE7\x96\xB8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x57\xE4"],
        ["\x57\xE4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x96\xB8"],

        ["\xE7\x96\xBC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x57\xE5"],
        ["\x57\xE5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x96\xBC"],

        ["\xE7\x96\xB1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x57\xE6"],
        ["\x57\xE6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x96\xB1"],

        ["\xE7\x97\x8D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x57\xE7"],
        ["\x57\xE7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\x8D"],

        ["\xE7\x97\x8A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x57\xE8"],
        ["\x57\xE8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\x8A"],

        ["\xE7\x97\x92",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x57\xE9"],
        ["\x57\xE9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\x92"],

        ["\xE7\x97\x99",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x57\x4A"],
        ["\x57\x4A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\x99"],

        ["\xE7\x97\xA3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x57\x5B"],
        ["\x57\x5B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\xA3"],

        ["\xE7\x97\x9E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x57\x5A"],
        ["\x57\x5A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\x9E"],

        ["\xE7\x97\xBE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x57\x5F"],
        ["\x57\x5F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\xBE"],

        ["\xE7\x97\xBF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x57\x6D"],
        ["\x57\x6D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\xBF"],

        ["\xE7\x97\xBC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x57\x79"],
        ["\x57\x79",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\xBC"],

        ["\xE7\x98\x81",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x57\x57"],
        ["\x57\x57",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x98\x81"],

        ["\xE7\x97\xB0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x57\x59"],
        ["\x57\x59",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\xB0"],

        ["\xE7\x97\xBA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x57\x62"],
        ["\x57\x62",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\xBA"],

        ["\xE7\x97\xB2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x57\x63"],
        ["\x57\x63",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\xB2"],

        ["\xE7\x97\xB3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x57\x64"],
        ["\x57\x64",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\xB3"],

        ["\xE7\x98\x8B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x57\x65"],
        ["\x57\x65",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x98\x8B"],

        ["\xE7\x98\x8D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x57\x66"],
        ["\x57\x66",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x98\x8D"],

        ["\xE7\x98\x89",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x57\x67"],
        ["\x57\x67",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x98\x89"],

        ["\xE7\x98\x9F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x57\x68"],
        ["\x57\x68",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x98\x9F"],

        ["\xE7\x98\xA7",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x57\x69"],
        ["\x57\x69",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x98\xA7"],

        ["\xE7\x98\xA0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x57\x70"],
        ["\x57\x70",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x98\xA0"],

        ["\xE7\x98\xA1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x57\x71"],
        ["\x57\x71",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x98\xA1"],

        ["\xE7\x98\xA2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x57\x72"],
        ["\x57\x72",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x98\xA2"],

        ["\xE7\x98\xA4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x57\x73"],
        ["\x57\x73",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x98\xA4"],

        ["\xE7\x98\xB4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x57\x74"],
        ["\x57\x74",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x98\xB4"],

        ["\xE7\x98\xB0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x57\x75"],
        ["\x57\x75",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x98\xB0"],

        ["\xE7\x98\xBB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x57\x76"],
        ["\x57\x76",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x98\xBB"],

        ["\xE7\x99\x87",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x57\x77"],
        ["\x57\x77",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\x87"],

        ["\xE7\x99\x88",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x57\x78"],
        ["\x57\x78",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\x88"],

        ["\xE7\x99\x86",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x57\x80"],
        ["\x57\x80",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\x86"],

        ["\xE7\x99\x9C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x57\x8B"],
        ["\x57\x8B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\x9C"],

        ["\xE7\x99\x98",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x57\x9B"],
        ["\x57\x9B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\x98"],

        ["\xE7\x99\xA1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x57\x9C"],
        ["\x57\x9C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\xA1"],

        ["\xE7\x99\xA2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x57\xA0"],
        ["\x57\xA0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\xA2"],

        ["\xE7\x99\xA8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x57\xAB"],
        ["\x57\xAB",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\xA8"],

        ["\xE7\x99\xA9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x57\xB0"],
        ["\x57\xB0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\xA9"],

        ["\xE7\x99\xAA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x57\xC0"],
        ["\x57\xC0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\xAA"],

        ["\xE7\x99\xA7",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x57\x6A"],
        ["\x57\x6A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\xA7"],

        ["\xE7\x99\xAC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x57\xD0"],
        ["\x57\xD0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\xAC"],

        ["\xE7\x99\xB0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x57\xA1"],
        ["\x57\xA1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\xB0"],

        ["\xE7\x99\xB2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x59\x4F"],
        ["\x59\x4F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\xB2"],

        ["\xE7\x99\xB6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x59\x7F"],
        ["\x59\x7F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\xB6"],

        ["\xE7\x99\xB8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x59\x7B"],
        ["\x59\x7B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\xB8"],

        ["\xE7\x99\xBC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x59\xE0"],
        ["\x59\xE0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\xBC"],

        ["\xE7\x9A\x80",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x59\x6C"],
        ["\x59\x6C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\x80"],

        ["\xE7\x9A\x83",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x59\x50"],
        ["\x59\x50",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\x83"],

        ["\xE7\x9A\x88",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x59\x7D"],
        ["\x59\x7D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\x88"],

        ["\xE7\x9A\x8B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x59\x4D"],
        ["\x59\x4D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\x8B"],

        ["\xE7\x9A\x8E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x59\x5D"],
        ["\x59\x5D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\x8E"],

        ["\xE7\x9A\x96",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x59\x5C"],
        ["\x59\x5C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\x96"],

        ["\xE7\x9A\x93",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x59\x4E"],
        ["\x59\x4E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\x93"],

        ["\xE7\x9A\x99",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x59\x6B"],
        ["\x59\x6B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\x99"],

        ["\xE7\x9A\x9A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x59\x60"],
        ["\x59\x60",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\x9A"],

        ["\xE7\x9A\xB0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x59\x4B"],
        ["\x59\x4B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\xB0"],

        ["\xE7\x9A\xB4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x59\x61"],
        ["\x59\x61",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\xB4"],

        ["\xE7\x9A\xB8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x59\xF0"],
        ["\x59\xF0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\xB8"],

        ["\xE7\x9A\xB9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x59\xF1"],
        ["\x59\xF1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\xB9"],

        ["\xE7\x9A\xBA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x59\xF2"],
        ["\x59\xF2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\xBA"],

        ["\xE7\x9B\x82",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x59\xF3"],
        ["\x59\xF3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\x82"],

        ["\xE7\x9B\x8D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x59\xF4"],
        ["\x59\xF4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\x8D"],

        ["\xE7\x9B\x96",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x59\xF5"],
        ["\x59\xF5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\x96"],

        ["\xE7\x9B\x92",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x59\xF6"],
        ["\x59\xF6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\x92"],

        ["\xE7\x9B\x9E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x59\xF7"],
        ["\x59\xF7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\x9E"],

        ["\xE7\x9B\xA1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x59\xF8"],
        ["\x59\xF8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\xA1"],

        ["\xE7\x9B\xA5",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x59\xF9"],
        ["\x59\xF9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\xA5"],

        ["\xE7\x9B\xA7",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x59\x7A"],
        ["\x59\x7A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\xA7"],

        ["\xE7\x9B\xAA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x59\x5E"],
        ["\x59\x5E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\xAA"],

        ["\xE8\x98\xAF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x59\x4C"],
        ["\x59\x4C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x98\xAF"],

        ["\xE7\x9B\xBB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x59\x7E"],
        ["\x59\x7E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\xBB"],

        ["\xE7\x9C\x88",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x59\x6E"],
        ["\x59\x6E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9C\x88"],

        ["\xE7\x9C\x87",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x59\x6F"],
        ["\x59\x6F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9C\x87"],

        ["\xE7\x9C\x84",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x59\x7C"],
        ["\x59\x7C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9C\x84"],

        ["\xE7\x9C\xA9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x59\xC1"],
        ["\x59\xC1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9C\xA9"],

        ["\xE7\x9C\xA4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x59\xC2"],
        ["\x59\xC2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9C\xA4"],

        ["\xE7\x9C\x9E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x59\xC3"],
        ["\x59\xC3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9C\x9E"],

        ["\xE7\x9C\xA5",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x59\xC4"],
        ["\x59\xC4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9C\xA5"],

        ["\xE7\x9C\xA6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x59\xC5"],
        ["\x59\xC5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9C\xA6"],

        ["\xE7\x9C\x9B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x59\xC6"],
        ["\x59\xC6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9C\x9B"],

        ["\xE7\x9C\xB7",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x59\xC7"],
        ["\x59\xC7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9C\xB7"],

        ["\xE7\x9C\xB8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x59\xC8"],
        ["\x59\xC8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9C\xB8"],

        ["\xE7\x9D\x87",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x59\xC9"],
        ["\x59\xC9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9D\x87"],

        ["\xE7\x9D\x9A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x59\xD1"],
        ["\x59\xD1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9D\x9A"],

        ["\xE7\x9D\xA8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x59\xD2"],
        ["\x59\xD2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9D\xA8"],

        ["\xE7\x9D\xAB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x59\xD3"],
        ["\x59\xD3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9D\xAB"],

        ["\xE7\x9D\x9B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x59\xD4"],
        ["\x59\xD4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9D\x9B"],

        ["\xE7\x9D\xA5",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x59\xD5"],
        ["\x59\xD5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9D\xA5"],

        ["\xE7\x9D\xBF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x59\xD6"],
        ["\x59\xD6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9D\xBF"],

        ["\xE7\x9D\xBE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x59\xD7"],
        ["\x59\xD7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9D\xBE"],

        ["\xE7\x9D\xB9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x59\xD8"],
        ["\x59\xD8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9D\xB9"],

        ["\xE7\x9E\x8E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x59\xD9"],
        ["\x59\xD9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9E\x8E"],

        ["\xE7\x9E\x8B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x59\xE2"],
        ["\x59\xE2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9E\x8B"],

        ["\xE7\x9E\x91",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x59\xE3"],
        ["\x59\xE3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9E\x91"],

        ["\xE7\x9E\xA0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x59\xE4"],
        ["\x59\xE4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9E\xA0"],

        ["\xE7\x9E\x9E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x59\xE5"],
        ["\x59\xE5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9E\x9E"],

        ["\xE7\x9E\xB0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x59\xE6"],
        ["\x59\xE6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9E\xB0"],

        ["\xE7\x9E\xB6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x59\xE7"],
        ["\x59\xE7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9E\xB6"],

        ["\xE7\x9E\xB9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x59\xE8"],
        ["\x59\xE8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9E\xB9"],

        ["\xE7\x9E\xBF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x59\xE9"],
        ["\x59\xE9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9E\xBF"],

        ["\xE7\x9E\xBC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x59\x4A"],
        ["\x59\x4A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9E\xBC"],

        ["\xE7\x9E\xBD",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x59\x5B"],
        ["\x59\x5B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9E\xBD"],

        ["\xE7\x9E\xBB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x59\x5A"],
        ["\x59\x5A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9E\xBB"],

        ["\xE7\x9F\x87",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x59\x5F"],
        ["\x59\x5F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9F\x87"],

        ["\xE7\x9F\x8D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x59\x6D"],
        ["\x59\x6D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9F\x8D"],

        ["\xE7\x9F\x97",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x59\x79"],
        ["\x59\x79",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9F\x97"],

        ["\xE7\x9F\x9A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x59\x57"],
        ["\x59\x57",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9F\x9A"],

        ["\xE7\x9F\x9C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x59\x59"],
        ["\x59\x59",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9F\x9C"],

        ["\xE7\x9F\xA3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x59\x62"],
        ["\x59\x62",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9F\xA3"],

        ["\xE7\x9F\xAE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x59\x63"],
        ["\x59\x63",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9F\xAE"],

        ["\xE7\x9F\xBC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x59\x64"],
        ["\x59\x64",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9F\xBC"],

        ["\xE7\xA0\x8C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x59\x65"],
        ["\x59\x65",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA0\x8C"],

        ["\xE7\xA0\x92",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x59\x66"],
        ["\x59\x66",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA0\x92"],

        ["\xE7\xA4\xA6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF9\x5B"],
        ["\xF9\x5B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA4\xA6"],

        ["\xE7\xA0\xA0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x59\x68"],
        ["\x59\x68",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA0\xA0"],

        ["\xE7\xA4\xAA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC5\xE6"],
        ["\xC5\xE6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA4\xAA"],

        ["\xE7\xA1\x85",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x59\x70"],
        ["\x59\x70",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA1\x85"],

        ["\xE7\xA2\x8E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x59\x71"],
        ["\x59\x71",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA2\x8E"],

        ["\xE7\xA1\xB4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x59\x72"],
        ["\x59\x72",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA1\xB4"],

        ["\xE7\xA2\x86",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x59\x73"],
        ["\x59\x73",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA2\x86"],

        ["\xE7\xA1\xBC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x59\x74"],
        ["\x59\x74",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA1\xBC"],

        ["\xE7\xA2\x9A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x59\x75"],
        ["\x59\x75",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA2\x9A"],

        ["\xE7\xA2\x8C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x59\x76"],
        ["\x59\x76",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA2\x8C"],

        ["\xE7\xA2\xA3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x59\x77"],
        ["\x59\x77",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA2\xA3"],

        ["\xE7\xA2\xB5",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x59\x78"],
        ["\x59\x78",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA2\xB5"],

        ["\xE7\xA2\xAA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x59\x80"],
        ["\x59\x80",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA2\xAA"],

        ["\xE7\xA2\xAF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x59\x8B"],
        ["\x59\x8B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA2\xAF"],

        ["\xE7\xA3\x91",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x59\x9B"],
        ["\x59\x9B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA3\x91"],

        ["\xE7\xA3\x86",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x59\x9C"],
        ["\x59\x9C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA3\x86"],

        ["\xE7\xA3\x8B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x59\xA0"],
        ["\x59\xA0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA3\x8B"],

        ["\xE7\xA3\x94",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x59\xAB"],
        ["\x59\xAB",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA3\x94"],

        ["\xE7\xA2\xBE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x59\xB0"],
        ["\x59\xB0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA2\xBE"],

        ["\xE7\xA2\xBC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x59\xC0"],
        ["\x59\xC0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA2\xBC"],

        ["\xE7\xA3\x85",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x59\x6A"],
        ["\x59\x6A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA3\x85"],

        ["\xE7\xA3\x8A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x59\xD0"],
        ["\x59\xD0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA3\x8A"],

        ["\xE7\xA3\xAC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x59\xA1"],
        ["\x59\xA1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA3\xAC"],

        ["\xE7\xA3\xA7",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x62\x4F"],
        ["\x62\x4F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA3\xA7"],

        ["\xE7\xA3\x9A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x62\x7F"],
        ["\x62\x7F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA3\x9A"],

        ["\xE7\xA3\xBD",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x62\x7B"],
        ["\x62\x7B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA3\xBD"],

        ["\xE7\xA3\xB4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x62\xE0"],
        ["\x62\xE0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA3\xB4"],

        ["\xE7\xA4\x87",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x62\x6C"],
        ["\x62\x6C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA4\x87"],

        ["\xE7\xA4\x92",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x62\x50"],
        ["\x62\x50",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA4\x92"],

        ["\xE7\xA4\x91",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x62\x7D"],
        ["\x62\x7D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA4\x91"],

        ["\xE7\xA4\x99",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x62\x4D"],
        ["\x62\x4D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA4\x99"],

        ["\xE7\xA4\xAC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x62\x5D"],
        ["\x62\x5D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA4\xAC"],

        ["\xE7\xA4\xAB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x62\x5C"],
        ["\x62\x5C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA4\xAB"],

        ["\xE7\xA5\x80",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x62\x4E"],
        ["\x62\x4E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5\x80"],

        ["\xE7\xA5\xA0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x62\x6B"],
        ["\x62\x6B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5\xA0"],

        ["\xE7\xA5\x97",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x62\x60"],
        ["\x62\x60",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5\x97"],

        ["\xE7\xA5\x9F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x62\x4B"],
        ["\x62\x4B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5\x9F"],

        ["\xE7\xA5\x9A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x62\x61"],
        ["\x62\x61",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5\x9A"],

        ["\xE7\xA5\x95",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x62\xF0"],
        ["\x62\xF0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5\x95"],

        ["\xE7\xA5\x93",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x62\xF1"],
        ["\x62\xF1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5\x93"],

        ["\xE7\xA5\xBA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x62\xF2"],
        ["\x62\xF2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5\xBA"],

        ["\xE7\xA5\xBF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x62\xF3"],
        ["\x62\xF3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5\xBF"],

        ["\xE7\xA6\x8A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x62\xF4"],
        ["\x62\xF4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6\x8A"],

        ["\xE7\xA6\x9D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x62\xF5"],
        ["\x62\xF5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6\x9D"],

        ["\xE7\xA6\xA7",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x62\xF6"],
        ["\x62\xF6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6\xA7"],

        ["\xE9\xBD\x8B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x62\xF7"],
        ["\x62\xF7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xBD\x8B"],

        ["\xE7\xA6\xAA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x62\xF8"],
        ["\x62\xF8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6\xAA"],

        ["\xE7\xA6\xAE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x62\xF9"],
        ["\x62\xF9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6\xAE"],

        ["\xE7\xA6\xB3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x62\x7A"],
        ["\x62\x7A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6\xB3"],

        ["\xE7\xA6\xB9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x62\x5E"],
        ["\x62\x5E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6\xB9"],

        ["\xE7\xA6\xBA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x62\x4C"],
        ["\x62\x4C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6\xBA"],

        ["\xE7\xA7\x89",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x62\x7E"],
        ["\x62\x7E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA7\x89"],

        ["\xE7\xA7\x95",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x62\x6E"],
        ["\x62\x6E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA7\x95"],

        ["\xE7\xA7\xA7",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x62\x6F"],
        ["\x62\x6F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA7\xA7"],

        ["\xE7\xA7\xAC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x62\x7C"],
        ["\x62\x7C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA7\xAC"],

        ["\xE7\xA7\xA1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x62\xC1"],
        ["\x62\xC1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA7\xA1"],

        ["\xE7\xA7\xA3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x62\xC2"],
        ["\x62\xC2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA7\xA3"],

        ["\xE7\xA8\x88",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x62\xC3"],
        ["\x62\xC3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8\x88"],

        ["\xE7\xA8\x8D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x62\xC4"],
        ["\x62\xC4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8\x8D"],

        ["\xE7\xA8\x98",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x62\xC5"],
        ["\x62\xC5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8\x98"],

        ["\xE7\xA8\x99",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x62\xC6"],
        ["\x62\xC6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8\x99"],

        ["\xE7\xA8\xA0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x62\xC7"],
        ["\x62\xC7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8\xA0"],

        ["\xE7\xA8\x9F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x62\xC8"],
        ["\x62\xC8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8\x9F"],

        ["\xE7\xA6\x80",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x62\xC9"],
        ["\x62\xC9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6\x80"],

        ["\xE7\xA8\xB1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x62\xD1"],
        ["\x62\xD1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8\xB1"],

        ["\xE7\xA8\xBB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x62\xD2"],
        ["\x62\xD2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8\xBB"],

        ["\xE7\xA8\xBE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x62\xD3"],
        ["\x62\xD3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8\xBE"],

        ["\xE7\xA8\xB7",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x62\xD4"],
        ["\x62\xD4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8\xB7"],

        ["\xE7\xA9\x83",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x62\xD5"],
        ["\x62\xD5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\x83"],

        ["\xE7\xA9\x97",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x62\xD6"],
        ["\x62\xD6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\x97"],

        ["\xE7\xA9\x89",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x62\xD7"],
        ["\x62\xD7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\x89"],

        ["\xE7\xA9\xA1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x62\xD8"],
        ["\x62\xD8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\xA1"],

        ["\xE7\xA9\xA2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x62\xD9"],
        ["\x62\xD9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\xA2"],

        ["\xE7\xA9\xA9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x62\xE2"],
        ["\x62\xE2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\xA9"],

        ["\xE9\xBE\x9D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x62\xE3"],
        ["\x62\xE3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xBE\x9D"],

        ["\xE7\xA9\xB0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x62\xE4"],
        ["\x62\xE4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\xB0"],

        ["\xE7\xA9\xB9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x62\xE5"],
        ["\x62\xE5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\xB9"],

        ["\xE7\xA9\xBD",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x62\xE6"],
        ["\x62\xE6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\xBD"],

        ["\xE7\xAA\x88",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x62\xE7"],
        ["\x62\xE7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAA\x88"],

        ["\xE7\xAA\x97",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x62\xE8"],
        ["\x62\xE8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAA\x97"],

        ["\xE7\xAA\x95",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x62\xE9"],
        ["\x62\xE9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAA\x95"],

        ["\xE7\xAA\x98",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x62\x4A"],
        ["\x62\x4A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAA\x98"],

        ["\xE7\xAA\x96",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x62\x5B"],
        ["\x62\x5B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAA\x96"],

        ["\xE7\xAA\xA9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x62\x5A"],
        ["\x62\x5A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAA\xA9"],

        ["\xE7\xAB\x88",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF3\x9B"],
        ["\xF3\x9B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\x88"],

        ["\xE7\xAA\xB0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x62\x6D"],
        ["\x62\x6D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAA\xB0"],

        ["\xE7\xAA\xB6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x62\x79"],
        ["\x62\x79",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAA\xB6"],

        ["\xE7\xAB\x85",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x62\x57"],
        ["\x62\x57",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\x85"],

        ["\xE7\xAB\x84",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x62\x59"],
        ["\x62\x59",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\x84"],

        ["\xE7\xAA\xBF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x62\x62"],
        ["\x62\x62",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAA\xBF"],

        ["\xE9\x82\x83",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x62\x63"],
        ["\x62\x63",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x82\x83"],

        ["\xE7\xAB\x87",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x62\x64"],
        ["\x62\x64",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\x87"],

        ["\xE7\xAB\x8A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x62\x65"],
        ["\x62\x65",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\x8A"],

        ["\xE7\xAB\x8D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x62\x66"],
        ["\x62\x66",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\x8D"],

        ["\xE7\xAB\x8F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x62\x67"],
        ["\x62\x67",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\x8F"],

        ["\xE7\xAB\x95",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x62\x68"],
        ["\x62\x68",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\x95"],

        ["\xE7\xAB\x93",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x62\x69"],
        ["\x62\x69",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\x93"],

        ["\xE7\xAB\x99",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x62\x70"],
        ["\x62\x70",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\x99"],

        ["\xE7\xAB\x9A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x62\x71"],
        ["\x62\x71",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\x9A"],

        ["\xE7\xAB\x9D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x62\x72"],
        ["\x62\x72",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\x9D"],

        ["\xE7\xAB\xA1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x62\x73"],
        ["\x62\x73",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\xA1"],

        ["\xE7\xAB\xA2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x62\x74"],
        ["\x62\x74",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\xA2"],

        ["\xE7\xAB\xA6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x62\x75"],
        ["\x62\x75",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\xA6"],

        ["\xE7\xAB\xAD",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x62\x76"],
        ["\x62\x76",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\xAD"],

        ["\xE7\xAB\xB0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x62\x77"],
        ["\x62\x77",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\xB0"],

        ["\xE7\xAC\x82",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x62\x78"],
        ["\x62\x78",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC\x82"],

        ["\xE7\xAC\x8F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x62\x80"],
        ["\x62\x80",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC\x8F"],

        ["\xE7\xAC\x8A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x62\x8B"],
        ["\x62\x8B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC\x8A"],

        ["\xE7\xAC\x86",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x62\x9B"],
        ["\x62\x9B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC\x86"],

        ["\xE7\xAC\xB3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x62\x9C"],
        ["\x62\x9C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC\xB3"],

        ["\xE7\xAC\x98",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x62\xA0"],
        ["\x62\xA0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC\x98"],

        ["\xE7\xAC\x99",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x62\xAB"],
        ["\x62\xAB",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC\x99"],

        ["\xE7\xAC\x9E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x62\xB0"],
        ["\x62\xB0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC\x9E"],

        ["\xE7\xAC\xB5",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x62\xC0"],
        ["\x62\xC0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC\xB5"],

        ["\xE7\xAC\xA8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x62\x6A"],
        ["\x62\x6A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC\xA8"],

        ["\xE7\xAC\xB6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x62\xD0"],
        ["\x62\xD0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC\xB6"],

        ["\xE7\xAD\x90",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x62\xA1"],
        ["\x62\xA1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\x90"],

        ["\xE7\xAD\xBA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x63\x4F"],
        ["\x63\x4F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\xBA"],

        ["\xE7\xAC\x84",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x63\x7F"],
        ["\x63\x7F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC\x84"],

        ["\xE7\xAD\x8D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x63\x7B"],
        ["\x63\x7B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\x8D"],

        ["\xE7\xAC\x8B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x63\xE0"],
        ["\x63\xE0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC\x8B"],

        ["\xE7\xAD\x8C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x63\x6C"],
        ["\x63\x6C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\x8C"],

        ["\xE7\xAD\x85",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x63\x50"],
        ["\x63\x50",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\x85"],

        ["\xE7\xAD\xB5",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x63\x7D"],
        ["\x63\x7D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\xB5"],

        ["\xE7\xAD\xA5",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x63\x4D"],
        ["\x63\x4D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\xA5"],

        ["\xE7\xAD\xB4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x63\x5D"],
        ["\x63\x5D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\xB4"],

        ["\xE7\xAD\xA7",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x63\x5C"],
        ["\x63\x5C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\xA7"],

        ["\xE7\xAD\xB0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x63\x4E"],
        ["\x63\x4E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\xB0"],

        ["\xE7\xAD\xB1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x63\x6B"],
        ["\x63\x6B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\xB1"],

        ["\xE7\xAD\xAC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x63\x60"],
        ["\x63\x60",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\xAC"],

        ["\xE7\xAD\xAE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x63\x4B"],
        ["\x63\x4B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\xAE"],

        ["\xE7\xAE\x9D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x63\x61"],
        ["\x63\x61",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAE\x9D"],

        ["\xE7\xAE\x98",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x63\xF0"],
        ["\x63\xF0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAE\x98"],

        ["\xE7\xAE\x9F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x63\xF1"],
        ["\x63\xF1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAE\x9F"],

        ["\xE7\xAE\x8D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x63\xF2"],
        ["\x63\xF2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAE\x8D"],

        ["\xE7\xAE\x9C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x63\xF3"],
        ["\x63\xF3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAE\x9C"],

        ["\xE7\xAE\x9A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x63\xF4"],
        ["\x63\xF4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAE\x9A"],

        ["\xE7\xAE\x8B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x63\xF5"],
        ["\x63\xF5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAE\x8B"],

        ["\xE7\xAE\x92",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x63\xF6"],
        ["\x63\xF6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAE\x92"],

        ["\xE7\xAE\x8F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x63\xF7"],
        ["\x63\xF7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAE\x8F"],

        ["\xE7\xAD\x9D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x63\xF8"],
        ["\x63\xF8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\x9D"],

        ["\xE7\xAE\x99",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x63\xF9"],
        ["\x63\xF9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAE\x99"],

        ["\xE7\xAF\x8B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x63\x7A"],
        ["\x63\x7A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAF\x8B"],

        ["\xE7\xAF\x81",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x63\x5E"],
        ["\x63\x5E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAF\x81"],

        ["\xE7\xAF\x8C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x63\x4C"],
        ["\x63\x4C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAF\x8C"],

        ["\xE7\xAF\x8F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x63\x7E"],
        ["\x63\x7E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAF\x8F"],

        ["\xE7\xAE\xB4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x63\x6E"],
        ["\x63\x6E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAE\xB4"],

        ["\xE7\xAF\x86",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x63\x6F"],
        ["\x63\x6F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAF\x86"],

        ["\xE7\xAF\x9D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x63\x7C"],
        ["\x63\x7C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAF\x9D"],

        ["\xE7\xAF\xA9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x63\xC1"],
        ["\x63\xC1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAF\xA9"],

        ["\xE7\xB0\x91",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x63\xC2"],
        ["\x63\xC2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB0\x91"],

        ["\xE7\xB0\x94",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x63\xC3"],
        ["\x63\xC3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB0\x94"],

        ["\xE7\xAF\xA6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x63\xC4"],
        ["\x63\xC4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAF\xA6"],

        ["\xE7\xAF\xA5",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x63\xC5"],
        ["\x63\xC5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAF\xA5"],

        ["\xE7\xB1\xA0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD6\xF6"],
        ["\xD6\xF6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB1\xA0"],

        ["\xE7\xB0\x80",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x63\xC7"],
        ["\x63\xC7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB0\x80"],

        ["\xE7\xB0\x87",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x63\xC8"],
        ["\x63\xC8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB0\x87"],

        ["\xE7\xB0\x93",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x63\xC9"],
        ["\x63\xC9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB0\x93"],

        ["\xE7\xAF\xB3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x63\xD1"],
        ["\x63\xD1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAF\xB3"],

        ["\xE7\xAF\xB7",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x63\xD2"],
        ["\x63\xD2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAF\xB7"],

        ["\xE7\xB0\x97",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x63\xD3"],
        ["\x63\xD3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB0\x97"],

        ["\xE7\xB0\x8D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x63\xD4"],
        ["\x63\xD4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB0\x8D"],

        ["\xE7\xAF\xB6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x63\xD5"],
        ["\x63\xD5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAF\xB6"],

        ["\xE7\xB0\xA3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x63\xD6"],
        ["\x63\xD6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB0\xA3"],

        ["\xE7\xB0\xA7",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x63\xD7"],
        ["\x63\xD7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB0\xA7"],

        ["\xE7\xB0\xAA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x63\xD8"],
        ["\x63\xD8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB0\xAA"],

        ["\xE7\xB0\x9F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x63\xD9"],
        ["\x63\xD9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB0\x9F"],

        ["\xE7\xB0\xB7",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x63\xE2"],
        ["\x63\xE2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB0\xB7"],

        ["\xE7\xB0\xAB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x63\xE3"],
        ["\x63\xE3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB0\xAB"],

        ["\xE7\xB0\xBD",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x63\xE4"],
        ["\x63\xE4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB0\xBD"],

        ["\xE7\xB1\x8C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x63\xE5"],
        ["\x63\xE5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB1\x8C"],

        ["\xE7\xB1\x83",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x63\xE6"],
        ["\x63\xE6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB1\x83"],

        ["\xE7\xB1\x94",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x63\xE7"],
        ["\x63\xE7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB1\x94"],

        ["\xE7\xB1\x8F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x63\xE8"],
        ["\x63\xE8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB1\x8F"],

        ["\xE7\xB1\x80",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x63\xE9"],
        ["\x63\xE9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB1\x80"],

        ["\xE7\xB1\x90",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x63\x4A"],
        ["\x63\x4A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB1\x90"],

        ["\xE7\xB1\x98",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x63\x5B"],
        ["\x63\x5B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB1\x98"],

        ["\xE7\xB1\x9F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x63\x5A"],
        ["\x63\x5A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB1\x9F"],

        ["\xE7\xB1\xA4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x63\x5F"],
        ["\x63\x5F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB1\xA4"],

        ["\xE7\xB1\x96",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x63\x6D"],
        ["\x63\x6D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB1\x96"],

        ["\xE7\xB1\xA5",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x63\x79"],
        ["\x63\x79",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB1\xA5"],

        ["\xE7\xB1\xAC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x63\x57"],
        ["\x63\x57",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB1\xAC"],

        ["\xE7\xB1\xB5",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x63\x59"],
        ["\x63\x59",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB1\xB5"],

        ["\xE7\xB2\x83",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x63\x62"],
        ["\x63\x62",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\x83"],

        ["\xE7\xB2\x90",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x63\x63"],
        ["\x63\x63",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\x90"],

        ["\xE7\xB2\xA4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x63\x64"],
        ["\x63\x64",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\xA4"],

        ["\xE7\xB2\xAD",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x63\x65"],
        ["\x63\x65",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\xAD"],

        ["\xE7\xB2\xA2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x63\x66"],
        ["\x63\x66",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\xA2"],

        ["\xE7\xB2\xAB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x63\x67"],
        ["\x63\x67",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\xAB"],

        ["\xE7\xB2\xA1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x63\x68"],
        ["\x63\x68",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\xA1"],

        ["\xE7\xB2\xA8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x63\x69"],
        ["\x63\x69",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\xA8"],

        ["\xE7\xB2\xB3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x63\x70"],
        ["\x63\x70",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\xB3"],

        ["\xE7\xB2\xB2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x63\x71"],
        ["\x63\x71",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\xB2"],

        ["\xE7\xB2\xB1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x63\x72"],
        ["\x63\x72",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\xB1"],

        ["\xE7\xB2\xAE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x63\x73"],
        ["\x63\x73",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\xAE"],

        ["\xE7\xB2\xB9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x63\x74"],
        ["\x63\x74",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\xB9"],

        ["\xE7\xB2\xBD",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x63\x75"],
        ["\x63\x75",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\xBD"],

        ["\xE7\xB3\x80",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x63\x76"],
        ["\x63\x76",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3\x80"],

        ["\xE7\xB3\x85",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x63\x77"],
        ["\x63\x77",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3\x85"],

        ["\xE7\xB3\x82",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x63\x78"],
        ["\x63\x78",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3\x82"],

        ["\xE7\xB3\x98",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x63\x80"],
        ["\x63\x80",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3\x98"],

        ["\xE7\xB3\x92",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x63\x8B"],
        ["\x63\x8B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3\x92"],

        ["\xE7\xB3\x9C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x63\x9B"],
        ["\x63\x9B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3\x9C"],

        ["\xE7\xB3\xA2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x63\x9C"],
        ["\x63\x9C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3\xA2"],

        ["\xE9\xAC\xBB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x63\xA0"],
        ["\x63\xA0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xAC\xBB"],

        ["\xE7\xB3\xAF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x63\xAB"],
        ["\x63\xAB",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3\xAF"],

        ["\xE7\xB3\xB2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x63\xB0"],
        ["\x63\xB0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3\xB2"],

        ["\xE7\xB3\xB4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x63\xC0"],
        ["\x63\xC0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3\xB4"],

        ["\xE7\xB3\xB6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x63\x6A"],
        ["\x63\x6A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3\xB6"],

        ["\xE7\xB3\xBA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x63\xD0"],
        ["\x63\xD0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3\xBA"],

        ["\xE7\xB4\x86",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x63\xA1"],
        ["\x63\xA1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\x86"],

        ["\xE7\xB4\x82",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x64\x4F"],
        ["\x64\x4F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\x82"],

        ["\xE7\xB4\x9C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x64\x7F"],
        ["\x64\x7F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\x9C"],

        ["\xE7\xB4\x95",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x64\x7B"],
        ["\x64\x7B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\x95"],

        ["\xE7\xB4\x8A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x64\xE0"],
        ["\x64\xE0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\x8A"],

        ["\xE7\xB5\x85",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x64\x6C"],
        ["\x64\x6C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\x85"],

        ["\xE7\xB5\x8B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x64\x50"],
        ["\x64\x50",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\x8B"],

        ["\xE7\xB4\xAE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x64\x7D"],
        ["\x64\x7D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\xAE"],

        ["\xE7\xB4\xB2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x64\x4D"],
        ["\x64\x4D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\xB2"],

        ["\xE7\xB4\xBF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x64\x5D"],
        ["\x64\x5D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\xBF"],

        ["\xE7\xB4\xB5",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x64\x5C"],
        ["\x64\x5C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\xB5"],

        ["\xE7\xB5\x86",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x64\x4E"],
        ["\x64\x4E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\x86"],

        ["\xE7\xB5\xB3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x64\x6B"],
        ["\x64\x6B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\xB3"],

        ["\xE7\xB5\x96",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x64\x60"],
        ["\x64\x60",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\x96"],

        ["\xE7\xB5\x8E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x64\x4B"],
        ["\x64\x4B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\x8E"],

        ["\xE7\xB5\xB2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x64\x61"],
        ["\x64\x61",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\xB2"],

        ["\xE7\xB5\xA8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x64\xF0"],
        ["\x64\xF0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\xA8"],

        ["\xE7\xB5\xAE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x64\xF1"],
        ["\x64\xF1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\xAE"],

        ["\xE7\xB5\x8F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x64\xF2"],
        ["\x64\xF2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\x8F"],

        ["\xE7\xB5\xA3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x64\xF3"],
        ["\x64\xF3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\xA3"],

        ["\xE7\xB6\x93",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x64\xF4"],
        ["\x64\xF4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\x93"],

        ["\xE7\xB6\x89",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x64\xF5"],
        ["\x64\xF5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\x89"],

        ["\xE7\xB5\x9B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x64\xF6"],
        ["\x64\xF6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\x9B"],

        ["\xE7\xB6\x8F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x64\xF7"],
        ["\x64\xF7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\x8F"],

        ["\xE7\xB5\xBD",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x64\xF8"],
        ["\x64\xF8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\xBD"],

        ["\xE7\xB6\x9B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x64\xF9"],
        ["\x64\xF9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\x9B"],

        ["\xE7\xB6\xBA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x64\x7A"],
        ["\x64\x7A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\xBA"],

        ["\xE7\xB6\xAE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x64\x5E"],
        ["\x64\x5E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\xAE"],

        ["\xE7\xB6\xA3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x64\x4C"],
        ["\x64\x4C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\xA3"],

        ["\xE7\xB6\xB5",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x64\x7E"],
        ["\x64\x7E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\xB5"],

        ["\xE7\xB7\x87",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x64\x6E"],
        ["\x64\x6E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7\x87"],

        ["\xE7\xB6\xBD",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x64\x6F"],
        ["\x64\x6F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\xBD"],

        ["\xE7\xB6\xAB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x64\x7C"],
        ["\x64\x7C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\xAB"],

        ["\xE7\xB8\xBD",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x64\xC1"],
        ["\x64\xC1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\xBD"],

        ["\xE7\xB6\xA2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x64\xC2"],
        ["\x64\xC2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\xA2"],

        ["\xE7\xB6\xAF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x64\xC3"],
        ["\x64\xC3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\xAF"],

        ["\xE7\xB7\x9C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x64\xC4"],
        ["\x64\xC4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7\x9C"],

        ["\xE7\xB6\xB8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x64\xC5"],
        ["\x64\xC5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\xB8"],

        ["\xE7\xB6\x9F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x64\xC6"],
        ["\x64\xC6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\x9F"],

        ["\xE7\xB6\xB0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x64\xC7"],
        ["\x64\xC7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\xB0"],

        ["\xE7\xB7\x98",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x64\xC8"],
        ["\x64\xC8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7\x98"],

        ["\xE7\xB7\x9D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x64\xC9"],
        ["\x64\xC9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7\x9D"],

        ["\xE7\xB7\xA4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x64\xD1"],
        ["\x64\xD1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7\xA4"],

        ["\xE7\xB7\x9E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x64\xD2"],
        ["\x64\xD2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7\x9E"],

        ["\xE7\xB7\xBB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x64\xD3"],
        ["\x64\xD3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7\xBB"],

        ["\xE7\xB7\xB2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x64\xD4"],
        ["\x64\xD4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7\xB2"],

        ["\xE7\xB7\xA1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x64\xD5"],
        ["\x64\xD5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7\xA1"],

        ["\xE7\xB8\x85",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x64\xD6"],
        ["\x64\xD6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\x85"],

        ["\xE7\xB8\x8A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x64\xD7"],
        ["\x64\xD7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\x8A"],

        ["\xE7\xB8\xA3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x64\xD8"],
        ["\x64\xD8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\xA3"],

        ["\xE7\xB8\xA1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x64\xD9"],
        ["\x64\xD9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\xA1"],

        ["\xE7\xB8\x92",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x64\xE2"],
        ["\x64\xE2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\x92"],

        ["\xE7\xB8\xB1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x64\xE3"],
        ["\x64\xE3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\xB1"],

        ["\xE7\xB8\x9F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x64\xE4"],
        ["\x64\xE4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\x9F"],

        ["\xE7\xB8\x89",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x64\xE5"],
        ["\x64\xE5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\x89"],

        ["\xE7\xB8\x8B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x64\xE6"],
        ["\x64\xE6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\x8B"],

        ["\xE7\xB8\xA2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x64\xE7"],
        ["\x64\xE7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\xA2"],

        ["\xE7\xB9\x86",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x64\xE8"],
        ["\x64\xE8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\x86"],

        ["\xE7\xB9\xA6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x64\xE9"],
        ["\x64\xE9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\xA6"],

        ["\xE7\xB8\xBB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x64\x4A"],
        ["\x64\x4A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\xBB"],

        ["\xE7\xB8\xB5",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x64\x5B"],
        ["\x64\x5B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\xB5"],

        ["\xE7\xB8\xB9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x64\x5A"],
        ["\x64\x5A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\xB9"],

        ["\xE7\xB9\x83",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x64\x5F"],
        ["\x64\x5F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\x83"],

        ["\xE7\xB8\xB7",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x64\x6D"],
        ["\x64\x6D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\xB7"],

        ["\xE7\xB8\xB2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x64\x79"],
        ["\x64\x79",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\xB2"],

        ["\xE7\xB8\xBA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x64\x57"],
        ["\x64\x57",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\xBA"],

        ["\xE7\xB9\xA7",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x64\x59"],
        ["\x64\x59",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\xA7"],

        ["\xE7\xB9\x9D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x64\x62"],
        ["\x64\x62",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\x9D"],

        ["\xE7\xB9\x96",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x64\x63"],
        ["\x64\x63",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\x96"],

        ["\xE7\xB9\x9E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x64\x64"],
        ["\x64\x64",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\x9E"],

        ["\xE7\xB9\x99",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x64\x65"],
        ["\x64\x65",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\x99"],

        ["\xE7\xB9\x9A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x64\x66"],
        ["\x64\x66",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\x9A"],

        ["\xE7\xB9\xB9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x64\x67"],
        ["\x64\x67",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\xB9"],

        ["\xE7\xB9\xAA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x64\x68"],
        ["\x64\x68",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\xAA"],

        ["\xE7\xB9\xA9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x64\x69"],
        ["\x64\x69",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\xA9"],

        ["\xE7\xB9\xBC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x64\x70"],
        ["\x64\x70",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\xBC"],

        ["\xE7\xB9\xBB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x64\x71"],
        ["\x64\x71",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\xBB"],

        ["\xE7\xBA\x83",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x64\x72"],
        ["\x64\x72",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBA\x83"],

        ["\xE7\xB7\x95",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x64\x73"],
        ["\x64\x73",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7\x95"],

        ["\xE7\xB9\xBD",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x64\x74"],
        ["\x64\x74",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\xBD"],

        ["\xE8\xBE\xAE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x64\x75"],
        ["\x64\x75",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBE\xAE"],

        ["\xE7\xB9\xBF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x64\x76"],
        ["\x64\x76",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\xBF"],

        ["\xE7\xBA\x88",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x64\x77"],
        ["\x64\x77",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBA\x88"],

        ["\xE7\xBA\x89",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x64\x78"],
        ["\x64\x78",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBA\x89"],

        ["\xE7\xBA\x8C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x64\x80"],
        ["\x64\x80",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBA\x8C"],

        ["\xE7\xBA\x92",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x64\x8B"],
        ["\x64\x8B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBA\x92"],

        ["\xE7\xBA\x90",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x64\x9B"],
        ["\x64\x9B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBA\x90"],

        ["\xE7\xBA\x93",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x64\x9C"],
        ["\x64\x9C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBA\x93"],

        ["\xE7\xBA\x94",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x64\xA0"],
        ["\x64\xA0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBA\x94"],

        ["\xE7\xBA\x96",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x64\xAB"],
        ["\x64\xAB",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBA\x96"],

        ["\xE7\xBA\x8E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x64\xB0"],
        ["\x64\xB0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBA\x8E"],

        ["\xE7\xBA\x9B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x64\xC0"],
        ["\x64\xC0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBA\x9B"],

        ["\xE7\xBA\x9C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x64\x6A"],
        ["\x64\x6A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBA\x9C"],

        ["\xE7\xBC\xB8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x64\xD0"],
        ["\x64\xD0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBC\xB8"],

        ["\xE7\xBC\xBA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x64\xA1"],
        ["\x64\xA1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBC\xBA"],

        ["\xE7\xBD\x85",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x65\x4F"],
        ["\x65\x4F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\x85"],

        ["\xE7\xBD\x8C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x65\x7F"],
        ["\x65\x7F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\x8C"],

        ["\xE7\xBD\x8D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x65\x7B"],
        ["\x65\x7B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\x8D"],

        ["\xE7\xBD\x8E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x65\xE0"],
        ["\x65\xE0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\x8E"],

        ["\xE7\xBD\x90",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x65\x6C"],
        ["\x65\x6C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\x90"],

        ["\xE7\xBD\x91",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x65\x50"],
        ["\x65\x50",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\x91"],

        ["\xE7\xBD\x95",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x65\x7D"],
        ["\x65\x7D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\x95"],

        ["\xE7\xBD\x94",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x65\x4D"],
        ["\x65\x4D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\x94"],

        ["\xE7\xBD\x98",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x65\x5D"],
        ["\x65\x5D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\x98"],

        ["\xE7\xBD\x9F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x65\x5C"],
        ["\x65\x5C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\x9F"],

        ["\xE7\xBD\xA0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x65\x4E"],
        ["\x65\x4E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\xA0"],

        ["\xE7\xBD\xA8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x65\x6B"],
        ["\x65\x6B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\xA8"],

        ["\xE7\xBD\xA9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x65\x60"],
        ["\x65\x60",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\xA9"],

        ["\xE7\xBD\xA7",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x65\x4B"],
        ["\x65\x4B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\xA7"],

        ["\xE7\xBD\xB8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x65\x61"],
        ["\x65\x61",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\xB8"],

        ["\xE7\xBE\x82",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x65\xF0"],
        ["\x65\xF0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\x82"],

        ["\xE7\xBE\x86",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x65\xF1"],
        ["\x65\xF1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\x86"],

        ["\xE7\xBE\x83",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x65\xF2"],
        ["\x65\xF2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\x83"],

        ["\xE7\xBE\x88",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x65\xF3"],
        ["\x65\xF3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\x88"],

        ["\xE7\xBE\x87",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x65\xF4"],
        ["\x65\xF4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\x87"],

        ["\xE7\xBE\x8C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x65\xF5"],
        ["\x65\xF5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\x8C"],

        ["\xE7\xBE\x94",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x65\xF6"],
        ["\x65\xF6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\x94"],

        ["\xE7\xBE\x9E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x65\xF7"],
        ["\x65\xF7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\x9E"],

        ["\xE7\xBE\x9D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x65\xF8"],
        ["\x65\xF8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\x9D"],

        ["\xE7\xBE\x9A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x65\xF9"],
        ["\x65\xF9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\x9A"],

        ["\xE7\xBE\xA3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x65\x7A"],
        ["\x65\x7A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\xA3"],

        ["\xE7\xBE\xAF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x65\x5E"],
        ["\x65\x5E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\xAF"],

        ["\xE7\xBE\xB2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x65\x4C"],
        ["\x65\x4C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\xB2"],

        ["\xE7\xBE\xB9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x65\x7E"],
        ["\x65\x7E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\xB9"],

        ["\xE7\xBE\xAE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x65\x6E"],
        ["\x65\x6E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\xAE"],

        ["\xE7\xBE\xB6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x65\x6F"],
        ["\x65\x6F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\xB6"],

        ["\xE7\xBE\xB8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x65\x7C"],
        ["\x65\x7C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\xB8"],

        ["\xE8\xAD\xB1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x65\xC1"],
        ["\x65\xC1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD\xB1"],

        ["\xE7\xBF\x85",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x65\xC2"],
        ["\x65\xC2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBF\x85"],

        ["\xE7\xBF\x86",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x65\xC3"],
        ["\x65\xC3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBF\x86"],

        ["\xE7\xBF\x8A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x65\xC4"],
        ["\x65\xC4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBF\x8A"],

        ["\xE7\xBF\x95",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x65\xC5"],
        ["\x65\xC5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBF\x95"],

        ["\xE7\xBF\x94",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x65\xC6"],
        ["\x65\xC6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBF\x94"],

        ["\xE7\xBF\xA1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x65\xC7"],
        ["\x65\xC7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBF\xA1"],

        ["\xE7\xBF\xA6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x65\xC8"],
        ["\x65\xC8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBF\xA6"],

        ["\xE7\xBF\xA9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x65\xC9"],
        ["\x65\xC9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBF\xA9"],

        ["\xE7\xBF\xB3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x65\xD1"],
        ["\x65\xD1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBF\xB3"],

        ["\xE7\xBF\xB9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x65\xD2"],
        ["\x65\xD2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBF\xB9"],

        ["\xE9\xA3\x9C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x65\xD3"],
        ["\x65\xD3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA3\x9C"],

        ["\xE8\x80\x86",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x65\xD4"],
        ["\x65\xD4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\x86"],

        ["\xE8\x80\x84",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x65\xD5"],
        ["\x65\xD5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\x84"],

        ["\xE8\x80\x8B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x65\xD6"],
        ["\x65\xD6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\x8B"],

        ["\xE8\x80\x92",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x65\xD7"],
        ["\x65\xD7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\x92"],

        ["\xE8\x80\x98",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x65\xD8"],
        ["\x65\xD8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\x98"],

        ["\xE8\x80\x99",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x65\xD9"],
        ["\x65\xD9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\x99"],

        ["\xE8\x80\x9C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x65\xE2"],
        ["\x65\xE2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\x9C"],

        ["\xE8\x80\xA1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x65\xE3"],
        ["\x65\xE3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\xA1"],

        ["\xE8\x80\xA8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x65\xE4"],
        ["\x65\xE4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\xA8"],

        ["\xE8\x80\xBF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x65\xE5"],
        ["\x65\xE5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\xBF"],

        ["\xE8\x80\xBB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x65\xE6"],
        ["\x65\xE6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\xBB"],

        ["\xE8\x81\x8A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x65\xE7"],
        ["\x65\xE7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x81\x8A"],

        ["\xE8\x81\x86",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x65\xE8"],
        ["\x65\xE8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x81\x86"],

        ["\xE8\x81\x92",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x65\xE9"],
        ["\x65\xE9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x81\x92"],

        ["\xE8\x81\x98",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x65\x4A"],
        ["\x65\x4A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x81\x98"],

        ["\xE8\x81\x9A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x65\x5B"],
        ["\x65\x5B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x81\x9A"],

        ["\xE8\x81\x9F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x65\x5A"],
        ["\x65\x5A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x81\x9F"],

        ["\xE8\x81\xA2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x65\x5F"],
        ["\x65\x5F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x81\xA2"],

        ["\xE8\x81\xA8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x65\x6D"],
        ["\x65\x6D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x81\xA8"],

        ["\xE8\x81\xB3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x65\x79"],
        ["\x65\x79",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x81\xB3"],

        ["\xE8\x81\xB2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x65\x57"],
        ["\x65\x57",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x81\xB2"],

        ["\xE8\x81\xB0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x65\x59"],
        ["\x65\x59",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x81\xB0"],

        ["\xE8\x81\xB6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x65\x62"],
        ["\x65\x62",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x81\xB6"],

        ["\xE8\x81\xB9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x65\x63"],
        ["\x65\x63",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x81\xB9"],

        ["\xE8\x81\xBD",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x65\x64"],
        ["\x65\x64",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x81\xBD"],

        ["\xE8\x81\xBF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x65\x65"],
        ["\x65\x65",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x81\xBF"],

        ["\xE8\x82\x84",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x65\x66"],
        ["\x65\x66",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x82\x84"],

        ["\xE8\x82\x86",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x65\x67"],
        ["\x65\x67",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x82\x86"],

        ["\xE8\x82\x85",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x65\x68"],
        ["\x65\x68",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x82\x85"],

        ["\xE8\x82\x9B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x65\x69"],
        ["\x65\x69",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x82\x9B"],

        ["\xE8\x82\x93",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x65\x70"],
        ["\x65\x70",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x82\x93"],

        ["\xE8\x82\x9A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x65\x71"],
        ["\x65\x71",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x82\x9A"],

        ["\xE8\x82\xAD",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x65\x72"],
        ["\x65\x72",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x82\xAD"],

        ["\xE5\x86\x90",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x65\x73"],
        ["\x65\x73",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\x90"],

        ["\xE8\x82\xAC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x65\x74"],
        ["\x65\x74",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x82\xAC"],

        ["\xE8\x83\x9B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x65\x75"],
        ["\x65\x75",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x83\x9B"],

        ["\xE8\x83\xA5",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x65\x76"],
        ["\x65\x76",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x83\xA5"],

        ["\xE8\x83\x99",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x65\x77"],
        ["\x65\x77",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x83\x99"],

        ["\xE8\x83\x9D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x65\x78"],
        ["\x65\x78",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x83\x9D"],

        ["\xE8\x83\x84",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x65\x80"],
        ["\x65\x80",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x83\x84"],

        ["\xE8\x83\x9A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x65\x8B"],
        ["\x65\x8B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x83\x9A"],

        ["\xE8\x83\x96",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x65\x9B"],
        ["\x65\x9B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x83\x96"],

        ["\xE8\x84\x89",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x65\x9C"],
        ["\x65\x9C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x84\x89"],

        ["\xE8\x83\xAF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x65\xA0"],
        ["\x65\xA0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x83\xAF"],

        ["\xE8\x83\xB1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x65\xAB"],
        ["\x65\xAB",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x83\xB1"],

        ["\xE8\x84\x9B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x65\xB0"],
        ["\x65\xB0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x84\x9B"],

        ["\xE8\x84\xA9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x65\xC0"],
        ["\x65\xC0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x84\xA9"],

        ["\xE8\x84\xA3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x65\x6A"],
        ["\x65\x6A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x84\xA3"],

        ["\xE8\x84\xAF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x65\xD0"],
        ["\x65\xD0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x84\xAF"],

        ["\xE8\x85\x8B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x65\xA1"],
        ["\x65\xA1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x85\x8B"],

        ["\xE9\x9A\x8B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x66\x4F"],
        ["\x66\x4F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\x8B"],

        ["\xE8\x85\x86",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x66\x7F"],
        ["\x66\x7F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x85\x86"],

        ["\xE8\x84\xBE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x66\x7B"],
        ["\x66\x7B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x84\xBE"],

        ["\xE8\x85\x93",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x66\xE0"],
        ["\x66\xE0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x85\x93"],

        ["\xE8\x85\x91",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x66\x6C"],
        ["\x66\x6C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x85\x91"],

        ["\xE8\x83\xBC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x66\x50"],
        ["\x66\x50",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x83\xBC"],

        ["\xE8\x85\xB1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x66\x7D"],
        ["\x66\x7D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x85\xB1"],

        ["\xE8\x85\xAE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x66\x4D"],
        ["\x66\x4D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x85\xAE"],

        ["\xE8\x85\xA5",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x66\x5D"],
        ["\x66\x5D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x85\xA5"],

        ["\xE8\x85\xA6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x66\x5C"],
        ["\x66\x5C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x85\xA6"],

        ["\xE8\x85\xB4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x66\x4E"],
        ["\x66\x4E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x85\xB4"],

        ["\xE8\x86\x83",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x66\x6B"],
        ["\x66\x6B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x86\x83"],

        ["\xE8\x86\x88",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x66\x60"],
        ["\x66\x60",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x86\x88"],

        ["\xE8\x86\x8A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x66\x4B"],
        ["\x66\x4B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x86\x8A"],

        ["\xE8\x86\x80",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x66\x61"],
        ["\x66\x61",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x86\x80"],

        ["\xE8\x86\x82",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x66\xF0"],
        ["\x66\xF0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x86\x82"],

        ["\xE8\x86\xA0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x66\xF1"],
        ["\x66\xF1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x86\xA0"],

        ["\xE8\x86\x95",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x66\xF2"],
        ["\x66\xF2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x86\x95"],

        ["\xE8\x86\xA4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x66\xF3"],
        ["\x66\xF3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x86\xA4"],

        ["\xE8\x86\xA3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x66\xF4"],
        ["\x66\xF4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x86\xA3"],

        ["\xE8\x85\x9F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x66\xF5"],
        ["\x66\xF5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x85\x9F"],

        ["\xE8\x86\x93",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x66\xF6"],
        ["\x66\xF6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x86\x93"],

        ["\xE8\x86\xA9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x66\xF7"],
        ["\x66\xF7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x86\xA9"],

        ["\xE8\x86\xB0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x66\xF8"],
        ["\x66\xF8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x86\xB0"],

        ["\xE8\x86\xB5",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x66\xF9"],
        ["\x66\xF9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x86\xB5"],

        ["\xE8\x86\xBE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x66\x7A"],
        ["\x66\x7A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x86\xBE"],

        ["\xE8\x86\xB8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x66\x5E"],
        ["\x66\x5E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x86\xB8"],

        ["\xE8\x86\xBD",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x66\x4C"],
        ["\x66\x4C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x86\xBD"],

        ["\xE8\x87\x80",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x66\x7E"],
        ["\x66\x7E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\x80"],

        ["\xE8\x87\x82",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x66\x6E"],
        ["\x66\x6E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\x82"],

        ["\xE8\x86\xBA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x66\x6F"],
        ["\x66\x6F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x86\xBA"],

        ["\xE8\x87\x89",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x66\x7C"],
        ["\x66\x7C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\x89"],

        ["\xE8\x87\x8D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x66\xC1"],
        ["\x66\xC1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\x8D"],

        ["\xE8\x87\x91",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x66\xC2"],
        ["\x66\xC2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\x91"],

        ["\xE8\x87\x99",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x66\xC3"],
        ["\x66\xC3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\x99"],

        ["\xE8\x87\x98",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x66\xC4"],
        ["\x66\xC4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\x98"],

        ["\xE8\x87\x88",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x66\xC5"],
        ["\x66\xC5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\x88"],

        ["\xE8\x87\x9A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x66\xC6"],
        ["\x66\xC6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\x9A"],

        ["\xE8\x87\x9F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x66\xC7"],
        ["\x66\xC7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\x9F"],

        ["\xE8\x87\xA0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x66\xC8"],
        ["\x66\xC8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\xA0"],

        ["\xE8\x87\xA7",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x66\xC9"],
        ["\x66\xC9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\xA7"],

        ["\xE8\x87\xBA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x66\xD1"],
        ["\x66\xD1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\xBA"],

        ["\xE8\x87\xBB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x66\xD2"],
        ["\x66\xD2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\xBB"],

        ["\xE8\x87\xBE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x66\xD3"],
        ["\x66\xD3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\xBE"],

        ["\xE8\x88\x81",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x66\xD4"],
        ["\x66\xD4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\x81"],

        ["\xE8\x88\x82",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x66\xD5"],
        ["\x66\xD5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\x82"],

        ["\xE8\x88\x85",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x66\xD6"],
        ["\x66\xD6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\x85"],

        ["\xE8\x88\x87",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x66\xD7"],
        ["\x66\xD7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\x87"],

        ["\xE8\x88\x8A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x66\xD8"],
        ["\x66\xD8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\x8A"],

        ["\xE8\x88\x8D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x66\xD9"],
        ["\x66\xD9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\x8D"],

        ["\xE8\x88\x90",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x66\xE2"],
        ["\x66\xE2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\x90"],

        ["\xE8\x88\x96",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x66\xE3"],
        ["\x66\xE3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\x96"],

        ["\xE8\x88\xA9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x66\xE4"],
        ["\x66\xE4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\xA9"],

        ["\xE8\x88\xAB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x66\xE5"],
        ["\x66\xE5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\xAB"],

        ["\xE8\x88\xB8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x66\xE6"],
        ["\x66\xE6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\xB8"],

        ["\xE8\x88\xB3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x66\xE7"],
        ["\x66\xE7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\xB3"],

        ["\xE8\x89\x80",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x66\xE8"],
        ["\x66\xE8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x89\x80"],

        ["\xE8\x89\x99",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x66\xE9"],
        ["\x66\xE9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x89\x99"],

        ["\xE8\x89\x98",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x66\x4A"],
        ["\x66\x4A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x89\x98"],

        ["\xE8\x89\x9D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x66\x5B"],
        ["\x66\x5B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x89\x9D"],

        ["\xE8\x89\x9A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x66\x5A"],
        ["\x66\x5A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x89\x9A"],

        ["\xE8\x89\x9F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x66\x5F"],
        ["\x66\x5F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x89\x9F"],

        ["\xE8\x89\xA4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x66\x6D"],
        ["\x66\x6D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x89\xA4"],

        ["\xE8\x89\xA2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x66\x79"],
        ["\x66\x79",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x89\xA2"],

        ["\xE8\x89\xA8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x66\x57"],
        ["\x66\x57",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x89\xA8"],

        ["\xE8\x89\xAA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x66\x59"],
        ["\x66\x59",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x89\xAA"],

        ["\xE8\x89\xAB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x66\x62"],
        ["\x66\x62",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x89\xAB"],

        ["\xE8\x88\xAE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x66\x63"],
        ["\x66\x63",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\xAE"],

        ["\xE8\x89\xB1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x66\x64"],
        ["\x66\x64",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x89\xB1"],

        ["\xE8\x89\xB7",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x66\x65"],
        ["\x66\x65",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x89\xB7"],

        ["\xE8\x89\xB8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x66\x66"],
        ["\x66\x66",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x89\xB8"],

        ["\xE8\x89\xBE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x66\x67"],
        ["\x66\x67",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x89\xBE"],

        ["\xE8\x8A\x8D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x66\x68"],
        ["\x66\x68",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8A\x8D"],

        ["\xE8\x8A\x92",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x66\x69"],
        ["\x66\x69",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8A\x92"],

        ["\xE8\x8A\xAB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x66\x70"],
        ["\x66\x70",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8A\xAB"],

        ["\xE8\x8A\x9F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x66\x71"],
        ["\x66\x71",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8A\x9F"],

        ["\xE8\x8A\xBB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x66\x72"],
        ["\x66\x72",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8A\xBB"],

        ["\xE8\x8A\xAC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x66\x73"],
        ["\x66\x73",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8A\xAC"],

        ["\xE8\x8B\xA1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x66\x74"],
        ["\x66\x74",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8B\xA1"],

        ["\xE8\x8B\xA3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x66\x75"],
        ["\x66\x75",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8B\xA3"],

        ["\xE8\x8B\x9F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x66\x76"],
        ["\x66\x76",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8B\x9F"],

        ["\xE8\x8B\x92",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x66\x77"],
        ["\x66\x77",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8B\x92"],

        ["\xE8\x8B\xB4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x66\x78"],
        ["\x66\x78",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8B\xB4"],

        ["\xE8\x8B\xB3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x66\x80"],
        ["\x66\x80",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8B\xB3"],

        ["\xE8\x8B\xBA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x66\x8B"],
        ["\x66\x8B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8B\xBA"],

        ["\xE8\x8E\x93",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x66\x9B"],
        ["\x66\x9B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8E\x93"],

        ["\xE8\x8C\x83",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x66\x9C"],
        ["\x66\x9C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C\x83"],

        ["\xE8\x8B\xBB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x66\xA0"],
        ["\x66\xA0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8B\xBB"],

        ["\xE8\x8B\xB9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x66\xAB"],
        ["\x66\xAB",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8B\xB9"],

        ["\xE8\x8B\x9E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x66\xB0"],
        ["\x66\xB0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8B\x9E"],

        ["\xE8\x8C\x86",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x66\xC0"],
        ["\x66\xC0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C\x86"],

        ["\xE8\x8B\x9C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x66\x6A"],
        ["\x66\x6A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8B\x9C"],

        ["\xE8\x8C\x89",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x66\xD0"],
        ["\x66\xD0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C\x89"],

        ["\xE8\x8B\x99",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x66\xA1"],
        ["\x66\xA1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8B\x99"],

        ["\xE8\x8C\xB5",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x67\x4F"],
        ["\x67\x4F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C\xB5"],

        ["\xE8\x8C\xB4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x67\x7F"],
        ["\x67\x7F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C\xB4"],

        ["\xE8\x8C\x96",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x67\x7B"],
        ["\x67\x7B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C\x96"],

        ["\xE8\x8C\xB2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x67\xE0"],
        ["\x67\xE0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C\xB2"],

        ["\xE8\x8C\xB1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x67\x6C"],
        ["\x67\x6C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C\xB1"],

        ["\xE8\x8D\x80",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x67\x50"],
        ["\x67\x50",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8D\x80"],

        ["\xE8\x8C\xB9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x67\x7D"],
        ["\x67\x7D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C\xB9"],

        ["\xE8\x8D\x90",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x67\x4D"],
        ["\x67\x4D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8D\x90"],

        ["\xE8\x8D\x85",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x67\x5D"],
        ["\x67\x5D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8D\x85"],

        ["\xE8\x8C\xAF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x67\x5C"],
        ["\x67\x5C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C\xAF"],

        ["\xE8\x8C\xAB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x67\x4E"],
        ["\x67\x4E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C\xAB"],

        ["\xE8\x8C\x97",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x67\x6B"],
        ["\x67\x6B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C\x97"],

        ["\xE8\x8C\x98",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x67\x60"],
        ["\x67\x60",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C\x98"],

        ["\xE8\x8E\x85",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x67\x4B"],
        ["\x67\x4B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8E\x85"],

        ["\xE8\x8E\x9A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x67\x61"],
        ["\x67\x61",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8E\x9A"],

        ["\xE8\x8E\xAA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x67\xF0"],
        ["\x67\xF0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8E\xAA"],

        ["\xE8\x8E\x9F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x67\xF1"],
        ["\x67\xF1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8E\x9F"],

        ["\xE8\x8E\xA2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x67\xF2"],
        ["\x67\xF2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8E\xA2"],

        ["\xE8\x8E\x96",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x67\xF3"],
        ["\x67\xF3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8E\x96"],

        ["\xE8\x8C\xA3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x67\xF4"],
        ["\x67\xF4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C\xA3"],

        ["\xE8\x8E\x8E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x67\xF5"],
        ["\x67\xF5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8E\x8E"],

        ["\xE8\x8E\x87",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x67\xF6"],
        ["\x67\xF6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8E\x87"],

        ["\xE8\x8E\x8A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x67\xF7"],
        ["\x67\xF7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8E\x8A"],

        ["\xE8\x8D\xBC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x67\xF8"],
        ["\x67\xF8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8D\xBC"],

        ["\xE8\x8E\xB5",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x67\xF9"],
        ["\x67\xF9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8E\xB5"],

        ["\xE8\x8D\xB3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x67\x7A"],
        ["\x67\x7A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8D\xB3"],

        ["\xE8\x8D\xB5",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x67\x5E"],
        ["\x67\x5E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8D\xB5"],

        ["\xE8\x8E\xA0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x67\x4C"],
        ["\x67\x4C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8E\xA0"],

        ["\xE8\x8E\x89",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x67\x7E"],
        ["\x67\x7E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8E\x89"],

        ["\xE8\x8E\xA8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x67\x6E"],
        ["\x67\x6E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8E\xA8"],

        ["\xE8\x8F\xB4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x67\x6F"],
        ["\x67\x6F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F\xB4"],

        ["\xE8\x90\x93",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x67\x7C"],
        ["\x67\x7C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x90\x93"],

        ["\xE8\x8F\xAB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x67\xC1"],
        ["\x67\xC1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F\xAB"],

        ["\xE8\x8F\x8E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x67\xC2"],
        ["\x67\xC2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F\x8E"],

        ["\xE8\x8F\xBD",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x67\xC3"],
        ["\x67\xC3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F\xBD"],

        ["\xE8\x90\x83",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x67\xC4"],
        ["\x67\xC4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x90\x83"],

        ["\xE8\x8F\x98",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x67\xC5"],
        ["\x67\xC5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F\x98"],

        ["\xE8\x90\x8B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x67\xC6"],
        ["\x67\xC6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x90\x8B"],

        ["\xE8\x8F\x81",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x67\xC7"],
        ["\x67\xC7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F\x81"],

        ["\xE8\x8F\xB7",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x67\xC8"],
        ["\x67\xC8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F\xB7"],

        ["\xE8\x90\x87",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x67\xC9"],
        ["\x67\xC9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x90\x87"],

        ["\xE8\x8F\xA0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x67\xD1"],
        ["\x67\xD1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F\xA0"],

        ["\xE8\x8F\xB2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x67\xD2"],
        ["\x67\xD2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F\xB2"],

        ["\xE8\x90\x8D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x67\xD3"],
        ["\x67\xD3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x90\x8D"],

        ["\xE8\x90\xA2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x67\xD4"],
        ["\x67\xD4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x90\xA2"],

        ["\xE8\x90\xA0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x67\xD5"],
        ["\x67\xD5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x90\xA0"],

        ["\xE8\x8E\xBD",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x67\xD6"],
        ["\x67\xD6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8E\xBD"],

        ["\xE8\x90\xB8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x67\xD7"],
        ["\x67\xD7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x90\xB8"],

        ["\xE8\x94\x86",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x67\xD8"],
        ["\x67\xD8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x94\x86"],

        ["\xE8\x8F\xBB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x67\xD9"],
        ["\x67\xD9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F\xBB"],

        ["\xE8\x91\xAD",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x67\xE2"],
        ["\x67\xE2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x91\xAD"],

        ["\xE8\x90\xAA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x67\xE3"],
        ["\x67\xE3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x90\xAA"],

        ["\xE8\x90\xBC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x67\xE4"],
        ["\x67\xE4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x90\xBC"],

        ["\xE8\x95\x9A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x67\xE5"],
        ["\x67\xE5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x95\x9A"],

        ["\xE8\x92\x84",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x67\xE6"],
        ["\x67\xE6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x92\x84"],

        ["\xE8\x91\xB7",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x67\xE7"],
        ["\x67\xE7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x91\xB7"],

        ["\xE8\x91\xAB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x67\xE8"],
        ["\x67\xE8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x91\xAB"],

        ["\xE8\x92\xAD",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x67\xE9"],
        ["\x67\xE9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x92\xAD"],

        ["\xE8\x91\xAE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x67\x4A"],
        ["\x67\x4A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x91\xAE"],

        ["\xE8\x92\x82",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x67\x5B"],
        ["\x67\x5B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x92\x82"],

        ["\xE8\x91\xA9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x67\x5A"],
        ["\x67\x5A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x91\xA9"],

        ["\xE8\x91\x86",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x67\x5F"],
        ["\x67\x5F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x91\x86"],

        ["\xE8\x90\xAC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x67\x6D"],
        ["\x67\x6D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x90\xAC"],

        ["\xE8\x91\xAF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x67\x79"],
        ["\x67\x79",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x91\xAF"],

        ["\xE8\x91\xB9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x67\x57"],
        ["\x67\x57",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x91\xB9"],

        ["\xE8\x90\xB5",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x67\x59"],
        ["\x67\x59",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x90\xB5"],

        ["\xE8\x93\x8A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x67\x62"],
        ["\x67\x62",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x93\x8A"],

        ["\xE8\x91\xA2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x67\x63"],
        ["\x67\x63",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x91\xA2"],

        ["\xE8\x92\xB9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x67\x64"],
        ["\x67\x64",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x92\xB9"],

        ["\xE8\x92\xBF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x67\x65"],
        ["\x67\x65",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x92\xBF"],

        ["\xE8\x92\x9F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x67\x66"],
        ["\x67\x66",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x92\x9F"],

        ["\xE8\x93\x99",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x67\x67"],
        ["\x67\x67",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x93\x99"],

        ["\xE8\x93\x8D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x67\x68"],
        ["\x67\x68",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x93\x8D"],

        ["\xE8\x92\xBB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x67\x69"],
        ["\x67\x69",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x92\xBB"],

        ["\xE8\x93\x9A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x67\x70"],
        ["\x67\x70",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x93\x9A"],

        ["\xE8\x93\x90",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x67\x71"],
        ["\x67\x71",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x93\x90"],

        ["\xE8\x93\x81",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x67\x72"],
        ["\x67\x72",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x93\x81"],

        ["\xE8\x93\x86",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x67\x73"],
        ["\x67\x73",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x93\x86"],

        ["\xE8\x93\x96",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x67\x74"],
        ["\x67\x74",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x93\x96"],

        ["\xE8\x92\xA1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x67\x75"],
        ["\x67\x75",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x92\xA1"],

        ["\xE8\x94\xA1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x67\x76"],
        ["\x67\x76",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x94\xA1"],

        ["\xE8\x93\xBF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x67\x77"],
        ["\x67\x77",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x93\xBF"],

        ["\xE8\x93\xB4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x67\x78"],
        ["\x67\x78",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x93\xB4"],

        ["\xE8\x94\x97",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x67\x80"],
        ["\x67\x80",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x94\x97"],

        ["\xE8\x94\x98",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x67\x8B"],
        ["\x67\x8B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x94\x98"],

        ["\xE8\x94\xAC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x67\x9B"],
        ["\x67\x9B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x94\xAC"],

        ["\xE8\x94\x9F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x67\x9C"],
        ["\x67\x9C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x94\x9F"],

        ["\xE8\x94\x95",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x67\xA0"],
        ["\x67\xA0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x94\x95"],

        ["\xE8\x94\x94",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x67\xAB"],
        ["\x67\xAB",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x94\x94"],

        ["\xE8\x93\xBC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x67\xB0"],
        ["\x67\xB0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x93\xBC"],

        ["\xE8\x95\x80",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x67\xC0"],
        ["\x67\xC0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x95\x80"],

        ["\xE8\x95\xA3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x67\x6A"],
        ["\x67\x6A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x95\xA3"],

        ["\xE8\x95\x98",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x67\xD0"],
        ["\x67\xD0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x95\x98"],

        ["\xE8\x95\x88",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x67\xA1"],
        ["\x67\xA1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x95\x88"],

        ["\xE8\x95\x81",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x68\x4F"],
        ["\x68\x4F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x95\x81"],

        ["\xE8\x98\x82",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x4C\xC9"],
        ["\x4C\xC9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x98\x82"],

        ["\xE8\x95\x8B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x68\x7B"],
        ["\x68\x7B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x95\x8B"],

        ["\xE8\x95\x95",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x68\xE0"],
        ["\x68\xE0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x95\x95"],

        ["\xE8\x96\x80",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x68\x6C"],
        ["\x68\x6C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\x80"],

        ["\xE8\x96\xA4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x68\x50"],
        ["\x68\x50",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\xA4"],

        ["\xE8\x96\x88",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x68\x7D"],
        ["\x68\x7D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\x88"],

        ["\xE8\x96\x91",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x68\x4D"],
        ["\x68\x4D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\x91"],

        ["\xE8\x96\x8A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x68\x5D"],
        ["\x68\x5D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\x8A"],

        ["\xE8\x96\xA8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x68\x5C"],
        ["\x68\x5C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\xA8"],

        ["\xE8\x95\xAD",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x68\x4E"],
        ["\x68\x4E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x95\xAD"],

        ["\xE8\x96\x94",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x68\x6B"],
        ["\x68\x6B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\x94"],

        ["\xE8\x96\x9B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x68\x60"],
        ["\x68\x60",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\x9B"],

        ["\xE8\x97\xAA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xD3\xAB"],
        ["\xD3\xAB",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x97\xAA"],

        ["\xE8\x96\x87",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x68\x61"],
        ["\x68\x61",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\x87"],

        ["\xE8\x96\x9C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x68\xF0"],
        ["\x68\xF0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\x9C"],

        ["\xE8\x95\xB7",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x68\xF1"],
        ["\x68\xF1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x95\xB7"],

        ["\xE8\x95\xBE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x68\xF2"],
        ["\x68\xF2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x95\xBE"],

        ["\xE8\x96\x90",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x68\xF3"],
        ["\x68\xF3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\x90"],

        ["\xE8\x97\x89",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x68\xF4"],
        ["\x68\xF4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x97\x89"],

        ["\xE8\x96\xBA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x68\xF5"],
        ["\x68\xF5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\xBA"],

        ["\xE8\x97\x8F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x68\xF6"],
        ["\x68\xF6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x97\x8F"],

        ["\xE8\x96\xB9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x68\xF7"],
        ["\x68\xF7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\xB9"],

        ["\xE8\x97\x90",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x68\xF8"],
        ["\x68\xF8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x97\x90"],

        ["\xE8\x97\x95",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x68\xF9"],
        ["\x68\xF9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x97\x95"],

        ["\xE8\x97\x9D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x68\x7A"],
        ["\x68\x7A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x97\x9D"],

        ["\xE8\x97\xA5",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x68\x5E"],
        ["\x68\x5E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x97\xA5"],

        ["\xE8\x97\x9C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x68\x4C"],
        ["\x68\x4C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x97\x9C"],

        ["\xE8\x97\xB9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x68\x7E"],
        ["\x68\x7E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x97\xB9"],

        ["\xE8\x98\x8A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x68\x6E"],
        ["\x68\x6E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x98\x8A"],

        ["\xE8\x98\x93",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x68\x6F"],
        ["\x68\x6F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x98\x93"],

        ["\xE8\x98\x8B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x68\x7C"],
        ["\x68\x7C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x98\x8B"],

        ["\xE8\x97\xBE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x68\xC1"],
        ["\x68\xC1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x97\xBE"],

        ["\xE8\x97\xBA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x68\xC2"],
        ["\x68\xC2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x97\xBA"],

        ["\xE8\x98\x86",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x68\xC3"],
        ["\x68\xC3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x98\x86"],

        ["\xE8\x98\xA2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x68\xC4"],
        ["\x68\xC4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x98\xA2"],

        ["\xE8\x98\x9A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x68\xC5"],
        ["\x68\xC5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x98\x9A"],

        ["\xE8\x98\xB0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x68\xC6"],
        ["\x68\xC6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x98\xB0"],

        ["\xE8\x98\xBF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x68\xC7"],
        ["\x68\xC7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x98\xBF"],

        ["\xE8\x99\x8D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x68\xC8"],
        ["\x68\xC8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x99\x8D"],

        ["\xE4\xB9\x95",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x68\xC9"],
        ["\x68\xC9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xB9\x95"],

        ["\xE8\x99\x94",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x68\xD1"],
        ["\x68\xD1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x99\x94"],

        ["\xE8\x99\x9F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x68\xD2"],
        ["\x68\xD2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x99\x9F"],

        ["\xE8\x99\xA7",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x68\xD3"],
        ["\x68\xD3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x99\xA7"],

        ["\xE8\x99\xB1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x68\xD4"],
        ["\x68\xD4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x99\xB1"],

        ["\xE8\x9A\x93",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x68\xD5"],
        ["\x68\xD5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9A\x93"],

        ["\xE8\x9A\xA3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x68\xD6"],
        ["\x68\xD6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9A\xA3"],

        ["\xE8\x9A\xA9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x68\xD7"],
        ["\x68\xD7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9A\xA9"],

        ["\xE8\x9A\xAA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x68\xD8"],
        ["\x68\xD8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9A\xAA"],

        ["\xE8\x9A\x8B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x68\xD9"],
        ["\x68\xD9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9A\x8B"],

        ["\xE8\x9A\x8C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x68\xE2"],
        ["\x68\xE2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9A\x8C"],

        ["\xE8\x9A\xB6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x68\xE3"],
        ["\x68\xE3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9A\xB6"],

        ["\xE8\x9A\xAF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x68\xE4"],
        ["\x68\xE4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9A\xAF"],

        ["\xE8\x9B\x84",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x68\xE5"],
        ["\x68\xE5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9B\x84"],

        ["\xE8\x9B\x86",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x68\xE6"],
        ["\x68\xE6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9B\x86"],

        ["\xE8\x9A\xB0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x68\xE7"],
        ["\x68\xE7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9A\xB0"],

        ["\xE8\x9B\x89",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x68\xE8"],
        ["\x68\xE8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9B\x89"],

        ["\xE8\xA0\xA3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF3\xC2"],
        ["\xF3\xC2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA0\xA3"],

        ["\xE8\x9A\xAB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x68\x4A"],
        ["\x68\x4A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9A\xAB"],

        ["\xE8\x9B\x94",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x68\x5B"],
        ["\x68\x5B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9B\x94"],

        ["\xE8\x9B\x9E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x68\x5A"],
        ["\x68\x5A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9B\x9E"],

        ["\xE8\x9B\xA9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x68\x5F"],
        ["\x68\x5F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9B\xA9"],

        ["\xE8\x9B\xAC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x68\x6D"],
        ["\x68\x6D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9B\xAC"],

        ["\xE8\x9B\x9F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x68\x79"],
        ["\x68\x79",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9B\x9F"],

        ["\xE8\x9B\x9B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x68\x57"],
        ["\x68\x57",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9B\x9B"],

        ["\xE8\x9B\xAF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x68\x59"],
        ["\x68\x59",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9B\xAF"],

        ["\xE8\x9C\x92",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x68\x62"],
        ["\x68\x62",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9C\x92"],

        ["\xE8\x9C\x86",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x68\x63"],
        ["\x68\x63",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9C\x86"],

        ["\xE8\x9C\x88",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x68\x64"],
        ["\x68\x64",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9C\x88"],

        ["\xE8\x9C\x80",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x68\x65"],
        ["\x68\x65",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9C\x80"],

        ["\xE8\x9C\x83",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x68\x66"],
        ["\x68\x66",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9C\x83"],

        ["\xE8\x9B\xBB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x68\x67"],
        ["\x68\x67",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9B\xBB"],

        ["\xE8\x9C\x91",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x68\x68"],
        ["\x68\x68",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9C\x91"],

        ["\xE8\x9C\x89",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x68\x69"],
        ["\x68\x69",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9C\x89"],

        ["\xE8\x9C\x8D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x68\x70"],
        ["\x68\x70",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9C\x8D"],

        ["\xE8\x9B\xB9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x68\x71"],
        ["\x68\x71",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9B\xB9"],

        ["\xE8\x9C\x8A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x68\x72"],
        ["\x68\x72",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9C\x8A"],

        ["\xE8\x9C\xB4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x68\x73"],
        ["\x68\x73",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9C\xB4"],

        ["\xE8\x9C\xBF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x68\x74"],
        ["\x68\x74",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9C\xBF"],

        ["\xE8\x9C\xB7",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x68\x75"],
        ["\x68\x75",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9C\xB7"],

        ["\xE8\x9C\xBB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x68\x76"],
        ["\x68\x76",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9C\xBB"],

        ["\xE8\x9C\xA5",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x68\x77"],
        ["\x68\x77",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9C\xA5"],

        ["\xE8\x9C\xA9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x68\x78"],
        ["\x68\x78",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9C\xA9"],

        ["\xE8\x9C\x9A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x68\x80"],
        ["\x68\x80",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9C\x9A"],

        ["\xE8\x9D\xA0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x68\x8B"],
        ["\x68\x8B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9D\xA0"],

        ["\xE8\x9D\x9F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x68\x9B"],
        ["\x68\x9B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9D\x9F"],

        ["\xE8\x9D\xB8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x68\x9C"],
        ["\x68\x9C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9D\xB8"],

        ["\xE8\x9D\x8C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x68\xA0"],
        ["\x68\xA0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9D\x8C"],

        ["\xE8\x9D\x8E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x68\xAB"],
        ["\x68\xAB",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9D\x8E"],

        ["\xE8\x9D\xB4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x68\xB0"],
        ["\x68\xB0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9D\xB4"],

        ["\xE8\x9D\x97",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x68\xC0"],
        ["\x68\xC0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9D\x97"],

        ["\xE8\x9D\xA8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x68\x6A"],
        ["\x68\x6A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9D\xA8"],

        ["\xE8\x9D\xAE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x68\xD0"],
        ["\x68\xD0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9D\xAE"],

        ["\xE8\x9D\x99",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x68\xA1"],
        ["\x68\xA1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9D\x99"],

        ["\xE8\x9D\x93",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x69\x4F"],
        ["\x69\x4F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9D\x93"],

        ["\xE8\x9D\xA3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x69\x7F"],
        ["\x69\x7F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9D\xA3"],

        ["\xE8\x9D\xAA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x69\x7B"],
        ["\x69\x7B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9D\xAA"],

        ["\xE8\xA0\x85",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC7\x67"],
        ["\xC7\x67",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA0\x85"],

        ["\xE8\x9E\xA2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x69\x6C"],
        ["\x69\x6C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9E\xA2"],

        ["\xE8\x9E\x9F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x69\x50"],
        ["\x69\x50",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9E\x9F"],

        ["\xE8\x9E\x82",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x69\x7D"],
        ["\x69\x7D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9E\x82"],

        ["\xE8\x9E\xAF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x69\x4D"],
        ["\x69\x4D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9E\xAF"],

        ["\xE8\x9F\x8B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x69\x5D"],
        ["\x69\x5D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9F\x8B"],

        ["\xE8\x9E\xBD",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x69\x5C"],
        ["\x69\x5C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9E\xBD"],

        ["\xE8\x9F\x80",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x69\x4E"],
        ["\x69\x4E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9F\x80"],

        ["\xE8\x9F\x90",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x69\x6B"],
        ["\x69\x6B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9F\x90"],

        ["\xE9\x9B\x96",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x69\x60"],
        ["\x69\x60",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\x96"],

        ["\xE8\x9E\xAB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x69\x4B"],
        ["\x69\x4B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9E\xAB"],

        ["\xE8\x9F\x84",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x69\x61"],
        ["\x69\x61",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9F\x84"],

        ["\xE8\x9E\xB3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x69\xF0"],
        ["\x69\xF0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9E\xB3"],

        ["\xE8\x9F\x87",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x69\xF1"],
        ["\x69\xF1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9F\x87"],

        ["\xE8\x9F\x86",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x69\xF2"],
        ["\x69\xF2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9F\x86"],

        ["\xE8\x9E\xBB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x69\xF3"],
        ["\x69\xF3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9E\xBB"],

        ["\xE8\x9F\xAF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x69\xF4"],
        ["\x69\xF4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9F\xAF"],

        ["\xE8\x9F\xB2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x69\xF5"],
        ["\x69\xF5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9F\xB2"],

        ["\xE8\x9F\xA0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x69\xF6"],
        ["\x69\xF6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9F\xA0"],

        ["\xE8\xA0\x8F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x69\xF7"],
        ["\x69\xF7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA0\x8F"],

        ["\xE8\xA0\x8D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x69\xF8"],
        ["\x69\xF8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA0\x8D"],

        ["\xE8\x9F\xBE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x69\xF9"],
        ["\x69\xF9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9F\xBE"],

        ["\xE8\x9F\xB6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x69\x7A"],
        ["\x69\x7A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9F\xB6"],

        ["\xE8\x9F\xB7",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x69\x5E"],
        ["\x69\x5E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9F\xB7"],

        ["\xE8\xA0\x8E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x69\x4C"],
        ["\x69\x4C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA0\x8E"],

        ["\xE8\x9F\x92",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x69\x7E"],
        ["\x69\x7E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9F\x92"],

        ["\xE8\xA0\x91",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x69\x6E"],
        ["\x69\x6E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA0\x91"],

        ["\xE8\xA0\x96",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x69\x6F"],
        ["\x69\x6F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA0\x96"],

        ["\xE8\xA0\x95",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x69\x7C"],
        ["\x69\x7C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA0\x95"],

        ["\xE8\xA0\xA2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x69\xC1"],
        ["\x69\xC1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA0\xA2"],

        ["\xE8\xA0\xA1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x69\xC2"],
        ["\x69\xC2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA0\xA1"],

        ["\xE8\xA0\xB1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x69\xC3"],
        ["\x69\xC3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA0\xB1"],

        ["\xE8\xA0\xB6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x69\xC4"],
        ["\x69\xC4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA0\xB6"],

        ["\xE8\xA0\xB9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x69\xC5"],
        ["\x69\xC5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA0\xB9"],

        ["\xE8\xA0\xA7",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x69\xC6"],
        ["\x69\xC6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA0\xA7"],

        ["\xE8\xA0\xBB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x69\xC7"],
        ["\x69\xC7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA0\xBB"],

        ["\xE8\xA1\x84",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x69\xC8"],
        ["\x69\xC8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\x84"],

        ["\xE8\xA1\x82",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x69\xC9"],
        ["\x69\xC9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\x82"],

        ["\xE8\xA1\x92",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x69\xD1"],
        ["\x69\xD1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\x92"],

        ["\xE8\xA1\x99",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x69\xD2"],
        ["\x69\xD2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\x99"],

        ["\xE8\xA1\x9E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x69\xD3"],
        ["\x69\xD3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\x9E"],

        ["\xE8\xA1\xA2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x69\xD4"],
        ["\x69\xD4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\xA2"],

        ["\xE8\xA1\xAB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x69\xD5"],
        ["\x69\xD5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\xAB"],

        ["\xE8\xA2\x81",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x69\xD6"],
        ["\x69\xD6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA2\x81"],

        ["\xE8\xA1\xBE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x69\xD7"],
        ["\x69\xD7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\xBE"],

        ["\xE8\xA2\x9E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x69\xD8"],
        ["\x69\xD8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA2\x9E"],

        ["\xE8\xA1\xB5",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x69\xD9"],
        ["\x69\xD9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\xB5"],

        ["\xE8\xA1\xBD",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x69\xE2"],
        ["\x69\xE2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\xBD"],

        ["\xE8\xA2\xB5",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x69\xE3"],
        ["\x69\xE3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA2\xB5"],

        ["\xE8\xA1\xB2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x69\xE4"],
        ["\x69\xE4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\xB2"],

        ["\xE8\xA2\x82",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x69\xE5"],
        ["\x69\xE5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA2\x82"],

        ["\xE8\xA2\x97",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x69\xE6"],
        ["\x69\xE6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA2\x97"],

        ["\xE8\xA2\x92",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x69\xE7"],
        ["\x69\xE7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA2\x92"],

        ["\xE8\xA2\xAE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x69\xE8"],
        ["\x69\xE8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA2\xAE"],

        ["\xE8\xA2\x99",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x69\xE9"],
        ["\x69\xE9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA2\x99"],

        ["\xE8\xA2\xA2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x69\x4A"],
        ["\x69\x4A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA2\xA2"],

        ["\xE8\xA2\x8D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x69\x5B"],
        ["\x69\x5B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA2\x8D"],

        ["\xE8\xA2\xA4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x69\x5A"],
        ["\x69\x5A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA2\xA4"],

        ["\xE8\xA2\xB0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x69\x5F"],
        ["\x69\x5F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA2\xB0"],

        ["\xE8\xA2\xBF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x69\x6D"],
        ["\x69\x6D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA2\xBF"],

        ["\xE8\xA2\xB1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x69\x79"],
        ["\x69\x79",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA2\xB1"],

        ["\xE8\xA3\x83",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x69\x57"],
        ["\x69\x57",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\x83"],

        ["\xE8\xA3\x84",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x69\x59"],
        ["\x69\x59",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\x84"],

        ["\xE8\xA3\x94",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x69\x62"],
        ["\x69\x62",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\x94"],

        ["\xE8\xA3\x98",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x69\x63"],
        ["\x69\x63",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\x98"],

        ["\xE8\xA3\x99",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x69\x64"],
        ["\x69\x64",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\x99"],

        ["\xE8\xA3\x9D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x69\x65"],
        ["\x69\x65",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\x9D"],

        ["\xE8\xA3\xB9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x69\x66"],
        ["\x69\x66",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\xB9"],

        ["\xE8\xA4\x82",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x69\x67"],
        ["\x69\x67",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA4\x82"],

        ["\xE8\xA3\xBC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x69\x68"],
        ["\x69\x68",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\xBC"],

        ["\xE8\xA3\xB4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x69\x69"],
        ["\x69\x69",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\xB4"],

        ["\xE8\xA3\xA8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x69\x70"],
        ["\x69\x70",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\xA8"],

        ["\xE8\xA3\xB2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x69\x71"],
        ["\x69\x71",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\xB2"],

        ["\xE8\xA4\x84",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x69\x72"],
        ["\x69\x72",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA4\x84"],

        ["\xE8\xA4\x8C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x69\x73"],
        ["\x69\x73",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA4\x8C"],

        ["\xE8\xA4\x8A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x69\x74"],
        ["\x69\x74",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA4\x8A"],

        ["\xE8\xA4\x93",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x69\x75"],
        ["\x69\x75",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA4\x93"],

        ["\xE8\xA5\x83",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x69\x76"],
        ["\x69\x76",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA5\x83"],

        ["\xE8\xA4\x9E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x69\x77"],
        ["\x69\x77",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA4\x9E"],

        ["\xE8\xA4\xA5",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x69\x78"],
        ["\x69\x78",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA4\xA5"],

        ["\xE8\xA4\xAA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x69\x80"],
        ["\x69\x80",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA4\xAA"],

        ["\xE8\xA4\xAB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x69\x8B"],
        ["\x69\x8B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA4\xAB"],

        ["\xE8\xA5\x81",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x69\x9B"],
        ["\x69\x9B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA5\x81"],

        ["\xE8\xA5\x84",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x69\x9C"],
        ["\x69\x9C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA5\x84"],

        ["\xE8\xA4\xBB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x69\xA0"],
        ["\x69\xA0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA4\xBB"],

        ["\xE8\xA4\xB6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x69\xAB"],
        ["\x69\xAB",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA4\xB6"],

        ["\xE8\xA4\xB8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x69\xB0"],
        ["\x69\xB0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA4\xB8"],

        ["\xE8\xA5\x8C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x69\xC0"],
        ["\x69\xC0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA5\x8C"],

        ["\xE8\xA4\x9D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x69\x6A"],
        ["\x69\x6A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA4\x9D"],

        ["\xE8\xA5\xA0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x69\xD0"],
        ["\x69\xD0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA5\xA0"],

        ["\xE8\xA5\x9E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x69\xA1"],
        ["\x69\xA1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA5\x9E"],

        ["\xE8\xA5\xA6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x70\x4F"],
        ["\x70\x4F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA5\xA6"],

        ["\xE8\xA5\xA4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x70\x7F"],
        ["\x70\x7F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA5\xA4"],

        ["\xE8\xA5\xAD",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x70\x7B"],
        ["\x70\x7B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA5\xAD"],

        ["\xE8\xA5\xAA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x70\xE0"],
        ["\x70\xE0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA5\xAA"],

        ["\xE8\xA5\xAF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x70\x6C"],
        ["\x70\x6C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA5\xAF"],

        ["\xE8\xA5\xB4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x70\x50"],
        ["\x70\x50",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA5\xB4"],

        ["\xE8\xA5\xB7",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x70\x7D"],
        ["\x70\x7D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA5\xB7"],

        ["\xE8\xA5\xBE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x70\x4D"],
        ["\x70\x4D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA5\xBE"],

        ["\xE8\xA6\x83",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x70\x5D"],
        ["\x70\x5D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\x83"],

        ["\xE8\xA6\x88",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x70\x5C"],
        ["\x70\x5C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\x88"],

        ["\xE8\xA6\x8A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x70\x4E"],
        ["\x70\x4E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\x8A"],

        ["\xE8\xA6\x93",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x70\x6B"],
        ["\x70\x6B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\x93"],

        ["\xE8\xA6\x98",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x70\x60"],
        ["\x70\x60",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\x98"],

        ["\xE8\xA6\xA1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x70\x4B"],
        ["\x70\x4B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\xA1"],

        ["\xE8\xA6\xA9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x70\x61"],
        ["\x70\x61",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\xA9"],

        ["\xE8\xA6\xA6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x70\xF0"],
        ["\x70\xF0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\xA6"],

        ["\xE8\xA6\xAC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x70\xF1"],
        ["\x70\xF1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\xAC"],

        ["\xE8\xA6\xAF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x70\xF2"],
        ["\x70\xF2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\xAF"],

        ["\xE8\xA6\xB2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x70\xF3"],
        ["\x70\xF3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\xB2"],

        ["\xE8\xA6\xBA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x70\xF4"],
        ["\x70\xF4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\xBA"],

        ["\xE8\xA6\xBD",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x70\xF5"],
        ["\x70\xF5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\xBD"],

        ["\xE8\xA6\xBF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x70\xF6"],
        ["\x70\xF6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\xBF"],

        ["\xE8\xA7\x80",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x70\xF7"],
        ["\x70\xF7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA7\x80"],

        ["\xE8\xA7\x9A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x70\xF8"],
        ["\x70\xF8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA7\x9A"],

        ["\xE8\xA7\x9C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x70\xF9"],
        ["\x70\xF9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA7\x9C"],

        ["\xE8\xA7\x9D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x70\x7A"],
        ["\x70\x7A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA7\x9D"],

        ["\xE8\xA7\xA7",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x70\x5E"],
        ["\x70\x5E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA7\xA7"],

        ["\xE8\xA7\xB4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x70\x4C"],
        ["\x70\x4C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA7\xB4"],

        ["\xE8\xA7\xB8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x70\x7E"],
        ["\x70\x7E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA7\xB8"],

        ["\xE8\xA8\x83",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x70\x6E"],
        ["\x70\x6E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\x83"],

        ["\xE8\xA8\x96",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x70\x6F"],
        ["\x70\x6F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\x96"],

        ["\xE8\xA8\x90",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x70\x7C"],
        ["\x70\x7C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\x90"],

        ["\xE8\xA8\x8C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x70\xC1"],
        ["\x70\xC1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\x8C"],

        ["\xE8\xA8\x9B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x70\xC2"],
        ["\x70\xC2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\x9B"],

        ["\xE8\xA8\x9D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x70\xC3"],
        ["\x70\xC3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\x9D"],

        ["\xE8\xA8\xA5",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x70\xC4"],
        ["\x70\xC4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\xA5"],

        ["\xE8\xA8\xB6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x70\xC5"],
        ["\x70\xC5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\xB6"],

        ["\xE8\xA9\x81",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x70\xC6"],
        ["\x70\xC6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\x81"],

        ["\xE8\xA9\x9B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x70\xC7"],
        ["\x70\xC7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\x9B"],

        ["\xE8\xA9\x92",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x70\xC8"],
        ["\x70\xC8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\x92"],

        ["\xE8\xA9\x86",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x70\xC9"],
        ["\x70\xC9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\x86"],

        ["\xE8\xA9\x88",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x70\xD1"],
        ["\x70\xD1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\x88"],

        ["\xE8\xA9\xBC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x70\xD2"],
        ["\x70\xD2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\xBC"],

        ["\xE8\xA9\xAD",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x70\xD3"],
        ["\x70\xD3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\xAD"],

        ["\xE8\xA9\xAC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x70\xD4"],
        ["\x70\xD4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\xAC"],

        ["\xE8\xA9\xA2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x70\xD5"],
        ["\x70\xD5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\xA2"],

        ["\xE8\xAA\x85",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x70\xD6"],
        ["\x70\xD6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\x85"],

        ["\xE8\xAA\x82",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x70\xD7"],
        ["\x70\xD7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\x82"],

        ["\xE8\xAA\x84",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x70\xD8"],
        ["\x70\xD8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\x84"],

        ["\xE8\xAA\xA8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x70\xD9"],
        ["\x70\xD9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\xA8"],

        ["\xE8\xAA\xA1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x70\xE2"],
        ["\x70\xE2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\xA1"],

        ["\xE8\xAA\x91",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x70\xE3"],
        ["\x70\xE3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\x91"],

        ["\xE8\xAA\xA5",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x70\xE4"],
        ["\x70\xE4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\xA5"],

        ["\xE8\xAA\xA6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x70\xE5"],
        ["\x70\xE5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\xA6"],

        ["\xE8\xAA\x9A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x70\xE6"],
        ["\x70\xE6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\x9A"],

        ["\xE8\xAA\xA3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x70\xE7"],
        ["\x70\xE7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\xA3"],

        ["\xE8\xAB\x84",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x70\xE8"],
        ["\x70\xE8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\x84"],

        ["\xE8\xAB\x8D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x70\xE9"],
        ["\x70\xE9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\x8D"],

        ["\xE8\xAB\x82",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x70\x4A"],
        ["\x70\x4A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\x82"],

        ["\xE8\xAB\x9A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x70\x5B"],
        ["\x70\x5B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\x9A"],

        ["\xE8\xAB\xAB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xF4\xD9"],
        ["\xF4\xD9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\xAB"],

        ["\xE8\xAB\xB3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x70\x5F"],
        ["\x70\x5F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\xB3"],

        ["\xE8\xAB\xA7",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x70\x6D"],
        ["\x70\x6D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\xA7"],

        ["\xE8\xAB\xA4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x70\x79"],
        ["\x70\x79",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\xA4"],

        ["\xE8\xAB\xB1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x70\x57"],
        ["\x70\x57",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\xB1"],

        ["\xE8\xAC\x94",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x70\x59"],
        ["\x70\x59",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC\x94"],

        ["\xE8\xAB\xA0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x70\x62"],
        ["\x70\x62",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\xA0"],

        ["\xE8\xAB\xA2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x70\x63"],
        ["\x70\x63",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\xA2"],

        ["\xE8\xAB\xB7",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x70\x64"],
        ["\x70\x64",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\xB7"],

        ["\xE8\xAB\x9E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x70\x65"],
        ["\x70\x65",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\x9E"],

        ["\xE8\xAB\x9B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x70\x66"],
        ["\x70\x66",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\x9B"],

        ["\xE8\xAC\x8C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x70\x67"],
        ["\x70\x67",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC\x8C"],

        ["\xE8\xAC\x87",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x70\x68"],
        ["\x70\x68",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC\x87"],

        ["\xE8\xAC\x9A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x70\x69"],
        ["\x70\x69",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC\x9A"],

        ["\xE8\xAB\xA1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x70\x70"],
        ["\x70\x70",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\xA1"],

        ["\xE8\xAC\x96",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x70\x71"],
        ["\x70\x71",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC\x96"],

        ["\xE8\xAC\x90",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x70\x72"],
        ["\x70\x72",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC\x90"],

        ["\xE8\xAC\x97",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x70\x73"],
        ["\x70\x73",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC\x97"],

        ["\xE8\xAC\xA0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x70\x74"],
        ["\x70\x74",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC\xA0"],

        ["\xE8\xAC\xB3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x70\x75"],
        ["\x70\x75",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC\xB3"],

        ["\xE9\x9E\xAB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x70\x76"],
        ["\x70\x76",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9E\xAB"],

        ["\xE8\xAC\xA6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x70\x77"],
        ["\x70\x77",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC\xA6"],

        ["\xE8\xAC\xAB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x70\x78"],
        ["\x70\x78",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC\xAB"],

        ["\xE8\xAC\xBE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x70\x80"],
        ["\x70\x80",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC\xBE"],

        ["\xE8\xAC\xA8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x70\x8B"],
        ["\x70\x8B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC\xA8"],

        ["\xE8\xAD\x81",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x70\x9B"],
        ["\x70\x9B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD\x81"],

        ["\xE8\xAD\x8C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x70\x9C"],
        ["\x70\x9C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD\x8C"],

        ["\xE8\xAD\x8F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x70\xA0"],
        ["\x70\xA0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD\x8F"],

        ["\xE8\xAD\x8E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x70\xAB"],
        ["\x70\xAB",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD\x8E"],

        ["\xE8\xAD\x89",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x70\xB0"],
        ["\x70\xB0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD\x89"],

        ["\xE8\xAD\x96",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x70\xC0"],
        ["\x70\xC0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD\x96"],

        ["\xE8\xAD\x9B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x70\x6A"],
        ["\x70\x6A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD\x9B"],

        ["\xE8\xAD\x9A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x70\xD0"],
        ["\x70\xD0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD\x9A"],

        ["\xE8\xAD\xAB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x70\xA1"],
        ["\x70\xA1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD\xAB"],

        ["\xE8\xAD\x9F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x71\x4F"],
        ["\x71\x4F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD\x9F"],

        ["\xE8\xAD\xAC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x71\x7F"],
        ["\x71\x7F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD\xAC"],

        ["\xE8\xAD\xAF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x71\x7B"],
        ["\x71\x7B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD\xAF"],

        ["\xE8\xAD\xB4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x71\xE0"],
        ["\x71\xE0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD\xB4"],

        ["\xE8\xAD\xBD",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x71\x6C"],
        ["\x71\x6C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD\xBD"],

        ["\xE8\xAE\x80",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x71\x50"],
        ["\x71\x50",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAE\x80"],

        ["\xE8\xAE\x8C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x71\x7D"],
        ["\x71\x7D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAE\x8C"],

        ["\xE8\xAE\x8E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x71\x4D"],
        ["\x71\x4D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAE\x8E"],

        ["\xE8\xAE\x92",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x71\x5D"],
        ["\x71\x5D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAE\x92"],

        ["\xE8\xAE\x93",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x71\x5C"],
        ["\x71\x5C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAE\x93"],

        ["\xE8\xAE\x96",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x71\x4E"],
        ["\x71\x4E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAE\x96"],

        ["\xE8\xAE\x99",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x71\x6B"],
        ["\x71\x6B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAE\x99"],

        ["\xE8\xAE\x9A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x71\x60"],
        ["\x71\x60",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAE\x9A"],

        ["\xE8\xB0\xBA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x71\x4B"],
        ["\x71\x4B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB0\xBA"],

        ["\xE8\xB1\x81",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x71\x61"],
        ["\x71\x61",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB1\x81"],

        ["\xE8\xB0\xBF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x71\xF0"],
        ["\x71\xF0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB0\xBF"],

        ["\xE8\xB1\x88",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x71\xF1"],
        ["\x71\xF1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB1\x88"],

        ["\xE8\xB1\x8C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x71\xF2"],
        ["\x71\xF2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB1\x8C"],

        ["\xE8\xB1\x8E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x71\xF3"],
        ["\x71\xF3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB1\x8E"],

        ["\xE8\xB1\x90",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x71\xF4"],
        ["\x71\xF4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB1\x90"],

        ["\xE8\xB1\x95",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x71\xF5"],
        ["\x71\xF5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB1\x95"],

        ["\xE8\xB1\xA2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x71\xF6"],
        ["\x71\xF6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB1\xA2"],

        ["\xE8\xB1\xAC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x71\xF7"],
        ["\x71\xF7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB1\xAC"],

        ["\xE8\xB1\xB8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x71\xF8"],
        ["\x71\xF8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB1\xB8"],

        ["\xE8\xB1\xBA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x71\xF9"],
        ["\x71\xF9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB1\xBA"],

        ["\xE8\xB2\x82",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x71\x7A"],
        ["\x71\x7A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\x82"],

        ["\xE8\xB2\x89",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x71\x5E"],
        ["\x71\x5E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\x89"],

        ["\xE8\xB2\x85",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x71\x4C"],
        ["\x71\x4C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\x85"],

        ["\xE8\xB2\x8A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x71\x7E"],
        ["\x71\x7E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\x8A"],

        ["\xE8\xB2\x8D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x71\x6E"],
        ["\x71\x6E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\x8D"],

        ["\xE8\xB2\x8E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x71\x6F"],
        ["\x71\x6F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\x8E"],

        ["\xE8\xB2\x94",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x71\x7C"],
        ["\x71\x7C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\x94"],

        ["\xE8\xB1\xBC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x71\xC1"],
        ["\x71\xC1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB1\xBC"],

        ["\xE8\xB2\x98",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x71\xC2"],
        ["\x71\xC2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\x98"],

        ["\xE6\x88\x9D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x71\xC3"],
        ["\x71\xC3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\x9D"],

        ["\xE8\xB2\xAD",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x71\xC4"],
        ["\x71\xC4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\xAD"],

        ["\xE8\xB2\xAA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x71\xC5"],
        ["\x71\xC5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\xAA"],

        ["\xE8\xB2\xBD",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x71\xC6"],
        ["\x71\xC6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\xBD"],

        ["\xE8\xB2\xB2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x71\xC7"],
        ["\x71\xC7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\xB2"],

        ["\xE8\xB2\xB3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x71\xC8"],
        ["\x71\xC8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\xB3"],

        ["\xE8\xB2\xAE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x71\xC9"],
        ["\x71\xC9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\xAE"],

        ["\xE8\xB2\xB6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x71\xD1"],
        ["\x71\xD1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\xB6"],

        ["\xE8\xB3\x88",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x71\xD2"],
        ["\x71\xD2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\x88"],

        ["\xE8\xB3\x81",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x71\xD3"],
        ["\x71\xD3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\x81"],

        ["\xE8\xB3\xA4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC1\x4D"],
        ["\xC1\x4D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\xA4"],

        ["\xE8\xB3\xA3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x71\xD5"],
        ["\x71\xD5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\xA3"],

        ["\xE8\xB3\x9A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x71\xD6"],
        ["\x71\xD6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\x9A"],

        ["\xE8\xB3\xBD",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x71\xD7"],
        ["\x71\xD7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\xBD"],

        ["\xE8\xB3\xBA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x71\xD8"],
        ["\x71\xD8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\xBA"],

        ["\xE8\xB3\xBB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x71\xD9"],
        ["\x71\xD9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\xBB"],

        ["\xE8\xB4\x84",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x71\xE2"],
        ["\x71\xE2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB4\x84"],

        ["\xE8\xB4\x85",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x71\xE3"],
        ["\x71\xE3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB4\x85"],

        ["\xE8\xB4\x8A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x71\xE4"],
        ["\x71\xE4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB4\x8A"],

        ["\xE8\xB4\x87",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x71\xE5"],
        ["\x71\xE5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB4\x87"],

        ["\xE8\xB4\x8F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x71\xE6"],
        ["\x71\xE6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB4\x8F"],

        ["\xE8\xB4\x8D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x71\xE7"],
        ["\x71\xE7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB4\x8D"],

        ["\xE8\xB4\x90",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x71\xE8"],
        ["\x71\xE8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB4\x90"],

        ["\xE9\xBD\x8E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x71\xE9"],
        ["\x71\xE9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xBD\x8E"],

        ["\xE8\xB4\x93",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x71\x4A"],
        ["\x71\x4A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB4\x93"],

        ["\xE8\xB3\x8D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x71\x5B"],
        ["\x71\x5B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\x8D"],

        ["\xE8\xB4\x94",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x71\x5A"],
        ["\x71\x5A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB4\x94"],

        ["\xE8\xB4\x96",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x71\x5F"],
        ["\x71\x5F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB4\x96"],

        ["\xE8\xB5\xA7",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x71\x6D"],
        ["\x71\x6D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB5\xA7"],

        ["\xE8\xB5\xAD",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x71\x79"],
        ["\x71\x79",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB5\xAD"],

        ["\xE8\xB5\xB1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x71\x57"],
        ["\x71\x57",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB5\xB1"],

        ["\xE8\xB5\xB3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x71\x59"],
        ["\x71\x59",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB5\xB3"],

        ["\xE8\xB6\x81",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x71\x62"],
        ["\x71\x62",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB6\x81"],

        ["\xE8\xB6\x99",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x71\x63"],
        ["\x71\x63",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB6\x99"],

        ["\xE8\xB7\x82",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x71\x64"],
        ["\x71\x64",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB7\x82"],

        ["\xE8\xB6\xBE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x71\x65"],
        ["\x71\x65",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB6\xBE"],

        ["\xE8\xB6\xBA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x71\x66"],
        ["\x71\x66",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB6\xBA"],

        ["\xE8\xB7\x8F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x71\x67"],
        ["\x71\x67",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB7\x8F"],

        ["\xE8\xB7\x9A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x71\x68"],
        ["\x71\x68",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB7\x9A"],

        ["\xE8\xB7\x96",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x71\x69"],
        ["\x71\x69",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB7\x96"],

        ["\xE8\xB7\x8C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x71\x70"],
        ["\x71\x70",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB7\x8C"],

        ["\xE8\xB7\x9B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x71\x71"],
        ["\x71\x71",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB7\x9B"],

        ["\xE8\xB7\x8B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x71\x72"],
        ["\x71\x72",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB7\x8B"],

        ["\xE8\xB7\xAA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x71\x73"],
        ["\x71\x73",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB7\xAA"],

        ["\xE8\xB7\xAB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x71\x74"],
        ["\x71\x74",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB7\xAB"],

        ["\xE8\xB7\x9F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x71\x75"],
        ["\x71\x75",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB7\x9F"],

        ["\xE8\xB7\xA3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x71\x76"],
        ["\x71\x76",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB7\xA3"],

        ["\xE8\xB7\xBC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x71\x77"],
        ["\x71\x77",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB7\xBC"],

        ["\xE8\xB8\x88",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x71\x78"],
        ["\x71\x78",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB8\x88"],

        ["\xE8\xB8\x89",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x71\x80"],
        ["\x71\x80",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB8\x89"],

        ["\xE8\xB7\xBF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x71\x8B"],
        ["\x71\x8B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB7\xBF"],

        ["\xE8\xB8\x9D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x71\x9B"],
        ["\x71\x9B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB8\x9D"],

        ["\xE8\xB8\x9E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x71\x9C"],
        ["\x71\x9C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB8\x9E"],

        ["\xE8\xB8\x90",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x71\xA0"],
        ["\x71\xA0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB8\x90"],

        ["\xE8\xB8\x9F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x71\xAB"],
        ["\x71\xAB",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB8\x9F"],

        ["\xE8\xB9\x82",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x71\xB0"],
        ["\x71\xB0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB9\x82"],

        ["\xE8\xB8\xB5",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x71\xC0"],
        ["\x71\xC0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB8\xB5"],

        ["\xE8\xB8\xB0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x71\x6A"],
        ["\x71\x6A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB8\xB0"],

        ["\xE8\xB8\xB4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x71\xD0"],
        ["\x71\xD0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB8\xB4"],

        ["\xE8\xB9\x8A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x71\xA1"],
        ["\x71\xA1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB9\x8A"],

        ["\xE8\xB9\x87",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x72\x4F"],
        ["\x72\x4F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB9\x87"],

        ["\xE8\xB9\x89",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x72\x7F"],
        ["\x72\x7F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB9\x89"],

        ["\xE8\xB9\x8C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x72\x7B"],
        ["\x72\x7B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB9\x8C"],

        ["\xE8\xB9\x90",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x72\xE0"],
        ["\x72\xE0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB9\x90"],

        ["\xE8\xB9\x88",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x72\x6C"],
        ["\x72\x6C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB9\x88"],

        ["\xE8\xB9\x99",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x72\x50"],
        ["\x72\x50",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB9\x99"],

        ["\xE8\xB9\xA4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x72\x7D"],
        ["\x72\x7D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB9\xA4"],

        ["\xE8\xB9\xA0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x72\x4D"],
        ["\x72\x4D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB9\xA0"],

        ["\xE8\xB8\xAA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x72\x5D"],
        ["\x72\x5D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB8\xAA"],

        ["\xE8\xB9\xA3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x72\x5C"],
        ["\x72\x5C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB9\xA3"],

        ["\xE8\xB9\x95",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x72\x4E"],
        ["\x72\x4E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB9\x95"],

        ["\xE8\xB9\xB6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x72\x6B"],
        ["\x72\x6B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB9\xB6"],

        ["\xE8\xB9\xB2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x72\x60"],
        ["\x72\x60",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB9\xB2"],

        ["\xE8\xB9\xBC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x72\x4B"],
        ["\x72\x4B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB9\xBC"],

        ["\xE8\xBA\x81",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x72\x61"],
        ["\x72\x61",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBA\x81"],

        ["\xE8\xBA\x87",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x72\xF0"],
        ["\x72\xF0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBA\x87"],

        ["\xE8\xBA\x85",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x72\xF1"],
        ["\x72\xF1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBA\x85"],

        ["\xE8\xBA\x84",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x72\xF2"],
        ["\x72\xF2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBA\x84"],

        ["\xE8\xBA\x8B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x72\xF3"],
        ["\x72\xF3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBA\x8B"],

        ["\xE8\xBA\x8A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x72\xF4"],
        ["\x72\xF4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBA\x8A"],

        ["\xE8\xBA\x93",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x72\xF5"],
        ["\x72\xF5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBA\x93"],

        ["\xE8\xBA\x91",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x72\xF6"],
        ["\x72\xF6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBA\x91"],

        ["\xE8\xBA\x94",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x72\xF7"],
        ["\x72\xF7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBA\x94"],

        ["\xE8\xBA\x99",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x72\xF8"],
        ["\x72\xF8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBA\x99"],

        ["\xE8\xBA\xAA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x72\xF9"],
        ["\x72\xF9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBA\xAA"],

        ["\xE8\xBA\xA1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x72\x7A"],
        ["\x72\x7A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBA\xA1"],

        ["\xE8\xBA\xAC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x72\x5E"],
        ["\x72\x5E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBA\xAC"],

        ["\xE8\xBA\xB0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x72\x4C"],
        ["\x72\x4C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBA\xB0"],

        ["\xE8\xBB\x86",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x72\x7E"],
        ["\x72\x7E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBB\x86"],

        ["\xE8\xBA\xB1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x72\x6E"],
        ["\x72\x6E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBA\xB1"],

        ["\xE8\xBA\xBE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x72\x6F"],
        ["\x72\x6F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBA\xBE"],

        ["\xE8\xBB\x85",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x72\x7C"],
        ["\x72\x7C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBB\x85"],

        ["\xE8\xBB\x88",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x72\xC1"],
        ["\x72\xC1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBB\x88"],

        ["\xE8\xBB\x8B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x72\xC2"],
        ["\x72\xC2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBB\x8B"],

        ["\xE8\xBB\x9B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x72\xC3"],
        ["\x72\xC3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBB\x9B"],

        ["\xE8\xBB\xA3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x72\xC4"],
        ["\x72\xC4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBB\xA3"],

        ["\xE8\xBB\xBC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x72\xC5"],
        ["\x72\xC5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBB\xBC"],

        ["\xE8\xBB\xBB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x72\xC6"],
        ["\x72\xC6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBB\xBB"],

        ["\xE8\xBB\xAB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x72\xC7"],
        ["\x72\xC7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBB\xAB"],

        ["\xE8\xBB\xBE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x72\xC8"],
        ["\x72\xC8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBB\xBE"],

        ["\xE8\xBC\x8A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x72\xC9"],
        ["\x72\xC9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC\x8A"],

        ["\xE8\xBC\x85",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x72\xD1"],
        ["\x72\xD1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC\x85"],

        ["\xE8\xBC\x95",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x72\xD2"],
        ["\x72\xD2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC\x95"],

        ["\xE8\xBC\x92",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x72\xD3"],
        ["\x72\xD3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC\x92"],

        ["\xE8\xBC\x99",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x72\xD4"],
        ["\x72\xD4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC\x99"],

        ["\xE8\xBC\x93",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x72\xD5"],
        ["\x72\xD5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC\x93"],

        ["\xE8\xBC\x9C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x72\xD6"],
        ["\x72\xD6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC\x9C"],

        ["\xE8\xBC\x9F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x72\xD7"],
        ["\x72\xD7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC\x9F"],

        ["\xE8\xBC\x9B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x72\xD8"],
        ["\x72\xD8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC\x9B"],

        ["\xE8\xBC\x8C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x72\xD9"],
        ["\x72\xD9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC\x8C"],

        ["\xE8\xBC\xA6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x72\xE2"],
        ["\x72\xE2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC\xA6"],

        ["\xE8\xBC\xB3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x72\xE3"],
        ["\x72\xE3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC\xB3"],

        ["\xE8\xBC\xBB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x72\xE4"],
        ["\x72\xE4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC\xBB"],

        ["\xE8\xBC\xB9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x72\xE5"],
        ["\x72\xE5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC\xB9"],

        ["\xE8\xBD\x85",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x72\xE6"],
        ["\x72\xE6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBD\x85"],

        ["\xE8\xBD\x82",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x72\xE7"],
        ["\x72\xE7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBD\x82"],

        ["\xE8\xBC\xBE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x72\xE8"],
        ["\x72\xE8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC\xBE"],

        ["\xE8\xBD\x8C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x72\xE9"],
        ["\x72\xE9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBD\x8C"],

        ["\xE8\xBD\x89",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x72\x4A"],
        ["\x72\x4A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBD\x89"],

        ["\xE8\xBD\x86",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x72\x5B"],
        ["\x72\x5B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBD\x86"],

        ["\xE8\xBD\x8E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x72\x5A"],
        ["\x72\x5A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBD\x8E"],

        ["\xE8\xBD\x97",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x72\x5F"],
        ["\x72\x5F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBD\x97"],

        ["\xE8\xBD\x9C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x72\x6D"],
        ["\x72\x6D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBD\x9C"],

        ["\xE8\xBD\xA2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x72\x79"],
        ["\x72\x79",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBD\xA2"],

        ["\xE8\xBD\xA3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x72\x57"],
        ["\x72\x57",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBD\xA3"],

        ["\xE8\xBD\xA4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x72\x59"],
        ["\x72\x59",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBD\xA4"],

        ["\xE8\xBE\x9C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x72\x62"],
        ["\x72\x62",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBE\x9C"],

        ["\xE8\xBE\x9F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x72\x63"],
        ["\x72\x63",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBE\x9F"],

        ["\xE8\xBE\xA3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x72\x64"],
        ["\x72\x64",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBE\xA3"],

        ["\xE8\xBE\xAD",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x72\x65"],
        ["\x72\x65",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBE\xAD"],

        ["\xE8\xBE\xAF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x72\x66"],
        ["\x72\x66",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBE\xAF"],

        ["\xE8\xBE\xB7",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x72\x67"],
        ["\x72\x67",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBE\xB7"],

        ["\xE8\xBF\x9A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x72\x68"],
        ["\x72\x68",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF\x9A"],

        ["\xE8\xBF\xA5",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x72\x69"],
        ["\x72\x69",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF\xA5"],

        ["\xE8\xBF\xA2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x72\x70"],
        ["\x72\x70",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF\xA2"],

        ["\xE8\xBF\xAA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x72\x71"],
        ["\x72\x71",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF\xAA"],

        ["\xE8\xBF\xAF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x72\x72"],
        ["\x72\x72",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF\xAF"],

        ["\xE9\x82\x87",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\xC6\x9B"],
        ["\xC6\x9B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x82\x87"],

        ["\xE8\xBF\xB4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x72\x74"],
        ["\x72\x74",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF\xB4"],

        ["\xE9\x80\x85",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x72\x75"],
        ["\x72\x75",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\x85"],

        ["\xE8\xBF\xB9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x72\x76"],
        ["\x72\x76",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF\xB9"],

        ["\xE8\xBF\xBA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x72\x77"],
        ["\x72\x77",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF\xBA"],

        ["\xE9\x80\x91",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x72\x78"],
        ["\x72\x78",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\x91"],

        ["\xE9\x80\x95",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x72\x80"],
        ["\x72\x80",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\x95"],

        ["\xE9\x80\xA1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x72\x8B"],
        ["\x72\x8B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\xA1"],

        ["\xE9\x80\x8D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x72\x9B"],
        ["\x72\x9B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\x8D"],

        ["\xE9\x80\x9E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x72\x9C"],
        ["\x72\x9C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\x9E"],

        ["\xE9\x80\x96",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x72\xA0"],
        ["\x72\xA0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\x96"],

        ["\xE9\x80\x8B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x72\xAB"],
        ["\x72\xAB",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\x8B"],

        ["\xE9\x80\xA7",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x72\xB0"],
        ["\x72\xB0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\xA7"],

        ["\xE9\x80\xB6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x72\xC0"],
        ["\x72\xC0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\xB6"],

        ["\xE9\x80\xB5",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x72\x6A"],
        ["\x72\x6A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\xB5"],

        ["\xE9\x80\xB9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x72\xD0"],
        ["\x72\xD0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\xB9"],

        ["\xE8\xBF\xB8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x72\xA1"],
        ["\x72\xA1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF\xB8"],

        ["\xE9\x81\x8F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x73\x4F"],
        ["\x73\x4F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\x8F"],

        ["\xE9\x81\x90",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x73\x7F"],
        ["\x73\x7F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\x90"],

        ["\xE9\x81\x91",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x73\x7B"],
        ["\x73\x7B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\x91"],

        ["\xE9\x81\x92",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x73\xE0"],
        ["\x73\xE0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\x92"],

        ["\xE9\x80\x8E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x73\x6C"],
        ["\x73\x6C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\x8E"],

        ["\xE9\x81\x89",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x73\x50"],
        ["\x73\x50",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\x89"],

        ["\xE9\x80\xBE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x73\x7D"],
        ["\x73\x7D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\xBE"],

        ["\xE9\x81\x96",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x73\x4D"],
        ["\x73\x4D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\x96"],

        ["\xE9\x81\x98",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x73\x5D"],
        ["\x73\x5D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\x98"],

        ["\xE9\x81\x9E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x73\x5C"],
        ["\x73\x5C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\x9E"],

        ["\xE9\x81\xA8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x73\x4E"],
        ["\x73\x4E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\xA8"],

        ["\xE9\x81\xAF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x73\x6B"],
        ["\x73\x6B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\xAF"],

        ["\xE9\x81\xB6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x73\x60"],
        ["\x73\x60",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\xB6"],

        ["\xE9\x9A\xA8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x73\x4B"],
        ["\x73\x4B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\xA8"],

        ["\xE9\x81\xB2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x73\x61"],
        ["\x73\x61",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\xB2"],

        ["\xE9\x82\x82",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x73\xF0"],
        ["\x73\xF0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x82\x82"],

        ["\xE9\x81\xBD",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x73\xF1"],
        ["\x73\xF1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\xBD"],

        ["\xE9\x82\x81",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x73\xF2"],
        ["\x73\xF2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x82\x81"],

        ["\xE9\x82\x80",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x73\xF3"],
        ["\x73\xF3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x82\x80"],

        ["\xE9\x82\x8A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x73\xF4"],
        ["\x73\xF4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x82\x8A"],

        ["\xE9\x82\x89",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x73\xF5"],
        ["\x73\xF5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x82\x89"],

        ["\xE9\x82\x8F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x73\xF6"],
        ["\x73\xF6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x82\x8F"],

        ["\xE9\x82\xA8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x73\xF7"],
        ["\x73\xF7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x82\xA8"],

        ["\xE9\x82\xAF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x73\xF8"],
        ["\x73\xF8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x82\xAF"],

        ["\xE9\x82\xB1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x73\xF9"],
        ["\x73\xF9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x82\xB1"],

        ["\xE9\x82\xB5",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x73\x7A"],
        ["\x73\x7A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x82\xB5"],

        ["\xE9\x83\xA2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x73\x5E"],
        ["\x73\x5E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x83\xA2"],

        ["\xE9\x83\xA4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x73\x4C"],
        ["\x73\x4C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x83\xA4"],

        ["\xE6\x89\x88",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x73\x7E"],
        ["\x73\x7E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\x88"],

        ["\xE9\x83\x9B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x73\x6E"],
        ["\x73\x6E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x83\x9B"],

        ["\xE9\x84\x82",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x73\x6F"],
        ["\x73\x6F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x84\x82"],

        ["\xE9\x84\x92",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x73\x7C"],
        ["\x73\x7C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x84\x92"],

        ["\xE9\x84\x99",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x73\xC1"],
        ["\x73\xC1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x84\x99"],

        ["\xE9\x84\xB2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x73\xC2"],
        ["\x73\xC2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x84\xB2"],

        ["\xE9\x84\xB0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x73\xC3"],
        ["\x73\xC3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x84\xB0"],

        ["\xE9\x85\x8A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x73\xC4"],
        ["\x73\xC4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x85\x8A"],

        ["\xE9\x85\x96",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x73\xC5"],
        ["\x73\xC5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x85\x96"],

        ["\xE9\x85\x98",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x73\xC6"],
        ["\x73\xC6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x85\x98"],

        ["\xE9\x85\xA3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x73\xC7"],
        ["\x73\xC7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x85\xA3"],

        ["\xE9\x85\xA5",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x73\xC8"],
        ["\x73\xC8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x85\xA5"],

        ["\xE9\x85\xA9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x73\xC9"],
        ["\x73\xC9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x85\xA9"],

        ["\xE9\x85\xB3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x73\xD1"],
        ["\x73\xD1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x85\xB3"],

        ["\xE9\x85\xB2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x73\xD2"],
        ["\x73\xD2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x85\xB2"],

        ["\xE9\x86\x8B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x73\xD3"],
        ["\x73\xD3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x86\x8B"],

        ["\xE9\x86\x89",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x73\xD4"],
        ["\x73\xD4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x86\x89"],

        ["\xE9\x86\x82",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x73\xD5"],
        ["\x73\xD5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x86\x82"],

        ["\xE9\x86\xA2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x73\xD6"],
        ["\x73\xD6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x86\xA2"],

        ["\xE9\x86\xAB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x73\xD7"],
        ["\x73\xD7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x86\xAB"],

        ["\xE9\x86\xAF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x73\xD8"],
        ["\x73\xD8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x86\xAF"],

        ["\xE9\x86\xAA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x73\xD9"],
        ["\x73\xD9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x86\xAA"],

        ["\xE9\x86\xB5",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x73\xE2"],
        ["\x73\xE2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x86\xB5"],

        ["\xE9\x86\xB4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x73\xE3"],
        ["\x73\xE3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x86\xB4"],

        ["\xE9\x86\xBA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x73\xE4"],
        ["\x73\xE4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x86\xBA"],

        ["\xE9\x87\x80",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x73\xE5"],
        ["\x73\xE5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\x80"],

        ["\xE9\x87\x81",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x73\xE6"],
        ["\x73\xE6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\x81"],

        ["\xE9\x87\x89",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x73\xE7"],
        ["\x73\xE7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\x89"],

        ["\xE9\x87\x8B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x73\xE8"],
        ["\x73\xE8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\x8B"],

        ["\xE9\x87\x90",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x73\xE9"],
        ["\x73\xE9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\x90"],

        ["\xE9\x87\x96",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x73\x4A"],
        ["\x73\x4A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\x96"],

        ["\xE9\x87\x9F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x73\x5B"],
        ["\x73\x5B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\x9F"],

        ["\xE9\x87\xA1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x73\x5A"],
        ["\x73\x5A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\xA1"],

        ["\xE9\x87\x9B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x73\x5F"],
        ["\x73\x5F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\x9B"],

        ["\xE9\x87\xBC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x73\x6D"],
        ["\x73\x6D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\xBC"],

        ["\xE9\x87\xB5",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x73\x79"],
        ["\x73\x79",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\xB5"],

        ["\xE9\x87\xB6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x73\x57"],
        ["\x73\x57",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\xB6"],

        ["\xE9\x88\x9E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x73\x59"],
        ["\x73\x59",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x88\x9E"],

        ["\xE9\x87\xBF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x73\x62"],
        ["\x73\x62",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\xBF"],

        ["\xE9\x88\x94",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x73\x63"],
        ["\x73\x63",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x88\x94"],

        ["\xE9\x88\xAC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x73\x64"],
        ["\x73\x64",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x88\xAC"],

        ["\xE9\x88\x95",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x73\x65"],
        ["\x73\x65",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x88\x95"],

        ["\xE9\x88\x91",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x73\x66"],
        ["\x73\x66",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x88\x91"],

        ["\xE9\x89\x9E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x73\x67"],
        ["\x73\x67",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x89\x9E"],

        ["\xE9\x89\x97",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x73\x68"],
        ["\x73\x68",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x89\x97"],

        ["\xE9\x89\x85",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x73\x69"],
        ["\x73\x69",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x89\x85"],

        ["\xE9\x89\x89",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x73\x70"],
        ["\x73\x70",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x89\x89"],

        ["\xE9\x89\xA4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x73\x71"],
        ["\x73\x71",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x89\xA4"],

        ["\xE9\x89\x88",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x73\x72"],
        ["\x73\x72",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x89\x88"],

        ["\xE9\x8A\x95",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x73\x73"],
        ["\x73\x73",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8A\x95"],

        ["\xE9\x88\xBF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x73\x74"],
        ["\x73\x74",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x88\xBF"],

        ["\xE9\x89\x8B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x73\x75"],
        ["\x73\x75",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x89\x8B"],

        ["\xE9\x89\x90",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x73\x76"],
        ["\x73\x76",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x89\x90"],

        ["\xE9\x8A\x9C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x73\x77"],
        ["\x73\x77",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8A\x9C"],

        ["\xE9\x8A\x96",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x73\x78"],
        ["\x73\x78",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8A\x96"],

        ["\xE9\x8A\x93",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x73\x80"],
        ["\x73\x80",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8A\x93"],

        ["\xE9\x8A\x9B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x73\x8B"],
        ["\x73\x8B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8A\x9B"],

        ["\xE9\x89\x9A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x73\x9B"],
        ["\x73\x9B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x89\x9A"],

        ["\xE9\x8B\x8F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x73\x9C"],
        ["\x73\x9C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8B\x8F"],

        ["\xE9\x8A\xB9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x73\xA0"],
        ["\x73\xA0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8A\xB9"],

        ["\xE9\x8A\xB7",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x73\xAB"],
        ["\x73\xAB",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8A\xB7"],

        ["\xE9\x8B\xA9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x73\xB0"],
        ["\x73\xB0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8B\xA9"],

        ["\xE9\x8C\x8F",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x73\xC0"],
        ["\x73\xC0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8C\x8F"],

        ["\xE9\x8B\xBA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x73\x6A"],
        ["\x73\x6A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8B\xBA"],

        ["\xE9\x8D\x84",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x73\xD0"],
        ["\x73\xD0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8D\x84"],

        ["\xE9\x8C\xAE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x73\xA1"],
        ["\x73\xA1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8C\xAE"],

        ["\xE9\x8C\x99",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x74\x4F"],
        ["\x74\x4F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8C\x99"],

        ["\xE9\x8C\xA2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x74\x7F"],
        ["\x74\x7F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8C\xA2"],

        ["\xE9\x8C\x9A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x74\x7B"],
        ["\x74\x7B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8C\x9A"],

        ["\xE9\x8C\xA3",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x74\xE0"],
        ["\x74\xE0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8C\xA3"],

        ["\xE9\x8C\xBA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x74\x6C"],
        ["\x74\x6C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8C\xBA"],

        ["\xE9\x8C\xB5",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x74\x50"],
        ["\x74\x50",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8C\xB5"],

        ["\xE9\x8C\xBB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x74\x7D"],
        ["\x74\x7D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8C\xBB"],

        ["\xE9\x8D\x9C",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x74\x4D"],
        ["\x74\x4D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8D\x9C"],

        ["\xE9\x8D\xA0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x74\x5D"],
        ["\x74\x5D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8D\xA0"],

        ["\xE9\x8D\xBC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x74\x5C"],
        ["\x74\x5C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8D\xBC"],

        ["\xE9\x8D\xAE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x74\x4E"],
        ["\x74\x4E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8D\xAE"],

        ["\xE9\x8D\x96",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x74\x6B"],
        ["\x74\x6B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8D\x96"],

        ["\xE9\x8E\xB0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x74\x60"],
        ["\x74\x60",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8E\xB0"],

        ["\xE9\x8E\xAC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x74\x4B"],
        ["\x74\x4B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8E\xAC"],

        ["\xE9\x8E\xAD",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x74\x61"],
        ["\x74\x61",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8E\xAD"],

        ["\xE9\x8E\x94",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x74\xF0"],
        ["\x74\xF0",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8E\x94"],

        ["\xE9\x8E\xB9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x74\xF1"],
        ["\x74\xF1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8E\xB9"],

        ["\xE9\x8F\x96",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x74\xF2"],
        ["\x74\xF2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8F\x96"],

        ["\xE9\x8F\x97",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x74\xF3"],
        ["\x74\xF3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8F\x97"],

        ["\xE9\x8F\xA8",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x74\xF4"],
        ["\x74\xF4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8F\xA8"],

        ["\xE9\x8F\xA5",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x74\xF5"],
        ["\x74\xF5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8F\xA5"],

        ["\xE9\x8F\x98",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x74\xF6"],
        ["\x74\xF6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8F\x98"],

        ["\xE9\x8F\x83",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x74\xF7"],
        ["\x74\xF7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8F\x83"],

        ["\xE9\x8F\x9D",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x74\xF8"],
        ["\x74\xF8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8F\x9D"],

        ["\xE9\x8F\x90",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x74\xF9"],
        ["\x74\xF9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8F\x90"],

        ["\xE9\x8F\x88",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x74\x7A"],
        ["\x74\x7A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8F\x88"],

        ["\xE9\x8F\xA4",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x74\x5E"],
        ["\x74\x5E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8F\xA4"],

        ["\xE9\x90\x9A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x74\x4C"],
        ["\x74\x4C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x90\x9A"],

        ["\xE9\x90\x94",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x74\x7E"],
        ["\x74\x7E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x90\x94"],

        ["\xE9\x90\x93",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x74\x6E"],
        ["\x74\x6E",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x90\x93"],

        ["\xE9\x90\x83",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x74\x6F"],
        ["\x74\x6F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x90\x83"],

        ["\xE9\x90\x87",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x74\x7C"],
        ["\x74\x7C",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x90\x87"],

        ["\xE9\x90\x90",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x74\xC1"],
        ["\x74\xC1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x90\x90"],

        ["\xE9\x90\xB6",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x74\xC2"],
        ["\x74\xC2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x90\xB6"],

        ["\xE9\x90\xAB",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x74\xC3"],
        ["\x74\xC3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x90\xAB"],

        ["\xE9\x90\xB5",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x74\xC4"],
        ["\x74\xC4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x90\xB5"],

        ["\xE9\x90\xA1",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x74\xC5"],
        ["\x74\xC5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x90\xA1"],

        ["\xE9\x90\xBA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x74\xC6"],
        ["\x74\xC6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x90\xBA"],

        ["\xE9\x91\x81",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x74\xC7"],
        ["\x74\xC7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x91\x81"],

        ["\xE9\x91\x92",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x74\xC8"],
        ["\x74\xC8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x91\x92"],

        ["\xE9\x91\x84",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x74\xC9"],
        ["\x74\xC9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x91\x84"],

        ["\xE9\x91\x9B",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x74\xD1"],
        ["\x74\xD1",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x91\x9B"],

        ["\xE9\x91\xA0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x74\xD2"],
        ["\x74\xD2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x91\xA0"],

        ["\xE9\x91\xA2",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x74\xD3"],
        ["\x74\xD3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x91\xA2"],

        ["\xE9\x91\x9E",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x74\xD4"],
        ["\x74\xD4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x91\x9E"],

        ["\xE9\x91\xAA",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x74\xD5"],
        ["\x74\xD5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x91\xAA"],

        ["\xE9\x88\xA9",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x74\xD6"],
        ["\x74\xD6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x88\xA9"],

        ["\xE9\x91\xB0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x74\xD7"],
        ["\x74\xD7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x91\xB0"],

        ["\xE9\x91\xB5",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x74\xD8"],
        ["\x74\xD8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x91\xB5"],

        ["\xE9\x91\xB7",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x74\xD9"],
        ["\x74\xD9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x91\xB7"],

        ["\xE9\x91\xBD",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x74\xE2"],
        ["\x74\xE2",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x91\xBD"],

        ["\xE9\x91\x9A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x74\xE3"],
        ["\x74\xE3",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x91\x9A"],

        ["\xE9\x91\xBC",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x74\xE4"],
        ["\x74\xE4",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x91\xBC"],

        ["\xE9\x91\xBE",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x74\xE5"],
        ["\x74\xE5",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x91\xBE"],

        ["\xE9\x92\x81",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x74\xE6"],
        ["\x74\xE6",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x92\x81"],

        ["\xE9\x91\xBF",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x74\xE7"],
        ["\x74\xE7",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x91\xBF"],

        ["\xE9\x96\x82",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x74\xE8"],
        ["\x74\xE8",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\x82"],

        ["\xE9\x96\x87",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x74\xE9"],
        ["\x74\xE9",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\x87"],

        ["\xE9\x96\x8A",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x74\x4A"],
        ["\x74\x4A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\x8A"],

        ["\xE9\x96\x94",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x74\x5B"],
        ["\x74\x5B",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\x94"],

        ["\xE9\x96\x96",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x74\x5A"],
        ["\x74\x5A",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\x96"],

        ["\xE9\x96\x98",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x74\x5F"],
        ["\x74\x5F",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\x98"],

        ["\xE9\x96\x99",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x74\x6D"],
        ["\x74\x6D",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\x99"],

        ["\xE9\x96\xA0",'jipse','utf8.1',{'INPUT_LAYOUT'=>'D'},"\x74\x79"],
        ["\x74\x79",'utf8.1','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\xA0"],

      