######################################################################
#
# 5100_letsj_by_jipse_RT_DBCS.t
#
# Copyright (c) 2018, 2019 INABA Hitoshi <ina@cpan.org> in a CPAN
######################################################################

use strict;
use FindBin;
use lib "$FindBin::Bin/../lib";

BEGIN {
    use vars qw(@test);
    @test = (
        ["\x4F\x4F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\x20\x20"],
        ["\x20\x20",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4F\x4F"],

        ["\x4F\x7F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA1\xA2"],
        ["\xA1\xA2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4F\x7F"],

        ["\x4F\x7B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA1\xA3"],
        ["\xA1\xA3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4F\x7B"],

        ["\x4F\xE0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA1\xA4"],
        ["\xA1\xA4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4F\xE0"],

        ["\x4F\x6C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA1\xA5"],
        ["\xA1\xA5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4F\x6C"],

        ["\x4F\x50",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA1\xA6"],
        ["\xA1\xA6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4F\x50"],

        ["\x4F\x7D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA1\xA7"],
        ["\xA1\xA7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4F\x7D"],

        ["\x4F\x4D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA1\xA8"],
        ["\xA1\xA8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4F\x4D"],

        ["\x4F\x5D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA1\xA9"],
        ["\xA1\xA9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4F\x5D"],

        ["\x4F\x5C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA1\xAA"],
        ["\xA1\xAA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4F\x5C"],

        ["\x4F\x4E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA1\xAB"],
        ["\xA1\xAB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4F\x4E"],

        ["\x4F\x6B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA1\xAC"],
        ["\xA1\xAC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4F\x6B"],

        ["\x4F\x60",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA1\xAD"],
        ["\xA1\xAD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4F\x60"],

        ["\x4F\x4B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA1\xAE"],
        ["\xA1\xAE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4F\x4B"],

        ["\x4F\x61",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA1\xAF"],
        ["\xA1\xAF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4F\x61"],

        ["\x4F\xF0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA1\xB0"],
        ["\xA1\xB0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4F\xF0"],

        ["\x4F\xF1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA1\xB1"],
        ["\xA1\xB1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4F\xF1"],

        ["\x4F\xF2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA1\xB2"],
        ["\xA1\xB2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4F\xF2"],

        ["\x4F\xF3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA1\xB3"],
        ["\xA1\xB3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4F\xF3"],

        ["\x4F\xF4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA1\xB4"],
        ["\xA1\xB4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4F\xF4"],

        ["\x4F\xF5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA1\xB5"],
        ["\xA1\xB5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4F\xF5"],

        ["\x4F\xF6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA1\xB6"],
        ["\xA1\xB6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4F\xF6"],

        ["\x4F\xF7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA1\xB7"],
        ["\xA1\xB7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4F\xF7"],

        ["\x4F\xF8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA1\xB8"],
        ["\xA1\xB8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4F\xF8"],

        ["\x4F\xF9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA1\xB9"],
        ["\xA1\xB9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4F\xF9"],

        ["\x4F\x7A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA1\xBA"],
        ["\xA1\xBA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4F\x7A"],

        ["\x4F\x5E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA1\xBB"],
        ["\xA1\xBB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4F\x5E"],

        ["\x4F\x4C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA1\xBC"],
        ["\xA1\xBC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4F\x4C"],

        ["\x4F\x7E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA1\xBD"],
        ["\xA1\xBD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4F\x7E"],

        ["\x4F\x6E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA1\xBE"],
        ["\xA1\xBE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4F\x6E"],

        ["\x4F\x6F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA1\xBF"],
        ["\xA1\xBF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4F\x6F"],

        ["\x4F\x7C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\x31\xA1"],
        ["\x31\xA1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4F\x7C"],

        ["\x4F\xC1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA1\xC1"],
        ["\xA1\xC1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4F\xC1"],

        ["\x4F\xC2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\x31\xA2"],
        ["\x31\xA2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4F\xC2"],

        ["\x4F\xC3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA1\xC3"],
        ["\xA1\xC3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4F\xC3"],

        ["\x4F\xC4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA1\xC4"],
        ["\xA1\xC4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4F\xC4"],

        ["\x4F\xC5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA1\xC5"],
        ["\xA1\xC5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4F\xC5"],

        ["\x4F\xC6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA1\xC6"],
        ["\xA1\xC6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4F\xC6"],

        ["\x4F\xC7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA1\xC7"],
        ["\xA1\xC7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4F\xC7"],

        ["\x4F\xC8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA1\xC8"],
        ["\xA1\xC8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4F\xC8"],

        ["\x4F\xC9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA1\xC9"],
        ["\xA1\xC9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4F\xC9"],

        ["\x4F\xD1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA1\xCA"],
        ["\xA1\xCA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4F\xD1"],

        ["\x4F\xD2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA1\xCB"],
        ["\xA1\xCB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4F\xD2"],

        ["\x4F\xD3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA1\xCC"],
        ["\xA1\xCC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4F\xD3"],

        ["\x4F\xD4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA1\xCD"],
        ["\xA1\xCD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4F\xD4"],

        ["\x4F\xD5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA1\xCE"],
        ["\xA1\xCE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4F\xD5"],

        ["\x4F\xD6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA1\xCF"],
        ["\xA1\xCF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4F\xD6"],

        ["\x4F\xD7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA1\xD0"],
        ["\xA1\xD0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4F\xD7"],

        ["\x4F\xD8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA1\xD1"],
        ["\xA1\xD1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4F\xD8"],

        ["\x4F\xD9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA1\xD2"],
        ["\xA1\xD2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4F\xD9"],

        ["\x4F\xE2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA1\xD3"],
        ["\xA1\xD3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4F\xE2"],

        ["\x4F\xE3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA1\xD4"],
        ["\xA1\xD4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4F\xE3"],

        ["\x4F\xE4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA1\xD5"],
        ["\xA1\xD5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4F\xE4"],

        ["\x4F\xE5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA1\xD6"],
        ["\xA1\xD6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4F\xE5"],

        ["\x4F\xE6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA1\xD7"],
        ["\xA1\xD7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4F\xE6"],

        ["\x4F\xE7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA1\xD8"],
        ["\xA1\xD8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4F\xE7"],

        ["\x4F\xE8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA1\xD9"],
        ["\xA1\xD9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4F\xE8"],

        ["\x4F\xE9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA1\xDA"],
        ["\xA1\xDA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4F\xE9"],

        ["\x4F\x4A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA1\xDB"],
        ["\xA1\xDB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4F\x4A"],

        ["\x4F\x5B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA1\xDC"],
        ["\xA1\xDC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4F\x5B"],

        ["\x4F\x5A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\x31\xA3"],
        ["\x31\xA3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4F\x5A"],

        ["\x4F\x5F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA1\xDE"],
        ["\xA1\xDE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4F\x5F"],

        ["\x4F\x6D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA1\xDF"],
        ["\xA1\xDF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4F\x6D"],

        ["\x4F\x79",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA1\xE0"],
        ["\xA1\xE0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4F\x79"],

        ["\x4F\x57",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA1\xE1"],
        ["\xA1\xE1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4F\x57"],

        ["\x4F\x59",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA1\xE2"],
        ["\xA1\xE2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4F\x59"],

        ["\x4F\x62",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA1\xE3"],
        ["\xA1\xE3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4F\x62"],

        ["\x4F\x63",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA1\xE4"],
        ["\xA1\xE4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4F\x63"],

        ["\x4F\x64",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA1\xE5"],
        ["\xA1\xE5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4F\x64"],

        ["\x4F\x65",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA1\xE6"],
        ["\xA1\xE6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4F\x65"],

        ["\x4F\x66",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA1\xE7"],
        ["\xA1\xE7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4F\x66"],

        ["\x4F\x67",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA1\xE8"],
        ["\xA1\xE8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4F\x67"],

        ["\x4F\x68",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA1\xE9"],
        ["\xA1\xE9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4F\x68"],

        ["\x4F\x69",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA1\xEA"],
        ["\xA1\xEA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4F\x69"],

        ["\x4F\x70",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA1\xEB"],
        ["\xA1\xEB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4F\x70"],

        ["\x4F\x71",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA1\xEC"],
        ["\xA1\xEC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4F\x71"],

        ["\x4F\x72",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA1\xED"],
        ["\xA1\xED",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4F\x72"],

        ["\x4F\x73",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA1\xEE"],
        ["\xA1\xEE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4F\x73"],

        ["\x4F\x74",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA1\xEF"],
        ["\xA1\xEF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4F\x74"],

        ["\x4F\x75",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA1\xF0"],
        ["\xA1\xF0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4F\x75"],

        ["\x4F\x76",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\x31\xA4"],
        ["\x31\xA4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4F\x76"],

        ["\x4F\x77",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\x31\xA5"],
        ["\x31\xA5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4F\x77"],

        ["\x4F\x78",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA1\xF3"],
        ["\xA1\xF3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4F\x78"],

        ["\x4F\x80",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA1\xF4"],
        ["\xA1\xF4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4F\x80"],

        ["\x4F\x8B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA1\xF5"],
        ["\xA1\xF5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4F\x8B"],

        ["\x4F\x9B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA1\xF6"],
        ["\xA1\xF6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4F\x9B"],

        ["\x4F\x9C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA1\xF7"],
        ["\xA1\xF7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4F\x9C"],

        ["\x4F\xA0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA1\xF8"],
        ["\xA1\xF8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4F\xA0"],

        ["\x4F\xAB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA1\xF9"],
        ["\xA1\xF9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4F\xAB"],

        ["\x4F\xB0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA1\xFA"],
        ["\xA1\xFA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4F\xB0"],

        ["\x4F\xC0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA1\xFB"],
        ["\xA1\xFB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4F\xC0"],

        ["\x4F\x6A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA1\xFC"],
        ["\xA1\xFC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4F\x6A"],

        ["\x4F\xD0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA1\xFD"],
        ["\xA1\xFD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4F\xD0"],

        ["\x4F\xA1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA1\xFE"],
        ["\xA1\xFE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4F\xA1"],

        ["\x7F\x4F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA2\xA1"],
        ["\xA2\xA1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7F\x4F"],

        ["\x7F\x7F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA2\xA2"],
        ["\xA2\xA2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7F\x7F"],

        ["\x7F\x7B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA2\xA3"],
        ["\xA2\xA3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7F\x7B"],

        ["\x7F\xE0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA2\xA4"],
        ["\xA2\xA4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7F\xE0"],

        ["\x7F\x6C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA2\xA5"],
        ["\xA2\xA5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7F\x6C"],

        ["\x7F\x50",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA2\xA6"],
        ["\xA2\xA6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7F\x50"],

        ["\x7F\x7D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA2\xA7"],
        ["\xA2\xA7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7F\x7D"],

        ["\x7F\x4D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA2\xA8"],
        ["\xA2\xA8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7F\x4D"],

        ["\x7F\x5D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA2\xA9"],
        ["\xA2\xA9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7F\x5D"],

        ["\x7F\x5C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA2\xAA"],
        ["\xA2\xAA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7F\x5C"],

        ["\x7F\x4E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA2\xAB"],
        ["\xA2\xAB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7F\x4E"],

        ["\x7F\x6B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA2\xAC"],
        ["\xA2\xAC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7F\x6B"],

        ["\x7F\x60",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA2\xAD"],
        ["\xA2\xAD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7F\x60"],

        ["\x7F\x4B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xA2\xAE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7F\x4B"],

        ["\x45\xA9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA2\xBA"],
        ["\xA2\xBA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x45\xA9"],

        ["\x45\xAA",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA2\xBB"],
        ["\xA2\xBB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x45\xAA"],

        ["\x46\xEA",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA2\xBC"],
        ["\xA2\xBC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x46\xEA"],

        ["\x46\xEB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA2\xBD"],
        ["\xA2\xBD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x46\xEB"],

        ["\x45\xA7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA2\xBE"],
        ["\xA2\xBE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x45\xA7"],

        ["\x45\xA8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA2\xBF"],
        ["\xA2\xBF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x45\xA8"],

        ["\x60\x6A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA2\xC0"],
        ["\xA2\xC0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x60\x6A"],

        ["\x60\xC0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA2\xC1"],
        ["\xA2\xC1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x60\xC0"],

        ["\x45\xA5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA2\xCA"],
        ["\xA2\xCA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x45\xA5"],

        ["\x45\xA6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA2\xCB"],
        ["\xA2\xCB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x45\xA6"],

        ["\x80\x4F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\x31\xA6"],
        ["\x31\xA6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x80\x4F"],

        ["\x46\xEC",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA2\xCD"],
        ["\xA2\xCD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x46\xEC"],

        ["\x46\xED",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA2\xCE"],
        ["\xA2\xCE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x46\xED"],

        ["\x45\xB9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA2\xCF"],
        ["\xA2\xCF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x45\xB9"],

        ["\x45\xCA",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA2\xD0"],
        ["\xA2\xD0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x45\xCA"],

        ["\x60\x9C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA2\xDC"],
        ["\xA2\xDC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x60\x9C"],

        ["\x60\x9B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA2\xDD"],
        ["\xA2\xDD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x60\x9B"],

        ["\x46\xEE",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA2\xDE"],
        ["\xA2\xDE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x46\xEE"],

        ["\x45\x9D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA2\xDF"],
        ["\xA2\xDF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x45\x9D"],

        ["\x46\xEF",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA2\xE0"],
        ["\xA2\xE0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x46\xEF"],

        ["\x60\x76",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA2\xE1"],
        ["\xA2\xE1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x60\x76"],

        ["\x60\x75",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA2\xE2"],
        ["\xA2\xE2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x60\x75"],

        ["\x45\xB3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA2\xE3"],
        ["\xA2\xE3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x45\xB3"],

        ["\x45\xB4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA2\xE4"],
        ["\xA2\xE4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x45\xB4"],

        ["\x60\x8B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA2\xE5"],
        ["\xA2\xE5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x60\x8B"],

        ["\x45\xBD",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA2\xE6"],
        ["\xA2\xE6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x45\xBD"],

        ["\x45\xBC",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA2\xE7"],
        ["\xA2\xE7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x45\xBC"],

        ["\x60\xB0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA2\xE8"],
        ["\xA2\xE8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x60\xB0"],

        ["\x60\x77",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA2\xE9"],
        ["\xA2\xE9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x60\x77"],

        ["\x46\xFA",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA2\xEA"],
        ["\xA2\xEA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x46\xFA"],

        ["\x44\xBF",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA2\xF2"],
        ["\xA2\xF2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x44\xBF"],

        ["\x44\xFE",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA2\xF3"],
        ["\xA2\xF3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x44\xFE"],

        ["\x46\xFB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA2\xF4"],
        ["\xA2\xF4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x46\xFB"],

        ["\x46\xFC",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA2\xF5"],
        ["\xA2\xF5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x46\xFC"],

        ["\x46\xFD",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA2\xF6"],
        ["\xA2\xF6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x46\xFD"],

        ["\x45\xDA",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA2\xF7"],
        ["\xA2\xF7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x45\xDA"],

        ["\x45\xDB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA2\xF8"],
        ["\xA2\xF8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x45\xDB"],

        ["\x45\xDC",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA2\xF9"],
        ["\xA2\xF9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x45\xDC"],

        ["\x46\xFE",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA2\xFE"],
        ["\xA2\xFE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x46\xFE"],

        ["\x7B\xF0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA3\xB0"],
        ["\xA3\xB0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7B\xF0"],

        ["\x7B\xF1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA3\xB1"],
        ["\xA3\xB1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7B\xF1"],

        ["\x7B\xF2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA3\xB2"],
        ["\xA3\xB2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7B\xF2"],

        ["\x7B\xF3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA3\xB3"],
        ["\xA3\xB3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7B\xF3"],

        ["\x7B\xF4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA3\xB4"],
        ["\xA3\xB4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7B\xF4"],

        ["\x7B\xF5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA3\xB5"],
        ["\xA3\xB5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7B\xF5"],

        ["\x7B\xF6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA3\xB6"],
        ["\xA3\xB6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7B\xF6"],

        ["\x7B\xF7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA3\xB7"],
        ["\xA3\xB7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7B\xF7"],

        ["\x7B\xF8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA3\xB8"],
        ["\xA3\xB8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7B\xF8"],

        ["\x7B\xF9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA3\xB9"],
        ["\xA3\xB9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7B\xF9"],

        ["\x7B\xC1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA3\xC1"],
        ["\xA3\xC1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7B\xC1"],

        ["\x7B\xC2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA3\xC2"],
        ["\xA3\xC2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7B\xC2"],

        ["\x7B\xC3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA3\xC3"],
        ["\xA3\xC3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7B\xC3"],

        ["\x7B\xC4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA3\xC4"],
        ["\xA3\xC4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7B\xC4"],

        ["\x7B\xC5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA3\xC5"],
        ["\xA3\xC5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7B\xC5"],

        ["\x7B\xC6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA3\xC6"],
        ["\xA3\xC6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7B\xC6"],

        ["\x7B\xC7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA3\xC7"],
        ["\xA3\xC7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7B\xC7"],

        ["\x7B\xC8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA3\xC8"],
        ["\xA3\xC8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7B\xC8"],

        ["\x7B\xC9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA3\xC9"],
        ["\xA3\xC9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7B\xC9"],

        ["\x7B\xD1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA3\xCA"],
        ["\xA3\xCA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7B\xD1"],

        ["\x7B\xD2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA3\xCB"],
        ["\xA3\xCB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7B\xD2"],

        ["\x7B\xD3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA3\xCC"],
        ["\xA3\xCC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7B\xD3"],

        ["\x7B\xD4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA3\xCD"],
        ["\xA3\xCD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7B\xD4"],

        ["\x7B\xD5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA3\xCE"],
        ["\xA3\xCE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7B\xD5"],

        ["\x7B\xD6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA3\xCF"],
        ["\xA3\xCF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7B\xD6"],

        ["\x7B\xD7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA3\xD0"],
        ["\xA3\xD0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7B\xD7"],

        ["\x7B\xD8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA3\xD1"],
        ["\xA3\xD1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7B\xD8"],

        ["\x7B\xD9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA3\xD2"],
        ["\xA3\xD2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7B\xD9"],

        ["\x7B\xE2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA3\xD3"],
        ["\xA3\xD3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7B\xE2"],

        ["\x7B\xE3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA3\xD4"],
        ["\xA3\xD4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7B\xE3"],

        ["\x7B\xE4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA3\xD5"],
        ["\xA3\xD5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7B\xE4"],

        ["\x7B\xE5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA3\xD6"],
        ["\xA3\xD6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7B\xE5"],

        ["\x7B\xE6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA3\xD7"],
        ["\xA3\xD7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7B\xE6"],

        ["\x7B\xE7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA3\xD8"],
        ["\xA3\xD8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7B\xE7"],

        ["\x7B\xE8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA3\xD9"],
        ["\xA3\xD9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7B\xE8"],

        ["\x7B\xE9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA3\xDA"],
        ["\xA3\xDA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7B\xE9"],

        ["\x7B\x57",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA3\xE1"],
        ["\xA3\xE1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7B\x57"],

        ["\x7B\x59",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA3\xE2"],
        ["\xA3\xE2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7B\x59"],

        ["\x7B\x62",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA3\xE3"],
        ["\xA3\xE3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7B\x62"],

        ["\x7B\x63",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA3\xE4"],
        ["\xA3\xE4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7B\x63"],

        ["\x7B\x64",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA3\xE5"],
        ["\xA3\xE5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7B\x64"],

        ["\x7B\x65",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA3\xE6"],
        ["\xA3\xE6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7B\x65"],

        ["\x7B\x66",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA3\xE7"],
        ["\xA3\xE7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7B\x66"],

        ["\x7B\x67",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA3\xE8"],
        ["\xA3\xE8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7B\x67"],

        ["\x7B\x68",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA3\xE9"],
        ["\xA3\xE9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7B\x68"],

        ["\x7B\x69",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA3\xEA"],
        ["\xA3\xEA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7B\x69"],

        ["\x7B\x70",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA3\xEB"],
        ["\xA3\xEB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7B\x70"],

        ["\x7B\x71",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA3\xEC"],
        ["\xA3\xEC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7B\x71"],

        ["\x7B\x72",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA3\xED"],
        ["\xA3\xED",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7B\x72"],

        ["\x7B\x73",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA3\xEE"],
        ["\xA3\xEE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7B\x73"],

        ["\x7B\x74",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA3\xEF"],
        ["\xA3\xEF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7B\x74"],

        ["\x7B\x75",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA3\xF0"],
        ["\xA3\xF0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7B\x75"],

        ["\x7B\x76",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA3\xF1"],
        ["\xA3\xF1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7B\x76"],

        ["\x7B\x77",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA3\xF2"],
        ["\xA3\xF2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7B\x77"],

        ["\x7B\x78",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA3\xF3"],
        ["\xA3\xF3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7B\x78"],

        ["\x7B\x80",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA3\xF4"],
        ["\xA3\xF4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7B\x80"],

        ["\x7B\x8B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA3\xF5"],
        ["\xA3\xF5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7B\x8B"],

        ["\x7B\x9B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA3\xF6"],
        ["\xA3\xF6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7B\x9B"],

        ["\x7B\x9C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA3\xF7"],
        ["\xA3\xF7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7B\x9C"],

        ["\x7B\xA0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA3\xF8"],
        ["\xA3\xF8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7B\xA0"],

        ["\x7B\xAB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA3\xF9"],
        ["\xA3\xF9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7B\xAB"],

        ["\x7B\xB0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA3\xFA"],
        ["\xA3\xFA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7B\xB0"],

        ["\xE0\x4F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA4\xA1"],
        ["\xA4\xA1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE0\x4F"],

        ["\xE0\x7F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA4\xA2"],
        ["\xA4\xA2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE0\x7F"],

        ["\xE0\x7B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA4\xA3"],
        ["\xA4\xA3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE0\x7B"],

        ["\xE0\xE0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA4\xA4"],
        ["\xA4\xA4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xE0"],

        ["\xE0\x6C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA4\xA5"],
        ["\xA4\xA5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE0\x6C"],

        ["\xE0\x50",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA4\xA6"],
        ["\xA4\xA6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE0\x50"],

        ["\xE0\x7D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA4\xA7"],
        ["\xA4\xA7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE0\x7D"],

        ["\xE0\x4D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA4\xA8"],
        ["\xA4\xA8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE0\x4D"],

        ["\xE0\x5D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA4\xA9"],
        ["\xA4\xA9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE0\x5D"],

        ["\xE0\x5C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA4\xAA"],
        ["\xA4\xAA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE0\x5C"],

        ["\xE0\x4E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA4\xAB"],
        ["\xA4\xAB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE0\x4E"],

        ["\xE0\x6B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA4\xAC"],
        ["\xA4\xAC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE0\x6B"],

        ["\xE0\x60",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA4\xAD"],
        ["\xA4\xAD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE0\x60"],

        ["\xE0\x4B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA4\xAE"],
        ["\xA4\xAE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE0\x4B"],

        ["\xE0\x61",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA4\xAF"],
        ["\xA4\xAF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE0\x61"],

        ["\xE0\xF0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA4\xB0"],
        ["\xA4\xB0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xF0"],

        ["\xE0\xF1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA4\xB1"],
        ["\xA4\xB1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xF1"],

        ["\xE0\xF2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA4\xB2"],
        ["\xA4\xB2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xF2"],

        ["\xE0\xF3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA4\xB3"],
        ["\xA4\xB3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xF3"],

        ["\xE0\xF4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA4\xB4"],
        ["\xA4\xB4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xF4"],

        ["\xE0\xF5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA4\xB5"],
        ["\xA4\xB5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xF5"],

        ["\xE0\xF6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA4\xB6"],
        ["\xA4\xB6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xF6"],

        ["\xE0\xF7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA4\xB7"],
        ["\xA4\xB7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xF7"],

        ["\xE0\xF8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA4\xB8"],
        ["\xA4\xB8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xF8"],

        ["\xE0\xF9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA4\xB9"],
        ["\xA4\xB9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xF9"],

        ["\xE0\x7A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA4\xBA"],
        ["\xA4\xBA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE0\x7A"],

        ["\xE0\x5E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA4\xBB"],
        ["\xA4\xBB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE0\x5E"],

        ["\xE0\x4C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA4\xBC"],
        ["\xA4\xBC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE0\x4C"],

        ["\xE0\x7E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA4\xBD"],
        ["\xA4\xBD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE0\x7E"],

        ["\xE0\x6E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA4\xBE"],
        ["\xA4\xBE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE0\x6E"],

        ["\xE0\x6F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA4\xBF"],
        ["\xA4\xBF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE0\x6F"],

        ["\xE0\x7C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA4\xC0"],
        ["\xA4\xC0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE0\x7C"],

        ["\xE0\xC1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA4\xC1"],
        ["\xA4\xC1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xC1"],

        ["\xE0\xC2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA4\xC2"],
        ["\xA4\xC2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xC2"],

        ["\xE0\xC3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA4\xC3"],
        ["\xA4\xC3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xC3"],

        ["\xE0\xC4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA4\xC4"],
        ["\xA4\xC4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xC4"],

        ["\xE0\xC5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA4\xC5"],
        ["\xA4\xC5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xC5"],

        ["\xE0\xC6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA4\xC6"],
        ["\xA4\xC6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xC6"],

        ["\xE0\xC7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA4\xC7"],
        ["\xA4\xC7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xC7"],

        ["\xE0\xC8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA4\xC8"],
        ["\xA4\xC8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xC8"],

        ["\xE0\xC9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA4\xC9"],
        ["\xA4\xC9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xC9"],

        ["\xE0\xD1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA4\xCA"],
        ["\xA4\xCA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xD1"],

        ["\xE0\xD2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA4\xCB"],
        ["\xA4\xCB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xD2"],

        ["\xE0\xD3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA4\xCC"],
        ["\xA4\xCC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xD3"],

        ["\xE0\xD4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA4\xCD"],
        ["\xA4\xCD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xD4"],

        ["\xE0\xD5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA4\xCE"],
        ["\xA4\xCE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xD5"],

        ["\xE0\xD6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA4\xCF"],
        ["\xA4\xCF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xD6"],

        ["\xE0\xD7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA4\xD0"],
        ["\xA4\xD0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xD7"],

        ["\xE0\xD8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA4\xD1"],
        ["\xA4\xD1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xD8"],

        ["\xE0\xD9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA4\xD2"],
        ["\xA4\xD2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xD9"],

        ["\xE0\xE2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA4\xD3"],
        ["\xA4\xD3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xE2"],

        ["\xE0\xE3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA4\xD4"],
        ["\xA4\xD4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xE3"],

        ["\xE0\xE4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA4\xD5"],
        ["\xA4\xD5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xE4"],

        ["\xE0\xE5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA4\xD6"],
        ["\xA4\xD6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xE5"],

        ["\xE0\xE6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA4\xD7"],
        ["\xA4\xD7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xE6"],

        ["\xE0\xE7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA4\xD8"],
        ["\xA4\xD8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xE7"],

        ["\xE0\xE8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA4\xD9"],
        ["\xA4\xD9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xE8"],

        ["\xE0\xE9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA4\xDA"],
        ["\xA4\xDA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xE9"],

        ["\xE0\x4A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA4\xDB"],
        ["\xA4\xDB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE0\x4A"],

        ["\xE0\x5B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA4\xDC"],
        ["\xA4\xDC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE0\x5B"],

        ["\xE0\x5A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA4\xDD"],
        ["\xA4\xDD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE0\x5A"],

        ["\xE0\x5F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA4\xDE"],
        ["\xA4\xDE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE0\x5F"],

        ["\xE0\x6D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA4\xDF"],
        ["\xA4\xDF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE0\x6D"],

        ["\xE0\x79",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA4\xE0"],
        ["\xA4\xE0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE0\x79"],

        ["\xE0\x57",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA4\xE1"],
        ["\xA4\xE1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE0\x57"],

        ["\xE0\x59",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA4\xE2"],
        ["\xA4\xE2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE0\x59"],

        ["\xE0\x62",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA4\xE3"],
        ["\xA4\xE3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE0\x62"],

        ["\xE0\x63",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA4\xE4"],
        ["\xA4\xE4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE0\x63"],

        ["\xE0\x64",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA4\xE5"],
        ["\xA4\xE5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE0\x64"],

        ["\xE0\x65",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA4\xE6"],
        ["\xA4\xE6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE0\x65"],

        ["\xE0\x66",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA4\xE7"],
        ["\xA4\xE7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE0\x66"],

        ["\xE0\x67",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA4\xE8"],
        ["\xA4\xE8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE0\x67"],

        ["\xE0\x68",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA4\xE9"],
        ["\xA4\xE9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE0\x68"],

        ["\xE0\x69",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA4\xEA"],
        ["\xA4\xEA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE0\x69"],

        ["\xE0\x70",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA4\xEB"],
        ["\xA4\xEB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE0\x70"],

        ["\xE0\x71",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA4\xEC"],
        ["\xA4\xEC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE0\x71"],

        ["\xE0\x72",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA4\xED"],
        ["\xA4\xED",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE0\x72"],

        ["\xE0\x73",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA4\xEE"],
        ["\xA4\xEE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE0\x73"],

        ["\xE0\x74",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA4\xEF"],
        ["\xA4\xEF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE0\x74"],

        ["\xE0\x75",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA4\xF0"],
        ["\xA4\xF0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE0\x75"],

        ["\xE0\x76",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA4\xF1"],
        ["\xA4\xF1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE0\x76"],

        ["\xE0\x77",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA4\xF2"],
        ["\xA4\xF2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE0\x77"],

        ["\xE0\x78",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA4\xF3"],
        ["\xA4\xF3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE0\x78"],

        ["\x6C\x4F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA5\xA1"],
        ["\xA5\xA1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6C\x4F"],

        ["\x6C\x7F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA5\xA2"],
        ["\xA5\xA2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6C\x7F"],

        ["\x6C\x7B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA5\xA3"],
        ["\xA5\xA3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6C\x7B"],

        ["\x6C\xE0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA5\xA4"],
        ["\xA5\xA4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6C\xE0"],

        ["\x6C\x6C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA5\xA5"],
        ["\xA5\xA5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6C\x6C"],

        ["\x6C\x50",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA5\xA6"],
        ["\xA5\xA6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6C\x50"],

        ["\x6C\x7D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA5\xA7"],
        ["\xA5\xA7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6C\x7D"],

        ["\x6C\x4D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA5\xA8"],
        ["\xA5\xA8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6C\x4D"],

        ["\x6C\x5D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA5\xA9"],
        ["\xA5\xA9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6C\x5D"],

        ["\x6C\x5C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA5\xAA"],
        ["\xA5\xAA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6C\x5C"],

        ["\x6C\x4E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA5\xAB"],
        ["\xA5\xAB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6C\x4E"],

        ["\x6C\x6B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA5\xAC"],
        ["\xA5\xAC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6C\x6B"],

        ["\x6C\x60",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA5\xAD"],
        ["\xA5\xAD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6C\x60"],

        ["\x6C\x4B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA5\xAE"],
        ["\xA5\xAE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6C\x4B"],

        ["\x6C\x61",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA5\xAF"],
        ["\xA5\xAF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6C\x61"],

        ["\x6C\xF0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA5\xB0"],
        ["\xA5\xB0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6C\xF0"],

        ["\x6C\xF1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA5\xB1"],
        ["\xA5\xB1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6C\xF1"],

        ["\x6C\xF2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA5\xB2"],
        ["\xA5\xB2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6C\xF2"],

        ["\x6C\xF3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA5\xB3"],
        ["\xA5\xB3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6C\xF3"],

        ["\x6C\xF4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA5\xB4"],
        ["\xA5\xB4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6C\xF4"],

        ["\x6C\xF5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA5\xB5"],
        ["\xA5\xB5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6C\xF5"],

        ["\x6C\xF6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA5\xB6"],
        ["\xA5\xB6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6C\xF6"],

        ["\x6C\xF7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA5\xB7"],
        ["\xA5\xB7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6C\xF7"],

        ["\x6C\xF8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA5\xB8"],
        ["\xA5\xB8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6C\xF8"],

        ["\x6C\xF9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA5\xB9"],
        ["\xA5\xB9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6C\xF9"],

        ["\x6C\x7A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA5\xBA"],
        ["\xA5\xBA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6C\x7A"],

        ["\x6C\x5E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA5\xBB"],
        ["\xA5\xBB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6C\x5E"],

        ["\x6C\x4C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA5\xBC"],
        ["\xA5\xBC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6C\x4C"],

        ["\x6C\x7E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA5\xBD"],
        ["\xA5\xBD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6C\x7E"],

        ["\x6C\x6E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA5\xBE"],
        ["\xA5\xBE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6C\x6E"],

        ["\x6C\x6F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA5\xBF"],
        ["\xA5\xBF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6C\x6F"],

        ["\x6C\x7C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA5\xC0"],
        ["\xA5\xC0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6C\x7C"],

        ["\x6C\xC1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA5\xC1"],
        ["\xA5\xC1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6C\xC1"],

        ["\x6C\xC2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA5\xC2"],
        ["\xA5\xC2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6C\xC2"],

        ["\x6C\xC3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA5\xC3"],
        ["\xA5\xC3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6C\xC3"],

        ["\x6C\xC4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA5\xC4"],
        ["\xA5\xC4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6C\xC4"],

        ["\x6C\xC5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA5\xC5"],
        ["\xA5\xC5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6C\xC5"],

        ["\x6C\xC6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA5\xC6"],
        ["\xA5\xC6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6C\xC6"],

        ["\x6C\xC7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA5\xC7"],
        ["\xA5\xC7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6C\xC7"],

        ["\x6C\xC8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA5\xC8"],
        ["\xA5\xC8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6C\xC8"],

        ["\x6C\xC9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA5\xC9"],
        ["\xA5\xC9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6C\xC9"],

        ["\x6C\xD1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA5\xCA"],
        ["\xA5\xCA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6C\xD1"],

        ["\x6C\xD2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA5\xCB"],
        ["\xA5\xCB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6C\xD2"],

        ["\x6C\xD3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA5\xCC"],
        ["\xA5\xCC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6C\xD3"],

        ["\x6C\xD4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA5\xCD"],
        ["\xA5\xCD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6C\xD4"],

        ["\x6C\xD5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA5\xCE"],
        ["\xA5\xCE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6C\xD5"],

        ["\x6C\xD6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA5\xCF"],
        ["\xA5\xCF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6C\xD6"],

        ["\x6C\xD7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA5\xD0"],
        ["\xA5\xD0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6C\xD7"],

        ["\x6C\xD8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA5\xD1"],
        ["\xA5\xD1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6C\xD8"],

        ["\x6C\xD9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA5\xD2"],
        ["\xA5\xD2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6C\xD9"],

        ["\x6C\xE2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA5\xD3"],
        ["\xA5\xD3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6C\xE2"],

        ["\x6C\xE3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA5\xD4"],
        ["\xA5\xD4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6C\xE3"],

        ["\x6C\xE4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA5\xD5"],
        ["\xA5\xD5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6C\xE4"],

        ["\x6C\xE5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA5\xD6"],
        ["\xA5\xD6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6C\xE5"],

        ["\x6C\xE6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA5\xD7"],
        ["\xA5\xD7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6C\xE6"],

        ["\x6C\xE7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA5\xD8"],
        ["\xA5\xD8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6C\xE7"],

        ["\x6C\xE8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA5\xD9"],
        ["\xA5\xD9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6C\xE8"],

        ["\x6C\xE9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA5\xDA"],
        ["\xA5\xDA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6C\xE9"],

        ["\x6C\x4A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA5\xDB"],
        ["\xA5\xDB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6C\x4A"],

        ["\x6C\x5B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA5\xDC"],
        ["\xA5\xDC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6C\x5B"],

        ["\x6C\x5A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA5\xDD"],
        ["\xA5\xDD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6C\x5A"],

        ["\x6C\x5F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA5\xDE"],
        ["\xA5\xDE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6C\x5F"],

        ["\x6C\x6D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA5\xDF"],
        ["\xA5\xDF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6C\x6D"],

        ["\x6C\x79",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA5\xE0"],
        ["\xA5\xE0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6C\x79"],

        ["\x6C\x57",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA5\xE1"],
        ["\xA5\xE1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6C\x57"],

        ["\x6C\x59",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA5\xE2"],
        ["\xA5\xE2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6C\x59"],

        ["\x6C\x62",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA5\xE3"],
        ["\xA5\xE3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6C\x62"],

        ["\x6C\x63",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA5\xE4"],
        ["\xA5\xE4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6C\x63"],

        ["\x6C\x64",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA5\xE5"],
        ["\xA5\xE5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6C\x64"],

        ["\x6C\x65",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA5\xE6"],
        ["\xA5\xE6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6C\x65"],

        ["\x6C\x66",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA5\xE7"],
        ["\xA5\xE7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6C\x66"],

        ["\x6C\x67",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA5\xE8"],
        ["\xA5\xE8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6C\x67"],

        ["\x6C\x68",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA5\xE9"],
        ["\xA5\xE9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6C\x68"],

        ["\x6C\x69",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA5\xEA"],
        ["\xA5\xEA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6C\x69"],

        ["\x6C\x70",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA5\xEB"],
        ["\xA5\xEB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6C\x70"],

        ["\x6C\x71",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA5\xEC"],
        ["\xA5\xEC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6C\x71"],

        ["\x6C\x72",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA5\xED"],
        ["\xA5\xED",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6C\x72"],

        ["\x6C\x73",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA5\xEE"],
        ["\xA5\xEE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6C\x73"],

        ["\x6C\x74",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA5\xEF"],
        ["\xA5\xEF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6C\x74"],

        ["\x6C\x75",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA5\xF0"],
        ["\xA5\xF0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6C\x75"],

        ["\x6C\x76",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA5\xF1"],
        ["\xA5\xF1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6C\x76"],

        ["\x6C\x77",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA5\xF2"],
        ["\xA5\xF2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6C\x77"],

        ["\x6C\x78",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA5\xF3"],
        ["\xA5\xF3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6C\x78"],

        ["\x6C\x80",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA5\xF4"],
        ["\xA5\xF4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6C\x80"],

        ["\x6C\x8B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA5\xF5"],
        ["\xA5\xF5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6C\x8B"],

        ["\x6C\x9B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA5\xF6"],
        ["\xA5\xF6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6C\x9B"],

        ["\x50\x4F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA6\xA1"],
        ["\xA6\xA1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x50\x4F"],

        ["\x50\x7F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA6\xA2"],
        ["\xA6\xA2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x50\x7F"],

        ["\x50\x7B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA6\xA3"],
        ["\xA6\xA3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x50\x7B"],

        ["\x50\xE0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA6\xA4"],
        ["\xA6\xA4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x50\xE0"],

        ["\x50\x6C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA6\xA5"],
        ["\xA6\xA5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x50\x6C"],

        ["\x50\x50",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA6\xA6"],
        ["\xA6\xA6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x50\x50"],

        ["\x50\x7D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA6\xA7"],
        ["\xA6\xA7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x50\x7D"],

        ["\x50\x4D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA6\xA8"],
        ["\xA6\xA8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x50\x4D"],

        ["\x50\x5D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA6\xA9"],
        ["\xA6\xA9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x50\x5D"],

        ["\x50\x5C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA6\xAA"],
        ["\xA6\xAA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x50\x5C"],

        ["\x50\x4E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA6\xAB"],
        ["\xA6\xAB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x50\x4E"],

        ["\x50\x6B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA6\xAC"],
        ["\xA6\xAC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x50\x6B"],

        ["\x50\x60",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA6\xAD"],
        ["\xA6\xAD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x50\x60"],

        ["\x50\x4B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA6\xAE"],
        ["\xA6\xAE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x50\x4B"],

        ["\x50\x61",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA6\xAF"],
        ["\xA6\xAF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x50\x61"],

        ["\x50\xF0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA6\xB0"],
        ["\xA6\xB0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x50\xF0"],

        ["\x50\xF1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA6\xB1"],
        ["\xA6\xB1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x50\xF1"],

        ["\x50\xF2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA6\xB2"],
        ["\xA6\xB2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x50\xF2"],

        ["\x50\xF3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA6\xB3"],
        ["\xA6\xB3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x50\xF3"],

        ["\x50\xF4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA6\xB4"],
        ["\xA6\xB4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x50\xF4"],

        ["\x50\xF5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA6\xB5"],
        ["\xA6\xB5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x50\xF5"],

        ["\x50\xF6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA6\xB6"],
        ["\xA6\xB6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x50\xF6"],

        ["\x50\xF7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA6\xB7"],
        ["\xA6\xB7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x50\xF7"],

        ["\x50\xF8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA6\xB8"],
        ["\xA6\xB8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x50\xF8"],

        ["\x50\xC1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA6\xC1"],
        ["\xA6\xC1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x50\xC1"],

        ["\x50\xC2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA6\xC2"],
        ["\xA6\xC2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x50\xC2"],

        ["\x50\xC3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA6\xC3"],
        ["\xA6\xC3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x50\xC3"],

        ["\x50\xC4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA6\xC4"],
        ["\xA6\xC4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x50\xC4"],

        ["\x50\xC5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA6\xC5"],
        ["\xA6\xC5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x50\xC5"],

        ["\x50\xC6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA6\xC6"],
        ["\xA6\xC6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x50\xC6"],

        ["\x50\xC7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA6\xC7"],
        ["\xA6\xC7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x50\xC7"],

        ["\x50\xC8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA6\xC8"],
        ["\xA6\xC8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x50\xC8"],

        ["\x50\xC9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA6\xC9"],
        ["\xA6\xC9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x50\xC9"],

        ["\x50\xD1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA6\xCA"],
        ["\xA6\xCA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x50\xD1"],

        ["\x50\xD2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA6\xCB"],
        ["\xA6\xCB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x50\xD2"],

        ["\x50\xD3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA6\xCC"],
        ["\xA6\xCC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x50\xD3"],

        ["\x50\xD4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA6\xCD"],
        ["\xA6\xCD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x50\xD4"],

        ["\x50\xD5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA6\xCE"],
        ["\xA6\xCE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x50\xD5"],

        ["\x50\xD6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA6\xCF"],
        ["\xA6\xCF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x50\xD6"],

        ["\x50\xD7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA6\xD0"],
        ["\xA6\xD0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x50\xD7"],

        ["\x50\xD8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA6\xD1"],
        ["\xA6\xD1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x50\xD8"],

        ["\x50\xD9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA6\xD2"],
        ["\xA6\xD2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x50\xD9"],

        ["\x50\xE2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA6\xD3"],
        ["\xA6\xD3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x50\xE2"],

        ["\x50\xE3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA6\xD4"],
        ["\xA6\xD4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x50\xE3"],

        ["\x50\xE4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA6\xD5"],
        ["\xA6\xD5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x50\xE4"],

        ["\x50\xE5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA6\xD6"],
        ["\xA6\xD6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x50\xE5"],

        ["\x50\xE6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA6\xD7"],
        ["\xA6\xD7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x50\xE6"],

        ["\x50\xE7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA6\xD8"],
        ["\xA6\xD8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x50\xE7"],

        ["\x7D\x4F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA7\xA1"],
        ["\xA7\xA1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7D\x4F"],

        ["\x7D\x7F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA7\xA2"],
        ["\xA7\xA2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7D\x7F"],

        ["\x7D\x7B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA7\xA3"],
        ["\xA7\xA3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7D\x7B"],

        ["\x7D\xE0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA7\xA4"],
        ["\xA7\xA4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7D\xE0"],

        ["\x7D\x6C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA7\xA5"],
        ["\xA7\xA5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7D\x6C"],

        ["\x7D\x50",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA7\xA6"],
        ["\xA7\xA6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7D\x50"],

        ["\x7D\x7D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA7\xA7"],
        ["\xA7\xA7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7D\x7D"],

        ["\x7D\x4D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA7\xA8"],
        ["\xA7\xA8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7D\x4D"],

        ["\x7D\x5D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA7\xA9"],
        ["\xA7\xA9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7D\x5D"],

        ["\x7D\x5C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA7\xAA"],
        ["\xA7\xAA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7D\x5C"],

        ["\x7D\x4E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA7\xAB"],
        ["\xA7\xAB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7D\x4E"],

        ["\x7D\x6B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA7\xAC"],
        ["\xA7\xAC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7D\x6B"],

        ["\x7D\x60",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA7\xAD"],
        ["\xA7\xAD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7D\x60"],

        ["\x7D\x4B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA7\xAE"],
        ["\xA7\xAE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7D\x4B"],

        ["\x7D\x61",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA7\xAF"],
        ["\xA7\xAF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7D\x61"],

        ["\x7D\xF0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA7\xB0"],
        ["\xA7\xB0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7D\xF0"],

        ["\x7D\xF1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA7\xB1"],
        ["\xA7\xB1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7D\xF1"],

        ["\x7D\xF2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA7\xB2"],
        ["\xA7\xB2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7D\xF2"],

        ["\x7D\xF3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA7\xB3"],
        ["\xA7\xB3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7D\xF3"],

        ["\x7D\xF4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA7\xB4"],
        ["\xA7\xB4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7D\xF4"],

        ["\x7D\xF5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA7\xB5"],
        ["\xA7\xB5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7D\xF5"],

        ["\x7D\xF6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA7\xB6"],
        ["\xA7\xB6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7D\xF6"],

        ["\x7D\xF7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA7\xB7"],
        ["\xA7\xB7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7D\xF7"],

        ["\x7D\xF8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA7\xB8"],
        ["\xA7\xB8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7D\xF8"],

        ["\x7D\xF9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA7\xB9"],
        ["\xA7\xB9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7D\xF9"],

        ["\x7D\x7A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA7\xBA"],
        ["\xA7\xBA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7D\x7A"],

        ["\x7D\x5E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA7\xBB"],
        ["\xA7\xBB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7D\x5E"],

        ["\x7D\x4C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA7\xBC"],
        ["\xA7\xBC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7D\x4C"],

        ["\x7D\x7E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA7\xBD"],
        ["\xA7\xBD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7D\x7E"],

        ["\x7D\x6E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA7\xBE"],
        ["\xA7\xBE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7D\x6E"],

        ["\x7D\x6F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA7\xBF"],
        ["\xA7\xBF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7D\x6F"],

        ["\x7D\x7C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA7\xC0"],
        ["\xA7\xC0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7D\x7C"],

        ["\x7D\xC1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA7\xC1"],
        ["\xA7\xC1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7D\xC1"],

        ["\x7D\xD8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA7\xD1"],
        ["\xA7\xD1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7D\xD8"],

        ["\x7D\xD9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA7\xD2"],
        ["\xA7\xD2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7D\xD9"],

        ["\x7D\xE2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA7\xD3"],
        ["\xA7\xD3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7D\xE2"],

        ["\x7D\xE3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA7\xD4"],
        ["\xA7\xD4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7D\xE3"],

        ["\x7D\xE4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA7\xD5"],
        ["\xA7\xD5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7D\xE4"],

        ["\x7D\xE5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA7\xD6"],
        ["\xA7\xD6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7D\xE5"],

        ["\x7D\xE6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA7\xD7"],
        ["\xA7\xD7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7D\xE6"],

        ["\x7D\xE7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA7\xD8"],
        ["\xA7\xD8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7D\xE7"],

        ["\x7D\xE8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA7\xD9"],
        ["\xA7\xD9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7D\xE8"],

        ["\x7D\xE9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA7\xDA"],
        ["\xA7\xDA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7D\xE9"],

        ["\x7D\x4A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA7\xDB"],
        ["\xA7\xDB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7D\x4A"],

        ["\x7D\x5B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA7\xDC"],
        ["\xA7\xDC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7D\x5B"],

        ["\x7D\x5A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA7\xDD"],
        ["\xA7\xDD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7D\x5A"],

        ["\x7D\x5F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA7\xDE"],
        ["\xA7\xDE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7D\x5F"],

        ["\x7D\x6D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA7\xDF"],
        ["\xA7\xDF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7D\x6D"],

        ["\x7D\x79",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA7\xE0"],
        ["\xA7\xE0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7D\x79"],

        ["\x7D\x57",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA7\xE1"],
        ["\xA7\xE1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7D\x57"],

        ["\x7D\x59",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA7\xE2"],
        ["\xA7\xE2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7D\x59"],

        ["\x7D\x62",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA7\xE3"],
        ["\xA7\xE3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7D\x62"],

        ["\x7D\x63",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA7\xE4"],
        ["\xA7\xE4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7D\x63"],

        ["\x7D\x64",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA7\xE5"],
        ["\xA7\xE5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7D\x64"],

        ["\x7D\x65",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA7\xE6"],
        ["\xA7\xE6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7D\x65"],

        ["\x7D\x66",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA7\xE7"],
        ["\xA7\xE7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7D\x66"],

        ["\x7D\x67",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA7\xE8"],
        ["\xA7\xE8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7D\x67"],

        ["\x7D\x68",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA7\xE9"],
        ["\xA7\xE9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7D\x68"],

        ["\x7D\x69",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA7\xEA"],
        ["\xA7\xEA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7D\x69"],

        ["\x7D\x70",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA7\xEB"],
        ["\xA7\xEB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7D\x70"],

        ["\x7D\x71",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA7\xEC"],
        ["\xA7\xEC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7D\x71"],

        ["\x7D\x72",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA7\xED"],
        ["\xA7\xED",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7D\x72"],

        ["\x7D\x73",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA7\xEE"],
        ["\xA7\xEE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7D\x73"],

        ["\x7D\x74",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA7\xEF"],
        ["\xA7\xEF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7D\x74"],

        ["\x7D\x75",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA7\xF0"],
        ["\xA7\xF0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7D\x75"],

        ["\x7D\x76",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA7\xF1"],
        ["\xA7\xF1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7D\x76"],

        ["\x6B\xE0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA8\xA1"],
        ["\xA8\xA1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6B\xE0"],

        ["\x6B\x50",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA8\xA2"],
        ["\xA8\xA2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6B\x50"],

        ["\x6B\xF0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA8\xA3"],
        ["\xA8\xA3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6B\xF0"],

        ["\x6B\xF4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA8\xA4"],
        ["\xA8\xA4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6B\xF4"],

        ["\x6B\x4C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA8\xA5"],
        ["\xA8\xA5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6B\x4C"],

        ["\x6B\xF8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA8\xA6"],
        ["\xA8\xA6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6B\xF8"],

        ["\x6B\x7C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA8\xA7"],
        ["\xA8\xA7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6B\x7C"],

        ["\x6B\xD7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA8\xA8"],
        ["\xA8\xA8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6B\xD7"],

        ["\x6B\xC8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA8\xA9"],
        ["\xA8\xA9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6B\xC8"],

        ["\x6B\xE7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA8\xAA"],
        ["\xA8\xAA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6B\xE7"],

        ["\x6B\x79",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA8\xAB"],
        ["\xA8\xAB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6B\x79"],

        ["\x6B\x6C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA8\xAC"],
        ["\xA8\xAC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6B\x6C"],

        ["\x6B\x7D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA8\xAD"],
        ["\xA8\xAD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6B\x7D"],

        ["\x6B\xF3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA8\xAE"],
        ["\xA8\xAE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6B\xF3"],

        ["\x6B\xF7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA8\xAF"],
        ["\xA8\xAF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6B\xF7"],

        ["\x6B\x6F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA8\xB0"],
        ["\xA8\xB0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6B\x6F"],

        ["\x6B\x5E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA8\xB1"],
        ["\xA8\xB1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6B\x5E"],

        ["\x6B\xC7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA8\xB2"],
        ["\xA8\xB2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6B\xC7"],

        ["\x6B\xE6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA8\xB3"],
        ["\xA8\xB3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6B\xE6"],

        ["\x6B\xD6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA8\xB4"],
        ["\xA8\xB4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6B\xD6"],

        ["\x6B\x6D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA8\xB5"],
        ["\xA8\xB5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6B\x6D"],

        ["\x6B\x74",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA8\xB6"],
        ["\xA8\xB6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6B\x74"],

        ["\x6B\xC4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA8\xB7"],
        ["\xA8\xB7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6B\xC4"],

        ["\x6B\xE2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA8\xB8"],
        ["\xA8\xB8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6B\xE2"],

        ["\x6B\xD3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA8\xB9"],
        ["\xA8\xB9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6B\xD3"],

        ["\x6B\x4A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA8\xBA"],
        ["\xA8\xBA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6B\x4A"],

        ["\x6B\x62",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA8\xBB"],
        ["\xA8\xBB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6B\x62"],

        ["\x6B\xC1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA8\xBC"],
        ["\xA8\xBC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6B\xC1"],

        ["\x6B\xE3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA8\xBD"],
        ["\xA8\xBD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6B\xE3"],

        ["\x6B\xC9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA8\xBE"],
        ["\xA8\xBE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6B\xC9"],

        ["\x6B\x5B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA8\xBF"],
        ["\xA8\xBF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6B\x5B"],

        ["\x6B\x65",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA8\xC0"],
        ["\xA8\xC0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6B\x65"],

        ["\x60\x4F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\x31\xA7"],
        ["\x31\xA7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x60\x4F"],

        ["\x60\x7F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\x31\xA8"],
        ["\x31\xA8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x60\x7F"],

        ["\x60\x7B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\x31\xA9"],
        ["\x31\xA9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x60\x7B"],

        ["\x60\xE0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\x31\xAA"],
        ["\x31\xAA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x60\xE0"],

        ["\x60\x6C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\x31\xAB"],
        ["\x31\xAB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x60\x6C"],

        ["\x60\x50",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\x31\xAC"],
        ["\x31\xAC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x60\x50"],

        ["\x60\x7D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\x31\xAD"],
        ["\x31\xAD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x60\x7D"],

        ["\x60\x4D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\x31\xAE"],
        ["\x31\xAE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x60\x4D"],

        ["\x60\x5D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\x31\xAF"],
        ["\x31\xAF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x60\x5D"],

        ["\x60\x5C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\x31\xB0"],
        ["\x31\xB0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x60\x5C"],

        ["\x60\x4E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\x31\xB1"],
        ["\x31\xB1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x60\x4E"],

        ["\x60\x6B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\x31\xB2"],
        ["\x31\xB2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x60\x6B"],

        ["\x60\x60",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\x31\xB3"],
        ["\x31\xB3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x60\x60"],

        ["\x60\x4B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\x31\xB4"],
        ["\x31\xB4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x60\x4B"],

        ["\x60\x61",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\x31\xB5"],
        ["\x31\xB5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x60\x61"],

        ["\x60\xF0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\x31\xB6"],
        ["\x31\xB6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x60\xF0"],

        ["\x60\xF1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\x31\xB7"],
        ["\x31\xB7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x60\xF1"],

        ["\x60\xF2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\x31\xB8"],
        ["\x31\xB8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x60\xF2"],

        ["\x60\xF3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\x31\xB9"],
        ["\x31\xB9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x60\xF3"],

        ["\x60\xF4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\x31\xBA"],
        ["\x31\xBA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x60\xF4"],

        ["\x60\xF5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\x31\xBB"],
        ["\x31\xBB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x60\xF5"],

        ["\x60\xF6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\x31\xBC"],
        ["\x31\xBC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x60\xF6"],

        ["\x60\xF7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\x31\xBD"],
        ["\x31\xBD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x60\xF7"],

        ["\x60\xF8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\x31\xBE"],
        ["\x31\xBE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x60\xF8"],

        ["\x60\xF9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\x31\xBF"],
        ["\x31\xBF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x60\xF9"],

        ["\x60\x7A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\x31\xC0"],
        ["\x31\xC0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x60\x7A"],

        ["\x60\x5E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\x31\xC1"],
        ["\x31\xC1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x60\x5E"],

        ["\x60\x4C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\x31\xC2"],
        ["\x31\xC2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x60\x4C"],

        ["\x60\x7E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\x31\xC3"],
        ["\x31\xC3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x60\x7E"],

        ["\x60\x6E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\x31\xC4"],
        ["\x31\xC4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x60\x6E"],

        ["\x60\x7C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\x31\xC5"],
        ["\x31\xC5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x60\x7C"],

        ["\x60\xC1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\x31\xC6"],
        ["\x31\xC6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x60\xC1"],

        ["\x60\xC2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\x31\xC7"],
        ["\x31\xC7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x60\xC2"],

        ["\x60\xC3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\x31\xC8"],
        ["\x31\xC8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x60\xC3"],

        ["\x60\xC4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\x31\xC9"],
        ["\x31\xC9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x60\xC4"],

        ["\x60\xC5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\x31\xCA"],
        ["\x31\xCA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x60\xC5"],

        ["\x60\xC6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\x31\xCB"],
        ["\x31\xCB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x60\xC6"],

        ["\x60\xC7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\x31\xCC"],
        ["\x31\xCC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x60\xC7"],

        ["\x60\xC8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\x31\xCD"],
        ["\x31\xCD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x60\xC8"],

        ["\x60\xC9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\x31\xCE"],
        ["\x31\xCE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x60\xC9"],

        ["\x60\xD1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\x31\xCF"],
        ["\x31\xCF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x60\xD1"],

        ["\x60\xD2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\x31\xD0"],
        ["\x31\xD0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x60\xD2"],

        ["\x60\xD3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\x31\xD1"],
        ["\x31\xD1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x60\xD3"],

        ["\x60\xD4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\x31\xD2"],
        ["\x31\xD2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x60\xD4"],

        ["\x60\xD5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\x31\xD3"],
        ["\x31\xD3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x60\xD5"],

        ["\x60\xD6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\x31\xD4"],
        ["\x31\xD4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x60\xD6"],

        ["\x60\xD7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\x31\xD5"],
        ["\x31\xD5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x60\xD7"],

        ["\x60\xD8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\x31\xD6"],
        ["\x31\xD6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x60\xD8"],

        ["\x60\xD9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\x31\xD7"],
        ["\x31\xD7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x60\xD9"],

        ["\x60\xE2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\x31\xD8"],
        ["\x31\xD8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x60\xE2"],

        ["\x60\xE3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\x31\xD9"],
        ["\x31\xD9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x60\xE3"],

        ["\x60\xE4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\x31\xDA"],
        ["\x31\xDA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x60\xE4"],

        ["\x60\xE5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\x31\xDB"],
        ["\x31\xDB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x60\xE5"],

        ["\x60\x6D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\x31\xDC"],
        ["\x31\xDC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x60\x6D"],

        ["\x60\x79",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\x31\xDD"],
        ["\x31\xDD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x60\x79"],

        ["\x60\x57",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\x31\xDE"],
        ["\x31\xDE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x60\x57"],

        ["\x60\x59",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xA2\x71"],
        ["\xA2\x71",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x60\x59"],

        ["\x60\x62",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\x31\xDF"],
        ["\x31\xDF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x60\x62"],

        ["\x60\x63",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\x31\xE0"],
        ["\x31\xE0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x60\x63"],

        ["\x60\x64",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\x31\xE1"],
        ["\x31\xE1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x60\x64"],

        ["\x60\x65",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\x31\xE2"],
        ["\x31\xE2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x60\x65"],

        ["\x60\x66",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\x31\xE3"],
        ["\x31\xE3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x60\x66"],

        ["\x60\x67",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\x31\xE4"],
        ["\x31\xE4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x60\x67"],

        ["\x60\x68",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\x31\xE5"],
        ["\x31\xE5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x60\x68"],

        ["\x60\x69",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\x31\xE6"],
        ["\x31\xE6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x60\x69"],

        ["\x60\x70",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\x31\xE7"],
        ["\x31\xE7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x60\x70"],

        ["\x60\x71",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\x31\xE8"],
        ["\x31\xE8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x60\x71"],

        ["\x60\x72",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\x31\xE9"],
        ["\x31\xE9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x60\x72"],

        ["\x60\x73",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\x31\xEA"],
        ["\x31\xEA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x60\x73"],

        ["\x60\x74",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\x31\xEB"],
        ["\x31\xEB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x60\x74"],

        ["\x60\x78",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\x31\xEC"],
        ["\x31\xEC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x60\x78"],

        ["\x60\x80",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\x31\xED"],
        ["\x31\xED",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x60\x80"],

        ["\x60\xA0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\x31\xEE"],
        ["\x31\xEE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x60\xA0"],

        ["\x60\xAB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\x31\xEF"],
        ["\x31\xEF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x60\xAB"],

        ["\xF0\x4F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xA1"],
        ["\xB0\xA1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\x4F"],

        ["\xF0\x7F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xA2"],
        ["\xB0\xA2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\x7F"],

        ["\xF0\x7B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xA3"],
        ["\xB0\xA3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\x7B"],

        ["\xF0\xE0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xA4"],
        ["\xB0\xA4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xE0"],

        ["\xF0\x6C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xA5"],
        ["\xB0\xA5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\x6C"],

        ["\xF0\x50",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xA6"],
        ["\xB0\xA6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\x50"],

        ["\xF0\x7D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xA7"],
        ["\xB0\xA7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\x7D"],

        ["\xF0\x4D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xA8"],
        ["\xB0\xA8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\x4D"],

        ["\xF0\x5D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xA9"],
        ["\xB0\xA9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\x5D"],

        ["\xF0\x5C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xAA"],
        ["\xB0\xAA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\x5C"],

        ["\xF0\x4E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xAB"],
        ["\xB0\xAB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\x4E"],

        ["\xF0\x6B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xAC"],
        ["\xB0\xAC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\x6B"],

        ["\xF0\x60",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xAD"],
        ["\xB0\xAD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\x60"],

        ["\xF0\x4B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xAE"],
        ["\xB0\xAE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\x4B"],

        ["\xF0\x61",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xAF"],
        ["\xB0\xAF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\x61"],

        ["\xF0\xF0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xB0"],
        ["\xB0\xB0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xF0"],

        ["\xF0\xF1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xB1"],
        ["\xB0\xB1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xF1"],

        ["\xF0\xF2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xB2"],
        ["\xB0\xB2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xF2"],

        ["\x77\xD4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xB3"],
        ["\xB0\xB3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x77\xD4"],

        ["\xF0\xF4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xB4"],
        ["\xB0\xB4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xF4"],

        ["\xF0\xF5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xB5"],
        ["\xB0\xB5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xF5"],

        ["\xF0\xF6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xB6"],
        ["\xB0\xB6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xF6"],

        ["\xF0\xF7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xB7"],
        ["\xB0\xB7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xF7"],

        ["\xF0\xF8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xB8"],
        ["\xB0\xB8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xF8"],

        ["\xF0\xF9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xB9"],
        ["\xB0\xB9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xF9"],

        ["\xF0\x7A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xBA"],
        ["\xB0\xBA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\x7A"],

        ["\xF0\x5E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xBB"],
        ["\xB0\xBB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\x5E"],

        ["\xF0\x4C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xBC"],
        ["\xB0\xBC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\x4C"],

        ["\xF0\x7E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xBD"],
        ["\xB0\xBD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\x7E"],

        ["\xF0\x6E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xBE"],
        ["\xB0\xBE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\x6E"],

        ["\xF0\x6F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xBF"],
        ["\xB0\xBF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\x6F"],

        ["\xF0\x7C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xC0"],
        ["\xB0\xC0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\x7C"],

        ["\xF0\xC1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xC1"],
        ["\xB0\xC1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xC1"],

        ["\xF0\xC2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xC2"],
        ["\xB0\xC2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xC2"],

        ["\xF0\xC3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xC3"],
        ["\xB0\xC3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xC3"],

        ["\xF0\xC4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xC4"],
        ["\xB0\xC4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xC4"],

        ["\xF0\xC5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xC5"],
        ["\xB0\xC5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xC5"],

        ["\xF0\xC6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xC6"],
        ["\xB0\xC6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xC6"],

        ["\xF0\xC7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xC7"],
        ["\xB0\xC7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xC7"],

        ["\xF0\xC8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xC8"],
        ["\xB0\xC8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xC8"],

        ["\xF0\xC9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xC9"],
        ["\xB0\xC9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xC9"],

        ["\xF0\xD1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xCA"],
        ["\xB0\xCA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xD1"],

        ["\xF0\xD2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xCB"],
        ["\xB0\xCB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xD2"],

        ["\xF0\xD3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xCC"],
        ["\xB0\xCC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xD3"],

        ["\xF0\xD4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xCD"],
        ["\xB0\xCD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xD4"],

        ["\xF0\xD5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xCE"],
        ["\xB0\xCE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xD5"],

        ["\xF0\xD6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xCF"],
        ["\xB0\xCF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xD6"],

        ["\xF0\xD7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xD0"],
        ["\xB0\xD0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xD7"],

        ["\xF0\xD8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xD1"],
        ["\xB0\xD1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xD8"],

        ["\xF0\xD9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xD2"],
        ["\xB0\xD2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xD9"],

        ["\xF0\xE2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xD3"],
        ["\xB0\xD3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xE2"],

        ["\xF0\xE3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xD4"],
        ["\xB0\xD4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xE3"],

        ["\xF0\xE4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xD5"],
        ["\xB0\xD5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xE4"],

        ["\xF0\xE5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xD6"],
        ["\xB0\xD6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xE5"],

        ["\xF0\xE6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xD7"],
        ["\xB0\xD7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xE6"],

        ["\xF0\xE7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xD8"],
        ["\xB0\xD8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xE7"],

        ["\xF0\xE8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xD9"],
        ["\xB0\xD9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xE8"],

        ["\xF0\xE9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xDA"],
        ["\xB0\xDA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xE9"],

        ["\xF0\x4A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xDB"],
        ["\xB0\xDB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\x4A"],

        ["\xF0\x5B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xDC"],
        ["\xB0\xDC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\x5B"],

        ["\xF0\x5A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xDD"],
        ["\xB0\xDD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\x5A"],

        ["\xF0\x5F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xDE"],
        ["\xB0\xDE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\x5F"],

        ["\xF0\x6D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xDF"],
        ["\xB0\xDF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\x6D"],

        ["\xF0\x79",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xE0"],
        ["\xB0\xE0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\x79"],

        ["\xF0\x57",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xE1"],
        ["\xB0\xE1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\x57"],

        ["\xF0\x59",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xE2"],
        ["\xB0\xE2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\x59"],

        ["\xF0\x62",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xE3"],
        ["\xB0\xE3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\x62"],

        ["\xF0\x63",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xE4"],
        ["\xB0\xE4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\x63"],

        ["\xF0\x64",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xE5"],
        ["\xB0\xE5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\x64"],

        ["\xF0\x65",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xE6"],
        ["\xB0\xE6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\x65"],

        ["\xF0\x66",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xE7"],
        ["\xB0\xE7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\x66"],

        ["\xF0\x67",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xE8"],
        ["\xB0\xE8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\x67"],

        ["\xF0\x68",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xE9"],
        ["\xB0\xE9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\x68"],

        ["\xF0\x69",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xEA"],
        ["\xB0\xEA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\x69"],

        ["\xF0\x70",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xEB"],
        ["\xB0\xEB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\x70"],

        ["\xF0\x71",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xEC"],
        ["\xB0\xEC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\x71"],

        ["\xF0\x72",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xED"],
        ["\xB0\xED",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\x72"],

        ["\xF0\x73",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xEE"],
        ["\xB0\xEE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\x73"],

        ["\xF0\x74",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xEF"],
        ["\xB0\xEF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\x74"],

        ["\xF0\x75",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xF0"],
        ["\xB0\xF0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\x75"],

        ["\xF0\x76",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xF1"],
        ["\xB0\xF1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\x76"],

        ["\xF0\x77",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xF2"],
        ["\xB0\xF2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\x77"],

        ["\xF0\x78",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xF3"],
        ["\xB0\xF3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\x78"],

        ["\xF0\x80",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xF4"],
        ["\xB0\xF4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\x80"],

        ["\xF0\x8B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xF5"],
        ["\xB0\xF5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\x8B"],

        ["\xF0\x9B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xF6"],
        ["\xB0\xF6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\x9B"],

        ["\xF0\x9C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xF7"],
        ["\xB0\xF7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\x9C"],

        ["\xF0\xA0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xF8"],
        ["\xB0\xF8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xA0"],

        ["\xF0\xAB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xF9"],
        ["\xB0\xF9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xAB"],

        ["\xF0\xB0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xFA"],
        ["\xB0\xFA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xB0"],

        ["\xF0\xC0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xFB"],
        ["\xB0\xFB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xC0"],

        ["\xF0\x6A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xFC"],
        ["\xB0\xFC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\x6A"],

        ["\xF0\xD0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xFD"],
        ["\xB0\xFD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xD0"],

        ["\xF0\xA1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\xFE"],
        ["\xB0\xFE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xA1"],

        ["\xF1\x4F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xA1"],
        ["\xB1\xA1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\x4F"],

        ["\xF1\x7F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xA2"],
        ["\xB1\xA2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\x7F"],

        ["\xF1\x7B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xA3"],
        ["\xB1\xA3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\x7B"],

        ["\xF1\xE0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xA4"],
        ["\xB1\xA4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xE0"],

        ["\xF1\x6C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xA5"],
        ["\xB1\xA5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\x6C"],

        ["\xF1\x50",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xA6"],
        ["\xB1\xA6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\x50"],

        ["\xF1\x7D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xA7"],
        ["\xB1\xA7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\x7D"],

        ["\xF1\x4D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xA8"],
        ["\xB1\xA8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\x4D"],

        ["\xF1\x5D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xA9"],
        ["\xB1\xA9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\x5D"],

        ["\xF1\x5C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xAA"],
        ["\xB1\xAA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\x5C"],

        ["\xF1\x4E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xAB"],
        ["\xB1\xAB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\x4E"],

        ["\xF1\x6B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xAC"],
        ["\xB1\xAC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\x6B"],

        ["\xF1\x60",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xAD"],
        ["\xB1\xAD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\x60"],

        ["\xF1\x4B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xAE"],
        ["\xB1\xAE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\x4B"],

        ["\xF1\x61",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xAF"],
        ["\xB1\xAF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\x61"],

        ["\xF1\xF0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xB0"],
        ["\xB1\xB0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xF0"],

        ["\xF1\xF1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xB1"],
        ["\xB1\xB1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xF1"],

        ["\xF1\xF2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xB2"],
        ["\xB1\xB2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xF2"],

        ["\xF1\xF3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xB3"],
        ["\xB1\xB3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xF3"],

        ["\xF1\xF4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xB4"],
        ["\xB1\xB4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xF4"],

        ["\xF1\xF5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xB5"],
        ["\xB1\xB5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xF5"],

        ["\xF1\xF6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xB6"],
        ["\xB1\xB6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xF6"],

        ["\xF1\xF7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xB7"],
        ["\xB1\xB7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xF7"],

        ["\xF1\xF8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xB8"],
        ["\xB1\xB8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xF8"],

        ["\xF1\xF9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xB9"],
        ["\xB1\xB9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xF9"],

        ["\xF1\x7A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xBA"],
        ["\xB1\xBA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\x7A"],

        ["\xF1\x5E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xBB"],
        ["\xB1\xBB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\x5E"],

        ["\xF1\x4C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xBC"],
        ["\xB1\xBC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\x4C"],

        ["\xF1\x7E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xBD"],
        ["\xB1\xBD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\x7E"],

        ["\xF1\x6E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xBE"],
        ["\xB1\xBE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\x6E"],

        ["\xF1\x6F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xBF"],
        ["\xB1\xBF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\x6F"],

        ["\xF1\x7C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xC0"],
        ["\xB1\xC0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\x7C"],

        ["\xF1\xC1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xC1"],
        ["\xB1\xC1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xC1"],

        ["\xF1\xC2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xC2"],
        ["\xB1\xC2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xC2"],

        ["\xF1\xC3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xC3"],
        ["\xB1\xC3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xC3"],

        ["\xF1\xC4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xC4"],
        ["\xB1\xC4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xC4"],

        ["\xF1\xC5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xC5"],
        ["\xB1\xC5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xC5"],

        ["\xF1\xC6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xC6"],
        ["\xB1\xC6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xC6"],

        ["\xF1\xC7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xC7"],
        ["\xB1\xC7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xC7"],

        ["\xF1\xC8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xC8"],
        ["\xB1\xC8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xC8"],

        ["\xF1\xC9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xC9"],
        ["\xB1\xC9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xC9"],

        ["\xF1\xD1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xCA"],
        ["\xB1\xCA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xD1"],

        ["\xF1\xD2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xCB"],
        ["\xB1\xCB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xD2"],

        ["\xF1\xD3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xCC"],
        ["\xB1\xCC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xD3"],

        ["\xF1\xD4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xCD"],
        ["\xB1\xCD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xD4"],

        ["\xF1\xD5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xCE"],
        ["\xB1\xCE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xD5"],

        ["\xF1\xD6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xCF"],
        ["\xB1\xCF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xD6"],

        ["\xF1\xD7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xD0"],
        ["\xB1\xD0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xD7"],

        ["\xF1\xD8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xD1"],
        ["\xB1\xD1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xD8"],

        ["\xF1\xD9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xD2"],
        ["\xB1\xD2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xD9"],

        ["\xF1\xE2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xD3"],
        ["\xB1\xD3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xE2"],

        ["\xF1\xE3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xD4"],
        ["\xB1\xD4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xE3"],

        ["\xF1\xE4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xD5"],
        ["\xB1\xD5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xE4"],

        ["\xF1\xE5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xD6"],
        ["\xB1\xD6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xE5"],

        ["\xF1\xE6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xD7"],
        ["\xB1\xD7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xE6"],

        ["\xF1\xE7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xD8"],
        ["\xB1\xD8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xE7"],

        ["\xF1\xE8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xD9"],
        ["\xB1\xD9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xE8"],

        ["\xF1\xE9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xDA"],
        ["\xB1\xDA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xE9"],

        ["\xF1\x4A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xDB"],
        ["\xB1\xDB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\x4A"],

        ["\xF1\x5B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xDC"],
        ["\xB1\xDC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\x5B"],

        ["\xF1\x5A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xDD"],
        ["\xB1\xDD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\x5A"],

        ["\xF1\x5F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xDE"],
        ["\xB1\xDE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\x5F"],

        ["\xF1\x6D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xDF"],
        ["\xB1\xDF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\x6D"],

        ["\xF1\x79",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xE0"],
        ["\xB1\xE0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\x79"],

        ["\xF1\x57",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xE1"],
        ["\xB1\xE1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\x57"],

        ["\xF1\x59",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xE2"],
        ["\xB1\xE2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\x59"],

        ["\xF1\x62",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xE3"],
        ["\xB1\xE3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\x62"],

        ["\xF1\x63",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xE4"],
        ["\xB1\xE4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\x63"],

        ["\xF1\x64",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xE5"],
        ["\xB1\xE5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\x64"],

        ["\xF1\x65",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xE6"],
        ["\xB1\xE6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\x65"],

        ["\xF1\x66",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xE7"],
        ["\xB1\xE7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\x66"],

        ["\xF1\x67",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xE8"],
        ["\xB1\xE8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\x67"],

        ["\xF1\x68",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xE9"],
        ["\xB1\xE9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\x68"],

        ["\xF1\x69",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xEA"],
        ["\xB1\xEA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\x69"],

        ["\xF1\x70",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xEB"],
        ["\xB1\xEB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\x70"],

        ["\xF1\x71",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xEC"],
        ["\xB1\xEC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\x71"],

        ["\xF1\x72",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xED"],
        ["\xB1\xED",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\x72"],

        ["\xF1\x73",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xEE"],
        ["\xB1\xEE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\x73"],

        ["\xF1\x74",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xEF"],
        ["\xB1\xEF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\x74"],

        ["\xF1\x75",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xF0"],
        ["\xB1\xF0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\x75"],

        ["\xF1\x76",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xF1"],
        ["\xB1\xF1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\x76"],

        ["\xF1\x77",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xF2"],
        ["\xB1\xF2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\x77"],

        ["\xF1\x78",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xF3"],
        ["\xB1\xF3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\x78"],

        ["\xF1\x80",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xF4"],
        ["\xB1\xF4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\x80"],

        ["\xF1\x8B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xF5"],
        ["\xB1\xF5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\x8B"],

        ["\xF1\x9B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xF6"],
        ["\xB1\xF6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\x9B"],

        ["\xF1\x9C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xF7"],
        ["\xB1\xF7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\x9C"],

        ["\xF1\xA0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xF8"],
        ["\xB1\xF8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xA0"],

        ["\xF1\xAB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xF9"],
        ["\xB1\xF9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xAB"],

        ["\xF1\xB0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xFA"],
        ["\xB1\xFA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xB0"],

        ["\xF1\xC0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xFB"],
        ["\xB1\xFB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xC0"],

        ["\xF1\x6A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xFC"],
        ["\xB1\xFC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\x6A"],

        ["\xF1\xD0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xFD"],
        ["\xB1\xFD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xD0"],

        ["\xF1\xA1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\xFE"],
        ["\xB1\xFE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xA1"],

        ["\xF2\x4F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xA1"],
        ["\xB2\xA1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\x4F"],

        ["\xF2\x7F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xA2"],
        ["\xB2\xA2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\x7F"],

        ["\xF2\x7B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xA3"],
        ["\xB2\xA3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\x7B"],

        ["\xF2\xE0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xA4"],
        ["\xB2\xA4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xE0"],

        ["\xF2\x6C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xA5"],
        ["\xB2\xA5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\x6C"],

        ["\xF2\x50",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xA6"],
        ["\xB2\xA6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\x50"],

        ["\xF2\x7D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xA7"],
        ["\xB2\xA7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\x7D"],

        ["\xF2\x4D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xA8"],
        ["\xB2\xA8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\x4D"],

        ["\x77\x80",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xA9"],
        ["\xB2\xA9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x77\x80"],

        ["\xF2\x5C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xAA"],
        ["\xB2\xAA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\x5C"],

        ["\xF2\x4E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xAB"],
        ["\xB2\xAB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\x4E"],

        ["\xF2\x6B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xAC"],
        ["\xB2\xAC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\x6B"],

        ["\xF2\x60",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xAD"],
        ["\xB2\xAD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\x60"],

        ["\xF2\x4B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xAE"],
        ["\xB2\xAE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\x4B"],

        ["\xF2\x61",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xAF"],
        ["\xB2\xAF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\x61"],

        ["\xF2\xF0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xB0"],
        ["\xB2\xB0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xF0"],

        ["\xF2\xF1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xB1"],
        ["\xB2\xB1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xF1"],

        ["\xF2\xF2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xB2"],
        ["\xB2\xB2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xF2"],

        ["\xF2\xF3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xB3"],
        ["\xB2\xB3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xF3"],

        ["\xF2\xF4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xB4"],
        ["\xB2\xB4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xF4"],

        ["\xF2\xF5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xB5"],
        ["\xB2\xB5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xF5"],

        ["\xF2\xF6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xB6"],
        ["\xB2\xB6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xF6"],

        ["\xF2\xF7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xB7"],
        ["\xB2\xB7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xF7"],

        ["\xF2\xF8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xB8"],
        ["\xB2\xB8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xF8"],

        ["\xF2\xF9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xB9"],
        ["\xB2\xB9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xF9"],

        ["\xF2\x7A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xBA"],
        ["\xB2\xBA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\x7A"],

        ["\xF2\x5E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xBB"],
        ["\xB2\xBB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\x5E"],

        ["\xF2\x4C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xBC"],
        ["\xB2\xBC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\x4C"],

        ["\xF2\x7E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xBD"],
        ["\xB2\xBD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\x7E"],

        ["\xF2\x6E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xBE"],
        ["\xB2\xBE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\x6E"],

        ["\xF2\x6F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xBF"],
        ["\xB2\xBF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\x6F"],

        ["\xF2\x7C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xC0"],
        ["\xB2\xC0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\x7C"],

        ["\xF2\xC1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xC1"],
        ["\xB2\xC1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xC1"],

        ["\xF2\xC2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xC2"],
        ["\xB2\xC2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xC2"],

        ["\xF2\xC3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xC3"],
        ["\xB2\xC3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xC3"],

        ["\xF2\xC4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xC4"],
        ["\xB2\xC4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xC4"],

        ["\xF2\xC5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xC5"],
        ["\xB2\xC5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xC5"],

        ["\xF2\xC6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xC6"],
        ["\xB2\xC6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xC6"],

        ["\xF2\xC7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xC7"],
        ["\xB2\xC7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xC7"],

        ["\xF2\xC8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xC8"],
        ["\xB2\xC8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xC8"],

        ["\xF2\xC9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xC9"],
        ["\xB2\xC9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xC9"],

        ["\xF2\xD1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xCA"],
        ["\xB2\xCA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xD1"],

        ["\xF2\xD2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xCB"],
        ["\xB2\xCB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xD2"],

        ["\xF2\xD3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xCC"],
        ["\xB2\xCC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xD3"],

        ["\xF2\xD4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xCD"],
        ["\xB2\xCD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xD4"],

        ["\xF2\xD5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xCE"],
        ["\xB2\xCE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xD5"],

        ["\xF2\xD6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xCF"],
        ["\xB2\xCF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xD6"],

        ["\xF2\xD7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xD0"],
        ["\xB2\xD0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xD7"],

        ["\xF2\xD8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xD1"],
        ["\xB2\xD1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xD8"],

        ["\xF2\xD9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xD2"],
        ["\xB2\xD2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xD9"],

        ["\xF2\xE2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xD3"],
        ["\xB2\xD3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xE2"],

        ["\xF2\xE3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xD4"],
        ["\xB2\xD4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xE3"],

        ["\xF2\xE4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xD5"],
        ["\xB2\xD5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xE4"],

        ["\xF2\xE5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xD6"],
        ["\xB2\xD6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xE5"],

        ["\xF2\xE6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xD7"],
        ["\xB2\xD7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xE6"],

        ["\xF2\xE7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xD8"],
        ["\xB2\xD8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xE7"],

        ["\xF2\xE8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xD9"],
        ["\xB2\xD9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xE8"],

        ["\xF2\xE9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xDA"],
        ["\xB2\xDA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xE9"],

        ["\xF2\x4A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xDB"],
        ["\xB2\xDB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\x4A"],

        ["\xF2\x5B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xDC"],
        ["\xB2\xDC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\x5B"],

        ["\xF2\x5A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xDD"],
        ["\xB2\xDD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\x5A"],

        ["\xF2\x5F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xDE"],
        ["\xB2\xDE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\x5F"],

        ["\xF2\x6D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xDF"],
        ["\xB2\xDF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\x6D"],

        ["\xF2\x79",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xE0"],
        ["\xB2\xE0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\x79"],

        ["\xF2\x57",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xE1"],
        ["\xB2\xE1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\x57"],

        ["\xF2\x59",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xE2"],
        ["\xB2\xE2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\x59"],

        ["\xF2\x62",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xE3"],
        ["\xB2\xE3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\x62"],

        ["\xF2\x63",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xE4"],
        ["\xB2\xE4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\x63"],

        ["\xF2\x64",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xE5"],
        ["\xB2\xE5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\x64"],

        ["\xF2\x65",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xE6"],
        ["\xB2\xE6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\x65"],

        ["\xF2\x66",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xE7"],
        ["\xB2\xE7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\x66"],

        ["\xF2\x67",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xE8"],
        ["\xB2\xE8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\x67"],

        ["\xF2\x68",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xE9"],
        ["\xB2\xE9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\x68"],

        ["\xF2\x69",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xEA"],
        ["\xB2\xEA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\x69"],

        ["\xF2\x70",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xEB"],
        ["\xB2\xEB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\x70"],

        ["\xF2\x71",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xEC"],
        ["\xB2\xEC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\x71"],

        ["\xF2\x72",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xED"],
        ["\xB2\xED",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\x72"],

        ["\xF2\x73",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xEE"],
        ["\xB2\xEE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\x73"],

        ["\xF2\x74",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xEF"],
        ["\xB2\xEF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\x74"],

        ["\xF2\x75",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xF0"],
        ["\xB2\xF0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\x75"],

        ["\xF2\x76",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xF1"],
        ["\xB2\xF1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\x76"],

        ["\xF2\x77",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xF2"],
        ["\xB2\xF2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\x77"],

        ["\xF2\x78",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xF3"],
        ["\xB2\xF3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\x78"],

        ["\xF2\x80",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xF4"],
        ["\xB2\xF4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\x80"],

        ["\xF2\x8B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xF5"],
        ["\xB2\xF5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\x8B"],

        ["\xF2\x9B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xF6"],
        ["\xB2\xF6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\x9B"],

        ["\xF2\x9C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xF7"],
        ["\xB2\xF7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\x9C"],

        ["\xF2\xA0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xF8"],
        ["\xB2\xF8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xA0"],

        ["\xF2\xAB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xF9"],
        ["\xB2\xF9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xAB"],

        ["\xF2\xB0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xFA"],
        ["\xB2\xFA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xB0"],

        ["\xF2\xC0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xFB"],
        ["\xB2\xFB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xC0"],

        ["\xF2\x6A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xFC"],
        ["\xB2\xFC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\x6A"],

        ["\xF2\xD0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xFD"],
        ["\xB2\xFD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xD0"],

        ["\xF2\xA1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB2\xFE"],
        ["\xB2\xFE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xA1"],

        ["\xF3\x4F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xA1"],
        ["\xB3\xA1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\x4F"],

        ["\xF3\x7F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xA2"],
        ["\xB3\xA2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\x7F"],

        ["\xF3\x7B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xA3"],
        ["\xB3\xA3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\x7B"],

        ["\xF3\xE0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xA4"],
        ["\xB3\xA4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xE0"],

        ["\xF3\x6C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xA5"],
        ["\xB3\xA5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\x6C"],

        ["\xF3\x50",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xA6"],
        ["\xB3\xA6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\x50"],

        ["\xF3\x7D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xA7"],
        ["\xB3\xA7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\x7D"],

        ["\xF3\x4D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xA8"],
        ["\xB3\xA8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\x4D"],

        ["\xF3\x5D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xA9"],
        ["\xB3\xA9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\x5D"],

        ["\xF3\x5C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xAA"],
        ["\xB3\xAA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\x5C"],

        ["\xF3\x4E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xAB"],
        ["\xB3\xAB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\x4E"],

        ["\xF3\x6B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xAC"],
        ["\xB3\xAC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\x6B"],

        ["\xF3\x60",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xAD"],
        ["\xB3\xAD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\x60"],

        ["\xF3\x4B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xAE"],
        ["\xB3\xAE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\x4B"],

        ["\xF3\x61",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xAF"],
        ["\xB3\xAF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\x61"],

        ["\xF3\xF0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xB0"],
        ["\xB3\xB0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xF0"],

        ["\xF3\xF1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xB1"],
        ["\xB3\xB1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xF1"],

        ["\xF3\xF2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xB2"],
        ["\xB3\xB2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xF2"],

        ["\xF3\xF3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xB3"],
        ["\xB3\xB3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xF3"],

        ["\xF3\xF4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xB4"],
        ["\xB3\xB4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xF4"],

        ["\xF3\xF5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xB5"],
        ["\xB3\xB5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xF5"],

        ["\xF3\xF6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xB6"],
        ["\xB3\xB6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xF6"],

        ["\xF3\xF7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xB7"],
        ["\xB3\xB7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xF7"],

        ["\xF3\xF8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xB8"],
        ["\xB3\xB8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xF8"],

        ["\xF3\xF9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xB9"],
        ["\xB3\xB9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xF9"],

        ["\xF3\x7A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xBA"],
        ["\xB3\xBA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\x7A"],

        ["\xF3\x5E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xBB"],
        ["\xB3\xBB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\x5E"],

        ["\xF3\x4C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xBC"],
        ["\xB3\xBC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\x4C"],

        ["\xF3\x7E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xBD"],
        ["\xB3\xBD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\x7E"],

        ["\xF3\x6E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xBE"],
        ["\xB3\xBE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\x6E"],

        ["\xF3\x6F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xBF"],
        ["\xB3\xBF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\x6F"],

        ["\xF3\x7C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xC0"],
        ["\xB3\xC0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\x7C"],

        ["\xF3\xC1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xC1"],
        ["\xB3\xC1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xC1"],

        ["\x68\xE9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xC2"],
        ["\xB3\xC2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\xE9"],

        ["\xF3\xC3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xC3"],
        ["\xB3\xC3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xC3"],

        ["\xF3\xC4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xC4"],
        ["\xB3\xC4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xC4"],

        ["\xF3\xC5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xC5"],
        ["\xB3\xC5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xC5"],

        ["\xF3\xC6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xC6"],
        ["\xB3\xC6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xC6"],

        ["\xF3\xC7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xC7"],
        ["\xB3\xC7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xC7"],

        ["\xF3\xC8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xC8"],
        ["\xB3\xC8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xC8"],

        ["\xE8\xA0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xC9"],
        ["\xB3\xC9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xA0"],

        ["\xF3\xD1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xCA"],
        ["\xB3\xCA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xD1"],

        ["\xF3\xD2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xCB"],
        ["\xB3\xCB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xD2"],

        ["\xF3\xD3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xCC"],
        ["\xB3\xCC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xD3"],

        ["\xF3\xD4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xCD"],
        ["\xB3\xCD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xD4"],

        ["\xF3\xD5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xCE"],
        ["\xB3\xCE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xD5"],

        ["\xF3\xD6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xCF"],
        ["\xB3\xCF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xD6"],

        ["\xF3\xD7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xD0"],
        ["\xB3\xD0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xD7"],

        ["\xF3\xD8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xD1"],
        ["\xB3\xD1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xD8"],

        ["\xF3\xD9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xD2"],
        ["\xB3\xD2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xD9"],

        ["\xF3\xE2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xD3"],
        ["\xB3\xD3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xE2"],

        ["\xF3\xE3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xD4"],
        ["\xB3\xD4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xE3"],

        ["\xF3\xE4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xD5"],
        ["\xB3\xD5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xE4"],

        ["\xF3\xE5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xD6"],
        ["\xB3\xD6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xE5"],

        ["\xF3\xE6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xD7"],
        ["\xB3\xD7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xE6"],

        ["\xF3\xE7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xD8"],
        ["\xB3\xD8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xE7"],

        ["\xF3\xE8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xD9"],
        ["\xB3\xD9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xE8"],

        ["\xF3\xE9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xDA"],
        ["\xB3\xDA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xE9"],

        ["\xF3\x4A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xDB"],
        ["\xB3\xDB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\x4A"],

        ["\xF3\x5B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xDC"],
        ["\xB3\xDC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\x5B"],

        ["\xF3\x5A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xDD"],
        ["\xB3\xDD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\x5A"],

        ["\xF3\x5F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xDE"],
        ["\xB3\xDE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\x5F"],

        ["\xF3\x6D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xDF"],
        ["\xB3\xDF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\x6D"],

        ["\xF3\x79",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xE0"],
        ["\xB3\xE0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\x79"],

        ["\xF3\x57",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xE1"],
        ["\xB3\xE1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\x57"],

        ["\xF3\x59",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xE2"],
        ["\xB3\xE2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\x59"],

        ["\xF3\x62",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xE3"],
        ["\xB3\xE3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\x62"],

        ["\xF3\x63",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xE4"],
        ["\xB3\xE4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\x63"],

        ["\xF3\x64",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xE5"],
        ["\xB3\xE5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\x64"],

        ["\xF3\x65",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xE6"],
        ["\xB3\xE6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\x65"],

        ["\xF3\x66",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xE7"],
        ["\xB3\xE7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\x66"],

        ["\xF3\x67",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xE8"],
        ["\xB3\xE8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\x67"],

        ["\xF3\x68",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xE9"],
        ["\xB3\xE9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\x68"],

        ["\xF3\x69",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xEA"],
        ["\xB3\xEA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\x69"],

        ["\xF3\x70",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xEB"],
        ["\xB3\xEB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\x70"],

        ["\xF3\x71",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xEC"],
        ["\xB3\xEC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\x71"],

        ["\xF3\x72",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xED"],
        ["\xB3\xED",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\x72"],

        ["\xF3\x73",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xEE"],
        ["\xB3\xEE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\x73"],

        ["\xF3\x74",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xEF"],
        ["\xB3\xEF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\x74"],

        ["\xF3\x75",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xF0"],
        ["\xB3\xF0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\x75"],

        ["\xF3\x76",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xF1"],
        ["\xB3\xF1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\x76"],

        ["\xF3\x77",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xF2"],
        ["\xB3\xF2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\x77"],

        ["\xF3\x78",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xF3"],
        ["\xB3\xF3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\x78"],

        ["\xF3\x80",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xF4"],
        ["\xB3\xF4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\x80"],

        ["\xF3\x8B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xF5"],
        ["\xB3\xF5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\x8B"],

        ["\x62\x5F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xF6"],
        ["\xB3\xF6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\x5F"],

        ["\xF3\x9C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xF7"],
        ["\xB3\xF7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\x9C"],

        ["\xF3\xA0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xF8"],
        ["\xB3\xF8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xA0"],

        ["\xF3\xAB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xF9"],
        ["\xB3\xF9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xAB"],

        ["\xF3\xB0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xFA"],
        ["\xB3\xFA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0"],

        ["\xF3\xC0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xFB"],
        ["\xB3\xFB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xC0"],

        ["\xF3\x6A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xFC"],
        ["\xB3\xFC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\x6A"],

        ["\xF3\xD0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xFD"],
        ["\xB3\xFD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xD0"],

        ["\xF3\xA1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB3\xFE"],
        ["\xB3\xFE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xA1"],

        ["\xF4\x4F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xA1"],
        ["\xB4\xA1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF4\x4F"],

        ["\xF4\x7F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xA2"],
        ["\xB4\xA2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF4\x7F"],

        ["\xF4\x7B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xA3"],
        ["\xB4\xA3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF4\x7B"],

        ["\xF4\xE0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xA4"],
        ["\xB4\xA4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF4\xE0"],

        ["\xF4\x6C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xA5"],
        ["\xB4\xA5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF4\x6C"],

        ["\xF4\x50",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xA6"],
        ["\xB4\xA6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF4\x50"],

        ["\xF4\x7D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xA7"],
        ["\xB4\xA7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF4\x7D"],

        ["\xF4\x4D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xA8"],
        ["\xB4\xA8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF4\x4D"],

        ["\xF4\x5D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xA9"],
        ["\xB4\xA9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF4\x5D"],

        ["\xF4\x5C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xAA"],
        ["\xB4\xAA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF4\x5C"],

        ["\xF4\x4E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xAB"],
        ["\xB4\xAB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF4\x4E"],

        ["\xF4\x6B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xAC"],
        ["\xB4\xAC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF4\x6B"],

        ["\xF4\x60",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xAD"],
        ["\xB4\xAD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF4\x60"],

        ["\xF4\x4B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xAE"],
        ["\xB4\xAE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF4\x4B"],

        ["\xF4\x61",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xAF"],
        ["\xB4\xAF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF4\x61"],

        ["\xF4\xF0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xB0"],
        ["\xB4\xB0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF4\xF0"],

        ["\xF4\xF1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xB1"],
        ["\xB4\xB1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF4\xF1"],

        ["\xF4\xF2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xB2"],
        ["\xB4\xB2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF4\xF2"],

        ["\xF4\xF3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xB3"],
        ["\xB4\xB3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF4\xF3"],

        ["\xF4\xF4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xB4"],
        ["\xB4\xB4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF4\xF4"],

        ["\xF4\xF5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xB5"],
        ["\xB4\xB5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF4\xF5"],

        ["\xF4\xF6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xB6"],
        ["\xB4\xB6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF4\xF6"],

        ["\xF4\xF7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xB7"],
        ["\xB4\xB7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF4\xF7"],

        ["\xF4\xF8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xB8"],
        ["\xB4\xB8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF4\xF8"],

        ["\xF4\xF9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xB9"],
        ["\xB4\xB9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF4\xF9"],

        ["\xF4\x7A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xBA"],
        ["\xB4\xBA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF4\x7A"],

        ["\xF4\x5E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xBB"],
        ["\xB4\xBB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF4\x5E"],

        ["\xF4\x4C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xBC"],
        ["\xB4\xBC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF4\x4C"],

        ["\xF4\x7E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xBD"],
        ["\xB4\xBD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF4\x7E"],

        ["\xF4\x6E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xBE"],
        ["\xB4\xBE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF4\x6E"],

        ["\xF4\x6F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xBF"],
        ["\xB4\xBF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF4\x6F"],

        ["\xF4\x7C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xC0"],
        ["\xB4\xC0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF4\x7C"],

        ["\xF4\xC1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xC1"],
        ["\xB4\xC1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF4\xC1"],

        ["\xF4\xC2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xC2"],
        ["\xB4\xC2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF4\xC2"],

        ["\x5F\x8B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xC3"],
        ["\xB4\xC3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\x8B"],

        ["\xF4\xC4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xC4"],
        ["\xB4\xC4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF4\xC4"],

        ["\xF4\xC5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xC5"],
        ["\xB4\xC5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF4\xC5"],

        ["\xF4\xC6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xC6"],
        ["\xB4\xC6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF4\xC6"],

        ["\xF4\xC7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xC7"],
        ["\xB4\xC7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF4\xC7"],

        ["\xF4\xC8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xC8"],
        ["\xB4\xC8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF4\xC8"],

        ["\xF4\xC9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xC9"],
        ["\xB4\xC9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF4\xC9"],

        ["\xF4\xD1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xCA"],
        ["\xB4\xCA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF4\xD1"],

        ["\xF4\xD2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xCB"],
        ["\xB4\xCB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF4\xD2"],

        ["\xF4\xD3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xCC"],
        ["\xB4\xCC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF4\xD3"],

        ["\xF4\xD4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xCD"],
        ["\xB4\xCD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF4\xD4"],

        ["\xF4\xD5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xCE"],
        ["\xB4\xCE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF4\xD5"],

        ["\xF4\xD6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xCF"],
        ["\xB4\xCF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF4\xD6"],

        ["\xF4\xD7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xD0"],
        ["\xB4\xD0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF4\xD7"],

        ["\xF4\xD8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xD1"],
        ["\xB4\xD1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF4\xD8"],

        ["\x70\x5A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xD2"],
        ["\xB4\xD2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\x5A"],

        ["\xF4\xE2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xD3"],
        ["\xB4\xD3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF4\xE2"],

        ["\xF4\xE3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xD4"],
        ["\xB4\xD4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF4\xE3"],

        ["\xF4\xE4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xD5"],
        ["\xB4\xD5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF4\xE4"],

        ["\xF4\xE5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xD6"],
        ["\xB4\xD6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF4\xE5"],

        ["\xF4\xE6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xD7"],
        ["\xB4\xD7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF4\xE6"],

        ["\xF4\xE7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xD8"],
        ["\xB4\xD8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF4\xE7"],

        ["\xF4\xE8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xD9"],
        ["\xB4\xD9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF4\xE8"],

        ["\xF4\xE9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xDA"],
        ["\xB4\xDA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF4\xE9"],

        ["\xF4\x4A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xDB"],
        ["\xB4\xDB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF4\x4A"],

        ["\xF4\x5B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xDC"],
        ["\xB4\xDC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF4\x5B"],

        ["\xF4\x5A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xDD"],
        ["\xB4\xDD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF4\x5A"],

        ["\xF4\x5F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xDE"],
        ["\xB4\xDE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF4\x5F"],

        ["\xF4\x6D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xDF"],
        ["\xB4\xDF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF4\x6D"],

        ["\xF4\x79",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xE0"],
        ["\xB4\xE0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF4\x79"],

        ["\xF4\x57",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xE1"],
        ["\xB4\xE1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF4\x57"],

        ["\xF4\x59",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xE2"],
        ["\xB4\xE2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF4\x59"],

        ["\xF4\x62",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xE3"],
        ["\xB4\xE3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF4\x62"],

        ["\xF4\x63",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xE4"],
        ["\xB4\xE4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF4\x63"],

        ["\xF4\x64",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xE5"],
        ["\xB4\xE5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF4\x64"],

        ["\xF4\x65",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xE6"],
        ["\xB4\xE6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF4\x65"],

        ["\xF4\x66",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xE7"],
        ["\xB4\xE7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF4\x66"],

        ["\xF4\x67",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xE8"],
        ["\xB4\xE8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF4\x67"],

        ["\xF4\x68",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xE9"],
        ["\xB4\xE9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF4\x68"],

        ["\xF4\x69",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xEA"],
        ["\xB4\xEA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF4\x69"],

        ["\xF4\x70",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xEB"],
        ["\xB4\xEB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF4\x70"],

        ["\xF4\x71",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xEC"],
        ["\xB4\xEC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF4\x71"],

        ["\xF4\x72",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xED"],
        ["\xB4\xED",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF4\x72"],

        ["\xF4\x73",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xEE"],
        ["\xB4\xEE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF4\x73"],

        ["\xF4\x74",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xEF"],
        ["\xB4\xEF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF4\x74"],

        ["\xF4\x75",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xF0"],
        ["\xB4\xF0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF4\x75"],

        ["\xF4\x76",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xF1"],
        ["\xB4\xF1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF4\x76"],

        ["\xF4\x77",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xF2"],
        ["\xB4\xF2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF4\x77"],

        ["\xF4\x78",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xF3"],
        ["\xB4\xF3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF4\x78"],

        ["\xF4\x80",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xF4"],
        ["\xB4\xF4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF4\x80"],

        ["\xF4\x8B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xF5"],
        ["\xB4\xF5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF4\x8B"],

        ["\xF4\x9B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xF6"],
        ["\xB4\xF6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF4\x9B"],

        ["\xF4\x9C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xF7"],
        ["\xB4\xF7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF4\x9C"],

        ["\xF4\xA0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xF8"],
        ["\xB4\xF8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF4\xA0"],

        ["\xF4\xAB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xF9"],
        ["\xB4\xF9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF4\xAB"],

        ["\xF4\xB0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xFA"],
        ["\xB4\xFA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF4\xB0"],

        ["\xF4\xC0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xFB"],
        ["\xB4\xFB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF4\xC0"],

        ["\xF4\x6A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xFC"],
        ["\xB4\xFC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF4\x6A"],

        ["\xF4\xD0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xFD"],
        ["\xB4\xFD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF4\xD0"],

        ["\xF4\xA1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB4\xFE"],
        ["\xB4\xFE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF4\xA1"],

        ["\xF5\x4F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xA1"],
        ["\xB5\xA1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF5\x4F"],

        ["\xF5\x7F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xA2"],
        ["\xB5\xA2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF5\x7F"],

        ["\xF5\x7B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xA3"],
        ["\xB5\xA3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF5\x7B"],

        ["\xF5\xE0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xA4"],
        ["\xB5\xA4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF5\xE0"],

        ["\xF5\x6C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xA5"],
        ["\xB5\xA5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF5\x6C"],

        ["\xF5\x50",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xA6"],
        ["\xB5\xA6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF5\x50"],

        ["\xF5\x7D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xA7"],
        ["\xB5\xA7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF5\x7D"],

        ["\xF5\x4D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xA8"],
        ["\xB5\xA8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF5\x4D"],

        ["\xF5\x5D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xA9"],
        ["\xB5\xA9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF5\x5D"],

        ["\xF5\x5C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xAA"],
        ["\xB5\xAA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF5\x5C"],

        ["\xF5\x4E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xAB"],
        ["\xB5\xAB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF5\x4E"],

        ["\xF5\x6B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xAC"],
        ["\xB5\xAC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF5\x6B"],

        ["\xF5\x60",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xAD"],
        ["\xB5\xAD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF5\x60"],

        ["\xF5\x4B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xAE"],
        ["\xB5\xAE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF5\x4B"],

        ["\xF5\x61",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xAF"],
        ["\xB5\xAF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF5\x61"],

        ["\xF5\xF0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xB0"],
        ["\xB5\xB0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF5\xF0"],

        ["\xF5\xF1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xB1"],
        ["\xB5\xB1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF5\xF1"],

        ["\xF5\xF2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xB2"],
        ["\xB5\xB2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF5\xF2"],

        ["\xF5\xF3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xB3"],
        ["\xB5\xB3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF5\xF3"],

        ["\xF5\xF4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xB4"],
        ["\xB5\xB4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF5\xF4"],

        ["\xF5\xF5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xB5"],
        ["\xB5\xB5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF5\xF5"],

        ["\xF5\xF6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xB6"],
        ["\xB5\xB6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF5\xF6"],

        ["\xF5\xF7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xB7"],
        ["\xB5\xB7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF5\xF7"],

        ["\xF5\xF8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xB8"],
        ["\xB5\xB8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF5\xF8"],

        ["\xF5\xF9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xB9"],
        ["\xB5\xB9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF5\xF9"],

        ["\xF5\x7A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xBA"],
        ["\xB5\xBA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF5\x7A"],

        ["\xF5\x5E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xBB"],
        ["\xB5\xBB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF5\x5E"],

        ["\xF5\x4C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xBC"],
        ["\xB5\xBC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF5\x4C"],

        ["\xF5\x7E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xBD"],
        ["\xB5\xBD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF5\x7E"],

        ["\xF5\x6E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xBE"],
        ["\xB5\xBE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF5\x6E"],

        ["\xF5\x6F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xBF"],
        ["\xB5\xBF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF5\x6F"],

        ["\xF5\x7C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xC0"],
        ["\xB5\xC0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF5\x7C"],

        ["\xF5\xC1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xC1"],
        ["\xB5\xC1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF5\xC1"],

        ["\xF5\xC2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xC2"],
        ["\xB5\xC2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF5\xC2"],

        ["\xF5\xC3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xC3"],
        ["\xB5\xC3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF5\xC3"],

        ["\xF5\xC4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xC4"],
        ["\xB5\xC4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF5\xC4"],

        ["\xF5\xC5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xC5"],
        ["\xB5\xC5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF5\xC5"],

        ["\xF5\xC6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xC6"],
        ["\xB5\xC6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF5\xC6"],

        ["\xF5\xC7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xC7"],
        ["\xB5\xC7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF5\xC7"],

        ["\xF5\xC8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xC8"],
        ["\xB5\xC8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF5\xC8"],

        ["\xF5\xC9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xC9"],
        ["\xB5\xC9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF5\xC9"],

        ["\xF5\xD1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xCA"],
        ["\xB5\xCA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF5\xD1"],

        ["\xF5\xD2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xCB"],
        ["\xB5\xCB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF5\xD2"],

        ["\xF5\xD3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xCC"],
        ["\xB5\xCC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF5\xD3"],

        ["\xF5\xD4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xCD"],
        ["\xB5\xCD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF5\xD4"],

        ["\xF5\xD5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xCE"],
        ["\xB5\xCE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF5\xD5"],

        ["\xF5\xD6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xCF"],
        ["\xB5\xCF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF5\xD6"],

        ["\xF5\xD7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xD0"],
        ["\xB5\xD0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF5\xD7"],

        ["\xF5\xD8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xD1"],
        ["\xB5\xD1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF5\xD8"],

        ["\xF5\xD9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xD2"],
        ["\xB5\xD2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF5\xD9"],

        ["\xF5\xE2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xD3"],
        ["\xB5\xD3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF5\xE2"],

        ["\xF5\xE3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xD4"],
        ["\xB5\xD4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF5\xE3"],

        ["\xF5\xE4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xD5"],
        ["\xB5\xD5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF5\xE4"],

        ["\xF5\xE5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xD6"],
        ["\xB5\xD6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF5\xE5"],

        ["\xF5\xE6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xD7"],
        ["\xB5\xD7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF5\xE6"],

        ["\xF5\xE7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xD8"],
        ["\xB5\xD8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF5\xE7"],

        ["\xF5\xE8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xD9"],
        ["\xB5\xD9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF5\xE8"],

        ["\xF5\xE9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xDA"],
        ["\xB5\xDA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF5\xE9"],

        ["\xF5\x4A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xDB"],
        ["\xB5\xDB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF5\x4A"],

        ["\xF5\x5B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xDC"],
        ["\xB5\xDC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF5\x5B"],

        ["\xF5\x5A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xDD"],
        ["\xB5\xDD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF5\x5A"],

        ["\xF5\x5F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xDE"],
        ["\xB5\xDE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF5\x5F"],

        ["\xF5\x6D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xDF"],
        ["\xB5\xDF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF5\x6D"],

        ["\xF5\x79",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xE0"],
        ["\xB5\xE0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF5\x79"],

        ["\xF5\x57",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xE1"],
        ["\xB5\xE1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF5\x57"],

        ["\xF5\x59",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xE2"],
        ["\xB5\xE2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF5\x59"],

        ["\xF5\x62",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xE3"],
        ["\xB5\xE3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF5\x62"],

        ["\xF5\x63",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xE4"],
        ["\xB5\xE4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF5\x63"],

        ["\xF5\x64",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xE5"],
        ["\xB5\xE5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF5\x64"],

        ["\xF5\x65",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xE6"],
        ["\xB5\xE6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF5\x65"],

        ["\xF5\x66",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xE7"],
        ["\xB5\xE7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF5\x66"],

        ["\xF5\x67",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xE8"],
        ["\xB5\xE8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF5\x67"],

        ["\xF5\x68",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xE9"],
        ["\xB5\xE9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF5\x68"],

        ["\xF5\x69",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xEA"],
        ["\xB5\xEA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF5\x69"],

        ["\xF5\x70",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xEB"],
        ["\xB5\xEB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF5\x70"],

        ["\xF5\x71",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xEC"],
        ["\xB5\xEC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF5\x71"],

        ["\xF5\x72",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xED"],
        ["\xB5\xED",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF5\x72"],

        ["\xF5\x73",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xEE"],
        ["\xB5\xEE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF5\x73"],

        ["\xF5\x74",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xEF"],
        ["\xB5\xEF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF5\x74"],

        ["\xF5\x75",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xF0"],
        ["\xB5\xF0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF5\x75"],

        ["\xF5\x76",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xF1"],
        ["\xB5\xF1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF5\x76"],

        ["\xF5\x77",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xF2"],
        ["\xB5\xF2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF5\x77"],

        ["\xF5\x78",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xF3"],
        ["\xB5\xF3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF5\x78"],

        ["\xF5\x80",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xF4"],
        ["\xB5\xF4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF5\x80"],

        ["\xF5\x8B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xF5"],
        ["\xB5\xF5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF5\x8B"],

        ["\xF5\x9B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xF6"],
        ["\xB5\xF6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF5\x9B"],

        ["\xF5\x9C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xF7"],
        ["\xB5\xF7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF5\x9C"],

        ["\xF5\xA0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xF8"],
        ["\xB5\xF8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF5\xA0"],

        ["\xF5\xAB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xF9"],
        ["\xB5\xF9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF5\xAB"],

        ["\xF5\xB0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xFA"],
        ["\xB5\xFA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF5\xB0"],

        ["\xF5\xC0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xFB"],
        ["\xB5\xFB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF5\xC0"],

        ["\xF5\x6A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xFC"],
        ["\xB5\xFC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF5\x6A"],

        ["\xF5\xD0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xFD"],
        ["\xB5\xFD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF5\xD0"],

        ["\xF5\xA1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB5\xFE"],
        ["\xB5\xFE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF5\xA1"],

        ["\xF6\x4F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xA1"],
        ["\xB6\xA1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF6\x4F"],

        ["\xF6\x7F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xA2"],
        ["\xB6\xA2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF6\x7F"],

        ["\xF6\x7B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xA3"],
        ["\xB6\xA3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF6\x7B"],

        ["\xF6\xE0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xA4"],
        ["\xB6\xA4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF6\xE0"],

        ["\xF6\x6C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xA5"],
        ["\xB6\xA5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF6\x6C"],

        ["\xF6\x50",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xA6"],
        ["\xB6\xA6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF6\x50"],

        ["\xF6\x7D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xA7"],
        ["\xB6\xA7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF6\x7D"],

        ["\xF6\x4D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xA8"],
        ["\xB6\xA8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF6\x4D"],

        ["\xF6\x5D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xA9"],
        ["\xB6\xA9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF6\x5D"],

        ["\xF6\x5C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xAA"],
        ["\xB6\xAA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF6\x5C"],

        ["\xF6\x4E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xAB"],
        ["\xB6\xAB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF6\x4E"],

        ["\xF6\x6B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xAC"],
        ["\xB6\xAC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF6\x6B"],

        ["\xF6\x60",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xAD"],
        ["\xB6\xAD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF6\x60"],

        ["\xF6\x4B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xAE"],
        ["\xB6\xAE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF6\x4B"],

        ["\xF6\x61",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xAF"],
        ["\xB6\xAF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF6\x61"],

        ["\xF6\xF0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xB0"],
        ["\xB6\xB0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF6\xF0"],

        ["\xF6\xF1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xB1"],
        ["\xB6\xB1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF6\xF1"],

        ["\xF6\xF2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xB2"],
        ["\xB6\xB2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF6\xF2"],

        ["\xF6\xF3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xB3"],
        ["\xB6\xB3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF6\xF3"],

        ["\xF6\xF4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xB4"],
        ["\xB6\xB4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF6\xF4"],

        ["\xF6\xF5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xB5"],
        ["\xB6\xB5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF6\xF5"],

        ["\xF6\xF6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xB6"],
        ["\xB6\xB6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF6\xF6"],

        ["\xF6\xF7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xB7"],
        ["\xB6\xB7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF6\xF7"],

        ["\xF6\xF8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xB8"],
        ["\xB6\xB8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF6\xF8"],

        ["\xF6\xF9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xB9"],
        ["\xB6\xB9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF6\xF9"],

        ["\xF6\x7A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xBA"],
        ["\xB6\xBA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF6\x7A"],

        ["\xF6\x5E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xBB"],
        ["\xB6\xBB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF6\x5E"],

        ["\xF6\x4C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xBC"],
        ["\xB6\xBC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF6\x4C"],

        ["\xF6\x7E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xBD"],
        ["\xB6\xBD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF6\x7E"],

        ["\xF6\x6E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xBE"],
        ["\xB6\xBE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF6\x6E"],

        ["\xF6\x6F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xBF"],
        ["\xB6\xBF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF6\x6F"],

        ["\xF6\x7C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xC0"],
        ["\xB6\xC0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF6\x7C"],

        ["\xF6\xC1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xC1"],
        ["\xB6\xC1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF6\xC1"],

        ["\xF6\xC2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xC2"],
        ["\xB6\xC2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF6\xC2"],

        ["\xF6\xC3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xC3"],
        ["\xB6\xC3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF6\xC3"],

        ["\xF6\xC4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xC4"],
        ["\xB6\xC4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF6\xC4"],

        ["\xF6\xC5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xC5"],
        ["\xB6\xC5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF6\xC5"],

        ["\x86\xBA",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xC6"],
        ["\xB6\xC6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x86\xBA"],

        ["\xF6\xC7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xC7"],
        ["\xB6\xC7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF6\xC7"],

        ["\xF6\xC8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xC8"],
        ["\xB6\xC8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF6\xC8"],

        ["\xF6\xC9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xC9"],
        ["\xB6\xC9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF6\xC9"],

        ["\xF6\xD1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xCA"],
        ["\xB6\xCA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF6\xD1"],

        ["\xF6\xD2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xCB"],
        ["\xB6\xCB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF6\xD2"],

        ["\xF6\xD3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xCC"],
        ["\xB6\xCC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF6\xD3"],

        ["\xF6\xD4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xCD"],
        ["\xB6\xCD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF6\xD4"],

        ["\xF6\xD5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xCE"],
        ["\xB6\xCE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF6\xD5"],

        ["\xF6\xD6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xCF"],
        ["\xB6\xCF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF6\xD6"],

        ["\xF6\xD7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xD0"],
        ["\xB6\xD0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF6\xD7"],

        ["\xF6\xD8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xD1"],
        ["\xB6\xD1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF6\xD8"],

        ["\xF6\xD9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xD2"],
        ["\xB6\xD2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF6\xD9"],

        ["\xF6\xE2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xD3"],
        ["\xB6\xD3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF6\xE2"],

        ["\xF6\xE3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xD4"],
        ["\xB6\xD4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF6\xE3"],

        ["\xF6\xE4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xD5"],
        ["\xB6\xD5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF6\xE4"],

        ["\xF6\xE5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xD6"],
        ["\xB6\xD6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF6\xE5"],

        ["\xF6\xE6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xD7"],
        ["\xB6\xD7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF6\xE6"],

        ["\xF6\xE7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xD8"],
        ["\xB6\xD8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF6\xE7"],

        ["\xF6\xE8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xD9"],
        ["\xB6\xD9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF6\xE8"],

        ["\xF6\xE9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xDA"],
        ["\xB6\xDA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF6\xE9"],

        ["\xF6\x4A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xDB"],
        ["\xB6\xDB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF6\x4A"],

        ["\xF6\x5B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xDC"],
        ["\xB6\xDC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF6\x5B"],

        ["\xF6\x5A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xDD"],
        ["\xB6\xDD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF6\x5A"],

        ["\xF6\x5F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xDE"],
        ["\xB6\xDE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF6\x5F"],

        ["\xF6\x6D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xDF"],
        ["\xB6\xDF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF6\x6D"],

        ["\xF6\x79",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xE0"],
        ["\xB6\xE0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF6\x79"],

        ["\xF6\x57",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xE1"],
        ["\xB6\xE1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF6\x57"],

        ["\xF6\x59",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xE2"],
        ["\xB6\xE2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF6\x59"],

        ["\xF6\x62",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xE3"],
        ["\xB6\xE3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF6\x62"],

        ["\xF6\x63",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xE4"],
        ["\xB6\xE4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF6\x63"],

        ["\xF6\x64",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xE5"],
        ["\xB6\xE5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF6\x64"],

        ["\xF6\x65",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xE6"],
        ["\xB6\xE6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF6\x65"],

        ["\xF6\x66",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xE7"],
        ["\xB6\xE7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF6\x66"],

        ["\xF6\x67",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xE8"],
        ["\xB6\xE8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF6\x67"],

        ["\xF6\x68",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xE9"],
        ["\xB6\xE9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF6\x68"],

        ["\xF6\x69",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xEA"],
        ["\xB6\xEA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF6\x69"],

        ["\xF6\x70",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xEB"],
        ["\xB6\xEB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF6\x70"],

        ["\xF6\x71",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xEC"],
        ["\xB6\xEC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF6\x71"],

        ["\xF6\x72",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xED"],
        ["\xB6\xED",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF6\x72"],

        ["\xF6\x73",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xEE"],
        ["\xB6\xEE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF6\x73"],

        ["\xF6\x74",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xEF"],
        ["\xB6\xEF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF6\x74"],

        ["\xF6\x75",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xF0"],
        ["\xB6\xF0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF6\x75"],

        ["\xF6\x76",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xF1"],
        ["\xB6\xF1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF6\x76"],

        ["\xF6\x77",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xF2"],
        ["\xB6\xF2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF6\x77"],

        ["\xF6\x78",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xF3"],
        ["\xB6\xF3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF6\x78"],

        ["\xF6\x80",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xF4"],
        ["\xB6\xF4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF6\x80"],

        ["\xF6\x8B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xF5"],
        ["\xB6\xF5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF6\x8B"],

        ["\xF6\x9B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xF6"],
        ["\xB6\xF6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF6\x9B"],

        ["\xF6\x9C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xF7"],
        ["\xB6\xF7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF6\x9C"],

        ["\xF6\xA0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xF8"],
        ["\xB6\xF8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF6\xA0"],

        ["\xF6\xAB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xF9"],
        ["\xB6\xF9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF6\xAB"],

        ["\xF6\xB0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xFA"],
        ["\xB6\xFA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF6\xB0"],

        ["\xF6\xC0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xFB"],
        ["\xB6\xFB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF6\xC0"],

        ["\xF6\x6A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xFC"],
        ["\xB6\xFC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF6\x6A"],

        ["\xF6\xD0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xFD"],
        ["\xB6\xFD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF6\xD0"],

        ["\xF6\xA1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB6\xFE"],
        ["\xB6\xFE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF6\xA1"],

        ["\xF7\x4F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xA1"],
        ["\xB7\xA1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF7\x4F"],

        ["\xF7\x7F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xA2"],
        ["\xB7\xA2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF7\x7F"],

        ["\xF7\x7B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xA3"],
        ["\xB7\xA3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF7\x7B"],

        ["\xF7\xE0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xA4"],
        ["\xB7\xA4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF7\xE0"],

        ["\xF7\x6C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xA5"],
        ["\xB7\xA5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF7\x6C"],

        ["\xF7\x50",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xA6"],
        ["\xB7\xA6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF7\x50"],

        ["\xF7\x7D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xA7"],
        ["\xB7\xA7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF7\x7D"],

        ["\xF7\x4D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xA8"],
        ["\xB7\xA8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF7\x4D"],

        ["\xF7\x5D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xA9"],
        ["\xB7\xA9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF7\x5D"],

        ["\xF7\x5C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xAA"],
        ["\xB7\xAA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF7\x5C"],

        ["\xF7\x4E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xAB"],
        ["\xB7\xAB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF7\x4E"],

        ["\xF7\x6B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xAC"],
        ["\xB7\xAC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF7\x6B"],

        ["\xF7\x60",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xAD"],
        ["\xB7\xAD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF7\x60"],

        ["\xF7\x4B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xAE"],
        ["\xB7\xAE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF7\x4B"],

        ["\xF7\x61",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xAF"],
        ["\xB7\xAF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF7\x61"],

        ["\xF7\xF0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xB0"],
        ["\xB7\xB0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF7\xF0"],

        ["\xF7\xF1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xB1"],
        ["\xB7\xB1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF7\xF1"],

        ["\xF7\xF2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xB2"],
        ["\xB7\xB2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF7\xF2"],

        ["\xF7\xF3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xB3"],
        ["\xB7\xB3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF7\xF3"],

        ["\xF7\xF4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xB4"],
        ["\xB7\xB4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF7\xF4"],

        ["\xF7\xF5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xB5"],
        ["\xB7\xB5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF7\xF5"],

        ["\xF7\xF6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xB6"],
        ["\xB7\xB6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF7\xF6"],

        ["\xF7\xF7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xB7"],
        ["\xB7\xB7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF7\xF7"],

        ["\xF7\xF8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xB8"],
        ["\xB7\xB8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF7\xF8"],

        ["\xF7\xF9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xB9"],
        ["\xB7\xB9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF7\xF9"],

        ["\xF7\x7A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xBA"],
        ["\xB7\xBA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF7\x7A"],

        ["\xF7\x5E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xBB"],
        ["\xB7\xBB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF7\x5E"],

        ["\xF7\x4C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xBC"],
        ["\xB7\xBC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF7\x4C"],

        ["\xF7\x7E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xBD"],
        ["\xB7\xBD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF7\x7E"],

        ["\xF7\x6E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xBE"],
        ["\xB7\xBE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF7\x6E"],

        ["\xF7\x6F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xBF"],
        ["\xB7\xBF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF7\x6F"],

        ["\xF7\x7C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xC0"],
        ["\xB7\xC0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF7\x7C"],

        ["\xF7\xC1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xC1"],
        ["\xB7\xC1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF7\xC1"],

        ["\xF7\xC2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xC2"],
        ["\xB7\xC2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF7\xC2"],

        ["\xF7\xC3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xC3"],
        ["\xB7\xC3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF7\xC3"],

        ["\xF7\xC4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xC4"],
        ["\xB7\xC4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF7\xC4"],

        ["\xF7\xC5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xC5"],
        ["\xB7\xC5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF7\xC5"],

        ["\xF7\xC6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xC6"],
        ["\xB7\xC6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF7\xC6"],

        ["\xF7\xC7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xC7"],
        ["\xB7\xC7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF7\xC7"],

        ["\xF7\xC8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xC8"],
        ["\xB7\xC8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF7\xC8"],

        ["\xF7\xC9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xC9"],
        ["\xB7\xC9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF7\xC9"],

        ["\xF7\xD1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xCA"],
        ["\xB7\xCA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF7\xD1"],

        ["\xF7\xD2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xCB"],
        ["\xB7\xCB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF7\xD2"],

        ["\xF7\xD3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xCC"],
        ["\xB7\xCC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF7\xD3"],

        ["\xF7\xD4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xCD"],
        ["\xB7\xCD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF7\xD4"],

        ["\xF7\xD5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xCE"],
        ["\xB7\xCE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF7\xD5"],

        ["\xF7\xD6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xCF"],
        ["\xB7\xCF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF7\xD6"],

        ["\xF7\xD7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xD0"],
        ["\xB7\xD0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF7\xD7"],

        ["\xF7\xD8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xD1"],
        ["\xB7\xD1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF7\xD8"],

        ["\xF7\xD9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xD2"],
        ["\xB7\xD2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF7\xD9"],

        ["\xF7\xE2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xD3"],
        ["\xB7\xD3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF7\xE2"],

        ["\xF7\xE3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xD4"],
        ["\xB7\xD4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF7\xE3"],

        ["\xF7\xE4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xD5"],
        ["\xB7\xD5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF7\xE4"],

        ["\xF7\xE5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xD6"],
        ["\xB7\xD6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF7\xE5"],

        ["\xF7\xE6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xD7"],
        ["\xB7\xD7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF7\xE6"],

        ["\xF7\xE7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xD8"],
        ["\xB7\xD8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF7\xE7"],

        ["\xF7\xE8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xD9"],
        ["\xB7\xD9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF7\xE8"],

        ["\xF7\xE9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xDA"],
        ["\xB7\xDA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF7\xE9"],

        ["\x75\x80",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xDB"],
        ["\xB7\xDB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x75\x80"],

        ["\xF7\x5B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xDC"],
        ["\xB7\xDC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF7\x5B"],

        ["\xF7\x5A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xDD"],
        ["\xB7\xDD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF7\x5A"],

        ["\xF7\x5F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xDE"],
        ["\xB7\xDE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF7\x5F"],

        ["\xF7\x6D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xDF"],
        ["\xB7\xDF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF7\x6D"],

        ["\xF7\x79",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xE0"],
        ["\xB7\xE0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF7\x79"],

        ["\xF7\x57",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xE1"],
        ["\xB7\xE1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF7\x57"],

        ["\xF7\x59",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xE2"],
        ["\xB7\xE2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF7\x59"],

        ["\xF7\x62",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xE3"],
        ["\xB7\xE3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF7\x62"],

        ["\xF7\x63",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xE4"],
        ["\xB7\xE4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF7\x63"],

        ["\xF7\x64",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xE5"],
        ["\xB7\xE5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF7\x64"],

        ["\xF7\x65",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xE6"],
        ["\xB7\xE6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF7\x65"],

        ["\xF7\x66",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xE7"],
        ["\xB7\xE7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF7\x66"],

        ["\xF7\x67",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xE8"],
        ["\xB7\xE8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF7\x67"],

        ["\xF7\x68",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xE9"],
        ["\xB7\xE9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF7\x68"],

        ["\xF7\x69",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xEA"],
        ["\xB7\xEA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF7\x69"],

        ["\xF7\x70",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xEB"],
        ["\xB7\xEB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF7\x70"],

        ["\xF7\x71",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xEC"],
        ["\xB7\xEC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF7\x71"],

        ["\xF7\x72",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xED"],
        ["\xB7\xED",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF7\x72"],

        ["\xF7\x73",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xEE"],
        ["\xB7\xEE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF7\x73"],

        ["\xF7\x74",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xEF"],
        ["\xB7\xEF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF7\x74"],

        ["\xF7\x75",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xF0"],
        ["\xB7\xF0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF7\x75"],

        ["\xF7\x76",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xF1"],
        ["\xB7\xF1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF7\x76"],

        ["\xF7\x77",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xF2"],
        ["\xB7\xF2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF7\x77"],

        ["\xF7\x78",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xF3"],
        ["\xB7\xF3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF7\x78"],

        ["\xF7\x80",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xF4"],
        ["\xB7\xF4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF7\x80"],

        ["\xF7\x8B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xF5"],
        ["\xB7\xF5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF7\x8B"],

        ["\xF7\x9B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xF6"],
        ["\xB7\xF6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF7\x9B"],

        ["\xF7\x9C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xF7"],
        ["\xB7\xF7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF7\x9C"],

        ["\xF7\xA0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xF8"],
        ["\xB7\xF8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF7\xA0"],

        ["\xF7\xAB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xF9"],
        ["\xB7\xF9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF7\xAB"],

        ["\xF7\xB0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xFA"],
        ["\xB7\xFA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF7\xB0"],

        ["\xF7\xC0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xFB"],
        ["\xB7\xFB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF7\xC0"],

        ["\xF7\x6A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xFC"],
        ["\xB7\xFC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF7\x6A"],

        ["\xF7\xD0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xFD"],
        ["\xB7\xFD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF7\xD0"],

        ["\xF7\xA1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB7\xFE"],
        ["\xB7\xFE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF7\xA1"],

        ["\xF8\x4F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xA1"],
        ["\xB8\xA1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF8\x4F"],

        ["\xF8\x7F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xA2"],
        ["\xB8\xA2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF8\x7F"],

        ["\xF8\x7B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xA3"],
        ["\xB8\xA3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF8\x7B"],

        ["\xF8\xE0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xA4"],
        ["\xB8\xA4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF8\xE0"],

        ["\xF8\x6C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xA5"],
        ["\xB8\xA5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF8\x6C"],

        ["\xF8\x50",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xA6"],
        ["\xB8\xA6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF8\x50"],

        ["\xF8\x7D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xA7"],
        ["\xB8\xA7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF8\x7D"],

        ["\xF8\x4D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xA8"],
        ["\xB8\xA8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF8\x4D"],

        ["\xF8\x5D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xA9"],
        ["\xB8\xA9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF8\x5D"],

        ["\xF8\x5C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xAA"],
        ["\xB8\xAA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF8\x5C"],

        ["\xF8\x4E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xAB"],
        ["\xB8\xAB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF8\x4E"],

        ["\xF8\x6B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xAC"],
        ["\xB8\xAC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF8\x6B"],

        ["\xF8\x60",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xAD"],
        ["\xB8\xAD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF8\x60"],

        ["\xF8\x4B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xAE"],
        ["\xB8\xAE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF8\x4B"],

        ["\xF8\x61",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xAF"],
        ["\xB8\xAF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF8\x61"],

        ["\xF8\xF0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xB0"],
        ["\xB8\xB0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF8\xF0"],

        ["\xF8\xF1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xB1"],
        ["\xB8\xB1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF8\xF1"],

        ["\xF8\xF2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xB2"],
        ["\xB8\xB2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF8\xF2"],

        ["\xF8\xF3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xB3"],
        ["\xB8\xB3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF8\xF3"],

        ["\xF8\xF4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xB4"],
        ["\xB8\xB4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF8\xF4"],

        ["\xF8\xF5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xB5"],
        ["\xB8\xB5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF8\xF5"],

        ["\xF8\xF6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xB6"],
        ["\xB8\xB6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF8\xF6"],

        ["\xF8\xF7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xB7"],
        ["\xB8\xB7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF8\xF7"],

        ["\xF8\xF8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xB8"],
        ["\xB8\xB8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF8\xF8"],

        ["\xF8\xF9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xB9"],
        ["\xB8\xB9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF8\xF9"],

        ["\xF8\x7A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xBA"],
        ["\xB8\xBA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF8\x7A"],

        ["\xF8\x5E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xBB"],
        ["\xB8\xBB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF8\x5E"],

        ["\xF8\x4C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xBC"],
        ["\xB8\xBC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF8\x4C"],

        ["\xF8\x7E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xBD"],
        ["\xB8\xBD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF8\x7E"],

        ["\xF8\x6E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xBE"],
        ["\xB8\xBE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF8\x6E"],

        ["\xF8\x6F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xBF"],
        ["\xB8\xBF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF8\x6F"],

        ["\xF8\x7C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xC0"],
        ["\xB8\xC0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF8\x7C"],

        ["\xF8\xC1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xC1"],
        ["\xB8\xC1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF8\xC1"],

        ["\xF8\xC2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xC2"],
        ["\xB8\xC2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF8\xC2"],

        ["\xF8\xC3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xC3"],
        ["\xB8\xC3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF8\xC3"],

        ["\xF8\xC4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xC4"],
        ["\xB8\xC4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF8\xC4"],

        ["\xF8\xC5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xC5"],
        ["\xB8\xC5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF8\xC5"],

        ["\xF8\xC6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xC6"],
        ["\xB8\xC6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF8\xC6"],

        ["\xF8\xC7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xC7"],
        ["\xB8\xC7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF8\xC7"],

        ["\xF8\xC8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xC8"],
        ["\xB8\xC8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF8\xC8"],

        ["\xF8\xC9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xC9"],
        ["\xB8\xC9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF8\xC9"],

        ["\xF8\xD1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xCA"],
        ["\xB8\xCA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF8\xD1"],

        ["\xF8\xD2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xCB"],
        ["\xB8\xCB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF8\xD2"],

        ["\xF8\xD3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xCC"],
        ["\xB8\xCC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF8\xD3"],

        ["\xF8\xD4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xCD"],
        ["\xB8\xCD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF8\xD4"],

        ["\xF8\xD5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xCE"],
        ["\xB8\xCE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF8\xD5"],

        ["\xF8\xD6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xCF"],
        ["\xB8\xCF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF8\xD6"],

        ["\xF8\xD7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xD0"],
        ["\xB8\xD0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF8\xD7"],

        ["\xF8\xD8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xD1"],
        ["\xB8\xD1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF8\xD8"],

        ["\xF8\xD9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xD2"],
        ["\xB8\xD2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF8\xD9"],

        ["\xF8\xE2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xD3"],
        ["\xB8\xD3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF8\xE2"],

        ["\xF8\xE3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xD4"],
        ["\xB8\xD4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF8\xE3"],

        ["\xF8\xE4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xD5"],
        ["\xB8\xD5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF8\xE4"],

        ["\xF8\xE5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xD6"],
        ["\xB8\xD6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF8\xE5"],

        ["\xF8\xE6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xD7"],
        ["\xB8\xD7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF8\xE6"],

        ["\xF8\xE7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xD8"],
        ["\xB8\xD8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF8\xE7"],

        ["\xF8\xE8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xD9"],
        ["\xB8\xD9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF8\xE8"],

        ["\xF8\xE9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xDA"],
        ["\xB8\xDA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF8\xE9"],

        ["\xF8\x4A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xDB"],
        ["\xB8\xDB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF8\x4A"],

        ["\xF8\x5B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xDC"],
        ["\xB8\xDC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF8\x5B"],

        ["\xF8\x5A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xDD"],
        ["\xB8\xDD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF8\x5A"],

        ["\xF8\x5F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xDE"],
        ["\xB8\xDE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF8\x5F"],

        ["\xF8\x6D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xDF"],
        ["\xB8\xDF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF8\x6D"],

        ["\xF8\x79",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xE0"],
        ["\xB8\xE0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF8\x79"],

        ["\xF8\x57",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xE1"],
        ["\xB8\xE1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF8\x57"],

        ["\xF8\x59",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xE2"],
        ["\xB8\xE2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF8\x59"],

        ["\xF8\x62",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xE3"],
        ["\xB8\xE3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF8\x62"],

        ["\xF8\x63",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xE4"],
        ["\xB8\xE4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF8\x63"],

        ["\xF8\x64",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xE5"],
        ["\xB8\xE5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF8\x64"],

        ["\xF8\x65",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xE6"],
        ["\xB8\xE6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF8\x65"],

        ["\xF8\x66",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xE7"],
        ["\xB8\xE7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF8\x66"],

        ["\xF8\x67",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xE8"],
        ["\xB8\xE8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF8\x67"],

        ["\xF8\x68",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xE9"],
        ["\xB8\xE9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF8\x68"],

        ["\xF8\x69",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xEA"],
        ["\xB8\xEA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF8\x69"],

        ["\xF8\x70",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xEB"],
        ["\xB8\xEB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF8\x70"],

        ["\xF8\x71",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xEC"],
        ["\xB8\xEC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF8\x71"],

        ["\xF8\x72",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xED"],
        ["\xB8\xED",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF8\x72"],

        ["\xF8\x73",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xEE"],
        ["\xB8\xEE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF8\x73"],

        ["\xF8\x74",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xEF"],
        ["\xB8\xEF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF8\x74"],

        ["\xF8\x75",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xF0"],
        ["\xB8\xF0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF8\x75"],

        ["\xF8\x76",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xF1"],
        ["\xB8\xF1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF8\x76"],

        ["\xF8\x77",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xF2"],
        ["\xB8\xF2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF8\x77"],

        ["\xF8\x78",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xF3"],
        ["\xB8\xF3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF8\x78"],

        ["\xF8\x80",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xF4"],
        ["\xB8\xF4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF8\x80"],

        ["\xF8\x8B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xF5"],
        ["\xB8\xF5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF8\x8B"],

        ["\xF8\x9B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xF6"],
        ["\xB8\xF6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF8\x9B"],

        ["\xF8\x9C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xF7"],
        ["\xB8\xF7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF8\x9C"],

        ["\xF8\xA0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xF8"],
        ["\xB8\xF8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF8\xA0"],

        ["\xF8\xAB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xF9"],
        ["\xB8\xF9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF8\xAB"],

        ["\xF8\xB0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xFA"],
        ["\xB8\xFA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF8\xB0"],

        ["\xF8\xC0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xFB"],
        ["\xB8\xFB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF8\xC0"],

        ["\xF8\x6A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xFC"],
        ["\xB8\xFC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF8\x6A"],

        ["\xF8\xD0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xFD"],
        ["\xB8\xFD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF8\xD0"],

        ["\xF8\xA1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB8\xFE"],
        ["\xB8\xFE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF8\xA1"],

        ["\xF9\x4F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xA1"],
        ["\xB9\xA1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF9\x4F"],

        ["\xF9\x7F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xA2"],
        ["\xB9\xA2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF9\x7F"],

        ["\xF9\x7B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xA3"],
        ["\xB9\xA3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF9\x7B"],

        ["\xF9\xE0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xA4"],
        ["\xB9\xA4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF9\xE0"],

        ["\xF9\x6C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xA5"],
        ["\xB9\xA5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF9\x6C"],

        ["\xF9\x50",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xA6"],
        ["\xB9\xA6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF9\x50"],

        ["\xF9\x7D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xA7"],
        ["\xB9\xA7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF9\x7D"],

        ["\xF9\x4D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xA8"],
        ["\xB9\xA8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF9\x4D"],

        ["\xF9\x5D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xA9"],
        ["\xB9\xA9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF9\x5D"],

        ["\xF9\x5C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xAA"],
        ["\xB9\xAA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF9\x5C"],

        ["\xF9\x4E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xAB"],
        ["\xB9\xAB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF9\x4E"],

        ["\xF9\x6B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xAC"],
        ["\xB9\xAC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF9\x6B"],

        ["\xF9\x60",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xAD"],
        ["\xB9\xAD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF9\x60"],

        ["\xF9\x4B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xAE"],
        ["\xB9\xAE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF9\x4B"],

        ["\xF9\x61",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xAF"],
        ["\xB9\xAF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF9\x61"],

        ["\xF9\xF0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xB0"],
        ["\xB9\xB0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF9\xF0"],

        ["\xF9\xF1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xB1"],
        ["\xB9\xB1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF9\xF1"],

        ["\xF9\xF2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xB2"],
        ["\xB9\xB2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF9\xF2"],

        ["\xF9\xF3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xB3"],
        ["\xB9\xB3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF9\xF3"],

        ["\xF9\xF4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xB4"],
        ["\xB9\xB4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF9\xF4"],

        ["\xF9\xF5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xB5"],
        ["\xB9\xB5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF9\xF5"],

        ["\xF9\xF6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xB6"],
        ["\xB9\xB6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF9\xF6"],

        ["\x8E\x86",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xB7"],
        ["\xB9\xB7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x8E\x86"],

        ["\xF9\xF8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xB8"],
        ["\xB9\xB8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF9\xF8"],

        ["\xF9\xF9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xB9"],
        ["\xB9\xB9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF9\xF9"],

        ["\xF9\x7A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xBA"],
        ["\xB9\xBA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF9\x7A"],

        ["\xF9\x5E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xBB"],
        ["\xB9\xBB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF9\x5E"],

        ["\xF9\x4C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xBC"],
        ["\xB9\xBC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF9\x4C"],

        ["\xF9\x7E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xBD"],
        ["\xB9\xBD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF9\x7E"],

        ["\xF9\x6E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xBE"],
        ["\xB9\xBE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF9\x6E"],

        ["\xF9\x6F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xBF"],
        ["\xB9\xBF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF9\x6F"],

        ["\xF9\x7C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xC0"],
        ["\xB9\xC0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF9\x7C"],

        ["\xF9\xC1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xC1"],
        ["\xB9\xC1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF9\xC1"],

        ["\xF9\xC2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xC2"],
        ["\xB9\xC2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF9\xC2"],

        ["\xF9\xC3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xC3"],
        ["\xB9\xC3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF9\xC3"],

        ["\xF9\xC4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xC4"],
        ["\xB9\xC4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF9\xC4"],

        ["\xF9\xC5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xC5"],
        ["\xB9\xC5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF9\xC5"],

        ["\xF9\xC6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xC6"],
        ["\xB9\xC6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF9\xC6"],

        ["\xF9\xC7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xC7"],
        ["\xB9\xC7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF9\xC7"],

        ["\xF9\xC8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xC8"],
        ["\xB9\xC8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF9\xC8"],

        ["\xF9\xC9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xC9"],
        ["\xB9\xC9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF9\xC9"],

        ["\xF9\xD1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xCA"],
        ["\xB9\xCA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF9\xD1"],

        ["\xF9\xD2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xCB"],
        ["\xB9\xCB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF9\xD2"],

        ["\xF9\xD3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xCC"],
        ["\xB9\xCC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF9\xD3"],

        ["\xF9\xD4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xCD"],
        ["\xB9\xCD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF9\xD4"],

        ["\xF9\xD5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xCE"],
        ["\xB9\xCE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF9\xD5"],

        ["\xF9\xD6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xCF"],
        ["\xB9\xCF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF9\xD6"],

        ["\xF9\xD7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xD0"],
        ["\xB9\xD0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF9\xD7"],

        ["\xF9\xD8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xD1"],
        ["\xB9\xD1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF9\xD8"],

        ["\xF9\xD9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xD2"],
        ["\xB9\xD2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF9\xD9"],

        ["\xF9\xE2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xD3"],
        ["\xB9\xD3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF9\xE2"],

        ["\xF9\xE3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xD4"],
        ["\xB9\xD4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF9\xE3"],

        ["\xF9\xE4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xD5"],
        ["\xB9\xD5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF9\xE4"],

        ["\xF9\xE5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xD6"],
        ["\xB9\xD6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF9\xE5"],

        ["\xF9\xE6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xD7"],
        ["\xB9\xD7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF9\xE6"],

        ["\xF9\xE7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xD8"],
        ["\xB9\xD8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF9\xE7"],

        ["\xF9\xE8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xD9"],
        ["\xB9\xD9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF9\xE8"],

        ["\xF9\xE9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xDA"],
        ["\xB9\xDA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF9\xE9"],

        ["\xF9\x4A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xDB"],
        ["\xB9\xDB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF9\x4A"],

        ["\x59\x67",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xDC"],
        ["\xB9\xDC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\x67"],

        ["\xF9\x5A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xDD"],
        ["\xB9\xDD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF9\x5A"],

        ["\xF9\x5F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xDE"],
        ["\xB9\xDE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF9\x5F"],

        ["\xF9\x6D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xDF"],
        ["\xB9\xDF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF9\x6D"],

        ["\xF9\x79",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xE0"],
        ["\xB9\xE0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF9\x79"],

        ["\xF9\x57",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xE1"],
        ["\xB9\xE1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF9\x57"],

        ["\xF9\x59",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xE2"],
        ["\xB9\xE2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF9\x59"],

        ["\xF9\x62",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xE3"],
        ["\xB9\xE3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF9\x62"],

        ["\xF9\x63",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xE4"],
        ["\xB9\xE4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF9\x63"],

        ["\xF9\x64",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xE5"],
        ["\xB9\xE5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF9\x64"],

        ["\xF9\x65",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xE6"],
        ["\xB9\xE6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF9\x65"],

        ["\xF9\x66",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xE7"],
        ["\xB9\xE7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF9\x66"],

        ["\xF9\x67",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xE8"],
        ["\xB9\xE8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF9\x67"],

        ["\xF9\x68",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xE9"],
        ["\xB9\xE9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF9\x68"],

        ["\xF9\x69",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xEA"],
        ["\xB9\xEA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF9\x69"],

        ["\xF9\x70",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xEB"],
        ["\xB9\xEB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF9\x70"],

        ["\xF9\x71",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xEC"],
        ["\xB9\xEC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF9\x71"],

        ["\xAC\x8C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xED"],
        ["\xB9\xED",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xAC\x8C"],

        ["\xF9\x73",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xEE"],
        ["\xB9\xEE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF9\x73"],

        ["\xF9\x74",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xEF"],
        ["\xB9\xEF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF9\x74"],

        ["\xF9\x75",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xF0"],
        ["\xB9\xF0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF9\x75"],

        ["\xF9\x76",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xF1"],
        ["\xB9\xF1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF9\x76"],

        ["\xF9\x77",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xF2"],
        ["\xB9\xF2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF9\x77"],

        ["\xF9\x78",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xF3"],
        ["\xB9\xF3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF9\x78"],

        ["\xF9\x80",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xF4"],
        ["\xB9\xF4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF9\x80"],

        ["\xF9\x8B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xF5"],
        ["\xB9\xF5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF9\x8B"],

        ["\xF9\x9B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xF6"],
        ["\xB9\xF6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF9\x9B"],

        ["\xF9\x9C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xF7"],
        ["\xB9\xF7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF9\x9C"],

        ["\xF9\xA0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xF8"],
        ["\xB9\xF8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF9\xA0"],

        ["\xF9\xAB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xF9"],
        ["\xB9\xF9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF9\xAB"],

        ["\xF9\xB0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xFA"],
        ["\xB9\xFA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF9\xB0"],

        ["\xF9\xC0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xFB"],
        ["\xB9\xFB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF9\xC0"],

        ["\xF9\x6A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xFC"],
        ["\xB9\xFC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF9\x6A"],

        ["\xF9\xD0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xFD"],
        ["\xB9\xFD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF9\xD0"],

        ["\xF9\xA1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB9\xFE"],
        ["\xB9\xFE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF9\xA1"],

        ["\x7A\x4F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xA1"],
        ["\xBA\xA1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7A\x4F"],

        ["\x7A\x7F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xA2"],
        ["\xBA\xA2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7A\x7F"],

        ["\x7A\x7B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xA3"],
        ["\xBA\xA3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7A\x7B"],

        ["\x7A\xE0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xA4"],
        ["\xBA\xA4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7A\xE0"],

        ["\x7A\x6C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xA5"],
        ["\xBA\xA5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7A\x6C"],

        ["\x7A\x50",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xA6"],
        ["\xBA\xA6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7A\x50"],

        ["\x7A\x7D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xA7"],
        ["\xBA\xA7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7A\x7D"],

        ["\x7A\x4D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xA8"],
        ["\xBA\xA8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7A\x4D"],

        ["\x7A\x5D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xA9"],
        ["\xBA\xA9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7A\x5D"],

        ["\x7A\x5C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xAA"],
        ["\xBA\xAA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7A\x5C"],

        ["\x7A\x4E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xAB"],
        ["\xBA\xAB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7A\x4E"],

        ["\x7A\x6B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xAC"],
        ["\xBA\xAC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7A\x6B"],

        ["\x7A\x60",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xAD"],
        ["\xBA\xAD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7A\x60"],

        ["\x7A\x4B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xAE"],
        ["\xBA\xAE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7A\x4B"],

        ["\x7A\x61",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xAF"],
        ["\xBA\xAF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7A\x61"],

        ["\x7A\xF0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xB0"],
        ["\xBA\xB0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7A\xF0"],

        ["\x7A\xF1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xB1"],
        ["\xBA\xB1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7A\xF1"],

        ["\x7A\xF2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xB2"],
        ["\xBA\xB2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7A\xF2"],

        ["\x7A\xF3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xB3"],
        ["\xBA\xB3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7A\xF3"],

        ["\x7A\xF4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xB4"],
        ["\xBA\xB4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7A\xF4"],

        ["\x7A\xF5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xB5"],
        ["\xBA\xB5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7A\xF5"],

        ["\x7A\xF6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xB6"],
        ["\xBA\xB6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7A\xF6"],

        ["\x7A\xF7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xB7"],
        ["\xBA\xB7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7A\xF7"],

        ["\x7A\xF8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xB8"],
        ["\xBA\xB8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7A\xF8"],

        ["\x7A\xF9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xB9"],
        ["\xBA\xB9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7A\xF9"],

        ["\x7A\x7A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xBA"],
        ["\xBA\xBA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7A\x7A"],

        ["\x7A\x5E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xBB"],
        ["\xBA\xBB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7A\x5E"],

        ["\x7A\x4C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xBC"],
        ["\xBA\xBC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7A\x4C"],

        ["\x7A\x7E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xBD"],
        ["\xBA\xBD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7A\x7E"],

        ["\x7A\x6E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xBE"],
        ["\xBA\xBE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7A\x6E"],

        ["\x7A\x6F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xBF"],
        ["\xBA\xBF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7A\x6F"],

        ["\x7A\x7C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xC0"],
        ["\xBA\xC0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7A\x7C"],

        ["\x7A\xC1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xC1"],
        ["\xBA\xC1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7A\xC1"],

        ["\x7A\xC2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xC2"],
        ["\xBA\xC2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7A\xC2"],

        ["\x7A\xC3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xC3"],
        ["\xBA\xC3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7A\xC3"],

        ["\x7A\xC4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xC4"],
        ["\xBA\xC4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7A\xC4"],

        ["\x7A\xC5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xC5"],
        ["\xBA\xC5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7A\xC5"],

        ["\x7A\xC6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xC6"],
        ["\xBA\xC6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7A\xC6"],

        ["\x7A\xC7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xC7"],
        ["\xBA\xC7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7A\xC7"],

        ["\x7A\xC8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xC8"],
        ["\xBA\xC8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7A\xC8"],

        ["\x7A\xC9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xC9"],
        ["\xBA\xC9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7A\xC9"],

        ["\x7A\xD1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xCA"],
        ["\xBA\xCA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7A\xD1"],

        ["\x7A\xD2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xCB"],
        ["\xBA\xCB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7A\xD2"],

        ["\x7A\xD3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xCC"],
        ["\xBA\xCC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7A\xD3"],

        ["\x7A\xD4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xCD"],
        ["\xBA\xCD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7A\xD4"],

        ["\x7A\xD5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xCE"],
        ["\xBA\xCE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7A\xD5"],

        ["\x7A\xD6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xCF"],
        ["\xBA\xCF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7A\xD6"],

        ["\x7A\xD7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xD0"],
        ["\xBA\xD0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7A\xD7"],

        ["\x7A\xD8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xD1"],
        ["\xBA\xD1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7A\xD8"],

        ["\x7A\xD9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xD2"],
        ["\xBA\xD2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7A\xD9"],

        ["\x7A\xE2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xD3"],
        ["\xBA\xD3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7A\xE2"],

        ["\x7A\xE3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xD4"],
        ["\xBA\xD4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7A\xE3"],

        ["\x7A\xE4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xD5"],
        ["\xBA\xD5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7A\xE4"],

        ["\x7A\xE5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xD6"],
        ["\xBA\xD6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7A\xE5"],

        ["\x7A\xE6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xD7"],
        ["\xBA\xD7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7A\xE6"],

        ["\x7A\xE7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xD8"],
        ["\xBA\xD8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7A\xE7"],

        ["\x7A\xE8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xD9"],
        ["\xBA\xD9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7A\xE8"],

        ["\x7A\xE9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xDA"],
        ["\xBA\xDA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7A\xE9"],

        ["\x7A\x4A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xDB"],
        ["\xBA\xDB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7A\x4A"],

        ["\x7A\x5B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xDC"],
        ["\xBA\xDC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7A\x5B"],

        ["\x7A\x5A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xDD"],
        ["\xBA\xDD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7A\x5A"],

        ["\x7A\x5F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xDE"],
        ["\xBA\xDE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7A\x5F"],

        ["\x7A\x6D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xDF"],
        ["\xBA\xDF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7A\x6D"],

        ["\x7A\x79",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xE0"],
        ["\xBA\xE0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7A\x79"],

        ["\x7A\x57",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xE1"],
        ["\xBA\xE1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7A\x57"],

        ["\x7A\x59",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xE2"],
        ["\xBA\xE2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7A\x59"],

        ["\x7A\x62",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xE3"],
        ["\xBA\xE3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7A\x62"],

        ["\x7A\x63",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xE4"],
        ["\xBA\xE4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7A\x63"],

        ["\x7A\x64",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xE5"],
        ["\xBA\xE5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7A\x64"],

        ["\x7A\x65",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xE6"],
        ["\xBA\xE6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7A\x65"],

        ["\x7A\x66",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xE7"],
        ["\xBA\xE7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7A\x66"],

        ["\x7A\x67",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xE8"],
        ["\xBA\xE8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7A\x67"],

        ["\x7A\x68",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xE9"],
        ["\xBA\xE9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7A\x68"],

        ["\x7A\x69",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xEA"],
        ["\xBA\xEA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7A\x69"],

        ["\x7A\x70",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xEB"],
        ["\xBA\xEB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7A\x70"],

        ["\x7A\x71",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xEC"],
        ["\xBA\xEC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7A\x71"],

        ["\x7A\x72",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xED"],
        ["\xBA\xED",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7A\x72"],

        ["\x7A\x73",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xEE"],
        ["\xBA\xEE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7A\x73"],

        ["\x7A\x74",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xEF"],
        ["\xBA\xEF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7A\x74"],

        ["\x7A\x75",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xF0"],
        ["\xBA\xF0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7A\x75"],

        ["\x7A\x76",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xF1"],
        ["\xBA\xF1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7A\x76"],

        ["\x7A\x77",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xF2"],
        ["\xBA\xF2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7A\x77"],

        ["\x7A\x78",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xF3"],
        ["\xBA\xF3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7A\x78"],

        ["\x7A\x80",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xF4"],
        ["\xBA\xF4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7A\x80"],

        ["\x7A\x8B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xF5"],
        ["\xBA\xF5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7A\x8B"],

        ["\x7A\x9B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xF6"],
        ["\xBA\xF6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7A\x9B"],

        ["\x7A\x9C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xF7"],
        ["\xBA\xF7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7A\x9C"],

        ["\x7A\xA0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xF8"],
        ["\xBA\xF8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7A\xA0"],

        ["\x7A\xAB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xF9"],
        ["\xBA\xF9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7A\xAB"],

        ["\x7A\xB0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xFA"],
        ["\xBA\xFA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7A\xB0"],

        ["\x7A\xC0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xFB"],
        ["\xBA\xFB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7A\xC0"],

        ["\x7A\x6A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xFC"],
        ["\xBA\xFC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7A\x6A"],

        ["\x7A\xD0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xFD"],
        ["\xBA\xFD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7A\xD0"],

        ["\x7A\xA1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBA\xFE"],
        ["\xBA\xFE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7A\xA1"],

        ["\x5E\x4F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xA1"],
        ["\xBB\xA1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\x4F"],

        ["\x5E\x7F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xA2"],
        ["\xBB\xA2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\x7F"],

        ["\x5E\x7B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xA3"],
        ["\xBB\xA3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\x7B"],

        ["\x5E\xE0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xA4"],
        ["\xBB\xA4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\xE0"],

        ["\x5E\x6C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xA5"],
        ["\xBB\xA5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\x6C"],

        ["\x5E\x50",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xA6"],
        ["\xBB\xA6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\x50"],

        ["\x5E\x7D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xA7"],
        ["\xBB\xA7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\x7D"],

        ["\x5E\x4D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xA8"],
        ["\xBB\xA8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\x4D"],

        ["\x5E\x5D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xA9"],
        ["\xBB\xA9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\x5D"],

        ["\x5E\x5C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xAA"],
        ["\xBB\xAA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\x5C"],

        ["\x5E\x4E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xAB"],
        ["\xBB\xAB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\x4E"],

        ["\x5E\x6B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xAC"],
        ["\xBB\xAC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\x6B"],

        ["\x5E\x60",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xAD"],
        ["\xBB\xAD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\x60"],

        ["\x5E\x4B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xAE"],
        ["\xBB\xAE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\x4B"],

        ["\x5E\x61",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xAF"],
        ["\xBB\xAF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\x61"],

        ["\x5E\xF0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xB0"],
        ["\xBB\xB0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\xF0"],

        ["\x5E\xF1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xB1"],
        ["\xBB\xB1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\xF1"],

        ["\x5E\xF2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xB2"],
        ["\xBB\xB2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\xF2"],

        ["\x5E\xF3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xB3"],
        ["\xBB\xB3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\xF3"],

        ["\x5E\xF4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xB4"],
        ["\xBB\xB4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\xF4"],

        ["\x5E\xF5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xB5"],
        ["\xBB\xB5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\xF5"],

        ["\x5E\xF6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xB6"],
        ["\xBB\xB6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\xF6"],

        ["\x5E\xF7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xB7"],
        ["\xBB\xB7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\xF7"],

        ["\x5E\xF8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xB8"],
        ["\xBB\xB8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\xF8"],

        ["\x5E\xF9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xB9"],
        ["\xBB\xB9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\xF9"],

        ["\x5E\x7A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xBA"],
        ["\xBB\xBA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\x7A"],

        ["\x5E\x5E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xBB"],
        ["\xBB\xBB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\x5E"],

        ["\x5E\x4C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xBC"],
        ["\xBB\xBC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\x4C"],

        ["\x5E\x7E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xBD"],
        ["\xBB\xBD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\x7E"],

        ["\x5E\x6E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xBE"],
        ["\xBB\xBE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\x6E"],

        ["\x5E\x6F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xBF"],
        ["\xBB\xBF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\x6F"],

        ["\x5E\x7C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xC0"],
        ["\xBB\xC0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\x7C"],

        ["\x5E\xC1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xC1"],
        ["\xBB\xC1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\xC1"],

        ["\x5E\xC2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xC2"],
        ["\xBB\xC2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\xC2"],

        ["\x5E\xC3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xC3"],
        ["\xBB\xC3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\xC3"],

        ["\x5E\xC4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xC4"],
        ["\xBB\xC4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\xC4"],

        ["\x5E\xC5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xC5"],
        ["\xBB\xC5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\xC5"],

        ["\x5E\xC6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xC6"],
        ["\xBB\xC6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\xC6"],

        ["\x5E\xC7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xC7"],
        ["\xBB\xC7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\xC7"],

        ["\x5E\xC8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xC8"],
        ["\xBB\xC8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\xC8"],

        ["\x5E\xC9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xC9"],
        ["\xBB\xC9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\xC9"],

        ["\x5E\xD1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xCA"],
        ["\xBB\xCA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\xD1"],

        ["\x5E\xD2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xCB"],
        ["\xBB\xCB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\xD2"],

        ["\x5E\xD3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xCC"],
        ["\xBB\xCC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\xD3"],

        ["\x5E\xD4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xCD"],
        ["\xBB\xCD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\xD4"],

        ["\x5E\xD5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xCE"],
        ["\xBB\xCE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\xD5"],

        ["\x5E\xD6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xCF"],
        ["\xBB\xCF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\xD6"],

        ["\x5E\xD7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xD0"],
        ["\xBB\xD0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\xD7"],

        ["\x5E\xD8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xD1"],
        ["\xBB\xD1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\xD8"],

        ["\x5E\xD9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xD2"],
        ["\xBB\xD2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\xD9"],

        ["\x5E\xE2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xD3"],
        ["\xBB\xD3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\xE2"],

        ["\x5E\xE3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xD4"],
        ["\xBB\xD4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\xE3"],

        ["\x5E\xE4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xD5"],
        ["\xBB\xD5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\xE4"],

        ["\x5E\xE5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xD6"],
        ["\xBB\xD6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\xE5"],

        ["\x5E\xE6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xD7"],
        ["\xBB\xD7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\xE6"],

        ["\x5E\xE7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xD8"],
        ["\xBB\xD8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\xE7"],

        ["\x5E\xE8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xD9"],
        ["\xBB\xD9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\xE8"],

        ["\x5E\xE9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xDA"],
        ["\xBB\xDA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\xE9"],

        ["\x5E\x4A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xDB"],
        ["\xBB\xDB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\x4A"],

        ["\x5E\x5B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xDC"],
        ["\xBB\xDC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\x5B"],

        ["\x5E\x5A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xDD"],
        ["\xBB\xDD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\x5A"],

        ["\x5E\x5F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xDE"],
        ["\xBB\xDE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\x5F"],

        ["\x5E\x6D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xDF"],
        ["\xBB\xDF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\x6D"],

        ["\x5E\x79",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xE0"],
        ["\xBB\xE0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\x79"],

        ["\x5E\x57",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xE1"],
        ["\xBB\xE1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\x57"],

        ["\x5E\x59",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xE2"],
        ["\xBB\xE2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\x59"],

        ["\x5E\x62",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xE3"],
        ["\xBB\xE3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\x62"],

        ["\x5E\x63",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xE4"],
        ["\xBB\xE4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\x63"],

        ["\x5E\x64",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xE5"],
        ["\xBB\xE5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\x64"],

        ["\x5E\x65",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xE6"],
        ["\xBB\xE6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\x65"],

        ["\x5E\x66",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xE7"],
        ["\xBB\xE7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\x66"],

        ["\x5E\x67",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xE8"],
        ["\xBB\xE8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\x67"],

        ["\x5E\x68",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xE9"],
        ["\xBB\xE9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\x68"],

        ["\x5E\x69",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xEA"],
        ["\xBB\xEA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\x69"],

        ["\x5E\x70",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xEB"],
        ["\xBB\xEB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\x70"],

        ["\x5E\x71",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xEC"],
        ["\xBB\xEC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\x71"],

        ["\x5E\x72",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xED"],
        ["\xBB\xED",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\x72"],

        ["\x5E\x73",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xEE"],
        ["\xBB\xEE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\x73"],

        ["\x5E\x74",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xEF"],
        ["\xBB\xEF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\x74"],

        ["\x5E\x75",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xF0"],
        ["\xBB\xF0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\x75"],

        ["\x5E\x76",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xF1"],
        ["\xBB\xF1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\x76"],

        ["\x5E\x77",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xF2"],
        ["\xBB\xF2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\x77"],

        ["\x5E\x78",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xF3"],
        ["\xBB\xF3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\x78"],

        ["\x5E\x80",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xF4"],
        ["\xBB\xF4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\x80"],

        ["\x5E\x8B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xF5"],
        ["\xBB\xF5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\x8B"],

        ["\x5E\x9B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xF6"],
        ["\xBB\xF6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\x9B"],

        ["\x5E\x9C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xF7"],
        ["\xBB\xF7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\x9C"],

        ["\x5E\xA0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xF8"],
        ["\xBB\xF8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\xA0"],

        ["\x5E\xAB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xF9"],
        ["\xBB\xF9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\xAB"],

        ["\x5E\xB0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xFA"],
        ["\xBB\xFA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\xB0"],

        ["\x5E\xC0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xFB"],
        ["\xBB\xFB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\xC0"],

        ["\x5E\x6A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xFC"],
        ["\xBB\xFC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\x6A"],

        ["\x5E\xD0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xFD"],
        ["\xBB\xFD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\xD0"],

        ["\x5E\xA1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBB\xFE"],
        ["\xBB\xFE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\xA1"],

        ["\x4C\x4F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xA1"],
        ["\xBC\xA1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\x4F"],

        ["\x4C\x7F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xA2"],
        ["\xBC\xA2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\x7F"],

        ["\x4C\x7B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xA3"],
        ["\xBC\xA3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\x7B"],

        ["\x4C\xE0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xA4"],
        ["\xBC\xA4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\xE0"],

        ["\x4C\x6C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xA5"],
        ["\xBC\xA5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\x6C"],

        ["\x4C\x50",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xA6"],
        ["\xBC\xA6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\x50"],

        ["\x4C\x7D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xA7"],
        ["\xBC\xA7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\x7D"],

        ["\x4C\x4D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xA8"],
        ["\xBC\xA8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\x4D"],

        ["\x4C\x5D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xA9"],
        ["\xBC\xA9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\x5D"],

        ["\x4C\x5C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xAA"],
        ["\xBC\xAA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\x5C"],

        ["\x4C\x4E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xAB"],
        ["\xBC\xAB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\x4E"],

        ["\x4C\x6B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xAC"],
        ["\xBC\xAC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\x6B"],

        ["\x4C\x60",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xAD"],
        ["\xBC\xAD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\x60"],

        ["\x4C\x4B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xAE"],
        ["\xBC\xAE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\x4B"],

        ["\x4C\x61",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xAF"],
        ["\xBC\xAF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\x61"],

        ["\x4C\xF0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xB0"],
        ["\xBC\xB0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\xF0"],

        ["\x4C\xF1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xB1"],
        ["\xBC\xB1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\xF1"],

        ["\x4C\xF2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xB2"],
        ["\xBC\xB2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\xF2"],

        ["\x4C\xF3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xB3"],
        ["\xBC\xB3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\xF3"],

        ["\x4C\xF4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xB4"],
        ["\xBC\xB4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\xF4"],

        ["\x4C\xF5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xB5"],
        ["\xBC\xB5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\xF5"],

        ["\x4C\xF6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xB6"],
        ["\xBC\xB6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\xF6"],

        ["\x4C\xF7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xB7"],
        ["\xBC\xB7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\xF7"],

        ["\x4C\xF8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xB8"],
        ["\xBC\xB8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\xF8"],

        ["\x4C\xF9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xB9"],
        ["\xBC\xB9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\xF9"],

        ["\x4C\x7A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xBA"],
        ["\xBC\xBA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\x7A"],

        ["\x4C\x5E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xBB"],
        ["\xBC\xBB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\x5E"],

        ["\x4C\x4C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xBC"],
        ["\xBC\xBC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\x4C"],

        ["\x4C\x7E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xBD"],
        ["\xBC\xBD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\x7E"],

        ["\x4C\x6E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xBE"],
        ["\xBC\xBE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\x6E"],

        ["\x4C\x6F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xBF"],
        ["\xBC\xBF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\x6F"],

        ["\x4C\x7C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xC0"],
        ["\xBC\xC0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\x7C"],

        ["\x4C\xC1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xC1"],
        ["\xBC\xC1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\xC1"],

        ["\x4C\xC2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xC2"],
        ["\xBC\xC2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\xC2"],

        ["\x4C\xC3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xC3"],
        ["\xBC\xC3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\xC3"],

        ["\x4C\xC4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xC4"],
        ["\xBC\xC4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\xC4"],

        ["\x4C\xC5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xC5"],
        ["\xBC\xC5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\xC5"],

        ["\x4C\xC6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xC6"],
        ["\xBC\xC6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\xC6"],

        ["\x4C\xC7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xC7"],
        ["\xBC\xC7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\xC7"],

        ["\x4C\xC8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xC8"],
        ["\xBC\xC8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\xC8"],

        ["\x68\x7F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xC9"],
        ["\xBC\xC9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\x7F"],

        ["\x4C\xD1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xCA"],
        ["\xBC\xCA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\xD1"],

        ["\x4C\xD2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xCB"],
        ["\xBC\xCB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\xD2"],

        ["\x4C\xD3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xCC"],
        ["\xBC\xCC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\xD3"],

        ["\x4C\xD4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xCD"],
        ["\xBC\xCD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\xD4"],

        ["\x4C\xD5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xCE"],
        ["\xBC\xCE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\xD5"],

        ["\x4C\xD6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xCF"],
        ["\xBC\xCF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\xD6"],

        ["\x4C\xD7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xD0"],
        ["\xBC\xD0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\xD7"],

        ["\x4C\xD8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xD1"],
        ["\xBC\xD1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\xD8"],

        ["\x4C\xD9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xD2"],
        ["\xBC\xD2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\xD9"],

        ["\x4C\xE2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xD3"],
        ["\xBC\xD3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\xE2"],

        ["\x4C\xE3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xD4"],
        ["\xBC\xD4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\xE3"],

        ["\x4C\xE4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xD5"],
        ["\xBC\xD5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\xE4"],

        ["\x4C\xE5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xD6"],
        ["\xBC\xD6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\xE5"],

        ["\x4C\xE6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xD7"],
        ["\xBC\xD7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\xE6"],

        ["\x4C\xE7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xD8"],
        ["\xBC\xD8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\xE7"],

        ["\x4C\xE8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xD9"],
        ["\xBC\xD9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\xE8"],

        ["\x4C\xE9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xDA"],
        ["\xBC\xDA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\xE9"],

        ["\x4C\x4A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xDB"],
        ["\xBC\xDB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\x4A"],

        ["\x4C\x5B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xDC"],
        ["\xBC\xDC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\x5B"],

        ["\x4C\x5A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xDD"],
        ["\xBC\xDD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\x5A"],

        ["\x4C\x5F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xDE"],
        ["\xBC\xDE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\x5F"],

        ["\x4C\x6D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xDF"],
        ["\xBC\xDF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\x6D"],

        ["\x4C\x79",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xE0"],
        ["\xBC\xE0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\x79"],

        ["\x4C\x57",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xE1"],
        ["\xBC\xE1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\x57"],

        ["\x4C\x59",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xE2"],
        ["\xBC\xE2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\x59"],

        ["\x4C\x62",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xE3"],
        ["\xBC\xE3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\x62"],

        ["\x4C\x63",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xE4"],
        ["\xBC\xE4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\x63"],

        ["\x4C\x64",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xE5"],
        ["\xBC\xE5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\x64"],

        ["\x4C\x65",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xE6"],
        ["\xBC\xE6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\x65"],

        ["\x4C\x66",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xE7"],
        ["\xBC\xE7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\x66"],

        ["\x4C\x67",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xE8"],
        ["\xBC\xE8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\x67"],

        ["\x4C\x68",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xE9"],
        ["\xBC\xE9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\x68"],

        ["\x4C\x69",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xEA"],
        ["\xBC\xEA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\x69"],

        ["\x4C\x70",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xEB"],
        ["\xBC\xEB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\x70"],

        ["\x4C\x71",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xEC"],
        ["\xBC\xEC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\x71"],

        ["\x4C\x72",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xED"],
        ["\xBC\xED",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\x72"],

        ["\x4C\x73",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xEE"],
        ["\xBC\xEE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\x73"],

        ["\x4C\x74",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xEF"],
        ["\xBC\xEF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\x74"],

        ["\x4C\x75",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xF0"],
        ["\xBC\xF0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\x75"],

        ["\x4C\x76",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xF1"],
        ["\xBC\xF1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\x76"],

        ["\x4C\x77",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xF2"],
        ["\xBC\xF2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\x77"],

        ["\x4C\x78",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xF3"],
        ["\xBC\xF3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\x78"],

        ["\x4C\x80",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xF4"],
        ["\xBC\xF4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\x80"],

        ["\x4C\x8B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xF5"],
        ["\xBC\xF5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\x8B"],

        ["\x4C\x9B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xF6"],
        ["\xBC\xF6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\x9B"],

        ["\x4C\x9C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xF7"],
        ["\xBC\xF7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\x9C"],

        ["\x4C\xA0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xF8"],
        ["\xBC\xF8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\xA0"],

        ["\x4C\xAB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xF9"],
        ["\xBC\xF9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\xAB"],

        ["\x4C\xB0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xFA"],
        ["\xBC\xFA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\xB0"],

        ["\x4C\xC0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xFB"],
        ["\xBC\xFB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\xC0"],

        ["\x4C\x6A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xFC"],
        ["\xBC\xFC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\x6A"],

        ["\x4C\xD0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xFD"],
        ["\xBC\xFD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\xD0"],

        ["\x4C\xA1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\xFE"],
        ["\xBC\xFE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\xA1"],

        ["\x7E\x4F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xA1"],
        ["\xBD\xA1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7E\x4F"],

        ["\x7E\x7F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xA2"],
        ["\xBD\xA2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7E\x7F"],

        ["\x7E\x7B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xA3"],
        ["\xBD\xA3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7E\x7B"],

        ["\x7E\xE0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xA4"],
        ["\xBD\xA4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7E\xE0"],

        ["\x7E\x6C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xA5"],
        ["\xBD\xA5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7E\x6C"],

        ["\x7E\x50",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xA6"],
        ["\xBD\xA6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7E\x50"],

        ["\x7E\x7D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xA7"],
        ["\xBD\xA7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7E\x7D"],

        ["\x7E\x4D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xA8"],
        ["\xBD\xA8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7E\x4D"],

        ["\x7E\x5D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xA9"],
        ["\xBD\xA9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7E\x5D"],

        ["\x7E\x5C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xAA"],
        ["\xBD\xAA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7E\x5C"],

        ["\x7E\x4E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xAB"],
        ["\xBD\xAB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7E\x4E"],

        ["\x7E\x6B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xAC"],
        ["\xBD\xAC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7E\x6B"],

        ["\x7E\x60",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xAD"],
        ["\xBD\xAD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7E\x60"],

        ["\x7E\x4B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xAE"],
        ["\xBD\xAE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7E\x4B"],

        ["\x7E\x61",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xAF"],
        ["\xBD\xAF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7E\x61"],

        ["\x7E\xF0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xB0"],
        ["\xBD\xB0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7E\xF0"],

        ["\x7E\xF1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xB1"],
        ["\xBD\xB1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7E\xF1"],

        ["\x7E\xF2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xB2"],
        ["\xBD\xB2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7E\xF2"],

        ["\x7E\xF3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xB3"],
        ["\xBD\xB3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7E\xF3"],

        ["\x7E\xF4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xB4"],
        ["\xBD\xB4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7E\xF4"],

        ["\x7E\xF5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xB5"],
        ["\xBD\xB5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7E\xF5"],

        ["\x7E\xF6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xB6"],
        ["\xBD\xB6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7E\xF6"],

        ["\x7E\xF7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xB7"],
        ["\xBD\xB7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7E\xF7"],

        ["\x7E\xF8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xB8"],
        ["\xBD\xB8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7E\xF8"],

        ["\x7E\xF9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xB9"],
        ["\xBD\xB9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7E\xF9"],

        ["\x7E\x7A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xBA"],
        ["\xBD\xBA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7E\x7A"],

        ["\x7E\x5E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xBB"],
        ["\xBD\xBB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7E\x5E"],

        ["\x7E\x4C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xBC"],
        ["\xBD\xBC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7E\x4C"],

        ["\x7E\x7E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xBD"],
        ["\xBD\xBD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7E\x7E"],

        ["\x7E\x6E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xBE"],
        ["\xBD\xBE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7E\x6E"],

        ["\x7E\x6F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xBF"],
        ["\xBD\xBF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7E\x6F"],

        ["\x7E\x7C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xC0"],
        ["\xBD\xC0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7E\x7C"],

        ["\x7E\xC1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xC1"],
        ["\xBD\xC1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7E\xC1"],

        ["\x7E\xC2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xC2"],
        ["\xBD\xC2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7E\xC2"],

        ["\x7E\xC3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xC3"],
        ["\xBD\xC3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7E\xC3"],

        ["\x7E\xC4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xC4"],
        ["\xBD\xC4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7E\xC4"],

        ["\x7E\xC5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xC5"],
        ["\xBD\xC5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7E\xC5"],

        ["\x7E\xC6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xC6"],
        ["\xBD\xC6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7E\xC6"],

        ["\x7E\xC7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xC7"],
        ["\xBD\xC7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7E\xC7"],

        ["\x7E\xC8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xC8"],
        ["\xBD\xC8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7E\xC8"],

        ["\x7E\xC9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xC9"],
        ["\xBD\xC9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7E\xC9"],

        ["\x7E\xD1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xCA"],
        ["\xBD\xCA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7E\xD1"],

        ["\x7E\xD2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xCB"],
        ["\xBD\xCB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7E\xD2"],

        ["\x7E\xD3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xCC"],
        ["\xBD\xCC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7E\xD3"],

        ["\x7E\xD4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xCD"],
        ["\xBD\xCD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7E\xD4"],

        ["\x7E\xD5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xCE"],
        ["\xBD\xCE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7E\xD5"],

        ["\x7E\xD6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xCF"],
        ["\xBD\xCF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7E\xD6"],

        ["\x7E\xD7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xD0"],
        ["\xBD\xD0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7E\xD7"],

        ["\x7E\xD8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xD1"],
        ["\xBD\xD1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7E\xD8"],

        ["\x7E\xD9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xD2"],
        ["\xBD\xD2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7E\xD9"],

        ["\x7E\xE2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xD3"],
        ["\xBD\xD3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7E\xE2"],

        ["\x7E\xE3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xD4"],
        ["\xBD\xD4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7E\xE3"],

        ["\x7E\xE4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xD5"],
        ["\xBD\xD5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7E\xE4"],

        ["\x7E\xE5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xD6"],
        ["\xBD\xD6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7E\xE5"],

        ["\x7E\xE6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xD7"],
        ["\xBD\xD7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7E\xE6"],

        ["\x7E\xE7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xD8"],
        ["\xBD\xD8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7E\xE7"],

        ["\x7E\xE8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xD9"],
        ["\xBD\xD9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7E\xE8"],

        ["\x7E\xE9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xDA"],
        ["\xBD\xDA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7E\xE9"],

        ["\x7E\x4A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xDB"],
        ["\xBD\xDB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7E\x4A"],

        ["\x7E\x5B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xDC"],
        ["\xBD\xDC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7E\x5B"],

        ["\x7E\x5A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xDD"],
        ["\xBD\xDD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7E\x5A"],

        ["\x7E\x5F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xDE"],
        ["\xBD\xDE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7E\x5F"],

        ["\x7E\x6D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xDF"],
        ["\xBD\xDF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7E\x6D"],

        ["\x7E\x79",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xE0"],
        ["\xBD\xE0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7E\x79"],

        ["\x7E\x57",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xE1"],
        ["\xBD\xE1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7E\x57"],

        ["\x7E\x59",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xE2"],
        ["\xBD\xE2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7E\x59"],

        ["\x7E\x62",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xE3"],
        ["\xBD\xE3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7E\x62"],

        ["\x7E\x63",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xE4"],
        ["\xBD\xE4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7E\x63"],

        ["\x7E\x64",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xE5"],
        ["\xBD\xE5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7E\x64"],

        ["\x7E\x65",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xE6"],
        ["\xBD\xE6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7E\x65"],

        ["\x7E\x66",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xE7"],
        ["\xBD\xE7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7E\x66"],

        ["\x7E\x67",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xE8"],
        ["\xBD\xE8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7E\x67"],

        ["\x7E\x68",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xE9"],
        ["\xBD\xE9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7E\x68"],

        ["\x7E\x69",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xEA"],
        ["\xBD\xEA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7E\x69"],

        ["\x7E\x70",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xEB"],
        ["\xBD\xEB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7E\x70"],

        ["\x7E\x71",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xEC"],
        ["\xBD\xEC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7E\x71"],

        ["\x7E\x72",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xED"],
        ["\xBD\xED",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7E\x72"],

        ["\x7E\x73",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xEE"],
        ["\xBD\xEE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7E\x73"],

        ["\x7E\x74",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xEF"],
        ["\xBD\xEF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7E\x74"],

        ["\x7E\x75",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xF0"],
        ["\xBD\xF0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7E\x75"],

        ["\x7E\x76",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xF1"],
        ["\xBD\xF1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7E\x76"],

        ["\x7E\x77",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xF2"],
        ["\xBD\xF2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7E\x77"],

        ["\x7E\x78",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xF3"],
        ["\xBD\xF3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7E\x78"],

        ["\x7E\x80",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xF4"],
        ["\xBD\xF4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7E\x80"],

        ["\x7E\x8B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xF5"],
        ["\xBD\xF5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7E\x8B"],

        ["\x7E\x9B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xF6"],
        ["\xBD\xF6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7E\x9B"],

        ["\x7E\x9C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xF7"],
        ["\xBD\xF7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7E\x9C"],

        ["\x7E\xA0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xF8"],
        ["\xBD\xF8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7E\xA0"],

        ["\x7E\xAB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xF9"],
        ["\xBD\xF9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7E\xAB"],

        ["\x7E\xB0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xFA"],
        ["\xBD\xFA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7E\xB0"],

        ["\x7E\xC0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xFB"],
        ["\xBD\xFB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7E\xC0"],

        ["\x7E\x6A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xFC"],
        ["\xBD\xFC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7E\x6A"],

        ["\x7E\xD0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xFD"],
        ["\xBD\xFD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7E\xD0"],

        ["\x7E\xA1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBD\xFE"],
        ["\xBD\xFE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7E\xA1"],

        ["\x6E\x4F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xA1"],
        ["\xBE\xA1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\x4F"],

        ["\x6E\x7F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xA2"],
        ["\xBE\xA2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\x7F"],

        ["\x6E\x7B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xA3"],
        ["\xBE\xA3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\x7B"],

        ["\x6E\xE0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xA4"],
        ["\xBE\xA4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\xE0"],

        ["\x6E\x6C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xA5"],
        ["\xBE\xA5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\x6C"],

        ["\x6E\x50",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xA6"],
        ["\xBE\xA6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\x50"],

        ["\x6E\x7D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xA7"],
        ["\xBE\xA7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\x7D"],

        ["\x6E\x4D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xA8"],
        ["\xBE\xA8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\x4D"],

        ["\x6E\x5D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xA9"],
        ["\xBE\xA9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\x5D"],

        ["\x6E\x5C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xAA"],
        ["\xBE\xAA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\x5C"],

        ["\x6E\x4E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xAB"],
        ["\xBE\xAB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\x4E"],

        ["\x6E\x6B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xAC"],
        ["\xBE\xAC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\x6B"],

        ["\x6E\x60",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xAD"],
        ["\xBE\xAD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\x60"],

        ["\x6E\x4B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xAE"],
        ["\xBE\xAE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\x4B"],

        ["\x6E\x61",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xAF"],
        ["\xBE\xAF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\x61"],

        ["\x6E\xF0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xB0"],
        ["\xBE\xB0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\xF0"],

        ["\x6E\xF1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xB1"],
        ["\xBE\xB1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\xF1"],

        ["\x6E\xF2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xB2"],
        ["\xBE\xB2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\xF2"],

        ["\x6E\xF3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xB3"],
        ["\xBE\xB3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\xF3"],

        ["\x6E\xF4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xB4"],
        ["\xBE\xB4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\xF4"],

        ["\x6E\xF5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xB5"],
        ["\xBE\xB5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\xF5"],

        ["\x6E\xF6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xB6"],
        ["\xBE\xB6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\xF6"],

        ["\x6E\xF7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xB7"],
        ["\xBE\xB7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\xF7"],

        ["\x6E\xF8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xB8"],
        ["\xBE\xB8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\xF8"],

        ["\x6E\xF9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xB9"],
        ["\xBE\xB9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\xF9"],

        ["\x6E\x7A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xBA"],
        ["\xBE\xBA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\x7A"],

        ["\x6E\x5E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xBB"],
        ["\xBE\xBB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\x5E"],

        ["\x6E\x4C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xBC"],
        ["\xBE\xBC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\x4C"],

        ["\x6E\x7E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xBD"],
        ["\xBE\xBD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\x7E"],

        ["\x6E\x6E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xBE"],
        ["\xBE\xBE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\x6E"],

        ["\x6E\x6F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xBF"],
        ["\xBE\xBF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\x6F"],

        ["\x6E\x7C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xC0"],
        ["\xBE\xC0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\x7C"],

        ["\x6E\xC1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xC1"],
        ["\xBE\xC1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\xC1"],

        ["\x6E\xC2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xC2"],
        ["\xBE\xC2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\xC2"],

        ["\x6E\xC3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xC3"],
        ["\xBE\xC3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\xC3"],

        ["\x6E\xC4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xC4"],
        ["\xBE\xC4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\xC4"],

        ["\x6E\xC5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xC5"],
        ["\xBE\xC5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\xC5"],

        ["\x6E\xC6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xC6"],
        ["\xBE\xC6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\xC6"],

        ["\x6E\xC7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xC7"],
        ["\xBE\xC7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\xC7"],

        ["\x6E\xC8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xC8"],
        ["\xBE\xC8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\xC8"],

        ["\x6E\xC9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xC9"],
        ["\xBE\xC9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\xC9"],

        ["\x6E\xD1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xCA"],
        ["\xBE\xCA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\xD1"],

        ["\x6E\xD2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xCB"],
        ["\xBE\xCB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\xD2"],

        ["\x6E\xD3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xCC"],
        ["\xBE\xCC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\xD3"],

        ["\x6E\xD4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xCD"],
        ["\xBE\xCD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\xD4"],

        ["\x6E\xD5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xCE"],
        ["\xBE\xCE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\xD5"],

        ["\x6E\xD6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xCF"],
        ["\xBE\xCF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\xD6"],

        ["\x6E\xD7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xD0"],
        ["\xBE\xD0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\xD7"],

        ["\x6E\xD8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xD1"],
        ["\xBE\xD1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\xD8"],

        ["\x6E\xD9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xD2"],
        ["\xBE\xD2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\xD9"],

        ["\x6E\xE2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xD3"],
        ["\xBE\xD3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\xE2"],

        ["\x6E\xE3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xD4"],
        ["\xBE\xD4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\xE3"],

        ["\x6E\xE4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xD5"],
        ["\xBE\xD5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\xE4"],

        ["\x6E\xE5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xD6"],
        ["\xBE\xD6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\xE5"],

        ["\x6E\xE6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xD7"],
        ["\xBE\xD7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\xE6"],

        ["\x6E\xE7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xD8"],
        ["\xBE\xD8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\xE7"],

        ["\x6E\xE8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xD9"],
        ["\xBE\xD9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\xE8"],

        ["\x6E\xE9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xDA"],
        ["\xBE\xDA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\xE9"],

        ["\x6E\x4A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xDB"],
        ["\xBE\xDB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\x4A"],

        ["\x6E\x5B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xDC"],
        ["\xBE\xDC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\x5B"],

        ["\x6E\x5A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xDD"],
        ["\xBE\xDD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\x5A"],

        ["\x6E\x5F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xDE"],
        ["\xBE\xDE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\x5F"],

        ["\x6E\x6D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xDF"],
        ["\xBE\xDF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\x6D"],

        ["\x6E\x79",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xE0"],
        ["\xBE\xE0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\x79"],

        ["\x6E\x57",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xE1"],
        ["\xBE\xE1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\x57"],

        ["\x6E\x59",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xE2"],
        ["\xBE\xE2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\x59"],

        ["\x6E\x62",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xE3"],
        ["\xBE\xE3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\x62"],

        ["\x6E\x63",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xE4"],
        ["\xBE\xE4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\x63"],

        ["\x6E\x64",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xE5"],
        ["\xBE\xE5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\x64"],

        ["\x6E\x65",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xE6"],
        ["\xBE\xE6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\x65"],

        ["\x6E\x66",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xE7"],
        ["\xBE\xE7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\x66"],

        ["\x6E\x67",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xE8"],
        ["\xBE\xE8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\x67"],

        ["\x6E\x68",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xE9"],
        ["\xBE\xE9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\x68"],

        ["\x6E\x69",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xEA"],
        ["\xBE\xEA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\x69"],

        ["\x6E\x70",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xEB"],
        ["\xBE\xEB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\x70"],

        ["\x6E\x71",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xEC"],
        ["\xBE\xEC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\x71"],

        ["\x6E\x72",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xED"],
        ["\xBE\xED",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\x72"],

        ["\x6E\x73",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xEE"],
        ["\xBE\xEE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\x73"],

        ["\x6E\x74",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xEF"],
        ["\xBE\xEF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\x74"],

        ["\x6E\x75",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xF0"],
        ["\xBE\xF0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\x75"],

        ["\x6E\x76",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xF1"],
        ["\xBE\xF1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\x76"],

        ["\x6E\x77",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xF2"],
        ["\xBE\xF2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\x77"],

        ["\x6E\x78",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xF3"],
        ["\xBE\xF3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\x78"],

        ["\x6E\x80",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xF4"],
        ["\xBE\xF4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\x80"],

        ["\x6E\x8B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xF5"],
        ["\xBE\xF5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\x8B"],

        ["\x6E\x9B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xF6"],
        ["\xBE\xF6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\x9B"],

        ["\x6E\x9C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xF7"],
        ["\xBE\xF7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\x9C"],

        ["\x6E\xA0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xF8"],
        ["\xBE\xF8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\xA0"],

        ["\x6E\xAB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xF9"],
        ["\xBE\xF9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\xAB"],

        ["\x6E\xB0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xFA"],
        ["\xBE\xFA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\xB0"],

        ["\x6E\xC0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xFB"],
        ["\xBE\xFB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\xC0"],

        ["\x6E\x6A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xFC"],
        ["\xBE\xFC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\x6A"],

        ["\x6E\xD0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xFD"],
        ["\xBE\xFD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\xD0"],

        ["\x6E\xA1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBE\xFE"],
        ["\xBE\xFE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\xA1"],

        ["\x6F\x4F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xA1"],
        ["\xBF\xA1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\x4F"],

        ["\x6F\x7F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xA2"],
        ["\xBF\xA2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\x7F"],

        ["\x6F\x7B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xA3"],
        ["\xBF\xA3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\x7B"],

        ["\x6F\xE0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xA4"],
        ["\xBF\xA4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\xE0"],

        ["\x6F\x6C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xA5"],
        ["\xBF\xA5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\x6C"],

        ["\x6F\x50",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xA6"],
        ["\xBF\xA6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\x50"],

        ["\x6F\x7D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xA7"],
        ["\xBF\xA7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\x7D"],

        ["\x6F\x4D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xA8"],
        ["\xBF\xA8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\x4D"],

        ["\x6F\x5D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xA9"],
        ["\xBF\xA9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\x5D"],

        ["\x6F\x5C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xAA"],
        ["\xBF\xAA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\x5C"],

        ["\x6F\x4E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xAB"],
        ["\xBF\xAB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\x4E"],

        ["\x6F\x6B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xAC"],
        ["\xBF\xAC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\x6B"],

        ["\x6F\x60",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xAD"],
        ["\xBF\xAD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\x60"],

        ["\x6F\x4B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xAE"],
        ["\xBF\xAE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\x4B"],

        ["\x6F\x61",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xAF"],
        ["\xBF\xAF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\x61"],

        ["\x6F\xF0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xB0"],
        ["\xBF\xB0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\xF0"],

        ["\x6F\xF1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xB1"],
        ["\xBF\xB1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\xF1"],

        ["\x6F\xF2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xB2"],
        ["\xBF\xB2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\xF2"],

        ["\x6F\xF3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xB3"],
        ["\xBF\xB3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\xF3"],

        ["\x6F\xF4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xB4"],
        ["\xBF\xB4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\xF4"],

        ["\x6F\xF5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xB5"],
        ["\xBF\xB5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\xF5"],

        ["\x6F\xF6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xB6"],
        ["\xBF\xB6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\xF6"],

        ["\x6F\xF7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xB7"],
        ["\xBF\xB7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\xF7"],

        ["\x6F\xF8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xB8"],
        ["\xBF\xB8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\xF8"],

        ["\x6F\xF9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xB9"],
        ["\xBF\xB9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\xF9"],

        ["\x6F\x7A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xBA"],
        ["\xBF\xBA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\x7A"],

        ["\x6F\x5E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xBB"],
        ["\xBF\xBB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\x5E"],

        ["\x6F\x4C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xBC"],
        ["\xBF\xBC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\x4C"],

        ["\x6F\x7E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xBD"],
        ["\xBF\xBD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\x7E"],

        ["\x6F\x6E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xBE"],
        ["\xBF\xBE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\x6E"],

        ["\x6F\x6F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xBF"],
        ["\xBF\xBF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\x6F"],

        ["\x6F\x7C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xC0"],
        ["\xBF\xC0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\x7C"],

        ["\x6F\xC1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xC1"],
        ["\xBF\xC1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\xC1"],

        ["\x6F\xC2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xC2"],
        ["\xBF\xC2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\xC2"],

        ["\x6F\xC3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xC3"],
        ["\xBF\xC3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\xC3"],

        ["\x6F\xC4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xC4"],
        ["\xBF\xC4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\xC4"],

        ["\x6F\xC5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xC5"],
        ["\xBF\xC5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\xC5"],

        ["\x6F\xC6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xC6"],
        ["\xBF\xC6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\xC6"],

        ["\x6F\xC7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xC7"],
        ["\xBF\xC7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\xC7"],

        ["\x6F\xC8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xC8"],
        ["\xBF\xC8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\xC8"],

        ["\x6F\xC9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xC9"],
        ["\xBF\xC9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\xC9"],

        ["\x6F\xD1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xCA"],
        ["\xBF\xCA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\xD1"],

        ["\x6F\xD2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xCB"],
        ["\xBF\xCB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\xD2"],

        ["\x6F\xD3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xCC"],
        ["\xBF\xCC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\xD3"],

        ["\x6F\xD4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xCD"],
        ["\xBF\xCD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\xD4"],

        ["\x6F\xD5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xCE"],
        ["\xBF\xCE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\xD5"],

        ["\x6F\xD6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xCF"],
        ["\xBF\xCF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\xD6"],

        ["\x6F\xD7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xD0"],
        ["\xBF\xD0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\xD7"],

        ["\x6F\xD8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xD1"],
        ["\xBF\xD1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\xD8"],

        ["\x6F\xD9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xD2"],
        ["\xBF\xD2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\xD9"],

        ["\x6F\xE2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xD3"],
        ["\xBF\xD3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\xE2"],

        ["\x6F\xE3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xD4"],
        ["\xBF\xD4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\xE3"],

        ["\x6F\xE4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xD5"],
        ["\xBF\xD5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\xE4"],

        ["\x6F\xE5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xD6"],
        ["\xBF\xD6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\xE5"],

        ["\x6F\xE6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xD7"],
        ["\xBF\xD7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\xE6"],

        ["\x6F\xE7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xD8"],
        ["\xBF\xD8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\xE7"],

        ["\x75\xE6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xD9"],
        ["\xBF\xD9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x75\xE6"],

        ["\x6F\xE9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xDA"],
        ["\xBF\xDA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\xE9"],

        ["\x6F\x4A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xDB"],
        ["\xBF\xDB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\x4A"],

        ["\x6F\x5B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xDC"],
        ["\xBF\xDC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\x5B"],

        ["\x6F\x5A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xDD"],
        ["\xBF\xDD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\x5A"],

        ["\x6F\x5F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xDE"],
        ["\xBF\xDE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\x5F"],

        ["\x6F\x6D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xDF"],
        ["\xBF\xDF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\x6D"],

        ["\x6F\x79",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xE0"],
        ["\xBF\xE0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\x79"],

        ["\x6F\x57",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xE1"],
        ["\xBF\xE1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\x57"],

        ["\x6F\x59",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xE2"],
        ["\xBF\xE2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\x59"],

        ["\x6F\x62",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xE3"],
        ["\xBF\xE3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\x62"],

        ["\x6F\x63",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xE4"],
        ["\xBF\xE4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\x63"],

        ["\x6F\x64",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xE5"],
        ["\xBF\xE5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\x64"],

        ["\x6F\x65",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xE6"],
        ["\xBF\xE6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\x65"],

        ["\x6F\x66",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xE7"],
        ["\xBF\xE7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\x66"],

        ["\x6F\x67",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xE8"],
        ["\xBF\xE8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\x67"],

        ["\x6F\x68",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xE9"],
        ["\xBF\xE9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\x68"],

        ["\x6F\x69",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xEA"],
        ["\xBF\xEA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\x69"],

        ["\x6F\x70",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xEB"],
        ["\xBF\xEB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\x70"],

        ["\x6F\x71",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xEC"],
        ["\xBF\xEC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\x71"],

        ["\x6F\x72",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xED"],
        ["\xBF\xED",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\x72"],

        ["\x6F\x73",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xEE"],
        ["\xBF\xEE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\x73"],

        ["\x6F\x74",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xEF"],
        ["\xBF\xEF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\x74"],

        ["\x6F\x75",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xF0"],
        ["\xBF\xF0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\x75"],

        ["\x6F\x76",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xF1"],
        ["\xBF\xF1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\x76"],

        ["\x6F\x77",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xF2"],
        ["\xBF\xF2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\x77"],

        ["\x6F\x78",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xF3"],
        ["\xBF\xF3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\x78"],

        ["\x6F\x80",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xF4"],
        ["\xBF\xF4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\x80"],

        ["\x6F\x8B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xF5"],
        ["\xBF\xF5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\x8B"],

        ["\x6F\x9B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xF6"],
        ["\xBF\xF6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\x9B"],

        ["\x6F\x9C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xF7"],
        ["\xBF\xF7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\x9C"],

        ["\x6F\xA0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xF8"],
        ["\xBF\xF8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\xA0"],

        ["\x6F\xAB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xF9"],
        ["\xBF\xF9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\xAB"],

        ["\x6F\xB0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xFA"],
        ["\xBF\xFA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\xB0"],

        ["\x6F\xC0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xFB"],
        ["\xBF\xFB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\xC0"],

        ["\x6F\x6A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xFC"],
        ["\xBF\xFC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\x6A"],

        ["\x6F\xD0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xFD"],
        ["\xBF\xFD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\xD0"],

        ["\x6F\xA1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBF\xFE"],
        ["\xBF\xFE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\xA1"],

        ["\x7C\x4F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xA1"],
        ["\xC0\xA1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7C\x4F"],

        ["\x7C\x7F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xA2"],
        ["\xC0\xA2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7C\x7F"],

        ["\x7C\x7B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xA3"],
        ["\xC0\xA3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7C\x7B"],

        ["\x7C\xE0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xA4"],
        ["\xC0\xA4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7C\xE0"],

        ["\x7C\x6C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xA5"],
        ["\xC0\xA5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7C\x6C"],

        ["\x7C\x50",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xA6"],
        ["\xC0\xA6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7C\x50"],

        ["\x7C\x7D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xA7"],
        ["\xC0\xA7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7C\x7D"],

        ["\x7C\x4D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xA8"],
        ["\xC0\xA8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7C\x4D"],

        ["\x7C\x5D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xA9"],
        ["\xC0\xA9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7C\x5D"],

        ["\x7C\x5C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xAA"],
        ["\xC0\xAA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7C\x5C"],

        ["\x7C\x4E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xAB"],
        ["\xC0\xAB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7C\x4E"],

        ["\x7C\x6B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xAC"],
        ["\xC0\xAC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7C\x6B"],

        ["\x7C\x60",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xAD"],
        ["\xC0\xAD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7C\x60"],

        ["\x7C\x4B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xAE"],
        ["\xC0\xAE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7C\x4B"],

        ["\x7C\x61",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xAF"],
        ["\xC0\xAF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7C\x61"],

        ["\x7C\xF0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xB0"],
        ["\xC0\xB0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7C\xF0"],

        ["\x7C\xF1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xB1"],
        ["\xC0\xB1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7C\xF1"],

        ["\x7C\xF2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xB2"],
        ["\xC0\xB2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7C\xF2"],

        ["\x7C\xF3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xB3"],
        ["\xC0\xB3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7C\xF3"],

        ["\x7C\xF4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xB4"],
        ["\xC0\xB4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7C\xF4"],

        ["\x7C\xF5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xB5"],
        ["\xC0\xB5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7C\xF5"],

        ["\x7C\xF6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xB6"],
        ["\xC0\xB6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7C\xF6"],

        ["\x7C\xF7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xB7"],
        ["\xC0\xB7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7C\xF7"],

        ["\x7C\xF8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xB8"],
        ["\xC0\xB8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7C\xF8"],

        ["\x7C\xF9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xB9"],
        ["\xC0\xB9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7C\xF9"],

        ["\x7C\x7A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xBA"],
        ["\xC0\xBA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7C\x7A"],

        ["\x7C\x5E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xBB"],
        ["\xC0\xBB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7C\x5E"],

        ["\x7C\x4C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xBC"],
        ["\xC0\xBC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7C\x4C"],

        ["\x7C\x7E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xBD"],
        ["\xC0\xBD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7C\x7E"],

        ["\x7C\x6E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xBE"],
        ["\xC0\xBE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7C\x6E"],

        ["\x7C\x6F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xBF"],
        ["\xC0\xBF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7C\x6F"],

        ["\x7C\x7C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xC0"],
        ["\xC0\xC0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7C\x7C"],

        ["\x7C\xC1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xC1"],
        ["\xC0\xC1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7C\xC1"],

        ["\x7C\xC2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xC2"],
        ["\xC0\xC2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7C\xC2"],

        ["\x7C\xC3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xC3"],
        ["\xC0\xC3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7C\xC3"],

        ["\x7C\xC4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xC4"],
        ["\xC0\xC4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7C\xC4"],

        ["\x7C\xC5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xC5"],
        ["\xC0\xC5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7C\xC5"],

        ["\x7C\xC6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xC6"],
        ["\xC0\xC6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7C\xC6"],

        ["\x7C\xC7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xC7"],
        ["\xC0\xC7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7C\xC7"],

        ["\x7C\xC8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xC8"],
        ["\xC0\xC8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7C\xC8"],

        ["\x7C\xC9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xC9"],
        ["\xC0\xC9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7C\xC9"],

        ["\x7C\xD1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xCA"],
        ["\xC0\xCA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7C\xD1"],

        ["\x7C\xD2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xCB"],
        ["\xC0\xCB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7C\xD2"],

        ["\x7C\xD3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xCC"],
        ["\xC0\xCC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7C\xD3"],

        ["\x7C\xD4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xCD"],
        ["\xC0\xCD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7C\xD4"],

        ["\x7C\xD5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xCE"],
        ["\xC0\xCE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7C\xD5"],

        ["\x7C\xD6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xCF"],
        ["\xC0\xCF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7C\xD6"],

        ["\x7C\xD7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xD0"],
        ["\xC0\xD0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7C\xD7"],

        ["\x7C\xD8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xD1"],
        ["\xC0\xD1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7C\xD8"],

        ["\x7C\xD9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xD2"],
        ["\xC0\xD2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7C\xD9"],

        ["\x7C\xE2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xD3"],
        ["\xC0\xD3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7C\xE2"],

        ["\x7C\xE3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xD4"],
        ["\xC0\xD4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7C\xE3"],

        ["\x7C\xE4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xD5"],
        ["\xC0\xD5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7C\xE4"],

        ["\x7C\xE5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xD6"],
        ["\xC0\xD6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7C\xE5"],

        ["\x7C\xE6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xD7"],
        ["\xC0\xD7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7C\xE6"],

        ["\x7C\xE7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xD8"],
        ["\xC0\xD8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7C\xE7"],

        ["\x7C\xE8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xD9"],
        ["\xC0\xD9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7C\xE8"],

        ["\x7C\xE9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xDA"],
        ["\xC0\xDA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7C\xE9"],

        ["\x7C\x4A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xDB"],
        ["\xC0\xDB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7C\x4A"],

        ["\x7C\x5B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xDC"],
        ["\xC0\xDC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7C\x5B"],

        ["\x7C\x5A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xDD"],
        ["\xC0\xDD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7C\x5A"],

        ["\x7C\x5F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xDE"],
        ["\xC0\xDE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7C\x5F"],

        ["\x7C\x6D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xDF"],
        ["\xC0\xDF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7C\x6D"],

        ["\x7C\x79",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xE0"],
        ["\xC0\xE0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7C\x79"],

        ["\x7C\x57",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xE1"],
        ["\xC0\xE1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7C\x57"],

        ["\x7C\x59",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xE2"],
        ["\xC0\xE2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7C\x59"],

        ["\x7C\x62",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xE3"],
        ["\xC0\xE3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7C\x62"],

        ["\x7C\x63",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xE4"],
        ["\xC0\xE4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7C\x63"],

        ["\x7C\x64",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xE5"],
        ["\xC0\xE5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7C\x64"],

        ["\x7C\x65",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xE6"],
        ["\xC0\xE6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7C\x65"],

        ["\x7C\x66",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xE7"],
        ["\xC0\xE7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7C\x66"],

        ["\x7C\x67",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xE8"],
        ["\xC0\xE8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7C\x67"],

        ["\x7C\x68",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xE9"],
        ["\xC0\xE9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7C\x68"],

        ["\x7C\x69",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xEA"],
        ["\xC0\xEA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7C\x69"],

        ["\x7C\x70",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xEB"],
        ["\xC0\xEB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7C\x70"],

        ["\x7C\x71",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xEC"],
        ["\xC0\xEC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7C\x71"],

        ["\x7C\x72",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xED"],
        ["\xC0\xED",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7C\x72"],

        ["\x7C\x73",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xEE"],
        ["\xC0\xEE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7C\x73"],

        ["\x7C\x74",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xEF"],
        ["\xC0\xEF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7C\x74"],

        ["\x7C\x75",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xF0"],
        ["\xC0\xF0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7C\x75"],

        ["\x7C\x76",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xF1"],
        ["\xC0\xF1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7C\x76"],

        ["\x7C\x77",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xF2"],
        ["\xC0\xF2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7C\x77"],

        ["\x7C\x78",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xF3"],
        ["\xC0\xF3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7C\x78"],

        ["\x7C\x80",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xF4"],
        ["\xC0\xF4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7C\x80"],

        ["\x7C\x8B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xF5"],
        ["\xC0\xF5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7C\x8B"],

        ["\x7C\x9B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xF6"],
        ["\xC0\xF6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7C\x9B"],

        ["\x7C\x9C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xF7"],
        ["\xC0\xF7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7C\x9C"],

        ["\x7C\xA0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xF8"],
        ["\xC0\xF8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7C\xA0"],

        ["\x7C\xAB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xF9"],
        ["\xC0\xF9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7C\xAB"],

        ["\x7C\xB0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xFA"],
        ["\xC0\xFA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7C\xB0"],

        ["\x7C\xC0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xFB"],
        ["\xC0\xFB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7C\xC0"],

        ["\x7C\x6A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xFC"],
        ["\xC0\xFC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7C\x6A"],

        ["\x7C\xD0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xFD"],
        ["\xC0\xFD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7C\xD0"],

        ["\x7C\xA1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC0\xFE"],
        ["\xC0\xFE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x7C\xA1"],

        ["\xC1\x4F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xA1"],
        ["\xC1\xA1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\x4F"],

        ["\xC1\x7F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xA2"],
        ["\xC1\xA2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\x7F"],

        ["\xC1\x7B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xA3"],
        ["\xC1\xA3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\x7B"],

        ["\xC1\xE0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xA4"],
        ["\xC1\xA4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xE0"],

        ["\xC1\x6C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xA5"],
        ["\xC1\xA5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\x6C"],

        ["\xC1\x50",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xA6"],
        ["\xC1\xA6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\x50"],

        ["\xC1\x7D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xA7"],
        ["\xC1\xA7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\x7D"],

        ["\x71\xD4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xA8"],
        ["\xC1\xA8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\xD4"],

        ["\xC1\x5D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xA9"],
        ["\xC1\xA9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\x5D"],

        ["\xC1\x5C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xAA"],
        ["\xC1\xAA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\x5C"],

        ["\xC1\x4E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xAB"],
        ["\xC1\xAB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\x4E"],

        ["\xC1\x6B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xAC"],
        ["\xC1\xAC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\x6B"],

        ["\xC1\x60",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xAD"],
        ["\xC1\xAD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\x60"],

        ["\xC1\x4B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xAE"],
        ["\xC1\xAE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\x4B"],

        ["\xC1\x61",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xAF"],
        ["\xC1\xAF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\x61"],

        ["\xC1\xF0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xB0"],
        ["\xC1\xB0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xF0"],

        ["\xC1\xF1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xB1"],
        ["\xC1\xB1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xF1"],

        ["\xC1\xF2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xB2"],
        ["\xC1\xB2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xF2"],

        ["\xC1\xF3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xB3"],
        ["\xC1\xB3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xF3"],

        ["\xC1\xF4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xB4"],
        ["\xC1\xB4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xF4"],

        ["\xC1\xF5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xB5"],
        ["\xC1\xB5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xF5"],

        ["\xC1\xF6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xB6"],
        ["\xC1\xB6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xF6"],

        ["\xC1\xF7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xB7"],
        ["\xC1\xB7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xF7"],

        ["\xC1\xF8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xB8"],
        ["\xC1\xB8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xF8"],

        ["\xC1\xF9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xB9"],
        ["\xC1\xB9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xF9"],

        ["\xC1\x7A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xBA"],
        ["\xC1\xBA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\x7A"],

        ["\xC1\x5E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xBB"],
        ["\xC1\xBB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\x5E"],

        ["\xC1\x4C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xBC"],
        ["\xC1\xBC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\x4C"],

        ["\xC1\x7E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xBD"],
        ["\xC1\xBD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\x7E"],

        ["\xC1\x6E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xBE"],
        ["\xC1\xBE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\x6E"],

        ["\xC1\x6F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xBF"],
        ["\xC1\xBF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\x6F"],

        ["\xC1\x7C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xC0"],
        ["\xC1\xC0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\x7C"],

        ["\xC1\xC1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xC1"],
        ["\xC1\xC1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xC1"],

        ["\xC1\xC2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xC2"],
        ["\xC1\xC2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xC2"],

        ["\xC1\xC3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xC3"],
        ["\xC1\xC3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xC3"],

        ["\xC1\xC4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xC4"],
        ["\xC1\xC4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xC4"],

        ["\xC1\xC5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xC5"],
        ["\xC1\xC5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xC5"],

        ["\xC1\xC6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xC6"],
        ["\xC1\xC6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xC6"],

        ["\xC1\xC7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xC7"],
        ["\xC1\xC7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xC7"],

        ["\xC1\xC8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xC8"],
        ["\xC1\xC8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xC8"],

        ["\xC1\xC9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xC9"],
        ["\xC1\xC9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xC9"],

        ["\xC1\xD1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xCA"],
        ["\xC1\xCA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xD1"],

        ["\xC1\xD2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xCB"],
        ["\xC1\xCB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xD2"],

        ["\xC1\xD3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xCC"],
        ["\xC1\xCC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xD3"],

        ["\xC1\xD4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xCD"],
        ["\xC1\xCD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xD4"],

        ["\xC1\xD5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xCE"],
        ["\xC1\xCE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xD5"],

        ["\xC1\xD6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xCF"],
        ["\xC1\xCF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xD6"],

        ["\xC1\xD7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xD0"],
        ["\xC1\xD0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xD7"],

        ["\xC1\xD8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xD1"],
        ["\xC1\xD1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xD8"],

        ["\xC1\xD9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xD2"],
        ["\xC1\xD2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xD9"],

        ["\xC1\xE2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xD3"],
        ["\xC1\xD3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xE2"],

        ["\xC1\xE3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xD4"],
        ["\xC1\xD4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xE3"],

        ["\xC1\xE4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xD5"],
        ["\xC1\xD5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xE4"],

        ["\xC1\xE5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xD6"],
        ["\xC1\xD6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xE5"],

        ["\xC1\xE6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xD7"],
        ["\xC1\xD7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xE6"],

        ["\xC1\xE7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xD8"],
        ["\xC1\xD8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xE7"],

        ["\xC1\xE8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xD9"],
        ["\xC1\xD9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xE8"],

        ["\xC1\xE9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xDA"],
        ["\xC1\xDA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xE9"],

        ["\xC1\x4A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xDB"],
        ["\xC1\xDB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\x4A"],

        ["\xC1\x5B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xDC"],
        ["\xC1\xDC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\x5B"],

        ["\xC1\x5A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xDD"],
        ["\xC1\xDD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\x5A"],

        ["\xC1\x5F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xDE"],
        ["\xC1\xDE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\x5F"],

        ["\xC1\x6D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xDF"],
        ["\xC1\xDF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\x6D"],

        ["\xC1\x79",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xE0"],
        ["\xC1\xE0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\x79"],

        ["\xC1\x57",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xE1"],
        ["\xC1\xE1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\x57"],

        ["\xC1\x59",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xE2"],
        ["\xC1\xE2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\x59"],

        ["\xC1\x62",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xE3"],
        ["\xC1\xE3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\x62"],

        ["\xC1\x63",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xE4"],
        ["\xC1\xE4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\x63"],

        ["\xC1\x64",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xE5"],
        ["\xC1\xE5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\x64"],

        ["\xC1\x65",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xE6"],
        ["\xC1\xE6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\x65"],

        ["\xC1\x66",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xE7"],
        ["\xC1\xE7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\x66"],

        ["\xC1\x67",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xE8"],
        ["\xC1\xE8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\x67"],

        ["\xC1\x68",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xE9"],
        ["\xC1\xE9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\x68"],

        ["\xC1\x69",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xEA"],
        ["\xC1\xEA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\x69"],

        ["\xC1\x70",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xEB"],
        ["\xC1\xEB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\x70"],

        ["\xC1\x71",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xEC"],
        ["\xC1\xEC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\x71"],

        ["\xC1\x72",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xED"],
        ["\xC1\xED",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\x72"],

        ["\xC1\x73",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xEE"],
        ["\xC1\xEE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\x73"],

        ["\xC1\x74",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xEF"],
        ["\xC1\xEF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\x74"],

        ["\xC1\x75",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xF0"],
        ["\xC1\xF0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\x75"],

        ["\xC1\x76",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xF1"],
        ["\xC1\xF1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\x76"],

        ["\xC1\x77",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xF2"],
        ["\xC1\xF2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\x77"],

        ["\xC1\x78",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xF3"],
        ["\xC1\xF3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\x78"],

        ["\xC1\x80",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xF4"],
        ["\xC1\xF4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\x80"],

        ["\xC1\x8B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xF5"],
        ["\xC1\xF5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\x8B"],

        ["\xC1\x9B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xF6"],
        ["\xC1\xF6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\x9B"],

        ["\xC1\x9C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xF7"],
        ["\xC1\xF7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\x9C"],

        ["\xC1\xA0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xF8"],
        ["\xC1\xF8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xA0"],

        ["\xC1\xAB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xF9"],
        ["\xC1\xF9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xAB"],

        ["\xC1\xB0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xFA"],
        ["\xC1\xFA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xB0"],

        ["\xC1\xC0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xFB"],
        ["\xC1\xFB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xC0"],

        ["\xC1\x6A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xFC"],
        ["\xC1\xFC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\x6A"],

        ["\xC1\xD0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xFD"],
        ["\xC1\xFD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xD0"],

        ["\xC1\xA1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC1\xFE"],
        ["\xC1\xFE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xA1"],

        ["\xC2\x4F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xA1"],
        ["\xC2\xA1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\x4F"],

        ["\xC2\x7F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xA2"],
        ["\xC2\xA2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\x7F"],

        ["\xC2\x7B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xA3"],
        ["\xC2\xA3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\x7B"],

        ["\xC2\xE0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xA4"],
        ["\xC2\xA4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xE0"],

        ["\xC2\x6C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xA5"],
        ["\xC2\xA5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\x6C"],

        ["\xC2\x50",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xA6"],
        ["\xC2\xA6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\x50"],

        ["\xC2\x7D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xA7"],
        ["\xC2\xA7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\x7D"],

        ["\xC2\x4D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xA8"],
        ["\xC2\xA8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\x4D"],

        ["\xC2\x5D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xA9"],
        ["\xC2\xA9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\x5D"],

        ["\xC2\x5C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xAA"],
        ["\xC2\xAA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\x5C"],

        ["\xC2\x4E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xAB"],
        ["\xC2\xAB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\x4E"],

        ["\xC2\x6B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xAC"],
        ["\xC2\xAC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\x6B"],

        ["\xC2\x60",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xAD"],
        ["\xC2\xAD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\x60"],

        ["\xC2\x4B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xAE"],
        ["\xC2\xAE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\x4B"],

        ["\xC2\x61",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xAF"],
        ["\xC2\xAF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\x61"],

        ["\xC2\xF0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xB0"],
        ["\xC2\xB0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xF0"],

        ["\xC2\xF1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xB1"],
        ["\xC2\xB1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xF1"],

        ["\xC2\xF2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xB2"],
        ["\xC2\xB2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xF2"],

        ["\xC2\xF3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xB3"],
        ["\xC2\xB3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xF3"],

        ["\xC2\xF4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xB4"],
        ["\xC2\xB4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xF4"],

        ["\xC2\xF5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xB5"],
        ["\xC2\xB5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xF5"],

        ["\xC2\xF6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xB6"],
        ["\xC2\xB6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xF6"],

        ["\xC2\xF7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xB7"],
        ["\xC2\xB7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xF7"],

        ["\xC2\xF8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xB8"],
        ["\xC2\xB8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xF8"],

        ["\xC2\xF9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xB9"],
        ["\xC2\xB9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xF9"],

        ["\xC2\x7A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xBA"],
        ["\xC2\xBA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\x7A"],

        ["\xC2\x5E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xBB"],
        ["\xC2\xBB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\x5E"],

        ["\xC2\x4C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xBC"],
        ["\xC2\xBC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\x4C"],

        ["\xC2\x7E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xBD"],
        ["\xC2\xBD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\x7E"],

        ["\xC2\x6E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xBE"],
        ["\xC2\xBE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\x6E"],

        ["\xC2\x6F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xBF"],
        ["\xC2\xBF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\x6F"],

        ["\xC2\x7C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xC0"],
        ["\xC2\xC0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\x7C"],

        ["\xC2\xC1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xC1"],
        ["\xC2\xC1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xC1"],

        ["\xC2\xC2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xC2"],
        ["\xC2\xC2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xC2"],

        ["\xC2\xC3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xC3"],
        ["\xC2\xC3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xC3"],

        ["\xC2\xC4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xC4"],
        ["\xC2\xC4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xC4"],

        ["\xC2\xC5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xC5"],
        ["\xC2\xC5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xC5"],

        ["\xC2\xC6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xC6"],
        ["\xC2\xC6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xC6"],

        ["\xC2\xC7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xC7"],
        ["\xC2\xC7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xC7"],

        ["\xC2\xC8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xC8"],
        ["\xC2\xC8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xC8"],

        ["\xC2\xC9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xC9"],
        ["\xC2\xC9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xC9"],

        ["\xC2\xD1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xCA"],
        ["\xC2\xCA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xD1"],

        ["\xC2\xD2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xCB"],
        ["\xC2\xCB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xD2"],

        ["\xC2\xD3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xCC"],
        ["\xC2\xCC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xD3"],

        ["\xC2\xD4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xCD"],
        ["\xC2\xCD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xD4"],

        ["\xC2\xD5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xCE"],
        ["\xC2\xCE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xD5"],

        ["\xC2\xD6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xCF"],
        ["\xC2\xCF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xD6"],

        ["\xC2\xD7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xD0"],
        ["\xC2\xD0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xD7"],

        ["\xC2\xD8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xD1"],
        ["\xC2\xD1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xD8"],

        ["\xC2\xD9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xD2"],
        ["\xC2\xD2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xD9"],

        ["\xC2\xE2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xD3"],
        ["\xC2\xD3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xE2"],

        ["\xC2\xE3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xD4"],
        ["\xC2\xD4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xE3"],

        ["\xC2\xE4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xD5"],
        ["\xC2\xD5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xE4"],

        ["\xC2\xE5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xD6"],
        ["\xC2\xD6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xE5"],

        ["\xC2\xE6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xD7"],
        ["\xC2\xD7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xE6"],

        ["\xC2\xE7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xD8"],
        ["\xC2\xD8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xE7"],

        ["\xC2\xE8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xD9"],
        ["\xC2\xD9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xE8"],

        ["\xC2\xE9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xDA"],
        ["\xC2\xDA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xE9"],

        ["\xC2\x4A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xDB"],
        ["\xC2\xDB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\x4A"],

        ["\xC2\x5B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xDC"],
        ["\xC2\xDC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\x5B"],

        ["\xC2\x5A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xDD"],
        ["\xC2\xDD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\x5A"],

        ["\xC2\x5F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xDE"],
        ["\xC2\xDE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\x5F"],

        ["\xC2\x6D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xDF"],
        ["\xC2\xDF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\x6D"],

        ["\xC2\x79",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xE0"],
        ["\xC2\xE0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\x79"],

        ["\xC2\x57",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xE1"],
        ["\xC2\xE1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\x57"],

        ["\xC2\x59",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xE2"],
        ["\xC2\xE2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\x59"],

        ["\xC2\x62",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xE3"],
        ["\xC2\xE3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\x62"],

        ["\xC2\x63",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xE4"],
        ["\xC2\xE4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\x63"],

        ["\xC2\x64",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xE5"],
        ["\xC2\xE5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\x64"],

        ["\xC2\x65",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xE6"],
        ["\xC2\xE6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\x65"],

        ["\xC2\x66",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xE7"],
        ["\xC2\xE7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\x66"],

        ["\xC2\x67",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xE8"],
        ["\xC2\xE8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\x67"],

        ["\xC2\x68",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xE9"],
        ["\xC2\xE9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\x68"],

        ["\xC2\x69",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xEA"],
        ["\xC2\xEA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\x69"],

        ["\xC2\x70",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xEB"],
        ["\xC2\xEB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\x70"],

        ["\xC2\x71",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xEC"],
        ["\xC2\xEC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\x71"],

        ["\xC2\x72",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xED"],
        ["\xC2\xED",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\x72"],

        ["\xC2\x73",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xEE"],
        ["\xC2\xEE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\x73"],

        ["\xC2\x74",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xEF"],
        ["\xC2\xEF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\x74"],

        ["\xC2\x75",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xF0"],
        ["\xC2\xF0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\x75"],

        ["\xC2\x76",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xF1"],
        ["\xC2\xF1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\x76"],

        ["\xC2\x77",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xF2"],
        ["\xC2\xF2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\x77"],

        ["\xC2\x78",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xF3"],
        ["\xC2\xF3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\x78"],

        ["\xC2\x80",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xF4"],
        ["\xC2\xF4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\x80"],

        ["\xC2\x8B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xF5"],
        ["\xC2\xF5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\x8B"],

        ["\xC2\x9B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xF6"],
        ["\xC2\xF6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\x9B"],

        ["\xC2\x9C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xF7"],
        ["\xC2\xF7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\x9C"],

        ["\xC2\xA0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xF8"],
        ["\xC2\xF8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xA0"],

        ["\xC2\xAB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xF9"],
        ["\xC2\xF9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xAB"],

        ["\xC2\xB0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xFA"],
        ["\xC2\xFA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xB0"],

        ["\xC2\xC0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xFB"],
        ["\xC2\xFB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xC0"],

        ["\xC2\x6A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xFC"],
        ["\xC2\xFC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\x6A"],

        ["\xC2\xD0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xFD"],
        ["\xC2\xFD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xD0"],

        ["\xC2\xA1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xFE"],
        ["\xC2\xFE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xA1"],

        ["\xC3\x4F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xA1"],
        ["\xC3\xA1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\x4F"],

        ["\xC3\x7F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xA2"],
        ["\xC3\xA2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\x7F"],

        ["\xC3\x7B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xA3"],
        ["\xC3\xA3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\x7B"],

        ["\xC3\xE0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xA4"],
        ["\xC3\xA4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xE0"],

        ["\xC3\x6C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xA5"],
        ["\xC3\xA5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\x6C"],

        ["\xC3\x50",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xA6"],
        ["\xC3\xA6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\x50"],

        ["\xC3\x7D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xA7"],
        ["\xC3\xA7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\x7D"],

        ["\xC3\x4D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xA8"],
        ["\xC3\xA8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\x4D"],

        ["\xC3\x5D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xA9"],
        ["\xC3\xA9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\x5D"],

        ["\xC3\x5C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xAA"],
        ["\xC3\xAA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\x5C"],

        ["\xC3\x4E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xAB"],
        ["\xC3\xAB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\x4E"],

        ["\xC3\x6B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xAC"],
        ["\xC3\xAC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\x6B"],

        ["\xC3\x60",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xAD"],
        ["\xC3\xAD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\x60"],

        ["\xC3\x4B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xAE"],
        ["\xC3\xAE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\x4B"],

        ["\xC3\x61",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xAF"],
        ["\xC3\xAF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\x61"],

        ["\xC3\xF0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xB0"],
        ["\xC3\xB0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xF0"],

        ["\xC3\xF1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xB1"],
        ["\xC3\xB1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xF1"],

        ["\xC3\xF2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xB2"],
        ["\xC3\xB2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xF2"],

        ["\xC3\xF3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xB3"],
        ["\xC3\xB3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xF3"],

        ["\xC3\xF4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xB4"],
        ["\xC3\xB4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xF4"],

        ["\xC3\xF5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xB5"],
        ["\xC3\xB5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xF5"],

        ["\xC3\xF6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xB6"],
        ["\xC3\xB6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xF6"],

        ["\xC3\xF7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xB7"],
        ["\xC3\xB7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xF7"],

        ["\xC3\xF8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xB8"],
        ["\xC3\xB8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xF8"],

        ["\xC3\xF9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xB9"],
        ["\xC3\xB9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xF9"],

        ["\xC3\x7A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xBA"],
        ["\xC3\xBA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\x7A"],

        ["\xC3\x5E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xBB"],
        ["\xC3\xBB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\x5E"],

        ["\xC3\x4C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xBC"],
        ["\xC3\xBC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\x4C"],

        ["\xC3\x7E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xBD"],
        ["\xC3\xBD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\x7E"],

        ["\xC3\x6E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xBE"],
        ["\xC3\xBE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\x6E"],

        ["\xC3\x6F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xBF"],
        ["\xC3\xBF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\x6F"],

        ["\xC3\x7C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xC0"],
        ["\xC3\xC0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\x7C"],

        ["\xC3\xC1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xC1"],
        ["\xC3\xC1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xC1"],

        ["\xC3\xC2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xC2"],
        ["\xC3\xC2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xC2"],

        ["\xC3\xC3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xC3"],
        ["\xC3\xC3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xC3"],

        ["\xC3\xC4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xC4"],
        ["\xC3\xC4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xC4"],

        ["\xC3\xC5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xC5"],
        ["\xC3\xC5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xC5"],

        ["\xC3\xC6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xC6"],
        ["\xC3\xC6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xC6"],

        ["\xC3\xC7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xC7"],
        ["\xC3\xC7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xC7"],

        ["\xC3\xC8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xC8"],
        ["\xC3\xC8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xC8"],

        ["\xC3\xC9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xC9"],
        ["\xC3\xC9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xC9"],

        ["\xC3\xD1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xCA"],
        ["\xC3\xCA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xD1"],

        ["\xC3\xD2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xCB"],
        ["\xC3\xCB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xD2"],

        ["\xC3\xD3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xCC"],
        ["\xC3\xCC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xD3"],

        ["\xC3\xD4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xCD"],
        ["\xC3\xCD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xD4"],

        ["\xC3\xD5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xCE"],
        ["\xC3\xCE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xD5"],

        ["\xC3\xD6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xCF"],
        ["\xC3\xCF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xD6"],

        ["\xC3\xD7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xD0"],
        ["\xC3\xD0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xD7"],

        ["\xC3\xD8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xD1"],
        ["\xC3\xD1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xD8"],

        ["\xC3\xD9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xD2"],
        ["\xC3\xD2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xD9"],

        ["\xC3\xE2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xD3"],
        ["\xC3\xD3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xE2"],

        ["\xC3\xE3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xD4"],
        ["\xC3\xD4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xE3"],

        ["\xC3\xE4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xD5"],
        ["\xC3\xD5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xE4"],

        ["\xC3\xE5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xD6"],
        ["\xC3\xD6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xE5"],

        ["\xC3\xE6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xD7"],
        ["\xC3\xD7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xE6"],

        ["\xC3\xE7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xD8"],
        ["\xC3\xD8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xE7"],

        ["\xC3\xE8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xD9"],
        ["\xC3\xD9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xE8"],

        ["\xC3\xE9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xDA"],
        ["\xC3\xDA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xE9"],

        ["\xC3\x4A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xDB"],
        ["\xC3\xDB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\x4A"],

        ["\xC3\x5B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xDC"],
        ["\xC3\xDC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\x5B"],

        ["\xC3\x5A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xDD"],
        ["\xC3\xDD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\x5A"],

        ["\xC3\x5F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xDE"],
        ["\xC3\xDE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\x5F"],

        ["\xC3\x6D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xDF"],
        ["\xC3\xDF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\x6D"],

        ["\xC3\x79",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xE0"],
        ["\xC3\xE0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\x79"],

        ["\xC3\x57",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xE1"],
        ["\xC3\xE1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\x57"],

        ["\xC3\x59",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xE2"],
        ["\xC3\xE2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\x59"],

        ["\xC3\x62",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xE3"],
        ["\xC3\xE3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\x62"],

        ["\xC3\x63",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xE4"],
        ["\xC3\xE4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\x63"],

        ["\xC3\x64",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xE5"],
        ["\xC3\xE5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\x64"],

        ["\xC3\x65",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xE6"],
        ["\xC3\xE6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\x65"],

        ["\xC3\x66",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xE7"],
        ["\xC3\xE7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\x66"],

        ["\xC3\x67",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xE8"],
        ["\xC3\xE8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\x67"],

        ["\xC3\x68",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xE9"],
        ["\xC3\xE9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\x68"],

        ["\xC3\x69",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xEA"],
        ["\xC3\xEA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\x69"],

        ["\xC3\x70",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xEB"],
        ["\xC3\xEB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\x70"],

        ["\xC3\x71",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xEC"],
        ["\xC3\xEC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\x71"],

        ["\xC3\x72",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xED"],
        ["\xC3\xED",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\x72"],

        ["\xC3\x73",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xEE"],
        ["\xC3\xEE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\x73"],

        ["\xC3\x74",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xEF"],
        ["\xC3\xEF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\x74"],

        ["\xC3\x75",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xF0"],
        ["\xC3\xF0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\x75"],

        ["\xC3\x76",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xF1"],
        ["\xC3\xF1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\x76"],

        ["\xC3\x77",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xF2"],
        ["\xC3\xF2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\x77"],

        ["\xC3\x78",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xF3"],
        ["\xC3\xF3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\x78"],

        ["\xC3\x80",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xF4"],
        ["\xC3\xF4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\x80"],

        ["\xC3\x8B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xF5"],
        ["\xC3\xF5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\x8B"],

        ["\xC3\x9B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xF6"],
        ["\xC3\xF6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\x9B"],

        ["\xC3\x9C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xF7"],
        ["\xC3\xF7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\x9C"],

        ["\xC3\xA0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xF8"],
        ["\xC3\xF8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xA0"],

        ["\xC3\xAB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xF9"],
        ["\xC3\xF9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xAB"],

        ["\xC3\xB0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xFA"],
        ["\xC3\xFA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xB0"],

        ["\xC3\xC0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xFB"],
        ["\xC3\xFB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xC0"],

        ["\xC3\x6A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xFC"],
        ["\xC3\xFC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\x6A"],

        ["\xC3\xD0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xFD"],
        ["\xC3\xFD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xD0"],

        ["\xC3\xA1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xFE"],
        ["\xC3\xFE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xA1"],

        ["\xC4\x4F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xA1"],
        ["\xC4\xA1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\x4F"],

        ["\xC4\x7F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xA2"],
        ["\xC4\xA2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\x7F"],

        ["\xC4\x7B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xA3"],
        ["\xC4\xA3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\x7B"],

        ["\xC4\xE0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xA4"],
        ["\xC4\xA4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xE0"],

        ["\xC4\x6C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xA5"],
        ["\xC4\xA5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\x6C"],

        ["\xC4\x50",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xA6"],
        ["\xC4\xA6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\x50"],

        ["\xC4\x7D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xA7"],
        ["\xC4\xA7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\x7D"],

        ["\xC4\x4D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xA8"],
        ["\xC4\xA8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\x4D"],

        ["\xC4\x5D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xA9"],
        ["\xC4\xA9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\x5D"],

        ["\xC4\x5C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xAA"],
        ["\xC4\xAA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\x5C"],

        ["\xC4\x4E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xAB"],
        ["\xC4\xAB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\x4E"],

        ["\xC4\x6B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xAC"],
        ["\xC4\xAC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\x6B"],

        ["\xC4\x60",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xAD"],
        ["\xC4\xAD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\x60"],

        ["\xC4\x4B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xAE"],
        ["\xC4\xAE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\x4B"],

        ["\xC4\x61",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xAF"],
        ["\xC4\xAF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\x61"],

        ["\xC4\xF0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xB0"],
        ["\xC4\xB0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xF0"],

        ["\xC4\xF1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xB1"],
        ["\xC4\xB1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xF1"],

        ["\xC4\xF2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xB2"],
        ["\xC4\xB2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xF2"],

        ["\xC4\xF3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xB3"],
        ["\xC4\xB3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xF3"],

        ["\xC4\xF4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xB4"],
        ["\xC4\xB4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xF4"],

        ["\xC4\xF5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xB5"],
        ["\xC4\xB5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xF5"],

        ["\xC4\xF6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xB6"],
        ["\xC4\xB6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xF6"],

        ["\xC4\xF7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xB7"],
        ["\xC4\xB7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xF7"],

        ["\xC4\xF8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xB8"],
        ["\xC4\xB8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xF8"],

        ["\xC4\xF9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xB9"],
        ["\xC4\xB9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xF9"],

        ["\xC4\x7A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xBA"],
        ["\xC4\xBA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\x7A"],

        ["\xC4\x5E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xBB"],
        ["\xC4\xBB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\x5E"],

        ["\xC4\x4C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xBC"],
        ["\xC4\xBC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\x4C"],

        ["\xC4\x7E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xBD"],
        ["\xC4\xBD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\x7E"],

        ["\xC4\x6E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xBE"],
        ["\xC4\xBE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\x6E"],

        ["\xC4\x6F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xBF"],
        ["\xC4\xBF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\x6F"],

        ["\xC4\x7C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xC0"],
        ["\xC4\xC0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\x7C"],

        ["\xC4\xC1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xC1"],
        ["\xC4\xC1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xC1"],

        ["\xC4\xC2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xC2"],
        ["\xC4\xC2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xC2"],

        ["\xC4\xC3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xC3"],
        ["\xC4\xC3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xC3"],

        ["\xC4\xC4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xC4"],
        ["\xC4\xC4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xC4"],

        ["\xC4\xC5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xC5"],
        ["\xC4\xC5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xC5"],

        ["\xC4\xC6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xC6"],
        ["\xC4\xC6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xC6"],

        ["\xC4\xC7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xC7"],
        ["\xC4\xC7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xC7"],

        ["\xC4\xC8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xC8"],
        ["\xC4\xC8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xC8"],

        ["\xC4\xC9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xC9"],
        ["\xC4\xC9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xC9"],

        ["\xC4\xD1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xCA"],
        ["\xC4\xCA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xD1"],

        ["\xC4\xD2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xCB"],
        ["\xC4\xCB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xD2"],

        ["\xC4\xD3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xCC"],
        ["\xC4\xCC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xD3"],

        ["\x86\xEB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xCD"],
        ["\xC4\xCD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x86\xEB"],

        ["\xC4\xD5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xCE"],
        ["\xC4\xCE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xD5"],

        ["\xC4\xD6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xCF"],
        ["\xC4\xCF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xD6"],

        ["\xC4\xD7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xD0"],
        ["\xC4\xD0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xD7"],

        ["\xC4\xD8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xD1"],
        ["\xC4\xD1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xD8"],

        ["\xC4\xD9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xD2"],
        ["\xC4\xD2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xD9"],

        ["\xC4\xE2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xD3"],
        ["\xC4\xD3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xE2"],

        ["\xC4\xE3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xD4"],
        ["\xC4\xD4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xE3"],

        ["\xC4\xE4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xD5"],
        ["\xC4\xD5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xE4"],

        ["\xC4\xE5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xD6"],
        ["\xC4\xD6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xE5"],

        ["\xC4\xE6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xD7"],
        ["\xC4\xD7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xE6"],

        ["\xC4\xE7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xD8"],
        ["\xC4\xD8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xE7"],

        ["\xC4\xE8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xD9"],
        ["\xC4\xD9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xE8"],

        ["\xC4\xE9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xDA"],
        ["\xC4\xDA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xE9"],

        ["\xE3\x63",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xDB"],
        ["\xC4\xDB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\x63"],

        ["\xC4\x5B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xDC"],
        ["\xC4\xDC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\x5B"],

        ["\xC4\x5A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xDD"],
        ["\xC4\xDD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\x5A"],

        ["\xC4\x5F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xDE"],
        ["\xC4\xDE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\x5F"],

        ["\xC4\x6D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xDF"],
        ["\xC4\xDF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\x6D"],

        ["\xC4\x79",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xE0"],
        ["\xC4\xE0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\x79"],

        ["\xC4\x57",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xE1"],
        ["\xC4\xE1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\x57"],

        ["\xC4\x59",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xE2"],
        ["\xC4\xE2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\x59"],

        ["\xC4\x62",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xE3"],
        ["\xC4\xE3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\x62"],

        ["\xC4\x63",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xE4"],
        ["\xC4\xE4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\x63"],

        ["\xC4\x64",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xE5"],
        ["\xC4\xE5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\x64"],

        ["\xC4\x65",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xE6"],
        ["\xC4\xE6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\x65"],

        ["\xC4\x66",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xE7"],
        ["\xC4\xE7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\x66"],

        ["\xC4\x67",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xE8"],
        ["\xC4\xE8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\x67"],

        ["\xC4\x68",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xE9"],
        ["\xC4\xE9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\x68"],

        ["\xC4\x69",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xEA"],
        ["\xC4\xEA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\x69"],

        ["\xC4\x70",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xEB"],
        ["\xC4\xEB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\x70"],

        ["\xC4\x71",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xEC"],
        ["\xC4\xEC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\x71"],

        ["\xC4\x72",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xED"],
        ["\xC4\xED",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\x72"],

        ["\xC4\x73",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xEE"],
        ["\xC4\xEE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\x73"],

        ["\xC4\x74",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xEF"],
        ["\xC4\xEF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\x74"],

        ["\xC4\x75",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xF0"],
        ["\xC4\xF0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\x75"],

        ["\xC4\x76",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xF1"],
        ["\xC4\xF1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\x76"],

        ["\xC4\x77",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xF2"],
        ["\xC4\xF2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\x77"],

        ["\xC4\x78",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xF3"],
        ["\xC4\xF3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\x78"],

        ["\xC4\x80",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xF4"],
        ["\xC4\xF4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\x80"],

        ["\xC4\x8B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xF5"],
        ["\xC4\xF5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\x8B"],

        ["\xC4\x9B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xF6"],
        ["\xC4\xF6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\x9B"],

        ["\xC4\x9C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xF7"],
        ["\xC4\xF7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\x9C"],

        ["\xC4\xA0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xF8"],
        ["\xC4\xF8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xA0"],

        ["\xC4\xAB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xF9"],
        ["\xC4\xF9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xAB"],

        ["\xC4\xB0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xFA"],
        ["\xC4\xFA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xB0"],

        ["\xC4\xC0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xFB"],
        ["\xC4\xFB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xC0"],

        ["\xC4\x6A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xFC"],
        ["\xC4\xFC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\x6A"],

        ["\xC4\xD0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xFD"],
        ["\xC4\xFD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xD0"],

        ["\xC4\xA1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC4\xFE"],
        ["\xC4\xFE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xA1"],

        ["\xC5\x4F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xA1"],
        ["\xC5\xA1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC5\x4F"],

        ["\xC5\x7F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xA2"],
        ["\xC5\xA2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC5\x7F"],

        ["\xC5\x7B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xA3"],
        ["\xC5\xA3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC5\x7B"],

        ["\xC5\xE0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xA4"],
        ["\xC5\xA4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xE0"],

        ["\xC5\x6C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xA5"],
        ["\xC5\xA5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC5\x6C"],

        ["\xC5\x50",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xA6"],
        ["\xC5\xA6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC5\x50"],

        ["\xC5\x7D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xA7"],
        ["\xC5\xA7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC5\x7D"],

        ["\xC5\x4D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xA8"],
        ["\xC5\xA8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC5\x4D"],

        ["\xC5\x5D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xA9"],
        ["\xC5\xA9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC5\x5D"],

        ["\xC5\x5C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xAA"],
        ["\xC5\xAA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC5\x5C"],

        ["\xC5\x4E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xAB"],
        ["\xC5\xAB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC5\x4E"],

        ["\xC5\x6B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xAC"],
        ["\xC5\xAC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC5\x6B"],

        ["\xC5\x60",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xAD"],
        ["\xC5\xAD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC5\x60"],

        ["\xC5\x4B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xAE"],
        ["\xC5\xAE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC5\x4B"],

        ["\xC5\x61",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xAF"],
        ["\xC5\xAF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC5\x61"],

        ["\xC5\xF0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xB0"],
        ["\xC5\xB0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xF0"],

        ["\xC5\xF1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xB1"],
        ["\xC5\xB1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xF1"],

        ["\xC5\xF2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xB2"],
        ["\xC5\xB2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xF2"],

        ["\xC5\xF3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xB3"],
        ["\xC5\xB3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xF3"],

        ["\xC5\xF4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xB4"],
        ["\xC5\xB4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xF4"],

        ["\xC5\xF5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xB5"],
        ["\xC5\xB5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xF5"],

        ["\xAC\xB8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xB6"],
        ["\xC5\xB6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xAC\xB8"],

        ["\xC5\xF7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xB7"],
        ["\xC5\xB7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xF7"],

        ["\xC5\xF8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xB8"],
        ["\xC5\xB8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xF8"],

        ["\xC5\xF9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xB9"],
        ["\xC5\xB9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xF9"],

        ["\xC5\x7A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xBA"],
        ["\xC5\xBA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC5\x7A"],

        ["\xC5\x5E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xBB"],
        ["\xC5\xBB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC5\x5E"],

        ["\xC5\x4C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xBC"],
        ["\xC5\xBC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC5\x4C"],

        ["\xC5\x7E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xBD"],
        ["\xC5\xBD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC5\x7E"],

        ["\xC5\x6E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xBE"],
        ["\xC5\xBE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC5\x6E"],

        ["\xA9\x43",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xBF"],
        ["\xC5\xBF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xA9\x43"],

        ["\xC5\x7C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xC0"],
        ["\xC5\xC0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC5\x7C"],

        ["\xC5\xC1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xC1"],
        ["\xC5\xC1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xC1"],

        ["\xC5\xC2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xC2"],
        ["\xC5\xC2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xC2"],

        ["\xC5\xC3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xC3"],
        ["\xC5\xC3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xC3"],

        ["\xC5\xC4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xC4"],
        ["\xC5\xC4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xC4"],

        ["\xC5\xC5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xC5"],
        ["\xC5\xC5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xC5"],

        ["\xC5\xC6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xC6"],
        ["\xC5\xC6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xC6"],

        ["\xC5\xC7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xC7"],
        ["\xC5\xC7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xC7"],

        ["\xC5\xC8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xC8"],
        ["\xC5\xC8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xC8"],

        ["\xC5\xC9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xC9"],
        ["\xC5\xC9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xC9"],

        ["\xC5\xD1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xCA"],
        ["\xC5\xCA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xD1"],

        ["\xC5\xD2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xCB"],
        ["\xC5\xCB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xD2"],

        ["\xC5\xD3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xCC"],
        ["\xC5\xCC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xD3"],

        ["\xC5\xD4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xCD"],
        ["\xC5\xCD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xD4"],

        ["\xC5\xD5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xCE"],
        ["\xC5\xCE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xD5"],

        ["\xC5\xD6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xCF"],
        ["\xC5\xCF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xD6"],

        ["\xC5\xD7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xD0"],
        ["\xC5\xD0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xD7"],

        ["\xC5\xD8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xD1"],
        ["\xC5\xD1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xD8"],

        ["\xC5\xD9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xD2"],
        ["\xC5\xD2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xD9"],

        ["\xC5\xE2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xD3"],
        ["\xC5\xD3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xE2"],

        ["\xC5\xE3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xD4"],
        ["\xC5\xD4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xE3"],

        ["\xC5\xE4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xD5"],
        ["\xC5\xD5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xE4"],

        ["\xC5\xE5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xD6"],
        ["\xC5\xD6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xE5"],

        ["\x59\x69",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xD7"],
        ["\xC5\xD7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\x69"],

        ["\xC5\xE7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xD8"],
        ["\xC5\xD8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xE7"],

        ["\xC5\xE8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xD9"],
        ["\xC5\xD9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xE8"],

        ["\xC5\xE9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xDA"],
        ["\xC5\xDA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xE9"],

        ["\xC5\x4A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xDB"],
        ["\xC5\xDB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC5\x4A"],

        ["\xC5\x5B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xDC"],
        ["\xC5\xDC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC5\x5B"],

        ["\xC5\x5A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xDD"],
        ["\xC5\xDD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC5\x5A"],

        ["\xC5\x5F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xDE"],
        ["\xC5\xDE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC5\x5F"],

        ["\xC5\x6D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xDF"],
        ["\xC5\xDF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC5\x6D"],

        ["\xC5\x79",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xE0"],
        ["\xC5\xE0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC5\x79"],

        ["\xC5\x57",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xE1"],
        ["\xC5\xE1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC5\x57"],

        ["\xC5\x59",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xE2"],
        ["\xC5\xE2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC5\x59"],

        ["\xC5\x62",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xE3"],
        ["\xC5\xE3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC5\x62"],

        ["\xC5\x63",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xE4"],
        ["\xC5\xE4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC5\x63"],

        ["\xC5\x64",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xE5"],
        ["\xC5\xE5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC5\x64"],

        ["\xC5\x65",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xE6"],
        ["\xC5\xE6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC5\x65"],

        ["\xC5\x66",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xE7"],
        ["\xC5\xE7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC5\x66"],

        ["\xC5\x67",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xE8"],
        ["\xC5\xE8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC5\x67"],

        ["\xC5\x68",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xE9"],
        ["\xC5\xE9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC5\x68"],

        ["\xC5\x69",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xEA"],
        ["\xC5\xEA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC5\x69"],

        ["\xC5\x70",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xEB"],
        ["\xC5\xEB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC5\x70"],

        ["\xC5\x71",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xEC"],
        ["\xC5\xEC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC5\x71"],

        ["\xC5\x72",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xED"],
        ["\xC5\xED",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC5\x72"],

        ["\x4A\x72",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xEE"],
        ["\xC5\xEE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\x72"],

        ["\xC5\x74",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xEF"],
        ["\xC5\xEF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC5\x74"],

        ["\xC5\x75",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xF0"],
        ["\xC5\xF0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC5\x75"],

        ["\xC5\x76",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xF1"],
        ["\xC5\xF1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC5\x76"],

        ["\xC5\x77",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xF2"],
        ["\xC5\xF2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC5\x77"],

        ["\x5F\xF9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xF3"],
        ["\xC5\xF3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\xF9"],

        ["\xC5\x80",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xF4"],
        ["\xC5\xF4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC5\x80"],

        ["\xC5\x8B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xF5"],
        ["\xC5\xF5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC5\x8B"],

        ["\xC5\x9B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xF6"],
        ["\xC5\xF6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC5\x9B"],

        ["\xC5\x9C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xF7"],
        ["\xC5\xF7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC5\x9C"],

        ["\xC5\xA0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xF8"],
        ["\xC5\xF8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xA0"],

        ["\xC5\xAB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xF9"],
        ["\xC5\xF9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xAB"],

        ["\xC5\xB0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xFA"],
        ["\xC5\xFA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xB0"],

        ["\xC5\xC0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xFB"],
        ["\xC5\xFB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xC0"],

        ["\xC5\x6A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xFC"],
        ["\xC5\xFC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC5\x6A"],

        ["\xC5\xD0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xFD"],
        ["\xC5\xFD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xD0"],

        ["\xC5\xA1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\xFE"],
        ["\xC5\xFE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xA1"],

        ["\xC6\x4F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xA1"],
        ["\xC6\xA1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\x4F"],

        ["\xC6\x7F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xA2"],
        ["\xC6\xA2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\x7F"],

        ["\xC6\x7B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xA3"],
        ["\xC6\xA3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\x7B"],

        ["\xC6\xE0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xA4"],
        ["\xC6\xA4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xE0"],

        ["\xC6\x6C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xA5"],
        ["\xC6\xA5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\x6C"],

        ["\xC6\x50",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xA6"],
        ["\xC6\xA6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\x50"],

        ["\xC6\x7D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xA7"],
        ["\xC6\xA7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\x7D"],

        ["\xC6\x4D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xA8"],
        ["\xC6\xA8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\x4D"],

        ["\xC6\x5D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xA9"],
        ["\xC6\xA9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\x5D"],

        ["\xC6\x5C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xAA"],
        ["\xC6\xAA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\x5C"],

        ["\xC6\x4E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xAB"],
        ["\xC6\xAB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\x4E"],

        ["\xC6\x6B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xAC"],
        ["\xC6\xAC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\x6B"],

        ["\xC6\x60",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xAD"],
        ["\xC6\xAD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\x60"],

        ["\xC6\x4B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xAE"],
        ["\xC6\xAE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\x4B"],

        ["\xC6\x61",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xAF"],
        ["\xC6\xAF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\x61"],

        ["\xC6\xF0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xB0"],
        ["\xC6\xB0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xF0"],

        ["\xC6\xF1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xB1"],
        ["\xC6\xB1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xF1"],

        ["\xC6\xF2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xB2"],
        ["\xC6\xB2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xF2"],

        ["\xC6\xF3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xB3"],
        ["\xC6\xB3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xF3"],

        ["\xC6\xF4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xB4"],
        ["\xC6\xB4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xF4"],

        ["\xC6\xF5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xB5"],
        ["\xC6\xB5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xF5"],

        ["\xC6\xF6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xB6"],
        ["\xC6\xB6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xF6"],

        ["\xC6\xF7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xB7"],
        ["\xC6\xB7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xF7"],

        ["\xC6\xF8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xB8"],
        ["\xC6\xB8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xF8"],

        ["\xC6\xF9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xB9"],
        ["\xC6\xB9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xF9"],

        ["\xC6\x7A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xBA"],
        ["\xC6\xBA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\x7A"],

        ["\xC6\x5E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xBB"],
        ["\xC6\xBB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\x5E"],

        ["\xC6\x4C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xBC"],
        ["\xC6\xBC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\x4C"],

        ["\xC6\x7E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xBD"],
        ["\xC6\xBD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\x7E"],

        ["\xC6\x6E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xBE"],
        ["\xC6\xBE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\x6E"],

        ["\xC6\x6F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xBF"],
        ["\xC6\xBF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\x6F"],

        ["\xC6\x7C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xC0"],
        ["\xC6\xC0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\x7C"],

        ["\xC6\xC1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xC1"],
        ["\xC6\xC1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xC1"],

        ["\xC6\xC2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xC2"],
        ["\xC6\xC2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xC2"],

        ["\xC6\xC3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xC3"],
        ["\xC6\xC3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xC3"],

        ["\xC6\xC4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xC4"],
        ["\xC6\xC4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xC4"],

        ["\xC6\xC5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xC5"],
        ["\xC6\xC5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xC5"],

        ["\xC6\xC6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xC6"],
        ["\xC6\xC6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xC6"],

        ["\xC6\xC7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xC7"],
        ["\xC6\xC7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xC7"],

        ["\xC6\xC8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xC8"],
        ["\xC6\xC8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xC8"],

        ["\xC6\xC9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xC9"],
        ["\xC6\xC9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xC9"],

        ["\xC6\xD1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xCA"],
        ["\xC6\xCA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xD1"],

        ["\xC6\xD2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xCB"],
        ["\xC6\xCB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xD2"],

        ["\xC6\xD3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xCC"],
        ["\xC6\xCC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xD3"],

        ["\xC6\xD4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xCD"],
        ["\xC6\xCD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xD4"],

        ["\xC6\xD5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xCE"],
        ["\xC6\xCE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xD5"],

        ["\xC6\xD6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xCF"],
        ["\xC6\xCF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xD6"],

        ["\xC6\xD7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xD0"],
        ["\xC6\xD0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xD7"],

        ["\xC6\xD8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xD1"],
        ["\xC6\xD1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xD8"],

        ["\xC6\xD9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xD2"],
        ["\xC6\xD2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xD9"],

        ["\xC6\xE2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xD3"],
        ["\xC6\xD3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xE2"],

        ["\xC6\xE3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xD4"],
        ["\xC6\xD4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xE3"],

        ["\xC6\xE4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xD5"],
        ["\xC6\xD5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xE4"],

        ["\xC6\xE5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xD6"],
        ["\xC6\xD6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xE5"],

        ["\xC6\xE6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xD7"],
        ["\xC6\xD7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xE6"],

        ["\xC6\xE7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xD8"],
        ["\xC6\xD8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xE7"],

        ["\xC6\xE8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xD9"],
        ["\xC6\xD9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xE8"],

        ["\xC6\xE9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xDA"],
        ["\xC6\xDA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xE9"],

        ["\xC6\x4A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xDB"],
        ["\xC6\xDB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\x4A"],

        ["\xC6\x5B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xDC"],
        ["\xC6\xDC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\x5B"],

        ["\xC6\x5A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xDD"],
        ["\xC6\xDD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\x5A"],

        ["\xC6\x5F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xDE"],
        ["\xC6\xDE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\x5F"],

        ["\xC6\x6D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xDF"],
        ["\xC6\xDF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\x6D"],

        ["\xC6\x79",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xE0"],
        ["\xC6\xE0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\x79"],

        ["\xC6\x57",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xE1"],
        ["\xC6\xE1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\x57"],

        ["\xC6\x59",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xE2"],
        ["\xC6\xE2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\x59"],

        ["\xC6\x62",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xE3"],
        ["\xC6\xE3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\x62"],

        ["\xC6\x63",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xE4"],
        ["\xC6\xE4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\x63"],

        ["\xC6\x64",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xE5"],
        ["\xC6\xE5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\x64"],

        ["\xC6\x65",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xE6"],
        ["\xC6\xE6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\x65"],

        ["\xC6\x66",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xE7"],
        ["\xC6\xE7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\x66"],

        ["\xC6\x67",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xE8"],
        ["\xC6\xE8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\x67"],

        ["\xC6\x68",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xE9"],
        ["\xC6\xE9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\x68"],

        ["\xC6\x69",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xEA"],
        ["\xC6\xEA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\x69"],

        ["\xC6\x70",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xEB"],
        ["\xC6\xEB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\x70"],

        ["\xC6\x71",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xEC"],
        ["\xC6\xEC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\x71"],

        ["\xC6\x72",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xED"],
        ["\xC6\xED",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\x72"],

        ["\xC6\x73",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xEE"],
        ["\xC6\xEE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\x73"],

        ["\xC6\x74",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xEF"],
        ["\xC6\xEF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\x74"],

        ["\xC6\x75",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xF0"],
        ["\xC6\xF0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\x75"],

        ["\xC6\x76",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xF1"],
        ["\xC6\xF1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\x76"],

        ["\xC6\x77",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xF2"],
        ["\xC6\xF2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\x77"],

        ["\xC6\x78",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xF3"],
        ["\xC6\xF3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\x78"],

        ["\xC6\x80",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xF4"],
        ["\xC6\xF4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\x80"],

        ["\xC6\x8B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xF5"],
        ["\xC6\xF5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\x8B"],

        ["\x72\x73",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xF6"],
        ["\xC6\xF6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\x73"],

        ["\xC6\x9C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xF7"],
        ["\xC6\xF7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\x9C"],

        ["\xC6\xA0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xF8"],
        ["\xC6\xF8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xA0"],

        ["\xC6\xAB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xF9"],
        ["\xC6\xF9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xAB"],

        ["\xC6\xB0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xFA"],
        ["\xC6\xFA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xB0"],

        ["\xC6\xC0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xFB"],
        ["\xC6\xFB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xC0"],

        ["\xC6\x6A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xFC"],
        ["\xC6\xFC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\x6A"],

        ["\xC6\xD0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xFD"],
        ["\xC6\xFD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xD0"],

        ["\xC6\xA1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC6\xFE"],
        ["\xC6\xFE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xA1"],

        ["\xC7\x4F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xA1"],
        ["\xC7\xA1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\x4F"],

        ["\xC7\x7F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xA2"],
        ["\xC7\xA2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\x7F"],

        ["\xC7\x7B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xA3"],
        ["\xC7\xA3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\x7B"],

        ["\xC7\xE0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xA4"],
        ["\xC7\xA4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xE0"],

        ["\xC7\x6C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xA5"],
        ["\xC7\xA5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\x6C"],

        ["\xC7\x50",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xA6"],
        ["\xC7\xA6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\x50"],

        ["\xC7\x7D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xA7"],
        ["\xC7\xA7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\x7D"],

        ["\xC7\x4D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xA8"],
        ["\xC7\xA8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\x4D"],

        ["\xC7\x5D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xA9"],
        ["\xC7\xA9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\x5D"],

        ["\xC7\x5C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xAA"],
        ["\xC7\xAA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\x5C"],

        ["\xC7\x4E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xAB"],
        ["\xC7\xAB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\x4E"],

        ["\xC7\x6B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xAC"],
        ["\xC7\xAC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\x6B"],

        ["\xC7\x60",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xAD"],
        ["\xC7\xAD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\x60"],

        ["\xC7\x4B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xAE"],
        ["\xC7\xAE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\x4B"],

        ["\xC7\x61",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xAF"],
        ["\xC7\xAF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\x61"],

        ["\xC7\xF0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xB0"],
        ["\xC7\xB0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xF0"],

        ["\xC7\xF1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xB1"],
        ["\xC7\xB1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xF1"],

        ["\xC7\xF2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xB2"],
        ["\xC7\xB2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xF2"],

        ["\xC7\xF3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xB3"],
        ["\xC7\xB3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xF3"],

        ["\xC7\xF4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xB4"],
        ["\xC7\xB4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xF4"],

        ["\xC7\xF5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xB5"],
        ["\xC7\xB5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xF5"],

        ["\xC7\xF6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xB6"],
        ["\xC7\xB6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xF6"],

        ["\xC7\xF7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xB7"],
        ["\xC7\xB7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xF7"],

        ["\xC7\xF8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xB8"],
        ["\xC7\xB8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xF8"],

        ["\xC7\xF9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xB9"],
        ["\xC7\xB9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xF9"],

        ["\xC7\x7A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xBA"],
        ["\xC7\xBA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\x7A"],

        ["\xC7\x5E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xBB"],
        ["\xC7\xBB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\x5E"],

        ["\xC7\x4C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xBC"],
        ["\xC7\xBC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\x4C"],

        ["\xC7\x7E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xBD"],
        ["\xC7\xBD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\x7E"],

        ["\xC7\x6E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xBE"],
        ["\xC7\xBE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\x6E"],

        ["\xC7\x6F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xBF"],
        ["\xC7\xBF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\x6F"],

        ["\xC7\x7C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xC0"],
        ["\xC7\xC0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\x7C"],

        ["\xC7\xC1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xC1"],
        ["\xC7\xC1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xC1"],

        ["\xC7\xC2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xC2"],
        ["\xC7\xC2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xC2"],

        ["\xC7\xC3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xC3"],
        ["\xC7\xC3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xC3"],

        ["\xC7\xC4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xC4"],
        ["\xC7\xC4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xC4"],

        ["\xC7\xC5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xC5"],
        ["\xC7\xC5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xC5"],

        ["\xC7\xC6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xC6"],
        ["\xC7\xC6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xC6"],

        ["\xC7\xC7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xC7"],
        ["\xC7\xC7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xC7"],

        ["\xC7\xC8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xC8"],
        ["\xC7\xC8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xC8"],

        ["\xC7\xC9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xC9"],
        ["\xC7\xC9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xC9"],

        ["\xC7\xD1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xCA"],
        ["\xC7\xCA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xD1"],

        ["\xC7\xD2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xCB"],
        ["\xC7\xCB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xD2"],

        ["\xC7\xD3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xCC"],
        ["\xC7\xCC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xD3"],

        ["\xC7\xD4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xCD"],
        ["\xC7\xCD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xD4"],

        ["\xC7\xD5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xCE"],
        ["\xC7\xCE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xD5"],

        ["\xC7\xD6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xCF"],
        ["\xC7\xCF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xD6"],

        ["\xC7\xD7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xD0"],
        ["\xC7\xD0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xD7"],

        ["\xC7\xD8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xD1"],
        ["\xC7\xD1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xD8"],

        ["\xC7\xD9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xD2"],
        ["\xC7\xD2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xD9"],

        ["\xC7\xE2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xD3"],
        ["\xC7\xD3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xE2"],

        ["\xC7\xE3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xD4"],
        ["\xC7\xD4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xE3"],

        ["\xC7\xE4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xD5"],
        ["\xC7\xD5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xE4"],

        ["\xC7\xE5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xD6"],
        ["\xC7\xD6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xE5"],

        ["\xC7\xE6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xD7"],
        ["\xC7\xD7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xE6"],

        ["\xC7\xE7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xD8"],
        ["\xC7\xD8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xE7"],

        ["\xC7\xE8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xD9"],
        ["\xC7\xD9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xE8"],

        ["\xC7\xE9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xDA"],
        ["\xC7\xDA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xE9"],

        ["\xC7\x4A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xDB"],
        ["\xC7\xDB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\x4A"],

        ["\xC7\x5B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xDC"],
        ["\xC7\xDC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\x5B"],

        ["\xC7\x5A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xDD"],
        ["\xC7\xDD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\x5A"],

        ["\xC7\x5F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xDE"],
        ["\xC7\xDE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\x5F"],

        ["\xC7\x6D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xDF"],
        ["\xC7\xDF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\x6D"],

        ["\xC7\x79",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xE0"],
        ["\xC7\xE0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\x79"],

        ["\xC7\x57",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xE1"],
        ["\xC7\xE1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\x57"],

        ["\xC7\x59",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xE2"],
        ["\xC7\xE2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\x59"],

        ["\xC7\x62",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xE3"],
        ["\xC7\xE3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\x62"],

        ["\xC7\x63",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xE4"],
        ["\xC7\xE4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\x63"],

        ["\xC7\x64",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xE5"],
        ["\xC7\xE5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\x64"],

        ["\xC7\x65",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xE6"],
        ["\xC7\xE6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\x65"],

        ["\xC7\x66",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xE7"],
        ["\xC7\xE7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\x66"],

        ["\x69\xE0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xE8"],
        ["\xC7\xE8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\xE0"],

        ["\xC7\x68",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xE9"],
        ["\xC7\xE9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\x68"],

        ["\xC7\x69",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xEA"],
        ["\xC7\xEA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\x69"],

        ["\xC7\x70",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xEB"],
        ["\xC7\xEB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\x70"],

        ["\xC7\x71",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xEC"],
        ["\xC7\xEC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\x71"],

        ["\xC7\x72",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xED"],
        ["\xC7\xED",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\x72"],

        ["\xC7\x73",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xEE"],
        ["\xC7\xEE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\x73"],

        ["\xC7\x74",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xEF"],
        ["\xC7\xEF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\x74"],

        ["\xC7\x75",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xF0"],
        ["\xC7\xF0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\x75"],

        ["\xC7\x76",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xF1"],
        ["\xC7\xF1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\x76"],

        ["\xC7\x77",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xF2"],
        ["\xC7\xF2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\x77"],

        ["\xC7\x78",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xF3"],
        ["\xC7\xF3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\x78"],

        ["\xC7\x80",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xF4"],
        ["\xC7\xF4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\x80"],

        ["\xC7\x8B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xF5"],
        ["\xC7\xF5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\x8B"],

        ["\xC7\x9B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xF6"],
        ["\xC7\xF6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\x9B"],

        ["\xC7\x9C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xF7"],
        ["\xC7\xF7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\x9C"],

        ["\xC7\xA0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xF8"],
        ["\xC7\xF8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xA0"],

        ["\xC7\xAB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xF9"],
        ["\xC7\xF9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xAB"],

        ["\xC7\xB0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xFA"],
        ["\xC7\xFA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xB0"],

        ["\xC7\xC0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xFB"],
        ["\xC7\xFB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xC0"],

        ["\xC7\x6A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xFC"],
        ["\xC7\xFC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\x6A"],

        ["\xC7\xD0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xFD"],
        ["\xC7\xFD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xD0"],

        ["\xC7\xA1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC7\xFE"],
        ["\xC7\xFE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xA1"],

        ["\xC8\x4F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xA1"],
        ["\xC8\xA1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\x4F"],

        ["\xC8\x7F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xA2"],
        ["\xC8\xA2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\x7F"],

        ["\xC8\x7B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xA3"],
        ["\xC8\xA3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\x7B"],

        ["\xC8\xE0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xA4"],
        ["\xC8\xA4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xE0"],

        ["\xC8\x6C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xA5"],
        ["\xC8\xA5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\x6C"],

        ["\xC8\x50",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xA6"],
        ["\xC8\xA6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\x50"],

        ["\xC8\x7D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xA7"],
        ["\xC8\xA7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\x7D"],

        ["\xC8\x4D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xA8"],
        ["\xC8\xA8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\x4D"],

        ["\xC8\x5D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xA9"],
        ["\xC8\xA9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\x5D"],

        ["\xC8\x5C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xAA"],
        ["\xC8\xAA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\x5C"],

        ["\xC8\x4E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xAB"],
        ["\xC8\xAB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\x4E"],

        ["\xC8\x6B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xAC"],
        ["\xC8\xAC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\x6B"],

        ["\xC8\x60",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xAD"],
        ["\xC8\xAD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\x60"],

        ["\xC8\x4B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xAE"],
        ["\xC8\xAE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\x4B"],

        ["\xC8\x61",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xAF"],
        ["\xC8\xAF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\x61"],

        ["\xC8\xF0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xB0"],
        ["\xC8\xB0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xF0"],

        ["\xC8\xF1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xB1"],
        ["\xC8\xB1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xF1"],

        ["\xC8\xF2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xB2"],
        ["\xC8\xB2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xF2"],

        ["\xC8\xF3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xB3"],
        ["\xC8\xB3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xF3"],

        ["\xC8\xF4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xB4"],
        ["\xC8\xB4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xF4"],

        ["\xC8\xF5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xB5"],
        ["\xC8\xB5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xF5"],

        ["\xC8\xF6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xB6"],
        ["\xC8\xB6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xF6"],

        ["\xC8\xF7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xB7"],
        ["\xC8\xB7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xF7"],

        ["\xC8\xF8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xB8"],
        ["\xC8\xB8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xF8"],

        ["\xC8\xF9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xB9"],
        ["\xC8\xB9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xF9"],

        ["\xC8\x7A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xBA"],
        ["\xC8\xBA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\x7A"],

        ["\xC8\x5E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xBB"],
        ["\xC8\xBB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\x5E"],

        ["\xC8\x4C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xBC"],
        ["\xC8\xBC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\x4C"],

        ["\xC8\x7E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xBD"],
        ["\xC8\xBD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\x7E"],

        ["\xC8\x6E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xBE"],
        ["\xC8\xBE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\x6E"],

        ["\xC8\x6F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xBF"],
        ["\xC8\xBF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\x6F"],

        ["\xC8\x7C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xC0"],
        ["\xC8\xC0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\x7C"],

        ["\xC8\xC1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xC1"],
        ["\xC8\xC1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xC1"],

        ["\xC8\xC2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xC2"],
        ["\xC8\xC2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xC2"],

        ["\xC8\xC3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xC3"],
        ["\xC8\xC3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xC3"],

        ["\xC8\xC4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xC4"],
        ["\xC8\xC4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xC4"],

        ["\xC8\xC5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xC5"],
        ["\xC8\xC5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xC5"],

        ["\xC8\xC6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xC6"],
        ["\xC8\xC6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xC6"],

        ["\xC8\xC7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xC7"],
        ["\xC8\xC7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xC7"],

        ["\xC8\xC8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xC8"],
        ["\xC8\xC8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xC8"],

        ["\xC8\xC9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xC9"],
        ["\xC8\xC9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xC9"],

        ["\xC8\xD1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xCA"],
        ["\xC8\xCA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xD1"],

        ["\xC8\xD2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xCB"],
        ["\xC8\xCB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xD2"],

        ["\xC8\xD3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xCC"],
        ["\xC8\xCC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xD3"],

        ["\xC8\xD4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xCD"],
        ["\xC8\xCD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xD4"],

        ["\xC8\xD5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xCE"],
        ["\xC8\xCE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xD5"],

        ["\xC8\xD6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xCF"],
        ["\xC8\xCF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xD6"],

        ["\xC8\xD7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xD0"],
        ["\xC8\xD0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xD7"],

        ["\xC8\xD8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xD1"],
        ["\xC8\xD1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xD8"],

        ["\xC8\xD9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xD2"],
        ["\xC8\xD2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xD9"],

        ["\xC8\xE2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xD3"],
        ["\xC8\xD3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xE2"],

        ["\xC8\xE3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xD4"],
        ["\xC8\xD4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xE3"],

        ["\xC8\xE4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xD5"],
        ["\xC8\xD5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xE4"],

        ["\xC8\xE5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xD6"],
        ["\xC8\xD6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xE5"],

        ["\xC8\xE6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xD7"],
        ["\xC8\xD7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xE6"],

        ["\xC8\xE7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xD8"],
        ["\xC8\xD8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xE7"],

        ["\xC8\xE8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xD9"],
        ["\xC8\xD9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xE8"],

        ["\xC8\xE9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xDA"],
        ["\xC8\xDA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xE9"],

        ["\xC8\x4A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xDB"],
        ["\xC8\xDB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\x4A"],

        ["\xC8\x5B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xDC"],
        ["\xC8\xDC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\x5B"],

        ["\xC8\x5A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xDD"],
        ["\xC8\xDD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\x5A"],

        ["\xC8\x5F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xDE"],
        ["\xC8\xDE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\x5F"],

        ["\xC8\x6D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xDF"],
        ["\xC8\xDF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\x6D"],

        ["\xC8\x79",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xE0"],
        ["\xC8\xE0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\x79"],

        ["\xC8\x57",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xE1"],
        ["\xC8\xE1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\x57"],

        ["\xC8\x59",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xE2"],
        ["\xC8\xE2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\x59"],

        ["\xC8\x62",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xE3"],
        ["\xC8\xE3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\x62"],

        ["\xC8\x63",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xE4"],
        ["\xC8\xE4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\x63"],

        ["\xC8\x64",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xE5"],
        ["\xC8\xE5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\x64"],

        ["\xC8\x65",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xE6"],
        ["\xC8\xE6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\x65"],

        ["\xC8\x66",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xE7"],
        ["\xC8\xE7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\x66"],

        ["\xC8\x67",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xE8"],
        ["\xC8\xE8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\x67"],

        ["\xC8\x68",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xE9"],
        ["\xC8\xE9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\x68"],

        ["\xC8\x69",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xEA"],
        ["\xC8\xEA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\x69"],

        ["\xC8\x70",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xEB"],
        ["\xC8\xEB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\x70"],

        ["\xC8\x71",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xEC"],
        ["\xC8\xEC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\x71"],

        ["\xC8\x72",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xED"],
        ["\xC8\xED",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\x72"],

        ["\xC8\x73",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xEE"],
        ["\xC8\xEE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\x73"],

        ["\xC8\x74",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xEF"],
        ["\xC8\xEF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\x74"],

        ["\xC8\x75",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xF0"],
        ["\xC8\xF0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\x75"],

        ["\xC8\x76",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xF1"],
        ["\xC8\xF1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\x76"],

        ["\xC8\x77",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xF2"],
        ["\xC8\xF2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\x77"],

        ["\xC8\x78",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xF3"],
        ["\xC8\xF3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\x78"],

        ["\xC8\x80",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xF4"],
        ["\xC8\xF4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\x80"],

        ["\xC8\x8B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xF5"],
        ["\xC8\xF5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\x8B"],

        ["\xC8\x9B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xF6"],
        ["\xC8\xF6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\x9B"],

        ["\xC8\x9C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xF7"],
        ["\xC8\xF7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\x9C"],

        ["\xC8\xA0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xF8"],
        ["\xC8\xF8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xA0"],

        ["\xC8\xAB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xF9"],
        ["\xC8\xF9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xAB"],

        ["\xC8\xB0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xFA"],
        ["\xC8\xFA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xB0"],

        ["\xC8\xC0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xFB"],
        ["\xC8\xFB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xC0"],

        ["\xC8\x6A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xFC"],
        ["\xC8\xFC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\x6A"],

        ["\xC8\xD0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xFD"],
        ["\xC8\xFD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xD0"],

        ["\xC8\xA1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC8\xFE"],
        ["\xC8\xFE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xA1"],

        ["\xC9\x4F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xA1"],
        ["\xC9\xA1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\x4F"],

        ["\xC9\x7F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xA2"],
        ["\xC9\xA2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\x7F"],

        ["\xC9\x7B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xA3"],
        ["\xC9\xA3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\x7B"],

        ["\xC9\xE0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xA4"],
        ["\xC9\xA4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xE0"],

        ["\xC9\x6C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xA5"],
        ["\xC9\xA5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\x6C"],

        ["\xC9\x50",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xA6"],
        ["\xC9\xA6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\x50"],

        ["\xC9\x7D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xA7"],
        ["\xC9\xA7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\x7D"],

        ["\xC9\x4D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xA8"],
        ["\xC9\xA8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\x4D"],

        ["\xC9\x5D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xA9"],
        ["\xC9\xA9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\x5D"],

        ["\xC9\x5C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xAA"],
        ["\xC9\xAA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\x5C"],

        ["\xC9\x4E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xAB"],
        ["\xC9\xAB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\x4E"],

        ["\xC9\x6B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xAC"],
        ["\xC9\xAC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\x6B"],

        ["\xC9\x60",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xAD"],
        ["\xC9\xAD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\x60"],

        ["\xC9\x4B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xAE"],
        ["\xC9\xAE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\x4B"],

        ["\xC9\x61",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xAF"],
        ["\xC9\xAF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\x61"],

        ["\x4A\xE7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xB0"],
        ["\xC9\xB0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\xE7"],

        ["\xC9\xF1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xB1"],
        ["\xC9\xB1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xF1"],

        ["\xC9\xF2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xB2"],
        ["\xC9\xB2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xF2"],

        ["\xC9\xF3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xB3"],
        ["\xC9\xB3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xF3"],

        ["\xC9\xF4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xB4"],
        ["\xC9\xB4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xF4"],

        ["\xC9\xF5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xB5"],
        ["\xC9\xB5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xF5"],

        ["\xC9\xF6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xB6"],
        ["\xC9\xB6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xF6"],

        ["\xC9\xF7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xB7"],
        ["\xC9\xB7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xF7"],

        ["\xC9\xF8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xB8"],
        ["\xC9\xB8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xF8"],

        ["\xC9\xF9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xB9"],
        ["\xC9\xB9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xF9"],

        ["\xC9\x7A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xBA"],
        ["\xC9\xBA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\x7A"],

        ["\xC9\x5E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xBB"],
        ["\xC9\xBB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\x5E"],

        ["\xC9\x4C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xBC"],
        ["\xC9\xBC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\x4C"],

        ["\xC9\x7E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xBD"],
        ["\xC9\xBD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\x7E"],

        ["\xC9\x6E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xBE"],
        ["\xC9\xBE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\x6E"],

        ["\xC9\x6F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xBF"],
        ["\xC9\xBF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\x6F"],

        ["\xC9\x7C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xC0"],
        ["\xC9\xC0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\x7C"],

        ["\xC9\xC1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xC1"],
        ["\xC9\xC1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xC1"],

        ["\xC9\xC2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xC2"],
        ["\xC9\xC2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xC2"],

        ["\xC9\xC3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xC3"],
        ["\xC9\xC3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xC3"],

        ["\xC9\xC4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xC4"],
        ["\xC9\xC4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xC4"],

        ["\xC9\xC5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xC5"],
        ["\xC9\xC5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xC5"],

        ["\xC9\xC6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xC6"],
        ["\xC9\xC6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xC6"],

        ["\xC9\xC7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xC7"],
        ["\xC9\xC7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xC7"],

        ["\xC9\xC8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xC8"],
        ["\xC9\xC8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xC8"],

        ["\xC9\xC9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xC9"],
        ["\xC9\xC9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xC9"],

        ["\xC9\xD1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xCA"],
        ["\xC9\xCA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xD1"],

        ["\xC9\xD2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xCB"],
        ["\xC9\xCB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xD2"],

        ["\xC9\xD3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xCC"],
        ["\xC9\xCC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xD3"],

        ["\xC9\xD4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xCD"],
        ["\xC9\xCD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xD4"],

        ["\xC9\xD5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xCE"],
        ["\xC9\xCE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xD5"],

        ["\xC9\xD6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xCF"],
        ["\xC9\xCF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xD6"],

        ["\xC9\xD7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xD0"],
        ["\xC9\xD0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xD7"],

        ["\xC9\xD8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xD1"],
        ["\xC9\xD1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xD8"],

        ["\xC9\xD9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xD2"],
        ["\xC9\xD2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xD9"],

        ["\xC9\xE2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xD3"],
        ["\xC9\xD3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xE2"],

        ["\xC9\xE3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xD4"],
        ["\xC9\xD4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xE3"],

        ["\xC9\xE4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xD5"],
        ["\xC9\xD5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xE4"],

        ["\xC9\xE5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xD6"],
        ["\xC9\xD6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xE5"],

        ["\xC9\xE6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xD7"],
        ["\xC9\xD7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xE6"],

        ["\xC9\xE7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xD8"],
        ["\xC9\xD8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xE7"],

        ["\xC9\xE8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xD9"],
        ["\xC9\xD9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xE8"],

        ["\xC9\xE9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xDA"],
        ["\xC9\xDA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xE9"],

        ["\xC9\x4A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xDB"],
        ["\xC9\xDB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\x4A"],

        ["\xC9\x5B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xDC"],
        ["\xC9\xDC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\x5B"],

        ["\xC9\x5A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xDD"],
        ["\xC9\xDD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\x5A"],

        ["\xC9\x5F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xDE"],
        ["\xC9\xDE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\x5F"],

        ["\xC9\x6D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xDF"],
        ["\xC9\xDF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\x6D"],

        ["\xC9\x79",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xE0"],
        ["\xC9\xE0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\x79"],

        ["\xC9\x57",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xE1"],
        ["\xC9\xE1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\x57"],

        ["\xC9\x59",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xE2"],
        ["\xC9\xE2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\x59"],

        ["\xC9\x62",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xE3"],
        ["\xC9\xE3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\x62"],

        ["\xC9\x63",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xE4"],
        ["\xC9\xE4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\x63"],

        ["\xC9\x64",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xE5"],
        ["\xC9\xE5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\x64"],

        ["\xC9\x65",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xE6"],
        ["\xC9\xE6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\x65"],

        ["\xC9\x66",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xE7"],
        ["\xC9\xE7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\x66"],

        ["\xC9\x67",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xE8"],
        ["\xC9\xE8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\x67"],

        ["\xC9\x68",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xE9"],
        ["\xC9\xE9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\x68"],

        ["\xC9\x69",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xEA"],
        ["\xC9\xEA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\x69"],

        ["\xC9\x70",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xEB"],
        ["\xC9\xEB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\x70"],

        ["\xC9\x71",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xEC"],
        ["\xC9\xEC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\x71"],

        ["\xC9\x72",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xED"],
        ["\xC9\xED",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\x72"],

        ["\xC9\x73",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xEE"],
        ["\xC9\xEE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\x73"],

        ["\xC9\x74",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xEF"],
        ["\xC9\xEF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\x74"],

        ["\xC9\x75",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xF0"],
        ["\xC9\xF0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\x75"],

        ["\xC9\x76",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xF1"],
        ["\xC9\xF1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\x76"],

        ["\xC9\x77",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xF2"],
        ["\xC9\xF2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\x77"],

        ["\xC9\x78",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xF3"],
        ["\xC9\xF3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\x78"],

        ["\xC9\x80",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xF4"],
        ["\xC9\xF4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\x80"],

        ["\xC9\x8B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xF5"],
        ["\xC9\xF5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\x8B"],

        ["\xC9\x9B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xF6"],
        ["\xC9\xF6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\x9B"],

        ["\xC9\x9C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xF7"],
        ["\xC9\xF7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\x9C"],

        ["\xC9\xA0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xF8"],
        ["\xC9\xF8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xA0"],

        ["\xC9\xAB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xF9"],
        ["\xC9\xF9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xAB"],

        ["\xC9\xB0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xFA"],
        ["\xC9\xFA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xB0"],

        ["\xC9\xC0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xFB"],
        ["\xC9\xFB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xC0"],

        ["\xC9\x6A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xFC"],
        ["\xC9\xFC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\x6A"],

        ["\xC9\xD0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xFD"],
        ["\xC9\xFD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xD0"],

        ["\xC9\xA1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC9\xFE"],
        ["\xC9\xFE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xA1"],

        ["\xD1\x4F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xA1"],
        ["\xCA\xA1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\x4F"],

        ["\xD1\x7F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xA2"],
        ["\xCA\xA2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\x7F"],

        ["\xD1\x7B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xA3"],
        ["\xCA\xA3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\x7B"],

        ["\xD1\xE0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xA4"],
        ["\xCA\xA4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xE0"],

        ["\xD1\x6C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xA5"],
        ["\xCA\xA5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\x6C"],

        ["\xD1\x50",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xA6"],
        ["\xCA\xA6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\x50"],

        ["\xD1\x7D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xA7"],
        ["\xCA\xA7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\x7D"],

        ["\xD1\x4D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xA8"],
        ["\xCA\xA8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\x4D"],

        ["\xD1\x5D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xA9"],
        ["\xCA\xA9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\x5D"],

        ["\xD1\x5C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xAA"],
        ["\xCA\xAA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\x5C"],

        ["\xD1\x4E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xAB"],
        ["\xCA\xAB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\x4E"],

        ["\xD1\x6B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xAC"],
        ["\xCA\xAC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\x6B"],

        ["\xD1\x60",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xAD"],
        ["\xCA\xAD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\x60"],

        ["\xD1\x4B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xAE"],
        ["\xCA\xAE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\x4B"],

        ["\xD1\x61",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xAF"],
        ["\xCA\xAF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\x61"],

        ["\xD1\xF0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xB0"],
        ["\xCA\xB0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xF0"],

        ["\xD1\xF1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xB1"],
        ["\xCA\xB1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xF1"],

        ["\xD1\xF2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xB2"],
        ["\xCA\xB2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xF2"],

        ["\xD1\xF3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xB3"],
        ["\xCA\xB3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xF3"],

        ["\xD1\xF4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xB4"],
        ["\xCA\xB4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xF4"],

        ["\xD1\xF5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xB5"],
        ["\xCA\xB5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xF5"],

        ["\xD1\xF6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xB6"],
        ["\xCA\xB6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xF6"],

        ["\xD1\xF7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xB7"],
        ["\xCA\xB7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xF7"],

        ["\xD1\xF8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xB8"],
        ["\xCA\xB8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xF8"],

        ["\xD1\xF9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xB9"],
        ["\xCA\xB9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xF9"],

        ["\xD1\x7A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xBA"],
        ["\xCA\xBA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\x7A"],

        ["\xD1\x5E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xBB"],
        ["\xCA\xBB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\x5E"],

        ["\xD1\x4C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xBC"],
        ["\xCA\xBC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\x4C"],

        ["\xD1\x7E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xBD"],
        ["\xCA\xBD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\x7E"],

        ["\xD1\x6E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xBE"],
        ["\xCA\xBE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\x6E"],

        ["\xD1\x6F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xBF"],
        ["\xCA\xBF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\x6F"],

        ["\xD1\x7C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xC0"],
        ["\xCA\xC0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\x7C"],

        ["\xD1\xC1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xC1"],
        ["\xCA\xC1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xC1"],

        ["\xD1\xC2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xC2"],
        ["\xCA\xC2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xC2"],

        ["\xD1\xC3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xC3"],
        ["\xCA\xC3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xC3"],

        ["\xD1\xC4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xC4"],
        ["\xCA\xC4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xC4"],

        ["\xD1\xC5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xC5"],
        ["\xCA\xC5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xC5"],

        ["\xD1\xC6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xC6"],
        ["\xCA\xC6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xC6"],

        ["\xD1\xC7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xC7"],
        ["\xCA\xC7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xC7"],

        ["\xD1\xC8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xC8"],
        ["\xCA\xC8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xC8"],

        ["\xD1\xC9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xC9"],
        ["\xCA\xC9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xC9"],

        ["\xD1\xD1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xCA"],
        ["\xCA\xCA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xD1"],

        ["\xD1\xD2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xCB"],
        ["\xCA\xCB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xD2"],

        ["\xD1\xD3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xCC"],
        ["\xCA\xCC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xD3"],

        ["\xD1\xD4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xCD"],
        ["\xCA\xCD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xD4"],

        ["\xD1\xD5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xCE"],
        ["\xCA\xCE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xD5"],

        ["\xD1\xD6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xCF"],
        ["\xCA\xCF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xD6"],

        ["\xD1\xD7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xD0"],
        ["\xCA\xD0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xD7"],

        ["\xD1\xD8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xD1"],
        ["\xCA\xD1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xD8"],

        ["\xD1\xD9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xD2"],
        ["\xCA\xD2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xD9"],

        ["\xD1\xE2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xD3"],
        ["\xCA\xD3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xE2"],

        ["\xD1\xE3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xD4"],
        ["\xCA\xD4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xE3"],

        ["\xD1\xE4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xD5"],
        ["\xCA\xD5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xE4"],

        ["\xD1\xE5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xD6"],
        ["\xCA\xD6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xE5"],

        ["\xD1\xE6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xD7"],
        ["\xCA\xD7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xE6"],

        ["\xD1\xE7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xD8"],
        ["\xCA\xD8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xE7"],

        ["\xD1\xE8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xD9"],
        ["\xCA\xD9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xE8"],

        ["\xD1\xE9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xDA"],
        ["\xCA\xDA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xE9"],

        ["\xD1\x4A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xDB"],
        ["\xCA\xDB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\x4A"],

        ["\xD1\x5B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xDC"],
        ["\xCA\xDC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\x5B"],

        ["\xD1\x5A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xDD"],
        ["\xCA\xDD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\x5A"],

        ["\xD1\x5F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xDE"],
        ["\xCA\xDE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\x5F"],

        ["\xD1\x6D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xDF"],
        ["\xCA\xDF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\x6D"],

        ["\xD1\x79",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xE0"],
        ["\xCA\xE0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\x79"],

        ["\xD1\x57",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xE1"],
        ["\xCA\xE1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\x57"],

        ["\xD1\x59",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xE2"],
        ["\xCA\xE2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\x59"],

        ["\xD1\x62",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xE3"],
        ["\xCA\xE3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\x62"],

        ["\xD1\x63",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xE4"],
        ["\xCA\xE4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\x63"],

        ["\xD1\x64",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xE5"],
        ["\xCA\xE5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\x64"],

        ["\xD1\x65",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xE6"],
        ["\xCA\xE6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\x65"],

        ["\xD1\x66",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xE7"],
        ["\xCA\xE7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\x66"],

        ["\xD1\x67",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xE8"],
        ["\xCA\xE8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\x67"],

        ["\xD1\x68",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xE9"],
        ["\xCA\xE9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\x68"],

        ["\xD1\x69",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xEA"],
        ["\xCA\xEA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\x69"],

        ["\xD1\x70",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xEB"],
        ["\xCA\xEB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\x70"],

        ["\xD1\x71",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xEC"],
        ["\xCA\xEC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\x71"],

        ["\xD1\x72",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xED"],
        ["\xCA\xED",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\x72"],

        ["\xD1\x73",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xEE"],
        ["\xCA\xEE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\x73"],

        ["\xD1\x74",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xEF"],
        ["\xCA\xEF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\x74"],

        ["\xD1\x75",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xF0"],
        ["\xCA\xF0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\x75"],

        ["\xD1\x76",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xF1"],
        ["\xCA\xF1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\x76"],

        ["\xD1\x77",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xF2"],
        ["\xCA\xF2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\x77"],

        ["\xD1\x78",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xF3"],
        ["\xCA\xF3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\x78"],

        ["\xD1\x80",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xF4"],
        ["\xCA\xF4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\x80"],

        ["\xD1\x8B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xF5"],
        ["\xCA\xF5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\x8B"],

        ["\xD1\x9B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xF6"],
        ["\xCA\xF6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\x9B"],

        ["\xD1\x9C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xF7"],
        ["\xCA\xF7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\x9C"],

        ["\xD1\xA0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xF8"],
        ["\xCA\xF8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xA0"],

        ["\xD1\xAB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xF9"],
        ["\xCA\xF9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xAB"],

        ["\xD1\xB0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xFA"],
        ["\xCA\xFA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xB0"],

        ["\xD1\xC0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xFB"],
        ["\xCA\xFB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xC0"],

        ["\xD1\x6A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xFC"],
        ["\xCA\xFC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\x6A"],

        ["\xD1\xD0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xFD"],
        ["\xCA\xFD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xD0"],

        ["\xD1\xA1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCA\xFE"],
        ["\xCA\xFE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xA1"],

        ["\xD2\x4F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xA1"],
        ["\xCB\xA1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\x4F"],

        ["\xD2\x7F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xA2"],
        ["\xCB\xA2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\x7F"],

        ["\xD2\x7B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xA3"],
        ["\xCB\xA3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\x7B"],

        ["\xD2\xE0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xA4"],
        ["\xCB\xA4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xE0"],

        ["\xD2\x6C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xA5"],
        ["\xCB\xA5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\x6C"],

        ["\xD2\x50",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xA6"],
        ["\xCB\xA6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\x50"],

        ["\xD2\x7D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xA7"],
        ["\xCB\xA7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\x7D"],

        ["\xD2\x4D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xA8"],
        ["\xCB\xA8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\x4D"],

        ["\xD2\x5D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xA9"],
        ["\xCB\xA9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\x5D"],

        ["\xD2\x5C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xAA"],
        ["\xCB\xAA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\x5C"],

        ["\xD2\x4E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xAB"],
        ["\xCB\xAB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\x4E"],

        ["\xD2\x6B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xAC"],
        ["\xCB\xAC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\x6B"],

        ["\xD2\x60",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xAD"],
        ["\xCB\xAD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\x60"],

        ["\xD2\x4B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xAE"],
        ["\xCB\xAE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\x4B"],

        ["\xD2\x61",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xAF"],
        ["\xCB\xAF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\x61"],

        ["\xD2\xF0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xB0"],
        ["\xCB\xB0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xF0"],

        ["\xD2\xF1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xB1"],
        ["\xCB\xB1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xF1"],

        ["\xD2\xF2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xB2"],
        ["\xCB\xB2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xF2"],

        ["\xD2\xF3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xB3"],
        ["\xCB\xB3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xF3"],

        ["\xD2\xF4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xB4"],
        ["\xCB\xB4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xF4"],

        ["\xD2\xF5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xB5"],
        ["\xCB\xB5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xF5"],

        ["\xD2\xF6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xB6"],
        ["\xCB\xB6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xF6"],

        ["\xD2\xF7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xB7"],
        ["\xCB\xB7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xF7"],

        ["\xD2\xF8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xB8"],
        ["\xCB\xB8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xF8"],

        ["\xD2\xF9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xB9"],
        ["\xCB\xB9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xF9"],

        ["\xD2\x7A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xBA"],
        ["\xCB\xBA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\x7A"],

        ["\xD2\x5E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xBB"],
        ["\xCB\xBB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\x5E"],

        ["\xD2\x4C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xBC"],
        ["\xCB\xBC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\x4C"],

        ["\xD2\x7E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xBD"],
        ["\xCB\xBD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\x7E"],

        ["\xD2\x6E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xBE"],
        ["\xCB\xBE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\x6E"],

        ["\xD2\x6F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xBF"],
        ["\xCB\xBF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\x6F"],

        ["\xD2\x7C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xC0"],
        ["\xCB\xC0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\x7C"],

        ["\xD2\xC1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xC1"],
        ["\xCB\xC1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xC1"],

        ["\xD2\xC2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xC2"],
        ["\xCB\xC2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xC2"],

        ["\xD2\xC3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xC3"],
        ["\xCB\xC3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xC3"],

        ["\xD2\xC4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xC4"],
        ["\xCB\xC4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xC4"],

        ["\xD2\xC5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xC5"],
        ["\xCB\xC5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xC5"],

        ["\xD2\xC6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xC6"],
        ["\xCB\xC6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xC6"],

        ["\xD2\xC7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xC7"],
        ["\xCB\xC7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xC7"],

        ["\xD2\xC8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xC8"],
        ["\xCB\xC8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xC8"],

        ["\xD2\xC9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xC9"],
        ["\xCB\xC9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xC9"],

        ["\xD2\xD1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xCA"],
        ["\xCB\xCA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xD1"],

        ["\xD2\xD2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xCB"],
        ["\xCB\xCB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xD2"],

        ["\xD2\xD3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xCC"],
        ["\xCB\xCC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xD3"],

        ["\xD2\xD4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xCD"],
        ["\xCB\xCD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xD4"],

        ["\xD2\xD5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xCE"],
        ["\xCB\xCE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xD5"],

        ["\xD2\xD6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xCF"],
        ["\xCB\xCF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xD6"],

        ["\xD2\xD7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xD0"],
        ["\xCB\xD0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xD7"],

        ["\xD2\xD8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xD1"],
        ["\xCB\xD1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xD8"],

        ["\xD2\xD9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xD2"],
        ["\xCB\xD2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xD9"],

        ["\xD2\xE2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xD3"],
        ["\xCB\xD3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xE2"],

        ["\xD2\xE3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xD4"],
        ["\xCB\xD4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xE3"],

        ["\xD2\xE4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xD5"],
        ["\xCB\xD5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xE4"],

        ["\xD2\xE5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xD6"],
        ["\xCB\xD6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xE5"],

        ["\xD2\xE6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xD7"],
        ["\xCB\xD7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xE6"],

        ["\xD2\xE7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xD8"],
        ["\xCB\xD8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xE7"],

        ["\xD2\xE8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xD9"],
        ["\xCB\xD9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xE8"],

        ["\xD2\xE9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xDA"],
        ["\xCB\xDA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xE9"],

        ["\xD2\x4A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xDB"],
        ["\xCB\xDB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\x4A"],

        ["\xD2\x5B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xDC"],
        ["\xCB\xDC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\x5B"],

        ["\xD2\x5A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xDD"],
        ["\xCB\xDD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\x5A"],

        ["\xD2\x5F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xDE"],
        ["\xCB\xDE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\x5F"],

        ["\xD2\x6D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xDF"],
        ["\xCB\xDF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\x6D"],

        ["\xD2\x79",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xE0"],
        ["\xCB\xE0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\x79"],

        ["\xD2\x57",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xE1"],
        ["\xCB\xE1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\x57"],

        ["\xD2\x59",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xE2"],
        ["\xCB\xE2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\x59"],

        ["\xD2\x62",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xE3"],
        ["\xCB\xE3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\x62"],

        ["\xD2\x63",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xE4"],
        ["\xCB\xE4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\x63"],

        ["\xD2\x64",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xE5"],
        ["\xCB\xE5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\x64"],

        ["\xD2\x65",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xE6"],
        ["\xCB\xE6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\x65"],

        ["\xD2\x66",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xE7"],
        ["\xCB\xE7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\x66"],

        ["\xD2\x67",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xE8"],
        ["\xCB\xE8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\x67"],

        ["\xD2\x68",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xE9"],
        ["\xCB\xE9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\x68"],

        ["\x90\xA3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xEA"],
        ["\xCB\xEA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x90\xA3"],

        ["\xD2\x70",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xEB"],
        ["\xCB\xEB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\x70"],

        ["\xD2\x71",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xEC"],
        ["\xCB\xEC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\x71"],

        ["\xD2\x72",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xED"],
        ["\xCB\xED",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\x72"],

        ["\xD2\x73",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xEE"],
        ["\xCB\xEE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\x73"],

        ["\xD2\x74",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xEF"],
        ["\xCB\xEF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\x74"],

        ["\xD2\x75",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xF0"],
        ["\xCB\xF0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\x75"],

        ["\xD2\x76",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xF1"],
        ["\xCB\xF1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\x76"],

        ["\xD2\x77",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xF2"],
        ["\xCB\xF2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\x77"],

        ["\xD2\x78",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xF3"],
        ["\xCB\xF3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\x78"],

        ["\xD2\x80",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xF4"],
        ["\xCB\xF4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\x80"],

        ["\xD2\x8B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xF5"],
        ["\xCB\xF5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\x8B"],

        ["\xD2\x9B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xF6"],
        ["\xCB\xF6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\x9B"],

        ["\xD2\x9C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xF7"],
        ["\xCB\xF7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\x9C"],

        ["\xD2\xA0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xF8"],
        ["\xCB\xF8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xA0"],

        ["\xD7\xE5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xF9"],
        ["\xCB\xF9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xE5"],

        ["\xD2\xB0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xFA"],
        ["\xCB\xFA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xB0"],

        ["\xD2\xC0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xFB"],
        ["\xCB\xFB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xC0"],

        ["\xD2\x6A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xFC"],
        ["\xCB\xFC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\x6A"],

        ["\xD2\xD0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xFD"],
        ["\xCB\xFD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xD0"],

        ["\xD2\xA1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCB\xFE"],
        ["\xCB\xFE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xA1"],

        ["\xD3\x4F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xA1"],
        ["\xCC\xA1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\x4F"],

        ["\xD3\x7F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xA2"],
        ["\xCC\xA2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\x7F"],

        ["\xD3\x7B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xA3"],
        ["\xCC\xA3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\x7B"],

        ["\xD3\xE0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xA4"],
        ["\xCC\xA4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xE0"],

        ["\xD3\x6C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xA5"],
        ["\xCC\xA5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\x6C"],

        ["\xD3\x50",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xA6"],
        ["\xCC\xA6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\x50"],

        ["\xD3\x7D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xA7"],
        ["\xCC\xA7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\x7D"],

        ["\xD3\x4D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xA8"],
        ["\xCC\xA8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\x4D"],

        ["\xD3\x5D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xA9"],
        ["\xCC\xA9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\x5D"],

        ["\xD3\x5C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xAA"],
        ["\xCC\xAA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\x5C"],

        ["\xD3\x4E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xAB"],
        ["\xCC\xAB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\x4E"],

        ["\xD3\x6B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xAC"],
        ["\xCC\xAC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\x6B"],

        ["\xD3\x60",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xAD"],
        ["\xCC\xAD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\x60"],

        ["\xD3\x4B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xAE"],
        ["\xCC\xAE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\x4B"],

        ["\xD3\x61",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xAF"],
        ["\xCC\xAF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\x61"],

        ["\xD3\xF0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xB0"],
        ["\xCC\xB0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xF0"],

        ["\xD3\xF1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xB1"],
        ["\xCC\xB1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xF1"],

        ["\xD3\xF2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xB2"],
        ["\xCC\xB2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xF2"],

        ["\xD3\xF3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xB3"],
        ["\xCC\xB3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xF3"],

        ["\xD3\xF4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xB4"],
        ["\xCC\xB4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xF4"],

        ["\xD3\xF5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xB5"],
        ["\xCC\xB5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xF5"],

        ["\xD3\xF6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xB6"],
        ["\xCC\xB6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xF6"],

        ["\xD3\xF7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xB7"],
        ["\xCC\xB7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xF7"],

        ["\xD3\xF8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xB8"],
        ["\xCC\xB8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xF8"],

        ["\xD3\xF9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xB9"],
        ["\xCC\xB9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xF9"],

        ["\xD3\x7A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xBA"],
        ["\xCC\xBA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\x7A"],

        ["\xD3\x5E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xBB"],
        ["\xCC\xBB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\x5E"],

        ["\xD3\x4C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xBC"],
        ["\xCC\xBC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\x4C"],

        ["\xD3\x7E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xBD"],
        ["\xCC\xBD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\x7E"],

        ["\xD3\x6E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xBE"],
        ["\xCC\xBE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\x6E"],

        ["\xD3\x6F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xBF"],
        ["\xCC\xBF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\x6F"],

        ["\xD3\x7C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xC0"],
        ["\xCC\xC0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\x7C"],

        ["\xD3\xC1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xC1"],
        ["\xCC\xC1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xC1"],

        ["\xD3\xC2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xC2"],
        ["\xCC\xC2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xC2"],

        ["\xD3\xC3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xC3"],
        ["\xCC\xC3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xC3"],

        ["\xD3\xC4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xC4"],
        ["\xCC\xC4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xC4"],

        ["\xD3\xC5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xC5"],
        ["\xCC\xC5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xC5"],

        ["\xD3\xC6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xC6"],
        ["\xCC\xC6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xC6"],

        ["\xD3\xC7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xC7"],
        ["\xCC\xC7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xC7"],

        ["\xD3\xC8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xC8"],
        ["\xCC\xC8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xC8"],

        ["\xD3\xC9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xC9"],
        ["\xCC\xC9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xC9"],

        ["\xD3\xD1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xCA"],
        ["\xCC\xCA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xD1"],

        ["\xD3\xD2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xCB"],
        ["\xCC\xCB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xD2"],

        ["\xD3\xD3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xCC"],
        ["\xCC\xCC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xD3"],

        ["\xD3\xD4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xCD"],
        ["\xCC\xCD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xD4"],

        ["\xD3\xD5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xCE"],
        ["\xCC\xCE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xD5"],

        ["\xD3\xD6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xCF"],
        ["\xCC\xCF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xD6"],

        ["\xD3\xD7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xD0"],
        ["\xCC\xD0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xD7"],

        ["\xD3\xD8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xD1"],
        ["\xCC\xD1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xD8"],

        ["\xD3\xD9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xD2"],
        ["\xCC\xD2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xD9"],

        ["\xD3\xE2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xD3"],
        ["\xCC\xD3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xE2"],

        ["\xD3\xE3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xD4"],
        ["\xCC\xD4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xE3"],

        ["\xD3\xE4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xD5"],
        ["\xCC\xD5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xE4"],

        ["\xD3\xE5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xD6"],
        ["\xCC\xD6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xE5"],

        ["\xD3\xE6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xD7"],
        ["\xCC\xD7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xE6"],

        ["\xD3\xE7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xD8"],
        ["\xCC\xD8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xE7"],

        ["\xD3\xE8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xD9"],
        ["\xCC\xD9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xE8"],

        ["\xD3\xE9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xDA"],
        ["\xCC\xDA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xE9"],

        ["\xD3\x4A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xDB"],
        ["\xCC\xDB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\x4A"],

        ["\xD3\x5B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xDC"],
        ["\xCC\xDC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\x5B"],

        ["\xD3\x5A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xDD"],
        ["\xCC\xDD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\x5A"],

        ["\xD3\x5F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xDE"],
        ["\xCC\xDE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\x5F"],

        ["\xD3\x6D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xDF"],
        ["\xCC\xDF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\x6D"],

        ["\xD3\x79",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xE0"],
        ["\xCC\xE0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\x79"],

        ["\xD3\x57",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xE1"],
        ["\xCC\xE1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\x57"],

        ["\xD3\x59",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xE2"],
        ["\xCC\xE2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\x59"],

        ["\xD3\x62",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xE3"],
        ["\xCC\xE3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\x62"],

        ["\xD3\x63",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xE4"],
        ["\xCC\xE4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\x63"],

        ["\xD3\x64",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xE5"],
        ["\xCC\xE5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\x64"],

        ["\xD3\x65",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xE6"],
        ["\xCC\xE6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\x65"],

        ["\xD3\x66",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xE7"],
        ["\xCC\xE7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\x66"],

        ["\xD3\x67",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xE8"],
        ["\xCC\xE8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\x67"],

        ["\xD3\x68",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xE9"],
        ["\xCC\xE9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\x68"],

        ["\xD3\x69",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xEA"],
        ["\xCC\xEA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\x69"],

        ["\xD3\x70",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xEB"],
        ["\xCC\xEB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\x70"],

        ["\xD3\x71",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xEC"],
        ["\xCC\xEC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\x71"],

        ["\xD3\x72",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xED"],
        ["\xCC\xED",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\x72"],

        ["\xD3\x73",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xEE"],
        ["\xCC\xEE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\x73"],

        ["\xD3\x74",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xEF"],
        ["\xCC\xEF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\x74"],

        ["\xD3\x75",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xF0"],
        ["\xCC\xF0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\x75"],

        ["\xD3\x76",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xF1"],
        ["\xCC\xF1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\x76"],

        ["\xD3\x77",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xF2"],
        ["\xCC\xF2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\x77"],

        ["\xD3\x78",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xF3"],
        ["\xCC\xF3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\x78"],

        ["\xD3\x80",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xF4"],
        ["\xCC\xF4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\x80"],

        ["\xD3\x8B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xF5"],
        ["\xCC\xF5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\x8B"],

        ["\xD3\x9B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xF6"],
        ["\xCC\xF6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\x9B"],

        ["\xD3\x9C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xF7"],
        ["\xCC\xF7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\x9C"],

        ["\xD3\xA0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xF8"],
        ["\xCC\xF8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xA0"],

        ["\x68\x4B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xF9"],
        ["\xCC\xF9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\x4B"],

        ["\xD3\xB0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xFA"],
        ["\xCC\xFA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xB0"],

        ["\xD3\xC0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xFB"],
        ["\xCC\xFB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xC0"],

        ["\xD3\x6A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xFC"],
        ["\xCC\xFC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\x6A"],

        ["\xD3\xD0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xFD"],
        ["\xCC\xFD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xD0"],

        ["\xD3\xA1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCC\xFE"],
        ["\xCC\xFE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xA1"],

        ["\xD4\x4F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xA1"],
        ["\xCD\xA1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\x4F"],

        ["\xD4\x7F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xA2"],
        ["\xCD\xA2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\x7F"],

        ["\xD4\x7B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xA3"],
        ["\xCD\xA3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\x7B"],

        ["\xD4\xE0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xA4"],
        ["\xCD\xA4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xE0"],

        ["\xD4\x6C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xA5"],
        ["\xCD\xA5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\x6C"],

        ["\xD4\x50",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xA6"],
        ["\xCD\xA6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\x50"],

        ["\xD4\x7D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xA7"],
        ["\xCD\xA7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\x7D"],

        ["\xD4\x4D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xA8"],
        ["\xCD\xA8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\x4D"],

        ["\xD4\x5D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xA9"],
        ["\xCD\xA9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\x5D"],

        ["\xD4\x5C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xAA"],
        ["\xCD\xAA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\x5C"],

        ["\xD4\x4E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xAB"],
        ["\xCD\xAB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\x4E"],

        ["\xD4\x6B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xAC"],
        ["\xCD\xAC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\x6B"],

        ["\xD4\x60",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xAD"],
        ["\xCD\xAD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\x60"],

        ["\xD4\x4B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xAE"],
        ["\xCD\xAE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\x4B"],

        ["\xD4\x61",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xAF"],
        ["\xCD\xAF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\x61"],

        ["\xD4\xF0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xB0"],
        ["\xCD\xB0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xF0"],

        ["\xD4\xF1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xB1"],
        ["\xCD\xB1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xF1"],

        ["\xD4\xF2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xB2"],
        ["\xCD\xB2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xF2"],

        ["\xD4\xF3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xB3"],
        ["\xCD\xB3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xF3"],

        ["\xD4\xF4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xB4"],
        ["\xCD\xB4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xF4"],

        ["\xD4\xF5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xB5"],
        ["\xCD\xB5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xF5"],

        ["\xD4\xF6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xB6"],
        ["\xCD\xB6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xF6"],

        ["\xD4\xF7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xB7"],
        ["\xCD\xB7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xF7"],

        ["\xD4\xF8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xB8"],
        ["\xCD\xB8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xF8"],

        ["\xD4\xF9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xB9"],
        ["\xCD\xB9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xF9"],

        ["\xD4\x7A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xBA"],
        ["\xCD\xBA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\x7A"],

        ["\xD4\x5E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xBB"],
        ["\xCD\xBB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\x5E"],

        ["\xD4\x4C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xBC"],
        ["\xCD\xBC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\x4C"],

        ["\xD4\x7E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xBD"],
        ["\xCD\xBD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\x7E"],

        ["\xD4\x6E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xBE"],
        ["\xCD\xBE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\x6E"],

        ["\xD4\x6F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xBF"],
        ["\xCD\xBF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\x6F"],

        ["\xD4\x7C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xC0"],
        ["\xCD\xC0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\x7C"],

        ["\xD4\xC1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xC1"],
        ["\xCD\xC1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xC1"],

        ["\xD4\xC2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xC2"],
        ["\xCD\xC2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xC2"],

        ["\xD4\xC3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xC3"],
        ["\xCD\xC3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xC3"],

        ["\xD4\xC4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xC4"],
        ["\xCD\xC4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xC4"],

        ["\xD4\xC5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xC5"],
        ["\xCD\xC5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xC5"],

        ["\xD4\xC6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xC6"],
        ["\xCD\xC6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xC6"],

        ["\xD4\xC7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xC7"],
        ["\xCD\xC7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xC7"],

        ["\xD4\xC8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xC8"],
        ["\xCD\xC8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xC8"],

        ["\xD4\xC9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xC9"],
        ["\xCD\xC9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xC9"],

        ["\xD4\xD1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xCA"],
        ["\xCD\xCA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xD1"],

        ["\xD4\xD2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xCB"],
        ["\xCD\xCB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xD2"],

        ["\xD4\xD3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xCC"],
        ["\xCD\xCC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xD3"],

        ["\xD4\xD4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xCD"],
        ["\xCD\xCD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xD4"],

        ["\xD4\xD5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xCE"],
        ["\xCD\xCE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xD5"],

        ["\xD4\xD6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xCF"],
        ["\xCD\xCF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xD6"],

        ["\xD4\xD7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xD0"],
        ["\xCD\xD0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xD7"],

        ["\xD4\xD8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xD1"],
        ["\xCD\xD1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xD8"],

        ["\xD4\xD9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xD2"],
        ["\xCD\xD2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xD9"],

        ["\xD4\xE2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xD3"],
        ["\xCD\xD3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xE2"],

        ["\xD4\xE3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xD4"],
        ["\xCD\xD4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xE3"],

        ["\xD4\xE4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xD5"],
        ["\xCD\xD5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xE4"],

        ["\xD4\xE5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xD6"],
        ["\xCD\xD6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xE5"],

        ["\xD4\xE6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xD7"],
        ["\xCD\xD7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xE6"],

        ["\xD4\xE7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xD8"],
        ["\xCD\xD8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xE7"],

        ["\xD4\xE8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xD9"],
        ["\xCD\xD9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xE8"],

        ["\xA5\x95",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xDA"],
        ["\xCD\xDA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xA5\x95"],

        ["\xD4\x4A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xDB"],
        ["\xCD\xDB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\x4A"],

        ["\xD4\x5B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xDC"],
        ["\xCD\xDC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\x5B"],

        ["\xD4\x5A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xDD"],
        ["\xCD\xDD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\x5A"],

        ["\xD4\x5F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xDE"],
        ["\xCD\xDE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\x5F"],

        ["\xD4\x6D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xDF"],
        ["\xCD\xDF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\x6D"],

        ["\xD4\x79",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xE0"],
        ["\xCD\xE0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\x79"],

        ["\xD4\x57",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xE1"],
        ["\xCD\xE1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\x57"],

        ["\xD4\x59",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xE2"],
        ["\xCD\xE2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\x59"],

        ["\xD4\x62",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xE3"],
        ["\xCD\xE3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\x62"],

        ["\xD4\x63",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xE4"],
        ["\xCD\xE4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\x63"],

        ["\xD4\x64",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xE5"],
        ["\xCD\xE5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\x64"],

        ["\xD4\x65",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xE6"],
        ["\xCD\xE6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\x65"],

        ["\xD4\x66",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xE7"],
        ["\xCD\xE7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\x66"],

        ["\xD4\x67",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xE8"],
        ["\xCD\xE8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\x67"],

        ["\xD4\x68",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xE9"],
        ["\xCD\xE9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\x68"],

        ["\xD4\x69",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xEA"],
        ["\xCD\xEA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\x69"],

        ["\xD4\x70",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xEB"],
        ["\xCD\xEB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\x70"],

        ["\xD4\x71",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xEC"],
        ["\xCD\xEC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\x71"],

        ["\xD4\x72",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xED"],
        ["\xCD\xED",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\x72"],

        ["\xD4\x73",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xEE"],
        ["\xCD\xEE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\x73"],

        ["\xD4\x74",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xEF"],
        ["\xCD\xEF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\x74"],

        ["\xD4\x75",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xF0"],
        ["\xCD\xF0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\x75"],

        ["\xD4\x76",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xF1"],
        ["\xCD\xF1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\x76"],

        ["\xD4\x77",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xF2"],
        ["\xCD\xF2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\x77"],

        ["\xD4\x78",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xF3"],
        ["\xCD\xF3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\x78"],

        ["\xD4\x80",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xF4"],
        ["\xCD\xF4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\x80"],

        ["\xD4\x8B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xF5"],
        ["\xCD\xF5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\x8B"],

        ["\xD4\x9B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xF6"],
        ["\xCD\xF6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\x9B"],

        ["\xD4\x9C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xF7"],
        ["\xCD\xF7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\x9C"],

        ["\xD4\xA0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xF8"],
        ["\xCD\xF8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xA0"],

        ["\xD4\xAB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xF9"],
        ["\xCD\xF9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xAB"],

        ["\xD4\xB0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xFA"],
        ["\xCD\xFA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xB0"],

        ["\xD4\xC0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xFB"],
        ["\xCD\xFB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xC0"],

        ["\xD4\x6A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xFC"],
        ["\xCD\xFC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\x6A"],

        ["\xD4\xD0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xFD"],
        ["\xCD\xFD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xD0"],

        ["\xD4\xA1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCD\xFE"],
        ["\xCD\xFE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xA1"],

        ["\xD5\x4F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xA1"],
        ["\xCE\xA1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\x4F"],

        ["\xD5\x7F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xA2"],
        ["\xCE\xA2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\x7F"],

        ["\xD5\x7B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xA3"],
        ["\xCE\xA3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\x7B"],

        ["\xD5\xE0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xA4"],
        ["\xCE\xA4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xE0"],

        ["\xD5\x6C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xA5"],
        ["\xCE\xA5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\x6C"],

        ["\xD5\x50",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xA6"],
        ["\xCE\xA6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\x50"],

        ["\xD5\x7D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xA7"],
        ["\xCE\xA7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\x7D"],

        ["\xD5\x4D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xA8"],
        ["\xCE\xA8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\x4D"],

        ["\xD5\x5D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xA9"],
        ["\xCE\xA9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\x5D"],

        ["\xD5\x5C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xAA"],
        ["\xCE\xAA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\x5C"],

        ["\xD5\x4E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xAB"],
        ["\xCE\xAB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\x4E"],

        ["\xD5\x6B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xAC"],
        ["\xCE\xAC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\x6B"],

        ["\xD5\x60",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xAD"],
        ["\xCE\xAD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\x60"],

        ["\xD5\x4B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xAE"],
        ["\xCE\xAE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\x4B"],

        ["\xD5\x61",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xAF"],
        ["\xCE\xAF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\x61"],

        ["\xD5\xF0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xB0"],
        ["\xCE\xB0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xF0"],

        ["\xD5\xF1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xB1"],
        ["\xCE\xB1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xF1"],

        ["\xD5\xF2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xB2"],
        ["\xCE\xB2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xF2"],

        ["\xD5\xF3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xB3"],
        ["\xCE\xB3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xF3"],

        ["\xD5\xF4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xB4"],
        ["\xCE\xB4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xF4"],

        ["\xD5\xF5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xB5"],
        ["\xCE\xB5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xF5"],

        ["\xD5\xF6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xB6"],
        ["\xCE\xB6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xF6"],

        ["\xD5\xF7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xB7"],
        ["\xCE\xB7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xF7"],

        ["\xD5\xF8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xB8"],
        ["\xCE\xB8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xF8"],

        ["\xD5\xF9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xB9"],
        ["\xCE\xB9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xF9"],

        ["\xD5\x7A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xBA"],
        ["\xCE\xBA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\x7A"],

        ["\xD5\x5E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xBB"],
        ["\xCE\xBB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\x5E"],

        ["\xD5\x4C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xBC"],
        ["\xCE\xBC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\x4C"],

        ["\xD5\x7E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xBD"],
        ["\xCE\xBD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\x7E"],

        ["\xD5\x6E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xBE"],
        ["\xCE\xBE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\x6E"],

        ["\xD5\x6F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xBF"],
        ["\xCE\xBF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\x6F"],

        ["\xD5\x7C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xC0"],
        ["\xCE\xC0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\x7C"],

        ["\xD5\xC1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xC1"],
        ["\xCE\xC1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xC1"],

        ["\xD5\xC2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xC2"],
        ["\xCE\xC2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xC2"],

        ["\xD5\xC3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xC3"],
        ["\xCE\xC3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xC3"],

        ["\xD5\xC4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xC4"],
        ["\xCE\xC4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xC4"],

        ["\xD5\xC5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xC5"],
        ["\xCE\xC5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xC5"],

        ["\xD5\xC6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xC6"],
        ["\xCE\xC6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xC6"],

        ["\xD5\xC7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xC7"],
        ["\xCE\xC7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xC7"],

        ["\xD5\xC8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xC8"],
        ["\xCE\xC8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xC8"],

        ["\xD5\xC9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xC9"],
        ["\xCE\xC9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xC9"],

        ["\xD5\xD1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xCA"],
        ["\xCE\xCA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xD1"],

        ["\xD5\xD2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xCB"],
        ["\xCE\xCB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xD2"],

        ["\xD5\xD3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xCC"],
        ["\xCE\xCC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xD3"],

        ["\xD5\xD4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xCD"],
        ["\xCE\xCD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xD4"],

        ["\xD5\xD5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xCE"],
        ["\xCE\xCE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xD5"],

        ["\xD5\xD6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xCF"],
        ["\xCE\xCF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xD6"],

        ["\xD5\xD7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xD0"],
        ["\xCE\xD0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xD7"],

        ["\xD5\xD8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xD1"],
        ["\xCE\xD1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xD8"],

        ["\xD5\xD9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xD2"],
        ["\xCE\xD2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xD9"],

        ["\xD5\xE2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xD3"],
        ["\xCE\xD3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xE2"],

        ["\xD5\xE3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xD4"],
        ["\xCE\xD4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xE3"],

        ["\xD5\xE4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xD5"],
        ["\xCE\xD5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xE4"],

        ["\xD5\xE5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xD6"],
        ["\xCE\xD6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xE5"],

        ["\xD5\xE6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xD7"],
        ["\xCE\xD7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xE6"],

        ["\xD5\xE7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xD8"],
        ["\xCE\xD8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xE7"],

        ["\xD5\xE8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xD9"],
        ["\xCE\xD9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xE8"],

        ["\xD5\xE9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xDA"],
        ["\xCE\xDA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xE9"],

        ["\xD5\x4A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xDB"],
        ["\xCE\xDB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\x4A"],

        ["\xD5\x5B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xDC"],
        ["\xCE\xDC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\x5B"],

        ["\xD5\x5A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xDD"],
        ["\xCE\xDD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\x5A"],

        ["\xD5\x5F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xDE"],
        ["\xCE\xDE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\x5F"],

        ["\xD5\x6D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xDF"],
        ["\xCE\xDF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\x6D"],

        ["\xD5\x79",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xE0"],
        ["\xCE\xE0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\x79"],

        ["\xD5\x57",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xE1"],
        ["\xCE\xE1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\x57"],

        ["\xD5\x59",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xE2"],
        ["\xCE\xE2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\x59"],

        ["\xD5\x62",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xE3"],
        ["\xCE\xE3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\x62"],

        ["\xD5\x63",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xE4"],
        ["\xCE\xE4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\x63"],

        ["\xD5\x64",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xE5"],
        ["\xCE\xE5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\x64"],

        ["\xD5\x65",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xE6"],
        ["\xCE\xE6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\x65"],

        ["\xD5\x66",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xE7"],
        ["\xCE\xE7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\x66"],

        ["\xD5\x67",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xE8"],
        ["\xCE\xE8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\x67"],

        ["\xD5\x68",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xE9"],
        ["\xCE\xE9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\x68"],

        ["\xD5\x69",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xEA"],
        ["\xCE\xEA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\x69"],

        ["\xD5\x70",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xEB"],
        ["\xCE\xEB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\x70"],

        ["\xD5\x71",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xEC"],
        ["\xCE\xEC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\x71"],

        ["\xD5\x72",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xED"],
        ["\xCE\xED",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\x72"],

        ["\xD5\x73",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xEE"],
        ["\xCE\xEE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\x73"],

        ["\xD5\x74",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xEF"],
        ["\xCE\xEF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\x74"],

        ["\xD5\x75",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xF0"],
        ["\xCE\xF0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\x75"],

        ["\xD5\x76",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xF1"],
        ["\xCE\xF1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\x76"],

        ["\xD5\x77",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xF2"],
        ["\xCE\xF2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\x77"],

        ["\xD5\x78",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xF3"],
        ["\xCE\xF3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\x78"],

        ["\xD5\x80",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xF4"],
        ["\xCE\xF4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\x80"],

        ["\xD5\x8B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xF5"],
        ["\xCE\xF5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\x8B"],

        ["\xD5\x9B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xF6"],
        ["\xCE\xF6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\x9B"],

        ["\xD5\x9C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xF7"],
        ["\xCE\xF7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\x9C"],

        ["\xD5\xA0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xF8"],
        ["\xCE\xF8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xA0"],

        ["\xD5\xAB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xF9"],
        ["\xCE\xF9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xAB"],

        ["\xD5\xB0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xFA"],
        ["\xCE\xFA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xB0"],

        ["\xD5\xC0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xFB"],
        ["\xCE\xFB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xC0"],

        ["\xD5\x6A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xFC"],
        ["\xCE\xFC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\x6A"],

        ["\xD5\xD0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xFD"],
        ["\xCE\xFD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xD0"],

        ["\xD5\xA1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xFE"],
        ["\xCE\xFE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xA1"],

        ["\xD6\x4F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCF\xA1"],
        ["\xCF\xA1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD6\x4F"],

        ["\xD6\x7F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCF\xA2"],
        ["\xCF\xA2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD6\x7F"],

        ["\xD6\x7B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCF\xA3"],
        ["\xCF\xA3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD6\x7B"],

        ["\xD6\xE0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCF\xA4"],
        ["\xCF\xA4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xE0"],

        ["\xD6\x6C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCF\xA5"],
        ["\xCF\xA5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD6\x6C"],

        ["\xD6\x50",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCF\xA6"],
        ["\xCF\xA6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD6\x50"],

        ["\xD6\x7D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCF\xA7"],
        ["\xCF\xA7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD6\x7D"],

        ["\xD6\x4D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCF\xA8"],
        ["\xCF\xA8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD6\x4D"],

        ["\xD6\x5D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCF\xA9"],
        ["\xCF\xA9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD6\x5D"],

        ["\xD6\x5C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCF\xAA"],
        ["\xCF\xAA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD6\x5C"],

        ["\xD6\x4E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCF\xAB"],
        ["\xCF\xAB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD6\x4E"],

        ["\xD6\x6B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCF\xAC"],
        ["\xCF\xAC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD6\x6B"],

        ["\xD6\x60",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCF\xAD"],
        ["\xCF\xAD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD6\x60"],

        ["\xD6\x4B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCF\xAE"],
        ["\xCF\xAE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD6\x4B"],

        ["\xD6\x61",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCF\xAF"],
        ["\xCF\xAF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD6\x61"],

        ["\xD6\xF0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCF\xB0"],
        ["\xCF\xB0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xF0"],

        ["\xD6\xF1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCF\xB1"],
        ["\xCF\xB1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xF1"],

        ["\xD6\xF2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCF\xB2"],
        ["\xCF\xB2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xF2"],

        ["\xD6\xF3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCF\xB3"],
        ["\xCF\xB3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xF3"],

        ["\xD6\xF4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCF\xB4"],
        ["\xCF\xB4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xF4"],

        ["\xD6\xF5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCF\xB5"],
        ["\xCF\xB5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xF5"],

        ["\x63\xC6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCF\xB6"],
        ["\xCF\xB6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\xC6"],

        ["\xD6\xF7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCF\xB7"],
        ["\xCF\xB7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xF7"],

        ["\xD6\xF8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCF\xB8"],
        ["\xCF\xB8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xF8"],

        ["\xD6\xF9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCF\xB9"],
        ["\xCF\xB9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xF9"],

        ["\xD6\x7A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCF\xBA"],
        ["\xCF\xBA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD6\x7A"],

        ["\xD6\x5E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCF\xBB"],
        ["\xCF\xBB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD6\x5E"],

        ["\xD6\x4C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCF\xBC"],
        ["\xCF\xBC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD6\x4C"],

        ["\xD6\x7E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCF\xBD"],
        ["\xCF\xBD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD6\x7E"],

        ["\xD6\x6E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCF\xBE"],
        ["\xCF\xBE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD6\x6E"],

        ["\xD6\x6F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCF\xBF"],
        ["\xCF\xBF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD6\x6F"],

        ["\xD6\x7C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCF\xC0"],
        ["\xCF\xC0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD6\x7C"],

        ["\xD6\xC1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCF\xC1"],
        ["\xCF\xC1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xC1"],

        ["\xD6\xC2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCF\xC2"],
        ["\xCF\xC2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xC2"],

        ["\xD6\xC3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCF\xC3"],
        ["\xCF\xC3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xC3"],

        ["\xD6\xC4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCF\xC4"],
        ["\xCF\xC4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xC4"],

        ["\xD6\xC5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCF\xC5"],
        ["\xCF\xC5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xC5"],

        ["\xD6\xC6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCF\xC6"],
        ["\xCF\xC6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xC6"],

        ["\xD6\xC7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCF\xC7"],
        ["\xCF\xC7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xC7"],

        ["\xD6\xC8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCF\xC8"],
        ["\xCF\xC8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xC8"],

        ["\xD6\xC9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCF\xC9"],
        ["\xCF\xC9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xC9"],

        ["\xD6\xD1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCF\xCA"],
        ["\xCF\xCA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xD1"],

        ["\xD6\xD2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCF\xCB"],
        ["\xCF\xCB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xD2"],

        ["\xD6\xD3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCF\xCC"],
        ["\xCF\xCC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xD3"],

        ["\xD6\xD4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCF\xCD"],
        ["\xCF\xCD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xD4"],

        ["\xD6\xD5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCF\xCE"],
        ["\xCF\xCE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xD5"],

        ["\xD6\xD6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCF\xCF"],
        ["\xCF\xCF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xD6"],

        ["\xD6\xD7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCF\xD0"],
        ["\xCF\xD0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xD7"],

        ["\xD6\xD8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCF\xD1"],
        ["\xCF\xD1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xD8"],

        ["\xD6\xD9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCF\xD2"],
        ["\xCF\xD2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xD9"],

        ["\xD6\xE2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xCF\xD3"],
        ["\xCF\xD3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xE2"],

        ["\xD7\x4F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xA1"],
        ["\xD0\xA1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\x4F"],

        ["\xD7\x7F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xA2"],
        ["\xD0\xA2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\x7F"],

        ["\xD7\x7B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xA3"],
        ["\xD0\xA3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\x7B"],

        ["\xD7\xE0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xA4"],
        ["\xD0\xA4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xE0"],

        ["\xD7\x6C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xA5"],
        ["\xD0\xA5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\x6C"],

        ["\xD7\x50",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xA6"],
        ["\xD0\xA6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\x50"],

        ["\xD7\x7D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xA7"],
        ["\xD0\xA7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\x7D"],

        ["\xD7\x4D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xA8"],
        ["\xD0\xA8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\x4D"],

        ["\xD7\x5D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xA9"],
        ["\xD0\xA9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\x5D"],

        ["\xD7\x5C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xAA"],
        ["\xD0\xAA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\x5C"],

        ["\xD7\x4E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xAB"],
        ["\xD0\xAB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\x4E"],

        ["\xD7\x6B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xAC"],
        ["\xD0\xAC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\x6B"],

        ["\xD7\x60",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xAD"],
        ["\xD0\xAD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\x60"],

        ["\xD7\x4B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xAE"],
        ["\xD0\xAE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\x4B"],

        ["\xD7\x61",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xAF"],
        ["\xD0\xAF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\x61"],

        ["\xD7\xF0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xB0"],
        ["\xD0\xB0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xF0"],

        ["\xD7\xF1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xB1"],
        ["\xD0\xB1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xF1"],

        ["\xD7\xF2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xB2"],
        ["\xD0\xB2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xF2"],

        ["\xD7\xF3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xB3"],
        ["\xD0\xB3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xF3"],

        ["\xD7\xF4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xB4"],
        ["\xD0\xB4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xF4"],

        ["\xD7\xF5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xB5"],
        ["\xD0\xB5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xF5"],

        ["\xD7\xF6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xB6"],
        ["\xD0\xB6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xF6"],

        ["\xD7\xF7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xB7"],
        ["\xD0\xB7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xF7"],

        ["\xD7\xF8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xB8"],
        ["\xD0\xB8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xF8"],

        ["\xD7\xF9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xB9"],
        ["\xD0\xB9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xF9"],

        ["\xD7\x7A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xBA"],
        ["\xD0\xBA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\x7A"],

        ["\xD7\x5E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xBB"],
        ["\xD0\xBB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\x5E"],

        ["\xD7\x4C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xBC"],
        ["\xD0\xBC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\x4C"],

        ["\xD7\x7E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xBD"],
        ["\xD0\xBD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\x7E"],

        ["\xD7\x6E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xBE"],
        ["\xD0\xBE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\x6E"],

        ["\xD7\x6F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xBF"],
        ["\xD0\xBF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\x6F"],

        ["\xD7\x7C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xC0"],
        ["\xD0\xC0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\x7C"],

        ["\xD7\xC1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xC1"],
        ["\xD0\xC1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xC1"],

        ["\xD7\xC2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xC2"],
        ["\xD0\xC2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xC2"],

        ["\xD7\xC3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xC3"],
        ["\xD0\xC3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xC3"],

        ["\xD7\xC4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xC4"],
        ["\xD0\xC4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xC4"],

        ["\xD7\xC5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xC5"],
        ["\xD0\xC5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xC5"],

        ["\xD7\xC6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xC6"],
        ["\xD0\xC6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xC6"],

        ["\xD7\xC7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xC7"],
        ["\xD0\xC7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xC7"],

        ["\xD7\xC8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xC8"],
        ["\xD0\xC8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xC8"],

        ["\xD7\xC9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xC9"],
        ["\xD0\xC9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xC9"],

        ["\xD7\xD1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xCA"],
        ["\xD0\xCA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xD1"],

        ["\xD7\xD2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xCB"],
        ["\xD0\xCB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xD2"],

        ["\xD7\xD3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xCC"],
        ["\xD0\xCC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xD3"],

        ["\xD7\xD4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xCD"],
        ["\xD0\xCD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xD4"],

        ["\xD7\xD5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xCE"],
        ["\xD0\xCE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xD5"],

        ["\xD7\xD6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xCF"],
        ["\xD0\xCF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xD6"],

        ["\xD7\xD7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xD0"],
        ["\xD0\xD0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xD7"],

        ["\xD7\xD8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xD1"],
        ["\xD0\xD1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xD8"],

        ["\xD7\xD9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xD2"],
        ["\xD0\xD2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xD9"],

        ["\xD7\xE2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xD3"],
        ["\xD0\xD3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xE2"],

        ["\xD7\xE3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xD4"],
        ["\xD0\xD4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xE3"],

        ["\xD7\xE4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xD5"],
        ["\xD0\xD5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xE4"],

        ["\xD2\xAB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xD6"],
        ["\xD0\xD6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xAB"],

        ["\xD7\xE6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xD7"],
        ["\xD0\xD7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xE6"],

        ["\xD7\xE7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xD8"],
        ["\xD0\xD8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xE7"],

        ["\xD7\xE8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xD9"],
        ["\xD0\xD9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xE8"],

        ["\xD7\xE9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xDA"],
        ["\xD0\xDA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xE9"],

        ["\xD7\x4A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xDB"],
        ["\xD0\xDB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\x4A"],

        ["\xD7\x5B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xDC"],
        ["\xD0\xDC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\x5B"],

        ["\xD7\x5A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xDD"],
        ["\xD0\xDD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\x5A"],

        ["\xD7\x5F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xDE"],
        ["\xD0\xDE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\x5F"],

        ["\xD7\x6D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xDF"],
        ["\xD0\xDF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\x6D"],

        ["\xD7\x79",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xE0"],
        ["\xD0\xE0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\x79"],

        ["\xD7\x57",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xE1"],
        ["\xD0\xE1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\x57"],

        ["\xD7\x59",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xE2"],
        ["\xD0\xE2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\x59"],

        ["\xD7\x62",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xE3"],
        ["\xD0\xE3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\x62"],

        ["\xD7\x63",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xE4"],
        ["\xD0\xE4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\x63"],

        ["\xD7\x64",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xE5"],
        ["\xD0\xE5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\x64"],

        ["\xD7\x65",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xE6"],
        ["\xD0\xE6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\x65"],

        ["\xD7\x66",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xE7"],
        ["\xD0\xE7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\x66"],

        ["\xD7\x67",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xE8"],
        ["\xD0\xE8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\x67"],

        ["\xD7\x68",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xE9"],
        ["\xD0\xE9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\x68"],

        ["\xD7\x69",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xEA"],
        ["\xD0\xEA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\x69"],

        ["\xD7\x70",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xEB"],
        ["\xD0\xEB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\x70"],

        ["\xD7\x71",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xEC"],
        ["\xD0\xEC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\x71"],

        ["\xD7\x72",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xED"],
        ["\xD0\xED",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\x72"],

        ["\xD7\x73",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xEE"],
        ["\xD0\xEE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\x73"],

        ["\xD7\x74",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xEF"],
        ["\xD0\xEF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\x74"],

        ["\xD7\x75",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xF0"],
        ["\xD0\xF0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\x75"],

        ["\xD7\x76",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xF1"],
        ["\xD0\xF1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\x76"],

        ["\xD7\x77",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xF2"],
        ["\xD0\xF2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\x77"],

        ["\xD7\x78",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xF3"],
        ["\xD0\xF3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\x78"],

        ["\xD7\x80",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xF4"],
        ["\xD0\xF4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\x80"],

        ["\xD7\x8B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xF5"],
        ["\xD0\xF5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\x8B"],

        ["\xD7\x9B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xF6"],
        ["\xD0\xF6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\x9B"],

        ["\xD7\x9C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xF7"],
        ["\xD0\xF7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\x9C"],

        ["\xD7\xA0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xF8"],
        ["\xD0\xF8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xA0"],

        ["\xD7\xAB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xF9"],
        ["\xD0\xF9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xAB"],

        ["\xD7\xB0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xFA"],
        ["\xD0\xFA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xB0"],

        ["\xD7\xC0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xFB"],
        ["\xD0\xFB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xC0"],

        ["\xD7\x6A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xFC"],
        ["\xD0\xFC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\x6A"],

        ["\xD7\xD0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xFD"],
        ["\xD0\xFD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xD0"],

        ["\xD7\xA1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xFE"],
        ["\xD0\xFE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xA1"],

        ["\xD8\x4F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xA1"],
        ["\xD1\xA1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\x4F"],

        ["\xD8\x7F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xA2"],
        ["\xD1\xA2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\x7F"],

        ["\xD8\x7B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xA3"],
        ["\xD1\xA3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\x7B"],

        ["\xD8\xE0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xA4"],
        ["\xD1\xA4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xE0"],

        ["\xD8\x6C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xA5"],
        ["\xD1\xA5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\x6C"],

        ["\xD8\x50",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xA6"],
        ["\xD1\xA6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\x50"],

        ["\xD8\x7D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xA7"],
        ["\xD1\xA7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\x7D"],

        ["\xD8\x4D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xA8"],
        ["\xD1\xA8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\x4D"],

        ["\xD8\x5D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xA9"],
        ["\xD1\xA9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\x5D"],

        ["\xD8\x5C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xAA"],
        ["\xD1\xAA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\x5C"],

        ["\xD8\x4E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xAB"],
        ["\xD1\xAB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\x4E"],

        ["\xD8\x6B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xAC"],
        ["\xD1\xAC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\x6B"],

        ["\xD8\x60",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xAD"],
        ["\xD1\xAD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\x60"],

        ["\xD8\x4B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xAE"],
        ["\xD1\xAE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\x4B"],

        ["\xD8\x61",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xAF"],
        ["\xD1\xAF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\x61"],

        ["\xD8\xF0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xB0"],
        ["\xD1\xB0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xF0"],

        ["\xD8\xF1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xB1"],
        ["\xD1\xB1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xF1"],

        ["\xD8\xF2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xB2"],
        ["\xD1\xB2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xF2"],

        ["\xD8\xF3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xB3"],
        ["\xD1\xB3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xF3"],

        ["\xD8\xF4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xB4"],
        ["\xD1\xB4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xF4"],

        ["\xD8\xF5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xB5"],
        ["\xD1\xB5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xF5"],

        ["\xD8\xF6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xB6"],
        ["\xD1\xB6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xF6"],

        ["\xD8\xF7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xB7"],
        ["\xD1\xB7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xF7"],

        ["\xD8\xF8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xB8"],
        ["\xD1\xB8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xF8"],

        ["\xD8\xF9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xB9"],
        ["\xD1\xB9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xF9"],

        ["\xD8\x7A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xBA"],
        ["\xD1\xBA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\x7A"],

        ["\xD8\x5E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xBB"],
        ["\xD1\xBB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\x5E"],

        ["\xD8\x4C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xBC"],
        ["\xD1\xBC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\x4C"],

        ["\xD8\x7E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xBD"],
        ["\xD1\xBD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\x7E"],

        ["\xD8\x6E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xBE"],
        ["\xD1\xBE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\x6E"],

        ["\xD8\x6F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xBF"],
        ["\xD1\xBF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\x6F"],

        ["\xD8\x7C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xC0"],
        ["\xD1\xC0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\x7C"],

        ["\xD8\xC1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xC1"],
        ["\xD1\xC1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xC1"],

        ["\xD8\xC2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xC2"],
        ["\xD1\xC2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xC2"],

        ["\xD8\xC3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xC3"],
        ["\xD1\xC3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xC3"],

        ["\xD8\xC4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xC4"],
        ["\xD1\xC4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xC4"],

        ["\xD8\xC5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xC5"],
        ["\xD1\xC5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xC5"],

        ["\xD8\xC6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xC6"],
        ["\xD1\xC6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xC6"],

        ["\xD8\xC7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xC7"],
        ["\xD1\xC7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xC7"],

        ["\xD8\xC8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xC8"],
        ["\xD1\xC8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xC8"],

        ["\xD8\xC9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xC9"],
        ["\xD1\xC9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xC9"],

        ["\xD8\xD1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xCA"],
        ["\xD1\xCA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xD1"],

        ["\xD8\xD2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xCB"],
        ["\xD1\xCB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xD2"],

        ["\xD8\xD3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xCC"],
        ["\xD1\xCC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xD3"],

        ["\xD8\xD4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xCD"],
        ["\xD1\xCD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xD4"],

        ["\xD8\xD5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xCE"],
        ["\xD1\xCE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xD5"],

        ["\xD8\xD6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xCF"],
        ["\xD1\xCF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xD6"],

        ["\xD8\xD7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xD0"],
        ["\xD1\xD0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xD7"],

        ["\xD8\xD8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xD1"],
        ["\xD1\xD1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xD8"],

        ["\xD8\xD9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xD2"],
        ["\xD1\xD2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xD9"],

        ["\xD8\xE2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xD3"],
        ["\xD1\xD3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xE2"],

        ["\xD8\xE3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xD4"],
        ["\xD1\xD4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xE3"],

        ["\xD8\xE4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xD5"],
        ["\xD1\xD5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xE4"],

        ["\xD8\xE5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xD6"],
        ["\xD1\xD6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xE5"],

        ["\xD8\xE6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xD7"],
        ["\xD1\xD7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xE6"],

        ["\xD8\xE7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xD8"],
        ["\xD1\xD8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xE7"],

        ["\xD8\xE8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xD9"],
        ["\xD1\xD9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xE8"],

        ["\xD8\xE9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xDA"],
        ["\xD1\xDA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xE9"],

        ["\xD8\x4A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xDB"],
        ["\xD1\xDB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\x4A"],

        ["\xD8\x5B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xDC"],
        ["\xD1\xDC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\x5B"],

        ["\xD8\x5A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xDD"],
        ["\xD1\xDD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\x5A"],

        ["\xD8\x5F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xDE"],
        ["\xD1\xDE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\x5F"],

        ["\xD8\x6D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xDF"],
        ["\xD1\xDF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\x6D"],

        ["\xD8\x79",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xE0"],
        ["\xD1\xE0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\x79"],

        ["\xD8\x57",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xE1"],
        ["\xD1\xE1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\x57"],

        ["\xD8\x59",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xE2"],
        ["\xD1\xE2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\x59"],

        ["\xD8\x62",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xE3"],
        ["\xD1\xE3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\x62"],

        ["\xD8\x63",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xE4"],
        ["\xD1\xE4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\x63"],

        ["\xD8\x64",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xE5"],
        ["\xD1\xE5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\x64"],

        ["\xD8\x65",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xE6"],
        ["\xD1\xE6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\x65"],

        ["\xD8\x66",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xE7"],
        ["\xD1\xE7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\x66"],

        ["\xD8\x67",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xE8"],
        ["\xD1\xE8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\x67"],

        ["\xD8\x68",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xE9"],
        ["\xD1\xE9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\x68"],

        ["\xD8\x69",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xEA"],
        ["\xD1\xEA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\x69"],

        ["\xD8\x70",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xEB"],
        ["\xD1\xEB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\x70"],

        ["\xD8\x71",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xEC"],
        ["\xD1\xEC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\x71"],

        ["\xD8\x72",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xED"],
        ["\xD1\xED",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\x72"],

        ["\xD8\x73",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xEE"],
        ["\xD1\xEE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\x73"],

        ["\xD8\x74",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xEF"],
        ["\xD1\xEF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\x74"],

        ["\xD8\x75",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xF0"],
        ["\xD1\xF0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\x75"],

        ["\xD8\x76",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xF1"],
        ["\xD1\xF1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\x76"],

        ["\xD8\x77",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xF2"],
        ["\xD1\xF2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\x77"],

        ["\xD8\x78",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xF3"],
        ["\xD1\xF3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\x78"],

        ["\xD8\x80",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xF4"],
        ["\xD1\xF4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\x80"],

        ["\xD8\x8B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xF5"],
        ["\xD1\xF5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\x8B"],

        ["\xD8\x9B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xF6"],
        ["\xD1\xF6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\x9B"],

        ["\xD8\x9C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xF7"],
        ["\xD1\xF7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\x9C"],

        ["\xD8\xA0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xF8"],
        ["\xD1\xF8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xA0"],

        ["\xD8\xAB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xF9"],
        ["\xD1\xF9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xAB"],

        ["\xD8\xB0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xFA"],
        ["\xD1\xFA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xB0"],

        ["\xD8\xC0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xFB"],
        ["\xD1\xFB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xC0"],

        ["\xD8\x6A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xFC"],
        ["\xD1\xFC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\x6A"],

        ["\xD8\xD0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xFD"],
        ["\xD1\xFD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xD0"],

        ["\xD8\xA1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\xFE"],
        ["\xD1\xFE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xA1"],

        ["\xD9\x4F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xA1"],
        ["\xD2\xA1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\x4F"],

        ["\xD9\x7F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xA2"],
        ["\xD2\xA2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\x7F"],

        ["\xD9\x7B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xA3"],
        ["\xD2\xA3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\x7B"],

        ["\xD9\xE0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xA4"],
        ["\xD2\xA4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xE0"],

        ["\xD9\x6C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xA5"],
        ["\xD2\xA5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\x6C"],

        ["\xD9\x50",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xA6"],
        ["\xD2\xA6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\x50"],

        ["\xD9\x7D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xA7"],
        ["\xD2\xA7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\x7D"],

        ["\xD9\x4D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xA8"],
        ["\xD2\xA8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\x4D"],

        ["\xD9\x5D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xA9"],
        ["\xD2\xA9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\x5D"],

        ["\xD9\x5C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xAA"],
        ["\xD2\xAA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\x5C"],

        ["\xD9\x4E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xAB"],
        ["\xD2\xAB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\x4E"],

        ["\xD9\x6B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xAC"],
        ["\xD2\xAC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\x6B"],

        ["\xD9\x60",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xAD"],
        ["\xD2\xAD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\x60"],

        ["\xD9\x4B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xAE"],
        ["\xD2\xAE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\x4B"],

        ["\xD9\x61",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xAF"],
        ["\xD2\xAF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\x61"],

        ["\xD9\xF0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xB0"],
        ["\xD2\xB0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xF0"],

        ["\xD9\xF1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xB1"],
        ["\xD2\xB1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xF1"],

        ["\xD9\xF2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xB2"],
        ["\xD2\xB2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xF2"],

        ["\xD9\xF3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xB3"],
        ["\xD2\xB3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xF3"],

        ["\xD9\xF4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xB4"],
        ["\xD2\xB4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xF4"],

        ["\xD9\xF5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xB5"],
        ["\xD2\xB5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xF5"],

        ["\xD9\xF6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xB6"],
        ["\xD2\xB6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xF6"],

        ["\xD9\xF7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xB7"],
        ["\xD2\xB7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xF7"],

        ["\xD9\xF8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xB8"],
        ["\xD2\xB8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xF8"],

        ["\xD9\xF9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xB9"],
        ["\xD2\xB9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xF9"],

        ["\xD9\x7A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xBA"],
        ["\xD2\xBA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\x7A"],

        ["\xD9\x5E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xBB"],
        ["\xD2\xBB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\x5E"],

        ["\xD9\x4C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xBC"],
        ["\xD2\xBC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\x4C"],

        ["\xD9\x7E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xBD"],
        ["\xD2\xBD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\x7E"],

        ["\xD9\x6E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xBE"],
        ["\xD2\xBE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\x6E"],

        ["\xD9\x6F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xBF"],
        ["\xD2\xBF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\x6F"],

        ["\xD9\x7C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xC0"],
        ["\xD2\xC0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\x7C"],

        ["\xD9\xC1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xC1"],
        ["\xD2\xC1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xC1"],

        ["\xD9\xC2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xC2"],
        ["\xD2\xC2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xC2"],

        ["\xD9\xC3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xC3"],
        ["\xD2\xC3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xC3"],

        ["\xD9\xC4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xC4"],
        ["\xD2\xC4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xC4"],

        ["\xD9\xC5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xC5"],
        ["\xD2\xC5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xC5"],

        ["\xD9\xC6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xC6"],
        ["\xD2\xC6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xC6"],

        ["\xD9\xC7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xC7"],
        ["\xD2\xC7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xC7"],

        ["\xD9\xC8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xC8"],
        ["\xD2\xC8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xC8"],

        ["\xD9\xC9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xC9"],
        ["\xD2\xC9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xC9"],

        ["\xD9\xD1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xCA"],
        ["\xD2\xCA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xD1"],

        ["\xD9\xD2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xCB"],
        ["\xD2\xCB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xD2"],

        ["\xD9\xD3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xCC"],
        ["\xD2\xCC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xD3"],

        ["\xD9\xD4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xCD"],
        ["\xD2\xCD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xD4"],

        ["\xD9\xD5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xCE"],
        ["\xD2\xCE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xD5"],

        ["\xD9\xD6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xCF"],
        ["\xD2\xCF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xD6"],

        ["\xD9\xD7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xD0"],
        ["\xD2\xD0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xD7"],

        ["\xD9\xD8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xD1"],
        ["\xD2\xD1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xD8"],

        ["\xD9\xD9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xD2"],
        ["\xD2\xD2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xD9"],

        ["\xD9\xE2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xD3"],
        ["\xD2\xD3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xE2"],

        ["\xD9\xE3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xD4"],
        ["\xD2\xD4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xE3"],

        ["\xD9\xE4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xD5"],
        ["\xD2\xD5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xE4"],

        ["\xD9\xE5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xD6"],
        ["\xD2\xD6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xE5"],

        ["\xD9\xE6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xD7"],
        ["\xD2\xD7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xE6"],

        ["\xD9\xE7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xD8"],
        ["\xD2\xD8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xE7"],

        ["\xD9\xE8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xD9"],
        ["\xD2\xD9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xE8"],

        ["\xD9\xE9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xDA"],
        ["\xD2\xDA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xE9"],

        ["\xD9\x4A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xDB"],
        ["\xD2\xDB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\x4A"],

        ["\xD9\x5B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xDC"],
        ["\xD2\xDC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\x5B"],

        ["\xD9\x5A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xDD"],
        ["\xD2\xDD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\x5A"],

        ["\xD9\x5F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xDE"],
        ["\xD2\xDE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\x5F"],

        ["\xD9\x6D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xDF"],
        ["\xD2\xDF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\x6D"],

        ["\xD9\x79",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xE0"],
        ["\xD2\xE0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\x79"],

        ["\xD9\x57",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xE1"],
        ["\xD2\xE1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\x57"],

        ["\xD9\x59",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xE2"],
        ["\xD2\xE2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\x59"],

        ["\xD9\x62",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xE3"],
        ["\xD2\xE3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\x62"],

        ["\xD9\x63",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xE4"],
        ["\xD2\xE4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\x63"],

        ["\xD9\x64",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xE5"],
        ["\xD2\xE5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\x64"],

        ["\xD9\x65",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xE6"],
        ["\xD2\xE6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\x65"],

        ["\xD9\x66",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xE7"],
        ["\xD2\xE7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\x66"],

        ["\xD9\x67",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xE8"],
        ["\xD2\xE8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\x67"],

        ["\xD9\x68",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xE9"],
        ["\xD2\xE9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\x68"],

        ["\xD9\x69",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xEA"],
        ["\xD2\xEA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\x69"],

        ["\xD9\x70",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xEB"],
        ["\xD2\xEB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\x70"],

        ["\xD9\x71",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xEC"],
        ["\xD2\xEC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\x71"],

        ["\xD9\x72",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xED"],
        ["\xD2\xED",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\x72"],

        ["\xD9\x73",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xEE"],
        ["\xD2\xEE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\x73"],

        ["\xD9\x74",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xEF"],
        ["\xD2\xEF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\x74"],

        ["\xD9\x75",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xF0"],
        ["\xD2\xF0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\x75"],

        ["\xD9\x76",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xF1"],
        ["\xD2\xF1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\x76"],

        ["\xD9\x77",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xF2"],
        ["\xD2\xF2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\x77"],

        ["\xD9\x78",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xF3"],
        ["\xD2\xF3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\x78"],

        ["\xD9\x80",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xF4"],
        ["\xD2\xF4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\x80"],

        ["\xD9\x8B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xF5"],
        ["\xD2\xF5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\x8B"],

        ["\xD9\x9B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xF6"],
        ["\xD2\xF6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\x9B"],

        ["\xD9\x9C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xF7"],
        ["\xD2\xF7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\x9C"],

        ["\xD9\xA0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xF8"],
        ["\xD2\xF8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xA0"],

        ["\xD9\xAB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xF9"],
        ["\xD2\xF9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xAB"],

        ["\xD9\xB0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xFA"],
        ["\xD2\xFA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xB0"],

        ["\xD9\xC0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xFB"],
        ["\xD2\xFB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xC0"],

        ["\xD9\x6A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xFC"],
        ["\xD2\xFC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\x6A"],

        ["\xD9\xD0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xFD"],
        ["\xD2\xFD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xD0"],

        ["\xD9\xA1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD2\xFE"],
        ["\xD2\xFE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xA1"],

        ["\xE2\x4F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xA1"],
        ["\xD3\xA1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\x4F"],

        ["\xE2\x7F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xA2"],
        ["\xD3\xA2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\x7F"],

        ["\xE2\x7B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xA3"],
        ["\xD3\xA3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\x7B"],

        ["\xE2\xE0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xA4"],
        ["\xD3\xA4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xE0"],

        ["\xE2\x6C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xA5"],
        ["\xD3\xA5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\x6C"],

        ["\xE2\x50",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xA6"],
        ["\xD3\xA6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\x50"],

        ["\xE2\x7D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xA7"],
        ["\xD3\xA7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\x7D"],

        ["\xE2\x4D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xA8"],
        ["\xD3\xA8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\x4D"],

        ["\xE2\x5D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xA9"],
        ["\xD3\xA9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\x5D"],

        ["\xE2\x5C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xAA"],
        ["\xD3\xAA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\x5C"],

        ["\xE2\x4E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xAB"],
        ["\xD3\xAB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\x4E"],

        ["\xE2\x6B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xAC"],
        ["\xD3\xAC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\x6B"],

        ["\xE2\x60",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xAD"],
        ["\xD3\xAD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\x60"],

        ["\xE2\x4B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xAE"],
        ["\xD3\xAE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\x4B"],

        ["\xE2\x61",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xAF"],
        ["\xD3\xAF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\x61"],

        ["\xE2\xF0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xB0"],
        ["\xD3\xB0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xF0"],

        ["\xE2\xF1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xB1"],
        ["\xD3\xB1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xF1"],

        ["\xE2\xF2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xB2"],
        ["\xD3\xB2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xF2"],

        ["\xE2\xF3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xB3"],
        ["\xD3\xB3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xF3"],

        ["\xE2\xF4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xB4"],
        ["\xD3\xB4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xF4"],

        ["\xE2\xF5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xB5"],
        ["\xD3\xB5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xF5"],

        ["\xE2\xF6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xB6"],
        ["\xD3\xB6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xF6"],

        ["\xE2\xF7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xB7"],
        ["\xD3\xB7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xF7"],

        ["\xE2\xF8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xB8"],
        ["\xD3\xB8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xF8"],

        ["\xE2\xF9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xB9"],
        ["\xD3\xB9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xF9"],

        ["\xE2\x7A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xBA"],
        ["\xD3\xBA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\x7A"],

        ["\xE2\x5E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xBB"],
        ["\xD3\xBB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\x5E"],

        ["\xE2\x4C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xBC"],
        ["\xD3\xBC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\x4C"],

        ["\xE2\x7E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xBD"],
        ["\xD3\xBD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\x7E"],

        ["\xE2\x6E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xBE"],
        ["\xD3\xBE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\x6E"],

        ["\xE2\x6F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xBF"],
        ["\xD3\xBF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\x6F"],

        ["\xE2\x7C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xC0"],
        ["\xD3\xC0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\x7C"],

        ["\xE2\xC1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xC1"],
        ["\xD3\xC1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xC1"],

        ["\xE2\xC2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xC2"],
        ["\xD3\xC2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xC2"],

        ["\xE2\xC3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xC3"],
        ["\xD3\xC3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xC3"],

        ["\xE2\xC4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xC4"],
        ["\xD3\xC4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xC4"],

        ["\xE2\xC5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xC5"],
        ["\xD3\xC5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xC5"],

        ["\xE2\xC6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xC6"],
        ["\xD3\xC6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xC6"],

        ["\xE2\xC7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xC7"],
        ["\xD3\xC7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xC7"],

        ["\xE2\xC8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xC8"],
        ["\xD3\xC8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xC8"],

        ["\xE2\xC9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xC9"],
        ["\xD3\xC9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xC9"],

        ["\xE2\xD1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xCA"],
        ["\xD3\xCA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xD1"],

        ["\xE2\xD2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xCB"],
        ["\xD3\xCB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xD2"],

        ["\xE2\xD3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xCC"],
        ["\xD3\xCC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xD3"],

        ["\xE2\xD4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xCD"],
        ["\xD3\xCD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xD4"],

        ["\xE2\xD5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xCE"],
        ["\xD3\xCE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xD5"],

        ["\xE2\xD6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xCF"],
        ["\xD3\xCF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xD6"],

        ["\xE2\xD7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xD0"],
        ["\xD3\xD0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xD7"],

        ["\xE2\xD8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xD1"],
        ["\xD3\xD1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xD8"],

        ["\xE2\xD9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xD2"],
        ["\xD3\xD2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xD9"],

        ["\xE2\xE2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xD3"],
        ["\xD3\xD3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xE2"],

        ["\xE2\xE3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xD4"],
        ["\xD3\xD4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xE3"],

        ["\xE2\xE4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xD5"],
        ["\xD3\xD5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xE4"],

        ["\xE2\xE5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xD6"],
        ["\xD3\xD6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xE5"],

        ["\xE2\xE6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xD7"],
        ["\xD3\xD7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xE6"],

        ["\xE2\xE7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xD8"],
        ["\xD3\xD8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xE7"],

        ["\xE2\xE8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xD9"],
        ["\xD3\xD9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xE8"],

        ["\xE2\xE9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xDA"],
        ["\xD3\xDA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xE9"],

        ["\xE2\x4A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xDB"],
        ["\xD3\xDB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\x4A"],

        ["\xE2\x5B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xDC"],
        ["\xD3\xDC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\x5B"],

        ["\xE2\x5A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xDD"],
        ["\xD3\xDD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\x5A"],

        ["\xE2\x5F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xDE"],
        ["\xD3\xDE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\x5F"],

        ["\xE2\x6D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xDF"],
        ["\xD3\xDF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\x6D"],

        ["\xE2\x79",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xE0"],
        ["\xD3\xE0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\x79"],

        ["\xE2\x57",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xE1"],
        ["\xD3\xE1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\x57"],

        ["\xE2\x59",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xE2"],
        ["\xD3\xE2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\x59"],

        ["\xE2\x62",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xE3"],
        ["\xD3\xE3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\x62"],

        ["\xE2\x63",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xE4"],
        ["\xD3\xE4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\x63"],

        ["\xE2\x64",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xE5"],
        ["\xD3\xE5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\x64"],

        ["\xE2\x65",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xE6"],
        ["\xD3\xE6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\x65"],

        ["\xE2\x66",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xE7"],
        ["\xD3\xE7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\x66"],

        ["\xE2\x67",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xE8"],
        ["\xD3\xE8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\x67"],

        ["\xE2\x68",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xE9"],
        ["\xD3\xE9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\x68"],

        ["\xE2\x69",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xEA"],
        ["\xD3\xEA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\x69"],

        ["\xE2\x70",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xEB"],
        ["\xD3\xEB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\x70"],

        ["\xE2\x71",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xEC"],
        ["\xD3\xEC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\x71"],

        ["\xE2\x72",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xED"],
        ["\xD3\xED",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\x72"],

        ["\xE2\x73",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xEE"],
        ["\xD3\xEE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\x73"],

        ["\xE2\x74",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xEF"],
        ["\xD3\xEF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\x74"],

        ["\xE2\x75",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xF0"],
        ["\xD3\xF0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\x75"],

        ["\xE2\x76",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xF1"],
        ["\xD3\xF1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\x76"],

        ["\xE2\x77",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xF2"],
        ["\xD3\xF2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\x77"],

        ["\xE2\x78",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xF3"],
        ["\xD3\xF3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\x78"],

        ["\xE2\x80",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xF4"],
        ["\xD3\xF4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\x80"],

        ["\xE2\x8B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xF5"],
        ["\xD3\xF5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\x8B"],

        ["\xE2\x9B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xF6"],
        ["\xD3\xF6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\x9B"],

        ["\xE2\x9C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xF7"],
        ["\xD3\xF7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\x9C"],

        ["\xE2\xA0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xF8"],
        ["\xD3\xF8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xA0"],

        ["\xE2\xAB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xF9"],
        ["\xD3\xF9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xAB"],

        ["\xE2\xB0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xFA"],
        ["\xD3\xFA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xB0"],

        ["\xE2\xC0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xFB"],
        ["\xD3\xFB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xC0"],

        ["\xE2\x6A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xFC"],
        ["\xD3\xFC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\x6A"],

        ["\xE2\xD0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xFD"],
        ["\xD3\xFD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xD0"],

        ["\xE2\xA1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD3\xFE"],
        ["\xD3\xFE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xA1"],

        ["\xE3\x4F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xA1"],
        ["\xD4\xA1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\x4F"],

        ["\xE3\x7F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xA2"],
        ["\xD4\xA2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\x7F"],

        ["\xE3\x7B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xA3"],
        ["\xD4\xA3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\x7B"],

        ["\xE3\xE0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xA4"],
        ["\xD4\xA4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xE0"],

        ["\xE3\x6C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xA5"],
        ["\xD4\xA5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\x6C"],

        ["\xE3\x50",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xA6"],
        ["\xD4\xA6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\x50"],

        ["\xE3\x7D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xA7"],
        ["\xD4\xA7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\x7D"],

        ["\xE3\x4D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xA8"],
        ["\xD4\xA8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\x4D"],

        ["\xE3\x5D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xA9"],
        ["\xD4\xA9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\x5D"],

        ["\xE3\x5C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xAA"],
        ["\xD4\xAA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\x5C"],

        ["\xE3\x4E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xAB"],
        ["\xD4\xAB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\x4E"],

        ["\xE3\x6B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xAC"],
        ["\xD4\xAC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\x6B"],

        ["\xE3\x60",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xAD"],
        ["\xD4\xAD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\x60"],

        ["\xE3\x4B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xAE"],
        ["\xD4\xAE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\x4B"],

        ["\xE3\x61",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xAF"],
        ["\xD4\xAF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\x61"],

        ["\xE3\xF0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xB0"],
        ["\xD4\xB0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xF0"],

        ["\xE3\xF1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xB1"],
        ["\xD4\xB1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xF1"],

        ["\xE3\xF2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xB2"],
        ["\xD4\xB2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xF2"],

        ["\xE3\xF3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xB3"],
        ["\xD4\xB3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xF3"],

        ["\xE3\xF4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xB4"],
        ["\xD4\xB4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xF4"],

        ["\xE3\xF5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xB5"],
        ["\xD4\xB5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xF5"],

        ["\xE3\xF6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xB6"],
        ["\xD4\xB6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xF6"],

        ["\xE3\xF7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xB7"],
        ["\xD4\xB7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xF7"],

        ["\xE3\xF8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xB8"],
        ["\xD4\xB8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xF8"],

        ["\xE3\xF9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xB9"],
        ["\xD4\xB9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xF9"],

        ["\xE3\x7A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xBA"],
        ["\xD4\xBA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\x7A"],

        ["\xE3\x5E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xBB"],
        ["\xD4\xBB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\x5E"],

        ["\xE3\x4C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xBC"],
        ["\xD4\xBC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\x4C"],

        ["\xE3\x7E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xBD"],
        ["\xD4\xBD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\x7E"],

        ["\xE3\x6E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xBE"],
        ["\xD4\xBE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\x6E"],

        ["\xE3\x6F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xBF"],
        ["\xD4\xBF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\x6F"],

        ["\xE3\x7C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xC0"],
        ["\xD4\xC0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\x7C"],

        ["\xE3\xC1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xC1"],
        ["\xD4\xC1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xC1"],

        ["\xE3\xC2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xC2"],
        ["\xD4\xC2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xC2"],

        ["\xE3\xC3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xC3"],
        ["\xD4\xC3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xC3"],

        ["\xE3\xC4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xC4"],
        ["\xD4\xC4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xC4"],

        ["\xE3\xC5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xC5"],
        ["\xD4\xC5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xC5"],

        ["\xE3\xC6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xC6"],
        ["\xD4\xC6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xC6"],

        ["\xE3\xC7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xC7"],
        ["\xD4\xC7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xC7"],

        ["\xE3\xC8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xC8"],
        ["\xD4\xC8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xC8"],

        ["\xE3\xC9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xC9"],
        ["\xD4\xC9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xC9"],

        ["\xE3\xD1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xCA"],
        ["\xD4\xCA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xD1"],

        ["\xE3\xD2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xCB"],
        ["\xD4\xCB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xD2"],

        ["\xE3\xD3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xCC"],
        ["\xD4\xCC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xD3"],

        ["\xE3\xD4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xCD"],
        ["\xD4\xCD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xD4"],

        ["\xE3\xD5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xCE"],
        ["\xD4\xCE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xD5"],

        ["\xE3\xD6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xCF"],
        ["\xD4\xCF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xD6"],

        ["\xE3\xD7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xD0"],
        ["\xD4\xD0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xD7"],

        ["\xE3\xD8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xD1"],
        ["\xD4\xD1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xD8"],

        ["\xE3\xD9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xD2"],
        ["\xD4\xD2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xD9"],

        ["\xE3\xE2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xD3"],
        ["\xD4\xD3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xE2"],

        ["\xE3\xE3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xD4"],
        ["\xD4\xD4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xE3"],

        ["\xE3\xE4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xD5"],
        ["\xD4\xD5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xE4"],

        ["\xE3\xE5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xD6"],
        ["\xD4\xD6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xE5"],

        ["\xE3\xE6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xD7"],
        ["\xD4\xD7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xE6"],

        ["\xE3\xE7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xD8"],
        ["\xD4\xD8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xE7"],

        ["\xE3\xE8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xD9"],
        ["\xD4\xD9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xE8"],

        ["\xE3\xE9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xDA"],
        ["\xD4\xDA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xE9"],

        ["\xE3\x4A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xDB"],
        ["\xD4\xDB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\x4A"],

        ["\xE3\x5B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xDC"],
        ["\xD4\xDC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\x5B"],

        ["\xE3\x5A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xDD"],
        ["\xD4\xDD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\x5A"],

        ["\xE3\x5F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xDE"],
        ["\xD4\xDE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\x5F"],

        ["\xE3\x6D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xDF"],
        ["\xD4\xDF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\x6D"],

        ["\xE3\x79",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xE0"],
        ["\xD4\xE0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\x79"],

        ["\xE3\x57",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xE1"],
        ["\xD4\xE1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\x57"],

        ["\xE3\x59",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xE2"],
        ["\xD4\xE2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\x59"],

        ["\xE3\x62",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xE3"],
        ["\xD4\xE3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\x62"],

        ["\xC4\x4A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xE4"],
        ["\xD4\xE4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\x4A"],

        ["\xE3\x64",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xE5"],
        ["\xD4\xE5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\x64"],

        ["\xE3\x65",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xE6"],
        ["\xD4\xE6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\x65"],

        ["\xE3\x66",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xE7"],
        ["\xD4\xE7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\x66"],

        ["\xE3\x67",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xE8"],
        ["\xD4\xE8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\x67"],

        ["\xE3\x68",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xE9"],
        ["\xD4\xE9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\x68"],

        ["\xE3\x69",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xEA"],
        ["\xD4\xEA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\x69"],

        ["\xE3\x70",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xEB"],
        ["\xD4\xEB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\x70"],

        ["\xE3\x71",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xEC"],
        ["\xD4\xEC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\x71"],

        ["\xE3\x72",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xED"],
        ["\xD4\xED",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\x72"],

        ["\xE3\x73",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xEE"],
        ["\xD4\xEE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\x73"],

        ["\xE3\x74",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xEF"],
        ["\xD4\xEF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\x74"],

        ["\xE3\x75",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xF0"],
        ["\xD4\xF0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\x75"],

        ["\xE3\x76",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xF1"],
        ["\xD4\xF1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\x76"],

        ["\xE3\x77",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xF2"],
        ["\xD4\xF2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\x77"],

        ["\xE3\x78",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xF3"],
        ["\xD4\xF3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\x78"],

        ["\xE3\x80",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xF4"],
        ["\xD4\xF4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\x80"],

        ["\xE3\x8B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xF5"],
        ["\xD4\xF5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\x8B"],

        ["\xE3\x9B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xF6"],
        ["\xD4\xF6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\x9B"],

        ["\xE3\x9C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xF7"],
        ["\xD4\xF7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\x9C"],

        ["\xE3\xA0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xF8"],
        ["\xD4\xF8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xA0"],

        ["\xE3\xAB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xF9"],
        ["\xD4\xF9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xAB"],

        ["\xE3\xB0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xFA"],
        ["\xD4\xFA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xB0"],

        ["\xE3\xC0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xFB"],
        ["\xD4\xFB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xC0"],

        ["\xE3\x6A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xFC"],
        ["\xD4\xFC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\x6A"],

        ["\xE3\xD0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xFD"],
        ["\xD4\xFD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xD0"],

        ["\xE3\xA1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\xFE"],
        ["\xD4\xFE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xA1"],

        ["\xE4\x4F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xA1"],
        ["\xD5\xA1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\x4F"],

        ["\xE4\x7F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xA2"],
        ["\xD5\xA2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\x7F"],

        ["\xE4\x7B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xA3"],
        ["\xD5\xA3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\x7B"],

        ["\xE4\xE0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xA4"],
        ["\xD5\xA4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xE0"],

        ["\xE4\x6C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xA5"],
        ["\xD5\xA5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\x6C"],

        ["\xE4\x50",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xA6"],
        ["\xD5\xA6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\x50"],

        ["\xE4\x7D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xA7"],
        ["\xD5\xA7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\x7D"],

        ["\xE4\x4D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xA8"],
        ["\xD5\xA8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\x4D"],

        ["\xE4\x5D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xA9"],
        ["\xD5\xA9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\x5D"],

        ["\xE4\x5C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xAA"],
        ["\xD5\xAA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\x5C"],

        ["\xE4\x4E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xAB"],
        ["\xD5\xAB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\x4E"],

        ["\xE4\x6B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xAC"],
        ["\xD5\xAC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\x6B"],

        ["\xE4\x60",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xAD"],
        ["\xD5\xAD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\x60"],

        ["\xE4\x4B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xAE"],
        ["\xD5\xAE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\x4B"],

        ["\xE4\x61",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xAF"],
        ["\xD5\xAF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\x61"],

        ["\xE4\xF0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xB0"],
        ["\xD5\xB0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xF0"],

        ["\xE4\xF1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xB1"],
        ["\xD5\xB1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xF1"],

        ["\xE4\xF2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xB2"],
        ["\xD5\xB2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xF2"],

        ["\xE4\xF3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xB3"],
        ["\xD5\xB3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xF3"],

        ["\xE4\xF4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xB4"],
        ["\xD5\xB4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xF4"],

        ["\xE4\xF5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xB5"],
        ["\xD5\xB5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xF5"],

        ["\xE4\xF6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xB6"],
        ["\xD5\xB6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xF6"],

        ["\xE4\xF7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xB7"],
        ["\xD5\xB7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xF7"],

        ["\xE4\xF8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xB8"],
        ["\xD5\xB8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xF8"],

        ["\xE4\xF9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xB9"],
        ["\xD5\xB9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xF9"],

        ["\xE4\x7A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xBA"],
        ["\xD5\xBA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\x7A"],

        ["\xE4\x5E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xBB"],
        ["\xD5\xBB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\x5E"],

        ["\xE4\x4C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xBC"],
        ["\xD5\xBC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\x4C"],

        ["\xE4\x7E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xBD"],
        ["\xD5\xBD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\x7E"],

        ["\xE4\x6E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xBE"],
        ["\xD5\xBE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\x6E"],

        ["\xE4\x6F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xBF"],
        ["\xD5\xBF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\x6F"],

        ["\xE4\x7C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xC0"],
        ["\xD5\xC0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\x7C"],

        ["\xE4\xC1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xC1"],
        ["\xD5\xC1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xC1"],

        ["\xE4\xC2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xC2"],
        ["\xD5\xC2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xC2"],

        ["\xE4\xC3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xC3"],
        ["\xD5\xC3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xC3"],

        ["\xE4\xC4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xC4"],
        ["\xD5\xC4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xC4"],

        ["\xE4\xC5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xC5"],
        ["\xD5\xC5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xC5"],

        ["\xE4\xC6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xC6"],
        ["\xD5\xC6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xC6"],

        ["\xE4\xC7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xC7"],
        ["\xD5\xC7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xC7"],

        ["\xE4\xC8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xC8"],
        ["\xD5\xC8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xC8"],

        ["\xE4\xC9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xC9"],
        ["\xD5\xC9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xC9"],

        ["\xE4\xD1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xCA"],
        ["\xD5\xCA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xD1"],

        ["\xE4\xD2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xCB"],
        ["\xD5\xCB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xD2"],

        ["\xE4\xD3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xCC"],
        ["\xD5\xCC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xD3"],

        ["\xE4\xD4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xCD"],
        ["\xD5\xCD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xD4"],

        ["\xE4\xD5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xCE"],
        ["\xD5\xCE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xD5"],

        ["\xE4\xD6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xCF"],
        ["\xD5\xCF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xD6"],

        ["\xE4\xD7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xD0"],
        ["\xD5\xD0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xD7"],

        ["\xE4\xD8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xD1"],
        ["\xD5\xD1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xD8"],

        ["\xE4\xD9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xD2"],
        ["\xD5\xD2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xD9"],

        ["\xE4\xE2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xD3"],
        ["\xD5\xD3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xE2"],

        ["\xE4\xE3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xD4"],
        ["\xD5\xD4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xE3"],

        ["\xE4\xE4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xD5"],
        ["\xD5\xD5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xE4"],

        ["\xE4\xE5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xD6"],
        ["\xD5\xD6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xE5"],

        ["\xE4\xE6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xD7"],
        ["\xD5\xD7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xE6"],

        ["\xE4\xE7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xD8"],
        ["\xD5\xD8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xE7"],

        ["\xE4\xE8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xD9"],
        ["\xD5\xD9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xE8"],

        ["\xE4\xE9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xDA"],
        ["\xD5\xDA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xE9"],

        ["\xE4\x4A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xDB"],
        ["\xD5\xDB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\x4A"],

        ["\xE4\x5B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xDC"],
        ["\xD5\xDC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\x5B"],

        ["\xE4\x5A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xDD"],
        ["\xD5\xDD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\x5A"],

        ["\xE4\x5F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xDE"],
        ["\xD5\xDE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\x5F"],

        ["\xE4\x6D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xDF"],
        ["\xD5\xDF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\x6D"],

        ["\xE4\x79",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xE0"],
        ["\xD5\xE0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\x79"],

        ["\xE4\x57",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xE1"],
        ["\xD5\xE1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\x57"],

        ["\xE4\x59",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xE2"],
        ["\xD5\xE2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\x59"],

        ["\xE4\x62",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xE3"],
        ["\xD5\xE3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\x62"],

        ["\xE4\x63",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xE4"],
        ["\xD5\xE4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\x63"],

        ["\xE4\x64",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xE5"],
        ["\xD5\xE5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\x64"],

        ["\xE4\x65",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xE6"],
        ["\xD5\xE6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\x65"],

        ["\xE4\x66",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xE7"],
        ["\xD5\xE7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\x66"],

        ["\xE4\x67",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xE8"],
        ["\xD5\xE8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\x67"],

        ["\xE4\x68",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xE9"],
        ["\xD5\xE9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\x68"],

        ["\xE4\x69",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xEA"],
        ["\xD5\xEA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\x69"],

        ["\xE4\x70",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xEB"],
        ["\xD5\xEB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\x70"],

        ["\xE4\x71",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xEC"],
        ["\xD5\xEC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\x71"],

        ["\xE4\x72",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xED"],
        ["\xD5\xED",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\x72"],

        ["\xE4\x73",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xEE"],
        ["\xD5\xEE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\x73"],

        ["\xE4\x74",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xEF"],
        ["\xD5\xEF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\x74"],

        ["\xE4\x75",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xF0"],
        ["\xD5\xF0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\x75"],

        ["\xE4\x76",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xF1"],
        ["\xD5\xF1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\x76"],

        ["\xE4\x77",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xF2"],
        ["\xD5\xF2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\x77"],

        ["\xE4\x78",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xF3"],
        ["\xD5\xF3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\x78"],

        ["\xE4\x80",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xF4"],
        ["\xD5\xF4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\x80"],

        ["\xE4\x8B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xF5"],
        ["\xD5\xF5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\x8B"],

        ["\xE4\x9B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xF6"],
        ["\xD5\xF6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\x9B"],

        ["\xE4\x9C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xF7"],
        ["\xD5\xF7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\x9C"],

        ["\xE4\xA0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xF8"],
        ["\xD5\xF8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xA0"],

        ["\xE4\xAB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xF9"],
        ["\xD5\xF9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xAB"],

        ["\xE4\xB0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xFA"],
        ["\xD5\xFA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xB0"],

        ["\xE4\xC0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xFB"],
        ["\xD5\xFB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xC0"],

        ["\xE4\x6A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xFC"],
        ["\xD5\xFC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\x6A"],

        ["\xE4\xD0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xFD"],
        ["\xD5\xFD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xD0"],

        ["\xE4\xA1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD5\xFE"],
        ["\xD5\xFE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xA1"],

        ["\xE5\x4F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xA1"],
        ["\xD6\xA1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\x4F"],

        ["\xE5\x7F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xA2"],
        ["\xD6\xA2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\x7F"],

        ["\xE5\x7B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xA3"],
        ["\xD6\xA3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\x7B"],

        ["\xE5\xE0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xA4"],
        ["\xD6\xA4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xE0"],

        ["\xE5\x6C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xA5"],
        ["\xD6\xA5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\x6C"],

        ["\xE5\x50",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xA6"],
        ["\xD6\xA6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\x50"],

        ["\xE5\x7D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xA7"],
        ["\xD6\xA7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\x7D"],

        ["\xE5\x4D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xA8"],
        ["\xD6\xA8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\x4D"],

        ["\xE5\x5D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xA9"],
        ["\xD6\xA9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\x5D"],

        ["\xE5\x5C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xAA"],
        ["\xD6\xAA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\x5C"],

        ["\xE5\x4E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xAB"],
        ["\xD6\xAB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\x4E"],

        ["\xE5\x6B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xAC"],
        ["\xD6\xAC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\x6B"],

        ["\xE5\x60",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xAD"],
        ["\xD6\xAD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\x60"],

        ["\xE5\x4B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xAE"],
        ["\xD6\xAE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\x4B"],

        ["\xE5\x61",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xAF"],
        ["\xD6\xAF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\x61"],

        ["\xE5\xF0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xB0"],
        ["\xD6\xB0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xF0"],

        ["\xE5\xF1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xB1"],
        ["\xD6\xB1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xF1"],

        ["\xE5\xF2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xB2"],
        ["\xD6\xB2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xF2"],

        ["\xE5\xF3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xB3"],
        ["\xD6\xB3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xF3"],

        ["\xE5\xF4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xB4"],
        ["\xD6\xB4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xF4"],

        ["\xE5\xF5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xB5"],
        ["\xD6\xB5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xF5"],

        ["\xE5\xF6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xB6"],
        ["\xD6\xB6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xF6"],

        ["\xE5\xF7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xB7"],
        ["\xD6\xB7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xF7"],

        ["\xE5\xF8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xB8"],
        ["\xD6\xB8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xF8"],

        ["\xE5\xF9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xB9"],
        ["\xD6\xB9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xF9"],

        ["\xE5\x7A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xBA"],
        ["\xD6\xBA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\x7A"],

        ["\xE5\x5E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xBB"],
        ["\xD6\xBB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\x5E"],

        ["\xE5\x4C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xBC"],
        ["\xD6\xBC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\x4C"],

        ["\xE5\x7E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xBD"],
        ["\xD6\xBD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\x7E"],

        ["\xE5\x6E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xBE"],
        ["\xD6\xBE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\x6E"],

        ["\xE5\x6F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xBF"],
        ["\xD6\xBF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\x6F"],

        ["\xE5\x7C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xC0"],
        ["\xD6\xC0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\x7C"],

        ["\xE5\xC1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xC1"],
        ["\xD6\xC1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xC1"],

        ["\xE5\xC2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xC2"],
        ["\xD6\xC2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xC2"],

        ["\xE5\xC3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xC3"],
        ["\xD6\xC3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xC3"],

        ["\xE5\xC4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xC4"],
        ["\xD6\xC4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xC4"],

        ["\xE5\xC5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xC5"],
        ["\xD6\xC5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xC5"],

        ["\xE5\xC6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xC6"],
        ["\xD6\xC6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xC6"],

        ["\xE5\xC7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xC7"],
        ["\xD6\xC7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xC7"],

        ["\xE5\xC8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xC8"],
        ["\xD6\xC8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xC8"],

        ["\xE5\xC9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xC9"],
        ["\xD6\xC9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xC9"],

        ["\xE5\xD1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xCA"],
        ["\xD6\xCA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xD1"],

        ["\xE5\xD2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xCB"],
        ["\xD6\xCB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xD2"],

        ["\xE5\xD3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xCC"],
        ["\xD6\xCC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xD3"],

        ["\xE5\xD4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xCD"],
        ["\xD6\xCD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xD4"],

        ["\xE5\xD5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xCE"],
        ["\xD6\xCE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xD5"],

        ["\xE5\xD6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xCF"],
        ["\xD6\xCF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xD6"],

        ["\xE5\xD7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xD0"],
        ["\xD6\xD0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xD7"],

        ["\xE5\xD8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xD1"],
        ["\xD6\xD1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xD8"],

        ["\xE5\xD9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xD2"],
        ["\xD6\xD2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xD9"],

        ["\xE5\xE2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xD3"],
        ["\xD6\xD3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xE2"],

        ["\xE5\xE3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xD4"],
        ["\xD6\xD4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xE3"],

        ["\xE5\xE4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xD5"],
        ["\xD6\xD5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xE4"],

        ["\xE5\xE5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xD6"],
        ["\xD6\xD6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xE5"],

        ["\xE5\xE6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xD7"],
        ["\xD6\xD7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xE6"],

        ["\xE5\xE7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xD8"],
        ["\xD6\xD8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xE7"],

        ["\xE5\xE8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xD9"],
        ["\xD6\xD9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xE8"],

        ["\xE5\xE9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xDA"],
        ["\xD6\xDA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xE9"],

        ["\xE5\x4A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xDB"],
        ["\xD6\xDB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\x4A"],

        ["\xE5\x5B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xDC"],
        ["\xD6\xDC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\x5B"],

        ["\xE5\x5A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xDD"],
        ["\xD6\xDD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\x5A"],

        ["\xE5\x5F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xDE"],
        ["\xD6\xDE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\x5F"],

        ["\xE5\x6D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xDF"],
        ["\xD6\xDF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\x6D"],

        ["\xE5\x79",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xE0"],
        ["\xD6\xE0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\x79"],

        ["\xE5\x57",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xE1"],
        ["\xD6\xE1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\x57"],

        ["\xE5\x59",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xE2"],
        ["\xD6\xE2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\x59"],

        ["\xE5\x62",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xE3"],
        ["\xD6\xE3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\x62"],

        ["\xE5\x63",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xE4"],
        ["\xD6\xE4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\x63"],

        ["\xE5\x64",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xE5"],
        ["\xD6\xE5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\x64"],

        ["\xE5\x65",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xE6"],
        ["\xD6\xE6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\x65"],

        ["\xE5\x66",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xE7"],
        ["\xD6\xE7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\x66"],

        ["\xE5\x67",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xE8"],
        ["\xD6\xE8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\x67"],

        ["\xE5\x68",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xE9"],
        ["\xD6\xE9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\x68"],

        ["\xE5\x69",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xEA"],
        ["\xD6\xEA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\x69"],

        ["\xE5\x70",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xEB"],
        ["\xD6\xEB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\x70"],

        ["\xE5\x71",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xEC"],
        ["\xD6\xEC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\x71"],

        ["\xE5\x72",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xED"],
        ["\xD6\xED",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\x72"],

        ["\xE5\x73",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xEE"],
        ["\xD6\xEE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\x73"],

        ["\xE5\x74",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xEF"],
        ["\xD6\xEF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\x74"],

        ["\xE5\x75",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xF0"],
        ["\xD6\xF0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\x75"],

        ["\xE5\x76",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xF1"],
        ["\xD6\xF1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\x76"],

        ["\xE5\x77",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xF2"],
        ["\xD6\xF2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\x77"],

        ["\xE5\x78",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xF3"],
        ["\xD6\xF3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\x78"],

        ["\xE5\x80",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xF4"],
        ["\xD6\xF4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\x80"],

        ["\xE5\x8B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xF5"],
        ["\xD6\xF5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B"],

        ["\xE5\x9B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xF6"],
        ["\xD6\xF6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B"],

        ["\xE5\x9C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xF7"],
        ["\xD6\xF7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C"],

        ["\xE5\xA0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xF8"],
        ["\xD6\xF8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xA0"],

        ["\xE5\xAB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xF9"],
        ["\xD6\xF9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xAB"],

        ["\xE5\xB0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xFA"],
        ["\xD6\xFA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0"],

        ["\xE5\xC0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xFB"],
        ["\xD6\xFB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xC0"],

        ["\xE5\x6A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xFC"],
        ["\xD6\xFC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\x6A"],

        ["\xE5\xD0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xFD"],
        ["\xD6\xFD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xD0"],

        ["\xE5\xA1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD6\xFE"],
        ["\xD6\xFE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xA1"],

        ["\xE6\x4F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xA1"],
        ["\xD7\xA1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\x4F"],

        ["\xE6\x7F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xA2"],
        ["\xD7\xA2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\x7F"],

        ["\xE6\x7B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xA3"],
        ["\xD7\xA3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\x7B"],

        ["\xE6\xE0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xA4"],
        ["\xD7\xA4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xE0"],

        ["\xE6\x6C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xA5"],
        ["\xD7\xA5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\x6C"],

        ["\xE6\x50",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xA6"],
        ["\xD7\xA6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\x50"],

        ["\xE6\x7D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xA7"],
        ["\xD7\xA7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\x7D"],

        ["\xE6\x4D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xA8"],
        ["\xD7\xA8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\x4D"],

        ["\xE6\x5D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xA9"],
        ["\xD7\xA9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\x5D"],

        ["\xE6\x5C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xAA"],
        ["\xD7\xAA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\x5C"],

        ["\xE6\x4E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xAB"],
        ["\xD7\xAB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\x4E"],

        ["\xE6\x6B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xAC"],
        ["\xD7\xAC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\x6B"],

        ["\xE6\x60",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xAD"],
        ["\xD7\xAD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\x60"],

        ["\xE6\x4B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xAE"],
        ["\xD7\xAE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\x4B"],

        ["\xE6\x61",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xAF"],
        ["\xD7\xAF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\x61"],

        ["\xE6\xF0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xB0"],
        ["\xD7\xB0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xF0"],

        ["\xE6\xF1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xB1"],
        ["\xD7\xB1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xF1"],

        ["\xE6\xF2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xB2"],
        ["\xD7\xB2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xF2"],

        ["\xE6\xF3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xB3"],
        ["\xD7\xB3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xF3"],

        ["\xE6\xF4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xB4"],
        ["\xD7\xB4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xF4"],

        ["\xE6\xF5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xB5"],
        ["\xD7\xB5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xF5"],

        ["\xE6\xF6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xB6"],
        ["\xD7\xB6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xF6"],

        ["\xE6\xF7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xB7"],
        ["\xD7\xB7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xF7"],

        ["\xE6\xF8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xB8"],
        ["\xD7\xB8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xF8"],

        ["\xE6\xF9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xB9"],
        ["\xD7\xB9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xF9"],

        ["\xE6\x7A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xBA"],
        ["\xD7\xBA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\x7A"],

        ["\xE6\x4C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xBC"],
        ["\xD7\xBC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\x4C"],

        ["\xE6\x7E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xBD"],
        ["\xD7\xBD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\x7E"],

        ["\xE6\x6E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xBE"],
        ["\xD7\xBE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\x6E"],

        ["\xE6\x6F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xBF"],
        ["\xD7\xBF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\x6F"],

        ["\xE6\x7C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xC0"],
        ["\xD7\xC0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\x7C"],

        ["\xE6\xC1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xC1"],
        ["\xD7\xC1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xC1"],

        ["\xE6\xC2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xC2"],
        ["\xD7\xC2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xC2"],

        ["\xE6\xC3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xC3"],
        ["\xD7\xC3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xC3"],

        ["\xE6\xC4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xC4"],
        ["\xD7\xC4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xC4"],

        ["\xE6\xC5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xC5"],
        ["\xD7\xC5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xC5"],

        ["\xE6\xC6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xC6"],
        ["\xD7\xC6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xC6"],

        ["\xE6\xC7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xC7"],
        ["\xD7\xC7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xC7"],

        ["\xE6\xC8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xC8"],
        ["\xD7\xC8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xC8"],

        ["\xE6\xC9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xC9"],
        ["\xD7\xC9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xC9"],

        ["\xE6\xD1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xCA"],
        ["\xD7\xCA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xD1"],

        ["\xE6\xD2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xCB"],
        ["\xD7\xCB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xD2"],

        ["\xE6\xD3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xCC"],
        ["\xD7\xCC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xD3"],

        ["\xE6\xD4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xCD"],
        ["\xD7\xCD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xD4"],

        ["\xE6\xD5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xCE"],
        ["\xD7\xCE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xD5"],

        ["\xE6\xD6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xCF"],
        ["\xD7\xCF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xD6"],

        ["\xE6\xD7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xD0"],
        ["\xD7\xD0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xD7"],

        ["\xE6\xD8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xD1"],
        ["\xD7\xD1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xD8"],

        ["\xE6\xD9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xD2"],
        ["\xD7\xD2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xD9"],

        ["\xE6\xE2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xD3"],
        ["\xD7\xD3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xE2"],

        ["\xE6\xE3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xD4"],
        ["\xD7\xD4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xE3"],

        ["\xE6\xE4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xD5"],
        ["\xD7\xD5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xE4"],

        ["\xE6\xE5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xD6"],
        ["\xD7\xD6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xE5"],

        ["\xE6\xE6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xD7"],
        ["\xD7\xD7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xE6"],

        ["\xE6\xE7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xD8"],
        ["\xD7\xD8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xE7"],

        ["\xE6\xE8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xD9"],
        ["\xD7\xD9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xE8"],

        ["\xE6\xE9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xDA"],
        ["\xD7\xDA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xE9"],

        ["\xE6\x4A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xDB"],
        ["\xD7\xDB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\x4A"],

        ["\xE6\x5B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xDC"],
        ["\xD7\xDC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\x5B"],

        ["\xE6\x5A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xDD"],
        ["\xD7\xDD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\x5A"],

        ["\xE6\x5F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xDE"],
        ["\xD7\xDE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\x5F"],

        ["\xE6\x6D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xDF"],
        ["\xD7\xDF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\x6D"],

        ["\xE6\x79",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xE0"],
        ["\xD7\xE0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\x79"],

        ["\xE6\x57",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xE1"],
        ["\xD7\xE1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\x57"],

        ["\xE6\x59",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xE2"],
        ["\xD7\xE2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\x59"],

        ["\xE6\x62",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xE3"],
        ["\xD7\xE3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\x62"],

        ["\xE6\x63",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xE4"],
        ["\xD7\xE4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\x63"],

        ["\xE6\x64",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xE5"],
        ["\xD7\xE5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\x64"],

        ["\xE6\x65",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xE6"],
        ["\xD7\xE6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\x65"],

        ["\xE6\x66",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xE7"],
        ["\xD7\xE7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\x66"],

        ["\xE6\x67",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xE8"],
        ["\xD7\xE8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\x67"],

        ["\xE6\x68",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xE9"],
        ["\xD7\xE9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\x68"],

        ["\xE6\x69",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xEA"],
        ["\xD7\xEA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\x69"],

        ["\xE6\x70",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xEB"],
        ["\xD7\xEB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\x70"],

        ["\xE6\x71",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xEC"],
        ["\xD7\xEC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\x71"],

        ["\xE6\x72",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xED"],
        ["\xD7\xED",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\x72"],

        ["\xE6\x73",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xEE"],
        ["\xD7\xEE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\x73"],

        ["\xE6\x74",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xEF"],
        ["\xD7\xEF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\x74"],

        ["\xE6\x75",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xF0"],
        ["\xD7\xF0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\x75"],

        ["\xE6\x76",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xF1"],
        ["\xD7\xF1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\x76"],

        ["\xE6\x77",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xF2"],
        ["\xD7\xF2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\x77"],

        ["\xE6\x78",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xF3"],
        ["\xD7\xF3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\x78"],

        ["\xE6\x80",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xF4"],
        ["\xD7\xF4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\x80"],

        ["\xE6\x8B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xF5"],
        ["\xD7\xF5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B"],

        ["\xE6\x9B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xF6"],
        ["\xD7\xF6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B"],

        ["\xE6\x9C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xF7"],
        ["\xD7\xF7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C"],

        ["\xE6\xA0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xF8"],
        ["\xD7\xF8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xA0"],

        ["\xE6\xAB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xF9"],
        ["\xD7\xF9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xAB"],

        ["\xE6\xB0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xFA"],
        ["\xD7\xFA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xB0"],

        ["\xE6\xC0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xFB"],
        ["\xD7\xFB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xC0"],

        ["\xE6\x6A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xFC"],
        ["\xD7\xFC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\x6A"],

        ["\xE6\xD0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xFD"],
        ["\xD7\xFD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xD0"],

        ["\xE6\xA1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD7\xFE"],
        ["\xD7\xFE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1"],

        ["\xE7\x4F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xA1"],
        ["\xD8\xA1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\x4F"],

        ["\xE7\x7F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xA2"],
        ["\xD8\xA2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\x7F"],

        ["\xE7\x7B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xA3"],
        ["\xD8\xA3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\x7B"],

        ["\xE7\xE0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xA4"],
        ["\xD8\xA4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xE0"],

        ["\xE7\x6C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xA5"],
        ["\xD8\xA5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\x6C"],

        ["\xE7\x50",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xA6"],
        ["\xD8\xA6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\x50"],

        ["\xE7\x7D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xA7"],
        ["\xD8\xA7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\x7D"],

        ["\xE7\x4D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xA8"],
        ["\xD8\xA8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\x4D"],

        ["\xE7\x5D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xA9"],
        ["\xD8\xA9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\x5D"],

        ["\xE7\x5C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xAA"],
        ["\xD8\xAA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\x5C"],

        ["\xE7\x4E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xAB"],
        ["\xD8\xAB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\x4E"],

        ["\xE7\x6B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xAC"],
        ["\xD8\xAC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\x6B"],

        ["\xE7\x60",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xAD"],
        ["\xD8\xAD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\x60"],

        ["\xE7\x4B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xAE"],
        ["\xD8\xAE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\x4B"],

        ["\xE7\x61",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xAF"],
        ["\xD8\xAF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\x61"],

        ["\xE7\xF0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xB0"],
        ["\xD8\xB0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xF0"],

        ["\xE7\xF1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xB1"],
        ["\xD8\xB1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xF1"],

        ["\xE7\xF2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xB2"],
        ["\xD8\xB2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xF2"],

        ["\xE7\xF3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xB3"],
        ["\xD8\xB3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xF3"],

        ["\xE7\xF4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xB4"],
        ["\xD8\xB4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xF4"],

        ["\xE7\xF5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xB5"],
        ["\xD8\xB5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xF5"],

        ["\xE7\xF6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xB6"],
        ["\xD8\xB6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xF6"],

        ["\xE7\xF7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xB7"],
        ["\xD8\xB7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xF7"],

        ["\xE7\xF8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xB8"],
        ["\xD8\xB8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xF8"],

        ["\xE7\xF9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xB9"],
        ["\xD8\xB9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xF9"],

        ["\xE7\x7A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xBA"],
        ["\xD8\xBA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\x7A"],

        ["\xE7\x5E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xBB"],
        ["\xD8\xBB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\x5E"],

        ["\xE7\x4C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xBC"],
        ["\xD8\xBC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\x4C"],

        ["\xE7\x7E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xBD"],
        ["\xD8\xBD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\x7E"],

        ["\xE7\x6E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xBE"],
        ["\xD8\xBE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\x6E"],

        ["\xE7\x6F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xBF"],
        ["\xD8\xBF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\x6F"],

        ["\xE7\x7C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xC0"],
        ["\xD8\xC0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\x7C"],

        ["\xE7\xC1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xC1"],
        ["\xD8\xC1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xC1"],

        ["\xE7\xC2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xC2"],
        ["\xD8\xC2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xC2"],

        ["\xE7\xC3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xC3"],
        ["\xD8\xC3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xC3"],

        ["\xE7\xC4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xC4"],
        ["\xD8\xC4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xC4"],

        ["\xE7\xC5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xC5"],
        ["\xD8\xC5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xC5"],

        ["\xE7\xC6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xC6"],
        ["\xD8\xC6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xC6"],

        ["\xE7\xC7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xC7"],
        ["\xD8\xC7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xC7"],

        ["\xE7\xC8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xC8"],
        ["\xD8\xC8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xC8"],

        ["\xE7\xC9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xC9"],
        ["\xD8\xC9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xC9"],

        ["\xE7\xD1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xCA"],
        ["\xD8\xCA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xD1"],

        ["\xE7\xD2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xCB"],
        ["\xD8\xCB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xD2"],

        ["\xE7\xD3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xCC"],
        ["\xD8\xCC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xD3"],

        ["\xE7\xD4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xCD"],
        ["\xD8\xCD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xD4"],

        ["\xE7\xD5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xCE"],
        ["\xD8\xCE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xD5"],

        ["\xE7\xD6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xCF"],
        ["\xD8\xCF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xD6"],

        ["\xE7\xD7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xD0"],
        ["\xD8\xD0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xD7"],

        ["\xE7\xD8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xD1"],
        ["\xD8\xD1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xD8"],

        ["\xE7\xD9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xD2"],
        ["\xD8\xD2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xD9"],

        ["\xE7\xE2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xD3"],
        ["\xD8\xD3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xE2"],

        ["\xE7\xE3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xD4"],
        ["\xD8\xD4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xE3"],

        ["\xE7\xE4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xD5"],
        ["\xD8\xD5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xE4"],

        ["\xE7\xE5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xD6"],
        ["\xD8\xD6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xE5"],

        ["\xE7\xE6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xD7"],
        ["\xD8\xD7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xE6"],

        ["\xE7\xE7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xD8"],
        ["\xD8\xD8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xE7"],

        ["\xE7\xE8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xD9"],
        ["\xD8\xD9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xE8"],

        ["\xE7\xE9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xDA"],
        ["\xD8\xDA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xE9"],

        ["\xE7\x4A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xDB"],
        ["\xD8\xDB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\x4A"],

        ["\xE7\x5B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xDC"],
        ["\xD8\xDC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\x5B"],

        ["\xE7\x5A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xDD"],
        ["\xD8\xDD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\x5A"],

        ["\xE7\x5F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xDE"],
        ["\xD8\xDE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\x5F"],

        ["\xE7\x6D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xDF"],
        ["\xD8\xDF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\x6D"],

        ["\xE7\x79",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xE0"],
        ["\xD8\xE0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\x79"],

        ["\xE7\x57",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xE1"],
        ["\xD8\xE1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\x57"],

        ["\xE7\x59",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xE2"],
        ["\xD8\xE2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\x59"],

        ["\xE7\x62",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xE3"],
        ["\xD8\xE3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\x62"],

        ["\xE7\x63",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xE4"],
        ["\xD8\xE4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\x63"],

        ["\xE7\x64",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xE5"],
        ["\xD8\xE5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\x64"],

        ["\xE7\x65",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xE6"],
        ["\xD8\xE6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\x65"],

        ["\xE7\x66",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xE7"],
        ["\xD8\xE7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\x66"],

        ["\xE7\x67",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xE8"],
        ["\xD8\xE8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\x67"],

        ["\xE7\x68",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xE9"],
        ["\xD8\xE9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\x68"],

        ["\xE7\x69",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xEA"],
        ["\xD8\xEA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\x69"],

        ["\xE7\x70",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xEB"],
        ["\xD8\xEB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\x70"],

        ["\xE7\x71",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xEC"],
        ["\xD8\xEC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\x71"],

        ["\xE7\x72",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xED"],
        ["\xD8\xED",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\x72"],

        ["\xE7\x73",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xEE"],
        ["\xD8\xEE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\x73"],

        ["\xE7\x74",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xEF"],
        ["\xD8\xEF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\x74"],

        ["\xE7\x75",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xF0"],
        ["\xD8\xF0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\x75"],

        ["\xE7\x76",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xF1"],
        ["\xD8\xF1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\x76"],

        ["\xE7\x77",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xF2"],
        ["\xD8\xF2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\x77"],

        ["\xE7\x78",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xF3"],
        ["\xD8\xF3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\x78"],

        ["\xE7\x80",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xF4"],
        ["\xD8\xF4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\x80"],

        ["\xE7\x8B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xF5"],
        ["\xD8\xF5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\x8B"],

        ["\xE7\x9B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xF6"],
        ["\xD8\xF6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B"],

        ["\xE7\x9C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xF7"],
        ["\xD8\xF7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\x9C"],

        ["\xE7\xA0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xF8"],
        ["\xD8\xF8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xA0"],

        ["\xE7\xAB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xF9"],
        ["\xD8\xF9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB"],

        ["\xE7\xB0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xFA"],
        ["\xD8\xFA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xB0"],

        ["\xE7\xC0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xFB"],
        ["\xD8\xFB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xC0"],

        ["\xE7\x6A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xFC"],
        ["\xD8\xFC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\x6A"],

        ["\xE7\xD0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xFD"],
        ["\xD8\xFD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xD0"],

        ["\xE7\xA1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD8\xFE"],
        ["\xD8\xFE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xA1"],

        ["\xE8\x4F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xA1"],
        ["\xD9\xA1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\x4F"],

        ["\xE8\x7F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xA2"],
        ["\xD9\xA2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\x7F"],

        ["\xE8\x7B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xA3"],
        ["\xD9\xA3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\x7B"],

        ["\xE8\xE0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xA4"],
        ["\xD9\xA4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xE0"],

        ["\xE8\x6C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xA5"],
        ["\xD9\xA5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\x6C"],

        ["\xE8\x50",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xA6"],
        ["\xD9\xA6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\x50"],

        ["\xE8\x7D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xA7"],
        ["\xD9\xA7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\x7D"],

        ["\xE8\x4D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xA8"],
        ["\xD9\xA8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\x4D"],

        ["\xE8\x5D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xA9"],
        ["\xD9\xA9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\x5D"],

        ["\xE8\x5C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xAA"],
        ["\xD9\xAA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\x5C"],

        ["\xE8\x4E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xAB"],
        ["\xD9\xAB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\x4E"],

        ["\xE8\x6B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xAC"],
        ["\xD9\xAC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\x6B"],

        ["\xE8\x60",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xAD"],
        ["\xD9\xAD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\x60"],

        ["\xE8\x4B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xAE"],
        ["\xD9\xAE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\x4B"],

        ["\xE8\x61",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xAF"],
        ["\xD9\xAF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\x61"],

        ["\xE8\xF0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xB0"],
        ["\xD9\xB0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xF0"],

        ["\xE8\xF1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xB1"],
        ["\xD9\xB1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xF1"],

        ["\xE8\xF2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xB2"],
        ["\xD9\xB2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xF2"],

        ["\xE8\xF3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xB3"],
        ["\xD9\xB3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xF3"],

        ["\xE8\xF4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xB4"],
        ["\xD9\xB4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xF4"],

        ["\xE8\xF5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xB5"],
        ["\xD9\xB5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xF5"],

        ["\xE8\xF6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xB6"],
        ["\xD9\xB6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xF6"],

        ["\xE8\xF7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xB7"],
        ["\xD9\xB7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xF7"],

        ["\xE8\xF8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xB8"],
        ["\xD9\xB8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xF8"],

        ["\xE8\xF9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xB9"],
        ["\xD9\xB9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xF9"],

        ["\xE8\x7A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xBA"],
        ["\xD9\xBA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\x7A"],

        ["\xE8\x5E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xBB"],
        ["\xD9\xBB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\x5E"],

        ["\xE8\x4C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xBC"],
        ["\xD9\xBC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\x4C"],

        ["\xE8\x7E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xBD"],
        ["\xD9\xBD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\x7E"],

        ["\xE8\x6E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xBE"],
        ["\xD9\xBE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\x6E"],

        ["\xE8\x6F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xBF"],
        ["\xD9\xBF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\x6F"],

        ["\xE8\x7C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xC0"],
        ["\xD9\xC0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\x7C"],

        ["\xE8\xC1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xC1"],
        ["\xD9\xC1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xC1"],

        ["\xE8\xC2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xC2"],
        ["\xD9\xC2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xC2"],

        ["\xE8\xC3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xC3"],
        ["\xD9\xC3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xC3"],

        ["\xE8\xC4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xC4"],
        ["\xD9\xC4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xC4"],

        ["\xE8\xC5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xC5"],
        ["\xD9\xC5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xC5"],

        ["\xE8\xC6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xC6"],
        ["\xD9\xC6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xC6"],

        ["\xE8\xC7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xC7"],
        ["\xD9\xC7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xC7"],

        ["\xE8\xC8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xC8"],
        ["\xD9\xC8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xC8"],

        ["\xE8\xC9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xC9"],
        ["\xD9\xC9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xC9"],

        ["\xE8\xD1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xCA"],
        ["\xD9\xCA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xD1"],

        ["\xE8\xD2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xCB"],
        ["\xD9\xCB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xD2"],

        ["\xE8\xD3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xCC"],
        ["\xD9\xCC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xD3"],

        ["\xE8\xD4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xCD"],
        ["\xD9\xCD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xD4"],

        ["\xE8\xD5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xCE"],
        ["\xD9\xCE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xD5"],

        ["\xE8\xD6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xCF"],
        ["\xD9\xCF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xD6"],

        ["\xE8\xD7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xD0"],
        ["\xD9\xD0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xD7"],

        ["\xE8\xD8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xD1"],
        ["\xD9\xD1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xD8"],

        ["\xE8\xD9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xD2"],
        ["\xD9\xD2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xD9"],

        ["\xE8\xE2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xD3"],
        ["\xD9\xD3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xE2"],

        ["\xE8\xE3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xD4"],
        ["\xD9\xD4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xE3"],

        ["\xE8\xE4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xD5"],
        ["\xD9\xD5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xE4"],

        ["\xE8\xE5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xD6"],
        ["\xD9\xD6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xE5"],

        ["\xE8\xE6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xD7"],
        ["\xD9\xD7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xE6"],

        ["\xE8\xE7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xD8"],
        ["\xD9\xD8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xE7"],

        ["\xE8\xE8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xD9"],
        ["\xD9\xD9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xE8"],

        ["\xE8\xE9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xDA"],
        ["\xD9\xDA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xE9"],

        ["\xE8\x4A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xDB"],
        ["\xD9\xDB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\x4A"],

        ["\xE8\x5B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xDC"],
        ["\xD9\xDC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\x5B"],

        ["\xE8\x5A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xDD"],
        ["\xD9\xDD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\x5A"],

        ["\xE8\x5F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xDE"],
        ["\xD9\xDE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\x5F"],

        ["\xE8\x6D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xDF"],
        ["\xD9\xDF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\x6D"],

        ["\xE8\x79",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xE0"],
        ["\xD9\xE0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\x79"],

        ["\xE8\x57",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xE1"],
        ["\xD9\xE1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\x57"],

        ["\xE8\x59",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xE2"],
        ["\xD9\xE2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\x59"],

        ["\xE8\x62",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xE3"],
        ["\xD9\xE3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\x62"],

        ["\xE8\x63",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xE4"],
        ["\xD9\xE4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\x63"],

        ["\xE8\x64",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xE5"],
        ["\xD9\xE5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\x64"],

        ["\xE8\x65",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xE6"],
        ["\xD9\xE6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\x65"],

        ["\xE8\x66",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xE7"],
        ["\xD9\xE7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\x66"],

        ["\xE8\x67",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xE8"],
        ["\xD9\xE8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\x67"],

        ["\xE8\x68",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xE9"],
        ["\xD9\xE9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\x68"],

        ["\xE8\x69",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xEA"],
        ["\xD9\xEA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\x69"],

        ["\xE8\x70",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xEB"],
        ["\xD9\xEB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\x70"],

        ["\xE8\x71",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xEC"],
        ["\xD9\xEC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\x71"],

        ["\xE8\x72",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xED"],
        ["\xD9\xED",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\x72"],

        ["\xE8\x73",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xEE"],
        ["\xD9\xEE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\x73"],

        ["\xE8\x74",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xEF"],
        ["\xD9\xEF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\x74"],

        ["\xE8\x75",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xF0"],
        ["\xD9\xF0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\x75"],

        ["\xE8\x76",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xF1"],
        ["\xD9\xF1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\x76"],

        ["\xE8\x77",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xF2"],
        ["\xD9\xF2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\x77"],

        ["\xE8\x78",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xF3"],
        ["\xD9\xF3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\x78"],

        ["\xE8\x80",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xF4"],
        ["\xD9\xF4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\x80"],

        ["\xE8\x8B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xF5"],
        ["\xD9\xF5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\x8B"],

        ["\xE8\x9B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xF6"],
        ["\xD9\xF6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\x9B"],

        ["\xE8\x9C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xF7"],
        ["\xD9\xF7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\x9C"],

        ["\xF3\xC9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xF8"],
        ["\xD9\xF8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xC9"],

        ["\xE8\xAB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xF9"],
        ["\xD9\xF9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB"],

        ["\xE8\xB0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xFA"],
        ["\xD9\xFA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xB0"],

        ["\xE8\xC0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xFB"],
        ["\xD9\xFB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xC0"],

        ["\xE8\x6A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xFC"],
        ["\xD9\xFC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\x6A"],

        ["\xE8\xD0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xFD"],
        ["\xD9\xFD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xD0"],

        ["\xE8\xA1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\xFE"],
        ["\xD9\xFE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1"],

        ["\xE9\x4F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xA1"],
        ["\xDA\xA1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\x4F"],

        ["\xE9\x7F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xA2"],
        ["\xDA\xA2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\x7F"],

        ["\xE9\x7B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xA3"],
        ["\xDA\xA3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\x7B"],

        ["\xE9\xE0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xA4"],
        ["\xDA\xA4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xE0"],

        ["\xE9\x6C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xA5"],
        ["\xDA\xA5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\x6C"],

        ["\xE9\x50",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xA6"],
        ["\xDA\xA6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\x50"],

        ["\xE9\x7D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xA7"],
        ["\xDA\xA7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\x7D"],

        ["\xE9\x4D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xA8"],
        ["\xDA\xA8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\x4D"],

        ["\xE9\x5D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xA9"],
        ["\xDA\xA9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\x5D"],

        ["\xE9\x5C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xAA"],
        ["\xDA\xAA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\x5C"],

        ["\xE9\x4E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xAB"],
        ["\xDA\xAB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\x4E"],

        ["\xE9\x6B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xAC"],
        ["\xDA\xAC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\x6B"],

        ["\xE9\x60",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xAD"],
        ["\xDA\xAD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\x60"],

        ["\xE9\x4B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xAE"],
        ["\xDA\xAE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\x4B"],

        ["\xE9\x61",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xAF"],
        ["\xDA\xAF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\x61"],

        ["\xE9\xF0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xB0"],
        ["\xDA\xB0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xF0"],

        ["\xE9\xF1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xB1"],
        ["\xDA\xB1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xF1"],

        ["\xE9\xF2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xB2"],
        ["\xDA\xB2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xF2"],

        ["\xE9\xF3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xB3"],
        ["\xDA\xB3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xF3"],

        ["\xE9\xF4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xB4"],
        ["\xDA\xB4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xF4"],

        ["\xE9\xF5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xB5"],
        ["\xDA\xB5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xF5"],

        ["\xE9\xF6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xB6"],
        ["\xDA\xB6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xF6"],

        ["\xE9\xF7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xB7"],
        ["\xDA\xB7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xF7"],

        ["\xE9\xF8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xB8"],
        ["\xDA\xB8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xF8"],

        ["\xE9\xF9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xB9"],
        ["\xDA\xB9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xF9"],

        ["\xE9\x7A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xBA"],
        ["\xDA\xBA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\x7A"],

        ["\xE9\x5E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xBB"],
        ["\xDA\xBB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\x5E"],

        ["\xE9\x4C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xBC"],
        ["\xDA\xBC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\x4C"],

        ["\xE9\x7E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xBD"],
        ["\xDA\xBD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\x7E"],

        ["\xE9\x6E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xBE"],
        ["\xDA\xBE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\x6E"],

        ["\xE9\x6F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xBF"],
        ["\xDA\xBF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\x6F"],

        ["\xE9\x7C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xC0"],
        ["\xDA\xC0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\x7C"],

        ["\xE9\xC1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xC1"],
        ["\xDA\xC1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xC1"],

        ["\xE9\xC2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xC2"],
        ["\xDA\xC2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xC2"],

        ["\xE9\xC3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xC3"],
        ["\xDA\xC3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xC3"],

        ["\xE9\xC4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xC4"],
        ["\xDA\xC4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xC4"],

        ["\xE9\xC5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xC5"],
        ["\xDA\xC5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xC5"],

        ["\xE9\xC6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xC6"],
        ["\xDA\xC6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xC6"],

        ["\xE9\xC7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xC7"],
        ["\xDA\xC7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xC7"],

        ["\xE9\xC8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xC8"],
        ["\xDA\xC8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xC8"],

        ["\xE9\xC9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xC9"],
        ["\xDA\xC9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xC9"],

        ["\xE9\xD1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xCA"],
        ["\xDA\xCA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xD1"],

        ["\xE9\xD2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xCB"],
        ["\xDA\xCB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xD2"],

        ["\xE9\xD3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xCC"],
        ["\xDA\xCC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xD3"],

        ["\xE9\xD4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xCD"],
        ["\xDA\xCD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xD4"],

        ["\xE9\xD5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xCE"],
        ["\xDA\xCE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xD5"],

        ["\xE9\xD6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xCF"],
        ["\xDA\xCF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xD6"],

        ["\xE9\xD7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xD0"],
        ["\xDA\xD0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xD7"],

        ["\xE9\xD8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xD1"],
        ["\xDA\xD1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xD8"],

        ["\xE9\xD9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xD2"],
        ["\xDA\xD2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xD9"],

        ["\xE9\xE2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xD3"],
        ["\xDA\xD3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xE2"],

        ["\xE9\xE3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xD4"],
        ["\xDA\xD4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xE3"],

        ["\xE9\xE4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xD5"],
        ["\xDA\xD5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xE4"],

        ["\xE9\xE5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xD6"],
        ["\xDA\xD6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xE5"],

        ["\xE9\xE6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xD7"],
        ["\xDA\xD7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xE6"],

        ["\xE9\xE7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xD8"],
        ["\xDA\xD8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xE7"],

        ["\xE9\xE8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xD9"],
        ["\xDA\xD9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xE8"],

        ["\xE9\xE9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xDA"],
        ["\xDA\xDA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xE9"],

        ["\xE9\x4A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xDB"],
        ["\xDA\xDB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\x4A"],

        ["\xE9\x5B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xDC"],
        ["\xDA\xDC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\x5B"],

        ["\xE9\x5A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xDD"],
        ["\xDA\xDD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\x5A"],

        ["\xE9\x5F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xDE"],
        ["\xDA\xDE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\x5F"],

        ["\xE9\x6D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xDF"],
        ["\xDA\xDF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\x6D"],

        ["\xE9\x79",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xE0"],
        ["\xDA\xE0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\x79"],

        ["\xE9\x57",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xE1"],
        ["\xDA\xE1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\x57"],

        ["\xE9\x59",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xE2"],
        ["\xDA\xE2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\x59"],

        ["\xE9\x62",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xE3"],
        ["\xDA\xE3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\x62"],

        ["\xE9\x63",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xE4"],
        ["\xDA\xE4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\x63"],

        ["\xE9\x64",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xE5"],
        ["\xDA\xE5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\x64"],

        ["\xE9\x65",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xE6"],
        ["\xDA\xE6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\x65"],

        ["\xE9\x66",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xE7"],
        ["\xDA\xE7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\x66"],

        ["\xE9\x67",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xE8"],
        ["\xDA\xE8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\x67"],

        ["\xE9\x68",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xE9"],
        ["\xDA\xE9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\x68"],

        ["\xE9\x69",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xEA"],
        ["\xDA\xEA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\x69"],

        ["\xE9\x70",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xEB"],
        ["\xDA\xEB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\x70"],

        ["\xE9\x71",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xEC"],
        ["\xDA\xEC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\x71"],

        ["\xE9\x72",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xED"],
        ["\xDA\xED",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\x72"],

        ["\xE9\x73",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xEE"],
        ["\xDA\xEE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\x73"],

        ["\xE9\x74",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xEF"],
        ["\xDA\xEF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\x74"],

        ["\xE9\x75",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xF0"],
        ["\xDA\xF0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\x75"],

        ["\xE9\x76",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xF1"],
        ["\xDA\xF1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\x76"],

        ["\xE9\x77",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xF2"],
        ["\xDA\xF2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\x77"],

        ["\xE9\x78",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xF3"],
        ["\xDA\xF3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\x78"],

        ["\xE9\x80",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xF4"],
        ["\xDA\xF4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\x80"],

        ["\xE9\x8B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xF5"],
        ["\xDA\xF5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\x8B"],

        ["\xE9\x9B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xF6"],
        ["\xDA\xF6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B"],

        ["\xE9\x9C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xF7"],
        ["\xDA\xF7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\x9C"],

        ["\xE9\xA0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xF8"],
        ["\xDA\xF8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0"],

        ["\xE9\xAB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xF9"],
        ["\xDA\xF9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xAB"],

        ["\xE9\xB0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xFA"],
        ["\xDA\xFA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0"],

        ["\xE9\xC0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xFB"],
        ["\xDA\xFB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xC0"],

        ["\xE9\x6A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xFC"],
        ["\xDA\xFC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\x6A"],

        ["\xE9\xD0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xFD"],
        ["\xDA\xFD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xD0"],

        ["\xE9\xA1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDA\xFE"],
        ["\xDA\xFE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xA1"],

        ["\x4A\x4F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xA1"],
        ["\xDB\xA1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\x4F"],

        ["\x4A\x7F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xA2"],
        ["\xDB\xA2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\x7F"],

        ["\x4A\x7B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xA3"],
        ["\xDB\xA3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\x7B"],

        ["\x4A\xE0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xA4"],
        ["\xDB\xA4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\xE0"],

        ["\x4A\x6C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xA5"],
        ["\xDB\xA5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\x6C"],

        ["\x4A\x50",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xA6"],
        ["\xDB\xA6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\x50"],

        ["\x4A\x7D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xA7"],
        ["\xDB\xA7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\x7D"],

        ["\x4A\x4D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xA8"],
        ["\xDB\xA8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\x4D"],

        ["\x4A\x5D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xA9"],
        ["\xDB\xA9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\x5D"],

        ["\x4A\x5C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xAA"],
        ["\xDB\xAA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\x5C"],

        ["\x4A\x4E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xAB"],
        ["\xDB\xAB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\x4E"],

        ["\x4A\x6B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xAC"],
        ["\xDB\xAC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\x6B"],

        ["\x4A\x60",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xAD"],
        ["\xDB\xAD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\x60"],

        ["\x4A\x4B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xAE"],
        ["\xDB\xAE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\x4B"],

        ["\x4A\x61",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xAF"],
        ["\xDB\xAF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\x61"],

        ["\x4A\xF0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xB0"],
        ["\xDB\xB0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\xF0"],

        ["\x4A\xF1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xB1"],
        ["\xDB\xB1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\xF1"],

        ["\x4A\xF2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xB2"],
        ["\xDB\xB2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\xF2"],

        ["\x4A\xF3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xB3"],
        ["\xDB\xB3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\xF3"],

        ["\x4A\xF4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xB4"],
        ["\xDB\xB4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\xF4"],

        ["\x4A\xF5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xB5"],
        ["\xDB\xB5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\xF5"],

        ["\x4A\xF6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xB6"],
        ["\xDB\xB6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\xF6"],

        ["\x4A\xF7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xB7"],
        ["\xDB\xB7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\xF7"],

        ["\x4A\xF8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xB8"],
        ["\xDB\xB8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\xF8"],

        ["\x4A\xF9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xB9"],
        ["\xDB\xB9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\xF9"],

        ["\x4A\x7A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xBA"],
        ["\xDB\xBA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\x7A"],

        ["\x4A\x5E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xBB"],
        ["\xDB\xBB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\x5E"],

        ["\x4A\x4C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xBC"],
        ["\xDB\xBC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\x4C"],

        ["\x4A\x7E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xBD"],
        ["\xDB\xBD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\x7E"],

        ["\x4A\x6E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xBE"],
        ["\xDB\xBE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\x6E"],

        ["\x4A\x6F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xBF"],
        ["\xDB\xBF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\x6F"],

        ["\x4A\x7C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xC0"],
        ["\xDB\xC0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\x7C"],

        ["\x4A\xC1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xC1"],
        ["\xDB\xC1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\xC1"],

        ["\x4A\xC2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xC2"],
        ["\xDB\xC2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\xC2"],

        ["\x4A\xC3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xC3"],
        ["\xDB\xC3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\xC3"],

        ["\x4A\xC4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xC4"],
        ["\xDB\xC4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\xC4"],

        ["\x4A\xC5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xC5"],
        ["\xDB\xC5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\xC5"],

        ["\x4A\xC6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xC6"],
        ["\xDB\xC6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\xC6"],

        ["\x4A\xC7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xC7"],
        ["\xDB\xC7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\xC7"],

        ["\x4A\xC8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xC8"],
        ["\xDB\xC8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\xC8"],

        ["\x4A\xC9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xC9"],
        ["\xDB\xC9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\xC9"],

        ["\x4A\xD1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xCA"],
        ["\xDB\xCA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\xD1"],

        ["\x4A\xD2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xCB"],
        ["\xDB\xCB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\xD2"],

        ["\x4A\xD3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xCC"],
        ["\xDB\xCC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\xD3"],

        ["\x4A\xD4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xCD"],
        ["\xDB\xCD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\xD4"],

        ["\x4A\xD5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xCE"],
        ["\xDB\xCE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\xD5"],

        ["\x4A\xD6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xCF"],
        ["\xDB\xCF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\xD6"],

        ["\x4A\xD7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xD0"],
        ["\xDB\xD0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\xD7"],

        ["\x4A\xD8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xD1"],
        ["\xDB\xD1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\xD8"],

        ["\x4A\xD9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xD2"],
        ["\xDB\xD2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\xD9"],

        ["\x4A\xE2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xD3"],
        ["\xDB\xD3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\xE2"],

        ["\x4A\xE3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xD4"],
        ["\xDB\xD4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\xE3"],

        ["\x4A\xE4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xD5"],
        ["\xDB\xD5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\xE4"],

        ["\x4A\xE5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xD6"],
        ["\xDB\xD6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\xE5"],

        ["\x4A\xE6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xD7"],
        ["\xDB\xD7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\xE6"],

        ["\xC9\xF0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xD8"],
        ["\xDB\xD8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xF0"],

        ["\x4A\xE8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xD9"],
        ["\xDB\xD9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\xE8"],

        ["\x4A\xE9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xDA"],
        ["\xDB\xDA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\xE9"],

        ["\x4A\x4A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xDB"],
        ["\xDB\xDB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\x4A"],

        ["\x4A\x5B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xDC"],
        ["\xDB\xDC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\x5B"],

        ["\x4A\x5A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xDD"],
        ["\xDB\xDD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\x5A"],

        ["\x4A\x5F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xDE"],
        ["\xDB\xDE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\x5F"],

        ["\x4A\x6D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xDF"],
        ["\xDB\xDF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\x6D"],

        ["\x4A\x79",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xE0"],
        ["\xDB\xE0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\x79"],

        ["\x4A\x57",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xE1"],
        ["\xDB\xE1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\x57"],

        ["\x4A\x59",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xE2"],
        ["\xDB\xE2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\x59"],

        ["\x4A\x62",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xE3"],
        ["\xDB\xE3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\x62"],

        ["\x4A\x63",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xE4"],
        ["\xDB\xE4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\x63"],

        ["\x4A\x64",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xE5"],
        ["\xDB\xE5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\x64"],

        ["\x4A\x65",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xE6"],
        ["\xDB\xE6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\x65"],

        ["\x4A\x66",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xE7"],
        ["\xDB\xE7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\x66"],

        ["\x4A\x67",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xE8"],
        ["\xDB\xE8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\x67"],

        ["\x4A\x68",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xE9"],
        ["\xDB\xE9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\x68"],

        ["\x4A\x69",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xEA"],
        ["\xDB\xEA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\x69"],

        ["\x4A\x70",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xEB"],
        ["\xDB\xEB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\x70"],

        ["\x4A\x71",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xEC"],
        ["\xDB\xEC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\x71"],

        ["\xC5\x73",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xED"],
        ["\xDB\xED",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC5\x73"],

        ["\x4A\x73",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xEE"],
        ["\xDB\xEE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\x73"],

        ["\x4A\x74",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xEF"],
        ["\xDB\xEF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\x74"],

        ["\x4A\x75",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xF0"],
        ["\xDB\xF0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\x75"],

        ["\x4A\x76",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xF1"],
        ["\xDB\xF1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\x76"],

        ["\x4A\x77",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xF2"],
        ["\xDB\xF2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\x77"],

        ["\x4A\x78",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xF3"],
        ["\xDB\xF3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\x78"],

        ["\x4A\x80",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xF4"],
        ["\xDB\xF4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\x80"],

        ["\x4A\x8B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xF5"],
        ["\xDB\xF5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\x8B"],

        ["\x4A\x9B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xF6"],
        ["\xDB\xF6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\x9B"],

        ["\x4A\x9C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xF7"],
        ["\xDB\xF7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\x9C"],

        ["\x4A\xA0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xF8"],
        ["\xDB\xF8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\xA0"],

        ["\x4A\xAB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xF9"],
        ["\xDB\xF9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\xAB"],

        ["\x4A\xB0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xFA"],
        ["\xDB\xFA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\xB0"],

        ["\x4A\xC0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xFB"],
        ["\xDB\xFB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\xC0"],

        ["\x4A\x6A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xFC"],
        ["\xDB\xFC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\x6A"],

        ["\x4A\xD0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xFD"],
        ["\xDB\xFD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\xD0"],

        ["\x4A\xA1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDB\xFE"],
        ["\xDB\xFE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\xA1"],

        ["\x5B\x4F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xA1"],
        ["\xDC\xA1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\x4F"],

        ["\x5B\x7F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xA2"],
        ["\xDC\xA2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\x7F"],

        ["\x5B\x7B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xA3"],
        ["\xDC\xA3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\x7B"],

        ["\x5B\xE0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xA4"],
        ["\xDC\xA4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\xE0"],

        ["\x5B\x6C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xA5"],
        ["\xDC\xA5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\x6C"],

        ["\x5B\x50",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xA6"],
        ["\xDC\xA6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\x50"],

        ["\x5B\x7D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xA7"],
        ["\xDC\xA7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\x7D"],

        ["\x5B\x4D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xA8"],
        ["\xDC\xA8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\x4D"],

        ["\x5B\x5D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xA9"],
        ["\xDC\xA9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\x5D"],

        ["\x5B\x5C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xAA"],
        ["\xDC\xAA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\x5C"],

        ["\x5B\x4E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xAB"],
        ["\xDC\xAB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\x4E"],

        ["\x5B\x6B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xAC"],
        ["\xDC\xAC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\x6B"],

        ["\x5B\x60",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xAD"],
        ["\xDC\xAD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\x60"],

        ["\x5B\x4B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xAE"],
        ["\xDC\xAE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\x4B"],

        ["\x5B\x61",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xAF"],
        ["\xDC\xAF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\x61"],

        ["\x5B\xF0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xB0"],
        ["\xDC\xB0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\xF0"],

        ["\x5B\xF1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xB1"],
        ["\xDC\xB1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\xF1"],

        ["\x5B\xF2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xB2"],
        ["\xDC\xB2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\xF2"],

        ["\x5B\xF3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xB3"],
        ["\xDC\xB3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\xF3"],

        ["\x5B\xF4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xB4"],
        ["\xDC\xB4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\xF4"],

        ["\x5B\xF5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xB5"],
        ["\xDC\xB5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\xF5"],

        ["\x5B\xF6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xB6"],
        ["\xDC\xB6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\xF6"],

        ["\x5B\xF7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xB7"],
        ["\xDC\xB7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\xF7"],

        ["\x5B\xF8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xB8"],
        ["\xDC\xB8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\xF8"],

        ["\x5B\xF9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xB9"],
        ["\xDC\xB9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\xF9"],

        ["\x5B\x7A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xBA"],
        ["\xDC\xBA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\x7A"],

        ["\x5B\x5E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xBB"],
        ["\xDC\xBB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\x5E"],

        ["\x5B\x4C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xBC"],
        ["\xDC\xBC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\x4C"],

        ["\x5B\x7E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xBD"],
        ["\xDC\xBD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\x7E"],

        ["\x5B\x6E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xBE"],
        ["\xDC\xBE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\x6E"],

        ["\x5B\x6F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xBF"],
        ["\xDC\xBF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\x6F"],

        ["\x5B\x7C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xC0"],
        ["\xDC\xC0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\x7C"],

        ["\x5B\xC1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xC1"],
        ["\xDC\xC1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\xC1"],

        ["\x5B\xC2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xC2"],
        ["\xDC\xC2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\xC2"],

        ["\x5B\xC3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xC3"],
        ["\xDC\xC3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\xC3"],

        ["\x5B\xC4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xC4"],
        ["\xDC\xC4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\xC4"],

        ["\x5B\xC5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xC5"],
        ["\xDC\xC5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\xC5"],

        ["\x5B\xC6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xC6"],
        ["\xDC\xC6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\xC6"],

        ["\x5B\xC7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xC7"],
        ["\xDC\xC7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\xC7"],

        ["\x5B\xC8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xC8"],
        ["\xDC\xC8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\xC8"],

        ["\x5B\xC9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xC9"],
        ["\xDC\xC9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\xC9"],

        ["\x5B\xD1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xCA"],
        ["\xDC\xCA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\xD1"],

        ["\x5B\xD2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xCB"],
        ["\xDC\xCB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\xD2"],

        ["\x5B\xD3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xCC"],
        ["\xDC\xCC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\xD3"],

        ["\x5B\xD4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xCD"],
        ["\xDC\xCD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\xD4"],

        ["\x5B\xD5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xCE"],
        ["\xDC\xCE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\xD5"],

        ["\x5B\xD6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xCF"],
        ["\xDC\xCF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\xD6"],

        ["\x5B\xD7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xD0"],
        ["\xDC\xD0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\xD7"],

        ["\x5B\xD8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xD1"],
        ["\xDC\xD1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\xD8"],

        ["\x5B\xD9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xD2"],
        ["\xDC\xD2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\xD9"],

        ["\x5B\xE2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xD3"],
        ["\xDC\xD3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\xE2"],

        ["\x5B\xE3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xD4"],
        ["\xDC\xD4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\xE3"],

        ["\x5B\xE4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xD5"],
        ["\xDC\xD5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\xE4"],

        ["\x5B\xE5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xD6"],
        ["\xDC\xD6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\xE5"],

        ["\x5B\xE6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xD7"],
        ["\xDC\xD7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\xE6"],

        ["\x5B\xE7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xD8"],
        ["\xDC\xD8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\xE7"],

        ["\x5B\xE8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xD9"],
        ["\xDC\xD9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\xE8"],

        ["\x5B\xE9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xDA"],
        ["\xDC\xDA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\xE9"],

        ["\x5B\x4A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xDB"],
        ["\xDC\xDB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\x4A"],

        ["\x5B\x5B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xDC"],
        ["\xDC\xDC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\x5B"],

        ["\x5B\x5A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xDD"],
        ["\xDC\xDD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\x5A"],

        ["\x5B\x5F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xDE"],
        ["\xDC\xDE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\x5F"],

        ["\x5B\x6D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xDF"],
        ["\xDC\xDF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\x6D"],

        ["\x5B\x79",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xE0"],
        ["\xDC\xE0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\x79"],

        ["\x5B\x57",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xE1"],
        ["\xDC\xE1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\x57"],

        ["\x5B\x59",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xE2"],
        ["\xDC\xE2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\x59"],

        ["\x5B\x62",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xE3"],
        ["\xDC\xE3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\x62"],

        ["\x5B\x63",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xE4"],
        ["\xDC\xE4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\x63"],

        ["\x5B\x64",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xE5"],
        ["\xDC\xE5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\x64"],

        ["\x5B\x65",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xE6"],
        ["\xDC\xE6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\x65"],

        ["\x5B\x66",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xE7"],
        ["\xDC\xE7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\x66"],

        ["\x5B\x67",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xE8"],
        ["\xDC\xE8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\x67"],

        ["\x5B\x68",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xE9"],
        ["\xDC\xE9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\x68"],

        ["\x5B\x69",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xEA"],
        ["\xDC\xEA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\x69"],

        ["\x5B\x70",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xEB"],
        ["\xDC\xEB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\x70"],

        ["\x5B\x71",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xEC"],
        ["\xDC\xEC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\x71"],

        ["\x5B\x72",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xED"],
        ["\xDC\xED",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\x72"],

        ["\x5B\x73",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xEE"],
        ["\xDC\xEE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\x73"],

        ["\x5B\x74",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xEF"],
        ["\xDC\xEF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\x74"],

        ["\x5B\x75",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xF0"],
        ["\xDC\xF0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\x75"],

        ["\x5B\x76",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xF1"],
        ["\xDC\xF1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\x76"],

        ["\x5B\x77",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xF2"],
        ["\xDC\xF2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\x77"],

        ["\x5B\x78",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xF3"],
        ["\xDC\xF3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\x78"],

        ["\x5B\x80",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xF4"],
        ["\xDC\xF4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\x80"],

        ["\x5B\x8B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xF5"],
        ["\xDC\xF5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\x8B"],

        ["\x5B\x9B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xF6"],
        ["\xDC\xF6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\x9B"],

        ["\x5B\x9C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xF7"],
        ["\xDC\xF7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\x9C"],

        ["\x5B\xA0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xF8"],
        ["\xDC\xF8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\xA0"],

        ["\x5B\xAB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xF9"],
        ["\xDC\xF9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\xAB"],

        ["\x5B\xB0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xFA"],
        ["\xDC\xFA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\xB0"],

        ["\x5B\xC0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xFB"],
        ["\xDC\xFB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\xC0"],

        ["\x5B\x6A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xFC"],
        ["\xDC\xFC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\x6A"],

        ["\x5B\xD0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xFD"],
        ["\xDC\xFD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\xD0"],

        ["\x5B\xA1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\xFE"],
        ["\xDC\xFE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\xA1"],

        ["\x5A\x4F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xA1"],
        ["\xDD\xA1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\x4F"],

        ["\x5A\x7F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xA2"],
        ["\xDD\xA2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\x7F"],

        ["\x5A\x7B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xA3"],
        ["\xDD\xA3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\x7B"],

        ["\x5A\xE0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xA4"],
        ["\xDD\xA4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\xE0"],

        ["\x5A\x6C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xA5"],
        ["\xDD\xA5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\x6C"],

        ["\x5A\x50",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xA6"],
        ["\xDD\xA6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\x50"],

        ["\x5A\x7D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xA7"],
        ["\xDD\xA7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\x7D"],

        ["\x5A\x4D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xA8"],
        ["\xDD\xA8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\x4D"],

        ["\x5A\x5D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xA9"],
        ["\xDD\xA9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\x5D"],

        ["\x5A\x5C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xAA"],
        ["\xDD\xAA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\x5C"],

        ["\x5A\x4E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xAB"],
        ["\xDD\xAB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\x4E"],

        ["\x5A\x6B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xAC"],
        ["\xDD\xAC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\x6B"],

        ["\x5A\x60",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xAD"],
        ["\xDD\xAD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\x60"],

        ["\x5A\x4B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xAE"],
        ["\xDD\xAE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\x4B"],

        ["\x5A\x61",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xAF"],
        ["\xDD\xAF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\x61"],

        ["\x5A\xF0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xB0"],
        ["\xDD\xB0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\xF0"],

        ["\x5A\xF1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xB1"],
        ["\xDD\xB1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\xF1"],

        ["\x5A\xF2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xB2"],
        ["\xDD\xB2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\xF2"],

        ["\x5A\xF3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xB3"],
        ["\xDD\xB3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\xF3"],

        ["\x5A\xF4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xB4"],
        ["\xDD\xB4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\xF4"],

        ["\x5A\xF5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xB5"],
        ["\xDD\xB5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\xF5"],

        ["\x5A\xF6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xB6"],
        ["\xDD\xB6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\xF6"],

        ["\x5A\xF7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xB7"],
        ["\xDD\xB7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\xF7"],

        ["\x5A\xF8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xB8"],
        ["\xDD\xB8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\xF8"],

        ["\x5A\xF9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xB9"],
        ["\xDD\xB9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\xF9"],

        ["\x5A\x7A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xBA"],
        ["\xDD\xBA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\x7A"],

        ["\x5A\x5E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xBB"],
        ["\xDD\xBB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\x5E"],

        ["\x5A\x4C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xBC"],
        ["\xDD\xBC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\x4C"],

        ["\x5A\x7E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xBD"],
        ["\xDD\xBD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\x7E"],

        ["\x5A\x6E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xBE"],
        ["\xDD\xBE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\x6E"],

        ["\x5A\x6F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xBF"],
        ["\xDD\xBF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\x6F"],

        ["\x5A\x7C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xC0"],
        ["\xDD\xC0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\x7C"],

        ["\x5A\xC1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xC1"],
        ["\xDD\xC1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\xC1"],

        ["\x5A\xC2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xC2"],
        ["\xDD\xC2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\xC2"],

        ["\x5A\xC3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xC3"],
        ["\xDD\xC3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\xC3"],

        ["\x5A\xC4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xC4"],
        ["\xDD\xC4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\xC4"],

        ["\x5A\xC5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xC5"],
        ["\xDD\xC5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\xC5"],

        ["\x5A\xC6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xC6"],
        ["\xDD\xC6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\xC6"],

        ["\x5A\xC7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xC7"],
        ["\xDD\xC7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\xC7"],

        ["\x5A\xC8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xC8"],
        ["\xDD\xC8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\xC8"],

        ["\x5A\xC9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xC9"],
        ["\xDD\xC9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\xC9"],

        ["\x5A\xD1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xCA"],
        ["\xDD\xCA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\xD1"],

        ["\x5A\xD2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xCB"],
        ["\xDD\xCB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\xD2"],

        ["\x5A\xD3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xCC"],
        ["\xDD\xCC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\xD3"],

        ["\x5A\xD4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xCD"],
        ["\xDD\xCD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\xD4"],

        ["\x5A\xD5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xCE"],
        ["\xDD\xCE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\xD5"],

        ["\x5A\xD6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xCF"],
        ["\xDD\xCF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\xD6"],

        ["\x5A\xD7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xD0"],
        ["\xDD\xD0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\xD7"],

        ["\x5A\xD8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xD1"],
        ["\xDD\xD1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\xD8"],

        ["\x5A\xD9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xD2"],
        ["\xDD\xD2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\xD9"],

        ["\x5A\xE2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xD3"],
        ["\xDD\xD3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\xE2"],

        ["\x5A\xE3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xD4"],
        ["\xDD\xD4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\xE3"],

        ["\x5A\xE4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xD5"],
        ["\xDD\xD5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\xE4"],

        ["\x5A\xE5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xD6"],
        ["\xDD\xD6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\xE5"],

        ["\x5A\xE6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xD7"],
        ["\xDD\xD7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\xE6"],

        ["\x5A\xE7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xD8"],
        ["\xDD\xD8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\xE7"],

        ["\x5A\xE8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xD9"],
        ["\xDD\xD9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\xE8"],

        ["\x5A\xE9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xDA"],
        ["\xDD\xDA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\xE9"],

        ["\x5A\x4A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xDB"],
        ["\xDD\xDB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\x4A"],

        ["\x5A\x5B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xDC"],
        ["\xDD\xDC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\x5B"],

        ["\x5A\x5A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xDD"],
        ["\xDD\xDD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\x5A"],

        ["\x5A\x5F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xDE"],
        ["\xDD\xDE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\x5F"],

        ["\x5A\x6D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xDF"],
        ["\xDD\xDF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\x6D"],

        ["\x5A\x79",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xE0"],
        ["\xDD\xE0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\x79"],

        ["\x5A\x57",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xE1"],
        ["\xDD\xE1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\x57"],

        ["\x5A\x59",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xE2"],
        ["\xDD\xE2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\x59"],

        ["\x5A\x62",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xE3"],
        ["\xDD\xE3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\x62"],

        ["\x5A\x63",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xE4"],
        ["\xDD\xE4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\x63"],

        ["\x5A\x64",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xE5"],
        ["\xDD\xE5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\x64"],

        ["\x5A\x65",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xE6"],
        ["\xDD\xE6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\x65"],

        ["\x5A\x66",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xE7"],
        ["\xDD\xE7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\x66"],

        ["\x5A\x67",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xE8"],
        ["\xDD\xE8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\x67"],

        ["\x5A\x68",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xE9"],
        ["\xDD\xE9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\x68"],

        ["\x5A\x69",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xEA"],
        ["\xDD\xEA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\x69"],

        ["\x5A\x70",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xEB"],
        ["\xDD\xEB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\x70"],

        ["\x5A\x71",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xEC"],
        ["\xDD\xEC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\x71"],

        ["\x5A\x72",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xED"],
        ["\xDD\xED",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\x72"],

        ["\x5A\x73",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xEE"],
        ["\xDD\xEE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\x73"],

        ["\x5A\x74",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xEF"],
        ["\xDD\xEF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\x74"],

        ["\x5A\x75",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xF0"],
        ["\xDD\xF0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\x75"],

        ["\x5A\x76",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xF1"],
        ["\xDD\xF1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\x76"],

        ["\x5A\x77",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xF2"],
        ["\xDD\xF2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\x77"],

        ["\x5A\x78",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xF3"],
        ["\xDD\xF3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\x78"],

        ["\x5A\x80",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xF4"],
        ["\xDD\xF4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\x80"],

        ["\x5A\x8B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xF5"],
        ["\xDD\xF5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\x8B"],

        ["\x5A\x9B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xF6"],
        ["\xDD\xF6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\x9B"],

        ["\x5A\x9C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xF7"],
        ["\xDD\xF7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\x9C"],

        ["\x5A\xA0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xF8"],
        ["\xDD\xF8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\xA0"],

        ["\x5A\xAB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xF9"],
        ["\xDD\xF9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\xAB"],

        ["\x5A\xB0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xFA"],
        ["\xDD\xFA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\xB0"],

        ["\x5A\xC0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xFB"],
        ["\xDD\xFB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\xC0"],

        ["\x5A\x6A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xFC"],
        ["\xDD\xFC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\x6A"],

        ["\x5A\xD0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xFD"],
        ["\xDD\xFD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\xD0"],

        ["\x5A\xA1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDD\xFE"],
        ["\xDD\xFE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\xA1"],

        ["\x5F\x4F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xA1"],
        ["\xDE\xA1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\x4F"],

        ["\x5F\x7F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xA2"],
        ["\xDE\xA2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\x7F"],

        ["\x5F\x7B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xA3"],
        ["\xDE\xA3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\x7B"],

        ["\x5F\xE0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xA4"],
        ["\xDE\xA4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\xE0"],

        ["\x5F\x6C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xA5"],
        ["\xDE\xA5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\x6C"],

        ["\x5F\x50",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xA6"],
        ["\xDE\xA6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\x50"],

        ["\x5F\x7D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xA7"],
        ["\xDE\xA7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\x7D"],

        ["\x5F\x4D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xA8"],
        ["\xDE\xA8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\x4D"],

        ["\x5F\x5D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xA9"],
        ["\xDE\xA9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\x5D"],

        ["\x5F\x5C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xAA"],
        ["\xDE\xAA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\x5C"],

        ["\x5F\x4E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xAB"],
        ["\xDE\xAB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\x4E"],

        ["\x5F\x6B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xAC"],
        ["\xDE\xAC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\x6B"],

        ["\x5F\x60",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xAD"],
        ["\xDE\xAD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\x60"],

        ["\x5F\x4B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xAE"],
        ["\xDE\xAE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\x4B"],

        ["\x5F\x61",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xAF"],
        ["\xDE\xAF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\x61"],

        ["\x5F\xF0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xB0"],
        ["\xDE\xB0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\xF0"],

        ["\x5F\xF1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xB1"],
        ["\xDE\xB1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\xF1"],

        ["\x5F\xF2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xB2"],
        ["\xDE\xB2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\xF2"],

        ["\x5F\xF3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xB3"],
        ["\xDE\xB3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\xF3"],

        ["\x5F\xF4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xB4"],
        ["\xDE\xB4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\xF4"],

        ["\x5F\xF5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xB5"],
        ["\xDE\xB5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\xF5"],

        ["\x5F\xF6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xB6"],
        ["\xDE\xB6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\xF6"],

        ["\x5F\xF7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xB7"],
        ["\xDE\xB7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\xF7"],

        ["\x5F\xF8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xB8"],
        ["\xDE\xB8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\xF8"],

        ["\xC5\x78",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xB9"],
        ["\xDE\xB9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC5\x78"],

        ["\x5F\x7A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xBA"],
        ["\xDE\xBA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\x7A"],

        ["\x5F\x5E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xBB"],
        ["\xDE\xBB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\x5E"],

        ["\x5F\x4C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xBC"],
        ["\xDE\xBC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\x4C"],

        ["\x5F\x7E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xBD"],
        ["\xDE\xBD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\x7E"],

        ["\x5F\x6E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xBE"],
        ["\xDE\xBE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\x6E"],

        ["\x5F\x6F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xBF"],
        ["\xDE\xBF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\x6F"],

        ["\x5F\x7C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xC0"],
        ["\xDE\xC0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\x7C"],

        ["\x5F\xC1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xC1"],
        ["\xDE\xC1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\xC1"],

        ["\x5F\xC2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xC2"],
        ["\xDE\xC2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\xC2"],

        ["\x5F\xC3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xC3"],
        ["\xDE\xC3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\xC3"],

        ["\x5F\xC4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xC4"],
        ["\xDE\xC4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\xC4"],

        ["\x5F\xC5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xC5"],
        ["\xDE\xC5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\xC5"],

        ["\x5F\xC6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xC6"],
        ["\xDE\xC6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\xC6"],

        ["\x5F\xC7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xC7"],
        ["\xDE\xC7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\xC7"],

        ["\x5F\xC8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xC8"],
        ["\xDE\xC8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\xC8"],

        ["\x5F\xC9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xC9"],
        ["\xDE\xC9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\xC9"],

        ["\x5F\xD1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xCA"],
        ["\xDE\xCA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\xD1"],

        ["\x5F\xD2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xCB"],
        ["\xDE\xCB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\xD2"],

        ["\x5F\xD3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xCC"],
        ["\xDE\xCC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\xD3"],

        ["\x5F\xD4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xCD"],
        ["\xDE\xCD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\xD4"],

        ["\x5F\xD5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xCE"],
        ["\xDE\xCE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\xD5"],

        ["\x5F\xD6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xCF"],
        ["\xDE\xCF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\xD6"],

        ["\x5F\xD7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xD0"],
        ["\xDE\xD0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\xD7"],

        ["\x5F\xD8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xD1"],
        ["\xDE\xD1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\xD8"],

        ["\x5F\xD9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xD2"],
        ["\xDE\xD2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\xD9"],

        ["\x5F\xE2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xD3"],
        ["\xDE\xD3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\xE2"],

        ["\x5F\xE3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xD4"],
        ["\xDE\xD4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\xE3"],

        ["\x5F\xE4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xD5"],
        ["\xDE\xD5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\xE4"],

        ["\x5F\xE5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xD6"],
        ["\xDE\xD6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\xE5"],

        ["\x5F\xE6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xD7"],
        ["\xDE\xD7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\xE6"],

        ["\x5F\xE7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xD8"],
        ["\xDE\xD8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\xE7"],

        ["\x5F\xE8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xD9"],
        ["\xDE\xD9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\xE8"],

        ["\x5F\xE9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xDA"],
        ["\xDE\xDA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\xE9"],

        ["\x5F\x4A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xDB"],
        ["\xDE\xDB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\x4A"],

        ["\x5F\x5B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xDC"],
        ["\xDE\xDC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\x5B"],

        ["\x5F\x5A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xDD"],
        ["\xDE\xDD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\x5A"],

        ["\x5F\x5F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xDE"],
        ["\xDE\xDE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\x5F"],

        ["\x5F\x6D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xDF"],
        ["\xDE\xDF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\x6D"],

        ["\x5F\x79",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xE0"],
        ["\xDE\xE0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\x79"],

        ["\x5F\x57",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xE1"],
        ["\xDE\xE1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\x57"],

        ["\x5F\x59",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xE2"],
        ["\xDE\xE2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\x59"],

        ["\x5F\x62",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xE3"],
        ["\xDE\xE3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\x62"],

        ["\x5F\x63",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xE4"],
        ["\xDE\xE4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\x63"],

        ["\x5F\x64",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xE5"],
        ["\xDE\xE5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\x64"],

        ["\x5F\x65",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xE6"],
        ["\xDE\xE6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\x65"],

        ["\x5F\x66",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xE7"],
        ["\xDE\xE7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\x66"],

        ["\x5F\x67",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xE8"],
        ["\xDE\xE8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\x67"],

        ["\x5F\x68",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xE9"],
        ["\xDE\xE9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\x68"],

        ["\x5F\x69",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xEA"],
        ["\xDE\xEA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\x69"],

        ["\x5F\x70",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xEB"],
        ["\xDE\xEB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\x70"],

        ["\x5F\x71",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xEC"],
        ["\xDE\xEC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\x71"],

        ["\x5F\x72",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xED"],
        ["\xDE\xED",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\x72"],

        ["\x5F\x73",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xEE"],
        ["\xDE\xEE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\x73"],

        ["\x5F\x74",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xEF"],
        ["\xDE\xEF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\x74"],

        ["\x5F\x75",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xF0"],
        ["\xDE\xF0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\x75"],

        ["\x5F\x76",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xF1"],
        ["\xDE\xF1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\x76"],

        ["\x5F\x77",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xF2"],
        ["\xDE\xF2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\x77"],

        ["\x5F\x78",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xF3"],
        ["\xDE\xF3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\x78"],

        ["\x5F\x80",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xF4"],
        ["\xDE\xF4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\x80"],

        ["\xF4\xC3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xF5"],
        ["\xDE\xF5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF4\xC3"],

        ["\x5F\x9B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xF6"],
        ["\xDE\xF6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\x9B"],

        ["\x5F\x9C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xF7"],
        ["\xDE\xF7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\x9C"],

        ["\x5F\xA0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xF8"],
        ["\xDE\xF8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\xA0"],

        ["\x5F\xAB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xF9"],
        ["\xDE\xF9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\xAB"],

        ["\x5F\xB0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xFA"],
        ["\xDE\xFA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\xB0"],

        ["\x5F\xC0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xFB"],
        ["\xDE\xFB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\xC0"],

        ["\x5F\x6A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xFC"],
        ["\xDE\xFC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\x6A"],

        ["\x5F\xD0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xFD"],
        ["\xDE\xFD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\xD0"],

        ["\x5F\xA1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDE\xFE"],
        ["\xDE\xFE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\xA1"],

        ["\x6D\x4F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xA1"],
        ["\xDF\xA1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\x4F"],

        ["\x6D\x7F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xA2"],
        ["\xDF\xA2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\x7F"],

        ["\x6D\x7B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xA3"],
        ["\xDF\xA3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\x7B"],

        ["\x6D\xE0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xA4"],
        ["\xDF\xA4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\xE0"],

        ["\x6D\x6C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xA5"],
        ["\xDF\xA5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\x6C"],

        ["\x6D\x50",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xA6"],
        ["\xDF\xA6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\x50"],

        ["\x6D\x7D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xA7"],
        ["\xDF\xA7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\x7D"],

        ["\x6D\x4D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xA8"],
        ["\xDF\xA8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\x4D"],

        ["\x6D\x5D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xA9"],
        ["\xDF\xA9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\x5D"],

        ["\x6D\x5C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xAA"],
        ["\xDF\xAA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\x5C"],

        ["\x6D\x4E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xAB"],
        ["\xDF\xAB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\x4E"],

        ["\x6D\x6B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xAC"],
        ["\xDF\xAC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\x6B"],

        ["\x6D\x60",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xAD"],
        ["\xDF\xAD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\x60"],

        ["\x6D\x4B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xAE"],
        ["\xDF\xAE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\x4B"],

        ["\x6D\x61",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xAF"],
        ["\xDF\xAF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\x61"],

        ["\x6D\xF0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xB0"],
        ["\xDF\xB0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\xF0"],

        ["\x6D\xF1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xB1"],
        ["\xDF\xB1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\xF1"],

        ["\x6D\xF2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xB2"],
        ["\xDF\xB2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\xF2"],

        ["\x6D\xF3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xB3"],
        ["\xDF\xB3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\xF3"],

        ["\x6D\xF4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xB4"],
        ["\xDF\xB4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\xF4"],

        ["\x6D\xF5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xB5"],
        ["\xDF\xB5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\xF5"],

        ["\x6D\xF6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xB6"],
        ["\xDF\xB6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\xF6"],

        ["\x6D\xF7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xB7"],
        ["\xDF\xB7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\xF7"],

        ["\x6D\xF8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xB8"],
        ["\xDF\xB8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\xF8"],

        ["\x6D\xF9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xB9"],
        ["\xDF\xB9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\xF9"],

        ["\x6D\x7A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xBA"],
        ["\xDF\xBA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\x7A"],

        ["\x6D\x5E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xBB"],
        ["\xDF\xBB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\x5E"],

        ["\x6D\x4C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xBC"],
        ["\xDF\xBC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\x4C"],

        ["\x6D\x7E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xBD"],
        ["\xDF\xBD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\x7E"],

        ["\x6D\x6E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xBE"],
        ["\xDF\xBE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\x6E"],

        ["\x6D\x6F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xBF"],
        ["\xDF\xBF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\x6F"],

        ["\x6D\x7C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xC0"],
        ["\xDF\xC0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\x7C"],

        ["\x6D\xC1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xC1"],
        ["\xDF\xC1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\xC1"],

        ["\x6D\xC2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xC2"],
        ["\xDF\xC2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\xC2"],

        ["\x6D\xC3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xC3"],
        ["\xDF\xC3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\xC3"],

        ["\x6D\xC4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xC4"],
        ["\xDF\xC4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\xC4"],

        ["\x6D\xC5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xC5"],
        ["\xDF\xC5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\xC5"],

        ["\x6D\xC6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xC6"],
        ["\xDF\xC6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\xC6"],

        ["\x6D\xC7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xC7"],
        ["\xDF\xC7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\xC7"],

        ["\x6D\xC8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xC8"],
        ["\xDF\xC8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\xC8"],

        ["\x6D\xC9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xC9"],
        ["\xDF\xC9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\xC9"],

        ["\x6D\xD1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xCA"],
        ["\xDF\xCA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\xD1"],

        ["\x6D\xD2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xCB"],
        ["\xDF\xCB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\xD2"],

        ["\x6D\xD3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xCC"],
        ["\xDF\xCC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\xD3"],

        ["\x6D\xD4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xCD"],
        ["\xDF\xCD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\xD4"],

        ["\x6D\xD5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xCE"],
        ["\xDF\xCE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\xD5"],

        ["\x6D\xD6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xCF"],
        ["\xDF\xCF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\xD6"],

        ["\x6D\xD7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xD0"],
        ["\xDF\xD0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\xD7"],

        ["\x6D\xD8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xD1"],
        ["\xDF\xD1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\xD8"],

        ["\x6D\xD9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xD2"],
        ["\xDF\xD2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\xD9"],

        ["\x6D\xE2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xD3"],
        ["\xDF\xD3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\xE2"],

        ["\x6D\xE3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xD4"],
        ["\xDF\xD4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\xE3"],

        ["\x6D\xE4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xD5"],
        ["\xDF\xD5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\xE4"],

        ["\x6D\xE5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xD6"],
        ["\xDF\xD6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\xE5"],

        ["\x6D\xE6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xD7"],
        ["\xDF\xD7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\xE6"],

        ["\x6D\xE7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xD8"],
        ["\xDF\xD8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\xE7"],

        ["\x6D\xE8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xD9"],
        ["\xDF\xD9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\xE8"],

        ["\x6D\xE9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xDA"],
        ["\xDF\xDA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\xE9"],

        ["\x6D\x4A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xDB"],
        ["\xDF\xDB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\x4A"],

        ["\x6D\x5B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xDC"],
        ["\xDF\xDC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\x5B"],

        ["\x6D\x5A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xDD"],
        ["\xDF\xDD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\x5A"],

        ["\x6D\x5F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xDE"],
        ["\xDF\xDE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\x5F"],

        ["\x6D\x6D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xDF"],
        ["\xDF\xDF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\x6D"],

        ["\x6D\x79",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xE0"],
        ["\xDF\xE0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\x79"],

        ["\x6D\x57",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xE1"],
        ["\xDF\xE1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\x57"],

        ["\x6D\x59",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xE2"],
        ["\xDF\xE2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\x59"],

        ["\x6D\x62",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xE3"],
        ["\xDF\xE3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\x62"],

        ["\x6D\x63",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xE4"],
        ["\xDF\xE4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\x63"],

        ["\x6D\x64",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xE5"],
        ["\xDF\xE5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\x64"],

        ["\x6D\x65",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xE6"],
        ["\xDF\xE6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\x65"],

        ["\x6D\x66",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xE7"],
        ["\xDF\xE7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\x66"],

        ["\x6D\x67",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xE8"],
        ["\xDF\xE8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\x67"],

        ["\x6D\x68",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xE9"],
        ["\xDF\xE9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\x68"],

        ["\x6D\x69",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xEA"],
        ["\xDF\xEA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\x69"],

        ["\x6D\x70",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xEB"],
        ["\xDF\xEB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\x70"],

        ["\x6D\x71",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xEC"],
        ["\xDF\xEC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\x71"],

        ["\x6D\x72",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xED"],
        ["\xDF\xED",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\x72"],

        ["\x6D\x73",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xEE"],
        ["\xDF\xEE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\x73"],

        ["\x6D\x74",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xEF"],
        ["\xDF\xEF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\x74"],

        ["\x6D\x75",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xF0"],
        ["\xDF\xF0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\x75"],

        ["\x6D\x76",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xF1"],
        ["\xDF\xF1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\x76"],

        ["\x6D\x77",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xF2"],
        ["\xDF\xF2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\x77"],

        ["\x6D\x78",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xF3"],
        ["\xDF\xF3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\x78"],

        ["\x6D\x80",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xF4"],
        ["\xDF\xF4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\x80"],

        ["\x6D\x8B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xF5"],
        ["\xDF\xF5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\x8B"],

        ["\x6D\x9B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xF6"],
        ["\xDF\xF6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\x9B"],

        ["\x6D\x9C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xF7"],
        ["\xDF\xF7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\x9C"],

        ["\x6D\xA0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xF8"],
        ["\xDF\xF8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\xA0"],

        ["\x6D\xAB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xF9"],
        ["\xDF\xF9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\xAB"],

        ["\x6D\xB0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xFA"],
        ["\xDF\xFA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\xB0"],

        ["\x6D\xC0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xFB"],
        ["\xDF\xFB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\xC0"],

        ["\x6D\x6A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xFC"],
        ["\xDF\xFC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\x6A"],

        ["\x6D\xD0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xFD"],
        ["\xDF\xFD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\xD0"],

        ["\x6D\xA1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDF\xFE"],
        ["\xDF\xFE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\xA1"],

        ["\x79\x4F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xA1"],
        ["\xE0\xA1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x79\x4F"],

        ["\x79\x7F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xA2"],
        ["\xE0\xA2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x79\x7F"],

        ["\x79\x7B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xA3"],
        ["\xE0\xA3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x79\x7B"],

        ["\x79\xE0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xA4"],
        ["\xE0\xA4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x79\xE0"],

        ["\x79\x6C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xA5"],
        ["\xE0\xA5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x79\x6C"],

        ["\x79\x50",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xA6"],
        ["\xE0\xA6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x79\x50"],

        ["\x79\x7D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xA7"],
        ["\xE0\xA7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x79\x7D"],

        ["\x79\x4D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xA8"],
        ["\xE0\xA8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x79\x4D"],

        ["\x79\x5D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xA9"],
        ["\xE0\xA9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x79\x5D"],

        ["\x79\x5C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xAA"],
        ["\xE0\xAA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x79\x5C"],

        ["\x79\x4E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xAB"],
        ["\xE0\xAB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x79\x4E"],

        ["\x79\x6B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xAC"],
        ["\xE0\xAC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x79\x6B"],

        ["\x79\x60",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xAD"],
        ["\xE0\xAD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x79\x60"],

        ["\x79\x4B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xAE"],
        ["\xE0\xAE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x79\x4B"],

        ["\x79\x61",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xAF"],
        ["\xE0\xAF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x79\x61"],

        ["\x79\xF0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xB0"],
        ["\xE0\xB0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x79\xF0"],

        ["\x79\xF1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xB1"],
        ["\xE0\xB1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x79\xF1"],

        ["\x79\xF2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xB2"],
        ["\xE0\xB2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x79\xF2"],

        ["\x79\xF3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xB3"],
        ["\xE0\xB3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x79\xF3"],

        ["\x79\xF4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xB4"],
        ["\xE0\xB4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x79\xF4"],

        ["\x79\xF5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xB5"],
        ["\xE0\xB5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x79\xF5"],

        ["\x79\xF6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xB6"],
        ["\xE0\xB6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x79\xF6"],

        ["\x79\xF7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xB7"],
        ["\xE0\xB7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x79\xF7"],

        ["\x79\xF8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xB8"],
        ["\xE0\xB8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x79\xF8"],

        ["\x79\xF9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xB9"],
        ["\xE0\xB9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x79\xF9"],

        ["\x79\x7A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xBA"],
        ["\xE0\xBA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x79\x7A"],

        ["\x79\x5E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xBB"],
        ["\xE0\xBB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x79\x5E"],

        ["\x79\x4C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xBC"],
        ["\xE0\xBC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x79\x4C"],

        ["\x79\x7E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xBD"],
        ["\xE0\xBD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x79\x7E"],

        ["\x79\x6E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xBE"],
        ["\xE0\xBE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x79\x6E"],

        ["\x79\x6F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xBF"],
        ["\xE0\xBF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x79\x6F"],

        ["\x79\x7C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xC0"],
        ["\xE0\xC0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x79\x7C"],

        ["\x79\xC1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xC1"],
        ["\xE0\xC1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x79\xC1"],

        ["\x79\xC2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xC2"],
        ["\xE0\xC2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x79\xC2"],

        ["\x79\xC3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xC3"],
        ["\xE0\xC3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x79\xC3"],

        ["\x79\xC4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xC4"],
        ["\xE0\xC4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x79\xC4"],

        ["\x79\xC5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xC5"],
        ["\xE0\xC5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x79\xC5"],

        ["\x79\xC6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xC6"],
        ["\xE0\xC6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x79\xC6"],

        ["\x79\xC7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xC7"],
        ["\xE0\xC7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x79\xC7"],

        ["\x79\xC8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xC8"],
        ["\xE0\xC8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x79\xC8"],

        ["\x79\xC9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xC9"],
        ["\xE0\xC9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x79\xC9"],

        ["\x79\xD1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xCA"],
        ["\xE0\xCA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x79\xD1"],

        ["\x79\xD2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xCB"],
        ["\xE0\xCB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x79\xD2"],

        ["\x79\xD3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xCC"],
        ["\xE0\xCC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x79\xD3"],

        ["\x79\xD4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xCD"],
        ["\xE0\xCD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x79\xD4"],

        ["\x79\xD5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xCE"],
        ["\xE0\xCE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x79\xD5"],

        ["\x79\xD6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xCF"],
        ["\xE0\xCF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x79\xD6"],

        ["\x79\xD7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xD0"],
        ["\xE0\xD0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x79\xD7"],

        ["\x79\xD8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xD1"],
        ["\xE0\xD1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x79\xD8"],

        ["\x79\xD9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xD2"],
        ["\xE0\xD2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x79\xD9"],

        ["\x79\xE2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xD3"],
        ["\xE0\xD3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x79\xE2"],

        ["\x79\xE3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xD4"],
        ["\xE0\xD4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x79\xE3"],

        ["\x79\xE4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xD5"],
        ["\xE0\xD5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x79\xE4"],

        ["\x79\xE5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xD6"],
        ["\xE0\xD6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x79\xE5"],

        ["\x79\xE6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xD7"],
        ["\xE0\xD7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x79\xE6"],

        ["\x79\xE7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xD8"],
        ["\xE0\xD8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x79\xE7"],

        ["\x79\xE8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xD9"],
        ["\xE0\xD9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x79\xE8"],

        ["\x79\xE9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xDA"],
        ["\xE0\xDA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x79\xE9"],

        ["\x79\x4A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xDB"],
        ["\xE0\xDB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x79\x4A"],

        ["\x79\x5B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xDC"],
        ["\xE0\xDC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x79\x5B"],

        ["\x79\x5A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xDD"],
        ["\xE0\xDD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x79\x5A"],

        ["\x79\x5F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xDE"],
        ["\xE0\xDE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x79\x5F"],

        ["\x79\x6D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xDF"],
        ["\xE0\xDF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x79\x6D"],

        ["\x79\x79",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xE0"],
        ["\xE0\xE0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x79\x79"],

        ["\x79\x57",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xE1"],
        ["\xE0\xE1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x79\x57"],

        ["\x79\x59",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xE2"],
        ["\xE0\xE2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x79\x59"],

        ["\x79\x62",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xE3"],
        ["\xE0\xE3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x79\x62"],

        ["\x79\x63",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xE4"],
        ["\xE0\xE4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x79\x63"],

        ["\x79\x64",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xE5"],
        ["\xE0\xE5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x79\x64"],

        ["\x79\x65",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xE6"],
        ["\xE0\xE6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x79\x65"],

        ["\x79\x66",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xE7"],
        ["\xE0\xE7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x79\x66"],

        ["\x79\x67",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xE8"],
        ["\xE0\xE8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x79\x67"],

        ["\x79\x68",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xE9"],
        ["\xE0\xE9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x79\x68"],

        ["\x79\x69",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xEA"],
        ["\xE0\xEA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x79\x69"],

        ["\x79\x70",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xEB"],
        ["\xE0\xEB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x79\x70"],

        ["\x79\x71",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xEC"],
        ["\xE0\xEC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x79\x71"],

        ["\x79\x72",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xED"],
        ["\xE0\xED",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x79\x72"],

        ["\x79\x73",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xEE"],
        ["\xE0\xEE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x79\x73"],

        ["\x79\x74",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xEF"],
        ["\xE0\xEF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x79\x74"],

        ["\x79\x75",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xF0"],
        ["\xE0\xF0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x79\x75"],

        ["\x79\x76",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xF1"],
        ["\xE0\xF1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x79\x76"],

        ["\x79\x77",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xF2"],
        ["\xE0\xF2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x79\x77"],

        ["\x79\x78",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xF3"],
        ["\xE0\xF3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x79\x78"],

        ["\x79\x80",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xF4"],
        ["\xE0\xF4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x79\x80"],

        ["\x79\x8B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xF5"],
        ["\xE0\xF5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x79\x8B"],

        ["\x95\xCA",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xF6"],
        ["\xE0\xF6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x95\xCA"],

        ["\x79\x9C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xF7"],
        ["\xE0\xF7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x79\x9C"],

        ["\x79\xA0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xF8"],
        ["\xE0\xF8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x79\xA0"],

        ["\x79\xAB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xF9"],
        ["\xE0\xF9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x79\xAB"],

        ["\x79\xB0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xFA"],
        ["\xE0\xFA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x79\xB0"],

        ["\x79\xC0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xFB"],
        ["\xE0\xFB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x79\xC0"],

        ["\x79\x6A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xFC"],
        ["\xE0\xFC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x79\x6A"],

        ["\x79\xD0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xFD"],
        ["\xE0\xFD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x79\xD0"],

        ["\x79\xA1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE0\xFE"],
        ["\xE0\xFE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x79\xA1"],

        ["\x57\x4F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xA1"],
        ["\xE1\xA1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\x4F"],

        ["\x57\x7F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xA2"],
        ["\xE1\xA2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\x7F"],

        ["\x57\x7B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xA3"],
        ["\xE1\xA3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\x7B"],

        ["\x57\xE0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xA4"],
        ["\xE1\xA4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\xE0"],

        ["\x57\x6C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xA5"],
        ["\xE1\xA5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\x6C"],

        ["\x57\x50",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xA6"],
        ["\xE1\xA6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\x50"],

        ["\x57\x7D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xA7"],
        ["\xE1\xA7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\x7D"],

        ["\x57\x4D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xA8"],
        ["\xE1\xA8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\x4D"],

        ["\x57\x5D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xA9"],
        ["\xE1\xA9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\x5D"],

        ["\x57\x5C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xAA"],
        ["\xE1\xAA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\x5C"],

        ["\x57\x4E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xAB"],
        ["\xE1\xAB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\x4E"],

        ["\x57\x6B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xAC"],
        ["\xE1\xAC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\x6B"],

        ["\x57\x60",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xAD"],
        ["\xE1\xAD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\x60"],

        ["\x57\x4B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xAE"],
        ["\xE1\xAE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\x4B"],

        ["\x57\x61",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xAF"],
        ["\xE1\xAF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\x61"],

        ["\x57\xF0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xB0"],
        ["\xE1\xB0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\xF0"],

        ["\x57\xF1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xB1"],
        ["\xE1\xB1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\xF1"],

        ["\x57\xF2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xB2"],
        ["\xE1\xB2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\xF2"],

        ["\x57\xF3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xB3"],
        ["\xE1\xB3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\xF3"],

        ["\x57\xF4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xB4"],
        ["\xE1\xB4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\xF4"],

        ["\x57\xF5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xB5"],
        ["\xE1\xB5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\xF5"],

        ["\x57\xF6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xB6"],
        ["\xE1\xB6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\xF6"],

        ["\x57\xF7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xB7"],
        ["\xE1\xB7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\xF7"],

        ["\x57\xF8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xB8"],
        ["\xE1\xB8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\xF8"],

        ["\x57\xF9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xB9"],
        ["\xE1\xB9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\xF9"],

        ["\x57\x7A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xBA"],
        ["\xE1\xBA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\x7A"],

        ["\x57\x5E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xBB"],
        ["\xE1\xBB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\x5E"],

        ["\x57\x4C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xBC"],
        ["\xE1\xBC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\x4C"],

        ["\x57\x7E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xBD"],
        ["\xE1\xBD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\x7E"],

        ["\x57\x6E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xBE"],
        ["\xE1\xBE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\x6E"],

        ["\x57\x6F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xBF"],
        ["\xE1\xBF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\x6F"],

        ["\x57\x7C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xC0"],
        ["\xE1\xC0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\x7C"],

        ["\x57\xC1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xC1"],
        ["\xE1\xC1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\xC1"],

        ["\x57\xC2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xC2"],
        ["\xE1\xC2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\xC2"],

        ["\x57\xC3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xC3"],
        ["\xE1\xC3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\xC3"],

        ["\x57\xC4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xC4"],
        ["\xE1\xC4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\xC4"],

        ["\x57\xC5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xC5"],
        ["\xE1\xC5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\xC5"],

        ["\x57\xC6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xC6"],
        ["\xE1\xC6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\xC6"],

        ["\x57\xC7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xC7"],
        ["\xE1\xC7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\xC7"],

        ["\x57\xC8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xC8"],
        ["\xE1\xC8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\xC8"],

        ["\x57\xC9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xC9"],
        ["\xE1\xC9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\xC9"],

        ["\x57\xD1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xCA"],
        ["\xE1\xCA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\xD1"],

        ["\x57\xD2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xCB"],
        ["\xE1\xCB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\xD2"],

        ["\x57\xD3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xCC"],
        ["\xE1\xCC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\xD3"],

        ["\x57\xD4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xCD"],
        ["\xE1\xCD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\xD4"],

        ["\x57\xD5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xCE"],
        ["\xE1\xCE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\xD5"],

        ["\x57\xD6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xCF"],
        ["\xE1\xCF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\xD6"],

        ["\x57\xD7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xD0"],
        ["\xE1\xD0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\xD7"],

        ["\x57\xD8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xD1"],
        ["\xE1\xD1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\xD8"],

        ["\x57\xD9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xD2"],
        ["\xE1\xD2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\xD9"],

        ["\x57\xE2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xD3"],
        ["\xE1\xD3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\xE2"],

        ["\x57\xE3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xD4"],
        ["\xE1\xD4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\xE3"],

        ["\x57\xE4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xD5"],
        ["\xE1\xD5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\xE4"],

        ["\x57\xE5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xD6"],
        ["\xE1\xD6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\xE5"],

        ["\x57\xE6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xD7"],
        ["\xE1\xD7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\xE6"],

        ["\x57\xE7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xD8"],
        ["\xE1\xD8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\xE7"],

        ["\x57\xE8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xD9"],
        ["\xE1\xD9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\xE8"],

        ["\x57\xE9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xDA"],
        ["\xE1\xDA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\xE9"],

        ["\x57\x4A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xDB"],
        ["\xE1\xDB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\x4A"],

        ["\x57\x5B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xDC"],
        ["\xE1\xDC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\x5B"],

        ["\x57\x5A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xDD"],
        ["\xE1\xDD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\x5A"],

        ["\x57\x5F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xDE"],
        ["\xE1\xDE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\x5F"],

        ["\x57\x6D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xDF"],
        ["\xE1\xDF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\x6D"],

        ["\x57\x79",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xE0"],
        ["\xE1\xE0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\x79"],

        ["\x57\x57",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xE1"],
        ["\xE1\xE1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\x57"],

        ["\x57\x59",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xE2"],
        ["\xE1\xE2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\x59"],

        ["\x57\x62",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xE3"],
        ["\xE1\xE3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\x62"],

        ["\x57\x63",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xE4"],
        ["\xE1\xE4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\x63"],

        ["\x57\x64",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xE5"],
        ["\xE1\xE5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\x64"],

        ["\x57\x65",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xE6"],
        ["\xE1\xE6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\x65"],

        ["\x57\x66",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xE7"],
        ["\xE1\xE7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\x66"],

        ["\x57\x67",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xE8"],
        ["\xE1\xE8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\x67"],

        ["\x57\x68",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xE9"],
        ["\xE1\xE9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\x68"],

        ["\x57\x69",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xEA"],
        ["\xE1\xEA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\x69"],

        ["\x57\x70",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xEB"],
        ["\xE1\xEB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\x70"],

        ["\x57\x71",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xEC"],
        ["\xE1\xEC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\x71"],

        ["\x57\x72",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xED"],
        ["\xE1\xED",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\x72"],

        ["\x57\x73",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xEE"],
        ["\xE1\xEE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\x73"],

        ["\x57\x74",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xEF"],
        ["\xE1\xEF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\x74"],

        ["\x57\x75",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xF0"],
        ["\xE1\xF0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\x75"],

        ["\x57\x76",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xF1"],
        ["\xE1\xF1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\x76"],

        ["\x57\x77",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xF2"],
        ["\xE1\xF2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\x77"],

        ["\x57\x78",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xF3"],
        ["\xE1\xF3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\x78"],

        ["\x57\x80",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xF4"],
        ["\xE1\xF4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\x80"],

        ["\x57\x8B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xF5"],
        ["\xE1\xF5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\x8B"],

        ["\x57\x9B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xF6"],
        ["\xE1\xF6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\x9B"],

        ["\x57\x9C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xF7"],
        ["\xE1\xF7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\x9C"],

        ["\x57\xA0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xF8"],
        ["\xE1\xF8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\xA0"],

        ["\x57\xAB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xF9"],
        ["\xE1\xF9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\xAB"],

        ["\x57\xB0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xFA"],
        ["\xE1\xFA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\xB0"],

        ["\x57\xC0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xFB"],
        ["\xE1\xFB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\xC0"],

        ["\x57\x6A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xFC"],
        ["\xE1\xFC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\x6A"],

        ["\x57\xD0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xFD"],
        ["\xE1\xFD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\xD0"],

        ["\x57\xA1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE1\xFE"],
        ["\xE1\xFE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\xA1"],

        ["\x59\x4F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xA1"],
        ["\xE2\xA1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\x4F"],

        ["\x59\x7F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xA2"],
        ["\xE2\xA2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\x7F"],

        ["\x59\x7B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xA3"],
        ["\xE2\xA3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\x7B"],

        ["\x59\xE0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xA4"],
        ["\xE2\xA4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\xE0"],

        ["\x59\x6C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xA5"],
        ["\xE2\xA5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\x6C"],

        ["\x59\x50",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xA6"],
        ["\xE2\xA6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\x50"],

        ["\x59\x7D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xA7"],
        ["\xE2\xA7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\x7D"],

        ["\x59\x4D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xA8"],
        ["\xE2\xA8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\x4D"],

        ["\x59\x5D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xA9"],
        ["\xE2\xA9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\x5D"],

        ["\x59\x5C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xAA"],
        ["\xE2\xAA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\x5C"],

        ["\x59\x4E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xAB"],
        ["\xE2\xAB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\x4E"],

        ["\x59\x6B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xAC"],
        ["\xE2\xAC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\x6B"],

        ["\x59\x60",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xAD"],
        ["\xE2\xAD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\x60"],

        ["\x59\x4B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xAE"],
        ["\xE2\xAE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\x4B"],

        ["\x59\x61",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xAF"],
        ["\xE2\xAF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\x61"],

        ["\x59\xF0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xB0"],
        ["\xE2\xB0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\xF0"],

        ["\x59\xF1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xB1"],
        ["\xE2\xB1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\xF1"],

        ["\x59\xF2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xB2"],
        ["\xE2\xB2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\xF2"],

        ["\x59\xF3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xB3"],
        ["\xE2\xB3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\xF3"],

        ["\x59\xF4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xB4"],
        ["\xE2\xB4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\xF4"],

        ["\x59\xF5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xB5"],
        ["\xE2\xB5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\xF5"],

        ["\x59\xF6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xB6"],
        ["\xE2\xB6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\xF6"],

        ["\x59\xF7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xB7"],
        ["\xE2\xB7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\xF7"],

        ["\x59\xF8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xB8"],
        ["\xE2\xB8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\xF8"],

        ["\x59\xF9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xB9"],
        ["\xE2\xB9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\xF9"],

        ["\x59\x7A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xBA"],
        ["\xE2\xBA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\x7A"],

        ["\x59\x5E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xBB"],
        ["\xE2\xBB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\x5E"],

        ["\x59\x4C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xBC"],
        ["\xE2\xBC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\x4C"],

        ["\x59\x7E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xBD"],
        ["\xE2\xBD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\x7E"],

        ["\x59\x6E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xBE"],
        ["\xE2\xBE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\x6E"],

        ["\x59\x6F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xBF"],
        ["\xE2\xBF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\x6F"],

        ["\x59\x7C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xC0"],
        ["\xE2\xC0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\x7C"],

        ["\x59\xC1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xC1"],
        ["\xE2\xC1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\xC1"],

        ["\x59\xC2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xC2"],
        ["\xE2\xC2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\xC2"],

        ["\x59\xC3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xC3"],
        ["\xE2\xC3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\xC3"],

        ["\x59\xC4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xC4"],
        ["\xE2\xC4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\xC4"],

        ["\x59\xC5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xC5"],
        ["\xE2\xC5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\xC5"],

        ["\x59\xC6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xC6"],
        ["\xE2\xC6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\xC6"],

        ["\x59\xC7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xC7"],
        ["\xE2\xC7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\xC7"],

        ["\x59\xC8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xC8"],
        ["\xE2\xC8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\xC8"],

        ["\x59\xC9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xC9"],
        ["\xE2\xC9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\xC9"],

        ["\x59\xD1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xCA"],
        ["\xE2\xCA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\xD1"],

        ["\x59\xD2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xCB"],
        ["\xE2\xCB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\xD2"],

        ["\x59\xD3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xCC"],
        ["\xE2\xCC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\xD3"],

        ["\x59\xD4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xCD"],
        ["\xE2\xCD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\xD4"],

        ["\x59\xD5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xCE"],
        ["\xE2\xCE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\xD5"],

        ["\x59\xD6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xCF"],
        ["\xE2\xCF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\xD6"],

        ["\x59\xD7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xD0"],
        ["\xE2\xD0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\xD7"],

        ["\x59\xD8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xD1"],
        ["\xE2\xD1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\xD8"],

        ["\x59\xD9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xD2"],
        ["\xE2\xD2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\xD9"],

        ["\x59\xE2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xD3"],
        ["\xE2\xD3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\xE2"],

        ["\x59\xE3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xD4"],
        ["\xE2\xD4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\xE3"],

        ["\x59\xE4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xD5"],
        ["\xE2\xD5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\xE4"],

        ["\x59\xE5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xD6"],
        ["\xE2\xD6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\xE5"],

        ["\x59\xE6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xD7"],
        ["\xE2\xD7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\xE6"],

        ["\x59\xE7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xD8"],
        ["\xE2\xD8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\xE7"],

        ["\x59\xE8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xD9"],
        ["\xE2\xD9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\xE8"],

        ["\x59\xE9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xDA"],
        ["\xE2\xDA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\xE9"],

        ["\x59\x4A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xDB"],
        ["\xE2\xDB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\x4A"],

        ["\x59\x5B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xDC"],
        ["\xE2\xDC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\x5B"],

        ["\x59\x5A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xDD"],
        ["\xE2\xDD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\x5A"],

        ["\x59\x5F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xDE"],
        ["\xE2\xDE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\x5F"],

        ["\x59\x6D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xDF"],
        ["\xE2\xDF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\x6D"],

        ["\x59\x79",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xE0"],
        ["\xE2\xE0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\x79"],

        ["\x59\x57",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xE1"],
        ["\xE2\xE1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\x57"],

        ["\x59\x59",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xE2"],
        ["\xE2\xE2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\x59"],

        ["\x59\x62",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xE3"],
        ["\xE2\xE3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\x62"],

        ["\x59\x63",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xE4"],
        ["\xE2\xE4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\x63"],

        ["\x59\x64",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xE5"],
        ["\xE2\xE5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\x64"],

        ["\x59\x65",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xE6"],
        ["\xE2\xE6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\x65"],

        ["\x59\x66",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xE7"],
        ["\xE2\xE7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\x66"],

        ["\xF9\x5B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xE8"],
        ["\xE2\xE8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF9\x5B"],

        ["\x59\x68",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xE9"],
        ["\xE2\xE9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\x68"],

        ["\xC5\xE6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xEA"],
        ["\xE2\xEA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xE6"],

        ["\x59\x70",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xEB"],
        ["\xE2\xEB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\x70"],

        ["\x59\x71",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xEC"],
        ["\xE2\xEC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\x71"],

        ["\x59\x72",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xED"],
        ["\xE2\xED",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\x72"],

        ["\x59\x73",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xEE"],
        ["\xE2\xEE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\x73"],

        ["\x59\x74",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xEF"],
        ["\xE2\xEF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\x74"],

        ["\x59\x75",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xF0"],
        ["\xE2\xF0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\x75"],

        ["\x59\x76",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xF1"],
        ["\xE2\xF1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\x76"],

        ["\x59\x77",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xF2"],
        ["\xE2\xF2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\x77"],

        ["\x59\x78",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xF3"],
        ["\xE2\xF3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\x78"],

        ["\x59\x80",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xF4"],
        ["\xE2\xF4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\x80"],

        ["\x59\x8B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xF5"],
        ["\xE2\xF5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\x8B"],

        ["\x59\x9B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xF6"],
        ["\xE2\xF6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\x9B"],

        ["\x59\x9C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xF7"],
        ["\xE2\xF7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\x9C"],

        ["\x59\xA0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xF8"],
        ["\xE2\xF8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\xA0"],

        ["\x59\xAB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xF9"],
        ["\xE2\xF9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\xAB"],

        ["\x59\xB0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xFA"],
        ["\xE2\xFA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\xB0"],

        ["\x59\xC0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xFB"],
        ["\xE2\xFB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\xC0"],

        ["\x59\x6A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xFC"],
        ["\xE2\xFC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\x6A"],

        ["\x59\xD0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xFD"],
        ["\xE2\xFD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\xD0"],

        ["\x59\xA1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\xFE"],
        ["\xE2\xFE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\xA1"],

        ["\x62\x4F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xA1"],
        ["\xE3\xA1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\x4F"],

        ["\x62\x7F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xA2"],
        ["\xE3\xA2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\x7F"],

        ["\x62\x7B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xA3"],
        ["\xE3\xA3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\x7B"],

        ["\x62\xE0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xA4"],
        ["\xE3\xA4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\xE0"],

        ["\x62\x6C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xA5"],
        ["\xE3\xA5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\x6C"],

        ["\x62\x50",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xA6"],
        ["\xE3\xA6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\x50"],

        ["\x62\x7D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xA7"],
        ["\xE3\xA7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\x7D"],

        ["\x62\x4D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xA8"],
        ["\xE3\xA8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\x4D"],

        ["\x62\x5D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xA9"],
        ["\xE3\xA9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\x5D"],

        ["\x62\x5C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xAA"],
        ["\xE3\xAA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\x5C"],

        ["\x62\x4E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xAB"],
        ["\xE3\xAB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\x4E"],

        ["\x62\x6B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xAC"],
        ["\xE3\xAC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\x6B"],

        ["\x62\x60",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xAD"],
        ["\xE3\xAD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\x60"],

        ["\x62\x4B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xAE"],
        ["\xE3\xAE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\x4B"],

        ["\x62\x61",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xAF"],
        ["\xE3\xAF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\x61"],

        ["\x62\xF0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xB0"],
        ["\xE3\xB0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\xF0"],

        ["\x62\xF1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xB1"],
        ["\xE3\xB1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\xF1"],

        ["\x62\xF2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xB2"],
        ["\xE3\xB2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\xF2"],

        ["\x62\xF3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xB3"],
        ["\xE3\xB3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\xF3"],

        ["\x62\xF4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xB4"],
        ["\xE3\xB4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\xF4"],

        ["\x62\xF5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xB5"],
        ["\xE3\xB5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\xF5"],

        ["\x62\xF6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xB6"],
        ["\xE3\xB6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\xF6"],

        ["\x62\xF7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xB7"],
        ["\xE3\xB7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\xF7"],

        ["\x62\xF8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xB8"],
        ["\xE3\xB8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\xF8"],

        ["\x62\xF9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xB9"],
        ["\xE3\xB9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\xF9"],

        ["\x62\x7A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xBA"],
        ["\xE3\xBA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\x7A"],

        ["\x62\x5E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xBB"],
        ["\xE3\xBB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\x5E"],

        ["\x62\x4C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xBC"],
        ["\xE3\xBC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\x4C"],

        ["\x62\x7E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xBD"],
        ["\xE3\xBD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\x7E"],

        ["\x62\x6E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xBE"],
        ["\xE3\xBE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\x6E"],

        ["\x62\x6F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xBF"],
        ["\xE3\xBF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\x6F"],

        ["\x62\x7C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xC0"],
        ["\xE3\xC0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\x7C"],

        ["\x62\xC1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xC1"],
        ["\xE3\xC1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\xC1"],

        ["\x62\xC2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xC2"],
        ["\xE3\xC2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\xC2"],

        ["\x62\xC3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xC3"],
        ["\xE3\xC3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\xC3"],

        ["\x62\xC4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xC4"],
        ["\xE3\xC4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\xC4"],

        ["\x62\xC5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xC5"],
        ["\xE3\xC5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\xC5"],

        ["\x62\xC6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xC6"],
        ["\xE3\xC6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\xC6"],

        ["\x62\xC7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xC7"],
        ["\xE3\xC7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\xC7"],

        ["\x62\xC8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xC8"],
        ["\xE3\xC8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\xC8"],

        ["\x62\xC9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xC9"],
        ["\xE3\xC9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\xC9"],

        ["\x62\xD1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xCA"],
        ["\xE3\xCA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\xD1"],

        ["\x62\xD2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xCB"],
        ["\xE3\xCB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\xD2"],

        ["\x62\xD3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xCC"],
        ["\xE3\xCC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\xD3"],

        ["\x62\xD4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xCD"],
        ["\xE3\xCD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\xD4"],

        ["\x62\xD5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xCE"],
        ["\xE3\xCE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\xD5"],

        ["\x62\xD6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xCF"],
        ["\xE3\xCF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\xD6"],

        ["\x62\xD7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xD0"],
        ["\xE3\xD0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\xD7"],

        ["\x62\xD8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xD1"],
        ["\xE3\xD1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\xD8"],

        ["\x62\xD9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xD2"],
        ["\xE3\xD2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\xD9"],

        ["\x62\xE2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xD3"],
        ["\xE3\xD3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\xE2"],

        ["\x62\xE3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xD4"],
        ["\xE3\xD4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\xE3"],

        ["\x62\xE4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xD5"],
        ["\xE3\xD5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\xE4"],

        ["\x62\xE5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xD6"],
        ["\xE3\xD6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\xE5"],

        ["\x62\xE6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xD7"],
        ["\xE3\xD7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\xE6"],

        ["\x62\xE7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xD8"],
        ["\xE3\xD8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\xE7"],

        ["\x62\xE8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xD9"],
        ["\xE3\xD9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\xE8"],

        ["\x62\xE9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xDA"],
        ["\xE3\xDA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\xE9"],

        ["\x62\x4A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xDB"],
        ["\xE3\xDB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\x4A"],

        ["\x62\x5B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xDC"],
        ["\xE3\xDC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\x5B"],

        ["\x62\x5A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xDD"],
        ["\xE3\xDD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\x5A"],

        ["\xF3\x9B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xDE"],
        ["\xE3\xDE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\x9B"],

        ["\x62\x6D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xDF"],
        ["\xE3\xDF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\x6D"],

        ["\x62\x79",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xE0"],
        ["\xE3\xE0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\x79"],

        ["\x62\x57",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xE1"],
        ["\xE3\xE1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\x57"],

        ["\x62\x59",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xE2"],
        ["\xE3\xE2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\x59"],

        ["\x62\x62",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xE3"],
        ["\xE3\xE3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\x62"],

        ["\x62\x63",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xE4"],
        ["\xE3\xE4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\x63"],

        ["\x62\x64",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xE5"],
        ["\xE3\xE5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\x64"],

        ["\x62\x65",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xE6"],
        ["\xE3\xE6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\x65"],

        ["\x62\x66",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xE7"],
        ["\xE3\xE7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\x66"],

        ["\x62\x67",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xE8"],
        ["\xE3\xE8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\x67"],

        ["\x62\x68",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xE9"],
        ["\xE3\xE9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\x68"],

        ["\x62\x69",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xEA"],
        ["\xE3\xEA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\x69"],

        ["\x62\x70",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xEB"],
        ["\xE3\xEB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\x70"],

        ["\x62\x71",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xEC"],
        ["\xE3\xEC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\x71"],

        ["\x62\x72",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xED"],
        ["\xE3\xED",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\x72"],

        ["\x62\x73",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xEE"],
        ["\xE3\xEE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\x73"],

        ["\x62\x74",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xEF"],
        ["\xE3\xEF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\x74"],

        ["\x62\x75",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xF0"],
        ["\xE3\xF0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\x75"],

        ["\x62\x76",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xF1"],
        ["\xE3\xF1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\x76"],

        ["\x62\x77",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xF2"],
        ["\xE3\xF2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\x77"],

        ["\x62\x78",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xF3"],
        ["\xE3\xF3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\x78"],

        ["\x62\x80",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xF4"],
        ["\xE3\xF4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\x80"],

        ["\x62\x8B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xF5"],
        ["\xE3\xF5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\x8B"],

        ["\x62\x9B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xF6"],
        ["\xE3\xF6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\x9B"],

        ["\x62\x9C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xF7"],
        ["\xE3\xF7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\x9C"],

        ["\x62\xA0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xF8"],
        ["\xE3\xF8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\xA0"],

        ["\x62\xAB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xF9"],
        ["\xE3\xF9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\xAB"],

        ["\x62\xB0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xFA"],
        ["\xE3\xFA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\xB0"],

        ["\x62\xC0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xFB"],
        ["\xE3\xFB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\xC0"],

        ["\x62\x6A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xFC"],
        ["\xE3\xFC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\x6A"],

        ["\x62\xD0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xFD"],
        ["\xE3\xFD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\xD0"],

        ["\x62\xA1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\xFE"],
        ["\xE3\xFE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\xA1"],

        ["\x63\x4F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xA1"],
        ["\xE4\xA1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\x4F"],

        ["\x63\x7F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xA2"],
        ["\xE4\xA2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\x7F"],

        ["\x63\x7B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xA3"],
        ["\xE4\xA3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\x7B"],

        ["\x63\xE0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xA4"],
        ["\xE4\xA4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\xE0"],

        ["\x63\x6C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xA5"],
        ["\xE4\xA5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\x6C"],

        ["\x63\x50",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xA6"],
        ["\xE4\xA6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\x50"],

        ["\x63\x7D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xA7"],
        ["\xE4\xA7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\x7D"],

        ["\x63\x4D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xA8"],
        ["\xE4\xA8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\x4D"],

        ["\x63\x5D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xA9"],
        ["\xE4\xA9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\x5D"],

        ["\x63\x5C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xAA"],
        ["\xE4\xAA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\x5C"],

        ["\x63\x4E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xAB"],
        ["\xE4\xAB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\x4E"],

        ["\x63\x6B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xAC"],
        ["\xE4\xAC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\x6B"],

        ["\x63\x60",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xAD"],
        ["\xE4\xAD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\x60"],

        ["\x63\x4B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xAE"],
        ["\xE4\xAE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\x4B"],

        ["\x63\x61",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xAF"],
        ["\xE4\xAF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\x61"],

        ["\x63\xF0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xB0"],
        ["\xE4\xB0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\xF0"],

        ["\x63\xF1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xB1"],
        ["\xE4\xB1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\xF1"],

        ["\x63\xF2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xB2"],
        ["\xE4\xB2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\xF2"],

        ["\x63\xF3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xB3"],
        ["\xE4\xB3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\xF3"],

        ["\x63\xF4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xB4"],
        ["\xE4\xB4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\xF4"],

        ["\x63\xF5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xB5"],
        ["\xE4\xB5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\xF5"],

        ["\x63\xF6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xB6"],
        ["\xE4\xB6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\xF6"],

        ["\x63\xF7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xB7"],
        ["\xE4\xB7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\xF7"],

        ["\x63\xF8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8"],
        ["\xE4\xB8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\xF8"],

        ["\x63\xF9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xB9"],
        ["\xE4\xB9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\xF9"],

        ["\x63\x7A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA"],
        ["\xE4\xBA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\x7A"],

        ["\x63\x5E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB"],
        ["\xE4\xBB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\x5E"],

        ["\x63\x4C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBC"],
        ["\xE4\xBC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\x4C"],

        ["\x63\x7E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD"],
        ["\xE4\xBD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\x7E"],

        ["\x63\x6E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE"],
        ["\xE4\xBE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\x6E"],

        ["\x63\x6F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF"],
        ["\xE4\xBF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\x6F"],

        ["\x63\x7C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xC0"],
        ["\xE4\xC0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\x7C"],

        ["\x63\xC1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xC1"],
        ["\xE4\xC1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\xC1"],

        ["\x63\xC2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xC2"],
        ["\xE4\xC2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\xC2"],

        ["\x63\xC3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xC3"],
        ["\xE4\xC3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\xC3"],

        ["\x63\xC4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xC4"],
        ["\xE4\xC4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\xC4"],

        ["\x63\xC5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xC5"],
        ["\xE4\xC5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\xC5"],

        ["\xD6\xF6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xC6"],
        ["\xE4\xC6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xF6"],

        ["\x63\xC7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xC7"],
        ["\xE4\xC7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\xC7"],

        ["\x63\xC8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xC8"],
        ["\xE4\xC8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\xC8"],

        ["\x63\xC9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xC9"],
        ["\xE4\xC9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\xC9"],

        ["\x63\xD1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xCA"],
        ["\xE4\xCA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\xD1"],

        ["\x63\xD2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xCB"],
        ["\xE4\xCB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\xD2"],

        ["\x63\xD3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xCC"],
        ["\xE4\xCC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\xD3"],

        ["\x63\xD4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xCD"],
        ["\xE4\xCD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\xD4"],

        ["\x63\xD5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xCE"],
        ["\xE4\xCE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\xD5"],

        ["\x63\xD6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xCF"],
        ["\xE4\xCF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\xD6"],

        ["\x63\xD7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xD0"],
        ["\xE4\xD0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\xD7"],

        ["\x63\xD8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xD1"],
        ["\xE4\xD1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\xD8"],

        ["\x63\xD9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xD2"],
        ["\xE4\xD2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\xD9"],

        ["\x63\xE2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xD3"],
        ["\xE4\xD3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\xE2"],

        ["\x63\xE3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xD4"],
        ["\xE4\xD4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\xE3"],

        ["\x63\xE4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xD5"],
        ["\xE4\xD5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\xE4"],

        ["\x63\xE5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xD6"],
        ["\xE4\xD6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\xE5"],

        ["\x63\xE6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xD7"],
        ["\xE4\xD7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\xE6"],

        ["\x63\xE7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xD8"],
        ["\xE4\xD8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\xE7"],

        ["\x63\xE8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xD9"],
        ["\xE4\xD9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\xE8"],

        ["\x63\xE9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xDA"],
        ["\xE4\xDA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\xE9"],

        ["\x63\x4A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xDB"],
        ["\xE4\xDB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\x4A"],

        ["\x63\x5B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xDC"],
        ["\xE4\xDC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\x5B"],

        ["\x63\x5A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xDD"],
        ["\xE4\xDD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\x5A"],

        ["\x63\x5F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xDE"],
        ["\xE4\xDE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\x5F"],

        ["\x63\x6D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xDF"],
        ["\xE4\xDF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\x6D"],

        ["\x63\x79",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xE0"],
        ["\xE4\xE0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\x79"],

        ["\x63\x57",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xE1"],
        ["\xE4\xE1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\x57"],

        ["\x63\x59",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xE2"],
        ["\xE4\xE2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\x59"],

        ["\x63\x62",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xE3"],
        ["\xE4\xE3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\x62"],

        ["\x63\x63",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xE4"],
        ["\xE4\xE4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\x63"],

        ["\x63\x64",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xE5"],
        ["\xE4\xE5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\x64"],

        ["\x63\x65",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xE6"],
        ["\xE4\xE6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\x65"],

        ["\x63\x66",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xE7"],
        ["\xE4\xE7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\x66"],

        ["\x63\x67",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xE8"],
        ["\xE4\xE8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\x67"],

        ["\x63\x68",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xE9"],
        ["\xE4\xE9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\x68"],

        ["\x63\x69",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xEA"],
        ["\xE4\xEA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\x69"],

        ["\x63\x70",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xEB"],
        ["\xE4\xEB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\x70"],

        ["\x63\x71",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xEC"],
        ["\xE4\xEC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\x71"],

        ["\x63\x72",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xED"],
        ["\xE4\xED",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\x72"],

        ["\x63\x73",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xEE"],
        ["\xE4\xEE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\x73"],

        ["\x63\x74",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xEF"],
        ["\xE4\xEF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\x74"],

        ["\x63\x75",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xF0"],
        ["\xE4\xF0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\x75"],

        ["\x63\x76",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xF1"],
        ["\xE4\xF1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\x76"],

        ["\x63\x77",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xF2"],
        ["\xE4\xF2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\x77"],

        ["\x63\x78",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xF3"],
        ["\xE4\xF3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\x78"],

        ["\x63\x80",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xF4"],
        ["\xE4\xF4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\x80"],

        ["\x63\x8B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xF5"],
        ["\xE4\xF5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\x8B"],

        ["\x63\x9B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xF6"],
        ["\xE4\xF6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\x9B"],

        ["\x63\x9C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xF7"],
        ["\xE4\xF7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\x9C"],

        ["\x63\xA0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xF8"],
        ["\xE4\xF8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\xA0"],

        ["\x63\xAB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xF9"],
        ["\xE4\xF9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\xAB"],

        ["\x63\xB0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xFA"],
        ["\xE4\xFA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\xB0"],

        ["\x63\xC0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xFB"],
        ["\xE4\xFB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\xC0"],

        ["\x63\x6A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xFC"],
        ["\xE4\xFC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\x6A"],

        ["\x63\xD0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xFD"],
        ["\xE4\xFD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\xD0"],

        ["\x63\xA1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xFE"],
        ["\xE4\xFE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\xA1"],

        ["\x64\x4F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA1"],
        ["\xE5\xA1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\x4F"],

        ["\x64\x7F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA2"],
        ["\xE5\xA2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\x7F"],

        ["\x64\x7B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3"],
        ["\xE5\xA3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\x7B"],

        ["\x64\xE0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4"],
        ["\xE5\xA4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\xE0"],

        ["\x64\x6C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5"],
        ["\xE5\xA5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\x6C"],

        ["\x64\x50",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA6"],
        ["\xE5\xA6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\x50"],

        ["\x64\x7D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA7"],
        ["\xE5\xA7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\x7D"],

        ["\x64\x4D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA8"],
        ["\xE5\xA8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\x4D"],

        ["\x64\x5D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA9"],
        ["\xE5\xA9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\x5D"],

        ["\x64\x5C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAA"],
        ["\xE5\xAA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\x5C"],

        ["\x64\x4E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAB"],
        ["\xE5\xAB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\x4E"],

        ["\x64\x6B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAC"],
        ["\xE5\xAC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\x6B"],

        ["\x64\x60",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD"],
        ["\xE5\xAD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\x60"],

        ["\x64\x4B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE"],
        ["\xE5\xAE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\x4B"],

        ["\x64\x61",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF"],
        ["\xE5\xAF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\x61"],

        ["\x64\xF0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0"],
        ["\xE5\xB0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\xF0"],

        ["\x64\xF1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1"],
        ["\xE5\xB1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\xF1"],

        ["\x64\xF2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB2"],
        ["\xE5\xB2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\xF2"],

        ["\x64\xF3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB3"],
        ["\xE5\xB3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\xF3"],

        ["\x64\xF4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB4"],
        ["\xE5\xB4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\xF4"],

        ["\x64\xF5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB5"],
        ["\xE5\xB5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\xF5"],

        ["\x64\xF6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB6"],
        ["\xE5\xB6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\xF6"],

        ["\x64\xF7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7"],
        ["\xE5\xB7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\xF7"],

        ["\x64\xF8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8"],
        ["\xE5\xB8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\xF8"],

        ["\x64\xF9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9"],
        ["\xE5\xB9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\xF9"],

        ["\x64\x7A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBA"],
        ["\xE5\xBA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\x7A"],

        ["\x64\x5E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB"],
        ["\xE5\xBB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\x5E"],

        ["\x64\x4C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC"],
        ["\xE5\xBC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\x4C"],

        ["\x64\x7E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD"],
        ["\xE5\xBD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\x7E"],

        ["\x64\x6E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE"],
        ["\xE5\xBE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\x6E"],

        ["\x64\x6F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF"],
        ["\xE5\xBF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\x6F"],

        ["\x64\x7C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xC0"],
        ["\xE5\xC0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\x7C"],

        ["\x64\xC1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xC1"],
        ["\xE5\xC1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\xC1"],

        ["\x64\xC2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xC2"],
        ["\xE5\xC2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\xC2"],

        ["\x64\xC3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xC3"],
        ["\xE5\xC3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\xC3"],

        ["\x64\xC4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xC4"],
        ["\xE5\xC4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\xC4"],

        ["\x64\xC5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xC5"],
        ["\xE5\xC5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\xC5"],

        ["\x64\xC6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xC6"],
        ["\xE5\xC6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\xC6"],

        ["\x64\xC7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xC7"],
        ["\xE5\xC7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\xC7"],

        ["\x64\xC8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xC8"],
        ["\xE5\xC8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\xC8"],

        ["\x64\xC9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xC9"],
        ["\xE5\xC9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\xC9"],

        ["\x64\xD1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xCA"],
        ["\xE5\xCA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\xD1"],

        ["\x64\xD2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xCB"],
        ["\xE5\xCB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\xD2"],

        ["\x64\xD3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xCC"],
        ["\xE5\xCC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\xD3"],

        ["\x64\xD4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xCD"],
        ["\xE5\xCD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\xD4"],

        ["\x64\xD5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xCE"],
        ["\xE5\xCE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\xD5"],

        ["\x64\xD6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xCF"],
        ["\xE5\xCF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\xD6"],

        ["\x64\xD7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xD0"],
        ["\xE5\xD0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\xD7"],

        ["\x64\xD8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xD1"],
        ["\xE5\xD1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\xD8"],

        ["\x64\xD9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xD2"],
        ["\xE5\xD2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\xD9"],

        ["\x64\xE2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xD3"],
        ["\xE5\xD3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\xE2"],

        ["\x64\xE3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xD4"],
        ["\xE5\xD4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\xE3"],

        ["\x64\xE4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xD5"],
        ["\xE5\xD5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\xE4"],

        ["\x64\xE5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xD6"],
        ["\xE5\xD6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\xE5"],

        ["\x64\xE6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xD7"],
        ["\xE5\xD7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\xE6"],

        ["\x64\xE7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xD8"],
        ["\xE5\xD8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\xE7"],

        ["\x64\xE8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xD9"],
        ["\xE5\xD9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\xE8"],

        ["\x64\xE9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xDA"],
        ["\xE5\xDA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\xE9"],

        ["\x64\x4A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xDB"],
        ["\xE5\xDB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\x4A"],

        ["\x64\x5B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xDC"],
        ["\xE5\xDC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\x5B"],

        ["\x64\x5A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xDD"],
        ["\xE5\xDD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\x5A"],

        ["\x64\x5F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xDE"],
        ["\xE5\xDE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\x5F"],

        ["\x64\x6D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xDF"],
        ["\xE5\xDF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\x6D"],

        ["\x64\x79",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xE0"],
        ["\xE5\xE0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\x79"],

        ["\x64\x57",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xE1"],
        ["\xE5\xE1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\x57"],

        ["\x64\x59",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xE2"],
        ["\xE5\xE2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\x59"],

        ["\x64\x62",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xE3"],
        ["\xE5\xE3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\x62"],

        ["\x64\x63",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xE4"],
        ["\xE5\xE4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\x63"],

        ["\x64\x64",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xE5"],
        ["\xE5\xE5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\x64"],

        ["\x64\x65",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xE6"],
        ["\xE5\xE6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\x65"],

        ["\x64\x66",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xE7"],
        ["\xE5\xE7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\x66"],

        ["\x64\x67",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xE8"],
        ["\xE5\xE8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\x67"],

        ["\x64\x68",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xE9"],
        ["\xE5\xE9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\x68"],

        ["\x64\x69",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xEA"],
        ["\xE5\xEA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\x69"],

        ["\x64\x70",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xEB"],
        ["\xE5\xEB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\x70"],

        ["\x64\x71",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xEC"],
        ["\xE5\xEC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\x71"],

        ["\x64\x72",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xED"],
        ["\xE5\xED",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\x72"],

        ["\x64\x73",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xEE"],
        ["\xE5\xEE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\x73"],

        ["\x64\x74",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xEF"],
        ["\xE5\xEF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\x74"],

        ["\x64\x75",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xF0"],
        ["\xE5\xF0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\x75"],

        ["\x64\x76",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xF1"],
        ["\xE5\xF1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\x76"],

        ["\x64\x77",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xF2"],
        ["\xE5\xF2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\x77"],

        ["\x64\x78",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xF3"],
        ["\xE5\xF3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\x78"],

        ["\x64\x80",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xF4"],
        ["\xE5\xF4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\x80"],

        ["\x64\x8B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xF5"],
        ["\xE5\xF5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\x8B"],

        ["\x64\x9B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xF6"],
        ["\xE5\xF6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\x9B"],

        ["\x64\x9C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xF7"],
        ["\xE5\xF7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\x9C"],

        ["\x64\xA0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xF8"],
        ["\xE5\xF8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\xA0"],

        ["\x64\xAB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xF9"],
        ["\xE5\xF9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\xAB"],

        ["\x64\xB0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xFA"],
        ["\xE5\xFA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\xB0"],

        ["\x64\xC0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xFB"],
        ["\xE5\xFB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\xC0"],

        ["\x64\x6A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xFC"],
        ["\xE5\xFC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\x6A"],

        ["\x64\xD0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xFD"],
        ["\xE5\xFD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\xD0"],

        ["\x64\xA1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xFE"],
        ["\xE5\xFE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\xA1"],

        ["\x65\x4F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1"],
        ["\xE6\xA1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\x4F"],

        ["\x65\x7F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2"],
        ["\xE6\xA2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\x7F"],

        ["\x65\x7B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3"],
        ["\xE6\xA3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\x7B"],

        ["\x65\xE0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4"],
        ["\xE6\xA4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\xE0"],

        ["\x65\x6C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5"],
        ["\xE6\xA5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\x6C"],

        ["\x65\x50",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA6"],
        ["\xE6\xA6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\x50"],

        ["\x65\x7D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7"],
        ["\xE6\xA7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\x7D"],

        ["\x65\x4D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8"],
        ["\xE6\xA8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\x4D"],

        ["\x65\x5D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA9"],
        ["\xE6\xA9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\x5D"],

        ["\x65\x5C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAA"],
        ["\xE6\xAA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\x5C"],

        ["\x65\x4E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAB"],
        ["\xE6\xAB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\x4E"],

        ["\x65\x6B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAC"],
        ["\xE6\xAC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\x6B"],

        ["\x65\x60",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD"],
        ["\xE6\xAD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\x60"],

        ["\x65\x4B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE"],
        ["\xE6\xAE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\x4B"],

        ["\x65\x61",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAF"],
        ["\xE6\xAF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\x61"],

        ["\x65\xF0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB0"],
        ["\xE6\xB0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\xF0"],

        ["\x65\xF1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1"],
        ["\xE6\xB1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\xF1"],

        ["\x65\xF2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2"],
        ["\xE6\xB2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\xF2"],

        ["\x65\xF3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3"],
        ["\xE6\xB3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\xF3"],

        ["\x65\xF4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4"],
        ["\xE6\xB4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\xF4"],

        ["\x65\xF5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB5"],
        ["\xE6\xB5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\xF5"],

        ["\x65\xF6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB6"],
        ["\xE6\xB6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\xF6"],

        ["\x65\xF7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7"],
        ["\xE6\xB7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\xF7"],

        ["\x65\xF8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8"],
        ["\xE6\xB8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\xF8"],

        ["\x65\xF9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB9"],
        ["\xE6\xB9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\xF9"],

        ["\x65\x7A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBA"],
        ["\xE6\xBA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\x7A"],

        ["\x65\x5E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBB"],
        ["\xE6\xBB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\x5E"],

        ["\x65\x4C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBC"],
        ["\xE6\xBC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\x4C"],

        ["\x65\x7E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBD"],
        ["\xE6\xBD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\x7E"],

        ["\x65\x6E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBE"],
        ["\xE6\xBE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\x6E"],

        ["\x65\x6F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF"],
        ["\xE6\xBF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\x6F"],

        ["\x65\x7C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xC0"],
        ["\xE6\xC0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\x7C"],

        ["\x65\xC1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xC1"],
        ["\xE6\xC1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\xC1"],

        ["\x65\xC2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xC2"],
        ["\xE6\xC2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\xC2"],

        ["\x65\xC3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xC3"],
        ["\xE6\xC3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\xC3"],

        ["\x65\xC4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xC4"],
        ["\xE6\xC4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\xC4"],

        ["\x65\xC5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xC5"],
        ["\xE6\xC5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\xC5"],

        ["\x65\xC6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xC6"],
        ["\xE6\xC6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\xC6"],

        ["\x65\xC7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xC7"],
        ["\xE6\xC7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\xC7"],

        ["\x65\xC8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xC8"],
        ["\xE6\xC8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\xC8"],

        ["\x65\xC9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xC9"],
        ["\xE6\xC9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\xC9"],

        ["\x65\xD1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xCA"],
        ["\xE6\xCA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\xD1"],

        ["\x65\xD2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xCB"],
        ["\xE6\xCB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\xD2"],

        ["\x65\xD3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xCC"],
        ["\xE6\xCC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\xD3"],

        ["\x65\xD4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xCD"],
        ["\xE6\xCD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\xD4"],

        ["\x65\xD5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xCE"],
        ["\xE6\xCE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\xD5"],

        ["\x65\xD6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xCF"],
        ["\xE6\xCF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\xD6"],

        ["\x65\xD7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xD0"],
        ["\xE6\xD0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\xD7"],

        ["\x65\xD8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xD1"],
        ["\xE6\xD1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\xD8"],

        ["\x65\xD9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xD2"],
        ["\xE6\xD2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\xD9"],

        ["\x65\xE2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xD3"],
        ["\xE6\xD3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\xE2"],

        ["\x65\xE3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xD4"],
        ["\xE6\xD4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\xE3"],

        ["\x65\xE4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xD5"],
        ["\xE6\xD5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\xE4"],

        ["\x65\xE5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xD6"],
        ["\xE6\xD6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\xE5"],

        ["\x65\xE6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xD7"],
        ["\xE6\xD7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\xE6"],

        ["\x65\xE7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xD8"],
        ["\xE6\xD8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\xE7"],

        ["\x65\xE8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xD9"],
        ["\xE6\xD9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\xE8"],

        ["\x65\xE9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xDA"],
        ["\xE6\xDA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\xE9"],

        ["\x65\x4A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xDB"],
        ["\xE6\xDB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\x4A"],

        ["\x65\x5B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xDC"],
        ["\xE6\xDC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\x5B"],

        ["\x65\x5A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xDD"],
        ["\xE6\xDD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\x5A"],

        ["\x65\x5F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xDE"],
        ["\xE6\xDE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\x5F"],

        ["\x65\x6D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xDF"],
        ["\xE6\xDF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\x6D"],

        ["\x65\x79",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xE0"],
        ["\xE6\xE0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\x79"],

        ["\x65\x57",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xE1"],
        ["\xE6\xE1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\x57"],

        ["\x65\x59",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xE2"],
        ["\xE6\xE2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\x59"],

        ["\x65\x62",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xE3"],
        ["\xE6\xE3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\x62"],

        ["\x65\x63",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xE4"],
        ["\xE6\xE4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\x63"],

        ["\x65\x64",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xE5"],
        ["\xE6\xE5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\x64"],

        ["\x65\x65",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xE6"],
        ["\xE6\xE6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\x65"],

        ["\x65\x66",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xE7"],
        ["\xE6\xE7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\x66"],

        ["\x65\x67",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xE8"],
        ["\xE6\xE8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\x67"],

        ["\x65\x68",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xE9"],
        ["\xE6\xE9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\x68"],

        ["\x65\x69",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xEA"],
        ["\xE6\xEA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\x69"],

        ["\x65\x70",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xEB"],
        ["\xE6\xEB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\x70"],

        ["\x65\x71",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xEC"],
        ["\xE6\xEC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\x71"],

        ["\x65\x72",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xED"],
        ["\xE6\xED",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\x72"],

        ["\x65\x73",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xEE"],
        ["\xE6\xEE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\x73"],

        ["\x65\x74",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xEF"],
        ["\xE6\xEF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\x74"],

        ["\x65\x75",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xF0"],
        ["\xE6\xF0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\x75"],

        ["\x65\x76",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xF1"],
        ["\xE6\xF1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\x76"],

        ["\x65\x77",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xF2"],
        ["\xE6\xF2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\x77"],

        ["\x65\x78",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xF3"],
        ["\xE6\xF3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\x78"],

        ["\x65\x80",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xF4"],
        ["\xE6\xF4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\x80"],

        ["\x65\x8B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xF5"],
        ["\xE6\xF5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\x8B"],

        ["\x65\x9B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xF6"],
        ["\xE6\xF6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\x9B"],

        ["\x65\x9C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xF7"],
        ["\xE6\xF7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\x9C"],

        ["\x65\xA0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xF8"],
        ["\xE6\xF8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\xA0"],

        ["\x65\xAB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xF9"],
        ["\xE6\xF9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\xAB"],

        ["\x65\xB0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xFA"],
        ["\xE6\xFA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\xB0"],

        ["\x65\xC0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xFB"],
        ["\xE6\xFB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\xC0"],

        ["\x65\x6A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xFC"],
        ["\xE6\xFC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\x6A"],

        ["\x65\xD0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xFD"],
        ["\xE6\xFD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\xD0"],

        ["\x65\xA1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xFE"],
        ["\xE6\xFE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\xA1"],

        ["\x66\x4F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA1"],
        ["\xE7\xA1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\x4F"],

        ["\x66\x7F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA2"],
        ["\xE7\xA2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\x7F"],

        ["\x66\x7B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA3"],
        ["\xE7\xA3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\x7B"],

        ["\x66\xE0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA4"],
        ["\xE7\xA4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\xE0"],

        ["\x66\x6C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5"],
        ["\xE7\xA5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\x6C"],

        ["\x66\x50",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6"],
        ["\xE7\xA6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\x50"],

        ["\x66\x7D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA7"],
        ["\xE7\xA7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\x7D"],

        ["\x66\x4D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8"],
        ["\xE7\xA8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\x4D"],

        ["\x66\x5D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9"],
        ["\xE7\xA9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\x5D"],

        ["\x66\x5C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAA"],
        ["\xE7\xAA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\x5C"],

        ["\x66\x4E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB"],
        ["\xE7\xAB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\x4E"],

        ["\x66\x6B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC"],
        ["\xE7\xAC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\x6B"],

        ["\x66\x60",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD"],
        ["\xE7\xAD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\x60"],

        ["\x66\x4B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAE"],
        ["\xE7\xAE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\x4B"],

        ["\x66\x61",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAF"],
        ["\xE7\xAF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\x61"],

        ["\x66\xF0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB0"],
        ["\xE7\xB0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\xF0"],

        ["\x66\xF1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB1"],
        ["\xE7\xB1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\xF1"],

        ["\x66\xF2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2"],
        ["\xE7\xB2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\xF2"],

        ["\x66\xF3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3"],
        ["\xE7\xB3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\xF3"],

        ["\x66\xF4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4"],
        ["\xE7\xB4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\xF4"],

        ["\x66\xF5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5"],
        ["\xE7\xB5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\xF5"],

        ["\x66\xF6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6"],
        ["\xE7\xB6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\xF6"],

        ["\x66\xF7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7"],
        ["\xE7\xB7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\xF7"],

        ["\x66\xF8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8"],
        ["\xE7\xB8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\xF8"],

        ["\x66\xF9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9"],
        ["\xE7\xB9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\xF9"],

        ["\x66\x7A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBA"],
        ["\xE7\xBA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\x7A"],

        ["\x66\x5E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBB"],
        ["\xE7\xBB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\x5E"],

        ["\x66\x4C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBC"],
        ["\xE7\xBC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\x4C"],

        ["\x66\x7E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD"],
        ["\xE7\xBD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\x7E"],

        ["\x66\x6E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE"],
        ["\xE7\xBE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\x6E"],

        ["\x66\x6F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBF"],
        ["\xE7\xBF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\x6F"],

        ["\x66\x7C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xC0"],
        ["\xE7\xC0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\x7C"],

        ["\x66\xC1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xC1"],
        ["\xE7\xC1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\xC1"],

        ["\x66\xC2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xC2"],
        ["\xE7\xC2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\xC2"],

        ["\x66\xC3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xC3"],
        ["\xE7\xC3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\xC3"],

        ["\x66\xC4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xC4"],
        ["\xE7\xC4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\xC4"],

        ["\x66\xC5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xC5"],
        ["\xE7\xC5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\xC5"],

        ["\x66\xC6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xC6"],
        ["\xE7\xC6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\xC6"],

        ["\x66\xC7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xC7"],
        ["\xE7\xC7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\xC7"],

        ["\x66\xC8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xC8"],
        ["\xE7\xC8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\xC8"],

        ["\x66\xC9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xC9"],
        ["\xE7\xC9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\xC9"],

        ["\x66\xD1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xCA"],
        ["\xE7\xCA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\xD1"],

        ["\x66\xD2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xCB"],
        ["\xE7\xCB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\xD2"],

        ["\x66\xD3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xCC"],
        ["\xE7\xCC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\xD3"],

        ["\x66\xD4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xCD"],
        ["\xE7\xCD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\xD4"],

        ["\x66\xD5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xCE"],
        ["\xE7\xCE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\xD5"],

        ["\x66\xD6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xCF"],
        ["\xE7\xCF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\xD6"],

        ["\x66\xD7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xD0"],
        ["\xE7\xD0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\xD7"],

        ["\x66\xD8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xD1"],
        ["\xE7\xD1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\xD8"],

        ["\x66\xD9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xD2"],
        ["\xE7\xD2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\xD9"],

        ["\x66\xE2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xD3"],
        ["\xE7\xD3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\xE2"],

        ["\x66\xE3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xD4"],
        ["\xE7\xD4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\xE3"],

        ["\x66\xE4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xD5"],
        ["\xE7\xD5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\xE4"],

        ["\x66\xE5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xD6"],
        ["\xE7\xD6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\xE5"],

        ["\x66\xE6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xD7"],
        ["\xE7\xD7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\xE6"],

        ["\x66\xE7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xD8"],
        ["\xE7\xD8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\xE7"],

        ["\x66\xE8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xD9"],
        ["\xE7\xD9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\xE8"],

        ["\x66\xE9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xDA"],
        ["\xE7\xDA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\xE9"],

        ["\x66\x4A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xDB"],
        ["\xE7\xDB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\x4A"],

        ["\x66\x5B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xDC"],
        ["\xE7\xDC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\x5B"],

        ["\x66\x5A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xDD"],
        ["\xE7\xDD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\x5A"],

        ["\x66\x5F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xDE"],
        ["\xE7\xDE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\x5F"],

        ["\x66\x6D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xDF"],
        ["\xE7\xDF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\x6D"],

        ["\x66\x79",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xE0"],
        ["\xE7\xE0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\x79"],

        ["\x66\x57",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xE1"],
        ["\xE7\xE1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\x57"],

        ["\x66\x59",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xE2"],
        ["\xE7\xE2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\x59"],

        ["\x66\x62",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xE3"],
        ["\xE7\xE3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\x62"],

        ["\x66\x63",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xE4"],
        ["\xE7\xE4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\x63"],

        ["\x66\x64",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xE5"],
        ["\xE7\xE5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\x64"],

        ["\x66\x65",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xE6"],
        ["\xE7\xE6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\x65"],

        ["\x66\x66",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xE7"],
        ["\xE7\xE7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\x66"],

        ["\x66\x67",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xE8"],
        ["\xE7\xE8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\x67"],

        ["\x66\x68",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xE9"],
        ["\xE7\xE9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\x68"],

        ["\x66\x69",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xEA"],
        ["\xE7\xEA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\x69"],

        ["\x66\x70",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xEB"],
        ["\xE7\xEB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\x70"],

        ["\x66\x71",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xEC"],
        ["\xE7\xEC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\x71"],

        ["\x66\x72",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xED"],
        ["\xE7\xED",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\x72"],

        ["\x66\x73",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xEE"],
        ["\xE7\xEE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\x73"],

        ["\x66\x74",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xEF"],
        ["\xE7\xEF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\x74"],

        ["\x66\x75",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xF0"],
        ["\xE7\xF0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\x75"],

        ["\x66\x76",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xF1"],
        ["\xE7\xF1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\x76"],

        ["\x66\x77",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xF2"],
        ["\xE7\xF2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\x77"],

        ["\x66\x78",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xF3"],
        ["\xE7\xF3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\x78"],

        ["\x66\x80",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xF4"],
        ["\xE7\xF4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\x80"],

        ["\x66\x8B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xF5"],
        ["\xE7\xF5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\x8B"],

        ["\x66\x9B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xF6"],
        ["\xE7\xF6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\x9B"],

        ["\x66\x9C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xF7"],
        ["\xE7\xF7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\x9C"],

        ["\x66\xA0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xF8"],
        ["\xE7\xF8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\xA0"],

        ["\x66\xAB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xF9"],
        ["\xE7\xF9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\xAB"],

        ["\x66\xB0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xFA"],
        ["\xE7\xFA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\xB0"],

        ["\x66\xC0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xFB"],
        ["\xE7\xFB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\xC0"],

        ["\x66\x6A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xFC"],
        ["\xE7\xFC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\x6A"],

        ["\x66\xD0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xFD"],
        ["\xE7\xFD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\xD0"],

        ["\x66\xA1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xFE"],
        ["\xE7\xFE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\xA1"],

        ["\x67\x4F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1"],
        ["\xE8\xA1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\x4F"],

        ["\x67\x7F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA2"],
        ["\xE8\xA2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\x7F"],

        ["\x67\x7B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3"],
        ["\xE8\xA3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\x7B"],

        ["\x67\xE0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA4"],
        ["\xE8\xA4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\xE0"],

        ["\x67\x6C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA5"],
        ["\xE8\xA5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\x6C"],

        ["\x67\x50",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6"],
        ["\xE8\xA6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\x50"],

        ["\x67\x7D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA7"],
        ["\xE8\xA7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\x7D"],

        ["\x67\x4D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8"],
        ["\xE8\xA8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\x4D"],

        ["\x67\x5D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9"],
        ["\xE8\xA9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\x5D"],

        ["\x67\x5C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA"],
        ["\xE8\xAA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\x5C"],

        ["\x67\x4E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB"],
        ["\xE8\xAB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\x4E"],

        ["\x67\x6B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC"],
        ["\xE8\xAC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\x6B"],

        ["\x67\x60",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD"],
        ["\xE8\xAD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\x60"],

        ["\x67\x4B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAE"],
        ["\xE8\xAE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\x4B"],

        ["\x67\x61",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAF"],
        ["\xE8\xAF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\x61"],

        ["\x67\xF0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB0"],
        ["\xE8\xB0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\xF0"],

        ["\x67\xF1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB1"],
        ["\xE8\xB1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\xF1"],

        ["\x67\xF2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2"],
        ["\xE8\xB2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\xF2"],

        ["\x67\xF3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3"],
        ["\xE8\xB3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\xF3"],

        ["\x67\xF4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB4"],
        ["\xE8\xB4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\xF4"],

        ["\x67\xF5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB5"],
        ["\xE8\xB5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\xF5"],

        ["\x67\xF6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB6"],
        ["\xE8\xB6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\xF6"],

        ["\x67\xF7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB7"],
        ["\xE8\xB7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\xF7"],

        ["\x67\xF8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB8"],
        ["\xE8\xB8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\xF8"],

        ["\x67\xF9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB9"],
        ["\xE8\xB9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\xF9"],

        ["\x67\x7A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBA"],
        ["\xE8\xBA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\x7A"],

        ["\x67\x5E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBB"],
        ["\xE8\xBB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\x5E"],

        ["\x67\x4C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC"],
        ["\xE8\xBC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\x4C"],

        ["\x67\x7E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBD"],
        ["\xE8\xBD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\x7E"],

        ["\x67\x6E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBE"],
        ["\xE8\xBE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\x6E"],

        ["\x67\x6F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF"],
        ["\xE8\xBF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\x6F"],

        ["\x67\x7C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xC0"],
        ["\xE8\xC0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\x7C"],

        ["\x67\xC1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xC1"],
        ["\xE8\xC1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\xC1"],

        ["\x67\xC2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xC2"],
        ["\xE8\xC2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\xC2"],

        ["\x67\xC3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xC3"],
        ["\xE8\xC3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\xC3"],

        ["\x67\xC4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xC4"],
        ["\xE8\xC4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\xC4"],

        ["\x67\xC5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xC5"],
        ["\xE8\xC5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\xC5"],

        ["\x67\xC6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xC6"],
        ["\xE8\xC6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\xC6"],

        ["\x67\xC7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xC7"],
        ["\xE8\xC7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\xC7"],

        ["\x67\xC8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xC8"],
        ["\xE8\xC8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\xC8"],

        ["\x67\xC9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xC9"],
        ["\xE8\xC9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\xC9"],

        ["\x67\xD1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xCA"],
        ["\xE8\xCA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\xD1"],

        ["\x67\xD2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xCB"],
        ["\xE8\xCB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\xD2"],

        ["\x67\xD3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xCC"],
        ["\xE8\xCC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\xD3"],

        ["\x67\xD4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xCD"],
        ["\xE8\xCD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\xD4"],

        ["\x67\xD5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xCE"],
        ["\xE8\xCE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\xD5"],

        ["\x67\xD6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xCF"],
        ["\xE8\xCF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\xD6"],

        ["\x67\xD7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xD0"],
        ["\xE8\xD0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\xD7"],

        ["\x67\xD8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xD1"],
        ["\xE8\xD1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\xD8"],

        ["\x67\xD9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xD2"],
        ["\xE8\xD2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\xD9"],

        ["\x67\xE2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xD3"],
        ["\xE8\xD3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\xE2"],

        ["\x67\xE3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xD4"],
        ["\xE8\xD4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\xE3"],

        ["\x67\xE4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xD5"],
        ["\xE8\xD5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\xE4"],

        ["\x67\xE5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xD6"],
        ["\xE8\xD6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\xE5"],

        ["\x67\xE6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xD7"],
        ["\xE8\xD7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\xE6"],

        ["\x67\xE7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xD8"],
        ["\xE8\xD8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\xE7"],

        ["\x67\xE8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xD9"],
        ["\xE8\xD9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\xE8"],

        ["\x67\xE9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xDA"],
        ["\xE8\xDA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\xE9"],

        ["\x67\x4A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xDB"],
        ["\xE8\xDB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\x4A"],

        ["\x67\x5B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xDC"],
        ["\xE8\xDC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\x5B"],

        ["\x67\x5A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xDD"],
        ["\xE8\xDD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\x5A"],

        ["\x67\x5F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xDE"],
        ["\xE8\xDE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\x5F"],

        ["\x67\x6D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xDF"],
        ["\xE8\xDF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\x6D"],

        ["\x67\x79",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xE0"],
        ["\xE8\xE0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\x79"],

        ["\x67\x57",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xE1"],
        ["\xE8\xE1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\x57"],

        ["\x67\x59",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xE2"],
        ["\xE8\xE2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\x59"],

        ["\x67\x62",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xE3"],
        ["\xE8\xE3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\x62"],

        ["\x67\x63",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xE4"],
        ["\xE8\xE4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\x63"],

        ["\x67\x64",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xE5"],
        ["\xE8\xE5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\x64"],

        ["\x67\x65",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xE6"],
        ["\xE8\xE6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\x65"],

        ["\x67\x66",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xE7"],
        ["\xE8\xE7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\x66"],

        ["\x67\x67",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xE8"],
        ["\xE8\xE8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\x67"],

        ["\x67\x68",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xE9"],
        ["\xE8\xE9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\x68"],

        ["\x67\x69",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xEA"],
        ["\xE8\xEA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\x69"],

        ["\x67\x70",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xEB"],
        ["\xE8\xEB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\x70"],

        ["\x67\x71",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xEC"],
        ["\xE8\xEC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\x71"],

        ["\x67\x72",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xED"],
        ["\xE8\xED",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\x72"],

        ["\x67\x73",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xEE"],
        ["\xE8\xEE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\x73"],

        ["\x67\x74",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xEF"],
        ["\xE8\xEF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\x74"],

        ["\x67\x75",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xF0"],
        ["\xE8\xF0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\x75"],

        ["\x67\x76",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xF1"],
        ["\xE8\xF1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\x76"],

        ["\x67\x77",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xF2"],
        ["\xE8\xF2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\x77"],

        ["\x67\x78",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xF3"],
        ["\xE8\xF3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\x78"],

        ["\x67\x80",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xF4"],
        ["\xE8\xF4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\x80"],

        ["\x67\x8B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xF5"],
        ["\xE8\xF5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\x8B"],

        ["\x67\x9B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xF6"],
        ["\xE8\xF6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\x9B"],

        ["\x67\x9C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xF7"],
        ["\xE8\xF7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\x9C"],

        ["\x67\xA0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xF8"],
        ["\xE8\xF8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\xA0"],

        ["\x67\xAB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xF9"],
        ["\xE8\xF9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\xAB"],

        ["\x67\xB0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xFA"],
        ["\xE8\xFA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\xB0"],

        ["\x67\xC0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xFB"],
        ["\xE8\xFB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\xC0"],

        ["\x67\x6A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xFC"],
        ["\xE8\xFC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\x6A"],

        ["\x67\xD0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xFD"],
        ["\xE8\xFD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\xD0"],

        ["\x67\xA1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xFE"],
        ["\xE8\xFE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\xA1"],

        ["\x68\x4F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA1"],
        ["\xE9\xA1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\x4F"],

        ["\x4C\xC9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA2"],
        ["\xE9\xA2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\xC9"],

        ["\x68\x7B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA3"],
        ["\xE9\xA3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\x7B"],

        ["\x68\xE0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA4"],
        ["\xE9\xA4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\xE0"],

        ["\x68\x6C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA5"],
        ["\xE9\xA5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\x6C"],

        ["\x68\x50",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA6"],
        ["\xE9\xA6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\x50"],

        ["\x68\x7D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA7"],
        ["\xE9\xA7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\x7D"],

        ["\x68\x4D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA8"],
        ["\xE9\xA8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\x4D"],

        ["\x68\x5D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA9"],
        ["\xE9\xA9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\x5D"],

        ["\x68\x5C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xAA"],
        ["\xE9\xAA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\x5C"],

        ["\x68\x4E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xAB"],
        ["\xE9\xAB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\x4E"],

        ["\x68\x6B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xAC"],
        ["\xE9\xAC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\x6B"],

        ["\x68\x60",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xAD"],
        ["\xE9\xAD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\x60"],

        ["\xD3\xAB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xAE"],
        ["\xE9\xAE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xAB"],

        ["\x68\x61",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xAF"],
        ["\xE9\xAF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\x61"],

        ["\x68\xF0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0"],
        ["\xE9\xB0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\xF0"],

        ["\x68\xF1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB1"],
        ["\xE9\xB1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\xF1"],

        ["\x68\xF2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB2"],
        ["\xE9\xB2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\xF2"],

        ["\x68\xF3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB3"],
        ["\xE9\xB3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\xF3"],

        ["\x68\xF4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB4"],
        ["\xE9\xB4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\xF4"],

        ["\x68\xF5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB5"],
        ["\xE9\xB5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\xF5"],

        ["\x68\xF6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB6"],
        ["\xE9\xB6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\xF6"],

        ["\x68\xF7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB7"],
        ["\xE9\xB7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\xF7"],

        ["\x68\xF8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB8"],
        ["\xE9\xB8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\xF8"],

        ["\x68\xF9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB9"],
        ["\xE9\xB9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\xF9"],

        ["\x68\x7A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xBA"],
        ["\xE9\xBA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\x7A"],

        ["\x68\x5E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xBB"],
        ["\xE9\xBB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\x5E"],

        ["\x68\x4C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xBC"],
        ["\xE9\xBC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\x4C"],

        ["\x68\x7E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xBD"],
        ["\xE9\xBD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\x7E"],

        ["\x68\x6E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xBE"],
        ["\xE9\xBE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\x6E"],

        ["\x68\x6F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xBF"],
        ["\xE9\xBF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\x6F"],

        ["\x68\x7C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xC0"],
        ["\xE9\xC0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\x7C"],

        ["\x68\xC1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xC1"],
        ["\xE9\xC1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\xC1"],

        ["\x68\xC2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xC2"],
        ["\xE9\xC2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\xC2"],

        ["\x68\xC3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xC3"],
        ["\xE9\xC3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\xC3"],

        ["\x68\xC4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xC4"],
        ["\xE9\xC4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\xC4"],

        ["\x68\xC5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xC5"],
        ["\xE9\xC5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\xC5"],

        ["\x68\xC6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xC6"],
        ["\xE9\xC6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\xC6"],

        ["\x68\xC7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xC7"],
        ["\xE9\xC7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\xC7"],

        ["\x68\xC8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xC8"],
        ["\xE9\xC8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\xC8"],

        ["\x68\xC9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xC9"],
        ["\xE9\xC9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\xC9"],

        ["\x68\xD1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xCA"],
        ["\xE9\xCA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\xD1"],

        ["\x68\xD2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xCB"],
        ["\xE9\xCB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\xD2"],

        ["\x68\xD3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xCC"],
        ["\xE9\xCC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\xD3"],

        ["\x68\xD4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xCD"],
        ["\xE9\xCD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\xD4"],

        ["\x68\xD5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xCE"],
        ["\xE9\xCE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\xD5"],

        ["\x68\xD6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xCF"],
        ["\xE9\xCF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\xD6"],

        ["\x68\xD7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xD0"],
        ["\xE9\xD0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\xD7"],

        ["\x68\xD8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xD1"],
        ["\xE9\xD1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\xD8"],

        ["\x68\xD9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xD2"],
        ["\xE9\xD2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\xD9"],

        ["\x68\xE2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xD3"],
        ["\xE9\xD3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\xE2"],

        ["\x68\xE3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xD4"],
        ["\xE9\xD4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\xE3"],

        ["\x68\xE4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xD5"],
        ["\xE9\xD5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\xE4"],

        ["\x68\xE5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xD6"],
        ["\xE9\xD6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\xE5"],

        ["\x68\xE6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xD7"],
        ["\xE9\xD7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\xE6"],

        ["\x68\xE7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xD8"],
        ["\xE9\xD8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\xE7"],

        ["\x68\xE8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xD9"],
        ["\xE9\xD9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\xE8"],

        ["\xF3\xC2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xDA"],
        ["\xE9\xDA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xC2"],

        ["\x68\x4A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xDB"],
        ["\xE9\xDB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\x4A"],

        ["\x68\x5B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xDC"],
        ["\xE9\xDC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\x5B"],

        ["\x68\x5A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xDD"],
        ["\xE9\xDD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\x5A"],

        ["\x68\x5F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xDE"],
        ["\xE9\xDE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\x5F"],

        ["\x68\x6D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xDF"],
        ["\xE9\xDF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\x6D"],

        ["\x68\x79",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xE0"],
        ["\xE9\xE0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\x79"],

        ["\x68\x57",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xE1"],
        ["\xE9\xE1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\x57"],

        ["\x68\x59",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xE2"],
        ["\xE9\xE2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\x59"],

        ["\x68\x62",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xE3"],
        ["\xE9\xE3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\x62"],

        ["\x68\x63",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xE4"],
        ["\xE9\xE4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\x63"],

        ["\x68\x64",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xE5"],
        ["\xE9\xE5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\x64"],

        ["\x68\x65",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xE6"],
        ["\xE9\xE6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\x65"],

        ["\x68\x66",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xE7"],
        ["\xE9\xE7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\x66"],

        ["\x68\x67",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xE8"],
        ["\xE9\xE8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\x67"],

        ["\x68\x68",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xE9"],
        ["\xE9\xE9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\x68"],

        ["\x68\x69",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xEA"],
        ["\xE9\xEA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\x69"],

        ["\x68\x70",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xEB"],
        ["\xE9\xEB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\x70"],

        ["\x68\x71",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xEC"],
        ["\xE9\xEC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\x71"],

        ["\x68\x72",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xED"],
        ["\xE9\xED",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\x72"],

        ["\x68\x73",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xEE"],
        ["\xE9\xEE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\x73"],

        ["\x68\x74",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xEF"],
        ["\xE9\xEF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\x74"],

        ["\x68\x75",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xF0"],
        ["\xE9\xF0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\x75"],

        ["\x68\x76",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xF1"],
        ["\xE9\xF1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\x76"],

        ["\x68\x77",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xF2"],
        ["\xE9\xF2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\x77"],

        ["\x68\x78",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xF3"],
        ["\xE9\xF3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\x78"],

        ["\x68\x80",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xF4"],
        ["\xE9\xF4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\x80"],

        ["\x68\x8B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xF5"],
        ["\xE9\xF5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\x8B"],

        ["\x68\x9B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xF6"],
        ["\xE9\xF6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\x9B"],

        ["\x68\x9C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xF7"],
        ["\xE9\xF7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\x9C"],

        ["\x68\xA0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xF8"],
        ["\xE9\xF8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\xA0"],

        ["\x68\xAB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xF9"],
        ["\xE9\xF9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\xAB"],

        ["\x68\xB0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xFA"],
        ["\xE9\xFA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\xB0"],

        ["\x68\xC0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xFB"],
        ["\xE9\xFB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\xC0"],

        ["\x68\x6A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xFC"],
        ["\xE9\xFC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\x6A"],

        ["\x68\xD0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xFD"],
        ["\xE9\xFD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\xD0"],

        ["\x68\xA1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xFE"],
        ["\xE9\xFE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\xA1"],

        ["\x69\x4F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xA1"],
        ["\xEA\xA1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\x4F"],

        ["\x69\x7F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xA2"],
        ["\xEA\xA2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\x7F"],

        ["\x69\x7B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xA3"],
        ["\xEA\xA3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\x7B"],

        ["\xC7\x67",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xA4"],
        ["\xEA\xA4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\x67"],

        ["\x69\x6C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xA5"],
        ["\xEA\xA5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\x6C"],

        ["\x69\x50",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xA6"],
        ["\xEA\xA6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\x50"],

        ["\x69\x7D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xA7"],
        ["\xEA\xA7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\x7D"],

        ["\x69\x4D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xA8"],
        ["\xEA\xA8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\x4D"],

        ["\x69\x5D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xA9"],
        ["\xEA\xA9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\x5D"],

        ["\x69\x5C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xAA"],
        ["\xEA\xAA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\x5C"],

        ["\x69\x4E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xAB"],
        ["\xEA\xAB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\x4E"],

        ["\x69\x6B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xAC"],
        ["\xEA\xAC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\x6B"],

        ["\x69\x60",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xAD"],
        ["\xEA\xAD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\x60"],

        ["\x69\x4B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xAE"],
        ["\xEA\xAE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\x4B"],

        ["\x69\x61",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xAF"],
        ["\xEA\xAF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\x61"],

        ["\x69\xF0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xB0"],
        ["\xEA\xB0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\xF0"],

        ["\x69\xF1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xB1"],
        ["\xEA\xB1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\xF1"],

        ["\x69\xF2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xB2"],
        ["\xEA\xB2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\xF2"],

        ["\x69\xF3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xB3"],
        ["\xEA\xB3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\xF3"],

        ["\x69\xF4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xB4"],
        ["\xEA\xB4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\xF4"],

        ["\x69\xF5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xB5"],
        ["\xEA\xB5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\xF5"],

        ["\x69\xF6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xB6"],
        ["\xEA\xB6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\xF6"],

        ["\x69\xF7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xB7"],
        ["\xEA\xB7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\xF7"],

        ["\x69\xF8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xB8"],
        ["\xEA\xB8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\xF8"],

        ["\x69\xF9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xB9"],
        ["\xEA\xB9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\xF9"],

        ["\x69\x7A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xBA"],
        ["\xEA\xBA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\x7A"],

        ["\x69\x5E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xBB"],
        ["\xEA\xBB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\x5E"],

        ["\x69\x4C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xBC"],
        ["\xEA\xBC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\x4C"],

        ["\x69\x7E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xBD"],
        ["\xEA\xBD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\x7E"],

        ["\x69\x6E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xBE"],
        ["\xEA\xBE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\x6E"],

        ["\x69\x6F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xBF"],
        ["\xEA\xBF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\x6F"],

        ["\x69\x7C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xC0"],
        ["\xEA\xC0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\x7C"],

        ["\x69\xC1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xC1"],
        ["\xEA\xC1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\xC1"],

        ["\x69\xC2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xC2"],
        ["\xEA\xC2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\xC2"],

        ["\x69\xC3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xC3"],
        ["\xEA\xC3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\xC3"],

        ["\x69\xC4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xC4"],
        ["\xEA\xC4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\xC4"],

        ["\x69\xC5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xC5"],
        ["\xEA\xC5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\xC5"],

        ["\x69\xC6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xC6"],
        ["\xEA\xC6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\xC6"],

        ["\x69\xC7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xC7"],
        ["\xEA\xC7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\xC7"],

        ["\x69\xC8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xC8"],
        ["\xEA\xC8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\xC8"],

        ["\x69\xC9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xC9"],
        ["\xEA\xC9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\xC9"],

        ["\x69\xD1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xCA"],
        ["\xEA\xCA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\xD1"],

        ["\x69\xD2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xCB"],
        ["\xEA\xCB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\xD2"],

        ["\x69\xD3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xCC"],
        ["\xEA\xCC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\xD3"],

        ["\x69\xD4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xCD"],
        ["\xEA\xCD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\xD4"],

        ["\x69\xD5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xCE"],
        ["\xEA\xCE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\xD5"],

        ["\x69\xD6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xCF"],
        ["\xEA\xCF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\xD6"],

        ["\x69\xD7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xD0"],
        ["\xEA\xD0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\xD7"],

        ["\x69\xD8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xD1"],
        ["\xEA\xD1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\xD8"],

        ["\x69\xD9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xD2"],
        ["\xEA\xD2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\xD9"],

        ["\x69\xE2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xD3"],
        ["\xEA\xD3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\xE2"],

        ["\x69\xE3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xD4"],
        ["\xEA\xD4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\xE3"],

        ["\x69\xE4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xD5"],
        ["\xEA\xD5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\xE4"],

        ["\x69\xE5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xD6"],
        ["\xEA\xD6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\xE5"],

        ["\x69\xE6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xD7"],
        ["\xEA\xD7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\xE6"],

        ["\x69\xE7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xD8"],
        ["\xEA\xD8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\xE7"],

        ["\x69\xE8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xD9"],
        ["\xEA\xD9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\xE8"],

        ["\x69\xE9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xDA"],
        ["\xEA\xDA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\xE9"],

        ["\x69\x4A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xDB"],
        ["\xEA\xDB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\x4A"],

        ["\x69\x5B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xDC"],
        ["\xEA\xDC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\x5B"],

        ["\x69\x5A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xDD"],
        ["\xEA\xDD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\x5A"],

        ["\x69\x5F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xDE"],
        ["\xEA\xDE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\x5F"],

        ["\x69\x6D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xDF"],
        ["\xEA\xDF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\x6D"],

        ["\x69\x79",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xE0"],
        ["\xEA\xE0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\x79"],

        ["\x69\x57",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xE1"],
        ["\xEA\xE1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\x57"],

        ["\x69\x59",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xE2"],
        ["\xEA\xE2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\x59"],

        ["\x69\x62",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xE3"],
        ["\xEA\xE3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\x62"],

        ["\x69\x63",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xE4"],
        ["\xEA\xE4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\x63"],

        ["\x69\x64",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xE5"],
        ["\xEA\xE5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\x64"],

        ["\x69\x65",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xE6"],
        ["\xEA\xE6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\x65"],

        ["\x69\x66",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xE7"],
        ["\xEA\xE7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\x66"],

        ["\x69\x67",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xE8"],
        ["\xEA\xE8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\x67"],

        ["\x69\x68",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xE9"],
        ["\xEA\xE9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\x68"],

        ["\x69\x69",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xEA"],
        ["\xEA\xEA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\x69"],

        ["\x69\x70",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xEB"],
        ["\xEA\xEB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\x70"],

        ["\x69\x71",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xEC"],
        ["\xEA\xEC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\x71"],

        ["\x69\x72",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xED"],
        ["\xEA\xED",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\x72"],

        ["\x69\x73",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xEE"],
        ["\xEA\xEE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\x73"],

        ["\x69\x74",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xEF"],
        ["\xEA\xEF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\x74"],

        ["\x69\x75",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xF0"],
        ["\xEA\xF0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\x75"],

        ["\x69\x76",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xF1"],
        ["\xEA\xF1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\x76"],

        ["\x69\x77",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xF2"],
        ["\xEA\xF2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\x77"],

        ["\x69\x78",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xF3"],
        ["\xEA\xF3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\x78"],

        ["\x69\x80",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xF4"],
        ["\xEA\xF4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\x80"],

        ["\x69\x8B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xF5"],
        ["\xEA\xF5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\x8B"],

        ["\x69\x9B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xF6"],
        ["\xEA\xF6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\x9B"],

        ["\x69\x9C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xF7"],
        ["\xEA\xF7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\x9C"],

        ["\x69\xA0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xF8"],
        ["\xEA\xF8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\xA0"],

        ["\x69\xAB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xF9"],
        ["\xEA\xF9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\xAB"],

        ["\x69\xB0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xFA"],
        ["\xEA\xFA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\xB0"],

        ["\x69\xC0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xFB"],
        ["\xEA\xFB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\xC0"],

        ["\x69\x6A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xFC"],
        ["\xEA\xFC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\x6A"],

        ["\x69\xD0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xFD"],
        ["\xEA\xFD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\xD0"],

        ["\x69\xA1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEA\xFE"],
        ["\xEA\xFE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\xA1"],

        ["\x70\x4F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xA1"],
        ["\xEB\xA1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\x4F"],

        ["\x70\x7F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xA2"],
        ["\xEB\xA2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\x7F"],

        ["\x70\x7B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xA3"],
        ["\xEB\xA3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\x7B"],

        ["\x70\xE0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xA4"],
        ["\xEB\xA4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\xE0"],

        ["\x70\x6C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xA5"],
        ["\xEB\xA5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\x6C"],

        ["\x70\x50",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xA6"],
        ["\xEB\xA6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\x50"],

        ["\x70\x7D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xA7"],
        ["\xEB\xA7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\x7D"],

        ["\x70\x4D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xA8"],
        ["\xEB\xA8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\x4D"],

        ["\x70\x5D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xA9"],
        ["\xEB\xA9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\x5D"],

        ["\x70\x5C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xAA"],
        ["\xEB\xAA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\x5C"],

        ["\x70\x4E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xAB"],
        ["\xEB\xAB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\x4E"],

        ["\x70\x6B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xAC"],
        ["\xEB\xAC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\x6B"],

        ["\x70\x60",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xAD"],
        ["\xEB\xAD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\x60"],

        ["\x70\x4B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xAE"],
        ["\xEB\xAE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\x4B"],

        ["\x70\x61",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xAF"],
        ["\xEB\xAF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\x61"],

        ["\x70\xF0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xB0"],
        ["\xEB\xB0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\xF0"],

        ["\x70\xF1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xB1"],
        ["\xEB\xB1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\xF1"],

        ["\x70\xF2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xB2"],
        ["\xEB\xB2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\xF2"],

        ["\x70\xF3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xB3"],
        ["\xEB\xB3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\xF3"],

        ["\x70\xF4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xB4"],
        ["\xEB\xB4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\xF4"],

        ["\x70\xF5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xB5"],
        ["\xEB\xB5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\xF5"],

        ["\x70\xF6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xB6"],
        ["\xEB\xB6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\xF6"],

        ["\x70\xF7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xB7"],
        ["\xEB\xB7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\xF7"],

        ["\x70\xF8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xB8"],
        ["\xEB\xB8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\xF8"],

        ["\x70\xF9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xB9"],
        ["\xEB\xB9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\xF9"],

        ["\x70\x7A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xBA"],
        ["\xEB\xBA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\x7A"],

        ["\x70\x5E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xBB"],
        ["\xEB\xBB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\x5E"],

        ["\x70\x4C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xBC"],
        ["\xEB\xBC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\x4C"],

        ["\x70\x7E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xBD"],
        ["\xEB\xBD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\x7E"],

        ["\x70\x6E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xBE"],
        ["\xEB\xBE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\x6E"],

        ["\x70\x6F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xBF"],
        ["\xEB\xBF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\x6F"],

        ["\x70\x7C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xC0"],
        ["\xEB\xC0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\x7C"],

        ["\x70\xC1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xC1"],
        ["\xEB\xC1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\xC1"],

        ["\x70\xC2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xC2"],
        ["\xEB\xC2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\xC2"],

        ["\x70\xC3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xC3"],
        ["\xEB\xC3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\xC3"],

        ["\x70\xC4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xC4"],
        ["\xEB\xC4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\xC4"],

        ["\x70\xC5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xC5"],
        ["\xEB\xC5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\xC5"],

        ["\x70\xC6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xC6"],
        ["\xEB\xC6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\xC6"],

        ["\x70\xC7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xC7"],
        ["\xEB\xC7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\xC7"],

        ["\x70\xC8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xC8"],
        ["\xEB\xC8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\xC8"],

        ["\x70\xC9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xC9"],
        ["\xEB\xC9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\xC9"],

        ["\x70\xD1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xCA"],
        ["\xEB\xCA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\xD1"],

        ["\x70\xD2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xCB"],
        ["\xEB\xCB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\xD2"],

        ["\x70\xD3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xCC"],
        ["\xEB\xCC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\xD3"],

        ["\x70\xD4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xCD"],
        ["\xEB\xCD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\xD4"],

        ["\x70\xD5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xCE"],
        ["\xEB\xCE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\xD5"],

        ["\x70\xD6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xCF"],
        ["\xEB\xCF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\xD6"],

        ["\x70\xD7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xD0"],
        ["\xEB\xD0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\xD7"],

        ["\x70\xD8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xD1"],
        ["\xEB\xD1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\xD8"],

        ["\x70\xD9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xD2"],
        ["\xEB\xD2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\xD9"],

        ["\x70\xE2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xD3"],
        ["\xEB\xD3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\xE2"],

        ["\x70\xE3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xD4"],
        ["\xEB\xD4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\xE3"],

        ["\x70\xE4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xD5"],
        ["\xEB\xD5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\xE4"],

        ["\x70\xE5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xD6"],
        ["\xEB\xD6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\xE5"],

        ["\x70\xE6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xD7"],
        ["\xEB\xD7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\xE6"],

        ["\x70\xE7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xD8"],
        ["\xEB\xD8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\xE7"],

        ["\x70\xE8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xD9"],
        ["\xEB\xD9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\xE8"],

        ["\x70\xE9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xDA"],
        ["\xEB\xDA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\xE9"],

        ["\x70\x4A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xDB"],
        ["\xEB\xDB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\x4A"],

        ["\x70\x5B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xDC"],
        ["\xEB\xDC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\x5B"],

        ["\xF4\xD9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xDD"],
        ["\xEB\xDD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF4\xD9"],

        ["\x70\x5F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xDE"],
        ["\xEB\xDE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\x5F"],

        ["\x70\x6D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xDF"],
        ["\xEB\xDF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\x6D"],

        ["\x70\x79",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xE0"],
        ["\xEB\xE0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\x79"],

        ["\x70\x57",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xE1"],
        ["\xEB\xE1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\x57"],

        ["\x70\x59",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xE2"],
        ["\xEB\xE2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\x59"],

        ["\x70\x62",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xE3"],
        ["\xEB\xE3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\x62"],

        ["\x70\x63",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xE4"],
        ["\xEB\xE4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\x63"],

        ["\x70\x64",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xE5"],
        ["\xEB\xE5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\x64"],

        ["\x70\x65",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xE6"],
        ["\xEB\xE6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\x65"],

        ["\x70\x66",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xE7"],
        ["\xEB\xE7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\x66"],

        ["\x70\x67",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xE8"],
        ["\xEB\xE8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\x67"],

        ["\x70\x68",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xE9"],
        ["\xEB\xE9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\x68"],

        ["\x70\x69",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xEA"],
        ["\xEB\xEA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\x69"],

        ["\x70\x70",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xEB"],
        ["\xEB\xEB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\x70"],

        ["\x70\x71",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xEC"],
        ["\xEB\xEC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\x71"],

        ["\x70\x72",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xED"],
        ["\xEB\xED",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\x72"],

        ["\x70\x73",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xEE"],
        ["\xEB\xEE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\x73"],

        ["\x70\x74",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xEF"],
        ["\xEB\xEF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\x74"],

        ["\x70\x75",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xF0"],
        ["\xEB\xF0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\x75"],

        ["\x70\x76",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xF1"],
        ["\xEB\xF1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\x76"],

        ["\x70\x77",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xF2"],
        ["\xEB\xF2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\x77"],

        ["\x70\x78",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xF3"],
        ["\xEB\xF3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\x78"],

        ["\x70\x80",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xF4"],
        ["\xEB\xF4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\x80"],

        ["\x70\x8B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xF5"],
        ["\xEB\xF5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\x8B"],

        ["\x70\x9B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xF6"],
        ["\xEB\xF6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\x9B"],

        ["\x70\x9C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xF7"],
        ["\xEB\xF7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\x9C"],

        ["\x70\xA0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xF8"],
        ["\xEB\xF8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\xA0"],

        ["\x70\xAB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xF9"],
        ["\xEB\xF9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\xAB"],

        ["\x70\xB0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xFA"],
        ["\xEB\xFA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\xB0"],

        ["\x70\xC0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xFB"],
        ["\xEB\xFB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\xC0"],

        ["\x70\x6A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xFC"],
        ["\xEB\xFC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\x6A"],

        ["\x70\xD0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xFD"],
        ["\xEB\xFD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\xD0"],

        ["\x70\xA1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEB\xFE"],
        ["\xEB\xFE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\xA1"],

        ["\x71\x4F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xA1"],
        ["\xEC\xA1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\x4F"],

        ["\x71\x7F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xA2"],
        ["\xEC\xA2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\x7F"],

        ["\x71\x7B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xA3"],
        ["\xEC\xA3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\x7B"],

        ["\x71\xE0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xA4"],
        ["\xEC\xA4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\xE0"],

        ["\x71\x6C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xA5"],
        ["\xEC\xA5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\x6C"],

        ["\x71\x50",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xA6"],
        ["\xEC\xA6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\x50"],

        ["\x71\x7D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xA7"],
        ["\xEC\xA7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\x7D"],

        ["\x71\x4D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xA8"],
        ["\xEC\xA8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\x4D"],

        ["\x71\x5D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xA9"],
        ["\xEC\xA9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\x5D"],

        ["\x71\x5C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xAA"],
        ["\xEC\xAA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\x5C"],

        ["\x71\x4E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xAB"],
        ["\xEC\xAB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\x4E"],

        ["\x71\x6B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xAC"],
        ["\xEC\xAC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\x6B"],

        ["\x71\x60",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xAD"],
        ["\xEC\xAD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\x60"],

        ["\x71\x4B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xAE"],
        ["\xEC\xAE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\x4B"],

        ["\x71\x61",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xAF"],
        ["\xEC\xAF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\x61"],

        ["\x71\xF0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xB0"],
        ["\xEC\xB0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\xF0"],

        ["\x71\xF1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xB1"],
        ["\xEC\xB1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\xF1"],

        ["\x71\xF2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xB2"],
        ["\xEC\xB2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\xF2"],

        ["\x71\xF3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xB3"],
        ["\xEC\xB3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\xF3"],

        ["\x71\xF4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xB4"],
        ["\xEC\xB4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\xF4"],

        ["\x71\xF5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xB5"],
        ["\xEC\xB5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\xF5"],

        ["\x71\xF6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xB6"],
        ["\xEC\xB6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\xF6"],

        ["\x71\xF7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xB7"],
        ["\xEC\xB7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\xF7"],

        ["\x71\xF8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xB8"],
        ["\xEC\xB8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\xF8"],

        ["\x71\xF9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xB9"],
        ["\xEC\xB9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\xF9"],

        ["\x71\x7A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xBA"],
        ["\xEC\xBA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\x7A"],

        ["\x71\x5E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xBB"],
        ["\xEC\xBB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\x5E"],

        ["\x71\x4C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xBC"],
        ["\xEC\xBC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\x4C"],

        ["\x71\x7E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xBD"],
        ["\xEC\xBD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\x7E"],

        ["\x71\x6E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xBE"],
        ["\xEC\xBE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\x6E"],

        ["\x71\x6F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xBF"],
        ["\xEC\xBF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\x6F"],

        ["\x71\x7C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xC0"],
        ["\xEC\xC0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\x7C"],

        ["\x71\xC1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xC1"],
        ["\xEC\xC1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\xC1"],

        ["\x71\xC2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xC2"],
        ["\xEC\xC2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\xC2"],

        ["\x71\xC3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xC3"],
        ["\xEC\xC3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\xC3"],

        ["\x71\xC4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xC4"],
        ["\xEC\xC4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\xC4"],

        ["\x71\xC5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xC5"],
        ["\xEC\xC5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\xC5"],

        ["\x71\xC6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xC6"],
        ["\xEC\xC6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\xC6"],

        ["\x71\xC7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xC7"],
        ["\xEC\xC7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\xC7"],

        ["\x71\xC8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xC8"],
        ["\xEC\xC8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\xC8"],

        ["\x71\xC9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xC9"],
        ["\xEC\xC9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\xC9"],

        ["\x71\xD1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xCA"],
        ["\xEC\xCA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\xD1"],

        ["\x71\xD2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xCB"],
        ["\xEC\xCB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\xD2"],

        ["\x71\xD3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xCC"],
        ["\xEC\xCC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\xD3"],

        ["\xC1\x4D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xCD"],
        ["\xEC\xCD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\x4D"],

        ["\x71\xD5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xCE"],
        ["\xEC\xCE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\xD5"],

        ["\x71\xD6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xCF"],
        ["\xEC\xCF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\xD6"],

        ["\x71\xD7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xD0"],
        ["\xEC\xD0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\xD7"],

        ["\x71\xD8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xD1"],
        ["\xEC\xD1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\xD8"],

        ["\x71\xD9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xD2"],
        ["\xEC\xD2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\xD9"],

        ["\x71\xE2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xD3"],
        ["\xEC\xD3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\xE2"],

        ["\x71\xE3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xD4"],
        ["\xEC\xD4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\xE3"],

        ["\x71\xE4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xD5"],
        ["\xEC\xD5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\xE4"],

        ["\x71\xE5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xD6"],
        ["\xEC\xD6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\xE5"],

        ["\x71\xE6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xD7"],
        ["\xEC\xD7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\xE6"],

        ["\x71\xE7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xD8"],
        ["\xEC\xD8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\xE7"],

        ["\x71\xE8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xD9"],
        ["\xEC\xD9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\xE8"],

        ["\x71\xE9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xDA"],
        ["\xEC\xDA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\xE9"],

        ["\x71\x4A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xDB"],
        ["\xEC\xDB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\x4A"],

        ["\x71\x5B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xDC"],
        ["\xEC\xDC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\x5B"],

        ["\x71\x5A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xDD"],
        ["\xEC\xDD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\x5A"],

        ["\x71\x5F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xDE"],
        ["\xEC\xDE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\x5F"],

        ["\x71\x6D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xDF"],
        ["\xEC\xDF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\x6D"],

        ["\x71\x79",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xE0"],
        ["\xEC\xE0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\x79"],

        ["\x71\x57",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xE1"],
        ["\xEC\xE1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\x57"],

        ["\x71\x59",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xE2"],
        ["\xEC\xE2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\x59"],

        ["\x71\x62",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xE3"],
        ["\xEC\xE3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\x62"],

        ["\x71\x63",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xE4"],
        ["\xEC\xE4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\x63"],

        ["\x71\x64",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xE5"],
        ["\xEC\xE5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\x64"],

        ["\x71\x65",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xE6"],
        ["\xEC\xE6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\x65"],

        ["\x71\x66",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xE7"],
        ["\xEC\xE7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\x66"],

        ["\x71\x67",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xE8"],
        ["\xEC\xE8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\x67"],

        ["\x71\x68",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xE9"],
        ["\xEC\xE9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\x68"],

        ["\x71\x69",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xEA"],
        ["\xEC\xEA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\x69"],

        ["\x71\x70",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xEB"],
        ["\xEC\xEB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\x70"],

        ["\x71\x71",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xEC"],
        ["\xEC\xEC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\x71"],

        ["\x71\x72",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xED"],
        ["\xEC\xED",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\x72"],

        ["\x71\x73",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xEE"],
        ["\xEC\xEE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\x73"],

        ["\x71\x74",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xEF"],
        ["\xEC\xEF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\x74"],

        ["\x71\x75",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xF0"],
        ["\xEC\xF0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\x75"],

        ["\x71\x76",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xF1"],
        ["\xEC\xF1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\x76"],

        ["\x71\x77",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xF2"],
        ["\xEC\xF2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\x77"],

        ["\x71\x78",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xF3"],
        ["\xEC\xF3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\x78"],

        ["\x71\x80",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xF4"],
        ["\xEC\xF4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\x80"],

        ["\x71\x8B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xF5"],
        ["\xEC\xF5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\x8B"],

        ["\x71\x9B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xF6"],
        ["\xEC\xF6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\x9B"],

        ["\x71\x9C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xF7"],
        ["\xEC\xF7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\x9C"],

        ["\x71\xA0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xF8"],
        ["\xEC\xF8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\xA0"],

        ["\x71\xAB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xF9"],
        ["\xEC\xF9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\xAB"],

        ["\x71\xB0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xFA"],
        ["\xEC\xFA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\xB0"],

        ["\x71\xC0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xFB"],
        ["\xEC\xFB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\xC0"],

        ["\x71\x6A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xFC"],
        ["\xEC\xFC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\x6A"],

        ["\x71\xD0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xFD"],
        ["\xEC\xFD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\xD0"],

        ["\x71\xA1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEC\xFE"],
        ["\xEC\xFE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\xA1"],

        ["\x72\x4F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xA1"],
        ["\xED\xA1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\x4F"],

        ["\x72\x7F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xA2"],
        ["\xED\xA2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\x7F"],

        ["\x72\x7B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xA3"],
        ["\xED\xA3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\x7B"],

        ["\x72\xE0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xA4"],
        ["\xED\xA4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\xE0"],

        ["\x72\x6C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xA5"],
        ["\xED\xA5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\x6C"],

        ["\x72\x50",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xA6"],
        ["\xED\xA6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\x50"],

        ["\x72\x7D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xA7"],
        ["\xED\xA7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\x7D"],

        ["\x72\x4D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xA8"],
        ["\xED\xA8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\x4D"],

        ["\x72\x5D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xA9"],
        ["\xED\xA9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\x5D"],

        ["\x72\x5C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xAA"],
        ["\xED\xAA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\x5C"],

        ["\x72\x4E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xAB"],
        ["\xED\xAB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\x4E"],

        ["\x72\x6B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xAC"],
        ["\xED\xAC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\x6B"],

        ["\x72\x60",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xAD"],
        ["\xED\xAD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\x60"],

        ["\x72\x4B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xAE"],
        ["\xED\xAE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\x4B"],

        ["\x72\x61",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xAF"],
        ["\xED\xAF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\x61"],

        ["\x72\xF0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xB0"],
        ["\xED\xB0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\xF0"],

        ["\x72\xF1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xB1"],
        ["\xED\xB1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\xF1"],

        ["\x72\xF2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xB2"],
        ["\xED\xB2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\xF2"],

        ["\x72\xF3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xB3"],
        ["\xED\xB3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\xF3"],

        ["\x72\xF4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xB4"],
        ["\xED\xB4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\xF4"],

        ["\x72\xF5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xB5"],
        ["\xED\xB5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\xF5"],

        ["\x72\xF6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xB6"],
        ["\xED\xB6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\xF6"],

        ["\x72\xF7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xB7"],
        ["\xED\xB7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\xF7"],

        ["\x72\xF8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xB8"],
        ["\xED\xB8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\xF8"],

        ["\x72\xF9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xB9"],
        ["\xED\xB9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\xF9"],

        ["\x72\x7A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xBA"],
        ["\xED\xBA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\x7A"],

        ["\x72\x5E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xBB"],
        ["\xED\xBB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\x5E"],

        ["\x72\x4C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xBC"],
        ["\xED\xBC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\x4C"],

        ["\x72\x7E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xBD"],
        ["\xED\xBD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\x7E"],

        ["\x72\x6E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xBE"],
        ["\xED\xBE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\x6E"],

        ["\x72\x6F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xBF"],
        ["\xED\xBF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\x6F"],

        ["\x72\x7C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xC0"],
        ["\xED\xC0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\x7C"],

        ["\x72\xC1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xC1"],
        ["\xED\xC1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\xC1"],

        ["\x72\xC2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xC2"],
        ["\xED\xC2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\xC2"],

        ["\x72\xC3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xC3"],
        ["\xED\xC3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\xC3"],

        ["\x72\xC4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xC4"],
        ["\xED\xC4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\xC4"],

        ["\x72\xC5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xC5"],
        ["\xED\xC5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\xC5"],

        ["\x72\xC6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xC6"],
        ["\xED\xC6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\xC6"],

        ["\x72\xC7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xC7"],
        ["\xED\xC7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\xC7"],

        ["\x72\xC8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xC8"],
        ["\xED\xC8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\xC8"],

        ["\x72\xC9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xC9"],
        ["\xED\xC9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\xC9"],

        ["\x72\xD1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xCA"],
        ["\xED\xCA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\xD1"],

        ["\x72\xD2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xCB"],
        ["\xED\xCB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\xD2"],

        ["\x72\xD3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xCC"],
        ["\xED\xCC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\xD3"],

        ["\x72\xD4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xCD"],
        ["\xED\xCD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\xD4"],

        ["\x72\xD5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xCE"],
        ["\xED\xCE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\xD5"],

        ["\x72\xD6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xCF"],
        ["\xED\xCF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\xD6"],

        ["\x72\xD7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xD0"],
        ["\xED\xD0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\xD7"],

        ["\x72\xD8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xD1"],
        ["\xED\xD1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\xD8"],

        ["\x72\xD9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xD2"],
        ["\xED\xD2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\xD9"],

        ["\x72\xE2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xD3"],
        ["\xED\xD3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\xE2"],

        ["\x72\xE3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xD4"],
        ["\xED\xD4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\xE3"],

        ["\x72\xE4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xD5"],
        ["\xED\xD5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\xE4"],

        ["\x72\xE5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xD6"],
        ["\xED\xD6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\xE5"],

        ["\x72\xE6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xD7"],
        ["\xED\xD7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\xE6"],

        ["\x72\xE7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xD8"],
        ["\xED\xD8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\xE7"],

        ["\x72\xE8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xD9"],
        ["\xED\xD9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\xE8"],

        ["\x72\xE9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xDA"],
        ["\xED\xDA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\xE9"],

        ["\x72\x4A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xDB"],
        ["\xED\xDB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\x4A"],

        ["\x72\x5B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xDC"],
        ["\xED\xDC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\x5B"],

        ["\x72\x5A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xDD"],
        ["\xED\xDD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\x5A"],

        ["\x72\x5F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xDE"],
        ["\xED\xDE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\x5F"],

        ["\x72\x6D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xDF"],
        ["\xED\xDF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\x6D"],

        ["\x72\x79",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xE0"],
        ["\xED\xE0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\x79"],

        ["\x72\x57",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xE1"],
        ["\xED\xE1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\x57"],

        ["\x72\x59",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xE2"],
        ["\xED\xE2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\x59"],

        ["\x72\x62",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xE3"],
        ["\xED\xE3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\x62"],

        ["\x72\x63",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xE4"],
        ["\xED\xE4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\x63"],

        ["\x72\x64",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xE5"],
        ["\xED\xE5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\x64"],

        ["\x72\x65",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xE6"],
        ["\xED\xE6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\x65"],

        ["\x72\x66",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xE7"],
        ["\xED\xE7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\x66"],

        ["\x72\x67",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xE8"],
        ["\xED\xE8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\x67"],

        ["\x72\x68",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xE9"],
        ["\xED\xE9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\x68"],

        ["\x72\x69",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xEA"],
        ["\xED\xEA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\x69"],

        ["\x72\x70",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xEB"],
        ["\xED\xEB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\x70"],

        ["\x72\x71",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xEC"],
        ["\xED\xEC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\x71"],

        ["\x72\x72",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xED"],
        ["\xED\xED",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\x72"],

        ["\xC6\x9B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xEE"],
        ["\xED\xEE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\x9B"],

        ["\x72\x74",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xEF"],
        ["\xED\xEF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\x74"],

        ["\x72\x75",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xF0"],
        ["\xED\xF0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\x75"],

        ["\x72\x76",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xF1"],
        ["\xED\xF1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\x76"],

        ["\x72\x77",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xF2"],
        ["\xED\xF2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\x77"],

        ["\x72\x78",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xF3"],
        ["\xED\xF3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\x78"],

        ["\x72\x80",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xF4"],
        ["\xED\xF4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\x80"],

        ["\x72\x8B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xF5"],
        ["\xED\xF5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\x8B"],

        ["\x72\x9B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xF6"],
        ["\xED\xF6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\x9B"],

        ["\x72\x9C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xF7"],
        ["\xED\xF7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\x9C"],

        ["\x72\xA0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xF8"],
        ["\xED\xF8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\xA0"],

        ["\x72\xAB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xF9"],
        ["\xED\xF9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\xAB"],

        ["\x72\xB0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xFA"],
        ["\xED\xFA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\xB0"],

        ["\x72\xC0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xFB"],
        ["\xED\xFB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\xC0"],

        ["\x72\x6A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xFC"],
        ["\xED\xFC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\x6A"],

        ["\x72\xD0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xFD"],
        ["\xED\xFD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\xD0"],

        ["\x72\xA1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xED\xFE"],
        ["\xED\xFE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\xA1"],

        ["\x73\x4F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xA1"],
        ["\xEE\xA1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\x4F"],

        ["\x73\x7F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xA2"],
        ["\xEE\xA2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\x7F"],

        ["\x73\x7B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xA3"],
        ["\xEE\xA3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\x7B"],

        ["\x73\xE0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xA4"],
        ["\xEE\xA4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\xE0"],

        ["\x73\x6C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xA5"],
        ["\xEE\xA5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\x6C"],

        ["\x73\x50",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xA6"],
        ["\xEE\xA6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\x50"],

        ["\x73\x7D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xA7"],
        ["\xEE\xA7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\x7D"],

        ["\x73\x4D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xA8"],
        ["\xEE\xA8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\x4D"],

        ["\x73\x5D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xA9"],
        ["\xEE\xA9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\x5D"],

        ["\x73\x5C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xAA"],
        ["\xEE\xAA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\x5C"],

        ["\x73\x4E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xAB"],
        ["\xEE\xAB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\x4E"],

        ["\x73\x6B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xAC"],
        ["\xEE\xAC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\x6B"],

        ["\x73\x60",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xAD"],
        ["\xEE\xAD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\x60"],

        ["\x73\x4B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xAE"],
        ["\xEE\xAE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\x4B"],

        ["\x73\x61",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xAF"],
        ["\xEE\xAF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\x61"],

        ["\x73\xF0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xB0"],
        ["\xEE\xB0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\xF0"],

        ["\x73\xF1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xB1"],
        ["\xEE\xB1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\xF1"],

        ["\x73\xF2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xB2"],
        ["\xEE\xB2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\xF2"],

        ["\x73\xF3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xB3"],
        ["\xEE\xB3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\xF3"],

        ["\x73\xF4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xB4"],
        ["\xEE\xB4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\xF4"],

        ["\x73\xF5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xB5"],
        ["\xEE\xB5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\xF5"],

        ["\x73\xF6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xB6"],
        ["\xEE\xB6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\xF6"],

        ["\x73\xF7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xB7"],
        ["\xEE\xB7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\xF7"],

        ["\x73\xF8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xB8"],
        ["\xEE\xB8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\xF8"],

        ["\x73\xF9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xB9"],
        ["\xEE\xB9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\xF9"],

        ["\x73\x7A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xBA"],
        ["\xEE\xBA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\x7A"],

        ["\x73\x5E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xBB"],
        ["\xEE\xBB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\x5E"],

        ["\x73\x4C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xBC"],
        ["\xEE\xBC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\x4C"],

        ["\x73\x7E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xBD"],
        ["\xEE\xBD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\x7E"],

        ["\x73\x6E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xBE"],
        ["\xEE\xBE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\x6E"],

        ["\x73\x6F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xBF"],
        ["\xEE\xBF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\x6F"],

        ["\x73\x7C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xC0"],
        ["\xEE\xC0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\x7C"],

        ["\x73\xC1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xC1"],
        ["\xEE\xC1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\xC1"],

        ["\x73\xC2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xC2"],
        ["\xEE\xC2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\xC2"],

        ["\x73\xC3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xC3"],
        ["\xEE\xC3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\xC3"],

        ["\x73\xC4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xC4"],
        ["\xEE\xC4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\xC4"],

        ["\x73\xC5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xC5"],
        ["\xEE\xC5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\xC5"],

        ["\x73\xC6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xC6"],
        ["\xEE\xC6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\xC6"],

        ["\x73\xC7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xC7"],
        ["\xEE\xC7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\xC7"],

        ["\x73\xC8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xC8"],
        ["\xEE\xC8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\xC8"],

        ["\x73\xC9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xC9"],
        ["\xEE\xC9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\xC9"],

        ["\x73\xD1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xCA"],
        ["\xEE\xCA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\xD1"],

        ["\x73\xD2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xCB"],
        ["\xEE\xCB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\xD2"],

        ["\x73\xD3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xCC"],
        ["\xEE\xCC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\xD3"],

        ["\x73\xD4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xCD"],
        ["\xEE\xCD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\xD4"],

        ["\x73\xD5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xCE"],
        ["\xEE\xCE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\xD5"],

        ["\x73\xD6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xCF"],
        ["\xEE\xCF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\xD6"],

        ["\x73\xD7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xD0"],
        ["\xEE\xD0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\xD7"],

        ["\x73\xD8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xD1"],
        ["\xEE\xD1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\xD8"],

        ["\x73\xD9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xD2"],
        ["\xEE\xD2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\xD9"],

        ["\x73\xE2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xD3"],
        ["\xEE\xD3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\xE2"],

        ["\x73\xE3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xD4"],
        ["\xEE\xD4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\xE3"],

        ["\x73\xE4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xD5"],
        ["\xEE\xD5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\xE4"],

        ["\x73\xE5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xD6"],
        ["\xEE\xD6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\xE5"],

        ["\x73\xE6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xD7"],
        ["\xEE\xD7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\xE6"],

        ["\x73\xE7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xD8"],
        ["\xEE\xD8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\xE7"],

        ["\x73\xE8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xD9"],
        ["\xEE\xD9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\xE8"],

        ["\x73\xE9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xDA"],
        ["\xEE\xDA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\xE9"],

        ["\x73\x4A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xDB"],
        ["\xEE\xDB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\x4A"],

        ["\x73\x5B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xDC"],
        ["\xEE\xDC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\x5B"],

        ["\x73\x5A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xDD"],
        ["\xEE\xDD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\x5A"],

        ["\x73\x5F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xDE"],
        ["\xEE\xDE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\x5F"],

        ["\x73\x6D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xDF"],
        ["\xEE\xDF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\x6D"],

        ["\x73\x79",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xE0"],
        ["\xEE\xE0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\x79"],

        ["\x73\x57",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xE1"],
        ["\xEE\xE1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\x57"],

        ["\x73\x59",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xE2"],
        ["\xEE\xE2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\x59"],

        ["\x73\x62",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xE3"],
        ["\xEE\xE3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\x62"],

        ["\x73\x63",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xE4"],
        ["\xEE\xE4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\x63"],

        ["\x73\x64",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xE5"],
        ["\xEE\xE5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\x64"],

        ["\x73\x65",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xE6"],
        ["\xEE\xE6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\x65"],

        ["\x73\x66",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xE7"],
        ["\xEE\xE7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\x66"],

        ["\x73\x67",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xE8"],
        ["\xEE\xE8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\x67"],

        ["\x73\x68",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xE9"],
        ["\xEE\xE9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\x68"],

        ["\x73\x69",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xEA"],
        ["\xEE\xEA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\x69"],

        ["\x73\x70",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xEB"],
        ["\xEE\xEB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\x70"],

        ["\x73\x71",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xEC"],
        ["\xEE\xEC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\x71"],

        ["\x73\x72",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xED"],
        ["\xEE\xED",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\x72"],

        ["\x73\x73",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xEE"],
        ["\xEE\xEE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\x73"],

        ["\x73\x74",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xEF"],
        ["\xEE\xEF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\x74"],

        ["\x73\x75",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xF0"],
        ["\xEE\xF0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\x75"],

        ["\x73\x76",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xF1"],
        ["\xEE\xF1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\x76"],

        ["\x73\x77",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xF2"],
        ["\xEE\xF2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\x77"],

        ["\x73\x78",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xF3"],
        ["\xEE\xF3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\x78"],

        ["\x73\x80",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xF4"],
        ["\xEE\xF4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\x80"],

        ["\x73\x8B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xF5"],
        ["\xEE\xF5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\x8B"],

        ["\x73\x9B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xF6"],
        ["\xEE\xF6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\x9B"],

        ["\x73\x9C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xF7"],
        ["\xEE\xF7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\x9C"],

        ["\x73\xA0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xF8"],
        ["\xEE\xF8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\xA0"],

        ["\x73\xAB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xF9"],
        ["\xEE\xF9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\xAB"],

        ["\x73\xB0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xFA"],
        ["\xEE\xFA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\xB0"],

        ["\x73\xC0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xFB"],
        ["\xEE\xFB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\xC0"],

        ["\x73\x6A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xFC"],
        ["\xEE\xFC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\x6A"],

        ["\x73\xD0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xFD"],
        ["\xEE\xFD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\xD0"],

        ["\x73\xA1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEE\xFE"],
        ["\xEE\xFE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\xA1"],

        ["\x74\x4F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xA1"],
        ["\xEF\xA1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x74\x4F"],

        ["\x74\x7F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xA2"],
        ["\xEF\xA2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x74\x7F"],

        ["\x74\x7B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xA3"],
        ["\xEF\xA3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x74\x7B"],

        ["\x74\xE0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xA4"],
        ["\xEF\xA4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x74\xE0"],

        ["\x74\x6C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xA5"],
        ["\xEF\xA5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x74\x6C"],

        ["\x74\x50",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xA6"],
        ["\xEF\xA6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x74\x50"],

        ["\x74\x7D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xA7"],
        ["\xEF\xA7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x74\x7D"],

        ["\x74\x4D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xA8"],
        ["\xEF\xA8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x74\x4D"],

        ["\x74\x5D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xA9"],
        ["\xEF\xA9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x74\x5D"],

        ["\x74\x5C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xAA"],
        ["\xEF\xAA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x74\x5C"],

        ["\x74\x4E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xAB"],
        ["\xEF\xAB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x74\x4E"],

        ["\x74\x6B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xAC"],
        ["\xEF\xAC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x74\x6B"],

        ["\x74\x60",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xAD"],
        ["\xEF\xAD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x74\x60"],

        ["\x74\x4B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xAE"],
        ["\xEF\xAE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x74\x4B"],

        ["\x74\x61",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xAF"],
        ["\xEF\xAF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x74\x61"],

        ["\x74\xF0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xB0"],
        ["\xEF\xB0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x74\xF0"],

        ["\x74\xF1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xB1"],
        ["\xEF\xB1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x74\xF1"],

        ["\x74\xF2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xB2"],
        ["\xEF\xB2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x74\xF2"],

        ["\x74\xF3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xB3"],
        ["\xEF\xB3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x74\xF3"],

        ["\x74\xF4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xB4"],
        ["\xEF\xB4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x74\xF4"],

        ["\x74\xF5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xB5"],
        ["\xEF\xB5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x74\xF5"],

        ["\x74\xF6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xB6"],
        ["\xEF\xB6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x74\xF6"],

        ["\x74\xF7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xB7"],
        ["\xEF\xB7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x74\xF7"],

        ["\x74\xF8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xB8"],
        ["\xEF\xB8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x74\xF8"],

        ["\x74\xF9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xB9"],
        ["\xEF\xB9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x74\xF9"],

        ["\x74\x7A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBA"],
        ["\xEF\xBA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x74\x7A"],

        ["\x74\x5E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBB"],
        ["\xEF\xBB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x74\x5E"],

        ["\x74\x4C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC"],
        ["\xEF\xBC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x74\x4C"],

        ["\x74\x7E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD"],
        ["\xEF\xBD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x74\x7E"],

        ["\x74\x6E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBE"],
        ["\xEF\xBE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x74\x6E"],

        ["\x74\x6F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBF"],
        ["\xEF\xBF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x74\x6F"],

        ["\x74\x7C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xC0"],
        ["\xEF\xC0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x74\x7C"],

        ["\x74\xC1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xC1"],
        ["\xEF\xC1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x74\xC1"],

        ["\x74\xC2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xC2"],
        ["\xEF\xC2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x74\xC2"],

        ["\x74\xC3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xC3"],
        ["\xEF\xC3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x74\xC3"],

        ["\x74\xC4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xC4"],
        ["\xEF\xC4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x74\xC4"],

        ["\x74\xC5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xC5"],
        ["\xEF\xC5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x74\xC5"],

        ["\x74\xC6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xC6"],
        ["\xEF\xC6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x74\xC6"],

        ["\x74\xC7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xC7"],
        ["\xEF\xC7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x74\xC7"],

        ["\x74\xC8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xC8"],
        ["\xEF\xC8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x74\xC8"],

        ["\x74\xC9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xC9"],
        ["\xEF\xC9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x74\xC9"],

        ["\x74\xD1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xCA"],
        ["\xEF\xCA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x74\xD1"],

        ["\x74\xD2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xCB"],
        ["\xEF\xCB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x74\xD2"],

        ["\x74\xD3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xCC"],
        ["\xEF\xCC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x74\xD3"],

        ["\x74\xD4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xCD"],
        ["\xEF\xCD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x74\xD4"],

        ["\x74\xD5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xCE"],
        ["\xEF\xCE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x74\xD5"],

        ["\x74\xD6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xCF"],
        ["\xEF\xCF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x74\xD6"],

        ["\x74\xD7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xD0"],
        ["\xEF\xD0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x74\xD7"],

        ["\x74\xD8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xD1"],
        ["\xEF\xD1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x74\xD8"],

        ["\x74\xD9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xD2"],
        ["\xEF\xD2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x74\xD9"],

        ["\x74\xE2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xD3"],
        ["\xEF\xD3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x74\xE2"],

        ["\x74\xE3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xD4"],
        ["\xEF\xD4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x74\xE3"],

        ["\x74\xE4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xD5"],
        ["\xEF\xD5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x74\xE4"],

        ["\x74\xE5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xD6"],
        ["\xEF\xD6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x74\xE5"],

        ["\x74\xE6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xD7"],
        ["\xEF\xD7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x74\xE6"],

        ["\x74\xE7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xD8"],
        ["\xEF\xD8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x74\xE7"],

        ["\x74\xE8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xD9"],
        ["\xEF\xD9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x74\xE8"],

        ["\x74\xE9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xDA"],
        ["\xEF\xDA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x74\xE9"],

        ["\x74\x4A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xDB"],
        ["\xEF\xDB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x74\x4A"],

        ["\x74\x5B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xDC"],
        ["\xEF\xDC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x74\x5B"],

        ["\x74\x5A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xDD"],
        ["\xEF\xDD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x74\x5A"],

        ["\x74\x5F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xDE"],
        ["\xEF\xDE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x74\x5F"],

        ["\x74\x6D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xDF"],
        ["\xEF\xDF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x74\x6D"],

        ["\x74\x79",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xE0"],
        ["\xEF\xE0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x74\x79"],

        ["\x74\x57",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xE1"],
        ["\xEF\xE1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x74\x57"],

        ["\x74\x59",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xE2"],
        ["\xEF\xE2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x74\x59"],

        ["\x74\x62",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xE3"],
        ["\xEF\xE3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x74\x62"],

        ["\x74\x63",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xE4"],
        ["\xEF\xE4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x74\x63"],

        ["\x74\x64",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xE5"],
        ["\xEF\xE5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x74\x64"],

        ["\x74\x65",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xE6"],
        ["\xEF\xE6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x74\x65"],

        ["\x74\x66",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xE7"],
        ["\xEF\xE7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x74\x66"],

        ["\x74\x67",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xE8"],
        ["\xEF\xE8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x74\x67"],

        ["\x74\x68",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xE9"],
        ["\xEF\xE9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x74\x68"],

        ["\x74\x69",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xEA"],
        ["\xEF\xEA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x74\x69"],

        ["\x74\x70",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xEB"],
        ["\xEF\xEB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x74\x70"],

        ["\x74\x71",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xEC"],
        ["\xEF\xEC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x74\x71"],

        ["\x74\x72",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xED"],
        ["\xEF\xED",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x74\x72"],

        ["\x74\x73",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xEE"],
        ["\xEF\xEE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x74\x73"],

        ["\x74\x74",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xEF"],
        ["\xEF\xEF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x74\x74"],

        ["\x74\x75",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xF0"],
        ["\xEF\xF0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x74\x75"],

        ["\x74\x76",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xF1"],
        ["\xEF\xF1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x74\x76"],

        ["\x74\x77",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xF2"],
        ["\xEF\xF2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x74\x77"],

        ["\x74\x78",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xF3"],
        ["\xEF\xF3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x74\x78"],

        ["\x74\x80",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xF4"],
        ["\xEF\xF4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x74\x80"],

        ["\x74\x8B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xF5"],
        ["\xEF\xF5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x74\x8B"],

        ["\x74\x9B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xF6"],
        ["\xEF\xF6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x74\x9B"],

        ["\x74\x9C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xF7"],
        ["\xEF\xF7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x74\x9C"],

        ["\x74\xA0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xF8"],
        ["\xEF\xF8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x74\xA0"],

        ["\x74\xAB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xF9"],
        ["\xEF\xF9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x74\xAB"],

        ["\x74\xB0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xFA"],
        ["\xEF\xFA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x74\xB0"],

        ["\x74\xC0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xFB"],
        ["\xEF\xFB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x74\xC0"],

        ["\x74\x6A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xFC"],
        ["\xEF\xFC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x74\x6A"],

        ["\x74\xD0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xFD"],
        ["\xEF\xFD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x74\xD0"],

        ["\x74\xA1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xFE"],
        ["\xEF\xFE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x74\xA1"],

        ["\x75\x4F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xA1"],
        ["\xF0\xA1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x75\x4F"],

        ["\x75\x7F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xA2"],
        ["\xF0\xA2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x75\x7F"],

        ["\x75\x7B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xA3"],
        ["\xF0\xA3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x75\x7B"],

        ["\x75\xE0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xA4"],
        ["\xF0\xA4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x75\xE0"],

        ["\x75\x6C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xA5"],
        ["\xF0\xA5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x75\x6C"],

        ["\x75\x50",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xA6"],
        ["\xF0\xA6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x75\x50"],

        ["\x75\x7D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xA7"],
        ["\xF0\xA7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x75\x7D"],

        ["\x75\x4D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xA8"],
        ["\xF0\xA8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x75\x4D"],

        ["\x75\x5D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xA9"],
        ["\xF0\xA9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x75\x5D"],

        ["\x75\x5C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xAA"],
        ["\xF0\xAA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x75\x5C"],

        ["\x75\x4E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xAB"],
        ["\xF0\xAB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x75\x4E"],

        ["\x75\x6B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xAC"],
        ["\xF0\xAC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x75\x6B"],

        ["\x75\x60",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xAD"],
        ["\xF0\xAD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x75\x60"],

        ["\x75\x4B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xAE"],
        ["\xF0\xAE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x75\x4B"],

        ["\x75\x61",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xAF"],
        ["\xF0\xAF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x75\x61"],

        ["\x75\xF0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xB0"],
        ["\xF0\xB0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x75\xF0"],

        ["\x75\xF1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xB1"],
        ["\xF0\xB1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x75\xF1"],

        ["\x75\xF2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xB2"],
        ["\xF0\xB2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x75\xF2"],

        ["\x75\xF3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xB3"],
        ["\xF0\xB3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x75\xF3"],

        ["\x75\xF4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xB4"],
        ["\xF0\xB4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x75\xF4"],

        ["\x75\xF5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xB5"],
        ["\xF0\xB5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x75\xF5"],

        ["\x75\xF6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xB6"],
        ["\xF0\xB6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x75\xF6"],

        ["\x75\xF7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xB7"],
        ["\xF0\xB7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x75\xF7"],

        ["\x75\xF8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xB8"],
        ["\xF0\xB8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x75\xF8"],

        ["\x75\xF9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xB9"],
        ["\xF0\xB9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x75\xF9"],

        ["\x75\x7A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xBA"],
        ["\xF0\xBA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x75\x7A"],

        ["\x75\x5E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xBB"],
        ["\xF0\xBB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x75\x5E"],

        ["\x75\x4C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xBC"],
        ["\xF0\xBC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x75\x4C"],

        ["\x75\x7E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xBD"],
        ["\xF0\xBD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x75\x7E"],

        ["\x75\x6E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xBE"],
        ["\xF0\xBE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x75\x6E"],

        ["\x75\x6F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xBF"],
        ["\xF0\xBF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x75\x6F"],

        ["\x75\x7C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xC0"],
        ["\xF0\xC0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x75\x7C"],

        ["\x75\xC1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xC1"],
        ["\xF0\xC1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x75\xC1"],

        ["\x75\xC2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xC2"],
        ["\xF0\xC2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x75\xC2"],

        ["\x75\xC3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xC3"],
        ["\xF0\xC3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x75\xC3"],

        ["\x75\xC4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xC4"],
        ["\xF0\xC4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x75\xC4"],

        ["\x75\xC5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xC5"],
        ["\xF0\xC5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x75\xC5"],

        ["\x75\xC6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xC6"],
        ["\xF0\xC6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x75\xC6"],

        ["\x75\xC7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xC7"],
        ["\xF0\xC7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x75\xC7"],

        ["\x75\xC8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xC8"],
        ["\xF0\xC8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x75\xC8"],

        ["\x75\xC9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xC9"],
        ["\xF0\xC9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x75\xC9"],

        ["\x75\xD1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xCA"],
        ["\xF0\xCA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x75\xD1"],

        ["\x75\xD2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xCB"],
        ["\xF0\xCB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x75\xD2"],

        ["\x75\xD3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xCC"],
        ["\xF0\xCC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x75\xD3"],

        ["\x75\xD4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xCD"],
        ["\xF0\xCD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x75\xD4"],

        ["\x75\xD5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xCE"],
        ["\xF0\xCE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x75\xD5"],

        ["\x75\xD6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xCF"],
        ["\xF0\xCF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x75\xD6"],

        ["\x75\xD7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xD0"],
        ["\xF0\xD0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x75\xD7"],

        ["\x75\xD8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xD1"],
        ["\xF0\xD1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x75\xD8"],

        ["\x75\xD9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xD2"],
        ["\xF0\xD2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x75\xD9"],

        ["\x75\xE2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xD3"],
        ["\xF0\xD3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x75\xE2"],

        ["\x75\xE3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xD4"],
        ["\xF0\xD4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x75\xE3"],

        ["\x75\xE4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xD5"],
        ["\xF0\xD5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x75\xE4"],

        ["\x75\xE5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xD6"],
        ["\xF0\xD6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x75\xE5"],

        ["\x6F\xE8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xD7"],
        ["\xF0\xD7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\xE8"],

        ["\x75\xE7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xD8"],
        ["\xF0\xD8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x75\xE7"],

        ["\x75\xE8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xD9"],
        ["\xF0\xD9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x75\xE8"],

        ["\x75\xE9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xDA"],
        ["\xF0\xDA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x75\xE9"],

        ["\x75\x4A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xDB"],
        ["\xF0\xDB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x75\x4A"],

        ["\x75\x5B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xDC"],
        ["\xF0\xDC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x75\x5B"],

        ["\x75\x5A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xDD"],
        ["\xF0\xDD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x75\x5A"],

        ["\x75\x5F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xDE"],
        ["\xF0\xDE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x75\x5F"],

        ["\x75\x6D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xDF"],
        ["\xF0\xDF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x75\x6D"],

        ["\x75\x79",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xE0"],
        ["\xF0\xE0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x75\x79"],

        ["\x75\x57",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xE1"],
        ["\xF0\xE1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x75\x57"],

        ["\x75\x59",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xE2"],
        ["\xF0\xE2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x75\x59"],

        ["\x75\x62",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xE3"],
        ["\xF0\xE3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x75\x62"],

        ["\x75\x63",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xE4"],
        ["\xF0\xE4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x75\x63"],

        ["\x75\x64",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xE5"],
        ["\xF0\xE5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x75\x64"],

        ["\x75\x65",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xE6"],
        ["\xF0\xE6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x75\x65"],

        ["\x75\x66",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xE7"],
        ["\xF0\xE7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x75\x66"],

        ["\x75\x67",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xE8"],
        ["\xF0\xE8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x75\x67"],

        ["\x75\x68",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xE9"],
        ["\xF0\xE9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x75\x68"],

        ["\x75\x69",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xEA"],
        ["\xF0\xEA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x75\x69"],

        ["\x75\x70",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xEB"],
        ["\xF0\xEB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x75\x70"],

        ["\x75\x71",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xEC"],
        ["\xF0\xEC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x75\x71"],

        ["\x75\x72",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xED"],
        ["\xF0\xED",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x75\x72"],

        ["\x75\x73",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xEE"],
        ["\xF0\xEE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x75\x73"],

        ["\x75\x74",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xEF"],
        ["\xF0\xEF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x75\x74"],

        ["\x75\x75",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xF0"],
        ["\xF0\xF0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x75\x75"],

        ["\x75\x76",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xF1"],
        ["\xF0\xF1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x75\x76"],

        ["\x75\x77",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xF2"],
        ["\xF0\xF2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x75\x77"],

        ["\x75\x78",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xF3"],
        ["\xF0\xF3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x75\x78"],

        ["\xF7\x4A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xF4"],
        ["\xF0\xF4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF7\x4A"],

        ["\x75\x8B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xF5"],
        ["\xF0\xF5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x75\x8B"],

        ["\x75\x9B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xF6"],
        ["\xF0\xF6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x75\x9B"],

        ["\x75\x9C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xF7"],
        ["\xF0\xF7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x75\x9C"],

        ["\x75\xA0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xF8"],
        ["\xF0\xF8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x75\xA0"],

        ["\x75\xAB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xF9"],
        ["\xF0\xF9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x75\xAB"],

        ["\x75\xB0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xFA"],
        ["\xF0\xFA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x75\xB0"],

        ["\x75\xC0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xFB"],
        ["\xF0\xFB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x75\xC0"],

        ["\x75\x6A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xFC"],
        ["\xF0\xFC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x75\x6A"],

        ["\x75\xD0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xFD"],
        ["\xF0\xFD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x75\xD0"],

        ["\x75\xA1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF0\xFE"],
        ["\xF0\xFE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x75\xA1"],

        ["\x76\x4F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xA1"],
        ["\xF1\xA1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x76\x4F"],

        ["\x76\x7F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xA2"],
        ["\xF1\xA2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x76\x7F"],

        ["\x76\x7B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xA3"],
        ["\xF1\xA3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x76\x7B"],

        ["\x76\xE0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xA4"],
        ["\xF1\xA4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x76\xE0"],

        ["\x76\x6C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xA5"],
        ["\xF1\xA5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x76\x6C"],

        ["\x76\x50",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xA6"],
        ["\xF1\xA6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x76\x50"],

        ["\x76\x7D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xA7"],
        ["\xF1\xA7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x76\x7D"],

        ["\x76\x4D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xA8"],
        ["\xF1\xA8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x76\x4D"],

        ["\x76\x5D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xA9"],
        ["\xF1\xA9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x76\x5D"],

        ["\x76\x5C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xAA"],
        ["\xF1\xAA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x76\x5C"],

        ["\x76\x4E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xAB"],
        ["\xF1\xAB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x76\x4E"],

        ["\x76\x6B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xAC"],
        ["\xF1\xAC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x76\x6B"],

        ["\x76\x60",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xAD"],
        ["\xF1\xAD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x76\x60"],

        ["\x76\x4B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xAE"],
        ["\xF1\xAE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x76\x4B"],

        ["\x76\x61",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xAF"],
        ["\xF1\xAF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x76\x61"],

        ["\x76\xF0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xB0"],
        ["\xF1\xB0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x76\xF0"],

        ["\x76\xF1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xB1"],
        ["\xF1\xB1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x76\xF1"],

        ["\x76\xF2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xB2"],
        ["\xF1\xB2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x76\xF2"],

        ["\x76\xF3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xB3"],
        ["\xF1\xB3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x76\xF3"],

        ["\x76\xF4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xB4"],
        ["\xF1\xB4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x76\xF4"],

        ["\x76\xF5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xB5"],
        ["\xF1\xB5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x76\xF5"],

        ["\x76\xF6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xB6"],
        ["\xF1\xB6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x76\xF6"],

        ["\x76\xF7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xB7"],
        ["\xF1\xB7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x76\xF7"],

        ["\x76\xF8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xB8"],
        ["\xF1\xB8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x76\xF8"],

        ["\x76\xF9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xB9"],
        ["\xF1\xB9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x76\xF9"],

        ["\x76\x7A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xBA"],
        ["\xF1\xBA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x76\x7A"],

        ["\x76\x5E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xBB"],
        ["\xF1\xBB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x76\x5E"],

        ["\x76\x4C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xBC"],
        ["\xF1\xBC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x76\x4C"],

        ["\x76\x7E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xBD"],
        ["\xF1\xBD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x76\x7E"],

        ["\x76\x6E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xBE"],
        ["\xF1\xBE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x76\x6E"],

        ["\x76\x6F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xBF"],
        ["\xF1\xBF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x76\x6F"],

        ["\x76\x7C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xC0"],
        ["\xF1\xC0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x76\x7C"],

        ["\x76\xC1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xC1"],
        ["\xF1\xC1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x76\xC1"],

        ["\x76\xC2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xC2"],
        ["\xF1\xC2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x76\xC2"],

        ["\x76\xC3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xC3"],
        ["\xF1\xC3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x76\xC3"],

        ["\x76\xC4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xC4"],
        ["\xF1\xC4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x76\xC4"],

        ["\x76\xC5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xC5"],
        ["\xF1\xC5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x76\xC5"],

        ["\x76\xC6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xC6"],
        ["\xF1\xC6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x76\xC6"],

        ["\x76\xC7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xC7"],
        ["\xF1\xC7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x76\xC7"],

        ["\x76\xC8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xC8"],
        ["\xF1\xC8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x76\xC8"],

        ["\x76\xC9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xC9"],
        ["\xF1\xC9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x76\xC9"],

        ["\x76\xD1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xCA"],
        ["\xF1\xCA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x76\xD1"],

        ["\x76\xD2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xCB"],
        ["\xF1\xCB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x76\xD2"],

        ["\x76\xD3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xCC"],
        ["\xF1\xCC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x76\xD3"],

        ["\x76\xD4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xCD"],
        ["\xF1\xCD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x76\xD4"],

        ["\x76\xD5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xCE"],
        ["\xF1\xCE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x76\xD5"],

        ["\x76\xD6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xCF"],
        ["\xF1\xCF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x76\xD6"],

        ["\x76\xD7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xD0"],
        ["\xF1\xD0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x76\xD7"],

        ["\x76\xD8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xD1"],
        ["\xF1\xD1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x76\xD8"],

        ["\x76\xD9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xD2"],
        ["\xF1\xD2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x76\xD9"],

        ["\x76\xE2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xD3"],
        ["\xF1\xD3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x76\xE2"],

        ["\x76\xE3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xD4"],
        ["\xF1\xD4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x76\xE3"],

        ["\x76\xE4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xD5"],
        ["\xF1\xD5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x76\xE4"],

        ["\x76\xE5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xD6"],
        ["\xF1\xD6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x76\xE5"],

        ["\x76\xE6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xD7"],
        ["\xF1\xD7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x76\xE6"],

        ["\x76\xE7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xD8"],
        ["\xF1\xD8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x76\xE7"],

        ["\x76\xE8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xD9"],
        ["\xF1\xD9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x76\xE8"],

        ["\x76\xE9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xDA"],
        ["\xF1\xDA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x76\xE9"],

        ["\x76\x4A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xDB"],
        ["\xF1\xDB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x76\x4A"],

        ["\x76\x5B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xDC"],
        ["\xF1\xDC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x76\x5B"],

        ["\x76\x5A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xDD"],
        ["\xF1\xDD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x76\x5A"],

        ["\x76\x5F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xDE"],
        ["\xF1\xDE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x76\x5F"],

        ["\x76\x6D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xDF"],
        ["\xF1\xDF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x76\x6D"],

        ["\x76\x79",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xE0"],
        ["\xF1\xE0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x76\x79"],

        ["\x76\x57",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xE1"],
        ["\xF1\xE1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x76\x57"],

        ["\x76\x59",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xE2"],
        ["\xF1\xE2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x76\x59"],

        ["\x76\x62",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xE3"],
        ["\xF1\xE3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x76\x62"],

        ["\x76\x63",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xE4"],
        ["\xF1\xE4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x76\x63"],

        ["\x76\x64",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xE5"],
        ["\xF1\xE5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x76\x64"],

        ["\x76\x65",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xE6"],
        ["\xF1\xE6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x76\x65"],

        ["\x76\x66",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xE7"],
        ["\xF1\xE7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x76\x66"],

        ["\x76\x67",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xE8"],
        ["\xF1\xE8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x76\x67"],

        ["\x76\x68",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xE9"],
        ["\xF1\xE9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x76\x68"],

        ["\x76\x69",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xEA"],
        ["\xF1\xEA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x76\x69"],

        ["\x76\x70",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xEB"],
        ["\xF1\xEB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x76\x70"],

        ["\x76\x71",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xEC"],
        ["\xF1\xEC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x76\x71"],

        ["\x76\x72",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xED"],
        ["\xF1\xED",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x76\x72"],

        ["\x76\x73",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xEE"],
        ["\xF1\xEE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x76\x73"],

        ["\x76\x74",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xEF"],
        ["\xF1\xEF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x76\x74"],

        ["\x76\x75",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xF0"],
        ["\xF1\xF0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x76\x75"],

        ["\x76\x76",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xF1"],
        ["\xF1\xF1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x76\x76"],

        ["\x76\x77",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xF2"],
        ["\xF1\xF2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x76\x77"],

        ["\x76\x78",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xF3"],
        ["\xF1\xF3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x76\x78"],

        ["\x76\x80",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xF4"],
        ["\xF1\xF4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x76\x80"],

        ["\x76\x8B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xF5"],
        ["\xF1\xF5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x76\x8B"],

        ["\x76\x9B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xF6"],
        ["\xF1\xF6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x76\x9B"],

        ["\x76\x9C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xF7"],
        ["\xF1\xF7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x76\x9C"],

        ["\x76\xA0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xF8"],
        ["\xF1\xF8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x76\xA0"],

        ["\x76\xAB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xF9"],
        ["\xF1\xF9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x76\xAB"],

        ["\x76\xB0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xFA"],
        ["\xF1\xFA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x76\xB0"],

        ["\x76\xC0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xFB"],
        ["\xF1\xFB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x76\xC0"],

        ["\x76\x6A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xFC"],
        ["\xF1\xFC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x76\x6A"],

        ["\x76\xD0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xFD"],
        ["\xF1\xFD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x76\xD0"],

        ["\x76\xA1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF1\xFE"],
        ["\xF1\xFE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x76\xA1"],

        ["\x77\x4F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xA1"],
        ["\xF2\xA1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x77\x4F"],

        ["\x77\x7F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xA2"],
        ["\xF2\xA2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x77\x7F"],

        ["\x77\x7B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xA3"],
        ["\xF2\xA3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x77\x7B"],

        ["\x77\xE0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xA4"],
        ["\xF2\xA4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x77\xE0"],

        ["\x77\x6C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xA5"],
        ["\xF2\xA5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x77\x6C"],

        ["\x77\x50",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xA6"],
        ["\xF2\xA6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x77\x50"],

        ["\x77\x7D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xA7"],
        ["\xF2\xA7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x77\x7D"],

        ["\x77\x4D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xA8"],
        ["\xF2\xA8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x77\x4D"],

        ["\x77\x5D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xA9"],
        ["\xF2\xA9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x77\x5D"],

        ["\x77\x5C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xAA"],
        ["\xF2\xAA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x77\x5C"],

        ["\x77\x4E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xAB"],
        ["\xF2\xAB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x77\x4E"],

        ["\x77\x6B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xAC"],
        ["\xF2\xAC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x77\x6B"],

        ["\x77\x60",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xAD"],
        ["\xF2\xAD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x77\x60"],

        ["\x77\x4B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xAE"],
        ["\xF2\xAE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x77\x4B"],

        ["\x77\x61",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xAF"],
        ["\xF2\xAF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x77\x61"],

        ["\x77\xF0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xB0"],
        ["\xF2\xB0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x77\xF0"],

        ["\x77\xF1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xB1"],
        ["\xF2\xB1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x77\xF1"],

        ["\x77\xF2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xB2"],
        ["\xF2\xB2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x77\xF2"],

        ["\x77\xF3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xB3"],
        ["\xF2\xB3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x77\xF3"],

        ["\x77\xF4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xB4"],
        ["\xF2\xB4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x77\xF4"],

        ["\x77\xF5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xB5"],
        ["\xF2\xB5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x77\xF5"],

        ["\x77\xF6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xB6"],
        ["\xF2\xB6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x77\xF6"],

        ["\x77\xF7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xB7"],
        ["\xF2\xB7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x77\xF7"],

        ["\x77\xF8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xB8"],
        ["\xF2\xB8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x77\xF8"],

        ["\x77\xF9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xB9"],
        ["\xF2\xB9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x77\xF9"],

        ["\x77\x7A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xBA"],
        ["\xF2\xBA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x77\x7A"],

        ["\x77\x5E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xBB"],
        ["\xF2\xBB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x77\x5E"],

        ["\x77\x4C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xBC"],
        ["\xF2\xBC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x77\x4C"],

        ["\x77\x7E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xBD"],
        ["\xF2\xBD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x77\x7E"],

        ["\x77\x6E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xBE"],
        ["\xF2\xBE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x77\x6E"],

        ["\x77\x6F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xBF"],
        ["\xF2\xBF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x77\x6F"],

        ["\x77\x7C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xC0"],
        ["\xF2\xC0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x77\x7C"],

        ["\x77\xC1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xC1"],
        ["\xF2\xC1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x77\xC1"],

        ["\x77\xC2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xC2"],
        ["\xF2\xC2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x77\xC2"],

        ["\x77\xC3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xC3"],
        ["\xF2\xC3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x77\xC3"],

        ["\x77\xC4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xC4"],
        ["\xF2\xC4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x77\xC4"],

        ["\x77\xC5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xC5"],
        ["\xF2\xC5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x77\xC5"],

        ["\x77\xC6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xC6"],
        ["\xF2\xC6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x77\xC6"],

        ["\x77\xC7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xC7"],
        ["\xF2\xC7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x77\xC7"],

        ["\x77\xC8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xC8"],
        ["\xF2\xC8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x77\xC8"],

        ["\x77\xC9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xC9"],
        ["\xF2\xC9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x77\xC9"],

        ["\x77\xD1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xCA"],
        ["\xF2\xCA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x77\xD1"],

        ["\x77\xD2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xCB"],
        ["\xF2\xCB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x77\xD2"],

        ["\x77\xD3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xCC"],
        ["\xF2\xCC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x77\xD3"],

        ["\xF0\xF3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xCD"],
        ["\xF2\xCD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xF3"],

        ["\x77\xD5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xCE"],
        ["\xF2\xCE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x77\xD5"],

        ["\x77\xD6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xCF"],
        ["\xF2\xCF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x77\xD6"],

        ["\x77\xD7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xD0"],
        ["\xF2\xD0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x77\xD7"],

        ["\x77\xD8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xD1"],
        ["\xF2\xD1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x77\xD8"],

        ["\x77\xD9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xD2"],
        ["\xF2\xD2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x77\xD9"],

        ["\x77\xE2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xD3"],
        ["\xF2\xD3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x77\xE2"],

        ["\x77\xE3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xD4"],
        ["\xF2\xD4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x77\xE3"],

        ["\x77\xE4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xD5"],
        ["\xF2\xD5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x77\xE4"],

        ["\x77\xE5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xD6"],
        ["\xF2\xD6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x77\xE5"],

        ["\x77\xE6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xD7"],
        ["\xF2\xD7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x77\xE6"],

        ["\x77\xE7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xD8"],
        ["\xF2\xD8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x77\xE7"],

        ["\x77\xE8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xD9"],
        ["\xF2\xD9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x77\xE8"],

        ["\x77\xE9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xDA"],
        ["\xF2\xDA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x77\xE9"],

        ["\x77\x4A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xDB"],
        ["\xF2\xDB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x77\x4A"],

        ["\x77\x5B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xDC"],
        ["\xF2\xDC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x77\x5B"],

        ["\x77\x5A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xDD"],
        ["\xF2\xDD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x77\x5A"],

        ["\x77\x5F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xDE"],
        ["\xF2\xDE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x77\x5F"],

        ["\x77\x6D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xDF"],
        ["\xF2\xDF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x77\x6D"],

        ["\x77\x79",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xE0"],
        ["\xF2\xE0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x77\x79"],

        ["\x77\x57",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xE1"],
        ["\xF2\xE1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x77\x57"],

        ["\x77\x59",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xE2"],
        ["\xF2\xE2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x77\x59"],

        ["\x77\x62",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xE3"],
        ["\xF2\xE3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x77\x62"],

        ["\x77\x63",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xE4"],
        ["\xF2\xE4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x77\x63"],

        ["\x77\x64",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xE5"],
        ["\xF2\xE5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x77\x64"],

        ["\x77\x65",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xE6"],
        ["\xF2\xE6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x77\x65"],

        ["\x77\x66",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xE7"],
        ["\xF2\xE7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x77\x66"],

        ["\x77\x67",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xE8"],
        ["\xF2\xE8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x77\x67"],

        ["\x77\x68",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xE9"],
        ["\xF2\xE9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x77\x68"],

        ["\x77\x69",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xEA"],
        ["\xF2\xEA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x77\x69"],

        ["\x77\x70",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xEB"],
        ["\xF2\xEB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x77\x70"],

        ["\x77\x71",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xEC"],
        ["\xF2\xEC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x77\x71"],

        ["\x77\x72",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xED"],
        ["\xF2\xED",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x77\x72"],

        ["\x77\x73",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xEE"],
        ["\xF2\xEE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x77\x73"],

        ["\x77\x74",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xEF"],
        ["\xF2\xEF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x77\x74"],

        ["\x77\x75",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xF0"],
        ["\xF2\xF0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x77\x75"],

        ["\x77\x76",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xF1"],
        ["\xF2\xF1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x77\x76"],

        ["\x77\x77",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xF2"],
        ["\xF2\xF2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x77\x77"],

        ["\x77\x78",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xF3"],
        ["\xF2\xF3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x77\x78"],

        ["\xF2\x5D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xF4"],
        ["\xF2\xF4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\x5D"],

        ["\x77\x8B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xF5"],
        ["\xF2\xF5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x77\x8B"],

        ["\x77\x9B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xF6"],
        ["\xF2\xF6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x77\x9B"],

        ["\x77\x9C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xF7"],
        ["\xF2\xF7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x77\x9C"],

        ["\x77\xA0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xF8"],
        ["\xF2\xF8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x77\xA0"],

        ["\x77\xAB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xF9"],
        ["\xF2\xF9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x77\xAB"],

        ["\x77\xB0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xFA"],
        ["\xF2\xFA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x77\xB0"],

        ["\x77\xC0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xFB"],
        ["\xF2\xFB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x77\xC0"],

        ["\x77\x6A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xFC"],
        ["\xF2\xFC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x77\x6A"],

        ["\x77\xD0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xFD"],
        ["\xF2\xFD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x77\xD0"],

        ["\x77\xA1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF2\xFE"],
        ["\xF2\xFE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x77\xA1"],

        ["\x78\x4F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xA1"],
        ["\xF3\xA1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x78\x4F"],

        ["\x78\x7F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xA2"],
        ["\xF3\xA2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x78\x7F"],

        ["\x78\x7B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xA3"],
        ["\xF3\xA3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x78\x7B"],

        ["\x78\xE0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xA4"],
        ["\xF3\xA4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x78\xE0"],

        ["\x78\x6C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xA5"],
        ["\xF3\xA5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x78\x6C"],

        ["\x78\x50",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xA6"],
        ["\xF3\xA6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x78\x50"],

        ["\x78\x7D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xA7"],
        ["\xF3\xA7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x78\x7D"],

        ["\x78\x4D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xA8"],
        ["\xF3\xA8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x78\x4D"],

        ["\x78\x5D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xA9"],
        ["\xF3\xA9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x78\x5D"],

        ["\x78\x5C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xAA"],
        ["\xF3\xAA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x78\x5C"],

        ["\x78\x4E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xAB"],
        ["\xF3\xAB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x78\x4E"],

        ["\x78\x6B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xAC"],
        ["\xF3\xAC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x78\x6B"],

        ["\x78\x60",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xAD"],
        ["\xF3\xAD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x78\x60"],

        ["\x78\x4B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xAE"],
        ["\xF3\xAE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x78\x4B"],

        ["\x78\x61",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xAF"],
        ["\xF3\xAF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x78\x61"],

        ["\x78\xF0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0"],
        ["\xF3\xB0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x78\xF0"],

        ["\x78\xF1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1"],
        ["\xF3\xB1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x78\xF1"],

        ["\x78\xF2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2"],
        ["\xF3\xB2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x78\xF2"],

        ["\x78\xF3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3"],
        ["\xF3\xB3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x78\xF3"],

        ["\x78\xF4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4"],
        ["\xF3\xB4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x78\xF4"],

        ["\x78\xF5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5"],
        ["\xF3\xB5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x78\xF5"],

        ["\x78\xF6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB6"],
        ["\xF3\xB6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x78\xF6"],

        ["\x78\xF7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB7"],
        ["\xF3\xB7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x78\xF7"],

        ["\x78\xF8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB8"],
        ["\xF3\xB8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x78\xF8"],

        ["\x78\xF9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB9"],
        ["\xF3\xB9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x78\xF9"],

        ["\x78\x7A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xBA"],
        ["\xF3\xBA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x78\x7A"],

        ["\x78\x5E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xBB"],
        ["\xF3\xBB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x78\x5E"],

        ["\x78\x4C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xBC"],
        ["\xF3\xBC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x78\x4C"],

        ["\x78\x7E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xBD"],
        ["\xF3\xBD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x78\x7E"],

        ["\x78\x6E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xBE"],
        ["\xF3\xBE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x78\x6E"],

        ["\x78\x6F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xBF"],
        ["\xF3\xBF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x78\x6F"],

        ["\x78\x7C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xC0"],
        ["\xF3\xC0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x78\x7C"],

        ["\x78\xC1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xC1"],
        ["\xF3\xC1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x78\xC1"],

        ["\x78\xC2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xC2"],
        ["\xF3\xC2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x78\xC2"],

        ["\x78\xC3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xC3"],
        ["\xF3\xC3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x78\xC3"],

        ["\x78\xC4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xC4"],
        ["\xF3\xC4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x78\xC4"],

        ["\x78\xC5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xC5"],
        ["\xF3\xC5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x78\xC5"],

        ["\x78\xC6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xC6"],
        ["\xF3\xC6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x78\xC6"],

        ["\x78\xC7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xC7"],
        ["\xF3\xC7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x78\xC7"],

        ["\x78\xC8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xC8"],
        ["\xF3\xC8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x78\xC8"],

        ["\x78\xC9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xC9"],
        ["\xF3\xC9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x78\xC9"],

        ["\x78\xD1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xCA"],
        ["\xF3\xCA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x78\xD1"],

        ["\x78\xD2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xCB"],
        ["\xF3\xCB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x78\xD2"],

        ["\x78\xD3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xCC"],
        ["\xF3\xCC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x78\xD3"],

        ["\x78\xD4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xCD"],
        ["\xF3\xCD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x78\xD4"],

        ["\x78\xD5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xCE"],
        ["\xF3\xCE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x78\xD5"],

        ["\x78\xD6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xCF"],
        ["\xF3\xCF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x78\xD6"],

        ["\x78\xD7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xD0"],
        ["\xF3\xD0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x78\xD7"],

        ["\x78\xD8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xD1"],
        ["\xF3\xD1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x78\xD8"],

        ["\x78\xD9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xD2"],
        ["\xF3\xD2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x78\xD9"],

        ["\x78\xE2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xD3"],
        ["\xF3\xD3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x78\xE2"],

        ["\x78\xE3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xD4"],
        ["\xF3\xD4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x78\xE3"],

        ["\x78\xE4",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xD5"],
        ["\xF3\xD5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x78\xE4"],

        ["\x78\xE5",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xD6"],
        ["\xF3\xD6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x78\xE5"],

        ["\x78\xE6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xD7"],
        ["\xF3\xD7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x78\xE6"],

        ["\x78\xE7",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xD8"],
        ["\xF3\xD8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x78\xE7"],

        ["\x78\xE8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xD9"],
        ["\xF3\xD9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x78\xE8"],

        ["\x78\xE9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xDA"],
        ["\xF3\xDA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x78\xE9"],

        ["\x78\x4A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xDB"],
        ["\xF3\xDB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x78\x4A"],

        ["\x78\x5B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xDC"],
        ["\xF3\xDC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x78\x5B"],

        ["\x78\x5A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xDD"],
        ["\xF3\xDD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x78\x5A"],

        ["\x78\x5F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xDE"],
        ["\xF3\xDE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x78\x5F"],

        ["\x78\x6D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xDF"],
        ["\xF3\xDF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x78\x6D"],

        ["\x78\x79",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xE0"],
        ["\xF3\xE0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x78\x79"],

        ["\x78\x57",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xE1"],
        ["\xF3\xE1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x78\x57"],

        ["\x78\x59",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xE2"],
        ["\xF3\xE2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x78\x59"],

        ["\x78\x62",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xE3"],
        ["\xF3\xE3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x78\x62"],

        ["\x78\x63",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xE4"],
        ["\xF3\xE4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x78\x63"],

        ["\x78\x64",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xE5"],
        ["\xF3\xE5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x78\x64"],

        ["\x78\x65",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xE6"],
        ["\xF3\xE6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x78\x65"],

        ["\x78\x66",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xE7"],
        ["\xF3\xE7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x78\x66"],

        ["\x78\x67",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xE8"],
        ["\xF3\xE8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x78\x67"],

        ["\x78\x68",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xE9"],
        ["\xF3\xE9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x78\x68"],

        ["\x78\x69",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xEA"],
        ["\xF3\xEA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x78\x69"],

        ["\x78\x70",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xEB"],
        ["\xF3\xEB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x78\x70"],

        ["\x78\x71",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xEC"],
        ["\xF3\xEC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x78\x71"],

        ["\x78\x72",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xED"],
        ["\xF3\xED",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x78\x72"],

        ["\x78\x73",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xEE"],
        ["\xF3\xEE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x78\x73"],

        ["\x78\x74",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xEF"],
        ["\xF3\xEF",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x78\x74"],

        ["\x78\x75",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xF0"],
        ["\xF3\xF0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x78\x75"],

        ["\x78\x76",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xF1"],
        ["\xF3\xF1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x78\x76"],

        ["\x78\x77",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xF2"],
        ["\xF3\xF2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x78\x77"],

        ["\x78\x78",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xF3"],
        ["\xF3\xF3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x78\x78"],

        ["\x78\x80",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xF4"],
        ["\xF3\xF4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x78\x80"],

        ["\x78\x8B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xF5"],
        ["\xF3\xF5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x78\x8B"],

        ["\x78\x9B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xF6"],
        ["\xF3\xF6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x78\x9B"],

        ["\x78\x9C",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xF7"],
        ["\xF3\xF7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x78\x9C"],

        ["\x78\xA0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xF8"],
        ["\xF3\xF8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x78\xA0"],

        ["\x78\xAB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xF9"],
        ["\xF3\xF9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x78\xAB"],

        ["\x78\xB0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xFA"],
        ["\xF3\xFA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x78\xB0"],

        ["\x78\xC0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xFB"],
        ["\xF3\xFB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x78\xC0"],

        ["\x78\x6A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xFC"],
        ["\xF3\xFC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x78\x6A"],

        ["\x78\xD0",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xFD"],
        ["\xF3\xFD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x78\xD0"],

        ["\x78\xA1",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xFE"],
        ["\xF3\xFE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x78\xA1"],

        ["\xF6\xC6",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF4\xA1"],
        ["\xF4\xA1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xF6\xC6"],

        ["\xD2\x69",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF4\xA2"],
        ["\xF4\xA2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\x69"],

        ["\xD4\xE9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF4\xA3"],
        ["\xF4\xA3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xE9"],

        ["\x79\x9B",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF4\xA4"],
        ["\xF4\xA4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x79\x9B"],

        ["\x84\x48",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF4\xA5"],
        ["\xF4\xA5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x84\x48"],

        ["\x94\x8A",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xF4\xA6"],
        ["\xF4\xA6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x94\x8A"],

        ["\x42\x8E",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\x31\xF0"],
        ["\x31\xF0",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x42\x8E"],

        ["\x42\x8F",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\x31\xF1"],
        ["\x31\xF1",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x42\x8F"],

        ["\x42\x90",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\x31\xF2"],
        ["\x31\xF2",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x42\x90"],

        ["\x42\x91",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\x31\xF3"],
        ["\x31\xF3",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x42\x91"],

        ["\x42\x92",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\x31\xF4"],
        ["\x31\xF4",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x42\x92"],

        ["\x42\x93",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\x31\xF5"],
        ["\x31\xF5",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x42\x93"],

        ["\x42\x94",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\x31\xF6"],
        ["\x31\xF6",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x42\x94"],

        ["\x42\x95",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\x31\xF7"],
        ["\x31\xF7",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x42\x95"],

        ["\x42\x96",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\x31\xF8"],
        ["\x31\xF8",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x42\x96"],

        ["\x42\x97",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\x31\xF9"],
        ["\x31\xF9",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x42\x97"],

        ["\x45\xFB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\x31\xFA"],
        ["\x31\xFA",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x45\xFB"],

        ["\x43\xEF",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\x31\xFB"],
        ["\x31\xFB",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x43\xEF"],

        ["\x43\xFA",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\x31\xFC"],
        ["\x31\xFC",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x43\xFA"],

        ["\x9A\xAE",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD4\x63"],
        ["\xD4\x63",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x9A\xAE"],

        ["\xA3\x49",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xDC\x5F"],
        ["\xDC\x5F",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xA3\x49"],

        ["\xA7\x89",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\x69"],
        ["\xE4\x69",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xA7\x89"],

        ["\xA6\xCF",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x78"],
        ["\xE3\x78",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xA6\xCF"],

        ["\x9F\x9D",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xD9\x21"],
        ["\xD9\x21",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x9F\x9D"],

        ["\x82\xEC",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\x3B"],
        ["\xB1\x3B",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x82\xEC"],

        ["\x93\xFE",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\x31\xFD"],
        ["\x31\xFD",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x93\xFE"],

        ["\x8E\x90",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\x2D"],
        ["\xC2\x2D",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x8E\x90"],

        ["\x90\x87",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\x7C"],
        ["\xC3\x7C",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x90\x87"],

        ["\xA7\x86",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\x50"],
        ["\xE4\x50",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\xA7\x86"],

        ["\x8E\xAA",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\x3F"],
        ["\xC2\x3F",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x8E\xAA"],

        ["\x8A\x98",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xBC\x74"],
        ["\xBC\x74",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x8A\x98"],

        ["\x82\x52",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\x29"],
        ["\xB0\x29",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x82\x52"],

        ["\x82\x93",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\x48"],
        ["\xB0\x48",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x82\x93"],

        ["\x82\xA8",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\x31\xFE"],
        ["\x31\xFE",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x82\xA8"],

        ["\x82\xA2",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\x52"],
        ["\xB0\x52",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x82\xA2"],

        ["\x82\xA3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\x54"],
        ["\xB0\x54",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x82\xA3"],

        ["\x82\xBB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\x63"],
        ["\xB0\x63",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x82\xBB"],

        ["\x82\xAC",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB0\x6E"],
        ["\xB0\x6E",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x82\xAC"],

        ["\x82\xCC",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\x27"],
        ["\xB1\x27",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x82\xCC"],

        ["\x82\xB9",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\x23"],
        ["\xB1\x23",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x82\xB9"],

        ["\x8A\xBA",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\x2C"],
        ["\xB1\x2C",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x8A\xBA"],

        ["\x82\xB3",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\x29"],
        ["\xB1\x29",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x82\xB3"],

        ["\x82\xEB",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\x3E"],
        ["\xB1\x3E",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x82\xEB"],

        ["\x83\x82",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\x5F"],
        ["\xB1\x5F",'jipse','letsj',{'INPUT_LAYOUT'=>'D'},"\x83\x82"],

        ["\x83\x41",'letsj','jipse',{'INPUT_LAYOUT'=>'D'},"\xB1\x58"],
        ["