######################################################################
#
# 2051_utf8jp_by_cp00930.t
#
# Copyright (c) 2018 INABA Hitoshi <ina@cpan.org> in a CPAN
######################################################################

use strict;
use FindBin;
use lib "$FindBin::Bin/../lib";

BEGIN {
    use vars qw(@test);
    @test = (
        ["\x00",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\x80"],
        ["\x01",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\x81"],
        ["\x02",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\x82"],
        ["\x03",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\x83"],
        ["\x37",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\x84"],
        ["\x2D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\x85"],
        ["\x2E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\x86"],
        ["\x2F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\x87"],
        ["\x16",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\x88"],
        ["\x05",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\x89"],
        ["\x15",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\x8A"],
        ["\x0B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\x8B"],
        ["\x0C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\x8C"],
        ["\x0D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\x8D"],
        ["\x0E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\x8E"],
        ["\x0F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\x8F"],
        ["\x10",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\x90"],
        ["\x11",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\x91"],
        ["\x12",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\x92"],
        ["\x13",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\x93"],
        ["\x3C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\x94"],
        ["\x3D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\x95"],
        ["\x32",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\x96"],
        ["\x26",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\x97"],
        ["\x18",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\x98"],
        ["\x19",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\x99"],
        ["\x3F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\x9A"],
        ["\x27",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\x9B"],
        ["\x1C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\x9C"],
        ["\x1D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\x9D"],
        ["\x1E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\x9E"],
        ["\x1F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\x9F"],
        ["\x40",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\xA0"],
        ["\x5A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\xA1"],
        ["\x7F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\xA2"],
        ["\x7B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\xA3"],
        ["\xE0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\xA4"],
        ["\x6C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\xA5"],
        ["\x50",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\xA6"],
        ["\x7D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\xA7"],
        ["\x4D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\xA8"],
        ["\x5D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\xA9"],
        ["\x5C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\xAA"],
        ["\x4E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\xAB"],
        ["\x6B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\xAC"],
        ["\x60",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\xAD"],
        ["\x4B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\xAE"],
        ["\x61",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\xAF"],
        ["\xF0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\xB0"],
        ["\xF1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\xB1"],
        ["\xF2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\xB2"],
        ["\xF3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\xB3"],
        ["\xF4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\xB4"],
        ["\xF5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\xB5"],
        ["\xF6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\xB6"],
        ["\xF7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\xB7"],
        ["\xF8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\xB8"],
        ["\xF9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\xB9"],
        ["\x7A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\xBA"],
        ["\x5E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\xBB"],
        ["\x4C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\xBC"],
        ["\x7E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\xBD"],
        ["\x6E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\xBE"],
        ["\x6F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\xBF"],
        ["\x7C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\x80"],
        ["\xC1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\x81"],
        ["\xC2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\x82"],
        ["\xC3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\x83"],
        ["\xC4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\x84"],
        ["\xC5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\x85"],
        ["\xC6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\x86"],
        ["\xC7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\x87"],
        ["\xC8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\x88"],
        ["\xC9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\x89"],
        ["\xD1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\x8A"],
        ["\xD2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\x8B"],
        ["\xD3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\x8C"],
        ["\xD4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\x8D"],
        ["\xD5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\x8E"],
        ["\xD6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\x8F"],
        ["\xD7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\x90"],
        ["\xD8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\x91"],
        ["\xD9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\x92"],
        ["\xE2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\x93"],
        ["\xE3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\x94"],
        ["\xE4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\x95"],
        ["\xE5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\x96"],
        ["\xE6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\x97"],
        ["\xE7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\x98"],
        ["\xE8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\x99"],
        ["\xE9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\x9A"],
        ["\x70",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\x9B"],
        ["\x5B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\x9C"],
        ["\x80",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\x9D"],
        ["\xB0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\x9E"],
        ["\x6D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\x9F"],
        ["\x79",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\xA0"],
        ["\x62",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\xA1"],
        ["\x63",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\xA2"],
        ["\x64",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\xA3"],
        ["\x65",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\xA4"],
        ["\x66",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\xA5"],
        ["\x67",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\xA6"],
        ["\x68",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\xA7"],
        ["\x69",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\xA8"],
        ["\x71",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\xA9"],
        ["\x72",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\xAA"],
        ["\x73",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\xAB"],
        ["\x74",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\xAC"],
        ["\x75",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\xAD"],
        ["\x76",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\xAE"],
        ["\x77",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\xAF"],
        ["\x78",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\xB0"],
        ["\x8B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\xB1"],
        ["\x9B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\xB2"],
        ["\xAB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\xB3"],
        ["\xB3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\xB4"],
        ["\xB4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\xB5"],
        ["\xB5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\xB6"],
        ["\xB6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\xB7"],
        ["\xB7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\xB8"],
        ["\xB8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\xB9"],
        ["\xB9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\xBA"],
        ["\xC0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\xBB"],
        ["\x4F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\xBC"],
        ["\xD0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\xBD"],
        ["\xA0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\xBE"],
        ["\x07",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\xBF"],
        ["\x20",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\x80"],
        ["\x21",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\x81"],
        ["\x22",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\x82"],
        ["\x23",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\x83"],
        ["\x24",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\x84"],
        ["\x25",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\x85"],
        ["\x06",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\x86"],
        ["\x17",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\x87"],
        ["\x28",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\x88"],
        ["\x29",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\x89"],
        ["\x2A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\x8A"],
        ["\x2B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\x8B"],
        ["\x2C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\x8C"],
        ["\x09",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\x8D"],
        ["\x0A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\x8E"],
        ["\x1B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\x8F"],
        ["\x30",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\x90"],
        ["\x31",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\x91"],
        ["\x1A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\x92"],
        ["\x33",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\x93"],
        ["\x34",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\x94"],
        ["\x35",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\x95"],
        ["\x36",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\x96"],
        ["\x08",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\x97"],
        ["\x38",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\x98"],
        ["\x39",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\x99"],
        ["\x3A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\x9A"],
        ["\x3B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\x9B"],
        ["\x04",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\x9C"],
        ["\x14",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\x9D"],
        ["\x3E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\x9E"],
        ["\x4A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\x9F"],
        ["\x6A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\xA0"],
        ["\x41",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\xA1"],
        ["\x42",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\xA2"],
        ["\x43",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\xA3"],
        ["\x44",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\xA4"],
        ["\x45",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\xA5"],
        ["\x46",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\xA6"],
        ["\x47",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\xA7"],
        ["\x48",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\xA8"],
        ["\x49",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\xA9"],
        ["\x51",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\xAA"],
        ["\x52",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\xAB"],
        ["\x53",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\xAC"],
        ["\x54",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\xAD"],
        ["\x55",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\xAE"],
        ["\x56",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\xAF"],
        ["\x58",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\xB0"],
        ["\x81",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\xB1"],
        ["\x82",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\xB2"],
        ["\x83",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\xB3"],
        ["\x84",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\xB4"],
        ["\x85",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\xB5"],
        ["\x86",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\xB6"],
        ["\x87",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\xB7"],
        ["\x88",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\xB8"],
        ["\x89",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\xB9"],
        ["\x8A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\xBA"],
        ["\x8C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\xBB"],
        ["\x8D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\xBC"],
        ["\x8E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\xBD"],
        ["\x8F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\xBE"],
        ["\x90",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\xBF"],
        ["\x91",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\x80"],
        ["\x92",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\x81"],
        ["\x93",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\x82"],
        ["\x94",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\x83"],
        ["\x95",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\x84"],
        ["\x96",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\x85"],
        ["\x97",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\x86"],
        ["\x98",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\x87"],
        ["\x99",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\x88"],
        ["\x9A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\x89"],
        ["\x9D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\x8A"],
        ["\x9E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\x8B"],
        ["\x9F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\x8C"],
        ["\xA2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\x8D"],
        ["\xA3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\x8E"],
        ["\xA4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\x8F"],
        ["\xA5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\x90"],
        ["\xA6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\x91"],
        ["\xA7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\x92"],
        ["\xA8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\x93"],
        ["\xA9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\x94"],
        ["\xAA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\x95"],
        ["\xAC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\x96"],
        ["\xAD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\x97"],
        ["\xAE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\x98"],
        ["\xAF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\x99"],
        ["\xBA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\x9A"],
        ["\xBB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\x9B"],
        ["\xBC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\x9C"],
        ["\xBD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\x9D"],
        ["\xBE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\x9E"],
        ["\xBF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\x9F"],
        ["\x57",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\xA0"],
        ["\x59",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\xA1"],
        ["\x5F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\xA2"],
        ["\x9C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\xA3"],
        ["\xA1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\xA4"],
        ["\xB1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\xA5"],
        ["\xB2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\xA6"],
        ["\xE1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\xA7"],
        ["\xCA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\xA8"],
        ["\xCB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\xA9"],
        ["\xCC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\xAA"],
        ["\xCD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\xAB"],
        ["\xCE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\xAC"],
        ["\xCF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\xAD"],
        ["\xDA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\xAE"],
        ["\xDB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\xAF"],
        ["\xDC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\xB0"],
        ["\xDD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\xB1"],
        ["\xDE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\xB2"],
        ["\xDF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\xB3"],
        ["\xEA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\xB4"],
        ["\xEB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\xB5"],
        ["\xEC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\xB6"],
        ["\xED",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\xB7"],
        ["\xEE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\xB8"],
        ["\xEF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\xB9"],
        ["\xFA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\xBA"],
        ["\xFB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\xBB"],
        ["\xFC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\xBC"],
        ["\xFD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\xBD"],
        ["\xFE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\xBE"],
        ["\xFF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\xBF"],
        ["\x40\x40",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x80"],
        ["\x43\x44",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x81"],
        ["\x43\x41",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x82"],
        ["\x42\x6B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x83"],
        ["\x42\x4B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x84"],
        ["\x43\x45",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x85"],
        ["\x42\x7A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x86"],
        ["\x42\x5E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x87"],
        ["\x42\x6F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x88"],
        ["\x42\x5A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x89"],
        ["\x43\xBE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x8A"],
        ["\x43\xBF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x8B"],
        ["\x44\x50",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x8C"],
        ["\x42\x79",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x8D"],
        ["\x44\x60",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x8E"],
        ["\x44\x70",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x8F"],
        ["\x42\xA1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x90"],
        ["\x42\x6D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x91"],
        ["\x43\xDC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x92"],
        ["\x43\xDD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x93"],
        ["\x44\xDC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x94"],
        ["\x44\xDD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x95"],
        ["\x44\x5B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x96"],
        ["\x44\x5C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x97"],
        ["\x44\x5D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x98"],
        ["\x44\x5E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x99"],
        ["\x44\x5F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x9A"],
        ["\x43\x58",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x9B"],
        ["\xDD\xB7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x9C"],
        ["\x44\x5A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x9D"],
        ["\x42\x61",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x9E"],
        ["\x43\xE0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x9F"],
        ["\x43\xA1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xA0"],
        ["\xDF\xE5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xA1"],
        ["\x42\x4F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xA2"],
        ["\x44\x7F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xA3"],
        ["\x44\x7E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xA4"],
        ["\x44\x61",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xA5"],
        ["\x44\x71",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xA6"],
        ["\x44\x62",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xA7"],
        ["\x44\x72",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xA8"],
        ["\x42\x4D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xA9"],
        ["\x42\x5D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xAA"],
        ["\x44\x63",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xAB"],
        ["\x44\x73",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xAC"],
        ["\x44\x44",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xAD"],
        ["\x44\x45",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xAE"],
        ["\x42\xC0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xAF"],
        ["\x42\xD0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xB0"],
        ["\x44\x64",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xB1"],
        ["\x44\x74",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xB2"],
        ["\x44\x65",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xB3"],
        ["\x44\x75",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xB4"],
        ["\x43\x42",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xB5"],
        ["\x43\x43",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xB6"],
        ["\x44\x42",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xB7"],
        ["\x44\x43",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xB8"],
        ["\x44\x66",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xB9"],
        ["\x44\x76",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xBA"],
        ["\x42\x4E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xBB"],
        ["\xE9\xF3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xBC"],
        ["\x44\x4B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xBD"],
        ["\x44\x7A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xBE"],
        ["\x44\x7B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xBF"],
        ["\x42\x7E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x80"],
        ["\x44\x4C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x81"],
        ["\x42\x4C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x82"],
        ["\x42\x6E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x83"],
        ["\x44\x67",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x84"],
        ["\x44\x77",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x85"],
        ["\x44\x4D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x86"],
        ["\x44\x68",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x87"],
        ["\x44\x69",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x88"],
        ["\x44\x79",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x89"],
        ["\x44\xED",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x8A"],
        ["\x44\xEE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x8B"],
        ["\x44\xEF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x8C"],
        ["\x44\x4E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x8D"],
        ["\x42\x5B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x8E"],
        ["\x42\xE0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x8F"],
        ["\x43\x4A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x90"],
        ["\x42\x4A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x91"],
        ["\x42\x6C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x92"],
        ["\x42\x7B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x93"],
        ["\x42\x50",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x94"],
        ["\x42\x5C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x95"],
        ["\x42\x7C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x96"],
        ["\x44\x6A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x97"],
        ["\x44\xE5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x98"],
        ["\x44\xE6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x99"],
        ["\x44\xE0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x9A"],
        ["\x44\xE1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x9B"],
        ["\x44\xE4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x9C"],
        ["\x44\xE7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x9D"],
        ["\x44\xE8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x9E"],
        ["\x44\xE9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x9F"],
        ["\x44\xEA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\xA0"],
        ["\x44\xE2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\xA1"],
        ["\x44\xE3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\xA2"],
        ["\x44\xEB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\xA3"],
        ["\x44\xEC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\xA4"],
        ["\x44\x6B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\xA5"],
        ["\x44\x6C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\xA6"],
        ["\x44\xF0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\xA7"],
        ["\x44\xF1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\xA8"],
        ["\x44\xF2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\xA9"],
        ["\x44\xF3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\xAA"],
        ["\x44\x7D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\xAB"],
        ["\x43\x64",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\xB7"],
        ["\x43\x65",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\xB8"],
        ["\x43\x66",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\xB9"],
        ["\x43\x67",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\xBA"],
        ["\x43\x68",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\xBB"],
        ["\x43\x69",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\xBC"],
        ["\x43\x6A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\xBD"],
        ["\x43\x6B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\xBE"],
        ["\x43\x6C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\x87"],
        ["\x43\x6D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\x88"],
        ["\x42\x5F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\x89"],
        ["\x43\x6E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\x8A"],
        ["\x43\x6F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\x8B"],
        ["\x43\x70",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\x8C"],
        ["\x43\x71",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\x8D"],
        ["\x43\x4B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\x99"],
        ["\x43\x4C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\x9A"],
        ["\x43\x4D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\x9B"],
        ["\x43\x4E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\x9C"],
        ["\x43\x4F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\x9D"],
        ["\x43\x5B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\x9E"],
        ["\x43\x5C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\x9F"],
        ["\x43\x5D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\xA0"],
        ["\x43\x5E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\xA1"],
        ["\x43\x5F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\xA2"],
        ["\x43\x60",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\xA3"],
        ["\x43\x61",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\xA4"],
        ["\x44\x78",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\xA5"],
        ["\x43\x62",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\xA6"],
        ["\x43\x63",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\xA7"],
        ["\x43\x72",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\xAF"],
        ["\x43\x73",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\xB0"],
        ["\x43\x74",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\xB1"],
        ["\x43\x75",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\xB2"],
        ["\x43\x76",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\xB3"],
        ["\x43\x77",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\xB4"],
        ["\x43\x78",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\xB5"],
        ["\x43\x79",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\xB6"],
        ["\x43\x7A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\xBB"],
        ["\x42\xF0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\x8B"],
        ["\x42\xF1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\x8C"],
        ["\x42\xF2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\x8D"],
        ["\x42\xF3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\x8E"],
        ["\x42\xF4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\x8F"],
        ["\x42\xF5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\x90"],
        ["\x42\xF6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\x91"],
        ["\x42\xF7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\x92"],
        ["\x42\xF8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\x93"],
        ["\x42\xF9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\x94"],
        ["\x42\xC1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\x9C"],
        ["\x42\xC2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\x9D"],
        ["\x42\xC3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\x9E"],
        ["\x42\xC4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\x9F"],
        ["\x42\xC5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xA0"],
        ["\x42\xC6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xA1"],
        ["\x42\xC7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xA2"],
        ["\x42\xC8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xA3"],
        ["\x42\xC9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xA4"],
        ["\x42\xD1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xA5"],
        ["\x42\xD2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xA6"],
        ["\x42\xD3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xA7"],
        ["\x42\xD4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xA8"],
        ["\x42\xD5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xA9"],
        ["\x42\xD6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xAA"],
        ["\x42\xD7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xAB"],
        ["\x42\xD8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xAC"],
        ["\x42\xD9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xAD"],
        ["\x42\xE2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xAE"],
        ["\x42\xE3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xAF"],
        ["\x42\xE4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xB0"],
        ["\x42\xE5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xB1"],
        ["\x42\xE6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xB2"],
        ["\x42\xE7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xB3"],
        ["\x42\xE8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xB4"],
        ["\x42\xE9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xB5"],
        ["\x42\x81",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xBC"],
        ["\x42\x82",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xBD"],
        ["\x42\x83",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xBE"],
        ["\x42\x84",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xBF"],
        ["\x42\x85",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x80"],
        ["\x42\x86",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x81"],
        ["\x42\x87",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x82"],
        ["\x42\x88",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x83"],
        ["\x42\x89",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x84"],
        ["\x42\x91",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x85"],
        ["\x42\x92",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x86"],
        ["\x42\x93",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x87"],
        ["\x42\x94",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x88"],
        ["\x42\x95",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x89"],
        ["\x42\x96",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x8A"],
        ["\x42\x97",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x8B"],
        ["\x42\x98",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x8C"],
        ["\x42\x99",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x8D"],
        ["\x42\xA2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x8E"],
        ["\x42\xA3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x8F"],
        ["\x42\xA4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x90"],
        ["\x42\xA5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x91"],
        ["\x42\xA6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x92"],
        ["\x42\xA7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x93"],
        ["\x42\xA8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x94"],
        ["\x42\xA9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x95"],
        ["\x44\x47",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x9A"],
        ["\x44\x81",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x9B"],
        ["\x44\x48",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x9C"],
        ["\x44\x82",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x9D"],
        ["\x44\x49",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x9E"],
        ["\x44\x83",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x9F"],
        ["\x44\x51",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xA0"],
        ["\x44\x84",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xA1"],
        ["\x44\x52",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xA2"],
        ["\x44\x85",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xA3"],
        ["\x44\x86",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xA4"],
        ["\x44\xC0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xA5"],
        ["\x44\x87",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xA6"],
        ["\x44\xC1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xA7"],
        ["\x44\x88",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xA8"],
        ["\x44\xC2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xA9"],
        ["\x44\x89",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xAA"],
        ["\x44\xC3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xAB"],
        ["\x44\x8A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xAC"],
        ["\x44\xC4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xAD"],
        ["\x44\x8C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xAE"],
        ["\x44\xC5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xAF"],
        ["\x44\x8D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xB0"],
        ["\x44\xC6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xB1"],
        ["\x44\x8E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xB2"],
        ["\x44\xC7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xB3"],
        ["\x44\x8F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xB4"],
        ["\x44\xC8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xB5"],
        ["\x44\x90",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xB6"],
        ["\x44\xC9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xB7"],
        ["\x44\x91",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xB8"],
        ["\x44\xCA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xB9"],
        ["\x44\x92",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xBA"],
        ["\x44\xCB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xBB"],
        ["\x44\x56",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xBC"],
        ["\x44\x93",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xBD"],
        ["\x44\xCC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xBE"],
        ["\x44\x94",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xBF"],
        ["\x44\xCD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x80"],
        ["\x44\x95",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x81"],
        ["\x44\xCE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x82"],
        ["\x44\x96",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x83"],
        ["\x44\x97",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x84"],
        ["\x44\x98",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x85"],
        ["\x44\x99",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x86"],
        ["\x44\x9A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x87"],
        ["\x44\x9D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x88"],
        ["\x44\xCF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x89"],
        ["\x44\xD5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x8A"],
        ["\x44\x9E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x8B"],
        ["\x44\xD0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x8C"],
        ["\x44\xD6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x8D"],
        ["\x44\x9F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x8E"],
        ["\x44\xD1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x8F"],
        ["\x44\xD7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x90"],
        ["\x44\xA2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x91"],
        ["\x44\xD2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x92"],
        ["\x44\xD8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x93"],
        ["\x44\xA3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x94"],
        ["\x44\xD3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x95"],
        ["\x44\xD9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x96"],
        ["\x44\xA4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x97"],
        ["\x44\xA5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x98"],
        ["\x44\xA6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x99"],
        ["\x44\xA7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x9A"],
        ["\x44\xA8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x9B"],
        ["\x44\x53",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x9C"],
        ["\x44\xA9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x9D"],
        ["\x44\x54",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x9E"],
        ["\x44\xAA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x9F"],
        ["\x44\x55",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xA0"],
        ["\x44\xAC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xA1"],
        ["\x44\xAD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xA2"],
        ["\x44\xAE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xA3"],
        ["\x44\xAF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xA4"],
        ["\x44\xBA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xA5"],
        ["\x44\xBB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xA6"],
        ["\x44\x57",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xA7"],
        ["\x44\xBC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xA8"],
        ["\x44\xDA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xA9"],
        ["\x44\xDB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xAA"],
        ["\x44\x46",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xAB"],
        ["\x44\xBD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xAC"],
        ["\x43\x47",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xB8"],
        ["\x43\x81",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xB9"],
        ["\x43\x48",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xBA"],
        ["\x43\x82",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xBB"],
        ["\x43\x49",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xBC"],
        ["\x43\x83",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xBD"],
        ["\x43\x51",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xBE"],
        ["\x43\x84",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xBF"],
        ["\x43\x52",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x80"],
        ["\x43\x85",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x81"],
        ["\x43\x86",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x82"],
        ["\x43\xC0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x83"],
        ["\x43\x87",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x84"],
        ["\x43\xC1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x85"],
        ["\x43\x88",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x86"],
        ["\x43\xC2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x87"],
        ["\x43\x89",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x88"],
        ["\x43\xC3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x89"],
        ["\x43\x8A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x8A"],
        ["\x43\xC4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x8B"],
        ["\x43\x8C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x8C"],
        ["\x43\xC5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x8D"],
        ["\x43\x8D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x8E"],
        ["\x43\xC6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x8F"],
        ["\x43\x8E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x90"],
        ["\x43\xC7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x91"],
        ["\x43\x8F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x92"],
        ["\x43\xC8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x93"],
        ["\x43\x90",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x94"],
        ["\x43\xC9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x95"],
        ["\x43\x91",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x96"],
        ["\x43\xCA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x97"],
        ["\x43\x92",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x98"],
        ["\x43\xCB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x99"],
        ["\x43\x56",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x9A"],
        ["\x43\x93",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x9B"],
        ["\x43\xCC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x9C"],
        ["\x43\x94",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x9D"],
        ["\x43\xCD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x9E"],
        ["\x43\x95",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x9F"],
        ["\x43\xCE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xA0"],
        ["\x43\x96",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xA1"],
        ["\x43\x97",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xA2"],
        ["\x43\x98",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xA3"],
        ["\x43\x99",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xA4"],
        ["\x43\x9A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xA5"],
        ["\x43\x9D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xA6"],
        ["\x43\xCF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xA7"],
        ["\x43\xD5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xA8"],
        ["\x43\x9E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xA9"],
        ["\x43\xD0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xAA"],
        ["\x43\xD6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xAB"],
        ["\x43\x9F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xAC"],
        ["\x43\xD1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xAD"],
        ["\x43\xD7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xAE"],
        ["\x43\xA2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xAF"],
        ["\x43\xD2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xB0"],
        ["\x43\xD8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xB1"],
        ["\x43\xA3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xB2"],
        ["\x43\xD3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xB3"],
        ["\x43\xD9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xB4"],
        ["\x43\xA4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xB5"],
        ["\x43\xA5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xB6"],
        ["\x43\xA6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xB7"],
        ["\x43\xA7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xB8"],
        ["\x43\xA8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xB9"],
        ["\x43\x53",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xBA"],
        ["\x43\xA9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xBB"],
        ["\x43\x54",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xBC"],
        ["\x43\xAA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xBD"],
        ["\x43\x55",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xBE"],
        ["\x43\xAC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xBF"],
        ["\x43\xAD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x80"],
        ["\x43\xAE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x81"],
        ["\x43\xAF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x82"],
        ["\x43\xBA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x83"],
        ["\x43\xBB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x84"],
        ["\x43\x57",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x85"],
        ["\x43\xBC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x86"],
        ["\x43\xDA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x87"],
        ["\x43\xDB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x88"],
        ["\x43\x46",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x89"],
        ["\x43\xBD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x8A"],
        ["\x43\xD4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x8B"],
        ["\x43\x59",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x8C"],
        ["\x43\x5A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x8D"],
        ["\x41\x61",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x96"],
        ["\x41\x62",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x97"],
        ["\x41\x63",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x98"],
        ["\x41\x64",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x99"],
        ["\x41\x65",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x9A"],
        ["\x41\x66",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x9B"],
        ["\x41\x67",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x9C"],
        ["\x41\x68",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x9D"],
        ["\x41\x69",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x9E"],
        ["\x41\x6A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x9F"],
        ["\x41\x6B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xA0"],
        ["\x41\x6C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xA1"],
        ["\x41\x6D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xA2"],
        ["\x41\x6E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xA3"],
        ["\x41\x6F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xA4"],
        ["\x41\x70",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xA5"],
        ["\x41\x71",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xA6"],
        ["\x41\x72",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xA7"],
        ["\x41\x73",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xA8"],
        ["\x41\x74",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xA9"],
        ["\x41\x75",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xAA"],
        ["\x41\x76",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xAB"],
        ["\x41\x77",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xAC"],
        ["\x41\x78",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xAD"],
        ["\x41\x41",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xB6"],
        ["\x41\x42",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xB7"],
        ["\x41\x43",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xB8"],
        ["\x41\x44",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xB9"],
        ["\x41\x45",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xBA"],
        ["\x41\x46",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xBB"],
        ["\x41\x47",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xBC"],
        ["\x41\x48",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xBD"],
        ["\x41\x49",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xBE"],
        ["\x41\x4A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xBF"],
        ["\x41\x4B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\x80"],
        ["\x41\x4C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\x81"],
        ["\x41\x4D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\x82"],
        ["\x41\x4E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\x83"],
        ["\x41\x4F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\x84"],
        ["\x41\x50",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\x85"],
        ["\x41\x51",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\x86"],
        ["\x41\x52",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\x87"],
        ["\x41\x53",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\x88"],
        ["\x41\x54",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\x89"],
        ["\x41\x55",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\x8A"],
        ["\x41\x56",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\x8B"],
        ["\x41\x57",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\x8C"],
        ["\x41\x58",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\x8D"],
        ["\x41\xC0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\xB4"],
        ["\x41\xC1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\xB5"],
        ["\x41\xC2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\xB6"],
        ["\x41\xC3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\xB7"],
        ["\x41\xC4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\xB8"],
        ["\x41\xC5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\xB9"],
        ["\x41\xC6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\xBA"],
        ["\x41\xC7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\xBB"],
        ["\x41\xC8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\xBC"],
        ["\x41\xC9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\xBD"],
        ["\x41\xCA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\xBE"],
        ["\x41\xCB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\xBF"],
        ["\x41\xCC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x80"],
        ["\x41\xCD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x81"],
        ["\x41\xCE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x82"],
        ["\x41\xCF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x83"],
        ["\x41\xD0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x84"],
        ["\x41\xD1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x85"],
        ["\x41\xD2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x86"],
        ["\x41\xD3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x87"],
        ["\x41\xD4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x88"],
        ["\x41\xD5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x89"],
        ["\x41\xD6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x8A"],
        ["\x41\xD7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x8B"],
        ["\x41\xD8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x8C"],
        ["\x41\xD9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x8D"],
        ["\x41\xDA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x8E"],
        ["\x41\xDB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x8F"],
        ["\x41\xDC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x90"],
        ["\x41\xDD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x91"],
        ["\x41\xDE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x92"],
        ["\x41\xDF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x93"],
        ["\x41\xE0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x94"],
        ["\x41\x80",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xA4"],
        ["\x41\x81",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xA5"],
        ["\x41\x82",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xA6"],
        ["\x41\x83",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xA7"],
        ["\x41\x84",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xA8"],
        ["\x41\x85",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xA9"],
        ["\x41\x86",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xAA"],
        ["\x41\x87",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xAB"],
        ["\x41\x88",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xAC"],
        ["\x41\x89",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xAD"],
        ["\x41\x8A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xAE"],
        ["\x41\x8B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xAF"],
        ["\x41\x8C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xB0"],
        ["\x41\x8D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xB1"],
        ["\x41\x8E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xB2"],
        ["\x41\x8F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xB3"],
        ["\x41\x90",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xB4"],
        ["\x41\x91",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xB5"],
        ["\x41\x92",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xB6"],
        ["\x41\x93",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xB7"],
        ["\x41\x94",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xB8"],
        ["\x41\x95",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xB9"],
        ["\x41\x96",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xBA"],
        ["\x41\x97",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xBB"],
        ["\x41\x98",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xBC"],
        ["\x41\x99",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xBD"],
        ["\x41\x9A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xBE"],
        ["\x41\x9B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xBF"],
        ["\x41\x9C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\x80"],
        ["\x41\x9D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\x81"],
        ["\x41\x9E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\x82"],
        ["\x41\x9F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\x83"],
        ["\x41\xA0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\x84"],
        ["\x43\x7C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\x92"],
        ["\x43\x7D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\x93"],
        ["\x43\x7E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\x94"],
        ["\x43\x7F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\x95"],
        ["\x43\xB0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\x96"],
        ["\x43\xB1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\x97"],
        ["\x43\xB2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\x98"],
        ["\x43\xB3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\x99"],
        ["\x43\xB4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\x9A"],
        ["\x43\xB5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\x9B"],
        ["\x43\xB6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\x9C"],
        ["\x43\xB7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\x9D"],
        ["\x43\xB8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\x9E"],
        ["\x43\xB9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\x9F"],
        ["\x43\xE1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\xA0"],
        ["\x43\xE2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\xA1"],
        ["\x43\xE3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\xA2"],
        ["\x43\xE4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\xA3"],
        ["\x43\xE5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\xA4"],
        ["\x43\xE6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\xA5"],
        ["\x43\xE7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\xA6"],
        ["\x43\xE8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\xA7"],
        ["\x43\xE9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\xA8"],
        ["\x43\xEA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\xA9"],
        ["\x43\xEB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\xAA"],
        ["\x43\xEC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\xAB"],
        ["\x43\xED",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\xAC"],
        ["\x43\xEE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\xAD"],
        ["\x43\xEF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\xAE"],
        ["\x43\xF0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\xAF"],
        ["\x43\xF1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\xB0"],
        ["\x43\xF2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\xB1"],
        ["\xE2\x70",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xA8"],
        ["\xE2\x71",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xA9"],
        ["\xE2\x72",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xAA"],
        ["\xE2\x73",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xAB"],
        ["\xE2\x74",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xAC"],
        ["\xE2\x75",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xAD"],
        ["\xE2\x76",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xAE"],
        ["\xE2\x77",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xAF"],
        ["\xE2\x78",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xB0"],
        ["\xE2\x79",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xB1"],
        ["\xE2\x7A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xB2"],
        ["\xE2\x7B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xB3"],
        ["\xE2\x7C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xB4"],
        ["\xE2\x7D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xB5"],
        ["\xE2\x7E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xB6"],
        ["\xE2\x7F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xB7"],
        ["\xE2\x80",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xB8"],
        ["\xE2\x81",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xB9"],
        ["\xE2\x82",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xBA"],
        ["\xE2\x83",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xBB"],
        ["\x41\xF1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xBC"],
        ["\x41\xF2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xBD"],
        ["\x41\xF3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xBE"],
        ["\x41\xF4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xBF"],
        ["\x41\xF5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x80"],
        ["\x41\xF6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x81"],
        ["\x41\xF7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x82"],
        ["\x41\xF8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x83"],
        ["\x41\xF9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x84"],
        ["\x41\xFA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x85"],
        ["\xE8\xAA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x87"],
        ["\xE8\x75",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x88"],
        ["\xE8\x83",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x89"],
        ["\xE8\xAE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x8A"],
        ["\xE8\x79",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x8B"],
        ["\xE8\x88",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x8C"],
        ["\xE8\x64",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x8D"],
        ["\xE8\x97",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x8E"],
        ["\xE8\xB2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x8F"],
        ["\xE8\xB8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x90"],
        ["\xE8\x6E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x91"],
        ["\xE8\x87",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x92"],
        ["\xE8\x84",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x93"],
        ["\xE8\x8C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x94"],
        ["\xE8\xAB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x95"],
        ["\xE8\x9C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x96"],
        ["\xE8\xF9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x97"],
        ["\xE8\xFA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x98"],
        ["\xE8\xFB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x99"],
        ["\xE8\xEB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x9A"],
        ["\xE8\xEC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x9B"],
        ["\xE9\x63",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x9C"],
        ["\xE8\xFE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x9D"],
        ["\xE8\xD8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\xA6"],
        ["\xE6\xAC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\xA7"],
        ["\xE6\xAE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\xA8"],
        ["\x44\x6E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\xA9"],
        ["\xE9\x6C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\xAA"],
        ["\x44\x6F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\xAB"],
        ["\xE7\x67",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\xAC"],
        ["\xE7\x68",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\xAD"],
        ["\xE7\x69",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\xAE"],
        ["\xE7\x6A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\xAF"],
        ["\xE7\x6B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\xB0"],
        ["\x44\x6D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\xB1"],
        ["\xE6\xEF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\xB2"],
        ["\xE6\xF6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\xB3"],
        ["\xE8\xDB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\xB4"],
        ["\xE8\xDA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\xB5"],
        ["\xE8\xD9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\xB6"],
        ["\xDF\xE8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\xBA"],
        ["\xDF\xD6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\xBB"],
        ["\xDF\xE0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\xBF"],
        ["\xE0\xAC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x97\x80"],
        ["\x48\x67",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x82"],
        ["\x54\xD4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x83"],
        ["\x55\x7A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x84"],
        ["\x46\xAE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x85"],
        ["\x4E\xF9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x86"],
        ["\x45\xC6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x87"],
        ["\x4F\x81",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x88"],
        ["\x51\x79",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x89"],
        ["\x4D\xCE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x8A"],
        ["\x50\xD9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x8B"],
        ["\x50\xE2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x8C"],
        ["\x50\x9B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x8D"],
        ["\x49\x65",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x8E"],
        ["\x4D\x60",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x8F"],
        ["\x4E\x43",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x90"],
        ["\x47\xEC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x91"],
        ["\x4E\x72",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x92"],
        ["\x4A\xDD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x93"],
        ["\x67\xAA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x94"],
        ["\x50\xDA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x95"],
        ["\x47\x82",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x96"],
        ["\x55\x81",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x97"],
        ["\x4C\x69",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x98"],
        ["\x50\xAB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x99"],
        ["\x54\x9C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x9A"],
        ["\x51\x44",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x9B"],
        ["\x52\x45",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x9C"],
        ["\x4E\xF7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x9D"],
        ["\x49\xDC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x9E"],
        ["\x4F\x8E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x9F"],
        ["\x4D\x7F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xA0"],
        ["\x4B\xFB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xA1"],
        ["\x54\x48",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xA2"],
        ["\x45\xA8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xA3"],
        ["\x4E\xEB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xA4"],
        ["\x54\x89",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xA5"],
        ["\x4B\xE2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xA6"],
        ["\x48\xF1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xA7"],
        ["\x53\x64",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xA8"],
        ["\x50\x4C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xA9"],
        ["\x50\xD0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xAA"],
        ["\x46\xF6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xAB"],
        ["\x45\xB2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xAC"],
        ["\x47\xC8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xAD"],
        ["\x4A\x9E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xAE"],
        ["\x4D\xFB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xAF"],
        ["\x4A\xFA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xB0"],
        ["\x51\x47",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xB1"],
        ["\x48\x4F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xB2"],
        ["\x4C\x65",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xB3"],
        ["\x51\x89",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xB4"],
        ["\x4F\xE0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xB5"],
        ["\x47\x63",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xB6"],
        ["\x4F\xAD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xB7"],
        ["\x47\xE9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xB8"],
        ["\x4F\xF7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xB9"],
        ["\x49\xD7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xBA"],
        ["\x55\x8F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xBB"],
        ["\x4A\xA9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xBC"],
        ["\x49\x75",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xBD"],
        ["\x48\x80",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xBE"],
        ["\x4E\x9A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xBF"],
        ["\x4D\xF6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x80"],
        ["\x54\x82",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x81"],
        ["\x4A\xEA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x82"],
        ["\x55\x73",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x83"],
        ["\x49\xBC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x84"],
        ["\x4C\xDA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x85"],
        ["\x4A\x87",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x86"],
        ["\x45\x6D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x87"],
        ["\x4F\x7F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x88"],
        ["\x48\xE9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x89"],
        ["\x48\xAC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x8A"],
        ["\x49\xB3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x8B"],
        ["\x48\xAA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x8C"],
        ["\x45\x41",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x8D"],
        ["\x4E\xB0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x8E"],
        ["\x52\x71",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x8F"],
        ["\x4A\xD6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x90"],
        ["\x47\x6A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x91"],
        ["\x47\x4C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x92"],
        ["\x51\x9A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x93"],
        ["\x55\xC8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x94"],
        ["\x4C\x91",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x95"],
        ["\x47\x99",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x96"],
        ["\x52\xB1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x97"],
        ["\x46\xCB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x98"],
        ["\x4A\x49",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x99"],
        ["\x52\xB9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x9A"],
        ["\x46\xDA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x9B"],
        ["\x4B\xA3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x9C"],
        ["\x55\x4E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x9D"],
        ["\x4E\xE9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x9E"],
        ["\x4E\x8B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x9F"],
        ["\x49\xD8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xA0"],
        ["\x4C\xD2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xA1"],
        ["\x4E\xAE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xA2"],
        ["\x55\x77",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xA3"],
        ["\x55\xBC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xA4"],
        ["\x48\x5A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xA5"],
        ["\x46\xD5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xA6"],
        ["\x50\x99",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xA7"],
        ["\x47\x8F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xA8"],
        ["\x55\xDF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xA9"],
        ["\x49\xDD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xAA"],
        ["\x4C\x82",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xAB"],
        ["\x4B\xE7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xAC"],
        ["\x55\x9E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xAD"],
        ["\x4D\xEC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xAE"],
        ["\x4F\xB1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xAF"],
        ["\x4A\x89",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xB0"],
        ["\x51\xA0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xB1"],
        ["\x50\xF3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xB2"],
        ["\x4C\xDB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xB3"],
        ["\x55\xF7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xB4"],
        ["\x54\x9A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xB5"],
        ["\x54\xAB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xB6"],
        ["\x52\x55",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xB7"],
        ["\x53\x67",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xB8"],
        ["\x46\x6B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xB9"],
        ["\x4E\x64",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xBA"],
        ["\x54\x5F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xBB"],
        ["\x52\x9B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xBC"],
        ["\x49\x9D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xBD"],
        ["\x46\xAB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xBE"],
        ["\x4A\xBC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xBF"],
        ["\x51\x5F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x80"],
        ["\x50\xA7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x81"],
        ["\x51\x94",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x82"],
        ["\x48\xD3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x83"],
        ["\x55\xE8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x84"],
        ["\x49\x5E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x85"],
        ["\x47\xAC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x86"],
        ["\x4E\xBC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x87"],
        ["\x45\xFA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x88"],
        ["\x45\xFB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x89"],
        ["\x4F\x57",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x8A"],
        ["\x50\xB7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x8B"],
        ["\x4F\x52",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x8C"],
        ["\x51\xB5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x8D"],
        ["\x52\x54",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x8E"],
        ["\x55\x76",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x8F"],
        ["\x45\xEE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x90"],
        ["\x47\x80",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x91"],
        ["\x51\xC1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x92"],
        ["\x4D\x6F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x93"],
        ["\x4A\x45",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x94"],
        ["\x50\xCE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x95"],
        ["\x47\x74",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x96"],
        ["\x49\xAC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x97"],
        ["\x48\x73",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x98"],
        ["\x54\xE5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x99"],
        ["\x46\xDF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x9A"],
        ["\x51\x77",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x9B"],
        ["\x49\xEB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x9C"],
        ["\x53\xB7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x9D"],
        ["\x46\x45",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x9E"],
        ["\x47\xE1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x9F"],
        ["\x50\xA4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xA0"],
        ["\x52\xF2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xA1"],
        ["\x50\x78",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xA2"],
        ["\x47\xD0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xA3"],
        ["\x54\xDE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xA4"],
        ["\x55\xD0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xA5"],
        ["\x4A\xD5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xA6"],
        ["\x4E\x6F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xA7"],
        ["\x49\xED",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xA8"],
        ["\x4D\xAD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xA9"],
        ["\x53\xEE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xAA"],
        ["\x4B\xDD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xAB"],
        ["\x50\x47",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xAC"],
        ["\x4C\x5A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xAD"],
        ["\x4B\xAA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xAE"],
        ["\x4D\x54",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xAF"],
        ["\x50\x4B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xB0"],
        ["\x4C\xEC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xB1"],
        ["\x46\xE3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xB2"],
        ["\x49\xD4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xB3"],
        ["\x52\xC3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xB4"],
        ["\x47\x43",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xB5"],
        ["\x4D\xA4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xB6"],
        ["\x4E\x82",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xB7"],
        ["\x55\xD7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xB8"],
        ["\x50\xE6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xB9"],
        ["\x47\x92",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xBA"],
        ["\x46\xE5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xBB"],
        ["\x4C\xEA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xBC"],
        ["\x48\x95",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xBD"],
        ["\x49\xE1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xBE"],
        ["\x4F\xA3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xBF"],
        ["\x45\xF2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x80"],
        ["\x4A\xA0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x81"],
        ["\x54\x59",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x82"],
        ["\x49\xB1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x83"],
        ["\x4F\xFB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x84"],
        ["\x54\x6C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x85"],
        ["\x67\xD0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x86"],
        ["\x54\x64",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x87"],
        ["\x4A\xC6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x88"],
        ["\x45\x72",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x89"],
        ["\x47\xFD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x8A"],
        ["\x49\xE0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x8B"],
        ["\x45\x4E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x8C"],
        ["\x45\xE9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x8D"],
        ["\x4E\x6C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x8E"],
        ["\x54\x74",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x8F"],
        ["\x4E\x77",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x90"],
        ["\x50\x9A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x91"],
        ["\x4B\xBD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x92"],
        ["\x4E\x67",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x93"],
        ["\x4E\x79",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x94"],
        ["\x4C\x81",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x95"],
        ["\x49\x50",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x96"],
        ["\x50\xB8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x97"],
        ["\x48\x4D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x98"],
        ["\x45\x5F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x99"],
        ["\x45\x90",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x9A"],
        ["\x4D\x71",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x9B"],
        ["\x47\x70",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x9C"],
        ["\x54\x61",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x9D"],
        ["\x47\x5A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x9E"],
        ["\x48\x76",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x9F"],
        ["\x45\x9F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xA0"],
        ["\x47\xC6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xA1"],
        ["\x47\x7E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xA2"],
        ["\x49\x7E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xA3"],
        ["\x4E\x89",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xA4"],
        ["\x46\x86",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xA5"],
        ["\x52\xB8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xA6"],
        ["\x48\xED",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xA7"],
        ["\x4F\x46",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xA8"],
        ["\x47\xB9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xA9"],
        ["\x4E\xE8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xAA"],
        ["\x46\xF7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xAB"],
        ["\x46\x5A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xAC"],
        ["\x47\x85",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xAD"],
        ["\x4C\x9A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xAE"],
        ["\x52\x86",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xAF"],
        ["\x54\x63",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xB0"],
        ["\x4D\xBE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xB1"],
        ["\x4F\x51",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xB2"],
        ["\x46\xD9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xB3"],
        ["\x53\x77",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xB4"],
        ["\x54\x7A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xB5"],
        ["\x4B\xA1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xB6"],
        ["\x4B\x6C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xB7"],
        ["\x4C\x51",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xB8"],
        ["\x51\xC3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xB9"],
        ["\x49\xD6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xBA"],
        ["\x52\xCA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xBB"],
        ["\x4A\xEB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xBC"],
        ["\x53\x5D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xBD"],
        ["\x48\x8D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xBE"],
        ["\x4E\xE4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xBF"],
        ["\x4F\xAA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x80"],
        ["\x54\xC7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x81"],
        ["\x4F\x9D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x82"],
        ["\x49\xDE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x83"],
        ["\x53\xFC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x84"],
        ["\x46\x77",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x85"],
        ["\x53\x8A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x86"],
        ["\x4E\xBA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x87"],
        ["\x55\x99",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x88"],
        ["\x46\x41",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x89"],
        ["\x47\x45",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x8A"],
        ["\x55\x4B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x8B"],
        ["\x53\xBE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x8C"],
        ["\x48\x4B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x8D"],
        ["\x45\xBD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x8E"],
        ["\x47\xB7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x8F"],
        ["\x46\xA9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x90"],
        ["\x50\x53",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x91"],
        ["\x4E\xC8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x92"],
        ["\x4B\xAF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x93"],
        ["\x4C\x60",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x94"],
        ["\x4E\x71",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x95"],
        ["\x50\x91",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x96"],
        ["\x55\x94",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x97"],
        ["\x4E\xF2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x98"],
        ["\x4D\xA0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x99"],
        ["\x53\xA2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x9A"],
        ["\x48\x8F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x9B"],
        ["\x52\xCB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x9C"],
        ["\x55\x6D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x9D"],
        ["\x46\x82",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x9E"],
        ["\x45\xA7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x9F"],
        ["\x4A\xF5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xA0"],
        ["\x47\xAE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xA1"],
        ["\x4A\xB0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xA2"],
        ["\x4A\xE4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xA3"],
        ["\x4F\x7B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xA4"],
        ["\x50\x90",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xA5"],
        ["\x46\xCD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xA6"],
        ["\x49\xA9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xA7"],
        ["\x49\xEA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xA8"],
        ["\x51\xAC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xA9"],
        ["\x55\x6A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xAA"],
        ["\x46\x94",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xAB"],
        ["\x53\xE9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xAC"],
        ["\x49\x68",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xAD"],
        ["\x50\x74",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xAE"],
        ["\x52\x8A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xAF"],
        ["\x4C\x42",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xB0"],
        ["\x4F\x91",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xB1"],
        ["\x53\x56",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xB2"],
        ["\x4F\x6D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xB3"],
        ["\x4B\xA5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xB4"],
        ["\x4D\x8D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xB5"],
        ["\x54\x6D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xB6"],
        ["\x55\x9C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xB7"],
        ["\x55\xCC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xB8"],
        ["\x4B\x85",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xB9"],
        ["\x55\xBB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xBA"],
        ["\x47\xCE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xBB"],
        ["\x4A\xC1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xBC"],
        ["\x62\xE1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xBD"],
        ["\x53\x8F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xBE"],
        ["\x55\xD6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xBF"],
        ["\x55\xD8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x80"],
        ["\x47\xBA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x81"],
        ["\x54\xAD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x82"],
        ["\x48\xE5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x83"],
        ["\x5B\x52",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x84"],
        ["\x47\xDE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x85"],
        ["\x4B\x9E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x86"],
        ["\x50\xC0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x87"],
        ["\x4D\x61",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x88"],
        ["\x48\x7A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x89"],
        ["\x4F\x5C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x8A"],
        ["\x4A\x4C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x8B"],
        ["\x47\x7D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x8C"],
        ["\x53\xCC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x8D"],
        ["\x4A\x5A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x8E"],
        ["\x51\x62",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x8F"],
        ["\x4A\xE9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x90"],
        ["\x50\x5A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x91"],
        ["\x4A\xA3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x92"],
        ["\x45\xBE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x93"],
        ["\x4D\x46",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x94"],
        ["\x47\x61",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x95"],
        ["\x47\xF1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x96"],
        ["\x54\x8E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x97"],
        ["\x4A\xE3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x98"],
        ["\x47\xE0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x99"],
        ["\x4B\x6F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x9A"],
        ["\x4F\xB2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x9B"],
        ["\x49\xAD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x9C"],
        ["\x55\x71",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x9D"],
        ["\x46\xC2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x9E"],
        ["\x47\xD6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x9F"],
        ["\x54\x75",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xA0"],
        ["\x53\x84",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xA1"],
        ["\x4F\xC5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xA2"],
        ["\x47\xB4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xA3"],
        ["\x54\x41",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xA4"],
        ["\x4B\xA2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xA5"],
        ["\x48\xDF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xA6"],
        ["\x54\x5E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xA7"],
        ["\x50\xFE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xA8"],
        ["\x4F\x97",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xA9"],
        ["\x53\xD5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xAA"],
        ["\x4F\x59",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xAB"],
        ["\x51\x63",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xAC"],
        ["\x4E\x69",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xAD"],
        ["\x54\x45",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xAE"],
        ["\x48\x56",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xAF"],
        ["\x51\xBE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xB0"],
        ["\x60\x46",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xB1"],
        ["\x49\xB2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xB2"],
        ["\x4A\xCC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xB3"],
        ["\x49\x62",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xB4"],
        ["\x54\x7D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xB5"],
        ["\x4C\x54",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xB6"],
        ["\x52\x42",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xB7"],
        ["\x4B\xD3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xB8"],
        ["\x4F\x7C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xB9"],
        ["\x52\xAB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xBA"],
        ["\x4B\x9B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xBB"],
        ["\x4E\x5D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xBC"],
        ["\x49\xC2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xBD"],
        ["\x49\x70",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xBE"],
        ["\x4F\x98",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xBF"],
        ["\x4E\x7B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x80"],
        ["\x4B\x81",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x81"],
        ["\x4C\xD7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x82"],
        ["\x4B\x9A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x83"],
        ["\x4C\x7E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x84"],
        ["\x48\x93",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x85"],
        ["\x52\xB5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x86"],
        ["\x4F\xAC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x87"],
        ["\x55\xDE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x88"],
        ["\x48\xC5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x89"],
        ["\x49\xA2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x8A"],
        ["\x47\xF8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x8B"],
        ["\x4A\x6F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x8C"],
        ["\x48\xDA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x8D"],
        ["\x4D\xEB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x8E"],
        ["\x47\xF7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x8F"],
        ["\x4D\xD3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x90"],
        ["\x51\xA5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x91"],
        ["\x49\xAA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x92"],
        ["\x4F\xCF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x93"],
        ["\x4E\xC1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x94"],
        ["\x53\x6D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x95"],
        ["\x55\xB6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x96"],
        ["\x4E\xFB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x97"],
        ["\x4D\x4E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x98"],
        ["\x4E\xC4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x99"],
        ["\x4F\x58",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x9A"],
        ["\x54\xBA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x9B"],
        ["\x5D\xAA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x9C"],
        ["\x4A\xB9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x9D"],
        ["\x4B\x55",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x9E"],
        ["\x49\xE3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x9F"],
        ["\x4D\xA2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xA0"],
        ["\x52\x87",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xA1"],
        ["\x46\xF2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xA2"],
        ["\x4B\xEC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xA3"],
        ["\x4C\xFC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xA4"],
        ["\x50\x84",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xA5"],
        ["\x54\xB6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xA6"],
        ["\x4C\x8C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xA7"],
        ["\x4C\x4A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xA8"],
        ["\x51\xEE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xA9"],
        ["\x48\x7E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xAA"],
        ["\x63\xE0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xAB"],
        ["\x49\xA1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xAC"],
        ["\x4D\xA9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xAD"],
        ["\x4E\x4E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xAE"],
        ["\x45\xC1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xAF"],
        ["\x4D\xD9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xB0"],
        ["\x45\xC5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xB1"],
        ["\x4F\xFE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xB2"],
        ["\x4E\x75",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xB3"],
        ["\x48\x62",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xB4"],
        ["\x4C\xAA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xB5"],
        ["\x46\x7A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xB6"],
        ["\x49\xCB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xB7"],
        ["\x47\x48",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xB8"],
        ["\x49\xCF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xB9"],
        ["\x4E\x4C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xBA"],
        ["\x54\x47",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xBB"],
        ["\x49\xA5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xBC"],
        ["\x45\xBF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xBD"],
        ["\x55\x8B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xBE"],
        ["\x55\x84",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xBF"],
        ["\x51\xA4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x80"],
        ["\x53\x9D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x81"],
        ["\x48\xB8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x82"],
        ["\x4C\x57",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x83"],
        ["\x47\xD2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x84"],
        ["\x4E\x9F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x85"],
        ["\x4B\x91",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x86"],
        ["\x45\xD1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x87"],
        ["\x45\xFC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x88"],
        ["\x46\xF1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x89"],
        ["\x4D\x69",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x8A"],
        ["\x4F\x8B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x8B"],
        ["\x49\xDF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x8C"],
        ["\x47\x4A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x8D"],
        ["\x4A\xB5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x8E"],
        ["\x4B\x57",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x8F"],
        ["\x50\x97",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x90"],
        ["\x4B\xF2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x91"],
        ["\x4D\x96",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x92"],
        ["\x4D\xAB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x93"],
        ["\x4B\x77",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x94"],
        ["\x46\x8B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x95"],
        ["\x4E\xF1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x96"],
        ["\x4E\xB1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x97"],
        ["\x45\x79",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x98"],
        ["\x49\x82",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x99"],
        ["\x4A\x5B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x9A"],
        ["\x45\xB9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x9B"],
        ["\x49\x4C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x9C"],
        ["\x50\xD4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x9D"],
        ["\x4E\xD8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x9E"],
        ["\x4A\xEC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x9F"],
        ["\x52\x64",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xA0"],
        ["\x46\xDB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xA1"],
        ["\x55\xE0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xA2"],
        ["\x46\xFB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xA3"],
        ["\x47\x94",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xA4"],
        ["\x48\x7F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xA5"],
        ["\x48\xD0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xA6"],
        ["\x4D\xAA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xA7"],
        ["\x47\x87",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xA8"],
        ["\x53\xCE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xA9"],
        ["\x50\x58",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xAA"],
        ["\x4A\xC8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xAB"],
        ["\x47\xC0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xAC"],
        ["\x50\x59",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xAD"],
        ["\x49\xCA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xAE"],
        ["\x53\x95",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xAF"],
        ["\x4D\x8B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xB0"],
        ["\x4F\x92",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xB1"],
        ["\x48\xF7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xB2"],
        ["\x4F\xCD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xB3"],
        ["\x51\x7D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xB4"],
        ["\x4F\xDC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xB5"],
        ["\x4C\xB4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xB6"],
        ["\x51\x92",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xB7"],
        ["\x45\x98",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xB8"],
        ["\x51\xC6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xB9"],
        ["\x52\x65",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xBA"],
        ["\x47\x81",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xBB"],
        ["\x55\x41",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xBC"],
        ["\x46\xD7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xBD"],
        ["\x51\xED",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xBE"],
        ["\x45\x7E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xBF"],
        ["\x55\xEA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x80"],
        ["\x4D\x6D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x81"],
        ["\x53\x4B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x82"],
        ["\x4B\xC2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x83"],
        ["\x4B\x5F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x84"],
        ["\x52\x48",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x85"],
        ["\x4A\xA6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x86"],
        ["\x55\xAE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x87"],
        ["\x4A\xA4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x88"],
        ["\x4A\xDE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x89"],
        ["\x4D\x5C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x8A"],
        ["\x52\x60",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x8B"],
        ["\x4B\xFC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x8C"],
        ["\x4D\x56",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x8D"],
        ["\x45\x8A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x8E"],
        ["\x50\x85",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x8F"],
        ["\x4A\x81",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x90"],
        ["\x48\x5C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x91"],
        ["\x4B\x98",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x92"],
        ["\x45\x92",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x93"],
        ["\x4B\x63",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x94"],
        ["\x47\xCC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x95"],
        ["\x4C\x5C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x96"],
        ["\x50\xF0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x97"],
        ["\x49\xA0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x98"],
        ["\x50\xC8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x99"],
        ["\x4D\x4B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x9A"],
        ["\x54\x73",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x9B"],
        ["\x48\xDB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x9C"],
        ["\x49\x86",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x9D"],
        ["\x50\xAA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x9E"],
        ["\x51\xCF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x9F"],
        ["\x49\xF3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xA0"],
        ["\x51\xFE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xA1"],
        ["\x47\x57",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xA2"],
        ["\x4C\x7B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xA3"],
        ["\x49\x73",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xA4"],
        ["\x4A\xCA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xA5"],
        ["\x48\x5E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xA6"],
        ["\x4A\x52",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xA7"],
        ["\x4F\x61",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xA8"],
        ["\x4D\x77",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xA9"],
        ["\x4B\x82",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xAA"],
        ["\x52\x7A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xAB"],
        ["\x4F\x72",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xAC"],
        ["\x4A\x9A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xAD"],
        ["\x4D\xC2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xAE"],
        ["\x51\xE7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xAF"],
        ["\x4B\x78",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xB0"],
        ["\x55\xAA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xB1"],
        ["\x48\xEE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xB2"],
        ["\x4B\xAC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xB3"],
        ["\x4B\x73",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xB4"],
        ["\x45\x75",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xB5"],
        ["\x48\xBC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xB6"],
        ["\x52\xEC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xB7"],
        ["\x55\xAD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xB8"],
        ["\x55\x5A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xB9"],
        ["\x49\x71",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xBA"],
        ["\x47\xB3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xBB"],
        ["\x51\xEC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xBC"],
        ["\x47\xD7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xBD"],
        ["\x4D\x4D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xBE"],
        ["\x53\xE2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xBF"],
        ["\x4D\xD5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x80"],
        ["\x4C\x5F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x81"],
        ["\x4A\x95",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x82"],
        ["\x51\xB3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x83"],
        ["\x46\xD2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x84"],
        ["\x53\x85",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x85"],
        ["\x55\x42",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x86"],
        ["\x4B\xD5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x87"],
        ["\x49\x4E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x88"],
        ["\x55\xB1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x89"],
        ["\x47\xA5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x8A"],
        ["\x45\x89",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x8B"],
        ["\x4A\x58",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x8C"],
        ["\x4E\x5A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x8D"],
        ["\x4C\x9E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x8E"],
        ["\x51\xBB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x8F"],
        ["\x4B\xE3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x90"],
        ["\x50\x51",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x91"],
        ["\x46\x6A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x92"],
        ["\x55\x65",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x93"],
        ["\x49\x95",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x94"],
        ["\x4A\x8D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x95"],
        ["\x4A\x5C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x96"],
        ["\x51\xD5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x97"],
        ["\x4C\xD5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x98"],
        ["\x4D\xED",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x99"],
        ["\x4E\xD9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x9A"],
        ["\x68\x80",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x9B"],
        ["\x4C\x83",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x9C"],
        ["\x45\x6B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x9D"],
        ["\x48\x8B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x9E"],
        ["\x49\xB6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x9F"],
        ["\x49\xB7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xA0"],
        ["\x45\xFD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xA1"],
        ["\x49\xC0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xA2"],
        ["\x55\xE7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xA3"],
        ["\x4F\xC9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xA4"],
        ["\x49\x9F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xA5"],
        ["\x49\xAE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xA6"],
        ["\x4A\x7D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xA7"],
        ["\x4B\x8E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xA8"],
        ["\x54\xCF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xA9"],
        ["\x4B\x9D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xAA"],
        ["\x4C\xF8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xAB"],
        ["\x4C\xD8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xAC"],
        ["\x4D\x75",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xAD"],
        ["\x55\x5D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xAE"],
        ["\x4B\x8F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xAF"],
        ["\x4B\x97",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xB0"],
        ["\x4D\xD0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xB1"],
        ["\x4C\x73",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xB2"],
        ["\x4A\xA7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xB3"],
        ["\x54\xAF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xB4"],
        ["\x4D\x87",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xB5"],
        ["\x46\x73",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xB6"],
        ["\x45\x86",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xB7"],
        ["\x50\x7A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xB8"],
        ["\x47\x8C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xB9"],
        ["\x45\x49",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xBA"],
        ["\x4F\x63",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xBB"],
        ["\x4C\x8B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xBC"],
        ["\x45\x54",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xBD"],
        ["\x52\x74",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xBE"],
        ["\x4D\xE9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xBF"],
        ["\x4E\x4D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x80"],
        ["\x4A\x5F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x81"],
        ["\x53\x53",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x82"],
        ["\x4C\xFE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x83"],
        ["\x4F\x85",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x84"],
        ["\x49\xFC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x85"],
        ["\x47\xAF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x86"],
        ["\x52\xB2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x87"],
        ["\x55\x88",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x88"],
        ["\x4E\xB9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x89"],
        ["\x47\x8D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x8A"],
        ["\x50\xC3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x8B"],
        ["\x55\xF4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x8C"],
        ["\x49\xEC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x8D"],
        ["\x4B\xB9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x8E"],
        ["\x4C\xB8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x8F"],
        ["\x4D\xA6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x90"],
        ["\x4B\xF0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x91"],
        ["\x54\xB2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x92"],
        ["\x4D\x94",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x93"],
        ["\x4D\x44",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x94"],
        ["\x50\xA6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x95"],
        ["\x4F\xF8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x96"],
        ["\x4D\xF1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x97"],
        ["\x52\xE1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x98"],
        ["\x4A\x65",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x99"],
        ["\x46\x7F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x9A"],
        ["\x4C\xE5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x9B"],
        ["\x4E\x85",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x9C"],
        ["\x47\x9B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x9D"],
        ["\x4B\x69",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x9E"],
        ["\x48\x79",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x9F"],
        ["\x4F\x70",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xA0"],
        ["\x49\x7A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xA1"],
        ["\x47\xCF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xA2"],
        ["\x49\x98",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xA3"],
        ["\x4B\xC8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xA4"],
        ["\x47\xB1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xA5"],
        ["\x48\x97",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xA6"],
        ["\x49\x9E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xA7"],
        ["\x53\xDB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xA8"],
        ["\x4F\x6A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xA9"],
        ["\x53\xD2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xAA"],
        ["\x48\x51",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xAB"],
        ["\x4A\x43",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xAC"],
        ["\x4C\x52",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xAD"],
        ["\x4B\xE8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xAE"],
        ["\x47\xE4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xAF"],
        ["\x49\xE6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xB0"],
        ["\x4C\xB9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xB1"],
        ["\x46\xE6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xB2"],
        ["\x4C\x64",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xB3"],
        ["\x46\x90",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xB4"],
        ["\x4E\x60",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xB5"],
        ["\x46\x43",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xB6"],
        ["\x48\xA8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xB7"],
        ["\x4E\xB6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xB8"],
        ["\x51\x75",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xB9"],
        ["\x4D\xC1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xBA"],
        ["\x4E\x49",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xBB"],
        ["\x47\xB0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xBC"],
        ["\x49\x93",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xBD"],
        ["\x49\xAB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xBE"],
        ["\x51\x98",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xBF"],
        ["\x51\xB4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x80"],
        ["\x4F\xC7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x81"],
        ["\x48\xFA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x82"],
        ["\x46\x88",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x83"],
        ["\x4A\x4A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x84"],
        ["\x53\x73",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x85"],
        ["\x55\xEF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x86"],
        ["\x4E\xC9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x87"],
        ["\x53\xB3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x88"],
        ["\x4D\xF9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x89"],
        ["\x45\xC9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x8A"],
        ["\x54\xFB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x8B"],
        ["\x4A\xD7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x8C"],
        ["\x48\xA6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x8D"],
        ["\x66\xC4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x8E"],
        ["\x4D\x8E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x8F"],
        ["\x49\x53",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x90"],
        ["\x4B\xA9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x91"],
        ["\x4D\x78",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x92"],
        ["\x49\xF0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x93"],
        ["\x54\xD9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x94"],
        ["\x4A\x74",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x95"],
        ["\x4B\xD0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x96"],
        ["\x53\xC3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x97"],
        ["\x50\xD6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x98"],
        ["\x4F\xC3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x99"],
        ["\x4C\xB5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x9A"],
        ["\x47\xA4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x9B"],
        ["\x4A\xC2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x9C"],
        ["\x4B\x86",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x9D"],
        ["\x46\xBF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x9E"],
        ["\x4B\x43",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x9F"],
        ["\x54\xCC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xA0"],
        ["\x45\x61",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xA1"],
        ["\x48\xB2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xA2"],
        ["\x52\xFA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xA3"],
        ["\x52\xF1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xA4"],
        ["\x46\x81",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xA5"],
        ["\x48\xF4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xA6"],
        ["\x4B\x6B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xA7"],
        ["\x4C\xD3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xA8"],
        ["\x4F\xD3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xA9"],
        ["\x4F\x49",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xAA"],
        ["\x4A\xE7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xAB"],
        ["\x4E\xC3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xAC"],
        ["\x46\x66",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xAD"],
        ["\x47\xBE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xAE"],
        ["\x4D\xC6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xAF"],
        ["\x50\x8D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xB0"],
        ["\x54\x93",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xB1"],
        ["\x48\x6D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xB2"],
        ["\x48\xDC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xB3"],
        ["\x54\x8A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xB4"],
        ["\x4A\xC5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xB5"],
        ["\x4F\x45",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xB6"],
        ["\x46\xD3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xB7"],
        ["\x53\x69",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xB8"],
        ["\x49\xF6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xB9"],
        ["\x45\x52",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xBA"],
        ["\x4B\x79",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xBB"],
        ["\x45\xBB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xBC"],
        ["\x49\x7C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xBD"],
        ["\x47\xE5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xBE"],
        ["\x4E\x55",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xBF"],
        ["\x4E\xC2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x80"],
        ["\x4E\x45",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x81"],
        ["\x4A\x6C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x82"],
        ["\x4A\xE5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x83"],
        ["\x48\xB4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x84"],
        ["\x4C\x7D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x85"],
        ["\x46\x95",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x86"],
        ["\x45\x74",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x87"],
        ["\x4C\x8E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x88"],
        ["\x50\xA2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x89"],
        ["\x4E\x42",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x8A"],
        ["\x47\x8A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x8B"],
        ["\x47\xFC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x8C"],
        ["\x4C\x6E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x8D"],
        ["\x46\xB7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x8E"],
        ["\x55\x63",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x8F"],
        ["\x53\xAC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x90"],
        ["\x47\x9A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x91"],
        ["\x55\xAB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x92"],
        ["\x48\xAD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x93"],
        ["\x54\xA5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x94"],
        ["\x49\xFA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x95"],
        ["\x45\xD4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x96"],
        ["\x4A\xF6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x97"],
        ["\x4A\x94",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x98"],
        ["\x53\xF2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x99"],
        ["\x4E\xAF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x9A"],
        ["\x47\xAD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x9B"],
        ["\x45\xF8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x9C"],
        ["\x53\x6B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x9D"],
        ["\x45\xCF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x9E"],
        ["\x4A\xF7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x9F"],
        ["\x50\x61",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xA0"],
        ["\x4D\x52",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xA1"],
        ["\x51\xDB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xA2"],
        ["\x54\x71",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xA3"],
        ["\x4F\x5A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xA4"],
        ["\x4C\xC5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xA5"],
        ["\x4D\x63",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xA6"],
        ["\x51\x6D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xA7"],
        ["\x4A\xAB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xA8"],
        ["\x4E\xB4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xA9"],
        ["\x55\xCB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xAA"],
        ["\x55\xBF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xAB"],
        ["\x4C\x4D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xAC"],
        ["\x4E\xEE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xAD"],
        ["\x4F\xAF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xAE"],
        ["\x45\x45",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xAF"],
        ["\x4B\x74",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xB0"],
        ["\x4D\x99",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xB1"],
        ["\x45\xDF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xB2"],
        ["\x4A\xEE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xB3"],
        ["\x47\xF6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xB4"],
        ["\x50\xB5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xB5"],
        ["\x45\xE5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xB6"],
        ["\x46\x98",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xB7"],
        ["\x4A\xB1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xB8"],
        ["\x52\xD3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xB9"],
        ["\x55\xEE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xBA"],
        ["\x53\xF1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xBB"],
        ["\x4F\x4E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xBC"],
        ["\x48\xE7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xBD"],
        ["\x4D\x91",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xBE"],
        ["\x49\xDB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xBF"],
        ["\x51\x70",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x80"],
        ["\x4E\xB5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x81"],
        ["\x4F\xC6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x82"],
        ["\x47\x8E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x83"],
        ["\x54\x62",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x84"],
        ["\x53\xE3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x85"],
        ["\x4C\xAE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x86"],
        ["\x53\x43",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x87"],
        ["\x45\x9E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x88"],
        ["\x46\xBB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x89"],
        ["\x48\x70",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x8A"],
        ["\x49\x78",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x8B"],
        ["\x51\xE9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x8C"],
        ["\x49\x42",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x8D"],
        ["\x45\x88",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x8E"],
        ["\x46\xA5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x8F"],
        ["\x51\xAF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x90"],
        ["\x52\x53",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x91"],
        ["\x4E\xF3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x92"],
        ["\x54\x66",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x93"],
        ["\x46\x9E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x94"],
        ["\x4B\xD9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x95"],
        ["\x45\xF4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x96"],
        ["\x46\xC8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x97"],
        ["\x45\x6A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x98"],
        ["\x4C\xA3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x99"],
        ["\x53\xCB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x9A"],
        ["\x45\xA9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x9B"],
        ["\x45\xB7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x9C"],
        ["\x51\x5A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x9D"],
        ["\x46\x9A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x9E"],
        ["\x45\xD3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x9F"],
        ["\x47\xC7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xA0"],
        ["\x53\x8E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xA1"],
        ["\x4A\x67",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xA2"],
        ["\x50\x45",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xA3"],
        ["\x4C\xAC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xA4"],
        ["\x4B\xC5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xA5"],
        ["\x5B\x99",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xA6"],
        ["\x48\xB0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xA7"],
        ["\x4A\x6D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xA8"],
        ["\x50\x8B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xA9"],
        ["\x48\xBF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xAA"],
        ["\x52\xCC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xAB"],
        ["\x47\x96",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xAC"],
        ["\x45\xAD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xAD"],
        ["\x4F\xD4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xAE"],
        ["\x46\xEB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xAF"],
        ["\x48\xC6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xB0"],
        ["\x4A\x4D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xB1"],
        ["\x48\xA0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xB2"],
        ["\x4C\xBB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xB3"],
        ["\x4A\xEF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xB4"],
        ["\x4F\xD5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xB5"],
        ["\x51\x4B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xB6"],
        ["\x4B\x67",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xB7"],
        ["\x4C\x78",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xB8"],
        ["\x50\x6D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xB9"],
        ["\x48\xCB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xBA"],
        ["\x49\x9A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xBB"],
        ["\x47\x60",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xBC"],
        ["\x50\xEB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xBD"],
        ["\x52\xD5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xBE"],
        ["\x52\x47",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xBF"],
        ["\x51\xD8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x80"],
        ["\x48\x9F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x81"],
        ["\x46\xDC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x82"],
        ["\x45\xA4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x83"],
        ["\x4B\xED",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x84"],
        ["\x4A\x6E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x85"],
        ["\x4A\xF1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x86"],
        ["\x4E\x8F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x87"],
        ["\x50\x52",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x88"],
        ["\x4D\x86",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x89"],
        ["\x48\x63",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x8A"],
        ["\x5F\xAF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x8B"],
        ["\x46\xA1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x8C"],
        ["\x54\x9B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x8D"],
        ["\x49\xE5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x8E"],
        ["\x4A\x97",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x8F"],
        ["\x46\xBD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x90"],
        ["\x45\x71",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x91"],
        ["\x4D\xD6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x92"],
        ["\x49\xC7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x93"],
        ["\x54\xC6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x94"],
        ["\x48\xE2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x95"],
        ["\x45\xA0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x96"],
        ["\x55\xB9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x97"],
        ["\x55\xB5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x98"],
        ["\x53\x80",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x99"],
        ["\x4C\x68",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x9A"],
        ["\x50\xA9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x9B"],
        ["\x52\x61",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x9C"],
        ["\x47\x9E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x9D"],
        ["\x4B\xF5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x9E"],
        ["\x49\x54",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x9F"],
        ["\x45\x8F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xA0"],
        ["\x4E\x94",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xA1"],
        ["\x51\xEB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xA2"],
        ["\x50\xFD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xA3"],
        ["\x46\x79",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xA4"],
        ["\x4E\x95",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xA5"],
        ["\x54\xD0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xA6"],
        ["\x4B\xA4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xA7"],
        ["\x54\x95",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xA8"],
        ["\x50\x56",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xA9"],
        ["\x54\x9D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xAA"],
        ["\x4A\xA5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xAB"],
        ["\x50\xDC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xAC"],
        ["\x48\x41",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xAD"],
        ["\x4D\x4C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xAE"],
        ["\x49\x46",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xAF"],
        ["\x45\xE0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xB0"],
        ["\x4B\x44",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xB1"],
        ["\x53\xA6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xB2"],
        ["\x54\x88",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xB3"],
        ["\x4A\x77",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xB4"],
        ["\x53\xB8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xB5"],
        ["\x4E\xA4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xB6"],
        ["\x54\xE8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xB7"],
        ["\x4F\xE7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xB8"],
        ["\x46\x67",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xB9"],
        ["\x53\x59",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xBA"],
        ["\x4B\x46",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xBB"],
        ["\x53\xFD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xBC"],
        ["\x4C\xBD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xBD"],
        ["\x55\xB4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xBE"],
        ["\x50\xA8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xBF"],
        ["\x55\xDC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x80"],
        ["\x45\x76",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x81"],
        ["\x50\xA5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x82"],
        ["\x51\xB8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x83"],
        ["\x4E\xD3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x84"],
        ["\x48\x5B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x85"],
        ["\x49\x8B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x86"],
        ["\x47\x73",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x87"],
        ["\x4E\xAD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x88"],
        ["\x51\x88",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x89"],
        ["\x49\x5B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x8A"],
        ["\x51\x76",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x8B"],
        ["\x4D\x70",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x8C"],
        ["\x4F\x8A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x8D"],
        ["\x4E\x8D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x8E"],
        ["\x48\xB1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x8F"],
        ["\x54\x8F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x90"],
        ["\x4B\x58",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x91"],
        ["\x4C\x43",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x92"],
        ["\x48\xEB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x93"],
        ["\x46\xF5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x94"],
        ["\x4A\x6B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x95"],
        ["\x53\xC1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x96"],
        ["\x49\xA3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x97"],
        ["\x4E\xD4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x98"],
        ["\x4D\xCD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x99"],
        ["\x49\xF1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x9A"],
        ["\x4B\x4F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x9B"],
        ["\x4D\xE0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x9C"],
        ["\x48\xE4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x9D"],
        ["\x47\x69",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x9E"],
        ["\x4C\xBC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x9F"],
        ["\x53\xBF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xA0"],
        ["\x53\x54",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xA1"],
        ["\x4C\xC3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xA2"],
        ["\x54\xB4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xA3"],
        ["\x4C\x71",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xA4"],
        ["\x47\xDB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xA5"],
        ["\x47\x68",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xA6"],
        ["\x4B\xA8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xA7"],
        ["\x49\xBD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xA8"],
        ["\x4D\x6E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xA9"],
        ["\x47\x97",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xAA"],
        ["\x47\x66",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xAB"],
        ["\x47\xCD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xAC"],
        ["\x46\xBC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xAD"],
        ["\x4C\x4E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xAE"],
        ["\x49\xAF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xAF"],
        ["\x50\xC9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xB0"],
        ["\x45\xEC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xB1"],
        ["\x45\x91",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xB2"],
        ["\x4A\x7C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xB3"],
        ["\x4B\x52",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xB4"],
        ["\x54\x51",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xB5"],
        ["\x4C\xDE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xB6"],
        ["\x45\x7F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xB7"],
        ["\x46\xA3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xB8"],
        ["\x52\xD2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xB9"],
        ["\x50\xAF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xBA"],
        ["\x45\x94",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xBB"],
        ["\x4A\x90",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xBC"],
        ["\x4F\x50",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xBD"],
        ["\x50\xA3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xBE"],
        ["\x48\xE8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xBF"],
        ["\x4F\xA4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x80"],
        ["\x51\xF1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x81"],
        ["\x54\x99",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x82"],
        ["\x46\xC9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x83"],
        ["\x4C\xF4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x84"],
        ["\x50\xB1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x85"],
        ["\x47\x71",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x86"],
        ["\x53\x91",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x87"],
        ["\x49\x6E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x88"],
        ["\x54\x57",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x89"],
        ["\x4E\xA1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x8A"],
        ["\x48\xCF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x8B"],
        ["\x4B\x93",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x8C"],
        ["\x4F\x9E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x8D"],
        ["\x4C\x77",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x8E"],
        ["\x4F\xD6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x8F"],
        ["\x48\xF9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x90"],
        ["\x49\xE9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x91"],
        ["\x4C\xF1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x92"],
        ["\x4A\x8A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x93"],
        ["\x52\xA4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x94"],
        ["\x4F\xE4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x95"],
        ["\x55\x7D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x96"],
        ["\x55\xD2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x97"],
        ["\x4E\xB7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x98"],
        ["\x4D\xC7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x99"],
        ["\x54\xC3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x9A"],
        ["\x45\x43",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x9B"],
        ["\x50\x9C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x9C"],
        ["\x48\xD2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x9D"],
        ["\x45\x65",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x9E"],
        ["\x50\x6E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x9F"],
        ["\x53\xDE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xA0"],
        ["\x4A\xC9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xA1"],
        ["\x51\xF3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xA2"],
        ["\x54\xCE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xA3"],
        ["\x53\x99",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xA4"],
        ["\x45\xC0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xA5"],
        ["\x48\x43",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xA6"],
        ["\x55\xEB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xA7"],
        ["\x4F\x5D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xA8"],
        ["\x51\x6B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xA9"],
        ["\x4D\xEE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xAA"],
        ["\x48\x99",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xAB"],
        ["\x55\xB3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xAC"],
        ["\x4E\xFC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xAD"],
        ["\x50\x93",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xAE"],
        ["\x49\x92",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xAF"],
        ["\x48\xB5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xB0"],
        ["\x54\x65",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xB1"],
        ["\x50\x8A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xB2"],
        ["\x48\xB6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xB3"],
        ["\x4B\xC0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xB4"],
        ["\x45\xF0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xB5"],
        ["\x47\xD9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xB6"],
        ["\x4B\x5E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xB7"],
        ["\x45\x44",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xB8"],
        ["\x46\x7D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xB9"],
        ["\x49\x90",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xBA"],
        ["\x4C\xC1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xBB"],
        ["\x4B\x42",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xBC"],
        ["\x45\x64",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xBD"],
        ["\x55\xBA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xBE"],
        ["\x45\x53",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xBF"],
        ["\x4A\x44",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x80"],
        ["\x46\x61",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x81"],
        ["\x46\xAD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x82"],
        ["\x47\xB6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x83"],
        ["\x47\x7B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x84"],
        ["\x4F\xF2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x85"],
        ["\x4E\xA5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x86"],
        ["\x48\x88",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x87"],
        ["\x4D\x6A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x88"],
        ["\x46\x72",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x89"],
        ["\x48\xD8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x8A"],
        ["\x49\x99",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x8B"],
        ["\x48\x8E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x8C"],
        ["\x51\x9F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x8D"],
        ["\x4F\xEB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x8E"],
        ["\x46\xC3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x8F"],
        ["\x46\xC7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x90"],
        ["\x46\x80",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x91"],
        ["\x4A\xF0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x92"],
        ["\x53\x82",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x93"],
        ["\x48\x74",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x94"],
        ["\x4A\x48",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x95"],
        ["\x4A\x50",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x96"],
        ["\x4E\x90",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x97"],
        ["\x4C\xB0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x98"],
        ["\x49\x48",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x99"],
        ["\x4B\x76",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x9A"],
        ["\x4F\x9C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x9B"],
        ["\x46\x50",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x9C"],
        ["\x4F\x94",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x9D"],
        ["\x52\xB7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x9E"],
        ["\x4A\x8F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x9F"],
        ["\x4A\x9F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xA0"],
        ["\x45\xCE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xA1"],
        ["\x4B\xBC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xA2"],
        ["\x4F\xC2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xA3"],
        ["\x46\x9F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xA4"],
        ["\x48\xF2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xA5"],
        ["\x46\xA0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xA6"],
        ["\x4C\xBE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xA7"],
        ["\x46\xD8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xA8"],
        ["\x46\x51",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xA9"],
        ["\x45\x97",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xAA"],
        ["\x48\x57",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xAB"],
        ["\x45\x84",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xAC"],
        ["\x4C\x79",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xAD"],
        ["\x52\x49",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xAE"],
        ["\x51\x82",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xAF"],
        ["\x4A\x62",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xB0"],
        ["\x48\x53",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xB1"],
        ["\x51\xE6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xB2"],
        ["\x4C\xAB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xB3"],
        ["\x45\xC3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xB4"],
        ["\x4F\xE3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xB5"],
        ["\x4D\x74",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xB6"],
        ["\x50\x6A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xB7"],
        ["\x46\x97",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xB8"],
        ["\x46\x8F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xB9"],
        ["\x4A\x75",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xBA"],
        ["\x50\xBA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xBB"],
        ["\x54\x5C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xBC"],
        ["\x4B\xA6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xBD"],
        ["\x4C\x75",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xBE"],
        ["\x52\xA5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xBF"],
        ["\x45\x47",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x80"],
        ["\x50\x42",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x81"],
        ["\x4D\x57",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x82"],
        ["\x49\x41",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x83"],
        ["\x53\xE0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x84"],
        ["\x47\xB8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x85"],
        ["\x54\x69",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x86"],
        ["\x4C\x90",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x87"],
        ["\x4D\xAE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x88"],
        ["\x51\x42",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x89"],
        ["\x46\xEC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x8A"],
        ["\x45\xED",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x8B"],
        ["\x52\xBD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x8C"],
        ["\x48\x75",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x8D"],
        ["\x54\xD2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x8E"],
        ["\x47\xA7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x8F"],
        ["\x49\x72",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x90"],
        ["\x55\xC0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x91"],
        ["\x62\xA6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x92"],
        ["\x4F\x6B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x93"],
        ["\x4C\x58",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x94"],
        ["\x48\xC4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x95"],
        ["\x49\x8A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x96"],
        ["\x4B\xB3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x97"],
        ["\x51\x51",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x98"],
        ["\x4B\xD1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x99"],
        ["\x4C\x4C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x9A"],
        ["\x46\x63",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x9B"],
        ["\x4F\x47",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x9C"],
        ["\x46\x70",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x9D"],
        ["\x4D\xBB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x9E"],
        ["\x46\x53",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x9F"],
        ["\x54\x58",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xA0"],
        ["\x4F\xEA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xA1"],
        ["\x4E\xB8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xA2"],
        ["\x4A\xD0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xA3"],
        ["\x54\x70",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xA4"],
        ["\x4C\x6B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xA5"],
        ["\x54\xC1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xA6"],
        ["\x54\x6A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xA7"],
        ["\x53\xA9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xA8"],
        ["\x52\xBB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xA9"],
        ["\x4D\x79",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xAA"],
        ["\x52\x57",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xAB"],
        ["\x46\xD6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xAC"],
        ["\x4F\xE9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xAD"],
        ["\x4B\x6E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xAE"],
        ["\x54\x72",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xAF"],
        ["\x47\x62",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xB0"],
        ["\x46\xA6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xB1"],
        ["\x46\xF0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xB2"],
        ["\x45\xCB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xB3"],
        ["\x4D\x42",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xB4"],
        ["\x48\x65",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xB5"],
        ["\x4A\x7B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xB6"],
        ["\x4B\x99",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xB7"],
        ["\x46\x92",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xB8"],
        ["\x51\xCE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xB9"],
        ["\x4C\xED",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xBA"],
        ["\x47\x58",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xBB"],
        ["\x49\xBE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xBC"],
        ["\x54\x6F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xBD"],
        ["\x48\x4C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xBE"],
        ["\x54\x8D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xBF"],
        ["\x46\xB2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x80"],
        ["\x4C\x61",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x81"],
        ["\x46\xCF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x82"],
        ["\x51\xA3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x83"],
        ["\x47\xFB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x84"],
        ["\x50\x65",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x85"],
        ["\x47\x91",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x86"],
        ["\x48\xA1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x87"],
        ["\x47\xDD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x88"],
        ["\x4B\xEE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x89"],
        ["\x47\x41",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x8A"],
        ["\x46\xDE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x8B"],
        ["\x52\x82",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x8C"],
        ["\x4D\xD7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x8D"],
        ["\x4B\x72",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x8E"],
        ["\x45\xF1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x8F"],
        ["\x46\x58",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x90"],
        ["\x49\xF4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x91"],
        ["\x52\xDA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x92"],
        ["\x4A\x69",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x93"],
        ["\x4D\xB3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x94"],
        ["\x4B\xB8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x95"],
        ["\x4F\x93",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x96"],
        ["\x4B\x88",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x97"],
        ["\x4D\xDF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x98"],
        ["\x53\xFE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x99"],
        ["\x52\xF6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x9A"],
        ["\x55\xA6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x9B"],
        ["\x4A\xD3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x9C"],
        ["\x55\x48",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x9D"],
        ["\x51\x49",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x9E"],
        ["\x47\xA0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x9F"],
        ["\x53\x6F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xA0"],
        ["\x53\xD9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xA1"],
        ["\x46\xE0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xA2"],
        ["\x48\xC9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xA3"],
        ["\x45\x4A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xA4"],
        ["\x48\xFB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xA5"],
        ["\x51\x7F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xA6"],
        ["\x4D\xEA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xA7"],
        ["\x4D\x84",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xA8"],
        ["\x48\x92",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xA9"],
        ["\x4F\x65",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xAA"],
        ["\x4E\x93",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xAB"],
        ["\x45\xA3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xAC"],
        ["\x4C\xE2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xAD"],
        ["\x4F\xA5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xAE"],
        ["\x54\xDD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xAF"],
        ["\x48\x82",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xB0"],
        ["\x4A\xBF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xB1"],
        ["\x4C\xEB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xB2"],
        ["\x49\xF7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xB3"],
        ["\x4F\xC8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xB4"],
        ["\x52\x79",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xB5"],
        ["\x4E\xBF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xB6"],
        ["\x45\x9B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xB7"],
        ["\x48\x6C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xB8"],
        ["\x4A\x9C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xB9"],
        ["\x46\x60",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xBA"],
        ["\x50\x72",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xBB"],
        ["\x46\x62",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xBC"],
        ["\x4D\xB0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xBD"],
        ["\x54\x6B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xBE"],
        ["\x4F\xB8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xBF"],
        ["\x4C\xC0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x80"],
        ["\x4F\x80",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x81"],
        ["\x4E\xF5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x82"],
        ["\x4D\x67",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x83"],
        ["\x4F\xAE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x84"],
        ["\x53\xA4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x85"],
        ["\x48\x94",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x86"],
        ["\x46\xCE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x87"],
        ["\x4A\xD2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x88"],
        ["\x50\x82",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x89"],
        ["\x47\xA6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x8A"],
        ["\x4D\x47",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x8B"],
        ["\x52\x6E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x8C"],
        ["\x51\xA9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x8D"],
        ["\x47\xB2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x8E"],
        ["\x48\xE6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x8F"],
        ["\x47\x4B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x90"],
        ["\x45\x8C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x91"],
        ["\x4F\xBE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x92"],
        ["\x51\x52",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x93"],
        ["\x50\xE4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x94"],
        ["\x50\xC1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x95"],
        ["\x4A\x9B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x96"],
        ["\x4C\x99",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x97"],
        ["\x47\x9D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x98"],
        ["\x53\xF9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x99"],
        ["\x55\xE2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x9A"],
        ["\x47\xE2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x9B"],
        ["\x46\x71",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x9C"],
        ["\x50\xF5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x9D"],
        ["\x46\x99",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x9E"],
        ["\x4D\x4F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x9F"],
        ["\x50\xB3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xA0"],
        ["\x52\x98",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xA1"],
        ["\x52\xC0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xA2"],
        ["\x49\x6D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xA3"],
        ["\x4C\x5B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xA4"],
        ["\x4A\xA2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xA5"],
        ["\x45\xB5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xA6"],
        ["\x4E\x6B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xA7"],
        ["\x4E\x47",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xA8"],
        ["\x4F\x86",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xA9"],
        ["\x55\x68",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xAA"],
        ["\x46\xBE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xAB"],
        ["\x4D\x43",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xAC"],
        ["\x54\xEC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xAD"],
        ["\x4E\xCA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xAE"],
        ["\x53\xAF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xAF"],
        ["\x54\x98",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xB0"],
        ["\x52\xEF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xB1"],
        ["\x49\x59",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xB2"],
        ["\x45\x5D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xB3"],
        ["\x48\x4A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xB4"],
        ["\x48\x71",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xB5"],
        ["\x48\x50",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xB6"],
        ["\x4A\xED",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xB7"],
        ["\x55\x62",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xB8"],
        ["\x49\x64",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xB9"],
        ["\x4C\x48",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xBA"],
        ["\x4E\xC0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xBB"],
        ["\x4B\xFD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xBC"],
        ["\x4E\xEC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xBD"],
        ["\x4D\x8F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xBE"],
        ["\x46\xFE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xBF"],
        ["\x46\xD1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x80"],
        ["\x45\xB3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x81"],
        ["\x4A\xF8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x82"],
        ["\x45\x78",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x83"],
        ["\x50\xAC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x84"],
        ["\x53\x9B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x85"],
        ["\x55\x85",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x86"],
        ["\x46\xC6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x87"],
        ["\x48\x6B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x88"],
        ["\x4A\xC0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x89"],
        ["\x51\x55",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x8A"],
        ["\x49\x83",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x8B"],
        ["\x4D\xE6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x8C"],
        ["\x47\x42",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x8D"],
        ["\x4E\x4A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x8E"],
        ["\x48\x47",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x8F"],
        ["\x49\x76",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x90"],
        ["\x51\xB0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x91"],
        ["\x49\xF9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x92"],
        ["\x4B\xDF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x93"],
        ["\x47\x6E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x94"],
        ["\x49\xB5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x95"],
        ["\x4B\xD4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x96"],
        ["\x4C\xE4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x97"],
        ["\x52\x67",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x98"],
        ["\x51\x80",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x99"],
        ["\x53\xF8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x9A"],
        ["\x53\xA8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x9B"],
        ["\x4D\xA5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x9C"],
        ["\x4F\xA8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x9D"],
        ["\x50\xEF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x9E"],
        ["\x49\xBA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x9F"],
        ["\x4F\x88",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xA0"],
        ["\x4D\xE7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xA1"],
        ["\x49\x94",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xA2"],
        ["\x4A\xAD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xA3"],
        ["\x50\x7F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xA4"],
        ["\x4F\xB4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xA5"],
        ["\x53\xBD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xA6"],
        ["\x4C\xC8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xA7"],
        ["\x4B\xF9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xA8"],
        ["\x52\xE7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xA9"],
        ["\x45\x5E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xAA"],
        ["\x49\xD3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xAB"],
        ["\x4F\x62",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xAC"],
        ["\x49\x47",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xAD"],
        ["\x52\x7E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xAE"],
        ["\x4D\x85",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xAF"],
        ["\x45\xDB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xB0"],
        ["\x45\xD9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xB1"],
        ["\x51\x96",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xB2"],
        ["\x4D\xE4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xB3"],
        ["\x46\xEF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xB4"],
        ["\x48\x5F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xB5"],
        ["\x55\xF6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xB6"],
        ["\x47\x5E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xB7"],
        ["\x50\xF4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xB8"],
        ["\x4C\xC9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xB9"],
        ["\x48\x52",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xBA"],
        ["\x4E\x54",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xBB"],
        ["\x4E\x98",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xBC"],
        ["\x4A\xBA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xBD"],
        ["\x4B\x7B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xBE"],
        ["\x50\xC2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xBF"],
        ["\x4E\x57",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x80"],
        ["\x50\xCA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x81"],
        ["\x4F\x48",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x82"],
        ["\x49\x57",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x83"],
        ["\x4E\xE5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x84"],
        ["\x47\xC5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x85"],
        ["\x4E\x73",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x86"],
        ["\x54\xE6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x87"],
        ["\x48\x9A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x88"],
        ["\x48\xD7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x89"],
        ["\x47\xC3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x8A"],
        ["\x4C\xD1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x8B"],
        ["\x46\xB8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x8C"],
        ["\x53\x47",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x8D"],
        ["\x52\xE5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x8E"],
        ["\x49\xCE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x8F"],
        ["\x46\xF4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x90"],
        ["\x45\xA5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x91"],
        ["\x4F\x8C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x92"],
        ["\x4F\x76",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x93"],
        ["\x52\x4C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x94"],
        ["\x4B\x59",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x95"],
        ["\x49\x87",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x96"],
        ["\x46\xE7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x97"],
        ["\x4A\x76",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x98"],
        ["\x48\xF6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x99"],
        ["\x45\x87",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x9A"],
        ["\x4B\xB2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x9B"],
        ["\x45\x9D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x9C"],
        ["\x4D\x7E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x9D"],
        ["\x4D\x41",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x9E"],
        ["\x47\x77",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x9F"],
        ["\x49\x67",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xA0"],
        ["\x54\xE1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xA1"],
        ["\x46\x42",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xA2"],
        ["\x45\xA1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xA3"],
        ["\x4C\x8A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xA4"],
        ["\x4E\x59",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xA5"],
        ["\x4A\x47",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xA6"],
        ["\x4F\xE5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xA7"],
        ["\x54\x5A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xA8"],
        ["\x48\x85",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xA9"],
        ["\x4D\x68",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xAA"],
        ["\x47\x9C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xAB"],
        ["\x4D\x5E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xAC"],
        ["\x46\x69",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xAD"],
        ["\x49\x88",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xAE"],
        ["\x4D\xDE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xAF"],
        ["\x45\x93",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xB0"],
        ["\x47\x76",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xB1"],
        ["\x4F\x44",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xB2"],
        ["\x4D\x89",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xB3"],
        ["\x51\x4F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xB4"],
        ["\x4D\x5F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xB5"],
        ["\x4B\x66",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xB6"],
        ["\x4F\xB9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xB7"],
        ["\x52\xC4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xB8"],
        ["\x50\xF2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xB9"],
        ["\x50\x68",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xBA"],
        ["\x4C\x84",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xBB"],
        ["\x66\xAB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xBC"],
        ["\x52\xF4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xBD"],
        ["\x4B\xC1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xBE"],
        ["\x46\xB0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xBF"],
        ["\x4B\xAE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x80"],
        ["\x47\xC1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x81"],
        ["\x51\x78",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x82"],
        ["\x4F\xB3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x83"],
        ["\x49\xC4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x84"],
        ["\x4B\xC9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x85"],
        ["\x52\xAF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x86"],
        ["\x48\xD5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x87"],
        ["\x45\x9C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x88"],
        ["\x4F\xCB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x89"],
        ["\x52\x6C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x8A"],
        ["\x4F\xCC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x8B"],
        ["\x4F\x69",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x8C"],
        ["\x4F\x54",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x8D"],
        ["\x4C\xF7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x8E"],
        ["\x4E\x7C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x8F"],
        ["\x53\x90",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x90"],
        ["\x54\xEF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x91"],
        ["\x4E\x76",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x92"],
        ["\x4B\x5B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x93"],
        ["\x52\xC5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x94"],
        ["\x4C\x7F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x95"],
        ["\x50\x9E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x96"],
        ["\x46\xCC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x97"],
        ["\x52\xD0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x98"],
        ["\x55\x61",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x99"],
        ["\x51\xFB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x9A"],
        ["\x4E\xD6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x9B"],
        ["\x46\x68",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x9C"],
        ["\x4F\xED",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x9D"],
        ["\x47\x53",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x9E"],
        ["\x55\xE4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x9F"],
        ["\x4F\x64",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xA0"],
        ["\x4C\x8D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xA1"],
        ["\x48\x87",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xA2"],
        ["\x51\xEF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xA3"],
        ["\x4B\x60",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xA4"],
        ["\x46\x9B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xA5"],
        ["\x46\x5B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xA6"],
        ["\x50\x86",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xA7"],
        ["\x4B\xBB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xA8"],
        ["\x52\xDC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xA9"],
        ["\x46\xC4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xAA"],
        ["\x47\xEE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xAB"],
        ["\x4F\xF1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xAC"],
        ["\x4A\x61",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xAD"],
        ["\x46\x6E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xAE"],
        ["\x45\xBA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xAF"],
        ["\x45\xC7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xB0"],
        ["\x47\x7C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xB1"],
        ["\x47\xA9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xB2"],
        ["\x47\x95",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xB3"],
        ["\x53\x75",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xB4"],
        ["\x4D\xCC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xB5"],
        ["\x45\x77",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xB6"],
        ["\x45\x96",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xB7"],
        ["\x51\x58",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xB8"],
        ["\x45\x99",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xB9"],
        ["\x48\x44",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xBA"],
        ["\x46\x6C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xBB"],
        ["\x4B\xB5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xBC"],
        ["\x49\x6C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xBD"],
        ["\x45\x7B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xBE"],
        ["\x45\x58",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xBF"],
        ["\x46\xFD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x80"],
        ["\x4F\xA0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x81"],
        ["\x4A\xE8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x82"],
        ["\x53\xB1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x83"],
        ["\x53\x78",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x84"],
        ["\x46\x4C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x85"],
        ["\x46\x44",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x86"],
        ["\x46\x8E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x87"],
        ["\x47\xC4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x88"],
        ["\x55\xEC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x89"],
        ["\x4F\xDA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x8A"],
        ["\x4B\x53",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x8B"],
        ["\x4E\xD7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x8C"],
        ["\x55\x95",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x8D"],
        ["\x51\x41",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x8E"],
        ["\x4C\x59",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x8F"],
        ["\x4A\xE2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x90"],
        ["\x45\x80",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x91"],
        ["\x48\x91",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x92"],
        ["\x4D\xFE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x93"],
        ["\x48\x66",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x94"],
        ["\x53\x5E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x95"],
        ["\x4B\xD2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x96"],
        ["\x46\xF9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x97"],
        ["\x4C\xCD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x98"],
        ["\x53\x68",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x99"],
        ["\x50\x7D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x9A"],
        ["\x47\x65",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x9B"],
        ["\x52\x5C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x9C"],
        ["\x47\xA8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x9D"],
        ["\x4E\x8C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x9E"],
        ["\x49\x8D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x9F"],
        ["\x45\xE2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xA0"],
        ["\x51\x69",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xA1"],
        ["\x47\xA1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xA2"],
        ["\x49\x52",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xA3"],
        ["\x49\xBB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xA4"],
        ["\x4A\xF3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xA5"],
        ["\x50\x94",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xA6"],
        ["\x53\xE8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xA7"],
        ["\x48\xA2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xA8"],
        ["\x47\xA2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xA9"],
        ["\x45\x4C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xAA"],
        ["\x49\xEE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xAB"],
        ["\x49\x8F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xAC"],
        ["\x49\xFB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xAD"],
        ["\x53\xC0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xAE"],
        ["\x45\x67",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xAF"],
        ["\x47\x64",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xB0"],
        ["\x4D\xCA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xB1"],
        ["\x53\x72",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xB2"],
        ["\x50\xE3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xB3"],
        ["\x55\xDA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xB4"],
        ["\x46\xEE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xB5"],
        ["\x46\x8D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xB6"],
        ["\x4A\x4E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xB7"],
        ["\x48\x9B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xB8"],
        ["\x4D\xC0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xB9"],
        ["\x54\x90",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xBA"],
        ["\x55\x90",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xBB"],
        ["\x4D\x7B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xBC"],
        ["\x4E\x91",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xBD"],
        ["\x51\x8D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xBE"],
        ["\x46\x87",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xBF"],
        ["\x48\x68",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x80"],
        ["\x55\x96",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x81"],
        ["\x52\x6F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x82"],
        ["\x4F\xC1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x83"],
        ["\x46\x7B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x84"],
        ["\x4F\xBF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x85"],
        ["\x51\x8E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x86"],
        ["\x64\x78",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x87"],
        ["\x50\xD1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x88"],
        ["\x48\x5D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x89"],
        ["\x53\x5B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x8A"],
        ["\x4D\x48",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x8B"],
        ["\x4C\xAD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x8C"],
        ["\x51\x9C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x8D"],
        ["\x4C\xE9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x8E"],
        ["\x45\xAF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x8F"],
        ["\x46\xB3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x90"],
        ["\x4D\x73",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x91"],
        ["\x47\xEF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x92"],
        ["\x46\xB1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x93"],
        ["\x4F\x87",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x94"],
        ["\x51\xD4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x95"],
        ["\x50\x76",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x96"],
        ["\x51\x60",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x97"],
        ["\x50\x62",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x98"],
        ["\x4E\xC6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x99"],
        ["\x54\xB9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x9A"],
        ["\x4A\x60",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x9B"],
        ["\x51\x66",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x9C"],
        ["\x49\x5F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x9D"],
        ["\x53\x4C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x9E"],
        ["\x4E\xCF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x9F"],
        ["\x55\xB0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xA0"],
        ["\x51\x71",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xA1"],
        ["\x4C\x9C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xA2"],
        ["\x4C\xDC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xA3"],
        ["\x4D\x83",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xA4"],
        ["\x4D\x59",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xA5"],
        ["\x47\x9F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xA6"],
        ["\x46\xB9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xA7"],
        ["\x4C\xBF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xA8"],
        ["\x4C\xDF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xA9"],
        ["\x4F\xEF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xAA"],
        ["\x54\x4C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xAB"],
        ["\x50\xCB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xAC"],
        ["\x4E\x84",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xAD"],
        ["\x4B\xE1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xAE"],
        ["\x4B\x71",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xAF"],
        ["\x53\xF5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xB0"],
        ["\x45\xD6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xB1"],
        ["\x51\x68",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xB2"],
        ["\x4C\x9F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xB3"],
        ["\x4C\x53",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xB4"],
        ["\x52\xDD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xB5"],
        ["\x52\x4D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xB6"],
        ["\x4A\x8E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xB7"],
        ["\x51\xB7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xB8"],
        ["\x4B\x68",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xB9"],
        ["\x48\xB3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xBA"],
        ["\x4D\xDD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xBB"],
        ["\x4D\xC3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xBC"],
        ["\x55\x55",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xBD"],
        ["\x54\xA3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xBE"],
        ["\x49\x9B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xBF"],
        ["\x46\xE9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x80"],
        ["\x4E\xD2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x81"],
        ["\x4C\x67",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x82"],
        ["\x52\xDB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x83"],
        ["\x4D\xB7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x84"],
        ["\x54\xA1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x85"],
        ["\x4C\x66",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x86"],
        ["\x48\x96",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x87"],
        ["\x54\xA4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x88"],
        ["\x46\x78",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x89"],
        ["\x4B\xE9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x8A"],
        ["\x51\x8C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x8B"],
        ["\x47\x93",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x8C"],
        ["\x50\x70",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x8D"],
        ["\x4B\x89",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x8E"],
        ["\x48\x42",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x8F"],
        ["\x4B\x62",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x90"],
        ["\x4F\x79",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x91"],
        ["\x50\xB9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x92"],
        ["\x50\x5F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x93"],
        ["\x48\x98",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x94"],
        ["\x4A\xAA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x95"],
        ["\x47\x44",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x96"],
        ["\x51\x43",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x97"],
        ["\x51\x97",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x98"],
        ["\x4D\xE8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x99"],
        ["\x4D\xD2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x9A"],
        ["\x4B\xBA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x9B"],
        ["\x46\x4D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x9C"],
        ["\x4F\x4A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x9D"],
        ["\x4D\xBD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x9E"],
        ["\x46\x5E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x9F"],
        ["\x4C\x7C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xA0"],
        ["\x45\xB8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xA1"],
        ["\x4A\x6A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xA2"],
        ["\x49\x43",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xA3"],
        ["\x47\x4D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xA4"],
        ["\x4B\x6D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xA5"],
        ["\x4B\xB0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xA6"],
        ["\x53\xA0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xA7"],
        ["\x4B\x4B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xA8"],
        ["\x49\x45",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xA9"],
        ["\x46\xFA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xAA"],
        ["\x48\xCD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xAB"],
        ["\x4E\x97",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xAC"],
        ["\x47\x6D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xAD"],
        ["\x4F\xFD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xAE"],
        ["\x4A\xDC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xAF"],
        ["\x47\xCB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xB0"],
        ["\x4A\xF2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xB1"],
        ["\x4A\x57",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xB2"],
        ["\x4F\x67",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xB3"],
        ["\x4E\xFD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xB4"],
        ["\x4A\x41",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xB5"],
        ["\x4C\x5E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xB6"],
        ["\x4C\xEF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xB7"],
        ["\x4B\xD8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xB8"],
        ["\x45\x56",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xB9"],
        ["\x54\x55",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xBA"],
        ["\x47\x55",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xBB"],
        ["\x45\xFE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xBC"],
        ["\x45\xAB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xBD"],
        ["\x50\xD2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xBE"],
        ["\x55\xE3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xBF"],
        ["\x54\x78",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x80"],
        ["\x53\xB0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x81"],
        ["\x4D\x9E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x82"],
        ["\x54\xB8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x83"],
        ["\x47\xEA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x84"],
        ["\x55\xCD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x85"],
        ["\x54\xDB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x86"],
        ["\x55\xC5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x87"],
        ["\x4F\xE8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x88"],
        ["\x4D\xE5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x89"],
        ["\x53\xDA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x8A"],
        ["\x46\x96",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x8B"],
        ["\x53\x71",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x8C"],
        ["\x46\x56",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x8D"],
        ["\x49\x8E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x8E"],
        ["\x52\x62",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x8F"],
        ["\x49\x60",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x90"],
        ["\x48\xA3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x91"],
        ["\x50\x81",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x92"],
        ["\x48\xFD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x93"],
        ["\x50\x92",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x94"],
        ["\x4B\xC3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x95"],
        ["\x46\xF3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x96"],
        ["\x4D\xA1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x97"],
        ["\x52\x63",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x98"],
        ["\x52\x9A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x99"],
        ["\x52\xD7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x9A"],
        ["\x4A\x54",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x9B"],
        ["\x4A\xF4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x9C"],
        ["\x4B\x49",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x9D"],
        ["\x4F\x77",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x9E"],
        ["\x4A\x93",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x9F"],
        ["\x51\xDD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xA0"],
        ["\x50\xD8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xA1"],
        ["\x45\x9A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xA2"],
        ["\x47\x78",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xA3"],
        ["\x45\x5B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xA4"],
        ["\x46\x7E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xA5"],
        ["\x51\x6F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xA6"],
        ["\x47\xFE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xA7"],
        ["\x4B\x7A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xA8"],
        ["\x47\xA3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xA9"],
        ["\x52\xAE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xAA"],
        ["\x49\x96",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xAB"],
        ["\x53\x83",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xAC"],
        ["\x48\x6F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xAD"],
        ["\x55\xD5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xAE"],
        ["\x4E\x7E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xAF"],
        ["\x4B\xDB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xB0"],
        ["\x45\x85",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xB1"],
        ["\x4D\xD4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xB2"],
        ["\x4E\x5C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xB3"],
        ["\x4A\xB6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xB4"],
        ["\x53\x88",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xB5"],
        ["\x50\xBE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xB6"],
        ["\x4F\xE1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xB7"],
        ["\x4D\xF7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xB8"],
        ["\x55\x8A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xB9"],
        ["\x52\x4E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xBA"],
        ["\x4E\x41",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xBB"],
        ["\x4F\x71",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xBC"],
        ["\x4E\xFE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xBD"],
        ["\x46\xA4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xBE"],
        ["\x47\xDF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xBF"],
        ["\x4E\xBB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x80"],
        ["\x4A\xB4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x81"],
        ["\x4E\x46",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x82"],
        ["\x51\xC8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x83"],
        ["\x54\x7E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x84"],
        ["\x4B\xEF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x85"],
        ["\x45\x81",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x86"],
        ["\x52\xFE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x87"],
        ["\x55\x60",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x88"],
        ["\x4B\xBE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x89"],
        ["\x4B\x83",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x8A"],
        ["\x48\xAB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x8B"],
        ["\x48\xE3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x8C"],
        ["\x50\x63",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x8D"],
        ["\x51\xC4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x8E"],
        ["\x4A\xA1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x8F"],
        ["\x4B\x7F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x90"],
        ["\x4D\x9D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x91"],
        ["\x54\x87",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x92"],
        ["\x4C\xA5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x93"],
        ["\x53\xF3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x94"],
        ["\x48\x61",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x95"],
        ["\x4A\x82",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x96"],
        ["\x48\xEF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x97"],
        ["\x54\xCA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x98"],
        ["\x54\xA6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x99"],
        ["\x55\xB8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x9A"],
        ["\x4E\x9B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x9B"],
        ["\x53\xD8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x9C"],
        ["\x4F\xA2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x9D"],
        ["\x48\xC7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x9E"],
        ["\x47\xF0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x9F"],
        ["\x4E\x8E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xA0"],
        ["\x4A\xD4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xA1"],
        ["\x49\x89",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xA2"],
        ["\x4D\x6C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xA3"],
        ["\x4F\xF5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xA4"],
        ["\x47\xED",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xA5"],
        ["\x45\x7C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xA6"],
        ["\x49\x63",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xA7"],
        ["\x48\x7D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xA8"],
        ["\x45\xB0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xA9"],
        ["\x45\xC2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xAA"],
        ["\x55\x97",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xAB"],
        ["\x4E\xCE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xAC"],
        ["\x46\xA8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xAD"],
        ["\x45\xE8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xAE"],
        ["\x50\x89",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xAF"],
        ["\x4D\xCF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xB0"],
        ["\x46\x8C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xB1"],
        ["\x4C\x6A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xB2"],
        ["\x54\xDC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xB3"],
        ["\x4C\x6D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xB4"],
        ["\x52\xDF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xB5"],
        ["\x49\xA8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xB6"],
        ["\x4D\x72",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xB7"],
        ["\x45\xF5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xB8"],
        ["\x4B\x45",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xB9"],
        ["\x4C\x94",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xBA"],
        ["\x50\xBB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xBB"],
        ["\x4D\x9F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xBC"],
        ["\x4F\xB0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xBD"],
        ["\x49\x77",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xBE"],
        ["\x55\x67",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xBF"],
        ["\x47\xAA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x80"],
        ["\x45\x5C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x81"],
        ["\x48\x69",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x82"],
        ["\x4D\x64",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x83"],
        ["\x46\x4F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x84"],
        ["\x4D\x53",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x85"],
        ["\x4C\x98",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x86"],
        ["\x4B\xEA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x87"],
        ["\x49\x44",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x88"],
        ["\x4B\xCB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x89"],
        ["\x52\xE9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x8A"],
        ["\x4F\x66",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x8B"],
        ["\x55\x91",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x8C"],
        ["\x48\xC1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x8D"],
        ["\x4D\xF5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x8E"],
        ["\x53\x8B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x8F"],
        ["\x4F\xDE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x90"],
        ["\x49\xC5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x91"],
        ["\x54\xB0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x92"],
        ["\x4A\x59",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x93"],
        ["\x4C\x62",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x94"],
        ["\x4B\xCE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x95"],
        ["\x4D\xF3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x96"],
        ["\x55\xF9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x97"],
        ["\x55\x58",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x98"],
        ["\x55\x56",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x99"],
        ["\x51\xC7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x9A"],
        ["\x4D\xC5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x9B"],
        ["\x4B\x92",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x9C"],
        ["\x51\xE5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x9D"],
        ["\x48\xBA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x9E"],
        ["\x4E\x86",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x9F"],
        ["\x4C\x74",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xA0"],
        ["\x51\x53",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xA1"],
        ["\x4F\xDB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xA2"],
        ["\x4C\xC7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xA3"],
        ["\x47\x5C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xA4"],
        ["\x4C\x93",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xA5"],
        ["\x55\xDD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xA6"],
        ["\x45\x55",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xA7"],
        ["\x4E\x5F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xA8"],
        ["\x4D\xA8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xA9"],
        ["\x55\xE9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xAA"],
        ["\x4D\xB6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xAB"],
        ["\x4E\x6E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xAC"],
        ["\x46\x89",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xAD"],
        ["\x55\x70",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xAE"],
        ["\x4A\x78",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xAF"],
        ["\x50\xB4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xB0"],
        ["\x4E\x80",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xB1"],
        ["\x45\x83",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xB2"],
        ["\x4D\x5B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xB3"],
        ["\x47\x79",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xB4"],
        ["\x4E\xEF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xB5"],
        ["\x55\x46",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xB6"],
        ["\x46\x74",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xB7"],
        ["\x55\xF3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xB8"],
        ["\x4C\x8F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xB9"],
        ["\x4D\x5D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xBA"],
        ["\x4B\x4D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xBB"],
        ["\x4C\x89",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xBC"],
        ["\x4E\x61",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xBD"],
        ["\x45\xDC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xBE"],
        ["\x51\x50",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xBF"],
        ["\x4B\xA0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x80"],
        ["\x4E\xFA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x81"],
        ["\x49\xD1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x82"],
        ["\x54\xFE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x83"],
        ["\x4C\x47",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x84"],
        ["\x45\xE3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x85"],
        ["\x46\x57",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x86"],
        ["\x52\xD1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x87"],
        ["\x54\xCD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x88"],
        ["\x4B\x5C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x89"],
        ["\x4E\xDF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x8A"],
        ["\x4E\x8A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x8B"],
        ["\x4F\xD8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x8C"],
        ["\x47\xF5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x8D"],
        ["\x4F\xA1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x8E"],
        ["\x4D\xC9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x8F"],
        ["\x54\xAA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x90"],
        ["\x4C\xBA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x91"],
        ["\x54\x46",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x92"],
        ["\x49\x49",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x93"],
        ["\x58\x9B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x94"],
        ["\x52\xEA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x95"],
        ["\x55\x92",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x96"],
        ["\x4C\x87",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x97"],
        ["\x53\xD3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x98"],
        ["\x4C\xE3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x99"],
        ["\x47\x7A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x9A"],
        ["\x4E\x52",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x9B"],
        ["\x48\xA4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x9C"],
        ["\x4E\x70",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x9D"],
        ["\x4F\x95",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x9E"],
        ["\x53\x79",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x9F"],
        ["\x46\xB6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xA0"],
        ["\x4F\x56",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xA1"],
        ["\x4B\x61",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xA2"],
        ["\x45\xE7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xA3"],
        ["\x48\x9C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xA4"],
        ["\x4B\x64",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xA5"],
        ["\x48\xE0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xA6"],
        ["\x50\x5B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xA7"],
        ["\x4C\x9B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xA8"],
        ["\x4D\xE3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xA9"],
        ["\x4B\x90",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xAA"],
        ["\x53\x87",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xAB"],
        ["\x49\xB9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xAC"],
        ["\x51\xE4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xAD"],
        ["\x53\x4D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xAE"],
        ["\x51\x95",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xAF"],
        ["\x4B\xA7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xB0"],
        ["\x47\xF4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xB1"],
        ["\x4A\x80",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xB2"],
        ["\x4D\xFC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xB3"],
        ["\x4F\xC4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xB4"],
        ["\x52\x46",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xB5"],
        ["\x55\xA7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xB6"],
        ["\x51\x5E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xB7"],
        ["\x4D\x81",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xB8"],
        ["\x51\x54",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xB9"],
        ["\x4F\xF4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xBA"],
        ["\x51\xAA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xBB"],
        ["\x4E\x56",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xBC"],
        ["\x4D\xCB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xBD"],
        ["\x55\x43",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xBE"],
        ["\x4B\xF3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xBF"],
        ["\x4F\xB7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x80"],
        ["\x45\xEF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x81"],
        ["\x4F\x41",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x82"],
        ["\x49\xCC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x83"],
        ["\x50\x41",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x84"],
        ["\x54\x97",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x85"],
        ["\x47\x47",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x86"],
        ["\x48\xF8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x87"],
        ["\x4E\x7A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x88"],
        ["\x54\xEE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x89"],
        ["\x53\xDF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x8A"],
        ["\x45\xD7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x8B"],
        ["\x47\xC9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x8C"],
        ["\x4F\x5E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x8D"],
        ["\x46\x8A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x8E"],
        ["\x48\xDD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x8F"],
        ["\x48\x54",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x90"],
        ["\x4A\x91",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x91"],
        ["\x55\xFA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x92"],
        ["\x52\xA7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x93"],
        ["\x50\x7B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x94"],
        ["\x47\x52",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x95"],
        ["\x55\xC1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x96"],
        ["\x47\x88",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x97"],
        ["\x48\xD9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x98"],
        ["\x48\x49",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x99"],
        ["\x55\x89",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x9A"],
        ["\x45\x63",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x9B"],
        ["\x45\x82",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x9C"],
        ["\x50\x50",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x9D"],
        ["\x4E\xB2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x9E"],
        ["\x54\xF6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x9F"],
        ["\x48\x6A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xA0"],
        ["\x53\x7F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xA1"],
        ["\x53\xFB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xA2"],
        ["\x4C\x6C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xA3"],
        ["\x4E\x83",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xA4"],
        ["\x52\x5D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xA5"],
        ["\x45\xD2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xA6"],
        ["\x46\xE8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xA7"],
        ["\x53\xD4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xA8"],
        ["\x52\xC1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xA9"],
        ["\x48\xF0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xAA"],
        ["\x45\x4F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xAB"],
        ["\x55\xD3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xAC"],
        ["\x4D\x45",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xAD"],
        ["\x50\xDF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xAE"],
        ["\x4A\x64",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xAF"],
        ["\x45\xDE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xB0"],
        ["\x46\x84",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xB1"],
        ["\x4D\x90",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xB2"],
        ["\x4C\xD6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xB3"],
        ["\x4B\x6A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xB4"],
        ["\x49\x4B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xB5"],
        ["\x4B\xDE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xB6"],
        ["\x4B\xE6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xB7"],
        ["\x4C\x50",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xB8"],
        ["\x4B\xAB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xB9"],
        ["\x4C\xCB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xBA"],
        ["\x52\xF8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xBB"],
        ["\x55\x83",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xBC"],
        ["\x51\x5C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xBD"],
        ["\x45\x6F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xBE"],
        ["\x47\xD1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xBF"],
        ["\x51\x45",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x80"],
        ["\x47\x51",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x81"],
        ["\x52\x8F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x82"],
        ["\x45\x57",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x83"],
        ["\x4A\xDA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x84"],
        ["\x5C\x49",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x85"],
        ["\x4E\xA9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x86"],
        ["\x4D\x65",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x87"],
        ["\x55\xE1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x88"],
        ["\x48\xBD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x89"],
        ["\x5D\x69",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x8A"],
        ["\x4B\x65",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x8B"],
        ["\x4E\xF8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x8C"],
        ["\x46\x5F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x8D"],
        ["\x55\x49",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x8E"],
        ["\x55\x53",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x8F"],
        ["\x46\xA7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x90"],
        ["\x49\xD0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x91"],
        ["\x4B\x7C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x92"],
        ["\x48\x84",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x93"],
        ["\x48\x81",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x94"],
        ["\x4C\xDD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x95"],
        ["\x50\x71",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x96"],
        ["\x54\xF0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x97"],
        ["\x45\x68",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x98"],
        ["\x49\xD2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x99"],
        ["\x4F\xE2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x9A"],
        ["\x4A\x99",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x9B"],
        ["\x4D\x7C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x9C"],
        ["\x4C\x72",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x9D"],
        ["\x4B\xDA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x9E"],
        ["\x52\xCF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x9F"],
        ["\x4A\xB7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xA0"],
        ["\x47\xEB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xA1"],
        ["\x4E\x5E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xA2"],
        ["\x4B\xCC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xA3"],
        ["\x48\xEC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xA4"],
        ["\x45\xE4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xA5"],
        ["\x46\x6D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xA6"],
        ["\x49\x7F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xA7"],
        ["\x48\xAE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xA8"],
        ["\x53\xC2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xA9"],
        ["\x55\xDB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xAA"],
        ["\x4D\x98",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xAB"],
        ["\x4F\x9B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xAC"],
        ["\x4D\x50",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xAD"],
        ["\x4E\xAB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xAE"],
        ["\x54\xF7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xAF"],
        ["\x45\x50",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xB0"],
        ["\x48\xC0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xB1"],
        ["\x4F\x96",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xB2"],
        ["\x51\xA1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xB3"],
        ["\x50\xF1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xB4"],
        ["\x47\xE8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xB5"],
        ["\x46\x54",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xB6"],
        ["\x55\x50",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xB7"],
        ["\x46\xA2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xB8"],
        ["\x4A\x73",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xB9"],
        ["\x53\xD0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xBA"],
        ["\x4A\xD8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xBB"],
        ["\x4C\x97",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xBC"],
        ["\x4A\xDB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xBD"],
        ["\x4A\x4F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xBE"],
        ["\x47\xD3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xBF"],
        ["\x55\xD4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x80"],
        ["\x50\xCF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x81"],
        ["\x4A\xFD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x82"],
        ["\x54\xA7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x83"],
        ["\x4D\xA7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x84"],
        ["\x54\xC4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x85"],
        ["\x4D\x5A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x86"],
        ["\x4A\x84",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x87"],
        ["\x4F\x73",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x88"],
        ["\x53\x5C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x89"],
        ["\x55\xF1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x8A"],
        ["\x4F\xDD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x8B"],
        ["\x4E\x65",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x8C"],
        ["\x49\xF2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x8D"],
        ["\x55\x98",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x8E"],
        ["\x4C\xCF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x8F"],
        ["\x54\xF8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x90"],
        ["\x51\x7A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x91"],
        ["\x50\xB0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x92"],
        ["\x4C\x56",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x93"],
        ["\x4E\x63",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x94"],
        ["\x45\xE6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x95"],
        ["\x48\x46",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x96"],
        ["\x45\x8E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x97"],
        ["\x55\xA9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x98"],
        ["\x54\x9E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x99"],
        ["\x51\xAD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x9A"],
        ["\x52\xF9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x9B"],
        ["\x4B\x96",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x9C"],
        ["\x4F\xC0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x9D"],
        ["\x4B\x48",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x9E"],
        ["\x4D\x93",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x9F"],
        ["\x50\xA1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xA0"],
        ["\x48\x59",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xA1"],
        ["\x50\xDD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xA2"],
        ["\x45\x59",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xA3"],
        ["\x4A\xDF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xA4"],
        ["\x4C\xB1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xA5"],
        ["\x49\x5A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xA6"],
        ["\x55\x5E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xA7"],
        ["\x45\x42",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xA8"],
        ["\x4A\x86",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xA9"],
        ["\x50\xE1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xAA"],
        ["\x64\xF6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xAB"],
        ["\x4E\xCB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xAC"],
        ["\x53\x9E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xAD"],
        ["\x4A\x42",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xAE"],
        ["\x51\xB6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xAF"],
        ["\x51\xD9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xB0"],
        ["\x45\x62",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xB1"],
        ["\x4A\x98",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xB2"],
        ["\x46\x65",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xB3"],
        ["\x4B\xF8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xB4"],
        ["\x4C\xC6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xB5"],
        ["\x4F\xDF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xB6"],
        ["\x4A\x55",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xB7"],
        ["\x50\x43",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xB8"],
        ["\x4B\xD7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xB9"],
        ["\x4A\x7E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xBA"],
        ["\x50\x7E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xBB"],
        ["\x50\xFA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xBC"],
        ["\x4F\x89",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xBD"],
        ["\x4F\xA9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xBE"],
        ["\x54\x4E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xBF"],
        ["\x4F\xD0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x80"],
        ["\x47\xD5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x81"],
        ["\x45\x60",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x82"],
        ["\x4A\xAE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x83"],
        ["\x54\xC0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x84"],
        ["\x53\x48",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x85"],
        ["\x49\xD5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x86"],
        ["\x4B\xF7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x87"],
        ["\x4B\x9F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x88"],
        ["\x55\x64",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x89"],
        ["\x45\xD8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x8A"],
        ["\x4D\xF4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x8B"],
        ["\x51\x90",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x8C"],
        ["\x4B\xCD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x8D"],
        ["\x4A\xCE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x8E"],
        ["\x49\xE2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x8F"],
        ["\x47\x4F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x90"],
        ["\x4C\xB3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x91"],
        ["\x53\x5F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x92"],
        ["\x48\x45",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x93"],
        ["\x53\xEB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x94"],
        ["\x55\xA2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x95"],
        ["\x4E\x7D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x96"],
        ["\x4E\xE3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x97"],
        ["\x4E\x62",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x98"],
        ["\x4B\xFA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x99"],
        ["\x52\x80",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x9A"],
        ["\x46\xCA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x9B"],
        ["\x4A\x72",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x9C"],
        ["\x52\x9F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x9D"],
        ["\x4A\xBE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x9E"],
        ["\x4E\xCC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x9F"],
        ["\x55\x79",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xA0"],
        ["\x54\x42",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xA1"],
        ["\x46\x64",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xA2"],
        ["\x4C\xE1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xA3"],
        ["\x4B\xC7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xA4"],
        ["\x4E\xE2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xA5"],
        ["\x4C\xFA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xA6"],
        ["\x4B\x8A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xA7"],
        ["\x4C\x63",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xA8"],
        ["\x53\xBA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xA9"],
        ["\x55\x6F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xAA"],
        ["\x4A\xB2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xAB"],
        ["\x50\x4E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xAC"],
        ["\x4E\xF4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xAD"],
        ["\x47\xF3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xAE"],
        ["\x4A\xC4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xAF"],
        ["\x4D\xAC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xB0"],
        ["\x4D\x80",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xB1"],
        ["\x47\x98",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xB2"],
        ["\x52\xB3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xB3"],
        ["\x54\xEA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xB4"],
        ["\x54\xD6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xB5"],
        ["\x49\x74",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xB6"],
        ["\x47\x75",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xB7"],
        ["\x4F\x4F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xB8"],
        ["\x55\xC3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xB9"],
        ["\x4F\xCA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xBA"],
        ["\x63\x4B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xBB"],
        ["\x50\x8F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xBC"],
        ["\x55\xC9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xBD"],
        ["\x49\x4A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xBE"],
        ["\x49\xA6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xBF"],
        ["\x54\x81",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x80"],
        ["\x45\xF6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x81"],
        ["\x4F\xBA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x82"],
        ["\x49\x80",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x83"],
        ["\x4D\xB8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x84"],
        ["\x46\x59",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x85"],
        ["\x4E\xE0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x86"],
        ["\x4C\x4B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x87"],
        ["\x4B\x87",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x88"],
        ["\x4A\x92",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x89"],
        ["\x49\xEF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x8A"],
        ["\x52\xA6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x8B"],
        ["\x50\x8E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x8C"],
        ["\x4A\xD9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x8D"],
        ["\x52\xE6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x8E"],
        ["\x54\xB3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x8F"],
        ["\x55\xE5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x90"],
        ["\x4A\xE0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x91"],
        ["\x4B\xB6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x92"],
        ["\x4A\xFB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x93"],
        ["\x52\xBF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x94"],
        ["\x50\x5C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x95"],
        ["\x4B\x41",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x96"],
        ["\x4D\x9B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x97"],
        ["\x51\xC5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x98"],
        ["\x48\xDE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x99"],
        ["\x4E\x50",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x9A"],
        ["\x47\x8B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x9B"],
        ["\x49\xFE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x9C"],
        ["\x45\x48",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x9D"],
        ["\x4E\xA8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x9E"],
        ["\x54\xFA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x9F"],
        ["\x46\x4B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xA0"],
        ["\x51\xFA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xA1"],
        ["\x4C\xF6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xA2"],
        ["\x50\xF6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xA3"],
        ["\x4F\x82",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xA4"],
        ["\x4A\x85",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xA5"],
        ["\x52\xF5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xA6"],
        ["\x51\x72",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xA7"],
        ["\x4D\x95",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xA8"],
        ["\x55\x82",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xA9"],
        ["\x4F\x6F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xAA"],
        ["\x55\xC2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xAB"],
        ["\x4E\xD5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xAC"],
        ["\x49\xC9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xAD"],
        ["\x49\x5C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xAE"],
        ["\x47\x90",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xAF"],
        ["\x47\xF9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xB0"],
        ["\x55\xB2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xB1"],
        ["\x4F\x75",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xB2"],
        ["\x4D\xC8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xB3"],
        ["\x52\xE4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xB4"],
        ["\x46\xB4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xB5"],
        ["\x55\x6E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xB6"],
        ["\x50\x5E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xB7"],
        ["\x4A\xBD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xB8"],
        ["\x4C\xA7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xB9"],
        ["\x50\x66",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xBA"],
        ["\x4E\xDC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xBB"],
        ["\x47\x59",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xBC"],
        ["\x49\x56",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xBD"],
        ["\x4F\xF6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xBE"],
        ["\x4A\x5D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xBF"],
        ["\x49\xE8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x80"],
        ["\x53\x46",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x81"],
        ["\x54\xA0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x82"],
        ["\x55\x57",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x83"],
        ["\x46\xB5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x84"],
        ["\x52\xA8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x85"],
        ["\x4C\xB6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x86"],
        ["\x48\xB9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x87"],
        ["\x48\x90",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x88"],
        ["\x4B\x9C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x89"],
        ["\x52\xF7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x8A"],
        ["\x53\xA5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x8B"],
        ["\x55\xED",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x8C"],
        ["\x53\xAD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x8D"],
        ["\x4C\x4F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x8E"],
        ["\x51\xA2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x8F"],
        ["\x55\x8D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x90"],
        ["\x47\x72",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x91"],
        ["\x4C\x9D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x92"],
        ["\x50\xAD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x93"],
        ["\x4C\x76",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x94"],
        ["\x4F\xA6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x95"],
        ["\x4B\x80",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x96"],
        ["\x47\x4E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x97"],
        ["\x51\xFD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x98"],
        ["\x4D\x97",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x99"],
        ["\x49\xDA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x9A"],
        ["\x51\x7B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x9B"],
        ["\x4C\x70",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x9C"],
        ["\x53\x7D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x9D"],
        ["\x55\xA5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x9E"],
        ["\x49\x7B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x9F"],
        ["\x4B\x8D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xA0"],
        ["\x55\xF2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xA1"],
        ["\x46\xD0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xA2"],
        ["\x4C\xC4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xA3"],
        ["\x48\xE1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xA4"],
        ["\x48\x8A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xA5"],
        ["\x49\x4F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xA6"],
        ["\x51\xAB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xA7"],
        ["\x46\xAC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xA8"],
        ["\x45\xC8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xA9"],
        ["\x4B\x5D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xAA"],
        ["\x52\x5E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xAB"],
        ["\x53\xD7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xAC"],
        ["\x52\xA3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xAD"],
        ["\x52\xBC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xAE"],
        ["\x45\x7D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xAF"],
        ["\x4C\xFD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xB0"],
        ["\x52\xD9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xB1"],
        ["\x50\x87",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xB2"],
        ["\x4F\xD1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xB3"],
        ["\x4E\xA0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xB4"],
        ["\x50\x9D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xB5"],
        ["\x45\xE1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xB6"],
        ["\x50\x60",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xB7"],
        ["\x48\xCC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xB8"],
        ["\x52\x6A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xB9"],
        ["\x52\xE0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xBA"],
        ["\x47\xCA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xBB"],
        ["\x55\x9A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xBC"],
        ["\x4A\xC7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xBD"],
        ["\x55\xAC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xBE"],
        ["\x50\x46",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xBF"],
        ["\x4A\xB3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x80"],
        ["\x48\x55",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x81"],
        ["\x4F\xB5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x82"],
        ["\x45\x4B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x83"],
        ["\x55\xA1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x84"],
        ["\x4D\xB1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x85"],
        ["\x51\x59",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x86"],
        ["\x49\x66",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x87"],
        ["\x4C\xA4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x88"],
        ["\x4F\xBC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x89"],
        ["\x54\x52",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x8A"],
        ["\x4D\xBF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x8B"],
        ["\x46\xC0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x8C"],
        ["\x49\xFD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x8D"],
        ["\x55\x93",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x8E"],
        ["\x55\xAF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x8F"],
        ["\x4B\xCF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x90"],
        ["\x49\xBF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x91"],
        ["\x4D\xBA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x92"],
        ["\x4A\xB8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x93"],
        ["\x53\xF0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x94"],
        ["\x55\xBE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x95"],
        ["\x52\x59",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x96"],
        ["\x4E\x66",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x97"],
        ["\x54\x6E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x98"],
        ["\x45\xD0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x99"],
        ["\x4E\x88",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x9A"],
        ["\x51\x9D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x9B"],
        ["\x45\xEA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x9C"],
        ["\x55\xD1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x9D"],
        ["\x4D\xA3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x9E"],
        ["\x50\xD7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x9F"],
        ["\x53\xAB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xA0"],
        ["\x46\x47",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xA1"],
        ["\x4C\xD4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xA2"],
        ["\x46\xAF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xA3"],
        ["\x47\x5D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xA4"],
        ["\x51\x7E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xA5"],
        ["\x45\x73",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xA6"],
        ["\x49\x6F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xA7"],
        ["\x45\xAC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xA8"],
        ["\x48\x78",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xA9"],
        ["\x47\x6B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xAA"],
        ["\x45\x51",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xAB"],
        ["\x4E\xF0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xAC"],
        ["\x4D\x7A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xAD"],
        ["\x49\x51",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xAE"],
        ["\x51\xC2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xAF"],
        ["\x49\xF8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xB0"],
        ["\x4A\x8C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xB1"],
        ["\x45\xCC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xB2"],
        ["\x4F\xD9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xB3"],
        ["\x4D\x62",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xB4"],
        ["\x51\x91",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xB5"],
        ["\x4E\xBD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xB6"],
        ["\x4E\x4F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xB7"],
        ["\x49\xC8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xB8"],
        ["\x4F\xA7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xB9"],
        ["\x50\xEE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xBA"],
        ["\x47\x86",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xBB"],
        ["\x4B\x8C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xBC"],
        ["\x53\xB9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xBD"],
        ["\x51\xE1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xBE"],
        ["\x45\xB1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xBF"],
        ["\x4A\x63",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x80"],
        ["\x55\x47",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x81"],
        ["\x51\xD3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x82"],
        ["\x45\x95",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x83"],
        ["\x4D\x76",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x84"],
        ["\x52\x95",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x85"],
        ["\x47\xE7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x86"],
        ["\x50\xE0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x87"],
        ["\x54\x91",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x88"],
        ["\x4A\x83",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x89"],
        ["\x4B\x4E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x8A"],
        ["\x4A\x70",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x8B"],
        ["\x4A\x5E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x8C"],
        ["\x47\xD4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x8D"],
        ["\x45\x8B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x8E"],
        ["\x4C\xA0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x8F"],
        ["\x4B\x51",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x90"],
        ["\x4D\xF2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x91"],
        ["\x48\xEA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x92"],
        ["\x54\xAC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x93"],
        ["\x49\x81",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x94"],
        ["\x4E\xAA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x95"],
        ["\x4B\xE5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x96"],
        ["\x46\x52",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x97"],
        ["\x52\x8D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x98"],
        ["\x45\xB4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x99"],
        ["\x53\xE5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x9A"],
        ["\x4E\x6D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x9B"],
        ["\x52\x89",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x9C"],
        ["\x4F\xFC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x9D"],
        ["\x54\xB7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x9E"],
        ["\x54\x4F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x9F"],
        ["\x4E\xDD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xA0"],
        ["\x48\x9E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xA1"],
        ["\x54\x92",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xA2"],
        ["\x4F\xF3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xA3"],
        ["\x4F\x90",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xA4"],
        ["\x45\xCA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xA5"],
        ["\x48\xBB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xA6"],
        ["\x50\xC5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xA7"],
        ["\x4B\x94",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xA8"],
        ["\x46\x49",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xA9"],
        ["\x53\x9F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xAA"],
        ["\x4E\x7F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xAB"],
        ["\x45\x8D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xAC"],
        ["\x50\xCD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xAD"],
        ["\x4A\x7F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xAE"],
        ["\x48\x7C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xAF"],
        ["\x54\xD1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xB0"],
        ["\x4B\x7D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xB1"],
        ["\x51\x57",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xB2"],
        ["\x46\x6F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xB3"],
        ["\x4C\xD9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xB4"],
        ["\x55\x78",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xB5"],
        ["\x4B\x95",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xB6"],
        ["\x53\x7E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xB7"],
        ["\x4D\xF8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xB8"],
        ["\x46\xDD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xB9"],
        ["\x55\x72",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xBA"],
        ["\x55\x6C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xBB"],
        ["\x55\x9B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xBC"],
        ["\x50\x49",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xBD"],
        ["\x47\x6F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xBE"],
        ["\x47\x67",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xBF"],
        ["\x4F\xB6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x80"],
        ["\x48\x4E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x81"],
        ["\x45\xD5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x82"],
        ["\x48\xD6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x83"],
        ["\x50\x5D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x84"],
        ["\x4B\x4C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x85"],
        ["\x48\xCE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x86"],
        ["\x54\x9F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x87"],
        ["\x4B\x47",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x88"],
        ["\x54\x8B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x89"],
        ["\x45\xAA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x8A"],
        ["\x4E\x5B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x8B"],
        ["\x53\x63",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x8C"],
        ["\x53\xCF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x8D"],
        ["\x4C\x41",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x8E"],
        ["\x47\xD8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x8F"],
        ["\x4D\x58",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x90"],
        ["\x49\x6A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x91"],
        ["\x4A\x68",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x92"],
        ["\x48\xD4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x93"],
        ["\x4A\xE1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x94"],
        ["\x4E\xBE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x95"],
        ["\x52\xE3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x96"],
        ["\x51\x61",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x97"],
        ["\x4A\xFE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x98"],
        ["\x49\x69",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x99"],
        ["\x4F\x4C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x9A"],
        ["\x51\x6A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x9B"],
        ["\x55\x69",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x9C"],
        ["\x50\xF9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x9D"],
        ["\x4A\xA8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x9E"],
        ["\x50\x73",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x9F"],
        ["\x49\xB8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xA0"],
        ["\x4D\xB2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xA1"],
        ["\x49\x4D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xA2"],
        ["\x48\xFE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xA3"],
        ["\x4A\xAC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xA4"],
        ["\x4F\x5F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xA5"],
        ["\x55\x4F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xA6"],
        ["\x4C\x86",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xA7"],
        ["\x52\x85",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xA8"],
        ["\x48\xAF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xA9"],
        ["\x45\xCD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xAA"],
        ["\x4B\xC4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xAB"],
        ["\x46\x4A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xAC"],
        ["\x4E\x87",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xAD"],
        ["\x55\x87",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xAE"],
        ["\x4C\xC2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xAF"],
        ["\x49\xE4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xB0"],
        ["\x50\xB6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xB1"],
        ["\x46\x83",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xB2"],
        ["\x50\xDB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xB3"],
        ["\x50\x88",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xB4"],
        ["\x4E\xCD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xB5"],
        ["\x51\xBA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xB6"],
        ["\x4A\x71",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xB7"],
        ["\x46\x48",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xB8"],
        ["\x46\xC5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xB9"],
        ["\x54\x49",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xBA"],
        ["\x4D\x49",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xBB"],
        ["\x4E\xA6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xBC"],
        ["\x51\x8A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xBD"],
        ["\x4F\x6C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xBE"],
        ["\x4C\xCE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xBF"],
        ["\x4E\xE7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x80"],
        ["\x51\x99",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x81"],
        ["\x4C\x55",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x82"],
        ["\x50\xEC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x83"],
        ["\x4C\x85",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x84"],
        ["\x4C\x45",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x85"],
        ["\x4E\xA3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x86"],
        ["\x47\xDC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x87"],
        ["\x4C\xB2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x88"],
        ["\x47\xBB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x89"],
        ["\x50\x4A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x8A"],
        ["\x4B\x5A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x8B"],
        ["\x4F\x8F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x8C"],
        ["\x48\x77",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x8D"],
        ["\x4C\xFB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x8E"],
        ["\x4E\xF6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x8F"],
        ["\x4F\x4D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x90"],
        ["\x50\x64",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x91"],
        ["\x48\x72",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x92"],
        ["\x51\x83",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x93"],
        ["\x47\xBC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x94"],
        ["\x53\xE1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x95"],
        ["\x4E\xB3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x96"],
        ["\x45\x5A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x97"],
        ["\x4A\xBB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x98"],
        ["\x51\xC0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x99"],
        ["\x4A\xFC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x9A"],
        ["\x4E\xC7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x9B"],
        ["\x4E\xA2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x9C"],
        ["\x48\x7B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x9D"],
        ["\x4A\x96",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x9E"],
        ["\x52\xBE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x9F"],
        ["\x53\x4A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xA0"],
        ["\x54\xB1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xA1"],
        ["\x50\x75",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xA2"],
        ["\x4F\x42",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xA3"],
        ["\x46\x9D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xA4"],
        ["\x49\x6B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xA5"],
        ["\x52\x84",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xA6"],
        ["\x45\x66",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xA7"],
        ["\x51\xF6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xA8"],
        ["\x4D\xE1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xA9"],
        ["\x50\x57",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xAA"],
        ["\x48\xD1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xAB"],
        ["\x49\xB4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xAC"],
        ["\x4D\xE2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xAD"],
        ["\x48\xA7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xAE"],
        ["\x4E\xAC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xAF"],
        ["\x4B\xDC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xB0"],
        ["\x55\x9D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xB1"],
        ["\x49\xD9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xB2"],
        ["\x49\xF5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xB3"],
        ["\x55\xF0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xB4"],
        ["\x68\x81",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xB5"],
        ["\x4C\xCA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xB6"],
        ["\x4D\x8A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xB7"],
        ["\x4F\x78",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xB8"],
        ["\x55\xCE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xB9"],
        ["\x50\x54",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xBA"],
        ["\x53\xC6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xBB"],
        ["\x4D\x88",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xBC"],
        ["\x4F\xFA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xBD"],
        ["\x4B\x4A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xBE"],
        ["\x48\xF5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xBF"],
        ["\x51\xE0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x80"],
        ["\x47\x46",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x81"],
        ["\x53\xEC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x82"],
        ["\x49\xCD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x83"],
        ["\x56\x75",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x84"],
        ["\x4D\x9A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x85"],
        ["\x4E\xEA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x86"],
        ["\x45\x4D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x87"],
        ["\x4D\xDB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x88"],
        ["\x47\x5B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x89"],
        ["\x4F\x6E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x8A"],
        ["\x55\x7B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x8B"],
        ["\x47\x7F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x8C"],
        ["\x49\xC6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x8D"],
        ["\x4D\xB4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x8E"],
        ["\x4A\xE6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x8F"],
        ["\x4C\xCC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x90"],
        ["\x50\xD5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x91"],
        ["\x4A\x56",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x92"],
        ["\x53\xA1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x93"],
        ["\x4C\x88",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x94"],
        ["\x4F\x9A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x95"],
        ["\x47\xFA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x96"],
        ["\x50\x79",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x97"],
        ["\x4A\x66",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x98"],
        ["\x53\xC9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x99"],
        ["\x47\x56",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x9A"],
        ["\x4E\x6A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x9B"],
        ["\x46\xED",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x9C"],
        ["\x4B\x8B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x9D"],
        ["\x47\x5F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x9E"],
        ["\x4A\xAF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x9F"],
        ["\x50\xED",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xA0"],
        ["\x4E\x48",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xA1"],
        ["\x55\x7E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xA2"],
        ["\x4D\xFD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xA3"],
        ["\x54\x54",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xA4"],
        ["\x4B\x54",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xA5"],
        ["\x54\x67",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xA6"],
        ["\x45\xF3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xA7"],
        ["\x49\xB0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xA8"],
        ["\x45\xA6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xA9"],
        ["\x4B\x84",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xAA"],
        ["\x4E\x58",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xAB"],
        ["\x4D\xDC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xAC"],
        ["\x4B\x70",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xAD"],
        ["\x55\x8C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xAE"],
        ["\x55\xB7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xAF"],
        ["\x4E\xE6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xB0"],
        ["\x4B\x56",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xB1"],
        ["\x55\xCA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xB2"],
        ["\x48\x9D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xB3"],
        ["\x55\x6B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xB4"],
        ["\x46\x91",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xB5"],
        ["\x55\x5F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xB6"],
        ["\x55\xF5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xB7"],
        ["\x48\x64",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xB8"],
        ["\x46\x46",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xB9"],
        ["\x55\x4D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xBA"],
        ["\x4F\x83",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xBB"],
        ["\x46\xE2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xBC"],
        ["\x4A\x51",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xBD"],
        ["\x50\x80",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xBE"],
        ["\x4A\x53",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xBF"],
        ["\x4F\xEC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x80"],
        ["\x50\x95",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x81"],
        ["\x54\xBD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x82"],
        ["\x45\x6C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x83"],
        ["\x4D\xBC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x84"],
        ["\x46\x75",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x85"],
        ["\x51\xA6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x86"],
        ["\x52\x97",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x87"],
        ["\x50\xBF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x88"],
        ["\x53\xAE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x89"],
        ["\x4C\x44",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x8A"],
        ["\x4F\xF0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x8B"],
        ["\x4D\xEF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x8C"],
        ["\x46\xE4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x8D"],
        ["\x55\x54",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x8E"],
        ["\x4C\xF9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x8F"],
        ["\x46\xAA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x90"],
        ["\x4F\x5B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x91"],
        ["\x47\x49",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x92"],
        ["\x51\x46",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x93"],
        ["\x48\xC8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x94"],
        ["\x50\x96",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x95"],
        ["\x4E\x99",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x96"],
        ["\x45\x69",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x97"],
        ["\x47\xE6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x98"],
        ["\x46\xC1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x99"],
        ["\x53\x52",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x9A"],
        ["\x49\x5D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x9B"],
        ["\x47\xBD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x9C"],
        ["\x46\xE1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x9D"],
        ["\x4B\xAD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x9E"],
        ["\x4C\xA1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x9F"],
        ["\x48\xC3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xA0"],
        ["\x46\xEA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xA1"],
        ["\x62\xB3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xA2"],
        ["\x52\x41",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xA3"],
        ["\x50\x98",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xA4"],
        ["\x53\xC8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xA5"],
        ["\x46\x5C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xA6"],
        ["\x53\xAA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xA7"],
        ["\x4E\x9C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xA8"],
        ["\x46\x93",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xA9"],
        ["\x4B\xE0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xAA"],
        ["\x4C\xE6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xAB"],
        ["\x47\xDA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xAC"],
        ["\x46\x9C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xAD"],
        ["\x46\xD4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xAE"],
        ["\x4F\x7A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xAF"],
        ["\x52\x5F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xB0"],
        ["\x4D\xD8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xB1"],
        ["\x50\x7C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xB2"],
        ["\x4C\xF2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xB3"],
        ["\x46\x85",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xB4"],
        ["\x4E\xE1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xB5"],
        ["\x4F\xBD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xB6"],
        ["\x4F\x7D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xB7"],
        ["\x50\x4F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xB8"],
        ["\x53\xDD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xB9"],
        ["\x46\x7C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xBA"],
        ["\x48\x8C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xBB"],
        ["\x46\xF8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xBC"],
        ["\x4A\xCB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xBD"],
        ["\x4A\x8B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xBE"],
        ["\x4C\x92",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xBF"],
        ["\x4C\xB7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x80"],
        ["\x45\x70",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x81"],
        ["\x48\xC2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x82"],
        ["\x4A\xC3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x83"],
        ["\x47\xC2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x84"],
        ["\x49\xC1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x85"],
        ["\x47\x89",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x86"],
        ["\x4D\x8C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x87"],
        ["\x50\x6C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x88"],
        ["\x4D\x4A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x89"],
        ["\x54\xDA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x8A"],
        ["\x4D\xAF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x8B"],
        ["\x53\xD1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x8C"],
        ["\x48\x89",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x8D"],
        ["\x4C\x5D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x8E"],
        ["\x4C\x46",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x8F"],
        ["\x4F\x7E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x90"],
        ["\x51\x4E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x91"],
        ["\x4B\xFE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x92"],
        ["\x51\xD7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x93"],
        ["\x48\x48",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x94"],
        ["\x45\xDA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x95"],
        ["\x48\xBE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x96"],
        ["\x52\x9D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x97"],
        ["\x45\xB6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x98"],
        ["\x49\xA7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x99"],
        ["\x4A\xD1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x9A"],
        ["\x52\xA0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x9B"],
        ["\x45\xF9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x9C"],
        ["\x50\x83",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x9D"],
        ["\x46\x55",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x9E"],
        ["\x4D\x7D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x9F"],
        ["\x4C\xA8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xA0"],
        ["\x68\x82",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xA1"],
        ["\x47\xBF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xA2"],
        ["\x49\x79",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xA3"],
        ["\x53\xF4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xA4"],
        ["\x4D\x66",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xA5"],
        ["\x4B\xF6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xA6"],
        ["\x55\xD9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xA7"],
        ["\x4B\x7E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xA8"],
        ["\x4D\x9C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xA9"],
        ["\x4D\xB5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xAA"],
        ["\x4A\x88",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xAB"],
        ["\x4D\xFA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xAC"],
        ["\x51\xD6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xAD"],
        ["\x4F\x43",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xAE"],
        ["\x46\x76",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xAF"],
        ["\x52\xC9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xB0"],
        ["\x4A\x7A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xB1"],
        ["\x4B\xD6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xB2"],
        ["\x54\x50",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xB3"],
        ["\x4C\xE7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xB4"],
        ["\x47\xF2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xB5"],
        ["\x50\xBD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xB6"],
        ["\x4B\xBF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xB7"],
        ["\x4C\xF5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xB8"],
        ["\x49\x8C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xB9"],
        ["\x4E\xDE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xBA"],
        ["\x55\xA3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xBB"],
        ["\x4E\xED",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xBC"],
        ["\x4C\xA6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xBD"],
        ["\x4E\xD0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xBE"],
        ["\x45\xBC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xBF"],
        ["\x50\xC6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x80"],
        ["\x4C\xA2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x81"],
        ["\x4E\x51",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x82"],
        ["\x48\x58",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x83"],
        ["\x45\xEB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x84"],
        ["\x52\x8C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x85"],
        ["\x51\x74",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x86"],
        ["\x49\xA4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x87"],
        ["\x54\x4D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x88"],
        ["\x47\x6C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x89"],
        ["\x49\x97",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x8A"],
        ["\x49\x61",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x8B"],
        ["\x49\x91",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x8C"],
        ["\x47\x83",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x8D"],
        ["\x45\xDD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x8E"],
        ["\x55\x9F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x8F"],
        ["\x55\xE6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x90"],
        ["\x4C\xF0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x91"],
        ["\x51\x85",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x92"],
        ["\x46\xFC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x93"],
        ["\x4D\xC4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x94"],
        ["\x50\xF7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x95"],
        ["\x47\xAB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x96"],
        ["\x49\x84",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x97"],
        ["\x4C\xA9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x98"],
        ["\x46\x5D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x99"],
        ["\x49\xE7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x9A"],
        ["\x48\xCA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x9B"],
        ["\x55\x7C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x9C"],
        ["\x4C\x49",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x9D"],
        ["\x4A\xCF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x9E"],
        ["\x52\x50",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x9F"],
        ["\x4B\xB1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xA0"],
        ["\x49\x9C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xA1"],
        ["\x4D\x82",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xA2"],
        ["\x48\x83",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xA3"],
        ["\x53\x44",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xA4"],
        ["\x4C\x7A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xA5"],
        ["\x46\x4E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xA6"],
        ["\x4E\x44",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xA7"],
        ["\x4E\x74",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xA8"],
        ["\x4E\x9D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xA9"],
        ["\x4B\xB7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xAA"],
        ["\x52\x7D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xAB"],
        ["\x52\x96",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xAC"],
        ["\x4E\xC5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xAD"],
        ["\x45\xC4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xAE"],
        ["\x51\x81",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xAF"],
        ["\x52\x6B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xB0"],
        ["\x47\xB5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xB1"],
        ["\x50\xC7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xB2"],
        ["\x4A\xCD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xB3"],
        ["\x45\xF7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xB4"],
        ["\x48\xA5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xB5"],
        ["\x4D\x51",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xB6"],
        ["\x4F\x55",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xB7"],
        ["\x45\xA2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xB8"],
        ["\x52\xC7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xB9"],
        ["\x4A\x79",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xBA"],
        ["\x54\x53",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xBB"],
        ["\x4C\xD0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xBC"],
        ["\x48\xB7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xBD"],
        ["\x4C\xE0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xBE"],
        ["\x55\x4C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xBF"],
        ["\x51\x9B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x80"],
        ["\x50\x8C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x81"],
        ["\x4B\xEB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x82"],
        ["\x4D\xDA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x83"],
        ["\x51\x48",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x84"],
        ["\x46\xBA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x85"],
        ["\x49\xC3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x86"],
        ["\x54\x4A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x87"],
        ["\x4A\x46",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x88"],
        ["\x48\xFC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x89"],
        ["\x4D\x92",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x8A"],
        ["\x4C\xE8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x8B"],
        ["\x50\x9F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x8C"],
        ["\x4A\xF9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x8D"],
        ["\x49\x58",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x8E"],
        ["\x55\x59",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x8F"],
        ["\x45\xAE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x90"],
        ["\x55\x45",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x91"],
        ["\x50\x69",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x92"],
        ["\x4F\x4B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x93"],
        ["\x4C\xF3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x94"],
        ["\x4C\x80",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x95"],
        ["\x50\xCC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x96"],
        ["\x49\x55",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x97"],
        ["\x4B\xB4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x98"],
        ["\x4E\x68",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x99"],
        ["\x4D\xD1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x9A"],
        ["\x4F\x60",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x9B"],
        ["\x4E\xDB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x9C"],
        ["\x4B\xCA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x9D"],
        ["\x55\x5B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x9E"],
        ["\x54\xE0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x9F"],
        ["\x4C\x6F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xA0"],
        ["\x52\x70",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xA1"],
        ["\x48\x60",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xA2"],
        ["\x53\xCA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xA3"],
        ["\x4B\xF4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xA4"],
        ["\x47\x54",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xA5"],
        ["\x4F\xE6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xA6"],
        ["\x4B\x50",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xA7"],
        ["\x51\xF4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xA8"],
        ["\x55\x86",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xA9"],
        ["\x49\x7D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xAA"],
        ["\x55\xF8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xAB"],
        ["\x47\x84",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xAC"],
        ["\x4B\xC6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xAD"],
        ["\x48\xA9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xAE"],
        ["\x50\xF8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xAF"],
        ["\x4E\xA7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xB0"],
        ["\x54\xBF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xB1"],
        ["\x48\x6E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xB2"],
        ["\x52\xBA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xB3"],
        ["\x55\xC7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xB4"],
        ["\x4A\x9D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xB5"],
        ["\x50\xC4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xB6"],
        ["\x55\xC4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xB7"],
        ["\x50\x6F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xB8"],
        ["\x54\x44",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xB9"],
        ["\x49\x85",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xBA"],
        ["\x53\xE4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xBB"],
        ["\x52\xA1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xBC"],
        ["\x45\x6E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xBD"],
        ["\x45\x46",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xBE"],
        ["\x51\x9E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xBF"],
        ["\x50\xAE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x80"],
        ["\x55\x7F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x81"],
        ["\x48\x86",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x82"],
        ["\x48\xF3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x83"],
        ["\x4F\xF9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x84"],
        ["\x45\x7A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x85"],
        ["\x47\x50",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x86"],
        ["\x55\x8E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x87"],
        ["\x50\x67",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x88"],
        ["\x47\xE3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x89"],
        ["\x4E\x78",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x8A"],
        ["\x4F\xD2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x8B"],
        ["\x4B\xF1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x8C"],
        ["\x50\xE8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x8D"],
        ["\x4B\xE4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x8E"],
        ["\x52\x93",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x8F"],
        ["\x50\xD3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x90"],
        ["\x4F\xBB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x91"],
        ["\x50\xDE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x92"],
        ["\x54\x68",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x93"],
        ["\x4D\x6B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x94"],
        ["\x54\x5B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x95"],
        ["\x4C\xAF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x96"],
        ["\x56\x41",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x82"],
        ["\x56\x42",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x83"],
        ["\x56\x43",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x84"],
        ["\x56\x45",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x85"],
        ["\x56\x46",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x86"],
        ["\x56\x47",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x87"],
        ["\x54\xC8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x88"],
        ["\x56\x48",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x89"],
        ["\x56\x49",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x8A"],
        ["\x56\x4A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x8B"],
        ["\x56\x4B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x8C"],
        ["\x56\x4D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x8D"],
        ["\x56\x4E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x8E"],
        ["\x53\x55",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x8F"],
        ["\x56\x4F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x90"],
        ["\x61\xDB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x91"],
        ["\x56\x51",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x92"],
        ["\x56\x50",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x93"],
        ["\x56\x52",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x94"],
        ["\x51\x67",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x95"],
        ["\x56\x53",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x96"],
        ["\x56\x54",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x97"],
        ["\x56\x55",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x98"],
        ["\x56\x56",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x99"],
        ["\x56\x57",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x9A"],
        ["\x56\x58",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x9B"],
        ["\x56\x59",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x9C"],
        ["\x56\x5A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x9D"],
        ["\x56\x5B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x9E"],
        ["\x56\x5C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x9F"],
        ["\x56\x5E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xA0"],
        ["\x56\x5F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xA1"],
        ["\x56\x60",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xA2"],
        ["\x56\x61",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xA3"],
        ["\x53\x41",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xA4"],
        ["\x56\x63",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xA5"],
        ["\x56\x67",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xA6"],
        ["\x56\x68",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xA7"],
        ["\x56\x6F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xA8"],
        ["\x56\x69",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xA9"],
        ["\x56\x6B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xAA"],
        ["\x56\x6C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xAB"],
        ["\x51\xE2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xAC"],
        ["\x56\x72",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xAD"],
        ["\x56\x73",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xAE"],
        ["\x56\x76",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xAF"],
        ["\x56\x77",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xB0"],
        ["\x56\x79",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xB1"],
        ["\x56\x7A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xB2"],
        ["\x4F\x8D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xB3"],
        ["\x56\x7C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xB4"],
        ["\x56\x7D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xB5"],
        ["\x56\x7E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xB6"],
        ["\x52\x90",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xB7"],
        ["\x56\x7F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xB8"],
        ["\x53\xC4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xB9"],
        ["\x56\x80",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xBA"],
        ["\x56\x81",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xBB"],
        ["\x56\x82",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xBC"],
        ["\x56\x83",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xBD"],
        ["\x56\x84",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xBE"],
        ["\x56\x85",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xBF"],
        ["\x56\x87",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x80"],
        ["\x56\x88",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x81"],
        ["\x56\x89",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x82"],
        ["\x56\x8B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x83"],
        ["\x56\x8C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x84"],
        ["\x56\x8D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x85"],
        ["\x56\x8E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x86"],
        ["\x56\x8F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x87"],
        ["\x56\x64",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x88"],
        ["\x51\xF8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x89"],
        ["\x56\x90",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x8A"],
        ["\x56\x92",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x8B"],
        ["\x56\x93",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x8C"],
        ["\x56\x95",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x8D"],
        ["\x56\x96",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x8E"],
        ["\x56\x97",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x8F"],
        ["\x56\x99",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x90"],
        ["\x56\x9A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x91"],
        ["\x56\x9B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x92"],
        ["\x56\xAC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x93"],
        ["\x56\x9C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x94"],
        ["\x56\x9D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x95"],
        ["\x56\x9E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x96"],
        ["\x56\x9F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x97"],
        ["\x56\xA0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x98"],
        ["\x56\xA5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x99"],
        ["\x56\xA6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x9A"],
        ["\x56\xA7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x9B"],
        ["\x56\xA9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x9C"],
        ["\x56\xAA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x9D"],
        ["\x56\xAB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x9E"],
        ["\x56\xAD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x9F"],
        ["\x56\xAE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xA0"],
        ["\x56\xAF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xA1"],
        ["\x56\xB0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xA2"],
        ["\x56\xB1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xA3"],
        ["\x52\xD4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xA4"],
        ["\x56\xB3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xA5"],
        ["\x56\xB4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xA6"],
        ["\x56\xB6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xA7"],
        ["\x56\xB7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xA8"],
        ["\x56\xB8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xA9"],
        ["\x56\xB9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xAA"],
        ["\x56\xBA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xAB"],
        ["\x56\xBB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xAC"],
        ["\x56\xBC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xAD"],
        ["\x56\xBD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xAE"],
        ["\x56\xC1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xAF"],
        ["\x56\xBF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xB0"],
        ["\x56\xC0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xB1"],
        ["\x56\xBE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xB2"],
        ["\x56\xC2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xB3"],
        ["\x56\xC3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xB4"],
        ["\x56\xC4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xB5"],
        ["\x56\xC5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xB6"],
        ["\x56\xC6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xB7"],
        ["\x56\xC7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xB8"],
        ["\x56\xC8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xB9"],
        ["\x56\xCB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xBA"],
        ["\x56\xCA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xBB"],
        ["\x56\xCC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xBC"],
        ["\x56\xCD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xBD"],
        ["\x60\x5D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xBE"],
        ["\x56\xCF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xBF"],
        ["\x56\xD0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x80"],
        ["\x56\xD1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x81"],
        ["\x56\xD2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x82"],
        ["\x56\xD3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x83"],
        ["\x56\xD4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x84"],
        ["\x56\xD5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x85"],
        ["\x56\xD6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x86"],
        ["\x56\xD7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x87"],
        ["\x56\xD8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x88"],
        ["\x56\xD9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x89"],
        ["\x56\xDA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x8A"],
        ["\x56\xDB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x8B"],
        ["\x56\xDD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x8C"],
        ["\x56\xDE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x8D"],
        ["\x56\xDF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x8E"],
        ["\x56\xE0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x8F"],
        ["\x56\xE1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x90"],
        ["\x56\xE2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x91"],
        ["\x56\xE3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x92"],
        ["\x56\xE4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x93"],
        ["\x56\xE5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x94"],
        ["\x56\xE6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x95"],
        ["\x56\xE7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x96"],
        ["\x56\xE9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x97"],
        ["\x56\xEA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x98"],
        ["\x56\xEB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x99"],
        ["\x56\xEC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x9A"],
        ["\x56\xED",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x9B"],
        ["\x62\xD1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x9C"],
        ["\x56\xEE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x9D"],
        ["\x56\xF0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x9E"],
        ["\x56\xF1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x9F"],
        ["\x56\xF2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xA0"],
        ["\x56\xF3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xA1"],
        ["\x56\xF4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xA2"],
        ["\x56\xF5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xA3"],
        ["\x56\xF6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xA4"],
        ["\x54\xE3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xA5"],
        ["\x56\xF8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xA6"],
        ["\x56\xF9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xA7"],
        ["\x56\xFA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xA8"],
        ["\x56\xFB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xA9"],
        ["\x56\xFC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xAA"],
        ["\x57\x41",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xAB"],
        ["\x56\xFD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xAC"],
        ["\x56\xFE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xAD"],
        ["\x51\xAE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xAE"],
        ["\x57\x42",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xAF"],
        ["\x57\x43",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xB0"],
        ["\x57\x45",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xB1"],
        ["\x57\x47",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xB2"],
        ["\x57\x48",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xB3"],
        ["\x57\x46",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xB4"],
        ["\x57\x49",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xB5"],
        ["\x57\x4A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xB6"],
        ["\x57\x4B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xB7"],
        ["\x55\x80",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xB8"],
        ["\x57\x4D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xB9"],
        ["\x57\x44",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xBA"],
        ["\x57\x4C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xBB"],
        ["\x57\x4E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xBC"],
        ["\x64\xEC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xBD"],
        ["\x64\xED",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xBE"],
        ["\x57\x51",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xBF"],
        ["\x57\x52",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x80"],
        ["\x57\x53",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x81"],
        ["\x57\x54",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x82"],
        ["\x57\x55",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x83"],
        ["\x57\x57",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x84"],
        ["\x53\x92",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x85"],
        ["\x57\x59",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x86"],
        ["\x57\x5A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x87"],
        ["\x57\x5B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x88"],
        ["\x66\xDB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x89"],
        ["\x57\x5C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x8A"],
        ["\x57\x5D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x8B"],
        ["\x57\x5E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x8C"],
        ["\x57\x5F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x8D"],
        ["\x57\x60",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x8E"],
        ["\x57\x62",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x8F"],
        ["\x57\x64",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x90"],
        ["\x57\x65",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x91"],
        ["\x57\x66",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x92"],
        ["\x57\x67",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x93"],
        ["\x57\x68",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x94"],
        ["\x57\x69",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x95"],
        ["\x57\x6A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x96"],
        ["\x57\x6C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x97"],
        ["\x57\x6D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x98"],
        ["\x57\x6E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x99"],
        ["\x57\x6F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x9A"],
        ["\x57\x70",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x9B"],
        ["\x57\x71",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x9C"],
        ["\x57\x73",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x9D"],
        ["\x57\x72",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x9E"],
        ["\x57\x75",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x9F"],
        ["\x57\x74",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xA0"],
        ["\x57\x76",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xA1"],
        ["\x57\x77",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xA2"],
        ["\x57\x79",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xA3"],
        ["\x57\x7A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xA4"],
        ["\x57\x7B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xA5"],
        ["\x52\xC8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xA6"],
        ["\x57\x7E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xA7"],
        ["\x57\x7D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xA8"],
        ["\x57\x7F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xA9"],
        ["\x57\x81",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xAA"],
        ["\x57\x82",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xAB"],
        ["\x57\x83",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xAC"],
        ["\x57\x84",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xAD"],
        ["\x57\x85",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xAE"],
        ["\x57\x86",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xAF"],
        ["\x57\x88",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xB0"],
        ["\x57\x89",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xB1"],
        ["\x57\x8A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xB2"],
        ["\x66\x88",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xB3"],
        ["\x57\x8C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xB4"],
        ["\x57\x8D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xB5"],
        ["\x57\x8F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xB6"],
        ["\x57\x90",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xB7"],
        ["\x57\x91",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xB8"],
        ["\x57\x92",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xB9"],
        ["\x57\x93",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xBA"],
        ["\x57\x94",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xBB"],
        ["\x57\x95",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xBC"],
        ["\x57\x96",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xBD"],
        ["\x57\x97",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xBE"],
        ["\x57\x98",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xBF"],
        ["\x57\x99",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x80"],
        ["\x57\x9A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x81"],
        ["\x57\x9B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x82"],
        ["\x57\x9C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x83"],
        ["\x57\x9D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x84"],
        ["\x57\x9E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x85"],
        ["\x57\x9F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x86"],
        ["\x57\xA0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x87"],
        ["\x57\xA1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x88"],
        ["\x57\xA2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x89"],
        ["\x57\xA3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x8A"],
        ["\x57\xA4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x8B"],
        ["\x57\xA5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x8C"],
        ["\x57\xA6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x8D"],
        ["\x57\xA7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x8E"],
        ["\x57\xA8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x8F"],
        ["\x57\xAA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x90"],
        ["\x57\xAB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x91"],
        ["\x57\xAC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x92"],
        ["\x57\xAD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x93"],
        ["\x57\xAF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x94"],
        ["\x57\xB2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x95"],
        ["\x57\xB3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x96"],
        ["\x57\xB4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x97"],
        ["\x57\xB5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x98"],
        ["\x57\xB6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x99"],
        ["\x57\xB8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x9A"],
        ["\x57\xB9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x9B"],
        ["\x57\xBA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x9C"],
        ["\x57\xBB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x9D"],
        ["\x57\xBC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x9E"],
        ["\x57\xBE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x9F"],
        ["\x57\xB0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xA0"],
        ["\x57\xB7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xA1"],
        ["\x57\xBF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xA2"],
        ["\x57\xC1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xA3"],
        ["\x57\xC2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xA4"],
        ["\x57\xC3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xA5"],
        ["\x57\xC4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xA6"],
        ["\x57\xC5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xA7"],
        ["\x57\xC6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xA8"],
        ["\x54\x7C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xA9"],
        ["\x57\xC7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xAA"],
        ["\x57\xC8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xAB"],
        ["\x57\xC9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xAC"],
        ["\x57\xCA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xAD"],
        ["\x57\xCB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xAE"],
        ["\x57\xCC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xAF"],
        ["\x57\xCD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xB0"],
        ["\x57\xCE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xB1"],
        ["\x57\xCF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xB2"],
        ["\x57\xD0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xB3"],
        ["\x57\xD1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xB4"],
        ["\x57\xD2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xB5"],
        ["\x57\xD3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xB6"],
        ["\x57\xD4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xB7"],
        ["\x57\xD5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xB8"],
        ["\x57\xB1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xB9"],
        ["\x57\xD6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xBA"],
        ["\x57\xD7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xBB"],
        ["\x57\xD8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xBC"],
        ["\x57\xD9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xBD"],
        ["\x57\xDA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xBE"],
        ["\x57\xDB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xBF"],
        ["\x57\xDC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x80"],
        ["\x57\xDD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x81"],
        ["\x57\xDF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x82"],
        ["\x57\xE0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x83"],
        ["\x57\xE1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x84"],
        ["\x57\xE2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x85"],
        ["\x52\xA2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x86"],
        ["\x57\xE3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x87"],
        ["\x57\xE4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x88"],
        ["\x57\xE5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x89"],
        ["\x57\xE6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x8A"],
        ["\x57\xE7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x8B"],
        ["\x57\xE8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x8C"],
        ["\x57\xEA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x8D"],
        ["\x57\xEB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x8E"],
        ["\x57\xEC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x8F"],
        ["\x57\xED",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x90"],
        ["\x57\xEE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x91"],
        ["\x57\xEF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x92"],
        ["\x57\xE9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x93"],
        ["\x57\xF0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x94"],
        ["\x57\xF1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x95"],
        ["\x57\xFB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x96"],
        ["\x54\x7F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x97"],
        ["\x57\xF2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x98"],
        ["\x57\xF3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x99"],
        ["\x57\xF4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x9A"],
        ["\x57\xF5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x9B"],
        ["\x57\xF6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x9C"],
        ["\x57\xF8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x9D"],
        ["\x57\xF9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x9E"],
        ["\x57\xFA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x9F"],
        ["\x57\xF7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xA0"],
        ["\x57\xFE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xA1"],
        ["\x58\x41",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xA2"],
        ["\x58\x42",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xA3"],
        ["\x57\xFC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xA4"],
        ["\x57\xFD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xA5"],
        ["\x58\x43",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xA6"],
        ["\x58\x44",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xA7"],
        ["\x58\x45",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xA8"],
        ["\x58\x46",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xA9"],
        ["\x58\x48",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xAA"],
        ["\x58\x49",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xAB"],
        ["\x58\x4A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xAC"],
        ["\x58\x4B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xAD"],
        ["\x58\x4C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xAE"],
        ["\x58\x47",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xAF"],
        ["\x58\x4D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xB0"],
        ["\x58\x4F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xB1"],
        ["\x58\x4E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xB2"],
        ["\x58\x50",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xB3"],
        ["\x58\x51",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xB4"],
        ["\x58\x52",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xB5"],
        ["\x52\x66",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xB6"],
        ["\x58\x53",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xB7"],
        ["\x58\x54",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xB8"],
        ["\x58\x55",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xB9"],
        ["\x58\x56",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xBA"],
        ["\x51\xBD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xBB"],
        ["\x58\x57",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xBC"],
        ["\x54\xE7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xBD"],
        ["\x58\x59",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xBE"],
        ["\x58\x5A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xBF"],
        ["\x58\x58",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x80"],
        ["\x58\x5B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x81"],
        ["\x58\x5C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x82"],
        ["\x51\xD1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x83"],
        ["\x58\x5D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x84"],
        ["\x58\x5E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x85"],
        ["\x58\x5F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x86"],
        ["\x58\x61",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x87"],
        ["\x58\x62",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x88"],
        ["\x53\x98",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x89"],
        ["\x58\x71",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x8A"],
        ["\x58\x64",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x8B"],
        ["\x58\x65",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x8C"],
        ["\x58\x66",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x8D"],
        ["\x58\x67",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x8E"],
        ["\x58\x68",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x8F"],
        ["\x58\x69",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x90"],
        ["\x58\x6B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x91"],
        ["\x58\x6A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x92"],
        ["\x58\x6D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x93"],
        ["\x53\xCD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x94"],
        ["\x58\x6E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x95"],
        ["\x58\x6F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x96"],
        ["\x58\x72",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x97"],
        ["\x58\x74",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x98"],
        ["\x58\x75",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x99"],
        ["\x58\x78",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x9A"],
        ["\x58\x76",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x9B"],
        ["\x58\x79",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x9C"],
        ["\x58\x7A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x9D"],
        ["\x58\x7B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x9E"],
        ["\x53\xA7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x9F"],
        ["\x58\x86",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xA0"],
        ["\x58\x7C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xA1"],
        ["\x58\x7E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xA2"],
        ["\x58\x7D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xA3"],
        ["\x58\x83",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xA4"],
        ["\x58\x7F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xA5"],
        ["\x58\x81",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xA6"],
        ["\x58\x80",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xA7"],
        ["\x58\x84",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xA8"],
        ["\x58\x85",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xA9"],
        ["\x58\x8D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xAA"],
        ["\x58\x87",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xAB"],
        ["\x58\x88",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xAC"],
        ["\x58\x8E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xAD"],
        ["\x58\x95",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xAE"],
        ["\x55\x52",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xAF"],
        ["\x58\x89",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xB0"],
        ["\x58\x8B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xB1"],
        ["\x58\x8F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xB2"],
        ["\x58\x90",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xB3"],
        ["\x58\x91",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xB4"],
        ["\x58\x92",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xB5"],
        ["\x58\x93",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xB6"],
        ["\x58\x94",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xB7"],
        ["\x58\x99",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xB8"],
        ["\x58\x96",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xB9"],
        ["\x58\x98",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xBA"],
        ["\x58\x97",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xBB"],
        ["\x58\x9A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xBC"],
        ["\x50\x77",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xBD"],
        ["\x58\x9C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xBE"],
        ["\x58\x9D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xBF"],
        ["\x58\x9E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x80"],
        ["\x52\x75",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x81"],
        ["\x58\x9F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x82"],
        ["\x58\xA0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x83"],
        ["\x58\xA2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x84"],
        ["\x58\xA3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x85"],
        ["\x58\xA4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x86"],
        ["\x58\xA5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x87"],
        ["\x58\xA6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x88"],
        ["\x58\xA7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x89"],
        ["\x58\xA8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x8A"],
        ["\x58\xA9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x8B"],
        ["\x58\xAA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x8C"],
        ["\x60\x4E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x8D"],
        ["\x58\xAB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x8E"],
        ["\x58\xAC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x8F"],
        ["\x51\x8F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x90"],
        ["\x58\xAE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x91"],
        ["\x58\xAF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x92"],
        ["\x58\xB3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x93"],
        ["\x58\xB4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x94"],
        ["\x58\xB5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x95"],
        ["\x58\xB6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x96"],
        ["\x58\xB7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x97"],
        ["\x58\xB8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x98"],
        ["\x58\xB9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x99"],
        ["\x58\xBC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x9A"],
        ["\x56\x6D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x9B"],
        ["\x56\x78",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x9C"],
        ["\x58\xBD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x9D"],
        ["\x58\xBF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x9E"],
        ["\x58\xC1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x9F"],
        ["\x58\xC2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xA0"],
        ["\x51\x84",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xA1"],
        ["\x58\xBA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xA2"],
        ["\x58\xC3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xA3"],
        ["\x58\xC4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xA4"],
        ["\x58\xC5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xA5"],
        ["\x58\xC6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xA6"],
        ["\x58\xC7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xA7"],
        ["\x58\xC8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xA8"],
        ["\x58\xCA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xA9"],
        ["\x58\xC9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xAA"],
        ["\x58\xCB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xAB"],
        ["\x58\xCC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xAC"],
        ["\x58\xCD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xAD"],
        ["\x58\xCE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xAE"],
        ["\x58\xCF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xAF"],
        ["\x58\xD0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xB0"],
        ["\x58\xD1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xB1"],
        ["\x58\xD2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xB2"],
        ["\x58\xD3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xB3"],
        ["\x58\xD4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xB4"],
        ["\x58\xD6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xB5"],
        ["\x58\xD7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xB6"],
        ["\x58\xD8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xB7"],
        ["\x58\xD9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xB8"],
        ["\x58\xDA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xB9"],
        ["\x58\xDB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xBA"],
        ["\x58\xDC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xBB"],
        ["\x58\xDD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xBC"],
        ["\x58\xDE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xBD"],
        ["\x58\xDF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xBE"],
        ["\x58\xE0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xBF"],
        ["\x58\xE1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x80"],
        ["\x58\xE2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x81"],
        ["\x58\xE3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x82"],
        ["\x58\xD5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x83"],
        ["\x58\xE4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x84"],
        ["\x58\xE5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x85"],
        ["\x58\xE6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x86"],
        ["\x58\xE7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x87"],
        ["\x58\xE8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x88"],
        ["\x58\xE9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x89"],
        ["\x58\xEA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x8A"],
        ["\x58\xEB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x8B"],
        ["\x52\x58",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x8C"],
        ["\x58\xEE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x8D"],
        ["\x58\xEF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x8E"],
        ["\x58\xF0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x8F"],
        ["\x58\xF1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x90"],
        ["\x58\xF2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x91"],
        ["\x58\xF3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x92"],
        ["\x58\xF4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x93"],
        ["\x58\xED",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x94"],
        ["\x58\xF5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x95"],
        ["\x58\xF6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x96"],
        ["\x58\xF7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x97"],
        ["\x58\xF8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x98"],
        ["\x58\xF9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x99"],
        ["\x58\xFA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x9A"],
        ["\x58\xFB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x9B"],
        ["\x58\xFD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x9C"],
        ["\x52\x44",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x9D"],
        ["\x59\x41",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x9E"],
        ["\x59\x45",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x9F"],
        ["\x51\xFC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xA0"],
        ["\x59\x46",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xA1"],
        ["\x59\x43",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xA2"],
        ["\x59\x47",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xA3"],
        ["\x59\x48",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xA4"],
        ["\x59\x49",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xA5"],
        ["\x59\x4B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xA6"],
        ["\x59\x4A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xA7"],
        ["\x59\x4C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xA8"],
        ["\x59\x4D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xA9"],
        ["\x59\x4E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xAA"],
        ["\x59\x4F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xAB"],
        ["\x59\x50",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xAC"],
        ["\x59\x52",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xAD"],
        ["\x59\x53",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xAE"],
        ["\x59\x54",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xAF"],
        ["\x59\x55",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xB0"],
        ["\x51\x5D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xB1"],
        ["\x59\x56",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xB2"],
        ["\x59\x57",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xB3"],
        ["\x59\x58",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xB4"],
        ["\x59\x59",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xB5"],
        ["\x59\x5A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xB6"],
        ["\x54\x43",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xB7"],
        ["\x59\x5B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xB8"],
        ["\x59\x5C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xB9"],
        ["\x59\x5D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xBA"],
        ["\x56\x4C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xBB"],
        ["\x59\x5E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xBC"],
        ["\x59\x5F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xBD"],
        ["\x59\x60",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xBE"],
        ["\x52\x5A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xBF"],
        ["\x59\x61",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x80"],
        ["\x58\xBB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x81"],
        ["\x59\x63",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x82"],
        ["\x59\x64",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x83"],
        ["\x59\x65",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x84"],
        ["\x59\x6A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x85"],
        ["\x59\x66",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x86"],
        ["\x59\x69",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x87"],
        ["\x59\x62",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x88"],
        ["\x59\x6B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x89"],
        ["\x59\x6C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x8A"],
        ["\x59\x6D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x8B"],
        ["\x59\x6E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x8C"],
        ["\x59\x6F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x8D"],
        ["\x59\x71",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x8E"],
        ["\x59\x8C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x8F"],
        ["\x59\x72",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x90"],
        ["\x59\x73",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x91"],
        ["\x59\x74",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x92"],
        ["\x54\xF1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x93"],
        ["\x59\x81",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x94"],
        ["\x59\x75",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x95"],
        ["\x59\x76",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x96"],
        ["\x59\x77",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x97"],
        ["\x51\x4D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x98"],
        ["\x59\x79",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x99"],
        ["\x59\x7A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x9A"],
        ["\x59\x7B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x9B"],
        ["\x59\x7C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x9C"],
        ["\x59\x7D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x9D"],
        ["\x59\x7E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x9E"],
        ["\x59\x82",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x9F"],
        ["\x59\x83",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xA0"],
        ["\x59\x85",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xA1"],
        ["\x59\x86",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xA2"],
        ["\x59\x88",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xA3"],
        ["\x59\x89",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xA4"],
        ["\x59\x8A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xA5"],
        ["\x59\x8B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xA6"],
        ["\x59\x8D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xA7"],
        ["\x59\x8E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xA8"],
        ["\x59\x90",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xA9"],
        ["\x59\x91",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xAA"],
        ["\x4F\x84",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xAB"],
        ["\x59\x8F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xAC"],
        ["\x59\x92",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xAD"],
        ["\x59\x94",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xAE"],
        ["\x59\x96",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xAF"],
        ["\x52\x81",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xB0"],
        ["\x59\x98",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xB1"],
        ["\x59\x99",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xB2"],
        ["\x51\xDF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xB3"],
        ["\x59\x9A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xB4"],
        ["\x59\x9B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xB5"],
        ["\x4A\x4B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xB6"],
        ["\x59\x9C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xB7"],
        ["\x59\x9D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xB8"],
        ["\x59\x9E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xB9"],
        ["\x59\x9F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xBA"],
        ["\x59\xA0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xBB"],
        ["\x59\xA1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xBC"],
        ["\x59\xA2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xBD"],
        ["\x54\xBE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xBE"],
        ["\x59\xA3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xBF"],
        ["\x59\xA4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x80"],
        ["\x59\xA5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x81"],
        ["\x59\xA7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x82"],
        ["\x59\xA8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x83"],
        ["\x59\xA9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x84"],
        ["\x54\x83",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x85"],
        ["\x59\xAA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x86"],
        ["\x59\xAB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x87"],
        ["\x59\xA6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x88"],
        ["\x59\xAC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x89"],
        ["\x59\xAD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x8A"],
        ["\x59\xAE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x8B"],
        ["\x68\x50",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x8C"],
        ["\x59\xAF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x8D"],
        ["\x59\xB0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x8E"],
        ["\x59\xB1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x8F"],
        ["\x59\xB2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x90"],
        ["\x59\xB3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x91"],
        ["\x59\xB4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x92"],
        ["\x59\xB5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x93"],
        ["\x53\x6C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x94"],
        ["\x50\xE9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x95"],
        ["\x59\xB6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x96"],
        ["\x59\xB7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x97"],
        ["\x59\xB8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x98"],
        ["\x59\xB9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x99"],
        ["\x59\xBA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x9A"],
        ["\x59\xBB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x9B"],
        ["\x59\xBC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x9C"],
        ["\x59\xBD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x9D"],
        ["\x59\xBF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x9E"],
        ["\x59\xC0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x9F"],
        ["\x59\xBE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xA0"],
        ["\x59\xC1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xA1"],
        ["\x52\xD6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xA2"],
        ["\x54\x4B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xA3"],
        ["\x59\xC2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xA4"],
        ["\x59\xC3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xA5"],
        ["\x59\xD6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xA6"],
        ["\x59\xD5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xA7"],
        ["\x59\xC4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xA8"],
        ["\x59\xC5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xA9"],
        ["\x59\xC6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xAA"],
        ["\x59\xC8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xAB"],
        ["\x59\xC9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xAC"],
        ["\x59\xCC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xAD"],
        ["\x59\xCE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xAF"],
        ["\x59\xCF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xB0"],
        ["\x59\xD0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xB1"],
        ["\x59\xCA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xB2"],
        ["\x59\xD1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xB3"],
        ["\x59\xD2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xB4"],
        ["\x59\xD3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xB5"],
        ["\x59\xD4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xB6"],
        ["\x59\xD7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xB7"],
        ["\x52\x9C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xB8"],
        ["\x59\xD9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xB9"],
        ["\x59\xDA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xBA"],
        ["\x59\xDB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xBB"],
        ["\x59\xDC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xBC"],
        ["\x59\xDD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xBD"],
        ["\x59\xDE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xBE"],
        ["\x59\xDF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xBF"],
        ["\x59\xE1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x80"],
        ["\x59\xE0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x81"],
        ["\x59\xE3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x82"],
        ["\x59\xE2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x83"],
        ["\x59\xE4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x84"],
        ["\x59\xE5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x85"],
        ["\x59\xE6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x86"],
        ["\x59\xE7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x87"],
        ["\x59\xE9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x88"],
        ["\x59\xEA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x89"],
        ["\x59\xEB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x8A"],
        ["\x59\xEC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x8B"],
        ["\x59\xED",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x8C"],
        ["\x59\xEE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x8D"],
        ["\x59\xF0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x8E"],
        ["\x52\x76",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x8F"],
        ["\x59\xF2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x90"],
        ["\x59\xF3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x91"],
        ["\x5A\x43",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x92"],
        ["\x59\xF4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x93"],
        ["\x59\xF5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x94"],
        ["\x59\xF6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x95"],
        ["\x59\xF7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x96"],
        ["\x59\xF8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x97"],
        ["\x59\xF9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x98"],
        ["\x59\xFA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x99"],
        ["\x59\xFB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x9A"],
        ["\x59\xFC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x9B"],
        ["\x59\xFD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x9C"],
        ["\x59\xFE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x9D"],
        ["\x5A\x41",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x9E"],
        ["\x5A\x42",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x9F"],
        ["\x5A\x45",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xA0"],
        ["\x5A\x46",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xA1"],
        ["\x5A\x47",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xA2"],
        ["\x5A\x48",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xA3"],
        ["\x5A\x49",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xA4"],
        ["\x5A\x4A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xA5"],
        ["\x5A\x4B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xA6"],
        ["\x5A\x4C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xA7"],
        ["\x5A\x4D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xA8"],
        ["\x52\x56",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xA9"],
        ["\x5A\x4E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xAA"],
        ["\x5A\x4F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xAB"],
        ["\x5A\x50",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xAC"],
        ["\x5A\x52",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xAD"],
        ["\x55\x44",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xAE"],
        ["\x55\x4A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xAF"],
        ["\x5A\x53",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xB0"],
        ["\x5A\x54",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xB1"],
        ["\x5A\x55",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xB2"],
        ["\x5A\x56",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xB3"],
        ["\x5A\x58",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xB4"],
        ["\x5A\x59",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xB5"],
        ["\x5A\x5A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xB6"],
        ["\x5A\x5B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xB7"],
        ["\x5A\x5C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xB8"],
        ["\x5A\x5D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xB9"],
        ["\x5A\x5E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xBA"],
        ["\x5A\x60",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xBB"],
        ["\x5A\x61",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xBC"],
        ["\x53\xA3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xBD"],
        ["\x59\xEF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xBE"],
        ["\x5A\x62",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xBF"],
        ["\x5A\x63",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x80"],
        ["\x5A\x64",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x81"],
        ["\x5A\x66",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x82"],
        ["\x5A\x78",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x83"],
        ["\x5A\x69",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x84"],
        ["\x5A\x6A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x85"],
        ["\x5A\x6B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x86"],
        ["\x5A\x6C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x87"],
        ["\x5A\x6D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x88"],
        ["\x5A\x6E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x89"],
        ["\x5A\x6F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x8A"],
        ["\x5A\x70",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x8B"],
        ["\x5A\x71",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x8C"],
        ["\x5A\x72",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x8D"],
        ["\x5A\x73",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x8E"],
        ["\x5A\x74",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x8F"],
        ["\x5A\x75",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x90"],
        ["\x5A\x77",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x91"],
        ["\x5A\x7C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x92"],
        ["\x5A\x7A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x93"],
        ["\x5A\x7B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x94"],
        ["\x5A\x7D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x95"],
        ["\x51\xE3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x96"],
        ["\x5A\x7F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x97"],
        ["\x5A\x80",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x98"],
        ["\x5A\x81",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x99"],
        ["\x5A\x84",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x9A"],
        ["\x5A\x85",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x9B"],
        ["\x5A\x86",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x9C"],
        ["\x5A\x87",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x9D"],
        ["\x5A\x89",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x9E"],
        ["\x5A\x8A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x9F"],
        ["\x5A\x8B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xA0"],
        ["\x5A\x8C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xA1"],
        ["\x5A\x8D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xA2"],
        ["\x5A\x8E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xA3"],
        ["\x5A\x8F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xA4"],
        ["\x5A\x82",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xA5"],
        ["\x5A\x90",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xA6"],
        ["\x5A\x91",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xA7"],
        ["\x5A\x83",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xA8"],
        ["\x5A\x92",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xA9"],
        ["\x5A\x93",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xAA"],
        ["\x5A\x95",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xAB"],
        ["\x5A\x96",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xAC"],
        ["\x5A\x88",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xAD"],
        ["\x5A\x97",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xAE"],
        ["\x5A\x98",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xAF"],
        ["\x55\xCF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xB0"],
        ["\x5A\x99",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xB1"],
        ["\x5A\x9A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xB2"],
        ["\x5A\x9B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xB3"],
        ["\x5A\x9C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xB4"],
        ["\x5A\x9D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xB5"],
        ["\x5A\x9E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xB6"],
        ["\x5A\x9F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xB7"],
        ["\x5A\xAA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xB8"],
        ["\x5A\xA0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xB9"],
        ["\x5A\xA1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xBA"],
        ["\x5A\xA2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xBB"],
        ["\x5A\xA3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xBC"],
        ["\x5A\xA4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xBD"],
        ["\x5A\xA5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xBE"],
        ["\x5A\xA6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xBF"],
        ["\x5A\xA7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x80"],
        ["\x5A\xA8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x81"],
        ["\x5A\xAB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x82"],
        ["\x5A\xAD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x83"],
        ["\x5A\xA9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x84"],
        ["\x5A\xAE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x85"],
        ["\x5A\xAC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x86"],
        ["\x5A\xAF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x87"],
        ["\x5A\xB0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x88"],
        ["\x5A\xB1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x89"],
        ["\x5A\xB2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x8A"],
        ["\x5A\xB3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x8B"],
        ["\x5A\xB4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x8C"],
        ["\x54\x60",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x8D"],
        ["\x5A\xB6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x8E"],
        ["\x5A\xB7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x8F"],
        ["\x5A\xB8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x90"],
        ["\x5A\xB9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x91"],
        ["\x5A\xBA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x92"],
        ["\x5A\xBB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x93"],
        ["\x5A\xBC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x94"],
        ["\x5A\xBD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x95"],
        ["\x5A\xBE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x96"],
        ["\x5A\xBF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x97"],
        ["\x5A\xC0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x98"],
        ["\x5A\xC1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x99"],
        ["\x5A\xC2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x9A"],
        ["\x5A\xC3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x9B"],
        ["\x5A\xC4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x9C"],
        ["\x5A\xC5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x9D"],
        ["\x5A\xC6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x9E"],
        ["\x5A\xC7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x9F"],
        ["\x5A\xC8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xA0"],
        ["\x5A\xCA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xA1"],
        ["\x5A\xC9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xA2"],
        ["\x5A\xCB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xA3"],
        ["\x5A\xCC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xA4"],
        ["\x5A\xD7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xA5"],
        ["\x5A\xCD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xA6"],
        ["\x5A\xCE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xA7"],
        ["\x5A\xCF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xA8"],
        ["\x5A\xD0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xA9"],
        ["\x5A\xD1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xAA"],
        ["\x5A\xD2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xAB"],
        ["\x5A\xE6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xAC"],
        ["\x5A\xD4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xAD"],
        ["\x5B\x60",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xAE"],
        ["\x5A\xD5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xAF"],
        ["\x5A\xD6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xB0"],
        ["\x53\x45",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xB1"],
        ["\x5A\xD8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xB2"],
        ["\x5A\xD9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xB3"],
        ["\x5A\xDB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xB4"],
        ["\x5A\xDC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xB5"],
        ["\x5A\xDD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xB6"],
        ["\x5A\xDE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xB7"],
        ["\x5A\xDF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xB8"],
        ["\x5A\xE0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xB9"],
        ["\x5A\xE1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xBA"],
        ["\x5A\xE2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xBB"],
        ["\x5A\xE3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xBC"],
        ["\x5A\xE4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xBD"],
        ["\x5A\xE5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xBE"],
        ["\x5A\xE7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xBF"],
        ["\x5A\xE9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x80"],
        ["\x5A\xE8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x81"],
        ["\x5B\x48",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x82"],
        ["\x5A\xEA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x83"],
        ["\x5A\xEB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x84"],
        ["\x5A\xEC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x85"],
        ["\x5A\xED",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x86"],
        ["\x5A\xEE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x87"],
        ["\x5A\xEF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x88"],
        ["\x5A\xF0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x89"],
        ["\x5A\xF1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x8A"],
        ["\x5A\xF2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x8B"],
        ["\x5A\xF3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x8C"],
        ["\x5A\xF6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x8D"],
        ["\x5A\xF4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x8E"],
        ["\x5A\xF5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x8F"],
        ["\x5A\xF7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x90"],
        ["\x5A\xF8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x91"],
        ["\x5A\xF9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x92"],
        ["\x5A\xFA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x93"],
        ["\x5A\xFC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x94"],
        ["\x5A\xFD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x95"],
        ["\x5A\xFE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x96"],
        ["\x5B\x41",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x97"],
        ["\x5B\x42",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x98"],
        ["\x5B\x4C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x99"],
        ["\x5B\x43",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x9A"],
        ["\x5B\x44",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x9B"],
        ["\x5B\x45",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x9C"],
        ["\x5B\x46",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x9D"],
        ["\x5B\x47",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x9E"],
        ["\x5B\x71",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x9F"],
        ["\x5B\x49",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xA0"],
        ["\x5B\x4A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xA1"],
        ["\x5B\x4B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xA2"],
        ["\x5B\x4E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xA3"],
        ["\x5B\x4F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xA4"],
        ["\x5B\x51",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xA5"],
        ["\x5B\x4D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xA6"],
        ["\x52\x7F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xA7"],
        ["\x5B\x55",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xA8"],
        ["\x5B\x57",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xA9"],
        ["\x5B\x58",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xAA"],
        ["\x5B\x59",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xAB"],
        ["\x5B\x5A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xAC"],
        ["\x5B\x5B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xAD"],
        ["\x5B\x5C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xAE"],
        ["\x5B\x5D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xAF"],
        ["\x5B\x5E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xB0"],
        ["\x5B\x5F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xB1"],
        ["\x5B\x56",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xB2"],
        ["\x5B\x61",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xB3"],
        ["\x5B\x62",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xB4"],
        ["\x5B\x63",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xB5"],
        ["\x5B\x64",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xB6"],
        ["\x57\x78",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xB7"],
        ["\x5B\x65",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xB8"],
        ["\x5B\x66",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xB9"],
        ["\x5A\xD3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xBA"],
        ["\x5B\x67",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xBB"],
        ["\x5B\x68",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xBC"],
        ["\x5B\x76",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xBD"],
        ["\x5B\x6A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xBE"],
        ["\x5B\x69",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xBF"],
        ["\x5B\x6B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x80"],
        ["\x5B\x6C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x81"],
        ["\x5B\x6D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x82"],
        ["\x5B\x6E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x83"],
        ["\x5B\x6F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x84"],
        ["\x5B\x70",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x85"],
        ["\x5B\x72",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x86"],
        ["\x5B\x73",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x87"],
        ["\x5B\x74",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x88"],
        ["\x5B\x75",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x89"],
        ["\x5B\x77",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x8A"],
        ["\x5B\x78",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x8B"],
        ["\x5B\x79",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x8C"],
        ["\x5B\x7A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x8D"],
        ["\x5B\x7B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x8E"],
        ["\x5B\x7C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x8F"],
        ["\x5B\x7D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x90"],
        ["\x5B\x7F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x91"],
        ["\x5B\x82",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x92"],
        ["\x5B\x80",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x93"],
        ["\x5B\x81",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x94"],
        ["\x51\xB1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x95"],
        ["\x5B\x83",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x96"],
        ["\x5B\x84",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x97"],
        ["\x5B\x85",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x98"],
        ["\x5B\x86",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x99"],
        ["\x5B\x87",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x9A"],
        ["\x5B\x88",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x9B"],
        ["\x5B\x89",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x9C"],
        ["\x5B\x8A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x9D"],
        ["\x5B\x8B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x9E"],
        ["\x5B\x8C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x9F"],
        ["\x5B\x8D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xA0"],
        ["\x5B\x8E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xA1"],
        ["\x5B\x8F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xA2"],
        ["\x5B\x90",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xA3"],
        ["\x5B\x91",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xA4"],
        ["\x5B\x92",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xA5"],
        ["\x51\x65",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xA6"],
        ["\x5B\x93",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xA7"],
        ["\x5B\x95",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xA8"],
        ["\x5B\x94",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xA9"],
        ["\x5B\x96",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xAA"],
        ["\x5B\x9A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xAB"],
        ["\x52\x8E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xAC"],
        ["\x5B\x9B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xAD"],
        ["\x5B\x9C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xAE"],
        ["\x5B\xE0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xAF"],
        ["\x5B\x9F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xB0"],
        ["\x51\x93",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xB1"],
        ["\x5B\xA2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xB2"],
        ["\x5B\xA3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xB3"],
        ["\x51\xEA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xB4"],
        ["\x5B\xA5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xB5"],
        ["\x5B\xA6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xB6"],
        ["\x52\x51",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xB7"],
        ["\x5B\xA9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xB8"],
        ["\x5B\xAD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xB9"],
        ["\x5B\xAA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xBA"],
        ["\x50\xA0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xBB"],
        ["\x51\xB2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xBC"],
        ["\x4F\xCE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xBD"],
        ["\x5B\xAC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xBE"],
        ["\x5B\xB0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xBF"],
        ["\x5B\xB1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x80"],
        ["\x5B\xB2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x81"],
        ["\x4F\xAB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x82"],
        ["\x4E\xD1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x83"],
        ["\x5B\xB3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x84"],
        ["\x5B\xB5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x85"],
        ["\x5B\xB7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x86"],
        ["\x5B\xBA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x87"],
        ["\x52\x43",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x88"],
        ["\x5B\xBC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x89"],
        ["\x5B\xBD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x8A"],
        ["\x5B\xBE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x8B"],
        ["\x5B\xB9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x8C"],
        ["\x5B\xBF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x8D"],
        ["\x5B\xC0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x8E"],
        ["\x5B\xC1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x8F"],
        ["\x51\xCC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x90"],
        ["\x5B\x9E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x91"],
        ["\x5B\xC2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x92"],
        ["\x5B\xC3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x93"],
        ["\x5B\xC4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x94"],
        ["\x5B\xC5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x95"],
        ["\x5B\xC6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x96"],
        ["\x54\xFD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x97"],
        ["\x5B\xCA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x98"],
        ["\x5B\xCB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x99"],
        ["\x5B\xCD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x9A"],
        ["\x5B\xCE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x9B"],
        ["\x5B\xCF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x9C"],
        ["\x5B\xD0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x9D"],
        ["\x5B\xD1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x9E"],
        ["\x5B\xD2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x9F"],
        ["\x53\x4F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xA0"],
        ["\x5B\xD4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xA1"],
        ["\x5B\xD3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xA2"],
        ["\x5B\xD5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xA3"],
        ["\x5B\xD6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xA4"],
        ["\x54\x80",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xA5"],
        ["\x5B\xD7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xA6"],
        ["\x52\x91",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xA7"],
        ["\x5B\xD9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xA8"],
        ["\x5B\xDA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xA9"],
        ["\x5B\xDC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xAA"],
        ["\x5B\xDD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xAB"],
        ["\x54\xDF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xAC"],
        ["\x5B\xDE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xAD"],
        ["\x54\xF2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xAE"],
        ["\x5B\xDF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xAF"],
        ["\x5B\xE1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xB0"],
        ["\x5B\xE2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xB1"],
        ["\x5B\xDB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xB2"],
        ["\x5B\xE4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xB3"],
        ["\x5B\xE5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xB4"],
        ["\x5B\xE6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xB5"],
        ["\x5B\xE7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xB6"],
        ["\x54\xC9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xB7"],
        ["\x5B\xE8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xB8"],
        ["\x5B\xE9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xB9"],
        ["\x5B\xEB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xBA"],
        ["\x54\xF3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xBB"],
        ["\x5B\xED",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xBC"],
        ["\x5B\xEE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xBD"],
        ["\x5B\xEF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xBE"],
        ["\x5B\xF2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xBF"],
        ["\x5B\xF1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x80"],
        ["\x5B\xF4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x81"],
        ["\x5B\xEA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x82"],
        ["\x4D\x55",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x83"],
        ["\x5B\xF5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x84"],
        ["\x5B\xF6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x85"],
        ["\x52\xDE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x86"],
        ["\x5B\xF8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x87"],
        ["\x5B\xF7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x88"],
        ["\x5B\xFA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x89"],
        ["\x5B\xFB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x8A"],
        ["\x53\x61",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x8B"],
        ["\x52\xE2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x8C"],
        ["\x5B\xFD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x8D"],
        ["\x5B\xFC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x8E"],
        ["\x5C\x41",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x8F"],
        ["\x5C\x42",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x90"],
        ["\x5C\x43",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x91"],
        ["\x5C\x45",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x92"],
        ["\x5C\x46",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x93"],
        ["\x5C\x47",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x94"],
        ["\x4E\x92",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x95"],
        ["\x53\xBC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x96"],
        ["\x5C\x48",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x97"],
        ["\x54\x5D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x98"],
        ["\x5C\x4A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x99"],
        ["\x5C\x4B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x9A"],
        ["\x5C\x4C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x9B"],
        ["\x52\xC6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x9C"],
        ["\x5C\x4D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x9D"],
        ["\x5C\x4E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x9E"],
        ["\x5B\xFE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x9F"],
        ["\x5C\x44",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xA0"],
        ["\x5C\x4F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xA1"],
        ["\x5C\x50",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xA2"],
        ["\x5C\x51",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xA3"],
        ["\x5C\x52",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xA4"],
        ["\x5C\x61",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xA5"],
        ["\x5C\x53",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xA6"],
        ["\x5C\x54",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xA7"],
        ["\x5C\x55",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xA8"],
        ["\x5C\x56",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xA9"],
        ["\x5C\x57",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xAA"],
        ["\x5C\x58",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xAB"],
        ["\x5C\x59",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xAC"],
        ["\x5C\x69",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xAD"],
        ["\x5C\x5A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xAE"],
        ["\x5C\x5C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xAF"],
        ["\x54\xC2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xB0"],
        ["\x5C\x5D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xB1"],
        ["\x53\xFA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xB2"],
        ["\x54\x94",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xB3"],
        ["\x5C\x5E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xB4"],
        ["\x5C\x5B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xB5"],
        ["\x5C\x65",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xB6"],
        ["\x5C\x62",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xB7"],
        ["\x53\x70",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xB8"],
        ["\x5C\x64",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xB9"],
        ["\x5C\x63",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xBA"],
        ["\x5C\x60",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xBB"],
        ["\x5C\x67",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xBC"],
        ["\x5C\x68",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xBD"],
        ["\x54\xE2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xBE"],
        ["\x5C\x6A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xBF"],
        ["\x54\xA2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x80"],
        ["\x5C\x6B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x81"],
        ["\x5C\x74",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x82"],
        ["\x53\xEF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x83"],
        ["\x52\xED",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x84"],
        ["\x5C\x6D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x85"],
        ["\x5C\x6F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x86"],
        ["\x5C\x70",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x87"],
        ["\x5C\x71",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x88"],
        ["\x52\x7C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x89"],
        ["\x5C\x72",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x8A"],
        ["\x5C\x73",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x8B"],
        ["\x5C\x75",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x8C"],
        ["\x5C\x6C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x8D"],
        ["\x5C\x76",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x8E"],
        ["\x51\x4A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x8F"],
        ["\x54\x8C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x90"],
        ["\x5C\x77",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x91"],
        ["\x5C\x7A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x92"],
        ["\x5C\x7B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x93"],
        ["\x5C\x7C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x94"],
        ["\x5C\x7D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x95"],
        ["\x5C\x7E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x96"],
        ["\x5C\x7F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x97"],
        ["\x5C\x81",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x98"],
        ["\x5C\x82",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x99"],
        ["\x5C\x83",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x9A"],
        ["\x53\x8D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x9B"],
        ["\x5C\x88",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x9C"],
        ["\x54\x76",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x9D"],
        ["\x5C\x84",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x9E"],
        ["\x5C\x85",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x9F"],
        ["\x5C\x86",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xA0"],
        ["\x53\xB2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xA1"],
        ["\x5C\x87",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xA2"],
        ["\x5C\x89",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xA3"],
        ["\x5C\x8A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xA4"],
        ["\x5C\x8B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xA5"],
        ["\x5C\x8C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xA6"],
        ["\x5C\xC1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xA7"],
        ["\x5C\x8D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xA8"],
        ["\x5C\x8E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xA9"],
        ["\x5C\x8F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xAA"],
        ["\x53\xBB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xAB"],
        ["\x5C\x80",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xAC"],
        ["\x5C\x91",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xAD"],
        ["\x5C\x92",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xAE"],
        ["\x5C\x93",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xAF"],
        ["\x5C\x94",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xB0"],
        ["\x5C\x95",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xB1"],
        ["\x5C\x97",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xB2"],
        ["\x5C\xB7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xB3"],
        ["\x5C\x98",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xB4"],
        ["\x5C\x99",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xB5"],
        ["\x5C\x9C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xB6"],
        ["\x5C\x9D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xB7"],
        ["\x5C\xA8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xB8"],
        ["\x5C\x9F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xB9"],
        ["\x5C\xA0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xBA"],
        ["\x5C\xA1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xBB"],
        ["\x5C\xA2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xBC"],
        ["\x5C\xA3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xBD"],
        ["\x5C\xA4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xBE"],
        ["\x5C\xA5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xBF"],
        ["\x5C\xA7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x80"],
        ["\x5C\x96",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x81"],
        ["\x5C\xAA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x82"],
        ["\x5C\xAB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x83"],
        ["\x5C\x9E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x84"],
        ["\x5C\xAC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x85"],
        ["\x5C\xAD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x86"],
        ["\x5C\xAE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x87"],
        ["\x5C\xB0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x88"],
        ["\x5C\xBE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x89"],
        ["\x5C\xB3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x8A"],
        ["\x52\x8B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x8B"],
        ["\x5C\xB4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x8C"],
        ["\x5C\xB5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x8D"],
        ["\x5C\xB6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x8E"],
        ["\x5C\xB1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x8F"],
        ["\x5C\xB8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x90"],
        ["\x5C\xBA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x91"],
        ["\x53\x62",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x92"],
        ["\x5C\xB2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x93"],
        ["\x5C\xBB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x94"],
        ["\x5C\xBF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x95"],
        ["\x52\xEE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x96"],
        ["\x5C\xC0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x97"],
        ["\x5C\xBD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x98"],
        ["\x5C\xC2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x99"],
        ["\x5C\xC3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x9A"],
        ["\x5C\xC4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x9B"],
        ["\x67\x86",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x9C"],
        ["\x5C\xC5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x9D"],
        ["\x5C\xC6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x9E"],
        ["\x5C\xC7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x9F"],
        ["\x5C\xC9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xA0"],
        ["\x5C\xC8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xA1"],
        ["\x5C\xCA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xA2"],
        ["\x5C\xCB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xA3"],
        ["\x5C\xCC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xA4"],
        ["\x5C\xCD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xA5"],
        ["\x5C\xCE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xA6"],
        ["\x5C\xCF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xA7"],
        ["\x5C\xD0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xA8"],
        ["\x5C\xD1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xA9"],
        ["\x5C\xD2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xAA"],
        ["\x5C\xD3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xAB"],
        ["\x5C\xD4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xAC"],
        ["\x5C\xD5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xAD"],
        ["\x5C\xD6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xAE"],
        ["\x5C\xD7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xAF"],
        ["\x5C\xD8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xB0"],
        ["\x5C\xD9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xB1"],
        ["\x5C\xDA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xB2"],
        ["\x5C\xDB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xB3"],
        ["\x5C\xDC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xB4"],
        ["\x5C\xDD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xB5"],
        ["\x5C\xDE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xB6"],
        ["\x5C\xDF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xB7"],
        ["\x5C\xE0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xB8"],
        ["\x5C\xE1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xB9"],
        ["\x5C\xE3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xBA"],
        ["\x5C\xE2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xBB"],
        ["\x5C\xE4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xBC"],
        ["\x5C\xE5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xBD"],
        ["\x5C\xE6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xBE"],
        ["\x5C\xE7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xBF"],
        ["\x5C\xE8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x80"],
        ["\x5C\xE9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x81"],
        ["\x5C\xEB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x82"],
        ["\x5C\xEC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x83"],
        ["\x5C\xED",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x84"],
        ["\x5C\xEE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x85"],
        ["\x5C\xEF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x86"],
        ["\x68\x51",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x87"],
        ["\x5C\xF0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x88"],
        ["\x5C\xF1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x89"],
        ["\x5C\xF2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x8A"],
        ["\x5C\xF3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x8B"],
        ["\x5C\xF4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x8C"],
        ["\x5C\xF5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x8D"],
        ["\x5C\xF7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x8E"],
        ["\x5C\xF8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x8F"],
        ["\x5C\xFA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x90"],
        ["\x52\xB4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x91"],
        ["\x5C\xFB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x92"],
        ["\x5C\xFC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x93"],
        ["\x5D\x41",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x94"],
        ["\x5D\x42",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x95"],
        ["\x5D\x43",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x96"],
        ["\x5D\x44",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x97"],
        ["\x5D\x45",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x98"],
        ["\x5D\x46",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x99"],
        ["\x5D\x47",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x9A"],
        ["\x5D\x48",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x9B"],
        ["\x5D\x49",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x9C"],
        ["\x5D\x4A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x9D"],
        ["\x54\xD7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x9E"],
        ["\x5D\x4B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x9F"],
        ["\x55\xC6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xA0"],
        ["\x5D\x4C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xA1"],
        ["\x5D\x4F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xA2"],
        ["\x5D\x4D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xA3"],
        ["\x5D\x50",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xA4"],
        ["\x5D\x51",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xA5"],
        ["\x5D\x52",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xA6"],
        ["\x5D\x53",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xA7"],
        ["\x5D\x54",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xA8"],
        ["\x5D\x55",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xA9"],
        ["\x5D\x56",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xAA"],
        ["\x5D\x57",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xAB"],
        ["\x63\x70",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xAC"],
        ["\x5D\x59",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xAD"],
        ["\x5D\x5A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xAE"],
        ["\x5D\x5B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xAF"],
        ["\x50\xBC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xB0"],
        ["\x52\xB6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xB1"],
        ["\x52\xAC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xB2"],
        ["\x5D\x5C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xB3"],
        ["\x5D\x5D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xB4"],
        ["\x5D\x5E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xB5"],
        ["\x5D\x5F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xB6"],
        ["\x5D\x61",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xB7"],
        ["\x5D\x63",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xB8"],
        ["\x5D\x64",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xB9"],
        ["\x5D\x65",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xBA"],
        ["\x5D\x66",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xBB"],
        ["\x5D\x67",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xBC"],
        ["\x5D\x68",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xBD"],
        ["\x51\xD2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xBE"],
        ["\x5D\x6A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xBF"],
        ["\x5D\x6C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x80"],
        ["\x51\x64",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x81"],
        ["\x5D\x6D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x82"],
        ["\x5D\x6F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x83"],
        ["\x5D\x71",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x84"],
        ["\x5D\x70",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x85"],
        ["\x5D\x73",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x86"],
        ["\x5D\x75",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x87"],
        ["\x5D\x76",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x88"],
        ["\x5D\x77",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x89"],
        ["\x5D\x78",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x8A"],
        ["\x5D\x79",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x8B"],
        ["\x5D\x7B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x8C"],
        ["\x5D\x7C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x8D"],
        ["\x5D\x7D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x8E"],
        ["\x5D\x7E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x8F"],
        ["\x5D\x81",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x90"],
        ["\x5D\x82",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x91"],
        ["\x5D\x83",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x92"],
        ["\x5D\x84",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x93"],
        ["\x5D\x85",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x94"],
        ["\x5D\x86",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x95"],
        ["\x5D\x6E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x96"],
        ["\x5D\x87",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x97"],
        ["\x5D\x88",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x98"],
        ["\x5D\x89",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x99"],
        ["\x5D\x8B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x9A"],
        ["\x5D\x8C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x9B"],
        ["\x5D\x8D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x9C"],
        ["\x5D\x8F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x9D"],
        ["\x5D\x90",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x9E"],
        ["\x5D\x91",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x9F"],
        ["\x5D\x92",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xA0"],
        ["\x5D\x94",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xA1"],
        ["\x5D\x96",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xA2"],
        ["\x5D\x97",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xA3"],
        ["\x5D\x98",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xA4"],
        ["\x5D\xB4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xA5"],
        ["\x5D\x99",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xA6"],
        ["\x5D\x9A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xA7"],
        ["\x5D\x9B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xA8"],
        ["\x5D\x9C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xA9"],
        ["\x5D\x9D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xAA"],
        ["\x52\xA9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xAB"],
        ["\x5D\x9E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xAC"],
        ["\x52\x4A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xAD"],
        ["\x5D\x9F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xAE"],
        ["\x5D\xA0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xAF"],
        ["\x5D\xA1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xB0"],
        ["\x5D\xA2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xB1"],
        ["\x5D\xA3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xB2"],
        ["\x5D\xA4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xB3"],
        ["\x5D\xA5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xB4"],
        ["\x53\x76",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xB5"],
        ["\x5D\xA7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xB6"],
        ["\x5D\xA8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xB7"],
        ["\x5D\xA9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xB8"],
        ["\x55\x75",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xB9"],
        ["\x53\xEA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xBA"],
        ["\x5D\xAB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xBB"],
        ["\x5D\xAC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xBC"],
        ["\x5D\xAD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xBD"],
        ["\x5D\xAE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xBE"],
        ["\x5D\xAF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xBF"],
        ["\x5D\xB0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x80"],
        ["\x5D\xB1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x81"],
        ["\x5D\xB2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x82"],
        ["\x5D\xB3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x83"],
        ["\x5D\xB5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x84"],
        ["\x5D\xB6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x85"],
        ["\x5D\xB7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x86"],
        ["\x5D\xB8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x87"],
        ["\x5D\xB9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x88"],
        ["\x5D\xBA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x89"],
        ["\x55\xA0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x8A"],
        ["\x5D\xBB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x8B"],
        ["\x5D\xBC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x8C"],
        ["\x5D\xBD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x8D"],
        ["\x5D\xE2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x8E"],
        ["\x5D\xBE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x8F"],
        ["\x5D\xC0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x90"],
        ["\x5D\xC2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x91"],
        ["\x5D\xC3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x92"],
        ["\x5D\xC5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x93"],
        ["\x5D\xC6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x94"],
        ["\x5D\xCF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x95"],
        ["\x5D\xC7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x96"],
        ["\x5D\xC8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x97"],
        ["\x5D\xC9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x98"],
        ["\x5D\xCB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x99"],
        ["\x4E\x4B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x9A"],
        ["\x5D\xCC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x9B"],
        ["\x5D\xC4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x9C"],
        ["\x5D\xCE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x9D"],
        ["\x5D\xD0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x9E"],
        ["\x5D\xD1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x9F"],
        ["\x5D\xD2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xA0"],
        ["\x5D\xD4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xA1"],
        ["\x5D\xD3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xA2"],
        ["\x50\x55",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xA3"],
        ["\x5D\xD6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xA4"],
        ["\x5D\xCD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xA5"],
        ["\x5D\xD9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xA6"],
        ["\x5D\xDA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xA7"],
        ["\x5D\xDB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xA8"],
        ["\x5D\xDC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xA9"],
        ["\x5D\xDD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xAA"],
        ["\x5D\xDE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xAB"],
        ["\x51\x87",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xAC"],
        ["\x5D\xDF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xAD"],
        ["\x5D\xE0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xAE"],
        ["\x5D\xBF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xAF"],
        ["\x52\xB0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xB0"],
        ["\x5D\xE4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xB1"],
        ["\x5D\xE1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xB2"],
        ["\x5D\xE5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xB3"],
        ["\x5D\xE6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xB4"],
        ["\x5D\xE7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xB5"],
        ["\x5D\xE8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xB6"],
        ["\x5D\xE9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xB7"],
        ["\x5D\xEB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xB8"],
        ["\x4F\xEE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xB9"],
        ["\x5D\xEC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xBA"],
        ["\x5D\xF7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xBB"],
        ["\x5D\xEE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xBC"],
        ["\x5D\xEF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xBD"],
        ["\x52\xCD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xBE"],
        ["\x5D\xF0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xBF"],
        ["\x5D\xF1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x80"],
        ["\x5D\xF2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x81"],
        ["\x53\x8C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x82"],
        ["\x5D\xF3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x83"],
        ["\x5D\xF4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x84"],
        ["\x5D\xF8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x85"],
        ["\x5D\xF9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x86"],
        ["\x5D\xFA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x87"],
        ["\x53\x57",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x88"],
        ["\x68\x85",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x89"],
        ["\x5E\x45",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x8A"],
        ["\x5D\xFE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x8B"],
        ["\x5E\x41",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x8C"],
        ["\x5E\x42",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x8D"],
        ["\x5E\x43",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x8E"],
        ["\x5E\x44",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x8F"],
        ["\x5E\x46",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x90"],
        ["\x5E\x57",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x91"],
        ["\x5E\x47",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x92"],
        ["\x5E\x48",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x93"],
        ["\x54\xBB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x94"],
        ["\x5E\x4A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x95"],
        ["\x5E\x52",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x96"],
        ["\x5E\x4C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x97"],
        ["\x5E\x4D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x98"],
        ["\x5E\x4E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x99"],
        ["\x5E\x50",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x9A"],
        ["\x5E\x51",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x9B"],
        ["\x5E\x53",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x9C"],
        ["\x5E\x55",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x9D"],
        ["\x5E\x56",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x9E"],
        ["\x5E\x4F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x9F"],
        ["\x5E\x54",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xA0"],
        ["\x5E\x58",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xA1"],
        ["\x5E\x59",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xA2"],
        ["\x5E\x5B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xA3"],
        ["\x5E\x5C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xA4"],
        ["\x5E\x5D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xA5"],
        ["\x53\x7C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xA6"],
        ["\x5E\x5E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xA7"],
        ["\x5E\x5F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xA8"],
        ["\x5E\x60",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xA9"],
        ["\x5E\x61",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xAA"],
        ["\x5E\x62",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xAB"],
        ["\x5E\x63",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xAC"],
        ["\x5E\x64",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xAD"],
        ["\x5E\x65",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xAE"],
        ["\x5E\x66",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xAF"],
        ["\x5E\x67",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xB0"],
        ["\x5E\x68",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xB1"],
        ["\x5E\x69",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xB2"],
        ["\x5E\x6A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xB3"],
        ["\x5E\x6B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xB4"],
        ["\x5E\x6E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xB5"],
        ["\x5E\x6C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xB6"],
        ["\x5E\x6D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xB7"],
        ["\x5E\x6F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xB8"],
        ["\x5E\x70",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xB9"],
        ["\x5E\x71",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xBA"],
        ["\x5E\x72",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xBB"],
        ["\x5E\x79",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xBC"],
        ["\x5E\x74",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xBD"],
        ["\x5E\x76",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xBE"],
        ["\x5E\x77",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xBF"],
        ["\x5E\x78",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x80"],
        ["\x5E\x7A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x81"],
        ["\x5E\x7B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x82"],
        ["\x5E\x7C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x83"],
        ["\x5E\x7D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x84"],
        ["\x5E\x7E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x85"],
        ["\x5E\x7F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x86"],
        ["\x5E\x80",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x87"],
        ["\x56\xA1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x88"],
        ["\x5E\x81",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x89"],
        ["\x5E\x82",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x8A"],
        ["\x5E\x83",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x8B"],
        ["\x5E\x84",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x8C"],
        ["\x5E\x85",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x8D"],
        ["\x5E\x87",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x8E"],
        ["\x5E\x89",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x8F"],
        ["\x5E\x88",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x90"],
        ["\x5E\x8B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x91"],
        ["\x5E\x8C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x92"],
        ["\x5E\x8E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x93"],
        ["\x5E\x8D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x94"],
        ["\x5E\x90",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x95"],
        ["\x5E\x8F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x96"],
        ["\x5E\x91",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x97"],
        ["\x5E\x92",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x98"],
        ["\x5E\x93",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x99"],
        ["\x5E\x95",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x9A"],
        ["\x5E\x96",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x9B"],
        ["\x5E\x97",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x9C"],
        ["\x51\xCB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x9D"],
        ["\x5E\x98",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x9E"],
        ["\x5E\x9A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x9F"],
        ["\x5E\x9B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xA0"],
        ["\x5E\x9C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xA1"],
        ["\x5E\x9D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xA2"],
        ["\x5E\xA0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xA3"],
        ["\x5E\xA3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xA4"],
        ["\x5E\xA5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xA5"],
        ["\x5E\xC2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xA6"],
        ["\x5E\xA9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xA7"],
        ["\x5E\xBE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xA8"],
        ["\x5E\xAC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xA9"],
        ["\x5E\xA6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xAA"],
        ["\x5E\xAF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xAB"],
        ["\x5E\xB0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xAC"],
        ["\x5E\xB1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xAD"],
        ["\x5E\xB2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xAE"],
        ["\x5E\xB3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xAF"],
        ["\x5E\xB4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xB0"],
        ["\x5E\xB5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xB1"],
        ["\x5E\xB6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xB2"],
        ["\x5E\xB7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xB3"],
        ["\x5E\xB8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xB4"],
        ["\x5E\xB9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xB5"],
        ["\x5E\xBA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xB6"],
        ["\x68\x83",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xB7"],
        ["\x5E\xBF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xB8"],
        ["\x50\x4D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xB9"],
        ["\x5E\xC1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xBA"],
        ["\x5E\xC3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xBB"],
        ["\x5E\xC4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xBC"],
        ["\x5E\xC5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xBD"],
        ["\x5E\xC6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xBE"],
        ["\x5E\xA4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xBF"],
        ["\x5E\xC7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x80"],
        ["\x5E\xC8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x81"],
        ["\x5E\xC9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x82"],
        ["\x5E\xCA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x83"],
        ["\x5E\xCB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x84"],
        ["\x5E\xCD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x85"],
        ["\x5E\xCC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x86"],
        ["\x5E\xCE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x87"],
        ["\x5E\xD0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x88"],
        ["\x5E\xCF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x89"],
        ["\x5E\xD2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x8A"],
        ["\x5E\xD3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x8B"],
        ["\x5E\xD4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x8C"],
        ["\x5E\xD6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x8D"],
        ["\x5E\xD7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x8E"],
        ["\x5E\xD5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x8F"],
        ["\x53\xE6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x90"],
        ["\x5E\xD8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x91"],
        ["\x5E\xD9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x92"],
        ["\x5E\xDA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x93"],
        ["\x5E\xDB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x94"],
        ["\x5E\xDC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x95"],
        ["\x5E\xDD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x96"],
        ["\x5E\xDE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x97"],
        ["\x5E\xDF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x98"],
        ["\x5E\xE0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x99"],
        ["\x5E\xE2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x9A"],
        ["\x5E\xE1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x9B"],
        ["\x5E\xE3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x9C"],
        ["\x52\xFD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x9D"],
        ["\x5E\xE4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x9E"],
        ["\x5E\xE5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x9F"],
        ["\x5E\xE6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xA0"],
        ["\x5E\xE9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xA1"],
        ["\x5E\xEA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xA2"],
        ["\x5E\xEB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xA3"],
        ["\x5E\xED",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xA4"],
        ["\x5E\xEE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xA5"],
        ["\x5E\xE8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xA6"],
        ["\x5E\xEF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xA7"],
        ["\x5E\xF0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xA8"],
        ["\x5E\xEC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xA9"],
        ["\x5E\xF1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xAA"],
        ["\x5E\xF2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xAB"],
        ["\x5E\xF3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xAC"],
        ["\x5E\xF4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xAD"],
        ["\x5E\xF5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xAE"],
        ["\x5E\xF6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xAF"],
        ["\x5E\xF7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xB0"],
        ["\x5E\xF8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xB1"],
        ["\x5E\xF9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xB2"],
        ["\x5E\xFA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xB3"],
        ["\x5E\xFB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xB4"],
        ["\x5E\xFC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xB5"],
        ["\x5E\xFD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xB6"],
        ["\x5E\xFE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xB7"],
        ["\x5F\x41",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xB8"],
        ["\x5F\x42",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xB9"],
        ["\x5F\x43",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xBA"],
        ["\x5F\x44",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xBB"],
        ["\x5F\x45",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xBC"],
        ["\x5F\x46",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xBD"],
        ["\x5F\x47",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xBE"],
        ["\x5F\x48",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xBF"],
        ["\x5F\x49",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x80"],
        ["\x5F\x4A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x81"],
        ["\x5F\x4B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x82"],
        ["\x5F\x4C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x83"],
        ["\x5F\x4D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x84"],
        ["\x5F\x4E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x85"],
        ["\x52\x4F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x86"],
        ["\x5F\x4F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x87"],
        ["\x5F\x50",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x88"],
        ["\x5F\x51",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x89"],
        ["\x5F\x52",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x8A"],
        ["\x5F\x53",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x8B"],
        ["\x5F\x54",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x8C"],
        ["\x5F\x55",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x8D"],
        ["\x5F\x56",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x8E"],
        ["\x5F\x57",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x8F"],
        ["\x5F\x58",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x90"],
        ["\x5F\x59",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x91"],
        ["\x5F\x5A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x92"],
        ["\x5F\x5C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x93"],
        ["\x5F\x5D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x94"],
        ["\x5F\x5B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x95"],
        ["\x5F\x5E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x96"],
        ["\x5F\x5F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x97"],
        ["\x5F\x60",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x98"],
        ["\x5F\x61",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x99"],
        ["\x5F\x63",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x9A"],
        ["\x5F\x62",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x9B"],
        ["\x5F\x64",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x9C"],
        ["\x5F\x65",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x9D"],
        ["\x5F\x66",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x9E"],
        ["\x5F\x67",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x9F"],
        ["\x53\x9A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xA0"],
        ["\x5F\x68",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xA1"],
        ["\x5F\x6A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xA2"],
        ["\x5F\x6B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xA3"],
        ["\x5F\x6C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xA4"],
        ["\x5F\x6D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xA5"],
        ["\x52\x99",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xA6"],
        ["\x53\x96",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xA7"],
        ["\x4E\x81",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xA8"],
        ["\x5F\x6E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xA9"],
        ["\x5F\x6F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xAA"],
        ["\x5F\x74",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xAB"],
        ["\x5F\x75",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xAC"],
        ["\x5F\x76",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xAD"],
        ["\x5F\x77",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xAE"],
        ["\x5F\x78",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xAF"],
        ["\x5F\x79",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xB0"],
        ["\x5F\x7B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xB1"],
        ["\x5F\x7C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xB2"],
        ["\x5F\x7D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xB3"],
        ["\x5F\x7E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xB4"],
        ["\x5F\x7F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xB5"],
        ["\x5F\x80",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xB6"],
        ["\x53\xF7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xB7"],
        ["\x5F\x81",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xB8"],
        ["\x5F\x82",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xB9"],
        ["\x5F\x83",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xBA"],
        ["\x5F\x84",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xBB"],
        ["\x5F\x85",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xBC"],
        ["\x5F\x86",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xBD"],
        ["\x5F\x88",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xBE"],
        ["\x5F\x87",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xBF"],
        ["\x51\xCA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x80"],
        ["\x5F\x89",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x81"],
        ["\x5F\x8A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x82"],
        ["\x5F\x8B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x83"],
        ["\x5F\x8C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x84"],
        ["\x5F\x8D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x85"],
        ["\x5F\x8F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x86"],
        ["\x5F\x90",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x87"],
        ["\x5F\x91",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x88"],
        ["\x5F\x92",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x89"],
        ["\x5F\x93",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x8A"],
        ["\x5F\x94",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x8B"],
        ["\x5F\x95",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x8C"],
        ["\x5F\x96",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x8D"],
        ["\x5F\x97",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x8E"],
        ["\x5F\x98",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x8F"],
        ["\x5F\x99",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x90"],
        ["\x5F\x9A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x91"],
        ["\x5F\x9B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x92"],
        ["\x5F\x9C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x93"],
        ["\x5F\x9D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x94"],
        ["\x5F\x9E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x95"],
        ["\x5F\x9F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x96"],
        ["\x5F\xA0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x97"],
        ["\x5F\xA1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x98"],
        ["\x5F\xA2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x99"],
        ["\x5F\xA3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x9A"],
        ["\x5F\xA4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x9B"],
        ["\x5F\xA5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x9C"],
        ["\x53\x50",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x9D"],
        ["\x5F\xA6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x9E"],
        ["\x5F\xA7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x9F"],
        ["\x5F\xA8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xA0"],
        ["\x5F\xA9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xA1"],
        ["\x5F\xAB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xA2"],
        ["\x5F\xAC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xA3"],
        ["\x5F\xAD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xA4"],
        ["\x51\xB9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xA5"],
        ["\x5F\xB0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xA6"],
        ["\x51\x4C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xA7"],
        ["\x5F\xB1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xA8"],
        ["\x5F\xB5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xA9"],
        ["\x5F\xB4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xAA"],
        ["\x5F\xB7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xAB"],
        ["\x5F\xB9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xAC"],
        ["\x5F\xB8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xAD"],
        ["\x5F\xBA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xAE"],
        ["\x5F\xBB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xAF"],
        ["\x5F\xBC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xB0"],
        ["\x5F\xBD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xB1"],
        ["\x5F\xBE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xB2"],
        ["\x5F\xBF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xB3"],
        ["\x5F\xC0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xB4"],
        ["\x5F\xC1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xB5"],
        ["\x5F\xC2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xB6"],
        ["\x5F\xC3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xB7"],
        ["\x5F\xC4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xB8"],
        ["\x5F\xC5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xB9"],
        ["\x5F\xC6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xBA"],
        ["\x5F\xC7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xBB"],
        ["\x5F\xC8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xBC"],
        ["\x5F\xC9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xBD"],
        ["\x5F\xCA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xBE"],
        ["\x5F\xCB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xBF"],
        ["\x5F\xCC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x80"],
        ["\x4D\xF0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x81"],
        ["\x5F\xCD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x82"],
        ["\x5F\xCE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x83"],
        ["\x5F\xCF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x84"],
        ["\x5F\xD0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x85"],
        ["\x5F\xD3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x86"],
        ["\x5F\xD4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x87"],
        ["\x53\x65",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x88"],
        ["\x5F\xD6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x89"],
        ["\x5F\xD7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x8A"],
        ["\x5F\xD8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x8B"],
        ["\x55\x5C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x8C"],
        ["\x52\xD8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x8D"],
        ["\x5F\xDA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x8E"],
        ["\x5F\xDB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x8F"],
        ["\x5F\xDE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x90"],
        ["\x4F\xD7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x91"],
        ["\x51\xF5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x92"],
        ["\x5F\xE0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x93"],
        ["\x54\xF5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x94"],
        ["\x5F\xE1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x95"],
        ["\x53\x6A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x96"],
        ["\x5F\xE2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x97"],
        ["\x5F\xE3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x98"],
        ["\x5F\xE4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x99"],
        ["\x5F\xE5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x9A"],
        ["\x5F\xE6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x9B"],
        ["\x54\xB5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x9C"],
        ["\x5F\xE7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x9D"],
        ["\x5F\xE8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x9E"],
        ["\x5F\xE9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x9F"],
        ["\x5F\xEA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xA0"],
        ["\x5F\xEB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xA1"],
        ["\x53\x66",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xA2"],
        ["\x5F\xEC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xA3"],
        ["\x50\xE7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xA4"],
        ["\x5F\xED",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xA5"],
        ["\x5F\xF0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xA6"],
        ["\x5F\xEE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xA7"],
        ["\x5F\xEF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xA8"],
        ["\x5F\xF1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xA9"],
        ["\x5F\xF2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xAA"],
        ["\x5F\xF3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xAB"],
        ["\x5F\xF5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xAC"],
        ["\x5F\xF4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xAD"],
        ["\x5F\xF6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xAE"],
        ["\x5F\xF7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xAF"],
        ["\x5F\xF8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xB0"],
        ["\x5F\xF9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xB1"],
        ["\x5F\xFA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xB2"],
        ["\x5F\xFB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xB3"],
        ["\x60\x41",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xB4"],
        ["\x5F\xFC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xB5"],
        ["\x5F\xFD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xB6"],
        ["\x5F\xFE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xB7"],
        ["\x60\x42",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xB8"],
        ["\x52\xF0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xB9"],
        ["\x60\x43",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xBA"],
        ["\x60\x44",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xBB"],
        ["\x60\x48",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xBC"],
        ["\x60\x49",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xBD"],
        ["\x60\x47",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xBE"],
        ["\x60\x45",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xBF"],
        ["\x60\x4A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x80"],
        ["\x60\x4B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x81"],
        ["\x60\x4C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x82"],
        ["\x60\x4D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x83"],
        ["\x60\x50",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x84"],
        ["\x60\x51",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x85"],
        ["\x60\x52",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x86"],
        ["\x60\x53",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x87"],
        ["\x60\x54",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x88"],
        ["\x60\x55",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x89"],
        ["\x60\x56",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x8A"],
        ["\x60\x57",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x8B"],
        ["\x60\x5B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x8C"],
        ["\x60\x5C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x8D"],
        ["\x60\x5E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x8E"],
        ["\x60\x5F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x8F"],
        ["\x60\x61",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x90"],
        ["\x60\x62",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x91"],
        ["\x60\x63",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x92"],
        ["\x53\xE7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x93"],
        ["\x60\x65",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x94"],
        ["\x60\x66",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x95"],
        ["\x60\x67",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x96"],
        ["\x60\x68",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x97"],
        ["\x60\x64",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x98"],
        ["\x60\x69",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x99"],
        ["\x60\x6F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x9A"],
        ["\x54\xD5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x9B"],
        ["\x60\x6A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x9C"],
        ["\x60\x60",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x9D"],
        ["\x60\x6B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x9E"],
        ["\x60\x6C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x9F"],
        ["\x60\x6E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xA0"],
        ["\x54\x84",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xA1"],
        ["\x60\x70",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xA2"],
        ["\x50\x48",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xA3"],
        ["\x60\x71",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xA4"],
        ["\x60\x72",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xA5"],
        ["\x53\x4E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xA6"],
        ["\x60\x73",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xA7"],
        ["\x60\x74",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xA8"],
        ["\x60\x75",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xA9"],
        ["\x60\x76",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xAA"],
        ["\x60\x77",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xAB"],
        ["\x60\x78",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xAC"],
        ["\x60\x79",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xAD"],
        ["\x55\xA4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xAE"],
        ["\x60\x7A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xAF"],
        ["\x60\x7B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xB0"],
        ["\x60\x6D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xB1"],
        ["\x60\x7C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xB2"],
        ["\x60\x7E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xB3"],
        ["\x51\xE8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xB4"],
        ["\x60\x7F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xB5"],
        ["\x60\x7D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xB6"],
        ["\x60\x80",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xB7"],
        ["\x60\x81",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xB8"],
        ["\x60\x83",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xB9"],
        ["\x60\x84",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xBA"],
        ["\x4F\x53",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xBB"],
        ["\x60\x88",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xBC"],
        ["\x60\x85",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xBD"],
        ["\x60\x87",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xBE"],
        ["\x4C\xEE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xBF"],
        ["\x60\x89",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x80"],
        ["\x60\x8B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x81"],
        ["\x60\x8A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x82"],
        ["\x60\x8C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x83"],
        ["\x60\x86",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x84"],
        ["\x51\x7C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x85"],
        ["\x60\x8D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x86"],
        ["\x60\x8E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x87"],
        ["\x60\x8F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x88"],
        ["\x60\x90",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x89"],
        ["\x60\x91",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x8A"],
        ["\x60\x92",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x8B"],
        ["\x60\x93",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x8C"],
        ["\x60\x94",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x8D"],
        ["\x60\x95",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x8E"],
        ["\x60\x97",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x8F"],
        ["\x60\x98",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x90"],
        ["\x4F\x99",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x91"],
        ["\x51\xF2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x92"],
        ["\x60\x96",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x93"],
        ["\x60\x9A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x94"],
        ["\x60\x9B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x95"],
        ["\x60\x9C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x96"],
        ["\x52\xAA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x97"],
        ["\x60\x99",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x98"],
        ["\x60\x9D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x99"],
        ["\x60\x9E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x9A"],
        ["\x60\x9F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x9B"],
        ["\x60\xA0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x9C"],
        ["\x60\xA1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x9D"],
        ["\x60\xA2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x9E"],
        ["\x60\xA6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x9F"],
        ["\x60\xA3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xA0"],
        ["\x60\xA4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xA1"],
        ["\x60\xA5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xA2"],
        ["\x60\xA7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xA3"],
        ["\x60\xA8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xA4"],
        ["\x60\xA9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xA5"],
        ["\x60\xAA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xA6"],
        ["\x60\xAB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xA7"],
        ["\x60\xAC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xA8"],
        ["\x60\xAE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xA9"],
        ["\x51\xBC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xAA"],
        ["\x60\xAF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xAB"],
        ["\x60\xB0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xAC"],
        ["\x60\xB3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xAD"],
        ["\x60\xB1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xAE"],
        ["\x60\xB4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xAF"],
        ["\x60\xB2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xB0"],
        ["\x67\x88",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xB1"],
        ["\x60\xB5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xB2"],
        ["\x60\xB6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xB3"],
        ["\x60\xB7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xB4"],
        ["\x60\xB8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xB5"],
        ["\x52\xC2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xB6"],
        ["\x60\xB9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xB7"],
        ["\x60\xBA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xB8"],
        ["\x60\xBB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xB9"],
        ["\x60\xBC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xBA"],
        ["\x60\xBD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xBB"],
        ["\x60\xBE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xBC"],
        ["\x60\xBF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xBD"],
        ["\x60\xC0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xBE"],
        ["\x60\xC1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xBF"],
        ["\x60\xC2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x80"],
        ["\x60\xC3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x81"],
        ["\x60\xC5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x82"],
        ["\x60\xC7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x83"],
        ["\x60\xC8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x84"],
        ["\x60\xC9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x85"],
        ["\x52\x68",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x86"],
        ["\x60\xCA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x87"],
        ["\x60\xCB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x88"],
        ["\x60\xCC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x89"],
        ["\x60\xCD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x8A"],
        ["\x60\xCE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x8B"],
        ["\x60\xCF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x8C"],
        ["\x60\xD0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x8D"],
        ["\x53\x74",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x8E"],
        ["\x54\xED",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x8F"],
        ["\x54\xEB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x90"],
        ["\x54\xD3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x91"],
        ["\x60\xD1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x92"],
        ["\x60\xD2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x93"],
        ["\x60\xD3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x94"],
        ["\x60\xD5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x95"],
        ["\x60\xD6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x96"],
        ["\x60\xD7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x97"],
        ["\x60\xF3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x98"],
        ["\x60\xD8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x99"],
        ["\x60\xD9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x9A"],
        ["\x60\xE8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x9B"],
        ["\x60\xDB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x9C"],
        ["\x60\xDC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x9D"],
        ["\x60\xDD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x9E"],
        ["\x60\xDF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x9F"],
        ["\x60\xE0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xA0"],
        ["\x60\xE2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xA1"],
        ["\x60\xE3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xA2"],
        ["\x60\xE4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xA3"],
        ["\x60\xE6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xA4"],
        ["\x60\xE7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xA5"],
        ["\x60\xE9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xA6"],
        ["\x60\xEA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xA7"],
        ["\x55\xA8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xA8"],
        ["\x60\xEB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xA9"],
        ["\x60\xEC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xAA"],
        ["\x60\xF2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xAB"],
        ["\x60\xED",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xAC"],
        ["\x60\xEE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xAD"],
        ["\x60\xE5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xAE"],
        ["\x5B\xCC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xAF"],
        ["\x60\xF0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xB0"],
        ["\x60\xF1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xB1"],
        ["\x60\xF5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xB2"],
        ["\x60\xF4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xB3"],
        ["\x60\xF6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xB4"],
        ["\x60\xF7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xB5"],
        ["\x60\xF8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xB6"],
        ["\x60\xF9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xB7"],
        ["\x60\xEF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xB8"],
        ["\x61\x42",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xB9"],
        ["\x60\xFA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xBA"],
        ["\x60\xFB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xBB"],
        ["\x60\xFC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xBC"],
        ["\x60\xFE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xBD"],
        ["\x61\x41",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xBE"],
        ["\x61\x43",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xBF"],
        ["\x61\x44",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x80"],
        ["\x61\x45",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x81"],
        ["\x61\x46",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x82"],
        ["\x61\x47",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x83"],
        ["\x61\x4B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x84"],
        ["\x60\xDE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x85"],
        ["\x61\x48",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x86"],
        ["\x61\x49",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x87"],
        ["\x61\x4A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x88"],
        ["\x52\x78",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x89"],
        ["\x61\x4C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x8A"],
        ["\x61\x4E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x8B"],
        ["\x61\x4F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x8C"],
        ["\x52\x73",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x8D"],
        ["\x61\x50",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x8E"],
        ["\x61\x51",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x8F"],
        ["\x61\x52",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x90"],
        ["\x61\x4D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x91"],
        ["\x61\x53",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x92"],
        ["\x53\x9C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x93"],
        ["\x61\x54",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x94"],
        ["\x61\x55",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x95"],
        ["\x61\x56",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x96"],
        ["\x61\x58",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x97"],
        ["\x54\xCB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x98"],
        ["\x61\x59",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x99"],
        ["\x51\x6E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x9A"],
        ["\x61\x5A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x9B"],
        ["\x61\x5B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x9C"],
        ["\x61\x5C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x9D"],
        ["\x61\x5D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x9E"],
        ["\x61\x5E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x9F"],
        ["\x61\x5F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xA0"],
        ["\x61\x60",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xA1"],
        ["\x61\x62",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xA2"],
        ["\x61\x61",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xA3"],
        ["\x61\x63",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xA4"],
        ["\x61\x64",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xA5"],
        ["\x61\x65",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xA6"],
        ["\x61\x66",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xA7"],
        ["\x61\x68",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xA8"],
        ["\x61\x67",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xA9"],
        ["\x61\x69",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xAA"],
        ["\x61\x6A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xAB"],
        ["\x61\x6B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xAC"],
        ["\x61\x6C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xAD"],
        ["\x61\x6D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xAE"],
        ["\x61\x6F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xAF"],
        ["\x61\x70",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xB0"],
        ["\x61\x72",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xB1"],
        ["\x61\x73",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xB2"],
        ["\x61\x71",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xB3"],
        ["\x61\x74",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xB4"],
        ["\x61\x75",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xB5"],
        ["\x61\x76",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xB6"],
        ["\x61\x78",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xB7"],
        ["\x61\x79",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xB8"],
        ["\x61\x7A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xB9"],
        ["\x61\x7B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xBA"],
        ["\x54\xF9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xBB"],
        ["\x61\x7C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xBC"],
        ["\x61\x7D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xBD"],
        ["\x61\x7E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xBE"],
        ["\x61\x7F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xBF"],
        ["\x61\x80",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x80"],
        ["\x66\xDA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x81"],
        ["\x53\xDC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x82"],
        ["\x61\x81",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x83"],
        ["\x61\x82",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x84"],
        ["\x61\x83",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x85"],
        ["\x54\xE4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x86"],
        ["\x61\x84",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x87"],
        ["\x61\x85",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x88"],
        ["\x61\x86",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x89"],
        ["\x61\x87",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x8A"],
        ["\x61\x88",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x8B"],
        ["\x61\x89",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x8C"],
        ["\x61\x8A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x8D"],
        ["\x61\x8B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x8E"],
        ["\x61\x8C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x8F"],
        ["\x61\x8D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x90"],
        ["\x54\x79",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x91"],
        ["\x61\x8E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x92"],
        ["\x61\x8F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x93"],
        ["\x61\x90",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x94"],
        ["\x61\x91",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x95"],
        ["\x61\x92",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x96"],
        ["\x61\x93",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x97"],
        ["\x61\x94",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x98"],
        ["\x61\x95",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x99"],
        ["\x61\x96",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x9A"],
        ["\x61\x97",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x9B"],
        ["\x61\x98",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x9C"],
        ["\x53\xB6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x9D"],
        ["\x61\x99",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x9E"],
        ["\x52\x92",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x9F"],
        ["\x61\x9A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xA0"],
        ["\x61\x9B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xA1"],
        ["\x61\x9C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xA2"],
        ["\x61\x9D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xA3"],
        ["\x61\x9E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xA4"],
        ["\x61\x9F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xA5"],
        ["\x61\xA0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xA6"],
        ["\x61\xA1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xA7"],
        ["\x61\xA2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xA8"],
        ["\x61\xA3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xA9"],
        ["\x61\xA4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xAA"],
        ["\x52\x88",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xAB"],
        ["\x61\xA5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xAC"],
        ["\x61\xA6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xAD"],
        ["\x61\xA7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xAE"],
        ["\x61\xA8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xAF"],
        ["\x4C\x96",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xB0"],
        ["\x61\xA9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xB1"],
        ["\x61\xAA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xB2"],
        ["\x61\xAB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xB3"],
        ["\x66\x73",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xB4"],
        ["\x61\xAC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xB5"],
        ["\x61\xAD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xB6"],
        ["\x61\xAE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xB7"],
        ["\x61\xAF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xB8"],
        ["\x61\xB0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xB9"],
        ["\x61\xB1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xBA"],
        ["\x61\xB2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xBB"],
        ["\x61\xB3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xBC"],
        ["\x61\xB5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xBD"],
        ["\x61\xB6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xBE"],
        ["\x61\xB7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xBF"],
        ["\x61\xB8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x80"],
        ["\x61\xB9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x81"],
        ["\x61\xBA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x82"],
        ["\x61\xBB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x83"],
        ["\x61\xBC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x84"],
        ["\x61\xBD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x85"],
        ["\x61\xC1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x86"],
        ["\x61\xBE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x87"],
        ["\x61\xB4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x88"],
        ["\x61\xBF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x89"],
        ["\x61\xC2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x8A"],
        ["\x61\xC4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x8B"],
        ["\x61\xC0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x8C"],
        ["\x61\xC6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x8D"],
        ["\x61\xC3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x8E"],
        ["\x61\xC7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x8F"],
        ["\x61\xC8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x90"],
        ["\x61\xC9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x91"],
        ["\x61\xCA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x92"],
        ["\x61\xCB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x93"],
        ["\x61\xCC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x94"],
        ["\x61\xCD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x95"],
        ["\x61\xCF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x96"],
        ["\x61\xCE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x97"],
        ["\x61\xC5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x98"],
        ["\x61\xD0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x99"],
        ["\x61\xD1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x9A"],
        ["\x61\xD2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x9B"],
        ["\x51\x73",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x9C"],
        ["\x61\xD3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x9D"],
        ["\x61\xD4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x9E"],
        ["\x61\xD5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x9F"],
        ["\x61\xD6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xA0"],
        ["\x61\xD7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xA1"],
        ["\x61\xD8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xA2"],
        ["\x53\x58",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xA3"],
        ["\x62\xBA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xA4"],
        ["\x61\xD9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xA5"],
        ["\x61\xDA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xA6"],
        ["\x61\xDC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xA7"],
        ["\x61\xDD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xA8"],
        ["\x61\xDE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xA9"],
        ["\x61\xE0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xAA"],
        ["\x61\xE1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xAB"],
        ["\x61\xE2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xAC"],
        ["\x61\xE3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xAD"],
        ["\x54\xAE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xAE"],
        ["\x61\xE5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xAF"],
        ["\x61\xE4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xB0"],
        ["\x61\xE6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xB1"],
        ["\x61\xE7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xB2"],
        ["\x61\xE8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xB3"],
        ["\x61\xE9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xB4"],
        ["\x61\xEA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xB5"],
        ["\x61\xEB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xB6"],
        ["\x61\xDF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xB7"],
        ["\x61\xEC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xB8"],
        ["\x61\xED",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xB9"],
        ["\x53\xC5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xBA"],
        ["\x61\xEE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xBB"],
        ["\x61\xEF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xBC"],
        ["\x61\xF0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xBD"],
        ["\x61\xF1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xBE"],
        ["\x61\xF2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xBF"],
        ["\x61\xF3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x80"],
        ["\x61\xF4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x81"],
        ["\x61\xF5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x82"],
        ["\x61\xF6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x83"],
        ["\x61\xF7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x84"],
        ["\x61\xF9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x85"],
        ["\x61\xFA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x86"],
        ["\x61\xFB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x87"],
        ["\x62\x44",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x88"],
        ["\x62\x60",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x89"],
        ["\x61\xFC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x8A"],
        ["\x61\xFD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x8B"],
        ["\x61\xFE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x8C"],
        ["\x62\x41",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x8D"],
        ["\x62\x42",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x8E"],
        ["\x62\x43",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x8F"],
        ["\x62\x45",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x90"],
        ["\x62\x46",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x91"],
        ["\x62\x47",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x92"],
        ["\x62\x49",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x93"],
        ["\x62\x4A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x94"],
        ["\x54\x7B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x95"],
        ["\x62\x4B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x96"],
        ["\x62\x4C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x97"],
        ["\x62\x4D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x98"],
        ["\x62\x4E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x99"],
        ["\x62\x4F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x9A"],
        ["\x62\x50",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x9B"],
        ["\x62\x51",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x9C"],
        ["\x53\xF6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x9D"],
        ["\x62\x52",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x9E"],
        ["\x62\x62",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x9F"],
        ["\x62\x53",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xA0"],
        ["\x62\x54",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xA1"],
        ["\x62\x55",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xA2"],
        ["\x62\x56",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xA3"],
        ["\x62\x57",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xA4"],
        ["\x62\x58",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xA5"],
        ["\x62\x59",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xA6"],
        ["\x54\x86",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xA7"],
        ["\x62\x5C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xA8"],
        ["\x62\x5D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xA9"],
        ["\x62\x5E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xAA"],
        ["\x62\x5F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xAB"],
        ["\x62\x5A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xAC"],
        ["\x62\x61",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xAD"],
        ["\x62\x63",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xAE"],
        ["\x62\x64",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xAF"],
        ["\x62\x65",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xB0"],
        ["\x62\x66",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xB1"],
        ["\x54\xE9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xB2"],
        ["\x62\x68",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xB3"],
        ["\x62\x6A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xB4"],
        ["\x62\x6B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xB5"],
        ["\x62\x6C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xB6"],
        ["\x62\x6D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xB7"],
        ["\x62\x6E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xB8"],
        ["\x62\x69",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xB9"],
        ["\x62\x6F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xBA"],
        ["\x62\x70",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xBB"],
        ["\x62\x71",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xBC"],
        ["\x62\x72",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xBD"],
        ["\x54\xD8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xBE"],
        ["\x62\x73",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xBF"],
        ["\x62\x75",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x80"],
        ["\x62\x84",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x81"],
        ["\x62\x9D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x82"],
        ["\x62\x76",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x83"],
        ["\x51\x6C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x84"],
        ["\x62\x77",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x85"],
        ["\x62\x79",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x86"],
        ["\x62\x9F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x87"],
        ["\x62\x7A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x88"],
        ["\x62\x7B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x89"],
        ["\x62\x7C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x8A"],
        ["\x62\x90",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x8B"],
        ["\x62\x7F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x8C"],
        ["\x62\x80",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x8D"],
        ["\x62\x81",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x8E"],
        ["\x62\x82",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x8F"],
        ["\x4B\x75",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x90"],
        ["\x62\x83",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x91"],
        ["\x62\x7D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x92"],
        ["\x62\x85",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x93"],
        ["\x62\x86",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x94"],
        ["\x62\x78",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x95"],
        ["\x62\x87",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x96"],
        ["\x62\x88",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x97"],
        ["\x62\x89",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x98"],
        ["\x62\x94",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x99"],
        ["\x62\x8B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x9A"],
        ["\x62\x8C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x9B"],
        ["\x62\x8D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x9C"],
        ["\x62\x8E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x9D"],
        ["\x62\x8F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x9E"],
        ["\x62\x91",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x9F"],
        ["\x62\x92",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xA0"],
        ["\x62\x93",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xA1"],
        ["\x54\xA8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xA2"],
        ["\x62\x95",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xA3"],
        ["\x62\x96",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xA4"],
        ["\x62\x97",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xA5"],
        ["\x62\x98",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xA6"],
        ["\x62\x99",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xA7"],
        ["\x62\x9A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xA8"],
        ["\x62\x9B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xA9"],
        ["\x62\x9C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xAA"],
        ["\x51\x8B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xAB"],
        ["\x62\xA0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xAC"],
        ["\x62\xA2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xAD"],
        ["\x62\xA3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xAE"],
        ["\x62\xA4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xAF"],
        ["\x62\xA5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xB0"],
        ["\x54\x96",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xB1"],
        ["\x62\xA7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xB2"],
        ["\x62\xA9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xB3"],
        ["\x62\xAA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xB4"],
        ["\x62\xAB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xB5"],
        ["\x62\xAC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xB6"],
        ["\x62\xAD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xB7"],
        ["\x62\xAE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xB8"],
        ["\x62\xAF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xB9"],
        ["\x62\xB0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xBA"],
        ["\x62\xB1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xBB"],
        ["\x62\xB2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xBC"],
        ["\x4C\x95",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xBD"],
        ["\x62\xB4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xBE"],
        ["\x62\xB5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xBF"],
        ["\x62\xB6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x80"],
        ["\x62\xB7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x81"],
        ["\x62\xB8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x82"],
        ["\x62\xBC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x83"],
        ["\x62\xBD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x84"],
        ["\x62\xBE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x85"],
        ["\x62\xBF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x86"],
        ["\x62\xC0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x87"],
        ["\x62\xC1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x88"],
        ["\x62\xC2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x89"],
        ["\x62\xC3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x8A"],
        ["\x62\xC4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x8B"],
        ["\x62\xC5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x8C"],
        ["\x62\xC6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x8D"],
        ["\x62\xC7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x8E"],
        ["\x62\xC8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x8F"],
        ["\x62\xC9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x90"],
        ["\x53\xED",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x91"],
        ["\x4E\xDA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x92"],
        ["\x62\xCA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x93"],
        ["\x62\xCB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x94"],
        ["\x62\xCC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x95"],
        ["\x62\xCD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x96"],
        ["\x62\xCF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x97"],
        ["\x62\xD0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x98"],
        ["\x52\xFB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x99"],
        ["\x62\xD2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x9A"],
        ["\x62\xD3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x9B"],
        ["\x62\xD4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x9C"],
        ["\x62\xD5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x9D"],
        ["\x62\xD6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x9E"],
        ["\x62\xD7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x9F"],
        ["\x62\xD9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xA0"],
        ["\x62\xD8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xA1"],
        ["\x62\xDA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xA2"],
        ["\x62\xDB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xA3"],
        ["\x62\xDC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xA4"],
        ["\x62\xDD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xA5"],
        ["\x62\xDE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xA6"],
        ["\x62\xDF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xA7"],
        ["\x62\xE0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xA8"],
        ["\x53\x51",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xA9"],
        ["\x62\xE3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xAA"],
        ["\x62\xE4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xAB"],
        ["\x62\xE5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xAC"],
        ["\x62\xE6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xAD"],
        ["\x62\xE7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xAE"],
        ["\x62\xE8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xAF"],
        ["\x62\xE9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xB0"],
        ["\x4F\x74",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xB1"],
        ["\x62\xEA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xB2"],
        ["\x62\xEB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xB3"],
        ["\x62\xEC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xB4"],
        ["\x62\xED",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xB5"],
        ["\x62\xEE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xB6"],
        ["\x62\xEF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xB7"],
        ["\x62\xF0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xB8"],
        ["\x62\xF1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xB9"],
        ["\x62\xF2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xBA"],
        ["\x62\xF3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xBB"],
        ["\x62\xF4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xBC"],
        ["\x62\xF5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xBD"],
        ["\x62\xF6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xBE"],
        ["\x52\x6D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xBF"],
        ["\x62\xF7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x80"],
        ["\x62\xF8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x81"],
        ["\x62\xF9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x82"],
        ["\x62\xFA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x83"],
        ["\x63\x46",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x84"],
        ["\x62\xFB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x85"],
        ["\x62\xFC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x86"],
        ["\x62\xFD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x87"],
        ["\x62\xFE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x88"],
        ["\x63\x41",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x89"],
        ["\x63\x42",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x8A"],
        ["\x63\x43",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x8B"],
        ["\x63\x47",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x8C"],
        ["\x63\x48",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x8D"],
        ["\x63\x49",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x8E"],
        ["\x63\x4A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x8F"],
        ["\x63\x45",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x90"],
        ["\x55\xBD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x91"],
        ["\x63\x4C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x92"],
        ["\x63\x4E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x93"],
        ["\x63\x44",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x94"],
        ["\x63\x4F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x95"],
        ["\x63\x50",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x96"],
        ["\x63\x51",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x97"],
        ["\x63\x52",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x98"],
        ["\x63\x53",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x99"],
        ["\x63\x54",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x9A"],
        ["\x63\x55",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x9B"],
        ["\x63\x56",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x9C"],
        ["\x63\x57",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x9D"],
        ["\x54\xF4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x9E"],
        ["\x63\x4D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x9F"],
        ["\x63\x59",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xA0"],
        ["\x63\x5A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xA1"],
        ["\x63\x5B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xA2"],
        ["\x63\x5C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xA3"],
        ["\x63\x5F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xA4"],
        ["\x63\x61",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xA5"],
        ["\x63\x62",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xA6"],
        ["\x63\x63",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xA7"],
        ["\x63\x64",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xA8"],
        ["\x63\x5D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xA9"],
        ["\x63\x58",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xAA"],
        ["\x63\x65",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xAB"],
        ["\x63\x60",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xAC"],
        ["\x63\x66",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xAD"],
        ["\x63\x67",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xAE"],
        ["\x63\x68",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xAF"],
        ["\x63\x6A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xB0"],
        ["\x63\x6B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xB1"],
        ["\x63\x6C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xB2"],
        ["\x63\x69",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xB3"],
        ["\x63\x6D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xB4"],
        ["\x63\x6F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xB5"],
        ["\x63\x6E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xB6"],
        ["\x63\x71",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xB7"],
        ["\x63\x72",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xB8"],
        ["\x63\x73",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xB9"],
        ["\x63\x74",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xBA"],
        ["\x63\x75",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xBB"],
        ["\x63\x76",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xBC"],
        ["\x63\x77",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xBD"],
        ["\x63\x7C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xBE"],
        ["\x63\x78",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xBF"],
        ["\x63\x79",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x80"],
        ["\x63\x85",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x81"],
        ["\x63\x7A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x82"],
        ["\x63\x7B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x83"],
        ["\x63\x7D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x84"],
        ["\x63\x7E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x85"],
        ["\x63\x7F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x86"],
        ["\x63\x80",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x87"],
        ["\x63\x81",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x88"],
        ["\x63\x82",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x89"],
        ["\x63\x83",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x8A"],
        ["\x54\xC5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x8B"],
        ["\x63\x84",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x8C"],
        ["\x63\x86",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x8D"],
        ["\x63\x87",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x8E"],
        ["\x63\x88",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x8F"],
        ["\x63\x89",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x90"],
        ["\x63\x8A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x91"],
        ["\x63\x8B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x92"],
        ["\x63\x8C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x93"],
        ["\x63\x8D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x94"],
        ["\x63\x8E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x95"],
        ["\x63\x8F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x96"],
        ["\x53\x49",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x97"],
        ["\x63\x91",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x98"],
        ["\x63\x92",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x99"],
        ["\x63\x93",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x9A"],
        ["\x63\x94",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x9B"],
        ["\x63\x97",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x9C"],
        ["\x63\x98",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x9D"],
        ["\x63\x9F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x9E"],
        ["\x63\x99",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x9F"],
        ["\x63\x9A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xA0"],
        ["\x63\x95",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xA1"],
        ["\x63\x9B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xA2"],
        ["\x63\x9C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xA3"],
        ["\x50\x6B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xA4"],
        ["\x63\x9D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xA5"],
        ["\x63\x9E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xA6"],
        ["\x63\xA0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xA7"],
        ["\x63\xA2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xA8"],
        ["\x63\x96",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xA9"],
        ["\x63\xA3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xAA"],
        ["\x63\xA4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xAB"],
        ["\x63\xA5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xAC"],
        ["\x63\xA7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xAD"],
        ["\x63\xA8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xAE"],
        ["\x63\xA6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xAF"],
        ["\x63\xA9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xB0"],
        ["\x63\xAA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xB1"],
        ["\x63\xAB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xB2"],
        ["\x63\xAC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xB3"],
        ["\x63\xAD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xB4"],
        ["\x63\xAE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xB5"],
        ["\x63\xAF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xB6"],
        ["\x63\xB0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xB7"],
        ["\x63\xB1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xB8"],
        ["\x63\xB2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xB9"],
        ["\x63\xB3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xBA"],
        ["\x63\xB4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xBB"],
        ["\x63\xB5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xBC"],
        ["\x63\xB6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xBD"],
        ["\x63\xB7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xBE"],
        ["\x63\xB8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xBF"],
        ["\x63\xBA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x80"],
        ["\x63\xB9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x81"],
        ["\x63\xBB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x82"],
        ["\x63\xBC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x83"],
        ["\x53\x60",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x84"],
        ["\x63\xBD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x85"],
        ["\x63\xBE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x86"],
        ["\x63\xBF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x87"],
        ["\x63\xC0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x88"],
        ["\x63\xC1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x89"],
        ["\x63\xC2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x8A"],
        ["\x63\xC3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x8B"],
        ["\x63\xC4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x8C"],
        ["\x63\xC6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x8D"],
        ["\x63\xC7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x8E"],
        ["\x63\xC8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x8F"],
        ["\x63\xC9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x90"],
        ["\x63\xCA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x91"],
        ["\x63\xCC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x92"],
        ["\x63\xCD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x93"],
        ["\x63\xCE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x94"],
        ["\x63\xCF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x95"],
        ["\x63\xD0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x96"],
        ["\x63\xD1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x97"],
        ["\x63\xD2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x98"],
        ["\x63\xD3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x99"],
        ["\x63\xD5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x9A"],
        ["\x63\xD6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x9B"],
        ["\x63\xD7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x9C"],
        ["\x63\xD8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x9D"],
        ["\x63\xD9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x9E"],
        ["\x63\xDA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x9F"],
        ["\x63\xDB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xA0"],
        ["\x63\xDC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xA1"],
        ["\x63\xDD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xA2"],
        ["\x63\xDE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xA3"],
        ["\x50\xB2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xA4"],
        ["\x63\xE2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xA5"],
        ["\x63\xE3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xA6"],
        ["\x63\xE4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xA7"],
        ["\x4E\x96",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xA8"],
        ["\x63\xE5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xA9"],
        ["\x63\xE6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xAA"],
        ["\x63\xE7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xAB"],
        ["\x63\xE8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xAC"],
        ["\x63\xE9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xAD"],
        ["\x63\xEA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xAE"],
        ["\x63\xEB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xAF"],
        ["\x63\xF0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xB0"],
        ["\x63\xF1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xB1"],
        ["\x63\xF2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xB2"],
        ["\x63\xF3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xB3"],
        ["\x63\xF4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xB4"],
        ["\x63\xF5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xB5"],
        ["\x63\xEC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xB6"],
        ["\x63\xF6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xB7"],
        ["\x63\xF7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xB8"],
        ["\x63\xF8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xB9"],
        ["\x63\xF9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xBA"],
        ["\x63\xFA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xBB"],
        ["\x63\xFC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xBC"],
        ["\x63\xFD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xBD"],
        ["\x63\xFE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xBE"],
        ["\x64\x41",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xBF"],
        ["\x53\x81",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x80"],
        ["\x63\xFB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x81"],
        ["\x64\x42",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x82"],
        ["\x64\x43",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x83"],
        ["\x64\x44",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x84"],
        ["\x64\x46",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x85"],
        ["\x64\x47",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x86"],
        ["\x64\x48",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x87"],
        ["\x64\x49",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x88"],
        ["\x64\x4B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x89"],
        ["\x64\x4C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x8A"],
        ["\x64\x4D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x8B"],
        ["\x64\x4E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x8C"],
        ["\x64\x4A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x8D"],
        ["\x64\x4F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x8E"],
        ["\x64\x51",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x8F"],
        ["\x64\x52",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x90"],
        ["\x64\x53",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x91"],
        ["\x64\x55",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x92"],
        ["\x64\x56",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x93"],
        ["\x64\x57",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x94"],
        ["\x64\x54",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x95"],
        ["\x64\x58",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x96"],
        ["\x64\x59",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x97"],
        ["\x64\x5A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x98"],
        ["\x64\x5B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x99"],
        ["\x64\x5C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x9A"],
        ["\x64\x5D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x9B"],
        ["\x64\x5E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x9C"],
        ["\x64\x5F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x9D"],
        ["\x64\x60",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x9E"],
        ["\x64\x61",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x9F"],
        ["\x64\x62",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xA0"],
        ["\x64\x63",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xA1"],
        ["\x64\x64",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xA2"],
        ["\x64\x66",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xA3"],
        ["\x64\x67",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xA4"],
        ["\x64\x68",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xA5"],
        ["\x64\x69",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xA6"],
        ["\x64\x6A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xA7"],
        ["\x64\x6B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xA8"],
        ["\x64\x6D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xA9"],
        ["\x64\x65",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xAA"],
        ["\x64\x6C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xAB"],
        ["\x64\x6E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xAC"],
        ["\x64\x6F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xAD"],
        ["\x64\x70",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xAE"],
        ["\x64\x72",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xAF"],
        ["\x64\x73",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xB0"],
        ["\x64\x74",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xB1"],
        ["\x64\x71",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xB2"],
        ["\x64\x76",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xB3"],
        ["\x64\x77",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xB4"],
        ["\x64\x75",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xB5"],
        ["\x55\x66",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xB6"],
        ["\x64\x7A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xB7"],
        ["\x64\x7B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xB8"],
        ["\x64\x7E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xB9"],
        ["\x64\x7F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xBA"],
        ["\x64\x80",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xBB"],
        ["\x53\x5A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xBC"],
        ["\x55\x74",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xBD"],
        ["\x64\x82",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xBE"],
        ["\x64\x81",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xBF"],
        ["\x64\x83",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x80"],
        ["\x64\x84",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x81"],
        ["\x64\x86",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x82"],
        ["\x68\x6E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x83"],
        ["\x64\x87",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x84"],
        ["\x64\x79",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x85"],
        ["\x64\x88",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x86"],
        ["\x64\x89",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x87"],
        ["\x64\x8A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x88"],
        ["\x64\x8B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x89"],
        ["\x64\x8C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x8A"],
        ["\x51\xC9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x8B"],
        ["\x64\x8F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x8C"],
        ["\x51\xDE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x8D"],
        ["\x64\x90",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x8E"],
        ["\x64\x91",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x8F"],
        ["\x64\x92",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x90"],
        ["\x64\x93",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x91"],
        ["\x64\x94",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x92"],
        ["\x64\x95",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x93"],
        ["\x64\x96",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x94"],
        ["\x64\x97",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x95"],
        ["\x64\x98",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x96"],
        ["\x64\x99",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x97"],
        ["\x64\x9A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x98"],
        ["\x64\x9B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x99"],
        ["\x64\x9C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x9A"],
        ["\x64\x9D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x9B"],
        ["\x64\x9E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x9C"],
        ["\x64\xA0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x9D"],
        ["\x64\x9F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x9E"],
        ["\x64\xA1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x9F"],
        ["\x64\xA2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xA0"],
        ["\x64\xA3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xA1"],
        ["\x64\xA4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xA2"],
        ["\x64\xA5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xA3"],
        ["\x64\xA6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xA4"],
        ["\x64\xA7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xA5"],
        ["\x64\xA8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xA6"],
        ["\x64\xA9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xA7"],
        ["\x64\xAA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xA8"],
        ["\x64\xAB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xA9"],
        ["\x64\xAC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xAA"],
        ["\x64\xAD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xAB"],
        ["\x64\xAE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xAC"],
        ["\x64\xAF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xAD"],
        ["\x64\xB0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xAE"],
        ["\x64\xB1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xAF"],
        ["\x50\xFC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xB0"],
        ["\x64\xB3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xB1"],
        ["\x64\xB2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xB2"],
        ["\x64\xB4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xB3"],
        ["\x64\xB5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xB4"],
        ["\x64\xB7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xB5"],
        ["\x64\xB8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xB6"],
        ["\x64\xB6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xB7"],
        ["\x64\xB9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xB8"],
        ["\x64\xBA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xB9"],
        ["\x64\xBB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xBA"],
        ["\x64\xBC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xBB"],
        ["\x64\xBD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xBC"],
        ["\x64\xBE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xBD"],
        ["\x64\xBF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xBE"],
        ["\x64\xC0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xBF"],
        ["\x64\xC2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x80"],
        ["\x64\xC1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x81"],
        ["\x50\x44",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x82"],
        ["\x53\x7A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x83"],
        ["\x64\xC5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x84"],
        ["\x64\xC3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x85"],
        ["\x64\xC4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x86"],
        ["\x64\xC6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x87"],
        ["\x64\xC7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x88"],
        ["\x64\xC8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x89"],
        ["\x64\xCA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x8A"],
        ["\x64\xCB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x8B"],
        ["\x64\xCC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x8C"],
        ["\x64\xCD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x8D"],
        ["\x64\xCE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x8E"],
        ["\x64\xCF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x8F"],
        ["\x64\xD0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x90"],
        ["\x64\xD2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x91"],
        ["\x64\xD3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x92"],
        ["\x64\xD4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x93"],
        ["\x64\xD7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x94"],
        ["\x64\xD5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x95"],
        ["\x64\xD6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x96"],
        ["\x64\xD8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x97"],
        ["\x51\x5B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x98"],
        ["\x64\xD1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x99"],
        ["\x64\xD9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x9A"],
        ["\x64\xDA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x9B"],
        ["\x64\xDB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x9C"],
        ["\x64\xDC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x9D"],
        ["\x64\xDD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x9E"],
        ["\x64\xDE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x9F"],
        ["\x64\xDF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\xA0"],
        ["\x64\xE2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\xA1"],
        ["\x64\xE0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\xA2"],
        ["\x64\xE1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\xA3"],
        ["\x64\xE3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\xA4"],
        ["\x64\xE4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\xA5"],
        ["\x64\xE5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\xA6"],
        ["\x64\xE6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\xA7"],
        ["\x64\xE7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\xA8"],
        ["\x64\xE8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\xA9"],
        ["\x64\xE9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\xAA"],
        ["\x64\xEA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\xAB"],
        ["\x64\xEB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\xAC"],
        ["\x64\xEE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\xAD"],
        ["\x64\xEF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\xAE"],
        ["\x64\xF0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\xAF"],
        ["\x64\xF2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\xB0"],
        ["\x64\xF3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\xB1"],
        ["\x64\xF4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\xB2"],
        ["\x4E\x9E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\xB3"],
        ["\x64\xF5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\xB4"],
        ["\x51\x86",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\xB5"],
        ["\x64\xF7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\xB6"],
        ["\x64\xF8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\xB7"],
        ["\x64\xF9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\xB8"],
        ["\x54\xA9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\xB9"],
        ["\x64\xFB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\xBA"],
        ["\x64\xFC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\xBB"],
        ["\x64\xFE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\xBC"],
        ["\x65\x41",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\xBD"],
        ["\x65\x42",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\xBE"],
        ["\x65\x43",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\xBF"],
        ["\x65\x44",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\x80"],
        ["\x65\x45",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\x81"],
        ["\x65\x46",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\x82"],
        ["\x54\x85",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\x83"],
        ["\x65\x47",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\x84"],
        ["\x64\xFA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\x85"],
        ["\x65\x48",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\x86"],
        ["\x65\x4A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\x87"],
        ["\x65\x4B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\x88"],
        ["\x65\x4C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\x89"],
        ["\x64\xFD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\x8A"],
        ["\x65\x4D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\x8B"],
        ["\x65\x4E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\x8C"],
        ["\x65\x4F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\x8D"],
        ["\x65\x50",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\x8E"],
        ["\x65\x51",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\x8F"],
        ["\x65\x52",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\x90"],
        ["\x65\x54",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\x91"],
        ["\x65\x55",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\x92"],
        ["\x65\x56",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\x93"],
        ["\x65\x57",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\x94"],
        ["\x65\x58",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\x95"],
        ["\x65\x59",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\x96"],
        ["\x53\x7B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\x97"],
        ["\x65\x5B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\x98"],
        ["\x50\xEA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\x99"],
        ["\x65\x5A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\x9A"],
        ["\x65\x5C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\x9B"],
        ["\x51\xA8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\x9C"],
        ["\x65\x5E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\x9D"],
        ["\x65\x5F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\x9E"],
        ["\x65\x60",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\x9F"],
        ["\x65\x61",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\xA0"],
        ["\x65\x62",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\xA1"],
        ["\x65\x5D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\xA2"],
        ["\x65\x63",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\xA3"],
        ["\x65\x65",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\xA4"],
        ["\x65\x68",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\xA5"],
        ["\x65\x69",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\xA6"],
        ["\x65\x6A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\xA7"],
        ["\x65\x6C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\xA8"],
        ["\x65\x6D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\xA9"],
        ["\x65\x6E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\xAA"],
        ["\x65\x6F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\xAB"],
        ["\x65\x70",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\xAC"],
        ["\x65\x71",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\xAD"],
        ["\x65\x72",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\xAE"],
        ["\x65\x73",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\xAF"],
        ["\x65\x74",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\xB0"],
        ["\x65\x75",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\xB1"],
        ["\x65\x76",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\xB2"],
        ["\x65\x77",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\xB3"],
        ["\x65\x78",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\xB4"],
        ["\x65\x79",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\xB5"],
        ["\x65\x7A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\xB6"],
        ["\x65\x7B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\xB7"],
        ["\x65\x7C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\xB8"],
        ["\x65\x7D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\xB9"],
        ["\x65\x7E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\xBA"],
        ["\x65\x7F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\xBB"],
        ["\x65\x80",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\xBC"],
        ["\x52\x52",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\xBD"],
        ["\x65\x81",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\xBE"],
        ["\x65\x82",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\xBF"],
        ["\x65\x87",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\x80"],
        ["\x65\x88",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\x81"],
        ["\x65\x89",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\x82"],
        ["\x65\x84",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\x83"],
        ["\x51\xD0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\x84"],
        ["\x65\x8B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\x85"],
        ["\x65\x8E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\x86"],
        ["\x65\x91",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\x87"],
        ["\x65\x92",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\x88"],
        ["\x65\x94",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\x89"],
        ["\x65\x96",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\x8A"],
        ["\x65\x97",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\x8B"],
        ["\x52\x69",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\x8C"],
        ["\x53\x93",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\x8D"],
        ["\x65\x99",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\x8E"],
        ["\x65\x9A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\x8F"],
        ["\x65\x9C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\x90"],
        ["\x65\x9D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\x91"],
        ["\x65\xA0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\x92"],
        ["\x65\xB1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\x93"],
        ["\x65\xA4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\x94"],
        ["\x65\xA7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\x95"],
        ["\x65\xA2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\x96"],
        ["\x65\xAA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\x97"],
        ["\x65\xAE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\x98"],
        ["\x65\xAF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\x99"],
        ["\x65\xB0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\x9A"],
        ["\x65\xA9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\x9B"],
        ["\x65\xB3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\x9C"],
        ["\x65\xBA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\x9D"],
        ["\x65\xBB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\x9E"],
        ["\x65\xB2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\x9F"],
        ["\x65\xC0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\xA0"],
        ["\x65\xC2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\xA1"],
        ["\x65\xC4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\xA2"],
        ["\x52\x83",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\xA3"],
        ["\x65\xC7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\xA4"],
        ["\x65\xCA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\xA5"],
        ["\x65\xCB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\xA6"],
        ["\x65\xCD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\xA7"],
        ["\x65\xBE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\xA8"],
        ["\x65\xBF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\xA9"],
        ["\x65\xCF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\xAA"],
        ["\x52\xAD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\xAB"],
        ["\x65\xD1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\xAC"],
        ["\x65\xD2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\xAD"],
        ["\x65\xD3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\xAE"],
        ["\x65\xD4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\xAF"],
        ["\x65\xD7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\xB0"],
        ["\x53\x6E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\xB1"],
        ["\x65\xD9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\xB2"],
        ["\x65\xDA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\xB3"],
        ["\x65\xD6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\xB4"],
        ["\x65\xDC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\xB5"],
        ["\x65\xDE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\xB6"],
        ["\x65\xDF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\xB7"],
        ["\x65\xE0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\xB8"],
        ["\x65\xE1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\xB9"],
        ["\x65\xE2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\xBA"],
        ["\x65\xE3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\xBB"],
        ["\x65\xE5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\xBC"],
        ["\x65\xDB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\xBD"],
        ["\x65\xE6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\xBE"],
        ["\x65\xE7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\xBF"],
        ["\x65\xE9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\x80"],
        ["\x65\xEA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\x81"],
        ["\x65\xEC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\x82"],
        ["\x65\xED",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\x83"],
        ["\x51\xCD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\x84"],
        ["\x65\xEE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\x85"],
        ["\x65\xEF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\x86"],
        ["\x51\x56",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\x87"],
        ["\x65\xEB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\x88"],
        ["\x65\xF1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\x89"],
        ["\x65\xF2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\x8A"],
        ["\x65\xF3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\x8B"],
        ["\x65\xF5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\x8C"],
        ["\x65\xF7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\x8D"],
        ["\x65\xF9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\x8E"],
        ["\x65\xFA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\x8F"],
        ["\x65\xFB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\x90"],
        ["\x65\xFC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\x91"],
        ["\x65\x98",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\x92"],
        ["\x65\xFE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\x93"],
        ["\x65\xFD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\x94"],
        ["\x66\x41",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\x95"],
        ["\x66\x43",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\x96"],
        ["\x65\xF8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\x97"],
        ["\x66\x44",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\x98"],
        ["\x66\x45",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\x99"],
        ["\x66\x46",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\x9A"],
        ["\x66\x42",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\x9B"],
        ["\x66\x47",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\x9C"],
        ["\x66\x48",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\x9D"],
        ["\x66\x49",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\x9E"],
        ["\x66\x4B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\x9F"],
        ["\x66\x4C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\xA0"],
        ["\x66\x4D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\xA1"],
        ["\x66\x4E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\xA2"],
        ["\x66\x4F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\xA3"],
        ["\x66\x50",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\xA4"],
        ["\x66\x51",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\xA5"],
        ["\x66\x52",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\xA6"],
        ["\x66\x53",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\xA7"],
        ["\x66\x54",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\xA8"],
        ["\x66\x55",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\xA9"],
        ["\x66\x56",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\xAA"],
        ["\x66\x57",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\xAB"],
        ["\x66\x58",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\xAC"],
        ["\x66\x59",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\xAD"],
        ["\x66\x5A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\xAE"],
        ["\x66\x5B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\xAF"],
        ["\x66\x5C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\xB0"],
        ["\x66\x5D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\xB1"],
        ["\x66\x5E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\xB2"],
        ["\x66\x5F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\xB3"],
        ["\x66\x60",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\xB4"],
        ["\x66\x61",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\xB5"],
        ["\x66\x62",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\xB6"],
        ["\x66\x63",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\xB7"],
        ["\x66\x64",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\xB8"],
        ["\x66\x65",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\xB9"],
        ["\x66\x66",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\xBA"],
        ["\x66\x67",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\xBB"],
        ["\x66\x69",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\xBC"],
        ["\x66\x68",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\xBD"],
        ["\x66\x6A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\xBE"],
        ["\x66\x6F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\xBF"],
        ["\x66\x6B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\x80"],
        ["\x52\x72",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\x81"],
        ["\x66\x6C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\x82"],
        ["\x66\x6D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\x83"],
        ["\x66\x6E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\x84"],
        ["\x66\x70",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\x85"],
        ["\x66\x71",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\x86"],
        ["\x66\x72",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\x87"],
        ["\x66\x75",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\x88"],
        ["\x66\x76",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\x89"],
        ["\x66\x77",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\x8A"],
        ["\x66\x7B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\x8B"],
        ["\x66\x7A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\x8C"],
        ["\x66\x7C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\x8D"],
        ["\x66\x7D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\x8E"],
        ["\x66\x7E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\x8F"],
        ["\x66\x80",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\x90"],
        ["\x66\x81",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\x91"],
        ["\x66\x82",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\x92"],
        ["\x66\x83",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\x93"],
        ["\x66\x84",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\x94"],
        ["\x66\x85",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\x95"],
        ["\x54\x77",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\x96"],
        ["\x52\x5B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\x97"],
        ["\x63\xA1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\x98"],
        ["\x66\x87",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\x99"],
        ["\x66\x8E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\x9A"],
        ["\x66\x86",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\x9B"],
        ["\x66\x89",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\x9C"],
        ["\x66\x8A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\x9D"],
        ["\x66\x8B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\x9E"],
        ["\x66\x8C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\x9F"],
        ["\x66\x8F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\xA0"],
        ["\x66\x90",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\xA1"],
        ["\x66\x91",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\xA2"],
        ["\x66\x92",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\xA3"],
        ["\x66\x93",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\xA4"],
        ["\x66\x8D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\xA5"],
        ["\x66\x94",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\xA6"],
        ["\x66\x95",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\xA7"],
        ["\x66\x96",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\xA8"],
        ["\x66\x98",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\xA9"],
        ["\x66\x9A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\xAA"],
        ["\x66\x9B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\xAB"],
        ["\x66\x9D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\xAC"],
        ["\x66\x9C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\xAD"],
        ["\x66\x9F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\xAE"],
        ["\x66\xA0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\xAF"],
        ["\x66\xA1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\xB0"],
        ["\x66\xA6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\xB1"],
        ["\x66\xA7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\xB2"],
        ["\x66\xA8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\xB3"],
        ["\x66\xA9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\xB4"],
        ["\x66\xAA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\xB5"],
        ["\x53\xD6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\xB6"],
        ["\x53\xB5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\xB7"],
        ["\x52\xCE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\xB8"],
        ["\x66\xAC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\xB9"],
        ["\x66\xAD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\xBA"],
        ["\x66\xAE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\xBB"],
        ["\x66\xAF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\xBC"],
        ["\x66\xB0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\xBD"],
        ["\x52\x77",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\xBE"],
        ["\x66\xB1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\xBF"],
        ["\x66\xB2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\x80"],
        ["\x66\xB3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\x81"],
        ["\x66\xB4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\x82"],
        ["\x66\xB5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\x83"],
        ["\x66\xB6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\x84"],
        ["\x66\xB7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\x85"],
        ["\x66\xB8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\x86"],
        ["\x66\xB9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\x87"],
        ["\x66\xBA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\x88"],
        ["\x66\xBB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\x89"],
        ["\x66\xBC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\x8A"],
        ["\x66\xBD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\x8B"],
        ["\x66\xBE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\x8C"],
        ["\x66\xBF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\x8D"],
        ["\x68\x6F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\x8E"],
        ["\x66\xC0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\x8F"],
        ["\x66\xC1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\x90"],
        ["\x52\xFC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\x91"],
        ["\x66\xC2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\x92"],
        ["\x66\xC3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\x93"],
        ["\x54\x56",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\x94"],
        ["\x50\xFB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\x95"],
        ["\x66\xC5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\x96"],
        ["\x66\xC6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\x97"],
        ["\x66\xC7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\x98"],
        ["\x66\xC8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\x99"],
        ["\x51\xDC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\x9A"],
        ["\x66\xC9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\x9B"],
        ["\x66\xCA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\x9C"],
        ["\x66\xCD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\x9D"],
        ["\x66\xCE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\x9E"],
        ["\x66\xCF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\x9F"],
        ["\x66\xD0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\xA0"],
        ["\x66\xD1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\xA1"],
        ["\x66\xD2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\xA2"],
        ["\x66\xD3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\xA3"],
        ["\x66\xD4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\xA4"],
        ["\x66\xD5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\xA5"],
        ["\x66\xD6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\xA6"],
        ["\x66\xD7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\xA7"],
        ["\x66\xD8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\xA8"],
        ["\x66\xD9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\xA9"],
        ["\x66\xDC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\xAA"],
        ["\x66\xDE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\xAB"],
        ["\x66\xE0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\xAC"],
        ["\x54\xBC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\xAD"],
        ["\x66\xE2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\xAE"],
        ["\x66\xE3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\xAF"],
        ["\x66\xE4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\xB0"],
        ["\x66\xE7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\xB1"],
        ["\x66\xE1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\xB2"],
        ["\x66\xE8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\xB3"],
        ["\x66\xE9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\xB4"],
        ["\x66\xEA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\xB5"],
        ["\x66\xEB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\xB6"],
        ["\x66\xEC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\xB7"],
        ["\x66\xED",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\xB8"],
        ["\x66\xEE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\xB9"],
        ["\x66\xEF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\xBA"],
        ["\x66\xF0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\xBB"],
        ["\x66\xF1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\xBC"],
        ["\x66\xF2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\xBD"],
        ["\x66\xF3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\xBE"],
        ["\x66\xF4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\xBF"],
        ["\x52\xE8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\x80"],
        ["\x66\xF5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\x81"],
        ["\x66\xF6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\x82"],
        ["\x66\xF7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\x83"],
        ["\x66\xF8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\x84"],
        ["\x66\xFA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\x85"],
        ["\x66\xFB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\x86"],
        ["\x66\xFC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\x87"],
        ["\x66\xFD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\x88"],
        ["\x66\xFE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\x89"],
        ["\x67\x41",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\x8A"],
        ["\x67\x42",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\x8B"],
        ["\x67\x43",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\x8C"],
        ["\x67\x44",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\x8D"],
        ["\x67\x45",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\x8E"],
        ["\x67\x46",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\x8F"],
        ["\x67\x48",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\x90"],
        ["\x67\x49",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\x91"],
        ["\x67\x4A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\x92"],
        ["\x67\x4B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\x93"],
        ["\x67\x4C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\x94"],
        ["\x67\x4D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\x95"],
        ["\x67\x4E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\x96"],
        ["\x67\x47",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\x97"],
        ["\x67\x4F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\x98"],
        ["\x67\x50",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\x99"],
        ["\x67\x51",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\x9A"],
        ["\x67\x53",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\x9B"],
        ["\x67\x54",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\x9C"],
        ["\x67\x52",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\x9D"],
        ["\x67\x55",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\x9E"],
        ["\x67\x56",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\x9F"],
        ["\x67\x57",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\xA0"],
        ["\x67\x58",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\xA1"],
        ["\x67\x5A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\xA2"],
        ["\x67\x5B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\xA3"],
        ["\x67\x5C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\xA4"],
        ["\x67\x5D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\xA5"],
        ["\x67\x5F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\xA6"],
        ["\x67\x60",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\xA7"],
        ["\x67\x5E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\xA8"],
        ["\x67\x62",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\xA9"],
        ["\x67\x61",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\xAA"],
        ["\x67\x63",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\xAB"],
        ["\x67\x64",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\xAC"],
        ["\x67\x65",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\xAD"],
        ["\x67\x66",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\xAE"],
        ["\x67\x67",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\xAF"],
        ["\x67\x6A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\xB0"],
        ["\x67\x68",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\xB1"],
        ["\x67\x69",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\xB2"],
        ["\x67\x6D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\xB3"],
        ["\x67\x6E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\xB4"],
        ["\x67\x6F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\xB5"],
        ["\x67\x70",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\xB6"],
        ["\x67\x71",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\xB7"],
        ["\x67\x72",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\xB8"],
        ["\x67\x73",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\xB9"],
        ["\x67\x74",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\xBA"],
        ["\x67\x75",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\xBB"],
        ["\x67\x76",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\xBC"],
        ["\x67\x77",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\xBD"],
        ["\x67\x78",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\xBE"],
        ["\x67\x79",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\xBF"],
        ["\x67\x7A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\x80"],
        ["\x67\x7B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\x81"],
        ["\x67\x7C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\x82"],
        ["\x67\x7D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\x83"],
        ["\x67\x7E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\x84"],
        ["\x67\x7F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\x85"],
        ["\x67\x80",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\x86"],
        ["\x67\x81",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\x87"],
        ["\x67\x82",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\x88"],
        ["\x67\x83",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\x89"],
        ["\x67\x84",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\x8A"],
        ["\x67\x85",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\x8B"],
        ["\x67\x87",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\x8C"],
        ["\x67\x89",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\x8D"],
        ["\x67\x8A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\x8E"],
        ["\x53\x89",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\x8F"],
        ["\x67\x8B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\x90"],
        ["\x67\x8C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\x91"],
        ["\x67\x8D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\x92"],
        ["\x67\x8E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\x93"],
        ["\x67\x90",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\x94"],
        ["\x67\x92",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\x95"],
        ["\x67\x94",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\x96"],
        ["\x67\x95",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\x97"],
        ["\x67\x96",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\x98"],
        ["\x67\x97",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\x99"],
        ["\x67\x98",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\x9A"],
        ["\x67\x99",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\x9B"],
        ["\x67\x9A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\x9C"],
        ["\x67\x9C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\x9D"],
        ["\x67\x9D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\x9E"],
        ["\x67\x9E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\x9F"],
        ["\x67\xA0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\xA0"],
        ["\x67\xA1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\xA1"],
        ["\x67\xA2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\xA2"],
        ["\x67\xA3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\xA3"],
        ["\x67\xA4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\xA4"],
        ["\x67\xA5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\xA5"],
        ["\x67\xA6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\xA6"],
        ["\x67\xA7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\xA7"],
        ["\x67\xA8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\xA8"],
        ["\x67\xA9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\xA9"],
        ["\x51\xF0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\xAA"],
        ["\x67\xAC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\xAB"],
        ["\x67\xAB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\xAC"],
        ["\x55\x51",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\xAD"],
        ["\x67\xAF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\xAE"],
        ["\x67\xB0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\xAF"],
        ["\x67\xB2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\xB0"],
        ["\x67\xB3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\xB1"],
        ["\x67\xB4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\xB2"],
        ["\x67\xB5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\xB3"],
        ["\x67\xB6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\xB4"],
        ["\x67\xB7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\xB5"],
        ["\x67\xB8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\xB6"],
        ["\x67\xAD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\xB7"],
        ["\x67\xB9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\xB8"],
        ["\x67\xAE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\xB9"],
        ["\x67\xBA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\xBA"],
        ["\x67\xBB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\xBB"],
        ["\x67\xBC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\xBC"],
        ["\x67\xBD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\xBD"],
        ["\x67\xBE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\xBE"],
        ["\x67\xBF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\xBF"],
        ["\x67\xC0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\x80"],
        ["\x67\xC1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\x81"],
        ["\x67\xC2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\x82"],
        ["\x67\xC3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\x83"],
        ["\x67\xC4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\x84"],
        ["\x67\xC5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\x85"],
        ["\x67\xC6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\x86"],
        ["\x67\xC8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\x87"],
        ["\x67\xC9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\x88"],
        ["\x67\xCA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\x89"],
        ["\x67\xCB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\x8A"],
        ["\x54\xFC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\x8B"],
        ["\x67\xC7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\x8C"],
        ["\x67\xCC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\x8D"],
        ["\x67\xCD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\x8E"],
        ["\x67\xCE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\x8F"],
        ["\x67\xCF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\x90"],
        ["\x50\xE5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\x91"],
        ["\x67\xD1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\x92"],
        ["\x67\xD2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\x93"],
        ["\x67\xD7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\x94"],
        ["\x67\xD3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\x95"],
        ["\x67\xD4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\x96"],
        ["\x67\xD5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\x97"],
        ["\x67\xD6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\x98"],
        ["\x67\xD8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\x99"],
        ["\x67\xD9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\x9A"],
        ["\x67\xDA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\x9B"],
        ["\x67\xDB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\x9C"],
        ["\x67\xDC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\x9D"],
        ["\x67\xE0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\x9E"],
        ["\x67\xDE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\x9F"],
        ["\x67\xDF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\xA0"],
        ["\x67\xDD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\xA1"],
        ["\x67\xE1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\xA2"],
        ["\x53\x42",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\xA3"],
        ["\x67\xE3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\xA4"],
        ["\x67\xEA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\xA5"],
        ["\x67\xE5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\xA6"],
        ["\x67\xE6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\xA7"],
        ["\x67\xE7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\xA8"],
        ["\x67\xE8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\xA9"],
        ["\x67\xE9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\xAA"],
        ["\x67\xEB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\xAB"],
        ["\x67\xEC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\xAC"],
        ["\x67\xED",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\xAD"],
        ["\x67\xEE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\xAE"],
        ["\x67\xEF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\xAF"],
        ["\x67\xF0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\xB0"],
        ["\x67\xF1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\xB1"],
        ["\x67\xF2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\xB2"],
        ["\x67\xF3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\xB3"],
        ["\x67\xF5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\xB4"],
        ["\x67\xF6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\xB5"],
        ["\x67\xF7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\xB6"],
        ["\x67\xF8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\xB7"],
        ["\x67\xF9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\xB8"],
        ["\x67\xFA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\xB9"],
        ["\x67\xFB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\xBA"],
        ["\x67\xFC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\xBB"],
        ["\x67\xFD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\xBC"],
        ["\x68\x41",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\xBD"],
        ["\x68\x42",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\xBE"],
        ["\x68\x43",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\xBF"],
        ["\x68\x44",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\x80"],
        ["\x68\x45",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\x81"],
        ["\x68\x46",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\x82"],
        ["\x68\x47",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\x83"],
        ["\x68\x48",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\x84"],
        ["\x51\xF9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\x85"],
        ["\x68\x49",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\x86"],
        ["\x68\x4A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\x87"],
        ["\x68\x4B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\x88"],
        ["\x68\x4C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\x89"],
        ["\x53\xB4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\x8A"],
        ["\x68\x4D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\x8B"],
        ["\x68\x4E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\x8C"],
        ["\x68\x4F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\x8D"],
        ["\x68\x52",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\x8E"],
        ["\x68\x53",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\x8F"],
        ["\x51\xA7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\x90"],
        ["\x68\x54",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\x91"],
        ["\x68\x55",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\x92"],
        ["\x68\x57",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\x93"],
        ["\x68\x58",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\x94"],
        ["\x68\x59",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\x95"],
        ["\x68\x5A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\x96"],
        ["\x68\x5B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\x97"],
        ["\x68\x5C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\x98"],
        ["\x68\x5D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\x99"],
        ["\x68\x5E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\x9A"],
        ["\x68\x5F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\x9B"],
        ["\x68\x60",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\x9C"],
        ["\x68\x61",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\x9D"],
        ["\x68\x62",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\x9E"],
        ["\x68\x63",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\x9F"],
        ["\x68\x64",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\xA0"],
        ["\x68\x65",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\xA1"],
        ["\x68\x66",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\xA2"],
        ["\x68\x67",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\xA3"],
        ["\x68\x68",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\xA4"],
        ["\x68\x69",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\xA5"],
        ["\x68\x6A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\xA6"],
        ["\x68\x6B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\xA7"],
        ["\x68\x6C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\xA8"],
        ["\x68\x6D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\xA9"],
        ["\x68\x70",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\xAA"],
        ["\x68\x71",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\xAB"],
        ["\x68\x72",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\xAC"],
        ["\x68\x73",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\xAD"],
        ["\x68\x74",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\xAE"],
        ["\x68\x75",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\xAF"],
        ["\x68\x76",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\xB0"],
        ["\x68\x77",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\xB1"],
        ["\x68\x78",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\xB2"],
        ["\x68\x79",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\xB3"],
        ["\x68\x7A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\xB4"],
        ["\x68\x7B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\xB5"],
        ["\x68\x7C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\xB6"],
        ["\x68\x7D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\xB7"],
        ["\x68\x7E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\xB8"],
        ["\x68\x7F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\xB9"],
        ["\x4E\x53",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\xBA"],
        ["\x4D\xB9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\xBB"],
        ["\x52\xF3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\xBC"],
        ["\x5E\xBB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\xBD"],
        ["\x68\x84",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\xBE"],
        ["\x4F\x68",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\xBF"],
        ["\x41\xB1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAB\x9C"],
        ["\x41\xB2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAB\x9D"],
        ["\x41\xB3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAB\x9E"],
        ["\x41\xB4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAB\x9F"],
        ["\x41\xB5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAB\xA0"],
        ["\x41\xB6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAB\xA1"],
        ["\x41\xB7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAB\xA2"],
        ["\x41\xB8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAB\xA3"],
        ["\x41\xB9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAB\xA4"],
        ["\x41\xBA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAB\xA5"],
        ["\xE9\xF5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAB\xB1"],
        ["\x42\x7D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAB\xB2"],
        ["\x42\x7F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAB\xB3"],
        ["\x51\xBF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAB\xB8"],
        ["\x51\xDA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAB\xB9"],
        ["\x51\xF7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAB\xBA"],
        ["\x52\x4B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAB\xBB"],
        ["\x52\x7B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAB\xBC"],
        ["\x52\x94",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAB\xBD"],
        ["\x52\x9E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAB\xBE"],
        ["\x52\xEB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAB\xBF"],
        ["\x53\x86",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\x80"],
        ["\x53\x94",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\x81"],
        ["\x53\x97",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\x82"],
        ["\x53\xC7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\x83"],
        ["\x56\x44",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\x84"],
        ["\x56\x5D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\x85"],
        ["\x56\x62",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\x86"],
        ["\x56\x65",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\x87"],
        ["\x56\x66",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\x88"],
        ["\x56\x6A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\x89"],
        ["\x56\x6E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\x8A"],
        ["\x56\x70",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\x8B"],
        ["\x56\x71",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\x8C"],
        ["\x56\x74",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\x8D"],
        ["\x56\x7B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\x8E"],
        ["\x56\x86",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\x8F"],
        ["\x56\x8A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\x90"],
        ["\x56\x91",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\x91"],
        ["\x56\x94",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\x92"],
        ["\x56\x98",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\x93"],
        ["\x56\xA2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\x94"],
        ["\x56\xA3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\x95"],
        ["\x56\xA4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\x96"],
        ["\x56\xA8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\x97"],
        ["\x56\xB2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\x98"],
        ["\x56\xB5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\x99"],
        ["\x56\xC9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\x9A"],
        ["\x56\xCE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\x9B"],
        ["\x56\xDC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\x9C"],
        ["\x56\xE8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\x9D"],
        ["\x56\xEF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\x9E"],
        ["\x56\xF7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\x9F"],
        ["\x57\x4F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\xA0"],
        ["\x57\x50",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\xA1"],
        ["\x57\x56",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\xA2"],
        ["\x57\x58",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\xA3"],
        ["\x57\x61",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\xA4"],
        ["\x57\x63",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\xA5"],
        ["\x57\x6B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\xA6"],
        ["\x57\x7C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\xA7"],
        ["\x57\x80",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\xA8"],
        ["\x57\x87",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\xA9"],
        ["\x57\x8B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\xAA"],
        ["\x57\x8E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\xAB"],
        ["\x57\xA9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\xAC"],
        ["\x57\xAE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\xAD"],
        ["\x57\xBD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\xAE"],
        ["\x57\xC0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\xAF"],
        ["\x57\xDE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\xB0"],
        ["\x58\x60",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\xB1"],
        ["\x58\x63",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\xB2"],
        ["\x58\x6C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\xB3"],
        ["\x58\x70",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\xB4"],
        ["\x58\x73",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\xB5"],
        ["\x58\x77",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\xB6"],
        ["\x58\x82",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\xB7"],
        ["\x58\x8A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\xB8"],
        ["\x58\x8C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\xB9"],
        ["\x58\xA1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\xBA"],
        ["\x58\xAD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\xBB"],
        ["\x58\xB0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\xBC"],
        ["\x58\xB1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\xBD"],
        ["\x58\xB2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\xBE"],
        ["\x58\xBE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\xBF"],
        ["\x58\xC0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\x80"],
        ["\x58\xEC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\x81"],
        ["\x58\xFC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\x82"],
        ["\x58\xFE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\x83"],
        ["\x59\x42",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\x84"],
        ["\x59\x44",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\x85"],
        ["\x59\x51",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\x86"],
        ["\x59\x67",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\x87"],
        ["\x59\x68",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\x88"],
        ["\x59\x70",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\x89"],
        ["\x59\x78",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\x8A"],
        ["\x59\x7F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\x8B"],
        ["\x59\x80",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\x8C"],
        ["\x59\x84",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\x8D"],
        ["\x59\x87",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\x8E"],
        ["\x59\x93",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\x8F"],
        ["\x59\x95",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\x90"],
        ["\x59\x97",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\x91"],
        ["\x59\xC7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\x92"],
        ["\x59\xCB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\x93"],
        ["\x59\xD8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\x94"],
        ["\x59\xE8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\x95"],
        ["\x59\xF1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\x96"],
        ["\x5A\x44",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\x97"],
        ["\x5A\x51",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\x98"],
        ["\x5A\x57",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\x99"],
        ["\x5A\x5F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\x9A"],
        ["\x5A\x65",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\x9B"],
        ["\x5A\x67",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\x9C"],
        ["\x5A\x68",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\x9D"],
        ["\x5A\x76",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\x9E"],
        ["\x5A\x79",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\x9F"],
        ["\x5A\x7E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\xA0"],
        ["\x5A\x94",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\xA1"],
        ["\x5A\xB5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\xA2"],
        ["\x5A\xDA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\xA3"],
        ["\x5A\xFB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\xA4"],
        ["\x5B\x50",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\xA5"],
        ["\x5B\x53",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\xA6"],
        ["\x5B\x54",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\xA7"],
        ["\x5B\x7E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\xA8"],
        ["\x5B\x97",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\xA9"],
        ["\x5B\x98",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\xAA"],
        ["\x4F\x9F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\xAB"],
        ["\x5B\x9D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\xAC"],
        ["\x5B\xA0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\xAD"],
        ["\x5B\xA1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\xAE"],
        ["\x5B\xA4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\xAF"],
        ["\x5B\xA7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\xB0"],
        ["\x5B\xA8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\xB1"],
        ["\x5B\xAB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\xB2"],
        ["\x5B\xAE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\xB3"],
        ["\x5B\xAF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\xB4"],
        ["\x5B\xB4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\xB5"],
        ["\x5B\xB6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\xB6"],
        ["\x5B\xB8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\xB7"],
        ["\x5B\xBB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\xB8"],
        ["\x5B\xC7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\xB9"],
        ["\x5B\xC8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\xBA"],
        ["\x5B\xC9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\xBB"],
        ["\x5B\xD8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\xBC"],
        ["\x5B\xE3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\xBD"],
        ["\x5B\xEC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\xBE"],
        ["\x5B\xF0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\xBF"],
        ["\x5B\xF3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\x80"],
        ["\x5B\xF9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\x81"],
        ["\x5C\x5F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\x82"],
        ["\x5C\x66",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\x83"],
        ["\x5C\x6E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\x84"],
        ["\x5C\x78",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\x85"],
        ["\x5C\x79",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\x86"],
        ["\x5C\x90",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\x87"],
        ["\x5C\x9A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\x88"],
        ["\x5C\x9B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\x89"],
        ["\x5C\xA6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\x8A"],
        ["\x5C\xA9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\x8B"],
        ["\x5C\xAF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\x8C"],
        ["\x5C\xB9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\x8D"],
        ["\x5C\xBC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\x8E"],
        ["\x5C\xEA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\x8F"],
        ["\x5C\xF6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\x90"],
        ["\x5C\xF9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\x91"],
        ["\x5C\xFD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\x92"],
        ["\x5C\xFE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\x93"],
        ["\x5D\x4E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\x94"],
        ["\x5D\x58",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\x95"],
        ["\x5D\x60",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\x96"],
        ["\x5D\x62",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\x97"],
        ["\x5D\x6B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\x98"],
        ["\x5D\x72",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\x99"],
        ["\x5D\x74",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\x9A"],
        ["\x5D\x7A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\x9B"],
        ["\x5D\x7F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\x9C"],
        ["\x5D\x80",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\x9D"],
        ["\x5D\x8A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\x9E"],
        ["\x5D\x8E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\x9F"],
        ["\x5D\x93",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\xA0"],
        ["\x5D\x95",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\xA1"],
        ["\x5D\xA6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\xA2"],
        ["\x5D\xC1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\xA3"],
        ["\x5D\xCA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\xA4"],
        ["\x5D\xD5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\xA5"],
        ["\x5D\xD7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\xA6"],
        ["\x5D\xD8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\xA7"],
        ["\x5D\xE3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\xA8"],
        ["\x5D\xEA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\xA9"],
        ["\x5D\xED",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\xAA"],
        ["\x5D\xF5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\xAB"],
        ["\x5D\xF6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\xAC"],
        ["\x5D\xFB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\xAD"],
        ["\x5D\xFC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\xAE"],
        ["\x5D\xFD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\xAF"],
        ["\x5E\x49",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\xB0"],
        ["\x5E\x4B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\xB1"],
        ["\x5E\x5A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\xB2"],
        ["\x5E\x73",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\xB3"],
        ["\x5E\x75",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\xB4"],
        ["\x5E\x86",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\xB5"],
        ["\x5E\x8A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\xB6"],
        ["\x5E\x94",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\xB7"],
        ["\x5E\x99",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\xB8"],
        ["\x5E\x9E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\xB9"],
        ["\x5E\x9F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\xBA"],
        ["\x5E\xA1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\xBB"],
        ["\x5E\xA2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\xBC"],
        ["\x5E\xA7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\xBD"],
        ["\x5E\xA8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\xBE"],
        ["\x5E\xAA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\xBF"],
        ["\x5E\xAB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\x80"],
        ["\x5E\xAD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\x81"],
        ["\x5E\xAE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\x82"],
        ["\x5E\xBC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\x83"],
        ["\x5E\xBD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\x84"],
        ["\x5E\xC0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\x85"],
        ["\x5E\xD1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\x86"],
        ["\x5E\xE7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\x87"],
        ["\x5F\x69",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\x88"],
        ["\x5F\x70",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\x89"],
        ["\x5F\x71",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\x8A"],
        ["\x5F\x72",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\x8B"],
        ["\x5F\x73",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\x8C"],
        ["\x5F\x7A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\x8D"],
        ["\x5F\x8E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\x8E"],
        ["\x5F\xAA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\x8F"],
        ["\x5F\xAE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\x90"],
        ["\x5F\xB2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\x91"],
        ["\x5F\xB3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\x92"],
        ["\x5F\xB6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\x93"],
        ["\x5F\xD1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\x94"],
        ["\x5F\xD2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\x95"],
        ["\x5F\xD5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\x96"],
        ["\x5F\xD9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\x97"],
        ["\x5F\xDC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\x98"],
        ["\x5F\xDD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\x99"],
        ["\x5F\xDF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\x9A"],
        ["\x60\x4F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\x9B"],
        ["\x60\x58",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\x9C"],
        ["\x60\x59",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\x9D"],
        ["\x60\x5A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\x9E"],
        ["\x60\x82",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\x9F"],
        ["\x60\xAD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\xA0"],
        ["\x60\xC4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\xA1"],
        ["\x60\xC6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\xA2"],
        ["\x60\xD4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\xA3"],
        ["\x60\xDA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\xA4"],
        ["\x60\xE1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\xA5"],
        ["\x60\xFD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\xA6"],
        ["\x61\x57",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\xA7"],
        ["\x61\x6E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\xA8"],
        ["\x61\x77",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\xA9"],
        ["\x61\xF8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\xAA"],
        ["\x62\x48",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\xAB"],
        ["\x62\x5B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\xAC"],
        ["\x62\x67",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\xAD"],
        ["\x62\x74",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\xAE"],
        ["\x62\x7E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\xAF"],
        ["\x62\x8A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\xB0"],
        ["\x62\x9E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\xB1"],
        ["\x62\xA1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\xB2"],
        ["\x62\xA8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\xB3"],
        ["\x62\xB9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\xB4"],
        ["\x62\xBB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\xB5"],
        ["\x62\xCE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\xB6"],
        ["\x62\xE2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\xB7"],
        ["\x63\x5E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\xB8"],
        ["\x63\x90",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\xB9"],
        ["\x63\xC5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\xBA"],
        ["\x63\xCB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\xBB"],
        ["\x63\xD4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\xBC"],
        ["\x63\xDF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\xBD"],
        ["\x63\xE1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\xBE"],
        ["\x63\xED",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\xBF"],
        ["\x63\xEE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\x80"],
        ["\x63\xEF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\x81"],
        ["\x64\x45",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\x82"],
        ["\x64\x50",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\x83"],
        ["\x64\x7C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\x84"],
        ["\x64\x7D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\x85"],
        ["\x64\x85",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\x86"],
        ["\x64\x8D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\x87"],
        ["\x64\x8E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\x88"],
        ["\x64\xC9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\x89"],
        ["\x64\xF1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\x8A"],
        ["\x65\x49",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\x8B"],
        ["\x65\x53",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\x8C"],
        ["\x65\x64",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\x8D"],
        ["\x65\x66",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\x8E"],
        ["\x65\x67",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\x8F"],
        ["\x65\x6B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\x90"],
        ["\x65\x83",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\x91"],
        ["\x65\x85",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\x92"],
        ["\x65\x86",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\x93"],
        ["\x65\x8A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\x94"],
        ["\x65\x8C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\x95"],
        ["\x65\x8D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\x96"],
        ["\x65\x8F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\x97"],
        ["\x65\x90",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\x98"],
        ["\x65\x93",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\x99"],
        ["\x65\x95",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\x9A"],
        ["\x65\x9B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\x9B"],
        ["\x65\x9E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\x9C"],
        ["\x65\x9F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\x9D"],
        ["\x65\xA1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\x9E"],
        ["\x65\xA3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\x9F"],
        ["\x65\xA5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\xA0"],
        ["\x65\xA6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\xA1"],
        ["\x65\xA8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\xA2"],
        ["\x65\xAB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\xA3"],
        ["\x65\xAC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\xA4"],
        ["\x65\xAD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\xA5"],
        ["\x65\xB4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\xA6"],
        ["\x65\xB5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\xA7"],
        ["\x65\xB6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\xA8"],
        ["\x65\xB7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\xA9"],
        ["\x65\xB8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\xAA"],
        ["\x65\xB9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\xAB"],
        ["\x65\xBC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\xAC"],
        ["\x65\xBD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\xAD"],
        ["\x65\xC1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\xAE"],
        ["\x65\xC3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\xAF"],
        ["\x65\xC5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\xB0"],
        ["\x65\xC6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\xB1"],
        ["\x65\xC8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\xB2"],
        ["\x65\xC9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\xB3"],
        ["\x65\xCC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\xB4"],
        ["\x65\xCE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\xB5"],
        ["\x65\xD0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\xB6"],
        ["\x65\xD5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\xB7"],
        ["\x65\xD8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\xB8"],
        ["\x65\xDD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\xB9"],
        ["\x65\xE4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\xBA"],
        ["\x65\xE8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\xBB"],
        ["\x65\xF0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\xBC"],
        ["\x65\xF4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\xBD"],
        ["\x65\xF6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\xBE"],
        ["\x66\x4A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\xBF"],
        ["\x66\x74",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB1\x80"],
        ["\x66\x78",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB1\x81"],
        ["\x66\x79",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB1\x82"],
        ["\x66\x7F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB1\x83"],
        ["\x66\x97",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB1\x84"],
        ["\x66\x99",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB1\x85"],
        ["\x66\x9E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB1\x86"],
        ["\x66\xA2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB1\x87"],
        ["\x66\xA3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB1\x88"],
        ["\x66\xA4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB1\x89"],
        ["\x66\xA5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB1\x8A"],
        ["\x66\xCB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB1\x8B"],
        ["\x66\xCC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB1\x8C"],
        ["\x66\xDD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB1\x8D"],
        ["\x66\xDF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB1\x8E"],
        ["\x66\xE5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB1\x8F"],
        ["\x66\xE6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB1\x90"],
        ["\x66\xF9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB1\x91"],
        ["\x67\x59",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB1\x92"],
        ["\x67\x6B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB1\x93"],
        ["\x67\x6C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB1\x94"],
        ["\x67\x8F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB1\x95"],
        ["\x67\x91",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB1\x96"],
        ["\x67\x93",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB1\x97"],
        ["\x67\x9B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB1\x98"],
        ["\x67\x9F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB1\x99"],
        ["\x67\xB1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB1\x9A"],
        ["\x67\xE2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB1\x9B"],
        ["\x67\xE4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB1\x9C"],
        ["\x67\xF4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB1\x9D"],
        ["\x67\xFE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB1\x9E"],
        ["\x68\x56",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB1\x9F"],
        ["\x44\x4A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB4\xAC"],
        ["\x44\x7C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB4\xB1"],
        ["\x42\x60",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB5\x8C"],
        ["\xE6\xB3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB6\x80"],
        ["\xE6\xB4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB6\x81"],
        ["\xE6\xB5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB6\x82"],
        ["\xE6\xB8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB6\x83"],
        ["\xE6\xB9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB6\x84"],
        ["\xE6\xDD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB6\x85"],
        ["\xE6\xD2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB6\x86"],
        ["\xE0\x74",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB6\x8F"],
        ["\xE0\x75",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB6\x90"],
        ["\xE0\x78",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB6\x91"],
        ["\xE0\x79",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB6\x92"],
        ["\xDF\xCF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB6\x93"],
        ["\xDF\xCD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB6\x94"],
        ["\xE0\xEE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB6\x95"],
        ["\xE0\xEF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB6\x96"],
        ["\xE0\x83",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB6\x9E"],
        ["\xE0\x84",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB6\x9F"],
        ["\xE0\x85",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB6\xA0"],
        ["\xDF\xE6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB6\xA2"],
        ["\xE9\xF7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB6\xA3"],
        ["\xE9\xF8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB6\xA4"],
        ["\xE6\xA8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB6\xA5"],
        ["\xE6\xA9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB6\xA6"],
        ["\xE6\xA6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB6\xA7"],
        ["\xE6\xA7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB6\xA8"],
        ["\xE0\x58",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB6\xB8"],
        ["\xDF\xFA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB6\xB9"],
        ["\xDF\xFC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB6\xBA"],
        ["\xE0\x41",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB6\xBB"],
        ["\xE0\x68",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB6\xBC"],
        ["\xE0\x69",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB6\xBD"],
        ["\xDF\x61",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB6\xBE"],
        ["\xE4\xCA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB7\x87"],
        ["\xE4\xC8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB7\x88"],
        ["\xE4\xC9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB7\x89"],
        ["\xE4\xC7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB7\x8A"],
        ["\xE3\xE5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB7\x8C"],
        ["\xE3\xE4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB7\x8D"],
        ["\xE3\xED",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB7\x8E"],
        ["\xE3\xEC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB7\x8F"],
        ["\xDF\x64",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB7\x90"],
        ["\xDF\x65",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB7\x91"],
        ["\xDF\x63",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB7\x92"],
        ["\xDF\x66",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB7\x93"],
        ["\xDF\x91",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB7\x94"],
        ["\xDF\xB3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB7\x95"],
        ["\xDF\xB1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB7\x96"],
        ["\xDF\xB2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB7\x97"],
        ["\xDF\xB4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB7\x98"],
        ["\xEB\x77",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB7\x99"],
        ["\xEB\x78",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB7\x9A"],
        ["\xEC\x44",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB7\xA5"],
        ["\xE3\xF3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB7\xA6"],
        ["\xE6\xBA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB7\xA7"],
        ["\xEC\xAB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB7\xA8"],
        ["\xEC\xAA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB7\xA9"],
        ["\xE4\x4F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB7\xAA"],
        ["\xDD\xBD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB7\xAB"],
        ["\xDF\xD7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB8\x86"],
        ["\xDE\xD8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB8\x87"],
        ["\xDE\xB5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB8\x88"],
        ["\xE9\x6A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB8\x89"],
        ["\xDE\xB9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB8\x8A"],
        ["\xDE\xCB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB8\x8B"],
        ["\xE6\xDC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB8\xA6"],
        ["\xDD\xB6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB8\xA7"],
        ["\xEC\x7F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB8\xA8"],
        ["\xEC\x80",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB8\xA9"],
        ["\xE6\xCF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB9\xBD"],
        ["\xE6\xD0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB9\xBE"],
        ["\xE6\xD1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB9\xBF"],
        ["\xE4\xC2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBB\xBE"],
        ["\xE4\xBE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBB\xBF"],
        ["\xE4\xC0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBC\x80"],
        ["\xE4\xC4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBC\x81"],
        ["\xE4\xBF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBC\x82"],
        ["\xE4\xC3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBC\x83"],
        ["\xE4\xC5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBC\x84"],
        ["\xE4\xC1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBC\x85"],
        ["\xD9\x94",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBC\x9E"],
        ["\xE3\x47",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBC\x9F"],
        ["\xE3\x48",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBC\xA0"],
        ["\xE3\x49",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBC\xA1"],
        ["\xE3\x4A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBC\xA2"],
        ["\xE3\x4B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBC\xA3"],
        ["\xE3\x4C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBC\xA4"],
        ["\xE3\x4D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBC\xA5"],
        ["\xE3\x4E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBC\xA6"],
        ["\xE3\x4F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBC\xA7"],
        ["\xE3\x50",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBC\xA8"],
        ["\xE4\xCB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBC\xA9"],
        ["\xE4\xCC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBC\xAA"],
        ["\xE6\xAF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBC\xAB"],
        ["\xE4\x74",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBC\xAC"],
        ["\xE4\x68",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBC\xAD"],
        ["\xE4\x69",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBC\xAE"],
        ["\xE4\x6A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBC\xAF"],
        ["\xE4\x6B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBC\xB0"],
        ["\xE4\xC6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBC\xB1"],
        ["\xE3\xE1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBC\xB2"],
        ["\xEC\x85",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBC\xB3"],
        ["\xEC\x86",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBC\xB4"],
        ["\xEC\x87",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBC\xB5"],
        ["\xEC\x88",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBC\xB6"],
        ["\xEC\x89",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBC\xB7"],
        ["\xEC\x8A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBC\xB8"],
        ["\xEC\x8B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBC\xB9"],
        ["\xEC\x8C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBC\xBA"],
        ["\xEC\x8D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBC\xBB"],
        ["\xEC\x8E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBC\xBC"],
        ["\xEC\x8F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBC\xBE"],
        ["\xEC\x90",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBC\xBF"],
        ["\xEC\x91",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBD\x80"],
        ["\xEC\x92",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBD\x81"],
        ["\xEC\x93",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBD\x82"],
        ["\xEC\x94",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBD\x83"],
        ["\xE0\xF5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBD\xA5"],
        ["\xE0\xF6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBD\xA6"],
        ["\xE0\xF7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBD\xA7"],
        ["\xE0\xF8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBD\xA8"],
        ["\xE0\xF9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBD\xA9"],
        ["\xE0\xFA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBD\xAA"],
        ["\xE0\xFB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBD\xAB"],
        ["\xE0\xFC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBD\xAC"],
        ["\xE0\xFD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBD\xAD"],
        ["\xE0\xFE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBD\xAE"],
        ["\xE1\x41",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBD\xAF"],
        ["\xE1\x42",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBD\xB0"],
        ["\xE1\x43",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBD\xB1"],
        ["\xE1\x44",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBD\xB2"],
        ["\xE1\x45",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBD\xB3"],
        ["\xE6\xD8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBE\x95"],
        ["\xE6\xD9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBE\x96"],
        ["\xE6\xDA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBE\x97"],
        ["\xE6\xDB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBE\x98"],
        ["\xE0\xC7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBE\x99"],
        ["\xE0\xC8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBE\x9A"],
        ["\xDE\xF3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBE\x9B"],
        ["\xDE\xF4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBE\x9C"],
        ["\xDE\xF5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBE\x9D"],
        ["\xE5\xB2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBE\x9E"],
        ["\xE0\xF1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBE\x9F"],
        ["\xEA\xE4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBE\xA0"],
        ["\xE1\x46",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBE\xA1"],
        ["\xE7\xAF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBF\x82"],
        ["\xE7\xB0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBF\x83"],
        ["\xE7\xB1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBF\x84"],
        ["\xE7\xB2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBF\x85"],
        ["\xE7\xB3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBF\x86"],
        ["\xE7\xB4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBF\x87"],
        ["\xE7\xB5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBF\x88"],
        ["\xE7\xB6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBF\x89"],
        ["\xE7\xB7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBF\x8A"],
        ["\xE7\xB8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBF\x8B"],
        ["\xE7\xB9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBF\x8C"],
        ["\xE7\xBA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBF\x8D"],
        ["\xE7\xBB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBF\x8E"],
        ["\xE7\xBC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBF\x8F"],
        ["\xE7\xBD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBF\x90"],
        ["\xE7\xBE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBF\x91"],
        ["\xE7\xBF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBF\x92"],
        ["\xE7\xC0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBF\x93"],
        ["\xE7\xC1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBF\x94"],
        ["\xE7\xC2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBF\x95"],
        ["\xE7\xC3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBF\x96"],
        ["\xE7\xC4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBF\x97"],
        ["\xE7\xC5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBF\x98"],
        ["\xE7\xC6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBF\x99"],
        ["\xE7\xC7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBF\x9A"],
        ["\xE7\xC8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBF\x9B"],
        ["\xE7\xC9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBF\x9C"],
        ["\xE7\xCA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBF\x9D"],
        ["\xE7\xCB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBF\x9E"],
        ["\xE7\xCC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBF\x9F"],
        ["\xE3\xF7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBF\xA8"],
        ["\xE3\xF8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBF\xA9"],
        ["\xE3\xF9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBF\xAA"],
        ["\xE3\xFA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBF\xAB"],
        ["\xDD\xD0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBF\xAC"],
        ["\xDD\xDA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBF\xAD"],
        ["\xDD\xDB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBF\xAE"],
        ["\xDD\xDC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBF\xAF"],
        ["\xD7\x7C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBF\xB0"],
        ["\xD7\x7D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBF\xB1"],
        ["\xD7\x7F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBF\xB2"],
        ["\xDA\xDE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBF\xB3"],
        ["\xDA\xDF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBF\xB4"],
        ["\xD7\x94",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBF\xB5"],
        ["\xD7\x95",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBF\xB6"],
        ["\xD7\x80",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBF\xB7"],
        ["\xD7\x81",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBF\xB8"],
        ["\xD7\x83",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBF\xB9"],
        ["\xD7\x85",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBF\xBA"],
        ["\xD7\x87",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBF\xBB"],
        ["\xD7\x89",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBF\xBC"],
        ["\xD7\x8B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBF\xBD"],
        ["\x42\xE1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\x80"],
        ["\xD6\x41",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\x81"],
        ["\xD6\x42",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\x82"],
        ["\xD6\x43",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\x83"],
        ["\x42\x6A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\x84"],
        ["\xD6\x44",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\x85"],
        ["\xD6\x45",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\x86"],
        ["\xD6\x46",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\x87"],
        ["\xD6\x47",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\x88"],
        ["\xD6\x48",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\x89"],
        ["\xD6\x49",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\x8A"],
        ["\xD6\x4A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\x8B"],
        ["\xD6\x4B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\x8C"],
        ["\xD6\x4D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\x8D"],
        ["\xD6\x4E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\x8E"],
        ["\xD6\x4F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\x8F"],
        ["\xD6\x50",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\x90"],
        ["\xD6\x51",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\x91"],
        ["\xD6\x52",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\x92"],
        ["\xD6\x53",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\x93"],
        ["\xD6\x54",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\x94"],
        ["\xD6\x55",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\x95"],
        ["\xD6\x56",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\x96"],
        ["\xD6\x57",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\x97"],
        ["\xD6\x58",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\x98"],
        ["\xD6\x59",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\x99"],
        ["\xD6\x5A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\x9A"],
        ["\xD6\x5B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\x9B"],
        ["\xD6\x5C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\x9C"],
        ["\xD6\x5D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\x9D"],
        ["\xD6\x5E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\x9E"],
        ["\xD6\x5F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\x9F"],
        ["\xD6\x60",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\xA0"],
        ["\xD6\x61",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\xA1"],
        ["\xD6\x62",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\xA2"],
        ["\xD6\x63",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\xA3"],
        ["\xD6\x64",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\xA4"],
        ["\xD6\x65",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\xA5"],
        ["\xD6\x66",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\xA6"],
        ["\xD6\x67",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\xA7"],
        ["\xD6\x68",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\xA8"],
        ["\xD6\x69",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\xA9"],
        ["\xD6\x6A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\xAA"],
        ["\xD6\x6B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\xAB"],
        ["\xD6\x6C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\xAC"],
        ["\xD6\x6D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\xAD"],
        ["\xD6\x6E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\xAE"],
        ["\xD6\x6F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\xAF"],
        ["\xD6\x70",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\xB0"],
        ["\xD6\x71",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\xB1"],
        ["\xD6\x72",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\xB2"],
        ["\xD6\x73",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\xB3"],
        ["\xD6\x74",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\xB4"],
        ["\xD6\x75",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\xB5"],
        ["\xD6\x76",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\xB6"],
        ["\xD6\x77",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\xB7"],
        ["\xD6\x78",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\xB8"],
        ["\xD6\x79",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\xB9"],
        ["\xD6\x7A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\xBA"],
        ["\xD6\x7B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\xBB"],
        ["\xD6\x7C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\xBC"],
        ["\xD6\x7D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\xBD"],
        ["\xD6\x7E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\xBE"],
        ["\xD6\x7F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\xBF"],
        ["\xD6\x80",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\x80"],
        ["\xD6\x81",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\x81"],
        ["\xD6\x82",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\x82"],
        ["\xD6\x83",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\x83"],
        ["\xD6\x84",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\x84"],
        ["\xD6\x85",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\x85"],
        ["\xD6\x86",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\x86"],
        ["\xD6\x87",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\x87"],
        ["\xD6\x88",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\x88"],
        ["\xD6\x89",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\x89"],
        ["\xD6\x8A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\x8A"],
        ["\xD6\x8B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\x8B"],
        ["\xD6\x8C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\x8C"],
        ["\xD6\x8D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\x8D"],
        ["\xD6\x8E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\x8E"],
        ["\xD6\x8F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\x8F"],
        ["\xD6\x90",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\x90"],
        ["\xD6\x91",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\x91"],
        ["\xD6\x92",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\x92"],
        ["\xD6\x93",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\x93"],
        ["\xD6\xB8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\x94"],
        ["\xD6\xE2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\x95"],
        ["\xD7\x64",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\x96"],
        ["\xD6\xCA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\x97"],
        ["\xD7\x46",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\x98"],
        ["\xD6\xB9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\x99"],
        ["\xD6\xE3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\x9A"],
        ["\xD7\x65",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\x9B"],
        ["\xD6\xCB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\x9C"],
        ["\xD7\x47",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\x9D"],
        ["\xD6\xBC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\x9E"],
        ["\xD8\xF9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\x9F"],
        ["\xD6\xF9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\xA0"],
        ["\xD6\xF5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\xA1"],
        ["\xD7\x54",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\xA2"],
        ["\xD7\x5A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\xA3"],
        ["\xD7\x58",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\xA4"],
        ["\xD7\x5E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\xA5"],
        ["\xD7\x73",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\xA6"],
        ["\xD7\x77",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\xA7"],
        ["\xD7\x75",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\xA8"],
        ["\xD6\xBD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\xA9"],
        ["\xD8\xFC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\xAA"],
        ["\xD6\xFA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\xAB"],
        ["\xD6\xF6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\xAC"],
        ["\xD7\x55",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\xAD"],
        ["\xD8\xED",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\xAE"],
        ["\xD7\x5B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\xAF"],
        ["\xD7\x59",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\xB0"],
        ["\xD7\x5F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\xB1"],
        ["\xD7\x74",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\xB2"],
        ["\xD8\xFE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\xB3"],
        ["\xD7\x78",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\xB4"],
        ["\xD7\x76",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\xB5"],
        ["\xD7\x4E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\xB6"],
        ["\xD6\xBA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\xB7"],
        ["\xD6\xF1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\xB8"],
        ["\xD6\xBE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\xB9"],
        ["\xD6\xC4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\xBA"],
        ["\xD6\xD0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\xBB"],
        ["\xD6\xD2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\xBC"],
        ["\xD6\xC6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\xBD"],
        ["\xD6\xFB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\xBE"],
        ["\xD7\x41",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\xBF"],
        ["\xD7\x4A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x82\x80"],
        ["\xD7\x52",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x82\x81"],
        ["\xD7\x68",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x82\x82"],
        ["\xD7\x6A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x82\x83"],
        ["\xD7\x5C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x82\x84"],
        ["\xD7\x4F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x82\x85"],
        ["\xD6\xBB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x82\x86"],
        ["\xD6\xF2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x82\x87"],
        ["\xD6\xBF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x82\x88"],
        ["\xD6\xC5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x82\x89"],
        ["\xD6\xD1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x82\x8A"],
        ["\xD6\xD3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x82\x8B"],
        ["\xD6\xC7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x82\x8C"],
        ["\xD6\xC9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x82\x8D"],
        ["\xD6\xFC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x82\x8E"],
        ["\xD7\x42",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x82\x8F"],
        ["\xD7\x4B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x82\x90"],
        ["\xD7\x53",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x82\x91"],
        ["\xD7\x69",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x82\x92"],
        ["\xD7\x6B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x82\x93"],
        ["\xD7\x5D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x82\x94"],
        ["\xD8\xFA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x82\x95"],
        ["\xD6\xC0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x82\x96"],
        ["\xD6\xD4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x82\x97"],
        ["\xD6\xDC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x82\x98"],
        ["\xD6\xEC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x82\x99"],
        ["\xD7\x56",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x82\x9A"],
        ["\xD7\x66",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x82\x9B"],
        ["\xD6\xC1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x82\x9C"],
        ["\xD6\xD5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x82\x9D"],
        ["\xD6\xDD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x82\x9E"],
        ["\xD6\xED",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x82\x9F"],
        ["\xD7\x57",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x82\xA0"],
        ["\xD7\x67",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x82\xA1"],
        ["\xD8\xAD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x82\xA2"],
        ["\xD8\xC7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x82\xA3"],
        ["\xD8\xBA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x82\xA4"],
        ["\xD8\xBF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x82\xA5"],
        ["\xD8\xCE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x82\xA6"],
        ["\xD8\xA8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x82\xA7"],
        ["\xD8\xAA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x82\xA8"],
        ["\xD8\xB5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x82\xA9"],
        ["\xD8\xC4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x82\xAA"],
        ["\xD8\x92",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x82\xAB"],
        ["\xD8\xAF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x82\xAC"],
        ["\xD8\xB9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x82\xAD"],
        ["\xD8\xBE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x82\xAE"],
        ["\xD8\xCC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x82\xAF"],
        ["\xD8\xB7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x82\xB0"],
        ["\xD8\xA9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x82\xB1"],
        ["\xD8\x9B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x82\xB2"],
        ["\xD8\xAE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x82\xB3"],
        ["\xD8\xD9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x82\xB4"],
        ["\xD8\xCA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x82\xB5"],
        ["\xD8\x9D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x82\xB6"],
        ["\xD7\x45",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x82\xB7"],
        ["\xD8\xAC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x82\xB8"],
        ["\xD8\xBD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x82\xB9"],
        ["\xD6\xDF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x82\xBA"],
        ["\xD8\xD1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x82\xBB"],
        ["\xD8\xD0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x82\xBC"],
        ["\xD8\xA2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x82\xBD"],
        ["\xD8\xD4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x82\xBE"],
        ["\xD7\x7B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x82\xBF"],
        ["\xD8\x8F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x83\x80"],
        ["\xD8\x93",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x83\x81"],
        ["\xD8\xC0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x83\x82"],
        ["\xD8\x9C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x83\x83"],
        ["\xD7\x93",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x83\x84"],
        ["\xD7\x4D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x83\x85"],
        ["\xD7\x4C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x83\x86"],
        ["\xD8\xA4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x83\x87"],
        ["\xD8\xC5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x83\x88"],
        ["\xD8\x94",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x83\x89"],
        ["\xD8\xB1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x83\x8A"],
        ["\xD8\x95",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x83\x8B"],
        ["\xD8\x98",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x83\x8C"],
        ["\xD8\x9A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x83\x8D"],
        ["\xD8\x8C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x83\x8E"],
        ["\xD8\xAB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x83\x8F"],
        ["\xD8\xC6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x83\x90"],
        ["\xD8\xA0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x83\x91"],
        ["\xD8\xC8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x83\x92"],
        ["\xD8\x90",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x83\x93"],
        ["\xD8\x8D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x83\x94"],
        ["\xD8\x8E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x83\x95"],
        ["\xD8\xC9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x83\x96"],
        ["\xD8\xA1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x83\x97"],
        ["\xD8\xDE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x83\x98"],
        ["\xD8\xDD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x83\x99"],
        ["\xD8\x91",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x83\x9A"],
        ["\xD8\xCD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x83\x9B"],
        ["\xD8\xB6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x83\x9C"],
        ["\xD8\xA3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x83\x9D"],
        ["\xD8\x96",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x83\x9E"],
        ["\xD7\x90",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x83\xA0"],
        ["\xDC\x63",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x83\xA1"],
        ["\xDC\x64",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x83\xA2"],
        ["\xDC\x62",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x83\xAB"],
        ["\xDC\x65",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x83\xAC"],
        ["\xEA\xB2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x83\xAD"],
        ["\xD8\xEE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x83\xAE"],
        ["\xD8\xF0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x83\xAF"],
        ["\xD8\xF2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x83\xB0"],
        ["\xD8\xF3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x83\xB1"],
        ["\xEA\x57",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x83\xB2"],
        ["\xDD\xD2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x83\xB3"],
        ["\xEA\x5C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x83\xB4"],
        ["\xEA\x52",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x83\xB5"],
        ["\xEA\x55",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x83\xB6"],
        ["\xEA\x51",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x83\xB7"],
        ["\xEA\x60",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x83\xB8"],
        ["\xEA\x5D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x83\xB9"],
        ["\xEA\x53",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x83\xBA"],
        ["\xD9\x42",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x83\xBB"],
        ["\xD9\x43",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x83\xBC"],
        ["\xD9\x44",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x83\xBD"],
        ["\xD9\x45",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x83\xBE"],
        ["\xD9\x46",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x83\xBF"],
        ["\xEA\x76",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x84\x82"],
        ["\xEA\x7D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x84\x83"],
        ["\xEA\x8A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x84\x84"],
        ["\xEA\x6D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x84\x85"],
        ["\xEA\x70",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x84\x86"],
        ["\xEA\x71",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x84\x87"],
        ["\xEA\x59",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x84\x88"],
        ["\xEA\x8E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x84\x89"],
        ["\xEA\x7A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x84\x8A"],
        ["\xEA\x80",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x84\x8B"],
        ["\xD9\x41",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x84\x8C"],
        ["\xEA\x75",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x84\x8D"],
        ["\xEA\x81",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x84\x8E"],
        ["\xEA\x8D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x84\x8F"],
        ["\xEA\x85",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x84\x90"],
        ["\xEA\x6E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x84\x91"],
        ["\xEA\x6F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x84\x92"],
        ["\xEA\x69",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x84\x93"],
        ["\xEA\x6A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x84\x94"],
        ["\xEA\x7B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x84\x95"],
        ["\xEA\x8B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x84\x96"],
        ["\xEA\x8C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x84\x97"],
        ["\xEA\x54",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x84\x98"],
        ["\xEA\x6B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x84\x99"],
        ["\xE5\xFE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x84\x9A"],
        ["\xE6\x41",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x84\x9B"],
        ["\xE6\x42",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x84\x9C"],
        ["\xE6\x43",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x84\x9D"],
        ["\xE6\x44",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x84\x9E"],
        ["\xE6\x45",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x84\x9F"],
        ["\xE6\x46",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x84\xA0"],
        ["\xE6\x47",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x84\xA1"],
        ["\xE6\x48",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x84\xA2"],
        ["\xE6\x49",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x84\xA3"],
        ["\xE2\xFB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x84\xA4"],
        ["\xE2\xFC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x84\xA5"],
        ["\xE2\xFD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x84\xA6"],
        ["\xE2\xFE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x84\xA7"],
        ["\xE3\x41",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x84\xA8"],
        ["\xE3\x42",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x84\xA9"],
        ["\xE3\x43",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x84\xAA"],
        ["\xE3\x44",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x84\xAB"],
        ["\xE3\x45",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x84\xAC"],
        ["\xE3\x46",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x84\xAD"],
        ["\xDF\x48",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x84\xB8"],
        ["\xDF\x49",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x84\xB9"],
        ["\xE2\xE0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x84\xBA"],
        ["\xE2\xE1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x84\xBB"],
        ["\xE2\xE2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x84\xBC"],
        ["\xE2\xE3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x84\xBD"],
        ["\xE2\xE4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x84\xBE"],
        ["\xE2\xE5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x84\xBF"],
        ["\xE2\xE6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x85\x80"],
        ["\xE2\xE7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x85\x81"],
        ["\xE2\xE8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x85\x82"],
        ["\xE2\xE9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x85\x83"],
        ["\xE2\xEA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x85\x84"],
        ["\xE2\xEB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x85\x85"],
        ["\xE2\xEC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x85\x86"],
        ["\xE2\xED",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x85\x87"],
        ["\xE2\xEE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x85\x88"],
        ["\xE2\xEF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x85\x89"],
        ["\xE2\xF0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x85\x8A"],
        ["\xE2\xF1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x85\x8B"],
        ["\xE2\xF2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x85\x8C"],
        ["\xE2\xF3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x85\x8D"],
        ["\xE2\xF4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x85\x8E"],
        ["\xE2\xF5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x85\x8F"],
        ["\xE2\xF6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x85\x90"],
        ["\xE2\xF7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x85\x91"],
        ["\xE2\xF8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x85\x92"],
        ["\xE2\xF9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x85\x93"],
        ["\xE7\x80",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x85\x94"],
        ["\xE7\x81",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x85\x95"],
        ["\xE7\x82",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x85\x96"],
        ["\xE7\x83",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x85\x97"],
        ["\xE7\x84",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x85\x98"],
        ["\xE7\x85",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x85\x99"],
        ["\xE7\x86",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x85\x9A"],
        ["\xE7\x87",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x85\x9B"],
        ["\xE7\x88",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x85\x9C"],
        ["\xE7\x89",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x85\x9D"],
        ["\xE7\x8A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x85\x9E"],
        ["\xE7\x8B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x85\x9F"],
        ["\xE7\x8C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x85\xA0"],
        ["\xE7\x8D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x85\xA1"],
        ["\xE7\x8E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x85\xA2"],
        ["\xE7\x8F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x85\xA3"],
        ["\xE7\x90",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x85\xA4"],
        ["\xE7\x91",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x85\xA5"],
        ["\xE7\x92",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x85\xA6"],
        ["\xE7\x93",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x85\xA7"],
        ["\xE7\xAA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x85\xA8"],
        ["\xE7\x99",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x85\xA9"],
        ["\xE7\x95",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x85\xAA"],
        ["\xE7\x9D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x85\xAB"],
        ["\xE7\x9C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x85\xAC"],
        ["\xDD\xDD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x85\xB6"],
        ["\xDD\xD5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x85\xB7"],
        ["\xDF\x42",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x86\x96"],
        ["\xDF\x43",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x86\xAE"],
        ["\xE5\xEF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x87\x94"],
        ["\xE4\x7E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x87\x95"],
        ["\xB3\x56",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x87\x96"],
        ["\xB3\x42",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x87\x97"],
        ["\xB3\x43",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x87\x98"],
        ["\xB8\x4B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x87\x9A"],
        ["\xB8\x4C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x87\x9B"],
        ["\xB8\x5C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x87\x9C"],
        ["\xB8\x6D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x87\x9E"],
        ["\xB8\x6F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x87\x9F"],
        ["\xB8\x72",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x87\xA1"],
        ["\xB8\x8A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x87\xA2"],
        ["\xB8\x82",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x87\xA3"],
        ["\xB8\x83",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x87\xA4"],
        ["\xB8\x89",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x87\xA6"],
        ["\xB8\x8C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x87\xA7"],
        ["\xB8\x8D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x87\xA8"],
        ["\xB8\x95",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x87\xA9"],
        ["\xB8\x9F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x87\xAC"],
        ["\xB3\x54",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x87\xAD"],
        ["\xB8\xB4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x87\xAF"],
        ["\xB8\xBB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x87\xB0"],
        ["\xB3\x57",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x87\xB1"],
        ["\xB8\xC0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x87\xB2"],
        ["\xB8\xC4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x87\xB3"],
        ["\xB8\xC8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x87\xB4"],
        ["\xB8\xC9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x87\xB5"],
        ["\xB8\xCE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x87\xB7"],
        ["\xB8\xCF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x87\xB8"],
        ["\xB8\xFE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x87\xBA"],
        ["\xB9\x4F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x87\xBB"],
        ["\xB9\x42",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x87\xBC"],
        ["\xB9\x4A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x87\xBD"],
        ["\xB3\x63",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x87\xBE"],
        ["\xB9\x54",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x87\xBF"],
        ["\xB9\x53",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x88\x80"],
        ["\xB9\x57",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x88\x81"],
        ["\xB9\x61",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x88\x82"],
        ["\xB9\x6B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x88\x83"],
        ["\xB3\x69",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x88\x85"],
        ["\xB9\x71",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x88\x86"],
        ["\xB9\x72",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x88\x87"],
        ["\xB3\x6C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x88\x88"],
        ["\xB3\x71",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x88\x8A"],
        ["\xB3\x72",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x88\x8B"],
        ["\xB9\x8B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x88\x8C"],
        ["\xB9\x8C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x88\x8D"],
        ["\xB9\x8E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x88\x8E"],
        ["\xB9\x93",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x88\x8F"],
        ["\xB3\x74",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x88\x90"],
        ["\xB9\x97",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x88\x91"],
        ["\xB9\xA1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x88\x93"],
        ["\xB9\xA3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x88\x94"],
        ["\xB9\xA9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x88\x95"],
        ["\xB9\xB4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x88\x96"],
        ["\xB9\xC6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x88\x97"],
        ["\xB3\x7B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x88\x98"],
        ["\xB9\xC7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x88\x99"],
        ["\xB3\x7E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x88\x9A"],
        ["\xB9\xCB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x88\x9B"],
        ["\xB3\x7F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x88\x9D"],
        ["\xB9\xD3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x88\x9E"],
        ["\xB3\x81",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x88\x9F"],
        ["\xB9\xE0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x88\xA2"],
        ["\xB3\x83",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x88\xA3"],
        ["\xB9\xF5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x88\xA4"],
        ["\xB9\xF6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x88\xA5"],
        ["\xB3\x87",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x88\xA6"],
        ["\xBA\x44",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x88\xA8"],
        ["\xB3\x8F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x88\xAA"],
        ["\xBA\x60",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x88\xAB"],
        ["\xBA\x6A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x88\xAC"],
        ["\xBA\x72",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x88\xAE"],
        ["\xBA\x75",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x88\xAF"],
        ["\xBA\x76",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x88\xB0"],
        ["\xBA\x7A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x88\xB1"],
        ["\xBA\x7F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x88\xB2"],
        ["\xBA\x81",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x88\xB3"],
        ["\xBA\x8D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x88\xB5"],
        ["\xBA\x9F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x88\xB7"],
        ["\xBA\xA2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x88\xB8"],
        ["\xBA\xA4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x88\xB9"],
        ["\xBA\xAE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x88\xBA"],
        ["\xBA\xB3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x88\xBB"],
        ["\xBA\xB9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x88\xBC"],
        ["\xBA\xBC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x88\xBE"],
        ["\xB3\x9E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x88\xBF"],
        ["\xBA\xC5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\x80"],
        ["\xBA\xCE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\x81"],
        ["\xB3\xA5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\x82"],
        ["\xBA\xDB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\x83"],
        ["\xBA\xDE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\x84"],
        ["\xBA\xEA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\x85"],
        ["\xBA\xF3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\x86"],
        ["\xB3\xAD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\x87"],
        ["\xBA\xFD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\x88"],
        ["\xB3\xAC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\x89"],
        ["\xBB\x42",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\x8A"],
        ["\xBB\x43",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\x8B"],
        ["\xBB\x44",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\x8C"],
        ["\xBB\x4C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\x8D"],
        ["\xBB\x4F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\x8E"],
        ["\xBB\x54",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\x8F"],
        ["\xBB\x56",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\x90"],
        ["\xBB\x59",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\x91"],
        ["\xBB\x5D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\x92"],
        ["\xBB\x5E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\x93"],
        ["\xBB\x76",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\x94"],
        ["\xB3\xB1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\x95"],
        ["\xB3\xB2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\x96"],
        ["\xBB\x86",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\x97"],
        ["\xBB\x87",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\x98"],
        ["\xBB\x88",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\x99"],
        ["\xBB\x98",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\x9A"],
        ["\xBB\x9D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\x9B"],
        ["\xBB\xA1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\x9C"],
        ["\xBB\xAB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\x9D"],
        ["\xB3\xBA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\x9F"],
        ["\xBB\xB3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\xA0"],
        ["\xBB\xB6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\xA3"],
        ["\xBB\xBB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\xA4"],
        ["\xBB\xBF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\xA5"],
        ["\xBB\xC1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\xA6"],
        ["\xBB\xC2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\xA7"],
        ["\xBB\xC6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\xA8"],
        ["\xBB\xCA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\xA9"],
        ["\xBB\xDE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\xAB"],
        ["\xBB\xDF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\xAC"],
        ["\xB3\xBF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\xAD"],
        ["\xBB\xE3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\xAE"],
        ["\xBB\xE9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\xAF"],
        ["\xB3\xC2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\xB1"],
        ["\xBB\xF6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\xB2"],
        ["\xB3\xC6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\xB3"],
        ["\xBC\x41",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\xB4"],
        ["\xBB\xFD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\xB5"],
        ["\xBC\x42",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\xB6"],
        ["\xBC\x44",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\xB7"],
        ["\xB3\xC7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\xB8"],
        ["\xBC\x48",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\xB9"],
        ["\xBC\x4C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\xBA"],
        ["\xCB\xE3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\xBB"],
        ["\xBC\x63",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\xBD"],
        ["\xBC\x6B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\xBE"],
        ["\xBC\x6E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\xBF"],
        ["\xBC\x7B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x8A\x81"],
        ["\xBC\x80",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x8A\x82"],
        ["\xBC\x81",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x8A\x83"],
        ["\xBC\x93",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x8A\x84"],
        ["\xBC\x95",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x8A\x85"],
        ["\xBC\xA6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x8A\x86"],
        ["\xBC\xA7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x8A\x87"],
        ["\xBC\xA8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x8A\x88"],
        ["\xBC\xAB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x8A\x89"],
        ["\xB3\xD7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x8A\x8A"],
        ["\xBC\xB2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x8A\x8B"],
        ["\xBC\xB6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x8A\x8C"],
        ["\xBC\xC0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x8A\x8D"],
        ["\xB3\xD9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x8A\x8E"],
        ["\xBC\xD1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x8A\x8F"],
        ["\xBC\xD5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x8A\x90"],
        ["\xB3\x75",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x8A\x91"],
        ["\xB3\x8D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\xB8\xA7"],
        ["\xBC\xD9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\xB8\xA8"],
        ["\xBC\xE2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\xB8\xAA"],
        ["\xBC\xEC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\xB8\xAB"],
        ["\xB3\xE2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\xB8\xAE"],
        ["\xBD\x4A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\xB8\xB0"],
        ["\xBD\x4D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\xB8\xB1"],
        ["\xB3\xE3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\xB8\xB2"],
        ["\xBD\x57",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\xB8\xB3"],
        ["\xB3\xE7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\xB8\xB4"],
        ["\xB3\xE8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\xB8\xB5"],
        ["\xB3\xD1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\xB8\xB6"],
        ["\xBD\x60",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\xB8\xB7"],
        ["\xBD\x67",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\xB8\xB8"],
        ["\xBD\x6A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\xB8\xB9"],
        ["\xBD\x6D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\xB8\xBA"],
        ["\xBD\x6E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\xB8\xBB"],
        ["\xBD\x73",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\xB8\xBD"],
        ["\xB3\xF3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\xB8\xBE"],
        ["\xBD\x74",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\xB8\xBF"],
        ["\xBD\x7A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\xB9\x80"],
        ["\xB3\xFA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\xB9\x81"],
        ["\xB3\xFB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\xB9\x82"],
        ["\xBD\x7D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\xB9\x83"],
        ["\xBD\x89",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\xB9\x86"],
        ["\xB3\xFC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\xB9\x87"],
        ["\xBD\x8B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\xB9\x89"],
        ["\xBD\x9A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\xB9\x8B"],
        ["\xBD\xA5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\xB9\x8C"],
        ["\xB4\x45",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\xB9\x8D"],
        ["\xBD\xA6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\xB9\x8E"],
        ["\xBD\xAD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\xB9\x90"],
        ["\xB3\x90",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\xB9\x91"],
        ["\x59\xCD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\x83\xBE"],
        ["\xB3\xAB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAE\x90"],
        ["\xB4\x4A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAE\x91"],
        ["\xBD\xBA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAE\x92"],
        ["\xBD\xBC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAE\x93"],
        ["\xBD\xC9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAE\x94"],
        ["\xBD\xCC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAE\x95"],
        ["\xBD\xE0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAE\x96"],
        ["\xB4\x54",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAE\x97"],
        ["\xBD\xE3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAE\x98"],
        ["\xB4\x57",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAE\x99"],
        ["\xB4\x59",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAE\x9A"],
        ["\xBD\xEE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAE\x9B"],
        ["\xBD\xF0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAE\x9C"],
        ["\xBD\xF5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAE\x9D"],
        ["\xBD\xF7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAE\x9E"],
        ["\xBD\xFE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAE\xA0"],
        ["\xBE\x42",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAE\xA1"],
        ["\xBE\x44",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAE\xA2"],
        ["\xBE\x49",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAE\xA4"],
        ["\xBE\x4A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAE\xA5"],
        ["\xBE\x4E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAE\xA6"],
        ["\xBE\x55",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAE\xA8"],
        ["\xBE\x57",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAE\xA9"],
        ["\xBE\x5B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAE\xAA"],
        ["\xBE\x5F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAE\xAB"],
        ["\xBE\x62",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAE\xAC"],
        ["\xB4\x5C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAE\xAD"],
        ["\xBE\x69",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAE\xAF"],
        ["\xBE\x70",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAE\xB1"],
        ["\xBE\x73",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAE\xB2"],
        ["\xBE\x80",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAE\xB3"],
        ["\xBE\x82",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAE\xB4"],
        ["\xBE\x84",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAE\xB5"],
        ["\xBE\x89",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAE\xB6"],
        ["\xBE\x8A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAE\xB7"],
        ["\xBE\x8C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAE\xB8"],
        ["\xB4\x61",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAE\xB9"],
        ["\xBE\xA1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAE\xBA"],
        ["\xBE\xA2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAE\xBB"],
        ["\xBE\xB1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAE\xBC"],
        ["\xBE\xB4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAE\xBD"],
        ["\xBE\xB7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAE\xBF"],
        ["\xBE\xBB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\x80"],
        ["\xBE\xC9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\x81"],
        ["\xBE\xCD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\x82"],
        ["\xB4\x66",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\x85"],
        ["\xBE\xE3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\x86"],
        ["\xB4\x67",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\x87"],
        ["\xBE\xF1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\x88"],
        ["\xBE\xF0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\x89"],
        ["\xB4\x6A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\x8A"],
        ["\xBF\x4D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\x8B"],
        ["\xB4\x6D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\x8C"],
        ["\xBF\x55",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\x8D"],
        ["\xBF\x5D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\x8E"],
        ["\xBF\x5E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\x8F"],
        ["\xBF\x62",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\x90"],
        ["\xB4\x70",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\x91"],
        ["\xBF\x71",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\x92"],
        ["\xBF\x74",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\x93"],
        ["\xBF\x79",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\x94"],
        ["\xBF\x7D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\x95"],
        ["\xBF\x83",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\x96"],
        ["\xBF\x89",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\x97"],
        ["\xBF\x8D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\x98"],
        ["\xBF\x98",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\x99"],
        ["\xBF\xA0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\x9A"],
        ["\xBF\xBD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\x9B"],
        ["\xB4\x7B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\x9C"],
        ["\xBF\xC6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\x9E"],
        ["\xBF\xC8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\x9F"],
        ["\xBF\xCC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\xA0"],
        ["\xB4\x7F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\xA1"],
        ["\xBF\xD8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\xA2"],
        ["\xBF\xE3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\xA4"],
        ["\xBF\xF8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\xA6"],
        ["\xBF\xF9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\xA7"],
        ["\xBF\xFA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\xA8"],
        ["\xBF\xFC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\xA9"],
        ["\xC0\x41",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\xAA"],
        ["\xC0\x4C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\xAB"],
        ["\xC0\x4D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\xAC"],
        ["\xC0\x5C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\xAD"],
        ["\xC0\x5E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\xAE"],
        ["\xB4\x85",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\xAF"],
        ["\xC0\x6C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\xB0"],
        ["\xC0\x76",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\xB1"],
        ["\xB4\x89",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\xB2"],
        ["\xB4\x8D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\xB7"],
        ["\xC0\x97",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\xB8"],
        ["\xC0\x9C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\xBA"],
        ["\xC0\x9E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\xBB"],
        ["\xC0\x9F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\xBD"],
        ["\xB4\x8E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\xBF"],
        ["\xC0\xA6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\x80"],
        ["\xB4\x94",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\x81"],
        ["\xB4\x90",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\x83"],
        ["\xC0\xAD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\x84"],
        ["\xC0\xB2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\x87"],
        ["\xC0\xB3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\x88"],
        ["\xC0\xBC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\x89"],
        ["\xB4\x97",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\x8A"],
        ["\xC0\xC7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\x8D"],
        ["\xB4\x9B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\x8E"],
        ["\xC0\xCB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\x8F"],
        ["\xB4\x9C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\x90"],
        ["\xC0\xD0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\x91"],
        ["\xC0\xD2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\x92"],
        ["\xC0\xD8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\x94"],
        ["\xC0\xDD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\x96"],
        ["\xC0\xE0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\x98"],
        ["\xC0\xE1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\x99"],
        ["\xC0\xEA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\x9A"],
        ["\xC0\xEB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\x9B"],
        ["\xC0\xF0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\x9C"],
        ["\xC0\xF2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\x9D"],
        ["\xC0\xF4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\x9E"],
        ["\xC1\x4C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\xA0"],
        ["\xC1\x43",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\xA2"],
        ["\xB4\xAB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\xA3"],
        ["\xC1\x4F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\xA6"],
        ["\xC1\x53",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\xA7"],
        ["\xC1\x57",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\xA8"],
        ["\xC1\x61",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\xA9"],
        ["\xC1\x67",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\xAA"],
        ["\xC1\x68",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\xAB"],
        ["\xB4\xB3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\xAC"],
        ["\xC1\x76",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\xAD"],
        ["\xC1\x77",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\xAE"],
        ["\xC1\x7B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\xAF"],
        ["\xC1\x7F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\xB1"],
        ["\xC1\x87",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\xB2"],
        ["\xC1\x8B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\xB3"],
        ["\xC1\x8C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\xB4"],
        ["\xC1\x8D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\xB5"],
        ["\xC1\x91",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\xB6"],
        ["\xC1\x95",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\xB7"],
        ["\xC1\xA2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\xB8"],
        ["\xB4\xCB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\xB9"],
        ["\xC1\x9D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\xBA"],
        ["\xC1\xA0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\xBB"],
        ["\xC1\xA4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\xBC"],
        ["\xC1\xA6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\xBD"],
        ["\xC1\xA7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\xBE"],
        ["\xC1\xB2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\x80"],
        ["\xC1\xB7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\x82"],
        ["\xC1\xBB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\x83"],
        ["\xB4\xC9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\x84"],
        ["\xB4\xCA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\x85"],
        ["\xB4\xD1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\x86"],
        ["\xB4\xCD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\x88"],
        ["\xB4\xCE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\x89"],
        ["\xC1\xCB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\x8A"],
        ["\xB4\xD0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\x8B"],
        ["\xC1\xD0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\x8C"],
        ["\xC1\xD2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\x8D"],
        ["\xB4\xDE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\x8E"],
        ["\xC1\xDB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\x8F"],
        ["\xC1\xDC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\x90"],
        ["\xC1\xDE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\x91"],
        ["\xC1\xE2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\x92"],
        ["\xC1\xE6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\x93"],
        ["\xC1\xE7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\x94"],
        ["\xB4\xDF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\x97"],
        ["\xC1\xF0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\x98"],
        ["\xB4\xDA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\x99"],
        ["\xC1\xF4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\x9A"],
        ["\xC1\xF5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\x9B"],
        ["\xC1\xF7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\x9C"],
        ["\xC2\x4C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\x9E"],
        ["\xB4\xE2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\x9F"],
        ["\xB4\xE4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\xA0"],
        ["\xC2\x5C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\xA1"],
        ["\xC2\x5D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\xA2"],
        ["\xC2\x61",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\xA3"],
        ["\xC2\x63",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\xA4"],
        ["\xC2\x67",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\xA5"],
        ["\xC2\x6B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\xA6"],
        ["\xC2\x6E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\xA7"],
        ["\xB4\xEA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\xA8"],
        ["\xC2\x6F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\xA9"],
        ["\xB4\xEC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\xAA"],
        ["\xC2\x76",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\xAB"],
        ["\xC2\x7F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\xAC"],
        ["\xC2\x81",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\xAD"],
        ["\xB4\xEF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\xAE"],
        ["\xB4\xF3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\xAF"],
        ["\xB4\xF4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\xB1"],
        ["\xC2\x95",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\xB2"],
        ["\xC2\x98",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\xB3"],
        ["\xC2\x9C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\xB4"],
        ["\xC2\xA5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\xB5"],
        ["\xC2\xB0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\xB6"],
        ["\xB4\xF9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\xB8"],
        ["\xC2\xB5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\xB9"],
        ["\xC2\xB6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\xBA"],
        ["\xC2\xBA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\xBB"],
        ["\xC2\xC0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\xBD"],
        ["\xC2\xC1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\xBE"],
        ["\xB4\xFD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\xBF"],
        ["\xC2\xC7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\x80"],
        ["\xC2\xCD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\x81"],
        ["\xC2\xD0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\x82"],
        ["\xC2\xD3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\x83"],
        ["\xC2\xD5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\x84"],
        ["\xB5\x43",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\x85"],
        ["\xC2\xDA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\x87"],
        ["\xC2\xE2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\x88"],
        ["\xC2\xE4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\x89"],
        ["\xC2\xE5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\x8A"],
        ["\xC2\xE7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\x8B"],
        ["\xB5\x46",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\x8C"],
        ["\xC2\xEC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\x8D"],
        ["\xB5\x49",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\x8E"],
        ["\xC2\xF0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\x8F"],
        ["\xB5\x4C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\x91"],
        ["\xC2\xF3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\x92"],
        ["\xC2\xF6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\x93"],
        ["\xC2\xFB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\x95"],
        ["\xC2\xFC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\x96"],
        ["\xC3\x42",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\x97"],
        ["\xB5\x54",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\x98"],
        ["\xC3\x43",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\x99"],
        ["\xC3\x44",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\x9A"],
        ["\xB5\x59",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\x9C"],
        ["\xB5\x5B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\x9D"],
        ["\xC3\x55",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\x9E"],
        ["\xC3\x61",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\xA0"],
        ["\xB5\x5E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\xA1"],
        ["\xC3\x6F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\xA2"],
        ["\xC3\x73",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\xA3"],
        ["\xC3\x75",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\xA4"],
        ["\xC3\x79",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\xA5"],
        ["\xB5\x61",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\xA6"],
        ["\xC3\x88",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\xA7"],
        ["\xB5\x62",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\xA8"],
        ["\xC3\x8C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\xA9"],
        ["\xC3\x8E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\xAA"],
        ["\xC3\x90",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\xAB"],
        ["\xC3\x95",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\xAC"],
        ["\xC3\x99",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\xAD"],
        ["\xC3\x9C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\xAE"],
        ["\xC3\x9D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\xAF"],
        ["\xC3\x9E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\xB0"],
        ["\xC3\xA2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\xB1"],
        ["\xC3\xA6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\xB3"],
        ["\xC3\xA7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\xB4"],
        ["\xC3\xAB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\xB5"],
        ["\xC3\xAF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\xB6"],
        ["\xC3\xB2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\xB7"],
        ["\xC3\xB7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\xB8"],
        ["\xC3\xB8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\xB9"],
        ["\xC3\xBA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\xBA"],
        ["\xC3\xBC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\xBB"],
        ["\xC3\xC2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\xBC"],
        ["\xC3\xC1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\xBD"],
        ["\xC3\xC6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\x80"],
        ["\xC3\xD4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\x82"],
        ["\xC3\xD9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\x83"],
        ["\xC3\xDA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\x84"],
        ["\xC3\xD6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\x85"],
        ["\xC3\xDB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\x86"],
        ["\xC3\xDF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\x87"],
        ["\xC3\xEA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\x89"],
        ["\xC3\xEE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\x8B"],
        ["\xC3\xF2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\x8C"],
        ["\xC3\xF5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\x8D"],
        ["\xC3\xF7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\x8E"],
        ["\xC4\x43",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\x90"],
        ["\xC4\x41",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\x91"],
        ["\xC4\x42",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\x92"],
        ["\xB5\x78",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\x93"],
        ["\xC4\x46",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\x94"],
        ["\xB5\x79",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\x97"],
        ["\xB5\x7C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\x98"],
        ["\xC4\x4E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\x99"],
        ["\xC4\x52",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\x9B"],
        ["\xC4\x53",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\x9C"],
        ["\xC4\x56",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\x9E"],
        ["\xC4\x57",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\x9F"],
        ["\xC4\x59",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\xA0"],
        ["\xC4\x62",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\xA2"],
        ["\xC4\x65",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\xA3"],
        ["\xC4\x6E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\xA5"],
        ["\xB5\x81",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\xA6"],
        ["\xC4\x85",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\xA7"],
        ["\xC4\x86",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\xA8"],
        ["\xB5\x85",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\xA9"],
        ["\xC4\x98",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\xAA"],
        ["\xC4\x9B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\xAB"],
        ["\xB5\x88",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\xAD"],
        ["\xC4\xAC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\xAE"],
        ["\xB5\x8E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\xAF"],
        ["\xC4\xBA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\xB0"],
        ["\xC4\xBB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\xB1"],
        ["\xC4\xC5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\xB3"],
        ["\xC4\xCD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\xB4"],
        ["\xC4\xD6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\xB5"],
        ["\xC4\xDF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\xB6"],
        ["\xC4\xE4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\xB7"],
        ["\xC4\xE5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\xB8"],
        ["\xC4\xE6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\xB9"],
        ["\xC4\xE8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\xBA"],
        ["\xC4\xEA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\xBB"],
        ["\xC4\xF5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\xBD"],
        ["\xC4\xF7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\xBF"],
        ["\xC4\xFC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\x81"],
        ["\xC5\x49",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\x83"],
        ["\xC5\x4B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\x84"],
        ["\xC5\x4C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\x85"],
        ["\xB5\x96",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\x86"],
        ["\xC5\x4E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\x88"],
        ["\xC5\x4F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\x8A"],
        ["\xC5\x50",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\x8B"],
        ["\xC5\x52",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\x8D"],
        ["\xC5\x53",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\x8E"],
        ["\xC5\x58",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\x8F"],
        ["\xC5\x59",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\x90"],
        ["\xC5\x5A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\x91"],
        ["\xC5\x5B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\x92"],
        ["\xC5\x5F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\x93"],
        ["\xC5\x64",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\x95"],
        ["\xC5\x65",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\x96"],
        ["\xC5\x6C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\x97"],
        ["\xC5\x6D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\x98"],
        ["\xC5\x72",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\x9A"],
        ["\xC5\x75",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\x9B"],
        ["\xC5\x78",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\x9D"],
        ["\xC5\x6F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\x9E"],
        ["\xC5\x79",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\x9F"],
        ["\xC5\x7A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\xA0"],
        ["\xC5\x7B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\xA1"],
        ["\xC5\x82",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\xA2"],
        ["\xC5\x85",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\xA3"],
        ["\xC5\x86",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\xA4"],
        ["\xC5\x87",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\xA5"],
        ["\xC5\x8C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\xA6"],
        ["\xC5\x99",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\xA7"],
        ["\xC5\x9D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\xA9"],
        ["\xC5\xB5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\xAC"],
        ["\xC5\xBE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\xAD"],
        ["\xB5\xA6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\xAE"],
        ["\xC5\xCD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\xAF"],
        ["\xC5\xD4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\xB0"],
        ["\xC5\xDB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\xB1"],
        ["\xC5\xDC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\xB2"],
        ["\xC5\xE0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\xB3"],
        ["\xC5\xE6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\xB4"],
        ["\xC5\xE7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\xB5"],
        ["\xC5\xE8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\xB6"],
        ["\xC5\xEC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\xB7"],
        ["\xC5\xF1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\xB8"],
        ["\xC5\xF4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\xB9"],
        ["\xC5\xFB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\xBA"],
        ["\xC6\x42",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\xBB"],
        ["\xC6\x46",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\xBC"],
        ["\xC6\x47",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\xBD"],
        ["\xC6\x48",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\xBE"],
        ["\xC6\x4A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\xBF"],
        ["\xC6\x4B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\x80"],
        ["\xC6\x4D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\x81"],
        ["\xC6\x52",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\x83"],
        ["\xC6\x5B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\x86"],
        ["\xB5\xB8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\x87"],
        ["\xC6\x5F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\x88"],
        ["\xC6\x62",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\x89"],
        ["\xC6\x63",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\x8A"],
        ["\xC6\x64",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\x8B"],
        ["\xC6\x67",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\x8C"],
        ["\xC6\x6B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\x8D"],
        ["\xC6\x6E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\x8E"],
        ["\xC6\x71",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\x8F"],
        ["\xC6\x77",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\x90"],
        ["\xC6\x7F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\x91"],
        ["\xC6\x81",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\x92"],
        ["\xC6\x88",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\x94"],
        ["\xC6\x89",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\x95"],
        ["\xC6\x8E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\x96"],
        ["\xC6\x90",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\x97"],
        ["\xC6\x92",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\x98"],
        ["\xC6\x9B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\x99"],
        ["\xC6\x9D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\x9A"],
        ["\xC6\xA1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\x9B"],
        ["\xC6\xA8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\x9C"],
        ["\xC6\xB6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\x9D"],
        ["\xC6\xC9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\x9E"],
        ["\xB5\xCD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\x9F"],
        ["\xC6\xCE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\xA0"],
        ["\xB5\xCB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\xA2"],
        ["\xB5\xCC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\xA3"],
        ["\xC6\xD9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\xA4"],
        ["\xC6\xDB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\xA5"],
        ["\xB5\xCE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\xA6"],
        ["\xC6\xE9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\xA7"],
        ["\xB5\xD0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\xA8"],
        ["\xC6\xE8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\xA9"],
        ["\xC6\xFD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\xAA"],
        ["\xC7\x42",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\xAB"],
        ["\xC7\x49",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\xAC"],
        ["\xC7\x45",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\xAD"],
        ["\xC7\x4E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\xAE"],
        ["\xB5\xD5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\xAF"],
        ["\xC7\x56",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\xB0"],
        ["\xC7\x57",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\xB1"],
        ["\xB5\xD6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\xB2"],
        ["\xB5\xD8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\xB3"],
        ["\xC7\x5D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\xB4"],
        ["\xC7\x5E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\xB5"],
        ["\xB5\xD7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\xB6"],
        ["\xB5\xD9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\xB7"],
        ["\xB5\xDA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\xB8"],
        ["\xC7\x66",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\xB9"],
        ["\xB5\xDB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\xBA"],
        ["\xC7\x6B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\xBD"],
        ["\xB5\xDD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\xBE"],
        ["\xB5\xDE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\xBF"],
        ["\xC7\x75",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\x81"],
        ["\xC7\x7C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\x82"],
        ["\xC7\x7E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\x83"],
        ["\xC7\x83",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\x84"],
        ["\xC7\x84",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\x85"],
        ["\xB5\xE1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\x86"],
        ["\xC7\x86",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\x87"],
        ["\xC7\x8A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\x88"],
        ["\xC7\x8F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\x89"],
        ["\xC7\x90",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\x8A"],
        ["\xC7\x95",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\x8B"],
        ["\xB5\xE7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\x8C"],
        ["\xC7\xA7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\x8D"],
        ["\xC7\xB2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\x8E"],
        ["\xC7\xB8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\x8F"],
        ["\xB5\xE8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\x90"],
        ["\xC7\xBE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\x91"],
        ["\xC7\xC6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\x92"],
        ["\xB5\xE9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\x93"],
        ["\xC7\xC9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\x94"],
        ["\xC7\xCC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\x95"],
        ["\xC7\xD1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\x96"],
        ["\xC7\xD9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\x98"],
        ["\xB5\xF1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\x99"],
        ["\xC7\xE3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\x9A"],
        ["\xB5\xF3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\x9B"],
        ["\xC7\xED",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\x9C"],
        ["\xC7\xEE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\x9D"],
        ["\xC7\xF0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\x9E"],
        ["\xC7\xF5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\x9F"],
        ["\xC7\xF6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\xA0"],
        ["\xC7\xF7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\xA1"],
        ["\xB5\xFB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\xA3"],
        ["\xC8\x55",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\xA4"],
        ["\xC8\x56",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\xA5"],
        ["\xC8\x63",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\xA6"],
        ["\xC8\x74",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\xA7"],
        ["\xB6\x41",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\xA8"],
        ["\xC8\x6F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\xA9"],
        ["\xC8\x75",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\xAA"],
        ["\xC8\x77",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\xAB"],
        ["\xB6\x42",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\xAC"],
        ["\xB6\x44",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\xAD"],
        ["\xC8\x80",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\xAE"],
        ["\xC8\x8A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\xAF"],
        ["\xC8\x8E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\xB0"],
        ["\xC8\x93",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\xB1"],
        ["\xC8\x94",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\xB2"],
        ["\xC8\x96",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\xB3"],
        ["\xC8\x9D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\xB4"],
        ["\xC8\xA7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\xB5"],
        ["\xC8\xA9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\xB6"],
        ["\xC8\xAB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\xB7"],
        ["\xC8\xB1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\xB8"],
        ["\xC8\xB2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\xB9"],
        ["\xC8\xB7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\xBA"],
        ["\xC8\xB9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\xBB"],
        ["\xC8\xBB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\xBC"],
        ["\xC8\xBF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\xBD"],
        ["\xC8\xC4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\xBE"],
        ["\xC8\xC8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\x80"],
        ["\xC8\xD2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\x82"],
        ["\xC8\xD7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\x83"],
        ["\xC8\xDB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\x84"],
        ["\xC8\xE3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\x86"],
        ["\xC8\xE9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\x87"],
        ["\xC8\xEE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\x88"],
        ["\xB6\x5A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\x8A"],
        ["\xB6\x5B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\x8B"],
        ["\xC9\x4A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\x8C"],
        ["\xC9\x41",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\x8D"],
        ["\xC9\x43",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\x8E"],
        ["\xC9\x44",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\x8F"],
        ["\xB6\x5F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\x90"],
        ["\xC9\x53",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\x91"],
        ["\xC9\x58",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\x93"],
        ["\xC9\x64",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\x95"],
        ["\xB6\x65",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\x97"],
        ["\xC9\x87",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\x98"],
        ["\xC9\x89",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\x99"],
        ["\xC9\x91",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\x9A"],
        ["\xC9\x95",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\x9B"],
        ["\xC9\x97",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\x9C"],
        ["\xC9\x98",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\x9D"],
        ["\xC9\x9C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\x9E"],
        ["\xC9\x9D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\x9F"],
        ["\xC9\xA0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\xA0"],
        ["\xB6\x6A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\xA1"],
        ["\xC9\xAC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\xA2"],
        ["\xC9\xB3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\xA3"],
        ["\xC9\xB8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\xA4"],
        ["\xC9\xB9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\xA5"],
        ["\xC9\xBC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\xA6"],
        ["\xB6\x70",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\xA7"],
        ["\xC9\xD6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\xA8"],
        ["\xC9\xD8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\xA9"],
        ["\xC9\xDD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\xAA"],
        ["\xC9\xE6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\xAB"],
        ["\xC9\xF3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\xAC"],
        ["\xC9\xF7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\xAD"],
        ["\xC9\xF9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\xAE"],
        ["\xC9\xFA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\xAF"],
        ["\xC9\xFC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\xB0"],
        ["\xCA\x50",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\xB1"],
        ["\xCA\x53",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\xB2"],
        ["\xCA\x56",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\xB3"],
        ["\xCA\x58",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\xB4"],
        ["\xB6\x83",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\xB5"],
        ["\xB6\x84",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\xB6"],
        ["\xB6\x88",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\xB7"],
        ["\xCA\x81",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\xB8"],
        ["\xCA\x85",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\xB9"],
        ["\xB6\x97",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\xBA"],
        ["\xCA\x90",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\xBB"],
        ["\xCA\x98",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\xBC"],
        ["\xCA\x99",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\xBD"],
        ["\xCA\x9A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\xBE"],
        ["\xCA\x9D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\xBF"],
        ["\xCA\x9F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB8\x80"],
        ["\xCA\xA3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB8\x81"],
        ["\xCA\xA6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB8\x82"],
        ["\xCA\xA7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB8\x83"],
        ["\xCA\xA8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB8\x84"],
        ["\xCA\xAA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB8\x85"],
        ["\xCA\xB5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB8\x86"],
        ["\xCA\xB6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB8\x87"],
        ["\xCA\xB7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB8\x88"],
        ["\xCA\xC1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB8\x8B"],
        ["\xCA\xC3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB8\x8C"],
        ["\xCA\xC8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB8\x8D"],
        ["\xCA\xCC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB8\x8E"],
        ["\xCA\xCE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB8\x8F"],
        ["\xCA\xD1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB8\x90"],
        ["\xCA\xD4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB8\x91"],
        ["\xCA\xD9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB8\x92"],
        ["\xCA\xDD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB8\x93"],
        ["\xCA\xDF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB8\x94"],
        ["\xCA\xE2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB8\x95"],
        ["\xCA\xE8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB8\x96"],
        ["\xCA\xE9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB8\x97"],
        ["\xCA\xED",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB8\x98"],
        ["\xCA\xEE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB8\x99"],
        ["\xCA\xF0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB8\x9B"],
        ["\xCA\xF2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB8\x9C"],
        ["\xB6\x9F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB8\x9D"],
        ["\xCA\xF6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB8\x9E"],
        ["\xCA\xFA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB8\x9F"],
        ["\xCA\xFB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB8\xA0"],
        ["\xCA\xFC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB8\xA1"],
        ["\xB6\xA3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB8\xA2"],
        ["\xB6\xA5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB8\xA4"],
        ["\xCB\x56",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB8\xA5"],
        ["\xCB\x57",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB8\xA6"],
        ["\xCB\x5E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB8\xA7"],
        ["\xCB\x62",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB8\xA8"],
        ["\xCB\x67",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB8\xA9"],
        ["\xCB\x69",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB8\xAB"],
        ["\xCB\x6C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB8\xAC"],
        ["\xCB\x6D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB8\xAD"],
        ["\xB6\xAB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB8\xAE"],
        ["\xCB\x8D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB8\xAF"],
        ["\xCB\x84",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB8\xB0"],
        ["\xCB\x86",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB8\xB1"],
        ["\xCB\x8C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB8\xB2"],
        ["\xCB\x9F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB8\xB4"],
        ["\xCB\xB5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB8\xB6"],
        ["\xCB\xA2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB8\xB7"],
        ["\xCB\xAB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB8\xB8"],
        ["\xCB\xAC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB8\xB9"],
        ["\xCB\xB2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB8\xBA"],
        ["\xCB\xC1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB8\xBC"],
        ["\xCB\xC2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB8\xBD"],
        ["\xCB\xC9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB8\xBE"],
        ["\xCB\xD5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB8\xBF"],
        ["\xCB\xCD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\x80"],
        ["\xCB\xCF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\x81"],
        ["\xCB\xD0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\x82"],
        ["\xCB\xD3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\x83"],
        ["\xB6\xB7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\x84"],
        ["\xCB\xD6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\x85"],
        ["\xCB\xDC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\x86"],
        ["\xCB\xDE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\x87"],
        ["\xCB\xE9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\x88"],
        ["\xB6\xBB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\x89"],
        ["\xB6\xBC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\x8A"],
        ["\xCB\xEF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\x8B"],
        ["\xB6\xBD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\x8C"],
        ["\xCB\xF3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\x8D"],
        ["\xCB\xF5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\x8E"],
        ["\xCB\xFD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\x8F"],
        ["\xCC\x4C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\x90"],
        ["\xCC\x5D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\x91"],
        ["\xCC\x5E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\x92"],
        ["\xCC\x5F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\x93"],
        ["\xCC\x63",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\x94"],
        ["\xCC\x82",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\x95"],
        ["\xCC\x89",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\x96"],
        ["\xCC\x8A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\x97"],
        ["\xCC\x98",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\x98"],
        ["\xCC\x99",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\x99"],
        ["\xCC\x9C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\x9A"],
        ["\xB6\xCA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\x9B"],
        ["\xCC\xA5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\x9C"],
        ["\xB6\xCE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\x9D"],
        ["\xCC\xB7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\x9E"],
        ["\xCC\xB9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\x9F"],
        ["\xCC\xBB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\xA0"],
        ["\xCC\xBE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\xA1"],
        ["\xCC\xC5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\xA2"],
        ["\xCC\xE4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\xA3"],
        ["\xCC\xEB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\xA4"],
        ["\xCC\xF0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\xA5"],
        ["\xCC\xF4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\xA6"],
        ["\xB6\xD6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\xA7"],
        ["\xB6\xD9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\xAA"],
        ["\xCD\x48",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\xAB"],
        ["\xCD\x49",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\xAC"],
        ["\xCD\x4A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\xAD"],
        ["\xCD\x4D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\xAE"],
        ["\xCD\x4F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\xAF"],
        ["\xCD\x51",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\xB0"],
        ["\xCD\x53",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\xB1"],
        ["\xCD\x56",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\xB2"],
        ["\xCD\x70",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\xB3"],
        ["\xB6\xE0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\xB4"],
        ["\xCD\x7D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\xB5"],
        ["\xCD\x82",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\xB6"],
        ["\xCD\x88",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\xB7"],
        ["\xCD\x92",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\xB9"],
        ["\xCD\x95",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\xBA"],
        ["\xCD\xA1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\xBC"],
        ["\xCD\xA4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\xBD"],
        ["\xCD\xAA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\xBE"],
        ["\xCD\xAB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\xBF"],
        ["\xCD\xAE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\x80"],
        ["\xB6\xE5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\x83"],
        ["\xCD\xD4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\x85"],
        ["\xB6\xE6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\x88"],
        ["\xB6\xE9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\x89"],
        ["\xCD\xE8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\x8A"],
        ["\xCD\xEC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\x8B"],
        ["\xCD\xED",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\x8C"],
        ["\xB6\xEC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\x8D"],
        ["\xB6\xED",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\x8E"],
        ["\xCE\x49",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\x8F"],
        ["\xCE\x57",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\x90"],
        ["\xB6\xF3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\x91"],
        ["\xCE\x74",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\x92"],
        ["\xCE\x7B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\x94"],
        ["\xCE\x7C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\x95"],
        ["\xB6\xF6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\x96"],
        ["\xCE\x82",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\x98"],
        ["\xCE\x95",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\x99"],
        ["\xCE\xA2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\x9A"],
        ["\xCE\xA3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\x9B"],
        ["\xCE\xA6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\x9C"],
        ["\xCE\xB9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\x9D"],
        ["\xCE\xBC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\x9E"],
        ["\xCE\xC5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\x9F"],
        ["\xCE\xD7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\xA0"],
        ["\xCE\xDB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\xA1"],
        ["\xB7\x43",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\xA2"],
        ["\xCE\xEF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\xA3"],
        ["\xB7\x45",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\xA4"],
        ["\xCE\xFE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\xA5"],
        ["\xCF\x4A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\xA6"],
        ["\xCF\x52",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\xA7"],
        ["\xCF\x56",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\xA8"],
        ["\xCF\x61",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\xA9"],
        ["\xB7\x4A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\xAA"],
        ["\xCF\x6C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\xAB"],
        ["\xCF\x6D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\xAC"],
        ["\xCF\x7D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\xAD"],
        ["\xCF\x7E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\xAE"],
        ["\xCF\x7F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\xAF"],
        ["\xCF\x87",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\xB0"],
        ["\xCF\x8F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\xB1"],
        ["\xB7\x4F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\xB2"],
        ["\xCF\xA1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\xB3"],
        ["\xCF\xA6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\xB4"],
        ["\xCF\xA7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\xB5"],
        ["\xCF\xA9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\xB6"],
        ["\xCF\xAA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\xB7"],
        ["\xCF\xAD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\xB8"],
        ["\xCF\xB1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\xB9"],
        ["\xCF\xB5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\xBA"],
        ["\xCF\xB7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\xBB"],
        ["\xCF\xB8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\xBC"],
        ["\xCF\xB9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\xBD"],
        ["\xCF\xBE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\xBE"],
        ["\xCF\xC2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\xBF"],
        ["\xCF\xC6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBB\x81"],
        ["\xCF\xC8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBB\x82"],
        ["\xCF\xD3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBB\x84"],
        ["\xCF\xD4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBB\x86"],
        ["\xCF\xDB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBB\x87"],
        ["\xCF\xDC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBB\x88"],
        ["\xCF\xE0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBB\x8A"],
        ["\xCF\xE1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBB\x8B"],
        ["\xCF\xE2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBB\x8C"],
        ["\xCF\xE8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBB\x8D"],
        ["\xCF\xEB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBB\x8E"],
        ["\xCF\xF1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBB\x8F"],
        ["\xCF\xFB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBB\x90"],
        ["\xD0\x47",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBB\x91"],
        ["\xD0\x4B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBB\x92"],
        ["\xD0\x4F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBB\x93"],
        ["\xD0\x54",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBB\x94"],
        ["\xD0\x65",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBB\x96"],
        ["\xD0\x62",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBB\x9A"],
        ["\xD0\x6B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBB\x9B"],
        ["\xD0\x7F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBB\x9D"],
        ["\xD0\x82",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBB\xA2"],
        ["\xD0\x87",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBB\xA3"],
        ["\xD0\xB2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBB\xA6"],
        ["\xD0\xB8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBB\xA7"],
        ["\xD0\xB9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBB\xA8"],
        ["\xB7\x63",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBB\xAC"],
        ["\xD0\xCE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBB\xAD"],
        ["\xD0\xD8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBB\xB1"],
        ["\xB7\x66",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBB\xB2"],
        ["\xD0\xE0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBB\xB3"],
        ["\xD0\xE1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBB\xB4"],
        ["\xD0\xE4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBB\xB5"],
        ["\xD0\xF9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBB\xB7"],
        ["\xD0\xFC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBB\xB8"],
        ["\xD1\x46",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBB\xB9"],
        ["\xD1\x53",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBB\xBC"],
        ["\xD1\x5E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBB\xBD"],
        ["\xD1\x5B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBB\xBE"],
        ["\xD1\x6B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBB\xBF"],
        ["\xD1\x71",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\x80"],
        ["\xD1\x78",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\x81"],
        ["\xD1\x7A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\x82"],
        ["\xD1\x7E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\x83"],
        ["\xD1\x7F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\x84"],
        ["\xD1\x89",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\x85"],
        ["\xD1\x8C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\x86"],
        ["\xD1\x8E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\x87"],
        ["\xD1\x8F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\x88"],
        ["\xD1\x91",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\x89"],
        ["\xD1\x93",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\x8A"],
        ["\xD1\x95",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\x8B"],
        ["\xD1\x9A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\x8C"],
        ["\xD1\x9B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\x8D"],
        ["\xD1\x9E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\x8E"],
        ["\xB7\x75",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\x8F"],
        ["\xD1\xA0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\x90"],
        ["\xD1\xA2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\x91"],
        ["\xD1\xBB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\x92"],
        ["\xD1\xC6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\x93"],
        ["\xD1\xCC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\x96"],
        ["\xD1\xCD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\x97"],
        ["\xD1\xD4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\x98"],
        ["\xD1\xD8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\x99"],
        ["\xB7\x82",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\x9A"],
        ["\xD1\xDA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\x9B"],
        ["\xD1\xDB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\x9C"],
        ["\xD1\xEC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\xA0"],
        ["\xD1\xEF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\xA2"],
        ["\xD1\xF4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\xA3"],
        ["\xD1\xF5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\xA4"],
        ["\xD1\xFE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\xA5"],
        ["\xD2\x49",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\xA6"],
        ["\xD2\x50",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\xA7"],
        ["\xD2\x54",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\xA8"],
        ["\xD2\x58",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\xA9"],
        ["\xD2\x65",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\xAA"],
        ["\xD2\x63",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\xAB"],
        ["\xD2\x6B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\xAC"],
        ["\xB7\x89",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\xAD"],
        ["\xD2\x70",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\xAE"],
        ["\xD2\x77",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\xAF"],
        ["\xD2\x7C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\xB0"],
        ["\xD2\x7F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\xB1"],
        ["\xB7\x8D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\xB2"],
        ["\xD2\x88",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\xB3"],
        ["\xD2\x89",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\xB4"],
        ["\xD2\x8A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\xB5"],
        ["\xD2\x8B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\xB7"],
        ["\xD2\x8C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\xB8"],
        ["\xB7\x8E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\xB9"],
        ["\xD2\x91",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\xBB"],
        ["\xD2\x99",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\xBC"],
        ["\xD2\x9E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\xBD"],
        ["\xD2\xA4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\xBE"],
        ["\xD2\xC7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\xBF"],
        ["\xD2\xEC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\x81"],
        ["\xD2\xED",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\x82"],
        ["\xD2\xF8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\x83"],
        ["\xD2\xFA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\x84"],
        ["\xD2\xFB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\x85"],
        ["\xD3\x41",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\x86"],
        ["\xD3\x45",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\x87"],
        ["\xB7\xA1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\x89"],
        ["\xD3\x53",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\x8A"],
        ["\xD3\x58",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\x8B"],
        ["\xD3\x59",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\x8C"],
        ["\xD3\x5C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\x8D"],
        ["\xD3\x60",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\x8E"],
        ["\xD3\x6C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\x8F"],
        ["\xD3\x72",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\x90"],
        ["\xD3\x76",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\x91"],
        ["\xD3\x82",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\x92"],
        ["\xB7\xA9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\x93"],
        ["\xD3\x85",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\x94"],
        ["\xD3\x94",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\x95"],
        ["\xD3\xA2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\x96"],
        ["\xD3\x98",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\x97"],
        ["\xD3\xA5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\x9A"],
        ["\xD3\xAA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\x9B"],
        ["\xD3\xB1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\x9D"],
        ["\xD3\xB3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\x9E"],
        ["\xD3\xBD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\x9F"],
        ["\xD3\xC0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\xA0"],
        ["\xD3\xC6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\xA1"],
        ["\xD3\xCD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\xA2"],
        ["\xD3\xD0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\xA3"],
        ["\xD3\xDD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\xA5"],
        ["\xD3\xE8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\xA6"],
        ["\xD3\xEF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\xA7"],
        ["\xD3\xF0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\xA8"],
        ["\xD3\xF1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\xA9"],
        ["\xD3\xFA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\xAA"],
        ["\xB7\xB6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\xAB"],
        ["\xD4\x45",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\xAC"],
        ["\xD4\x51",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\xAD"],
        ["\xD4\x52",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\xAE"],
        ["\xD4\x5C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\xAF"],
        ["\xD4\x5E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\xB0"],
        ["\xB7\xBE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\xB1"],
        ["\xD4\x64",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\xB2"],
        ["\xD4\x6B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\xB4"],
        ["\xD4\x70",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\xB5"],
        ["\xD4\x76",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\xB6"],
        ["\xB7\xC4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\xB7"],
        ["\xD4\x7B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\xB8"],
        ["\xD4\x80",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\xB9"],
        ["\xD4\x89",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\xBA"],
        ["\xB7\xC6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\xBB"],
        ["\xD4\x8F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\xBC"],
        ["\xD4\x98",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\xBD"],
        ["\xD4\x9E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\xBE"],
        ["\xD4\xA4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\xBF"],
        ["\xD4\xB0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\x80"],
        ["\xD4\xB1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\x81"],
        ["\xD4\xB3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\x82"],
        ["\xD4\xB5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\x83"],
        ["\xD4\xB8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\x84"],
        ["\xD4\xB9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\x85"],
        ["\xB7\xCB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\x86"],
        ["\xD4\xCE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\x88"],
        ["\xD4\xE1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\x89"],
        ["\xD4\xEF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\x8A"],
        ["\xD5\x42",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\x8B"],
        ["\xD5\x45",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\x8C"],
        ["\xD5\x47",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\x8D"],
        ["\xD5\x4A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\x8E"],
        ["\xB3\xD3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\x8F"],
        ["\xB3\xE5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\x90"],
        ["\xB4\x51",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\x91"],
        ["\xC5\xEF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\x92"],
        ["\xC9\x5B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\x93"],
        ["\xB3\x46",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\x94"],
        ["\xB8\x41",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\x95"],
        ["\xB3\x41",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\x96"],
        ["\xB8\x45",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\x97"],
        ["\xB3\x44",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\x98"],
        ["\xB8\x49",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\x99"],
        ["\xB8\x4A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\x9A"],
        ["\xB8\x4E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\x9B"],
        ["\xB8\x51",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\x9C"],
        ["\xB3\x47",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\x9D"],
        ["\xB3\x48",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\x9E"],
        ["\xB8\x52",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\x9F"],
        ["\xB3\x4A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\xA0"],
        ["\xB3\x49",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\xA1"],
        ["\xB8\x53",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\xA2"],
        ["\xB8\x57",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\xA3"],
        ["\xB8\x5F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\xA4"],
        ["\xB3\x4B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\xA5"],
        ["\xB3\x4C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\xA6"],
        ["\xB8\x61",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\xA7"],
        ["\xB3\x4D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\xA8"],
        ["\xB3\x4E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\xA9"],
        ["\xB3\x4F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\xAA"],
        ["\xB8\x62",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\xAB"],
        ["\xB3\x50",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\xAC"],
        ["\xB8\x63",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\xAD"],
        ["\xB3\x51",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\xAE"],
        ["\xB8\x64",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\xAF"],
        ["\xB8\x6A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\xB0"],
        ["\xB8\x6C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\xB1"],
        ["\xB8\x76",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\xB3"],
        ["\xB3\x52",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\xB4"],
        ["\xB8\x7D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\xB5"],
        ["\xB8\x7F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\xB6"],
        ["\xB8\x87",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\xB7"],
        ["\xB8\x88",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\xB8"],
        ["\xB3\x53",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\xB9"],
        ["\xB8\x90",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\xBA"],
        ["\xB8\x91",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\xBB"],
        ["\xB8\x93",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\xBC"],
        ["\xB8\x94",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\xBD"],
        ["\xB8\x97",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\xBE"],
        ["\xB8\x99",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\xBF"],
        ["\xB3\x55",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBF\x82"],
        ["\xB8\xA3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBF\x83"],
        ["\xB8\xA9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBF\x84"],
        ["\xB8\xAC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBF\x85"],
        ["\xB8\xAF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBF\x86"],
        ["\xB8\xB1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBF\x87"],
        ["\xB8\xB2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBF\x88"],
        ["\xB3\x59",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBF\x89"],
        ["\xB8\xB7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBF\x8A"],
        ["\xB8\xBA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBF\x8B"],
        ["\xB8\xC1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBF\x8C"],
        ["\xB8\xC2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBF\x8D"],
        ["\xB8\xC6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBF\x8E"],
        ["\xB3\x58",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBF\x91"],
        ["\xB8\xD3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBF\x94"],
        ["\xB8\xD6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBF\x95"],
        ["\xB8\xD7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBF\x96"],
        ["\xB8\xDC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBF\x97"],
        ["\xB8\xDD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBF\x98"],
        ["\xB8\xDF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBF\x99"],
        ["\xB3\x5C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBF\x9B"],
        ["\xB3\x5A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBF\x9C"],
        ["\xB8\xEA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBF\x9D"],
        ["\xB8\xEB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBF\x9E"],
        ["\xB3\x5B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBF\x9F"],
        ["\xB8\xEC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBF\xA0"],
        ["\xB8\xEE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBF\xA1"],
        ["\xB8\xF4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBF\xA2"],
        ["\xB3\x5D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBF\xA3"],
        ["\xB3\x5E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBF\xA4"],
        ["\xB8\xF8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBF\xA5"],
        ["\xB3\x5F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBF\xA6"],
        ["\xB8\xFC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBF\xA7"],
        ["\xB8\xFD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBF\xA8"],
        ["\xB3\x65",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBF\xA9"],
        ["\xB3\x64",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBF\xAA"],
        ["\xB9\x41",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBF\xAB"],
        ["\xB3\x60",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBF\xAC"],
        ["\xB9\x44",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBF\xAD"],
        ["\xB3\x61",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBF\xAE"],
        ["\xB3\x62",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBF\xAF"],
        ["\xB9\x4C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBF\xB0"],
        ["\xB3\x66",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBF\xB1"],
        ["\xBC\xEE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBF\xB2"],
        ["\xBC\xF1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBF\xB3"],
        ["\xB3\xDB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBF\xB4"],
        ["\xB3\xDD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBF\xB6"],
        ["\xB3\xDC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBF\xB7"],
        ["\xBC\xFC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBF\xB8"],
        ["\xB3\xDF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBF\xB9"],
        ["\xB3\xDE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBF\xBA"],
        ["\xBD\x44",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBF\xBB"],
        ["\xBD\x46",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBF\xBC"],
        ["\xB3\xE0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBF\xBD"],
        ["\xB3\xE1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBF\xBE"],
        ["\xBD\x4C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBF\xBF"],
        ["\xBD\x50",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x80\x80"],
        ["\xB3\xE4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x80\x81"],
        ["\xB3\xE6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x80\x82"],
        ["\xBD\x58",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x80\x83"],
        ["\xBD\x59",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x80\x84"],
        ["\xBD\x5A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x80\x85"],
        ["\xBD\x5B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x80\x86"],
        ["\xBD\x5D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x80\x87"],
        ["\xB3\xE9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x80\x88"],
        ["\xB3\xEA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x80\x89"],
        ["\xBD\x62",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x80\x8A"],
        ["\xB3\xEC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x80\x8B"],
        ["\xB3\xEB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x80\x8C"],
        ["\xBD\x65",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x80\x8D"],
        ["\xBD\x66",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x80\x8E"],
        ["\xB3\xF1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x80\x8F"],
        ["\xB3\xF2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x80\x90"],
        ["\xB3\xF0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x80\x91"],
        ["\xBD\x6B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x80\x92"],
        ["\xBD\x6C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x80\x93"],
        ["\xB3\xED",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x80\x95"],
        ["\xB3\xEF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x80\x96"],
        ["\xB3\xEE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x80\x97"],
        ["\xBD\x71",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x80\x98"],
        ["\xB3\xF4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x80\x99"],
        ["\xBD\x72",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x80\x9A"],
        ["\xB3\xF5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x80\x9B"],
        ["\xB3\xF9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x80\x9C"],
        ["\xBD\x7C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x80\x9D"],
        ["\xB3\xF6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x80\x9E"],
        ["\xBD\x82",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x80\x9F"],
        ["\xB3\xF7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x80\xA0"],
        ["\xB3\xF8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x80\xA1"],
        ["\xBD\x80",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x80\xA2"],
        ["\xBD\x81",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x80\xA3"],
        ["\xBD\x83",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x80\xA4"],
        ["\xBD\x85",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x80\xA5"],
        ["\xB3\xFD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x80\xA7"],
        ["\xBD\x91",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x80\xA8"],
        ["\xBD\x94",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x80\xA9"],
        ["\xB3\xFE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x80\xAA"],
        ["\xBD\x95",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x80\xAB"],
        ["\xB4\x44",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x80\xAC"],
        ["\xB4\x41",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x80\xAD"],
        ["\xBD\x9C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x80\xAE"],
        ["\xB4\x42",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x80\xAF"],
        ["\xBD\x9E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x80\xB0"],
        ["\xBD\xA0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x80\xB1"],
        ["\xB4\x43",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x80\xB2"],
        ["\xBD\xA2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x80\xB3"],
        ["\xBD\xA8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x80\xB4"],
        ["\xBD\xA9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x80\xB5"],
        ["\xBD\xAA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x80\xB6"],
        ["\xB4\x46",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x80\xB7"],
        ["\xB4\x47",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x80\xB9"],
        ["\xB4\x48",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x80\xBA"],
        ["\xBD\xAF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x80\xBB"],
        ["\xBD\xB1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x80\xBC"],
        ["\xB4\x49",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x80\xBD"],
        ["\xBD\xB2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x80\xBE"],
        ["\xBD\xB3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x80\xBF"],
        ["\xB4\x4B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x81\x80"],
        ["\xBD\xB6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x81\x81"],
        ["\xB4\x4C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x81\x82"],
        ["\xBD\xB9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x81\x83"],
        ["\xBD\xBB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x81\x84"],
        ["\xB4\x4D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x81\x85"],
        ["\xBD\xBD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x81\x86"],
        ["\xBD\xC0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x81\x87"],
        ["\xBD\xC3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x81\x88"],
        ["\xBD\xC4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x81\x89"],
        ["\xB4\x4E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x81\x8A"],
        ["\xBD\xC8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x81\x8B"],
        ["\xB4\x4F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x81\x8C"],
        ["\xBD\xCF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x81\x8D"],
        ["\xBD\xD0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x81\x8E"],
        ["\xBD\xD1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x81\x8F"],
        ["\xB9\x56",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x81\x90"],
        ["\xB3\x67",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x81\x91"],
        ["\xB9\x5C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x81\x92"],
        ["\xB9\x5E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x81\x93"],
        ["\xB3\x68",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x81\x94"],
        ["\xB3\x6A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x81\x95"],
        ["\xB3\x6B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x81\x96"],
        ["\xB3\xCC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x81\x97"],
        ["\xB9\x77",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x81\x98"],
        ["\xB9\x79",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x81\x99"],
        ["\xB3\x6D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x81\x9A"],
        ["\xB9\x7B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x81\x9B"],
        ["\xB9\x7D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x81\x9C"],
        ["\xB9\x7E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x81\x9D"],
        ["\xB3\x6F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x81\x9E"],
        ["\xB9\x81",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x81\x9F"],
        ["\xB3\x70",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x81\xA0"],
        ["\xB3\x73",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x81\xA1"],
        ["\xB9\x90",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x81\xA2"],
        ["\xB9\x91",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x81\xA3"],
        ["\xB9\x94",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x81\xA4"],
        ["\xB9\x96",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x81\xA5"],
        ["\xB9\x98",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x81\xA6"],
        ["\xB3\x76",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x81\xA7"],
        ["\xB9\xA2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x81\xA8"],
        ["\xB9\xA6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x81\xA9"],
        ["\xB3\x77",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x81\xAA"],
        ["\xB9\xAC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x81\xAB"],
        ["\xB3\x78",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x81\xAC"],
        ["\xB9\xB0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x81\xAD"],
        ["\xB3\x79",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x81\xAE"],
        ["\xB9\xB8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x81\xAF"],
        ["\xB3\x7A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x81\xB0"],
        ["\xB9\xBA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x81\xB1"],
        ["\xB9\xC1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x81\xB4"],
        ["\xB9\xC2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x81\xB5"],
        ["\xB3\x7C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x81\xB6"],
        ["\xB3\x7D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x81\xB7"],
        ["\xB9\xC9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x81\xB8"],
        ["\xB3\x80",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x81\xB9"],
        ["\xB9\xD7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x81\xBA"],
        ["\xB9\xD9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x81\xBB"],
        ["\xB9\xDA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x81\xBC"],
        ["\xB9\xEC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x81\xBE"],
        ["\xB9\xEF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x81\xBF"],
        ["\xB9\xF0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\x80"],
        ["\xB3\x82",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\x81"],
        ["\xB3\x84",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\x82"],
        ["\xB3\x85",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\x83"],
        ["\xB9\xF8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\x84"],
        ["\xB3\x86",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\x85"],
        ["\xBA\x46",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\x86"],
        ["\xBA\x4A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\x87"],
        ["\xB3\x88",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\x88"],
        ["\xBA\x4C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\x89"],
        ["\xBA\x50",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\x8A"],
        ["\xB3\x89",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\x8B"],
        ["\xB3\x8A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\x8C"],
        ["\xB3\x8B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\x8D"],
        ["\xBA\x55",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\x8E"],
        ["\xBA\x56",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\x8F"],
        ["\xB3\x8C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\x90"],
        ["\xB3\x8E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\x91"],
        ["\xBA\x5B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\x92"],
        ["\xB3\x93",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\x93"],
        ["\xB3\x91",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\x94"],
        ["\xBA\x61",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\x95"],
        ["\xB3\x92",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\x96"],
        ["\xBA\x67",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\x97"],
        ["\xBA\x6D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\x98"],
        ["\xBA\x6F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\x99"],
        ["\xB3\x94",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\x9A"],
        ["\xBA\x7C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\x9C"],
        ["\xBA\x7E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\x9D"],
        ["\xB3\x95",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\x9E"],
        ["\xBA\x82",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\x9F"],
        ["\xBA\x85",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\xA0"],
        ["\xBA\x86",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\xA1"],
        ["\xBA\x88",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\xA2"],
        ["\xBA\x8A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\xA3"],
        ["\xBA\x8C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\xA4"],
        ["\xB3\x96",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\xA5"],
        ["\xB3\x9B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\xA6"],
        ["\xBA\x93",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\xA7"],
        ["\xBA\x94",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\xA8"],
        ["\xB3\x97",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\xA9"],
        ["\xB3\x98",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\xAA"],
        ["\xBA\x98",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\xAB"],
        ["\xBA\x99",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\xAC"],
        ["\xBA\x9C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\xAD"],
        ["\xBA\xA7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\xAE"],
        ["\xBA\xA9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\xAF"],
        ["\xB3\x99",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\xB0"],
        ["\xBA\xAA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\xB1"],
        ["\xBA\xAC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\xB2"],
        ["\xB3\x9A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\xB3"],
        ["\xBA\xB4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\xB4"],
        ["\xBA\xB5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\xB5"],
        ["\xBA\xB6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\xB6"],
        ["\xB3\x9F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\xB7"],
        ["\xB3\x9C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\xB8"],
        ["\xBA\xBA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\xB9"],
        ["\xBA\xBB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\xBA"],
        ["\xBA\xBE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\xBB"],
        ["\xB3\x9D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\xBC"],
        ["\xBA\xD0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\xBD"],
        ["\xB3\xA4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\xBE"],
        ["\xB3\xA3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\xBF"],
        ["\xBA\xC7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\x80"],
        ["\xBA\xCB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\x81"],
        ["\xBA\xCD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\x82"],
        ["\xBA\xCF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\x83"],
        ["\xB3\xA0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\x84"],
        ["\xB3\xA1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\x85"],
        ["\xBA\xD6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\x86"],
        ["\xB3\xA2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\x87"],
        ["\xBA\xD7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\x88"],
        ["\xB3\xA7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\x89"],
        ["\xB3\xA8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\x8A"],
        ["\xB3\xA6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\x8B"],
        ["\xBA\xE0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\x8C"],
        ["\xBA\xE5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\x8D"],
        ["\xBA\xE8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\x8E"],
        ["\xB3\xA9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\x8F"],
        ["\xBA\xEC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\x90"],
        ["\xBA\xED",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\x91"],
        ["\xBA\xEE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\x92"],
        ["\xB3\xAA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\x93"],
        ["\xBA\xF8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\x94"],
        ["\xBA\xF9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\x95"],
        ["\xBB\x41",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\x96"],
        ["\xB3\xAE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\x97"],
        ["\xBB\x48",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\x98"],
        ["\xBB\x4A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\x99"],
        ["\xBB\x4B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\x9A"],
        ["\xBB\x4D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\x9B"],
        ["\xBB\x4E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\x9C"],
        ["\xBB\x53",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\x9D"],
        ["\xBB\x57",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\x9E"],
        ["\xB3\xAF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\x9F"],
        ["\xBB\x5C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\xA0"],
        ["\xBB\x61",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\xA1"],
        ["\xBB\x67",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\xA2"],
        ["\xBB\x6D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\xA3"],
        ["\xBB\x71",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\xA4"],
        ["\xBB\x72",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\xA5"],
        ["\xB3\xB0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\xA6"],
        ["\xBB\x79",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\xA7"],
        ["\xBB\x7F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\xA8"],
        ["\xB3\xB3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\xA9"],
        ["\xBB\x82",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\xAA"],
        ["\xB3\xB5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\xAB"],
        ["\xBB\x8C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\xAC"],
        ["\xBB\x8D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\xAD"],
        ["\xBB\x8E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\xAE"],
        ["\xBB\x8F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\xAF"],
        ["\xB3\xB4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\xB0"],
        ["\xBB\x93",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\xB1"],
        ["\xBB\x97",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\xB2"],
        ["\xBB\x9A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\xB3"],
        ["\xBB\x9B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\xB4"],
        ["\xBB\x9C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\xB5"],
        ["\xBB\xA0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\xB6"],
        ["\xB3\xB7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\xB7"],
        ["\xB3\xB6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\xB8"],
        ["\xBB\xAA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\xBA"],
        ["\xBB\xAC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\xBB"],
        ["\xBB\xAD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\xBC"],
        ["\xBB\xB1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\xBD"],
        ["\xB3\xB9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\xBE"],
        ["\xB3\xB8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\xBF"],
        ["\xBB\xB5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\x80"],
        ["\xB3\xBD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\x81"],
        ["\xB3\xBE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\x82"],
        ["\xBB\xB9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\x83"],
        ["\xBB\xBC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\x84"],
        ["\xBB\xC0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\x85"],
        ["\xB3\xBB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\x86"],
        ["\xBB\xC3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\x87"],
        ["\xB3\xBC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\x88"],
        ["\xBB\xC4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\x89"],
        ["\xBB\xC8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\x8A"],
        ["\xBB\xCE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\x8B"],
        ["\xBB\xD0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\x8C"],
        ["\xBB\xD2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\x8D"],
        ["\xBB\xD4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\x8E"],
        ["\xBB\xD5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\x8F"],
        ["\xB3\xC0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\x90"],
        ["\xBB\xD7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\x91"],
        ["\xBB\xD8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\x92"],
        ["\xBB\xE0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\x93"],
        ["\xBB\xEA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\x94"],
        ["\xB3\xC1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\x95"],
        ["\xBB\xEC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\x96"],
        ["\xBB\xED",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\x97"],
        ["\xBB\xEE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\x98"],
        ["\xBB\xEF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\x99"],
        ["\xBB\xF1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\x9A"],
        ["\xB3\xC3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\x9B"],
        ["\xBB\xF7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\x9C"],
        ["\xB3\xC5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\x9D"],
        ["\xB3\xC4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\x9E"],
        ["\xBB\xFC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\x9F"],
        ["\xBC\x47",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\xA0"],
        ["\xBC\x49",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\xA1"],
        ["\xB3\xC8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\xA2"],
        ["\xBC\x4A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\xA3"],
        ["\xBC\x4B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\xA4"],
        ["\xB3\xC9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\xA6"],
        ["\xBC\x4F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\xA7"],
        ["\xBC\x53",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\xA8"],
        ["\xB3\xCA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\xA9"],
        ["\xB3\xCB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\xAA"],
        ["\xB3\xCD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\xAB"],
        ["\xB3\xCF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\xAC"],
        ["\xBC\x5C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\xAD"],
        ["\xB3\xCE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\xAE"],
        ["\xB6\x9E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\xAF"],
        ["\xBC\x60",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\xB1"],
        ["\xB3\xD0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\xB2"],
        ["\xBC\x66",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\xB3"],
        ["\xBC\x67",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\xB4"],
        ["\xBC\x6A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\xB5"],
        ["\xBC\x71",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\xB6"],
        ["\xBC\x74",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\xB7"],
        ["\xBC\x79",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\xB8"],
        ["\xBC\x7D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\xB9"],
        ["\xBC\x7F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\xBA"],
        ["\xBC\x82",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\xBB"],
        ["\xBC\x84",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\xBC"],
        ["\xBC\x85",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\xBD"],
        ["\xBC\x86",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\xBE"],
        ["\xBC\x87",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\xBF"],
        ["\xB3\xD2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\x80"],
        ["\xB3\xD6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\x81"],
        ["\xB3\xD4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\x82"],
        ["\xBC\x8F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\x83"],
        ["\xBC\x90",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\x84"],
        ["\xB3\xD5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\x85"],
        ["\xBC\x97",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\x86"],
        ["\xBC\x9A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\x87"],
        ["\xBC\xA2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\x88"],
        ["\xBC\xA5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\x89"],
        ["\xBC\xA9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\x8A"],
        ["\xBC\xAC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\x8B"],
        ["\xBC\xB1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\x8C"],
        ["\xBC\xB3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\x8D"],
        ["\xBC\xB4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\x8E"],
        ["\xBC\xB5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\x8F"],
        ["\xBC\xB8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\x90"],
        ["\xBC\xBA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\x91"],
        ["\xBC\xBB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\x92"],
        ["\xBC\xBD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\x93"],
        ["\xBC\xBF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\x94"],
        ["\xBC\xC4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\x95"],
        ["\xBC\xC5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\x96"],
        ["\xBC\xC6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\x97"],
        ["\xBC\xC7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\x98"],
        ["\xB3\xD8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\x99"],
        ["\xBC\xC9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\x9A"],
        ["\xBC\xCA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\x9B"],
        ["\xBC\xCD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\x9C"],
        ["\xBC\xCF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\x9D"],
        ["\xBC\xD0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\x9E"],
        ["\xBC\xD7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\x9F"],
        ["\xBC\xD6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\xA0"],
        ["\xBC\xDB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\xA1"],
        ["\xBC\xDC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\xA2"],
        ["\xBC\xDE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\xA3"],
        ["\xBC\xE0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\xA4"],
        ["\xBC\xE1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\xA5"],
        ["\xBC\xE4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\xA6"],
        ["\xBC\xE5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\xA7"],
        ["\xBC\xE6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\xA8"],
        ["\xB3\xDA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\xA9"],
        ["\xBD\xD2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\xAA"],
        ["\xB4\x50",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\xAB"],
        ["\xBD\xD9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\xAC"],
        ["\xBD\xDB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\xAD"],
        ["\xBD\xDC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\xAE"],
        ["\xB4\x53",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\xAF"],
        ["\xBD\xE1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\xB0"],
        ["\xBD\xE2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\xB1"],
        ["\xBD\xE7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\xB2"],
        ["\xB4\x55",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\xB3"],
        ["\xB4\x56",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\xB4"],
        ["\xB4\x58",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\xB5"],
        ["\xBD\xF1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\xB6"],
        ["\xBD\xF2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\xB7"],
        ["\xBD\xF4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\xB8"],
        ["\xB4\x5A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\xB9"],
        ["\xB4\x5B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\xBA"],
        ["\xBE\x46",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\xBB"],
        ["\xBE\x4D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\xBC"],
        ["\xBE\x50",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\xBD"],
        ["\xBE\x56",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\xBE"],
        ["\xBE\x59",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\xBF"],
        ["\xBE\x5D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\x80"],
        ["\xBE\x5E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\x81"],
        ["\xBE\x65",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\x82"],
        ["\xBE\x66",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\x83"],
        ["\xB4\x5D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\x84"],
        ["\xBE\x67",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\x85"],
        ["\xBE\x6A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\x86"],
        ["\xBE\x6D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\x87"],
        ["\xBE\x6E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\x88"],
        ["\xBE\x6F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\x89"],
        ["\xBE\x71",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\x8A"],
        ["\xBE\x77",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\x8B"],
        ["\xBE\x78",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\x8C"],
        ["\xBE\x7A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\x8D"],
        ["\xBE\x7D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\x8E"],
        ["\xB4\x5F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\x8F"],
        ["\xBE\x83",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\x90"],
        ["\xB4\x5E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\x91"],
        ["\xBE\x87",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\x92"],
        ["\xB4\x60",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\x93"],
        ["\xBE\x8F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\x94"],
        ["\xBE\x98",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\x95"],
        ["\xBE\x9F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\x97"],
        ["\xBE\xA6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\x98"],
        ["\xB4\x62",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\x99"],
        ["\xBE\xA7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\x9A"],
        ["\xBE\xA8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\x9B"],
        ["\xBE\xAB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\x9C"],
        ["\xBE\xAE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\x9D"],
        ["\xBE\xB5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\x9E"],
        ["\xBE\xB6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\x9F"],
        ["\xB4\x63",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\xA0"],
        ["\xBE\xBA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\xA2"],
        ["\xBE\xC2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\xA3"],
        ["\xBE\xC3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\xA4"],
        ["\xBE\xC4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\xA5"],
        ["\xBE\xC8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\xA6"],
        ["\xBE\xCA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\xA7"],
        ["\xB4\x65",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\xA8"],
        ["\xB4\x64",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\xA9"],
        ["\xBE\xD2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\xAA"],
        ["\xBE\xD4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\xAB"],
        ["\xBE\xD7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\xAC"],
        ["\xBE\xDC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\xAD"],
        ["\xB4\x68",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\xAE"],
        ["\xBE\xE4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\xAF"],
        ["\xBE\xE5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\xB0"],
        ["\xBE\xE6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\xB1"],
        ["\xBE\xEB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\xB3"],
        ["\xBE\xEC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\xB4"],
        ["\xBE\xEE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\xB5"],
        ["\xB4\x69",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\xB6"],
        ["\xBE\xF7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\xB7"],
        ["\xBE\xF9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\xB8"],
        ["\xBE\xFB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\xB9"],
        ["\xB4\x6B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\xBA"],
        ["\xB4\x6C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\xBB"],
        ["\xBF\x4A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\xBC"],
        ["\xBF\x4E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\xBD"],
        ["\xBF\x50",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\xBE"],
        ["\xBF\x57",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\xBF"],
        ["\xBF\x58",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\x80"],
        ["\xBF\x5A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\x81"],
        ["\xBF\x5B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\x82"],
        ["\xB4\x6E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\x83"],
        ["\xBF\x60",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\x84"],
        ["\xB4\x6F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\x85"],
        ["\xBF\x61",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\x86"],
        ["\xBF\x63",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\x87"],
        ["\xB4\x71",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\x88"],
        ["\xBF\x73",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\x8A"],
        ["\xB4\x72",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\x8B"],
        ["\xBF\x7A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\x8C"],
        ["\xBF\x7B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\x8D"],
        ["\xBF\x7F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\x8E"],
        ["\xBF\x80",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\x8F"],
        ["\xB4\x77",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\x90"],
        ["\xB4\x78",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\x91"],
        ["\xB4\x73",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\x92"],
        ["\xBF\x87",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\x93"],
        ["\xB4\x74",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\x94"],
        ["\xBF\x8A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\x95"],
        ["\xBF\x8B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\x96"],
        ["\xBF\x8E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\x97"],
        ["\xBF\x92",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\x98"],
        ["\xB4\x75",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\x99"],
        ["\xB4\x76",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\x9A"],
        ["\xB4\x7C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\x9B"],
        ["\xB4\x79",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\x9C"],
        ["\xBF\x9A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\x9D"],
        ["\xBF\xA4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\x9E"],
        ["\xBF\xAA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\x9F"],
        ["\xB4\x7D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\xA0"],
        ["\xBF\xA8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\xA1"],
        ["\xBF\xB2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\xA2"],
        ["\xB4\x7E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\xA3"],
        ["\xBF\xB9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\xA4"],
        ["\xBF\xBA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\xA5"],
        ["\xBF\xBB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\xA6"],
        ["\xBF\xBC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\xA7"],
        ["\xB4\x7A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\xA8"],
        ["\xBF\xBF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\xA9"],
        ["\xBF\xC0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\xAA"],
        ["\xBF\xC4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\xAB"],
        ["\xBF\xCA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\xAC"],
        ["\xBF\xCE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\xAD"],
        ["\xBF\xCF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\xAE"],
        ["\xBF\xD1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\xAF"],
        ["\xBF\xDC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\xB0"],
        ["\xBF\xDD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\xB1"],
        ["\xBF\xDF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\xB2"],
        ["\xBF\xE4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\xB3"],
        ["\xBF\xE7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\xB4"],
        ["\xBF\xE9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\xB5"],
        ["\xBF\xEC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\xB6"],
        ["\xBF\xF0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\xB8"],
        ["\xBF\xFD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\xB9"],
        ["\xBF\xFE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\xBA"],
        ["\xC0\x43",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\xBB"],
        ["\xC0\x44",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\xBC"],
        ["\xB4\x80",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\xBD"],
        ["\xC0\x45",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\xBE"],
        ["\xC0\x46",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\xBF"],
        ["\xC0\x4E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\x80"],
        ["\xC0\x50",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\x81"],
        ["\xB4\x81",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\x82"],
        ["\xC0\x54",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\x83"],
        ["\xC0\x56",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\x84"],
        ["\xC0\x57",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\x85"],
        ["\xB4\x82",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\x86"],
        ["\xC0\x5A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\x87"],
        ["\xB4\x83",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\x88"],
        ["\xB4\x84",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\x89"],
        ["\xC0\x69",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\x8A"],
        ["\xC0\x6D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\x8B"],
        ["\xC0\x6E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\x8C"],
        ["\xC0\x70",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\x8D"],
        ["\xB4\x86",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\x8E"],
        ["\xC0\x71",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\x8F"],
        ["\xC0\x72",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\x90"],
        ["\xC0\x7B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\x91"],
        ["\xB4\x87",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\x92"],
        ["\xB4\x88",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\x93"],
        ["\xC0\x7E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\x94"],
        ["\xC0\x7F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\x95"],
        ["\xC0\x81",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\x96"],
        ["\xC0\x84",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\x97"],
        ["\xB4\x8A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\x98"],
        ["\xC0\x89",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\x99"],
        ["\xC0\x8C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\x9A"],
        ["\xB4\x8C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\x9B"],
        ["\xC0\x8F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\x9C"],
        ["\xC0\x90",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\x9D"],
        ["\xC0\x96",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\x9E"],
        ["\xC0\x9B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\x9F"],
        ["\xC0\xA3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\xA0"],
        ["\xC0\xA8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\xA1"],
        ["\xC0\xA7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\xA2"],
        ["\xB4\x8F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\xA3"],
        ["\xB4\x93",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\xA4"],
        ["\xC0\xAA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\xA6"],
        ["\xB4\x92",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\xA7"],
        ["\xB4\x96",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\xA8"],
        ["\xB4\x91",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\xA9"],
        ["\xC0\xAE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\xAA"],
        ["\xC0\xAF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\xAB"],
        ["\xC0\xB0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\xAC"],
        ["\xB4\x95",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\xAD"],
        ["\xC0\xB5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\xAE"],
        ["\xC0\xB9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\xAF"],
        ["\xC0\xBD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\xB0"],
        ["\xC0\xBE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\xB1"],
        ["\xB4\x98",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\xB3"],
        ["\xC0\xC4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\xB4"],
        ["\xC0\xC5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\xB5"],
        ["\xC0\xC6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\xB6"],
        ["\xB4\x99",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\xB7"],
        ["\xB4\x9A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\xB9"],
        ["\xC0\xD4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\xBA"],
        ["\xB4\x8B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\xBB"],
        ["\xB4\x9D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\xBC"],
        ["\xC0\xD6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\xBD"],
        ["\xB4\x9E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\xBE"],
        ["\xB4\x9F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\xBF"],
        ["\xC0\xD9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x89\x80"],
        ["\xB4\xA3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x89\x81"],
        ["\xB4\xA2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x89\x82"],
        ["\xC0\xE2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x89\x83"],
        ["\xB4\xA0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x89\x84"],
        ["\xC0\xE3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x89\x85"],
        ["\xC0\xE5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x89\x86"],
        ["\xB4\xA1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x89\x87"],
        ["\xB4\xA8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x89\x88"],
        ["\xB4\xA4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x89\x89"],
        ["\xC0\xE8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x89\x8A"],
        ["\xC0\xE9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x89\x8B"],
        ["\xB4\xA5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x89\x8C"],
        ["\xB4\xA6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x89\x8D"],
        ["\xB4\xA7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x89\x8E"],
        ["\xB6\x9C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x89\x8F"],
        ["\xB4\xAA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x89\x90"],
        ["\xC0\xF5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x89\x91"],
        ["\xC0\xF7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x89\x92"],
        ["\xC0\xFC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x89\x93"],
        ["\xC0\xFE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x89\x94"],
        ["\xC1\x42",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x89\x95"],
        ["\xC1\x44",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x89\x96"],
        ["\xB4\xA9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x89\x97"],
        ["\xC1\x48",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x89\x98"],
        ["\xC1\x4B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x89\x99"],
        ["\xB4\xAF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x89\x9A"],
        ["\xB4\xB1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x89\x9B"],
        ["\xB4\xB0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x89\x9C"],
        ["\xB4\xAC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x89\x9D"],
        ["\xC1\x50",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x89\x9E"],
        ["\xC1\x54",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x89\x9F"],
        ["\xB4\xB2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x89\xA0"],
        ["\xC1\x58",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x89\xA1"],
        ["\xC1\x59",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x89\xA2"],
        ["\xB4\xAD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x89\xA3"],
        ["\xC1\x5B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x89\xA5"],
        ["\xB4\xAE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x89\xA6"],
        ["\xC1\x5D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x89\xA7"],
        ["\xC1\x5E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x89\xA8"],
        ["\xC1\x5F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x89\xA9"],
        ["\xB4\xB9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x89\xAA"],
        ["\xC1\x62",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x89\xAB"],
        ["\xC1\x63",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x89\xAC"],
        ["\xC1\x6A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x89\xAD"],
        ["\xC1\x6C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x89\xAE"],
        ["\xC1\x6D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x89\xAF"],
        ["\xB4\xB4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x89\xB0"],
        ["\xC1\x71",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x89\xB1"],
        ["\xB4\xB5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x89\xB2"],
        ["\xC1\x72",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x89\xB3"],
        ["\xB4\xB6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x89\xB4"],
        ["\xC1\x73",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x89\xB5"],
        ["\xC1\x74",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x89\xB6"],
        ["\xC1\x79",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x89\xB7"],
        ["\xB4\xB7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x89\xB8"],
        ["\xB4\xB8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x89\xB9"],
        ["\xC1\x7C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x89\xBA"],
        ["\xC1\x90",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x89\xBB"],
        ["\xB4\xBF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x89\xBC"],
        ["\xB4\xC4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x89\xBD"],
        ["\xB4\xBA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x89\xBF"],
        ["\xC1\x7D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8A\x80"],
        ["\xC1\x7E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8A\x81"],
        ["\xC1\x82",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8A\x83"],
        ["\xC1\x83",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8A\x84"],
        ["\xB4\xBB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8A\x85"],
        ["\xC1\x86",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8A\x86"],
        ["\xC1\x8A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8A\x87"],
        ["\xB4\xBC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8A\x88"],
        ["\xB4\xBD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8A\x89"],
        ["\xB4\xBE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8A\x8A"],
        ["\xB4\xC1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8A\x8B"],
        ["\xB4\xC0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8A\x8C"],
        ["\xB4\xC5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8A\x8D"],
        ["\xC1\x9F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8A\x8E"],
        ["\xB4\xC2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8A\x8F"],
        ["\xB4\xC3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8A\x90"],
        ["\xC1\xAA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8A\x91"],
        ["\xC1\xAB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8A\x92"],
        ["\xC1\xAE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8A\x93"],
        ["\xC1\xAF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8A\x94"],
        ["\xC1\xB1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8A\x95"],
        ["\xC1\xB4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8A\x96"],
        ["\xB4\xC6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8A\x97"],
        ["\xC1\xB5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8A\x98"],
        ["\xC1\xB8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8A\x9A"],
        ["\xB4\xC7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8A\x9B"],
        ["\xC1\xBD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8A\x9C"],
        ["\xC1\xBF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8A\x9D"],
        ["\xC1\xC0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8A\x9E"],
        ["\xB4\xC8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8A\x9F"],
        ["\xC1\xC3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8A\xA0"],
        ["\xC1\xC4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8A\xA1"],
        ["\xB4\xD3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8A\xA2"],
        ["\xB4\xD5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8A\xA3"],
        ["\xB4\xD2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8A\xA5"],
        ["\xB4\xD4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8A\xA6"],
        ["\xB4\xCC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8A\xA7"],
        ["\xC1\xC7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8A\xA8"],
        ["\xC1\xC8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8A\xA9"],
        ["\xC1\xCA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8A\xAA"],
        ["\xB4\xD6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8A\xAB"],
        ["\xB4\xCF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8A\xAC"],
        ["\xC1\xCC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8A\xAD"],
        ["\xC1\xD1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8A\xAE"],
        ["\xC1\xD3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8A\xAF"],
        ["\xC1\xD4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8A\xB0"],
        ["\xB4\xDD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8A\xB1"],
        ["\xC1\xD8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8A\xB2"],
        ["\xB4\xD7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8A\xB3"],
        ["\xC1\xD9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8A\xB4"],
        ["\xC1\xDD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8A\xB5"],
        ["\xC1\xDF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8A\xB7"],
        ["\xB4\xD8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8A\xB8"],
        ["\xC1\xE1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8A\xB9"],
        ["\xC1\xE4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8A\xBA"],
        ["\xC1\xE8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8A\xBB"],
        ["\xB4\xDC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8A\xBC"],
        ["\xC1\xED",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8A\xBE"],
        ["\xC1\xF1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8A\xBF"],
        ["\xB4\xD9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\x80"],
        ["\xC1\xF2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\x81"],
        ["\xC1\xF6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\x82"],
        ["\xB4\xDB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\x83"],
        ["\xB4\xE0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\x84"],
        ["\xC1\xF8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\x85"],
        ["\xC1\xFD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\x86"],
        ["\xC2\x42",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\x87"],
        ["\xC2\x47",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\x88"],
        ["\xC2\x46",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\x89"],
        ["\xC2\x4A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\x8A"],
        ["\xC2\x4B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\x8B"],
        ["\xB4\xE5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\x8C"],
        ["\xB4\xE3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\x8D"],
        ["\xC2\x4D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\x8E"],
        ["\xC2\x4F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\x8F"],
        ["\xC2\x50",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\x90"],
        ["\xB4\xE1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\x91"],
        ["\xC2\x52",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\x92"],
        ["\xB4\xE7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\x93"],
        ["\xB4\xE6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\x94"],
        ["\xC2\x58",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\x95"],
        ["\xC2\x59",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\x96"],
        ["\xC2\x5A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\x97"],
        ["\xB4\xE8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\x98"],
        ["\xC2\x5B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\x99"],
        ["\xB4\xE9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\x9A"],
        ["\xC2\x62",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\x9B"],
        ["\xC2\x68",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\x9C"],
        ["\xC2\x6C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\x9D"],
        ["\xB4\xEB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\x9E"],
        ["\xC2\x73",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\x9F"],
        ["\xB4\xED",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\xA0"],
        ["\xB4\xEE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\xA1"],
        ["\xC2\x79",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\xA2"],
        ["\xC2\x82",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\xA3"],
        ["\xB4\xF0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\xA4"],
        ["\xC2\x86",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\xA5"],
        ["\xC2\x87",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\xA6"],
        ["\xB4\xF1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\xA7"],
        ["\xB4\xF2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\xA8"],
        ["\xC2\x8A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\xA9"],
        ["\xC2\x8C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\xAA"],
        ["\xC2\x8F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\xAB"],
        ["\xC2\x90",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\xAC"],
        ["\xC2\x91",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\xAD"],
        ["\xC2\x92",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\xAE"],
        ["\xC2\x96",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\xAF"],
        ["\xB4\xF5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\xB0"],
        ["\xC2\x9B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\xB1"],
        ["\xC2\xA6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\xB2"],
        ["\xC2\xA7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\xB3"],
        ["\xC2\xA8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\xB4"],
        ["\xB4\xF6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\xB5"],
        ["\xC2\xAC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\xB7"],
        ["\xC2\xB1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\xB8"],
        ["\xC2\xB4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\xB9"],
        ["\xB4\xF7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\xBA"],
        ["\xC2\xBC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\xBB"],
        ["\xB4\xF8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\xBC"],
        ["\xC2\xBD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\xBD"],
        ["\xC2\xBE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\xBE"],
        ["\xC2\xBF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\xBF"],
        ["\xB4\xFA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\x80"],
        ["\xC2\xC6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\x81"],
        ["\xC2\xCA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\x82"],
        ["\xB4\xFC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\x83"],
        ["\xC2\xCE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\x84"],
        ["\xC2\xCF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\x86"],
        ["\xC2\xD2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\x87"],
        ["\xC2\xD4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\x88"],
        ["\xB4\xFB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\x89"],
        ["\xB5\x44",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\x8A"],
        ["\xB4\xFE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\x8B"],
        ["\xC2\xD9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\x8C"],
        ["\xB5\x41",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\x8D"],
        ["\xC2\xDF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\x8E"],
        ["\xC2\xE0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\x8F"],
        ["\xC2\xB2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\x90"],
        ["\xC2\xE3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\x91"],
        ["\xC2\xE6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\x92"],
        ["\xB5\x47",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\x93"],
        ["\xC2\xE9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\x94"],
        ["\xB5\x48",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\x95"],
        ["\xC2\xEE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\x96"],
        ["\xB5\x4A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\x97"],
        ["\xB5\x4B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\x98"],
        ["\xB5\x4D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\x99"],
        ["\xB5\x4E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\x9A"],
        ["\xC2\xF1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\x9B"],
        ["\xC2\xF5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\x9C"],
        ["\xB5\x4F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\x9D"],
        ["\xB5\x56",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\x9E"],
        ["\xB5\x58",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\x9F"],
        ["\xB5\x57",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\xA0"],
        ["\xB5\x55",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\xA1"],
        ["\xB5\x50",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\xA2"],
        ["\xB5\x51",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\xA3"],
        ["\xC2\xF7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\xA4"],
        ["\xB5\x52",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\xA5"],
        ["\xB5\x42",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\xA6"],
        ["\xC2\xFD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\xA7"],
        ["\xC3\x41",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\xA8"],
        ["\xB5\x53",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\xAA"],
        ["\xC3\x45",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\xAB"],
        ["\xC3\x49",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\xAC"],
        ["\xC3\x4D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\xAD"],
        ["\xC3\x53",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\xAE"],
        ["\xC3\x50",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\xAF"],
        ["\xC3\x51",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\xB0"],
        ["\xB5\x5A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\xB2"],
        ["\xC3\x52",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\xB3"],
        ["\xC3\x57",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\xB5"],
        ["\xC3\x58",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\xB6"],
        ["\xC3\x59",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\xB7"],
        ["\xB5\x5C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\xB8"],
        ["\xC3\x5A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\xB9"],
        ["\xC3\x5B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\xBA"],
        ["\xC3\x5D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\xBB"],
        ["\xC3\x5E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\xBC"],
        ["\xC3\x5F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\xBD"],
        ["\xC3\x63",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\xBE"],
        ["\xB5\x5D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\xBF"],
        ["\xC3\x69",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\x80"],
        ["\xC3\x6C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\x81"],
        ["\xB5\x5F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\x82"],
        ["\xC3\x74",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\x84"],
        ["\xC3\x77",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\x85"],
        ["\xB5\x60",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\x86"],
        ["\xB5\x64",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\x87"],
        ["\xC3\x7B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\x88"],
        ["\xC3\x7E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\x89"],
        ["\xC3\x7F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\x8A"],
        ["\xC3\x83",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\x8B"],
        ["\xC3\x84",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\x8C"],
        ["\xC3\x87",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\x8D"],
        ["\xB5\x63",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\x8E"],
        ["\xC3\x91",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\x8F"],
        ["\xC3\x93",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\x90"],
        ["\xB5\x66",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\x91"],
        ["\xC3\x96",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\x92"],
        ["\xC3\x98",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\x93"],
        ["\xC3\x9A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\x94"],
        ["\xB5\x65",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\x95"],
        ["\xC3\x9F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\x96"],
        ["\xB5\x67",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\x97"],
        ["\xC3\xA1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\x98"],
        ["\xC3\xA8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\x99"],
        ["\xC3\xAC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\x9A"],
        ["\xB5\x69",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\x9B"],
        ["\xC3\xAE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\x9C"],
        ["\xC3\xB0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\x9D"],
        ["\xC3\xB5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\x9E"],
        ["\xB5\x68",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\x9F"],
        ["\xC3\xBB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\xA1"],
        ["\xB5\x6A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\xA2"],
        ["\xC3\xBD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\xA3"],
        ["\xC3\xBE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\xA4"],
        ["\xC3\xC0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\xA5"],
        ["\xB5\x6C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\xA6"],
        ["\xC3\xC3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\xA7"],
        ["\xC3\xC5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\xA8"],
        ["\xB5\x6B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\xAA"],
        ["\xC3\xCA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\xAB"],
        ["\xB5\x6E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\xAC"],
        ["\xC3\xCE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\xAD"],
        ["\xB5\x6D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\xAE"],
        ["\xC3\xCF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\xAF"],
        ["\xC3\xD0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\xB0"],
        ["\xB5\x6F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\xB1"],
        ["\xC3\xD5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\xB2"],
        ["\xB5\x70",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\xB3"],
        ["\xC3\xD7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\xB4"],
        ["\xC3\xDC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\xB5"],
        ["\xB5\x71",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\xB6"],
        ["\xC3\xDD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\xB7"],
        ["\xC3\xDE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\xB8"],
        ["\xC3\xE0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\xB9"],
        ["\xC3\xE1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\xBA"],
        ["\xC3\xE2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\xBB"],
        ["\xC3\xE3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\xBC"],
        ["\xC3\xE5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\xBD"],
        ["\xC3\xE7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\xBE"],
        ["\xB5\x73",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\x80"],
        ["\xB5\x72",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\x81"],
        ["\xC3\xEC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\x82"],
        ["\xB5\x74",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\x83"],
        ["\xB5\x75",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\x84"],
        ["\xC3\xEF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\x85"],
        ["\xC3\xF0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\x86"],
        ["\xC3\xF1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\x87"],
        ["\xC3\xF6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\x88"],
        ["\xC3\xF9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\x89"],
        ["\xC3\xFB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\x8B"],
        ["\xC3\xFC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\x8C"],
        ["\xB5\x76",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\x8D"],
        ["\xC3\xFE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\x8E"],
        ["\xB5\x77",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\x8F"],
        ["\xC4\x45",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\x90"],
        ["\xC4\x47",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\x91"],
        ["\xC4\x4D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\x92"],
        ["\xC4\x4B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\x93"],
        ["\xB5\x7A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\x94"],
        ["\xC4\x51",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\x95"],
        ["\xB5\x7B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\x96"],
        ["\xB5\x7D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\x97"],
        ["\xC4\x55",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\x98"],
        ["\xC4\x5B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\x99"],
        ["\xC4\x5C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\x9A"],
        ["\xC4\x5D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\x9B"],
        ["\xB5\x7E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\x9C"],
        ["\xC4\x5E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\x9D"],
        ["\xC4\x61",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\x9E"],
        ["\xB5\x7F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\x9F"],
        ["\xC4\x66",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\xA0"],
        ["\xC4\x68",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\xA1"],
        ["\xC4\x6A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\xA2"],
        ["\xC4\x6C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\xA3"],
        ["\xC4\x6F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\xA4"],
        ["\xB5\x80",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\xA5"],
        ["\xB5\x82",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\xA6"],
        ["\xC4\x78",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\xA7"],
        ["\xC4\x7A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\xA8"],
        ["\xC4\x7B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\xA9"],
        ["\xC4\x7C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\xAA"],
        ["\xB3\x45",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\xAB"],
        ["\xC4\x7E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\xAC"],
        ["\xC4\x84",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\xAD"],
        ["\xB5\x83",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\xAE"],
        ["\xC4\x8B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\xAF"],
        ["\xB5\x84",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\xB0"],
        ["\xC4\x8E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\xB1"],
        ["\xC4\x8F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\xB2"],
        ["\xC4\x92",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\xB3"],
        ["\xC4\x95",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\xB4"],
        ["\xC4\x99",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\xB5"],
        ["\xB5\x86",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\xB6"],
        ["\xC4\x9D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\xB7"],
        ["\xC4\x9E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\xB8"],
        ["\xB5\x87",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\xB9"],
        ["\xC4\xA0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\xBB"],
        ["\xB5\x89",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\xBC"],
        ["\xC4\xA3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\xBD"],
        ["\xB5\x8A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\xBE"],
        ["\xB5\x8B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\xBF"],
        ["\xC4\xA9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\x80"],
        ["\xC4\xAB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\x81"],
        ["\xC4\xB1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\x82"],
        ["\xC4\xB4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\x83"],
        ["\xC4\xB6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\x84"],
        ["\xC4\xB7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\x85"],
        ["\xB5\x8C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\x86"],
        ["\xB5\x8F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\x87"],
        ["\xC4\xBC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\x88"],
        ["\xC4\xBD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\x89"],
        ["\xB5\x8D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\x8A"],
        ["\xC4\xC2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\x8B"],
        ["\xC4\xC6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\x8C"],
        ["\xB5\x90",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\x8D"],
        ["\xC4\xD0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\x8E"],
        ["\xC4\xD1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\x8F"],
        ["\xB5\x91",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\x90"],
        ["\xC4\xD2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\x91"],
        ["\xC4\xD3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\x92"],
        ["\xC4\xD4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\x93"],
        ["\xC4\xD8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\x95"],
        ["\xC4\xDA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\x96"],
        ["\xB5\x92",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\x97"],
        ["\xB5\x93",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\x98"],
        ["\xC4\xE1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\x99"],
        ["\xC4\xE2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\x9A"],
        ["\xC4\xE3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\x9B"],
        ["\xC4\xE7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\x9C"],
        ["\xB5\x94",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\x9D"],
        ["\xC4\xEC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\x9E"],
        ["\xC4\xED",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\x9F"],
        ["\xC4\xEE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\xA0"],
        ["\xC4\xEF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\xA1"],
        ["\xC4\xF0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\xA2"],
        ["\xC4\xF1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\xA3"],
        ["\xC4\xF3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\xA4"],
        ["\xC4\xF9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\xA5"],
        ["\xC4\xFB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\xA6"],
        ["\xC5\x41",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\xA7"],
        ["\xB5\x95",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\xA8"],
        ["\xC5\x42",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\xA9"],
        ["\xC5\x47",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\xAA"],
        ["\xC5\x4D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\xAB"],
        ["\xC5\x54",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\xAC"],
        ["\xC5\x55",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\xAD"],
        ["\xB5\x97",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\xAE"],
        ["\xC5\x56",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\xAF"],
        ["\xC5\x57",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\xB0"],
        ["\xC5\x5C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\xB1"],
        ["\xC5\x5E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\xB2"],
        ["\xC5\x60",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\xB3"],
        ["\xC5\x67",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\xB4"],
        ["\xC5\x6A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\xB5"],
        ["\xC5\x6B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\xB6"],
        ["\xB5\x98",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\xB7"],
        ["\xB5\x9A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\xB8"],
        ["\xC5\x71",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\xB9"],
        ["\xB5\x99",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\xBA"],
        ["\xC5\x73",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\xBB"],
        ["\xC5\x76",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\xBC"],
        ["\xC5\x77",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\xBD"],
        ["\xB5\x9B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\xBE"],
        ["\xC5\x7C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\xBF"],
        ["\xC5\x7D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\x80"],
        ["\xC5\x83",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\x81"],
        ["\xC5\x84",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\x82"],
        ["\xB5\x9C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\x83"],
        ["\xB5\x9D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\x84"],
        ["\xC5\x8B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\x85"],
        ["\xC5\x8E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\x86"],
        ["\xC5\x94",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\x87"],
        ["\xC5\x93",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\x88"],
        ["\xB5\x9E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\x89"],
        ["\xC5\x96",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\x8A"],
        ["\xB5\x9F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\x8B"],
        ["\xC5\x9E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\x8C"],
        ["\xC5\xA0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\x8D"],
        ["\xC5\xA3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\x8E"],
        ["\xB5\xA1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\x8F"],
        ["\xB5\xA0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\x90"],
        ["\xC5\xA6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\x91"],
        ["\xC5\xA7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\x92"],
        ["\xC5\xA9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\x93"],
        ["\xC5\xAC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\x94"],
        ["\xC5\xAD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\x95"],
        ["\xC5\xAE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\x96"],
        ["\xC5\xAF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\x97"],
        ["\xB5\xA2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\x98"],
        ["\xB5\xA3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\x99"],
        ["\xC5\xB4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\x9A"],
        ["\xC5\xB6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\x9B"],
        ["\xC5\xB9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\x9C"],
        ["\xC5\xBA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\x9D"],
        ["\xC5\xBB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\x9E"],
        ["\xB5\xA4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\x9F"],
        ["\xB5\xA5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\xA0"],
        ["\xB5\xA7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\xA1"],
        ["\xC5\xC3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\xA2"],
        ["\xB5\xA8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\xA3"],
        ["\xB5\xA9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\xA4"],
        ["\xB5\xAA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\xA5"],
        ["\xC5\xC7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\xA6"],
        ["\xC5\xC8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\xA7"],
        ["\xC5\xCB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\xA8"],
        ["\xC5\xCE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\xA9"],
        ["\xB5\xAB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\xAA"],
        ["\xB5\xAC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\xAB"],
        ["\xC5\xD1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\xAC"],
        ["\xC5\xD2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\xAD"],
        ["\xC5\xD5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\xAE"],
        ["\xC5\xD6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\xAF"],
        ["\xC5\xD7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\xB0"],
        ["\xC5\xD9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\xB1"],
        ["\xC5\xDA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\xB2"],
        ["\xC5\xDD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\xB3"],
        ["\xB5\xAF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\xB4"],
        ["\xC5\xDF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\xB5"],
        ["\xC5\xE3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\xB6"],
        ["\xB5\xAD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\xB7"],
        ["\xB5\xAE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\xB8"],
        ["\xC5\xE5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\xB9"],
        ["\xC5\xE9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\xBA"],
        ["\xC5\xEA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\xBB"],
        ["\xB5\xB0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\xBC"],
        ["\xC5\xEE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\xBD"],
        ["\xB5\xB1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\xBE"],
        ["\xC5\xF8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\xBF"],
        ["\xC5\xF3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x91\x80"],
        ["\xB5\xB2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x91\x81"],
        ["\xB5\xB3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x91\x82"],
        ["\xC5\xFA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x91\x83"],
        ["\xB5\xB4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x91\x84"],
        ["\xC5\xFE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x91\x85"],
        ["\xC6\x43",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x91\x86"],
        ["\xB5\xB5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x91\x87"],
        ["\xC6\x49",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x91\x88"],
        ["\xC6\x51",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x91\x89"],
        ["\xB5\xB6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x91\x8B"],
        ["\xC6\x54",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x91\x8C"],
        ["\xC6\x59",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x91\x8D"],
        ["\xC6\x5A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x91\x8E"],
        ["\xB5\xB7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x91\x8F"],
        ["\xB5\xB9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x91\x90"],
        ["\xC6\x60",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x91\x91"],
        ["\xB5\xBA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x91\x92"],
        ["\xC6\x68",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x91\x93"],
        ["\xC6\x69",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x91\x94"],
        ["\xB5\xBB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x91\x95"],
        ["\xC6\x76",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x91\x96"],
        ["\xC6\x78",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x91\x97"],
        ["\xC6\x7C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x91\x98"],
        ["\xC6\x80",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x91\x99"],
        ["\xB5\xBD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x91\x9A"],
        ["\xB5\xBC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x91\x9B"],
        ["\xB5\xC0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x91\x9C"],
        ["\xB5\xBE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x91\x9D"],
        ["\xB5\xBF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x91\x9E"],
        ["\xC6\x91",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x91\x9F"],
        ["\xC6\x95",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x91\xA0"],
        ["\xB5\xC2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x91\xA1"],
        ["\xC6\x98",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x91\xA2"],
        ["\xB5\xC1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x91\xA3"],
        ["\xC6\x9C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x91\xA4"],
        ["\xB5\xC4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x91\xA5"],
        ["\xB5\xC3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x91\xA6"],
        ["\xC6\xA4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x91\xA7"],
        ["\xC6\xA5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x91\xA8"],
        ["\xC6\xA6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x91\xA9"],
        ["\xB5\xC5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x91\xAA"],
        ["\xB5\xC6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x91\xAB"],
        ["\xC6\xB4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x91\xAC"],
        ["\xC6\xB5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x91\xAD"],
        ["\xC6\xB7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x91\xAE"],
        ["\xC6\xB8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x91\xAF"],
        ["\xC6\xB9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x91\xB0"],
        ["\xC6\xBA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x91\xB1"],
        ["\xB5\xC7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x91\xB2"],
        ["\xC6\xBB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x91\xB3"],
        ["\xC6\xBD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x91\xB4"],
        ["\xC6\xBF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x91\xB5"],
        ["\xB5\xC8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x91\xB6"],
        ["\xC6\xC0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x91\xB7"],
        ["\xC6\xC1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x91\xB8"],
        ["\xC6\xC2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x91\xB9"],
        ["\xC6\xC3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x91\xBA"],
        ["\xB5\xCA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x91\xBB"],
        ["\xB5\xC9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x91\xBD"],
        ["\xC6\xD0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x91\xBE"],
        ["\xC6\xDA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\x80"],
        ["\xB5\xCF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\x81"],
        ["\xC6\xDD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\x82"],
        ["\xC6\xDF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\x83"],
        ["\xC6\xE5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\x84"],
        ["\xC6\xE1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\x85"],
        ["\xC6\xE2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\x86"],
        ["\xC6\xE3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\x87"],
        ["\xC6\xED",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\x88"],
        ["\xC6\xF1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\x89"],
        ["\xC6\xF3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\x8A"],
        ["\xC6\xF4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\x8B"],
        ["\xC6\xF7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\x8C"],
        ["\xC6\xFB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\x8D"],
        ["\xC6\xFC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\x8E"],
        ["\xC6\xFE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\x8F"],
        ["\xB5\xD1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\x90"],
        ["\xC7\x46",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\x91"],
        ["\xC7\x47",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\x92"],
        ["\xB5\xD2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\x93"],
        ["\xB5\xD3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\x94"],
        ["\xC7\x4C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\x95"],
        ["\xB5\xD4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\x96"],
        ["\xC7\x52",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\x98"],
        ["\xC7\x59",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\x99"],
        ["\xC7\x5F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\x9A"],
        ["\xC7\x64",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\x9B"],
        ["\xC7\x65",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\x9C"],
        ["\xB5\xDC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\x9D"],
        ["\xC7\x67",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\x9E"],
        ["\xC7\x6A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\x9F"],
        ["\xC7\x73",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\xA1"],
        ["\xC7\x74",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\xA2"],
        ["\xC7\x77",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\xA4"],
        ["\xC7\x79",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\xA5"],
        ["\xC7\x7D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\xA6"],
        ["\xC7\x7F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\xA7"],
        ["\xC7\x80",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\xA8"],
        ["\xC7\x82",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\xA9"],
        ["\xB5\xDF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\xAA"],
        ["\xB5\xE0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\xAB"],
        ["\xC7\x87",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\xAC"],
        ["\xB5\xE2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\xAD"],
        ["\xB5\xE3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\xAE"],
        ["\xB5\xE4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\xAF"],
        ["\xB5\xE5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\xB0"],
        ["\xC7\x98",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\xB1"],
        ["\xC7\x9A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\xB2"],
        ["\xC7\x9B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\xB3"],
        ["\xC7\x9C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\xB4"],
        ["\xC7\x9D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\xB5"],
        ["\xB5\xE6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\xB6"],
        ["\xC7\xA1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\xB7"],
        ["\xC7\xA6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\xB8"],
        ["\xC7\xAB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\xB9"],
        ["\xC7\xAD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\xBA"],
        ["\xC7\xAF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\xBB"],
        ["\xC7\xB0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\xBC"],
        ["\xC7\xB1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\xBD"],
        ["\xC7\xB3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\xBE"],
        ["\xC7\xB4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\xBF"],
        ["\xC7\xB6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\x80"],
        ["\xC7\xB7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\x81"],
        ["\xC7\xB9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\x82"],
        ["\xC7\xBA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\x83"],
        ["\xC7\xBD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\x84"],
        ["\xC7\xC0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\x85"],
        ["\xC7\xC2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\x86"],
        ["\xC7\xC7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\x87"],
        ["\xC7\xC8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\x88"],
        ["\xB5\xEA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\x89"],
        ["\xB5\xEB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\x8A"],
        ["\xC7\xCB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\x8B"],
        ["\xC7\xCD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\x8C"],
        ["\xB5\xEC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\x8D"],
        ["\xB5\xED",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\x8E"],
        ["\xC7\xD0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\x8F"],
        ["\xC7\xD3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\x92"],
        ["\xC7\xD7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\x93"],
        ["\xB5\xEF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\x94"],
        ["\xB5\xEE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\x95"],
        ["\xC7\xDB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\x96"],
        ["\xB5\xF0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\x97"],
        ["\xC7\xE9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\x98"],
        ["\xC7\xDF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\x99"],
        ["\xC7\xE1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\x9A"],
        ["\xC7\xE4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\x9B"],
        ["\xC7\xE5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\x9C"],
        ["\xC7\xE7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\x9D"],
        ["\xB5\xF2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\x9E"],
        ["\xB5\xF5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\x9F"],
        ["\xB5\xF7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\xA0"],
        ["\xC7\xEC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\xA1"],
        ["\xB5\xF4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\xA2"],
        ["\xC7\xEF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\xA3"],
        ["\xB5\xF6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\xA4"],
        ["\xC7\xF1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\xA5"],
        ["\xC7\xF2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\xA6"],
        ["\xC7\xF3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\xA7"],
        ["\xC7\xF8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\xA8"],
        ["\xB5\xF9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\xA9"],
        ["\xB5\xF8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\xAA"],
        ["\xC7\xFD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\xAB"],
        ["\xC7\xFE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\xAC"],
        ["\xC8\x42",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\xAD"],
        ["\xB5\xFA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\xAE"],
        ["\xC8\x46",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\xAF"],
        ["\xC8\x49",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\xB0"],
        ["\xC8\x4D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\xB1"],
        ["\xC8\x50",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\xB2"],
        ["\xC8\x52",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\xB3"],
        ["\xB5\xFC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\xB4"],
        ["\xB5\xFD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\xB5"],
        ["\xC8\x53",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\xB6"],
        ["\xC8\x54",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\xB7"],
        ["\xC8\x57",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\xB8"],
        ["\xC8\x5A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\xB9"],
        ["\xB5\xFE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\xBA"],
        ["\xC8\x65",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\xBB"],
        ["\xC8\x69",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\xBC"],
        ["\xC8\x6B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\xBD"],
        ["\xC8\x6C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\xBE"],
        ["\xC8\x71",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\xBF"],
        ["\xB6\x43",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\x80"],
        ["\xC8\x7B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\x81"],
        ["\xC8\x7C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\x82"],
        ["\xB6\x45",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\x83"],
        ["\xC8\x85",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\x84"],
        ["\xC8\x86",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\x85"],
        ["\xC8\x89",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\x86"],
        ["\xC8\x8B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\x87"],
        ["\xB6\x46",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\x88"],
        ["\xC8\x8C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\x89"],
        ["\xB6\x47",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\x8A"],
        ["\xB6\x48",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\x8B"],
        ["\xB6\x4A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\x8C"],
        ["\xC8\x97",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\x8D"],
        ["\xB6\x49",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\x8E"],
        ["\xC8\x99",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\x8F"],
        ["\xC8\x9A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\x90"],
        ["\xC8\x9E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\x91"],
        ["\xB6\x4C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\x92"],
        ["\xC8\x9F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\x93"],
        ["\xB6\x4B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\x94"],
        ["\xC8\xA1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\x95"],
        ["\xC8\xA3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\x96"],
        ["\xB6\x4D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\x97"],
        ["\xC8\xA8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\x98"],
        ["\xB6\x4E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\x99"],
        ["\xC8\xAC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\x9A"],
        ["\xC8\xAE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\x9B"],
        ["\xB6\x4F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\x9C"],
        ["\xC8\xAF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\x9D"],
        ["\xC8\xB0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\x9E"],
        ["\xC8\xB3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\x9F"],
        ["\xB6\x50",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\xA0"],
        ["\xC8\xB6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\xA1"],
        ["\xC8\xBA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\xA2"],
        ["\xB6\x52",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\xA3"],
        ["\xB6\x51",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\xA4"],
        ["\xC8\xC1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\xA5"],
        ["\xC8\xC2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\xA6"],
        ["\xC8\xC3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\xA7"],
        ["\xC8\xC5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\xA8"],
        ["\xB6\x56",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\xA9"],
        ["\xB6\x54",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\xAA"],
        ["\xB6\x53",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\xAB"],
        ["\xC8\xCA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\xAC"],
        ["\xC8\xCB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\xAD"],
        ["\xC8\xCF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\xAE"],
        ["\xC8\xD0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\xAF"],
        ["\xB6\x55",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\xB0"],
        ["\xC8\xD4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\xB1"],
        ["\xB6\x57",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\xB2"],
        ["\xC8\xD9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\xB3"],
        ["\xC8\xDA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\xB4"],
        ["\xC8\xDC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\xB5"],
        ["\xC8\xE0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\xB6"],
        ["\xB6\x59",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\xB7"],
        ["\xC8\xE1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\xB8"],
        ["\xC8\xE4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\xB9"],
        ["\xC8\xE5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\xBA"],
        ["\xC8\xE7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\xBB"],
        ["\xB6\x58",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\xBD"],
        ["\xC8\xF1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\xBE"],
        ["\xC8\xF2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\xBF"],
        ["\xC8\xF5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\x80"],
        ["\xC8\xF9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\x81"],
        ["\xC8\xFC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\x82"],
        ["\xB6\x5C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\x83"],
        ["\xB6\x5E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\x84"],
        ["\xB6\x5D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\x85"],
        ["\xC9\x42",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\x86"],
        ["\xC9\x45",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\x87"],
        ["\xC9\x47",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\x88"],
        ["\xC9\x48",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\x89"],
        ["\xC9\x49",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\x8A"],
        ["\xC9\x4B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\x8B"],
        ["\xC9\x52",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\x8C"],
        ["\xC9\x5E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\x8D"],
        ["\xB6\x60",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\x8E"],
        ["\xC9\x60",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\x8F"],
        ["\xC9\x62",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\x90"],
        ["\xC9\x63",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\x91"],
        ["\xB6\x61",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\x92"],
        ["\xC9\x65",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\x93"],
        ["\xC9\x67",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\x94"],
        ["\xC9\x68",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\x95"],
        ["\xB6\x62",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\x96"],
        ["\xC9\x6C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\x97"],
        ["\xC9\x6B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\x98"],
        ["\xC9\x6E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\x99"],
        ["\xC9\x70",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\x9A"],
        ["\xC9\x71",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\x9B"],
        ["\xC9\x72",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\x9C"],
        ["\xB3\x6E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\x9D"],
        ["\xB6\x63",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\x9E"],
        ["\xC9\x73",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\x9F"],
        ["\xB6\x64",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\xA0"],
        ["\xC9\x78",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\xA1"],
        ["\xC9\x79",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\xA2"],
        ["\xC9\x7A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\xA3"],
        ["\xC9\x7D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\xA4"],
        ["\xC9\x7F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\xA5"],
        ["\xC9\x80",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\xA6"],
        ["\xB6\x66",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\xA7"],
        ["\xC9\x86",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\xA8"],
        ["\xB6\x67",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\xA9"],
        ["\xB5\x45",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\xAA"],
        ["\xC9\x88",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\xAB"],
        ["\xC9\x8A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\xAC"],
        ["\xC9\x8E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\xAD"],
        ["\xB6\x68",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\xAE"],
        ["\xC9\x93",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\xAF"],
        ["\xC9\x96",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\xB0"],
        ["\xC9\x99",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\xB1"],
        ["\xC9\x9A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\xB2"],
        ["\xC9\x9E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\xB3"],
        ["\xC9\x9F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\xB4"],
        ["\xB6\x69",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\xB5"],
        ["\xC9\xA6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\xB6"],
        ["\xC9\xA5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\xB7"],
        ["\xC9\xA8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\xB8"],
        ["\xC9\xAA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\xB9"],
        ["\xC9\xAD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\xBA"],
        ["\xC9\xB2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\xBB"],
        ["\xC9\xB4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\xBC"],
        ["\xC9\xB6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\xBD"],
        ["\xB6\x6B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\xBE"],
        ["\xC9\xC2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\xBF"],
        ["\xC9\xC4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x96\x80"],
        ["\xC9\xC5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x96\x81"],
        ["\xB6\x6C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x96\x82"],
        ["\xB6\x6D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x96\x83"],
        ["\xC9\xC9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x96\x84"],
        ["\xB6\x6E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x96\x85"],
        ["\xC9\xCC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x96\x86"],
        ["\xC9\xCE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x96\x87"],
        ["\xB6\x72",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x96\x88"],
        ["\xB6\x6F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x96\x89"],
        ["\xC9\xD5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x96\x8A"],
        ["\xC9\xD7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x96\x8B"],
        ["\xB6\x71",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x96\x8C"],
        ["\xB6\x75",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x96\x8D"],
        ["\xB6\x77",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x96\x8E"],
        ["\xB6\x73",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x96\x8F"],
        ["\xB6\x74",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x96\x90"],
        ["\xB6\x76",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x96\x91"],
        ["\xC9\xEE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x96\x92"],
        ["\xC9\xE4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x96\x93"],
        ["\xC9\xE8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x96\x94"],
        ["\xB6\x78",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x96\x95"],
        ["\xC9\xEA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x96\x96"],
        ["\xC9\xEB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x96\x97"],
        ["\xC9\xEC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x96\x98"],
        ["\xB6\x7B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x96\x99"],
        ["\xB6\x79",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x96\x9A"],
        ["\xB6\x7A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x96\x9B"],
        ["\xC9\xFB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x96\x9C"],
        ["\xB6\x7C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x96\x9D"],
        ["\xCA\x41",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x96\x9E"],
        ["\xB6\x7D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x96\x9F"],
        ["\xCA\x42",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x96\xA0"],
        ["\xCA\x43",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x96\xA1"],
        ["\xB6\x7E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x96\xA2"],
        ["\xCA\x49",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x96\xA3"],
        ["\xCA\x4E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x96\xA4"],
        ["\xB6\x7F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x96\xA5"],
        ["\xCA\x51",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x96\xA6"],
        ["\xB6\x80",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x96\xA7"],
        ["\xCA\x59",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x96\xA8"],
        ["\xB6\x81",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x96\xA9"],
        ["\xCA\x5D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x96\xAA"],
        ["\xB6\x82",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x96\xAB"],
        ["\xCA\x5F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x96\xAC"],
        ["\xB6\x85",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x96\xAD"],
        ["\xCA\x67",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x96\xAE"],
        ["\xCA\x68",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x96\xAF"],
        ["\xB6\x86",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x96\xB0"],
        ["\xB6\x87",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x96\xB1"],
        ["\xB6\x89",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x96\xB2"],
        ["\xCA\x6E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x96\xB3"],
        ["\xCA\x71",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x96\xB4"],
        ["\xCA\x72",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x96\xB5"],
        ["\xB6\x8A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x96\xB6"],
        ["\xCA\x74",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x96\xB7"],
        ["\xCA\x75",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x96\xB8"],
        ["\xB6\x8B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x96\xB9"],
        ["\xCA\x7A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x96\xBA"],
        ["\xB6\x8C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x96\xBB"],
        ["\xCA\x79",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x96\xBC"],
        ["\xB6\x8E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x96\xBD"],
        ["\xCA\x7B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x96\xBE"],
        ["\xB6\x8D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x96\xBF"],
        ["\xCA\x7D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x97\x80"],
        ["\xB6\x8F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x97\x81"],
        ["\xB6\x90",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x97\x82"],
        ["\xB6\x91",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x97\x83"],
        ["\xCA\x80",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x97\x84"],
        ["\xCA\x82",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x97\x85"],
        ["\xB6\x92",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x97\x86"],
        ["\xB6\x94",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x97\x87"],
        ["\xB6\x95",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x97\x88"],
        ["\xB6\x96",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x97\x89"],
        ["\xB6\x93",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x97\x8A"],
        ["\xCA\x87",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x97\x8B"],
        ["\xCA\x88",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x97\x8C"],
        ["\xCA\x8B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x97\x8D"],
        ["\xCA\x8F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x97\x8E"],
        ["\xB6\x98",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x97\x8F"],
        ["\xCA\x9B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x97\x90"],
        ["\xCA\x9C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x97\x91"],
        ["\xCA\xA1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x97\x92"],
        ["\xCA\xA2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x97\x93"],
        ["\xCA\xA4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x97\x94"],
        ["\xCA\xA5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x97\x95"],
        ["\xCA\xAD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x97\x96"],
        ["\xCA\xAF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x97\x97"],
        ["\xCA\xB4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x97\x98"],
        ["\xCA\xB8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x97\x99"],
        ["\xCA\xB9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x97\x9A"],
        ["\xB6\x99",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x97\x9B"],
        ["\xCA\xD3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x97\x9C"],
        ["\xCA\xBC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x97\x9D"],
        ["\xCA\xBD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x97\x9E"],
        ["\xCA\xC5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x97\x9F"],
        ["\xCA\xC9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x97\xA0"],
        ["\xCA\xCD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x97\xA1"],
        ["\xCA\xD6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x97\xA2"],
        ["\xB6\x9B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x97\xA3"],
        ["\xB6\x9D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x97\xA5"],
        ["\xB6\x9A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x97\xA6"],
        ["\xCA\xDE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x97\xA7"],
        ["\xCA\xE0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x97\xA8"],
        ["\xCA\xE1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x97\xA9"],
        ["\xCA\xE4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x97\xAA"],
        ["\xCA\xE6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x97\xAB"],
        ["\xCA\xEF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x97\xAC"],
        ["\xCA\xF1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x97\xAD"],
        ["\xCA\xF3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x97\xAE"],
        ["\xCA\xF4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x97\xAF"],
        ["\xB6\xA0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x97\xB0"],
        ["\xCA\xF8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x97\xB1"],
        ["\xCA\xFD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x97\xB2"],
        ["\xCA\xFE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x97\xB3"],
        ["\xCB\x41",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x97\xB4"],
        ["\xB6\xA1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x97\xB5"],
        ["\xB6\xA2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x97\xB6"],
        ["\xCB\x44",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x97\xB7"],
        ["\xCB\x47",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x97\xB8"],
        ["\xCB\x49",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x97\xB9"],
        ["\xCB\x4A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x97\xBA"],
        ["\xCB\x4B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x97\xBB"],
        ["\xCB\x4E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x97\xBC"],
        ["\xCB\x4F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x97\xBD"],
        ["\xCB\x50",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x97\xBE"],
        ["\xB6\xA4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x97\xBF"],
        ["\xCB\x53",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x98\x80"],
        ["\xCB\x59",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x98\x81"],
        ["\xCB\x5A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x98\x82"],
        ["\xCB\x5B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x98\x83"],
        ["\xCB\x5D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x98\x84"],
        ["\xB6\xA9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x98\x85"],
        ["\xB6\xA6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x98\x87"],
        ["\xCB\x63",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x98\x88"],
        ["\xCB\x6B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x98\x89"],
        ["\xB6\xA7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x98\x8A"],
        ["\xB6\xA8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x98\x8B"],
        ["\xCB\x71",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x98\x8C"],
        ["\xCB\x72",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x98\x8D"],
        ["\xB6\xAC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x98\x8E"],
        ["\xCB\x73",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x98\x8F"],
        ["\xCB\x74",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x98\x90"],
        ["\xCB\x75",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x98\x91"],
        ["\xCB\x76",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x98\x92"],
        ["\xCB\x77",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x98\x93"],
        ["\xCB\x7A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x98\x94"],
        ["\xCB\x7C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x98\x95"],
        ["\xCB\x80",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x98\x96"],
        ["\xB6\xAA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x98\x97"],
        ["\xCB\x87",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x98\x98"],
        ["\xCB\x88",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x98\x99"],
        ["\xCB\x8B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x98\x9A"],
        ["\xCB\x8F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x98\x9B"],
        ["\xCB\x93",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x98\x9C"],
        ["\xCB\xA0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x98\x9D"],
        ["\xB6\xAD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x98\x9E"],
        ["\xB6\xAF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x98\x9F"],
        ["\xB6\xAE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x98\xA0"],
        ["\xCB\x95",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x98\xA1"],
        ["\xCB\x9A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x98\xA3"],
        ["\xCB\x9D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x98\xA4"],
        ["\xCB\x9E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x98\xA5"],
        ["\xB6\xB0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x98\xA6"],
        ["\xCB\xA3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x98\xA7"],
        ["\xCB\xA4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x98\xA8"],
        ["\xCB\xA5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x98\xA9"],
        ["\xCB\xA6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x98\xAA"],
        ["\xCB\xA8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x98\xAB"],
        ["\xCB\xAD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x98\xAC"],
        ["\xCB\xAF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x98\xAD"],
        ["\xCB\xB0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x98\xAE"],
        ["\xB6\xB3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x98\xAF"],
        ["\xB6\xB1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x98\xB0"],
        ["\xB6\xB2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x98\xB1"],
        ["\xCB\xB8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x98\xB2"],
        ["\xCB\xBA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x98\xB3"],
        ["\xCB\xBF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x98\xB4"],
        ["\xCB\xC0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x98\xB5"],
        ["\xCB\xC3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x98\xB6"],
        ["\xB6\xB4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x98\xB7"],
        ["\xCB\xC5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x98\xB8"],
        ["\xB6\xB5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x98\xB9"],
        ["\xCB\xC7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x98\xBA"],
        ["\xCB\xCB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x98\xBB"],
        ["\xCB\xCE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x98\xBC"],
        ["\xCB\xD4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x98\xBD"],
        ["\xCB\xD9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x98\xBE"],
        ["\xCB\xDA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x98\xBF"],
        ["\xB6\xB6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x99\x80"],
        ["\xCB\xDB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x99\x81"],
        ["\xB6\xB8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x99\x82"],
        ["\xB6\xB9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x99\x83"],
        ["\xCB\xE0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x99\x84"],
        ["\xB6\xBA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x99\x85"],
        ["\xCB\xE2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x99\x86"],
        ["\xCB\xE7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x99\x88"],
        ["\xCB\xE8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x99\x89"],
        ["\xCB\xF4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x99\x8A"],
        ["\xCB\xF7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x99\x8B"],
        ["\xCB\xF8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x99\x8C"],
        ["\xB6\xBE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x99\x8D"],
        ["\xB6\xBF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x99\x8E"],
        ["\xCB\xFA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x99\x8F"],
        ["\xCB\xFB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x99\x90"],
        ["\xCC\x41",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x99\x91"],
        ["\xB6\xC0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x99\x92"],
        ["\xCC\x45",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x99\x93"],
        ["\xCC\x47",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x99\x95"],
        ["\xCC\x48",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x99\x96"],
        ["\xCC\x50",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x99\x97"],
        ["\xCC\x51",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x99\x98"],
        ["\xCC\x53",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x99\x99"],
        ["\xCC\x55",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x99\x9A"],
        ["\xCC\x56",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x99\x9B"],
        ["\xCC\x5A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x99\x9C"],
        ["\xB6\xC1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x99\x9D"],
        ["\xB6\xC2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x99\x9E"],
        ["\xCC\x61",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x99\x9F"],
        ["\xCC\x62",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x99\xA0"],
        ["\xCC\x64",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x99\xA1"],
        ["\xCC\x66",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x99\xA2"],
        ["\xCC\x67",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x99\xA3"],
        ["\xCC\x69",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x99\xA4"],
        ["\xCC\x6B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x99\xA5"],
        ["\xCC\x6C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x99\xA6"],
        ["\xCC\x6D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x99\xA7"],
        ["\xCC\x71",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x99\xA8"],
        ["\xCC\x74",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x99\xA9"],
        ["\xCC\x77",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x99\xAA"],
        ["\xCC\x78",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x99\xAB"],
        ["\xCC\x79",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x99\xAC"],
        ["\xB6\xC3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x99\xAD"],
        ["\xCC\x7C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x99\xAE"],
        ["\xCC\x7F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x99\xAF"],
        ["\xCC\x80",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x99\xB0"],
        ["\xCC\x83",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x99\xB1"],
        ["\xB6\xC4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x99\xB2"],
        ["\xB6\xC6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x99\xB3"],
        ["\xB6\xC5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x99\xB4"],
        ["\xCC\x97",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x99\xB5"],
        ["\xCC\x8B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x99\xB6"],
        ["\xCC\x8C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x99\xB7"],
        ["\xCC\x8F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x99\xB8"],
        ["\xCC\x95",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x99\xB9"],
        ["\xB6\xC7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x99\xBA"],
        ["\xB6\xC8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x99\xBB"],
        ["\xCC\x9D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x99\xBC"],
        ["\xB6\xC9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x99\xBD"],
        ["\xCC\x9F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x99\xBE"],
        ["\xCC\xA3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x99\xBF"],
        ["\xB6\xCF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\x80"],
        ["\xCC\xA9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\x81"],
        ["\xB6\xCB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\x82"],
        ["\xCC\xAB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\x83"],
        ["\xB6\xCC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\x84"],
        ["\xB6\xCD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\x85"],
        ["\xCC\xAD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\x86"],
        ["\xCC\xAE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\x87"],
        ["\xCC\xAF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\x88"],
        ["\xCC\xB5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\x89"],
        ["\xCC\xB6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\x8A"],
        ["\xCC\xBA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\x8B"],
        ["\xCC\xBD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\x8C"],
        ["\xCC\xC6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\x8D"],
        ["\xCC\xC8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\x8E"],
        ["\xCC\xCA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\x8F"],
        ["\xCC\xCD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\x90"],
        ["\xB6\xD0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\x91"],
        ["\xCC\xD3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\x92"],
        ["\xCC\xD9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\x93"],
        ["\xCC\xDC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\x94"],
        ["\xCC\xDE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\x95"],
        ["\xB6\xD2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\x96"],
        ["\xB6\xD1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\x97"],
        ["\xCC\xDF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\x98"],
        ["\xB6\xD4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\x99"],
        ["\xB6\xD3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\x9A"],
        ["\xCC\xE9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\x9B"],
        ["\xB6\xD5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\x9C"],
        ["\xCC\xED",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\x9D"],
        ["\xCC\xEE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\x9E"],
        ["\xCC\xEF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\x9F"],
        ["\xCC\xF6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\xA0"],
        ["\xB6\xD7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\xA1"],
        ["\xCC\xF5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\xA2"],
        ["\xCC\xF7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\xA3"],
        ["\xCC\xF8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\xA4"],
        ["\xCC\xFC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\xA5"],
        ["\xCC\xFD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\xA6"],
        ["\xB6\xD8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\xA7"],
        ["\xCD\x41",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\xA8"],
        ["\xB6\xDA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\xA9"],
        ["\xB6\xDB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\xAA"],
        ["\xB6\xDC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\xAB"],
        ["\xCD\x57",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\xAC"],
        ["\xCD\x58",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\xAD"],
        ["\xCD\x5A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\xAE"],
        ["\xB6\xDD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\xAF"],
        ["\xB6\xDE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\xB0"],
        ["\xCD\x62",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\xB1"],
        ["\xB6\xDF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\xB2"],
        ["\xCD\x6D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\xB3"],
        ["\xCD\x6F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\xB4"],
        ["\xCD\x74",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\xB5"],
        ["\xCD\x77",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\xB6"],
        ["\xCD\x7B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\xB7"],
        ["\xCD\x7F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\xB8"],
        ["\xCD\x81",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\xB9"],
        ["\xCD\x84",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\xBA"],
        ["\xB6\xE1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\xBB"],
        ["\xCD\x86",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\xBC"],
        ["\xCD\x87",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\xBD"],
        ["\xCD\x8A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\xBE"],
        ["\xCD\x8B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\xBF"],
        ["\xB6\xE2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9B\x80"],
        ["\xCD\x90",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9B\x81"],
        ["\xCD\x91",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9B\x82"],
        ["\xB6\xE4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9B\x83"],
        ["\xB6\xE3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9B\x84"],
        ["\xCD\x9B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9B\x85"],
        ["\xCD\x9D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9B\x86"],
        ["\xCD\xA0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9B\x87"],
        ["\xCD\xA3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9B\x88"],
        ["\xCD\xA8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9B\x89"],
        ["\xCD\xC1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9B\x8A"],
        ["\xCD\xBA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9B\x8B"],
        ["\xCD\xC5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9B\x8C"],
        ["\xCD\xD0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9B\x8E"],
        ["\xCD\xD6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9B\x8F"],
        ["\xB6\xE7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9B\x90"],
        ["\xCD\xDA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9B\x91"],
        ["\xCD\xD8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9B\x92"],
        ["\xB6\xE8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9B\x93"],
        ["\xCD\xDD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9B\x94"],
        ["\xCD\xDF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9B\x95"],
        ["\xCD\xE0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9B\x96"],
        ["\xCD\xE5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9B\x97"],
        ["\xB6\xEA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9B\x98"],
        ["\xB6\xEB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9B\x99"],
        ["\xCD\xEE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9B\x9A"],
        ["\xCD\xF1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9B\x9B"],
        ["\xCD\xF6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9B\x9D"],
        ["\xCD\xF9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9B\x9E"],
        ["\xCD\xFC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9B\x9F"],
        ["\xCD\xFD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9B\xA0"],
        ["\xCD\xFE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9B\xA1"],
        ["\xCE\x41",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9B\xA2"],
        ["\xCE\x44",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9B\xA3"],
        ["\xB6\xEE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9B\xA4"],
        ["\xCE\x45",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9B\xA5"],
        ["\xB6\xEF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9B\xA6"],
        ["\xB6\xF0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9B\xA7"],
        ["\xCE\x47",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9B\xA8"],
        ["\xCE\x48",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9B\xA9"],
        ["\xCE\x4B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9B\xAA"],
        ["\xCE\x4E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9B\xAB"],
        ["\xCE\x68",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9B\xB6"],
        ["\xCE\x71",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9B\xB7"],
        ["\xCE\x70",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9B\xB8"],
        ["\xCE\x72",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9B\xB9"],
        ["\xB6\xF4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9B\xBA"],
        ["\xB6\xF5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9B\xBC"],
        ["\xB6\xF7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9B\xBD"],
        ["\xCE\x80",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9B\xBE"],
        ["\xB6\xF8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9B\xBF"],
        ["\xCE\x85",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9C\x80"],
        ["\xCE\x89",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9C\x81"],
        ["\xCE\x8E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9C\x82"],
        ["\xCE\x92",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9C\x83"],
        ["\xB6\xF9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9C\x84"],
        ["\xCE\x9E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9C\x85"],
        ["\xCE\xA0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9C\x86"],
        ["\xCE\xA7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9C\x87"],
        ["\xB6\xFB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9C\x8A"],
        ["\xCE\xB0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9C\x8B"],
        ["\xCE\xBB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9C\x91"],
        ["\xB6\xFE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9C\x94"],
        ["\xB7\x46",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9C\xA7"],
        ["\xCF\x76",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9C\xBB"],
        ["\xCF\x95",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9D\x86"],
        ["\xCF\x96",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9D\x87"],
        ["\xB7\x53",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9D\x90"],
        ["\xCF\xC5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9D\x9C"],
        ["\xD0\x84",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9E\x83"],
        ["\xD0\x8D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9E\x8B"],
        ["\xD0\x9A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9E\x93"],
        ["\xD0\x9F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9E\x95"],
        ["\xD0\xF3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9F\x80"],
        ["\xB7\x6E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9F\x86"],
        ["\xD1\x88",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9F\x9D"],
        ["\xD1\xAD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9F\xA5"],
        ["\xD1\xAF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9F\xA6"],
        ["\xB7\x77",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9F\xA7"],
        ["\xD1\xB4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9F\xA9"],
        ["\xD1\xC4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9F\xAD"],
        ["\xB7\x7C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9F\xB1"],
        ["\xB7\x7F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9F\xB7"],
        ["\xD1\xD5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9F\xB9"],
        ["\xB7\x81",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9F\xBC"],
        ["\xB7\x84",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9F\xBF"],
        ["\xD1\xED",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA0\x84"],
        ["\xD1\xF3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA0\x86"],
        ["\xD2\x5A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA0\x90"],
        ["\xD2\x71",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA0\x98"],
        ["\xD2\x73",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA0\x9A"],
        ["\xD2\x74",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA0\x9B"],
        ["\xB7\x8B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA0\x9C"],
        ["\xD2\x79",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA0\x9E"],
        ["\xB7\x97",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA0\xBA"],
        ["\xD2\xB1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA1\x81"],
        ["\xD2\xCD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA1\x90"],
        ["\xB7\x9B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA1\x91"],
        ["\xD2\xE9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA1\x9D"],
        ["\xB7\x9D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA1\x9E"],
        ["\xD2\xF2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA1\xA0"],
        ["\xB7\x9F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA1\xA2"],
        ["\xD2\xF5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA1\xA3"],
        ["\xB7\xA0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA1\xA4"],
        ["\xD2\xFE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA1\xA5"],
        ["\xD3\x43",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA1\xA6"],
        ["\xD3\x47",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA1\xA7"],
        ["\xB7\xA2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA1\xA8"],
        ["\xB7\xA3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA1\xA9"],
        ["\xD3\x4F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA1\xAA"],
        ["\xB7\xA4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA1\xAB"],
        ["\xB7\xA5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA1\xAC"],
        ["\xB7\xA6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA1\xAD"],
        ["\xD3\x54",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA1\xAE"],
        ["\xD3\x5A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA1\xB0"],
        ["\xD3\x5D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA1\xB1"],
        ["\xD3\x5E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA1\xB2"],
        ["\xD3\x5F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA1\xB3"],
        ["\xB7\xA8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA1\xB4"],
        ["\xD3\x63",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA1\xB6"],
        ["\xD3\x65",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA1\xB7"],
        ["\xD3\x67",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA1\xB8"],
        ["\xD3\x73",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA1\xB9"],
        ["\xD3\x79",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA1\xBA"],
        ["\xD3\x7C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA1\xBB"],
        ["\xD3\x7D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA1\xBC"],
        ["\xD3\x7E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA1\xBD"],
        ["\xD3\x81",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA1\xBE"],
        ["\xD3\x84",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA1\xBF"],
        ["\xD3\x86",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\x80"],
        ["\xD3\x8C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\x81"],
        ["\xB7\xAA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\x82"],
        ["\xD3\x8E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\x83"],
        ["\xD3\x96",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\x84"],
        ["\xD3\x97",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\x85"],
        ["\xD3\x9B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\x86"],
        ["\xD3\x9C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\x87"],
        ["\xD3\x9F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\x88"],
        ["\xB7\xAB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\x89"],
        ["\xD3\xA0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\x8A"],
        ["\xD3\xB2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\x8B"],
        ["\xD3\xB5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\x8C"],
        ["\xB7\xAC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\x8E"],
        ["\xB7\xAF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\x8F"],
        ["\xD3\xB7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\x90"],
        ["\xD3\xB9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\x91"],
        ["\xD3\xBB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\x92"],
        ["\xD3\xBE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\x93"],
        ["\xD3\xCB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\x94"],
        ["\xD3\xC3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\x95"],
        ["\xD3\xC4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\x96"],
        ["\xD3\xC7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\x97"],
        ["\xD3\xC8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\x98"],
        ["\xD3\xC9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\x99"],
        ["\xD3\xCA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\x9A"],
        ["\xB7\xAD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\x9B"],
        ["\xB7\xAE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\x9C"],
        ["\xD3\xCF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\x9D"],
        ["\xB7\xB2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\x9E"],
        ["\xD3\xCC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\x9F"],
        ["\xB7\xB0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\xA0"],
        ["\xD3\xD6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\xA1"],
        ["\xD3\xD7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\xA2"],
        ["\xD3\xD8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\xA3"],
        ["\xD3\xD9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\xA4"],
        ["\xB7\xB1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\xA5"],
        ["\xD3\xDC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\xA6"],
        ["\xD3\xDF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\xA7"],
        ["\xD3\xE1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\xA8"],
        ["\xD3\xE2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\xA9"],
        ["\xB7\xB3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\xAA"],
        ["\xD3\xE3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\xAB"],
        ["\xD3\xE5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\xAC"],
        ["\xD3\xE6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\xAD"],
        ["\xD3\xEB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\xAE"],
        ["\xD3\xF6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\xAF"],
        ["\xB7\xB5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\xB0"],
        ["\xD3\xEC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\xB1"],
        ["\xD3\xED",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\xB2"],
        ["\xB7\xB4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\xB3"],
        ["\xD3\xF2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\xB4"],
        ["\xD3\xF4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\xB5"],
        ["\xD3\xF5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\xB6"],
        ["\xD3\xF7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\xB7"],
        ["\xD3\xF9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\xB8"],
        ["\xD3\xFC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\xB9"],
        ["\xD3\xFD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\xBA"],
        ["\xD3\xFE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\xBB"],
        ["\xB7\xB7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\xBC"],
        ["\xD4\x41",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\xBD"],
        ["\xD4\x42",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\xBE"],
        ["\xD4\x43",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\xBF"],
        ["\xD4\x44",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA3\x80"],
        ["\xB7\xB8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA3\x81"],
        ["\xD4\x47",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA3\x82"],
        ["\xD4\x48",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA3\x83"],
        ["\xD4\x4C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA3\x84"],
        ["\xD4\x4B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA3\x85"],
        ["\xB7\xB9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA3\x86"],
        ["\xD4\x4D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA3\x87"],
        ["\xD4\x4E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA3\x88"],
        ["\xD4\x4F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA3\x89"],
        ["\xB7\xBD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA3\x8A"],
        ["\xB7\xBA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA3\x8B"],
        ["\xB7\xBB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA3\x8C"],
        ["\xD4\x55",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA3\x8D"],
        ["\xB7\xBC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA3\x8E"],
        ["\xD4\x5B",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA3\x8F"],
        ["\xD4\x5F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA3\x90"],
        ["\xD4\x62",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA3\x91"],
        ["\xD4\x63",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA3\x92"],
        ["\xB7\xC2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA3\x93"],
        ["\xD4\x66",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA3\x94"],
        ["\xB7\xBF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA3\x96"],
        ["\xB7\xC0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA3\x97"],
        ["\xD4\x68",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA3\x98"],
        ["\xD4\x69",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA3\x99"],
        ["\xD4\x6C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA3\x9A"],
        ["\xD4\x6E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA3\x9B"],
        ["\xD4\x71",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA3\x9C"],
        ["\xB7\xC1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA3\x9D"],
        ["\xD4\x79",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA3\x9E"],
        ["\xD4\x81",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA3\x9F"],
        ["\xD4\x7E",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA3\xA0"],
        ["\xD4\x7F",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA3\xA1"],
        ["\xB7\xC3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA3\xA2"],
        ["\xD4\x82",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA3\xA3"],
        ["\xD4\x83",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA3\xA4"],
        ["\xD4\x84",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA3\xA5"],
        ["\xD4\x88",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA3\xA6"],
        ["\xD4\x8A",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA3\xA7"],
        ["\xD4\x8C",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA3\xA8"],
        ["\xD4\x8D",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA3\xA9"],
        ["\xB7\xC5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA3\xAA"],
        ["\xD4\x95",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA3\xAB"],
        ["\xB7\xC7",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA3\xAC"],
        ["\xD4\x99",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA3\xAD"],
        ["\xD4\x97",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA3\xAE"],
        ["\xB7\xC8",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA3\xAF"],
        ["\xD4\xA0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA3\xB1"],
        ["\xD4\xA1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA3\xB2"],
        ["\xD4\xA3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA3\xB3"],
        ["\xB4\x52",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA3\xB4"],
        ["\xD4\xA5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA3\xB5"],
        ["\xD4\xA9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA3\xB6"],
        ["\xD4\xAF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA3\xB7"],
        ["\xD4\xB2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA3\xB8"],
        ["\xB7\xC9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA3\xB9"],
        ["\xB7\xCA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA3\xBA"],
        ["\xB7\xCC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA3\xBB"],
        ["\xD4\xBE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA3\xBC"],
        ["\xD4\xC0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA3\xBD"],
        ["\xD4\xC3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA3\xBE"],
        ["\xD4\xC9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA3\xBF"],
        ["\xD4\xCA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA4\x80"],
        ["\xB7\xCD",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA4\x81"],
        ["\xD4\xCB",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA4\x82"],
        ["\xD4\xD3",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA4\x83"],
        ["\xD4\xD4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA4\x84"],
        ["\xD4\xDC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA4\x85"],
        ["\xD4\xE0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA4\x86"],
        ["\xD4\xE2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA4\x87"],
        ["\xD4\xE4",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA4\x88"],
        ["\xD4\xE6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA4\x89"],
        ["\xD4\xE9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA4\x8A"],
        ["\xD4\xEA",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA4\x8B"],
        ["\xD4\xEC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA4\x8C"],
        ["\xD4\xED",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA4\x8D"],
        ["\xD4\xF0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA4\x8E"],
        ["\xB7\xCE",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA4\x8F"],
        ["\xD4\xF2",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA4\x90"],
        ["\xB7\xCF",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA4\x91"],
        ["\xD4\xF5",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA4\x92"],
        ["\xB7\xD0",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA4\x93"],
        ["\xD4\xF6",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA4\x94"],
        ["\xD4\xF9",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA4\x95"],
        ["\xD4\xFC",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA4\x96"],
        ["\xB7\xD1",'utf8jp','cp00930',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA4\x97"],
    );
    $|=1; print "1..",scalar(@test),"\n"; my $testno=1; sub ok { print $_[0]?'ok ':'not ok ',$testno++,$_[1]?" - $_[1]\n":"\n" }
}

use Jacode4e::RoundTrip;

for my $test (@test) {
    my($give,$OUTPUT_encoding,$INPUT_encoding,$option,$want) = @{$test};
    my $got = $give;
    my $return = Jacode4e::RoundTrip::convert(\$got,$OUTPUT_encoding,$INPUT_encoding,$option);

    my $option_content = '';
    if (defined $option) {
        $option_content .= qq{INPUT_LAYOUT=>$option->{'INPUT_LAYOUT'}}        if exists $option->{'INPUT_LAYOUT'};
        $option_content .= qq{OUTPUT_SHIFTING=>$option->{'OUTPUT_SHIFTING'}}  if exists $option->{'OUTPUT_SHIFTING'};
        $option_content .= qq{SPACE=>@{[uc unpack('H*',$option->{'SPACE'})]}} if exists $option->{'SPACE'};
        $option_content .= qq{GETA=>@{[uc unpack('H*',$option->{'GETA'})]}}   if exists $option->{'GETA'};
        $option_content = "{$option_content}";
    }

    ok(($return > 0) and ($got eq $want),
        sprintf(qq{$INPUT_encoding(%s) to $OUTPUT_encoding(%s), $option_content => return=$return,got=(%s)},
            uc unpack('H*',$give),
            uc unpack('H*',$want),
            uc unpack('H*',$got),
        )
    );
}

__END__
