#!/usr/bin/perl

use warnings;
use strict;
use Test::Inter;
$::ti = new Test::Inter $0;
require "tests.pl";

our $obj = new Date::Manip::Date;
$obj->config("forcedate","now,America/New_York");

sub test {
   my(@test)=@_;
   my $date = shift(@test);
   $obj->set("date",$date);
   my $err = $obj->prev(@test);
   if ($err) {
      return $obj->err();
   } else {
      return [ $obj->value() ];
   }
}

my $tests="

[ 1996 11 22 17 49 30 ] 4         0                            => [ 1996 11 21 17 49 30 ]

[ 1996 11 22 17 49 30 ] 4         1                            => [ 1996 11 21 17 49 30 ]

[ 1996 11 22 17 49 30 ] 5         0                            => [ 1996 11 15 17 49 30 ]

[ 1996 11 22 17 49 30 ] 5         0                            => [ 1996 11 15 17 49 30 ]

[ 1996 11 22 17 49 30 ] 5         1                            => [ 1996 11 22 17 49 30 ]

[ 1996 11 22 17 49 30 ] 5         0 [ 18 30 ]                  => [ 1996 11 15 18 30 0 ]

[ 1996 11 22 17 49 30 ] 5         0 [ 18 30 45 ]               => [ 1996 11 15 18 30 45 ]

[ 1996 11 22 17 49 30 ] 5         1 [ 18 30 45 ]               => [ 1996 11 22 18 30 45 ]

[ 1996 11 22 17 49 30 ] 5         2 [ 18 30 45 ]               => [ 1996 11 15 18 30 45 ]

[ 1996 11 22 17 49 30 ] __undef__ 0 [ 18 0 0 ]                 => [ 1996 11 21 18 0 0 ]

[ 1996 11 22 17 49 33 ] __undef__ 0 [ 18 30 0 ]                => [ 1996 11 21 18 30 0 ]

[ 1996 11 22 17 49 33 ] __undef__ 0 [ 18 30 45 ]               => [ 1996 11 21 18 30 45 ]

[ 1996 11 22 17 49 33 ] __undef__ 0 [ 18 __undef__ 45 ]        => [ 1996 11 21 18 0 45 ]

[ 1996 11 22 17 0 0 ]   __undef__ 0 [ 17 0 0 ]                 => [ 1996 11 21 17 0 0 ]

[ 1996 11 22 17 0 0 ]   __undef__ 1 [ 17 0 0 ]                 => [ 1996 11 22 17 0 0 ]

[ 1996 11 22 17 49 0 ]  __undef__ 0 [ 17 49 0 ]                => [ 1996 11 21 17 49 0 ]

[ 1996 11 22 17 49 0 ]  __undef__ 1 [ 17 49 0 ]                => [ 1996 11 22 17 49 0 ]

[ 1996 11 22 17 49 33 ] __undef__ 0 [ 17 49 33 ]               => [ 1996 11 21 17 49 33 ]

[ 1996 11 22 17 49 33 ] __undef__ 1 [ 17 49 33 ]               => [ 1996 11 22 17 49 33 ]

[ 1996 11 22 17 0 33 ]  __undef__ 0 [ 17 __undef__ 33 ]        => [ 1996 11 21 17 0 33 ]

[ 1996 11 22 17 0 33 ]  __undef__ 1 [ 17 __undef__ 33 ]        => [ 1996 11 22 17 0 33 ]

[ 1996 11 22 17 49 30 ] __undef__ 0 [ __undef__ 30 0 ]         => [ 1996 11 22 17 30 0 ]

[ 1996 11 22 17 49 30 ] __undef__ 0 [ __undef__ 30 45 ]        => [ 1996 11 22 17 30 45 ]

[ 1996 11 22 17 49 30 ] __undef__ 0 [ __undef__ __undef__ 30 ] => [ 1996 11 22 17 48 30 ]

[ 1996 11 22 17 30 0 ]  __undef__ 0 [ __undef__ 30 0 ]         => [ 1996 11 22 16 30 0 ]

[ 1996 11 22 17 30 0 ]  __undef__ 1 [ __undef__ 30 0 ]         => [ 1996 11 22 17 30 0 ]

[ 1996 11 22 17 30 45 ] __undef__ 0 [ __undef__ 30 45 ]        => [ 1996 11 22 16 30 45 ]

[ 1996 11 22 17 30 45 ] __undef__ 1 [ __undef__ 30 45 ]        => [ 1996 11 22 17 30 45 ]

[ 1996 11 22 17 30 45 ] __undef__ 0 [ __undef__ __undef__ 45 ] => [ 1996 11 22 17 29 45 ]

[ 1996 11 22 17 30 45 ] __undef__ 1 [ __undef__ __undef__ 45 ] => [ 1996 11 22 17 30 45 ]

[ 2002 11 22 18 15 0 ] 4          0                            => [ 2002 11 21 18 15 0 ]

[ 2002 11 22 18 15 0 ] 4          0 [ 12 30 ]                  => [ 2002 11 21 12 30 0 ]

[ 2002 11 22 18 15 0 ] 5          0                            => [ 2002 11 15 18 15 0 ]

[ 2002 11 22 18 15 0 ] 5          1                            => [ 2002 11 22 18 15 0 ]

[ 2002 11 22 18 15 0 ] 5          2                            => [ 2002 11 15 18 15 0 ]

[ 2002 11 22 18 15 0 ] 5          0 [ 12 30 ]                  => [ 2002 11 15 12 30 0 ]

[ 2002 11 22 18 15 0 ] 5          1 [ 12 30 ]                  => [ 2002 11 22 12 30 0 ]

[ 2002 11 22 18 15 0 ] 5          2 [ 12 30 ]                  => [ 2002 11 22 12 30 0 ]

[ 2002 11 22 18 15 0 ] 5          0 [ 19 30 ]                  => [ 2002 11 15 19 30 0 ]

[ 2002 11 22 18 15 0 ] 5          1 [ 19 30 ]                  => [ 2002 11 22 19 30 0 ]

[ 2002 11 22 18 15 0 ] 5          2 [ 19 30 ]                  => [ 2002 11 15 19 30 0 ]

";

$::ti->tests(func  => \&test,
          tests => $tests);
$::ti->done_testing();

#Local Variables:
#mode: cperl
#indent-tabs-mode: nil
#cperl-indent-level: 3
#cperl-continued-statement-offset: 2
#cperl-continued-brace-offset: 0
#cperl-brace-offset: 0
#cperl-brace-imaginary-offset: 0
#cperl-label-offset: 0
#End:
