#!/usr/bin/perl -w

use strict qw(vars) ;

require 5.006 ;

use ExtUtils::MakeMaker ;
use ExtUtils::Embed ;

use Config ;
use File::Copy ;

no warnings ;

BEGIN
{
    eval { require File::Spec::Functions ; File::Spec::Functions->import() } ;
    if ($@)
    {
        *catfile = sub { return "$_[0]/$_[1]" }
    }
}

if ( $ARGV[0] =~ /renametree/i ) {
  renametree( $ARGV[1] , $ARGV[2] ) ;
  exit;
}

########
# NAME #
########

my $NAME = 'PLDelphi' ;
my $VERSION = '0.01' ;

#######
# EXT #
#######

my $dll = ".$Config{so}" ;
my $o = $Config{_o};

my $LIBNAME = ($dll =~ /\.(?:so|o)$/) ? "lib$NAME" : $NAME ;

#########
# FILES #
#########

my $C_FILES = "$NAME.c" ;
my $O_FILES = "$NAME$o" ;
my $INTERFACE = "$NAME.i" ;
my $CLEAN_FILES = "$LIBNAME$dll" ;

#opendir (DIRLOG, '.');
#while (my $filename = readdir DIRLOG) { $DELPHI_FILES .= " $filename" if $filename =~ /\.pas$/ ;}
#closedir (DIRLOG);

########
# VARS #
########

my $debug = 0;

my $pccflags = ccopts;
my $pldflags = ldopts;
my $ld = $Config{ld};
my $cc = $Config{cc};

chomp($pldflags) ;

my( $out, $ccdebug, $lddebug , $ldlnk , $warn, $rm, $mv );

my $is_MSVC = $cc =~ m/^cl/;
if( $is_MSVC ) {
  $out = '-out:';
  $ccdebug = $debug ? '-Zi ' : '';
  $lddebug = $debug ? '-debug ' : '-release ';
  $warn = '-W3';
  $ldlnk = '' ;
} else {
  $out = '-o ';
  $ccdebug = $debug ? '-g ' : '';
  $lddebug = $debug ? '' : '-s ';
  $warn = '-Wall -Wno-comments ';
  $ldlnk = ' -shared' ;
}

$rm = $^O eq 'MSWin32' ? '$(PERL) -MExtUtils::Command -e rm_f' : 'rm';
$mv = $^O eq 'MSWin32' ? '$(PERL) -MExtUtils::Command -e mv' : 'mv';

my $cflags  = "$ccdebug$warn$pccflags";
my $ldflags = "$lddebug$pldflags$ldlnk";

my $includes = '' ;

##################
# CREATE LIB DIR #
##################



#################
# WRITEMAKEFILE #
#################

print "Writing Makefile for $NAME\n";

open OUT, "> Makefile" or die "open 'Makefile': $!";

print OUT <<EOT;
# AUTOGENERATED, DO NOT EDIT, RERUN Makefile.PL

PERL=$^X

RM=$rm
MV=$mv

RM_RF = \$(PERL) -MExtUtils::Command -e rm_rf

LD=$ld
CC=$cc
CFLAGS=$cflags
LDFLAGS=$ldflags

INC = $includes

C_FILES = $C_FILES
O_FILES = $O_FILES
INTERFACE = $INTERFACE

OBJECTS=  \$(O_FILES)


DISTNAME = $NAME
VERSION = $VERSION
SUFFIX = .gz

DISTVNAME = \$(DISTNAME)-\$(VERSION)

.c$o:
	\$(CC) -c \$(INC) \$(CFLAGS) \$<

all: $LIBNAME$dll built

clean: cleanbuilt
	-\$(RM) *$o *.exp *.lib
	-\$(RM) *.opt *.pdb
	-\$(RM) $CLEAN_FILES
	\$(MV) Makefile Makefile.old

realclean: clean
	-\$(RM) $LIBNAME$dll
	-\$(RM) Makefile Makefile.old

$LIBNAME$dll: \$(OBJECTS)
	\$(LD) \$(OBJECTS) \$(LDFLAGS) -dll $out\$@

test:
	perl -e "print qq`\\n\\n** Take a look in the ConsoleTest project in Delphi (ConsoleTest.dpr)!\\n\\n`"


dist : \$(DISTVNAME).tar\$(SUFFIX)


\$(DISTVNAME).tar\$(SUFFIX) : distdir
	tar cvf \$(DISTVNAME).tar \$(DISTVNAME)
	\$(RM_RF) \$(DISTVNAME)
	gzip --best \$(DISTVNAME).tar


distdir :
	\$(RM_RF) \$(DISTVNAME)
	\$(PERL) -MExtUtils::Manifest=manicopy,maniread -e "manicopy(maniread(),'\$(DISTVNAME)');"


cleanbuilt :
	\$(PERL) MakeFile.PL renametree basiclib txt
	\$(RM_RF) lib
	\$(RM_RF) built


movelib :
	\$(PERL) MakeFile.PL renametree basiclib .
	\$(PERL) -MExtUtils::Manifest=manicopy,maniread -e "chdir('basiclib') ; manicopy( { \%{ maniread('MANIFEST-LIB') } } ,'../lib');"


built : cleanbuilt movelib
	\$(PERL) -MExtUtils::Manifest=manicopy,maniread -e "manicopy( { '$LIBNAME$dll' => '' , \%{ maniread('MANIFEST-BUILT') } } ,'built');"


.SUFFIXES: $o

EOT

##############
# RENAMETREE #
##############

sub renametree {
  my $basedir = $_[0] || './basiclib' ;
  my $ext = exists $_[1] ? $_[1] : 'txt' ;
  
  $ext =~ s/\W//gs ;
  
  $ext = "-$ext" if $ext ;
  
  my @dir = catdir($basedir , 0,1,1) ;
  
  foreach my $dir_i ( @dir ) {
    my $new_file = $dir_i ;
    $new_file =~ s/\.(\w+)(?:-\w+)?$/.$1$ext/ ;
    rename($dir_i , $new_file) ;
    ##print "$dir_i >> $new_file\n" ;
  }
}

##########
# CATDIR # (DIR , CUT_BASE , RECURSIVE , ONLY_FILES)
##########

sub catdir {
  my ( $dir , $cut , $r , $f ) = @_ ;
  
  my @files ;
  
  my @DIR = $dir ;
  foreach my $DIR ( @DIR ) {
    my $DH ;
    opendir ($DH, $DIR);

    while (my $filename = readdir $DH) {
      if ($filename ne "\." && $filename ne "\.\.") {
        my $file = "$DIR/$filename" ;
        if ($r && -d $file) { push(@DIR , $file) ;}
        else {
          if (!$f || !-d $file) {
            $file =~ s/^\Q$dir\E\/?//s if $cut ;
            push(@files , $file) ;
          }
        }
      }
    }
    
    closedir ($DH) ;
  }
  
  return( @files ) ;
}

#######
# END #
#######



