/*
** Copyright (c) 2002-2016, Erik de Castro Lopo <erikd@mega-nerd.com>
** All rights reserved.
**
** This code is released under 2-clause BSD license. Please see the
** file at : https://github.com/erikd/libsamplerate/blob/master/COPYING
*/

/*
**  f = make_filter (8, 128, 100.3) ;
**  Pass band width  : 0.0039062 (should be 0.0039062)
**  Stop band atten. : 100.71 dB
**  -3dB band width  : 0.484
**  half length      : 2463
**  increment        : 128
*/

static const struct fastest_coeffs_s
{	int increment ;
	coeff_t coeffs [2464] ;
} fastest_coeffs =
{	128,
{
 8.31472372954840555082e-01,
 8.31414005540308198583e-01,
 8.31238918266223869580e-01,
 8.30947156036480505392e-01,
 8.30538793675450581766e-01,
 8.30013935904800659316e-01,
 8.29372717311066987023e-01,
 8.28615302303967515840e-01,
 8.27741885065490623496e-01,
 8.26752689489751890761e-01,
 8.25647969113678215081e-01,
 8.24428007038499943704e-01,
 8.23093115842108757896e-01,
 8.21643637482293187624e-01,
 8.20079943190897053817e-01,
 8.18402433358933589780e-01,
 8.16611537412689103554e-01,
 8.14707713680854150873e-01,
 8.12691449252757824873e-01,
 8.10563259827706050764e-01,
 8.08323689555523805517e-01,
 8.05973310868314363198e-01,
 8.03512724303517833491e-01,
 8.00942558318331943035e-01,
 7.98263469095534694553e-01,
 7.95476140340800830231e-01,
 7.92581283071560838138e-01,
 7.89579635397499868255e-01,
 7.86471962292734527722e-01,
 7.83259055359786127148e-01,
 7.79941732585400893107e-01,
 7.76520838088307852054e-01,
 7.72997241859018080490e-01,
 7.69371839491718167992e-01,
 7.65645551908390675777e-01,
 7.61819325075220210586e-01,
 7.57894129711408459649e-01,
 7.53870960990470018181e-01,
 7.49750838234153449413e-01,
 7.45534804599028211314e-01,
 7.41223926755909090502e-01,
 7.36819294562192195208e-01,
 7.32322020727209643809e-01,
 7.27733240470738174110e-01,
 7.23054111174766811487e-01,
 7.18285812028632841830e-01,
 7.13429543667664534112e-01,
 7.08486527805442301009e-01,
 7.03458006859804640953e-01,
 6.98345243572719653891e-01,
 6.93149520624175785599e-01,
 6.87872140240182283755e-01,
 6.82514423795047564525e-01,
 6.77077711408058502407e-01,
 6.71563361534684655219e-01,
 6.65972750552474845875e-01,
 6.60307272341742135247e-01,
 6.54568337861228477514e-01,
 6.48757374718860524432e-01,
 6.42875826737744904271e-01,
 6.36925153517562181449e-01,
 6.30906829991492501541e-01,
 6.24822345978837789815e-01,
 6.18673205733470954470e-01,
 6.12460927488293727095e-01,
 6.06187042995817604307e-01,
 5.99853097065060292259e-01,
 5.93460647094893878339e-01,
 5.87011262603992944875e-01,
 5.80506524757569142281e-01,
 5.73948025891025337408e-01,
 5.67337369030688098981e-01,
 5.60676167411809700525e-01,
 5.53966043993961543279e-01,
 5.47208630974010734604e-01,
 5.40405569296826038261e-01,
 5.33558508163880174102e-01,
 5.26669104539922661168e-01,
 5.19739022657876970079e-01,
 5.12769933522119303326e-01,
 5.05763514410336290084e-01,
 4.98721448374081555155e-01,
 4.91645423738241937883e-01,
 4.84537133599546865348e-01,
 4.77398275324308896117e-01,
 4.70230550045545592219e-01,
 4.63035662159660077464e-01,
 4.55815318822846149427e-01,
 4.48571229447379538069e-01,
 4.41305105197960123586e-01,
 4.34018658488283970431e-01,
 4.26713602477997000495e-01,
 4.19391650570203500248e-01,
 4.12054515909689722530e-01,
 4.04703910882034223473e-01,
 3.97341546613763640927e-01,
 3.89969132473721613596e-01,
 3.82588375575806771689e-01,
 3.75200980283257823356e-01,
 3.67808647714624070701e-01,
 3.60413075251609871241e-01,
 3.53015956048925771960e-01,
 3.45618978546330835044e-01,
 3.38223825983006376461e-01,
 3.30832175914426429575e-01,
 3.23445699731881031180e-01,
 3.16066062184803764357e-01,
 3.08694920906066150312e-01,
 3.01333925940378832831e-01,
 2.93984719275965256102e-01,
 2.86648934379644393378e-01,
 2.79328195735489559492e-01,
 2.72024118387182545220e-01,
 2.64738307484245039003e-01,
 2.57472357832259801658e-01,
 2.50227853447243409057e-01,
 2.43006367114305704691e-01,
 2.35809459950733935063e-01,
 2.28638680973647728800e-01,
 2.21495566672345989279e-01,
 2.14381640585498134399e-01,
 2.07298412883298144305e-01,
 2.00247379954717363848e-01,
 1.93230023999986955108e-01,
 1.86247812628430653437e-01,
 1.79302198461779749294e-01,
 1.72394618743085786816e-01,
 1.65526494951356295537e-01,
 1.58699232422028796430e-01,
 1.51914219973401071195e-01,
 1.45172829539132269838e-01,
 1.38476415806921215879e-01,
 1.31826315863480453272e-01,
 1.25223848845901208904e-01,
 1.18670315599523901184e-01,
 1.12166998342411894374e-01,
 1.05715160336527447260e-01,
 9.93160455657086521652e-02,
 9.29708784205405536216e-02,
 8.66808633902153846673e-02,
 8.04471847614677826321e-02,
 7.42710063246745516574e-02,
 6.81534710872001986415e-02,
 6.20957009940759641076e-02,
 5.60987966560835549235e-02,
 5.01638370853247708703e-02,
 4.42918794383505357026e-02,
 3.84839587669171534490e-02,
 3.27410877764400740086e-02,
 2.70642565922108620236e-02,
 2.14544325334371267788e-02,
 1.59125598951669576520e-02,
 1.04395597381551803740e-02,
 5.03632968672305773861e-03,
-2.96256265336385191805e-04,
-5.55734794075828358179e-03,
-1.07461191566687631893e-02,
-1.58617678942645466689e-02,
-2.09035164602743607498e-02,
-2.58706116401622790435e-02,
-3.07623248430414844568e-02,
-3.55779522382659724178e-02,
-4.03168148836769782428e-02,
-4.49782588454727128013e-02,
-4.95616553096875425699e-02,
-5.40664006852556791594e-02,
-5.84919166986474642345e-02,
-6.28376504800633867154e-02,
-6.71030746411782619276e-02,
-7.12876873444269476554e-02,
-7.53910123638282386738e-02,
-7.94125991373483691715e-02,
-8.33520228108008270906e-02,
-8.72088842732959695914e-02,
-9.09828101842390379872e-02,
-9.46734529918955292072e-02,
-9.82804909435327500589e-02,
-1.01803628087157427284e-01,
-1.05242594264867719844e-01,
-1.08597145097841310535e-01,
-1.11867061962988789681e-01,
-1.15052151961296145188e-01,
-1.18152247877890054228e-01,
-1.21167208133862752684e-01,
-1.24096916729885473063e-01,
-1.26941283181660202750e-01,
-1.29700242447243679900e-01,
-1.32373754846295377252e-01,
-1.34961805971292009287e-01,
-1.37464406590764143257e-01,
-1.39881592544604443917e-01,
-1.42213424631507739937e-01,
-1.44459988488595730827e-01,
-1.46621394463294696386e-01,
-1.48697777477524800682e-01,
-1.50689296884269657850e-01,
-1.52596136316595465399e-01,
-1.54418503529190731527e-01,
-1.56156630232500315270e-01,
-1.57810771919529219121e-01,
-1.59381207685401427021e-01,
-1.60868240039743037872e-01,
-1.62272194711985145998e-01,
-1.63593420449666626659e-01,
-1.64832288809824062392e-01,
-1.65989193943563151379e-01,
-1.67064552373901109572e-01,
-1.68058802766975601273e-01,
-1.68972405696717037360e-01,
-1.69805843403086798027e-01,
-1.70559619543971530131e-01,
-1.71234258940853617537e-01,
-1.71830307318344255307e-01,
-1.72348331037702334756e-01,
-1.72788916824434257702e-01,
-1.73152671490098081231e-01,
-1.73440221648409775845e-01,
-1.73652213425782242506e-01,
-1.73789312166397952319e-01,
-1.73852202131942051855e-01,
-1.73841586196111674845e-01,
-1.73758185534021086793e-01,
-1.73602739306629005878e-01,
-1.73376004340306061335e-01,
-1.73078754801670009478e-01,
-1.72711781867818603420e-01,
-1.72275893392080048372e-01,
-1.71771913565416961545e-01,
-1.71200682573611373538e-01,
-1.70563056250360139954e-01,
-1.69859905726417126370e-01,
-1.69092117074913228514e-01,
-1.68260590952989147473e-01,
-1.67366242239875284703e-01,
-1.66409999671557895518e-01,
-1.65392805472166642966e-01,
-1.64315614982222552021e-01,
-1.63179396283883837437e-01,
-1.61985129823331186483e-01,
-1.60733808030429803360e-01,
-1.59426434935813571281e-01,
-1.58064025785527417778e-01,
-1.56647606653372045704e-01,
-1.55178214051094831571e-01,
-1.53656894536566474008e-01,
-1.52084704320088470730e-01,
-1.50462708868975059140e-01,
-1.48791982510548842500e-01,
-1.47073608033699704256e-01,
-1.45308676289147314931e-01,
-1.43498285788550977715e-01,
-1.41643542302611558092e-01,
-1.39745558458309881988e-01,
-1.37805453335422323224e-01,
-1.35824352062461073398e-01,
-1.33803385412180564362e-01,
-1.31743689396791985313e-01,
-1.29646404863030306753e-01,
-1.27512677087215337002e-01,
-1.25343655370452389253e-01,
-1.23140492634104758984e-01,
-1.20904345015691472298e-01,
-1.18636371465341922127e-01,
-1.16337733342949820048e-01,
-1.14009594016166518338e-01,
-1.11653118459372716065e-01,
-1.09269472853762789066e-01,
-1.06859824188683741331e-01,
-1.04425339864360325337e-01,
-1.01967187296145456177e-01,
-9.94865335204263567803e-02,
-9.69845448023236023083e-02,
-9.44623862453117940641e-02,
-9.19212214028948121358e-02,
-8.93622118924671249296e-02,
-8.67865170114848205607e-02,
-8.41952933560805999447e-02,
-8.15896944422443981537e-02,
-7.89708703296961439522e-02,
-7.63399672485739477779e-02,
-7.36981272290610500697e-02,
-7.10464877340710454501e-02,
-6.83861812951113146042e-02,
-6.57183351514422919859e-02,
-6.30440708926501142129e-02,
-6.03645041047437408421e-02,
-5.76807440198948140342e-02,
-5.49938931699267691267e-02,
-5.23050470436661057994e-02,
-4.96152937482609926456e-02,
-4.69257136745778041798e-02,
-4.42373791667729082677e-02,
-4.15513541961495605492e-02,
-3.88686940393953503370e-02,
-3.61904449613011935938e-02,
-3.35176439020573244121e-02,
-3.08513181692228674602e-02,
-2.81924851344595717162e-02,
-2.55421519351213023585e-02,
-2.29013151807887539724e-02,
-2.02709606648342685609e-02,
-1.76520630811025022733e-02,
-1.50455857457888787787e-02,
-1.24524803245954687053e-02,
-9.87368656524285036313e-03,
-7.31013203541311037958e-03,
-4.76273186619807602227e-03,
-2.23238850112297869746e-03,
 2.80008549183706099625e-04,
 2.77358294660976899965e-03,
 5.24747175940274562800e-03,
 7.70082569017439908660e-03,
 1.01328092980087648006e-02,
 1.25426012146140665460e-02,
 1.49293943544662570388e-02,
 1.72923961188884665885e-02,
 1.96308285940195309527e-02,
 2.19439287426209730936e-02,
 2.42309485896793734561e-02,
 2.64911554017603391442e-02,
 2.87238318600733545660e-02,
 3.09282762272103349532e-02,
 3.31038025075217068327e-02,
 3.52497406010981520486e-02,
 3.73654364513253609004e-02,
 3.94502521859858221176e-02,
 4.15035662518817155542e-02,
 4.35247735429537541130e-02,
 4.55132855218787699125e-02,
 4.74685303351244439196e-02,
 4.93899529214478216765e-02,
 5.12770151138242716304e-02,
 5.31291957347935772660e-02,
 5.49459906852194576721e-02,
 5.67269130264521220797e-02,
 5.84714930558940249039e-02,
 6.01792783759655322551e-02,
 6.18498339564735599705e-02,
 6.34827421903864652641e-02,
 6.50776029430226859995e-02,
 6.66340335946605799577e-02,
 6.81516690765814614483e-02,
 6.96301619005592065115e-02,
 7.10691821818139612965e-02,
 7.24684176554465098175e-02,
 7.38275736863740761340e-02,
 7.51463732727930683319e-02,
 7.64245570431912463194e-02,
 7.76618832469397474272e-02,
 7.88581277384926976337e-02,
 8.00130839552289779837e-02,
 8.11265628889681067459e-02,
 8.21983930512013155623e-02,
 8.32284204320703352442e-02,
 8.42165084531432683868e-02,
 8.51625379140240473808e-02,
 8.60664069328434949702e-02,
 8.69280308806818224898e-02,
 8.77473423099686122839e-02,
 8.85242908769151987114e-02,
 8.92588432580306151420e-02,
 8.99509830607803234637e-02,
 9.06007107284422380511e-02,
 9.12080434392217309636e-02,
 9.17730149996878741270e-02,
 9.22956757325926607782e-02,
 9.27760923591415126443e-02,
 9.32143478757788968014e-02,
 9.36105414255621187669e-02,
 9.39647881641913207407e-02,
 9.42772191207702781046e-02,
 9.45479810533706027664e-02,
 9.47772362994778183598e-02,
 9.49651626213951355338e-02,
 9.51119530466846413441e-02,
 9.52178157037280176178e-02,
 9.52829736524876819148e-02,
 9.53076647105531166160e-02,
 9.52921412745576373871e-02,
 9.52366701370536278271e-02,
 9.51415322989309503177e-02,
 9.50070227774735681647e-02,
 9.48334504101390751707e-02,
 9.46211376541590265532e-02,
 9.43704203820504156086e-02,
 9.40816476731309581094e-02,
 9.37551816011396865758e-02,
 9.33913970180541563870e-02,
 9.29906813342047527948e-02,
 9.25534342947849225647e-02,
 9.20800677528557931506e-02,
 9.15710054389489019888e-02,
 9.10266827273659706599e-02,
 9.04475463992783224043e-02,
 8.98340544027328158361e-02,
 8.91866756096650198371e-02,
 8.85058895700238101867e-02,
 8.77921862631190763615e-02,
 8.70460658462897246546e-02,
 8.62680384010083983748e-02,
 8.54586236765221690659e-02,
 8.46183508311429133375e-02,
 8.37477581712920277068e-02,
 8.28473928884114751980e-02,
 8.19178107938471483651e-02,
 8.09595760518180135312e-02,
 7.99732609105757996648e-02,
 7.89594454318716387764e-02,
 7.79187172188340326784e-02,
 7.68516711423724852015e-02,
 7.57589090662164482692e-02,
 7.46410395707000073884e-02,
 7.34986776754032733461e-02,
 7.23324445607601979047e-02,
 7.11429672887474440213e-02,
 6.99308785227581580779e-02,
 6.86968162467783832748e-02,
 6.74414234839716131287e-02,
 6.61653480147834510694e-02,
 6.48692420946761771905e-02,
 6.35537621716019962559e-02,
 6.22195686033254202751e-02,
 6.08673253747022482973e-02,
 5.94976998150253330588e-02,
 5.81113623155428762890e-02,
 5.67089860472591994478e-02,
 5.52912466791220663653e-02,
 5.38588220967053943333e-02,
 5.24123921214928872869e-02,
 5.09526382308646275110e-02,
 4.94802432788957607945e-02,
 4.79958912180662375380e-02,
 4.65002668219884549017e-02,
 4.49940554092515265783e-02,
 4.34779425684853407241e-02,
 4.19526138847447563340e-02,
 4.04187546673120054463e-02,
 3.88770496790168534895e-02,
 3.73281828671714888124e-02,
 3.57728370962169389680e-02,
 3.42116938821758476141e-02,
 3.26454331290065291604e-02,
 3.10747328669506231447e-02,
 2.95002689929673225788e-02,
 2.79227150133440210622e-02,
 2.63427417885741359249e-02,
 2.47610172805882329528e-02,
 2.31782063024293799591e-02,
 2.15949702704538760989e-02,
 2.00119669591453143431e-02,
 1.84298502586232419709e-02,
 1.68492699349288496680e-02,
 1.52708713931675090641e-02,
 1.36952954435869880129e-02,
 1.21231780706691841254e-02,
 1.05551502053105091677e-02,
 8.99183750016553651196e-03,
 7.43386010822696258193e-03,
 5.88183246471273707412e-03,
 4.33636307232945251988e-03,
 2.79805428998205086427e-03,
 1.26750212499337003291e-03,
-2.54703971099550386531e-04,
-1.76798130311027175757e-03,
-3.27175412906725469539e-03,
-4.76545385331804925710e-03,
-6.24851921581533794464e-03,
-7.72039647752874400727e-03,
-9.18053960192777122884e-03,
-1.06284104324833178490e-02,
-1.20634788661366718077e-02,
-1.34852230226875247771e-02,
-1.48931294100519973078e-02,
-1.62866930853476296615e-02,
-1.76654178117594401476e-02,
-1.90288162111466874205e-02,
-2.03764099123495759369e-02,
-2.17077296951579609696e-02,
-2.30223156299061669505e-02,
-2.43197172126588360974e-02,
-2.55994934959561624976e-02,
-2.68612132150869431513e-02,
-2.81044549098614510063e-02,
-2.93288070418574950415e-02,
-3.05338681071131295974e-02,
-3.17192467442452205595e-02,
-3.28845618379712614776e-02,
-3.40294426180154721551e-02,
-3.51535287533818185945e-02,
-3.62564704419792716017e-02,
-3.73379284955845242022e-02,
-3.83975744201309962533e-02,
-3.94350904913155775322e-02,
-4.04501698255130062720e-02,
-4.14425164459938585870e-02,
-4.24118453444415760556e-02,
-4.33578825377650758921e-02,
-4.42803651202084772032e-02,
-4.51790413107587551789e-02,
-4.60536704958539877541e-02,
-4.69040232673985507672e-02,
-4.77298814560914094751e-02,
-4.85310381600771723054e-02,
-4.93072977689298017068e-02,
-5.00584759829825892696e-02,
-5.07843998280173986037e-02,
-5.14849076653303427964e-02,
-5.21598491971914657306e-02,
-5.28090854677170859488e-02,
-5.34324888591782357072e-02,
-5.40299430837655400572e-02,
-5.46013431708381041796e-02,
-5.51465954496810906171e-02,
-5.56656175277993395256e-02,
-5.61583382647804357779e-02,
-5.66246977417538960298e-02,
-5.70646472264832865795e-02,
-5.74781491341238848225e-02,
-5.78651769836829588112e-02,
-5.82257153502198851469e-02,
-5.85597598128258789441e-02,
-5.88673168984241990120e-02,
-5.91484040214318093631e-02,
-5.94030494193287308957e-02,
-5.96312920841784027681e-02,
-5.98331816901454746627e-02,
-6.00087785170606569096e-02,
-6.01581533700810480725e-02,
-6.02813874954959694197e-02,
-6.03785724927326447609e-02,
-6.04498102226119424230e-02,
-6.04952127119116611631e-02,
-6.05149020542914278797e-02,
-6.05090103076376881197e-02,
-6.04776793878847099273e-02,
-6.04210609593744951695e-02,
-6.03393163218124903291e-02,
-6.02326162938837256222e-02,
-6.01011410935896536745e-02,
-5.99450802153716350018e-02,
-5.97646323040843391317e-02,
-5.95600050258849322837e-02,
-5.93314149361059764431e-02,
-5.90790873441773764507e-02,
-5.88032561756684640786e-02,
-5.85041638315173181950e-02,
-5.81820610445198463379e-02,
-5.78372067331465664064e-02,
-5.74698678527617162759e-02,
-5.70803192443151696800e-02,
-5.66688434805820984153e-02,
-5.62357307100216502471e-02,
-5.57812784983319834287e-02,
-5.53057916677746758127e-02,
-5.48095821343453915020e-02,
-5.42929687428649263015e-02,
-5.37562771000702349644e-02,
-5.31998394057807341695e-02,
-5.26239942822169029513e-02,
-5.20290866015511582754e-02,
-5.14154673117670768523e-02,
-5.07834932609073572141e-02,
-5.01335270197884388943e-02,
-4.94659367032617980353e-02,
-4.87810957901005926018e-02,
-4.80793829415919610204e-02,
-4.73611818189140221236e-02,
-4.66268808993793651418e-02,
-4.58768732916221277929e-02,
-4.51115565498113532672e-02,
-4.43313324869706107401e-02,
-4.35366069874822472774e-02,
-4.27277898188581847783e-02,
-4.19052944428566706558e-02,
-4.10695378260253277092e-02,
-4.02209402497498702544e-02,
-3.93599251198885058400e-02,
-3.84869187760717781921e-02,
-3.76023503007467674308e-02,
-3.67066513280452297319e-02,
-3.58002558525536487832e-02,
-3.48836000380640318119e-02,
-3.39571220263849699039e-02,
-3.30212617462878818553e-02,
-3.20764607226682249563e-02,
-3.11231618859974003277e-02,
-3.01618093821427596390e-02,
-2.91928483826300218251e-02,
-2.82167248954252464221e-02,
-2.72338855763107207109e-02,
-2.62447775409285488646e-02,
-2.52498481775659533444e-02,
-2.42495449607560524530e-02,
-2.32443152657647901516e-02,
-2.22346061840382018537e-02,
-2.12208643396787077773e-02,
-2.02035357070221716080e-02,
-1.91830654293842946256e-02,
-1.81598976390459701524e-02,
-1.71344752785447841659e-02,
-1.61072399233397958729e-02,
-1.50786316059164128556e-02,
-1.40490886413957953571e-02,
-1.30190474547137412242e-02,
-1.19889424094323342185e-02,
-1.09592056382471266657e-02,
-9.93026687525074697183e-03,
-8.90255329001433948211e-03,
-7.87648932354562125724e-03,
-6.85249652618241146540e-03,
-5.83099339747908569642e-03,
-4.81239522814202146106e-03,
-3.79711394406930576734e-03,
-2.78555795254968683455e-03,
-1.77813199067227692071e-03,
-7.75236976000132386663e-04,
 2.22730140442126654798e-04,
 1.21537651881706244492e-03,
 2.20231357271108733539e-03,
 3.18315710891246220898e-03,
 4.15752746468348553799e-03,
 5.12504964248380791986e-03,
 6.08535344210042478813e-03,
 7.03807359014245199208e-03,
 7.98284986685961206465e-03,
 8.91932723024580452476e-03,
 9.84715593738785290034e-03,
 1.07659916630240357766e-02,
 1.16754956152756248638e-02,
 1.25753346485176220604e-02,
 1.34651813733560731662e-02,
 1.43447142636787781933e-02,
 1.52136177607511777904e-02,
 1.60715823743268690360e-02,
 1.69183047807457617728e-02,
 1.77534879179936204430e-02,
 1.85768410776981605925e-02,
 1.93880799940382604618e-02,
 2.01869269295435888045e-02,
 2.09731107577651766649e-02,
 2.17463670427963037812e-02,
 2.25064381156266125894e-02,
 2.32530731473125917841e-02,
 2.39860282189490944815e-02,
 2.47050663884288181082e-02,
 2.54099577539762186418e-02,
 2.61004795144461655687e-02,
 2.67764160263764816605e-02,
 2.74375588577874841845e-02,
 2.80837068387202806741e-02,
 2.87146661085097808230e-02,
 2.93302501597869115513e-02,
 2.99302798792087168533e-02,
 3.05145835849139068774e-02,
 3.10829970607048658437e-02,
 3.16353635869560598226e-02,
 3.21715339682534032240e-02,
 3.26913665577675052742e-02,
 3.31947272783659833029e-02,
 3.36814896404726560331e-02,
 3.41515347566807569990e-02,
 3.46047513531298478462e-02,
 3.50410357776568884280e-02,
 3.54602920047340924858e-02,
 3.58624316372060172875e-02,
 3.62473739048404727803e-02,
 3.66150456597097023748e-02,
 3.69653813684179058385e-02,
 3.72983231011940682964e-02,
 3.76138205178691634178e-02,
 3.79118308507581658340e-02,
 3.81923188844700278732e-02,
 3.84552569326661666804e-02,
 3.87006248117945095277e-02,
 3.89284098118221136287e-02,
 3.91386066639944005252e-02,
 3.93312175056476295842e-02,
 3.95062518421033306848e-02,
 3.96637265056755394799e-02,
 3.98036656118202977761e-02,
 3.99261005124597820326e-02,
 4.00310697465144360585e-02,
 4.01186189876763035778e-02,
 4.01888009894591641258e-02,
 4.02416755275608953313e-02,
 4.02773093395744422041e-02,
 4.02957760620868618573e-02,
 4.02971561652026855072e-02,
 4.02815368845340013304e-02,
 4.02490121506946865737e-02,
 4.01996825163432602857e-02,
 4.01336550808131173329e-02,
 4.00510434123766412284e-02,
 3.99519674681838021790e-02,
 3.98365535119223901361e-02,
 3.97049340292425986809e-02,
 3.95572476409943238340e-02,
 3.93936390143226622396e-02,
 3.92142587716682866628e-02,
 3.90192633977227906761e-02,
 3.88088151443859719070e-02,
 3.85830819337740632546e-02,
 3.83422372593309676581e-02,
 3.80864600850902706997e-02,
 3.78159347431409609275e-02,
 3.75308508293468318096e-02,
 3.72314030973733209318e-02,
 3.69177913510723085255e-02,
 3.65902203352790472701e-02,
 3.62488996250740352911e-02,
 3.58940435135636018438e-02,
 3.55258708982338911042e-02,
 3.51446051659309519066e-02,
 3.47504740765239503175e-02,
 3.43437096453047957523e-02,
 3.39245480241803926136e-02,
 3.34932293817127510471e-02,
 3.30499977820627663383e-02,
 3.25951010628938789293e-02,
 3.21287907122915217251e-02,
 3.16513217447548164674e-02,
 3.11629525763171093267e-02,
 3.06639448988514501382e-02,
 3.01545635536184866710e-02,
 2.96350764041116987446e-02,
 2.91057542082603579181e-02,
 2.85668704900414009706e-02,
 2.80187014105628129368e-02,
 2.74615256386703497637e-02,
 2.68956242211381771345e-02,
 2.63212804524964143205e-02,
 2.57387797445546746833e-02,
 2.51484094956766456030e-02,
 2.45504589598617914414e-02,
 2.39452191156906725455e-02,
 2.33329825351894608321e-02,
 2.27140432526683408443e-02,
 2.20886966335908999093e-02,
 2.14572392435271874778e-02,
 2.08199687172471933905e-02,
 2.01771836280079629178e-02,
 1.95291833570884962312e-02,
 1.88762679636269269101e-02,
 1.82187380548123403767e-02,
 1.75568946564845403124e-02,
 1.68910390841945853846e-02,
 1.62214728147774996103e-02,
 1.55484973584896369464e-02,
 1.48724141317607399387e-02,
 1.41935243306124080076e-02,
 1.35121288047925294795e-02,
 1.28285279326754275003e-02,
 1.21430214969758445281e-02,
 1.14559085613274869858e-02,
 1.07674873477713456404e-02,
 1.00780551152029641815e-02,
 9.38790803882408146641e-03,
 8.69734109064560119429e-03,
 8.00664792108640895052e-03,
 7.31612074171312902482e-03,
 6.62605020916498532735e-03,
 5.93672531030635993593e-03,
 5.24843324865020312286e-03,
 4.56145933209378684481e-03,
 3.87608686200798923521e-03,
 3.19259702372048361982e-03,
 2.51126877843176705626e-03,
 1.83237875660391988202e-03,
 1.15620115285868549186e-03,
 4.83007622422852007059e-04,
-1.86932820843070034112e-04,
-8.53353904797455329115e-04,
-1.51599219771675255281e-03,
-2.17458720530792556924e-03,
-2.82888146600037857989e-03,
-3.47862064448672828401e-03,
-4.12355362347965707925e-03,
-4.76343259365718217635e-03,
-5.39801314176371720144e-03,
-6.02705433684159932323e-03,
-6.65031881456398799024e-03,
-7.26757285964317947813e-03,
-7.87858648628854928153e-03,
-8.48313351669007821576e-03,
-9.08099165750268083608e-03,
-9.67194257431004678072e-03,
-1.02557719640449674509e-02,
-1.08322696253466653482e-02,
-1.14012295268339416271e-02,
-1.19624498732761111452e-02,
-1.25157331696445651287e-02,
-1.30608862830260651078e-02,
-1.35977205023845738180e-02,
-1.41260515961539080687e-02,
-1.46456998676501564532e-02,
-1.51564902082884610246e-02,
-1.56582521485937077588e-02,
-1.61508199069943896020e-02,
-1.66340324363880263936e-02,
-1.71077334684716746149e-02,
-1.75717715558275228149e-02,
-1.80260001117568194329e-02,
-1.84702774478586080609e-02,
-1.89044668093441003975e-02,
-1.93284364080869922042e-02,
-1.97420594534034529732e-02,
-2.01452141805614354242e-02,
-2.05377838770183090977e-02,
-2.09196569063852221004e-02,
-2.12907267301215390176e-02,
-2.16508919269584217127e-02,
-2.20000562100566773860e-02,
-2.23381284419012192399e-02,
-2.26650226469371808558e-02,
-2.29806580219539050014e-02,
-2.32849589442222955349e-02,
-2.35778549773940013234e-02,
-2.38592808751701725145e-02,
-2.41291765827496146324e-02,
-2.43874872360661625048e-02,
-2.46341631588262027774e-02,
-2.48691598573592027865e-02,
-2.50924380132932847709e-02,
-2.53039634740697960691e-02,
-2.55037072413113186098e-02,
-2.56916454570593408291e-02,
-2.58677593878966008423e-02,
-2.60320354069717534162e-02,
-2.61844649739453247395e-02,
-2.63250446128731642459e-02,
-2.64537758880496950975e-02,
-2.65706653778289558776e-02,
-2.66757246464459155111e-02,
-2.67689702138592805492e-02,
-2.68504235236379437679e-02,
-2.69201109089152179621e-02,
-2.69780635564342181898e-02,
-2.70243174687087896191e-02,
-2.70589134243261995871e-02,
-2.70818969364167577707e-02,
-2.70933182093176481986e-02,
-2.70932320934577017257e-02,
-2.70816980384915410862e-02,
-2.70587800447114543156e-02,
-2.70245466127663376554e-02,
-2.69790706917171427270e-02,
-2.69224296254590607369e-02,
-2.68547050975419879237e-02,
-2.67759830744198866481e-02,
-2.66863537471611969587e-02,
-2.65859114716531889921e-02,
-2.64747547073322930800e-02,
-2.63529859544745573285e-02,
-2.62207116900796607939e-02,
-2.60780423023825730366e-02,
-2.59250920240284947471e-02,
-2.57619788639449828760e-02,
-2.55888245379471308827e-02,
-2.54057543981124761556e-02,
-2.52128973609604678519e-02,
-2.50103858344739478359e-02,
-2.47983556439997539222e-02,
-2.45769459570643403201e-02,
-2.43462992071435090080e-02,
-2.41065610164222128564e-02,
-2.38578801175844575078e-02,
-2.36004082746693114037e-02,
-2.33343002030331689300e-02,
-2.30597134884559483436e-02,
-2.27768085054302904524e-02,
-2.24857483346725776918e-02,
-2.21866986798954189675e-02,
-2.18798277838799307138e-02,
-2.15653063438876642366e-02,
-2.12433074264517691987e-02,
-2.09140063815867055519e-02,
-2.05775807564556566243e-02,
-2.02342102085360346642e-02,
-1.98840764183222142025e-02,
-1.95273630016047500257e-02,
-1.91642554213670816832e-02,
-1.87949408993371563925e-02,
-1.84196083272362247374e-02,
-1.80384481777610752862e-02,
-1.76516524153425696797e-02,
-1.72594144067167720724e-02,
-1.68619288313498413845e-02,
-1.64593915917550098760e-02,
-1.60519997237402040069e-02,
-1.56399513066264282679e-02,
-1.52234453734734331148e-02,
-1.48026818213531103502e-02,
-1.43778613217079923037e-02,
-1.39491852308316760523e-02,
-1.35168555005115483686e-02,
-1.30810745888681710658e-02,
-1.26420453714316226301e-02,
-1.21999710524887047813e-02,
-1.17550550767402828961e-02,
-1.13075010413035727252e-02,
-1.08575126080952908542e-02,
-1.04052934166326063736e-02,
-9.95104699728536351566e-03,
-9.49497668501652312967e-03,
-9.03728553364356763933e-03,
-8.57817623065582068875e-03,
-8.11785101262214349449e-03,
-7.65651158122056946231e-03,
-7.19435901992488725798e-03,
-6.73159371137851351291e-03,
-6.26841525548942068990e-03,
-5.80502238827697216589e-03,
-5.34161290150089295564e-03,
-4.87838356310490647849e-03,
-4.41553003850264462471e-03,
-3.95324681273798422126e-03,
-3.49172711354636287548e-03,
-3.03116283534747218975e-03,
-2.57174446419663202748e-03,
-2.11366100372138449731e-03,
-1.65709990207213789248e-03,
-1.20224697991074881177e-03,
-7.49286359465203312402e-04,
-2.98400394673150758020e-04,
 1.50230397559290287587e-04,
 5.96427404960260163468e-04,
 1.04001398633389997676e-03,
 1.48081553681653948010e-03,
 1.91865955192711671630e-03,
 2.35337569038958404136e-03,
 2.78479583570576333731e-03,
 3.21275415646031688166e-03,
 3.63708716533605539573e-03,
 4.05763377682291995208e-03,
 4.47423536360066955581e-03,
 4.88673581157838838457e-03,
 5.29498157357465894235e-03,
 5.69882172162047926506e-03,
 6.09810799787139853900e-03,
 6.49269486411187517899e-03,
 6.88243954983998491859e-03,
 7.26720209891677272618e-03,
 7.64684541476874993227e-03,
 8.02123530413159993580e-03,
 8.39024051932213063565e-03,
 8.75373279902990839019e-03,
 9.11158690761618844656e-03,
 9.46368067291306243327e-03,
 9.80989502251233651264e-03,
 1.01501140185368699670e-02,
 1.04842248908878447194e-02,
 1.08121180689596009528e-02,
 1.11336872118183785596e-02,
 1.14488292368375710328e-02,
 1.17574443467867335855e-02,
 1.20594360553697797084e-02,
 1.23547112112087492664e-02,
 1.26431800202723137322e-02,
 1.29247560667452802280e-02,
 1.31993563323394361153e-02,
 1.34669012140451026943e-02,
 1.37273145403230718842e-02,
 1.39805235857388930609e-02,
 1.42264590840399576116e-02,
 1.44650552396788801418e-02,
 1.46962497377853603536e-02,
 1.49199837525900817770e-02,
 1.51362019543059365262e-02,
 1.53448525144697818512e-02,
 1.55458871097522988158e-02,
 1.57392609242401407266e-02,
 1.59249326501989980909e-02,
 1.61028644873237487822e-02,
 1.62730221404839558996e-02,
 1.64353748159745995105e-02,
 1.65898952162792344411e-02,
 1.67365595333573702330e-02,
 1.68753474404654685292e-02,
 1.70062420825228405308e-02,
 1.71292300650343690127e-02,
 1.72443014415816948948e-02,
 1.73514496998961910423e-02,
 1.74506717465267233158e-02,
 1.75419678901157470585e-02,
 1.76253418232991503067e-02,
 1.77008006032431768062e-02,
 1.77683546308354950449e-02,
 1.78280176285450023266e-02,
 1.78798066169677284665e-02,
 1.79237418900749095885e-02,
 1.79598469891815541721e-02,
 1.79881486756524357207e-02,
 1.80086769023645003329e-02,
 1.80214647839439801036e-02,
 1.80265485657978320744e-02,
 1.80239675919585257136e-02,
 1.80137642717629609113e-02,
 1.79959840453853894826e-02,
 1.79706753482452019632e-02,
 1.79378895743111561878e-02,
 1.78976810383233188306e-02,
 1.78501069369546815080e-02,
 1.77952273089348571300e-02,
 1.77331049941585293384e-02,
 1.76638055918014250101e-02,
 1.75873974174670689996e-02,
 1.75039514593883366311e-02,
 1.74135413337067820883e-02,
 1.73162432388551425222e-02,
 1.72121359090659648006e-02,
 1.71013005670323306462e-02,
 1.69838208757447130248e-02,
 1.68597828895295613616e-02,
 1.67292750043147309125e-02,
 1.65923879071472879509e-02,
 1.64492145249898746862e-02,
 1.62998499728209574056e-02,
 1.61443915010654574782e-02,
 1.59829384423819872985e-02,
 1.58155921578329479449e-02,
 1.56424559824643004402e-02,
 1.54636351703211580993e-02,
 1.52792368389266484952e-02,
 1.50893699132506348831e-02,
 1.48941450691946284529e-02,
 1.46936746766213478105e-02,
 1.44880727419542387757e-02,
 1.42774548503756936596e-02,
 1.40619381076500047506e-02,
 1.38416410815988405458e-02,
 1.36166837432563775367e-02,
 1.33871874077307433104e-02,
 1.31532746747999255282e-02,
 1.29150693692685249875e-02,
 1.26726964811125480254e-02,
 1.24262821054400597609e-02,
 1.21759533822933443264e-02,
 1.19218384363212748234e-02,
 1.16640663163469111840e-02,
 1.14027669348586990772e-02,
 1.11380710074510391738e-02,
 1.08701099922405512027e-02,
 1.05990160292857588803e-02,
 1.03249218800347264402e-02,
 1.00479608668283364181e-02,
 9.76826681248407595326e-03,
 9.48597397998680001707e-03,
 9.20121701231205180171e-03,
 8.91413087240663405686e-03,
 8.62485078335300560382e-03,
 8.33351216874106057175e-03,
 8.04025059327335284154e-03,
 7.74520170362733365033e-03,
 7.44850116959968472363e-03,
 7.15028462555652392224e-03,
 6.85068761221313375642e-03,
 6.54984551876693164157e-03,
 6.24789352540736173808e-03,
 5.94496654622468298501e-03,
 5.64119917254172174859e-03,
 5.33672561668945780872e-03,
 5.03167965625017643561e-03,
 4.72619457878821046942e-03,
 4.42040312709122713147e-03,
 4.11443744494245557813e-03,
 3.80842902344421868274e-03,
 3.50250864791438413365e-03,
 3.19680634537424174582e-03,
 2.89145133264915015631e-03,
 2.58657196509964968506e-03,
 2.28229568600325869593e-03,
 1.97874897660506266980e-03,
 1.67605730685465247574e-03,
 1.37434508684857771554e-03,
 1.07373561899400072825e-03,
 7.74351050912206037222e-04,
 4.76312329096932108620e-04,
 1.79739153344913828647e-04,
-1.15250068026150436743e-04,
-4.08538262157430215240e-04,
-7.00009734810518881830e-04,
-9.89550212697529359140e-04,
-1.27704688496522110984e-03,
-1.56238844381914230262e-03,
-1.84546512427596291067e-03,
-2.12616874302977649017e-03,
-2.40439273642179809562e-03,
-2.68003219750039467159e-03,
-2.95298391216083011210e-03,
-3.22314639435426720723e-03,
-3.49041992035452591087e-03,
-3.75470656207426648626e-03,
-4.01591021941965966441e-03,
-4.27393665167596914500e-03,
-4.52869350791463860101e-03,
-4.78009035641408387002e-03,
-5.02803871308742881402e-03,
-5.27245206890878791856e-03,
-5.51324591633307794364e-03,
-5.75033777470175880286e-03,
-5.98364721463032038506e-03,
-6.21309588137129026331e-03,
-6.43860751714846711591e-03,
-6.66010798245885143193e-03,
-6.87752527633716734257e-03,
-7.09078955558135361203e-03,
-7.29983315293484570641e-03,
-7.50459059422442856246e-03,
-7.70499861445137022159e-03,
-7.90099617283428028169e-03,
-8.09252446680348673513e-03,
-8.27952694494581836748e-03,
-8.46194931890021165288e-03,
-8.63973957420479179992e-03,
-8.81284798009584514900e-03,
-8.98122709826090423468e-03,
-9.14483179054685624276e-03,
-9.30361922562642808254e-03,
-9.45754888462495800494e-03,
-9.60658256571109842037e-03,
-9.75068438765514661215e-03,
-9.88982079235872779677e-03,
-1.00239605463608785763e-02,
-1.01530747413246837108e-02,
-1.02771367935108499936e-02,
-1.03961224422430293518e-02,
-1.05100097473716045521e-02,
-1.06187790857425311958e-02,
-1.07224131466778661165e-02,
-1.08208969264758890494e-02,
-1.09142177219381259629e-02,
-1.10023651229317290939e-02,
-1.10853310039956218930e-02,
-1.11631095149994884197e-02,
-1.12356970708646971419e-02,
-1.13030923403568215463e-02,
-1.13652962339602110059e-02,
-1.14223118908440956359e-02,
-1.14741446649318026840e-02,
-1.15208021100836454503e-02,
-1.15622939644049946284e-02,
-1.15986321336910645080e-02,
-1.16298306740207010868e-02,
-1.16559057735113307669e-02,
-1.16768757332475214827e-02,
-1.16927609473963332182e-02,
-1.17035838825226608945e-02,
-1.17093690561177760784e-02,
-1.17101430143551586693e-02,
-1.17059343090872795129e-02,
-1.16967734740980097013e-02,
-1.16826930006248379257e-02,
-1.16637273121658596037e-02,
-1.16399127385864407935e-02,
-1.16112874895409699111e-02,
-1.15778916272246922003e-02,
-1.15397670384720374415e-02,
-1.14969574062164479888e-02,
-1.14495081803284975280e-02,
-1.13974665478479546959e-02,
-1.13408814026266253211e-02,
-1.12798033143984600957e-02,
-1.12142844972935168402e-02,
-1.11443787778127377519e-02,
-1.10701415622809114236e-02,
-1.09916298037944538957e-02,
-1.09089019686816925125e-02,
-1.08220180024931385970e-02,
-1.07310392955389764802e-02,
-1.06360286479915983754e-02,
-1.05370502345710423397e-02,
-1.04341695688310136247e-02,
-1.03274534670632443106e-02,
-1.02169700118386209270e-02,
-1.01027885152025192345e-02,
-9.98497948154308812008e-03,
-9.86361457015006402871e-03,
-9.73876655748246930488e-03,
-9.61050929916365190286e-03,
-9.47891769172138146105e-03,
-9.34406763409175583623e-03,
-9.20603598890469380922e-03,
-9.06490054356958417647e-03,
-8.92073997117914622990e-03,
-8.77363379124968326139e-03,
-8.62366233031589164704e-03,
-8.47090668239862398803e-03,
-8.31544866936306283078e-03,
-8.15737080118616487978e-03,
-7.99675623615058242533e-03,
-7.83368874098351944402e-03,
-7.66825265095798756787e-03,
-7.50053282997436773782e-03,
-7.33061463064018075525e-03,
-7.15858385436481461928e-03,
-6.98452671148786126409e-03,
-6.80852978145714965441e-03,
-6.63067997307481386826e-03,
-6.45106448482760802543e-03,
-6.26977076531890029770e-03,
-6.08688647381931853542e-03,
-5.90249944095203298716e-03,
-5.71669762953000513278e-03,
-5.52956909556100162373e-03,
-5.34120194943696596085e-03,
-5.15168431732329797079e-03,
-4.96110430276443595266e-03,
-4.76954994852103134756e-03,
-4.57710919865432410564e-03,
-4.38386986087277181340e-03,
-4.18991956915663876782e-03,
-3.99534574667439676410e-03,
-3.80023556900675307108e-03,
-3.60467592769156538676e-03,
-3.40875339410503987864e-03,
-3.21255418369197943973e-03,
-3.01616412055992575564e-03,
-2.81966860245005685598e-03,
-2.62315256609809257030e-03,
-2.42670045299875130826e-03,
-2.23039617558575898118e-03,
-2.03432308384080993632e-03,
-1.83856393234277533909e-03,
-1.64320084776991355742e-03,
-1.44831529686655904529e-03,
-1.25398805488530435195e-03,
-1.06029917451672204415e-03,
-8.67327955316482155854e-04,
-6.75152913641518712638e-04,
-4.83851753104545291573e-04,
-2.93501335557769932588e-04,
-1.04177652615230481180e-04,
 8.40442022771478958144e-05,
 2.71090061213828637746e-04,
 4.56886708636217294885e-04,
 6.41361907564611910364e-04,
 8.24444425246958221068e-04,
 1.00606405821750295726e-03,
 1.18615165675600578790e-03,
 1.36463914874257485378e-03,
 1.54145956289825905236e-03,
 1.71654705140769636706e-03,
 1.88983691191461173828e-03,
 2.06126560888645086675e-03,
 2.23077079434063144103e-03,
 2.39829132792830895110e-03,
 2.56376729636941056573e-03,
 2.72714003223500402184e-03,
 2.88835213207216685155e-03,
 3.04734747386685260462e-03,
 3.20407123384176817371e-03,
 3.35846990258462183704e-03,
 3.51049130050470068257e-03,
 3.66008459261367522647e-03,
 3.80720030262936314294e-03,
 3.95179032639856198800e-03,
 4.09380794463911311387e-03,
 4.23320783499702736619e-03,
 4.36994608342004212803e-03,
 4.50398019484403704799e-03,
 4.63526910319382156461e-03,
 4.76377318069614620610e-03,
 4.88945424650618146178e-03,
 5.01227557464674778470e-03,
 5.13220190126144337750e-03,
 5.24919943118207308480e-03,
 5.36323584381190321402e-03,
 5.47428029832571112767e-03,
 5.58230343818897148389e-03,
 5.68727739499729628703e-03,
 5.78917579163970574818e-03,
 5.88797374478673089110e-03,
 5.98364786670789981782e-03,
 6.07617626642060343345e-03,
 6.16553855017385084303e-03,
 6.25171582127166582804e-03,
 6.33469067923863194541e-03,
 6.41444721833308011821e-03,
 6.49097102541174898749e-03,
 6.56424917715103632687e-03,
 6.63427023662958338657e-03,
 6.70102424927795491810e-03,
 6.76450273820044644529e-03,
 6.82469869887525251023e-03,
 6.88160659323871527759e-03,
 6.93522234316026366108e-03,
 6.98554332331408935064e-03,
 7.03256835345506155222e-03,
 7.07629769010476809138e-03,
 7.11673301765615093362e-03,
 7.15387743890304877992e-03,
 7.18773546500291789924e-03,
 7.21831300488032408247e-03,
 7.24561735407938580650e-03,
 7.26965718307318129604e-03,
 7.29044252503875406940e-03,
 7.30798476310635155423e-03,
 7.32229661709144288850e-03,
 7.33339212971884264747e-03,
 7.34128665234775375920e-03,
 7.34599683020745793799e-03,
 7.34754058715258225737e-03,
 7.34593710994830336597e-03,
 7.34120683209452638829e-03,
 7.33337141719967496728e-03,
 7.32245374191355016119e-03,
 7.30847787843014878861e-03,
 7.29146907657012011139e-03,
 7.27145374545387114529e-03,
 7.24845943477565521351e-03,
 7.22251481568945107037e-03,
 7.19364966131744686118e-03,
 7.16189482689201083881e-03,
 7.12728222954231872138e-03,
 7.08984482773655864257e-03,
 7.04961660039112210374e-03,
 7.00663252565801673161e-03,
 6.96092855940177307472e-03,
 6.91254161337735619636e-03,
 6.86150953312070904788e-03,
 6.80787107556324582597e-03,
 6.75166588638215301593e-03,
 6.69293447709806265528e-03,
 6.63171820193170571955e-03,
 6.56805923443159328512e-03,
 6.50200054388410785683e-03,
 6.43358587151825807998e-03,
 6.36285970651646794888e-03,
 6.28986726184373092646e-03,
 6.21465444990643503531e-03,
 6.13726785805332464285e-03,
 6.05775472392990760317e-03,
 5.97616291069856791357e-03,
 5.89254088213594148099e-03,
 5.80693767761965816410e-03,
 5.71940288701587758180e-03,
 5.62998662548002196115e-03,
 5.53873950818146131014e-03,
 5.44571262496510149348e-03,
 5.35095751496040238082e-03,
 5.25452614115022934027e-03,
 5.15647086491062122543e-03,
 5.05684442053339500839e-03,
 4.95569988974256699088e-03,
 4.85309067621648645985e-03,
 4.74907048012647350216e-03,
 4.64369327270371719946e-03,
 4.53701327084515566163e-03,
 4.42908491176951992635e-03,
 4.31996282773485212186e-03,
 4.20970182082771107734e-03,
 4.09835683783572966160e-03,
 3.98598294521311340144e-03,
 3.87263530415101094040e-03,
 3.75836914576165720403e-03,
 3.64323974638825019007e-03,
 3.52730240304928790995e-03,
 3.41061240902878646739e-03,
 3.29322502962129748730e-03,
 3.17519547804233142826e-03,
 3.05657889151338601694e-03,
 2.93743030753160130203e-03,
 2.81780464033296821486e-03,
 2.69775665755896121301e-03,
 2.57734095713514719389e-03,
 2.45661194437134461702e-03,
 2.33562380929147129019e-03,
 2.21443050420279223534e-03,
 2.09308572151161147862e-03,
 1.97164287179554201940e-03,
 1.85015506213867531038e-03,
 1.72867507473943343883e-03,
 1.60725534579748128607e-03,
 1.48594794468843234732e-03,
 1.36480455343317803527e-03,
 1.24387644646943291808e-03,
 1.12321447073277739387e-03,
 1.00286902605367005473e-03,
 8.82890045877847201225e-04,
 7.63326978315998568199e-04,
 6.44228767529792380013e-04,
 5.25643835459782418976e-04,
 4.07620063901896608968e-04,
 2.90204776937506045247e-04,
 1.73444723723805766706e-04,
 5.73860616484244659592e-05,
-5.79256601447129809831e-05,
-1.72445516855139978872e-04,
-2.86129223744603178401e-04,
-3.98933151471683798521e-04,
-5.10814341036775051638e-04,
-6.21730518333987194034e-04,
-7.31640108305292775383e-04,
-8.40502248693749103720e-04,
-9.48276803391555388537e-04,
-1.05492437538016840815e-03,
-1.16040631925863960139e-03,
-1.26468475335793167046e-03,
-1.36772257143744795961e-03,
-1.46948345396231690001e-03,
-1.56993187895820992227e-03,
-1.66903313244173671925e-03,
-1.76675331842487395514e-03,
-1.86305936849075486246e-03,
-1.95791905094055886799e-03,
-2.05130097950870097026e-03,
-2.14317462164644121497e-03,
-2.23351030637205421117e-03,
-2.32227923168745655630e-03,
-2.40945347156019864382e-03,
-2.49500598247101752769e-03,
-2.57891060952624437755e-03,
-2.66114209213571661222e-03,
-2.74167606925580006200e-03,
-2.82048908419860059130e-03,
-2.89755858900738426376e-03,
-2.97286294839969704451e-03,
-3.04638144327833843006e-03,
-3.11809427381250833106e-03,
-3.18798256208930414976e-03,
-3.25602835433819615824e-03,
-3.32221462272949338845e-03,
-3.38652526674922864716e-03,
-3.44894511415224942069e-03,
-3.50945992149601917673e-03,
-3.56805637425754813494e-03,
-3.62472208653601482564e-03,
-3.67944560034401835918e-03,
-3.73221638449032109761e-03,
-3.78302483305743104600e-03,
-3.83186226347697993233e-03,
-3.87872091420681094562e-03,
-3.92359394201303914723e-03,
-3.96647541886111301701e-03,
-4.00736032841956212047e-03,
-4.04624456218095809173e-03,
-4.08312491520368761599e-03,
-4.11799908147960237043e-03,
-4.15086564893147550587e-03,
-4.18172409404541419592e-03,
-4.21057477614258761356e-03,
-4.23741893129556731340e-03,
-4.26225866589410255086e-03,
-4.28509694986558761776e-03,
-4.30593760955555893838e-03,
-4.32478532027361865092e-03,
-4.34164559851025946141e-03,
-4.35652479383043678834e-03,
-4.36943008044940375129e-03,
-4.38036944849687272935e-03,
-4.38935169497548655082e-03,
-4.39638641441941844384e-03,
-4.40148398925969356471e-03,
-4.40465557990201740657e-03,
-4.40591311452397972614e-03,
-4.40526927859759102890e-03,
-4.40273750414399336200e-03,
-4.39833195872687317957e-03,
-4.39206753419116562726e-03,
-4.38395983515392842489e-03,
-4.37402516725410826781e-03,
-4.36228052516814471251e-03,
-4.34874358039834783829e-03,
-4.33343266884099378305e-03,
-4.31636677814128347924e-03,
-4.29756553484226828249e-03,
-4.27704919133478460302e-03,
-4.25483861261575103258e-03,
-4.23095526286197242544e-03,
-4.20542119182673330285e-03,
-4.17825902106652539991e-03,
-4.14949193000528453179e-03,
-4.11914364184333848390e-03,
-4.08723840931864319803e-03,
-4.05380100032764340012e-03,
-4.01885668341308427420e-03,
-3.98243121312639048598e-03,
-3.94455081527187324114e-03,
-3.90524217204034265055e-03,
-3.86453240703949710971e-03,
-3.82244907022857112119e-03,
-3.77902012276458334344e-03,
-3.73427392176791782957e-03,
-3.68823920501411533363e-03,
-3.64094507555994461798e-03,
-3.59242098631046497328e-03,
-3.54269672453505143905e-03,
-3.49180239633924225512e-03,
-3.43976841109999795926e-03,
-3.38662546587152699790e-03,
-3.33240452976901182711e-03,
-3.27713682833726460339e-03,
-3.22085382791172753977e-03,
-3.16358721997866921757e-03,
-3.10536890554190866259e-03,
-3.04623097950279270868e-03,
-2.98620571506079835605e-03,
-2.92532554814109750294e-03,
-2.86362306185669341502e-03,
-2.80113097101106212072e-03,
-2.73788210664884781517e-03,
-2.67390940066071719841e-03,
-2.60924587044905360173e-03,
-2.54392460366138209102e-03,
-2.47797874299740972931e-03,
-2.41144147109654920225e-03,
-2.34434599551184728525e-03,
-2.27672553377682423265e-03,
-2.20861329857108918892e-03,
-2.14004248299099744321e-03,
-2.07104624593109319652e-03,
-2.00165769758243626206e-03,
-1.93190988505322330110e-03,
-1.86183577811795423693e-03,
-1.79146825509988766485e-03,
-1.72084008889326943795e-03,
-1.64998393312966343087e-03,
-1.57893230849462818527e-03,
-1.50771758919912264932e-03,
-1.43637198961127387532e-03,
-1.36492755105304883201e-03,
-1.29341612876705033125e-03,
-1.22186937905778840625e-03,
-1.15031874661246304344e-03,
-1.07879545200534983015e-03,
-1.00733047939059738862e-03,
-9.35954564387392199190e-04,
-8.64698182161781326270e-04,
-7.93591535709335898878e-04,
-7.22664544342259342231e-04,
-6.51946832385152269008e-04,
-5.81467718082645003419e-04,
-5.11256202723101406751e-04,
-4.41340959980976682391e-04,
-3.71750325482115011495e-04,
-3.02512286594312090893e-04,
-2.33654472446860898751e-04,
-1.65204144181543805632e-04,
-9.71881854382950145007e-05,
-2.96330930778333087529e-05,
 3.74350318557888840534e-05,
 1.03990492930665522531e-04,
 1.70008006877860913661e-04,
 2.35462711895771908792e-04,
 3.00330175705594570618e-04,
 3.64586403356421419591e-04,
 4.28207844777551787079e-04,
 4.91171402077186748311e-04,
 5.53454436585029511952e-04,
 6.15034775638214118408e-04,
 6.75890719108685204992e-04,
 7.36001045671158494674e-04,
 7.95345018810736208159e-04,
 8.53902392568785988461e-04,
 9.11653417026953884206e-04,
 9.68578843528107927274e-04,
 1.02465992963409239201e-03,
 1.07987844381954517861e-03,
 1.13421666990184857697e-03,
 1.18765741120669863183e-03,
 1.24018399446962118877e-03,
 1.29178027347317181048e-03,
 1.34243063242041153760e-03,
 1.39211998904448393775e-03,
 1.44083379745542361494e-03,
 1.48855805072399061464e-03,
 1.53527928320389963832e-03,
 1.58098457259274222282e-03,
 1.62566154173287799080e-03,
 1.66929836015300469068e-03,
 1.71188374535185877309e-03,
 1.75340696382495094506e-03,
 1.79385783183615881223e-03,
 1.83322671593499951850e-03,
 1.87150453322187351919e-03,
 1.90868275136241117781e-03,
 1.94475338835288632730e-03,
 1.97970901203875114180e-03,
 2.01354273938795765367e-03,
 2.04624823552140497340e-03,
 2.07781971250251560127e-03,
 2.10825192788842950831e-03,
 2.13754018304492627786e-03,
 2.16568032122775241954e-03,
 2.19266872543273649843e-03,
 2.21850231601753312277e-03,
 2.24317854809751244041e-03,
 2.26669540871874157159e-03,
 2.28905141381085521987e-03,
 2.31024560492300908704e-03,
 2.33027754574556848419e-03,
 2.34914731842113299123e-03,
 2.36685551964774167771e-03,
 2.38340325657774047483e-03,
 2.39879214251553785076e-03,
 2.41302429241780800814e-03,
 2.42610231819949092105e-03,
 2.43802932384921434983e-03,
 2.44880890035772524199e-03,
 2.45844512046309356806e-03,
 2.46694253321619750424e-03,
 2.47430615837057783779e-03,
 2.48054148060029584083e-03,
 2.48565444354972896537e-03,
 2.48965144371932805070e-03,
 2.49253932419119233338e-03,
 2.49432536819870756192e-03,
 2.49501729254406187306e-03,
 2.49462324086802481049e-03,
 2.49315177677595679884e-03,
 2.49061187682437026880e-03,
 2.48701292337218105022e-03,
 2.48236469730101589823e-03,
 2.47667737060877201499e-03,
 2.46996149888082565729e-03,
 2.46222801364318543901e-03,
 2.45348821460201170497e-03,
 2.44375376177385136151e-03,
 2.43303666751100867299e-03,
 2.42134928842652587602e-03,
 2.40870431722312039469e-03,
 2.39511477443066006163e-03,
 2.38059400005651662299e-03,
 2.36515564515335941637e-03,
 2.34881366330883401689e-03,
 2.33158230206161314751e-03,
 2.31347609424828503169e-03,
 2.29450984928561332182e-03,
 2.27469864439260342423e-03,
 2.25405781575686164908e-03,
 2.23260294964972971082e-03,
 2.21034987349466626252e-03,
 2.18731464689328946802e-03,
 2.16351355261355186160e-03,
 2.13896308754443764677e-03,
 2.11367995362164717843e-03,
 2.08768104872860673846e-03,
 2.06098345757712827012e-03,
 2.03360444257223585765e-03,
 2.00556143466523338278e-03,
 1.97687202419953838434e-03,
 1.94755395175337346625e-03,
 1.91762509898370150235e-03,
 1.88710347947544372464e-03,
 1.85600722960030926380e-03,
 1.82435459938927956557e-03,
 1.79216394342290039413e-03,
 1.75945371174334418141e-03,
 1.72624244079242210488e-03,
 1.69254874437936271916e-03,
 1.65839130468247841071e-03,
 1.62378886328829906069e-03,
 1.58876021227249563002e-03,
 1.55332418532590395277e-03,
 1.51749964892962602506e-03,
 1.48130549358308134279e-03,
 1.44476062508820820261e-03,
 1.40788395589385340219e-03,
 1.37069439650360901800e-03,
 1.33321084695073701146e-03,
 1.29545218834344489506e-03,
 1.25743727448406820806e-03,
 1.21918492356532437090e-03,
 1.18071390994699786103e-03,
 1.14204295601606406994e-03,
 1.10319072413361980722e-03,
 1.06417580867146756643e-03,
 1.02501672814153568618e-03,
 9.85731917420752321024e-04,
 9.46339720074761028661e-04,
 9.06858380782653099826e-04,
 8.67306037865940180828e-04,
 8.27700715924154601863e-04,
 7.88060318579825755218e-04,
 7.48402621335140681366e-04,
 7.08745264542995573667e-04,
 6.69105746494616255432e-04,
 6.29501416626196083105e-04,
 5.89949468846577432593e-04,
 5.50466934988384673337e-04,
 5.11070678384569518186e-04,
 4.71777387572266644969e-04,
 4.32603570126133903009e-04,
 3.93565546622840108093e-04,
 3.54679444738640930936e-04,
 3.15961193481461178213e-04,
 2.77426517559644606348e-04,
 2.39090931888283949464e-04,
 2.00969736235134577339e-04,
 1.63078010007227617185e-04,
 1.25430607179671989044e-04,
 8.80421513676910678318e-05,
 5.09270310433270975443e-05,
 1.40993948977051206995e-05,
-2.24268526499689963992e-05,
-5.86380557959355767418e-05,
-9.45208115468090933828e-05,
-1.30061973765318488264e-04,
-1.65248657065980185041e-04,
-2.00068240560348736649e-04,
-2.34508371450769772170e-04,
-2.68556968472767403858e-04,
-3.02202225185153135114e-04,
-3.35432613107714699702e-04,
-3.68236884706315019053e-04,
-4.00604076224976460123e-04,
-4.32523510365022737217e-04,
-4.63984798811095579957e-04,
-4.94977844604242624843e-04,
-5.25492844361963827582e-04,
-5.55520290345540247376e-04,
-5.85050972374773735341e-04,
-6.14075979590610184985e-04,
-6.42586702065795259929e-04,
-6.70574832264203037069e-04,
-6.98032366349193725621e-04,
-7.24951605341828033552e-04,
-7.51325156129156322866e-04,
-7.77145932323820387393e-04,
-8.02407154975299293648e-04,
-8.27102353133903219450e-04,
-8.51225364268258727699e-04,
-8.74770334537431802288e-04,
-8.97731718918501797773e-04,
-9.20104281190827605862e-04,
-9.41883093778050233848e-04,
-9.63063537449165905750e-04,
-9.83641300879760935652e-04,
-1.00361238007481306557e-03,
-1.02297307765449128208e-03,
-1.04172000200423238610e-03,
-1.05985006629069969386e-03,
-1.07736048734502422482e-03,
-1.09424878441514257174e-03,
-1.11051277778848088776e-03,
-1.12615058728708443934e-03,
-1.14116063063659394818e-03,
-1.15554162171100749217e-03,
-1.16929256865495575027e-03,
-1.18241277188544584124e-03,
-1.19490182197486941203e-03,
-1.20675959741726535404e-03,
-1.21798626227982297217e-03,
-1.22858226374166065384e-03,
-1.23854832952187280184e-03,
-1.24788546519901061629e-03,
-1.25659495142406364872e-03,
-1.26467834102919943727e-03,
-1.27213745603428412742e-03,
-1.27897438455362244883e-03,
-1.28519147760499177768e-03,
-1.29079134582336268501e-03,
-1.29577685608154116216e-03,
-1.30015112802015094483e-03,
-1.30391753048923449490e-03,
-1.30707967790388737521e-03,
-1.30964142651636395419e-03,
-1.31160687060702277167e-03,
-1.31298033859659005196e-03,
-1.31376638908218385492e-03,
-1.31396980679961724973e-03,
-1.31359559851441281067e-03,
-1.31264898884408520024e-03,
-1.31113541601419526274e-03,
-1.30906052755070225271e-03,
-1.30643017591116055581e-03,
-1.30325041405731484843e-03,
-1.29952749097163636725e-03,
-1.29526784712039586857e-03,
-1.29047810986578645812e-03,
-1.28516508882973415524e-03,
-1.27933577121191956356e-03,
-1.27299731706460124078e-03,
-1.26615705452684046764e-03,
-1.25882247502064623448e-03,
-1.25100122841167137044e-03,
-1.24270111813698665680e-03,
-1.23393009630251375940e-03,
-1.22469625875265661526e-03,
-1.21500784011470538623e-03,
-1.20487320882053006339e-03,
-1.19430086210808427544e-03,
-1.18329942100529298017e-03,
-1.17187762529875026674e-03,
-1.16004432848981092231e-03,
-1.14780849274044756403e-03,
-1.13517918381147498753e-03,
-1.12216556599544479457e-03,
-1.10877689704675665670e-03,
-1.09502252311132830878e-03,
-1.08091187365826806380e-03,
-1.06645445641585442931e-03,
-1.05165985231426076241e-03,
-1.03653771043727446592e-03,
-1.02109774298538512859e-03,
-1.00534972025243104707e-03,
-9.89303465618205854493e-04,
-9.72968850559070386023e-04,
-9.56355789678956110487e-04,
-9.39474235762757228438e-04,
-9.22334174854466432199e-04,
-9.04945621361946477522e-04,
-8.87318613190598128385e-04,
-8.69463206907894578697e-04,
-8.51389472940857513876e-04,
-8.33107490808391681729e-04,
-8.14627344390523211622e-04,
-7.95959117236444131487e-04,
-7.77112887913182157074e-04,
-7.58098725396869001399e-04,
-7.38926684508335205812e-04,
-7.19606801394884719458e-04,
-7.00149089059903611230e-04,
-6.80563532942129469604e-04,
-6.60860086546161931871e-04,
-6.41048667125920334890e-04,
-6.21139151422514545521e-04,
-6.01141371458319205383e-04,
-5.81065110388481308873e-04,
-5.60920098411564179222e-04,
-5.40716008740645473485e-04,
-5.20462453636329636791e-04,
-5.00168980502928035153e-04,
-4.79845068049252442000e-04,
-4.59500122515179752151e-04,
-4.39143473965308969373e-04,
-4.18784372650737749064e-04,
-3.98431985440370181519e-04,
-3.78095392322528038760e-04,
-3.57783582978218623466e-04,
-3.37505453426840712917e-04,
-3.17269802745462131330e-04,
-2.97085329862539673351e-04,
-2.76960630426857884294e-04,
-2.56904193752789059696e-04,
-2.36924399842341755311e-04,
-2.17029516485020210204e-04,
-1.97227696436049984184e-04,
-1.77526974673721080374e-04,
-1.57935265736364822877e-04,
-1.38460361139671443579e-04,
-1.19109926874780676581e-04,
-9.98915009877096604120e-05,
-8.08124912404658787314e-05,
-6.18801728543761411219e-05,
-4.31016863358901726119e-05,
-2.44840353852607290751e-05,
-6.03408488822807525549e-06,
 1.22414410087942923482e-05,
 3.03359607401630166279e-05,
 4.82430370786643698930e-05,
 6.59563788094303331657e-05,
 8.34698423199615796228e-05,
 1.00777433106333784039e-04,
 1.17873307195481496850e-04,
 1.34751772483674884346e-04,
 1.51407289991337552218e-04,
 1.67834475034225882872e-04,
 1.84028098311239825778e-04,
 1.99983086909011169297e-04,
 2.15694525223608961004e-04,
 2.31157655799539194473e-04,
 2.46367880086458945071e-04,
 2.61320759113890506518e-04,
 2.76012014084471178285e-04,
 2.90437526885940853344e-04,
 3.04593340522622661477e-04,
 3.18475659466672001308e-04,
 3.32080849929764377465e-04,
 3.45405440055728798956e-04,
 3.58446120034815369788e-04,
 3.71199742140139986053e-04,
 3.83663320687053425832e-04,
 3.95834031916090828447e-04,
 4.07709213800306149479e-04,
 4.19286365777668133727e-04,
 4.30563148409382728376e-04,
 4.41537382964913725693e-04,
 4.52207050934656925797e-04,
 4.62570293470961546242e-04,
 4.72625410758635230730e-04,
 4.82370861315684551149e-04,
 4.91805261225328150740e-04,
 5.00927383300294468485e-04,
 5.09736156180340470138e-04,
 5.18230663364083014855e-04,
 5.26410142176160977465e-04,
 5.34273982670858136115e-04,
 5.41821726473215733132e-04,
 5.49053065558819199977e-04,
 5.55967840973343140065e-04,
 5.62566041493084596781e-04,
 5.68847802227587348751e-04,
 5.74813403165606124842e-04,
 5.80463267665585255090e-04,
 5.85797960891953992807e-04,
 5.90818188198352634011e-04,
 5.95524793459205619046e-04,
 5.99918757350793364382e-04,
 6.04001195583171897330e-04,
 6.07773357084216074402e-04,
 6.11236622137123529822e-04,
 6.14392500472671181100e-04,
 6.17242629317575641247e-04,
 6.19788771400296852575e-04,
 6.22032812915646266330e-04,
 6.23976761449542352556e-04,
 6.25622743865282679096e-04,
 6.26973004152734866845e-04,
 6.28029901241785953013e-04,
 6.28795906781460817864e-04,
 6.29273602886090081127e-04,
 6.29465679849935955126e-04,
 6.29374933831637162034e-04,
 6.29004264509917614644e-04,
 6.28356672711923979618e-04,
 6.27435258015602670238e-04,
 6.26243216327530610385e-04,
 6.24783837437580067548e-04,
 6.23060502551831571320e-04,
 6.21076681805128117189e-04,
 6.18835931754663313292e-04,
 6.16341892855999597296e-04,
 6.13598286922899423257e-04,
 6.10608914572360016171e-04,
 6.07377652656219848941e-04,
 6.03908451680720608987e-04,
 6.00205333215381750360e-04,
 5.96272387292547546150e-04,
 5.92113769798962869678e-04,
 5.87733699860716260477e-04,
 5.83136457222883410056e-04,
 5.78326379625196070923e-04,
 5.73307860175058681823e-04,
 5.68085344719199331932e-04,
 5.62663329215264671791e-04,
 5.57046357104629347515e-04,
 5.51239016687691835844e-04,
 5.45245938502918582949e-04,
 5.39071792710859535452e-04,
 5.32721286484389919269e-04,
 5.26199161406370888652e-04,
 5.19510190875949965511e-04,
 5.12659177524647379116e-04,
 5.05650950643461694588e-04,
 4.98490363622070692395e-04,
 4.91182291401325650700e-04,
 4.83731627940122419548e-04,
 4.76143283697776802978e-04,
 4.68422183132952726740e-04,
 4.60573262220249240485e-04,
 4.52601465985464203410e-04,
 4.44511746060588389465e-04,
 4.36309058259498746754e-04,
 4.27998360175392566791e-04,
 4.19584608800889610671e-04,
 4.11072758171783069880e-04,
 4.02467757035333936928e-04,
 3.93774546544049656484e-04,
 3.84998057975832470683e-04,
 3.76143210481313700240e-04,
 3.67214908859312392543e-04,
 3.58218041361136620669e-04,
 3.49157477524604336044e-04,
 3.40038066038525694287e-04,
 3.30864632638427479810e-04,
 3.21641978034209344382e-04,
 3.12374875870502510550e-04,
 3.03068070720368721877e-04,
 2.93726276113044930307e-04,
 2.84354172596324122988e-04,
 2.74956405834251703824e-04,
 2.65537584740686090270e-04,
 2.56102279649332684359e-04,
 2.46655020520732712157e-04,
 2.37200295186851598233e-04,
 2.27742547633623577692e-04,
 2.18286176322046336163e-04,
 2.08835532548216017655e-04,
 1.99394918842769620351e-04,
 1.89968587410093434423e-04,
 1.80560738607737464008e-04,
 1.71175519466368710516e-04,
 1.61817022250571095152e-04,
 1.52489283060860649410e-04,
 1.43196280477158617963e-04,
 1.33941934244020521144e-04,
 1.24730103997818122337e-04,
 1.15564588036148766046e-04,
 1.06449122129624024050e-04,
 9.73873783762444747338e-05,
 8.83829640984437603628e-05,
 7.94394207830501368397e-05,
 7.05602230641164422306e-05,
 6.17487777488439845697e-05,
 5.30084228865277819307e-05,
 4.43424268807018922721e-05,
 3.57539876443504868529e-05,
 2.72462317982963840894e-05,
 1.88222139126731892130e-05,
 1.04849157914673770899e-05,
 2.23724580001398245952e-06,
-5.91796176458841909860e-06,
-1.39779472603022615363e-05,
-2.19400262443108254274e-05,
-2.98015899747312779436e-05,
-3.75601058699388188874e-05,
-4.52131179258346812058e-05,
-5.27582470911579511194e-05,
-6.01931916011169823111e-05,
-6.75157272696155086192e-05,
-7.47237077402686759994e-05,
-8.18150646965978259242e-05,
-8.87878080315813176041e-05,
-9.56400259770174112402e-05,
-1.02369885192932295447e-04,
-1.08975630817447491838e-04,
-1.15455586477445233109e-04,
-1.21808154260462635915e-04,
-1.28031814648165977134e-04,
-1.34125126411867404445e-04,
-1.40086726470483718130e-04,
-1.45915329711446663599e-04,
-1.51609728774925367391e-04,
-1.57168793801964925671e-04,
-1.62591472146915872604e-04,
-1.67876788054762332352e-04,
-1.73023842303760092562e-04,
-1.78031811814023872061e-04,
-1.82899949222519527144e-04,
-1.87627582425063416539e-04,
-1.92214114085866635134e-04,
-1.96659021115234305434e-04,
-2.00961854115964548605e-04,
-2.05122236799067813760e-04,
-2.09139865369424642018e-04,
-2.13014507881963919287e-04,
-2.16746003569016719827e-04,
-2.20334262139455170628e-04,
-2.23779263050288623272e-04,
-2.27081054751326671731e-04,
-2.30239753903598189230e-04,
-2.33255544572162539776e-04,
-2.36128677394024743099e-04,
-2.38859468721759089912e-04,
-2.41448299743606627134e-04,
-2.43895615580664562507e-04,
-2.46201924361897988517e-04,
-2.48367796277648787261e-04,
-2.50393862612362249915e-04,
-2.52280814757210175570e-04,
-2.54029403203337271477e-04,
-2.55640436516424906718e-04,
-2.57114780293308988878e-04,
-2.58453356101321892260e-04,
-2.59657140401130335366e-04,
-2.60727163453730896234e-04,
-2.61664508212373382850e-04,
-2.62470309200077975623e-04,
-2.63145751373508769710e-04,
-2.63692068973905575490e-04,
-2.64110544365773612825e-04,
-2.64402506864084673854e-04,
-2.64569331550674807438e-04,
-2.64612438080565591254e-04,
-2.64533289478916812908e-04,
-2.64333390929326621406e-04,
-2.64014288554176887285e-04,
-2.63577568187730454374e-04,
-2.63024854142685936189e-04,
-2.62357807970878796362e-04,
-2.61578127218826830911e-04,
-2.60687544178804346540e-04,
-2.59687824636131118095e-04,
-2.58580766613355161020e-04,
-2.57368199111998000473e-04,
-2.56051980852535184582e-04,
-2.54633999013272917245e-04,
-2.53116167968770410229e-04,
-2.51500428028467203686e-04,
-2.49788744176148520739e-04,
-2.47983104810888498049e-04,
-2.46085520490098991209e-04,
-2.44098022675305284133e-04,
-2.42022662481256641692e-04,
-2.39861509428983846149e-04,
-2.37616650203396260988e-04,
-2.35290187416002671578e-04,
-2.32884238373345356290e-04,
-2.30400933851706944807e-04,
-2.27842416878660760553e-04,
-2.25210841522004905167e-04,
-2.22508371686640725982e-04,
-2.19737179919906623887e-04,
-2.16899446225907947382e-04,
-2.13997356889345798732e-04,
-2.11033103309352538255e-04,
-2.08008880843819519632e-04,
-2.04926887664708660573e-04,
-2.01789323624807442155e-04,
-1.98598389136399967663e-04,
-1.95356284062287273917e-04,
-1.92065206619610498147e-04,
-1.88727352296894345393e-04,
-1.85344912784731391314e-04,
-1.81920074920499755819e-04,
-1.78455019647530454055e-04,
-1.74951920989073971512e-04,
-1.71412945037461607323e-04,
-1.67840248958807175192e-04,
-1.64235980013589989322e-04,
-1.60602274593463965847e-04,
-1.56941257274607583660e-04,
-1.53255039887926981963e-04,
-1.49545720606400077326e-04,
-1.45815383049865629223e-04,
-1.42066095407511174204e-04,
-1.38299909578337953649e-04,
-1.34518860329830815736e-04,
-1.30724964475093245915e-04,
-1.26920220068654472992e-04,
-1.23106605621173758290e-04,
-1.19286079333219134950e-04,
-1.15460578348350841244e-04,
-1.11632018025632952099e-04,
-1.07802291231779830637e-04,
-1.03973267653065606659e-04,
-1.00146793127148565233e-04,
-9.63246889949230804435e-05,
-9.25087514725346873358e-05,
-8.87007510436452450671e-05,
-8.49024318720545515026e-05,
-8.11155112347393549661e-05,
-7.73416789754019609908e-05,
-7.35825969785674924512e-05,
-6.98398986642887023612e-05,
-6.61151885034750767074e-05,
-6.24100415538899748772e-05,
-5.87260030168200428450e-05,
-5.50645878143974986741e-05,
-5.14272801876128782695e-05,
-4.78155333149380714058e-05,
-4.42307689515766361233e-05,
-4.06743770892715146635e-05,
-3.71477156366324749162e-05,
-3.36521101199027279356e-05,
-3.01888534041130525139e-05,
-2.67592054345224943665e-05,
-2.33643929982665948157e-05,
-2.00056095060906951114e-05,
-1.66840147940797201324e-05,
-1.34007349452439661363e-05,
-1.01568621308437851693e-05,
-6.95345447128813701427e-06,
-3.79153591650250810366e-06,
-6.72096145553293655593e-07,
 2.40390951459279597616e-06,
 5.43556015137456058426e-06,
 8.42196931017640123499e-06,
 1.13622850193110927676e-05,
 1.42556897966238257746e-05,
 1.71014006379341248229e-05,
 1.98986689875390831126e-05,
 2.26467806909793172563e-05,
 2.53450559303131682314e-05,
 2.79928491421220740245e-05,
 3.05895489185053302676e-05,
 3.31345778912925430443e-05,
 3.56273925997451632237e-05,
 3.80674833419947510364e-05,
 4.04543740105068599521e-05,
 4.27876219118044463113e-05,
 4.50668175707753267513e-05,
 4.72915845198089502860e-05,
 4.94615790730713200283e-05,
 5.15764900862005805371e-05,
 5.36360387017334339240e-05,
 5.56399780805481871900e-05,
 5.75880931196438774090e-05,
 5.94802001565561985590e-05,
 6.13161466607366493955e-05,
 6.30958109121965409621e-05,
 6.48191016677504891876e-05,
 6.64859578151715343739e-05,
 6.80963480156043240521e-05,
 6.96502703345347587470e-05,
 7.11477518616810702089e-05,
 7.25888483201263885920e-05,
 7.39736436650163245096e-05,
 7.53022496721903708853e-05,
 7.65748055170595645635e-05,
 7.77914773440878826866e-05,
 7.89524578272120806021e-05,
 8.00579657215541123884e-05,
 8.11082454067584148567e-05,
 8.21035664223097817662e-05,
 8.30442229951717527346e-05,
 8.39305335600990616227e-05,
 8.47628402729624154692e-05,
 8.55415085174379832356e-05,
 8.62669264054029689666e-05,
 8.69395042713942022743e-05,
 8.75596741614536786501e-05,
 8.81278893167311284636e-05,
 8.86446236521661512422e-05,
 8.91103712306026604075e-05,
 8.95256457326717546962e-05,
 8.98909799227875892661e-05,
 9.02069251115862640782e-05,
 9.04740506151490363976e-05,
 9.06929432113401867103e-05,
 9.08642065935940279782e-05,
 9.09884608224771455898e-05,
 9.10663417753510066833e-05,
 9.10985005944656069544e-05,
 9.10856031337957275460e-05,
 9.10283294049456589850e-05,
 9.09273730224310103125e-05,
 9.07834406486567112131e-05,
 9.05972514388884682737e-05,
 9.03695364865346147717e-05,
 9.01010382690298824038e-05,
 8.97925100946232214449e-05,
 8.94447155503604388049e-05,
 8.90584279515538464710e-05,
 8.86344297930203114553e-05,
 8.81735122023717546660e-05,
 8.76764743956322256668e-05,
 8.71441231354561004216e-05,
 8.65772721922116491981e-05,
 8.59767418081955635050e-05,
 8.53433581652348287718e-05,
 8.46779528559294970011e-05,
 8.39813623587842351167e-05,
 8.32544275174723505482e-05,
 8.24979930244696123580e-05,
 8.17129069092911340059e-05,
 8.09000200315580515319e-05,
 8.00601855791177764851e-05,
 7.91942585714318722121e-05,
 7.83030953684469709260e-05,
 7.73875531851490379041e-05,
 7.64484896120066966278e-05,
 7.54867621414943666810e-05,
 7.45032277008856680736e-05,
 7.34987421914997258445e-05,
 7.24741600345781298914e-05,
 7.14303337239639759421e-05,
 7.03681133857495075701e-05,
 6.92883463450485250238e-05,
 6.81918767000556897513e-05,
 6.70795449035298084342e-05,
 6.59521873518545653477e-05,
 6.48106359818019012913e-05,
 6.36557178751403541801e-05,
 6.24882548712000070136e-05,
 6.13090631875229413088e-05,
 6.01189530487050480105e-05,
 5.89187283235398522627e-05,
 5.77091861705600261078e-05,
 5.64911166920768371556e-05,
 5.52653025968012133018e-05,
 5.40325188711331935503e-05,
 5.27935324591918643858e-05,
 5.15491019516612150597e-05,
 5.02999772835162253098e-05,
 4.90468994406823114189e-05,
 4.77906001756943685883e-05,
 4.65318017323872241855e-05,
 4.52712165796745444508e-05,
 4.40095471544385224527e-05,
 4.27474856135762158195e-05,
 4.14857135952114382585e-05,
 4.02249019891050019768e-05,
 3.89657107162695045101e-05,
 3.77087885178019617646e-05,
 3.64547727529321324196e-05,
 3.52042892062907349744e-05,
 3.39579519043854685862e-05,
 3.27163629412759540162e-05,
 3.14801123134230239524e-05,
 3.02497777637023744978e-05,
 2.90259246345387218443e-05,
 2.78091057301432964695e-05,
 2.65998611878025348972e-05,
 2.53987183581919854364e-05,
 2.42061916946511448772e-05,
 2.30227826513813061706e-05,
 2.18489795905047869758e-05,
 2.06852576979222047276e-05,
 1.95320789079097866306e-05,
 1.83898918363816234168e-05,
 1.72591317227478167385e-05,
 1.61402203802856600485e-05,
 1.50335661549492530784e-05,
 1.39395638925266073790e-05,
 1.28585949140593193966e-05,
 1.17910269994264146578e-05,
 1.07372143790027249535e-05,
 9.69749773328629209753e-06,
 8.67220420039572420566e-06,
 7.66164739132314657512e-06,
 6.66612741284622437347e-06,
 5.68593089796976951548e-06,
 4.72133104379410701050e-06,
 3.77258765668374723169e-06,
 2.83994720461857994069e-06,
 1.92364287659795633360e-06,
 1.02389464897677183691e-06,
 1.40909358598783243636e-07,
-7.25119217400925882488e-07,
-1.57401027526573751796e-06,
-2.40559589188401177682e-06,
-3.21972092580435969379e-06,
-4.01624291213239929447e-06,
-4.79503195145223449727e-06,
-5.55597059291959898474e-06,
-6.29895371166915398527e-06,
-7.02388838068995278969e-06,
-7.73069373730662337714e-06,
-8.41930084443043260571e-06,
-9.08965254672049638874e-06,
-9.74170332181420186798e-06,
-1.03754191267770145960e-05,
-1.09907772399306088372e-05,
-1.15877660982095854786e-05,
-1.21663851302071818753e-05,
-1.27266445850638015879e-05,
-1.32685653573596831328e-05,
-1.37921788081646564831e-05,
-1.42975265824070264185e-05,
-1.47846604227169150120e-05,
-1.52536419799077777845e-05,
-1.57045426202454864190e-05,
-1.61374432296745794440e-05,
-1.65524340151509907705e-05,
-1.69496143032443776877e-05,
-1.73290923361651281922e-05,
-1.76909850653765942752e-05,
-1.80354179429455134585e-05,
-1.83625247107888849940e-05,
-1.86724471879742999741e-05,
-1.89653350562250020523e-05,
-1.92413456437866339777e-05,
-1.95006437078064384194e-05,
-1.97434012153796016272e-05,
-1.99697971234102591856e-05,
-2.01800171574394671614e-05,
-2.03742535895865872536e-05,
-2.05527050157544749519e-05,
-2.07155761322383869926e-05,
-2.08630775118898238230e-05,
-2.09954253799722451970e-05,
-2.11128413898529763743e-05,
-2.12155523986690494219e-05,
-2.13037902431062623279e-05,
-2.13777915154254429865e-05,
-2.14377973398712400380e-05,
-2.14840531495946086989e-05,
-2.15168084642204138245e-05,
-2.15363166681862903517e-05,
-2.15428347899803886579e-05,
-2.15366232824005027408e-05,
-2.15179458039577262574e-05,
-2.14870690015422825217e-05,
-2.14442622944694083432e-05,
-2.13897976600211963056e-05,
-2.13239494205938423077e-05,
-2.12469940325636042692e-05,
-2.11592098769767039874e-05,
-2.10608770521689021838e-05,
-2.09522771684173563140e-05,
-2.08336931447246940868e-05,
-2.07054090078323760555e-05,
-2.05677096935581607638e-05,
-2.04208808505498906150e-05,
-2.02652086465450858026e-05,
-2.01009795772225878085e-05,
-1.99284802777307897448e-05,
-1.97479973369733553508e-05,
-1.95598171147313057406e-05,
-1.93642255616965921713e-05,
-1.91615080424908975211e-05,
-1.89519491617392180451e-05,
-1.87358325932659067312e-05,
-1.85134409124775290410e-05,
-1.82850554319945745078e-05,
-1.80509560405904254164e-05,
-1.78114210454942761765e-05,
-1.75667270181107023892e-05,
-1.73171486432067083623e-05,
-1.70629585716134836285e-05,
-1.68044272764881711800e-05,
-1.65418229131769521309e-05,
-1.62754111827191523261e-05,
-1.60054551990284544996e-05,
-1.57322153597849753270e-05,
-1.54559492210684566130e-05,
-1.51769113757617390406e-05,
-1.48953533357483810943e-05,
-1.46115234179280960335e-05,
-1.43256666340692667526e-05,
-1.40380245845161517285e-05,
-1.37488353557644599467e-05,
-1.34583334219182035850e-05,
-1.31667495500361276861e-05,
-1.28743107093750131593e-05,
-1.25812399845332226092e-05,
-1.22877564924967183814e-05,
-1.19940753035859587103e-05,
-1.17004073663007361519e-05,
-1.14069594360560160192e-05,
-1.11139340078022052344e-05,
-1.08215292525168970740e-05,
-1.05299389575568482923e-05,
-1.02393524708539662493e-05,
-9.94995464893742348120e-06,
-9.66192580876271611343e-06,
-9.37544168332491989210e-06,
-9.09067338103246418157e-06,
-8.80778734881422739372e-06,
-8.52694533893248795902e-06,
-8.24830437947059051977e-06,
-7.97201674846333152320e-06,
-7.69822995163491404110e-06,
-7.42708670370925303302e-06,
-7.15872491325360909230e-06,
-6.89327767101633304933e-06,
-6.63087324171573705124e-06,
-6.37163505923899323223e-06,
-6.11568172520321447157e-06,
-5.86312701083429459631e-06,
-5.61407986211404469277e-06,
-5.36864440814655013182e-06,
-5.12691997269171846217e-06,
-4.88900108881444233564e-06,
-4.65497751659457443244e-06,
-4.42493426384305196255e-06,
-4.19895160976678087265e-06,
-3.97710513152554464493e-06,
-3.75946573362158312445e-06,
-3.54609968006129461300e-06,
-3.33706862922910230812e-06,
-3.13242967141053148128e-06,
-2.93223536890220278037e-06,
-2.73653379864365903313e-06,
-2.54536859730841838172e-06,
-2.35877900878616331091e-06,
-2.17679993399191934131e-06,
-1.99946198293410626841e-06,
-1.82679152897453787459e-06,
-1.65881076521146377169e-06,
-1.49553776291791911430e-06,
-1.33698653196547020166e-06,
-1.18316708316432299485e-06,
-1.03408549244911473199e-06,
-8.89743966841013678409e-07,
-7.50140912114827378233e-07,
-6.15271002100918799020e-07,
-4.85125249549975873449e-07,
-3.59691078491283933177e-07,
-2.38952398011216803052e-07,
-1.22889677382464548894e-07,
 0.0	/* Need a final zero coefficient */
}
} ; /* fastest_coeffs */
