package Syntax::Operator::Matches 0.000002;

use v5.38;
use warnings;

use Carp;
use match::simple;

require XSLoader;
XSLoader::load( __PACKAGE__, our $VERSION );

sub import
{
   my $class = shift;
   my $caller = caller;

   $class->import_into( $caller, @_ );
}

sub import_into
{
   my $class = shift;
   my ( $caller, @syms ) = @_;

   @syms or @syms = qw( matches );

   my %syms = map { $_ => 1 } @syms;
   $^H{"Syntax::Operator::Matches/matches"}++ if delete $syms{matches};

   croak "Unrecognised import symbols @{[ keys %syms ]}" if keys %syms;
}

1;
__END__

=head1 NAME

C<Syntax::Operator::Matches> - match::simple but as a real infix operator

=head1 SYNOPSIS

On Perl v5.38 or later:

   use v5.38;
   use Syntax::Operator::Matches;

   if ( $x matches $y ) {
      ...;
   }

=head1 DESCRIPTION

This module implements a C<matches> infix operator for L<match::simple>.

=head1 SEE ALSO

L<match::simple>.

=head1 AUTHOR

Toby Inkster <tobyink@cpan.org>.

