BEGIN {
  use strict; use warnings;
  my %missing = map {
    eval qq{ require $_ };
    $@ ? ($_=>1) : ()
  } qw( Getopt::Long Pod::Usage lib strict warnings );
  if(%missing)
  {
    print "Your Perl is missing core modules: @{[ sort keys %missing ]}\n";
    print "Ideally if you are using the system Perl you can install the appropriate\n";
    print "package which includes the core Perl modules.  On at least some versions\n";
    print "of Fedora, CentOS and RHEL, this is the `perl-core` package.\n";
    print "\n";
    print " % dnf install perl-core\n";
    print "   ~ or ~\n";
    print " % yum install perl-core\n";
    print "\n";
    print "If you really want to install dual-life modules from CPAN, then you can\n";
    print "use cpanm:\n";
    print "\n";
    print " % cpanm @{[ sort keys %missing ]}\n";
    print "\n";
    print "Note that some core modules are not available from CPAN.\n";
    exit;
  }
}
BEGIN {
  use strict; use warnings;
  unless(eval q{ use 5.010; 1}) {
    print "Perl 5.010 or better required\n";
    exit;
  }
}
# This file was automatically generated by Dist::Zilla::Plugin::Author::Plicease::MakeMaker v2.62.
use strict;
use warnings;
use 5.010;
use ExtUtils::MakeMaker;

my %WriteMakefileArgs = (
  "ABSTRACT"           => "Perl WebAssembly command line tool",
  "AUTHOR"             => "Graham Ollis <plicease\@cpan.org>",
  "CONFIGURE_REQUIRES" => {
    "ExtUtils::MakeMaker" => 0
  },
  "DISTNAME"  => "App-plasm",
  "EXE_FILES" => [
    "bin/plasm"
  ],
  "LICENSE"          => "perl",
  "MIN_PERL_VERSION" => "5.010",
  "NAME"             => "App::plasm",
  "PM"               => {
    "lib/App/plasm.pm" => "\$(INST_LIB)/App/plasm.pm"
  },
  "PREREQ_PM" => {
    "Path::Tiny"               => 0,
    "Wasm"                     => "0.08",
    "Wasm::Hook"               => 0,
    "Wasm::Wasmtime"           => "0.08",
    "Wasm::Wasmtime::Wat2Wasm" => 0
  },
  "TEST_REQUIRES" => {
    "Capture::Tiny"         => 0,
    "Test2::API"            => "1.302015",
    "Test2::Tools::Process" => 0,
    "Test2::V0"             => "0.000060",
    "Test::Script"          => 0
  },
  "VERSION" => "0.03",
  "test"    => {
    "TESTS" => "t/*.t"
  }
);

my %FallbackPrereqs = (
  "Capture::Tiny"            => 0,
  "Path::Tiny"               => 0,
  "Test2::API"               => "1.302015",
  "Test2::Tools::Process"    => 0,
  "Test2::V0"                => "0.000060",
  "Test::Script"             => 0,
  "Wasm"                     => "0.08",
  "Wasm::Hook"               => 0,
  "Wasm::Wasmtime"           => "0.08",
  "Wasm::Wasmtime::Wat2Wasm" => 0
);

unless ( eval { ExtUtils::MakeMaker->VERSION(6.63_03) } ) {
  delete $WriteMakefileArgs{TEST_REQUIRES};
  delete $WriteMakefileArgs{BUILD_REQUIRES};
  $WriteMakefileArgs{PREREQ_PM} = \%FallbackPrereqs;
}

delete $WriteMakefileArgs{CONFIGURE_REQUIRES}
  unless eval { ExtUtils::MakeMaker->VERSION(6.52) };

WriteMakefile(%WriteMakefileArgs);