package Pod::ProjectDocs::File;

use strict;
use warnings;

our $VERSION = '0.48_004'; # TRIAL VERSION

use Moose;
use IO::File;

has 'data' => (
    is => 'ro',
);

has 'default_name' => (
    is => 'ro',
    isa => 'Str',
);

has 'is_bin' => (
    is => 'rw',
    default => 0,
);

has 'config' => (
    is => 'ro',
);

has 'name' => (
    is => 'rw',
    isa => 'Str',
);

has 'relpath' => (
    is => 'rw',
    isa => 'Str',
);

sub _get_data {
    my $self = shift;
    return $self->data;
}

sub publish {
    my($self, $data) = @_;
    $data ||= $self->_get_data();
    my $path = $self->get_output_path;
    my $mode = ">>";
    if ( $path =~ m/html$/ ) {
        $mode .= ':encoding(UTF-8)' ;
    }
    my $fh = IO::File->new($path, $mode) or $self->_croak(qq/Can't open $path./);
    $fh->seek(0, 0);
    $fh->truncate(0);
    $fh->print($data);
    $fh->close;
    return;
}

sub get_output_path {
    my $self = shift;
    my $outroot = $self->config->outroot;
    my $relpath = $self->relpath || $self->default_name;
    my $path = File::Spec->catfile($outroot, $relpath);
    return $path;
}

sub _croak {
    my($self, $msg) = @_;
    require Carp;
    Carp::croak($msg);
    return;
}

1;
__END__
