use strict;
use warnings;
use Test::More;
use Digest::JH qw(jh_512 jh_512_hex);

my $len = 0;

while (my $line = <DATA>) {
    chomp $line;
    my ($msg, $digest) = split '\|', $line, 2;
    my $data = pack 'H*', $msg;
    $digest = lc $digest;

    if ($len and not $len % 8) {
        my $md = Digest::JH->new(512)->add($data)->hexdigest;
        is($md, $digest, "new/add/hexdigest: $len bits of $msg");
        is(
            jh_512_hex($data), $digest,
            "jh_512_hex: $len bits of $msg"
        );
        ok(
            jh_512($data) eq pack('H*', $digest),
            "jh_512: $len bits of $msg"
        );
    }

    my $md = Digest::JH->new(512)->add_bits($data, $len)
        ->hexdigest;
    is($md, $digest, "new/add_bits/hexdigest: $len bits of $msg");
}
continue { $len++ }

done_testing;

__DATA__
00|90ecf2f76f9d2c8017d979ad5ab96b87d58fc8fc4b83060f3f900774faa2c8fabe69c5f4ff1ec2b61d6b316941cedee117fb04b1f4c5bc1b919ae841c50eec4f
00|0c6cc1fe8edf03ad639cbbe90f796a4f9bf196eac21d3c9f1e44fc02f60d6f516a0c3a5bf636223c9afb2ef49ddcccbe2431e965b413088712e2f40662eb466e
C0|22cb8ee605509c9bacf7eab397490955e50fd4e9776856971d0c1ef1e348ba2a3b9846a011bab13fcc0ddd2bfc0ed597e2765e2cbb6964c6ca82c3db14b69a9e
C0|54ba5bf276553988a6204bb47ef7d9600d6b8936e29bb6be8b6fffc3f74518901e0e4d6849743bdc777b394d96fd9e285ec92873348646517fec30b02fad60e3
80|5d05c41d006f9cb9645afc9c64e20914756f88e3d1e2d5f791953cbce7473f2fde84bbc2ddc72dc0fbadf9e9b09747e252c7e28d662821dc36e01781d20cae30
48|737e967515a170e5e7d142cf73a2bea88432ef40b4a3a17f97cca92b40b1af3b30dce5379196ae55764aaaa7db18bb30603299eced8ae657cc97ff6d4f495be3
50|befd7de5137e8e29412da5d9e033c9f397b352a3be98a9216dcb52b8cd983277b537c525ceccc6ea37159f9b25a06006cfa9ef81de0ee17d9432494f0d5236b7
98|e5b38ae3b8e0c18ef56624dd5029da7ad900b324cd6bea91fd8ad03dd07ed7b56487ab8055bfaf7d9e5941fa369ebc68c1ced103ae5ca4aab8778e99aace96c6
CC|277c93806945992a7f10102f28471af2783fe32003b3f63320810e74f1bc233bf8669ab4b922db9ef13fcdcd4d31193b731eedde98fc87c129c04a4a1071f66f
9800|918ba65ea8594d2168141282dd229e77f6ffc2f97f7636b1119d4214f72803143c2c0a44aa39c1f8887870173fde94b4525cecaf97d1a4cfb5c33bc85f74ad24
9D40|b7242fde185cee215731584005367de04e37fdf6e5ec62a80cf3065ee298963be0ebe32ccedf6ab8e1acf7064dc447f1d1d4de21befb50cecb7629eeca404a7b
AA80|73f10bb97b3e107773b2cf4c3b18aa2e2c65a3c9cb5f9783093cb561d00944f6f0fb4e2cc68e98af805eaa72f69955cdae7aeb09ede01b8e7054d38c20f43c1d
9830|7b7b41ca7d41dae48d2848cdef66f3fcc5366cd17de579b26d61805eb182d1225ef6c3de5870755f4378ace7680445edb928a26e9fe8569c37ed5bb27c354056
5030|f56b50bdb0091240fe62d91d68b88cc761e509f322f842d68730819d8924d6c5728cef119766142c786fd510159e220cf09e6d58fbe243b671816ea4c4575f8e
4D24|01f44f68be01fa58feab13309c1b617132cc0eacbca72613f316dbffcc86d9979123afe52ab5e3d8f6409c03cc9ff102aeb285cbe0c66c6334fecd2af9a1c28a
CBDE|55e97311dd5d3862871f2a841bb95c8668f155d4914ce8e358cc6bade92f673aba54524239bfb2267b028e45dcbdcf4123fce011a5685ed190b58fddfb8e54d8
41FB|5d80be996ba553a0c68fd539ff3859ced2d1fa627afadde83464a9f67cab6d66a32749b5228482a5f4a11332d62974547cb8ff90eba9ddf03272f873457563f0
4FF400|1bc870ca2a606ef710b6311cb12897007b39942b9d9ad88101f4ffd2a32c60f8e627357f058e61e786b0a11875daa43f6ff8cb6a2a33c8b8ecdb3e20d9c738a4
FD0440|039c98e7dc8f9a44450bdb59293fcd3279f360210d17d3bca3dbe13f4b13a3e650956170841a34d778a10d8a2538ca7b513ee8404c0fea6c7694e917de8ecc7e
424D00|819993b1cff2e00e9dd943b1ddb9ac853b75f0dbfa1ff7c245ab957afc7e374ca4b1fb0bfb1420746671211f4290ec2368dd194add48819ed966090ad536748e
3FDEE0|a4708f69a2f2a49c3d4043bb1cf8e598d1135d74022b141aa692de62f8df6cc384be759808fcf0e3de7b0246a030298180d3ae2d7ea5853d3b46501b58f2de10
335768|8a7b3c05a869db6b3e4cd5ac5d1d50c1aec5ecfe23247adf2c00f28eaab6bceb982225f2c281f2bf12e2213538fc8ecd0bba1a689ea54b728b766890a1754cae
051E7C|7314b3f7aa6799379493ebd498d1d0fbbcb936cc2a21ca82f22cff01c609fb8c4e93e4f0e72a873c44378bac120a36b644461bcb8a08a0b6d9222dcec7756ff0
717F8C|111946280c8122816fe0e2228324a213b30602b421c2061a10cadcdd0f93fc479c3ead5911241df7c4bf7354d83654bc6f8e9ac5d6a8612242833f185a755b16
1F877C|fd745541f728856a4fe34d53ec2b17a03c9b83c321ea69e708c354198821aafd98ef2062b566308374763a55aa0291f99a42d9cdbe36952ff58d00a689c2e6a9
EB35CF80|c2eec383de341f435c33922b51b7605f0939f0537b79da02d7bd515d81589aa2dd74b52ea548be80bc43ddbd44663705108593b3ba57c13388405401070c1cb2
B406C480|6fc16a85a5f1c38e91db19b67b8ad2107b30ee946d02c2b2971c98821f06fbe3f8953769517a311794b37f47071de0634eaf387d589ae560a158955bdeafdcbd
CEE88040|bfb63ff89b22f54865862298982fbf838bbe14b9f370fc4492a63b77cf40138962e439194356195da63f4dbe73384020f968bd8e3be15537145fd7a5d511ceda
C584DB70|6476fe4afe5dbe65b21f68609ca0dd6819b2da0296dd8fa09b8dcbf6d50fa0002e6f77b4261d57deafcedbf317af84e927bd75acb0adabec114f57809413c7f5
53587BC8|1d1a3aabdca922c654184785b07d1ac7c0fd38bc177910e770e8a571d187a03c66a2a587fd8fd07a41477d9423a9f787098cd7381d0b3851a1576da4c6bee1bd
69A305B0|c5560f6061a84f7943db36dff6f57cfbb9dde50b7523408346f4a8371ef9b841f0bbfb44cb69d922be6aafa13d6d21d635b2182fed3eb4465a639dcf1bb6f388
C9375ECE|b6dc956b0df330195be156a6e55a3b7af321df6ab16e813293dadbf1d9f2d0c491d427758ae32b49cfceef24484e2fc755730b22848f0a9d6a483822b4c0d096
C1ECFDFC|6027c238eb7b1d60b64b72ea11713c52db49fbe9582b6fe9383d0d6f9d120ed85710c2fce6ff2d5a173c5ae7766ed286c0896330df7f308638dab6fc915fc86b
8D73E8A280|e19797ee65ed79c1cea17a9fb1a1420e55628d92ef8b1ef641f65d223a2abc0b96371957c1534a7f4fc587398fb409d9efeef57a4e5ebfb4b06573606c94e451
06F2522080|b17a2d8d00e5947718d25401c2b7c0ab719541097fd9786bc15e9b6834e1eeb01cbbb1a96143804ea01b6b91e4cd54802cd163c12037d20110e417d27f0d8236
3EF6C36F20|154dfdff1c3068f3f3673171da657a9677f1d765c25622d3a868d8c22294fd3d2fb131635661d686ed029a85943f055a8bc24d1403aff9308bc3ddf18cd3ccd3
0127A1D340|5e6b42fdbe823bae37a3ef84dea1620d60f040af66b9339b92a8eabdf3f622e3ac9de128dc344bdac43d95a31a37cf08c0b5076288bd007407760bee473f45ec
6A6AB6C210|1265a5d5d5eecb1af722d9843cae355efaa8ccf5825436c46ad111ad054ec7010f083211d9bf2e45cb3101bf22b6747eed96f297929c19b6b46cd3b800f738a8
AF3175E160|5c2a35e1853e06c0f1feeb107aa7dadf5d10e7d41d6dcf56e008f561ff51961fed5923dcf84c96a0da0557a796d21cc7e7888b7853a2d49120cac69cde18ca9e
B66609ED86|79dce28cfd1db00c9a8711a1ece013620e9c6b89c518533f6a44c4bfe77ec77f1a389d17f0e6226100b5253fe2832d1cc8aae1385fb1445674e15e6f6e833587
21F134AC57|e334b2946942583370ce0b840d31752f35de5087f5ab3405872087b496db14c8cdc2c138b3a26a3191d7b9134dd5acf8ebcfea0d2bded060ed3290a4a33fc3fc
3DC2AADFFC80|b3479bd2d5b6bec1f8b1b38e383b99812fa0e8ccf1048aafad7bee45ef207f7d86e060a1cbbef5161563a9a3c5f974caa1c7963d6d52417a3a69283ce2e5c64c
9202736D2240|c7f4e9530ea7f370eb1268c2bc56b1b0b2ef8bfeee1156573647031d85ecf5643e8253b578da25916bff1c61e74635a4fd03c29d5bf1e74a5055ee500c9d1a26
F219BD629820|a98682707b4c25430fd5a1408ffc1d152ff784f5e66c680fe336319bd9fff4b839484b75fe71aae5daf4c53397119ea2b3fbe1689025c48e6b9f02c6b729688e
F3511EE2C4B0|63a83313b4ce817236728678269f326b85aa43cfa6e1cacb3f163a88e41241308dd55674f23b92886b806a3869396b13e2ade444d831533858edbb575c17f52d
3ECAB6BF7720|26e2ec76fb3fe48ddb545e01c81bfebc708da91ba74b9b07d54eaf64246445be5249bc05dc07c318f09b4da83a99bd12ebdca6e01a966817ac4a6fa75fe45511
CD62F688F498|27205c6d3b3d398e8f6e5ed8881c750afe84f83cf10a33884c64b50727b6b288b8295d8211d038fccb3ea3a2c6bd9aa3477302d4314c322b5ec64c856646f309
C2CBAA33A9F8|7a1853f5249da94dfdc463161e20d3943abc4eb1520a11101358a3f446a1aae08665f9af017e73af4cc6761063511778d658f3499affb27094644542617a4eb7
C6F50BB74E29|f30360b24e1a66fe2fab043779a2fc0313069b55ee2d763e7fd125368befa27059acc55b1ae016881df31faed7e758c03d9a77863f98f1290f64cbdea25c0a36
79F1B4CCC62A00|ffad6ae1111361244d21abc37317a0d1d6f3d8b10a1ba8966be572405492e03ef357f78485df1fa6944395af97d6353846a7b921e61250c787b3063f45be11ab
