package Mail::Milter::Authentication::HTDocs;
use strict;
use warnings;
our $VERSION = '2.20180608'; # VERSION

## TODO a better way to do this
my @whitelist = qw{ /css/normalize.css /css/skeleton.css /css/authmilter.css };

sub get_file {
    my ( $self, $file ) = @_;

    my $whitelisted = grep { $_ eq $file } @whitelist;
    return if ! $whitelisted;

    my $basefile = __FILE__;
    $basefile =~ s/HTDocs\.pm$/htdocs/;
    $basefile .= $file;
    if ( ! -e $basefile ) {
        return;
    }
    open my $InF, '<', $basefile;
    my @Content = <$InF>;
    close $InF;
    return join( q{}, @Content );
}

sub new {
    my ( $class ) = @_;
    my $self = {};
    bless $self, $class;
    return $self;
}

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Mail::Milter::Authentication::HTDocs

=head1 VERSION

version 2.20180608

=head1 AUTHOR

Marc Bradshaw <marc@marcbradshaw.net>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2018 by Marc Bradshaw.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
