# Generated by default/object.tt
package Paws::DevOpsGuru::StartTimeRange;
  use Moose;
  has FromTime => (is => 'ro', isa => 'Str');
  has ToTime => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::DevOpsGuru::StartTimeRange

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::DevOpsGuru::StartTimeRange object:

  $service_obj->Method(Att1 => { FromTime => $value, ..., ToTime => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::DevOpsGuru::StartTimeRange object:

  $result = $service_obj->Method(...);
  $result->Att1->FromTime

=head1 DESCRIPTION

A time range used to specify when the behavior of an insight or anomaly
started.

=head1 ATTRIBUTES


=head2 FromTime => Str

The start time of the time range.


=head2 ToTime => Str

The end time of the time range.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::DevOpsGuru>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

