# NAME

Data::Object

# ABSTRACT

Object-Orientation for Perl 5

# SYNOPSIS

    package main;

    use Data::Object;

    my $array = Array [1..4];

    # my $iterator = $array->iterator;

    # $iterator->next; # 1

# DESCRIPTION

This package automatically exports and provides constructor functions for
creating chainable data type objects from raw Perl data types.

# LIBRARIES

This package uses type constraints from:

[Data::Object::Types](https://metacpan.org/pod/Data::Object::Types)

# FUNCTIONS

This package implements the following functions:

## array

    Array(ArrayRef $data) : InstanceOf["Data::Object::Box"]

The Array function returns a [Data::Object::Box](https://metacpan.org/pod/Data::Object::Box) which wraps a
[Data::Object::Array](https://metacpan.org/pod/Data::Object::Array) object.

- Array example #1

        package main;

        my $array = Array; # []

- Array example #2

        package main;

        my $array = Array [1..4];

## boolean

    Boolean(Bool $data) : BooleanObject

The Boolean function returns a [Data::Object::Boolean](https://metacpan.org/pod/Data::Object::Boolean) object representing a
true or false value.

- Boolean example #1

        package main;

        my $boolean = Boolean;

- Boolean example #2

        package main;

        my $boolean = Boolean 0;

## box

    Box(Any $data) : InstanceOf["Data::Object::Box"]

The Box function returns a [Data::Object::Box](https://metacpan.org/pod/Data::Object::Box) object representing a data type
object which is automatically deduced.

- Box example #1

        package main;

        my $box = Box;

- Box example #2

        package main;

        my $box = Box 123;

- Box example #3

        package main;

        my $box = Box [1..4];

- Box example #4

        package main;

        my $box = Box {1..4};

## code

    Code(CodeRef $data) : InstanceOf["Data::Object::Box"]

The Code function returns a [Data::Object::Box](https://metacpan.org/pod/Data::Object::Box) which wraps a
[Data::Object::Code](https://metacpan.org/pod/Data::Object::Code) object.

- Code example #1

        package main;

        my $code = Code;

- Code example #2

        package main;

        my $code = Code sub { shift };

## false

    False() : BooleanObject

The False function returns a [Data::Object::Boolean](https://metacpan.org/pod/Data::Object::Boolean) object representing a
false value.

- False example #1

        package main;

        my $false = False;

## float

    Float(Num $data) : InstanceOf["Data::Object::Box"]

The Float function returns a [Data::Object::Box](https://metacpan.org/pod/Data::Object::Box) which wraps a
[Data::Object::Float](https://metacpan.org/pod/Data::Object::Float) object.

- Float example #1

        package main;

        my $float = Float;

- Float example #2

        package main;

        my $float = Float '0.0';

## hash

    Hash(HashRef $data) : InstanceOf["Data::Object::Box"]

The Hash function returns a [Data::Object::Box](https://metacpan.org/pod/Data::Object::Box) which wraps a
[Data::Object::Hash](https://metacpan.org/pod/Data::Object::Hash) object.

- Hash example #1

        package main;

        my $hash = Hash;

- Hash example #2

        package main;

        my $hash = Hash {1..4};

## number

    Number(Num $data) : InstanceOf["Data::Object::Box"]

The Number function returns a [Data::Object::Box](https://metacpan.org/pod/Data::Object::Box) which wraps a
[Data::Object::Number](https://metacpan.org/pod/Data::Object::Number) object.

- Number example #1

        package main;

        my $number = Number;

- Number example #2

        package main;

        my $number = Number 123;

## regexp

    Regexp(RegexpRef $data) : InstanceOf["Data::Object::Box"]

The Regexp function returns a [Data::Object::Box](https://metacpan.org/pod/Data::Object::Box) which wraps a
[Data::Object::Regexp](https://metacpan.org/pod/Data::Object::Regexp) object.

- Regexp example #1

        package main;

        my $regexp = Regexp;

- Regexp example #2

        package main;

        my $regexp = Regexp qr/.*/;

## scalar

    Scalar(Ref $data) : InstanceOf["Data::Object::Box"]

The Scalar function returns a [Data::Object::Box](https://metacpan.org/pod/Data::Object::Box) which wraps a
[Data::Object::Scalar](https://metacpan.org/pod/Data::Object::Scalar) object.

- Scalar example #1

        package main;

        my $scalar = Scalar;

- Scalar example #2

        package main;

        my $scalar = Scalar \*main;

## string

    String(Str $data) : InstanceOf["Data::Object::Box"]

The String function returns a [Data::Object::Box](https://metacpan.org/pod/Data::Object::Box) which wraps a
[Data::Object::String](https://metacpan.org/pod/Data::Object::String) object.

- String example #1

        package main;

        my $string = String;

- String example #2

        package main;

        my $string = String 'abc';

## true

    True() : BooleanObject

The True function returns a [Data::Object::Boolean](https://metacpan.org/pod/Data::Object::Boolean) object representing a true
value.

- True example #1

        package main;

        my $true = True;

## undef

    Undef() : InstanceOf["Data::Object::Box"]

The Undef function returns a [Data::Object::Undef](https://metacpan.org/pod/Data::Object::Undef) object representing the
_undefined_ value.

- Undef example #1

        package main;

        my $undef = Undef;

# AUTHOR

Al Newkirk, `awncorp@cpan.org`

# LICENSE

Copyright (C) 2011-2019, Al Newkirk, et al.

This is free software; you can redistribute it and/or modify it under the terms
of the The Apache License, Version 2.0, as elucidated in the ["license
file"](https://github.com/iamalnewkirk/foobar/blob/master/LICENSE).

# PROJECT

[Wiki](https://github.com/iamalnewkirk/foobar/wiki)

[Project](https://github.com/iamalnewkirk/foobar)

[Initiatives](https://github.com/iamalnewkirk/foobar/projects)

[Milestones](https://github.com/iamalnewkirk/foobar/milestones)

[Contributing](https://github.com/iamalnewkirk/foobar/blob/master/CONTRIBUTE.md)

[Issues](https://github.com/iamalnewkirk/foobar/issues)
