# Generated by default/object.tt
package Paws::EKS::OidcIdentityProviderConfig;
  use Moose;
  has ClientId => (is => 'ro', isa => 'Str', request_name => 'clientId', traits => ['NameInRequest']);
  has ClusterName => (is => 'ro', isa => 'Str', request_name => 'clusterName', traits => ['NameInRequest']);
  has GroupsClaim => (is => 'ro', isa => 'Str', request_name => 'groupsClaim', traits => ['NameInRequest']);
  has GroupsPrefix => (is => 'ro', isa => 'Str', request_name => 'groupsPrefix', traits => ['NameInRequest']);
  has IdentityProviderConfigArn => (is => 'ro', isa => 'Str', request_name => 'identityProviderConfigArn', traits => ['NameInRequest']);
  has IdentityProviderConfigName => (is => 'ro', isa => 'Str', request_name => 'identityProviderConfigName', traits => ['NameInRequest']);
  has IssuerUrl => (is => 'ro', isa => 'Str', request_name => 'issuerUrl', traits => ['NameInRequest']);
  has RequiredClaims => (is => 'ro', isa => 'Paws::EKS::RequiredClaimsMap', request_name => 'requiredClaims', traits => ['NameInRequest']);
  has Status => (is => 'ro', isa => 'Str', request_name => 'status', traits => ['NameInRequest']);
  has Tags => (is => 'ro', isa => 'Paws::EKS::TagMap', request_name => 'tags', traits => ['NameInRequest']);
  has UsernameClaim => (is => 'ro', isa => 'Str', request_name => 'usernameClaim', traits => ['NameInRequest']);
  has UsernamePrefix => (is => 'ro', isa => 'Str', request_name => 'usernamePrefix', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::EKS::OidcIdentityProviderConfig

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::EKS::OidcIdentityProviderConfig object:

  $service_obj->Method(Att1 => { ClientId => $value, ..., UsernamePrefix => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::EKS::OidcIdentityProviderConfig object:

  $result = $service_obj->Method(...);
  $result->Att1->ClientId

=head1 DESCRIPTION

An object that represents the configuration for an OpenID Connect
(OIDC) identity provider.

=head1 ATTRIBUTES


=head2 ClientId => Str

This is also known as I<audience>. The ID of the client application
that makes authentication requests to the OIDC identity provider.


=head2 ClusterName => Str

The cluster that the configuration is associated to.


=head2 GroupsClaim => Str

The JSON web token (JWT) claim that the provider uses to return your
groups.


=head2 GroupsPrefix => Str

The prefix that is prepended to group claims to prevent clashes with
existing names (such as C<system:> groups). For example, the valueC<
oidc:> creates group names like C<oidc:engineering> and C<oidc:infra>.
The prefix can't contain C<system:>


=head2 IdentityProviderConfigArn => Str

The ARN of the configuration.


=head2 IdentityProviderConfigName => Str

The name of the configuration.


=head2 IssuerUrl => Str

The URL of the OIDC identity provider that allows the API server to
discover public signing keys for verifying tokens.


=head2 RequiredClaims => L<Paws::EKS::RequiredClaimsMap>

The key-value pairs that describe required claims in the identity
token. If set, each claim is verified to be present in the token with a
matching value.


=head2 Status => Str

The status of the OIDC identity provider.


=head2 Tags => L<Paws::EKS::TagMap>

The metadata to apply to the provider configuration to assist with
categorization and organization. Each tag consists of a key and an
optional value, both of which you defined.


=head2 UsernameClaim => Str

The JSON Web token (JWT) claim that is used as the username.


=head2 UsernamePrefix => Str

The prefix that is prepended to username claims to prevent clashes with
existing names. The prefix can't contain C<system:>



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::EKS>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

