#!perl -w

use strict;
# use Test::More qw(plan ok);
use Test::More;
plan tests => 41;

use Data::Pretty qw(dumpf);

is(dumpf("foo", sub { return { dump => "x" }}), 'x');
is(dumpf("foo", sub { return { object => "x" }}), '"x"');
is(dumpf("foo", sub { return { comment => "x" }}), "# x\n\"foo\"");
is(dumpf({},    sub { return { bless => "x"}}), "bless({}, \"x\")");
is(dumpf({a => 1, b => 2}, sub { return { hide_keys => ["b"] }}), "{ a => 1 }");
is(dumpf("foo", sub { return }), '"foo"');

my $cb_count = 0;
is(dumpf("foo", sub {
    my($ctx, $obj) = @_;
    $cb_count++;
    is($$obj, "foo");
    is($ctx->object_ref, $obj);
    is($ctx->class, "");
    ok(!$ctx->object_isa("SCALAR"));
    is($ctx->container_class, "");
    ok(!$ctx->container_isa("SCALAR"));
    is($ctx->container_self, "");
    ok(!$ctx->is_ref);
    ok(!$ctx->is_blessed);
    ok(!$ctx->is_array);
    ok(!$ctx->is_hash);
    ok( $ctx->is_scalar);
    ok(!$ctx->is_code);
    is($ctx->depth, 0);
    return;
}), '"foo"');
is($cb_count, 1);

$cb_count = 0;
like(dumpf(bless({ a => 1, b => bless {}, "Bar"}, "Foo"), sub {
    my($ctx, $obj) = @_;
    $cb_count++;
    return unless $ctx->object_isa("Bar");
    is(ref($obj), "Bar");
    is($ctx->object_ref, $obj);
    is($ctx->class, "Bar");
    ok($ctx->object_isa("Bar"));
    ok(!$ctx->object_isa("Foo"));
    is($ctx->container_class, "Foo");
    ok($ctx->container_isa("Foo"));
    is($ctx->container_self, '$self->{b}');
    ok($ctx->is_ref);
    ok($ctx->is_blessed);
    ok(!$ctx->is_array);
    ok($ctx->is_hash);
    ok(!$ctx->is_scalar);
    ok(!$ctx->is_code);
    is($ctx->depth, 1);
    is($ctx->expr, '$var->{b}');
    is($ctx->expr("ref"), '$ref->{b}');
    return;
# }) =~ /^bless\(.*, "Foo"\)\z/);
}), qr/^bless\(.*, "Foo"\)\z/);
is($cb_count, 3);
