/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dataset;

import java.io.IOException;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.Array;
import ucar.ma2.ArrayDouble;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Range;
import ucar.nc2.Variable;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.VariableDS;

public class CoordinateAxis2D
extends CoordinateAxis {
    private static Logger log = LoggerFactory.getLogger(CoordinateAxis2D.class);
    private static final boolean debug = false;
    private ArrayDouble.D2 midpoint = null;

    public CoordinateAxis2D(NetcdfDataset ncd, VariableDS vds) {
        super(ncd, vds);
    }

    protected Variable copy() {
        return new CoordinateAxis2D(this.ncd, this);
    }

    public double getCoordValue(int i, int j) {
        if (this.midpoint == null) {
            this.doRead();
        }
        return this.midpoint.get(i, j);
    }

    private void doRead() {
        Array data;
        try {
            data = this.read();
        }
        catch (IOException ioe) {
            log.error("Error reading coordinate values " + ioe);
            throw new IllegalStateException(ioe);
        }
        data = data.reduce();
        if (data.getRank() != 2) {
            throw new IllegalArgumentException("must be 2D");
        }
        this.midpoint = (ArrayDouble.D2)Array.factory(Double.TYPE, data.getShape(), data.get1DJavaArray(Double.TYPE));
    }

    public double[] getCoordValues() {
        if (this.midpoint == null) {
            this.doRead();
        }
        if (!this.isNumeric()) {
            throw new UnsupportedOperationException("CoordinateAxis2D.getCoordValues() on non-numeric");
        }
        return (double[])this.midpoint.get1DJavaArray(Double.TYPE);
    }

    public CoordinateAxis2D section(Range r1, Range r2) throws InvalidRangeException {
        ArrayList<Range> section = new ArrayList<Range>();
        section.add(r1);
        section.add(r2);
        return (CoordinateAxis2D)this.section(section);
    }

    public ArrayDouble.D2 getMidpoints() {
        if (this.midpoint == null) {
            this.doRead();
        }
        return this.midpoint;
    }

    public static ArrayDouble.D2 makeXEdges(ArrayDouble.D2 midx) {
        int[] shape = midx.getShape();
        int ny = shape[0];
        int nx = shape[1];
        ArrayDouble.D2 edgex = new ArrayDouble.D2(ny + 1, nx + 1);
        for (int y = 0; y < ny - 1; ++y) {
            for (int x = 0; x < nx - 1; ++x) {
                double xval = (midx.get(y, x) + midx.get(y, x + 1) + midx.get(y + 1, x) + midx.get(y + 1, x + 1)) / 4.0;
                edgex.set(y + 1, x + 1, xval);
            }
            edgex.set(y + 1, 0, edgex.get(y + 1, 1) - (edgex.get(y + 1, 2) - edgex.get(y + 1, 1)));
            edgex.set(y + 1, nx, edgex.get(y + 1, nx - 1) + (edgex.get(y + 1, nx - 1) - edgex.get(y + 1, nx - 2)));
        }
        for (int x = 0; x < nx + 1; ++x) {
            edgex.set(0, x, edgex.get(1, x) - (edgex.get(2, x) - edgex.get(1, x)));
            edgex.set(ny, x, edgex.get(ny - 1, x) + (edgex.get(ny - 1, x) - edgex.get(ny - 2, x)));
        }
        return edgex;
    }

    public static ArrayDouble.D2 makeYEdges(ArrayDouble.D2 midy) {
        int[] shape = midy.getShape();
        int ny = shape[0];
        int nx = shape[1];
        ArrayDouble.D2 edgey = new ArrayDouble.D2(ny + 1, nx + 1);
        for (int y = 0; y < ny - 1; ++y) {
            for (int x = 0; x < nx - 1; ++x) {
                double xval = (midy.get(y, x) + midy.get(y, x + 1) + midy.get(y + 1, x) + midy.get(y + 1, x + 1)) / 4.0;
                edgey.set(y + 1, x + 1, xval);
            }
            edgey.set(y + 1, 0, edgey.get(y + 1, 1) - (edgey.get(y + 1, 2) - edgey.get(y + 1, 1)));
            edgey.set(y + 1, nx, edgey.get(y + 1, nx - 1) + (edgey.get(y + 1, nx - 1) - edgey.get(y + 1, nx - 2)));
        }
        for (int x = 0; x < nx + 1; ++x) {
            edgey.set(0, x, edgey.get(1, x) - (edgey.get(2, x) - edgey.get(1, x)));
            edgey.set(ny, x, edgey.get(ny - 1, x) + (edgey.get(ny - 1, x) - edgey.get(ny - 2, x)));
        }
        return edgey;
    }

    public static ArrayDouble.D2 makeXEdgesRotated(ArrayDouble.D2 midx) {
        int x;
        int[] shape = midx.getShape();
        int ny = shape[0];
        int nx = shape[1];
        ArrayDouble.D2 edgex = new ArrayDouble.D2(ny + 2, nx + 1);
        for (int y = 0; y < ny; ++y) {
            for (int x2 = 1; x2 < nx; ++x2) {
                double xval = (midx.get(y, x2 - 1) + midx.get(y, x2)) / 2.0;
                edgex.set(y + 1, x2, xval);
            }
            edgex.set(y + 1, 0, midx.get(y, 0) - (edgex.get(y + 1, 1) - midx.get(y, 0)));
            edgex.set(y + 1, nx, midx.get(y, nx - 1) - (edgex.get(y + 1, nx - 1) - midx.get(y, nx - 1)));
        }
        for (x = 0; x < nx; ++x) {
            edgex.set(0, x, midx.get(0, x));
        }
        for (x = 0; x < nx - 1; ++x) {
            edgex.set(ny + 1, x, midx.get(ny - 1, x));
        }
        return edgex;
    }

    public static ArrayDouble.D2 makeYEdgesRotated(ArrayDouble.D2 midy) {
        double diff;
        double pt;
        int x;
        int[] shape = midy.getShape();
        int ny = shape[0];
        int nx = shape[1];
        ArrayDouble.D2 edgey = new ArrayDouble.D2(ny + 2, nx + 1);
        for (int y = 0; y < ny; ++y) {
            for (int x2 = 1; x2 < nx; ++x2) {
                double yval = (midy.get(y, x2 - 1) + midy.get(y, x2)) / 2.0;
                edgey.set(y + 1, x2, yval);
            }
            edgey.set(y + 1, 0, midy.get(y, 0) - (edgey.get(y + 1, 1) - midy.get(y, 0)));
            edgey.set(y + 1, nx, midy.get(y, nx - 1) - (edgey.get(y + 1, nx - 1) - midy.get(y, nx - 1)));
        }
        for (x = 0; x < nx; ++x) {
            double pt0 = midy.get(0, x);
            pt = edgey.get(2, x);
            diff = pt0 - pt;
            edgey.set(0, x, pt0 + diff);
        }
        for (x = 0; x < nx - 1; ++x) {
            double pt0 = midy.get(ny - 1, x);
            pt = edgey.get(ny - 1, x);
            diff = pt0 - pt;
            edgey.set(ny + 1, x, pt0 + diff);
        }
        return edgey;
    }
}

