#!/usr/bin/perl
#-------------------------------------------------------------------------------
# _
# Philip R Brenan at gmail dot com, Appa Apps Ltd Inc., 2019
#-------------------------------------------------------------------------------
use warnings FATAL => qw(all);
use strict;
use Carp;
use Data::Dump qw(dump);
use Data::Table::Text qw(:all);
use utf8;
use feature qw(say current_sub);
use Test::More qw(no_plan);
qx(chmod ug+x $0);

my $home = q(/home/phil/perl/cpan/DataGBStandard/words/);

my %w;
for my $w(split /\s+/, &data)
 {next unless $w =~ m(\A[a-z]+\Z)is;
# next unless length($w) >= 4 and length($w) <= 6;
  next unless length($w) == 5;
  next if $w =~ m(\A(bitch|penis|semen|sperm|urine|whore)\Z)s;
  $w{lc $w}++;
 }
owf(fpe($home, qw(listOfEnglishWordsNormalized txt)), join " ", sort keys %w);
say STDERR "Bits at a time: ", log(scalar(keys %w))/log(2);
say STDERR " Number of words per md5: ", 128/(log(scalar(keys %w))/log(2));
say STDERR " Number of words:  ", scalar(keys %w);


sub data{<<END}
    aback
    abacus
    abandon
    abandoned
    abandonment
    abashed
    abate
    abbey
    abbr.
    abbreviate
    abbreviation
    ABC
    ABC's
    abdicate
    abdication
    abdomen
    abdominal
    abduct
    abduction
    aberration
    abet
    abhor
    abhorrence
    abhorrent
    abide
    abiding
    ability
    abject
    ablaze
    able
    able-bodied
    ably
    abnormal
    abnormality
    abnormally
    aboard
    abolish
    abolition
    abolitionist
    abominable
    aboriginal
    aborigine
    abort
    abortion
    abortive
    abound
    about
    about-face
    above
    aboveboard
    abrasive
    abrasively
    abreast
    abridge
    abridgment
    abroad
    abrupt
    abruptly
    abruptness
    abscess
    abscond
    absence
    absent
    absentee
    absenteeism
    absently
    absent-minded
    absent-mindedly
    absent-mindedness
    absolute
    absolutely
    absolve
    absorb
    absorbed
    absorbent
    absorbing
    absorption
    abstain
    abstention
    abstinence
    abstinent
    abstract
    abstraction
    absurd
    absurdity
    absurdly
    abundance
    abundant
    abundantly
    abuse
    abusive
    abysmal
    abysmally
    abyss
    AC
    academic
    academically
    academy
    accelerate
    acceleration
    accelerator
    accent
    accented
    accentuate
    accept
    acceptability
    acceptable
    acceptably
    acceptance
    accepted
    access
    accessibility
    accessible
    accessory
    accident
    accidental
    accidentally
    accident-prone
    acclaim
    acclaimed
    acclimate
    acclimation
    accolade
    accommodate
    accommodating
    accommodation
    accommodations
    accompaniment
    accompanist
    accompany
    accomplice
    accomplish
    accomplished
    accomplishment
    accord
    accordance
    accordingly
    according to
    accordion
    accost
    account
    accountability
    accountable
    accountant
    accounting
    accreditation
    accredited
    accrue
    accumulate
    accumulation
    accuracy
    accurate
    accurately
    accusation
    accuse
    accused
    accuser
    accusing
    accusingly
    accustom
    accustomed
    ace
    acerbic
    ache
    achieve
    achievement
    achiever
    Achilles' heel
    achy
    acid
    acidic
    acidity
    acid rain
    acknowledge
    acknowledged
    acknowledgment
    acne
    acorn
    acoustic
    acoustics
    acquaint
    acquaintance
    acquainted
    acquiesce
    acquiescence
    acquire
    acquisition
    acquit
    acquittal
    acre
    acrid
    acrimonious
    acrimony
    acrobat
    acrobatic
    acrobatics
    acronym
    across
    across from
    across-the-board
    acrylic
    ACT
    act
    acting
    action
    activate
    activation
    active
    activism
    activist
    activity
    actor
    actress
    actual
    actuality
    actualization
    actually
    acumen
    acupuncture
    acute
    acute angle
    acutely
    ad
    A.D.
    adage
    adamant
    adamantly
    Adam's apple
    adapt
    adaptable
    adaptation
    adapter
    add
    addict
    addicted
    addiction
    addictive
    addition
    additional
    additionally
    additive
    address
    adept
    adeptly
    adequacy
    adequate
    adequately
    adhere
    adherence
    adherent
    adhesion
    adhesive
    ad hoc
    adjacent
    adjectival
    adjective
    adjoin
    adjoining
    adjourn
    adjournment
    adjudicate
    adjudicator
    adjunct
    adjust
    adjustable
    adjustment
    ad lib
    ad-lib
    administer
    administration
    administrative
    administrator
    admirable
    admirably
    admiral
    admiration
    admire
    admirer
    admiring
    admiringly
    admissible
    admission
    admit
    admittance
    admittedly
    admonish
    admonition
    adobe
    adolescence
    adolescent
    adopt
    adopted
    adoption
    adoptive
    adorable
    adoration
    adore
    adorn
    adornment
    adrenaline
    adrift
    adroit
    adroitly
    adulation
    adult
    adulterate
    adulteration
    adultery
    advance
    advanced
    advancement
    advantage
    advantageous
    Advent
    advent
    adventure
    adventurer
    adventurous
    adverb
    adverbial
    adversary
    adverse
    adversely
    adversity
    advertise
    advertisement
    advertiser
    advertising
    advice
    advisable

    advise
    adviser
    advisory
    advocacy
    advocate
    aerial
    aerobic
    aerobics
    aerodynamic
    aerodynamics
    aerosol
    aerospace
    aesthetic
    aesthetically
    aesthetics
    afar
    affable
    affably
    affair
    affairs
    affect
    affectation
    affected
    affection
    affectionate
    affectionately
    affidavit
    affiliate
    affiliated
    affiliation
    affinity
    affirm
    affirmation
    affirmative
    affirmative action
    affirmatively
    affix
    afflict
    affliction
    affluence
    affluent
    afford
    affordable
    affront
    afloat
    afraid
    afresh
    Africa
    African
    African-American
    after
    aftereffect
    afterlife
    aftermath
    afternoon
    aftershave
    aftershock
    afterthought
    afterward
    afterwards
    again
    against
    age
    aged
    agency
    agenda
    agent
    ages
    aggravate
    aggravating
    aggravation
    aggression
    aggressive
    aggressively
    aggressiveness
    aggressor
    aggrieved
    aghast
    agile
    agility
    aging
    agitate
    agitated
    agitation
    agitator
    agnostic
    agnosticism
    ago
    agonize
    agonized
    agonizing
    agonizingly
    agony
    agree
    agreeable
    agreeably
    agreed
    agreement
    agricultural
    agriculture
    ah
    aha
    ahead
    aid
    aide
    AIDS
    ailing
    ailment
    aim
    aimless
    aimlessly
    ain't
    air
    air bag
    air base
    airborne
    air-conditioned
    air conditioner
    air conditioning
    aircraft
    aircraft carrier
    airfare
    airfield
    air force
    airily
    airing
    airless
    airline
    airliner
    airmail
    airplane
    airport
    air raid
    airs
    airspace
    airstrip
    airtight
    air time
    air traffic controller
    airwaves
    airy
    aisle
    ajar
    akin
    a la carte
    a la mode
    alarm
    alarm clock
    alarmed
    alarming
    alarmingly
    alarmist
    alas
    albeit
    albino
    album
    alcohol
    alcoholic
    alcoholism
    alcove
    alderman
    alderwoman
    ale
    alert
    alfalfa
    algae
    algebra
    algebraic
    algorithm
    alias
    alibi
    alien
    alienate
    alienation
    alight
    align
    alignment
    alike
    alimony
    alive
    alkali
    alkaline
    all
    Allah
    all-American
    all-around
    allay
    all-clear
    allegation
    allege
    alleged
    allegedly
    allegiance
    allegorical
    allegory
    allergic
    allergy
    alleviate
    alleviation
    alley
    alliance
    allied
    alligator
    all-inclusive
    allocate
    allocation
    allot
    allotment
    all-out
    allow
    allowable
    allowance
    alloy
    all right
    all-star
    allude
    allure
    alluring
    allusion
    ally
    alma mater
    almanac
    almighty
    almond
    almost
    alms
    aloft
    aloha
    alone
    along
    alongside
    aloof
    aloud
    alphabet
    alphabetical
    alphabetically
    alpine
    already
    alright
    also
    altar
    alter
    alteration
    altercation
    alternate
    alternately
    alternation
    alternative
    alternatively
    although
    altitude
    alto
    altogether
    altruism
    altruistic
    aluminum
    alumna
    alumnae
    alumni
    alumnus
    always
    AM
    am
    A.M.
    amalgamate
    amalgamation
    amass
    amateur
    amateurish
    amaze
    amazed
    amazement
    amazing
    amazingly
    ambassador
    ambassadorial
    amber
    ambiance
    ambidextrous
    ambiguity
    ambiguous
    ambiguously
    ambition
    ambitious
    ambitiously
    ambivalence
    ambivalent
    amble
    ambulance
    ambush
    ameliorate
    amelioration
    amen
    amenable
    amend
    amendment
    amends
    amenity
    America
    American
    Americana
    American dream
    American Indian
    Americanism
    amiable
    amiably
    amicable
    amicably
    amid
    amidst
    amiss
    ammo
    ammonia
    ammunition
    amnesia
    amnesiac
    amnesty
    amoeba
    amok
    among
    amongst
    amoral
    amorous
    amorphous
    amount
    amp
    ampere
    amphetamine
    amphibian
    amphibious

    amphitheater
    ample
    amplification
    amplifier
    amplify
    amply
    amputate
    amputation
    amputee
    amuse
    amused
    amusement
    amusement park
    amusing
    an
    anachronism
    anachronistic
    anagram
    anal
    analgesic
    analogous
    analogy
    analyses
    analysis
    analyst
    analytic
    analyze
    anarchist
    anarchy
    anatomical
    anatomy
    ancestor
    ancestral
    ancestry
    anchor
    anchorman
    anchorwoman
    anchovy
    ancient
    and
    anecdotal
    anecdote
    anemia
    anemic
    anesthesia
    anesthesiologist
    anesthetic
    anesthetist
    anesthetize
    anew
    angel
    angelic
    angelically
    anger
    angle
    angler
    Anglican
    angling
    Anglo
    angrily
    angry
    angst
    anguish
    anguished
    angular
    animal
    animate
    animated
    animation
    animosity
    ankle
    annals
    annex
    annexation
    annihilate
    annihilation
    anniversary
    annotated
    announce
    announcement
    announcer
    annoy
    annoyance
    annoyed
    annoying
    annual
    annually
    annuity
    annul
    annulment
    anoint
    anomalous
    anonymity
    anonymous
    anonymously
    anorexia
    anorexic
    another
    answer
    answerable
    answering machine
    ant
    antacid
    antagonism
    antagonist
    antagonistic
    antagonistically
    antagonize
    Antarctic
    Antarctica
    ante
    antebellum
    antelope
    antenna
    antennae
    anthem
    anthill
    anthology
    anthropological
    anthropologist
    anthropology
    antibiotic
    antibody
    anticipate
    anticipation
    anticlimactic
    anticlimax
    antics
    antidote
    antifreeze
    antihistamine
    antipathy
    antiperspirant
    antiquated
    antique
    antiquity
    anti-Semitic
    anti-Semitism
    antiseptic
    antisocial
    antithesis
    antitrust
    antler
    antonym
    anus
    anvil
    anxiety
    anxious
    anxiously
    any
    anybody
    anyhow
    anymore
    anyone
    anyplace
    anything
    anytime
    anyway
    anywhere
    apart
    apart from
    apartheid
    apartment
    apartment building
    apathetic
    apathy
    ape
    aperitif
    aperture
    apex
    aphorism
    aphrodisiac
    apiece
    aplomb
    apocalypse
    apocalyptic
    apolitical
    apologetic
    apologetically
    apologize
    apology
    apoplectic
    apoplexy
    apostle
    apostolic
    apostrophe
    appall
    appalling
    appallingly
    apparatus
    apparel
    apparent
    apparently
    apparition
    appeal
    appealing
    appear
    appearance
    appease
    appeasement
    append
    appendage
    appendices
    appendicitis
    appendix
    appetite
    appetizer
    appetizing
    applaud
    applause
    apple
    apple cider
    applesauce
    appliance
    applicable
    applicant
    application
    applicator
    applied
    apply
    appoint
    appointed
    appointee
    appointment
    apportion
    appraisal
    appraise
    appreciable
    appreciate
    appreciation
    appreciative
    appreciatively
    apprehend
    apprehension
    apprehensive
    apprentice
    apprenticeship
    apprise
    approach
    approachable
    approbation
    appropriate
    appropriately
    appropriation
    approval
    approve
    approving
    approvingly
    approx.
    approximate
    approximately
    approximation
    Apr.
    apricot
    April
    April Fools' Day
    apron
    apt
    apt.
    aptitude
    aptitude test
    aptly
    aquaria
    aquarium
    Aquarius
    aquatic
    aqueduct
    Arab
    Arabic
    arable
    arbiter
    arbitrarily
    arbitrary
    arbitrate
    arbitration
    arbitrator
    arc
    arcade
    arch
    archaeological
    archaeologist
    archaeology
    archaic
    archbishop
    arched
    archipelago
    architect
    architectural
    architecture
    archive
    archives
    archway
    Arctic
    arctic
    Arctic Circle
    ardent
    ardently
    ardor
    arduous
    are
    area
    area code
    arena
    aren't
    arguable
    arguably
    argue
    argument
    argumentative
    aria
    arid
    Aries
    arise
    arisen
    aristocracy
    aristocrat
    aristocratic
    arithmetic
    arm
    armadillo
    armaments
    armband
    armchair
    armed
    armed forces
    armful
    armhole
    armistice
    armor
    armored

    armory
    armpit
    arms
    army
    aroma
    aromatic
    arose
    around
    around-the-clock
    arousal
    arouse
    arraign
    arraignment
    arrange
    arrangement
    array
    arrears
    arrest
    arrival
    arrive
    arrogance
    arrogant
    arrogantly
    arrow
    arsenal
    arsenic
    arson
    arsonist
    art
    arterial
    artery
    arthritic
    arthritis
    artichoke
    article
    articulate
    articulately
    articulation
    artifact
    artificial
    artificial insemination
    artificial intelligence
    artificially
    artificial respiration
    artillery
    artisan
    artist
    artistic
    artistically
    artistry
    arts
    artsy
    artwork
    as
    ASAP
    asbestos
    ascend
    ascendancy
    ascending
    ascent
    ascertain
    ascetic
    ascribe
    asexual
    ash
    ashamed
    ashen
    ashes
    ashore
    ashtray
    Asia
    Asian
    Asian-American
    aside
    aside from
    ask
    askance
    askew
    asleep
    asparagus
    aspect
    aspersion
    asphalt
    asphyxiate
    asphyxiation
    aspiration
    aspire
    aspirin
    aspiring
    ass
    assailant
    assassin
    assassinate
    assassination
    assault
    assemble
    assembly
    assembly line
    assemblyman
    assemblywoman
    assent
    assert
    assertion
    assertive
    assertively
    assertiveness
    assess
    assessment
    asset
    asshole
    assign
    assignment
    assimilate
    assimilation
    assist
    assistance
    assistant
    assistant professor
    assn.
    assoc.
    associate
    associate degree
    associate professor
    association
    assorted
    assortment
    asst.
    assume
    assumption
    assurance
    assure
    assured
    assuredly
    asterisk
    asteroid
    asthma
    asthmatic
    astonish
    astonished
    astonishing
    astonishingly
    astonishment
    astound
    astounding
    astray
    astride
    astringent
    astrologer
    astrological
    astrology
    astronaut
    astronomer
    astronomical
    astronomy
    AstroTurf
    astute
    astutely
    asylum
    at
    ate
    atheism
    atheist
    athlete
    athlete's foot
    athletic
    athletics
    Atlantic
    Atlantic Ocean
    atlas
    ATM
    atmosphere
    atmospheric
    atom
    atomic
    atomic bomb
    atomic energy
    atonement
    atrocious
    atrociously
    atrocity
    attach
    attache
    attache case
    attached
    attachment
    attack
    attacker
    attain
    attainable
    attainment
    attempt
    attend
    attendance
    attendant
    attention
    attentive
    attentively
    attest
    attic
    attire
    attitude
    attorney
    attorney general
    attract
    attraction
    attractive
    attractively
    attractiveness
    attributable
    attribute
    attribution
    attuned
    atty.
    auburn
    auction
    auctioneer
    audacious
    audacity
    audible
    audibly
    audience
    audio
    audiovisual
    audit
    audition
    auditor
    auditorium
    Aug.
    augment
    August
    aunt
    aura
    aural
    auspices
    auspicious
    austere
    austerity
    Australia
    Australian
    authentic
    authentically
    authenticate
    authenticity
    author
    authoritarian
    authoritative
    authoritatively
    authority
    authorization
    authorize
    authorship
    autistic
    auto
    autobiographical
    autobiography
    autocracy
    autocrat
    autocratic
    autograph
    automate
    automatic
    automatically
    automation
    automobile
    automotive
    autonomous
    autonomously
    autonomy
    autopsy
    autoworker
    autumn
    autumnal
    auxiliary
    AV
    avail
    availability
    available
    avalanche
    avant-garde
    avarice
    avaricious
    Ave.
    avenge
    avenue
    average
    averse
    aversion
    avert
    aviation
    aviator
    avid
    avidly
    avocado
    avoid
    avoidable
    avoidance
    avow
    avowal
    avowed
    aw
    await
    awake
    awaken
    awakening
    award
    aware
    awareness
    awash
    away
    awe
    awe-inspiring
    awesome
    awful
    awfully
    awhile
    awkward
    awkwardly
    awkwardness
    awning
    awoke
    awoken
    AWOL
    awry
    ax
    axes
    axiom
    axiomatic
    axis
    axle
ManyThings.org

    Reading
    Sentences
    More

English Vocabulary Word Lists with Games, Puzzles and Quizzes

English Vocabulary Word List
Alan Beale's Core Vocabulary - B (1146 Words)

    B.A.
    baa
    babble
    babe
    baboon
    baby
    baby boom
    baby boomer
    baby carriage
    babysat
    babysit
    babysitter
    bachelor
    back
    backbone
    backbreaking
    backdrop
    backer
    backfire
    backgammon
    background
    backhand
    backhanded
    backing
    backlash
    backlog
    backpack
    backpacker
    back seat
    backside
    backstage
    backstroke
    backtrack
    backup
    backward
    backwards
    backwoods
    backyard
    bacon
    bacteria
    bad
    bade
    badge
    badger
    badlands
    bad language
    badly
    badminton
    badmouth
    baffle
    baffled
    baffling
    bag
    bagel
    baggage
    baggy
    bag lady
    bagpipes
    bail
    bailiff
    bait
    bake
    baker
    bakery
    balance
    balanced
    balance of power
    balance sheet
    balcony
    bald
    bald eagle
    balding
    bale
    baleful
    balk
    ball
    ballad
    ballerina
    ballet
    ball game
    ballistic
    ballistics
    balloon
    ballot
    ballpark
    ballpoint pen
    ballroom
    balls
    balm
    balmy
    baloney
    bamboo
    bamboozle
    ban
    banal
    banality
    banana
    band
    bandage
    Band-Aid
    bandanna
    bandit
    bandstand
    bandwagon
    bandy
    bane
    bang
    bangle
    bangs
    banish
    banister
    banjo
    bank
    banker
    banking
    bankrupt
    bankruptcy
    banner
    banquet
    banter
    baptism
    baptismal
    Baptist
    baptize
    bar
    barbarian
    barbaric
    barbarism
    barbecue
    barbed wire
    barbell
    barber
    barbiturate
    bar code
    bare
    bare-bones
    barefoot
    barely
    barf
    bargain
    bargaining chip
    barge
    baritone
    bark
    barley
    bar mitzvah
    barn
    barnacle
    barnyard
    barometer
    barometric
    baron
    barracks
    barrage
    barrel
    barren
    barricade
    barrier
    barring
    barrio
    barroom
    bartender
    barter
    base
    baseball
    basement
    bases
    bash
    bashful
    bashing
    basic
    basically
    basics
    basin
    basis
    bask
    basket
    basketball
    basket case
    bass
    bass guitar
    bassist
    bassoon
    bastard
    bat
    batch
    bated
    bath
    bathe
    bathing suit
    bathrobe
    bathroom
    bathtub
    bat mitzvah
    baton
    battalion
    batter
    battered
    battery
    battle
    battlefield
    battleground
    battleship
    bawdy
    bawl
    bay
    bayonet
    bayou
    bay window
    bazaar
    BBQ
    B.C.
    be
    beach
    beach ball
    beacon
    bead
    beady
    beagle
    beak
    beaker
    beam
    bean
    bear
    bearable
    beard
    bearded
    bearer
    bearing
    bear market
    beast
    beat
    beaten
    beater
    beating
    beautician
    beautiful
    beautifully
    beauty
    beauty parlor
    beaver
    bebop
    became
    because
    because of
    beckon
    become
    becoming
    bed
    bed and breakfast
    bedbug
    bedclothes
    bedding
    bedlam
    bedpan
    bedraggled
    bedridden
    bedroom
    bedside
    bedspread
    bedtime
    bee
    beech
    beef
    beefy
    beehive
    beeline
    been
    beep
    beeper
    beer
    beeswax
    beet
    beetle
    befall
    befallen
    befell
    befit
    befitting
    before
    beforehand
    befriend
    beg
    began
    beggar
    begin
    beginner

    beginning
    begrudge
    beguile
    begun
    behalf
    behave
    behavior
    behead
    behind
    behold
    beholder
    beige
    being
    belated
    belatedly
    belch
    belie
    belief
    believable
    believe
    believer
    belittle
    bell
    bell-bottoms
    belligerence
    bellow
    bell pepper
    belly
    bellybutton
    belong
    belongings
    beloved
    below
    belt
    beltway
    bemused
    bench
    benchmark
    bend
    beneath
    benediction
    benefactor
    beneficial
    beneficiary
    benefit
    benevolence
    benevolent
    benign
    bent
    bequeath
    bequest
    berate
    bereaved
    bereavement
    bereft
    beret
    berry
    berserk
    berth
    beset
    beside
    besides
    besiege
    best
    bestial
    bestiality
    best man
    bestow
    bestseller
    best-selling
    bet
    betray
    betrayal
    better
    betterment
    better off
    between
    beveled
    beverage
    beware
    bewildered
    bewildering
    bewilderment
    bewitching
    beyond
    bias
    biased
    bib
    Bible
    bible
    biblical
    bibliography
    bib overalls
    bicentennial
    biceps
    bicker
    bicycle
    bid
    bidden
    bidder
    bidding
    bide
    biennial
    bifocals
    big
    bigamist
    bigamous
    bigamy
    Big Apple
    big brother
    big cheese
    big deal
    biggie
    big league
    big-league
    bigmouth
    big name
    bigot
    bigoted
    bigotry
    big shot
    big time
    big-time
    bigwig
    bike
    biker
    bikini
    bilateral
    bilaterally
    bile
    bilingual
    bill
    billboard
    billfold
    billiards
    billion
    billionaire
    billionth
    Bill of Rights
    billow
    billy goat
    bimbo
    bimonthly
    bin
    binary
    bind
    binder
    binding
    binge
    bingo
    binoculars
    biochemistry
    biodegradable
    biographer
    biographical
    biography
    biological
    biologist
    biology
    biopsy
    bipartisan
    biped
    biplane
    birch
    bird
    birdbrained
    birdseed
    birth
    birth certificate
    birth control
    birth date
    birthday
    birthmark
    birthplace
    birthrate
    biscuit
    bisect
    bisection
    bisexual
    bishop
    bison
    bit
    bitch
    bitchy
    bite
    biting
    bitten
    bitter
    bitterly
    bitterness
    biweekly
    bizarre
    blab
    blabbermouth
    Black
    black
    black belt
    blackberry
    blackbird
    blackboard
    blacken
    black eye
    blackhead
    black hole
    blackjack
    blacklist
    black magic
    blackmail
    blackmailer
    black market
    blackness
    blackout
    blacksmith
    blacktop
    bladder
    blade
    blah
    blame
    blameless
    blanch
    bland
    blandly
    blank
    blank check
    blanket
    blankly
    blankness
    blare
    blase
    blaspheme
    blasphemous
    blasphemy
    blast
    blast furnace
    blastoff
    blatant
    blatantly
    blaze
    blazer
    bleach
    bleachers
    bleak
    bleakly
    bleakness
    blearily
    bleary
    bled
    bleed
    bleeding
    blemish
    blemished
    blend
    blender
    bless
    blessed
    blessing
    blew
    blight
    blimp
    blind
    blind date
    blindfold
    blindly
    blindness
    blind spot
    blink
    blip
    bliss
    blissful
    blissfully
    blister
    blistering
    blithe
    blithely
    blitz
    blizzard
    bloated
    blob
    bloc
    block
    blockade
    blockage
    blockbuster
    blockhead
    block letter
    blond
    blood

    bloodbath
    blood donor
    bloodhound
    bloodless
    blood pressure
    bloodshed
    bloodshot
    bloodstain
    bloodstained
    bloodstream
    bloodthirsty
    blood type
    blood vessel
    bloody
    bloom
    blooper
    blossom
    blot
    blotch
    blotchy
    blotter
    blouse
    blow
    blow-dry
    blown
    blowout
    blowtorch
    blowup
    blubber
    bludgeon
    blue
    bluebell
    blueberry
    bluebird
    blue blood
    blue cheese
    blue chip
    blue-collar
    bluegrass
    blue jay
    blue jeans
    blue law
    blueprint
    blues
    bluff
    bluish
    blunder
    blunt
    bluntly
    bluntness
    blur
    blurb
    blurred
    blurry
    blurt
    blush
    blusher
    Blvd.
    B.O.
    boa
    boa constrictor
    boar
    board
    boarder
    boardinghouse
    boarding pass
    boarding school
    boardroom
    boardwalk
    boast
    boastful
    boat
    boat people
    bob
    bobbin
    bobcat
    bobsled
    bodice
    bodily
    body
    bodybuilding
    bodyguard
    body language
    body odor
    bodywork
    bog
    bogeyman
    bogged down
    boggle
    bogus
    bohemian
    boil
    boiler
    boiling
    boiling point
    boisterous
    bold
    boldly
    boldness
    bologna
    bolster
    bolt
    bomb
    bombard
    bombardment
    bomb disposal
    bombed
    bomber
    bombshell
    bona fide
    bonanza
    bond
    bondage
    bone
    bone-dry
    bone marrow
    bonfire
    bongo
    bonkers
    bonnet
    bonus
    bony
    boo
    boob
    boo-boo
    boob tube
    booby trap
    booby-trap
    boogie
    book
    bookcase
    bookend
    bookie
    booking
    bookkeeper
    bookkeeping
    booklet
    bookmaker
    bookmark
    books
    bookstore
    bookworm
    boom
    boom box
    boomerang
    boon
    boondocks
    boor
    boorish
    boost
    booster
    boot
    boot camp
    bootee
    booth
    bootleg
    bootlegger
    bootstraps
    booty
    booze
    boozer
    bop
    border
    borderline
    bore
    bored
    boredom
    boring
    born
    born-again
    borne
    borough
    borrow
    borrower
    bosom
    boss
    bossily
    bossiness
    bossy
    botanical
    botanist
    botany
    botch
    both
    bother
    bothersome
    bottle
    bottled
    bottleneck
    bottom
    bottomless
    bottom line
    bottoms
    bough
    bought
    boulder
    boulevard
    bounce
    bouncer
    bouncy
    bound
    boundary
    boundless
    bounds
    bountiful
    bounty
    bouquet
    bourbon
    bourgeois
    bourgeoisie
    bout
    boutique
    bovine
    bow
    bowel
    bowl
    bowlegged
    bowling
    bow tie
    box
    boxcar
    boxer
    boxer shorts
    boxing
    box office
    box spring
    boy
    boycott
    boyfriend
    boyhood
    boyish
    Boy Scout
    Boy Scouts
    bozo
    bra
    brace
    bracelet
    braces
    bracing
    bracket
    brackish
    brag
    braggart
    braid
    Braille
    brain
    brainchild
    brainless
    brains
    brainstorm
    brainwash
    brainwashing
    brainy
    braise
    brake
    bran
    branch
    brand
    brandish
    brand name
    brand-new
    brandy
    brash
    brass
    brassiere
    brass knuckles
    brassy
    brat
    bravado
    brave
    bravely
    bravery
    bravo
    brawl
    brawn
    brawny
    bray
    brazen
    brazenly
    brazier
    breach
    bread
    breadbasket
    breadth
    breadwinner
    break
    breakable

    breakdown
    breakfast
    break-in
    breaking point
    breakneck
    breakthrough
    breakup
    breakwater
    breast
    breast-fed
    breast-feed
    breaststroke
    breath
    breathe
    breather
    breathing
    breathless
    breathlessly
    breathtaking
    breathtakingly
    bred
    breed
    breeder
    breeding
    breeding ground
    breeze
    breezy
    brethren
    brevity
    brew
    brewer
    brewery
    bribe
    bribery
    bric-a-brac
    brick
    bricklayer
    bricklaying
    bridal
    bride
    bridegroom
    bridesmaid
    bridge
    bridle
    brief
    briefcase
    briefing
    briefly
    briefs
    brigade
    bright
    brighten
    brightly
    brightness
    brilliance
    brilliant
    brilliantly
    brim
    brine
    bring
    brink
    briny
    brisk
    briskly
    bristle
    Britain
    britches
    British
    brittle
    broach
    broad
    broadcast
    broadcaster
    broaden
    broadly
    broad-minded
    broadside
    broccoli
    brochure
    brogue
    broil
    broiler
    broke
    broken
    broken-down
    brokenhearted
    broker
    brokerage
    bronchitis
    bronco
    bronze
    bronze medal
    brooch
    brood
    brook
    broom
    broomstick
    broth
    brothel
    brother
    brotherhood
    brother-in-law
    brotherly
    brothers-in-law
    brought
    brow
    browbeat
    brown
    Brownie
    brownie
    Brownies
    brownish
    brownstone
    browse
    browser
    bruise
    brunch
    brunette
    brunt
    brush
    brush-off
    brusque
    Brussels sprout
    brutal
    brutality
    brutalize
    brutally
    brute
    brutish
    BS
    B.S.
    bubble
    bubble gum
    bubbly
    buck
    bucket
    buckle
    bucktoothed
    bud
    Buddha
    Buddhism
    Buddhist
    budding
    buddy
    budge
    budget
    buff
    buffalo
    buffer
    buffet
    buffoon
    bug
    buggy
    bugle
    build
    builder
    building
    buildup
    built
    built-in
    bulb
    bulbous
    bulge
    bulging
    bulk
    bulky
    bull
    bulldog
    bulldoze
    bulldozer
    bullet
    bulletin
    bulletin board
    bulletproof
    bullfight
    bullfighter
    bullfighting
    bullion
    bullish
    bull's-eye
    bullshit
    bully
    bum
    bumblebee
    bumbling
    bummer
    bump
    bumper
    bumper sticker
    bumpy
    bun
    bunch
    bundle
    bungalow
    bungee jumping
    bungle
    bungler
    bunion
    bunk
    bunk bed
    bunker
    bunny
    buns
    buoy
    buoyancy
    buoyant
    buoyantly
    burden
    bureau
    bureaucracy
    bureaucrat
    bureaucratic
    burger
    burglar
    burglar alarm
    burglarize
    burglary
    burial
    burlap
    burly
    burn
    burner
    burning
    burnish
    burnt
    burp
    burrow
    bursar
    burst
    bury
    bus
    busboy
    bush
    bushed
    bushel
    bushy
    busily
    business
    business administration
    business card
    businesslike
    businessman
    businesswoman
    busing
    bus stop
    bust
    buster
    bustle
    busy
    busybody
    busywork
    but
    butcher
    butchery
    butler
    butt
    butte
    butter
    buttercup
    butterfingers
    butterfly
    buttermilk
    butterscotch
    buttock
    button
    buttonhole
    buttress
    buxom
    buy
    buyer
    buyout
    buzz
    buzzard
    buzzer
    buzzword
    by
    bye
    bye-bye
    bygone
    bylaw
    bypass
    by-product
    bystander
    byte
    byway
ManyThings.org

    Reading
    Sentences
    More

English Vocabulary Word Lists with Games, Puzzles and Quizzes

English Vocabulary Word List
Alan Beale's Core Vocabulary - C (2031 Words)

    cab
    cabaret
    cabbage
    cabby
    cabin
    Cabinet
    cabinet
    cable
    cable car
    cable TV
    caboose
    cache
    cachet
    cackle
    cacti
    cactus
    cadaver
    cadence
    cadet
    cadre
    cafe
    cafeteria
    caffeine
    cage
    caged
    cagey
    cahoots
    cajole
    cake
    calamity
    calcium
    calculate
    calculated
    calculating
    calculation
    calculator
    calculus
    calendar
    calendar year
    calf
    caliber
    calibrate
    calibration
    calico
    call
    caller
    call girl
    calligraphy
    calling
    call-in show
    callous
    callously
    callousness
    callus
    calm
    calmly
    calmness
    calorie
    calves
    camaraderie
    camcorder
    came
    camel
    camellia
    cameo
    camera
    cameraman
    camerawoman
    camouflage
    camp
    campaign
    campaigner
    camper
    campground
    camping
    campsite
    campus
    can
    Canadian
    canal
    canary
    cancel
    cancellation
    Cancer
    cancer
    candid
    candidacy
    candidate
    candidly
    candle
    candlelight
    candlestick
    candor
    candy
    candy bar
    cane
    canine
    canister
    canker
    canker sore
    cannabis
    canned
    cannery
    cannibal
    cannibalism
    cannon
    cannonball
    cannot
    canny
    canoe
    canopied
    canopy
    can't
    cantaloupe
    cantankerous
    canteen
    canter
    Cantonese
    canvas
    canvass
    canyon
    cap
    capability
    capable
    capacity
    cape
    caper
    capillary
    capital
    capitalism
    capitalist
    capitalization
    capitalize
    capital letter
    capital punishment
    Capitol
    capitol
    capitulate
    capitulation
    cappuccino
    caprice
    capricious
    capriciously
    Capricorn
    capsize
    capsule
    captain
    caption
    captivate
    captivating
    captive
    captivity
    captor
    capture
    car
    caramel
    carat
    caravan
    carbohydrate
    carbon
    carbonated
    carbon copy
    carbon dioxide
    carbon monoxide
    carbon paper
    carburetor
    carcass
    card
    cardboard
    card catalog
    cardiac
    cardiac arrest
    cardigan
    cardinal
    cardinal number
    cardiology
    cards
    care
    careen
    career
    carefree
    careful
    carefully
    carefulness
    careless
    carelessly
    carelessness
    caress
    caretaker
    cargo
    Caribbean
    caribou
    caricature
    caring
    carjacker
    carjacking
    carnage
    carnal
    carnation
    carnival
    carnivore
    carnivorous
    carol
    carouse
    carousel
    carp
    carpenter
    carpentry
    carpet
    carpeted
    carpeting
    car pool
    car-pool
    carriage
    carrier
    carrot
    carry
    carry-on
    carryout
    cart
    cartel
    cartilage
    cartographer
    cartography
    carton
    cartoon
    cartoonist
    cartridge
    cartwheel
    carve
    carving
    car wash
    cascade
    case
    case study
    casework
    caseworker
    cash
    cash cow
    cashew
    cash flow
    cashier
    cashmere
    cash register
    casing
    casino
    cask
    casket
    casserole
    cassette
    cast
    castaway
    caste
    caster
    castigate
    castigation
    casting
    cast iron
    cast-iron
    castle
    castoff
    castrate
    castration
    casual
    casually
    casualness
    casualty
    cat
    cataclysm
    cataclysmic
    catalog
    catalyst
    catamaran
    catapult
    cataract
    catastrophe
    catastrophic
    catch
    Catch-22
    catching
    catch phrase
    catchy
    catechism
    categorical
    categorically
    categorize
    category
    cater
    caterer
    catering
    caterpillar
    catfish
    cathedral
    Catholic
    catholic
    Catholicism
    catnap
    catnip
    cattle
    catty
    catty-cornered
    catwalk
    Caucasian
    caucus
    caught
    cauliflower
    cause
    'cause
    caustic
    caution
    cautionary
    cautious
    cautiously
    cavalier
    cavalry
    cave
    caveman
    cavern
    caviar
    cavity
    cavort
    cc:
    CD
    CD-ROM
    cease
    cease-fire
    ceaseless
    ceaselessly
    cedar
    cede
    ceiling
    celebrate
    celebrated
    celebration
    celebrity
    celery
    celestial
    celibacy
    celibate
    cell
    cellar
    cellist
    cello
    cellophane
    cell phone
    cellular
    celluloid
    cellulose
    Celsius
    cement
    cemetery
    censor
    censorship
    censure
    census
    cent
    centenary
    centennial
    center
    centerpiece
    centigrade
    centimeter
    centipede
    central
    centralize
    centrally
    century
    CEO
    ceramic
    ceramics
    cereal
    cerebral
    cerebral palsy
    ceremonial
    ceremony
    certain
    certainly
    certainty
    certifiable
    certificate
    certification
    certified check
    certified mail
    certify
    cervical
    cervix
    cesarean
    cesarean section
    cessation
    cesspool
    chafe
    chagrin
    chain
    chain reaction
    chainsaw
    chain smoker
    chair
    chairman
    chairmanship
    chairperson
    chairwoman
    chalet
    chalk
    chalkboard
    chalky
    challenge
    challenged
    challenger
    challenging
    chamber
    chamber music
    chamber of commerce
    chameleon
    champ
    champagne
    champion
    championship
    chance
    chancellor
    chandelier
    change
    changeable
    changeover
    channel
    chant
    chaos
    chaotic
    chap
    chapel
    chaperone
    chaplain
    chapped
    chaps
    chapter
    char
    character
    characteristic
    characteristically
    characterization
    characterize
    charade
    charades
    charcoal
    charge
    charge account
    charge card
    chariot
    charisma
    charismatic
    charitable
    charitably
    charity
    charlatan
    charm
    charmed
    charmer
    charming
    charred
    chart
    charter
    charter flight
    charter member
    charts
    chase
    chasm
    chassis
    chaste
    chasten
    chastise
    chastisement
    chastity
    chat
    chateau
    chateaux
    chatter
    chatterbox
    chatty
    chauffeur
    chauvinism
    chauvinist
    chauvinistic
    cheap
    cheapen
    cheaply
    cheapness
    cheapskate
    cheat
    cheater
    check
    checkbook
    checked
    checker
    checkerboard
    checkered
    checkers
    check-in
    checking account
    checklist
    check mark
    checkmate
    checkout
    checkpoint
    checkup
    cheddar
    cheek
    cheekbone
    cheer
    cheerful

    cheerfully
    cheerfulness
    cheerleader
    cheers
    cheery
    cheese
    cheeseburger
    cheesecake
    cheesecloth
    cheetah
    chef
    chemical
    chemically
    chemist
    chemistry
    chemotherapy
    cherish
    cherry
    cherub
    chess
    chessboard
    chest
    chestnut
    chew
    chewing gum
    chewy
    chic
    Chicano
    chick
    chickadee
    chicken
    chicken feed
    chicken pox
    chide
    chief
    Chief Executive
    chief justice
    chiefly
    chieftain
    chiffon
    child
    childbearing
    childbirth
    childcare
    childhood
    childish
    childishly
    childless
    childlike
    childproof
    children
    child support
    chili
    chili con carne
    chili pepper
    chill
    chilling
    chilly
    chime
    chimney
    chimp
    chimpanzee
    chin
    china
    Chinatown
    Chinese
    chink
    chinos
    chintz
    chip
    chipmunk
    chipper
    chiropractor
    chirp
    chisel
    chit
    chitchat
    chivalrous
    chivalry
    chives
    chlorinate
    chlorine
    chloroform
    chlorophyll
    chock-full
    chocolate
    choice
    choir
    choke
    cholera
    cholesterol
    choose
    choosy
    chop
    chopper
    choppiness
    choppy
    chopsticks
    choral
    chord
    chore
    choreograph
    choreographer
    choreography
    chortle
    chorus
    chose
    chosen
    chow
    chowder
    Christ
    christen
    christening
    Christian
    Christianity
    Christmas
    Christmas card
    Christmas Day
    Christmas Eve
    Christmas tree
    chrome
    chromium
    chromosome
    chronic
    chronically
    chronicle
    chronological
    chronologically
    chronology
    chrysanthemum
    chubby
    chuck
    chuckle
    chug
    chum
    chump
    chunk
    chunky
    church
    churchgoer
    churlish
    churn
    chute
    chutzpah
    CIA
    cider
    cigar
    cigarette
    cinch
    cinder
    cinema
    cinematographer
    cinnamon
    cipher
    circa
    circle
    circuit
    circuit breaker
    circuitous
    circular
    circulate
    circulation
    circulatory
    circumcise
    circumcision
    circumference
    circumstance
    circumstances
    circumstantial
    circumvent
    circumvention
    circus
    cirrhosis
    cistern
    citation
    cite
    citizen
    citizens band
    citizenship
    citrus
    citrus fruit
    city
    city hall
    civic
    civics
    civil
    civilian
    civilization
    civilize
    civilized
    civil liberties
    civilly
    civil rights
    civil servant
    civil service
    Civil War
    civil war
    clack
    clad
    claim
    clairvoyance
    clairvoyant
    clam
    clamber
    clammy
    clamor
    clamp
    clampdown
    clan
    clandestine
    clang
    clank
    clap
    clapboard
    clapper
    clarification
    clarify
    clarinet
    clarity
    clash
    clasp
    class
    classic
    classical
    classically
    classics
    classification
    classified
    classified ad
    classify
    classmate
    classroom
    classy
    clatter
    clause
    claustrophobia
    claustrophobic
    claw
    clay
    clean
    clean-cut
    cleaner
    cleaners
    cleaning
    cleanliness
    cleanly
    cleanse
    cleanser
    clean-shaven
    cleanup
    clear
    clearance
    clear-cut
    clear-headed
    clearing
    clearly
    cleat
    cleavage
    cleaver
    clef
    cleft
    clemency
    clench
    clergy
    clergyman
    clergywoman
    cleric
    clerical
    clerk
    clever
    cleverly
    cleverness
    cliche
    click
    client
    clientele
    cliff
    cliffhanger
    climactic
    climate
    climatic
    climax
    climb
    climber
    clinch
    cling
    clinging
    clinic
    clinical
    clinically
    clinician
    clink
    clip
    clipboard
    clippers
    clipping
    clique
    clitoris
    cloak
    cloak-and-dagger
    cloakroom
    clobber
    clock
    clockwise
    clockwork
    clod
    clog
    clone
    close
    closed
    closed-circuit television
    closed shop
    close-knit
    closely
    closeness
    closeout
    closet
    close-up
    closure
    clot
    cloth
    clothe
    clothed
    clothes
    clothesline
    clothespin
    clothing
    cloud
    cloudburst
    cloudless
    cloudy
    clout
    clove
    clover
    clown
    club
    clubhouse
    clubs
    club sandwich
    club soda
    cluck
    clue
    clueless
    clump
    clumsily
    clumsiness
    clumsy
    clung
    clunk
    cluster
    clutch
    clutches
    clutter
    cluttered
    cm:
    c/o
    Co.
    coach
    coagulate
    coagulation
    coal
    coalesce
    coalition
    coals
    coarse
    coarsely
    coarsen
    coast
    coastal
    coaster
    Coast Guard
    coastline
    coat
    coat hanger
    coating
    coax
    cob
    cobbler
    cobblestone
    cobra
    cobweb
    Coca-Cola
    cocaine
    cock
    cockeyed
    cockiness
    cockpit
    cockroach
    cocktail
    cocky
    cocoa
    cocoa powder
    coconut
    cocoon
    cod
    C.O.D.
    code
    coed
    coeducational
    coerce
    coercion
    coercive
    coexist
    coexistence
    coffee
    coffeehouse
    coffee shop
    coffee table
    coffin
    cog
    cogency
    cogent
    cogently
    cognac
    cohabit
    cohabitation
    coherence
    coherent
    coherently
    cohesion
    coil
    coin
    coincide
    coincidence
    coincidental
    coincidentally
    Coke
    coke
    COLA
    cola
    colander
    cold
    cold-blooded
    cold cuts
    cold-hearted
    coldly
    coldness
    cold sore
    cold turkey
    cold war
    coleslaw
    colic
    collaborate
    collaboration
    collaborator
    collage
    collapse
    collapsible
    collar
    collarbone
    collate
    collateral
    colleague
    collect
    collected
    collectible
    collection
    collective
    collective bargaining
    collectively
    collector
    college
    collegiate
    collide
    collie
    collision
    colloquial
    colloquialism
    colloquially
    collusion
    cologne
    colon
    colonel
    colonial
    colonialism
    colonist
    colonization
    colonize
    colony
    color
    colorblind
    colored
    colorful
    coloring
    colorless
    color scheme
    colossal
    colt
    column
    columnist
    coma
    comatose
    comb
    combat
    combatant
    combative
    combination
    combine
    combined
    combustible
    combustion
    come
    comeback
    comedian
    comedown
    comedy
    come-on
    comet

    comeuppance
    comfort
    comfortable
    comfortably
    comforter
    comforting
    comfy
    comic
    comical
    comic book
    comics
    comic strip
    coming
    comma
    command
    commandant
    commandeer
    commander
    commanding
    commandment
    commando
    commemorate
    commemoration
    commemorative
    commence
    commencement
    commend
    commendable
    commendation
    comment
    commentary
    commentate
    commentator
    commerce
    commercial
    commercial bank
    commercialize
    commercially
    commiserate
    commiseration
    commission
    commissioner
    commit
    commitment
    committed
    committee
    commodity
    commodore
    common
    common ground
    common-law husband
    common-law wife
    commonly
    commonplace
    common sense
    commonwealth
    commotion
    communal
    commune
    communicable
    communicate
    communication
    communications
    communicative
    Communion
    communion
    communique
    communism
    communist
    community
    community center
    community college
    commute
    commuter
    compact
    compact disc
    companion
    companionable
    companionship
    company
    comparable
    comparative
    comparatively
    compare
    compared
    comparison
    compartment
    compartmentalize
    compass
    compassion
    compassionate
    compatibility
    compatible
    compatriot
    compel
    compelling
    compensate
    compensation
    compensatory
    compete
    competence
    competent
    competently
    competition
    competitive
    competitively
    competitiveness
    competitor
    compilation
    compile
    complacency
    complacent
    complain
    complaint
    complement
    complementary
    complete
    completely
    completion
    complex
    complexion
    complexity
    compliance
    compliant
    complicate
    complicated
    complication
    complicity
    compliment
    complimentary
    compliments
    comply
    component
    compose
    composed
    composer
    composite
    composition
    compost
    composure
    compound
    comprehend
    comprehensible
    comprehension
    comprehensive
    compress
    compression
    comprise
    compromise
    comp time
    compulsion
    compulsive
    compulsory
    compunction
    computation
    compute
    computer
    computerize
    computing
    comrade
    comradeship
    con
    con artist
    concave
    conceal
    concealment
    concede
    conceit
    conceited
    conceivable
    conceivably
    conceive
    concentrate
    concentrated
    concentration
    concentration camp
    concentric
    concept
    conception
    conceptual
    concern
    concerned
    concerning
    concert
    concerted
    concerto
    concession
    concession stand
    concierge
    conciliate
    conciliation
    conciliatory
    concise
    concisely
    conciseness
    conclude
    concluding
    conclusion
    conclusive
    conclusively
    concoct
    concoction
    concourse
    concrete
    concretely
    concur
    concurrence
    concurrent
    concurrently
    concussion
    condemn
    condemnation
    condensation
    condense
    condescend
    condescending
    condescension
    condiment
    condition
    conditional
    conditionally
    conditioner
    conditions
    condo
    condolence
    condom
    condominium
    condone
    condor
    conducive
    conduct
    conductor
    cone
    Confederacy
    confederacy
    Confederate
    confederate
    confederation
    confer
    conference
    conference call
    confess
    confessed
    confession
    confetti
    confidant
    confide
    confidence
    confident
    confidential
    confidentiality
    confidentially
    confidently
    confine
    confined
    confinement
    confines
    confirm
    confirmation
    confirmed
    confiscate
    confiscation
    conflict
    conflict of interest
    conform
    conformist
    conformity
    confound
    confront
    confrontation
    confuse
    confused
    confusing
    confusion
    congeal
    congenial
    congenital
    congested
    congestion
    conglomerate
    congratulate
    congratulations
    congratulatory
    congregate
    congregation
    Congress
    congress
    congressional
    congressman
    congresswoman
    conical
    conifer
    coniferous
    conjecture
    conjugal
    conjugate
    conjugation
    conjunction
    conjure
    con man
    connect
    connected
    connection
    connivance
    connive
    connoisseur
    connotation
    connote
    conquer
    conqueror
    conquest
    conscience
    conscientious
    conscientiously
    conscientious objector
    conscious
    consciously
    consciousness
    consecrate
    consecration
    consecutive
    consecutively
    consensus
    consent
    consequence
    consequent
    consequently
    conservation
    conservationist
    conservatism
    conservative
    conservatively
    conservator
    conservatory
    conserve
    consider
    considerable
    considerably
    considerate
    considerately
    consideration
    considering
    consign
    consignment
    consist
    consistency
    consistent
    consistently
    consolation
    console
    consolidate
    consolidation
    consomme
    consonant
    consort
    consortia
    consortium
    conspicuous
    conspicuously
    conspiracy
    conspirator
    conspiratorial
    conspire
    constant
    constantly
    constellation
    consternation
    constipated
    constipation
    constituency
    constituent
    constitute
    Constitution
    constitution
    constitutional
    constrain
    constraint
    constrict
    constriction
    construct
    construction
    construction paper
    constructive
    constructively
    construe
    consul
    consular
    consulate
    consult
    consultant
    consultation
    consulting
    consume
    consumer
    consuming
    consummate
    consummation
    consumption
    contact
    contact lens
    contagious
    contain
    container
    contaminate
    contamination
    contemplate
    contemplation
    contemplative
    contemporary
    contempt
    contemptible
    contemptuous
    contend
    contender
    content
    contented
    contentedly
    contention
    contentious
    contentment
    contents
    contest
    contestant
    context
    contiguous
    continent
    continental
    continental breakfast
    contingency
    contingent
    continual
    continually
    continuation
    continue
    continued
    continuing education
    continuity
    continuous
    continuously
    contort
    contortion
    contour
    contraband
    contraception
    contraceptive
    contract
    contraction
    contractor
    contractual
    contradict
    contradiction
    contradictory
    contraption
    contrary
    contrast
    contrasting
    contravene
    contravention
    contribute
    contribution
    contributor
    contributory
    contrite
    contrition
    contrive
    contrived
    control
    controlled
    controller
    control tower
    controversial
    controversy
    convalesce
    convalescence
    convalescent
    convene
    convenience
    convenience store
    convenient
    conveniently
    convent
    convention
    conventional
    conventionally
    converge
    conversant
    conversation
    conversational
    converse
    conversely
    conversion
    convert
    convertible
    convex
    convey
    conveyor belt
    convict
    conviction
    convince
    convinced
    convincing
    convincingly
    convivial
    convoluted
    convoy
    convulse
    convulsion
    coo

    cook
    cookbook
    cookie
    cooking
    cookout
    cool
    cooler
    coolly
    coolness
    coop
    cooperate
    cooperation
    cooperative
    co-opt
    coordinate
    coordination
    coordinator
    cop
    cope
    copier
    copilot
    copious
    cop-out
    copper
    copter
    copulate
    copulation
    copy
    copy machine
    copyright
    coral
    cord
    cordial
    cordiality
    cordially
    cordless
    cordon
    corduroy
    core
    cork
    corkscrew
    corn
    cornbread
    cornea
    corner
    cornerstone
    cornet
    cornflakes
    cornmeal
    cornstarch
    corny
    coronary
    coronation
    coroner
    corp.
    corporal
    corporal punishment
    corporate
    corporation
    corps
    corpse
    corpulent
    corpuscle
    corral
    correct
    correction
    corrective
    correctly
    correctness
    correlate
    correlation
    correspond
    correspondence
    correspondent
    corresponding
    correspondingly
    corridor
    corroborate
    corroboration
    corrode
    corrosion
    corrosive
    corrugated
    corrupt
    corruptible
    corruption
    corsage
    corset
    cosmetic
    cosmic
    cosmonaut
    cosmopolitan
    cosmos
    cost
    costar
    cost-effective
    costly
    cost of living
    costume
    cot
    cottage
    cottage cheese
    cotton
    cottonwood
    couch
    couch potato
    cougar
    cough
    could
    couldn't
    council
    councilor
    counsel
    counseling
    counselor
    count
    countable
    countdown
    countenance
    counter
    counteract
    counterattack
    counterbalance
    counterclockwise
    counterfeit
    counterfeiter
    counterpart
    counterproductive
    countersign
    countless
    country
    country and western
    countryman
    country music
    countryside
    countrywoman
    county
    coup
    coup d'etat
    couple
    coupon
    courage
    courageous
    courageously
    courier
    course
    court
    courteous
    courteously
    courtesy
    courthouse
    court-martial
    court of law
    courtroom
    courtship
    courts-martial
    courtyard
    cousin
    cove
    covenant
    cover
    coverage
    coveralls
    covered
    covering
    cover letter
    covers
    covert
    covertly
    cover-up
    covet
    covetous
    cow
    coward
    cowardice
    cowardly
    cowboy
    cower
    cowgirl
    coworker
    coy
    coyote
    cozy
    CPA
    crab
    crabby
    crack
    crackdown
    cracked
    cracker
    crackle
    crackpot
    cradle
    craft
    craftily
    craftsman
    craftsmanship
    crafty
    craggy
    cram
    crammed
    cramp
    cramped
    cramps
    cranberry
    crane
    cranium
    crank
    cranky
    cranny
    crap
    crappy
    craps
    crash
    crash course
    crash landing
    crass
    crate
    crater
    cravat
    crave
    craving
    crawl
    crayfish
    crayon
    craze
    crazed
    crazily
    craziness
    crazy
    creak
    creaky
    cream
    cream cheese
    creamy
    crease
    create
    creation
    creative
    creatively
    creativity
    creator
    creature
    credence
    credentials
    credibility
    credible
    credibly
    credit
    creditable
    credit card
    credit limit
    creditor
    credit rating
    credo
    creed
    creek
    creep
    creepy
    cremate
    cremation
    crematoria
    crematorium
    creole
    crepe
    crepe paper
    crept
    crescendo
    crescent
    crest
    crestfallen
    crevasse
    crevice
    crew
    crew cut
    crib
    crib sheet
    crick
    cricket
    crime
    criminal
    crimp
    crimson
    cringe
    crinkle
    crinkly
    cripple
    crippled
    crippling
    crises
    crisis
    crisp
    crisply
    crispy
    crisscross
    criteria
    criterion
    critic
    critical
    critically
    criticism
    criticize
    critique
    critter
    croak
    crochet
    crock
    crockery
    crocodile
    crocus
    croissant
    crony
    crook
    crooked
    croon
    crooner
    crop
    croquet
    cross
    crossbow
    crosscheck
    cross-country
    cross-examination
    cross-examine
    cross-eyed
    crossfire
    crossing
    cross-legged
    crossover
    cross-purposes
    cross-reference
    crossroads
    cross section
    cross street
    crosstown
    crosswalk
    crossword
    crossword puzzle
    crotch
    crouch
    crow
    crowbar
    crowd
    crowded
    crown
    crowning
    crown prince
    crown princess
    crucial
    crucially
    crucifix
    crucifixion
    crucify
    crud
    cruddy
    crude
    crudely
    cruel
    cruelly
    cruelty
    cruise
    cruise control
    cruiser
    cruise ship
    crumb
    crumble
    crummy
    crumple
    crunch
    crunchy
    crusade
    crusader
    crush
    crushing
    crust
    crustacean
    crusty
    crutch
    crux
    cry
    crybaby
    crying
    crypt
    cryptic
    cryptically
    crystal
    crystal ball
    crystallization
    crystallize
    C-section
    cu.
    cub
    cube
    cubic
    cubicle
    Cub Scout
    Cub Scouts
    cuckoo
    cucumber
    cuddle
    cuddly
    cue
    cuff
    cuff link
    cuisine
    cul-de-sac
    culinary
    cull
    culminate
    culmination
    culpability
    culpable
    culprit
    cult
    cultivate
    cultivated
    cultivation
    cultural
    culturally
    culture
    cultured
    culture shock
    cumbersome
    cumulative
    cunning
    cunningly
    cup
    cupboard
    cupcake
    curable
    curator
    curb
    curd
    curdle
    cure
    curfew
    curio
    curiosity
    curious
    curiously
    curl
    curler
    curly
    currant
    currency
    current
    current affairs
    currently
    curricula
    curriculum
    curry
    curry powder
    curse
    cursed
    cursor
    cursory
    curt
    curtail
    curtain
    curtsy
    curve
    curvy
    cushion
    cuss
    custard
    custodial
    custodian
    custody
    custom
    customarily
    customary
    custom-built
    customer
    customize
    custom-made
    customs
    cut
    cut-and-dried
    cutback
    cute
    cutely
    cuteness
    cuticle
    cutlery
    cutlet
    cutoff
    cut-rate
    cutter
    cutthroat
    cutting
    cutting edge
    cyanide
    cyberspace
    cycle
    cyclical
    cyclist
    cyclone
    cylinder
    cylindrical
    cymbal
    cynic
    cynical
    cynically
    cynicism
    Cyrillic
    cyst
    czar
ManyThings.org

    Reading
    Sentences
    More

English Vocabulary Word Lists with Games, Puzzles and Quizzes

English Vocabulary Word List
Alan Beale's Core Vocabulary - D (1291 Words)

    dab
    dabble
    dachshund
    dad
    daddy
    daffodil
    dagger
    daily
    daintily
    dainty
    dairy
    dairy cattle
    dairy farm
    daisy
    dally
    Dalmatian
    dam
    damage
    damages
    damaging
    dame
    damn
    damned
    damning
    damp
    dampen
    damper
    dampness
    damsel
    dance
    dancer
    dancing
    dandelion
    dandruff
    dandy
    danger
    dangerous
    dangerously
    dangle
    Danish
    Danish pastry
    dank
    dapper
    dare
    daredevil
    daring
    dark
    darken
    dark glasses
    dark horse
    darkness
    darkroom
    darling
    darn
    darned
    dart
    darts
    dash
    dashboard
    data
    database
    data processing
    date
    dated
    daub
    daughter
    daughter-in-law
    daughters-in-law
    daunt
    daunting
    dawdle
    dawn
    day
    daybreak
    day care
    daydream
    daydreamer
    Day-Glo
    daylight
    daylight saving time
    days
    daytime
    day-to-day
    daze
    dazed
    dazzle
    dazzling
    DC
    D.C.
    DDT
    deacon
    deaconess
    dead
    deaden
    dead end
    dead heat
    deadline
    deadlock
    deadly
    deadpan
    deaf
    deafen
    deafening
    deafness
    deal
    dealer
    dealership
    dealing
    dealings
    dealt
    dean
    dean's list
    dear
    dearly
    dearth
    death
    deathbed
    death penalty
    death row
    death toll
    deathtrap
    debase
    debasement
    debatable
    debate
    debauchery
    debilitate
    debilitating
    debility
    debit
    debonair
    debrief
    debriefing
    debris
    debt
    debtor
    debug
    debunk
    debut
    debutante
    Dec.
    decade
    decadence
    decadent
    decaf
    decaffeinated
    decal
    decanter
    decapitate
    decathlon
    decay
    deceased
    deceit
    deceitful
    deceitfully
    deceitfulness
    deceive
    December
    decency
    decent
    decently
    decentralization
    decentralize
    deception
    deceptive
    deceptively
    decibel
    decide
    decided
    decidedly
    deciduous
    decimal
    decimal point
    decimate
    decipher
    decision
    decisive
    decisively
    deck
    declaration
    declare
    decline
    decode
    decompose
    decomposition
    decor
    decorate
    decoration
    decorative
    decorator
    decorous
    decorum
    decoy
    decrease
    decree
    decrepit
    decriminalize
    decry
    dedicate
    dedicated
    dedication
    deduce
    deduct
    deductible
    deduction
    deed
    deem
    deep
    deepen
    deeply
    deep-seated
    Deep South
    deer
    deface
    defamation
    defamatory
    defame
    default
    defeat
    defeatist
    defecate
    defect
    defection
    defective
    defector
    defend
    defendant
    defender
    defense
    defenseless
    defense mechanism
    defensible
    defensive
    defensively
    defer
    deference
    deferential
    defiance
    defiant
    defiantly
    deficiency
    deficient
    deficit
    defile
    define
    definite
    definite article
    definitely
    definition
    definitive
    definitively
    deflate
    deflation
    deflect
    deflection
    deforestation
    deform
    deformation
    deformed
    deformity
    defraud
    defrost
    deft
    deftly
    defunct
    defuse
    defy
    degenerate
    degeneration
    degradation
    degrade
    degrading
    degree
    dehydrate
    dehydrated
    dehydration
    deign
    deity
    deja vu
    dejected
    dejectedly
    dejection
    delay
    delayed
    delectable
    delegate
    delegation
    delete
    deletion
    deli
    deliberate
    deliberately
    deliberation
    delicacy
    delicate
    delicately
    delicatessen
    delicious
    delight
    delighted
    delightful
    delightfully
    delineate
    delinquency
    delinquent
    delirious
    deliriously
    delirium
    deliver
    delivery
    delta
    delude
    deluded
    deluge
    delusion
    deluxe
    delve
    demagogic
    demagogue
    demand
    demanding
    demands
    demean

    demeaning
    demeanor
    demented
    demerit
    demise
    demo
    democracy
    Democrat
    Democratic
    democratic
    democratically
    Democratic Party
    demographics
    demolish
    demolition
    demon
    demonic
    demonstrate
    demonstration
    demonstrative
    demonstrator
    demoralize
    demoralizing
    demote
    demotion
    demure
    den
    denial
    denigrate
    denim
    denomination
    denote
    denounce
    dense
    densely
    density
    dent
    dental
    dental floss
    dented
    dentist
    dentures
    denunciation
    deny
    deodorant
    deodorize
    depart
    department
    departmental
    department store
    departure
    depend
    dependable
    dependence
    dependency
    dependent
    depict
    deplete
    depletion
    deplorable
    deplorably
    deplore
    deploy
    deployment
    deport
    deportation
    depose
    deposit
    depot
    depraved
    depravity
    depreciate
    depreciation
    depress
    depressed
    depressing
    depression
    deprivation
    deprive
    deprived
    dept.
    depth
    deputy
    derail
    derailment
    deranged
    derby
    derelict
    deride
    derision
    derivation
    derivative
    derive
    derogatory
    descend
    descendant
    descent
    describe
    description
    descriptive
    desecrate
    desecration
    desegregate
    desegregation
    desert
    deserted
    deserter
    deserve
    deserving
    design
    designate
    designation
    designer
    designing
    desirability
    desirable
    desire
    desirous
    desist
    desk
    desktop
    desktop computer
    desolate
    desolation
    despair
    desperate
    desperately
    desperation
    despicable
    despise
    despite
    despondent
    despondently
    despot
    despotic
    dessert
    destination
    destined
    destiny
    destitute
    destitution
    destroy
    destroyer
    destruction
    destructive
    detach
    detached
    detachment
    detail
    detailed
    detain
    detect
    detection
    detective
    detector
    detente
    detention
    deter
    detergent
    deteriorate
    deterioration
    determination
    determine
    determined
    determiner
    deterrence
    deterrent
    detest
    detonate
    detonation
    detonator
    detour
    detox
    detract
    detriment
    detrimental
    devaluation
    devalue
    devastate
    devastated
    devastating
    devastation
    develop
    developed
    developer
    developing
    development
    deviant
    deviate
    deviation
    device
    devil
    devilish
    devil's advocate
    devious
    devise
    devoid
    devote
    devoted
    devotedly
    devotee
    devotion
    devour
    devout
    devoutly
    dew
    dexterity
    dexterous
    diabetes
    diabetic
    diabolical
    diagnose
    diagnoses
    diagnosis
    diagnostic
    diagonal
    diagonally
    diagram
    dial
    dialect
    dialogue
    dial tone
    diameter
    diametrically
    diamond
    diamond anniversary
    diamonds
    diaper
    diaphragm
    diarrhea
    diary
    dice
    dicey
    dichotomy
    dick
    dictate
    dictation
    dictator
    dictatorial
    dictatorship
    diction
    dictionary
    did
    didn't
    die
    diehard
    diesel
    diesel engine
    diet
    differ
    difference
    different
    differentiate
    differently
    difficult
    difficulty
    diffuse
    dig
    digest
    digestion
    digestive
    digit
    digital
    dignified
    dignitary
    dignity
    digress
    digression
    dike
    dilapidated
    dilapidation
    dilate
    dilation
    dilemma
    diligence
    diligent
    diligently
    dilute
    dilution
    dim
    dime
    dimension
    dimensions
    diminish
    diminutive
    dimly
    dimple
    din
    dine
    diner
    ding-dong
    dinghy
    dingy
    dining room
    dinner
    dinosaur
    diocese
    dip
    diphtheria
    diphthong
    diploma
    diplomacy
    diplomat
    diplomatic
    diplomatically
    dipstick
    dire
    direct
    direction
    directions
    directive
    directly
    direct object
    director
    directory
    dirt
    dirt-cheap
    dirt-poor
    dirty
    dis
    disability
    disable
    disabled

    disadvantage
    disadvantaged
    disaffected
    disagree
    disagreeable
    disagreement
    disallow
    disappear
    disappearance
    disappoint
    disappointed
    disappointing
    disappointingly
    disappointment
    disapproval
    disapprove
    disapproving
    disapprovingly
    disarm
    disarmament
    disarming
    disarray
    disaster
    disastrous
    disastrously
    disavow
    disavowal
    disband
    disbelief
    disbelieve
    discard
    discern
    discernible
    discerning
    discharge
    disciple
    disciplinarian
    disciplinary
    discipline
    disciplined
    disclaim
    disclaimer
    disclose
    disclosure
    disco
    discolor
    discoloration
    discomfort
    disconcert
    disconcerted
    disconcerting
    disconnect
    disconnection
    discontent
    discontented
    discontinuation
    discontinue
    discord
    discordant
    discount
    discount store
    discourage
    discouraged
    discouragement
    discouraging
    discourse
    discourteous
    discourtesy
    discover
    discoverer
    discovery
    discredit
    discreet
    discreetly
    discrepancy
    discretion
    discretionary
    discriminate
    discriminating
    discrimination
    discus
    discuss
    discussion
    disdain
    disdainful
    disease
    diseased
    disembark
    disembarkation
    disenchanted
    disenchantment
    disenfranchise
    disengage
    disentangle
    disfavor
    disfigure
    disfigurement
    disgrace
    disgraceful
    disgracefully
    disgruntled
    disguise
    disgust
    disgusted
    disgusting
    dish
    dishearten
    disheartening
    disheveled
    dishonest
    dishonestly
    dishonesty
    dishonor
    dishonorable
    dishonorably
    dishtowel
    dishwasher
    disillusion
    disillusioned
    disillusionment
    disinfect
    disinfectant
    disinherit
    disintegrate
    disintegration
    disinterest
    disinterested
    disjointed
    disk
    disk drive
    diskette
    disk jockey
    dislike
    dislocate
    dislocation
    dislodge
    disloyal
    disloyalty
    dismal
    dismally
    dismantle
    dismay
    dismember
    dismiss
    dismissal
    dismissive
    dismount
    disobedience
    disobedient
    disobey
    disorder
    disordered
    disorderly
    disorganization
    disorganized
    disorient
    disorientation
    disoriented
    disown
    disparage
    disparaging
    disparate
    disparity
    dispassionate
    dispassionately
    dispatch
    dispel
    dispensable
    dispensary
    dispensation
    dispense
    dispenser
    dispersal
    disperse
    dispirited
    displace
    displacement
    display
    displease
    displeasure
    disposable
    disposal
    dispose
    disposed
    dispossess
    disproportionate
    disproportionately
    disprove
    dispute
    disqualification
    disqualify
    disregard
    disrepair
    disreputable
    disrepute
    disrespect
    disrespectful
    disrespectfully
    disrupt
    disruption
    disruptive
    dissatisfaction
    dissatisfied
    dissect
    dissection
    disseminate
    dissemination
    dissension
    dissent
    dissenter
    dissenting
    dissertation
    disservice
    dissidence
    dissident
    dissimilar
    dissimilarity
    dissipate
    dissociate
    dissociation
    dissolute
    dissolution
    dissolve
    dissuade
    distance
    distant
    distaste
    distasteful
    distastefully
    distend
    distention
    distill
    distillation
    distillery
    distinct
    distinction
    distinctive
    distinctively
    distinctly
    distinguish
    distinguishable
    distinguished
    distort
    distorted
    distortion
    distract
    distracted
    distraction
    distraught
    distress
    distressing
    distribute
    distribution
    distributor
    district
    district attorney
    district court
    distrust
    distrustful
    distrustfully
    disturb
    disturbance
    disturbed
    disturbing
    disuse
    ditch
    dither
    ditto
    ditty
    dive
    diver
    diverge
    divergence
    divergent
    diverse
    diversification
    diversify
    diversion
    diversity
    divert
    divest
    divide
    divided highway
    dividend
    divider
    divine
    divinely
    diving
    diving board
    divinity
    divisible
    division
    divisive
    divorce
    divorced
    divorcee
    divulge
    Dixie
    dizziness
    dizzy
    DJ
    DNA
    do
    docile
    dock
    docket
    doctor
    doctorate
    doctrine
    document
    documentary
    documentation
    dodge
    doe
    does
    doesn't
    dog
    dog-eared
    dogged
    doggedly
    doggone
    doggy bag
    doghouse

    dogma
    dogmatic
    dogwood
    doldrums
    dole
    doleful
    doll
    dollar
    dollhouse
    dollop
    dolly
    dolphin
    domain
    dome
    domestic
    domesticate
    domesticated
    domesticity
    domicile
    dominance
    dominant
    dominate
    domination
    domineering
    dominion
    domino
    dominoes
    donate
    donation
    done
    donkey
    donor
    don't
    doodad
    doodle
    doohickey
    doom
    doomed
    doomsday
    door
    doorbell
    doorknob
    doorman
    doormat
    doorstep
    doorway
    dope
    dopey
    dork
    dorky
    dorm
    dormant
    dormitory
    dorsal
    dosage
    dose
    dossier
    dot
    dote
    doting
    dotted line
    double
    double bass
    double-breasted
    double-check
    double chin
    double-cross
    double-decker
    double-decker bus
    double-digit
    double-jointed
    double negative
    double-park
    doubles
    double-spaced
    double standard
    double-talk
    doubly
    doubt
    doubtful
    doubtfully
    doubtless
    dough
    doughnut
    dour
    douse
    dove
    dowdy
    down
    downcast
    downer
    downfall
    downgrade
    downhearted
    downhill
    download
    down payment
    downplay
    downpour
    downright
    downsize
    downsizing
    Down's syndrome
    downstairs
    downstate
    downstream
    downtime
    down-to-earth
    downtown
    downtrodden
    downturn
    downward
    downwards
    downwind
    downy
    dowry
    doz.
    doze
    dozen
    dozens
    Dr.
    drab
    draconian
    draft
    draftsman
    drafty
    drag
    dragon
    drag race
    drain
    drainage
    drake
    drama
    dramatic
    dramatically
    dramatics
    dramatist
    dramatization
    dramatize
    drank
    drape
    drapery
    drapes
    drastic
    drastically
    draw
    drawback
    drawbridge
    drawer
    drawing
    drawing board
    drawl
    drawn
    dread
    dreaded
    dreadful
    dreadfully
    dreadlocks
    dream
    dreamer
    dreamt
    dreamy
    dreary
    dredge
    dregs
    drench
    dress
    dress code
    dresser
    dressing
    dressing room
    dressmaker
    dress rehearsal
    dressy
    drew
    dribble
    dribs and drabs
    dried
    drier
    drift
    drifter
    driftwood
    drill
    drink
    drinker
    drinking
    drinking fountain
    drinking water
    drip
    drip-dry
    drive
    drive-by
    drive-in
    drivel
    driven
    driver
    driver's license
    drive-through
    driveway
    driving
    drizzle
    droll
    drone
    drool
    droop
    drooping
    drop
    dropout
    droppings
    drops
    drought
    drove
    drown
    drowning
    drowsily
    drowsiness
    drowsy
    drudge
    drudgery
    drug
    drug addict
    drug addiction
    drugstore
    drum
    drummer
    drunk
    drunkard
    drunken
    drunkenly
    drunkenness
    dry
    dry-clean
    dry cleaners
    dryer
    dry goods
    dry ice
    dry land
    dryly
    dryness
    dry run
    dual
    dub
    dubious
    duchess
    duck
    duckling
    duct
    dud
    dude
    dude ranch
    duds
    due
    duel
    due process
    dues
    duet
    duffel bag
    dug
    dugout
    duke
    dull
    dullness
    duly
    dumb
    dumbbell
    dumbfounded
    dummy
    dump
    dumpling
    Dumpster
    dump truck
    dumpy
    dunce
    dune
    dung
    dungeon
    dunk
    duo
    dupe
    duplex
    duplicate
    duplication
    duplicity
    durability
    durable
    duration
    duress
    during
    dusk
    dust
    dust jacket
    dustpan
    dusty
    Dutch
    dutiful
    dutifully
    duty
    duty-free
    DVD
    dwarf
    dwarves
    dwell
    dweller
    dwelling
    dwelt
    dwindle
    dwindling
    dye
    dyed-in-the-wool
    dying
    dyke
    dynamic
    dynamics
    dynamism
    dynamite
    dynamo
    dynasty
    dysentery
    dysfunction
    dysfunctional
    dyslexia
    dyslexic
ManyThings.org

    Reading
    Sentences
    More

English Vocabulary Word Lists with Games, Puzzles and Quizzes

English Vocabulary Word List
Alan Beale's Core Vocabulary - E (906 Words)

    each other
    eager
    eagerly
    eagerness
    eagle
    eagle-eyed
    ear
    earache
    eardrum
    earlobe
    early
    earmark
    earmuffs
    earn
    earnest
    earnestly
    earnestness
    earnings
    earphones
    earplug
    earring
    earshot
    earsplitting
    Earth
    earth
    earthiness
    earthly
    earthquake
    earthshaking
    earthworm
    earthy
    earwax
    ease
    easel
    easily
    east
    eastbound
    Easter
    Easter egg
    easterly
    eastern
    easterner
    eastward
    eastwards
    easy
    easy chair
    easygoing
    eat
    eaten
    eater
    eatery
    eaves
    eavesdrop
    eavesdropper
    ebb
    ebony
    ebullience
    ebullient
    eccentric
    eccentricity
    ecclesiastical
    echo
    eclair
    eclipse
    ecological
    ecologically
    ecologist
    ecology
    economic
    economical
    economically
    economics
    economist
    economize
    economy
    ecosystem
    ecstasy
    ecstatic
    ecumenical
    eczema
    eddy
    edge
    edgewise
    edgy
    edible
    edict
    edification
    edifice
    edify
    edit
    edition
    editor
    editorial
    educate
    educated
    education
    educational
    educationally
    educator
    eel
    eerie
    eerily
    effect
    effective
    effectively
    effectiveness
    effects
    effeminate
    effervescence
    effervescent
    efficiency
    efficient
    efficiently
    effigy
    effort
    effortless
    effortlessly
    effusive
    effusively
    EFL
    e.g.
    egalitarian
    egalitarianism
    egg
    egghead
    eggplant
    eggshell
    ego
    egocentric
    egotism
    egotist
    egotistical
    egregious
    egregiously
    eh
    eight
    eighteen
    eighteenth
    eighth
    eightieth
    eighty
    either
    ejaculate
    ejaculation
    eject
    ejection
    eke
    elaborate
    elaborately
    elaboration
    elapse
    elastic
    elasticity
    elated
    elation
    elbow
    elbowroom
    elder
    elderly
    elders
    eldest
    elect
    election
    elective
    electoral
    electoral college
    electorate
    electric
    electrical
    electric chair
    electrician
    electricity
    electric razor
    electric shock
    electrify
    electrifying
    electrocute
    electrocution
    electrode
    electrolysis
    electron
    electronic
    electronically
    electronic mail
    electronics
    elegance
    elegant
    elegantly
    elegy
    element
    elemental
    elementary
    elementary school
    elements
    elephant
    elevate
    elevation
    elevator
    eleven
    eleventh
    elf
    elfin
    elicit
    eligibility
    eligible
    eliminate
    elimination
    elite
    elitism
    elitist
    elk
    elliptical
    elm
    elongate
    elongated
    elope
    elopement
    eloquence
    eloquent
    eloquently
    else
    elsewhere
    elucidate
    elude
    elusive
    elves
    'em

    emaciated
    e-mail
    emanate
    emancipate
    emancipated
    emancipation
    embalm
    embankment
    embargo
    embark
    embarrass
    embarrassed
    embarrassing
    embarrassingly
    embarrassment
    embassy
    embattled
    embed
    embellish
    embellishment
    ember
    embezzle
    embezzlement
    embezzler
    embitter
    embittered
    emblazon
    emblem
    embodiment
    embody
    emboss
    embossed
    embrace
    embroider
    embroidery
    embroil
    embryo
    embryonic
    emcee
    emerald
    emerge
    emergence
    emergency
    emergency brake
    emergency room
    emergent
    emeritus
    emery board
    emigrant
    emigrate
    emigration
    eminent
    eminently
    emir
    emirate
    emissary
    emission
    emit
    Emmy
    emotion
    emotional
    emotionally
    emotive
    empathize
    empathy
    emperor
    emphases
    emphasis
    emphasize
    emphatic
    emphatically
    emphysema
    empire
    empirical
    employ
    employee
    employer
    employment
    employment agency
    emporium
    empower
    empowerment
    empress
    emptiness
    empty
    empty-handed
    emulate
    enable
    enact
    enamel
    enamored
    encase
    enchanted
    enchanting
    enchilada
    encircle
    enclave
    enclose
    enclosure
    encompass
    encore
    encounter
    encourage
    encouragement
    encouraging
    encroach
    encumber
    encumbrance
    encyclopedia
    end
    endanger
    endangered
    endangered species
    endear
    endearing
    endearment
    endeavor
    endemic
    ending
    endive
    endless
    endlessly
    endorse
    endorsement
    endow
    endowment
    endurance
    endure
    enduring
    end zone
    enemy
    energetic
    energetically
    energies
    energize
    energy
    enforce
    enforceable
    enforcement
    enfranchise
    engage
    engaged
    engagement
    engagement ring
    engaging
    engender
    engine
    engineer
    engineering
    English
    engrave
    engraving
    engrossed
    engrossing
    engulf
    enhance
    enhancement
    enigma
    enigmatic
    enjoy
    enjoyable
    enjoyment
    enlarge
    enlargement
    enlighten
    enlightened
    enlightening
    enlist
    enlistment
    enliven
    en masse
    enmity
    enormity
    enormous
    enormously
    enough
    enrage
    enraged
    enrich
    enrichment
    enroll
    enrollment
    en route
    ensconce
    ensemble
    enshrine
    ensign
    ensue
    ensuing
    ensure
    entail
    entangle
    entangled
    entanglement
    enter
    enterprise
    enterprising
    entertain
    entertainer
    entertaining
    entertainment
    enthrall
    enthralling
    enthuse
    enthusiasm
    enthusiast
    enthusiastic
    enthusiastically
    entice
    enticement
    enticing
    entire
    entirely
    entirety
    entitle
    entitled
    entitlement
    entity
    entomologist
    entomology
    entourage
    entrails
    entrance
    entrance ramp
    entrant
    entrap
    entrapment

    entreat
    entreaty
    entree
    entrepreneur
    entrepreneurial
    entrust
    entry
    entry-level
    entryway
    entwine
    enumerate
    enunciate
    enunciation
    envelop
    envelope
    enviable
    envious
    enviously
    environment
    environmental
    environmentalist
    environmentally
    environs
    envisage
    envision
    envoy
    envy
    enzyme
    epaulet
    ephemeral
    epic
    epicenter
    epidemic
    epigram
    epilepsy
    epileptic
    epilogue
    Episcopal Church
    Episcopalian
    episode
    episodic
    epistle
    epitaph
    epithet
    epitome
    epitomize
    epoch
    equal
    equality
    equalize
    equally
    equal sign
    equanimity
    equate
    equation
    equator
    equatorial
    equestrian
    equilateral
    equilibrium
    equine
    equinox
    equip
    equipment
    equipped
    equitable
    equity
    equivalence
    equivalent
    equivocal
    ER
    era
    eradicate
    eradication
    erase
    eraser
    erect
    erection
    erode
    erosion
    erotic
    erotically
    eroticism
    err
    errand
    errant
    erratic
    erratically
    erroneous
    erroneously
    error
    erudite
    erudition
    erupt
    eruption
    escalate
    escalation
    escalator
    escapade
    escape
    escaped
    escapism
    escapist
    eschew
    escort
    Eskimo
    ESL
    esophagus
    esoteric
    ESP
    esp.
    especially
    espionage
    espouse
    espresso
    essay
    essence
    essential
    essentially
    establish
    establishment
    estate
    esteem
    esthetic
    esthetically
    estimable
    estimate
    estimated
    estimation
    estranged
    estrangement
    estrogen
    estuary
    et al.
    etc.
    etch
    eternal
    eternally
    eternity
    ether
    ethereal
    ethic
    ethical
    ethically
    ethics
    ethnic
    etiquette
    etymology
    eulogize
    eulogy
    eunuch
    euphemism
    euphemistic
    euphemistically
    euphoria
    euphoric
    Europe
    European
    euthanasia
    evacuate
    evacuation
    evacuee
    evade
    evaluate
    evaluation
    evangelical
    evangelism
    evangelist
    evaporate
    evaporation
    evasion
    evasive
    eve
    even
    evenhanded
    evening
    evenings
    evenly
    evenness
    event
    eventful
    eventual
    eventuality
    eventually
    ever
    evergreen
    everlasting
    evermore
    every
    everybody
    everyday
    everyone
    everyplace
    everything
    everywhere
    evict
    eviction
    evidence
    evident
    evidently
    evil
    evocative
    evoke
    evolution
    evolutionary
    evolve
    ewe
    ex
    exacerbate
    exact
    exacting
    exactly
    exaggerate
    exaggerated
    exaggeration
    exalt
    exaltation
    exam
    examination
    examine
    examiner
    example
    exasperate
    exasperated
    exasperating
    exasperation
    excavate

    excavation
    exceed
    exceedingly
    excel
    excellence
    excellent
    excellently
    except
    exception
    exceptional
    exceptionally
    excerpt
    excess
    excesses
    excessive
    excessively
    exchange
    exchange rate
    excise
    excision
    excitable
    excite
    excited
    excitedly
    excitement
    exciting
    exclaim
    exclamation
    exclamation point
    exclude
    excluding
    exclusion
    exclusive
    exclusively
    excommunicate
    excommunication
    excrement
    excrete
    excruciating
    excruciatingly
    excursion
    excusable
    excuse
    exec
    execute
    execution
    executioner
    executive
    executor
    exemplary
    exemplify
    exempt
    exemption
    exercise
    exert
    exertion
    exhale
    exhaust
    exhausted
    exhausting
    exhaustion
    exhaustive
    exhaustively
    exhibit
    exhibition
    exhibition game
    exhibitionism
    exhibitionist
    exhibitor
    exhilarate
    exhilarating
    exhilaration
    exhort
    exhortation
    exhumation
    exhume
    exile
    exist
    existence
    existing
    exit
    exit poll
    exit ramp
    exodus
    exonerate
    exoneration
    exorbitant
    exorcism
    exorcist
    exotic
    expand
    expanded
    expanse
    expansion
    expansionist
    expansive
    expatriate
    expect
    expectancy
    expectant
    expectantly
    expectation
    expediency
    expedient
    expedite
    expedition
    expel
    expend
    expendable
    expenditure
    expense
    expense account
    expenses
    expensive
    expensively
    experience
    experienced
    experiment
    experimental
    experimentally
    experimentation
    expert
    expertise
    expertly
    expiration
    expiration date
    expire
    explain
    explanation
    explanatory
    expletive
    explicable
    explicit
    explicitly
    explode
    exploit
    exploitation
    exploration
    exploratory
    explore
    explorer
    explosion
    explosive
    expo
    exponent
    export
    exportation
    exporter
    expose
    exposed
    exposition
    exposure
    express
    expression
    expressive
    expressively
    expressly
    expressway
    expropriate
    expropriation
    expulsion
    exquisite
    exquisitely
    extemporaneous
    extend
    extended family
    extension
    extensive
    extensively
    extent
    exterior
    exterminate
    extermination
    exterminator
    external
    extinct
    extinction
    extinguish
    extinguisher
    extol
    extort
    extortion
    extortionate
    extra
    extract
    extraction
    extracurricular
    extradite
    extradition
    extraneous
    extraordinarily
    extraordinary
    extrapolate
    extraterrestrial
    extravagance
    extravagant
    extravagantly
    extreme
    extremely
    extremism
    extremist
    extremities
    extremity
    extricate
    extrovert
    extroverted
    exuberance
    exuberant
    exude
    exult
    exultant
    exultation
    eye
    eyeball
    eyebrow
    eye-catching
    eyeglasses
    eyelash
    eyelid
    eyeliner
    eye-opener
    eye shadow
    eyesight
    eyesore
    eyewitness
 ManyThings.org

    Reading
    Sentences
    More

English Vocabulary Word Lists with Games, Puzzles and Quizzes

English Vocabulary Word List
Alan Beale's Core Vocabulary - F (1074 Words)

    fabric
    fabricate
    fabrication
    fabulous
    facade
    face
    faceless
    face-lift
    face-saving
    facet
    facetious
    facetiously
    face value
    facial
    facile
    facilitate
    facilities
    facility
    facsimile
    fact
    faction
    factor
    factory
    factual
    faculty
    fad
    fade
    fag
    faggot
    Fahrenheit
    fail
    failing
    fail-safe
    failure
    faint
    fair
    fairground
    fairly
    fairy
    fairy tale
    fait accompli
    faith
    faithful
    faithfully
    faithfulness
    faithless
    fake
    falcon
    fall
    fallacious
    fallacy
    fallen
    fall guy
    fallible
    fallout
    false
    falsehood
    falsetto
    falsification
    falsify
    falsity
    falter
    faltering
    fame
    famed
    familiar
    familiarity
    familiarize
    familiarly
    family
    family doctor
    family name
    family planning
    family room
    family tree
    family values
    famine
    famished
    famous
    famously
    fan
    fanatic
    fanatical
    fanatically
    fanaticism
    fanciful
    fancy
    fanfare
    fang
    fan mail
    fanny
    fantasize
    fantastic
    fantastically
    fantasy
    far
    faraway
    farce
    farcical
    fare
    Far East
    farewell
    far-fetched
    far-flung
    farm
    farmer
    farmers' market
    farmhouse
    farming
    farmyard
    far-off
    far-out
    far-reaching
    farsighted
    fart
    farther
    farthest
    fascinate
    fascinating
    fascination
    fascism
    fascist
    fashion
    fashionable
    fashionably
    fast
    fasten
    fastener
    fastening
    fast food
    fast-forward
    fastidious
    fast lane
    fat
    fatal
    fatalism
    fatalistic
    fatality
    fatally
    fate
    fated
    fateful
    Father
    father
    fatherhood
    father-in-law
    fatherly
    Father's Day
    fathers-in-law
    fathom
    fatigue
    fatten
    fattening
    fatty
    fatuous
    faucet
    fault
    faultless
    faulty
    fauna
    faux pas
    favor
    favorable
    favorably
    favorite
    favoritism
    fawn
    fax
    faze
    FBI
    fear
    fearful
    fearfully
    fearless
    fearlessly
    fearlessness
    feasibility
    feasible
    feast
    feat
    feather
    feathery
    feature
    Feb.
    February
    fecal
    feces
    Fed
    fed
    federal
    federalism
    federalist
    Federal Reserve System
    federate
    federation
    fed up
    fee
    feeble
    feeble-minded
    feed
    feedback
    feedbag
    feeding
    feel
    feeler
    feeling
    feelings
    feet
    feign
    feint
    feisty
    feline
    fell
    fellow
    fellowship
    felon
    felony
    felt
    felt-tip pen
    fem.
    female
    feminine
    femininity
    feminism
    feminist
    fence
    fencing
    fend
    fender
    fender-bender
    ferment
    fermentation
    fermented
    fern
    ferocious
    ferociously
    ferocity
    ferret
    Ferris wheel
    ferry
    fertile
    fertility
    fertilization
    fertilize
    fertilizer
    fervent
    fervently
    fervor
    fest
    fester
    festival
    festive
    festivities
    festivity
    fetal
    fetal position
    fetch
    fetching
    fete
    fetid
    fetish
    fetter
    fetters
    fetus
    feud
    feudal
    feudalism
    fever
    feverish

    feverishly
    few
    fez
    fiance
    fiancee
    fiasco
    fiat
    fib
    fibber
    fiber
    fiberglass
    fibrous
    fickle
    fiction
    fictional
    fictitious
    fiddle
    fiddler
    fidelity
    fidget
    fidgety
    field
    field day
    field hockey
    field test
    field-test
    field trip
    fieldwork
    fiend
    fiendish
    fierce
    fiercely
    fiery
    fiesta
    fifteen
    fifteenth
    fifth
    fiftieth
    fifty
    fifty-fifty
    fig
    fig.
    fight
    fighter
    fighting
    figment
    figurative
    figuratively
    figure
    figure eight
    figurehead
    figure of speech
    figure skating
    filament
    filch
    file
    filet mignon
    filibuster
    filigree
    fill
    fillet
    filling
    filling station
    filly
    film
    filmmaker
    filmy
    filter
    filth
    filthy
    fin
    finagle
    final
    finale
    finalist
    finality
    finalize
    finally
    finals
    finance
    finances
    financial
    financially
    financier
    financing
    finch
    find
    finder
    finding
    fine
    fine arts
    finely
    fine print
    finesse
    finger
    fingernail
    fingerprint
    fingertip
    finicky
    finish
    finished
    finite
    fir
    fire
    fire alarm
    firearm
    firebrand
    firecracker
    fire department
    fire drill
    fire engine
    fire escape
    fire extinguisher
    firefighter
    firefly
    fire hydrant
    fireman
    fireplace
    fireproof
    fireside
    fire station
    firewall
    firewood
    fireworks
    firing line
    firing squad
    firm
    firmly
    firmness
    first
    first aid
    first base
    first class
    first-class
    first cousin
    first-degree
    first floor
    firsthand
    first lady
    firstly
    first name
    first person
    first-rate
    fiscal
    fiscal year
    fish
    fishbowl
    fisherman
    fishery
    fishing
    fishing rod
    fishnet
    fish stick
    fishtail
    fishy
    fission
    fissure
    fist
    fit
    fitful
    fitness
    fitted
    fitting
    five
    five and ten
    fix
    fixation
    fixed
    fixture
    fizz
    fizzle
    fizzy
    fjord
    flab
    flabbergasted
    flabby
    flaccid
    flag
    flagging
    flagpole
    flagrant
    flagrantly
    flagship
    flagstone
    flail
    flair
    flak
    flake
    flaky
    flamboyance
    flamboyant
    flamboyantly
    flame
    flamenco
    flaming
    flamingo
    flammable
    flank
    flannel
    flap
    flapjack
    flare
    flared
    flare-up
    flash
    flashback
    flash card
    flasher
    flash flood
    flashlight
    flashy
    flask
    flat
    flatly
    flatten
    flatter
    flatterer
    flattering
    flattery
    flatulence
    flaunt
    flavor
    flavored
    flavoring
    flaw
    flawed
    flawless
    flawlessly
    flea
    flea market
    fleck
    fled
    fledgling
    flee
    fleece
    fleet
    fleeting
    flesh
    fleshy
    flew
    flex
    flexibility
    flexible
    flextime
    flick
    flicker
    flier
    flight
    flight attendant
    flighty
    flimsy
    flinch
    fling
    flint
    flip
    flip-flop
    flip out
    flippant
    flipper
    flip side
    flirt
    flirtation
    flirtatious
    flit
    float
    flock
    flog
    flogging
    flood

    floodgate
    floodlight
    floodlit
    floor
    flooring
    floor plan
    floozy
    flop
    flophouse
    floppy
    floppy disk
    flora
    floral
    florid
    florist
    floss
    flotilla
    flounce
    flounder
    flour
    flourish
    flout
    flow
    flow chart
    flower
    flowerbed
    flowered
    flowerpot
    flowery
    flown
    fl. oz.
    flu
    flub
    fluctuate
    fluctuation
    flue
    fluency
    fluent
    fluently
    fluff
    fluffy
    fluid
    fluidity
    fluid ounce
    fluids
    fluke
    flung
    flunk
    flunky
    fluorescent
    fluoride
    flurry
    flush
    flushed
    fluster
    flustered
    flute
    flutist
    flutter
    flux
    fly
    fly ball
    fly-by-night
    flying
    flying saucer
    flyswatter
    FM
    foal
    foam
    foam rubber
    foamy
    focal point
    foci
    focus
    fodder
    foe
    fog
    fogbound
    foggy
    foghorn
    fogy
    foible
    foil
    foist
    fold
    folder
    foliage
    folk
    folklore
    folk music
    folks
    folksy
    follicle
    follow
    follower
    following
    follow-up
    folly
    foment
    fond
    fondle
    fondly
    fondness
    font
    food
    food poisoning
    food processor
    food stamp
    foodstuff
    fool
    foolhardy
    foolish
    foolishly
    foolishness
    foolproof
    foot
    footage
    football
    footbridge
    foothill
    foothold
    footing
    footlights
    footlocker
    footloose
    footnote
    footpath
    footprint
    footsie
    footstep
    footwear
    footwork
    for
    forage
    foray
    forbade
    forbear
    forbearance
    forbid
    forbidden
    forbidding
    forbore
    forborne
    force
    forced
    force-fed
    force-feed
    forceful
    forcefully
    forceps
    forcible
    forcibly
    ford
    fore
    forearm
    foreboding
    forecast
    foreclose
    foreclosure
    forefinger
    forefront
    foreground
    forehand
    forehead
    foreign
    foreigner
    foreign exchange
    foreman
    foremost
    forensic
    foreplay
    forerunner
    foresaw
    foresee
    foreseeable
    foreseen
    foreshadow
    foresight
    foreskin
    forest
    forestall
    forestry
    foretaste
    foretell
    forethought
    foretold
    forever
    forewarn
    foreword
    forfeit
    forgave
    forge
    forger
    forgery
    forget
    forgetful
    forgetfulness
    forget-me-not
    forgivable
    forgive
    forgiven
    forgiveness
    forgiving
    forgo
    forgone
    forgot
    forgotten
    fork
    forked
    forklift
    forlorn
    form
    formal
    formaldehyde
    formality
    formalize
    formally
    format
    formation
    formative
    former
    formerly
    formidable
    formidably
    formless
    form letter
    formula
    formulae
    formulate
    formulation
    fornicate
    fornication
    forsake
    forsaken
    forsook
    forswear
    forswore
    forsworn
    fort
    forte
    forth
    forthcoming
    forthright
    fortieth
    fortification
    fortify
    fortitude
    fortress
    fortuitous
    fortunate
    fortunately
    fortune
    fortune cookie
    fortune teller
    forty
    forum
    forward
    forwarding address
    forward-looking
    forwards
    forwent
    fossil
    fossil fuel
    fossilize
    foster
    fought
    foul
    foul ball
    foul play

    found
    foundation
    founder
    founding father
    foundry
    fountain
    fountain pen
    four
    four-leaf clover
    four-letter word
    fourteen
    fourteenth
    fourth
    fourthly
    Fourth of July
    four-wheel drive
    fowl
    fox
    foxhole
    foxtrot
    foxy
    foyer
    fracas
    fraction
    fractional
    fractionally
    fractious
    fracture
    fragile
    fragility
    fragment
    fragrance
    fragrant
    frail
    frailty
    frame
    framework
    franc
    franchise
    frank
    frankfurter
    frankly
    frankness
    frantic
    frantically
    frat
    fraternal
    fraternity
    fraternize
    fraud
    fraudulent
    fraudulently
    fraught
    fray
    freak
    freak out
    freckle
    freckled
    free
    freebie
    freedom
    free enterprise
    free-for-all
    freehand
    freelance
    freelancer
    freeload
    freeloader
    freely
    free market
    free-range
    free speech
    freethinker
    freethinking
    freeway
    freewheeling
    free will
    freeze
    freeze-dried
    freezer
    freezing
    freezing point
    freight
    freighter
    freight train
    French
    French bread
    French fry
    French toast
    frenetic
    frenzied
    frenzy
    frequency
    frequent
    frequently
    fresh
    freshen
    freshly
    freshman
    freshness
    freshwater
    fret
    fretful
    Freudian
    Fri.
    friar
    friction
    Friday
    fridge
    fried
    friend
    friendless
    friendliness
    friendly
    friendship
    fries
    frieze
    frigate
    fright
    frighten
    frightened
    frightening
    frighteningly
    frightful
    frigid
    frigidity
    frill
    frilly
    fringe
    fringe benefit
    Frisbee
    frisk
    frisky
    fritter
    frivolity
    frivolous
    frivolously
    frizz
    frizzy
    fro
    frog
    frolic
    from
    frond
    front
    frontage
    frontal
    frontier
    frontiers
    front man
    frost
    frostbite
    frostbitten
    frosted
    frosting
    frosty
    froth
    frothy
    frown
    froze
    frozen
    frugal
    frugality
    frugally
    fruit
    fruitcake
    fruit fly
    fruitful
    fruition
    fruitless
    fruitlessly
    fruits
    fruity
    frumpy
    frustrate
    frustrated
    frustrating
    frustration
    fry
    frying pan
    ft.
    fuck
    fucked up
    fucker
    fucking
    fudge
    fuel
    fugitive
    fulcrum
    fulfill
    fulfilled
    fulfilling
    fulfillment
    full
    full-blown
    full-fledged
    full house
    full-length
    full moon
    full-scale
    full-time
    fully
    fumble
    fume
    fumes
    fumigate
    fumigation
    fun
    function
    functional
    functionally
    fund
    fundamental
    fundamentalism
    fundamentalist
    fundamentally
    fundamentals
    funding
    fund-raising
    funds
    funeral
    funeral director
    funeral home
    fungal
    fungi
    fungus
    funk
    funky
    funnel
    funnel cloud
    funnies
    funnily
    funny
    funny bone
    fur
    furious
    furiously
    furl
    furlong
    furnace
    furnish
    furnished
    furnishings
    furniture
    furor
    furrow
    furry
    further
    furthermore
    furthest
    furtive
    furtively
    fury
    fuse
    fuse box
    fuselage
    fusion
    fuss
    fussy
    futile
    futilely
    future
    future tense
    futuristic
    fuzz
    fuzzy
    FYI

ManyThings.org

    Reading
    Sentences
    More

English Vocabulary Word Lists with Games, Puzzles and Quizzes

English Vocabulary Word List
Alan Beale's Core Vocabulary - G (766 Words)

    gabby
    gable
    gadget
    gaffe
    gag
    gaggle
    gag order
    gaiety
    gaily
    gain
    gait
    gal
    gal.
    gala
    galactic
    galaxy
    gale
    gall
    gallant
    gallantly
    gallantry
    gallbladder
    gallery
    galley
    gallivant
    gallon
    gallop
    gallows
    galore
    galoshes
    galvanize
    gambit
    gamble
    gambler
    gambling
    game
    game plan
    games
    game show
    gamut
    gander
    gang
    gangland
    gangling
    gangplank
    gangrene
    gangster
    gangway
    gap
    gape
    gaping
    garage
    garage sale
    garb
    garbage
    garbage can
    garbage man
    garbled
    garden
    gardener
    gardening
    gargantuan
    gargle
    gargoyle
    garish
    garland
    garlic
    garment
    garnet
    garnish
    garret
    garrison
    garrulous
    garter
    gas
    gas chamber
    gaseous
    gash
    gasket
    gas mask
    gasoline
    gasp
    gas pedal
    gas station
    gassy
    gastric
    gastronomic
    gasworks
    gate
    gatecrasher
    gateway
    gather
    gathering
    gauche
    gaudy
    gauge
    gaunt
    gauntlet
    gauze
    gave
    gavel
    gawk
    gawky
    gay
    gaze
    gazebo
    gazelle
    gazette
    gear
    gearshift
    GED
    gee
    geek
    geeky
    geese
    geezer
    geisha
    gel
    gelatin
    gelding
    gem
    Gemini
    Gen.
    gender
    gene
    genealogical
    genealogist
    genealogy
    genera
    general
    general anesthetic
    general election
    generalization
    generalize
    generalized
    generally
    general store
    generate
    generation
    generation gap
    Generation X
    generator
    generic
    generically
    generosity
    generous
    generously
    genesis
    genetic
    genetically
    genetic engineering
    geneticist
    genetics
    genial
    genital
    genitalia
    genitals
    genius
    genocide
    genre
    gent
    genteel
    gentile
    gentility
    gentle
    gentleman
    gentleness
    gently
    gentrification
    gentry
    genuflect
    genuine
    genuinely
    genus
    geographer
    geographical
    geographically
    geography
    geologic
    geologist
    geology
    geometric
    geometrically
    geometry
    geranium
    geriatric
    geriatrics
    germ
    German
    German measles
    German shepherd
    germinate

    germination
    gerrymander
    gerrymandering
    gerund
    gestation
    gesticulate
    gesture
    get
    getaway
    get-together
    getup
    geyser
    ghastly
    ghetto
    ghost
    ghostly
    ghost town
    ghostwriter
    ghoul
    ghoulish
    GI
    giant
    gibberish
    gibe
    giblets
    giddy
    gift
    gift certificate
    gifted
    gig
    gigabyte
    gigantic
    giggle
    gild
    gill
    gimmick
    gimmicky
    gin
    ginger
    ginger ale
    gingerbread
    gingerly
    gingham
    giraffe
    girder
    girdle
    girl
    girlfriend
    Girl Scout
    Girl Scouts
    girth
    gist
    give
    give-and-take
    giveaway
    given
    given name
    gizmo
    gizzard
    glacial
    glacier
    glad
    glade
    gladiator
    gladly
    glamorize
    glamorous
    glamorously
    glamour
    glance
    gland
    glandular
    glare
    glaring
    glass
    glass ceiling
    glasses
    glassware
    glassy
    glaze
    glazed
    gleam
    gleaming
    glean
    glee
    gleeful
    gleefully
    glib
    glibly
    glide
    glider
    glimmer
    glimpse
    glint
    glisten
    glitch
    glitter
    glittering
    glitz
    glitzy
    gloat
    glob
    global
    globally
    globe
    globetrotter
    globular
    globule
    gloom
    gloomily
    gloominess
    gloomy
    glorification
    glorified
    glorify
    glorious
    gloriously
    glory
    gloss
    glossary
    glossy
    glove
    glove compartment
    glow
    glower
    glowering
    glowing
    glowingly
    glowworm
    glucose
    glue
    glum
    glumly
    glut
    glutton
    gluttony
    glycerin
    GMAT
    gnarled
    gnarly
    gnash
    gnat
    gnaw
    gnawing
    gnome
    GNP
    go
    goad
    go-ahead
    goal
    goalie
    goalkeeper
    goalpost
    goat
    goatee
    gob
    gobble
    gobbledygook
    go-between
    goblet
    goblin
    gobs
    go-cart
    God
    god
    god-awful
    godchild
    godchildren
    goddamn
    goddamned
    goddess
    godfather
    godforsaken
    godless
    godlike
    godly
    godmother
    godparent
    godsend
    gofer
    go-getter
    goggles
    going
    going-over
    goings-on
    gold
    gold digger
    golden
    golden anniversary
    goldfish
    gold medal
    gold medalist

    gold mine
    gold rush
    golf
    golf ball
    golf club
    golf course
    golfer
    golly
    gondola
    gone
    goner
    gong
    gonna
    gonorrhea
    goo
    good
    Good Book
    good-bye
    good-for-nothing
    Good Friday
    good guy
    good-humored
    goodies
    good-looking
    good-natured
    goodness
    good old boy
    goods
    good-tempered
    goodwill
    goody
    goody-goody
    gooey
    goof
    goof-off
    goofy
    goon
    goose
    goose bumps
    GOP
    gopher
    gore
    gorge
    gorgeous
    gorgeously
    gorilla
    gory
    gosh
    gosling
    Gospel
    gospel
    gospel music
    gossip
    got
    gotta
    gotten
    gouge
    goulash
    gourd
    gourmet
    gout
    govern
    government
    governmental
    governor
    governorship
    gown
    GPA
    grab
    grace
    graceful
    gracefully
    gracefulness
    gracious
    graciously
    graciousness
    grad
    gradation
    grade
    grade point average
    grader
    grade school
    gradient
    grad school
    gradual
    gradually
    graduate
    graduate school
    graduation
    graffiti
    graft
    grain
    grainy
    gram
    grammar
    grammar school
    grammatical
    grammatically
    Grammy
    grand
    grandchild
    grandchildren
    granddad
    granddaughter
    grandeur
    grandfather
    grandfather clock
    grandiose
    grand jury
    grandly
    grandma
    grandmother
    grandpa
    grandparent
    grand piano
    grand prix
    grand slam
    grandson
    grandstand
    grand total
    granite
    granny
    granola
    grant
    granted
    granular
    granulated
    granule
    grape
    grapefruit
    grapevine
    graph
    graphic
    graphically
    graphics
    graphite
    grapple
    grasp
    grasping
    grass
    grasshopper
    grassland
    grass roots
    grass-roots
    grassy
    grate
    grateful
    gratefully
    grater
    gratification
    gratify
    gratifying
    grating
    gratis
    gratitude
    gratuitous
    gratuity
    grave
    gravel
    gravely
    gravestone
    graveyard
    gravitate
    gravitation
    gravity
    gravy
    gray
    grayish
    gray matter
    graze
    grease
    greasy
    great
    Great Britain
    great-grandchild
    great-granddaughter
    great-grandfather
    great-grandmother
    great-grandparent
    great-grandson
    greatly
    greatness
    greed
    greedily
    greedy
    Greek
    green
    greenback
    green bean
    green card
    greenery
    greenhorn

    greenhouse
    greenhouse effect
    greenish
    greens
    greet
    greeting
    greeting card
    greetings
    gregarious
    gremlin
    grenade
    grew
    greyhound
    grid
    griddle
    gridiron
    gridlock
    grief
    grievance
    grieve
    grievous
    grill
    grim
    grimace
    grime
    grimly
    grimy
    grin
    grind
    grinder
    grindstone
    gringo
    grip
    gripe
    gripping
    grisly
    gristle
    grit
    grits
    gritty
    grizzly bear
    groan
    grocer
    groceries
    grocery
    grocery store
    groggy
    groin
    groom
    grooming
    groove
    groovy
    grope
    gross
    grossly
    grotesque
    grotto
    grouch
    grouchy
    ground
    ground crew
    ground floor
    groundhog
    Groundhog Day
    grounding
    groundless
    groundlessly
    ground rule
    grounds
    groundswell
    groundwork
    group
    groupie
    grouping
    grouse
    grove
    grovel
    grow
    grower
    growing pains
    growl
    grown
    grown-up
    growth
    grub
    grubby
    grudge
    grudging
    gruel
    grueling
    gruesome
    gruff
    gruffly
    grumble
    grumpy
    grunge
    grungy
    grunt
    G-string
    guacamole
    guarantee
    guarantor
    guaranty
    guard
    guarded
    guardedly
    guardian
    guardian angel
    guardrail
    gubernatorial
    guerrilla
    guess
    guesstimate
    guesswork
    guest
    guff
    guffaw
    guidance
    guidance counselor
    guide
    guidebook
    guided
    guideline
    guidelines
    guild
    guile
    guileless
    guillotine
    guilt
    guiltily
    guilty
    guinea pig
    guise
    guitar
    guitarist
    gulch
    gulf
    gull
    gullet
    gullibility
    gullible
    gully
    gulp
    gum
    gumbo
    gumdrop
    gummy
    gumption
    gun
    gunboat
    gunfire
    gung-ho
    gunk
    gunman
    gunner
    gunnysack
    gunpoint
    gunpowder
    gunrunner
    gunrunning
    gunshot
    gurgle
    gurgling
    guru
    gush
    gusher
    gushy
    gust
    gusto
    gusty
    gut
    guts
    gutsy
    gutter
    guttural
    guy
    guzzle
    guzzler
    gym
    gymnasium
    gymnast
    gymnastics
    gynecological
    gynecologist
    gynecology
    gyp
    gypsy
    gyrate
    gyration
    gyroscope
    ManyThings.org

    Reading
    Sentences
    More

English Vocabulary Word Lists with Games, Puzzles and Quizzes

English Vocabulary Word List
Alan Beale's Core Vocabulary - H (869 Words)

    haberdashery
    habit
    habitable
    habitat
    habitation
    habitual
    habitually
    hack
    hacker
    hackneyed
    hacksaw
    had
    haddock
    hadn't
    hag
    haggard
    haggle
    hail
    hailstone
    hair
    hairbrush
    haircut
    hairdo
    hairdresser
    hair dryer
    hairline
    hairnet
    hairpiece
    hair-raising
    hairsplitting
    hair spray
    hairstyle
    hairstylist
    hairy
    hale
    half
    half-and-half
    half-assed
    half-baked
    half brother
    halfhearted
    halfheartedly
    half-mast
    half sister
    halftime
    halfway
    halibut
    hall
    hallelujah
    hallmark
    Hall of Fame
    hallowed
    Halloween
    hallucinate
    hallucination
    hallucinogenic
    hallway
    halo
    halt
    halter
    halting
    halve
    halves
    ham
    hamburger
    hamlet
    hammer
    hammering
    hammock
    hamper
    hamster
    hamstring
    hand
    handbag
    handbook
    handcuff
    handcuffs
    handful
    handgun
    handicap
    handicapped
    handiwork
    handkerchief
    handle
    handlebar
    handler
    handmade
    hand-me-down
    handout
    handpicked
    handshake
    hands-off
    handsome
    handsomely
    hands-on
    handstand
    handwriting
    handwritten
    handy
    handyman
    hang
    hangar
    hanger
    hanger-on
    hangers-on
    hang glider
    hang gliding
    hanging
    hangout
    hangover
    hang-up
    hanker
    hankering
    hankie
    hanky-panky
    Hanukkah
    haphazard
    haphazardly
    hapless
    happen
    happening
    happily
    happiness
    happy
    happy-go-lucky
    happy hour
    harangue
    harass
    harassment
    harbor
    hard
    hardball
    hard-boiled
    hard copy
    hard-core
    hardcover
    hard currency
    hard disk
    harden
    hard hat
    hardheaded
    hardhearted
    hard-hitting
    hard-line
    hard-liner
    hardly
    hard-nosed
    hard rock
    hard sell
    hardship
    hardware
    hardwood
    hard-working
    hardy
    hare
    harebrained
    harelip
    harem
    hark
    harlot
    harm
    harmful
    harmless
    harmlessly
    harmonica
    harmonious
    harmoniously
    harmonization
    harmonize
    harmony
    harness
    harp
    harpist
    harpoon
    harpsichord
    harrowing
    harsh
    harshly
    harshness
    harvest
    has
    has-been
    hash
    hash browns
    hashish
    hasn't
    hassle
    haste
    hasten
    hastily
    hasty
    hat
    hatch
    hatchback
    hatchet
    hate
    hate crime
    hated
    hateful
    hatred
    haughtily
    haughty
    haul
    haunches
    haunt
    haunted
    haunting
    have
    haven
    haven't
    have to
    havoc
    hawk
    hay
    hay fever
    haystack
    haywire

    hazard
    hazardous
    haze
    hazel
    hazelnut
    hazing
    hazy
    H-bomb
    he
    head
    headache
    headband
    head count
    headfirst
    headgear
    headhunter
    heading
    headland
    headlight
    headline
    headlines
    headlong
    headmaster
    headmistress
    head-on
    headphones
    headquarters
    headrest
    headroom
    heads
    head start
    headstone
    headstrong
    head-to-head
    headway
    headwind
    heady
    heal
    healer
    health
    health care
    health club
    health food
    healthful
    healthily
    healthy
    heap
    heaping
    hear
    heard
    hearing
    hearing aid
    hearing-impaired
    hearsay
    hearse
    heart
    heartache
    heart attack
    heartbeat
    heartbreak
    heartbreaking
    heartbroken
    heartburn
    hearten
    heartfelt
    hearth
    heartily
    heartland
    heartless
    hearts
    heartthrob
    heart-to-heart
    heartwarming
    hearty
    heat
    heated
    heatedly
    heater
    heathen
    heat wave
    heave
    heaven
    heavenly
    heavens
    heavily
    heaviness
    heavy
    heavy-duty
    heavy-handed
    heavy industry
    heavy metal
    heavyweight
    heck
    heckle
    heckler
    heckling
    hectic
    he'd
    hedge
    hedonism
    hedonist
    hedonistic
    heed
    heedless
    heel
    heels
    hefty
    heifer
    height
    heighten
    heights
    heinous
    heir
    heiress
    heirloom
    heist
    held
    helicopter
    heliport
    helium
    hell
    he'll
    hello
    helm
    helmet
    help
    helper
    helpful
    helpfully
    helpfulness
    helping
    helpless
    helplessly
    helplessness
    helter-skelter
    hem
    hemisphere
    hemline
    hemlock
    hemoglobin
    hemophilia
    hemophiliac
    hemorrhage
    hemorrhoids
    hemp
    hen
    hence
    henceforth
    henchman
    hepatitis
    her
    herald
    herb
    herbal
    herbivore
    herd
    here
    hereabouts
    hereafter
    hereby
    hereditary
    heredity
    herein
    heresy
    heretic
    heretical
    herewith
    heritage
    hermetic
    hermit
    hernia
    hero
    heroic
    heroically
    heroin
    heroine
    heroism
    heron
    herpes
    herring
    hers
    herself
    hertz
    he's
    hesitancy
    hesitant
    hesitantly
    hesitate
    hesitation
    heterogeneous
    heterosexual
    hew
    hewn
    hexagon
    hexagonal
    hey
    heyday
    hi
    hiatus
    hibernate
    hibernation
    hiccup
    hiccups
    hick
    hickey
    hickory
    hid
    hidden
    hide
    hide-and-seek
    hideaway
    hideous
    hideously
    hideout
    hiding
    hierarchical
    hierarchy

    hieroglyphic
    hieroglyphics
    hi-fi
    high
    highbrow
    high chair
    high-class
    higher education
    high-grade
    high-handed
    high jinks
    high jump
    high-level
    highlight
    highlighter
    highlights
    highly
    high-minded
    Highness
    high-pitched
    high-powered
    high-pressure
    high-profile
    high-rise
    high roller
    high school
    high-spirited
    high-strung
    high-tech
    high tide
    highway
    highway patrol
    hijack
    hijacker
    hijacking
    hike
    hiker
    hilarious
    hilariously
    hilarity
    hill
    hillbilly
    hillside
    hilltop
    hilly
    hilt
    him
    himself
    hind
    hinder
    hindquarters
    hindrance
    hindsight
    Hindu
    Hinduism
    hinge
    hint
    hinterland
    hip
    hip-hop
    hippie
    hippo
    hippopotami
    hippopotamus
    hire
    his
    Hispanic
    hiss
    historian
    historic
    historical
    historically
    history
    histrionic
    histrionics
    hit
    hit-and-run
    hitch
    hitchhike
    hitchhiker
    hither
    hitherto
    hit man
    hit-or-miss
    HIV
    hive
    hives
    h'm
    HMO
    hoard
    hoarder
    hoarse
    hoarsely
    hoax
    hobble
    hobby
    hobnob
    hobo
    hock
    hockey
    hodgepodge
    hoe
    hog
    ho-hum
    hoist
    hokey
    hold
    holder
    holding
    holdover
    holdup
    hole
    holiday
    holidays
    holiness
    holistic
    holler
    hollow
    holly
    Hollywood
    Holocaust
    holocaust
    hologram
    holster
    holy
    Holy Communion
    Holy Ghost
    Holy Spirit
    homage
    home
    homecoming
    home economics
    homeland
    homeless
    homelessness
    home loan
    homely
    homemade
    homemaker
    homeopathic
    homeopathy
    homeowner
    home page
    home plate
    homer
    homeroom
    home run
    homesick
    homesickness
    homestead
    hometown
    homeward
    homework
    homey
    homicidal
    homicide
    homogeneity
    homogeneous
    homogenize
    homogenized
    homonym
    homosexual
    homosexuality
    honcho
    hone
    honest
    honestly
    honesty
    honey
    honeycomb
    honeymoon
    honeysuckle
    honk
    honor
    honorable
    honorably
    honorary
    honor roll
    honors
    hood
    hooded
    hoof
    hook
    hooked
    hooker
    hookey
    hooligan
    hoop
    hoops
    hooray
    hoot
    hooves
    hop
    hope
    hopeful
    hopefully
    hopefulness
    hopeless
    hopelessly
    hopelessness
    hopscotch
    horde
    horizon
    horizontal
    horizontally
    hormone
    horn
    hornet
    horny
    horoscope
    horrendous
    horrendously
    horrible
    horribly
    horrid
    horrific
    horrify

    horrifying
    horror
    hors d'oeuvre
    horse
    horseback riding
    horseplay
    horsepower
    horseshoe
    horseshoes
    horticultural
    horticulture
    hose
    hospice
    hospitable
    hospital
    hospitality
    hospitalization
    hospitalize
    host
    hostage
    hostel
    hostess
    hostile
    hostile takeover
    hostilities
    hostility
    hot
    hot air
    hot-air balloon
    hotbed
    hotcake
    hot chocolate
    hot dog
    hotel
    hot flash
    hothead
    hotheaded
    hot line
    hotly
    hot plate
    hot potato
    hot seat
    hotshot
    hot spot
    hot-tempered
    hot tub
    hot-water bottle
    hot-wire
    hound
    hour
    hourglass
    hourly
    hours
    House
    house
    house arrest
    houseboat
    housebound
    housebroken
    household
    househusband
    housekeeper
    housekeeping
    House of Representatives
    house-sit
    house-sitter
    housewares
    housewarming
    housewife
    housewives
    housework
    housing
    housing development
    housing project
    hovel
    hover
    how
    howdy
    however
    howl
    hp:
    HQ
    hr.
    hrs.
    hub
    hubbub
    hubcap
    huddle
    huddled
    hue
    huff
    huffy
    hug
    huge
    hugely
    huh
    hulk
    hull
    hullabaloo
    hum
    human
    human being
    humane
    humanely
    humanism
    humanist
    humanitarian
    humanitarianism
    humanities
    humanity
    humanize
    humankind
    humanly
    human nature
    human race
    human resources
    human rights
    humble
    humbling
    humbly
    humdrum
    humid
    humidify
    humidity
    humiliate
    humiliated
    humiliating
    humiliation
    humility
    humor
    humorist
    humorous
    humorously
    hump
    hunch
    hunchback
    hundred
    hundredth
    hung
    hunger
    hunger strike
    hungrily
    hungry
    hunk
    hunker
    hunt
    hunter
    hunting
    hurdle
    hurdler
    hurdles
    hurl
    hurrah
    hurricane
    hurried
    hurriedly
    hurry
    hurt
    hurtful
    hurtle
    husband
    hush
    hushed
    hush-hush
    husk
    huskiness
    husky
    hustle
    hustler
    hut
    hutch
    hybrid
    hydrant
    hydraulic
    hydraulics
    hydroelectric
    hydrogen
    hydroplane
    hyena
    hygiene
    hygienic
    hygienically
    hymn
    hymnal
    hype
    hyper
    hyperactive
    hyperactivity
    hyperbole
    hypersensitive
    hypertension
    hyperventilate
    hyphen
    hyphenate
    hyphenated
    hyphenation
    hypnosis
    hypnotic
    hypnotism
    hypnotist
    hypnotize
    hypochondria
    hypochondriac
    hypocrisy
    hypocrite
    hypocritical
    hypocritically
    hypodermic
    hypothermia
    hypotheses
    hypothesis
    hypothetical
    hypothetically
    hysterectomy
    hysteria
    hysterical
    hysterically
    hysterics
    ManyThings.org

    Reading
    Sentences
    More

English Vocabulary Word Lists with Games, Puzzles and Quizzes

English Vocabulary Word List
Alan Beale's Core Vocabulary - I (1064 Words)

    iceberg
    icebox
    icebreaker
    ice cap
    ice-cold
    ice cream
    ice-cream cone
    ice cube
    iced
    ice hockey
    ice skate
    ice skater
    icicle
    icing
    icky
    icon
    icy
    ID
    I'd
    ID card
    idea
    ideal
    idealism
    idealist
    idealistic
    idealize
    ideally
    identical
    identically
    identical twin
    identification
    identify
    identity
    ideological
    ideology
    idiocy
    idiom
    idiomatic
    idiosyncrasy
    idiosyncratic
    idiot
    idiotic
    idiotically
    idle
    idleness
    idly
    idol
    idolatrous
    idolatry
    idolize
    idyllic
    i.e.
    if
    iffy
    igloo
    ignite
    ignition
    ignorance
    ignorant
    ignore
    iguana
    ill
    I'll
    illegal
    illegally
    illegible
    illegibly
    illegitimacy
    illegitimate
    ill-equipped
    ill-fated
    illicit
    illiteracy
    illiterate
    ill-mannered
    illness
    illogical
    illogically
    illuminate
    illuminating
    illumination
    illusion
    illusory
    illustrate
    illustration
    illustrative
    illustrator
    illustrious
    I'm
    image
    imagery
    imaginable
    imaginary
    imagination
    imaginative
    imaginatively
    imagine
    imbalance
    imbalanced
    imbecile
    imbibe
    imbue
    imitate
    imitation
    imitative
    imitator
    immaculate
    immaculately
    immaterial
    immature
    immaturity
    immediacy
    immediate
    immediately
    immense
    immensely
    immensity
    immerse
    immersion
    immigrant
    immigrate
    immigration
    imminent
    imminently
    immobile
    immobility
    immobilize
    immoral
    immorality
    immorally
    immortal
    immortality
    immortalize
    immovable
    immune
    immune system
    immunity
    immunization
    immunize
    immutable
    imp
    impact
    impair
    impaired
    impairment
    impale
    impart
    impartial
    impartiality
    impartially
    impassable
    impasse
    impassioned
    impassive
    impatience
    impatient
    impatiently
    impeach
    impeachment
    impeccable
    impeccably
    impede
    impediment
    impel
    impending
    impenetrable
    imperative
    imperceptible
    imperfect
    imperfection
    imperfectly
    imperial
    imperialism
    imperialist
    imperil
    impersonal
    impersonate
    impersonation
    impersonator
    impertinence
    impertinent
    impervious
    impetuous
    impetuously
    impetus
    impinge
    impish
    implacable
    implant
    implausible
    implement
    implementation
    implicate
    implication
    implicit
    implicitly
    implode
    implore
    imply
    impolite
    impolitely
    import
    importance
    important
    importantly
    importation
    importer
    impose
    imposing
    imposition
    impossibility
    impossible
    impossibly
    impostor
    impotence
    impotent
    impound
    impoverished
    impractical
    imprecise
    impregnable
    impregnate
    impress
    impression
    impressionable
    impressionistic
    impressive
    imprint
    imprison
    imprisonment
    improbability
    improbable
    improbably
    impromptu
    improper
    improperly
    impropriety
    improve
    improvement
    improvisation
    improvise
    impudence
    impudent
    impulse
    impulsive
    impulsively
    impulsiveness
    impunity
    impure
    impurity
    in
    in.
    inability
    inaccessibility
    inaccessible
    inaccuracy
    inaccurate
    inaction
    inactive
    inactivity
    inadequacy
    inadequate
    inadequately
    inadmissible
    inadvertent
    inadvertently

    inadvisable
    inalienable
    inane
    inanimate
    inappropriate
    inarticulate
    inasmuch as
    inattention
    inattentive
    inaudible
    inaudibly
    inaugural
    inaugurate
    inauguration
    inauspicious
    in-between
    inbred
    Inc.
    incalculable
    incandescence
    incandescent
    incantation
    incapable
    incapacitate
    incapacity
    incarcerate
    incarceration
    incarnate
    incarnation
    incendiary
    incense
    incentive
    inception
    incessant
    incessantly
    incest
    incestuous
    inch
    incidence
    incident
    incidental
    incidentally
    incinerate
    incineration
    incinerator
    incision
    incisive
    incisor
    incite
    incitement
    inclination
    incline
    inclined
    include
    including
    inclusion
    inclusive
    incognito
    incoherence
    incoherent
    incoherently
    income
    income tax
    incoming
    incomparable
    incompatibility
    incompatible
    incompetence
    incompetent
    incompetently
    incomplete
    incompletely
    incomprehensible
    inconceivable
    inconclusive
    inconclusively
    incongruity
    incongruous
    inconsequential
    inconsiderate
    inconsistency
    inconsistent
    inconsistently
    inconsolable
    inconspicuous
    inconspicuously
    incontinence
    incontinent
    inconvenience
    inconvenient
    inconveniently
    incorporate
    incorporated
    incorporation
    incorrect
    incorrectly
    incorrigible
    increase
    increased
    increasing
    increasingly
    incredible
    incredibly
    incredulity
    incredulous
    increment
    incremental
    incriminate
    incriminating
    incrimination
    incubate
    incubation
    incubation period
    incubator
    incumbent
    incur
    incurable
    incurably
    indebted
    indebtedness
    indecency
    indecent
    indecently
    indecision
    indecisive
    indecisively
    indeed
    indefensible
    indefinable
    indefinably
    indefinite
    indefinitely
    indelible
    indelibly
    indelicate
    indemnify
    indemnity
    indent
    independence
    Independence Day
    independent
    independently
    in-depth
    indescribable
    indescribably
    indestructible
    indeterminate
    index
    index finger
    Indian
    Indian Ocean
    Indian summer
    indicate
    indication
    indicative
    indicator
    indices
    indict
    indictment
    indifference
    indifferent
    indifferently
    indigenous
    indigent
    indigestible
    indigestion
    indignant
    indignantly
    indignation
    indignity
    indirect
    indirectly
    indirectness
    indirect object
    indiscreet
    indiscretion
    indiscriminate
    indiscriminately
    indispensable
    indisputable
    indistinct
    indistinctly
    indistinguishable
    individual
    individualism
    individualist
    individualistic
    individuality
    individually
    indivisible
    indoctrinate
    indoctrination
    indolence
    indolent
    indomitable
    indoor
    indoors
    induce
    inducement
    induct
    induction
    indulge
    indulgence
    indulgent
    industrial
    industrial arts
    industrialist
    industrialization
    industrialize
    industrial park
    industrious
    industry
    inebriated
    inebriation
    ineffective
    ineffectiveness
    inefficiency
    inefficient
    inefficiently
    inelegant
    ineligibility
    ineligible
    inept
    ineptitude
    inequality
    inequity
    inert
    inertia
    inescapable
    inessential
    inevitability
    inevitable
    inevitably
    inexact
    inexcusable
    inexhaustible
    inexpensive
    inexpensively
    inexperience
    inexperienced
    inexplicable
    inexplicably
    infallibility
    infallible
    infamous
    infamy
    infancy
    infant
    infantile
    infantry
    infatuated
    infatuation
    infect
    infection
    infectious
    infer
    inference
    inferior
    inferiority
    inferiority complex
    inferno
    infertile
    infertility
    infest
    infestation
    infested

    infidel
    infidelity
    infield
    infielder
    infiltrate
    infiltration
    infiltrator
    infinite
    infinitely
    infinitesimal
    infinitive
    infinity
    infirm
    infirmary
    infirmity
    inflame
    inflamed
    inflammable
    inflammation
    inflammatory
    inflatable
    inflate
    inflated
    inflation
    inflationary
    inflection
    inflexibility
    inflexible
    inflexibly
    inflict
    infliction
    in-flight
    influence
    influential
    influenza
    influx
    info
    infomercial
    inform
    informal
    informality
    informally
    informant
    information
    information superhighway
    information technology
    informative
    informed
    informer
    infraction
    infrared
    infrastructure
    infrequent
    infrequently
    infringe
    infringement
    infuriate
    infuriating
    infuriatingly
    infuse
    infusion
    ingenious
    ingeniously
    ingenuity
    ingest
    ingrained
    ingratiate
    ingratiating
    ingratitude
    ingredient
    inhabit
    inhabitant
    inhalation
    inhale
    inhaler
    inherent
    inherit
    inheritance
    inhibit
    inhibited
    inhibition
    inhospitable
    in-house
    inhuman
    inhumane
    inhumanity
    initial
    initially
    initials
    initiate
    initiation
    initiative
    inject
    injection
    injunction
    injure
    injured
    injurious
    injury
    injustice
    ink
    inkling
    inlaid
    inland
    in-laws
    inlet
    in-line skate
    inmate
    inn
    innards
    innate
    inner
    inner city
    innermost
    inning
    innkeeper
    innocence
    innocent
    innocently
    innocuous
    innovate
    innovation
    innovative
    innovator
    innuendo
    innumerable
    inoculate
    inoculation
    inoffensive
    inopportune
    inordinate
    inordinately
    inorganic
    inpatient
    input
    inquest
    inquire
    inquiring
    inquiry
    inquisition
    inquisitive
    inroads
    INS
    insane
    insanely
    insanity
    insatiable
    inscribe
    inscription
    inscrutable
    insect
    insecticide
    insecure
    insecurity
    insemination
    insensitive
    insensitively
    insensitivity
    inseparable
    insert
    insertion
    inside
    insider
    insides
    insidious
    insight
    insignia
    insignificance
    insignificant
    insignificantly
    insincere
    insincerely
    insincerity
    insinuate
    insinuation
    insipid
    insist
    insistence
    insistent
    insistently
    insofar as
    insolence
    insolent
    insoluble
    insolvency
    insolvent
    insomnia
    insomniac
    inspect
    inspection
    inspector
    inspiration
    inspirational
    inspire
    inspired
    inspiring
    instability
    install
    installation
    installment
    instance
    instant
    instantaneous
    instantaneously
    instantly
    instant replay
    instead
    instep
    instigate
    instigation
    instill
    instinct
    instinctive
    instinctively
    institute
    institution
    institutional
    instruct
    instruction
    instructions
    instructive
    instructively
    instructor
    instrument
    instrumental
    insubordinate
    insubordination
    insubstantial
    insufferable
    insufficiency
    insufficient
    insular
    insularity
    insulate
    insulation
    insulin
    insult
    insulting
    insurance
    insure
    insured
    insurgency
    insurgent
    insurmountable
    insurrection
    intact
    intake
    intangible
    integer
    integral
    integrate
    integration
    integrity
    intellect
    intellectual
    intellectually
    intelligence
    intelligent
    intelligently
    intelligible
    intend
    intended
    intense
    intensely
    intensifier
    intensify

    intensity
    intensive
    intensive care
    intensively
    intent
    intention
    intentional
    intentionally
    intently
    inter
    interact
    interaction
    interactive
    intercede
    intercept
    interception
    interchange
    interchangeable
    interchangeably
    intercom
    interconnect
    interconnected
    intercontinental
    intercourse
    interdependence
    interdependent
    interest
    interested
    interesting
    interestingly
    interface
    interfere
    interference
    interim
    interior
    Interior Department
    interior design
    interject
    interjection
    interlock
    interlocking
    interloper
    interlude
    intermarriage
    intermarry
    intermediary
    intermediate
    interminable
    intermission
    intermittent
    intermittently
    intern
    internal
    internally
    international
    internationally
    Internet
    internist
    internment
    internship
    interpersonal
    interplanetary
    interplay
    interpose
    interpret
    interpretation
    interpreter
    interracial
    interrelated
    interrogate
    interrogation
    interrogator
    interrupt
    interruption
    intersect
    intersection
    intersperse
    interstate
    interval
    intervene
    intervening
    intervention
    interview
    interviewer
    interweave
    interwove
    interwoven
    intestate
    intestinal
    intestine
    intimacy
    intimate
    intimately
    intimidate
    intimidated
    intimidating
    intimidation
    into
    intolerable
    intolerably
    intolerance
    intolerant
    intonation
    intoxicated
    intoxication
    intractable
    intramural
    intransitive
    intransitively
    intravenous
    intrepid
    intricacies
    intricacy
    intricate
    intricately
    intrigue
    intriguing
    intrinsic
    intrinsically
    introduce
    introduction
    introductory
    introspective
    introvert
    introverted
    intrude
    intruder
    intrusion
    intrusive
    intuition
    intuitive
    intuitively
    Inuit
    inundate
    inundation
    invade
    invader
    invalid
    invalidate
    invaluable
    invariable
    invariably
    invasion
    invasive
    invent
    invention
    inventive
    inventor
    inventory
    inverse
    inversion
    invert
    invest
    investigate
    investigation
    investigative
    investigator
    investment
    investor
    inveterate
    invigorate
    invigorating
    invincible
    invisibility
    invisible
    invisibly
    invitation
    invite
    inviting
    invoice
    invoke
    involuntarily
    involuntary
    involve
    involved
    involvement
    inward
    inwardly
    inwards
    iodine
    iota
    IOU
    IQ
    IRA
    irascible
    irate
    iridescent
    iris
    Irish
    irk
    iron
    Iron Curtain
    ironic
    ironically
    ironing
    ironing board
    irony
    irrational
    irrationality
    irrationally
    irreconcilable
    irrefutable
    irregular
    irregularity
    irregularly
    irrelevance
    irrelevant
    irreparable
    irreparably
    irreplaceable
    irrepressible
    irreproachable
    irresistible
    irresistibly
    irrespective
    irresponsibility
    irresponsible
    irresponsibly
    irreverence
    irreverent
    irreverently
    irreversible
    irrigate
    irrigation
    irritability
    irritable
    irritably
    irritant
    irritate
    irritating
    irritation
    IRS
    is
    Islam
    Islamic
    island
    islander
    isle
    isn't
    isolate
    isolated
    isolation
    issue
    isthmus
    it
    Italian
    italic
    italicize
    italics
    itch
    itchiness
    itchy
    it'd
    item
    itemize
    itinerant
    itinerary
    it'll
    its
    it's
    itself
    IV
    I've
    ivory
    ivy
    Ivy League

ManyThings.org

    Reading
    Sentences
    More

English Vocabulary Word Lists with Games, Puzzles and Quizzes

English Vocabulary Word List
Alan Beale's Core Vocabulary - J (197 Words)

    jabber
    jack
    jackal
    jackass
    jacket
    jackhammer
    jack-in-the-box
    jackknife
    jackknives
    jack-of-all-trades
    jack-o'-lantern
    jackpot
    Jacuzzi
    jade
    jaded
    jagged
    jaguar
    jail
    jailer
    jalopy
    jam
    jamb
    jamboree
    jammed
    Jan.
    Jane Doe
    jangle
    janitor
    January
    Japanese
    jar
    jargon
    jaundice
    jaundiced
    jaunt
    jauntily
    jaunty
    javelin
    jaw
    jaws
    jaywalker
    jazz
    jazzy
    jealous
    jealously
    jealousy
    jeans
    Jeep
    jeer

    jeez
    Jell-O
    jelly
    jellyfish
    jeopardize
    jeopardy
    jerk
    jerkily
    jerky
    jersey
    jest
    jester
    Jesus
    Jesus Christ
    jet
    jet black
    jet engine
    jet lag
    jet-lagged
    jet-propelled
    jet propulsion
    jet set
    jet setter
    jettison
    jetty
    Jew
    jewel
    jeweled
    jeweler
    jewelry
    Jewish
    jibe
    jiffy
    jig
    jigger
    jiggle
    jigsaw puzzle
    jilt
    jingle
    jinx
    jinxed
    jitters
    jittery
    jive
    job
    jobless
    joblessness
    jock
    jockey

    jockstrap
    jocular
    jocularity
    jog
    jogger
    jogging
    john
    John Doe
    join
    joint
    jointly
    joint venture
    joke
    joker
    jolly
    jolt
    jostle
    jot
    journal
    journalism
    journalist
    journey
    jovial
    jowls
    joy
    joyful
    joyfully
    joyfulness
    joyous
    joyously
    joyride
    joyrider
    joyriding
    joystick
    Jr.
    jubilant
    jubilation
    Judaism
    judge
    judgment
    judgmental
    Judgment Day
    judicial
    judiciary
    judicious
    judiciously
    jug
    juggle
    juggler

    jugular
    juice
    juicy
    jukebox
    Jul.
    July
    jumble
    jumbled
    jumbo
    jump
    jumper
    jumper cable
    jump rope
    jump-start
    jumpsuit
    jumpy
    Jun.
    junction
    juncture
    June
    jungle
    Junior
    junior
    junior college
    junior high school
    junk
    junket
    junk food
    junkie
    junk mail
    junkyard
    junta
    Jupiter
    jurisdiction
    juror
    jury
    just
    justice
    justice of the peace
    justifiable
    justifiably
    justification
    justified
    justify
    justly
    jut
    juvenile
    juvenile delinquent
    juxtapose
    juxtaposition
 ManyThings.org

    Reading
    Sentences
    More

English Vocabulary Word Lists with Games, Puzzles and Quizzes

English Vocabulary Word List
Alan Beale's Core Vocabulary - K (130 Words)

    kaleidoscope
    kangaroo
    kaput
    karat
    karate
    karma
    kayak
    keel
    keen
    keenly
    keenness
    keep
    keeper
    keeping
    keepsake
    keg
    kennel
    kept
    kernel
    kerosene
    ketchup
    kettle
    key
    keyboard
    keyhole
    keynote
    key ring
    kg:
    khaki
    khakis
    kick
    kickback
    kickoff

    kid
    kiddie
    kiddo
    kidnap
    kidnapper
    kidnapping
    kidney
    kidney bean
    kill
    killer
    killing
    kiln
    kilo
    kilobyte
    kilogram
    kilometer
    kilowatt
    kilt
    kimono
    kin
    kind
    kindergarten
    kindergartner
    kindhearted
    kindle
    kindling
    kindly
    kindness
    kindred
    kinfolk
    king
    kingdom
    kingfisher

    kingpin
    king-size
    kink
    kinky
    kiosk
    kiss
    kit
    kitchen
    kite
    kitten
    kitty
    kiwi
    Kleenex
    kleptomaniac
    klutz
    klutzy
    km:
    knack
    knapsack
    knead
    knee
    kneecap
    knee-deep
    knee-high
    kneel
    knelt
    knew
    knickers
    knickknack
    knife
    knight
    knit
    knitting

    knitting needle
    knives
    knob
    knobby
    knock
    knockdown-dragout
    knocker
    knockout
    knoll
    knot
    knotty
    know
    know-how
    knowing
    knowingly
    know-it-all
    knowledge
    knowledgeable
    knowledgeably
    known
    knuckle
    KO
    koala
    Koran
    Korean
    kosher
    kowtow
    kudos
    kung fu
    kW
    Kwanzaa
    ManyThings.org

    Reading
    Sentences
    More

English Vocabulary Word Lists with Games, Puzzles and Quizzes

English Vocabulary Word List
Alan Beale's Core Vocabulary - L (652 Words)

    lab
    label
    labor
    laboratory
    labor camp
    Labor Day
    laborer
    laborious
    laboriously
    labor union
    labyrinth
    lace
    lacerate
    laceration
    lack
    lacking
    lackluster
    lacquer
    lacy
    lad
    ladder
    laden
    ladies' room
    ladle
    lady
    ladybug
    lag
    lagoon
    laid
    laid-back
    lain
    lair
    lake
    lamb
    lame
    lame duck
    lament
    lamentable
    laminate
    lamp
    lampoon
    lampshade
    lance
    land
    landfill
    landing
    landing strip
    landlady
    landlocked
    landlord
    landmark
    land mine
    landowner
    landscape
    landslide
    lane
    language
    language laboratory
    languid
    languish
    languorous
    lanky
    lantern
    lap
    lapel
    lapse
    laptop
    larceny
    lard
    large
    largely
    large-scale
    lark
    larva
    larvae
    laryngitis
    larynx
    lascivious
    laser
    laser printer
    lash
    lasso
    last
    last-ditch
    lasting
    lastly
    last name
    latch
    late
    lately
    latent
    later
    lateral
    latest
    latex
    lather
    Latin
    Latina
    Latin America
    Latin American
    Latino
    latitude
    latrine
    latter
    laudable
    laugh
    laughable
    laughingstock
    laughter
    launch
    launch pad
    launder
    Laundromat
    laundry
    laundry room
    laureate
    laurel
    lava
    lavatory
    lavender
    lavish
    law
    law-abiding
    law enforcement
    lawful
    lawless
    lawlessness
    lawmaker
    lawn
    lawn mower
    lawsuit
    lawyer
    lax
    laxative
    laxity
    lay
    layaway
    layer
    layman
    layoff
    layout
    layover
    lazily
    laziness
    lazy
    lb.
    lead
    leader
    leadership
    leading
    leaf
    leaflet
    leafy
    league
    leak
    leakage
    leaky
    lean
    leaning
    leap
    leapfrog
    leapt
    leap year

    learn
    learned
    learning
    learning disability
    lease
    leash
    least
    leather
    leathery
    leave
    leaves
    lecherous
    lectern
    lecture
    lecturer
    led
    ledge
    ledger
    leech
    leek
    leer
    leery
    leeway
    left
    left field
    left-hand
    left-handed
    leftovers
    left wing
    left-wing
    leg
    legacy
    legal
    legality
    legalize
    legally
    legal pad
    legal-size
    legend
    legendary
    leggings
    leggy
    legibility
    legible
    legibly
    legion
    legislate
    legislation
    legislative
    legislator
    legislature
    legit
    legitimacy
    legitimate
    legitimately
    leisure
    leisurely
    lemon
    lemonade
    lend
    lender
    length
    lengthen
    lengthwise
    lengthy
    leniency
    lenient
    leniently
    lens
    Lent
    lent
    lentil
    Leo
    leopard
    leotard
    leper
    leprosy
    leprous
    lesbian
    lesbianism
    less
    lessen
    lesser
    lesson
    let
    letdown
    lethal
    lethally
    lethargic
    lethargy
    let's
    letter
    letter carrier
    letterhead
    letter-size
    lettuce
    letup
    leukemia
    levee
    level
    levelheaded
    lever
    leverage
    levitate
    levitation
    levity
    levy
    lewd
    lexical
    lexicon
    liability
    liable
    liaise
    liaison
    liar
    lib
    libel
    libelous
    liberal
    liberal arts
    liberalism
    liberalize
    liberally
    liberate
    liberated
    liberation
    liberty
    libido
    Libra
    librarian
    library
    lice
    license
    license plate
    lichen
    lick
    lickety-split
    licking
    licorice
    lid
    lie
    lie detector
    lien
    lieu
    lieutenant
    life
    life-and-death
    lifeboat
    life buoy
    life cycle
    life expectancy
    lifeguard
    life insurance
    life jacket
    lifeless
    lifelike
    lifeline
    lifelong
    life preserver
    lifesaver
    life-size
    life span
    lifestyle

    life support
    life-threatening
    lifetime
    lift
    liftoff
    ligament
    light
    light bulb
    lighten
    lighter
    light-headed
    lighthearted
    lighthouse
    lighting
    lightly
    lightness
    lightning
    lightweight
    light-year
    likable
    like
    likelihood
    likely
    like-minded
    liken
    likeness
    likewise
    liking
    lilac
    lilt
    lily
    lima bean
    limb
    limbo
    lime
    limelight
    limerick
    limit
    limitation
    limitations
    limited
    limiting
    limo
    limousine
    limp
    linchpin
    line
    lineage
    linear
    lined
    linen
    linens
    liner
    lines
    lineup
    linger
    lingerie
    lingo
    linguist
    linguistic
    linguistics
    liniment
    lining
    link
    linkage
    linoleum
    lint
    lion
    lip
    lip-read
    lipstick
    lip-synch
    liquefy
    liqueur
    liquid
    liquidate
    liquidation
    liquor
    liquor store
    lisp
    list
    listen
    listener
    listing
    listless
    listlessly
    list price
    lit
    litany
    lite
    liter
    literacy
    literal
    literally
    literary
    literate
    literature
    lithe
    litigate
    litigation
    litmus test
    litter
    litterbug
    little
    Little League
    liturgical
    liturgy
    livable
    live
    livelihood
    lively
    liven
    liver
    lives
    livestock
    livid
    living
    living room
    living will
    lizard
    llama
    Ln.
    load
    loaded
    loads
    loaf
    loafer
    loan
    loan shark
    loath
    loathe
    loathing
    loathsome
    loaves
    lob
    lobby
    lobbyist
    lobe
    lobster
    local
    local anesthetic
    locale
    locality
    localized
    locally
    local time
    locate
    location
    lock
    locker
    locker room
    locket
    locksmith
    locomotive
    locust
    lodge
    lodging
    loft
    lofty
    log
    logbook
    logging
    logic

    logical
    logically
    logistical
    logistics
    logjam
    logo
    loincloth
    loiter
    loll
    lollipop
    lone
    loneliness
    lonely
    loner
    lonesome
    long
    long-distance
    longevity
    longhand
    longing
    longingly
    longitude
    longitudinal
    long johns
    long jump
    long-lived
    long-range
    longshoreman
    long shot
    long-standing
    long-suffering
    long-term
    longtime
    long-winded
    look
    lookalike
    lookout
    looks
    loom
    loony
    loop
    loophole
    loose
    loose-leaf
    loosely
    loosen
    loot
    looter
    lop
    lope
    lopsided
    Lord
    lord
    Lord's Prayer
    lore
    lose
    loser
    loss
    lost
    lost-and-found
    lot
    lotion
    lots
    lottery
    loud
    loudly
    loudmouth
    loudmouthed
    loudness
    loudspeaker
    lounge
    louse
    lousy
    lovable
    love
    love affair
    loveliness
    lovely
    lover
    lovers
    love seat
    lovesick
    love story
    loving
    lovingly
    low
    lowbrow
    low-cal
    lowdown
    lower
    lowercase
    lower-class
    low-key
    lowly
    low-lying
    low-paid
    low tide
    loyal
    loyally
    loyalty
    lozenge
    LSD
    lubricant
    lubricate
    lubrication
    lucid
    lucidity
    lucidly
    luck
    luckily
    lucky
    lucrative
    ludicrous
    ludicrously
    lug
    luggage
    luggage rack
    lugubrious
    lukewarm
    lull
    lullaby
    lumber
    lumbering
    lumberjack
    lumberyard
    luminary
    luminous
    lump
    lump sum
    lumpy
    lunacy
    lunar
    lunatic
    lunch
    lunchbox
    luncheon
    lunchtime
    lung
    lunge
    lurch
    lure
    lurid
    luridly
    lurk
    luscious
    lush
    lust
    luster
    lustrous
    lusty
    Lutheran
    luxuriant
    luxuriate
    luxurious
    luxuriously
    luxury
    lying
    lynch
    lynching
    lyric
    lyrical
    lyricist
    lyrics
  ManyThings.org

    Reading
    Sentences
    More

English Vocabulary Word Lists with Games, Puzzles and Quizzes

English Vocabulary Word List
Alan Beale's Core Vocabulary - M (1138 Words)

    ma
    M.A.
    ma'am
    macabre
    macaroni
    Mace
    machete
    machine
    machine gun
    machinery
    machinist
    macho
    mackerel
    macro
    macrocosm
    mad
    madam
    madden
    maddening
    maddeningly
    made
    madhouse
    madly
    madman
    madness
    maelstrom
    Mafia
    magazine
    magenta
    maggot
    magic
    magical
    magically
    magician
    Magic Marker
    magistrate
    magnanimity
    magnanimous
    magnate
    magnesium
    magnet
    magnetic
    magnetic tape
    magnetism
    magnetize
    magnification
    magnificence
    magnificent
    magnificently
    magnify
    magnifying glass
    magnitude
    magnolia
    magpie
    mahogany
    maid
    maiden
    maiden name
    maiden voyage
    maid of honor
    mail
    mailbox
    mailing
    mailing list
    mailman
    mail order
    maim
    main
    main drag
    mainframe
    mainland
    mainly
    mainstay
    mainstream
    maintain
    maintenance
    maintenance man
    majestic
    majestically
    majesty
    major
    majority
    major-league
    majorly
    make
    make-believe
    maker
    makeshift
    makeup
    making
    malady
    malaise
    malaria
    male
    male chauvinism
    male chauvinist
    malevolence
    malevolent
    malfunction
    malice
    malicious
    maliciously
    malign
    malignancy
    malignant
    mall
    mallard
    mallet
    malnourished
    malnutrition
    malpractice
    malt
    malted milk
    mama
    mammal
    mammoth
    man
    manacle
    manage
    manageable
    management
    manager
    managerial
    Mandarin
    mandarin
    Mandarin Chinese
    mandarin orange
    mandate
    mandatory
    mane
    maneuver
    maneuvers
    mange
    manger
    mangle
    mango
    mangrove
    mangy
    manhandle
    manhole
    manhood
    manhunt
    mania
    maniac
    maniacal
    manic
    manicure
    manicurist
    manifest
    manifestation
    manifesto
    manifold
    manipulate
    manipulation
    manipulative
    mankind
    manliness
    manly
    man-made
    manned
    mannequin
    manner
    mannerism
    manners
    mannish
    manor
    manpower
    mansion
    manslaughter
    mantel
    mantelpiece
    mantle
    mantra
    manual
    manually
    manufacture
    manufacturer
    manufacturing
    manure
    manuscript
    many
    Maori
    map
    maple
    mar
    Mar.
    marathon
    marble
    marbles
    March
    march
    Mardi Gras
    mare
    margarine
    margin
    marginal
    marginally
    margin of error
    marijuana
    marina
    marinade
    marinate
    Marine
    marine
    Marine Corps
    mariner
    marionette
    marital
    marital status
    maritime
    mark
    markdown
    marked
    marker
    market
    marketability
    marketable
    marketer
    marketing
    marketplace
    market research
    marking
    marksman
    markup
    marmalade
    maroon
    marooned
    marquee
    marriage
    married
    marrow
    marry
    Mars
    marsh
    marshal
    marshmallow
    marshy
    marsupial
    mart
    martial
    martial art
    martial law
    Martian
    martyr
    martyrdom
    marvel
    marvelous
    Marxism
    Marxist
    masc.
    mascara
    mascot
    masculine
    masculinity
    mash
    mask
    masking tape
    masochism
    masochist
    masochistic
    Mason
    mason
    masonry
    masquerade
    Mass
    mass
    massacre
    massage
    masses
    masseur
    masseuse
    massive
    mass media
    mass-produce
    mass production
    mast
    master
    masterful
    master key
    mastermind
    master of ceremonies
    masterpiece
    master plan
    master's degree
    mastery

    masturbate
    masturbation
    mat
    match
    matchbook
    matchbox
    matchless
    matchmaker
    matchmaking
    matchstick
    mate
    material
    materialism
    materialist
    materialistic
    materialize
    maternal
    maternity
    math
    mathematical
    mathematically
    mathematician
    mathematics
    matinee
    matriarch
    matriarchal
    matriarchy
    matriculate
    matrimonial
    matrimony
    matron
    matronly
    matron of honor
    matte
    matted
    matter
    matting
    mattress
    mature
    maturity
    maudlin
    maul
    mausoleum
    mauve
    maverick
    mawkish
    max
    max.
    maxim
    maximize
    maximum
    May
    may
    maybe
    mayday
    May Day
    mayhem
    mayo
    mayonnaise
    mayor
    maze
    MB
    M.B.A.
    McCoy
    M.D.
    me
    meadow
    meager
    meal
    mealtime
    mealy-mouthed
    mean
    meander
    meaning
    meaningful
    meaningfully
    meaningless
    means
    meant
    meantime
    meanwhile
    measles
    measly
    measurable
    measure
    measurement
    measuring cup
    meat
    meatball
    meatloaf
    meaty
    Mecca
    mecca
    mechanic
    mechanical
    mechanically
    mechanics
    mechanism
    mechanization
    mechanize
    med
    medal
    medalist
    medallion
    meddle
    meddler
    meddlesome
    media
    median
    mediate
    mediation
    mediator
    Medicaid
    medical
    medical examiner
    medically
    Medicare
    medicated
    medication
    medicinal
    medicine
    medieval
    mediocre
    mediocrity
    meditate
    meditation
    Mediterranean
    medium
    medley
    meek
    meekly
    meekness
    meet
    meeting
    meetinghouse
    meg
    megabyte
    megalomania
    megalomaniac
    megaphone
    megaton
    melancholy
    meld
    melee
    mellow
    melodic
    melodious
    melodrama
    melodramatic
    melody
    melon
    melt
    meltdown
    melting pot
    member
    membership
    membrane
    memento
    memo
    memoirs
    memorabilia
    memorable
    memorably
    memoranda
    memorandum
    memorial
    Memorial Day
    memorize
    memory
    men
    menace
    menacing
    menagerie
    mend
    menial
    meningitis
    menopause
    menorah
    men's room
    menstrual
    menstruate
    menstruation
    mental
    mentality
    mentally
    menthol
    mention
    mentor
    menu
    meow
    mercenary
    merchandise
    merchant
    merciful
    mercifully
    merciless
    mercilessly
    Mercury
    mercury
    mercy
    mercy killing
    mere
    merely
    merge
    merger
    meridian
    meringue
    merit
    mermaid
    merrily
    merriment
    merry
    merry-go-round
    mesh
    mesmerize
    mess
    message
    messenger
    mess hall
    Messiah
    Messrs.
    messy
    met
    metabolic
    metabolism
    metal
    metallic
    metallurgist
    metallurgy
    metamorphoses
    metamorphosis
    metaphor
    metaphorical
    metaphorically
    metaphysical
    metaphysics
    mete
    meteor
    meteoric
    meteorite
    meteorological
    meteorologist
    meteorology
    meter
    meter maid
    methadone
    methane
    method
    methodical
    methodically
    Methodist
    methodological
    methodology
    meticulous
    meticulously
    metric
    metric system
    metro
    metropolis
    metropolitan
    mettle
    Mexican
    mezzanine
    mg:
    mi.
    mice
    microbe
    microbiology
    microchip
    microcosm
    microfiche
    microfilm
    microorganism
    microphone
    microprocessor
    microscope
    microscopic
    microwave
    midair
    midday
    middle
    middle age
    middle-aged
    Middle Ages
    Middle America

    middle class
    Middle East
    middleman
    middle name
    middle-of-the-road
    middle school
    midget
    midnight
    midriff
    midst
    midsummer
    midterm
    midway
    midweek
    Midwest
    Midwestern
    midwife
    midwinter
    midwives
    miffed
    might
    mighty
    migraine
    migrant
    migrate
    migration
    migratory
    mike
    mild
    mildew
    mildly
    mildness
    mile
    mileage
    miles
    milestone
    milieu
    militancy
    militant
    militarism
    military
    militate
    militia
    milk
    milk chocolate
    milkman
    milk shake
    milky
    Milky Way
    mill
    millennia
    millennium
    milligram
    milliliter
    millimeter
    milliner
    millinery
    million
    millionaire
    millionth
    mime
    mimic
    mimicry
    min.
    mince
    mincemeat
    mind
    mind-boggling
    mindful
    mindless
    mine
    minefield
    miner
    mineral
    mineral water
    mingle
    mini
    miniature
    minimal
    minimally
    minimize
    minimum
    minimum wage
    mining
    miniseries
    miniskirt
    minister
    ministerial
    ministry
    minivan
    mink
    minnow
    minor
    minority
    minstrel
    mint
    minty
    minus
    minuscule
    minus sign
    minute
    minutes
    miracle
    miraculous
    miraculously
    mirage
    mire
    mirror
    mirth
    misadventure
    misappropriate
    misappropriation
    misbehave
    misbehavior
    misc.
    miscalculate
    miscalculation
    miscarriage
    miscarriage of justice
    miscarry
    miscellaneous
    mischief
    mischievous
    mischievously
    misconception
    misconduct
    misconstrue
    misdemeanor
    miser
    miserable
    miserably
    misery
    misfit
    misfortune
    misgiving
    misguided
    mishap
    misinform
    misinterpret
    misinterpretation
    misjudge
    misjudgment
    mislead
    misleading
    misled
    mismanage
    mismanagement
    mismatch
    misnomer
    misogynist
    misogyny
    misplace
    misplaced
    misprint
    mispronounce
    mispronunciation
    misquote
    misread
    misreading
    misrepresent
    misrepresentation
    Miss
    miss
    missile
    missing
    mission
    missionary
    misspell
    misspelling
    misspent
    misstep
    mist
    mistake
    mistaken
    mistakenly
    mister
    mistletoe
    mistook
    mistreat
    mistreatment
    mistress
    mistrial
    mistrust
    misty
    misunderstand
    misunderstanding
    misunderstood
    misuse
    mite
    mitigate
    mitigating
    mitigation
    mitt
    mitten
    mix
    mixed
    mixed marriage
    mixed-up
    mixer
    mixture
    mix-up
    ml:
    mm:
    mo.
    moan
    moat
    mob
    mobile
    mobile home
    mobility
    mobilization
    mobilize
    moccasin
    mock
    mockery
    mockingbird
    modal
    mode
    model
    modeling
    modem
    moderate
    moderately
    moderation
    moderator
    modern
    modernity
    modernization
    modernize
    modest
    modestly
    modesty
    modicum
    modification
    modifier
    modify
    modular
    modulate
    modulation
    module
    mohair
    moist
    moisten
    moisture
    moisturizer
    molar
    molasses
    mold
    molding
    moldy
    mole
    molecular
    molecule
    molest
    molestation
    molester
    mollify
    mollusk
    molt
    molten
    mom
    moment
    momentarily
    momentary
    momentous
    momentum
    momma
    mommy
    Mon.
    monarch
    monarchy
    monastery
    monastic
    Monday
    monetary
    money
    money market
    money order
    mongrel
    moniker
    monitor
    monk
    monkey
    monkey wrench
    mono

    monochrome
    monogamous
    monogamy
    monogram
    monogrammed
    monolingual
    monolith
    monolithic
    monologue
    mononucleosis
    monopolization
    monopolize
    monopoly
    monorail
    monosyllable
    monotone
    monotonous
    monotonously
    monotony
    monsoon
    monster
    monstrosity
    monstrous
    montage
    month
    monthly
    monument
    monumental
    moo
    mooch
    mood
    moodily
    moodiness
    moody
    moon
    moonbeam
    moonlight
    moonlighting
    moonlit
    moor
    mooring
    moose
    moot
    mop
    mope
    moped
    moral
    morale
    moralist
    moralistic
    morality
    morally
    morals
    moral support
    morass
    moratorium
    morbid
    more
    moreover
    mores
    morgue
    Mormon
    morning
    morning sickness
    moron
    moronic
    morose
    morphine
    Morse code
    morsel
    mortal
    mortality
    mortally
    mortar
    mortarboard
    mortgage
    mortician
    mortification
    mortify
    mortifying
    mortuary
    mos.
    mosaic
    mosque
    mosquito
    moss
    mossy
    most
    mostly
    motel
    moth
    mothball
    moth-eaten
    mother
    motherboard
    motherfucker
    motherhood
    mother-in-law
    motherly
    Mother Nature
    Mother's Day
    mothers-in-law
    mother tongue
    motif
    motion
    motionless
    motion picture
    motivate
    motivated
    motivation
    motive
    motley
    motor
    motorbike
    motorboat
    motorcade
    motorcycle
    motorcyclist
    motor home
    motorist
    motorized
    motormouth
    motor vehicle
    mottled
    motto
    mound
    Mount
    mount
    mountain
    mountain bike
    mountaineer
    mountaineering
    mountain lion
    mountainous
    mountainside
    mounted
    mounting
    mourn
    mourner
    mournful
    mournfully
    mourning
    mouse
    mousse
    mousy
    mouth
    mouthful
    mouthpiece
    mouthwash
    mouth-watering
    movable
    move
    movement
    movements
    mover
    movie
    movies
    movie theater
    moving
    moving van
    mow
    mower
    mown
    mpg:
    mph:
    Mr.
    Mrs.
    MS
    Ms.
    Mt.
    much
    muck
    mucous
    mucus
    mud
    muddle
    muddled
    muddy
    mudslide
    mudslinging
    muff
    muffin
    muffle
    muffled
    muffler
    mug
    mugger
    mugging
    muggy
    Muhammad
    mulatto
    mulch
    mule
    mull
    multicultural
    multilateral
    multimedia
    multimillionaire
    multiple
    multiple-choice
    multiple sclerosis
    multiplex
    multiplication
    multiplicity
    multiply
    multitude
    mumble
    mumbo jumbo
    mummify
    mummy
    mumps
    munch
    munchies
    mundane
    municipal
    municipality
    munitions
    mural
    murder
    murderer
    murderous
    murky
    murmur
    muscle
    muscular
    muse
    museum
    mush
    mushroom
    mushy
    music
    musical
    musician
    musing
    musk
    musket
    Muslim
    muss
    mussel
    must
    mustache
    mustang
    mustard
    muster
    mustn't
    musty
    mutability
    mutable
    mutant
    mutate
    mutation
    mute
    muted
    mutely
    mutilate
    mutilation
    mutinous
    mutiny
    mutt
    mutter
    mutton
    mutual
    mutual fund
    mutually
    Muzak
    muzzle
    my
    myopic
    myriad
    myself
    mysterious
    mysteriously
    mystery
    mystic
    mystical
    mysticism
    mystify
    mystifying
    mystique
    myth
    mythical
    mythological
    mythology
 ManyThings.org

    Reading
    Sentences
    More

English Vocabulary Word Lists with Games, Puzzles and Quizzes

English Vocabulary Word List
Alan Beale's Core Vocabulary - N (449 Words)

    nag
    nagging
    nail
    nailbrush
    nail file
    nail polish
    naive
    naively
    naivete
    naked
    name
    name-dropping
    nameless
    namely
    namesake
    nanny
    nap
    napalm
    nape
    napkin
    nappy
    narc
    narcissism
    narcissist
    narcissistic
    narcotic
    narrate
    narration
    narrative
    narrator
    narrow
    narrowly
    narrow-minded
    narrowness
    NASA
    nasal
    nasally
    nastily
    nastiness
    nasty
    nation
    national
    national anthem
    National Guard
    nationalism
    nationalist
    nationalistic
    nationality
    nationalization
    nationalize
    nationally
    national monument
    national park
    nationwide
    native
    Native American
    native speaker
    NATO
    natural
    natural gas
    natural history
    naturalist
    naturalization
    naturalize
    naturally
    naturalness
    natural resources
    nature
    naught
    naughtily
    naughtiness
    naughty
    nausea
    nauseate
    nauseated
    nauseating
    nauseous
    nautical
    naval
    navel
    navigable
    navigate
    navigation
    navigational
    navigator
    navy
    navy blue
    NBA
    NC-17
    NE
    near
    nearby
    nearly
    nearsighted
    neat
    neatly
    neatness
    necessarily
    necessary
    necessitate
    necessity
    neck
    necklace
    neckline
    necktie
    nectar
    nectarine
    nee
    need
    needle
    needless
    needlessly

    needlework
    needs
    needy
    neg.
    negate
    negation
    negative
    negatively
    neglect
    neglected
    neglectful
    negligee
    negligence
    negligent
    negligently
    negligible
    negotiable
    negotiate
    negotiation
    negotiator
    Negro
    neigh
    neighbor
    neighborhood
    neighboring
    neighborly
    neither
    neon
    nephew
    nepotism
    Neptune
    nerd
    nerdy
    nerve
    nerve-racking
    nerves
    nervous
    nervous breakdown
    nervously
    nervousness
    nervous system
    nest
    nest egg
    nestle
    net
    netting
    nettle
    network
    neurological
    neurologist
    neurology
    neuroses
    neurosis
    neurotic
    neuter
    neutral
    neutrality
    neutralization
    neutralize
    neutron
    never
    nevertheless
    new
    New Age
    newborn
    newcomer
    newfangled
    newly
    newlywed
    newlyweds
    new moon
    newness
    news
    newscast
    newscaster
    newsletter
    newspaper
    newsprint
    newsstand
    newsworthy
    newsy
    newt
    New Testament
    New World
    new year
    New Year's Day
    New Year's Eve
    next
    next best
    next-door
    next of kin
    NFL
    NHL
    nibble
    nice
    nicely
    niche
    nick
    nickel
    nickel-and-dime
    nickname
    nicotine
    niece
    nifty
    nigger
    niggling
    night
    nightclub
    nightfall
    nightgown
    nightie
    nightingale

    nightlife
    night light
    nightly
    nightmare
    nightmarish
    night owl
    nights
    night school
    night table
    nighttime
    nil
    nimble
    nimbly
    nincompoop
    nine
    nineteen
    nineteenth
    ninetieth
    ninety
    ninth
    nip
    nipple
    nippy
    nit
    nitrate
    nitrogen
    nitty-gritty
    nitwit
    no
    no.
    nobility
    noble
    nobleman
    noblewoman
    nobly
    nobody
    no-brainer
    nocturnal
    nod
    node
    no-fault
    no-frills
    noise
    noiseless
    noiselessly
    noise pollution
    noisily
    noisy
    nomad
    nomadic
    no man's land
    nomenclature
    nominal
    nominally
    nominate
    nomination
    nominee
    nonchalance
    nonchalant
    nonchalantly
    noncommittal
    noncommittally
    nonconformist
    nondairy
    nondenominational
    nondescript
    none
    nonentity
    nonetheless
    nonevent
    nonexistent
    nonfat
    nonfiction
    nonflammable
    nonintervention
    no-no
    no-nonsense
    nonplussed
    nonprofit
    nonproliferation
    nonrefundable
    nonrenewable
    nonsense
    nonsensical
    non sequitur
    nonsmoker
    nonsmoking
    nonstandard
    nonstick
    nonstop
    nonverbal
    nonviolence
    nonviolent
    noodle
    nook
    noon
    no one
    noose
    nope
    nor
    norm
    normal
    normalcy
    normality
    normalization
    normalize
    normally
    north
    North America
    North American
    northbound
    northeast

    northeasterly
    northeastern
    northeastward
    northerly
    northern
    northerner
    northern lights
    northernmost
    North Pole
    northward
    northwest
    northwesterly
    northwestern
    northwestward
    nose
    nosebleed
    nosedive
    nose job
    no-show
    nostalgia
    nostalgic
    nostalgically
    nostril
    nosy
    not
    notable
    notably
    notary public
    notation
    notch
    note
    notebook
    noted
    notes
    noteworthy
    'nother
    nothing
    notice
    noticeable
    noticeably
    notification
    notify
    notion
    notoriety
    notorious
    notoriously
    notwithstanding
    noun
    nourish
    nourishing
    nourishment
    Nov.
    novel
    novelist
    novelty
    November
    novice
    now
    nowadays
    nowhere
    noxious
    nozzle
    nuance
    nuclear
    nuclear energy
    nuclear family
    nuclear reaction
    nuclear reactor
    nuclei
    nucleus
    nude
    nudge
    nudist
    nudity
    nugget
    nuisance
    nuke
    nullify
    numb
    number
    number cruncher
    numbness
    numeral
    numerical
    numerically
    numerous
    nun
    nuptial
    nuptials
    nurse
    nursery
    nursery rhyme
    nursery school
    nursing
    nursing home
    nurture
    nut
    nutcracker
    nutmeg
    nutrient
    nutrition
    nutritional
    nutritious
    nuts
    nutshell
    nutty
    nuzzle
    NW
    nylon
    nylons
    nymph
    nymphomania
    nymphomaniac
 ManyThings.org

    Reading
    Sentences
    More

English Vocabulary Word Lists with Games, Puzzles and Quizzes

English Vocabulary Word List
Alan Beale's Core Vocabulary - O (558 Words)

    oaf
    oak
    oar
    oases
    oasis
    oat
    oath
    oatmeal
    oats
    obedience
    obedient
    obediently
    obese
    obesity
    obey
    obituary
    object
    objection
    objectionable
    objective
    objectively
    objectivity
    objector
    obligate
    obligated
    obligation
    obligatory
    oblige
    obliged
    obliging
    obligingly
    oblique
    obliterate
    obliteration
    oblivion
    oblivious
    oblong
    obnoxious
    obnoxiously
    oboe
    obscene
    obscenity
    obscure
    obscurity
    observable
    observance
    observant
    observation
    observatory
    observe
    observer
    obsess
    obsessed
    obsession
    obsessive
    obsessively
    obsolescence
    obsolete
    obstacle
    obstetrician
    obstetrics
    obstinacy
    obstinate
    obstinately
    obstruct
    obstruction
    obstructive
    obtain
    obtainable
    obtrusive
    obtuse
    obvious
    obviously
    occasion
    occasional
    occasionally
    occult
    occupancy
    occupant
    occupation
    occupational
    occupied
    occupy
    occur
    occurrence
    ocean
    oceanic
    oceanography
    o'clock
    Oct.
    octagon
    octagonal
    octave
    October
    octopi
    octopus
    OD
    odd
    oddity
    odd jobs
    oddly
    oddness
    odds
    odds and ends
    ode
    odious
    odometer
    odor
    odyssey
    of
    off
    offbeat
    off-color
    offend
    offender
    offense
    offensive
    offensively
    offer
    offering
    offhand
    office
    officer
    official
    officially
    officiate
    officious
    offing
    off-key
    off-limits
    off-peak
    off-ramp
    offset
    offshoot
    offshore
    offspring
    offstage
    off-the-record
    off-the-wall
    off-white

    often
    ogle
    ogre
    oh
    ohm
    oh well
    oil
    oiled
    oilfield
    oil painting
    oils
    oil slick
    oil well
    oily
    oink
    ointment
    OK
    okay
    okra
    old
    old age
    olden
    old-fashioned
    oldie
    Old Testament
    old-timer
    Old World
    olive
    olive oil
    Olympic
    Olympic Games
    Olympics
    ombudsman
    omelet
    omen
    ominous
    ominously
    omission
    omit
    omnipotence
    omniscience
    omniscient
    on
    once
    once-over
    oncoming
    one
    one-night stand
    one-on-one
    onerous
    oneself
    one-sided
    onetime
    one-to-one
    one-track mind
    one-upmanship
    one-way
    ongoing
    onion
    on-line
    onlooker
    only
    only child
    on-ramp
    onrush
    onset
    onslaught
    onto
    onus
    onward
    onwards
    oodles
    oops
    ooze
    opal
    opaque
    open
    open-air
    open-ended
    opener
    open house
    opening
    openly
    open-minded
    openness
    open season
    opera
    operable
    opera house
    operate
    operatic
    operating room
    operating system
    operation
    operational
    operationally
    operative
    operator
    ophthalmologist
    ophthalmology
    opinion
    opinionated
    opinion poll
    opium
    opossum
    opponent
    opportune
    opportunism
    opportunist
    opportunistic
    opportunity
    oppose
    opposed
    opposite
    opposition
    oppress
    oppressed
    oppression
    oppressive
    oppressor
    opt
    optic
    optical
    optical illusion
    optician
    optimism
    optimist
    optimistic
    optimistically
    optimum
    option
    optional
    optometrist
    optometry
    opulence
    opulent
    OR
    or
    oral
    orally

    orange
    orangutan
    oration
    orator
    oratory
    orbit
    orbital
    orchard
    orchestra
    orchestral
    orchestrate
    orchestration
    orchid
    ordain
    ordeal
    order
    orderly
    ordinal
    ordinance
    ordinarily
    ordinary
    ordination
    ore
    organ
    organic
    organically
    organism
    organist
    organization
    organizational
    organize
    organized
    organizer
    orgasm
    orgy
    Orient
    orient
    Oriental
    oriental
    orientation
    oriented
    origin
    original
    originality
    originally
    originate
    oriole
    ornament
    ornamental
    ornate
    ornately
    ornithologist
    ornithology
    orphan
    orphanage
    orthodontics
    orthodontist
    orthodox
    orthodoxy
    orthopedics
    Oscar
    ostentation
    ostentatious
    ostentatiously
    ostracism
    ostracize
    ostrich
    other
    otherwise
    otter
    ouch
    ought to
    ounce
    our
    ours
    ourselves
    oust
    ouster
    out
    outage
    outback
    outbid
    outboard motor
    outbreak
    outburst
    outcast
    outclass
    outcome
    outcropping
    outcry
    outdated
    outdid
    outdistance
    outdo
    outdone
    outdoor
    outdoors
    outer
    outermost
    outer space
    outfield
    outfielder
    outfit
    outgoing
    outgrew
    outgrow
    outgrown
    outgrowth
    outhouse
    outing
    outlandish
    outlast
    outlaw
    outlay
    outlet
    outline
    outlive
    outlook
    outlying
    outmaneuver
    outmoded
    outnumber
    out of
    out-of-bounds
    out-of-date
    out-of-the-way
    outpatient
    outperform
    outplacement
    outpost
    outpouring
    output
    outrage
    outraged
    outrageous
    outrageously
    outran
    outreach
    outright
    outrun

    outset
    outshine
    outshone
    outside
    outside of
    outsider
    outskirts
    outsmart
    outsourcing
    outspoken
    outspokenness
    outstanding
    outstandingly
    outstretched
    outstrip
    outward
    outwardly
    outwards
    outweigh
    outwit
    oval
    ovarian
    ovary
    ovation
    oven
    over
    overall
    overalls
    overate
    overbearing
    overboard
    overcame
    overcast
    overcharge
    overcoat
    overcome
    overcompensate
    overcompensation
    overcrowded
    overdid
    overdo
    overdone
    overdose
    overdraw
    overdrawn
    overdrew
    overdue
    overeat
    overeaten
    overestimate
    overextend
    overextended
    overflow
    overgrown
    overhand
    overhang
    overhaul
    overhead
    overhead projector
    overhear
    overheard
    overjoyed
    overland
    overlap
    overload
    overlook
    overly
    overnight
    overpass
    overpopulated
    overpopulation
    overpower
    overpowering
    overpriced
    overran
    overrate
    overrated
    overreact
    overridden
    override
    overriding
    overrode
    overrule
    overrun
    oversaw
    overseas
    oversee
    overseen
    overseer
    overshadow
    overshoot
    overshot
    oversight
    oversimplification
    oversimplify
    oversized
    oversleep
    overslept
    overstate
    overstep
    overt
    overtake
    overtaken
    over-the-counter
    overthrew
    overthrow
    overthrown
    overtime
    overtly
    overtone
    overtook
    overture
    overturn
    overview
    overweight
    overwhelm
    overwhelmed
    overwhelming
    overwhelmingly
    overwork
    overworked
    overwrought
    ow
    owe
    owing to
    owl
    own
    owner
    ownership
    ox
    oxen
    oxide
    oxidize
    oxygen
    oyster
    oz.
    ozone
    ozone layer
 ManyThings.org

    Reading
    Sentences
    More

English Vocabulary Word Lists with Games, Puzzles and Quizzes

English Vocabulary Word List
Alan Beale's Core Vocabulary - P (1778 Words)

    p.
    PA
    pa
    pace
    pacemaker
    pacesetter
    Pacific
    Pacific Ocean
    pacifier
    pacifism
    pacifist
    pacify
    pack
    package
    package tour
    packaging
    packed
    packer
    packet
    packing
    pack rat
    pact
    pad
    padding
    paddle
    paddock
    paddy
    padlock
    padre
    pagan
    page
    pageant
    pageantry
    pager
    pagoda
    paid
    pail
    pain
    pained
    painful
    painfully
    painkiller
    painless
    painlessly
    painstaking
    painstakingly
    paint
    paintbrush
    painter
    painting
    paints
    pair
    pajamas
    pal
    palace
    palatable
    palate
    palatial
    pale
    paleontologist
    paleontology
    palette
    pall
    pallbearer
    pallid
    pallor
    palm
    Palm Sunday
    palm tree
    palpable
    palpably
    paltry
    pamper
    pamphlet
    pan
    panacea
    panache
    pancake
    pancreas
    pancreatic
    panda
    pandemonium
    pander
    pane
    panel
    paneling
    panelist
    pang
    panhandle
    panhandler
    panic
    panicky
    panic-stricken
    panorama
    panoramic
    pansy
    pant
    pantheism
    panther
    panties
    pantomime
    pantry
    pants
    pantyhose
    papa
    papacy
    papal
    papaya
    paper
    paperback
    paperboy
    paper clip
    papergirl
    papers
    paperweight
    paperwork
    papier-mache
    paprika
    Pap smear
    par
    parable
    parachute
    parade
    paradigm
    paradise
    paradox
    paradoxical
    paradoxically
    paraffin
    paragon
    paragraph
    parakeet
    paralegal
    parallel
    paralysis
    paralytic
    paralyze
    paralyzed
    paramedic
    parameter
    paramilitary
    paramount
    paranoia
    paranoid
    paraphernalia
    paraphrase
    paraplegic
    parasite
    parasitic
    parasol
    paratrooper
    parcel
    parcel post
    parched
    parchment
    pardon
    pardonable
    pardon me
    pare
    parent
    parentage
    parental
    parentheses
    parenthesis
    parenthood
    parish
    parishioner
    parity
    park
    parka
    parking
    parking brake
    parking garage
    parking lot
    parking meter
    parking ticket
    parkway
    parliament
    parliamentary
    parlor
    parochial
    parody
    parole
    parquet
    parrot
    parsley
    parsnip
    part
    partial
    partiality
    partially
    participant
    participate
    participation
    participle
    particle
    particular
    particularly
    particulars
    parting
    partisan
    partition
    partly
    partner
    partnership
    part of speech
    partridge
    part-time
    partway
    party
    party favor
    pass
    passable
    passage
    passageway
    passbook
    passe
    passenger
    passerby
    passersby
    passing
    passion
    passionate
    passionately
    passive
    passively
    Passover
    passport
    password
    past
    pasta
    paste
    pastel
    pasteurization
    pasteurize
    pasteurized
    pastime
    pastor
    pastoral
    pastry
    past tense
    pasture
    pasty
    PA system
    pat
    patch
    patchwork
    patchy
    pate
    patent
    patent leather
    patently
    paternal
    paternalism
    paternalistic
    paternity
    path
    pathetic
    pathetically
    pathological
    pathologically
    pathologist
    pathology
    pathos
    pathway
    patience
    patient
    patiently
    patio
    patriarch
    patriarchal
    patriarchy
    patricide
    patrimony
    patriot
    patriotic
    patriotically
    patriotism
    patrol
    patrolman
    patrolwoman
    patron
    patronage
    patronize
    patronizing
    patronizingly
    patron saint
    patter
    pattern
    patterned
    patty
    paucity
    paunch
    paunchy
    pause
    pave
    pavement
    pavilion
    paw
    pawn
    pawnbroker
    pay
    payable
    paycheck
    payday
    pay dirt
    payee
    payload
    payment
    payoff
    pay phone
    payroll
    pay-TV
    PC
    PE
    pea
    peace
    peaceable
    peaceably
    Peace Corps
    peaceful
    peacefully
    peacefulness
    peacekeeping
    peacemaker
    peace pipe
    peacetime
    peach
    peacock
    peak
    peaked
    peal
    peanut
    peanut butter
    peanuts
    pear
    pearl
    peasant
    peat
    pebble
    pecan
    peck
    peculiar
    peculiarity
    peculiarly
    pedagogical
    pedagogy
    pedal
    pedantic
    pedantically
    pedantry
    peddle
    peddler
    pedestal
    pedestrian
    pediatrician
    pediatrics
    pedigree
    pedigreed
    pee
    peek
    peekaboo
    peel
    peep
    peephole
    peeping Tom
    peer
    peerless
    peeve
    peg
    pejorative
    pelican
    pellet
    pelt
    pelvic
    pelvis
    pen
    penal
    penalize
    penalty
    penalty box
    penance
    penchant
    pencil
    pencil case
    pencil sharpener
    pendant
    pending
    pendulum
    penetrate
    penetrating
    penetration
    penguin
    penicillin
    peninsula
    penis
    penitence
    penitent
    penitentiary
    penknife
    penknives
    pen name
    pennant
    penniless
    penny
    pen pal
    pension
    pensive
    Pentagon
    pentagon
    penthouse
    pent-up
    peon
    people
    pep
    pepper
    peppermint
    pepperoni
    peppy
    pep rally
    pep talk
    per
    perceive
    percent
    percentage
    percentile
    perceptible
    perceptibly
    perception
    perceptive
    perceptively
    perch
    percolate
    percolator
    percussion
    peremptory
    perennial
    perfect
    perfection
    perfectionist
    perfectly
    perforate
    perform
    performance
    performer

    perfume
    perfunctorily
    perfunctory
    perhaps
    peril
    perilous
    perimeter
    period
    periodic
    periodical
    periodically
    periodic table
    peripheral
    periphery
    periscope
    perish
    perishable
    perishables
    perjure
    perjury
    perk
    perky
    perm
    permanence
    permanent
    permanently
    permeate
    permissible
    permission
    permissive
    permit
    permutation
    pernicious
    peroxide
    perpendicular
    perpetrate
    perpetrator
    perpetual
    perpetually
    perpetuate
    perplex
    perplexed
    perplexing
    perquisite
    per se
    persecute
    persecution
    persecutor
    perseverance
    persevere
    persist
    persistence
    persistent
    persistently
    person
    persona
    personable
    personae
    personal
    personal computer
    personality
    personalize
    personally
    personal pronoun
    personals
    personification
    personify
    personnel
    perspective
    perspiration
    perspire
    persuade
    persuasion
    persuasive
    persuasively
    persuasiveness
    pert
    pertain
    pertinent
    perturb
    perusal
    peruse
    pervade
    pervasive
    perverse
    perversely
    perversion
    perversity
    pervert
    perverted
    pesky
    pessimism
    pessimist
    pessimistic
    pessimistically
    pest
    pester
    pesticide
    pet
    petal
    peter
    petite
    petition
    petrified
    petrify
    petroleum
    pettiness
    petty
    petty cash
    petulant
    pew
    pewter
    PG
    PG-13
    phallic
    phallus
    phantom
    Pharaoh
    pharmaceutical
    pharmacist
    pharmacologist
    pharmacology
    pharmacy
    phase
    Ph.D.
    pheasant
    phenomena
    phenomenal
    phenomenally
    phenomenon
    philanthropic
    philanthropist
    philanthropy
    philistine
    philosopher
    philosophical
    philosophically
    philosophize
    philosophy
    phlegm
    phlegmatic
    phobia
    phobic
    phoenix
    phone
    phone book
    phone booth
    phone call
    phonetic
    phonetically
    phonetics
    phonograph
    phony
    phooey
    phosphate
    phosphorescence
    phosphorescent
    phosphorus
    photo
    photocopier
    photocopy
    photo finish
    photogenic
    photograph
    photographer
    photographic
    photography
    photo opportunity
    photosynthesis
    phrasal verb
    phrase
    phrasing
    physical
    physical education
    physical examination
    physically
    physical therapist
    physical therapy
    physician
    physicist
    physics
    physiological
    physiology
    physiotherapy
    physique
    pianist
    piano
    piccolo
    pick
    pickax
    picker
    picket
    picket fence
    picket line
    pickle
    pickled
    pickpocket
    pickup
    pickup truck
    picky
    picnic
    pictorial
    picture
    picturesque
    piddling
    pidgin
    pie
    piece
    piecemeal
    piecework
    pie chart
    pier
    pierce
    piercing
    piety
    pig
    pigeon
    pigeonhole
    piggy
    piggyback
    piggy bank
    pigheaded
    piglet
    pigment
    pigmentation
    pigpen
    pigsty
    pigtail
    pike
    pile
    pileup
    pilfer
    Pilgrim
    pilgrim
    pilgrimage
    piling
    pill
    pillage
    pillar
    pillow
    pillowcase
    pilot
    pilot light
    pimp
    pimple
    pimply
    PIN
    pin
    pinball machine
    pincers
    pinch
    pinch-hit
    pinch hitter
    pincushion
    pine
    pineapple
    ping
    ping-pong
    pinion
    pink
    pinkie
    pinnacle
    PIN number
    pinpoint
    pinprick
    pins and needles
    pinstripe
    pint
    pinup
    pioneer
    pious
    piously
    pipe
    pipe dream
    pipeline
    piping
    pipsqueak
    piquancy
    piquant
    pique
    piracy
    piranha
    pirate
    pirouette
    Pisces
    piss
    pissed
    pissed off
    pistachio
    pistol
    piston
    pit
    pitch
    pitch-black
    pitcher
    pitchfork
    piteous
    pitfall
    pithy
    pitiful
    pitifully
    pitiless
    pittance
    pity
    pivot
    pivotal
    pixel
    pixie
    pizza
    pizzazz
    pj's
    Pkwy.
    Pl.
    placard
    place
    placebo
    place mat
    placenta
    placid
    placidly
    plagiarism
    plagiarist
    plagiarize
    plague
    plaid
    plain
    plainclothes
    plainly
    plains
    plaintiff
    plaintive
    plan
    plane
    planet
    planetaria
    planetarium
    planetary
    plank
    plankton
    planner
    planning
    plant
    plantation
    planter
    planting
    plaque
    plasma
    plaster
    plastered
    plastic
    plastic surgery
    plate
    plateau
    plated
    plateful
    platform
    plating
    platinum
    platitude
    platonic
    platoon
    platter
    plausible
    play
    playboy
    play-by-play
    player
    playful
    playfully
    playfulness
    playground
    playhouse
    playing card
    playing field
    playmate
    playoff
    playpen
    playroom
    plaything
    playwright
    plaza
    plea
    plea-bargain
    plead
    pleasant
    pleasantly
    pleasantry
    please
    pleased
    pleasing
    pleasurable
    pleasure
    pleat
    pleated
    pled
    pledge
    plenary
    plentiful
    plentifully
    plenty
    plethora
    Plexiglas
    pliable
    pliant
    pliers
    plight
    plod
    plodding
    plop
    plot
    plow
    ploy
    pluck
    plucky
    plug
    plum
    plumage
    plumber
    plumbing
    plume
    plummet
    plump
    plunder
    plunge
    plunger
    plunk
    plural
    plurality
    plus
    plush
    plus sign
    Pluto
    plutocracy
    plutonium
    ply
    plywood
    P.M.
    PMS
    pneumatic
    pneumonia
    poach
    poacher
    P.O. Box
    pocket
    pocketbook

    pocketful
    pocketknife
    pocketknives
    pockmark
    pockmarked
    pod
    podiatrist
    podiatry
    podium
    poem
    poet
    poetic
    poetically
    poetic justice
    poetic license
    poetry
    pogrom
    poignancy
    poignant
    poignantly
    poinsettia
    point
    point-blank
    pointed
    pointedly
    pointer
    pointless
    pointlessly
    pointlessness
    point man
    point of view
    pointy
    poise
    poised
    poison
    poisoning
    poison ivy
    poisonous
    poke
    poker
    poky
    polar
    polar bear
    polarity
    polarization
    polarize
    Polaroid
    Pole
    pole
    polemic
    polemical
    pole vault
    police
    police department
    police force
    policeman
    police officer
    police state
    police station
    policewoman
    policy
    polio
    Polish
    polish
    polished
    polite
    politely
    politeness
    political
    political correctness
    politically
    politically correct
    political science
    politician
    politicize
    politics
    polka
    polka dot
    poll
    pollen
    pollinate
    pollination
    polling place
    polls
    pollster
    pollutant
    pollute
    polluted
    pollution
    polo
    polo shirt
    polyester
    polygamist
    polygamous
    polygamy
    polygon
    polygraph
    polymer
    polyp
    polytechnic
    pomegranate
    pomp
    pompom
    pomposity
    pompous
    poncho
    pond
    ponder
    ponderous
    pontiff
    pontifical
    pontoon
    pony
    pony express
    ponytail
    pooch
    poodle
    pooh-pooh
    pool
    pool table
    poop
    pooped
    poor
    poorly
    pop
    popcorn
    Pope
    poplar
    pop music
    poppy
    pop quiz
    Popsicle
    populace
    popular
    popularity
    popularize
    popularly
    populate
    population
    populous
    porcelain
    porch
    porcupine
    pore
    pork
    porn
    pornographer
    pornographic
    pornography
    porous
    porpoise
    port
    portable
    portal
    portend
    portent
    porter
    portfolio
    porthole
    portico
    portion
    portly
    portrait
    portray
    portrayal
    Portuguese
    pose
    posh
    position
    positive
    positively
    posse
    possess
    possessed
    possession
    possessions
    possessive
    possibility
    possible
    possibly
    possum
    post
    postage
    postage stamp
    postal
    postal service
    postcard
    postdate
    postdoc
    postdoctoral
    poster
    posterior
    posterity
    postgraduate
    posthumous
    posthumously
    postman
    postmark
    postmaster
    postmortem
    post office
    post office box
    postpone
    postponement
    postscript
    postulate
    posture
    postwar
    posy
    pot
    potassium
    potato
    potato chip
    potbellied
    potbelly
    potency
    potent
    potential
    potentially
    pothole
    potion
    potluck
    potpourri
    potter
    pottery
    potty
    pouch
    poultry
    pounce
    pound
    pound cake
    pour
    pout
    poverty
    poverty line
    poverty-stricken
    POW
    powder
    powdered
    powder room
    powdery
    power
    powerboat
    powerful
    powerfully
    powerhouse
    powerless
    powerlessness
    power of attorney
    power outage
    power plant
    power steering
    powwow
    pp.
    PR
    practicable
    practical
    practicality
    practical joke
    practically
    practice
    practicing
    practitioner
    pragmatic
    pragmatism
    pragmatist
    prairie
    praise
    praiseworthy
    prance
    prank
    prankster
    prawn
    pray
    prayer
    preach
    preacher
    preamble
    precarious
    precariously
    precaution
    precautionary
    precede
    precedence
    precedent
    preceding
    precept
    precinct
    precious
    precious stone
    precipice
    precipitate
    precipitation
    precipitous
    precise
    precisely
    precision
    preclude
    precocious
    preconceived
    preconception
    precondition
    precursor
    predate
    predator
    predatory
    predecessor
    predestination
    predestined
    predetermined
    predicament
    predicate
    predict
    predictable
    predictably
    prediction
    predilection
    predisposed
    predisposition
    predominance
    predominant
    predominantly
    predominate
    preeminence
    preeminent
    preempt
    preemptive
    preen
    preexisting
    prefab
    prefabricated
    preface
    prefer
    preferable
    preferably
    preference
    preferential
    prefix
    pregnancy
    pregnant
    prehistoric
    prehistory
    prejudge
    prejudice
    prejudiced
    prejudicial
    preliminary
    prelude
    premarital
    premature
    prematurely
    premeditated
    premeditation
    premenstrual syndrome
    premier
    premiere
    premise
    premises
    premium
    premonition
    prenatal
    preoccupation
    preoccupied
    preoccupy
    prep
    preparation
    preparatory
    prepare
    prepared
    preparedness
    preponderance
    preposition
    preposterous
    preppy
    prep school
    preregister
    preregistration
    prerequisite
    prerogative
    presage
    Presbyterian
    preschool
    preschooler
    prescribe
    prescription
    prescriptive
    presence
    present
    presentable
    presentation
    present-day
    presently
    present tense
    preservation
    preservative
    preserve
    preserves
    preside
    presidency
    President
    president
    presidential
    Presidents' Day
    press
    press agent
    press conference
    pressed
    pressing
    press release
    pressure
    pressure cooker
    pressurized
    prestige
    prestigious
    presumably
    presume
    presumption
    presumptuous
    presuppose
    presupposition
    pretend
    pretense
    pretension
    pretentious
    pretext
    prettily
    pretty
    pretzel
    prevail
    prevailing
    prevalence
    prevalent
    prevent
    preventable
    prevention
    preventive
    preview
    previous
    previously
    prewar
    prey
    price
    priceless
    pricey
    prick

    prickle
    prickly
    pride
    priest
    priestess
    priesthood
    prim
    primacy
    prima donna
    primal
    primarily
    primary
    primary care
    primary color
    primary school
    primate
    prime
    prime minister
    primer
    prime rate
    prime time
    primeval
    primitive
    primly
    primordial
    primp
    primrose
    prince
    princely
    princess
    principal
    principality
    principally
    principle
    principled
    principles
    print
    printer
    printing
    printing press
    printout
    prior
    prioritize
    priority
    prism
    prison
    prisoner
    prisoner of war
    prissy
    pristine
    privacy
    private
    private enterprise
    private investigator
    privately
    private parts
    privation
    privatization
    privatize
    privilege
    privileged
    privy
    prize
    pro
    probability
    probable
    probably
    probation
    probation officer
    probe
    probing
    problem
    problematic
    procedural
    procedure
    proceed
    proceedings
    proceeds
    process
    procession
    processional
    processor
    proclaim
    proclamation
    procrastinate
    procrastination
    procreate
    procure
    procurement
    prod
    prodding
    prodigal
    prodigious
    prodigy
    produce
    producer
    product
    production
    productive
    productivity
    prof
    Prof.
    profane
    profanity
    profess
    professed
    profession
    professional
    professionalism
    professionally
    professor
    proficiency
    proficient
    profile
    profit
    profitability
    profitable
    profitably
    profiteer
    profit margin
    profit sharing
    profound
    profoundly
    profundity
    profuse
    profusion
    progeny
    prognoses
    prognosis
    program
    programmer
    programming
    progress
    progression
    progressive
    progressively
    prohibit
    Prohibition
    prohibition
    prohibitive
    prohibitively
    project
    projectile
    projection
    projector
    proletarian
    proletariat
    proliferate
    proliferation
    prolific
    prologue
    prolong
    prolonged
    prom
    promenade
    prominence
    prominent
    prominently
    promiscuity
    promiscuous
    promise
    promising
    promo
    promontory
    promote
    promoter
    promotion
    promotional
    prompt
    prompting
    promptly
    prone
    prong
    pronoun
    pronounce
    pronounced
    pronouncement
    pronto
    pronunciation
    proof
    proofread
    prop
    propaganda
    propagandize
    propagate
    propagation
    propel
    propeller
    propensity
    proper
    properly
    proper noun
    property
    prophecy
    prophesy
    prophet
    prophetic
    propitious
    proponent
    proportion
    proportional
    proportions
    proposal
    propose
    proposition
    proprietary
    proprietor
    propriety
    propulsion
    pro rata
    prosaic
    proscribe
    proscription
    prose
    prosecute
    prosecution
    prosecutor
    proselytize
    prospect
    prospective
    prospector
    prospects
    prospectus
    prosper
    prosperity
    prosperous
    prostheses
    prosthesis
    prostitute
    prostitution
    prostrate
    protagonist
    protect
    protection
    protective
    protector
    protege
    protein
    protest
    Protestant
    protester
    protocol
    proton
    prototype
    protracted
    protraction
    protrude
    protrusion
    proud
    proudly
    prove
    proven
    proverb
    proverbial
    provide
    provided
    provided that
    providence
    provident
    providing
    providing that
    province
    provincial
    provision
    provisional
    provisions
    proviso
    provocation
    provocative
    provoke
    provost
    prow
    prowess
    prowl
    prowler
    proximity
    proxy
    prude
    prudence
    prudent
    prudently
    prudish
    prune
    prurience
    prurient
    pry
    P.S.
    psalm
    pseudonym
    psych
    psyche
    psyched
    psychedelic
    psychiatric
    psychiatrist
    psychiatry
    psychic
    psycho
    psychoanalysis
    psychoanalyst
    psychoanalyze
    psychological
    psychologically
    psychologist
    psychology
    psychopath
    psychopathic
    psychoses
    psychosis
    psychosomatic
    psychotherapist
    psychotherapy
    psychotic
    pt.
    pub
    puberty
    pubescence
    pubic
    public
    public access
    public address system
    public assistance
    publication
    public defender
    publicist
    publicity
    publicize
    publicly
    public opinion
    public relations
    public school
    public television
    public transportation
    public utility
    publish
    publisher
    publishing
    puck
    pucker
    puckered
    pudding
    puddle
    pudgy
    puerile
    puff
    puffy
    pugnacious
    puke
    pull
    pulley
    pullout
    pullover
    pulmonary
    pulp
    pulpit
    pulsate
    pulsation
    pulse
    pulverization
    pulverize
    puma
    pumice
    pummel
    pump
    pumpernickel
    pumpkin
    pun
    punch
    punching bag
    punch line
    punctual
    punctuality
    punctuate
    punctuation
    punctuation mark
    puncture
    pundit
    pungent
    punish
    punishable
    punishing
    punishment
    punitive
    punk
    punk rock
    punt
    puny
    pup
    pupil
    puppet
    puppeteer
    puppy
    puppy love
    purchase
    purchaser
    pure
    puree
    purely
    purgatory
    purge
    purification
    purify
    purist
    Puritan
    puritan
    puritanical
    purity
    purple
    purport
    purpose
    purposeful
    purposely
    purr
    purse
    purser
    pursue
    pursuit
    purvey
    purveyor
    pus
    push
    push button
    pusher
    pushover
    push-up
    pushy
    pussy
    pussycat
    pussyfoot
    put
    put-down
    putrid
    putt
    putter
    putty
    puzzle
    puzzled
    pygmy
    pylon
    pyramid
    pyre
    Pyrex
    python


These are words from the 3esl.txt file from release 4.0 of 12dicts, released Jan. 18, 2003.


If something on our web site doesn't load properly, try clicking your "reload" button.
If it still doesn't work, please send a bug report.

This page is part of Interesting Things for ESL Students.

Copyright © 1997-2017 by Charles Kelly & Lawrence Kelly
ManyThings.org

    Reading
    Sentences
    More

English Vocabulary Word Lists with Games, Puzzles and Quizzes

English Vocabulary Word List
Alan Beale's Core Vocabulary - Q (92 Words)

    qt.
    Q-tip
    quack
    quad
    quadrangle
    quadrant
    quadrilateral
    quadruped
    quadruple
    quadruplet
    quagmire
    quail
    quaint
    quake
    qualification
    qualified
    qualifier
    qualify
    qualitative
    quality
    quality control
    qualm
    quandary

    quantifier
    quantify
    quantitative
    quantity
    quantum leap
    quarantine
    quark
    quarrel
    quarrelsome
    quarry
    quart
    quarter
    quarterback
    quarterfinal
    quarterly
    quarters
    quartet
    quartz
    quash
    quaver
    quay
    queasiness
    queasy

    queen
    queen-size
    queer
    quell
    quench
    query
    quest
    question
    questionable
    question mark
    questionnaire
    quibble
    quiche
    quick
    quicken
    quickie
    quickly
    quicksand
    quid pro quo
    quiet
    quietly
    quietness
    quill

    quilt
    quintessence
    quintessential
    quintet
    quintuplet
    quip
    quirk
    quirky
    quit
    quite
    quits
    quitter
    quiver
    quixotic
    quiz
    quizzical
    quorum
    quota
    quotable
    quotation
    quotation marks
    quote
    quotient
 ManyThings.org

    Reading
    Sentences
    More

English Vocabulary Word Lists with Games, Puzzles and Quizzes

English Vocabulary Word List
Alan Beale's Core Vocabulary - R (1187 Words)

    rabbi
    rabbit
    rabble
    rabid
    rabies
    raccoon
    race
    racetrack
    racial
    racially
    racing
    racism
    racist
    rack
    racket
    racketeer
    racy
    radar
    radial
    radiance
    radiant
    radiate
    radiation
    radiator
    radical
    radically
    radii
    radio
    radioactive
    radioactivity
    radiologist
    radiology
    radiotherapy
    radish
    radium
    radius
    radon
    raffle
    raft
    rafter
    rag
    ragamuffin
    rag doll
    rage
    ragged
    rags
    ragtag
    ragtime
    rah-rah
    raid
    raider
    rail
    railing
    railroad
    railroad crossing
    rain
    rainbow
    rain check
    raincoat
    raindrop
    rainfall
    rain forest
    rains
    rainstorm
    rainwater
    rainy
    raise
    raisin
    rake
    rally
    RAM
    ram
    Ramadan
    ramble
    rambling
    rambunctious
    ramification
    ramp
    rampage
    rampant
    ramrod
    ramshackle
    ran
    ranch
    rancher
    ranch house
    ranching
    rancid
    rancor
    rancorous
    random
    randomly
    rang
    range
    ranger
    rank
    rank and file
    ranking
    rankle
    ranks
    ransack
    ransom
    rant
    rap
    rape
    rapid
    rapidity
    rapidly
    rapids
    rapid transit
    rapist
    rapport
    rapprochement
    rapt
    rapture
    rapturous
    rare
    rarely
    raring
    rarity
    rascal
    rash
    rasp
    raspberry
    raspy
    rat
    rate
    rather
    ratification
    ratify
    rating
    ratio
    ration
    rational
    rationale
    rationalization
    rationalize
    rationally
    rationing
    rations
    rat race
    rattle
    rattler
    rattlesnake
    raucous
    raucously
    raunchy
    ravage
    rave
    raven
    ravenous
    rave review
    ravine
    raving
    ravishing
    raw
    ray
    rayon
    raze
    razor
    razor blade
    razz
    Rd.
    R & D
    re
    reach
    react
    reaction
    reactionary
    reactor
    read
    readable
    reader
    readership
    readily
    readiness
    reading
    readjust
    readjustment
    ready
    ready-made
    real
    real estate
    real estate agent
    realism
    realist
    realistic
    realistically
    reality
    reality check
    realization
    realize
    really
    realm
    real time
    real-time
    Realtor
    realty
    ream
    reap
    reappear
    reappearance
    rear
    rear end
    rear-end
    rearrange
    rearrangement
    rearview mirror
    reason
    reasonable
    reasonableness
    reasonably
    reasoning
    reassurance
    reassure
    reassuring
    reassuringly
    rebate
    rebel
    rebellion
    rebellious
    rebirth
    rebound
    rebuff
    rebuild
    rebuilt
    rebuke
    rebut
    rebuttal
    recalcitrance
    recalcitrant
    recall
    recant
    recap
    recapture
    recede
    receipt
    receive
    receiver
    receivership
    recent
    recently
    receptacle
    reception
    receptionist
    receptive
    recess
    recession
    recharge
    recipe
    recipient
    reciprocal
    reciprocate
    recital
    recitation
    recite
    reckless
    recklessly
    recklessness
    reckon
    reckoning
    reclaim
    reclamation
    recline
    reclining
    recluse
    recognition
    recognizable
    recognizably
    recognize
    recoil
    recollect
    recollection
    recommend
    recommendation
    recompense
    reconcile
    reconciliation
    recondition
    reconnaissance
    reconsider
    reconstitute
    reconstruct
    reconstruction
    record
    record-breaking
    recorder
    recording
    record player
    recount
    recoup
    recourse
    recover
    recovery
    recreate
    recreation
    recreational

    recruit
    recruiter
    recruitment
    rectal
    rectangle
    rectangular
    rectify
    rector
    rectum
    recuperate
    recuperation
    recur
    recurrence
    recurrent
    recyclable
    recycle
    recycled
    recycling
    red
    red-blooded
    red carpet
    Red Cross
    redden
    reddish
    redeem
    redeemable
    redemption
    redevelop
    redevelopment
    red-eye
    red-handed
    redhead
    red herring
    red-hot
    redid
    redirect
    redistribute
    redistribution
    red-light district
    redneck
    redness
    redo
    redone
    redouble
    redress
    redskin
    red tape
    reduce
    reduction
    redundancy
    redundant
    red wine
    redwood
    reed
    reeducate
    reeducation
    reef
    reek
    reel
    reelect
    reelection
    reenact
    reenactment
    reentry
    ref
    refer
    referee
    reference
    reference book
    referenda
    referendum
    refill
    refinance
    refine
    refined
    refinement
    refinery
    refinish
    reflect
    reflection
    reflective
    reflector
    reflex
    reflexes
    reflexive
    reform
    reformation
    reformer
    reform school
    refrain
    refresh
    refresher course
    refreshing
    refreshingly
    refreshment
    refreshments
    refrigerate
    refrigeration
    refrigerator
    refuel
    refuge
    refugee
    refund
    refundable
    refurbish
    refurbishment
    refusal
    refuse
    refute
    regain
    regal
    regalia
    regard
    regarding
    regardless
    regards
    regatta
    regenerate
    regeneration
    regent
    reggae
    regime
    regimen
    regiment
    regimental
    regimented
    region
    regional
    regionally
    register
    registered mail
    registered nurse
    registrar
    registration
    registry
    regress
    regression
    regret
    regretful
    regretfully
    regrettable
    regrettably
    regroup
    regular
    regularity
    regularly
    regulate
    regulation
    regurgitate
    regurgitation
    rehab
    rehabilitate
    rehabilitation
    rehash
    rehearsal
    rehearse
    reign
    reimburse
    reimbursement
    rein
    reincarnate
    reincarnation
    reindeer
    reinforce
    reinforcement
    reinforcements
    reinstate
    reinstatement
    reinvent
    reissue
    reiterate
    reiteration
    reject
    rejection
    rejoice
    rejoicing
    rejoin
    rejoinder
    rejuvenate
    rejuvenation
    rekindle
    relapse
    relate
    related
    relation
    relations
    relationship
    relative
    relatively
    relativity
    relax
    relaxation
    relaxed
    relaxing
    relay
    release
    relegate
    relent
    relentless
    relentlessly
    relevance
    relevant
    reliability
    reliable
    reliably
    reliance
    reliant
    relic
    relief
    relieve
    relieved
    religion
    religious
    religiously
    relinquish
    relish
    relive
    relocate
    relocation
    reluctance
    reluctant
    reluctantly
    rely
    remain
    remainder
    remaining
    remains
    remake
    remark
    remarkable
    remarkably
    remarriage
    remarry
    remedial
    remedy
    remember
    remembrance
    remind
    reminder
    reminisce
    reminiscence
    reminiscent
    remiss
    remission
    remit
    remittance
    remnant
    remodel
    remorse
    remorseful
    remorseless
    remote
    remote control
    remotely
    remoteness
    removable
    removal
    remove
    removed
    remover
    remunerate
    remuneration
    Renaissance
    rename
    rend
    render
    rendering
    rendezvous
    rendition
    renegade
    renege
    renew
    renewable
    renewal
    renounce
    renovate
    renovation
    renown
    renowned
    rent
    rental
    rent control
    renter
    renunciation
    reorganization
    reorganize
    rep
    Rep.
    repaid
    repair
    reparation
    repatriate
    repatriation
    repay
    repayment
    repeal
    repeat

    repeated
    repeatedly
    repel
    repellent
    repent
    repentance
    repentant
    repercussion
    repertoire
    repetition
    repetitious
    repetitive
    rephrase
    replace
    replaceable
    replacement
    replay
    replenish
    replenishment
    replete
    replica
    replicate
    replication
    reply
    report
    report card
    reportedly
    reporter
    repository
    repossess
    reprehensible
    represent
    representation
    Representative
    representative
    repress
    repressed
    repression
    repressive
    reprieve
    reprimand
    reprint
    reprisal
    reprise
    reproach
    reproduce
    reproduction
    reproductive
    reprove
    reptile
    reptilian
    republic
    Republican
    republican
    Republican Party
    repudiate
    repudiation
    repugnance
    repugnant
    repulse
    repulsion
    repulsive
    reputable
    reputation
    repute
    reputed
    reputedly
    request
    requiem
    require
    requirement
    requisite
    requisition
    rerun
    resale
    rescind
    rescue
    rescuer
    research
    researcher
    resemblance
    resemble
    resent
    resentful
    resentment
    reservation
    reserve
    reserved
    reserves
    reservoir
    reshuffle
    reside
    residence
    residency
    resident
    residential
    residual
    residue
    resign
    resignation
    resigned
    resilience
    resilient
    resin
    resist
    resistance
    resistant
    resolute
    resolutely
    resolution
    resolve
    resonance
    resonant
    resonate
    resort
    resound
    resounding
    resoundingly
    resource
    resourceful
    resourcefulness
    resources
    respect
    respectability
    respectable
    respectably
    respected
    respectful
    respectfully
    respective
    respectively
    respects
    respiration
    respirator
    respiratory
    respite
    resplendent
    respond
    response
    responsibility
    responsible
    responsibly
    responsive
    responsiveness
    rest
    restate
    restatement
    restaurant
    rest home
    restitution
    restive
    restless
    restlessly
    restoration
    restore
    restrain
    restrained
    restraint
    restrict
    restricted
    restriction
    restrictive
    rest room
    restructure
    restructuring
    result
    resultant
    resume
    resumption
    resurface
    resurgence
    resurgent
    resurrect
    Resurrection
    resurrection
    resuscitate
    resuscitation
    retail
    retailer
    retain
    retainer
    retake
    retaken
    retaliate
    retaliation
    retard
    retardation
    retarded
    retch
    retention
    rethink
    rethought
    reticence
    reticent
    retina
    retinue
    retire
    retired
    retiree
    retirement
    retiring
    retook
    retort
    retrace
    retract
    retractable
    retraction
    retread
    retreat
    retrial
    retribution
    retrieval
    retrieve
    retriever
    retroactive
    retroactively
    retrospective
    return
    returnable
    return address
    reunion
    reunite
    rev
    Rev.
    revaluation
    revalue
    revamp
    reveal
    revealing
    revel
    revelation
    reveler
    revelry
    revenge
    revenue
    reverberate
    reverberation
    revere
    reverence
    Reverend
    reverent
    reverently
    reverie
    reversal
    reverse
    reversible
    reversion
    revert
    review
    reviewer
    revile
    revise
    revision
    revitalization
    revitalize
    revival
    revive
    revoke
    revolt
    revolting
    revolution
    revolutionary
    Revolutionary War
    revolutionize
    revolve
    revolver
    revue
    revulsion
    reward
    rewarding
    rewind
    rework
    rewound
    rewrite
    rewritten
    rewrote
    rhapsody
    rhetoric
    rhetorical
    rhetorically
    rhetorical question
    rheumatism
    rhinestone
    rhino
    rhinoceros
    rhododendron
    rhubarb
    rhyme
    rhythm
    rhythm and blues
    rhythmic
    rhythmically
    rib
    ribald
    ribbon
    rib cage
    rice

    rich
    riches
    richly
    richness
    rickety
    rickshaw
    ricochet
    rid
    riddance
    ridden
    riddle
    riddled
    ride
    rider
    ridge
    ridicule
    ridiculous
    ridiculously
    riding
    rife
    rifle
    rift
    rig
    rigging
    right
    right angle
    righteous
    righteously
    righteousness
    rightful
    rightfully
    right-hand
    right-handed
    right-hand man
    rightly
    right of way
    rights
    right wing
    right-wing
    rigid
    rigidity
    rigidly
    rigmarole
    rigor
    rigor mortis
    rigorous
    rigorously
    rile
    rim
    rind
    ring
    ringed
    ringleader
    ringlet
    ringside
    ringworm
    rink
    rinky-dink
    rinse
    riot
    rioter
    rioting
    riotous
    RIP
    rip
    rip cord
    ripe
    ripen
    rip-off
    ripple
    rip-roaring
    rise
    risen
    riser
    risk
    risky
    risque
    rite
    ritual
    ritually
    ritzy
    rival
    rivalry
    river
    riverbed
    riverfront
    riverside
    rivet
    riveting
    RN
    roach
    road
    roadblock
    roadhouse
    roadkill
    roadrunner
    roadside
    road test
    roadway
    roadworthy
    roam
    roar
    roaring
    roast
    rob
    robber
    robbery
    robe
    robin
    robot
    robotics
    robust
    rock
    rock and roll
    rock bottom
    rocker
    rocket
    rocking chair
    rocking horse
    rock music
    rocky
    rod
    rode
    rodent
    rodeo
    roe
    rogue
    role
    role model
    role-play
    role-playing
    roll
    roll call
    roller
    Rollerblade
    roller coaster
    roller skate
    roller-skate
    rollerskating
    rollicking
    rolling pin
    roly-poly
    ROM
    Roman
    Roman alphabet
    Roman Catholic
    Roman Catholicism
    romance
    Roman numeral
    romantic
    romantically
    romanticize
    romp
    roof
    roofing
    rooftop
    rook
    rookie
    room
    room and board
    roomful
    roommate
    room service
    roomy
    roost
    rooster
    root
    root beer
    rootless
    roots
    rope
    rosary
    rose
    Rosh Hashanah
    roster
    rostrum
    rosy
    rot
    rotary
    rotate
    rotation
    ROTC
    rote
    rotisserie
    rotor
    rotten
    rotund
    rotunda
    rouge
    rough
    roughage
    rough-and-tumble
    roughhouse
    roughly
    roughness
    roughshod
    roulette
    round
    roundabout
    round-the-clock
    round trip
    round-trip
    roundup
    rouse
    rousing
    rout
    route
    routine
    routinely
    roving
    row
    rowboat
    rowdiness
    rowdy
    rowing
    royal
    royal blue
    royalties
    royalty
    R & R
    RSVP
    Rte.
    rub
    rubber
    rubber band
    rubberneck
    rubber stamp
    rubber-stamp
    rubbery
    rubbish
    rubble
    rubdown
    rubella
    ruby
    ruckus
    rudder
    ruddy
    rude
    rudely
    rudeness
    rudimentary
    rudiments
    rue
    rueful
    ruffle
    rug
    rugby
    rugged
    ruin
    ruinous
    rule
    ruler
    ruling
    rum
    rumble
    ruminate
    rummage
    rummage sale
    rummy
    rumor
    rumored
    rump
    rumple
    run
    runaround
    runaway
    rundown
    run-down
    rung
    run-in
    runner
    runners-up
    runner-up
    running
    running mate
    runny
    run-of-the-mill
    runway
    rupture
    rural
    ruse
    rush
    rush hour
    Russian
    rust
    rustic
    rustle
    rustler
    rustproof
    rusty
    rut
    ruthless
    ruthlessly
    ruthlessness
    RV
    rye
 ManyThings.org

    Reading
    Sentences
    More

English Vocabulary Word Lists with Games, Puzzles and Quizzes

English Vocabulary Word List
Alan Beale's Core Vocabulary - S (2529 Words)

    Sabbath
    sabbatical
    saber
    sabotage
    saboteur
    saccharin
    sack
    sacrament
    sacred
    sacrifice
    sacrificial
    sacrilege
    sacrilegious
    sacrosanct
    sad
    sadden
    saddle
    sadism
    sadist
    sadistic
    sadistically
    sadly
    sadness
    safari
    safe
    safe-deposit box
    safeguard
    safekeeping
    safely
    safe sex
    safety
    safety net
    safety pin
    sag
    saga
    sage
    sagebrush
    Sagittarius
    said
    sail
    sailboard
    sailboat
    sailing
    sailor
    saint
    sake
    salable
    salad
    salad bar
    salad dressing
    salami
    salaried
    salary
    sale
    sales
    salesclerk
    salesman
    salesperson
    sales representative
    sales slip
    sales tax
    saleswoman
    salient
    saliva
    salivate
    sallow
    salmon
    salmonella
    salon
    saloon
    salsa
    salt
    saltwater
    salty
    salutation
    salute
    salvage
    salvation
    Salvation Army
    salve
    same
    sameness
    sample
    sanatorium
    sanctify
    sanctimonious
    sanction
    sanctions
    sanctity
    sanctuary
    sand
    sandal
    sandbag
    sandblast
    sandcastle
    sand dune
    sandman
    sandpaper
    sandstone
    sandwich
    sandy
    sane
    sang
    sanitary
    sanitary napkin
    sanitation
    sanitize
    sanity
    sank
    Santa
    Santa Claus
    sap
    sapling
    sapphire
    sarcasm
    sarcastic
    sarcastically
    sardine
    sardonic
    SASE
    sash
    sass
    sassy
    SAT
    sat
    Sat.
    Satan
    satanic
    satanism
    satellite
    satellite television
    satin
    satiny
    satire
    satirical
    satirically
    satirist
    satirize
    satisfaction
    satisfactorily
    satisfactory
    satisfied
    satisfy
    satisfying
    saturate
    saturation
    Saturday
    Saturn
    sauce
    saucepan
    saucer
    saucy
    sauna
    saunter
    sausage
    saute
    sauteed
    savage
    savagely
    savagery
    save
    saver
    saving
    savings
    savings account
    savings and loan
    savings bank
    Savior
    savior
    savor
    savory
    savvy
    saw
    sawdust
    sawn
    sax
    saxophone
    say
    saying
    scab
    scads
    scaffold
    scaffolding
    scald
    scalding
    scale
    scallop
    scalloped
    scalp
    scalpel
    scalper
    scaly
    scam
    scamper
    scan
    scandal
    scandalize
    scandalous
    Scandinavia
    Scandinavian
    scanner
    scant
    scapegoat
    scar
    scarce
    scarcely
    scarcity
    scare
    scarecrow
    scared
    scarf
    scarlet
    scarves
    scary
    scathing
    scatter
    scatterbrained
    scattered
    scavenge
    scavenger
    scavenger hunt
    scenario
    scene
    scenery
    scenic
    scent
    scented
    schedule
    scheme
    schemer
    schism
    schizophrenia
    schizophrenic
    schlep
    schlock
    schlocky
    schmaltz
    schmaltzy
    schmooze
    schmuck
    scholar
    scholarship
    scholastic
    school
    school board
    schoolboy
    schoolchild
    schoolchildren
    school district
    schoolgirl
    schooling
    schoolteacher
    science
    science fiction
    scientific
    scientifically
    scientist
    sci-fi
    scintillating
    scissors
    scoff
    scold
    scolding
    scoop
    scoot
    scooter
    scope
    scorch
    scorching
    score
    scoreboard
    scorecard
    scores
    scorn
    scornful
    scornfully
    Scorpio
    scorpion
    Scotch
    scotch
    Scotch tape
    Scottish
    scoundrel
    scour
    scourge
    scout
    scowl
    scrabble
    scraggly
    scram
    scramble
    scrambled eggs
    scrap
    scrapbook
    scrape
    scrappy
    scraps
    scratch
    scratch paper
    scratchy
    scrawl
    scrawny
    scream
    screech
    screen
    screenplay
    screw
    screwball
    screwdriver
    screwed up
    screwy
    scribble
    scribe
    scrimp
    script
    Scripture
    scroll
    scrooge
    scrounge
    scrub
    scruffy
    scruples
    scrupulous
    scrupulously
    scrutinize
    scrutiny
    scuba diving
    scuff
    scuffle
    sculptor
    sculpture
    scum
    scurrilous
    scurry
    scuttle
    SE
    sea
    seafood
    sea gull
    seal
    sealed
    sea level
    sea lion
    seam
    seamless
    sear
    search
    searching
    searchlight
    search party
    search warrant
    seashell
    seashore
    seasick
    seasickness
    seaside
    season
    seasonable
    seasonal
    seasoned
    seasoning
    season ticket
    seat
    seat belt
    seating
    seaweed
    sec
    Sec.
    secede
    secession
    secluded
    seclusion
    second
    secondary
    secondary school
    second class
    second-class
    second-guess
    secondhand
    secondhand smoke
    secondly
    second nature
    second-rate
    seconds
    secrecy
    secret
    secret agent
    secretarial
    Secretary
    secretary
    Secretary of State
    secrete
    secretion
    secretive
    secretively
    secretly
    sect
    section
    sector
    secular
    secure
    securely
    security
    security deposit
    sedan
    sedate
    sedated
    sedation
    sedative
    sedentary
    sediment
    seduce
    seduction
    seductive
    see
    seed
    seedless
    seedling
    seedy
    Seeing Eye dog
    seek
    seem
    seeming
    seemingly
    seen
    seep
    seepage
    seesaw
    seethe
    seething
    segment
    segmented
    segregate
    segregation
    seize
    seizure
    seldom
    select
    selection
    selective
    selectively
    self
    self-absorbed
    self-appointed
    self-assurance
    self-assured
    self-centered
    self-confidence
    self-confident
    self-conscious
    self-consciously
    self-consciousness
    self-contained
    self-control
    self-defeating
    self-defense
    self-denial
    self-destructive
    self-discipline
    self-disciplined
    self-employed
    self-esteem
    self-evident
    self-explanatory
    self-fulfilling prophecy
    self-help
    self-important
    self-improvement
    self-indulgence
    self-indulgent
    self-inflicted
    self-interest
    selfish
    selfishly
    selfishness
    selfless
    self-made
    self-pity
    self-portrait
    self-possessed
    self-preservation
    self-reliance
    self-reliant
    self-respect
    self-respecting
    self-restraint
    self-righteous
    self-righteousness
    self-sacrifice
    self-sacrificing
    self-satisfied
    self-seeking
    self-service
    self-starter
    self-styled
    self-sufficiency
    self-sufficient
    self-supporting
    sell
    seller
    selling point
    sellout
    selves
    semantic
    semantics
    semblance
    semen
    semester
    semicircle
    semicolon
    semiconductor
    semifinal
    semifinalist
    seminal
    seminar
    seminary
    semiprecious
    Sen.
    Senate
    senate
    Senator
    senator
    senatorial
    send
    send-off
    senile
    senility
    Senior
    senior
    senior citizen
    senior high school
    seniority
    sensation
    sensational
    sensationalism
    sensationally
    sense
    senseless
    sensibility
    sensible
    sensibly
    sensitive
    sensitively
    sensitivity
    sensor
    sensory
    sensual
    sensuality
    sensuous
    sent
    sentence
    sentiment
    sentimental
    sentimentality
    sentry
    separable
    separate
    separated
    separately
    separation
    Sept.
    September
    sequel
    sequence
    sequential
    sequoia
    serenade
    serene
    serenely
    serenity
    sergeant
    serial
    serial killer
    serial number
    series
    serious
    seriously
    seriousness
    sermon
    serpent
    serrated
    serum
    servant
    serve
    server
    service
    serviceable
    service charge
    serviceman
    service station
    servicewoman
    servile
    serving
    servitude
    session
    set
    setback
    setting
    settle
    settled
    settlement
    settler
    setup
    seven
    seventeen
    seventeenth
    seventh
    seventieth
    seventy
    sever
    several
    severance
    severance pay
    severe
    severely
    severity
    sew
    sewage
    sewer
    sewing
    sewing machine
    sewn
    sex
    sexism
    sexist
    sexual
    sexual intercourse
    sexuality
    sexually
    sexy
    Sgt.
    sh

    shabbily
    shabby
    shack
    shackle
    shade
    shades
    shading
    shadow
    shadowy
    shady
    shaft
    shaggy
    shake
    shakedown
    shaken
    shakeup
    shakily
    shaky
    shall
    shallow
    shallowness
    sham
    shambles
    shame
    shameful
    shamefully
    shameless
    shamelessly
    shampoo
    shamrock
    shanty
    shantytown
    shape
    shapely
    share
    shareholder
    shark
    sharp
    sharpen
    sharpener
    sharply
    sharpness
    shatter
    shave
    shaver
    shawl
    she
    sheaf
    shear
    shears
    sheath
    sheathe
    sheaves
    shed
    she'd
    sheen
    sheep
    sheepish
    sheepishly
    sheer
    sheet
    sheik
    shelf
    shell
    she'll
    shellfish
    shelter
    sheltered
    shelve
    shelves
    shelving
    shenanigans
    shepherd
    sherbet
    sheriff
    sherry
    she's
    shield
    shift
    shift key
    shiftless
    shifty
    shimmer
    shin
    shine
    shingle
    shinny
    shiny
    ship
    shipload
    shipment
    shipping
    shipwreck
    shipyard
    shirk
    shirt
    shirtsleeve
    shit
    shitty
    shiver
    shoal
    shock
    shocked
    shocking
    shock wave
    shod
    shoddily
    shoddy
    shoe
    shoelace
    shoestring
    shone
    shoo
    shoo-in
    shook
    shook-up
    shoot
    shooting
    shooting star
    shop
    shopkeeper
    shoplift
    shoplifter
    shoplifting
    shopper
    shopping
    shopping bag
    shopping cart
    shopping center
    shopping mall
    shore
    shorn
    short
    shortage
    shortchange
    short circuit
    short-circuit
    shortcoming
    shortcut
    shorten
    shortening
    shortfall
    shorthand
    short-lived
    shortly
    shortness
    shorts
    shortsighted
    short story
    short-term
    shortwave
    shot
    shotgun
    shotgun wedding
    shot put
    should
    shoulder
    shoulder bag
    shoulder blade
    shouldn't
    shout
    shove
    shovel
    show
    show-and-tell
    showbiz
    show business
    showcase
    showdown
    shower
    showing
    showman
    showmanship
    shown
    show-off
    showpiece
    showroom
    showy
    shrank
    shrapnel
    shred
    shrewd
    shrewdly
    shriek
    shrill
    shrimp
    shrine
    shrink
    shrinkage
    shrink-wrap
    shrivel
    shriveled
    shroud
    shrub
    shrubbery
    shrug
    shrunk
    shrunken
    shuck
    shucks
    shudder
    shuffle
    shun
    shunt
    shush
    shut
    shutdown
    shuteye
    shut-in
    shutter
    shuttle
    shy
    shyly
    shyness
    shyster
    sibling
    sic
    sick
    sicken
    sickening
    sickle
    sick leave
    sickly
    sickness
    sick pay
    side
    sideburns
    side dish
    side effect
    sidekick
    sideline
    sidelines
    sidelong
    side order
    sideshow
    sidestep
    side street
    sidetrack
    sidewalk
    sideways
    siding
    sidle
    siege
    siesta
    sieve
    sift
    sigh
    sight
    sighted
    sighting
    sightless
    sightread
    sights
    sightseeing
    sightseer
    sign
    signal
    signatory
    signature
    significance
    significant
    significantly
    signify
    signing
    sign language
    signpost
    Sikh
    Sikhism
    silence
    silencer
    silent
    silently
    silent partner
    silhouette
    silicon
    silk
    silken
    silky
    sill
    silliness
    silly
    silo
    silt
    silver
    silver anniversary
    silver medal
    silver medalist
    silver plate
    silver-plated
    silversmith
    silverware
    similar
    similarity
    similarly
    simile
    simmer
    simper
    simple
    simple interest
    simple-minded
    simplicity
    simplification
    simplify
    simplistic
    simply
    simulate
    simulation
    simulator
    simultaneous
    simultaneously
    sin
    since
    sincere
    sincerely
    sincerity
    sinew
    sinewy
    sinful
    sing
    singe
    singer
    singing
    single
    single-digit
    single-family
    single file
    single-handedly
    single-minded
    single parent
    singles
    single-sex
    singly
    singsong
    singular
    singularly
    sinister
    sink
    sinner
    sinus
    sip
    siphon
    sir
    sire
    siren
    sirloin
    sissy
    Sister
    sister
    sister city
    sisterhood
    sister-in-law
    sisterly
    sisters-in-law
    sit
    sitcom
    sit-down
    site
    sit-in
    sitter
    sitting
    situated
    situation
    situation comedy
    sit-up
    six
    six-pack
    sixteen
    sixteenth
    sixth
    sixth sense
    sixtieth
    sixty
    sizable
    size
    sizzle
    skate
    skateboard
    skateboarder
    skateboarding
    skater
    skeleton
    skeptic
    skeptical
    skeptically
    skepticism
    sketch
    sketchy
    skew
    skewed
    skewer
    ski
    skid
    skier
    skiing
    skill
    skilled
    skillet
    skillful
    skillfully
    skim
    skim milk
    skimp
    skimpy
    skin
    skin-deep
    skinflint
    skinhead
    skinny
    skinny-dipping
    skintight
    skip
    skipper
    skirmish
    skirt
    skit
    skittish
    skull
    skullcap
    skunk
    sky
    skydiver
    skydiving
    sky-high
    skylight
    skyline
    skyrocket
    skyscraper
    slab
    slack
    slacken
    slacker
    slacks
    slain
    slake
    slalom
    slam
    slam-dunk
    slander
    slang
    slant
    slap
    slapdash
    slapstick
    slash
    slat
    slate
    slather
    slaughter
    slaughterhouse
    slave
    slave driver
    slavery
    slavish
    slay
    slaying
    sleazy
    sled
    sledgehammer
    sleek
    sleep
    sleeper
    sleepily
    sleeping bag
    sleeping pill
    sleepless
    sleeplessness
    sleepwalk
    sleepy
    sleepyhead
    sleet
    sleeve
    sleeveless
    sleigh
    sleight of hand
    slender
    slept
    sleuth
    slew
    slice
    slick
    slid
    slide
    sliding scale
    slight
    slightly
    slim
    slime
    slimy
    sling
    slingshot
    slink
    slip
    slipped disk
    slipper
    slippery
    slipshod
    slip-up
    slit
    slither
    sliver
    slob
    slobber
    slog
    slogan
    slop
    slope
    sloppily
    sloppy
    slosh
    sloshed
    slot
    sloth
    slothful
    slot machine
    slouch
    slovenly
    slow
    slowdown
    slowly
    slow motion
    slowness
    slowpoke
    slow-witted
    sludge
    slug
    sluggish
    sluice
    slum
    slumber
    slumber party
    slump
    slung
    slunk
    slur
    slurp
    slush
    slush fund
    slushy
    slut
    sly
    slyly
    smack
    smack-dab
    small
    small change
    small-claims court
    small fry
    small-minded
    small potatoes
    smallpox
    small-scale
    small talk
    small-time
    smart
    smart aleck
    smarts
    smarty-pants
    smash
    smashed
    smash hit
    smattering
    smear
    smell
    smelly
    smidgen
    smile
    smirk
    smith
    smithereens
    smitten
    smock
    smog
    smoggy
    smoke
    smoked
    smoke-free
    smoker
    smoke screen
    smokestack
    smoking
    smoking gun
    smoky
    smolder
    smooch
    smooth
    smoothly
    smoothness
    smorgasbord
    smother
    smudge
    smug
    smuggle
    smuggler
    smuggling
    smugly
    smugness
    smut
    smutty
    snack
    snack bar
    snafu
    snag
    snail
    snail mail
    snake
    snap
    snappy
    snapshot
    snare
    snarl
    snatch
    snazzy
    sneak
    sneaker
    sneaking
    sneaky
    sneer
    sneeze
    snicker
    snide
    sniff
    sniffle
    sniffles
    snip
    snipe
    sniper
    snit
    snitch
    snob
    snobbery
    snobbish
    snobby

    snoop
    snooty
    snooze
    snore
    snorkel
    snorkeling
    snort
    snot
    snotty
    snout
    snow
    snowball
    snowboard
    snowboarding
    snowbound
    snowdrift
    snowfall
    snowflake
    snow job
    snowman
    snowmobile
    snowplow
    snowstorm
    snowy
    snub
    snuck
    snuff
    snug
    snuggle
    snugly
    so
    soak
    soaked
    soaking
    soaking wet
    so-and-so
    soap
    soap opera
    soapy
    soar
    soaring
    sob
    S.O.B.
    sober
    sobering
    sobriety
    sob story
    so-called
    soccer
    sociable
    social
    social climber
    socialism
    socialist
    socialite
    socialize
    socially
    social science
    Social Security
    Social Security number
    social studies
    social work
    social worker
    society
    socioeconomic
    sociological
    sociologist
    sociology
    sociopath
    sock
    socket
    sod
    soda
    soda pop
    soda water
    sodden
    sodium
    sofa
    soft
    softball
    soft-boiled
    soft drink
    soften
    softhearted
    softly
    softness
    soft-pedal
    soft sell
    soft-spoken
    soft touch
    software
    softy
    soggy
    soil
    soiled
    sojourn
    solace
    solar
    solar system
    sold
    solder
    soldier
    sold-out
    sole
    solely
    solemn
    solemnity
    solemnly
    solicit
    solicitor
    solicitous
    solid
    solidarity
    solidify
    solidity
    solidly
    soliloquy
    solitaire
    solitary
    solitary confinement
    solitude
    solo
    soloist
    soluble
    solution
    solvable
    solve
    solvent
    somber
    somberly
    some
    somebody
    someday
    somehow
    someone
    someplace
    somersault
    something
    sometime
    sometimes
    someway
    somewhat
    somewhere
    son
    sonata
    song
    songwriter
    sonic
    sonic boom
    son-in-law
    sonnet
    sons-in-law
    soon
    soot
    soothe
    soothing
    soothingly
    sophisticated
    sophistication
    sophomore
    sophomoric
    soporific
    sopping
    soprano
    sorbet
    sorcerer
    sorceress
    sorcery
    sordid
    sore
    sorely
    soreness
    sorority
    sorrow
    sorrowful
    sorrowfully
    sorry
    sort
    SOS
    so-so
    so that
    souffle
    sought
    sought-after
    soul
    soulful
    soul-searching
    sound
    sound barrier
    sound bite
    sound effects
    sounding board
    soundly
    soundness
    soundproof
    soundtrack
    soup
    soup kitchen
    sour
    source
    sour cream
    sourdough
    sourly
    sourness
    south
    South America
    South American
    southbound
    southeast
    southeasterly
    southeastern
    southeastward
    southerly
    southern
    southerner
    South Pole
    southwest
    southwesterly
    southwestern
    southwestward
    souvenir
    sovereign
    sovereignty
    Soviet
    Soviet Union
    sow
    sown
    soybean
    soy sauce
    spa
    space
    space cadet
    spacecraft
    spaced out
    spaceship
    space shuttle
    spacey
    spacing
    spacious
    spaciousness
    spade
    spades
    spaghetti
    span
    spangle
    spaniel
    Spanish
    spank
    spanking
    spar
    spare
    spare part
    sparingly
    spark
    sparkle
    sparkler
    sparkling
    spark plug
    sparrow
    sparse
    sparsely
    sparseness
    Spartan
    spasm
    spasmodic
    spastic
    spat
    spate
    spatial
    spatter
    spatula
    spawn
    speak
    speaker
    spear
    spearhead
    spearmint
    special
    special effects
    specialist
    specialization
    specialize
    specialized
    specially
    specialty
    species
    specific
    specifically
    specification
    specifics
    specify
    specimen
    specious
    speck
    speckled
    spectacle
    spectacles
    spectacular
    spectacularly
    spectator
    specter
    spectra
    spectrum
    speculate
    speculation
    speculative
    speculator
    sped
    speech
    speechless
    speed
    speedboat
    speedily
    speeding
    speed limit
    speedometer
    speedway
    speedy
    spell
    spellbound
    spelling
    spelling bee
    spelt
    spend
    spending
    spendthrift
    spent
    sperm
    spew
    sphere
    spherical
    sphinx
    spice
    spick-and-span
    spicy
    spider
    spider web
    spiel
    spiffy
    spike
    spill
    spin
    spinach
    spinal
    spinal cord
    spindly
    spin doctor
    spine
    spineless
    spin-off
    spinster
    spiral
    spire
    spirit
    spirited
    spirits
    spiritual
    spiritually
    spit
    spite
    spiteful
    splash
    splashy
    splat
    splatter
    splay
    splendid
    splendidly
    splendor
    splint
    splinter
    split
    split second
    splitting
    splurge
    spoil
    spoiled
    spoils
    spoilsport
    spoke
    spoken
    spokesman
    spokesperson
    spokeswoman
    sponge
    sponge cake
    sponsor
    sponsorship
    spontaneity
    spontaneous
    spontaneously
    spoof
    spook
    spooky
    spool
    spoon
    spoon-feed
    spoonful
    sporadic
    sporadically
    sport
    sporting
    sports
    sports car
    sportscast
    sportsman
    sportsmanship
    sportswear
    sporty
    spot
    spot check
    spotless
    spotlight
    spotty
    spouse
    spout
    sprain
    sprang
    sprawl
    sprawled
    sprawling
    spray
    spread
    spreadsheet
    spree
    sprig
    spring
    springboard
    spring break
    spring chicken
    spring fever
    springtime
    springy
    sprinkle
    sprinkler
    sprint
    sprinter
    sprout
    spruce
    sprung
    spry
    spud
    spun
    spunky
    spur
    spurious
    spurn
    spurt
    sputter
    spy
    Sq.
    sq.
    squabble
    squad
    squad car
    squadron
    squalid
    squall
    squalor
    squander
    square
    square dance
    squarely
    square root
    squash
    squat
    squatter
    squawk
    squeak
    squeaky
    squeal
    squeamish
    squeeze
    squelch
    squid
    squint
    squire
    squirm
    squirrel
    squirt
    Sr.
    St.
    stab
    stabbing
    stability
    stabilize
    stable
    stack
    stacks
    stadia
    stadium
    staff
    staffer
    staffing
    stag
    stage
    stagecoach
    stage fright
    stagger
    staggering
    staggeringly
    staging
    stagnant
    stagnate
    stagnation
    staid
    stain
    stained glass
    stainless steel
    stair
    staircase
    stairs
    stairway
    stake
    stakeout
    stakes
    stale
    stalemate
    stalk
    stalker
    stalking
    stall
    stallion
    stalwart
    stamina
    stammer
    stamp
    stampede
    stance
    stanch
    stand
    stand-alone
    standard
    standardization
    standardize
    standard of living
    standby
    stand-in
    standing
    standoff
    standout
    standpoint
    stands
    standstill
    stank
    staple
    stapler
    star
    starboard
    starch
    starchy
    stardom
    stare
    starfish
    stark
    starry-eyed
    Stars and Stripes
    Star-Spangled Banner
    start
    starter
    startle
    startled
    startling
    start-up
    starvation
    starve
    starving
    stash
    stat
    state
    State Department
    stately
    statement
    state-of-the-art
    statesman
    statesmanlike
    statesmanship
    statewide
    static
    station
    stationary
    stationery
    station wagon
    statistic
    statistical
    statistically
    statistician
    statistics
    statue
    stature
    status
    status quo
    status symbol
    statute
    statutory
    statutory rape
    staunch
    stave
    stay
    steadfast
    steady
    steak
    steal
    stealth
    stealthily
    stealthy
    steam
    steamboat
    steamroll
    steamroller
    steamy
    steel
    steel wool
    steep
    steeple
    steeply
    steepness
    steer
    steering
    steering wheel
    stellar
    stem
    stench
    stencil
    stenographer
    stenography
    step
    stepbrother
    step-by-step
    stepchild
    stepchildren
    stepdaughter

    stepfather
    stepladder
    stepmother
    stepping-stone
    stepsister
    stepson
    stereo
    stereotype
    stereotypical
    sterile
    sterility
    sterilization
    sterilize
    sterling
    stern
    sternly
    steroid
    stethoscope
    stew
    steward
    stewardess
    stick
    sticker
    stick-in-the-mud
    stickler
    sticks
    stick shift
    sticky
    stiff
    stiffen
    stiffly
    stiffness
    stifle
    stifling
    stigma
    stigmatize
    still
    stillbirth
    stillborn
    still life
    stillness
    stilt
    stilted
    stilts
    stimulant
    stimulate
    stimulating
    stimulation
    stimuli
    stimulus
    sting
    stinginess
    stingy
    stink
    stinker
    stinking
    stint
    stipend
    stipulate
    stipulation
    stir
    stir-fry
    stirrup
    stitch
    stitching
    stock
    stockade
    stockbroker
    stock certificate
    stock exchange
    stockholder
    stocking
    stocking cap
    stock market
    stockpile
    stocky
    stockyard
    stodgy
    stoic
    stoical
    stoicism
    stoke
    stole
    stolen
    stolid
    stolidly
    stomach
    stomachache
    stomp
    stone
    stoned
    stonewall
    stony
    stood
    stool
    stoop
    stop
    stopgap
    stoplight
    stopover
    stoppage
    stopper
    stopwatch
    storage
    store
    storehouse
    storekeeper
    storeroom
    storey
    stork
    storm
    stormy
    story
    storyteller
    stout
    stove
    stow
    stowaway
    straddle
    straggle
    straight
    straighten
    straightforward
    strain
    strained
    strainer
    strait
    straitjacket
    strand
    stranded
    strange
    strangely
    strangeness
    stranger
    strangle
    stranglehold
    strangulation
    strap
    strapless
    strapped
    strata
    strategic
    strategically
    strategy
    stratify
    stratosphere
    stratum
    straw
    strawberry
    stray
    streak
    streaky
    stream
    streamer
    streamline
    streamlined
    street
    streetcar
    streetlight
    strength
    strengthen
    strenuous
    strenuously
    strep throat
    stress
    stressed
    stressed out
    stressful
    stretch
    stretcher
    strew
    strewn
    stricken
    strict
    strictly
    stridden
    stride
    strident
    strife
    strike
    striker
    striking
    strikingly
    string
    string bean
    stringent
    strings
    strip
    stripe
    striped
    stripper
    striptease
    strive
    striven
    strode
    stroke
    stroll
    stroller
    strong
    stronghold
    strongly
    strove
    struck
    structural
    structure
    struggle
    strum
    strung
    strung out
    strut
    stub
    stubble
    stubborn
    stubbornly
    stubbornness
    stuck
    stuck-up
    stud
    studded
    student
    student body
    studied
    studies
    studio
    studio apartment
    studious
    study
    study hall
    stuff
    stuffed animal
    stuffing
    stuffy
    stumble
    stumbling block
    stump
    stun
    stung
    stunk
    stunned
    stunning
    stunt
    stunt man
    stunt woman
    stupefied
    stupefy
    stupendous
    stupid
    stupidity
    stupidly
    stupor
    sturdiness
    sturdy
    stutter
    style
    stylish
    stymie
    Styrofoam
    suave
    sub
    subcommittee
    subconscious
    subconsciously
    subculture
    subdivide
    subdivision
    subdue
    subdued
    subject
    subjective
    subjectively
    subjugate
    subjunctive
    sublet
    sublime
    subliminal
    submarine
    submarine sandwich
    submerge
    submerged
    submersion
    submission
    submissive
    submit
    subordinate
    subordination
    subpoena
    subscribe
    subscriber
    subscription
    subsequent
    subsequently
    subservience
    subservient
    subside
    subsidiary
    subsidize
    subsidized
    subsidy
    subsist
    subsistence
    substance
    substance abuse
    substandard
    substantial
    substantially
    substantiate
    substitute
    substitution
    subterfuge
    subterranean
    subtitles
    subtle
    subtlety
    subtly
    subtract
    subtraction
    suburb
    suburban
    suburbia
    subversive
    subvert
    subway
    succeed
    success
    successful
    successfully
    succession
    successive
    successively
    successor
    succinct
    succinctly
    succor
    succulent
    succumb
    such
    such and such
    suck
    sucker
    suction
    sudden
    suddenly
    suddenness
    suds
    sue
    suede
    suffer
    sufferer
    suffering
    suffice
    sufficiency
    sufficient
    sufficiently
    suffix
    suffocate
    suffocating
    suffocation
    sugar
    sugary
    suggest
    suggestible
    suggestion
    suggestive
    suggestively
    suicidal
    suicide
    suit
    suitability
    suitable
    suitably
    suitcase
    suite
    suitor
    sulfur
    sulk
    sulky
    sullen
    sullenly
    sultan
    sultry
    sum
    summarize
    summary
    summer
    summer school
    summertime
    summery
    summit
    summon
    summons
    sumptuous
    sun
    Sun.
    sunbathe
    sunbathing
    sunblock
    sunburn
    sunburned
    sunburnt
    sundae
    Sunday
    Sunday school
    sundown
    sundry
    sunflower
    sung
    sunglasses
    sunk
    sunken
    sunlight
    sunlit
    sunny
    sunny-side up
    sunrise
    sunscreen
    sunset
    sunshine
    suntan
    sunup
    super
    superb
    superbly
    Super Bowl
    superficial
    superficially
    superfluous
    superhighway
    superhuman
    superintendent
    superior
    superiority
    superlative
    supermarket
    supernatural
    superpower
    supersede
    supersonic
    superstar
    superstition
    superstitious
    superstructure
    supervise
    supervision
    supervisor
    supervisory
    supper
    supplant
    supple
    supplement
    supplemental
    supplementary
    supplier
    supplies
    supply
    supply and demand
    support
    supporter
    supportive
    suppose
    supposed
    supposedly
    supposing
    supposition
    suppress
    suppression
    supremacy
    supreme
    Supreme Court
    supremely
    surcharge
    sure
    surefire
    surely
    surf
    surface
    surfboard
    surfer
    surfing
    surge
    surgeon
    surgery
    surgical
    surgically
    surly
    surmise
    surmount
    surpass
    surplus
    surprise
    surprised
    surprising
    surprisingly
    surreal
    surrealistic
    surrender
    surreptitious
    surrogate
    surround
    surrounding
    surroundings
    surveillance
    survey
    survival
    survive
    survivor
    susceptible
    suspect
    suspend
    suspenders
    suspense
    suspension
    suspicion
    suspicious
    suspiciously
    sustain
    sustained
    SW
    swab
    swagger
    swallow
    swam
    swamp
    swan
    swank
    swap
    swarm
    swarthy
    swat
    swatch
    sway
    swear
    swear word
    sweat
    sweater
    sweatpants
    sweats
    sweatshirt
    sweatshop
    sweat suit
    sweaty
    sweep
    sweeper
    sweeping
    sweepstakes
    sweet
    sweeten
    sweetener
    sweetheart
    sweetie
    sweetly
    sweetness
    sweet potato
    sweets
    swell
    swelling
    sweltering
    swept
    swerve
    swift
    swiftly
    swim
    swimmer
    swimming
    swimming pool
    swimming trunks
    swimsuit
    swindle
    swindler
    swine
    swing
    swinging
    swipe
    swirl
    swish
    Swiss
    switch
    switchboard
    swivel
    swollen
    swoon
    swoop
    sword
    swordfish
    swore
    sworn
    swum
    swung
    sycamore
    sycophant
    syllabi
    syllable
    syllabus
    symbol
    symbolic
    symbolically
    symbolism
    symbolize
    symmetrical
    symmetrically
    symmetry
    sympathetic
    sympathetically
    sympathies
    sympathize
    sympathizer
    sympathy
    symphony
    symptom
    synagogue
    sync
    synchronize
    syndicate
    syndicated
    syndication
    syndrome
    synod
    synonym
    synonymous
    synopses
    synopsis
    syntax
    syntheses
    synthesis
    synthesize
    synthesizer
    synthetic
    synthetically
    syphilis
    syringe
    syrup
    system
    systematic
    systematically
 ManyThings.org

    Reading
    Sentences
    More

English Vocabulary Word Lists with Games, Puzzles and Quizzes

English Vocabulary Word List
Alan Beale's Core Vocabulary - T (1096 Words)

    T.
    t.
    TA
    tab
    tabby
    tabernacle
    table
    tablecloth
    tablespoon
    tablespoonful
    tablet
    table tennis
    tabloid
    taboo
    tabulate
    tabulation
    tacit
    tacitly
    taciturn
    tack
    tackiness
    tackle
    tacky
    taco
    tact
    tactful
    tactfully
    tactic
    tactical
    tactically
    tactics
    tad
    tadpole
    taffy
    tag
    tail
    tailgate
    taillight
    tailor
    tailoring
    tailor-made
    tailpipe
    tails
    tailspin
    taint
    tainted
    Taiwanese
    take
    taken
    takeoff
    takeout
    takeover
    taking
    tale
    talent
    talented
    talisman
    talk
    talkative
    talker
    talks
    talk show
    tall
    tallow
    tally
    Talmud
    talon
    tambourine
    tame
    tamper
    tampon
    tan
    tandem
    tangent
    tangential
    tangerine
    tangible
    tangle
    tangled
    tango
    tangy
    tank
    tankard
    tanker
    tanned
    tantalize
    tantalizing
    tantalizingly
    tantamount
    tantrum
    tap
    tap dance
    tap-dance
    tape
    tape deck
    tape measure
    tape player
    taper
    tape-record
    tape recorder
    tapered
    tapestry
    tapeworm
    taps
    tap water
    tar
    tarantula
    tardiness
    tardy
    target
    tariff
    tarmac
    tarnish
    tarot
    tarp
    tarpaulin
    tarry
    tart
    tartan
    tartar
    tartar sauce
    task
    task force
    tassel
    taste
    tasteful
    tastefully
    tasteless
    taster
    tasty
    tattered
    tattle
    tattletale
    tattoo
    taught
    taunt
    Taurus
    taut
    tautly
    tavern
    tawdry
    tawny
    tax
    taxable
    taxation
    tax-deductible
    tax-exempt
    taxi
    taxidermy
    taxing
    taxi stand
    taxpayer
    tax shelter
    TB
    tbsp.
    tea
    tea bag
    teach
    teacher
    teacher's pet
    teaching
    teaching assistant
    teacup
    teak
    teakettle
    team
    teammate
    team player
    teamster
    teamwork
    teapot
    tear
    teardrop
    tearful
    teargas
    tease
    teaspoon
    teaspoonful
    teat
    technical
    technicality
    technically
    technician
    technique
    technological
    technologist
    technology
    teddy bear
    tedious
    tedium
    tee
    teem
    teen
    teenage
    teenaged
    teenager
    teens
    teeny-weeny
    teeter
    teeter-totter
    teeth
    teethe
    teetotaler
    Teflon
    telecommunications
    telecommuter
    telecommuting
    telegram
    telegraph
    telepathy
    telephone
    telephoto lens
    telescope
    telescopic
    telethon
    televise
    television
    tell
    teller
    telling
    telltale
    temp
    temper
    temperament
    temperamental
    temperance
    temperate
    temperature
    tempest
    tempestuous
    template
    temple
    tempo
    temporarily
    temporary
    tempt
    temptation
    tempting
    ten
    tenacious
    tenacity
    tenancy
    tenant
    tend
    tendency
    tender
    tenderhearted
    tenderize
    tenderly
    tenderness
    tendon
    tendril
    tenement
    tenet
    tennis
    tennis shoe
    tenor
    tense
    tension
    tent
    tentacle
    tentative
    tentatively
    tenth
    tenuous
    tenure
    tepee
    tepid
    tequila
    term
    terminal
    terminally
    terminate
    termination

    terminology
    terminus
    termite
    term paper
    terms
    Terr.
    terrace
    terra cotta
    terrain
    terrestrial
    terrible
    terribly
    terrier
    terrific
    terrified
    terrify
    terrifying
    territorial
    territory
    terror
    terrorism
    terrorist
    terrorize
    terse
    tersely
    test
    testament
    test ban
    test case
    test drive
    test-drive
    testes
    testicle
    testify
    testimonial
    testimony
    test tube
    testy
    tetanus
    tether
    text
    textbook
    textile
    texture
    than
    thank
    thankful
    thankfully
    thankless
    thanks
    Thanksgiving
    thank-you
    that
    thatch
    that's
    thaw
    the
    theater
    theatrical
    theft
    their
    theirs
    them
    thematic
    theme
    theme park
    theme song
    themselves
    then
    theologian
    theological
    theology
    theoretical
    theoretically
    theoretician
    theorist
    theorize
    theory
    therapeutic
    therapist
    therapy
    there
    thereabout
    thereabouts
    thereafter
    thereby
    therefore
    therein
    thereof
    there's
    thereupon
    thermal
    thermometer
    thermonuclear
    Thermos
    thermostat
    thesauri
    thesaurus
    these
    theses
    thesis
    they
    they'd
    they'll
    they're
    they've
    thick
    thicken
    thicket
    thickly
    thickness
    thick-skinned
    thief
    thieves
    thigh
    thimble
    thin
    thing
    thingamajig
    things
    think
    thinker
    thinking
    think tank
    thinly
    third
    third degree
    third-degree burn
    third party
    third person
    third-rate
    Third World
    thirst
    thirstily
    thirsty
    thirteen
    thirteenth
    thirtieth
    thirty
    this
    thistle
    thong
    thorn
    thorny
    thorough
    thoroughbred
    thoroughfare
    thoroughly
    thoroughness
    those
    though
    thought
    thoughtful
    thoughtfully
    thoughtfulness
    thoughtless
    thoughtlessly
    thoughtlessness
    thousand
    thousandth
    thrash
    thrashing
    thread
    threadbare
    threat
    threaten
    threatening
    threateningly
    three
    three-dimensional
    thresh
    thresher
    threshold
    threw
    thrift
    thrifty
    thrill
    thrilled
    thriller
    thrilling
    thrive
    thriving
    throat
    throaty
    throb
    throne
    throng
    throttle
    through
    throughout
    throve
    throw
    throwaway
    throwback
    thrown
    thrust
    thud
    thug
    thumb
    thumbnail
    thumbtack
    thump
    thunder
    thunderbolt
    thunderous
    thunderstorm
    thunderstruck
    Thurs.
    Thursday
    thus
    thwart
    thyroid
    tiara
    tic
    tick
    ticket
    tickle
    ticklish
    tick-tack-toe
    tidal
    tidal wave
    tidbit
    tide
    tidy
    tie
    tiebreaker
    tier
    tiff
    tiger
    tight
    tighten
    tightfisted
    tightly
    tightness
    tightrope
    tights
    tightwad
    tile
    till
    tilt
    timber
    time
    time and a half
    time bomb
    time card
    time clock
    time-consuming
    time-honored
    timekeeper
    timeless
    time limit
    timely
    time-out
    timer
    times
    timetable
    time zone
    timid
    timidity
    timidly
    timing
    tin
    tinder
    tinderbox
    tinfoil
    tinge
    tinged
    tingle
    tingling
    tinker
    tinkle
    tinny
    tinsel
    tint

    tiny
    tip
    tip-off
    tipsy
    tiptoe
    tirade
    tire
    tired
    tiredness
    tireless
    tiresome
    tiring
    tissue
    tissue paper
    tit
    titillate
    title
    title role
    titter
    tizzy
    TLC
    TM
    TNT
    to
    toad
    toadstool
    to and fro
    to-and-fro
    toast
    toaster
    toasty
    tobacco
    tobacconist
    toboggan
    today
    toddle
    toddler
    to-do
    toe
    TOEFL
    toehold
    toenail
    toffee
    tofu
    toga
    together
    togetherness
    toggle
    togs
    toil
    toilet
    toilet paper
    toiletries
    token
    tokenism
    told
    tolerable
    tolerance
    tolerant
    tolerate
    toll
    tollbooth
    toll-free
    tollgate
    tomahawk
    tomato
    tomb
    tomboy
    tombstone
    tomcat
    tome
    tomfoolery
    tomorrow
    ton
    tone
    tone-deaf
    tongs
    tongue
    tongue-in-cheek
    tongue-tied
    tongue twister
    tonic
    tonic water
    tonight
    tonnage
    tons
    tonsil
    tonsillitis
    too
    took
    tool
    toolbar
    toot
    tooth
    toothache
    toothbrush
    toothpaste
    toothpick
    top
    top hat
    top-heavy
    topic
    topical
    topic sentence
    topless
    top-notch
    topographer
    topography
    topping
    topple
    top-secret
    topsy-turvy
    torch
    tore
    torment
    tormentor
    torn
    tornado
    torpedo
    torrent
    torrential
    torrid
    torso
    tort
    tortilla
    tortoise
    tortuous
    torture
    torturer
    toss
    toss-up
    tot
    total
    totalitarian
    totalitarianism
    totality
    totally
    tote
    totem pole
    totter
    toucan
    touch
    touch-and-go
    touchdown
    touched
    touching
    touchstone
    touchy
    tough
    toughen
    toughness
    toupee
    tour
    tourism
    tourist
    tournament
    tourniquet
    tousle
    tout
    tow
    toward
    towards
    towel
    tower
    towering
    town
    town hall
    townhouse
    township
    tow truck
    toxic
    toxicity
    toxicology
    toxin
    toy
    trace
    tracer
    track
    track and field
    track meet
    track record
    tract
    traction
    tractor
    tractor-trailer
    trade
    trade-in
    trademark
    trade-off
    trader
    trade school
    trade secret
    tradition
    traditional
    traditionalist
    traditionally
    traffic
    traffic jam
    traffic light
    tragedy
    tragic
    tragically
    trail
    trailblazer
    trailer
    trailer park
    train
    trained
    trainee
    trainer
    training
    trait
    traitor
    trajectory
    tramp
    trample
    trampoline
    trance
    tranquil
    tranquility
    tranquilize
    tranquilizer
    transact
    transaction
    transatlantic
    transcend
    transcendence
    transcendental
    transcontinental
    transcribe
    transcript
    transcription
    transfer
    transferable
    transform
    transformation
    transformer
    transfusion
    transgress
    transgression
    transient
    transistor
    transit
    transition
    transitional
    transitive
    transitory
    translate
    translation
    translator
    translucence
    translucent
    transmission
    transmit
    transmitter
    transparency
    transparent
    transparently
    transpire
    transplant
    transport
    transportation
    transpose
    transsexual
    transvestite
    trap
    trap door
    trapeze
    trapper
    trappings
    trash
    trash can
    trashy
    trauma

    traumatic
    traumatize
    travel
    travel agency
    travel agent
    traveler
    traveler's check
    travels
    traverse
    travesty
    trawl
    trawler
    tray
    treacherous
    treachery
    tread
    treadmill
    treason
    treasure
    treasurer
    treasury
    treat
    treatable
    treatise
    treatment
    treaty
    treble
    tree
    treetop
    trek
    trellis
    tremble
    tremendous
    tremendously
    tremor
    trench
    trenchant
    trench coat
    trend
    trendy
    trepidation
    trespass
    trespasser
    trestle
    trial
    trial run
    trials
    triangle
    triangular
    tribal
    tribe
    tribulation
    tribunal
    tributary
    tribute
    triceps
    trick
    trickery
    trickle
    trick or treat
    trickster
    tricky
    tricycle
    trident
    trifle
    trifling
    trigger
    trigger-happy
    trigonometry
    trike
    trill
    trillion
    trilogy
    trim
    trimester
    trimmings
    Trinity
    trinket
    trio
    trip
    tripe
    triple
    triplet
    triplicate
    tripod
    trite
    triumph
    triumphant
    triumphantly
    trivia
    trivial
    trivialize
    trod
    trodden
    troll
    trolley
    trombone
    tromp
    troop
    trooper
    troops
    trophy
    tropic
    tropical
    tropics
    trot
    troubadour
    trouble
    troubled
    troublemaker
    troubleshooter
    troubleshooting
    troublesome
    trough
    trounce
    troupe
    trousers
    trout
    truancy
    truant
    truce
    truck
    trucker
    trucking
    truckload
    truck stop
    truculent
    trudge
    true
    truffle
    truism
    truly
    trump
    trumped-up
    trumpet
    trumpeter
    truncated
    trundle
    trunk
    trunks
    trust
    trustee
    trustful
    trusting
    trustworthy
    truth
    truthful
    truthfully
    try
    trying
    tryout
    T-shirt
    tsp.
    tub
    tuba
    tubby
    tube
    tuberculosis
    tubing
    tubular
    tuck
    Tues.
    Tuesday
    tuft
    tufted
    tug
    tugboat
    tug of war
    tuition
    tulip
    tumble
    tumbler
    tummy
    tumor
    tumult
    tumultuous
    tuna
    tundra
    tune
    tuner
    tune-up
    tunic
    tunnel
    turban
    turbine
    turbulence
    turbulent
    turd
    tureen
    turf
    turgid
    turkey
    turmoil
    turn
    turnaround
    turncoat
    turning point
    turnip
    turn-off
    turnout
    turnover
    turnpike
    turn signal
    turnstile
    turntable
    turpentine
    turquoise
    turret
    turtle
    turtleneck
    tush
    tusk
    tussle
    tutor
    tutorial
    tutoring
    tux
    tuxedo
    TV
    TV dinner
    twang
    tweak
    tweed
    tweet
    tweezers
    twelfth
    twelve
    twentieth
    twenty
    twenty-one
    twerp
    twice
    twiddle
    twig
    twilight
    twin
    twin bed
    twine
    twinge
    twinkle
    twin-size
    twirl
    twist
    twisted
    twister
    twit
    twitch
    twitter
    two
    two-bit
    two-dimensional
    two-faced
    two-piece
    two-tone
    tycoon
    tyke
    Tylenol
    type
    typecast
    typeface
    typewriter
    typewritten
    typhoid
    typhoon
    typical
    typically
    typify
    typing
    typist
    typo
    tyrannical
    tyrannize
    tyranny
    tyrant
  ManyThings.org

    Reading
    Sentences
    More

English Vocabulary Word Lists with Games, Puzzles and Quizzes

English Vocabulary Word List
Alan Beale's Core Vocabulary - U (489 Words)

    ubiquitous
    ubiquity
    udder
    UFO
    ugh
    ugliness
    ugly
    uh
    uh-huh
    uh-oh
    uh-uh
    U.K.
    ulcer
    ulterior
    ultimate
    ultimately
    ultimatum
    ultrasonic
    ultrasound
    ultraviolet
    um
    umbilical cord
    umbrella
    umpire
    umpteen
    umpteenth
    UN
    unabashed
    unabated
    unable
    unabridged
    unacceptable
    unacceptably
    unaccompanied
    unaccountable
    unaccountably
    unadulterated
    unaffected
    unaided
    un-American
    unanimity
    unanimous
    unanimously
    unarmed
    unassuming
    unattached
    unattended
    unattractive
    unauthorized
    unavailable
    unavoidable
    unavoidably
    unaware
    unawares
    unbalanced
    unbearable
    unbearably
    unbeatable
    unbeaten
    unbelievable
    unbelievably
    unborn
    unbounded
    unbridled
    unbroken
    unbutton
    uncalled-for
    uncannily
    uncanny
    uncertain
    uncertainly
    uncertainty
    unchanged
    uncharacteristic
    uncharacteristically
    uncharted
    unchecked
    uncle
    unclean
    unclear
    Uncle Sam
    uncomfortable
    uncomfortably
    uncommon
    uncommonly
    uncompromising
    unconcerned
    unconditional
    unconditionally
    unconfirmed
    unconscionable
    unconscious
    unconsciously
    unconsciousness
    unconstitutional
    uncontrollable
    uncontrollably
    uncontrolled
    unconventional
    uncouth
    uncover
    uncut
    undaunted
    undecided
    undeniable
    undeniably
    under
    underage
    underclass
    underclassman
    undercover
    undercurrent
    undercut
    underdog
    underestimate
    undergo
    undergrad
    undergraduate
    underground
    undergrowth
    underhanded
    underline

    underlying
    undermine
    underneath
    undernourished
    underpaid
    underpants
    underpass
    underprivileged
    underrate
    underrated
    underscore
    undershirt
    underside
    understaffed
    understand
    understandable
    understandably
    understanding
    understate
    understated
    understatement
    understood
    understudy
    undertake
    undertaken
    undertaker
    undertaking
    undertone
    undertook
    undertow
    underwater
    underwear
    underweight
    underwent
    underworld
    underwrite
    underwritten
    underwrote
    undesirable
    undetermined
    undeveloped
    undid
    undisclosed
    undisturbed
    undo
    undoing
    undone
    undoubtedly
    undress
    undressed
    undue
    unduly
    undying
    unearth
    unearthly
    unease
    uneasily
    uneasiness
    uneasy
    uneducated
    unemployed
    unemployment
    unemployment compensation
    unending
    unequal
    unequally
    unequivocal
    unerring
    uneven
    unevenly
    unexpected
    unexpectedly
    unfailing
    unfair
    unfairly
    unfairness
    unfaithful
    unfamiliar
    unfashionable
    unfasten
    unfavorable
    unfeeling
    unfit
    unfold
    unforeseen
    unforgettable
    unfortunate
    unfortunately
    unfounded
    unfriendly
    unfurl
    ungainly
    ungrateful
    ungratefully
    unhappily
    unhappiness
    unhappy
    unhealthy
    unheard-of
    unholy
    unhook
    unicorn
    unidentified
    unification
    uniform
    uniformed
    uniformity
    uniformly
    unify
    unilateral
    unimportant
    uninhabitable
    uninhibited
    uninsured
    unintelligible
    uninterested
    union
    unionize
    unique
    uniquely
    unisex
    unison

    unit
    unite
    united
    United Kingdom
    United Nations
    United States
    unity
    universal
    universally
    universe
    university
    unjust
    unjustified
    unkempt
    unkind
    unkindly
    unkindness
    unknowingly
    unknown
    unlawful
    unleaded
    unleash
    unless
    unlike
    unlikely
    unlimited
    unlisted
    unload
    unlock
    unlucky
    unmarked
    unmarried
    unmask
    unmistakable
    unmistakably
    unmitigated
    unmoved
    unnatural
    unnaturally
    unnecessarily
    unnecessary
    unnerve
    unnerving
    unnoticed
    unobtrusive
    unoccupied
    unofficial
    unofficially
    unorthodox
    unpack
    unpaid
    unparalleled
    unpleasant
    unplug
    unplugged
    unpopular
    unpopularity
    unprecedented
    unpredictable
    unprepared
    unprincipled
    unprintable
    unproductive
    unprofessional
    unprofitable
    unprotected
    unprovoked
    unqualified
    unquestionable
    unquestionably
    unquestioned
    unravel
    unreal
    unrealistic
    unreasonable
    unreasonably
    unrelenting
    unreliable
    unreserved
    unresponsive
    unrest
    unrestrained
    unrivaled
    unroll
    unruliness
    unruly
    unsafe
    unsanitary
    unsatisfactory
    unsavory
    unscathed
    unscrew
    unscrupulous
    unseasonable
    unseat
    unseemly
    unseen
    unsettled
    unsightly
    unskilled
    unsolicited
    unsophisticated
    unsound
    unspeakable
    unspecified
    unspoken
    unsportsmanlike
    unstable
    unsteady
    unstoppable
    unsuccessful
    unsuccessfully
    unsuitable
    unsung
    unsure
    unsuspecting
    untangle
    untenable
    unthinkable
    unthinking
    unthinkingly
    untie

    until
    untimely
    untiring
    untold
    untouchable
    untoward
    untried
    untrue
    untruthful
    unused
    unusual
    unusually
    unveil
    unwanted
    unwarranted
    unwelcome
    unwieldy
    unwilling
    unwind
    unwise
    unwitting
    unwittingly
    unwound
    unwritten
    unyielding
    unzip
    up
    up-and-coming
    upbeat
    upbringing
    upchuck
    upcoming
    update
    upend
    upfront
    upgrade
    upheaval
    upheld
    uphill
    uphold
    upholster
    upholstered
    upholstery
    upkeep
    uplifting
    upon
    upper
    uppercase
    upper class
    upperclassman
    uppermost
    uppity
    upright
    uprising
    uproar
    uproot
    upscale
    upset
    upshot
    upside down
    upside-down
    upstage
    upstairs
    upstart
    upstate
    upstream
    upsurge
    upswing
    uptake
    uptight
    up-to-date
    up-to-the-minute
    uptown
    upturn
    upward
    upwards
    uranium
    Uranus
    urban
    urbane
    urban renewal
    urban sprawl
    urchin
    urge
    urgency
    urgent
    urgently
    urinate
    urine
    urn
    US
    us
    USA
    usage
    use
    used
    used to
    useful
    usefully
    usefulness
    useless
    uselessly
    uselessness
    user
    user-friendly
    usher
    usual
    usually
    usurp
    utensil
    uteri
    uterus
    utility
    utility room
    utilization
    utilize
    utmost
    utopia
    utopian
    utter
    utterance
    utterly
    U-turn
 ManyThings.org

    Reading
    Sentences
    More

English Vocabulary Word Lists with Games, Puzzles and Quizzes

English Vocabulary Word List
Alan Beale's Core Vocabulary - V (310 Words)

    vacancy
    vacant
    vacantly
    vacate
    vacation
    vacationer
    vaccinate
    vaccination
    vaccine
    vacillate
    vacuum
    vacuum cleaner
    vacuum-packed
    vagina
    vaginal
    vagrant
    vague
    vaguely
    vagueness
    vain
    vainly
    valedictorian
    valentine
    Valentine's Day
    valet
    valiant
    valiantly
    valid
    validate
    validity
    valley
    valor
    valuable
    valuables
    value
    values
    valve
    vampire
    van
    vandal
    vandalism
    vandalize
    vanguard
    vanilla
    vanish
    vanishing
    vanity
    vanity plate
    vanquish
    vapor
    vaporize
    variability
    variable
    variance
    variant
    variation
    varied
    variety
    various
    variously
    varnish
    varsity
    vary
    vase
    vasectomy
    vast
    vastly
    vat
    vault
    VCR
    VD
    veal
    veer
    vegan
    vegetable
    vegetarian
    vegetation
    veggie

    veggies
    vehement
    vehemently
    vehicle
    vehicular
    veil
    veiled
    vein
    Velcro
    velocity
    velour
    velvet
    velvety
    vendetta
    vending machine
    vendor
    veneer
    venerable
    venerate
    venereal disease
    venetian blind
    vengeance
    vengeful
    venison
    venom
    venomous
    vent
    ventilate
    ventilation
    ventilator
    ventriloquism
    ventriloquist
    venture
    venue
    Venus
    veranda
    verb
    verbal
    verbally
    verbatim
    verbose
    verdict
    verge
    verification
    verify
    veritable
    vermin
    vernacular
    versatile
    versatility
    verse
    version
    versus
    vertebra
    vertebrae
    vertical
    vertically
    vertigo
    verve
    very
    vessel
    vest
    vestibule
    vestige
    vet
    veteran
    veterinarian
    veterinary
    veto
    vex
    via
    viability
    viable
    viaduct
    vial
    vibes
    vibrant
    vibrate

    vibration
    vicarious
    vice
    vice president
    vice versa
    vicinity
    vicious
    vicious circle
    viciously
    victim
    victimization
    victimize
    victor
    victorious
    victory
    video
    videocassette
    video game
    videotape
    vie
    view
    viewer
    viewing
    viewpoint
    vigil
    vigilance
    vigilant
    vigilante
    vigor
    vigorous
    vigorously
    vile
    vilify
    villa
    village
    villager
    villain
    villainy
    vindicate
    vindication
    vindictive
    vine
    vinegar
    vineyard
    vintage
    vinyl
    viola
    violate
    violation
    violence
    violent
    violently
    violet
    violin
    violinist
    VIP
    viper
    viral
    virgin
    virginity
    Virgo
    virile
    virility
    virtual
    virtually
    virtual reality
    virtue
    virtuoso
    virtuous
    virulent
    virus
    visa
    visage
    vis-a-vis
    viscosity
    viscous
    vise
    visibility

    visible
    visibly
    vision
    visionary
    visit
    visitation
    visitor
    visor
    vista
    visual
    visual aid
    visualize
    visually
    vital
    vitality
    vitally
    vital statistics
    vitamin
    vivacious
    vivaciously
    vivacity
    vivid
    vividly
    vivisection
    V-neck
    vocabulary
    vocal
    vocalist
    vocation
    vocational
    vociferous
    vociferously
    vodka
    vogue
    voice
    voice mail
    void
    vol.
    volatile
    volatility
    volcanic
    volcano
    volition
    volley
    volleyball
    volt
    voltage
    volume
    voluminous
    voluntarily
    voluntary
    volunteer
    voluptuous
    vomit
    voodoo
    voracious
    voracity
    vortex
    vortices
    vote
    voter
    voting booth
    vouch
    voucher
    vow
    vowel
    voyage
    voyager
    voyeur
    voyeurism
    vs.
    vulgar
    vulgarity
    vulnerability
    vulnerable
    vulture
  ManyThings.org

    Reading
    Sentences
    More

English Vocabulary Word Lists with Games, Puzzles and Quizzes

English Vocabulary Word List
Alan Beale's Core Vocabulary - W (638 Words)

    wacky
    wad
    waddle
    wade
    wafer
    waffle
    waft
    wag
    wage
    wager
    wages
    wagon
    wagon train
    waif
    wail
    waist
    waistband
    waistline
    wait
    waiter
    waiting list
    waiting room
    waitress
    waive
    waiver
    wake
    waken
    walk
    walker
    walkie-talkie
    walk-in
    walking stick
    Walkman
    walkout
    walk-up
    wall
    wallet
    wallop
    wallow
    wallpaper
    Wall Street
    wall-to-wall
    walnut
    walrus
    waltz
    wan
    wand
    wander
    wanderer
    wane
    wanna
    wannabe
    want
    want ad
    wanted
    wanting
    wanton
    war
    warble
    war crime
    war criminal
    ward
    warden
    wardrobe
    ware
    warehouse
    wares
    warfare
    war game
    warhead
    warily
    warlike
    warlock
    warlord
    warm
    warm-blooded
    warmed-over
    warm-hearted
    warmly
    warmonger
    warmongering
    warmth
    warm-up
    warn
    warning
    warp
    warpath
    warped
    warrant
    warranty
    warren
    warring
    warrior
    warship
    wart
    wartime
    wary
    was
    wash
    washable
    washbasin
    washcloth
    washed-out
    washed-up
    washer
    washing
    washing machine
    washout
    washroom
    wasn't
    WASP
    wasp
    waste
    wastebasket
    wasted
    wasteful
    wasteland
    watch
    watchdog
    watchful
    watchmaker
    watchman
    watchword
    water
    waterbed
    watercolor
    watercolors
    waterfall
    water fountain
    waterfront
    water hole
    watering hole
    waterlogged
    watermark
    watermelon
    water polo
    waterproof
    water-resistant
    waters
    watershed
    water-ski
    water-skier
    water-skiing
    water skis
    watertight
    water tower
    waterway
    waterworks
    watery
    watt
    wave
    wavelength
    waver
    wavy
    wax
    waxiness
    wax paper
    waxy
    way
    waylay

    way-out
    ways
    wayside
    wayward
    we
    weak
    weaken
    weakling
    weakly
    weakness
    wealth
    wealthy
    wean
    weapon
    weaponry
    wear
    wearily
    weariness
    wearisome
    weary
    weasel
    weather
    weather forecast
    weather forecaster
    weather vane
    weave
    web
    web-footed
    website
    wed
    we'd
    Wed.
    wedding
    wedding ring
    wedge
    wedlock
    Wednesday
    wee
    weed
    week
    weekday
    weekend
    weekly
    weeknight
    weep
    weigh
    weight
    weightless
    weightlessness
    weightlifter
    weightlifting
    weighty
    weird
    weirdo
    welcome
    weld
    welder
    welfare
    well
    we'll
    well-advised
    well-behaved
    well-being
    well-bred
    well-defined
    well-done
    well-dressed
    well-groomed
    well-heeled
    well-informed
    well-intentioned
    well-known
    well-meaning
    well-off
    well-read
    well-rounded
    well-spoken
    well-thought-of
    well-to-do
    well-wisher
    Welsh
    welsh
    welt
    welter
    went
    wept
    were
    we're
    weren't
    werewolf
    werewolves
    west
    westbound
    westerly
    Western
    western
    Westerner
    westerner
    westernize
    westward
    westwards
    wet
    wetback
    wet suit
    we've
    whack
    whale
    whaler
    whaling
    wham
    wharf
    wharves
    what
    whatchamacallit
    whatever
    what's
    whatsoever
    wheat
    wheel
    wheelbarrow
    wheelchair
    wheeler-dealer
    wheels
    wheeze
    when
    whenever
    where
    whereabouts
    whereas
    whereby
    wherein
    whereupon
    wherever
    wherewithal
    whet
    whether
    whew
    which
    whichever
    whiff
    while
    whim
    whimper
    whimsical
    whine
    whiner
    whinny
    whip
    whiplash
    whipping
    whir
    whirl
    whirlpool
    whirlwind
    whisk
    whisker
    whiskers
    whiskey
    whisper
    whistle

    White
    white
    white-collar
    White House
    white lie
    whiten
    white trash
    whitewash
    white water
    white wine
    whittle
    whiz
    who
    whoa
    who'd
    whodunit
    whoever
    whole
    wholehearted
    wholeheartedly
    wholesale
    wholesome
    whole-wheat
    who'll
    wholly
    whom
    whoop
    whooping cough
    whoops
    whoosh
    whopper
    whore
    who're
    who's
    whose
    who've
    why
    wick
    wicked
    wickedly
    wickedness
    wicker
    wicket
    wide
    wide-eyed
    widely
    widen
    wide-ranging
    widespread
    widow
    widowed
    widower
    width
    wield
    wiener
    wife
    wig
    wiggle
    wigwam
    wild
    wilderness
    wild goose chase
    wildlife
    wildly
    wiles
    will
    willful
    willfully
    willing
    willingly
    willingness
    willow
    willowy
    willpower
    wilt
    wily
    wimp
    wimpy
    win
    wince
    winch
    wind
    windbreaker
    windchill factor
    winded
    windfall
    winding
    wind instrument
    windmill
    window
    window dressing
    windowpane
    window shopping
    windowsill
    windpipe
    windshield
    windshield wiper
    windsurf
    windsurfing
    windswept
    windy
    wine
    wineglass
    wing
    winged
    wings
    wingspan
    wingtip
    wink
    winner
    winning
    winnings
    wino
    winsome
    winter
    wintertime
    wintry
    wipe
    wiper
    wire
    wired
    wiretap
    wiring
    wiry
    wisdom
    wisdom tooth
    wise
    wisecrack
    wise guy
    wisely
    wish
    wishbone
    wishes
    wishful thinking
    wishy-washy
    wisp
    wispy
    wistful
    wistfully
    wit
    witch
    witchcraft
    witch doctor
    witch hunt
    with
    withdraw
    withdrawal
    withdrawn
    withdrew
    wither
    withheld
    withhold
    withholding
    within
    without
    withstand
    withstood
    witness
    witness stand
    wits

    witticism
    witty
    wives
    wizard
    wizened
    wk.
    wobble
    wobbly
    woe
    woebegone
    woes
    wok
    woke
    woken
    wolf
    wolves
    woman
    womanhood
    womankind
    womb
    women
    women's room
    won
    wonder
    wonderful
    wonderfully
    wont
    won't
    woo
    wood
    woodchuck
    wooded
    wooden
    woodland
    woodpecker
    woods
    woodwind
    woodwork
    woody
    woof
    wool
    woolen
    woolens
    wooly
    woozy
    word
    wording
    word processing
    word processor
    wordy
    wore
    work
    workable
    workaholic
    workbench
    workbook
    worked up
    worker
    workers' compensation
    workfare
    workforce
    working
    working class
    workings
    workload
    workman
    workmanlike
    workmanship
    workout
    works
    worksheet
    workshop
    workstation
    work-study
    world
    world-class
    world-famous
    worldly
    world power
    World Series
    world war
    worldwide
    World Wide Web
    worm
    worms
    worn
    worn-out
    worried
    worry
    worrying
    worse
    worsen
    worship
    worshiper
    worst
    worth
    worthless
    worthwhile
    worthy
    would
    would-be
    wouldn't
    would've
    wound
    wounded
    wound up
    wove
    woven
    wow
    wrangle
    wrangler
    wrap
    wrapper
    wrapping
    wrapping paper
    wrath
    wreak
    wreath
    wreck
    wreckage
    wren
    wrench
    wrest
    wrestle
    wrestler
    wrestling
    wretch
    wretched
    wriggle
    wring
    wringer
    wrinkle
    wrinkled
    wrist
    wristwatch
    writ
    write
    write-in
    write-off
    writer
    write-up
    writhe
    writing
    written
    wrong
    wrongdoer
    wrongdoing
    wrongful
    wrongfully
    wrongly
    wrote
    wrought
    wrought iron
    wrung
    wry
    wryly
    wt.
    WWW
ManyThings.org

    Reading
    Sentences
    More

English Vocabulary Word Lists with Games, Puzzles and Quizzes

English Vocabulary Word List
Alan Beale's Core Vocabulary - XYZ (104 Words)

    xenophobia
    xenophobic
    Xerox
    XL
    Xmas
    X-rated
    x-ray
    xylophone
    yacht
    yak
    y'all
    yam
    Yank
    yank
    Yankee
    yap
    yard
    yard sale
    yardstick
    yarmulke
    yarn
    yawn
    yd.
    yeah
    year
    yearbook

    yearling
    yearly
    yearn
    yearning
    years
    yeast
    yell
    yellow
    yellowish
    Yellow Pages
    yelp
    yen
    yep
    yes
    yesterday
    yet
    Yiddish
    yield
    yippee
    YMCA
    yo
    yodel
    yoga
    yogurt
    yoke
    yokel

    yolk
    Yom Kippur
    yonder
    you
    you'd
    you'll
    young
    youngster
    your
    you're
    yours
    yourself
    yourselves
    youth
    youthful
    youth hostel
    you've
    yo-yo
    yr.
    yrs.
    yuck
    yucky
    Yuletide
    yum
    yummy
    yuppie

    YWCA
    zany
    zap
    zeal
    zealous
    zealously
    zebra
    zero
    zest
    zigzag
    zillion
    zinc
    zip
    ZIP code
    zipper
    zit
    zodiac
    zombie
    zone
    zoo
    zoological
    zoologist
    zoology
    zoom
    zoom lens
    zucchini

END
